
// POV-Ray Object File - A catamaran
// created 25-Sep-02
// last update 29-Sep-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Catamaran.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// CatamaranS // simple version
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Boat origin is along the waterline, at the base of the mast
// Mast extends into +Z

#ifndef (ThisIsMaster) // now we know this include file was not called by another
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc" // uncomment for testing only
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

#include "CatHull.inc"


//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare WhiteFiberglas =
	texture {
		pigment { color rgb<.99,.99,.99>*1.00 }
		finish { specular 0.93 roughness 0.04 }
	}


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare CatamaranS = // simple version
	union {
		object { CatHull translate <0,-4*Feet,0> }
		object { CatHull translate <0, 4*Feet,0> }
		cylinder { // mast support
			<0,-4*Feet,0>,<0,4*Feet,0>,6
			scale <1,1,.3>
		}
		cylinder { // rear support
			<0,-4*Feet,0>,<0,4*Feet,0>,6
			scale <1,1,.3>
			translate <-6*Feet,0,0>
		}
		box { // web
			<0,-3.3*Feet,-1>,<4.3*Feet,3.3*Feet,0>
			translate <-5*Feet,0,10>
		}
		cylinder { // mast
			<0,0,0>,<0,0,26*Feet>,2.3
			scale <1,0.6,1>
		}
		sphere { // mast top
			<0,0,0>,2.3
			scale <1,0.6,1>
			translate <0,0,26*Feet>
		}
		cylinder { // boom
			<-7*Feet,0,0>,<-4,0,0>,2.2
			translate <0,0,28>
		}
		texture { WhiteFiberglas }
	} // end union


//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
		location  <1, -40*Feet, 12*Feet> // overall
		look_at <0*Feet,0,8*Feet>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 1 }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }


object { CatamaranS scale 1 rotate x*0 translate <0,0,1> }


#end
