
// Glenn's POV-Ray Scene File - Vuaqava Island Resort
// created for the Sep/Oct 2002 Internet Ray Tracing Competition
// at http://www.irtc.org
// created 14-Sep-02
// last update 28-Oct-02
// copyright 2002 Glenn McCarter (glenn@mccarters.net)
//
// This scene uses RH coordinate system, Z = up.



//===============================================
//             Scene Switches
//===============================================

#declare RCam = 1; // Render Camera
#declare MCam = 0; // Map Camera
#declare SCam = 0; // Special Camera
#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare Radiosty = 1; // 0=off, 1=quick, 2=best radiosity
#declare DoFog = 1; // 0=no fog, 1=fog
#declare AreaSun = 1; // 0=normal light, 1=area light for the sun
#declare GoodGolfers = 1; // 0= simple stand-ins, 1=detailed Poser figures
#declare Vegetation = 1; // 0=no plants, 1=full plants
#declare VegQual = 1; // 0=plain spheres, 1=detailed trees
#declare Foreground = 1;
#declare Background = 1;
#declare Resort = 1;
                  
#version 3.5;
global_settings {
	adc_bailout 1/255 // default 1/255
	ambient_light <1.0,1.0,1.0> // default <1,1,1>, use 0 for radiosity
//	ambient_light <0.1,0.1,0.1>
//	ambient_light <0.05,0.05,0.05>
//	ambient_light <0.01,0.01,0.01>
//	ambient_light <0.003,0.003,0.003> // test
//	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
//	ambient_light <-0.1,-0.1,-0.1> // not bad
//	ambient_light <-2,-2,-2> // spoiled orange
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 100
	number_of_waves 10
	noise_generator 2

#switch (Radiosty)
#case (1)
	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
// QUICK TEST
  radiosity{
    adc_bailout 0.01/0.02// CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
		always_sample on     // CHANGE - default on, use off to reduce blotchiness
		brightness 0.5       // CHANGE - default 1.0 for full effect, 0.0 = no radiosity
    count 20             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out
    error_bound 1.0      // CHANGE - default 1.8, typ 1 to 3, hi = flat shadows, low = deep shadows
    gray_threshold 0.2   // CHANGE - 0.0 = unrealistically full color bleed, 1.0 = no color bleed
    low_error_factor .6  // leave this, default 0.5
		max_sample -1        // leave this negative unless you have a very bright object causing splotchiness
		media off            // default off, turn on if using media in scene
    minimum_reuse 0.015  // leave this, default 0.015
    nearest_count 5      // CHANGE - default 5, below 4 gets patchy, typ 3 to 10, max 20
		normal off           // default off, turn on for shadow areas to show bumps
    pretrace_start 0.08  // CHANGE - default 0.08, percent of final image size in first mosaic
    pretrace_end   0.04  // CHANGE - default 0.04, percent of final image size in last mosaic
    recursion_limit 3    // CHANGE - default 3, 1 or 2 is often sufficient
  }
#break
#case (2)
// FINAL RENDER
	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
  radiosity{
    adc_bailout 0.01/0.02// CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
		always_sample on     // CHANGE - default on, use off to reduce blotchiness
		brightness 1.0       // CHANGE - default 1.0 for full effect, 0.0 = no radiosity
    count 30             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out
    error_bound 1.0      // CHANGE - default 1.8, typ 1 to 3, hi = flat shadows, low = deep shadows
    gray_threshold 0.2   // CHANGE - 0.0 = unrealistically full color bleed, 1.0 = no color bleed
    low_error_factor .5  // leave this, default 0.5
		max_sample -1        // leave this negative unless you have a very bright object causing splotchiness
		media off            // default off, turn on if using media in scene
    minimum_reuse 0.015  // leave this, default 0.015
    nearest_count 8      // CHANGE - default 5, below 4 gets patchy, typ 3 to 10, max 20
		normal off           // default off, turn on for shadow areas to show bumps
    pretrace_start 0.02  // CHANGE - default 0.08, percent of final image size in first mosaic
    pretrace_end   0.004  // CHANGE - default 0.04, percent of final image size in last mosaic
    recursion_limit 7    // CHANGE - default 3, 1 or 2 is often sufficient
  }
   // end radiosity section
#break
#else
#end
}


//===============================================
//             Includes
//===============================================

#include "GIncludeRH.inc" // Glenn's standard includes
#include "Weeds.inc"
#include "Vegetation.inc"
#include "MiscObjects.inc"
#include "Bridges.inc"
#if (Foreground = 1)
	#include "Foreground.inc"
#end
#if (Background = 1)
	#include "Terrain.inc"
		#include "Boats.inc"
	#if (Resort = 1)
		#include "Marina.inc"
		#include "Resort.inc"
	#end
#end
//#include "GRuler.inc" // for testing only


//===============================================
//             Variables
//===============================================

//#declare CamPos = <70*Feet,-20*Feet,178*Feet>; // Camera Position, shows first tee
//#declare CamPos = <70*Feet,-20*Feet,172*Feet>; // Camera Position, slightly lower
#declare CamPos = <70*Feet,-12*Feet,172*Feet>; // Camera Position, for wide angle
#declare Seabed = -6*Feet; // height of base of all heightfields

//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
//		right     <4/3, 0.0,  0.0>  // aspect ratio
		right     <16/9, 0.0,  0.0>  // aspect ratio
		angle 80
	location CamPos // render
	look_at CamPos+<0*Feet,100*Feet,-34*Feet> // render
//	look_at CamPos+<0*Feet,100*Feet,134*Feet> // sky color test
}

#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
//		right     <16/9,     0.0,  0.0>
		right     <4/3,     0.0,  0.0>
		angle 50
//	location CamPos+<8*Feet,-26*Feet,12*Feet> // looking at tee box
//	look_at CamPos+<1*Feet,6*Feet,-1*Feet>
//	location <100*Yards,80*Feet,32*Feet> // beach area, catamaran
//	look_at <100*Yards,200*Feet,3*Feet>
//	location <80*Yards,320*Feet,45*Feet> // beach area, hole 2
//	look_at <120*Yards,440*Feet,3*Feet>
//	location CamPos+<-30*Feet,20*Feet,-14*Feet> // weed area low
//	look_at CamPos+<-30*Feet,30*Feet,-15*Feet>
//	location CamPos+<-30*Feet,20*Feet,-4*Feet> // weed area high
//	look_at CamPos+<-30*Feet,30*Feet,-15*Feet>
//	location <3*Yards,20*Yards,65*Feet> // hole 1-2 bridges
//	look_at <30*Yards,90*Yards,45*Feet>
//	location <30*Yards,50*Yards,125*Feet> // elevator
//	look_at <50*Yards,70*Yards,80*Feet>
//	location <40*Yards,50*Yards,45*Feet> // elevator base
//	look_at <50*Yards,70*Yards,20*Feet>
	location <240*Yards,150*Yards,500*Feet> // waterfall
	look_at <340*Yards, 450*Yards, 210*Feet>
	}

#declare Map_Cam =
	camera {
		orthographic
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  -1.0>  // Where Z is up
//		right     <16/9,     0.0,  0.0>
		right     <-4/3,     0.0,  0.0>

//		angle 36
//	location <500*Yards,1500*Yards,36000*Feet> // satellite view
//	look_at <500*Yards,1500*Yards,0*Feet>
//		angle 36
//	location <50*Yards,160*Yards,3000*Feet> // overview
//	look_at <50*Yards,160*Yards,0*Feet>
		angle 36
	location <150*Yards,320*Yards,3000*Feet> // resort background
	look_at <150*Yards,320*Yards,0*Feet>
//		angle 30
//	location <40*Yards,60*Yards,1200*Feet> // Hole1
//	look_at <40*Yards,60*Yards,0*Feet>
//		angle 30
//	location <60*Yards,60*Yards,1200*Feet> // Beach view
//	look_at <60*Yards,60*Yards,0*Feet>
//		angle 30
//	location <40*Yards,90*Yards,1200*Feet> // Hole1&2
//	look_at <40*Yards,90*Yards,0*Feet>
//		angle 30
//	location <40*Yards,160*Yards,1200*Feet> // Hole2
//	look_at <40*Yards,160*Yards,0*Feet>
//		angle 30
//	location <-40*Yards,310*Yards,1200*Feet> // Hole3
//	look_at <-40*Yards,310*Yards,0*Feet>
//		angle 30
//	location <-40*Yards,60*Yards,1200*Feet> // Hole9
//	look_at <-40*Yards,60*Yards,0*Feet>
//		angle 25
//	location <12*Yards,5*Yards,250*Feet> // tee view overall
//	look_at <12*Yards,5*Yards,0*Feet>
//		angle 16
//	location <16*Yards,9*Yards,200*Feet> // tee closeup
//	look_at <16*Yards,9*Yards,0*Feet>
	}

#if (SCam = 1 ) camera { Special_Cam } #end
#if (MCam = 1 ) camera { Map_Cam } #end
#if (RCam = 1 ) camera { Render_Cam } #end


//===============================================
//             Textures
//===============================================


//===============================================
//             Lighting
//===============================================

#declare OverheadSpotLight =
	light_source { 
		<0*Feet,0*Feet,6.7*Feet> // test
		color rgb <0.820,0.863,0.761>*1.2
		fade_distance 6*Feet
		fade_power 1
		spotlight
		point_at <0,0,0>
		radius 15
		falloff 40
		tightness 1
		#if (AreaSun=1)
			area_light <0,0,0.5>,<0,0.5,0>,4,4 adaptive 1 jitter circular orient
		#end
//		looks_like { sphere { <0,0,0>,10 texture { pigment {rgb<1,1,.1> } finish {ambient 20} } } }
	}
//object { OverheadSpotLight translate <-1,9*Feet,0> } // render
//object { TestSphere scale 20 translate <-1, 5*Feet,TTH> }

//light_source{<-4*Feet,0*Feet,4.7*Feet> color rgb<1,1,1> } // for testing only

#declare Sun =
	light_source {
		<0,0,0>
		color rgb <0.680,0.663,0.581>*2.3
		#if (AreaSun=1)
//			area_light <0,0,0.5*Miles>,<0,0.5*Miles,0>,4,4 adaptive 1 jitter circular orient // too soft!
//			area_light <0,0,0.5*Miles>,<0,0.5*Miles,0>,2,2 jitter circular orient
		#end
	}

object { Sun
	translate <0,0,50*Miles> // noon at Equator: directly overhead
	rotate y*-35 // towards left
  rotate z*1 // behind camera
}


//===============================================
//             Environment
//===============================================

background { color rgb <0.046, 0.045, 0.053> } // deep blue grey

sky_sphere { // sunny day
	pigment {
		gradient z
		color_map { // horizon is at about .23, zenith at .75

			[ 0.000 color rgb <0.900,0.908,0.936>*.99 ] // below ground level
			[ 0.070 color rgb <0.970,0.967,0.954>*.92 ] // turbulent clouds
			[ 0.170 color rgb <0.290,0.518,0.749>*.99 ] // top cloud line
			[ 0.300 color rgb <0.106,0.278,0.722>*.80 ] // above image
			[ 0.55 color rgb <0.067,0.169,0.710>*.40 ] // stratosphere
			[ 0.75 color rgb <0.067,0.169,0.710>*.20 ] // to zenith
		}
		scale 2
		translate <0,0,-.5>
		turbulence 0.033
		omega 0.5		
		rotate y*-2
	}
}

#if ( DoFog )
/*
// This fog obscures the entire sky in water reflection!
fog {
	fog_type 1 // constant fog
//	distance 10000*Feet // deep mist, fairly foggy
	distance 22000*Feet // deep mist, fairly foggy
//	distance 50000*Feet // med mist, too thin
//	distance 100000*Feet // fine mist
//	distance 400000*Feet // very fine mist, almost unnoticeable
	color rgbt<.71,.77,1,0.5>
}
*/

fog {
	fog_type 2 // ground fog
//	fog_alt 8*Feet // test
//	fog_alt 12*Feet // keeps bottom 20 or 30 feet out of view
//	fog_alt 100*Feet // leaves top of left coastline untouched
//	fog_alt 140*Feet // test, still leaves mountaintop untouched
	fog_alt 180*Feet // test
	up <0,0,1>
	distance 24000*Feet // damn thin
//	distance 12000*Feet // very extremely thin
//	distance 4000*Feet // extremely thin
//	distance 1000*Feet // very thin
//	distance 100*Feet // thin
//	distance 33*Feet // medium
//	distance 19*Feet // thick
//	distance 6*Feet // very thick

//	color rgb<.67,.71,.64> // pale creamy white
//	color rgbt<.41,.47,.64,.5> // bluish white
//	color rgbt<.41,.47,.64,.75> // bluish white, thinner
//	color rgbt<.41,.47,.64,.55> // bluish white, thicker
	color rgbt<.41,.47,.64,.45> // bluish white, test thicker
//	rotate x*-0.8 // leaves distant background unfogged
	rotate x*0.8 // leaves distant background fogged to higher altitudes
}

#end

#declare GroundPlane =
	plane { z,-0.1 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
//object { GroundPlane }

#declare SeaWaterTex =
	texture {
//		pigment { color rgbt<0.227,0.416,0.451,0.64> } // too clear
//		pigment { color rgb<0.227,0.416,0.451> } // no trans, too opaque
//		pigment { color rgb<1,1,1> } // test white
//		pigment { color rgbf<0.227,0.416,0.282,0.47> } // brownish
//		pigment { color rgbf<0.167,0.316,0.582,0.87> } // much more blue and clear
//		pigment { color rgbt<0.044,0.084,0.190,0.97> } // blue, too slatelike
//		pigment { color rgbt<.004,0.24,0.490,0.75> } // too bland
//		pigment { color rgbt<.004,0.040,0.190,0.75> } // more cobalt
		pigment { color rgbt<.004,0.040,0.190,1.0> } // clear test
//		pigment { color rgbf<1,1,1,0.97> } // test white filtered
//		pigment { color rgbt<.01,.01,.01,0.97> } // test dark grey
		normal { bumps .25 scale <2.2*Feet,2.2*Feet,12> }
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { 0.04, 0.64 } conserve_energy}
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.04,0.14,0.04>, <0.99,0.99,0.99> } conserve_energy}
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.04,0.14,0.04>, <0.42,0.74,0.84> } conserve_energy}
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.00,0.0,0.00>, <0.42,0.74,0.84> } conserve_energy}
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.00,0.0,0.00>, <0.12,0.34,0.43> } conserve_energy}
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.00,0.0,0.00>, <0.22,0.44,0.67> } conserve_energy}
		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003 reflection { <0.00,0.0,0.00>, <0.72,0.74,0.83> } conserve_energy}
//		finish { ambient 0.001 diffuse 0.02 specular 1.21 roughness .003  conserve_energy} // no reflection test
	}
#declare SeaWaterInt =
//	interior { ior 1.33 caustics 10 fade_distance 12 fade_power 1.0 fade_color <0.03,0.25,0.60> }
//	interior { ior 1.33 caustics 10 fade_distance 12 fade_power 1.0 fade_color <0.03,0.55,0.36> }
//	interior { ior 1.33 caustics 10 fade_distance 24 fade_power 1.7 fade_color <0.03,0.55,0.36> } // greenish
//	interior { ior 1.33 caustics 10 fade_distance 24 fade_power 1.7 fade_color <1,1,1> } // clear test
//	interior { ior 1.33 caustics 10 fade_distance 5 fade_power 1.7 fade_color <0.03,0.26,0.55> } // test
//	interior { ior 1.33 caustics 10 fade_distance 10 fade_power 1.7 fade_color <0.03,0.43,0.25> } // test green, too much algea
//	interior { ior 1.33 caustics 10 fade_distance 10 fade_power 2.0 fade_color <0.23,0.43,0.35> } // test blue-green
	interior { ior 1.33 caustics 10 fade_distance 20 fade_power 2.0 fade_color <0.04,0.18,0.22> } // test depth
#declare SeaWaterMat = // material
	material {
		texture { SeaWaterTex }
		interior { SeaWaterInt }
	}

#declare CausticTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.44 rgbt <1,1,1,1> ]
				[ 0.50 rgbt <1,1,1,.8> ]
				[ 0.55rgbt <1,1,1,1> ]
			}
			scale 20
		}
		finish { ambient .1 }
	}

#declare SandyBottom =
	pigment {
		granite
		color_map {
			[ 0.00 rgb<0.957,0.906,0.851>*.8 ]
			[ 1.00 rgb<0.957,0.906,0.851>*.6 ]
		}
		scale 400*Feet
	}
#declare RockyBottom =
	pigment {
		bozo
		color_map {
			[ 0.25 color rgb <0.345,0.392,0.333>*.1 ]
			[ 0.50 color rgb <0.184,0.292,0.114>*1 ]
			[ 0.60 color rgb <0.086,0.282,0.302>*1 ]
			[ 0.80 color rgb <0.086,0.282,0.302>*.03 ]
		}
		scale 2*Feet
	}
#declare RockySand =
	pigment {
		granite
		pigment_map {
//			[ 0.40 SandyBottom scale 1/(200*Feet) ]
			[ 0.20 SandyBottom scale 1/(200*Feet) ]
			[ 0.48 RockyBottom scale 1/(200*Feet) ]
		}
		turbulence 0.16
		scale 200*Feet
	}

#declare SeaFloorTex =
	texture {
		pigment {
			granite
			pigment_map {
				[ 0.50 SandyBottom scale 1/(2000*Feet) ]
				[ 0.58 RockySand scale 1/(2000*Feet) ]
			}
			translate <50,50.04,50> // this sets up a new random layout
			scale 2000*Feet
		}
		normal { bumps .5 scale 2.7*Meter }
		finish { ambient .1 diffuse .7 specular .2 roughness .15 }
	}

#declare SeaWater =
	union {

		box { <-30*KM,-30*KM,-100*Feet>,<30*KM,30*KM,0*Feet> // this is the transparent surface
			material { SeaWaterMat }
		}
/*
		box { <-30*KM,-30*KM,-0.002>,<30*KM,30*KM,-0.001> // this is the caustics underneath
			texture { CausticTex }
//			rotate x*-0.1
//			translate <0,0,2> // test
			no_shadow
		}
*/

		plane { z, Seabed // this is the ground underneath
			texture { SeaFloorTex }
		}
	} // end union


//===============================================
//             Other Objects
//===============================================



//===============================================
//             Object Placement
//===============================================

/*
Note: if you are trying to follow the layout of the
golf course, the holes are out of sequence!
Holes 1 through 12 are not shown
Hole 13 runs along the left ridge
Hole 14 is really hole3
Hole 15 is really hole9
Hole 16 is really hole1
Hole 17 is really hole2
Hole 18 ends at the resort
The background mounds are not part of the golf course.
*/


light_group {

//	#declare ASunLight =
	light_source {
		<0,0,0>
		color rgb <0.680,0.663,0.581>*2.3
		#if (AreaSun=1)
//			area_light <0,0,0.5*Miles>,<0,0.5*Miles,0>,4,4 adaptive 1 jitter circular orient // too soft!
			area_light <0,0,0.3*Miles>,<0,0.3*Miles,0>,2,2 jitter circular orient
		#end
//	}
//	object { ASunLight
	translate <0,0,50*Miles> // noon at Equator: directly overhead
	rotate y*-35 // towards left
  rotate z*1 // behind camera
	}

	#if (Foreground = 1) // show foreground elements
		object { Hole1Tee rotate z*-8 translate <0*Feet,-10*Feet,120*Feet> }
	#end // foreground
	global_lights off
} // end light group

object { SeaWater translate <0,0,0*Feet> }

#if (Background = 1) // show background elements
object { Hole1 translate <20*Yards,70*Yards,Seabed> } // main
//object { Hole9 scale <0.9,0.9,1.0> translate <-65*Yards,53*Yards,-10*Feet> } // upper left
object { Hole9 scale <0.9,0.9,1.0> translate <-50*Yards,35*Yards,-40*Feet> } // upper left test

object { Mound3 scale <.5,.5,.4> translate <44*Yards,38*Yards,Seabed> } // pointed top
object { Hole1m_Bridge rotate z*104 translate <61*Yards,45*Yards,17.8*Feet> }
object { Hole12a_Bridge rotate z*121 translate <29*Yards,90*Yards,20*Feet> }
object { Hole12b_Bridge rotate <0,-4,148> translate <19*Yards,133*Yards,45*Feet> }

object { Mound2Tee rotate <0,0,0> translate <-25*Yards, 124*Yards, Seabed> } // sloping top
object { Mound2Toppled rotate z*60 translate <-25*Yards, 124*Yards, Seabed>+<130*Feet,-10*Feet,-0*Feet> }

// Beach Area
object { SandyBeach rotate <0,0,0> translate <42*Yards,40*Yards,-6*Feet> }
object { Mound3 scale <.5,.6,.5> translate <125*Yards,159*Yards,0*Feet> } 
object { Mound3 rotate z*-90 scale <.5,1.1,.4> translate <130*Yards,172*Yards,0*Feet> } 

object { CatamaranS rotate <0,0,-45> translate <90*Yards,70*Yards,1*Feet> }
object { Hole2Green translate <120*Yards,155*Yards,15*Feet> }

// Far away groups
object { FarCoastline rotate z*-20 translate <-600*Yards,1000*Yards,Seabed> } // distant left
object { FarCoastline scale <3,3,3> rotate z*-110 rotate y*3 translate <-2.3*Miles,12*Miles,Seabed-50*Feet> } // very distant center
object { DistantIsland scale <3,11,2.5> rotate z*-110 rotate y*3 translate <-1.4*Miles,14*Miles,Seabed-50*Feet> } // very distant center
object { Mound3 scale <2.5,2.5,1.5> translate <-30*Yards,2400*Yards,Seabed> } // distant center

// Left side
object { Mound1 rotate <0,0,0> translate <-150*Yards, 584*Yards, Seabed> } // double top left
object { LeftFormation scale <1,1.2,1.3> rotate z*-90 translate <0*Yards,630*Yards,Seabed-30*Feet> } // upper left
object { Hole3Fairway rotate z*-77 scale <1,1,1> translate <-210*Yards,500*Yards,Seabed-0*Feet> } // left
object { Hole3Green  rotate z*170 scale <0.9,0.91,1.04> rotate y*-10 translate <37*Yards,330*Yards,Seabed-50*Feet> } // left
object { Hole3_Bridge rotate <0,5,0> translate <-42*Yards,306*Yards,42*Feet> }
object { Mound4TeeGroup rotate <0,0,3> translate <-230*Yards, 240*Yards, Seabed> } // left backdrop
object { Hole3Fairway rotate z*-107 scale <-1,1,1> translate <-80*Yards,300*Yards,Seabed-0*Feet> } // left near test

#if (Resort = 1)
// Resort area
object { ResortHill rotate z*0 translate <290*Yards,390*Yards,Seabed> }
object { RightCoast rotate z*-40 translate <50*Yards,140*Yards,Seabed> }
object { ResortGroup rotate <0,0,-60> translate <250*Yards,340*Yards,0> }
object { TwoMastedSchooner rotate z*0 translate <150*Yards,240*Yards,0> }
object { VolcanicFormation scale <1,1.2,1.3> rotate z*-90 translate <130*Yards,500*Yards,Seabed> } // resort area
object { MoundVert1 scale <1,1,0.9> rotate <0,0,-60> translate <280*Yards, 530*Yards, Seabed> } // right test
object { MoundVert1Waterfall scale 1.0 rotate <0,0,-18> translate <290*Yards, 480*Yards, Seabed> } // waterfall
object { MoundVert1 scale 1.0 rotate <0,0,-50> translate <350*Yards, 480*Yards, Seabed> } // right test
object { Hole18 rotate z*-30 translate <160*Yards,180*Yards,0> }
#if ( Vegetation = 1 )
object { FarTreeGroup(VegQual,60,240*Feet,100*Feet) rotate y*-3 translate <290*Yards, 460*Yards, 190*Feet> } // right test
object { FarTreeGroup(VegQual,40,200*Feet,80*Feet) rotate y*-7 translate <390*Yards, 550*Yards, 240*Feet> } // right test
object { FarTreeGroup(VegQual,30,200*Feet,80*Feet) scale 0.6 rotate y*-2 translate <340*Yards, 450*Yards, 197*Feet> } // right test
#end // vegetation
#end // resort
#end // background


