/*
camera{
	location < -2.822, 5.766, -5.915 >
	look_at < 0.354, 0.786, 0.895 >
	angle 40.000
}

background{ rgb <0/255,0/255,0/255> }


light_source{<100,100,-100> rgb 1}
light_source{<0,10,-1000> rgb 1}

//BagColor
#declare hama_mat0=material{
	
}

//TopBottomColor
#declare hama_mat1=material{
	
}


global_settings{
	adc_bailout 0.0039
	ambient_light rgb <255/255,255/255,255/255>
	assumed_gamma 2.200
	hf_gray_16 0
	irid_wavelength rgb <68/255,46/255,36/255>
	max_intersections 64
	max_trace_level 10
	number_of_waves 10
	radiosity{
		brightness 3.300
		count 100
		distance_maximum 0.000
		error_bound 0.400
		gray_threshold 0.500
		low_error_factor 0.800
		minimum_reuse 0.0150
		nearest_count 6
		recursion_limit 1
	}
}
*/

#declare TopBottomGroup=
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.445, 0.387, 0.000> <0.459, 0.392, 0.000> <0.478, 0.402, 0.000> <0.493, 0.405, 0.000> 
		<0.445, 0.387, 0.051> <0.459, 0.392, 0.051> <0.478, 0.402, 0.056> <0.493, 0.405, 0.056> 
		<0.430, 0.387, 0.120> <0.443, 0.392, 0.125> <0.463, 0.402, 0.127> <0.477, 0.405, 0.132> 
		<0.409, 0.387, 0.167> <0.422, 0.392, 0.172> <0.439, 0.402, 0.178> <0.453, 0.405, 0.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.493, 0.405, 0.000> <0.504, 0.406, 0.000> <0.526, 0.407, 0.000> <0.529, 0.401, 0.000> 
		<0.493, 0.405, 0.056> <0.504, 0.406, 0.056> <0.526, 0.407, 0.060> <0.529, 0.401, 0.060> 
		<0.477, 0.405, 0.132> <0.486, 0.406, 0.136> <0.509, 0.407, 0.140> <0.511, 0.401, 0.141> 
		<0.453, 0.405, 0.183> <0.463, 0.406, 0.187> <0.484, 0.407, 0.195> <0.486, 0.401, 0.196> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.529, 0.401, 0.000> <0.536, 0.385, 0.000> <0.536, 0.339, 0.000> <0.533, 0.312, 0.000> 
		<0.529, 0.401, 0.060> <0.536, 0.385, 0.060> <0.536, 0.339, 0.061> <0.533, 0.312, 0.061> 
		<0.511, 0.401, 0.141> <0.518, 0.385, 0.144> <0.518, 0.339, 0.143> <0.515, 0.312, 0.142> 
		<0.486, 0.401, 0.196> <0.493, 0.385, 0.198> <0.493, 0.339, 0.198> <0.490, 0.312, 0.197> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.533, 0.312, 0.000> <0.533, 0.308, 0.000> <0.519, 0.311, 0.000> <0.520, 0.307, 0.000> 
		<0.533, 0.312, 0.061> <0.533, 0.308, 0.061> <0.519, 0.311, 0.059> <0.520, 0.307, 0.059> 
		<0.515, 0.312, 0.142> <0.515, 0.308, 0.142> <0.502, 0.311, 0.139> <0.502, 0.307, 0.139> 
		<0.490, 0.312, 0.197> <0.490, 0.308, 0.197> <0.477, 0.311, 0.192> <0.478, 0.307, 0.193> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.520, 0.307, 0.000> <0.521, 0.295, 0.000> <0.536, 0.284, 0.000> <0.538, 0.273, 0.000> 
		<0.520, 0.307, 0.059> <0.521, 0.295, 0.059> <0.536, 0.284, 0.061> <0.538, 0.273, 0.061> 
		<0.502, 0.307, 0.139> <0.503, 0.296, 0.139> <0.518, 0.284, 0.143> <0.520, 0.273, 0.143> 
		<0.478, 0.307, 0.193> <0.479, 0.296, 0.193> <0.493, 0.284, 0.198> <0.494, 0.273, 0.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.538, 0.273, 0.000> <0.541, 0.251, 0.000> <0.539, 0.220, 0.000> <0.533, 0.198, 0.000> 
		<0.538, 0.273, 0.061> <0.541, 0.251, 0.061> <0.539, 0.220, 0.061> <0.533, 0.198, 0.061> 
		<0.520, 0.273, 0.143> <0.522, 0.251, 0.144> <0.521, 0.220, 0.144> <0.515, 0.198, 0.142> 
		<0.494, 0.273, 0.199> <0.497, 0.251, 0.200> <0.495, 0.220, 0.199> <0.490, 0.198, 0.197> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.533, 0.198, 0.000> <0.532, 0.193, 0.000> <0.517, 0.198, 0.000> <0.518, 0.193, 0.000> 
		<0.533, 0.198, 0.061> <0.532, 0.193, 0.061> <0.517, 0.198, 0.059> <0.518, 0.193, 0.059> 
		<0.515, 0.198, 0.142> <0.514, 0.194, 0.142> <0.499, 0.198, 0.138> <0.500, 0.193, 0.138> 
		<0.490, 0.198, 0.197> <0.489, 0.194, 0.197> <0.475, 0.198, 0.192> <0.476, 0.193, 0.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.518, 0.193, 0.000> <0.519, 0.183, 0.000> <0.536, 0.175, 0.000> <0.538, 0.164, 0.000> 
		<0.518, 0.193, 0.059> <0.519, 0.183, 0.059> <0.536, 0.175, 0.061> <0.538, 0.164, 0.061> 
		<0.500, 0.193, 0.138> <0.501, 0.183, 0.139> <0.518, 0.175, 0.143> <0.520, 0.164, 0.143> 
		<0.476, 0.193, 0.192> <0.477, 0.183, 0.192> <0.493, 0.175, 0.198> <0.495, 0.164, 0.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.538, 0.164, 0.000> <0.543, 0.142, 0.000> <0.534, 0.110, 0.000> <0.538, 0.087, 0.000> 
		<0.538, 0.164, 0.061> <0.543, 0.142, 0.061> <0.534, 0.110, 0.061> <0.538, 0.087, 0.061> 
		<0.520, 0.164, 0.143> <0.524, 0.142, 0.145> <0.516, 0.110, 0.142> <0.520, 0.087, 0.143> 
		<0.495, 0.164, 0.199> <0.499, 0.142, 0.201> <0.491, 0.110, 0.198> <0.495, 0.087, 0.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.538, 0.087, 0.000> <0.539, 0.080, 0.000> <0.552, 0.076, 0.000> <0.554, 0.069, 0.000> 
		<0.538, 0.087, 0.061> <0.539, 0.080, 0.061> <0.552, 0.076, 0.063> <0.554, 0.069, 0.063> 
		<0.520, 0.087, 0.143> <0.521, 0.080, 0.144> <0.533, 0.076, 0.147> <0.535, 0.069, 0.147> 
		<0.495, 0.087, 0.199> <0.496, 0.080, 0.199> <0.507, 0.076, 0.204> <0.509, 0.069, 0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.554, 0.069, 0.000> <0.557, 0.060, 0.000> <0.560, 0.046, 0.000> <0.554, 0.039, 0.000> 
		<0.554, 0.069, 0.063> <0.557, 0.060, 0.063> <0.560, 0.046, 0.063> <0.554, 0.039, 0.063> 
		<0.535, 0.069, 0.147> <0.538, 0.060, 0.148> <0.541, 0.046, 0.149> <0.535, 0.039, 0.147> 
		<0.509, 0.069, 0.205> <0.512, 0.060, 0.206> <0.515, 0.046, 0.207> <0.509, 0.039, 0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.554, 0.039, 0.000> <0.545, 0.028, 0.000> <0.526, 0.018, 0.000> <0.511, 0.017, 0.000> 
		<0.554, 0.039, 0.063> <0.545, 0.028, 0.063> <0.526, 0.018, 0.058> <0.511, 0.017, 0.058> 
		<0.535, 0.039, 0.147> <0.527, 0.028, 0.144> <0.507, 0.018, 0.142> <0.494, 0.017, 0.137> 
		<0.509, 0.039, 0.205> <0.501, 0.028, 0.201> <0.483, 0.018, 0.195> <0.470, 0.017, 0.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.511, 0.017, 0.000> <0.460, 0.011, 0.000> <0.391, 0.017, 0.000> <0.339, 0.017, 0.000> 
		<0.511, 0.017, 0.058> <0.460, 0.011, 0.058> <0.391, 0.017, 0.040> <0.339, 0.017, 0.040> 
		<0.494, 0.017, 0.137> <0.447, 0.011, 0.119> <0.375, 0.017, 0.111> <0.328, 0.017, 0.093> 
		<0.470, 0.017, 0.190> <0.423, 0.011, 0.172> <0.359, 0.017, 0.148> <0.311, 0.017, 0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.409, 0.387, -0.167> <0.422, 0.392, -0.172> <0.439, 0.402, -0.178> <0.453, 0.405, -0.183> 
		<0.430, 0.387, -0.120> <0.443, 0.392, -0.125> <0.463, 0.402, -0.127> <0.477, 0.405, -0.132> 
		<0.445, 0.387, -0.051> <0.459, 0.392, -0.051> <0.478, 0.402, -0.056> <0.493, 0.405, -0.056> 
		<0.445, 0.387, 0.000> <0.459, 0.392, 0.000> <0.478, 0.402, 0.000> <0.493, 0.405, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.453, 0.405, -0.183> <0.463, 0.406, -0.187> <0.484, 0.407, -0.195> <0.486, 0.401, -0.196> 
		<0.477, 0.405, -0.132> <0.486, 0.406, -0.136> <0.509, 0.407, -0.140> <0.511, 0.401, -0.141> 
		<0.493, 0.405, -0.056> <0.504, 0.406, -0.056> <0.526, 0.407, -0.060> <0.529, 0.401, -0.060> 
		<0.493, 0.405, 0.000> <0.504, 0.406, 0.000> <0.526, 0.407, 0.000> <0.529, 0.401, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.486, 0.401, -0.196> <0.493, 0.385, -0.198> <0.493, 0.339, -0.198> <0.490, 0.312, -0.197> 
		<0.511, 0.401, -0.141> <0.518, 0.385, -0.144> <0.518, 0.339, -0.143> <0.515, 0.312, -0.142> 
		<0.529, 0.401, -0.060> <0.536, 0.385, -0.060> <0.536, 0.339, -0.061> <0.533, 0.312, -0.061> 
		<0.529, 0.401, 0.000> <0.536, 0.385, 0.000> <0.536, 0.339, 0.000> <0.533, 0.312, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.490, 0.312, -0.197> <0.490, 0.308, -0.197> <0.477, 0.311, -0.192> <0.478, 0.307, -0.193> 
		<0.515, 0.312, -0.142> <0.515, 0.308, -0.142> <0.502, 0.311, -0.139> <0.502, 0.307, -0.139> 
		<0.533, 0.312, -0.061> <0.533, 0.308, -0.061> <0.519, 0.311, -0.059> <0.520, 0.307, -0.059> 
		<0.533, 0.312, 0.000> <0.533, 0.308, 0.000> <0.519, 0.311, 0.000> <0.520, 0.307, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.478, 0.307, -0.193> <0.479, 0.296, -0.193> <0.493, 0.284, -0.198> <0.494, 0.273, -0.199> 
		<0.502, 0.307, -0.139> <0.503, 0.296, -0.139> <0.518, 0.284, -0.143> <0.520, 0.273, -0.143> 
		<0.520, 0.307, -0.059> <0.521, 0.295, -0.059> <0.536, 0.284, -0.061> <0.538, 0.273, -0.061> 
		<0.520, 0.307, 0.000> <0.521, 0.295, 0.000> <0.536, 0.284, 0.000> <0.538, 0.273, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.494, 0.273, -0.199> <0.497, 0.251, -0.200> <0.495, 0.220, -0.199> <0.490, 0.198, -0.197> 
		<0.520, 0.273, -0.143> <0.522, 0.251, -0.144> <0.521, 0.220, -0.144> <0.515, 0.198, -0.142> 
		<0.538, 0.273, -0.061> <0.541, 0.251, -0.061> <0.539, 0.220, -0.061> <0.533, 0.198, -0.061> 
		<0.538, 0.273, 0.000> <0.541, 0.251, 0.000> <0.539, 0.220, 0.000> <0.533, 0.198, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.490, 0.198, -0.197> <0.489, 0.194, -0.197> <0.475, 0.198, -0.192> <0.476, 0.193, -0.192> 
		<0.515, 0.198, -0.142> <0.514, 0.194, -0.142> <0.499, 0.198, -0.138> <0.500, 0.193, -0.138> 
		<0.533, 0.198, -0.061> <0.532, 0.193, -0.061> <0.517, 0.198, -0.059> <0.518, 0.193, -0.059> 
		<0.533, 0.198, 0.000> <0.532, 0.193, 0.000> <0.517, 0.198, 0.000> <0.518, 0.193, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.476, 0.193, -0.192> <0.477, 0.183, -0.192> <0.493, 0.175, -0.198> <0.495, 0.164, -0.199> 
		<0.500, 0.193, -0.138> <0.501, 0.183, -0.139> <0.518, 0.175, -0.143> <0.520, 0.164, -0.143> 
		<0.518, 0.193, -0.059> <0.519, 0.183, -0.059> <0.536, 0.175, -0.061> <0.538, 0.164, -0.061> 
		<0.518, 0.193, 0.000> <0.519, 0.183, 0.000> <0.536, 0.175, 0.000> <0.538, 0.164, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.495, 0.164, -0.199> <0.499, 0.142, -0.201> <0.491, 0.110, -0.198> <0.495, 0.087, -0.199> 
		<0.520, 0.164, -0.143> <0.524, 0.142, -0.145> <0.516, 0.110, -0.142> <0.520, 0.087, -0.143> 
		<0.538, 0.164, -0.061> <0.543, 0.142, -0.061> <0.534, 0.110, -0.061> <0.538, 0.087, -0.061> 
		<0.538, 0.164, 0.000> <0.543, 0.142, 0.000> <0.534, 0.110, 0.000> <0.538, 0.087, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.495, 0.087, -0.199> <0.496, 0.080, -0.199> <0.507, 0.076, -0.204> <0.509, 0.069, -0.205> 
		<0.520, 0.087, -0.143> <0.521, 0.080, -0.144> <0.533, 0.076, -0.147> <0.535, 0.069, -0.147> 
		<0.538, 0.087, -0.061> <0.539, 0.080, -0.061> <0.552, 0.076, -0.063> <0.554, 0.069, -0.063> 
		<0.538, 0.087, 0.000> <0.539, 0.080, 0.000> <0.552, 0.076, 0.000> <0.554, 0.069, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.509, 0.069, -0.205> <0.512, 0.060, -0.206> <0.515, 0.046, -0.207> <0.509, 0.039, -0.205> 
		<0.535, 0.069, -0.147> <0.538, 0.060, -0.148> <0.541, 0.046, -0.149> <0.535, 0.039, -0.147> 
		<0.554, 0.069, -0.063> <0.557, 0.060, -0.063> <0.560, 0.046, -0.063> <0.554, 0.039, -0.063> 
		<0.554, 0.069, 0.000> <0.557, 0.060, 0.000> <0.560, 0.046, 0.000> <0.554, 0.039, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.509, 0.039, -0.205> <0.501, 0.028, -0.201> <0.483, 0.018, -0.195> <0.470, 0.017, -0.190> 
		<0.535, 0.039, -0.147> <0.527, 0.028, -0.144> <0.507, 0.018, -0.142> <0.494, 0.017, -0.137> 
		<0.554, 0.039, -0.063> <0.545, 0.028, -0.063> <0.526, 0.018, -0.058> <0.511, 0.017, -0.058> 
		<0.554, 0.039, 0.000> <0.545, 0.028, 0.000> <0.526, 0.018, 0.000> <0.511, 0.017, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.470, 0.017, -0.190> <0.423, 0.011, -0.172> <0.359, 0.017, -0.148> <0.311, 0.017, -0.130> 
		<0.494, 0.017, -0.137> <0.447, 0.011, -0.119> <0.375, 0.017, -0.111> <0.328, 0.017, -0.093> 
		<0.511, 0.017, -0.058> <0.460, 0.011, -0.058> <0.391, 0.017, -0.040> <0.339, 0.017, -0.040> 
		<0.511, 0.017, 0.000> <0.460, 0.011, 0.000> <0.391, 0.017, 0.000> <0.339, 0.017, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.305, 0.387, -0.308> <0.316, 0.392, -0.317> <0.329, 0.402, -0.329> <0.340, 0.405, -0.339> 
		<0.344, 0.387, -0.272> <0.354, 0.392, -0.282> <0.371, 0.402, -0.290> <0.382, 0.405, -0.300> 
		<0.387, 0.387, -0.214> <0.400, 0.392, -0.219> <0.415, 0.402, -0.231> <0.429, 0.405, -0.236> 
		<0.409, 0.387, -0.167> <0.422, 0.392, -0.172> <0.439, 0.402, -0.178> <0.453, 0.405, -0.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.340, 0.405, -0.339> <0.347, 0.406, -0.346> <0.363, 0.407, -0.360> <0.365, 0.401, -0.362> 
		<0.382, 0.405, -0.300> <0.390, 0.406, -0.307> <0.408, 0.407, -0.319> <0.410, 0.401, -0.320> 
		<0.429, 0.405, -0.236> <0.439, 0.406, -0.240> <0.458, 0.407, -0.251> <0.461, 0.401, -0.252> 
		<0.453, 0.405, -0.183> <0.463, 0.406, -0.187> <0.484, 0.407, -0.195> <0.486, 0.401, -0.196> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.365, 0.401, -0.362> <0.370, 0.385, -0.366> <0.370, 0.339, -0.366> <0.368, 0.312, -0.365> 
		<0.410, 0.401, -0.320> <0.415, 0.385, -0.325> <0.416, 0.339, -0.324> <0.414, 0.312, -0.323> 
		<0.461, 0.401, -0.252> <0.467, 0.385, -0.254> <0.467, 0.339, -0.255> <0.465, 0.312, -0.254> 
		<0.486, 0.401, -0.196> <0.493, 0.385, -0.198> <0.493, 0.339, -0.198> <0.490, 0.312, -0.197> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.368, 0.312, -0.365> <0.368, 0.308, -0.364> <0.358, 0.311, -0.356> <0.358, 0.307, -0.356> 
		<0.414, 0.312, -0.323> <0.414, 0.308, -0.323> <0.403, 0.311, -0.315> <0.403, 0.307, -0.315> 
		<0.465, 0.312, -0.254> <0.464, 0.308, -0.254> <0.452, 0.311, -0.248> <0.453, 0.307, -0.248> 
		<0.490, 0.312, -0.197> <0.490, 0.308, -0.197> <0.477, 0.311, -0.192> <0.478, 0.307, -0.193> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.358, 0.307, -0.356> <0.359, 0.296, -0.357> <0.370, 0.284, -0.367> <0.371, 0.273, -0.368> 
		<0.403, 0.307, -0.315> <0.404, 0.296, -0.316> <0.416, 0.284, -0.324> <0.417, 0.273, -0.325> 
		<0.453, 0.307, -0.248> <0.454, 0.296, -0.248> <0.467, 0.284, -0.256> <0.469, 0.273, -0.256> 
		<0.478, 0.307, -0.193> <0.479, 0.296, -0.193> <0.493, 0.284, -0.198> <0.494, 0.273, -0.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.371, 0.273, -0.368> <0.373, 0.251, -0.369> <0.372, 0.220, -0.368> <0.368, 0.198, -0.365> 
		<0.417, 0.273, -0.325> <0.419, 0.251, -0.327> <0.418, 0.220, -0.326> <0.414, 0.198, -0.323> 
		<0.469, 0.273, -0.256> <0.471, 0.251, -0.257> <0.470, 0.220, -0.256> <0.465, 0.198, -0.254> 
		<0.494, 0.273, -0.199> <0.497, 0.251, -0.200> <0.495, 0.220, -0.199> <0.490, 0.198, -0.197> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.368, 0.198, -0.365> <0.367, 0.194, -0.364> <0.356, 0.198, -0.354> <0.357, 0.193, -0.355> 
		<0.414, 0.198, -0.323> <0.413, 0.194, -0.322> <0.401, 0.198, -0.313> <0.401, 0.193, -0.314> 
		<0.465, 0.198, -0.254> <0.464, 0.194, -0.254> <0.450, 0.198, -0.247> <0.451, 0.193, -0.247> 
		<0.490, 0.198, -0.197> <0.489, 0.194, -0.197> <0.475, 0.198, -0.192> <0.476, 0.193, -0.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.357, 0.193, -0.355> <0.358, 0.183, -0.355> <0.370, 0.175, -0.366> <0.371, 0.164, -0.368> 
		<0.401, 0.193, -0.314> <0.402, 0.183, -0.315> <0.416, 0.175, -0.324> <0.418, 0.164, -0.325> 
		<0.451, 0.193, -0.247> <0.452, 0.183, -0.247> <0.467, 0.175, -0.255> <0.469, 0.164, -0.256> 
		<0.476, 0.193, -0.192> <0.477, 0.183, -0.192> <0.493, 0.175, -0.198> <0.495, 0.164, -0.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.371, 0.164, -0.368> <0.374, 0.142, -0.371> <0.368, 0.110, -0.365> <0.371, 0.087, -0.368> 
		<0.418, 0.164, -0.325> <0.421, 0.142, -0.328> <0.415, 0.110, -0.323> <0.418, 0.087, -0.325> 
		<0.469, 0.164, -0.256> <0.473, 0.142, -0.258> <0.465, 0.110, -0.255> <0.469, 0.087, -0.256> 
		<0.495, 0.164, -0.199> <0.499, 0.142, -0.201> <0.491, 0.110, -0.198> <0.495, 0.087, -0.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.371, 0.087, -0.368> <0.372, 0.080, -0.369> <0.381, 0.076, -0.377> <0.382, 0.069, -0.378> 
		<0.418, 0.087, -0.325> <0.418, 0.080, -0.326> <0.429, 0.076, -0.333> <0.430, 0.069, -0.335> 
		<0.469, 0.087, -0.256> <0.470, 0.080, -0.257> <0.481, 0.076, -0.263> <0.483, 0.069, -0.263> 
		<0.495, 0.087, -0.199> <0.496, 0.080, -0.199> <0.507, 0.076, -0.204> <0.509, 0.069, -0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.382, 0.069, -0.378> <0.384, 0.060, -0.380> <0.386, 0.046, -0.382> <0.382, 0.039, -0.378> 
		<0.430, 0.069, -0.335> <0.432, 0.060, -0.336> <0.434, 0.046, -0.338> <0.430, 0.039, -0.335> 
		<0.483, 0.069, -0.263> <0.485, 0.060, -0.264> <0.488, 0.046, -0.265> <0.483, 0.039, -0.263> 
		<0.509, 0.069, -0.205> <0.512, 0.060, -0.206> <0.515, 0.046, -0.207> <0.509, 0.039, -0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.382, 0.039, -0.378> <0.376, 0.028, -0.372> <0.362, 0.018, -0.360> <0.352, 0.017, -0.350> 
		<0.430, 0.039, -0.335> <0.424, 0.028, -0.329> <0.407, 0.018, -0.320> <0.396, 0.017, -0.310> 
		<0.483, 0.039, -0.263> <0.474, 0.028, -0.260> <0.459, 0.018, -0.249> <0.445, 0.017, -0.244> 
		<0.509, 0.039, -0.205> <0.501, 0.028, -0.201> <0.483, 0.018, -0.195> <0.470, 0.017, -0.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.352, 0.017, -0.350> <0.316, 0.011, -0.317> <0.267, 0.017, -0.273> <0.231, 0.017, -0.240> 
		<0.396, 0.017, -0.310> <0.360, 0.011, -0.277> <0.297, 0.017, -0.245> <0.261, 0.017, -0.212> 
		<0.445, 0.017, -0.244> <0.398, 0.011, -0.226> <0.342, 0.017, -0.185> <0.294, 0.017, -0.167> 
		<0.470, 0.017, -0.190> <0.423, 0.011, -0.172> <0.359, 0.017, -0.148> <0.311, 0.017, -0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.151, 0.387, -0.402> <0.156, 0.392, -0.414> <0.163, 0.402, -0.430> <0.169, 0.405, -0.443> 
		<0.202, 0.387, -0.383> <0.207, 0.392, -0.395> <0.219, 0.402, -0.409> <0.225, 0.405, -0.422> 
		<0.265, 0.387, -0.344> <0.275, 0.392, -0.354> <0.285, 0.402, -0.369> <0.295, 0.405, -0.379> 
		<0.305, 0.387, -0.308> <0.316, 0.392, -0.317> <0.329, 0.402, -0.329> <0.340, 0.405, -0.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.169, 0.405, -0.443> <0.173, 0.406, -0.452> <0.182, 0.407, -0.471> <0.183, 0.401, -0.473> 
		<0.225, 0.405, -0.422> <0.229, 0.406, -0.431> <0.242, 0.407, -0.448> <0.243, 0.401, -0.450> 
		<0.295, 0.405, -0.379> <0.303, 0.406, -0.386> <0.316, 0.407, -0.403> <0.318, 0.401, -0.405> 
		<0.340, 0.405, -0.339> <0.347, 0.406, -0.346> <0.363, 0.407, -0.360> <0.365, 0.401, -0.362> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.183, 0.401, -0.473> <0.186, 0.385, -0.479> <0.186, 0.339, -0.479> <0.185, 0.312, -0.477> 
		<0.243, 0.401, -0.450> <0.245, 0.385, -0.456> <0.246, 0.339, -0.456> <0.245, 0.312, -0.454> 
		<0.318, 0.401, -0.405> <0.322, 0.385, -0.409> <0.322, 0.339, -0.410> <0.320, 0.312, -0.408> 
		<0.365, 0.401, -0.362> <0.370, 0.385, -0.366> <0.370, 0.339, -0.366> <0.368, 0.312, -0.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.185, 0.312, -0.477> <0.184, 0.308, -0.476> <0.179, 0.311, -0.465> <0.179, 0.307, -0.465> 
		<0.245, 0.312, -0.454> <0.245, 0.308, -0.453> <0.238, 0.311, -0.442> <0.238, 0.307, -0.443> 
		<0.320, 0.312, -0.408> <0.320, 0.308, -0.408> <0.311, 0.311, -0.398> <0.312, 0.307, -0.398> 
		<0.368, 0.312, -0.365> <0.368, 0.308, -0.364> <0.358, 0.311, -0.356> <0.358, 0.307, -0.356> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.179, 0.307, -0.465> <0.180, 0.296, -0.466> <0.186, 0.284, -0.479> <0.186, 0.273, -0.480> 
		<0.238, 0.307, -0.443> <0.239, 0.296, -0.444> <0.246, 0.284, -0.456> <0.247, 0.273, -0.457> 
		<0.312, 0.307, -0.398> <0.313, 0.296, -0.399> <0.322, 0.284, -0.410> <0.323, 0.273, -0.411> 
		<0.358, 0.307, -0.356> <0.359, 0.296, -0.357> <0.370, 0.284, -0.367> <0.371, 0.273, -0.368> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.186, 0.273, -0.480> <0.187, 0.251, -0.483> <0.187, 0.220, -0.481> <0.185, 0.198, -0.477> 
		<0.247, 0.273, -0.457> <0.248, 0.251, -0.460> <0.247, 0.220, -0.458> <0.245, 0.198, -0.454> 
		<0.323, 0.273, -0.411> <0.325, 0.251, -0.413> <0.324, 0.220, -0.412> <0.320, 0.198, -0.408> 
		<0.371, 0.273, -0.368> <0.373, 0.251, -0.369> <0.372, 0.220, -0.368> <0.368, 0.198, -0.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.185, 0.198, -0.477> <0.184, 0.194, -0.476> <0.178, 0.198, -0.463> <0.178, 0.193, -0.463> 
		<0.245, 0.198, -0.454> <0.244, 0.194, -0.453> <0.237, 0.198, -0.441> <0.237, 0.193, -0.441> 
		<0.320, 0.198, -0.408> <0.319, 0.194, -0.407> <0.310, 0.198, -0.396> <0.310, 0.193, -0.397> 
		<0.368, 0.198, -0.365> <0.367, 0.194, -0.364> <0.356, 0.198, -0.354> <0.357, 0.193, -0.355> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.178, 0.193, -0.463> <0.179, 0.183, -0.464> <0.186, 0.175, -0.479> <0.186, 0.164, -0.481> 
		<0.237, 0.193, -0.441> <0.238, 0.183, -0.442> <0.246, 0.175, -0.456> <0.247, 0.164, -0.458> 
		<0.310, 0.193, -0.397> <0.311, 0.183, -0.398> <0.322, 0.175, -0.410> <0.323, 0.164, -0.412> 
		<0.357, 0.193, -0.355> <0.358, 0.183, -0.355> <0.370, 0.175, -0.366> <0.371, 0.164, -0.368> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.186, 0.164, -0.481> <0.188, 0.142, -0.484> <0.185, 0.110, -0.477> <0.186, 0.087, -0.481> 
		<0.247, 0.164, -0.458> <0.249, 0.142, -0.461> <0.246, 0.110, -0.454> <0.247, 0.087, -0.458> 
		<0.323, 0.164, -0.412> <0.326, 0.142, -0.414> <0.321, 0.110, -0.409> <0.323, 0.087, -0.412> 
		<0.371, 0.164, -0.368> <0.374, 0.142, -0.371> <0.368, 0.110, -0.365> <0.371, 0.087, -0.368> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.186, 0.087, -0.481> <0.187, 0.080, -0.482> <0.192, 0.076, -0.492> <0.192, 0.069, -0.494> 
		<0.247, 0.087, -0.458> <0.248, 0.080, -0.459> <0.254, 0.076, -0.468> <0.255, 0.069, -0.470> 
		<0.323, 0.087, -0.412> <0.324, 0.080, -0.412> <0.332, 0.076, -0.422> <0.333, 0.069, -0.423> 
		<0.371, 0.087, -0.368> <0.372, 0.080, -0.369> <0.381, 0.076, -0.377> <0.382, 0.069, -0.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.192, 0.069, -0.494> <0.194, 0.060, -0.496> <0.195, 0.046, -0.499> <0.192, 0.039, -0.494> 
		<0.255, 0.069, -0.470> <0.256, 0.060, -0.473> <0.257, 0.046, -0.475> <0.255, 0.039, -0.470> 
		<0.333, 0.069, -0.423> <0.335, 0.060, -0.425> <0.337, 0.046, -0.427> <0.333, 0.039, -0.423> 
		<0.382, 0.069, -0.378> <0.384, 0.060, -0.380> <0.386, 0.046, -0.382> <0.382, 0.039, -0.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.192, 0.039, -0.494> <0.189, 0.028, -0.486> <0.182, 0.018, -0.470> <0.176, 0.017, -0.458> 
		<0.255, 0.039, -0.470> <0.251, 0.028, -0.463> <0.240, 0.018, -0.448> <0.234, 0.017, -0.436> 
		<0.333, 0.039, -0.423> <0.327, 0.028, -0.417> <0.317, 0.018, -0.402> <0.307, 0.017, -0.392> 
		<0.382, 0.039, -0.378> <0.376, 0.028, -0.372> <0.362, 0.018, -0.360> <0.352, 0.017, -0.350> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.176, 0.017, -0.458> <0.156, 0.011, -0.415> <0.130, 0.017, -0.356> <0.110, 0.017, -0.313> 
		<0.234, 0.017, -0.436> <0.214, 0.011, -0.393> <0.170, 0.017, -0.341> <0.150, 0.017, -0.298> 
		<0.307, 0.017, -0.392> <0.270, 0.011, -0.359> <0.236, 0.017, -0.301> <0.199, 0.017, -0.268> 
		<0.352, 0.017, -0.350> <0.316, 0.011, -0.317> <0.267, 0.017, -0.273> <0.231, 0.017, -0.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.387, -0.435> <-0.032, 0.392, -0.448> <-0.032, 0.402, -0.465> <-0.032, 0.405, -0.479> 
		<0.024, 0.387, -0.435> <0.024, 0.392, -0.448> <0.030, 0.402, -0.465> <0.030, 0.405, -0.479> 
		<0.099, 0.387, -0.422> <0.104, 0.392, -0.434> <0.106, 0.402, -0.451> <0.112, 0.405, -0.464> 
		<0.151, 0.387, -0.402> <0.156, 0.392, -0.414> <0.163, 0.402, -0.430> <0.169, 0.405, -0.443> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.405, -0.479> <-0.032, 0.406, -0.489> <-0.032, 0.407, -0.509> <-0.032, 0.401, -0.512> 
		<0.030, 0.405, -0.479> <0.030, 0.406, -0.489> <0.034, 0.407, -0.509> <0.034, 0.401, -0.512> 
		<0.112, 0.405, -0.464> <0.116, 0.406, -0.473> <0.121, 0.407, -0.494> <0.122, 0.401, -0.496> 
		<0.169, 0.405, -0.443> <0.173, 0.406, -0.452> <0.182, 0.407, -0.471> <0.183, 0.401, -0.473> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.401, -0.512> <-0.032, 0.385, -0.518> <-0.032, 0.339, -0.518> <-0.032, 0.312, -0.516> 
		<0.034, 0.401, -0.512> <0.034, 0.385, -0.518> <0.034, 0.339, -0.518> <0.034, 0.312, -0.516> 
		<0.122, 0.401, -0.496> <0.124, 0.385, -0.502> <0.124, 0.339, -0.502> <0.123, 0.312, -0.500> 
		<0.183, 0.401, -0.473> <0.186, 0.385, -0.479> <0.186, 0.339, -0.479> <0.185, 0.312, -0.477> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.312, -0.516> <-0.032, 0.308, -0.515> <-0.032, 0.311, -0.503> <-0.032, 0.307, -0.503> 
		<0.034, 0.312, -0.516> <0.034, 0.308, -0.515> <0.033, 0.311, -0.503> <0.033, 0.307, -0.503> 
		<0.123, 0.312, -0.500> <0.123, 0.308, -0.500> <0.119, 0.311, -0.487> <0.119, 0.307, -0.488> 
		<0.185, 0.312, -0.477> <0.184, 0.308, -0.476> <0.179, 0.311, -0.465> <0.179, 0.307, -0.465> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.307, -0.503> <-0.032, 0.296, -0.505> <-0.032, 0.284, -0.519> <-0.032, 0.273, -0.520> 
		<0.033, 0.307, -0.503> <0.033, 0.296, -0.505> <0.035, 0.284, -0.519> <0.035, 0.273, -0.520> 
		<0.119, 0.307, -0.488> <0.120, 0.296, -0.489> <0.124, 0.284, -0.503> <0.124, 0.273, -0.504> 
		<0.179, 0.307, -0.465> <0.180, 0.296, -0.466> <0.186, 0.284, -0.479> <0.186, 0.273, -0.480> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.273, -0.520> <-0.032, 0.251, -0.522> <-0.032, 0.220, -0.521> <-0.032, 0.198, -0.516> 
		<0.035, 0.273, -0.520> <0.035, 0.251, -0.522> <0.034, 0.220, -0.521> <0.034, 0.198, -0.516> 
		<0.124, 0.273, -0.504> <0.125, 0.251, -0.506> <0.125, 0.220, -0.505> <0.123, 0.198, -0.500> 
		<0.186, 0.273, -0.480> <0.187, 0.251, -0.483> <0.187, 0.220, -0.481> <0.185, 0.198, -0.477> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.198, -0.516> <-0.032, 0.194, -0.515> <-0.032, 0.198, -0.501> <-0.032, 0.193, -0.501> 
		<0.034, 0.198, -0.516> <0.034, 0.194, -0.515> <0.032, 0.198, -0.501> <0.032, 0.193, -0.501> 
		<0.123, 0.198, -0.500> <0.122, 0.194, -0.499> <0.118, 0.198, -0.485> <0.119, 0.193, -0.486> 
		<0.185, 0.198, -0.477> <0.184, 0.194, -0.476> <0.178, 0.198, -0.463> <0.178, 0.193, -0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.193, -0.501> <-0.032, 0.183, -0.503> <-0.032, 0.175, -0.518> <-0.032, 0.164, -0.520> 
		<0.032, 0.193, -0.501> <0.032, 0.183, -0.503> <0.035, 0.175, -0.518> <0.035, 0.164, -0.520> 
		<0.119, 0.193, -0.486> <0.119, 0.183, -0.487> <0.123, 0.175, -0.502> <0.124, 0.164, -0.504> 
		<0.178, 0.193, -0.463> <0.179, 0.183, -0.464> <0.186, 0.175, -0.479> <0.186, 0.164, -0.481> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.164, -0.520> <-0.032, 0.142, -0.524> <-0.032, 0.110, -0.517> <-0.032, 0.087, -0.520> 
		<0.035, 0.164, -0.520> <0.035, 0.142, -0.524> <0.035, 0.110, -0.517> <0.035, 0.087, -0.520> 
		<0.124, 0.164, -0.504> <0.126, 0.142, -0.508> <0.123, 0.110, -0.501> <0.124, 0.087, -0.504> 
		<0.186, 0.164, -0.481> <0.188, 0.142, -0.484> <0.185, 0.110, -0.477> <0.186, 0.087, -0.481> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.087, -0.520> <-0.032, 0.080, -0.521> <-0.032, 0.076, -0.533> <-0.032, 0.069, -0.535> 
		<0.035, 0.087, -0.520> <0.035, 0.080, -0.521> <0.037, 0.076, -0.533> <0.037, 0.069, -0.535> 
		<0.124, 0.087, -0.504> <0.125, 0.080, -0.505> <0.128, 0.076, -0.516> <0.128, 0.069, -0.518> 
		<0.186, 0.087, -0.481> <0.187, 0.080, -0.482> <0.192, 0.076, -0.492> <0.192, 0.069, -0.494> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.069, -0.535> <-0.032, 0.060, -0.537> <-0.032, 0.046, -0.540> <-0.032, 0.039, -0.535> 
		<0.037, 0.069, -0.535> <0.037, 0.060, -0.537> <0.037, 0.046, -0.540> <0.037, 0.039, -0.535> 
		<0.128, 0.069, -0.518> <0.130, 0.060, -0.521> <0.131, 0.046, -0.523> <0.128, 0.039, -0.518> 
		<0.192, 0.069, -0.494> <0.194, 0.060, -0.496> <0.195, 0.046, -0.499> <0.192, 0.039, -0.494> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.039, -0.535> <-0.032, 0.028, -0.527> <-0.032, 0.018, -0.509> <-0.032, 0.017, -0.496> 
		<0.037, 0.039, -0.535> <0.037, 0.028, -0.527> <0.032, 0.018, -0.509> <0.032, 0.017, -0.496> 
		<0.128, 0.039, -0.518> <0.125, 0.028, -0.511> <0.122, 0.018, -0.493> <0.117, 0.017, -0.480> 
		<0.192, 0.039, -0.494> <0.189, 0.028, -0.486> <0.182, 0.018, -0.470> <0.176, 0.017, -0.458> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.017, -0.496> <-0.032, 0.011, -0.449> <-0.032, 0.017, -0.386> <-0.032, 0.017, -0.339> 
		<0.032, 0.017, -0.496> <0.032, 0.011, -0.449> <0.012, 0.017, -0.386> <0.012, 0.017, -0.339> 
		<0.117, 0.017, -0.480> <0.097, 0.011, -0.437> <0.090, 0.017, -0.372> <0.070, 0.017, -0.328> 
		<0.176, 0.017, -0.458> <0.156, 0.011, -0.415> <0.130, 0.017, -0.356> <0.110, 0.017, -0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.214, 0.387, -0.402> <-0.220, 0.392, -0.414> <-0.227, 0.402, -0.430> <-0.233, 0.405, -0.443> 
		<-0.162, 0.387, -0.422> <-0.168, 0.392, -0.434> <-0.169, 0.402, -0.451> <-0.175, 0.405, -0.464> 
		<-0.087, 0.387, -0.435> <-0.087, 0.392, -0.448> <-0.093, 0.402, -0.465> <-0.093, 0.405, -0.479> 
		<-0.032, 0.387, -0.435> <-0.032, 0.392, -0.448> <-0.032, 0.402, -0.465> <-0.032, 0.405, -0.479> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.233, 0.405, -0.443> <-0.237, 0.406, -0.452> <-0.245, 0.407, -0.471> <-0.246, 0.401, -0.473> 
		<-0.175, 0.405, -0.464> <-0.179, 0.406, -0.473> <-0.184, 0.407, -0.494> <-0.185, 0.401, -0.496> 
		<-0.093, 0.405, -0.479> <-0.093, 0.406, -0.489> <-0.097, 0.407, -0.509> <-0.097, 0.401, -0.512> 
		<-0.032, 0.405, -0.479> <-0.032, 0.406, -0.489> <-0.032, 0.407, -0.509> <-0.032, 0.401, -0.512> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.246, 0.401, -0.473> <-0.249, 0.385, -0.479> <-0.249, 0.339, -0.479> <-0.248, 0.312, -0.477> 
		<-0.185, 0.401, -0.496> <-0.188, 0.385, -0.502> <-0.187, 0.339, -0.502> <-0.186, 0.312, -0.500> 
		<-0.097, 0.401, -0.512> <-0.097, 0.385, -0.518> <-0.098, 0.339, -0.518> <-0.098, 0.312, -0.516> 
		<-0.032, 0.401, -0.512> <-0.032, 0.385, -0.518> <-0.032, 0.339, -0.518> <-0.032, 0.312, -0.516> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.248, 0.312, -0.477> <-0.248, 0.308, -0.476> <-0.243, 0.311, -0.465> <-0.243, 0.307, -0.465> 
		<-0.186, 0.312, -0.500> <-0.186, 0.308, -0.500> <-0.182, 0.311, -0.487> <-0.183, 0.307, -0.488> 
		<-0.098, 0.312, -0.516> <-0.098, 0.308, -0.515> <-0.096, 0.311, -0.503> <-0.096, 0.307, -0.503> 
		<-0.032, 0.312, -0.516> <-0.032, 0.308, -0.515> <-0.032, 0.311, -0.503> <-0.032, 0.307, -0.503> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.243, 0.307, -0.465> <-0.243, 0.296, -0.466> <-0.249, 0.284, -0.479> <-0.250, 0.273, -0.480> 
		<-0.183, 0.307, -0.488> <-0.183, 0.296, -0.489> <-0.187, 0.284, -0.503> <-0.188, 0.273, -0.504> 
		<-0.096, 0.307, -0.503> <-0.096, 0.296, -0.505> <-0.098, 0.284, -0.519> <-0.098, 0.273, -0.520> 
		<-0.032, 0.307, -0.503> <-0.032, 0.296, -0.505> <-0.032, 0.284, -0.519> <-0.032, 0.273, -0.520> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.250, 0.273, -0.480> <-0.251, 0.251, -0.483> <-0.250, 0.220, -0.481> <-0.248, 0.198, -0.477> 
		<-0.188, 0.273, -0.504> <-0.189, 0.251, -0.506> <-0.188, 0.220, -0.505> <-0.186, 0.198, -0.500> 
		<-0.098, 0.273, -0.520> <-0.098, 0.251, -0.522> <-0.098, 0.220, -0.521> <-0.098, 0.198, -0.516> 
		<-0.032, 0.273, -0.520> <-0.032, 0.251, -0.522> <-0.032, 0.220, -0.521> <-0.032, 0.198, -0.516> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.248, 0.198, -0.477> <-0.248, 0.194, -0.476> <-0.242, 0.198, -0.463> <-0.242, 0.193, -0.463> 
		<-0.186, 0.198, -0.500> <-0.186, 0.194, -0.499> <-0.182, 0.198, -0.485> <-0.182, 0.193, -0.486> 
		<-0.098, 0.198, -0.516> <-0.098, 0.194, -0.515> <-0.096, 0.198, -0.501> <-0.096, 0.193, -0.501> 
		<-0.032, 0.198, -0.516> <-0.032, 0.194, -0.515> <-0.032, 0.198, -0.501> <-0.032, 0.193, -0.501> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.242, 0.193, -0.463> <-0.242, 0.183, -0.464> <-0.249, 0.175, -0.479> <-0.250, 0.164, -0.481> 
		<-0.182, 0.193, -0.486> <-0.183, 0.183, -0.487> <-0.187, 0.175, -0.502> <-0.188, 0.164, -0.504> 
		<-0.096, 0.193, -0.501> <-0.096, 0.183, -0.503> <-0.098, 0.175, -0.518> <-0.098, 0.164, -0.520> 
		<-0.032, 0.193, -0.501> <-0.032, 0.183, -0.503> <-0.032, 0.175, -0.518> <-0.032, 0.164, -0.520> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.250, 0.164, -0.481> <-0.251, 0.142, -0.484> <-0.248, 0.110, -0.477> <-0.250, 0.087, -0.481> 
		<-0.188, 0.164, -0.504> <-0.189, 0.142, -0.508> <-0.186, 0.110, -0.501> <-0.188, 0.087, -0.504> 
		<-0.098, 0.164, -0.520> <-0.098, 0.142, -0.524> <-0.098, 0.110, -0.517> <-0.098, 0.087, -0.520> 
		<-0.032, 0.164, -0.520> <-0.032, 0.142, -0.524> <-0.032, 0.110, -0.517> <-0.032, 0.087, -0.520> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.250, 0.087, -0.481> <-0.250, 0.080, -0.482> <-0.255, 0.076, -0.492> <-0.256, 0.069, -0.494> 
		<-0.188, 0.087, -0.504> <-0.188, 0.080, -0.505> <-0.191, 0.076, -0.516> <-0.192, 0.069, -0.518> 
		<-0.098, 0.087, -0.520> <-0.098, 0.080, -0.521> <-0.100, 0.076, -0.533> <-0.100, 0.069, -0.535> 
		<-0.032, 0.087, -0.520> <-0.032, 0.080, -0.521> <-0.032, 0.076, -0.533> <-0.032, 0.069, -0.535> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.256, 0.069, -0.494> <-0.257, 0.060, -0.496> <-0.258, 0.046, -0.499> <-0.256, 0.039, -0.494> 
		<-0.192, 0.069, -0.518> <-0.193, 0.060, -0.521> <-0.194, 0.046, -0.523> <-0.192, 0.039, -0.518> 
		<-0.100, 0.069, -0.535> <-0.100, 0.060, -0.537> <-0.100, 0.046, -0.540> <-0.100, 0.039, -0.535> 
		<-0.032, 0.069, -0.535> <-0.032, 0.060, -0.537> <-0.032, 0.046, -0.540> <-0.032, 0.039, -0.535> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.256, 0.039, -0.494> <-0.252, 0.028, -0.486> <-0.245, 0.018, -0.470> <-0.240, 0.017, -0.458> 
		<-0.192, 0.039, -0.518> <-0.189, 0.028, -0.511> <-0.186, 0.018, -0.493> <-0.180, 0.017, -0.480> 
		<-0.100, 0.039, -0.535> <-0.100, 0.028, -0.527> <-0.095, 0.018, -0.509> <-0.095, 0.017, -0.496> 
		<-0.032, 0.039, -0.535> <-0.032, 0.028, -0.527> <-0.032, 0.018, -0.509> <-0.032, 0.017, -0.496> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.240, 0.017, -0.458> <-0.220, 0.011, -0.415> <-0.193, 0.017, -0.356> <-0.174, 0.017, -0.313> 
		<-0.180, 0.017, -0.480> <-0.161, 0.011, -0.437> <-0.153, 0.017, -0.372> <-0.133, 0.017, -0.328> 
		<-0.095, 0.017, -0.496> <-0.095, 0.011, -0.449> <-0.075, 0.017, -0.386> <-0.075, 0.017, -0.339> 
		<-0.032, 0.017, -0.496> <-0.032, 0.011, -0.449> <-0.032, 0.017, -0.386> <-0.032, 0.017, -0.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.369, 0.387, -0.308> <-0.379, 0.392, -0.317> <-0.392, 0.402, -0.329> <-0.403, 0.405, -0.339> 
		<-0.329, 0.387, -0.344> <-0.339, 0.392, -0.354> <-0.348, 0.402, -0.369> <-0.359, 0.405, -0.379> 
		<-0.265, 0.387, -0.383> <-0.271, 0.392, -0.395> <-0.283, 0.402, -0.409> <-0.289, 0.405, -0.422> 
		<-0.214, 0.387, -0.402> <-0.220, 0.392, -0.414> <-0.227, 0.402, -0.430> <-0.233, 0.405, -0.443> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.403, 0.405, -0.339> <-0.410, 0.406, -0.346> <-0.426, 0.407, -0.360> <-0.428, 0.401, -0.362> 
		<-0.359, 0.405, -0.379> <-0.366, 0.406, -0.386> <-0.379, 0.407, -0.403> <-0.381, 0.401, -0.405> 
		<-0.289, 0.405, -0.422> <-0.293, 0.406, -0.431> <-0.305, 0.407, -0.448> <-0.306, 0.401, -0.450> 
		<-0.233, 0.405, -0.443> <-0.237, 0.406, -0.452> <-0.245, 0.407, -0.471> <-0.246, 0.401, -0.473> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.428, 0.401, -0.362> <-0.433, 0.385, -0.366> <-0.433, 0.339, -0.366> <-0.431, 0.312, -0.365> 
		<-0.381, 0.401, -0.405> <-0.386, 0.385, -0.409> <-0.386, 0.339, -0.410> <-0.384, 0.312, -0.408> 
		<-0.306, 0.401, -0.450> <-0.309, 0.385, -0.456> <-0.309, 0.339, -0.456> <-0.308, 0.312, -0.454> 
		<-0.246, 0.401, -0.473> <-0.249, 0.385, -0.479> <-0.249, 0.339, -0.479> <-0.248, 0.312, -0.477> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.431, 0.312, -0.365> <-0.431, 0.308, -0.364> <-0.421, 0.311, -0.356> <-0.422, 0.307, -0.356> 
		<-0.384, 0.312, -0.408> <-0.383, 0.308, -0.408> <-0.375, 0.311, -0.398> <-0.375, 0.307, -0.398> 
		<-0.308, 0.312, -0.454> <-0.308, 0.308, -0.453> <-0.301, 0.311, -0.442> <-0.302, 0.307, -0.443> 
		<-0.248, 0.312, -0.477> <-0.248, 0.308, -0.476> <-0.243, 0.311, -0.465> <-0.243, 0.307, -0.465> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.422, 0.307, -0.356> <-0.423, 0.296, -0.357> <-0.433, 0.284, -0.367> <-0.434, 0.273, -0.368> 
		<-0.375, 0.307, -0.398> <-0.376, 0.296, -0.399> <-0.386, 0.284, -0.410> <-0.387, 0.273, -0.411> 
		<-0.302, 0.307, -0.443> <-0.302, 0.296, -0.444> <-0.310, 0.284, -0.456> <-0.310, 0.273, -0.457> 
		<-0.243, 0.307, -0.465> <-0.243, 0.296, -0.466> <-0.249, 0.284, -0.479> <-0.250, 0.273, -0.480> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.434, 0.273, -0.368> <-0.436, 0.251, -0.369> <-0.435, 0.220, -0.368> <-0.431, 0.198, -0.365> 
		<-0.387, 0.273, -0.411> <-0.389, 0.251, -0.413> <-0.388, 0.220, -0.412> <-0.384, 0.198, -0.408> 
		<-0.310, 0.273, -0.457> <-0.312, 0.251, -0.460> <-0.310, 0.220, -0.458> <-0.308, 0.198, -0.454> 
		<-0.250, 0.273, -0.480> <-0.251, 0.251, -0.483> <-0.250, 0.220, -0.481> <-0.248, 0.198, -0.477> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.431, 0.198, -0.365> <-0.431, 0.194, -0.364> <-0.420, 0.198, -0.354> <-0.420, 0.193, -0.355> 
		<-0.384, 0.198, -0.408> <-0.383, 0.194, -0.407> <-0.373, 0.198, -0.396> <-0.374, 0.193, -0.397> 
		<-0.308, 0.198, -0.454> <-0.308, 0.194, -0.453> <-0.300, 0.198, -0.441> <-0.301, 0.193, -0.441> 
		<-0.248, 0.198, -0.477> <-0.248, 0.194, -0.476> <-0.242, 0.198, -0.463> <-0.242, 0.193, -0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.420, 0.193, -0.355> <-0.421, 0.183, -0.355> <-0.433, 0.175, -0.366> <-0.435, 0.164, -0.368> 
		<-0.374, 0.193, -0.397> <-0.375, 0.183, -0.398> <-0.385, 0.175, -0.410> <-0.387, 0.164, -0.412> 
		<-0.301, 0.193, -0.441> <-0.301, 0.183, -0.442> <-0.310, 0.175, -0.456> <-0.311, 0.164, -0.458> 
		<-0.242, 0.193, -0.463> <-0.242, 0.183, -0.464> <-0.249, 0.175, -0.479> <-0.250, 0.164, -0.481> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 0.164, -0.368> <-0.438, 0.142, -0.371> <-0.432, 0.110, -0.365> <-0.435, 0.087, -0.368> 
		<-0.387, 0.164, -0.412> <-0.390, 0.142, -0.414> <-0.384, 0.110, -0.409> <-0.387, 0.087, -0.412> 
		<-0.311, 0.164, -0.458> <-0.312, 0.142, -0.461> <-0.309, 0.110, -0.454> <-0.311, 0.087, -0.458> 
		<-0.250, 0.164, -0.481> <-0.251, 0.142, -0.484> <-0.248, 0.110, -0.477> <-0.250, 0.087, -0.481> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 0.087, -0.368> <-0.436, 0.080, -0.369> <-0.444, 0.076, -0.377> <-0.446, 0.069, -0.378> 
		<-0.387, 0.087, -0.412> <-0.388, 0.080, -0.412> <-0.395, 0.076, -0.422> <-0.397, 0.069, -0.423> 
		<-0.311, 0.087, -0.458> <-0.311, 0.080, -0.459> <-0.318, 0.076, -0.468> <-0.318, 0.069, -0.470> 
		<-0.250, 0.087, -0.481> <-0.250, 0.080, -0.482> <-0.255, 0.076, -0.492> <-0.256, 0.069, -0.494> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.446, 0.069, -0.378> <-0.448, 0.060, -0.380> <-0.450, 0.046, -0.382> <-0.446, 0.039, -0.378> 
		<-0.397, 0.069, -0.423> <-0.399, 0.060, -0.425> <-0.401, 0.046, -0.427> <-0.397, 0.039, -0.423> 
		<-0.318, 0.069, -0.470> <-0.319, 0.060, -0.473> <-0.321, 0.046, -0.475> <-0.318, 0.039, -0.470> 
		<-0.256, 0.069, -0.494> <-0.257, 0.060, -0.496> <-0.258, 0.046, -0.499> <-0.256, 0.039, -0.494> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.446, 0.039, -0.378> <-0.440, 0.028, -0.372> <-0.426, 0.018, -0.360> <-0.416, 0.017, -0.350> 
		<-0.397, 0.039, -0.423> <-0.390, 0.028, -0.417> <-0.380, 0.018, -0.402> <-0.370, 0.017, -0.392> 
		<-0.318, 0.039, -0.470> <-0.315, 0.028, -0.463> <-0.303, 0.018, -0.448> <-0.297, 0.017, -0.436> 
		<-0.256, 0.039, -0.494> <-0.252, 0.028, -0.486> <-0.245, 0.018, -0.470> <-0.240, 0.017, -0.458> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.416, 0.017, -0.350> <-0.379, 0.011, -0.317> <-0.331, 0.017, -0.273> <-0.294, 0.017, -0.240> 
		<-0.370, 0.017, -0.392> <-0.334, 0.011, -0.359> <-0.299, 0.017, -0.301> <-0.263, 0.017, -0.268> 
		<-0.297, 0.017, -0.436> <-0.278, 0.011, -0.393> <-0.233, 0.017, -0.341> <-0.213, 0.017, -0.298> 
		<-0.240, 0.017, -0.458> <-0.220, 0.011, -0.415> <-0.193, 0.017, -0.356> <-0.174, 0.017, -0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.472, 0.387, -0.167> <-0.486, 0.392, -0.172> <-0.503, 0.402, -0.178> <-0.517, 0.405, -0.183> 
		<-0.450, 0.387, -0.214> <-0.464, 0.392, -0.219> <-0.479, 0.402, -0.231> <-0.493, 0.405, -0.236> 
		<-0.408, 0.387, -0.272> <-0.418, 0.392, -0.282> <-0.435, 0.402, -0.290> <-0.446, 0.405, -0.300> 
		<-0.369, 0.387, -0.308> <-0.379, 0.392, -0.317> <-0.392, 0.402, -0.329> <-0.403, 0.405, -0.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.517, 0.405, -0.183> <-0.527, 0.406, -0.187> <-0.547, 0.407, -0.195> <-0.550, 0.401, -0.196> 
		<-0.493, 0.405, -0.236> <-0.503, 0.406, -0.240> <-0.522, 0.407, -0.251> <-0.524, 0.401, -0.252> 
		<-0.446, 0.405, -0.300> <-0.453, 0.406, -0.307> <-0.472, 0.407, -0.319> <-0.474, 0.401, -0.320> 
		<-0.403, 0.405, -0.339> <-0.410, 0.406, -0.346> <-0.426, 0.407, -0.360> <-0.428, 0.401, -0.362> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.550, 0.401, -0.196> <-0.556, 0.385, -0.198> <-0.556, 0.339, -0.198> <-0.554, 0.312, -0.197> 
		<-0.524, 0.401, -0.252> <-0.531, 0.385, -0.254> <-0.531, 0.339, -0.255> <-0.528, 0.312, -0.254> 
		<-0.474, 0.401, -0.320> <-0.479, 0.385, -0.325> <-0.479, 0.339, -0.324> <-0.477, 0.312, -0.323> 
		<-0.428, 0.401, -0.362> <-0.433, 0.385, -0.366> <-0.433, 0.339, -0.366> <-0.431, 0.312, -0.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.554, 0.312, -0.197> <-0.553, 0.308, -0.197> <-0.541, 0.311, -0.192> <-0.541, 0.307, -0.193> 
		<-0.528, 0.312, -0.254> <-0.528, 0.308, -0.254> <-0.516, 0.311, -0.248> <-0.516, 0.307, -0.248> 
		<-0.477, 0.312, -0.323> <-0.477, 0.308, -0.323> <-0.466, 0.311, -0.315> <-0.467, 0.307, -0.315> 
		<-0.431, 0.312, -0.365> <-0.431, 0.308, -0.364> <-0.421, 0.311, -0.356> <-0.422, 0.307, -0.356> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.541, 0.307, -0.193> <-0.542, 0.296, -0.193> <-0.557, 0.284, -0.198> <-0.558, 0.273, -0.199> 
		<-0.516, 0.307, -0.248> <-0.517, 0.296, -0.248> <-0.531, 0.284, -0.256> <-0.532, 0.273, -0.256> 
		<-0.467, 0.307, -0.315> <-0.467, 0.296, -0.316> <-0.480, 0.284, -0.324> <-0.481, 0.273, -0.325> 
		<-0.422, 0.307, -0.356> <-0.423, 0.296, -0.357> <-0.433, 0.284, -0.367> <-0.434, 0.273, -0.368> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.558, 0.273, -0.199> <-0.561, 0.251, -0.200> <-0.559, 0.220, -0.199> <-0.554, 0.198, -0.197> 
		<-0.532, 0.273, -0.256> <-0.535, 0.251, -0.257> <-0.533, 0.220, -0.256> <-0.528, 0.198, -0.254> 
		<-0.481, 0.273, -0.325> <-0.483, 0.251, -0.327> <-0.481, 0.220, -0.326> <-0.477, 0.198, -0.323> 
		<-0.434, 0.273, -0.368> <-0.436, 0.251, -0.369> <-0.435, 0.220, -0.368> <-0.431, 0.198, -0.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.554, 0.198, -0.197> <-0.553, 0.194, -0.197> <-0.539, 0.198, -0.192> <-0.539, 0.193, -0.192> 
		<-0.528, 0.198, -0.254> <-0.527, 0.194, -0.254> <-0.514, 0.198, -0.247> <-0.514, 0.193, -0.247> 
		<-0.477, 0.198, -0.323> <-0.476, 0.194, -0.322> <-0.464, 0.198, -0.313> <-0.465, 0.193, -0.314> 
		<-0.431, 0.198, -0.365> <-0.431, 0.194, -0.364> <-0.420, 0.198, -0.354> <-0.420, 0.193, -0.355> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.539, 0.193, -0.192> <-0.541, 0.183, -0.192> <-0.556, 0.175, -0.198> <-0.558, 0.164, -0.199> 
		<-0.514, 0.193, -0.247> <-0.516, 0.183, -0.247> <-0.530, 0.175, -0.255> <-0.532, 0.164, -0.256> 
		<-0.465, 0.193, -0.314> <-0.466, 0.183, -0.315> <-0.480, 0.175, -0.324> <-0.481, 0.164, -0.325> 
		<-0.420, 0.193, -0.355> <-0.421, 0.183, -0.355> <-0.433, 0.175, -0.366> <-0.435, 0.164, -0.368> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.558, 0.164, -0.199> <-0.562, 0.142, -0.201> <-0.555, 0.110, -0.198> <-0.558, 0.087, -0.199> 
		<-0.532, 0.164, -0.256> <-0.536, 0.142, -0.258> <-0.529, 0.110, -0.255> <-0.532, 0.087, -0.256> 
		<-0.481, 0.164, -0.325> <-0.484, 0.142, -0.328> <-0.478, 0.110, -0.323> <-0.481, 0.087, -0.325> 
		<-0.435, 0.164, -0.368> <-0.438, 0.142, -0.371> <-0.432, 0.110, -0.365> <-0.435, 0.087, -0.368> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.558, 0.087, -0.199> <-0.559, 0.080, -0.199> <-0.571, 0.076, -0.204> <-0.573, 0.069, -0.205> 
		<-0.532, 0.087, -0.256> <-0.533, 0.080, -0.257> <-0.544, 0.076, -0.263> <-0.546, 0.069, -0.263> 
		<-0.481, 0.087, -0.325> <-0.482, 0.080, -0.326> <-0.492, 0.076, -0.333> <-0.494, 0.069, -0.335> 
		<-0.435, 0.087, -0.368> <-0.436, 0.080, -0.369> <-0.444, 0.076, -0.377> <-0.446, 0.069, -0.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.573, 0.069, -0.205> <-0.576, 0.060, -0.206> <-0.578, 0.046, -0.207> <-0.573, 0.039, -0.205> 
		<-0.546, 0.069, -0.263> <-0.549, 0.060, -0.264> <-0.551, 0.046, -0.265> <-0.546, 0.039, -0.263> 
		<-0.494, 0.069, -0.335> <-0.496, 0.060, -0.336> <-0.498, 0.046, -0.338> <-0.493, 0.039, -0.335> 
		<-0.446, 0.069, -0.378> <-0.448, 0.060, -0.380> <-0.450, 0.046, -0.382> <-0.446, 0.039, -0.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.573, 0.039, -0.205> <-0.564, 0.028, -0.201> <-0.547, 0.018, -0.195> <-0.533, 0.017, -0.190> 
		<-0.546, 0.039, -0.263> <-0.538, 0.028, -0.260> <-0.522, 0.018, -0.249> <-0.509, 0.017, -0.244> 
		<-0.493, 0.039, -0.335> <-0.487, 0.028, -0.329> <-0.470, 0.018, -0.320> <-0.460, 0.017, -0.310> 
		<-0.446, 0.039, -0.378> <-0.440, 0.028, -0.372> <-0.426, 0.018, -0.360> <-0.416, 0.017, -0.350> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.533, 0.017, -0.190> <-0.486, 0.011, -0.172> <-0.422, 0.017, -0.148> <-0.375, 0.017, -0.130> 
		<-0.509, 0.017, -0.244> <-0.461, 0.011, -0.226> <-0.405, 0.017, -0.185> <-0.358, 0.017, -0.167> 
		<-0.460, 0.017, -0.310> <-0.424, 0.011, -0.277> <-0.361, 0.017, -0.245> <-0.324, 0.017, -0.212> 
		<-0.416, 0.017, -0.350> <-0.379, 0.011, -0.317> <-0.331, 0.017, -0.273> <-0.294, 0.017, -0.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.508, 0.387, 0.000> <-0.523, 0.392, 0.000> <-0.542, 0.402, 0.000> <-0.557, 0.405, 0.000> 
		<-0.508, 0.387, -0.051> <-0.523, 0.392, -0.051> <-0.542, 0.402, -0.056> <-0.557, 0.405, -0.056> 
		<-0.493, 0.387, -0.120> <-0.507, 0.392, -0.125> <-0.526, 0.402, -0.127> <-0.540, 0.405, -0.132> 
		<-0.472, 0.387, -0.167> <-0.486, 0.392, -0.172> <-0.503, 0.402, -0.178> <-0.517, 0.405, -0.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.557, 0.405, 0.000> <-0.567, 0.406, 0.000> <-0.590, 0.407, 0.000> <-0.592, 0.401, 0.000> 
		<-0.557, 0.405, -0.056> <-0.567, 0.406, -0.056> <-0.590, 0.407, -0.060> <-0.592, 0.401, -0.060> 
		<-0.540, 0.405, -0.132> <-0.550, 0.406, -0.136> <-0.572, 0.407, -0.140> <-0.575, 0.401, -0.141> 
		<-0.517, 0.405, -0.183> <-0.527, 0.406, -0.187> <-0.547, 0.407, -0.195> <-0.550, 0.401, -0.196> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.592, 0.401, 0.000> <-0.599, 0.385, 0.000> <-0.599, 0.339, 0.000> <-0.597, 0.312, 0.000> 
		<-0.592, 0.401, -0.060> <-0.599, 0.385, -0.060> <-0.599, 0.339, -0.061> <-0.597, 0.312, -0.061> 
		<-0.575, 0.401, -0.141> <-0.581, 0.385, -0.144> <-0.581, 0.339, -0.143> <-0.579, 0.312, -0.142> 
		<-0.550, 0.401, -0.196> <-0.556, 0.385, -0.198> <-0.556, 0.339, -0.198> <-0.554, 0.312, -0.197> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.597, 0.312, 0.000> <-0.596, 0.308, 0.000> <-0.583, 0.311, 0.000> <-0.583, 0.307, 0.000> 
		<-0.597, 0.312, -0.061> <-0.596, 0.308, -0.061> <-0.583, 0.311, -0.059> <-0.583, 0.307, -0.059> 
		<-0.579, 0.312, -0.142> <-0.579, 0.308, -0.142> <-0.565, 0.311, -0.139> <-0.566, 0.307, -0.139> 
		<-0.554, 0.312, -0.197> <-0.553, 0.308, -0.197> <-0.541, 0.311, -0.192> <-0.541, 0.307, -0.193> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.583, 0.307, 0.000> <-0.585, 0.295, 0.000> <-0.600, 0.284, 0.000> <-0.601, 0.273, 0.000> 
		<-0.583, 0.307, -0.059> <-0.585, 0.295, -0.059> <-0.600, 0.284, -0.061> <-0.601, 0.273, -0.061> 
		<-0.566, 0.307, -0.139> <-0.567, 0.296, -0.139> <-0.582, 0.284, -0.143> <-0.583, 0.273, -0.143> 
		<-0.541, 0.307, -0.193> <-0.542, 0.296, -0.193> <-0.557, 0.284, -0.198> <-0.558, 0.273, -0.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.601, 0.273, 0.000> <-0.604, 0.251, 0.000> <-0.602, 0.220, 0.000> <-0.597, 0.198, 0.000> 
		<-0.601, 0.273, -0.061> <-0.604, 0.251, -0.061> <-0.602, 0.220, -0.061> <-0.597, 0.198, -0.061> 
		<-0.583, 0.273, -0.143> <-0.586, 0.251, -0.144> <-0.584, 0.220, -0.144> <-0.579, 0.198, -0.142> 
		<-0.558, 0.273, -0.199> <-0.561, 0.251, -0.200> <-0.559, 0.220, -0.199> <-0.554, 0.198, -0.197> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.597, 0.198, 0.000> <-0.596, 0.193, 0.000> <-0.580, 0.198, 0.000> <-0.581, 0.193, 0.000> 
		<-0.597, 0.198, -0.061> <-0.596, 0.193, -0.061> <-0.580, 0.198, -0.059> <-0.581, 0.193, -0.059> 
		<-0.579, 0.198, -0.142> <-0.578, 0.194, -0.142> <-0.563, 0.198, -0.138> <-0.564, 0.193, -0.138> 
		<-0.554, 0.198, -0.197> <-0.553, 0.194, -0.197> <-0.539, 0.198, -0.192> <-0.539, 0.193, -0.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.581, 0.193, 0.000> <-0.583, 0.183, 0.000> <-0.600, 0.175, 0.000> <-0.602, 0.164, 0.000> 
		<-0.581, 0.193, -0.059> <-0.583, 0.183, -0.059> <-0.600, 0.175, -0.061> <-0.602, 0.164, -0.061> 
		<-0.564, 0.193, -0.138> <-0.565, 0.183, -0.139> <-0.582, 0.175, -0.143> <-0.583, 0.164, -0.143> 
		<-0.539, 0.193, -0.192> <-0.541, 0.183, -0.192> <-0.556, 0.175, -0.198> <-0.558, 0.164, -0.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.602, 0.164, 0.000> <-0.606, 0.142, 0.000> <-0.598, 0.110, 0.000> <-0.602, 0.087, 0.000> 
		<-0.602, 0.164, -0.061> <-0.606, 0.142, -0.061> <-0.598, 0.110, -0.061> <-0.602, 0.087, -0.061> 
		<-0.583, 0.164, -0.143> <-0.588, 0.142, -0.145> <-0.580, 0.110, -0.142> <-0.583, 0.087, -0.143> 
		<-0.558, 0.164, -0.199> <-0.562, 0.142, -0.201> <-0.555, 0.110, -0.198> <-0.558, 0.087, -0.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.602, 0.087, 0.000> <-0.603, 0.080, 0.000> <-0.615, 0.076, 0.000> <-0.618, 0.069, 0.000> 
		<-0.602, 0.087, -0.061> <-0.603, 0.080, -0.061> <-0.615, 0.076, -0.063> <-0.618, 0.069, -0.063> 
		<-0.583, 0.087, -0.143> <-0.585, 0.080, -0.144> <-0.597, 0.076, -0.147> <-0.599, 0.069, -0.147> 
		<-0.558, 0.087, -0.199> <-0.559, 0.080, -0.199> <-0.571, 0.076, -0.204> <-0.573, 0.069, -0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.618, 0.069, 0.000> <-0.620, 0.060, 0.000> <-0.623, 0.046, 0.000> <-0.617, 0.039, 0.000> 
		<-0.618, 0.069, -0.063> <-0.620, 0.060, -0.063> <-0.623, 0.046, -0.063> <-0.617, 0.039, -0.063> 
		<-0.599, 0.069, -0.147> <-0.601, 0.060, -0.148> <-0.604, 0.046, -0.149> <-0.599, 0.039, -0.147> 
		<-0.573, 0.069, -0.205> <-0.576, 0.060, -0.206> <-0.578, 0.046, -0.207> <-0.573, 0.039, -0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.617, 0.039, 0.000> <-0.608, 0.028, 0.000> <-0.589, 0.018, 0.000> <-0.575, 0.017, 0.000> 
		<-0.617, 0.039, -0.063> <-0.608, 0.028, -0.063> <-0.589, 0.018, -0.058> <-0.575, 0.017, -0.058> 
		<-0.599, 0.039, -0.147> <-0.590, 0.028, -0.144> <-0.571, 0.018, -0.142> <-0.557, 0.017, -0.137> 
		<-0.573, 0.039, -0.205> <-0.564, 0.028, -0.201> <-0.547, 0.018, -0.195> <-0.533, 0.017, -0.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.575, 0.017, 0.000> <-0.523, 0.011, 0.000> <-0.454, 0.017, 0.000> <-0.403, 0.017, 0.000> 
		<-0.575, 0.017, -0.058> <-0.523, 0.011, -0.058> <-0.454, 0.017, -0.040> <-0.403, 0.017, -0.040> 
		<-0.557, 0.017, -0.137> <-0.510, 0.011, -0.119> <-0.439, 0.017, -0.111> <-0.391, 0.017, -0.093> 
		<-0.533, 0.017, -0.190> <-0.486, 0.011, -0.172> <-0.422, 0.017, -0.148> <-0.375, 0.017, -0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.472, 0.387, 0.167> <-0.486, 0.392, 0.172> <-0.503, 0.402, 0.178> <-0.517, 0.405, 0.183> 
		<-0.493, 0.387, 0.120> <-0.507, 0.392, 0.125> <-0.526, 0.402, 0.127> <-0.540, 0.405, 0.132> 
		<-0.508, 0.387, 0.051> <-0.523, 0.392, 0.051> <-0.542, 0.402, 0.056> <-0.557, 0.405, 0.056> 
		<-0.508, 0.387, 0.000> <-0.523, 0.392, 0.000> <-0.542, 0.402, 0.000> <-0.557, 0.405, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.517, 0.405, 0.183> <-0.527, 0.406, 0.187> <-0.547, 0.407, 0.195> <-0.550, 0.401, 0.196> 
		<-0.540, 0.405, 0.132> <-0.550, 0.406, 0.136> <-0.572, 0.407, 0.140> <-0.575, 0.401, 0.141> 
		<-0.557, 0.405, 0.056> <-0.567, 0.406, 0.056> <-0.590, 0.407, 0.060> <-0.592, 0.401, 0.060> 
		<-0.557, 0.405, 0.000> <-0.567, 0.406, 0.000> <-0.590, 0.407, 0.000> <-0.592, 0.401, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.550, 0.401, 0.196> <-0.556, 0.385, 0.198> <-0.556, 0.339, 0.198> <-0.554, 0.312, 0.197> 
		<-0.575, 0.401, 0.141> <-0.581, 0.385, 0.144> <-0.581, 0.339, 0.143> <-0.579, 0.312, 0.142> 
		<-0.592, 0.401, 0.060> <-0.599, 0.385, 0.060> <-0.599, 0.339, 0.061> <-0.597, 0.312, 0.061> 
		<-0.592, 0.401, 0.000> <-0.599, 0.385, 0.000> <-0.599, 0.339, 0.000> <-0.597, 0.312, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.554, 0.312, 0.197> <-0.553, 0.308, 0.197> <-0.541, 0.311, 0.192> <-0.541, 0.307, 0.193> 
		<-0.579, 0.312, 0.142> <-0.579, 0.308, 0.142> <-0.565, 0.311, 0.139> <-0.566, 0.307, 0.139> 
		<-0.597, 0.312, 0.061> <-0.596, 0.308, 0.061> <-0.583, 0.311, 0.059> <-0.583, 0.307, 0.059> 
		<-0.597, 0.312, 0.000> <-0.596, 0.308, 0.000> <-0.583, 0.311, 0.000> <-0.583, 0.307, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.541, 0.307, 0.193> <-0.542, 0.296, 0.193> <-0.557, 0.284, 0.198> <-0.558, 0.273, 0.199> 
		<-0.566, 0.307, 0.139> <-0.567, 0.296, 0.139> <-0.582, 0.284, 0.143> <-0.583, 0.273, 0.143> 
		<-0.583, 0.307, 0.059> <-0.585, 0.295, 0.059> <-0.600, 0.284, 0.061> <-0.601, 0.273, 0.061> 
		<-0.583, 0.307, 0.000> <-0.585, 0.295, 0.000> <-0.600, 0.284, 0.000> <-0.601, 0.273, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.558, 0.273, 0.199> <-0.561, 0.251, 0.200> <-0.559, 0.220, 0.199> <-0.554, 0.198, 0.197> 
		<-0.583, 0.273, 0.143> <-0.586, 0.251, 0.144> <-0.584, 0.220, 0.144> <-0.579, 0.198, 0.142> 
		<-0.601, 0.273, 0.061> <-0.604, 0.251, 0.061> <-0.602, 0.220, 0.061> <-0.597, 0.198, 0.061> 
		<-0.601, 0.273, 0.000> <-0.604, 0.251, 0.000> <-0.602, 0.220, 0.000> <-0.597, 0.198, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.554, 0.198, 0.197> <-0.553, 0.194, 0.197> <-0.539, 0.198, 0.192> <-0.539, 0.193, 0.192> 
		<-0.579, 0.198, 0.142> <-0.578, 0.194, 0.142> <-0.563, 0.198, 0.138> <-0.564, 0.193, 0.138> 
		<-0.597, 0.198, 0.061> <-0.596, 0.193, 0.061> <-0.580, 0.198, 0.059> <-0.581, 0.193, 0.059> 
		<-0.597, 0.198, 0.000> <-0.596, 0.193, 0.000> <-0.580, 0.198, 0.000> <-0.581, 0.193, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.539, 0.193, 0.192> <-0.541, 0.183, 0.192> <-0.556, 0.175, 0.198> <-0.558, 0.164, 0.199> 
		<-0.564, 0.193, 0.138> <-0.565, 0.183, 0.139> <-0.582, 0.175, 0.143> <-0.583, 0.164, 0.143> 
		<-0.581, 0.193, 0.059> <-0.583, 0.183, 0.059> <-0.600, 0.175, 0.061> <-0.602, 0.164, 0.061> 
		<-0.581, 0.193, 0.000> <-0.583, 0.183, 0.000> <-0.600, 0.175, 0.000> <-0.602, 0.164, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.558, 0.164, 0.199> <-0.562, 0.142, 0.201> <-0.555, 0.110, 0.198> <-0.558, 0.087, 0.199> 
		<-0.583, 0.164, 0.143> <-0.588, 0.142, 0.145> <-0.580, 0.110, 0.142> <-0.583, 0.087, 0.143> 
		<-0.602, 0.164, 0.061> <-0.606, 0.142, 0.061> <-0.598, 0.110, 0.061> <-0.602, 0.087, 0.061> 
		<-0.602, 0.164, 0.000> <-0.606, 0.142, 0.000> <-0.598, 0.110, 0.000> <-0.602, 0.087, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.558, 0.087, 0.199> <-0.559, 0.080, 0.199> <-0.571, 0.076, 0.204> <-0.573, 0.069, 0.205> 
		<-0.583, 0.087, 0.143> <-0.585, 0.080, 0.144> <-0.597, 0.076, 0.147> <-0.599, 0.069, 0.147> 
		<-0.602, 0.087, 0.061> <-0.603, 0.080, 0.061> <-0.615, 0.076, 0.063> <-0.618, 0.069, 0.063> 
		<-0.602, 0.087, 0.000> <-0.603, 0.080, 0.000> <-0.615, 0.076, 0.000> <-0.618, 0.069, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.573, 0.069, 0.205> <-0.576, 0.060, 0.206> <-0.578, 0.046, 0.207> <-0.573, 0.039, 0.205> 
		<-0.599, 0.069, 0.147> <-0.601, 0.060, 0.148> <-0.604, 0.046, 0.149> <-0.599, 0.039, 0.147> 
		<-0.618, 0.069, 0.063> <-0.620, 0.060, 0.063> <-0.623, 0.046, 0.063> <-0.617, 0.039, 0.063> 
		<-0.618, 0.069, 0.000> <-0.620, 0.060, 0.000> <-0.623, 0.046, 0.000> <-0.617, 0.039, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.573, 0.039, 0.205> <-0.564, 0.028, 0.201> <-0.547, 0.018, 0.195> <-0.533, 0.017, 0.190> 
		<-0.599, 0.039, 0.147> <-0.590, 0.028, 0.144> <-0.571, 0.018, 0.142> <-0.557, 0.017, 0.137> 
		<-0.617, 0.039, 0.063> <-0.608, 0.028, 0.063> <-0.589, 0.018, 0.058> <-0.575, 0.017, 0.058> 
		<-0.617, 0.039, 0.000> <-0.608, 0.028, 0.000> <-0.589, 0.018, 0.000> <-0.575, 0.017, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.533, 0.017, 0.190> <-0.486, 0.011, 0.172> <-0.422, 0.017, 0.148> <-0.375, 0.017, 0.130> 
		<-0.557, 0.017, 0.137> <-0.510, 0.011, 0.119> <-0.439, 0.017, 0.111> <-0.391, 0.017, 0.093> 
		<-0.575, 0.017, 0.058> <-0.523, 0.011, 0.058> <-0.454, 0.017, 0.040> <-0.403, 0.017, 0.040> 
		<-0.575, 0.017, 0.000> <-0.523, 0.011, 0.000> <-0.454, 0.017, 0.000> <-0.403, 0.017, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.369, 0.387, 0.308> <-0.379, 0.392, 0.317> <-0.392, 0.402, 0.329> <-0.403, 0.405, 0.339> 
		<-0.408, 0.387, 0.272> <-0.418, 0.392, 0.282> <-0.435, 0.402, 0.290> <-0.446, 0.405, 0.300> 
		<-0.450, 0.387, 0.214> <-0.464, 0.392, 0.219> <-0.479, 0.402, 0.231> <-0.493, 0.405, 0.236> 
		<-0.472, 0.387, 0.167> <-0.486, 0.392, 0.172> <-0.503, 0.402, 0.178> <-0.517, 0.405, 0.183> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.403, 0.405, 0.339> <-0.410, 0.406, 0.346> <-0.426, 0.407, 0.360> <-0.428, 0.401, 0.362> 
		<-0.446, 0.405, 0.300> <-0.453, 0.406, 0.307> <-0.472, 0.407, 0.319> <-0.474, 0.401, 0.320> 
		<-0.493, 0.405, 0.236> <-0.503, 0.406, 0.240> <-0.522, 0.407, 0.251> <-0.524, 0.401, 0.252> 
		<-0.517, 0.405, 0.183> <-0.527, 0.406, 0.187> <-0.547, 0.407, 0.195> <-0.550, 0.401, 0.196> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.428, 0.401, 0.362> <-0.433, 0.385, 0.366> <-0.433, 0.339, 0.366> <-0.431, 0.312, 0.365> 
		<-0.474, 0.401, 0.320> <-0.479, 0.385, 0.325> <-0.479, 0.339, 0.324> <-0.477, 0.312, 0.323> 
		<-0.524, 0.401, 0.252> <-0.531, 0.385, 0.254> <-0.531, 0.339, 0.255> <-0.528, 0.312, 0.254> 
		<-0.550, 0.401, 0.196> <-0.556, 0.385, 0.198> <-0.556, 0.339, 0.198> <-0.554, 0.312, 0.197> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.431, 0.312, 0.365> <-0.431, 0.308, 0.364> <-0.421, 0.311, 0.356> <-0.422, 0.307, 0.356> 
		<-0.477, 0.312, 0.323> <-0.477, 0.308, 0.323> <-0.466, 0.311, 0.315> <-0.467, 0.307, 0.315> 
		<-0.528, 0.312, 0.254> <-0.528, 0.308, 0.254> <-0.516, 0.311, 0.248> <-0.516, 0.307, 0.248> 
		<-0.554, 0.312, 0.197> <-0.553, 0.308, 0.197> <-0.541, 0.311, 0.192> <-0.541, 0.307, 0.193> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.422, 0.307, 0.356> <-0.423, 0.296, 0.357> <-0.433, 0.284, 0.367> <-0.434, 0.273, 0.368> 
		<-0.467, 0.307, 0.315> <-0.467, 0.296, 0.316> <-0.480, 0.284, 0.324> <-0.481, 0.273, 0.325> 
		<-0.516, 0.307, 0.248> <-0.517, 0.296, 0.248> <-0.531, 0.284, 0.256> <-0.532, 0.273, 0.256> 
		<-0.541, 0.307, 0.193> <-0.542, 0.296, 0.193> <-0.557, 0.284, 0.198> <-0.558, 0.273, 0.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.434, 0.273, 0.368> <-0.436, 0.251, 0.369> <-0.435, 0.220, 0.368> <-0.431, 0.198, 0.365> 
		<-0.481, 0.273, 0.325> <-0.483, 0.251, 0.327> <-0.481, 0.220, 0.326> <-0.477, 0.198, 0.323> 
		<-0.532, 0.273, 0.256> <-0.535, 0.251, 0.257> <-0.533, 0.220, 0.256> <-0.528, 0.198, 0.254> 
		<-0.558, 0.273, 0.199> <-0.561, 0.251, 0.200> <-0.559, 0.220, 0.199> <-0.554, 0.198, 0.197> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.431, 0.198, 0.365> <-0.431, 0.194, 0.364> <-0.420, 0.198, 0.354> <-0.420, 0.193, 0.355> 
		<-0.477, 0.198, 0.323> <-0.476, 0.194, 0.322> <-0.464, 0.198, 0.313> <-0.465, 0.193, 0.314> 
		<-0.528, 0.198, 0.254> <-0.527, 0.194, 0.254> <-0.514, 0.198, 0.247> <-0.514, 0.193, 0.247> 
		<-0.554, 0.198, 0.197> <-0.553, 0.194, 0.197> <-0.539, 0.198, 0.192> <-0.539, 0.193, 0.192> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.420, 0.193, 0.355> <-0.421, 0.183, 0.355> <-0.433, 0.175, 0.366> <-0.435, 0.164, 0.368> 
		<-0.465, 0.193, 0.314> <-0.466, 0.183, 0.315> <-0.480, 0.175, 0.324> <-0.481, 0.164, 0.325> 
		<-0.514, 0.193, 0.247> <-0.516, 0.183, 0.247> <-0.530, 0.175, 0.255> <-0.532, 0.164, 0.256> 
		<-0.539, 0.193, 0.192> <-0.541, 0.183, 0.192> <-0.556, 0.175, 0.198> <-0.558, 0.164, 0.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 0.164, 0.368> <-0.438, 0.142, 0.371> <-0.432, 0.110, 0.365> <-0.435, 0.087, 0.368> 
		<-0.481, 0.164, 0.325> <-0.484, 0.142, 0.328> <-0.478, 0.110, 0.323> <-0.481, 0.087, 0.325> 
		<-0.532, 0.164, 0.256> <-0.536, 0.142, 0.258> <-0.529, 0.110, 0.255> <-0.532, 0.087, 0.256> 
		<-0.558, 0.164, 0.199> <-0.562, 0.142, 0.201> <-0.555, 0.110, 0.198> <-0.558, 0.087, 0.199> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.435, 0.087, 0.368> <-0.436, 0.080, 0.369> <-0.444, 0.076, 0.377> <-0.446, 0.069, 0.378> 
		<-0.481, 0.087, 0.325> <-0.482, 0.080, 0.326> <-0.492, 0.076, 0.333> <-0.494, 0.069, 0.335> 
		<-0.532, 0.087, 0.256> <-0.533, 0.080, 0.257> <-0.544, 0.076, 0.263> <-0.546, 0.069, 0.263> 
		<-0.558, 0.087, 0.199> <-0.559, 0.080, 0.199> <-0.571, 0.076, 0.204> <-0.573, 0.069, 0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.446, 0.069, 0.378> <-0.448, 0.060, 0.380> <-0.450, 0.046, 0.382> <-0.446, 0.039, 0.378> 
		<-0.494, 0.069, 0.335> <-0.496, 0.060, 0.336> <-0.498, 0.046, 0.338> <-0.493, 0.039, 0.335> 
		<-0.546, 0.069, 0.263> <-0.549, 0.060, 0.264> <-0.551, 0.046, 0.265> <-0.546, 0.039, 0.263> 
		<-0.573, 0.069, 0.205> <-0.576, 0.060, 0.206> <-0.578, 0.046, 0.207> <-0.573, 0.039, 0.205> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.446, 0.039, 0.378> <-0.440, 0.028, 0.372> <-0.426, 0.018, 0.360> <-0.416, 0.017, 0.350> 
		<-0.493, 0.039, 0.335> <-0.487, 0.028, 0.329> <-0.470, 0.018, 0.320> <-0.460, 0.017, 0.310> 
		<-0.546, 0.039, 0.263> <-0.538, 0.028, 0.260> <-0.522, 0.018, 0.249> <-0.509, 0.017, 0.244> 
		<-0.573, 0.039, 0.205> <-0.564, 0.028, 0.201> <-0.547, 0.018, 0.195> <-0.533, 0.017, 0.190> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.416, 0.017, 0.350> <-0.379, 0.011, 0.317> <-0.331, 0.017, 0.273> <-0.294, 0.017, 0.240> 
		<-0.460, 0.017, 0.310> <-0.424, 0.011, 0.277> <-0.361, 0.017, 0.245> <-0.324, 0.017, 0.212> 
		<-0.509, 0.017, 0.244> <-0.461, 0.011, 0.226> <-0.405, 0.017, 0.185> <-0.358, 0.017, 0.167> 
		<-0.533, 0.017, 0.190> <-0.486, 0.011, 0.172> <-0.422, 0.017, 0.148> <-0.375, 0.017, 0.130> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.214, 0.387, 0.402> <-0.220, 0.392, 0.414> <-0.227, 0.402, 0.430> <-0.233, 0.405, 0.443> 
		<-0.265, 0.387, 0.383> <-0.271, 0.392, 0.395> <-0.283, 0.402, 0.409> <-0.289, 0.405, 0.422> 
		<-0.329, 0.387, 0.344> <-0.339, 0.392, 0.354> <-0.348, 0.402, 0.369> <-0.359, 0.405, 0.379> 
		<-0.369, 0.387, 0.308> <-0.379, 0.392, 0.317> <-0.392, 0.402, 0.329> <-0.403, 0.405, 0.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.233, 0.405, 0.443> <-0.237, 0.406, 0.452> <-0.245, 0.407, 0.471> <-0.246, 0.401, 0.473> 
		<-0.289, 0.405, 0.422> <-0.293, 0.406, 0.431> <-0.305, 0.407, 0.448> <-0.306, 0.401, 0.450> 
		<-0.359, 0.405, 0.379> <-0.366, 0.406, 0.386> <-0.379, 0.407, 0.403> <-0.381, 0.401, 0.405> 
		<-0.403, 0.405, 0.339> <-0.410, 0.406, 0.346> <-0.426, 0.407, 0.360> <-0.428, 0.401, 0.362> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.246, 0.401, 0.473> <-0.249, 0.385, 0.479> <-0.249, 0.339, 0.479> <-0.248, 0.312, 0.477> 
		<-0.306, 0.401, 0.450> <-0.309, 0.385, 0.456> <-0.309, 0.339, 0.456> <-0.308, 0.312, 0.454> 
		<-0.381, 0.401, 0.405> <-0.386, 0.385, 0.409> <-0.386, 0.339, 0.410> <-0.384, 0.312, 0.408> 
		<-0.428, 0.401, 0.362> <-0.433, 0.385, 0.366> <-0.433, 0.339, 0.366> <-0.431, 0.312, 0.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.248, 0.312, 0.477> <-0.248, 0.308, 0.476> <-0.243, 0.311, 0.465> <-0.243, 0.307, 0.465> 
		<-0.308, 0.312, 0.454> <-0.308, 0.308, 0.453> <-0.301, 0.311, 0.442> <-0.302, 0.307, 0.443> 
		<-0.384, 0.312, 0.408> <-0.383, 0.308, 0.408> <-0.375, 0.311, 0.398> <-0.375, 0.307, 0.398> 
		<-0.431, 0.312, 0.365> <-0.431, 0.308, 0.364> <-0.421, 0.311, 0.356> <-0.422, 0.307, 0.356> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.243, 0.307, 0.465> <-0.243, 0.296, 0.466> <-0.249, 0.284, 0.479> <-0.250, 0.273, 0.480> 
		<-0.302, 0.307, 0.443> <-0.302, 0.296, 0.444> <-0.310, 0.284, 0.456> <-0.310, 0.273, 0.457> 
		<-0.375, 0.307, 0.398> <-0.376, 0.296, 0.399> <-0.386, 0.284, 0.410> <-0.387, 0.273, 0.411> 
		<-0.422, 0.307, 0.356> <-0.423, 0.296, 0.357> <-0.433, 0.284, 0.367> <-0.434, 0.273, 0.368> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.250, 0.273, 0.480> <-0.251, 0.251, 0.483> <-0.250, 0.220, 0.481> <-0.248, 0.198, 0.477> 
		<-0.310, 0.273, 0.457> <-0.312, 0.251, 0.460> <-0.310, 0.220, 0.458> <-0.308, 0.198, 0.454> 
		<-0.387, 0.273, 0.411> <-0.389, 0.251, 0.413> <-0.388, 0.220, 0.412> <-0.384, 0.198, 0.408> 
		<-0.434, 0.273, 0.368> <-0.436, 0.251, 0.369> <-0.435, 0.220, 0.368> <-0.431, 0.198, 0.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.248, 0.198, 0.477> <-0.248, 0.194, 0.476> <-0.242, 0.198, 0.463> <-0.242, 0.193, 0.463> 
		<-0.308, 0.198, 0.454> <-0.308, 0.194, 0.453> <-0.300, 0.198, 0.441> <-0.301, 0.193, 0.441> 
		<-0.384, 0.198, 0.408> <-0.383, 0.194, 0.407> <-0.373, 0.198, 0.396> <-0.374, 0.193, 0.397> 
		<-0.431, 0.198, 0.365> <-0.431, 0.194, 0.364> <-0.420, 0.198, 0.354> <-0.420, 0.193, 0.355> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.242, 0.193, 0.463> <-0.242, 0.183, 0.464> <-0.249, 0.175, 0.479> <-0.250, 0.164, 0.481> 
		<-0.301, 0.193, 0.441> <-0.301, 0.183, 0.442> <-0.310, 0.175, 0.456> <-0.311, 0.164, 0.458> 
		<-0.374, 0.193, 0.397> <-0.375, 0.183, 0.398> <-0.385, 0.175, 0.410> <-0.387, 0.164, 0.412> 
		<-0.420, 0.193, 0.355> <-0.421, 0.183, 0.355> <-0.433, 0.175, 0.366> <-0.435, 0.164, 0.368> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.250, 0.164, 0.481> <-0.251, 0.142, 0.484> <-0.248, 0.110, 0.477> <-0.250, 0.087, 0.481> 
		<-0.311, 0.164, 0.458> <-0.312, 0.142, 0.461> <-0.309, 0.110, 0.454> <-0.311, 0.087, 0.458> 
		<-0.387, 0.164, 0.412> <-0.390, 0.142, 0.414> <-0.384, 0.110, 0.409> <-0.387, 0.087, 0.412> 
		<-0.435, 0.164, 0.368> <-0.438, 0.142, 0.371> <-0.432, 0.110, 0.365> <-0.435, 0.087, 0.368> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.250, 0.087, 0.481> <-0.250, 0.080, 0.482> <-0.255, 0.076, 0.492> <-0.256, 0.069, 0.494> 
		<-0.311, 0.087, 0.458> <-0.311, 0.080, 0.459> <-0.318, 0.076, 0.468> <-0.318, 0.069, 0.470> 
		<-0.387, 0.087, 0.412> <-0.388, 0.080, 0.412> <-0.395, 0.076, 0.422> <-0.397, 0.069, 0.423> 
		<-0.435, 0.087, 0.368> <-0.436, 0.080, 0.369> <-0.444, 0.076, 0.377> <-0.446, 0.069, 0.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.256, 0.069, 0.494> <-0.257, 0.060, 0.496> <-0.258, 0.046, 0.499> <-0.256, 0.039, 0.494> 
		<-0.318, 0.069, 0.470> <-0.319, 0.060, 0.473> <-0.321, 0.046, 0.475> <-0.318, 0.039, 0.470> 
		<-0.397, 0.069, 0.423> <-0.399, 0.060, 0.425> <-0.401, 0.046, 0.427> <-0.397, 0.039, 0.423> 
		<-0.446, 0.069, 0.378> <-0.448, 0.060, 0.380> <-0.450, 0.046, 0.382> <-0.446, 0.039, 0.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.256, 0.039, 0.494> <-0.252, 0.028, 0.486> <-0.245, 0.018, 0.470> <-0.240, 0.017, 0.458> 
		<-0.318, 0.039, 0.470> <-0.315, 0.028, 0.463> <-0.303, 0.018, 0.448> <-0.297, 0.017, 0.436> 
		<-0.397, 0.039, 0.423> <-0.390, 0.028, 0.417> <-0.380, 0.018, 0.402> <-0.370, 0.017, 0.392> 
		<-0.446, 0.039, 0.378> <-0.440, 0.028, 0.372> <-0.426, 0.018, 0.360> <-0.416, 0.017, 0.350> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.240, 0.017, 0.458> <-0.220, 0.011, 0.415> <-0.193, 0.017, 0.356> <-0.174, 0.017, 0.313> 
		<-0.297, 0.017, 0.436> <-0.278, 0.011, 0.393> <-0.233, 0.017, 0.341> <-0.213, 0.017, 0.298> 
		<-0.370, 0.017, 0.392> <-0.334, 0.011, 0.359> <-0.299, 0.017, 0.301> <-0.263, 0.017, 0.268> 
		<-0.416, 0.017, 0.350> <-0.379, 0.011, 0.317> <-0.331, 0.017, 0.273> <-0.294, 0.017, 0.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.387, 0.435> <-0.032, 0.392, 0.448> <-0.032, 0.402, 0.465> <-0.032, 0.405, 0.479> 
		<-0.087, 0.387, 0.435> <-0.087, 0.392, 0.448> <-0.093, 0.402, 0.465> <-0.093, 0.405, 0.479> 
		<-0.162, 0.387, 0.422> <-0.168, 0.392, 0.434> <-0.169, 0.402, 0.451> <-0.175, 0.405, 0.464> 
		<-0.214, 0.387, 0.402> <-0.220, 0.392, 0.414> <-0.227, 0.402, 0.430> <-0.233, 0.405, 0.443> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.405, 0.479> <-0.032, 0.406, 0.489> <-0.032, 0.407, 0.509> <-0.032, 0.401, 0.512> 
		<-0.093, 0.405, 0.479> <-0.093, 0.406, 0.489> <-0.097, 0.407, 0.509> <-0.097, 0.401, 0.512> 
		<-0.175, 0.405, 0.464> <-0.179, 0.406, 0.473> <-0.184, 0.407, 0.494> <-0.185, 0.401, 0.496> 
		<-0.233, 0.405, 0.443> <-0.237, 0.406, 0.452> <-0.245, 0.407, 0.471> <-0.246, 0.401, 0.473> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.401, 0.512> <-0.032, 0.385, 0.518> <-0.032, 0.339, 0.518> <-0.032, 0.312, 0.516> 
		<-0.097, 0.401, 0.512> <-0.097, 0.385, 0.518> <-0.098, 0.339, 0.518> <-0.098, 0.312, 0.516> 
		<-0.185, 0.401, 0.496> <-0.188, 0.385, 0.502> <-0.187, 0.339, 0.502> <-0.186, 0.312, 0.500> 
		<-0.246, 0.401, 0.473> <-0.249, 0.385, 0.479> <-0.249, 0.339, 0.479> <-0.248, 0.312, 0.477> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.312, 0.516> <-0.032, 0.308, 0.515> <-0.032, 0.311, 0.503> <-0.032, 0.307, 0.503> 
		<-0.098, 0.312, 0.516> <-0.098, 0.308, 0.515> <-0.096, 0.311, 0.503> <-0.096, 0.307, 0.503> 
		<-0.186, 0.312, 0.500> <-0.186, 0.308, 0.500> <-0.182, 0.311, 0.487> <-0.183, 0.307, 0.488> 
		<-0.248, 0.312, 0.477> <-0.248, 0.308, 0.476> <-0.243, 0.311, 0.465> <-0.243, 0.307, 0.465> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.307, 0.503> <-0.032, 0.296, 0.505> <-0.032, 0.284, 0.519> <-0.032, 0.273, 0.520> 
		<-0.096, 0.307, 0.503> <-0.096, 0.296, 0.505> <-0.098, 0.284, 0.519> <-0.098, 0.273, 0.520> 
		<-0.183, 0.307, 0.488> <-0.183, 0.296, 0.489> <-0.187, 0.284, 0.503> <-0.188, 0.273, 0.504> 
		<-0.243, 0.307, 0.465> <-0.243, 0.296, 0.466> <-0.249, 0.284, 0.479> <-0.250, 0.273, 0.480> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.273, 0.520> <-0.032, 0.251, 0.522> <-0.032, 0.220, 0.521> <-0.032, 0.198, 0.516> 
		<-0.098, 0.273, 0.520> <-0.098, 0.251, 0.522> <-0.098, 0.220, 0.521> <-0.098, 0.198, 0.516> 
		<-0.188, 0.273, 0.504> <-0.189, 0.251, 0.506> <-0.188, 0.220, 0.505> <-0.186, 0.198, 0.500> 
		<-0.250, 0.273, 0.480> <-0.251, 0.251, 0.483> <-0.250, 0.220, 0.481> <-0.248, 0.198, 0.477> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.198, 0.516> <-0.032, 0.194, 0.515> <-0.032, 0.198, 0.501> <-0.032, 0.193, 0.501> 
		<-0.098, 0.198, 0.516> <-0.098, 0.194, 0.515> <-0.096, 0.198, 0.501> <-0.096, 0.193, 0.501> 
		<-0.186, 0.198, 0.500> <-0.186, 0.194, 0.499> <-0.182, 0.198, 0.485> <-0.182, 0.193, 0.486> 
		<-0.248, 0.198, 0.477> <-0.248, 0.194, 0.476> <-0.242, 0.198, 0.463> <-0.242, 0.193, 0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.193, 0.501> <-0.032, 0.183, 0.503> <-0.032, 0.175, 0.518> <-0.032, 0.164, 0.520> 
		<-0.096, 0.193, 0.501> <-0.096, 0.183, 0.503> <-0.098, 0.175, 0.518> <-0.098, 0.164, 0.520> 
		<-0.182, 0.193, 0.486> <-0.183, 0.183, 0.487> <-0.187, 0.175, 0.502> <-0.188, 0.164, 0.504> 
		<-0.242, 0.193, 0.463> <-0.242, 0.183, 0.464> <-0.249, 0.175, 0.479> <-0.250, 0.164, 0.481> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.164, 0.520> <-0.032, 0.142, 0.524> <-0.032, 0.110, 0.517> <-0.032, 0.087, 0.520> 
		<-0.098, 0.164, 0.520> <-0.098, 0.142, 0.524> <-0.098, 0.110, 0.517> <-0.098, 0.087, 0.520> 
		<-0.188, 0.164, 0.504> <-0.189, 0.142, 0.508> <-0.186, 0.110, 0.501> <-0.188, 0.087, 0.504> 
		<-0.250, 0.164, 0.481> <-0.251, 0.142, 0.484> <-0.248, 0.110, 0.477> <-0.250, 0.087, 0.481> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.087, 0.520> <-0.032, 0.080, 0.521> <-0.032, 0.076, 0.533> <-0.032, 0.069, 0.535> 
		<-0.098, 0.087, 0.520> <-0.098, 0.080, 0.521> <-0.100, 0.076, 0.533> <-0.100, 0.069, 0.535> 
		<-0.188, 0.087, 0.504> <-0.188, 0.080, 0.505> <-0.191, 0.076, 0.516> <-0.192, 0.069, 0.518> 
		<-0.250, 0.087, 0.481> <-0.250, 0.080, 0.482> <-0.255, 0.076, 0.492> <-0.256, 0.069, 0.494> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.069, 0.535> <-0.032, 0.060, 0.537> <-0.032, 0.046, 0.540> <-0.032, 0.039, 0.535> 
		<-0.100, 0.069, 0.535> <-0.100, 0.060, 0.537> <-0.100, 0.046, 0.540> <-0.100, 0.039, 0.535> 
		<-0.192, 0.069, 0.518> <-0.193, 0.060, 0.521> <-0.194, 0.046, 0.523> <-0.192, 0.039, 0.518> 
		<-0.256, 0.069, 0.494> <-0.257, 0.060, 0.496> <-0.258, 0.046, 0.499> <-0.256, 0.039, 0.494> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.039, 0.535> <-0.032, 0.028, 0.527> <-0.032, 0.018, 0.509> <-0.032, 0.017, 0.496> 
		<-0.100, 0.039, 0.535> <-0.100, 0.028, 0.527> <-0.095, 0.018, 0.509> <-0.095, 0.017, 0.496> 
		<-0.192, 0.039, 0.518> <-0.189, 0.028, 0.511> <-0.186, 0.018, 0.493> <-0.180, 0.017, 0.480> 
		<-0.256, 0.039, 0.494> <-0.252, 0.028, 0.486> <-0.245, 0.018, 0.470> <-0.240, 0.017, 0.458> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.017, 0.496> <-0.032, 0.011, 0.449> <-0.032, 0.017, 0.386> <-0.032, 0.017, 0.339> 
		<-0.095, 0.017, 0.496> <-0.095, 0.011, 0.449> <-0.075, 0.017, 0.386> <-0.075, 0.017, 0.339> 
		<-0.180, 0.017, 0.480> <-0.161, 0.011, 0.437> <-0.153, 0.017, 0.372> <-0.133, 0.017, 0.328> 
		<-0.240, 0.017, 0.458> <-0.220, 0.011, 0.415> <-0.193, 0.017, 0.356> <-0.174, 0.017, 0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.151, 0.387, 0.402> <0.156, 0.392, 0.414> <0.163, 0.402, 0.430> <0.169, 0.405, 0.443> 
		<0.099, 0.387, 0.422> <0.104, 0.392, 0.434> <0.106, 0.402, 0.451> <0.112, 0.405, 0.464> 
		<0.024, 0.387, 0.435> <0.024, 0.392, 0.448> <0.030, 0.402, 0.465> <0.030, 0.405, 0.479> 
		<-0.032, 0.387, 0.435> <-0.032, 0.392, 0.448> <-0.032, 0.402, 0.465> <-0.032, 0.405, 0.479> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.169, 0.405, 0.443> <0.173, 0.406, 0.452> <0.182, 0.407, 0.471> <0.183, 0.401, 0.473> 
		<0.112, 0.405, 0.464> <0.116, 0.406, 0.473> <0.121, 0.407, 0.494> <0.122, 0.401, 0.496> 
		<0.030, 0.405, 0.479> <0.030, 0.406, 0.489> <0.034, 0.407, 0.509> <0.034, 0.401, 0.512> 
		<-0.032, 0.405, 0.479> <-0.032, 0.406, 0.489> <-0.032, 0.407, 0.509> <-0.032, 0.401, 0.512> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.183, 0.401, 0.473> <0.186, 0.385, 0.479> <0.186, 0.339, 0.479> <0.185, 0.312, 0.477> 
		<0.122, 0.401, 0.496> <0.124, 0.385, 0.502> <0.124, 0.339, 0.502> <0.123, 0.312, 0.500> 
		<0.034, 0.401, 0.512> <0.034, 0.385, 0.518> <0.034, 0.339, 0.518> <0.034, 0.312, 0.516> 
		<-0.032, 0.401, 0.512> <-0.032, 0.385, 0.518> <-0.032, 0.339, 0.518> <-0.032, 0.312, 0.516> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.185, 0.312, 0.477> <0.184, 0.308, 0.476> <0.179, 0.311, 0.465> <0.179, 0.307, 0.465> 
		<0.123, 0.312, 0.500> <0.123, 0.308, 0.500> <0.119, 0.311, 0.487> <0.119, 0.307, 0.488> 
		<0.034, 0.312, 0.516> <0.034, 0.308, 0.515> <0.033, 0.311, 0.503> <0.033, 0.307, 0.503> 
		<-0.032, 0.312, 0.516> <-0.032, 0.308, 0.515> <-0.032, 0.311, 0.503> <-0.032, 0.307, 0.503> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.179, 0.307, 0.465> <0.180, 0.296, 0.466> <0.186, 0.284, 0.479> <0.186, 0.273, 0.480> 
		<0.119, 0.307, 0.488> <0.120, 0.296, 0.489> <0.124, 0.284, 0.503> <0.124, 0.273, 0.504> 
		<0.033, 0.307, 0.503> <0.033, 0.296, 0.505> <0.035, 0.284, 0.519> <0.035, 0.273, 0.520> 
		<-0.032, 0.307, 0.503> <-0.032, 0.296, 0.505> <-0.032, 0.284, 0.519> <-0.032, 0.273, 0.520> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.186, 0.273, 0.480> <0.187, 0.251, 0.483> <0.187, 0.220, 0.481> <0.185, 0.198, 0.477> 
		<0.124, 0.273, 0.504> <0.125, 0.251, 0.506> <0.125, 0.220, 0.505> <0.123, 0.198, 0.500> 
		<0.035, 0.273, 0.520> <0.035, 0.251, 0.522> <0.034, 0.220, 0.521> <0.034, 0.198, 0.516> 
		<-0.032, 0.273, 0.520> <-0.032, 0.251, 0.522> <-0.032, 0.220, 0.521> <-0.032, 0.198, 0.516> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.185, 0.198, 0.477> <0.184, 0.194, 0.476> <0.178, 0.198, 0.463> <0.178, 0.193, 0.463> 
		<0.123, 0.198, 0.500> <0.122, 0.194, 0.499> <0.118, 0.198, 0.485> <0.119, 0.193, 0.486> 
		<0.034, 0.198, 0.516> <0.034, 0.194, 0.515> <0.032, 0.198, 0.501> <0.032, 0.193, 0.501> 
		<-0.032, 0.198, 0.516> <-0.032, 0.194, 0.515> <-0.032, 0.198, 0.501> <-0.032, 0.193, 0.501> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.178, 0.193, 0.463> <0.179, 0.183, 0.464> <0.186, 0.175, 0.479> <0.186, 0.164, 0.481> 
		<0.119, 0.193, 0.486> <0.119, 0.183, 0.487> <0.123, 0.175, 0.502> <0.124, 0.164, 0.504> 
		<0.032, 0.193, 0.501> <0.032, 0.183, 0.503> <0.035, 0.175, 0.518> <0.035, 0.164, 0.520> 
		<-0.032, 0.193, 0.501> <-0.032, 0.183, 0.503> <-0.032, 0.175, 0.518> <-0.032, 0.164, 0.520> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.186, 0.164, 0.481> <0.188, 0.142, 0.484> <0.185, 0.110, 0.477> <0.186, 0.087, 0.481> 
		<0.124, 0.164, 0.504> <0.126, 0.142, 0.508> <0.123, 0.110, 0.501> <0.124, 0.087, 0.504> 
		<0.035, 0.164, 0.520> <0.035, 0.142, 0.524> <0.035, 0.110, 0.517> <0.035, 0.087, 0.520> 
		<-0.032, 0.164, 0.520> <-0.032, 0.142, 0.524> <-0.032, 0.110, 0.517> <-0.032, 0.087, 0.520> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.186, 0.087, 0.481> <0.187, 0.080, 0.482> <0.192, 0.076, 0.492> <0.192, 0.069, 0.494> 
		<0.124, 0.087, 0.504> <0.125, 0.080, 0.505> <0.128, 0.076, 0.516> <0.128, 0.069, 0.518> 
		<0.035, 0.087, 0.520> <0.035, 0.080, 0.521> <0.037, 0.076, 0.533> <0.037, 0.069, 0.535> 
		<-0.032, 0.087, 0.520> <-0.032, 0.080, 0.521> <-0.032, 0.076, 0.533> <-0.032, 0.069, 0.535> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.192, 0.069, 0.494> <0.194, 0.060, 0.496> <0.195, 0.046, 0.499> <0.192, 0.039, 0.494> 
		<0.128, 0.069, 0.518> <0.130, 0.060, 0.521> <0.131, 0.046, 0.523> <0.128, 0.039, 0.518> 
		<0.037, 0.069, 0.535> <0.037, 0.060, 0.537> <0.037, 0.046, 0.540> <0.037, 0.039, 0.535> 
		<-0.032, 0.069, 0.535> <-0.032, 0.060, 0.537> <-0.032, 0.046, 0.540> <-0.032, 0.039, 0.535> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.192, 0.039, 0.494> <0.189, 0.028, 0.486> <0.182, 0.018, 0.470> <0.176, 0.017, 0.458> 
		<0.128, 0.039, 0.518> <0.125, 0.028, 0.511> <0.122, 0.018, 0.493> <0.117, 0.017, 0.480> 
		<0.037, 0.039, 0.535> <0.037, 0.028, 0.527> <0.032, 0.018, 0.509> <0.032, 0.017, 0.496> 
		<-0.032, 0.039, 0.535> <-0.032, 0.028, 0.527> <-0.032, 0.018, 0.509> <-0.032, 0.017, 0.496> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.176, 0.017, 0.458> <0.156, 0.011, 0.415> <0.130, 0.017, 0.356> <0.110, 0.017, 0.313> 
		<0.117, 0.017, 0.480> <0.097, 0.011, 0.437> <0.090, 0.017, 0.372> <0.070, 0.017, 0.328> 
		<0.032, 0.017, 0.496> <0.032, 0.011, 0.449> <0.012, 0.017, 0.386> <0.012, 0.017, 0.339> 
		<-0.032, 0.017, 0.496> <-0.032, 0.011, 0.449> <-0.032, 0.017, 0.386> <-0.032, 0.017, 0.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.305, 0.387, 0.308> <0.316, 0.392, 0.317> <0.329, 0.402, 0.329> <0.340, 0.405, 0.339> 
		<0.265, 0.387, 0.344> <0.275, 0.392, 0.354> <0.285, 0.402, 0.369> <0.295, 0.405, 0.379> 
		<0.202, 0.387, 0.383> <0.207, 0.392, 0.395> <0.219, 0.402, 0.409> <0.225, 0.405, 0.422> 
		<0.151, 0.387, 0.402> <0.156, 0.392, 0.414> <0.163, 0.402, 0.430> <0.169, 0.405, 0.443> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.340, 0.405, 0.339> <0.347, 0.406, 0.346> <0.363, 0.407, 0.360> <0.365, 0.401, 0.362> 
		<0.295, 0.405, 0.379> <0.303, 0.406, 0.386> <0.316, 0.407, 0.403> <0.318, 0.401, 0.405> 
		<0.225, 0.405, 0.422> <0.229, 0.406, 0.431> <0.242, 0.407, 0.448> <0.243, 0.401, 0.450> 
		<0.169, 0.405, 0.443> <0.173, 0.406, 0.452> <0.182, 0.407, 0.471> <0.183, 0.401, 0.473> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.365, 0.401, 0.362> <0.370, 0.385, 0.366> <0.370, 0.339, 0.366> <0.368, 0.312, 0.365> 
		<0.318, 0.401, 0.405> <0.322, 0.385, 0.409> <0.322, 0.339, 0.410> <0.320, 0.312, 0.408> 
		<0.243, 0.401, 0.450> <0.245, 0.385, 0.456> <0.246, 0.339, 0.456> <0.245, 0.312, 0.454> 
		<0.183, 0.401, 0.473> <0.186, 0.385, 0.479> <0.186, 0.339, 0.479> <0.185, 0.312, 0.477> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.368, 0.312, 0.365> <0.368, 0.308, 0.364> <0.358, 0.311, 0.356> <0.358, 0.307, 0.356> 
		<0.320, 0.312, 0.408> <0.320, 0.308, 0.408> <0.311, 0.311, 0.398> <0.312, 0.307, 0.398> 
		<0.245, 0.312, 0.454> <0.245, 0.308, 0.453> <0.238, 0.311, 0.442> <0.238, 0.307, 0.443> 
		<0.185, 0.312, 0.477> <0.184, 0.308, 0.476> <0.179, 0.311, 0.465> <0.179, 0.307, 0.465> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.358, 0.307, 0.356> <0.359, 0.296, 0.357> <0.370, 0.284, 0.367> <0.371, 0.273, 0.368> 
		<0.312, 0.307, 0.398> <0.313, 0.296, 0.399> <0.322, 0.284, 0.410> <0.323, 0.273, 0.411> 
		<0.238, 0.307, 0.443> <0.239, 0.296, 0.444> <0.246, 0.284, 0.456> <0.247, 0.273, 0.457> 
		<0.179, 0.307, 0.465> <0.180, 0.296, 0.466> <0.186, 0.284, 0.479> <0.186, 0.273, 0.480> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.371, 0.273, 0.368> <0.373, 0.251, 0.369> <0.372, 0.220, 0.368> <0.368, 0.198, 0.365> 
		<0.323, 0.273, 0.411> <0.325, 0.251, 0.413> <0.324, 0.220, 0.412> <0.320, 0.198, 0.408> 
		<0.247, 0.273, 0.457> <0.248, 0.251, 0.460> <0.247, 0.220, 0.458> <0.245, 0.198, 0.454> 
		<0.186, 0.273, 0.480> <0.187, 0.251, 0.483> <0.187, 0.220, 0.481> <0.185, 0.198, 0.477> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.368, 0.198, 0.365> <0.367, 0.194, 0.364> <0.356, 0.198, 0.354> <0.357, 0.193, 0.355> 
		<0.320, 0.198, 0.408> <0.319, 0.194, 0.407> <0.310, 0.198, 0.396> <0.310, 0.193, 0.397> 
		<0.245, 0.198, 0.454> <0.244, 0.194, 0.453> <0.237, 0.198, 0.441> <0.237, 0.193, 0.441> 
		<0.185, 0.198, 0.477> <0.184, 0.194, 0.476> <0.178, 0.198, 0.463> <0.178, 0.193, 0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.357, 0.193, 0.355> <0.358, 0.183, 0.355> <0.370, 0.175, 0.366> <0.371, 0.164, 0.368> 
		<0.310, 0.193, 0.397> <0.311, 0.183, 0.398> <0.322, 0.175, 0.410> <0.323, 0.164, 0.412> 
		<0.237, 0.193, 0.441> <0.238, 0.183, 0.442> <0.246, 0.175, 0.456> <0.247, 0.164, 0.458> 
		<0.178, 0.193, 0.463> <0.179, 0.183, 0.464> <0.186, 0.175, 0.479> <0.186, 0.164, 0.481> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.371, 0.164, 0.368> <0.374, 0.142, 0.371> <0.368, 0.110, 0.365> <0.371, 0.087, 0.368> 
		<0.323, 0.164, 0.412> <0.326, 0.142, 0.414> <0.321, 0.110, 0.409> <0.323, 0.087, 0.412> 
		<0.247, 0.164, 0.458> <0.249, 0.142, 0.461> <0.246, 0.110, 0.454> <0.247, 0.087, 0.458> 
		<0.186, 0.164, 0.481> <0.188, 0.142, 0.484> <0.185, 0.110, 0.477> <0.186, 0.087, 0.481> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.371, 0.087, 0.368> <0.372, 0.080, 0.369> <0.381, 0.076, 0.377> <0.382, 0.069, 0.378> 
		<0.323, 0.087, 0.412> <0.324, 0.080, 0.412> <0.332, 0.076, 0.422> <0.333, 0.069, 0.423> 
		<0.247, 0.087, 0.458> <0.248, 0.080, 0.459> <0.254, 0.076, 0.468> <0.255, 0.069, 0.470> 
		<0.186, 0.087, 0.481> <0.187, 0.080, 0.482> <0.192, 0.076, 0.492> <0.192, 0.069, 0.494> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.382, 0.069, 0.378> <0.384, 0.060, 0.380> <0.386, 0.046, 0.382> <0.382, 0.039, 0.378> 
		<0.333, 0.069, 0.423> <0.335, 0.060, 0.425> <0.337, 0.046, 0.427> <0.333, 0.039, 0.423> 
		<0.255, 0.069, 0.470> <0.256, 0.060, 0.473> <0.257, 0.046, 0.475> <0.255, 0.039, 0.470> 
		<0.192, 0.069, 0.494> <0.194, 0.060, 0.496> <0.195, 0.046, 0.499> <0.192, 0.039, 0.494> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.382, 0.039, 0.378> <0.376, 0.028, 0.372> <0.362, 0.018, 0.360> <0.352, 0.017, 0.350> 
		<0.333, 0.039, 0.423> <0.327, 0.028, 0.417> <0.317, 0.018, 0.402> <0.307, 0.017, 0.392> 
		<0.255, 0.039, 0.470> <0.251, 0.028, 0.463> <0.240, 0.018, 0.448> <0.234, 0.017, 0.436> 
		<0.192, 0.039, 0.494> <0.189, 0.028, 0.486> <0.182, 0.018, 0.470> <0.176, 0.017, 0.458> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.352, 0.017, 0.350> <0.316, 0.011, 0.317> <0.267, 0.017, 0.273> <0.231, 0.017, 0.240> 
		<0.307, 0.017, 0.392> <0.270, 0.011, 0.359> <0.236, 0.017, 0.301> <0.199, 0.017, 0.268> 
		<0.234, 0.017, 0.436> <0.214, 0.011, 0.393> <0.170, 0.017, 0.341> <0.150, 0.017, 0.298> 
		<0.176, 0.017, 0.458> <0.156, 0.011, 0.415> <0.130, 0.017, 0.356> <0.110, 0.017, 0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.409, 0.387, 0.167> <0.422, 0.392, 0.172> <0.439, 0.402, 0.178> <0.453, 0.405, 0.183> 
		<0.387, 0.387, 0.214> <0.400, 0.392, 0.219> <0.415, 0.402, 0.231> <0.429, 0.405, 0.236> 
		<0.344, 0.387, 0.272> <0.354, 0.392, 0.282> <0.371, 0.402, 0.290> <0.382, 0.405, 0.300> 
		<0.305, 0.387, 0.308> <0.316, 0.392, 0.317> <0.329, 0.402, 0.329> <0.340, 0.405, 0.339> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.453, 0.405, 0.183> <0.463, 0.406, 0.187> <0.484, 0.407, 0.195> <0.486, 0.401, 0.196> 
		<0.429, 0.405, 0.236> <0.439, 0.406, 0.240> <0.458, 0.407, 0.251> <0.461, 0.401, 0.252> 
		<0.382, 0.405, 0.300> <0.390, 0.406, 0.307> <0.408, 0.407, 0.319> <0.410, 0.401, 0.320> 
		<0.340, 0.405, 0.339> <0.347, 0.406, 0.346> <0.363, 0.407, 0.360> <0.365, 0.401, 0.362> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.486, 0.401, 0.196> <0.493, 0.385, 0.198> <0.493, 0.339, 0.198> <0.490, 0.312, 0.197> 
		<0.461, 0.401, 0.252> <0.467, 0.385, 0.254> <0.467, 0.339, 0.255> <0.465, 0.312, 0.254> 
		<0.410, 0.401, 0.320> <0.415, 0.385, 0.325> <0.416, 0.339, 0.324> <0.414, 0.312, 0.323> 
		<0.365, 0.401, 0.362> <0.370, 0.385, 0.366> <0.370, 0.339, 0.366> <0.368, 0.312, 0.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.490, 0.312, 0.197> <0.490, 0.308, 0.197> <0.477, 0.311, 0.192> <0.478, 0.307, 0.193> 
		<0.465, 0.312, 0.254> <0.464, 0.308, 0.254> <0.452, 0.311, 0.248> <0.453, 0.307, 0.248> 
		<0.414, 0.312, 0.323> <0.414, 0.308, 0.323> <0.403, 0.311, 0.315> <0.403, 0.307, 0.315> 
		<0.368, 0.312, 0.365> <0.368, 0.308, 0.364> <0.358, 0.311, 0.356> <0.358, 0.307, 0.356> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.478, 0.307, 0.193> <0.479, 0.296, 0.193> <0.493, 0.284, 0.198> <0.494, 0.273, 0.199> 
		<0.453, 0.307, 0.248> <0.454, 0.296, 0.248> <0.467, 0.284, 0.256> <0.469, 0.273, 0.256> 
		<0.403, 0.307, 0.315> <0.404, 0.296, 0.316> <0.416, 0.284, 0.324> <0.417, 0.273, 0.325> 
		<0.358, 0.307, 0.356> <0.359, 0.296, 0.357> <0.370, 0.284, 0.367> <0.371, 0.273, 0.368> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.494, 0.273, 0.199> <0.497, 0.251, 0.200> <0.495, 0.220, 0.199> <0.490, 0.198, 0.197> 
		<0.469, 0.273, 0.256> <0.471, 0.251, 0.257> <0.470, 0.220, 0.256> <0.465, 0.198, 0.254> 
		<0.417, 0.273, 0.325> <0.419, 0.251, 0.327> <0.418, 0.220, 0.326> <0.414, 0.198, 0.323> 
		<0.371, 0.273, 0.368> <0.373, 0.251, 0.369> <0.372, 0.220, 0.368> <0.368, 0.198, 0.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.490, 0.198, 0.197> <0.489, 0.194, 0.197> <0.475, 0.198, 0.192> <0.476, 0.193, 0.192> 
		<0.465, 0.198, 0.254> <0.464, 0.194, 0.254> <0.450, 0.198, 0.247> <0.451, 0.193, 0.247> 
		<0.414, 0.198, 0.323> <0.413, 0.194, 0.322> <0.401, 0.198, 0.313> <0.401, 0.193, 0.314> 
		<0.368, 0.198, 0.365> <0.367, 0.194, 0.364> <0.356, 0.198, 0.354> <0.357, 0.193, 0.355> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.476, 0.193, 0.192> <0.477, 0.183, 0.192> <0.493, 0.175, 0.198> <0.495, 0.164, 0.199> 
		<0.451, 0.193, 0.247> <0.452, 0.183, 0.247> <0.467, 0.175, 0.255> <0.469, 0.164, 0.256> 
		<0.401, 0.193, 0.314> <0.402, 0.183, 0.315> <0.416, 0.175, 0.324> <0.418, 0.164, 0.325> 
		<0.357, 0.193, 0.355> <0.358, 0.183, 0.355> <0.370, 0.175, 0.366> <0.371, 0.164, 0.368> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.495, 0.164, 0.199> <0.499, 0.142, 0.201> <0.491, 0.110, 0.198> <0.495, 0.087, 0.199> 
		<0.469, 0.164, 0.256> <0.473, 0.142, 0.258> <0.465, 0.110, 0.255> <0.469, 0.087, 0.256> 
		<0.418, 0.164, 0.325> <0.421, 0.142, 0.328> <0.415, 0.110, 0.323> <0.418, 0.087, 0.325> 
		<0.371, 0.164, 0.368> <0.374, 0.142, 0.371> <0.368, 0.110, 0.365> <0.371, 0.087, 0.368> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.495, 0.087, 0.199> <0.496, 0.080, 0.199> <0.507, 0.076, 0.204> <0.509, 0.069, 0.205> 
		<0.469, 0.087, 0.256> <0.470, 0.080, 0.257> <0.481, 0.076, 0.263> <0.483, 0.069, 0.263> 
		<0.418, 0.087, 0.325> <0.418, 0.080, 0.326> <0.429, 0.076, 0.333> <0.430, 0.069, 0.335> 
		<0.371, 0.087, 0.368> <0.372, 0.080, 0.369> <0.381, 0.076, 0.377> <0.382, 0.069, 0.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.509, 0.069, 0.205> <0.512, 0.060, 0.206> <0.515, 0.046, 0.207> <0.509, 0.039, 0.205> 
		<0.483, 0.069, 0.263> <0.485, 0.060, 0.264> <0.488, 0.046, 0.265> <0.483, 0.039, 0.263> 
		<0.430, 0.069, 0.335> <0.432, 0.060, 0.336> <0.434, 0.046, 0.338> <0.430, 0.039, 0.335> 
		<0.382, 0.069, 0.378> <0.384, 0.060, 0.380> <0.386, 0.046, 0.382> <0.382, 0.039, 0.378> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.509, 0.039, 0.205> <0.501, 0.028, 0.201> <0.483, 0.018, 0.195> <0.470, 0.017, 0.190> 
		<0.483, 0.039, 0.263> <0.474, 0.028, 0.260> <0.459, 0.018, 0.249> <0.445, 0.017, 0.244> 
		<0.430, 0.039, 0.335> <0.424, 0.028, 0.329> <0.407, 0.018, 0.320> <0.396, 0.017, 0.310> 
		<0.382, 0.039, 0.378> <0.376, 0.028, 0.372> <0.362, 0.018, 0.360> <0.352, 0.017, 0.350> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.470, 0.017, 0.190> <0.423, 0.011, 0.172> <0.359, 0.017, 0.148> <0.311, 0.017, 0.130> 
		<0.445, 0.017, 0.244> <0.398, 0.011, 0.226> <0.342, 0.017, 0.185> <0.294, 0.017, 0.167> 
		<0.396, 0.017, 0.310> <0.360, 0.011, 0.277> <0.297, 0.017, 0.245> <0.261, 0.017, 0.212> 
		<0.352, 0.017, 0.350> <0.316, 0.011, 0.317> <0.267, 0.017, 0.273> <0.231, 0.017, 0.240> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.264, 2.483, 0.370> <-0.251, 2.545, 0.370> <-0.282, 2.696, 0.370> <-0.220, 2.688, 0.370> 
		<-0.261, 2.483, 0.140> <-0.248, 2.545, 0.140> <-0.279, 2.696, 0.140> <-0.217, 2.688, 0.140> 
		<-0.257, 2.483, -0.167> <-0.243, 2.545, -0.167> <-0.275, 2.696, -0.167> <-0.212, 2.688, -0.167> 
		<-0.253, 2.483, -0.397> <-0.240, 2.545, -0.397> <-0.271, 2.696, -0.397> <-0.209, 2.688, -0.397> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.220, 2.688, 0.370> <-0.153, 2.680, 0.370> <-0.181, 2.536, 0.370> <-0.164, 2.470, 0.370> 
		<-0.217, 2.688, 0.140> <-0.150, 2.680, 0.140> <-0.178, 2.536, 0.140> <-0.161, 2.470, 0.140> 
		<-0.212, 2.688, -0.167> <-0.145, 2.680, -0.167> <-0.173, 2.536, -0.167> <-0.157, 2.470, -0.167> 
		<-0.209, 2.688, -0.397> <-0.142, 2.680, -0.397> <-0.170, 2.536, -0.397> <-0.153, 2.470, -0.397> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.060, 2.470, 0.385> <0.074, 2.531, 0.385> <0.042, 2.683, 0.385> <0.105, 2.675, 0.385> 
		<0.064, 2.470, 0.154> <0.077, 2.531, 0.154> <0.046, 2.683, 0.154> <0.108, 2.675, 0.154> 
		<0.068, 2.470, -0.154> <0.081, 2.531, -0.154> <0.050, 2.683, -0.154> <0.113, 2.675, -0.154> 
		<0.071, 2.470, -0.385> <0.085, 2.531, -0.385> <0.053, 2.683, -0.385> <0.116, 2.675, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.105, 2.675, 0.385> <0.172, 2.666, 0.385> <0.144, 2.522, 0.385> <0.160, 2.457, 0.385> 
		<0.108, 2.675, 0.154> <0.175, 2.666, 0.154> <0.147, 2.522, 0.154> <0.164, 2.457, 0.154> 
		<0.113, 2.675, -0.154> <0.179, 2.666, -0.154> <0.151, 2.522, -0.154> <0.168, 2.457, -0.154> 
		<0.116, 2.675, -0.385> <0.183, 2.666, -0.385> <0.155, 2.522, -0.385> <0.171, 2.457, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.405, 2.578, 0.000> <0.407, 2.622, 0.000> <0.389, 2.687, 0.000> <0.411, 2.726, 0.000> 
		<0.405, 2.578, 0.062> <0.407, 2.622, 0.062> <0.389, 2.687, 0.063> <0.411, 2.726, 0.063> 
		<0.380, 2.578, 0.147> <0.381, 2.622, 0.147> <0.366, 2.687, 0.139> <0.385, 2.726, 0.149> 
		<0.346, 2.578, 0.199> <0.348, 2.622, 0.200> <0.333, 2.687, 0.192> <0.351, 2.726, 0.202> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.411, 2.726, 0.000> <0.422, 2.746, 0.000> <0.488, 2.732, 0.000> <0.489, 2.730, 0.000> 
		<0.411, 2.726, 0.063> <0.422, 2.746, 0.063> <0.488, 2.732, 0.074> <0.489, 2.730, 0.074> 
		<0.385, 2.726, 0.149> <0.395, 2.746, 0.154> <0.458, 2.732, 0.175> <0.459, 2.730, 0.175> 
		<0.351, 2.726, 0.202> <0.361, 2.746, 0.207> <0.419, 2.732, 0.237> <0.419, 2.730, 0.238> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.489, 2.730, 0.000> <0.491, 2.722, 0.000> <0.526, 2.483, 0.000> <0.506, 2.380, 0.000> 
		<0.489, 2.730, 0.074> <0.491, 2.722, 0.074> <0.526, 2.483, 0.077> <0.506, 2.380, 0.077> 
		<0.459, 2.730, 0.175> <0.461, 2.722, 0.176> <0.492, 2.483, 0.190> <0.475, 2.380, 0.180> 
		<0.419, 2.730, 0.238> <0.421, 2.722, 0.239> <0.451, 2.483, 0.255> <0.434, 2.380, 0.245> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.506, 2.380, 0.000> <0.500, 2.353, 0.000> <0.443, 2.368, 0.000> <0.416, 2.363, 0.000> 
		<0.506, 2.380, 0.077> <0.500, 2.353, 0.077> <0.443, 2.368, 0.064> <0.416, 2.363, 0.064> 
		<0.475, 2.380, 0.180> <0.470, 2.354, 0.178> <0.414, 2.368, 0.163> <0.390, 2.363, 0.150> 
		<0.434, 2.380, 0.245> <0.429, 2.354, 0.243> <0.379, 2.368, 0.217> <0.356, 2.363, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.346, 2.578, -0.199> <0.348, 2.622, -0.200> <0.333, 2.687, -0.192> <0.351, 2.726, -0.202> 
		<0.380, 2.578, -0.147> <0.381, 2.622, -0.147> <0.366, 2.687, -0.139> <0.385, 2.726, -0.149> 
		<0.405, 2.578, -0.062> <0.407, 2.622, -0.062> <0.389, 2.687, -0.063> <0.411, 2.726, -0.063> 
		<0.405, 2.578, 0.000> <0.407, 2.622, 0.000> <0.389, 2.687, 0.000> <0.411, 2.726, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.351, 2.726, -0.202> <0.361, 2.746, -0.207> <0.419, 2.732, -0.237> <0.419, 2.730, -0.238> 
		<0.385, 2.726, -0.149> <0.395, 2.746, -0.154> <0.458, 2.732, -0.175> <0.459, 2.730, -0.175> 
		<0.411, 2.726, -0.063> <0.422, 2.746, -0.063> <0.488, 2.732, -0.074> <0.489, 2.730, -0.074> 
		<0.411, 2.726, 0.000> <0.422, 2.746, 0.000> <0.488, 2.732, 0.000> <0.489, 2.730, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.419, 2.730, -0.238> <0.421, 2.722, -0.239> <0.451, 2.483, -0.255> <0.434, 2.380, -0.245> 
		<0.459, 2.730, -0.175> <0.461, 2.722, -0.176> <0.492, 2.483, -0.190> <0.475, 2.380, -0.180> 
		<0.489, 2.730, -0.074> <0.491, 2.722, -0.074> <0.526, 2.483, -0.077> <0.506, 2.380, -0.077> 
		<0.489, 2.730, 0.000> <0.491, 2.722, 0.000> <0.526, 2.483, 0.000> <0.506, 2.380, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.434, 2.380, -0.245> <0.429, 2.354, -0.243> <0.379, 2.368, -0.217> <0.356, 2.363, -0.204> 
		<0.475, 2.380, -0.180> <0.470, 2.354, -0.178> <0.414, 2.368, -0.163> <0.390, 2.363, -0.150> 
		<0.506, 2.380, -0.077> <0.500, 2.353, -0.077> <0.443, 2.368, -0.064> <0.416, 2.363, -0.064> 
		<0.506, 2.380, 0.000> <0.500, 2.353, 0.000> <0.443, 2.368, 0.000> <0.416, 2.363, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.187, 2.578, -0.345> <0.187, 2.622, -0.347> <0.179, 2.686, -0.332> <0.189, 2.726, -0.350> 
		<0.244, 2.578, -0.315> <0.245, 2.622, -0.316> <0.237, 2.686, -0.302> <0.248, 2.726, -0.319> 
		<0.312, 2.578, -0.254> <0.313, 2.622, -0.255> <0.297, 2.687, -0.248> <0.316, 2.726, -0.257> 
		<0.346, 2.578, -0.199> <0.348, 2.622, -0.200> <0.333, 2.687, -0.192> <0.351, 2.726, -0.202> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.189, 2.726, -0.350> <0.195, 2.745, -0.358> <0.228, 2.732, -0.411> <0.229, 2.730, -0.412> 
		<0.248, 2.726, -0.319> <0.253, 2.745, -0.327> <0.297, 2.732, -0.375> <0.297, 2.730, -0.375> 
		<0.316, 2.726, -0.257> <0.326, 2.746, -0.263> <0.377, 2.732, -0.303> <0.378, 2.730, -0.303> 
		<0.351, 2.726, -0.202> <0.361, 2.746, -0.207> <0.419, 2.732, -0.237> <0.419, 2.730, -0.238> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.229, 2.730, -0.412> <0.230, 2.722, -0.413> <0.247, 2.483, -0.441> <0.237, 2.380, -0.425> 
		<0.297, 2.730, -0.375> <0.298, 2.722, -0.377> <0.318, 2.483, -0.404> <0.308, 2.380, -0.388> 
		<0.378, 2.730, -0.303> <0.380, 2.722, -0.304> <0.409, 2.483, -0.322> <0.391, 2.380, -0.313> 
		<0.419, 2.730, -0.238> <0.421, 2.722, -0.239> <0.451, 2.483, -0.255> <0.434, 2.380, -0.245> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.237, 2.380, -0.425> <0.234, 2.355, -0.421> <0.206, 2.368, -0.375> <0.192, 2.363, -0.354> 
		<0.308, 2.380, -0.388> <0.305, 2.355, -0.384> <0.265, 2.368, -0.344> <0.251, 2.363, -0.323> 
		<0.391, 2.380, -0.313> <0.386, 2.354, -0.310> <0.344, 2.368, -0.273> <0.321, 2.363, -0.261> 
		<0.434, 2.380, -0.245> <0.429, 2.354, -0.243> <0.379, 2.368, -0.217> <0.356, 2.363, -0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 2.578, -0.399> <-0.032, 2.622, -0.400> <-0.032, 2.686, -0.384> <-0.032, 2.726, -0.404> 
		<0.036, 2.578, -0.399> <0.036, 2.622, -0.400> <0.037, 2.686, -0.384> <0.037, 2.726, -0.404> 
		<0.127, 2.578, -0.377> <0.128, 2.622, -0.378> <0.118, 2.686, -0.364> <0.129, 2.726, -0.381> 
		<0.187, 2.578, -0.345> <0.187, 2.622, -0.347> <0.179, 2.686, -0.332> <0.189, 2.726, -0.350> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 2.726, -0.404> <-0.032, 2.745, -0.413> <-0.032, 2.732, -0.475> <-0.032, 2.730, -0.475> 
		<0.037, 2.726, -0.404> <0.037, 2.745, -0.413> <0.049, 2.732, -0.475> <0.049, 2.730, -0.475> 
		<0.129, 2.726, -0.381> <0.134, 2.745, -0.390> <0.157, 2.732, -0.449> <0.157, 2.730, -0.449> 
		<0.189, 2.726, -0.350> <0.195, 2.745, -0.358> <0.228, 2.732, -0.411> <0.229, 2.730, -0.412> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 2.730, -0.475> <-0.032, 2.722, -0.477> <-0.032, 2.483, -0.509> <-0.032, 2.380, -0.490> 
		<0.049, 2.730, -0.475> <0.049, 2.722, -0.477> <0.051, 2.483, -0.509> <0.051, 2.380, -0.490> 
		<0.157, 2.730, -0.449> <0.159, 2.722, -0.451> <0.174, 2.483, -0.480> <0.164, 2.380, -0.463> 
		<0.229, 2.730, -0.412> <0.230, 2.722, -0.413> <0.247, 2.483, -0.441> <0.237, 2.380, -0.425> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 2.380, -0.490> <-0.032, 2.355, -0.486> <-0.032, 2.368, -0.433> <-0.032, 2.363, -0.409> 
		<0.051, 2.380, -0.490> <0.051, 2.355, -0.486> <0.037, 2.368, -0.433> <0.037, 2.363, -0.409> 
		<0.164, 2.380, -0.463> <0.161, 2.355, -0.460> <0.144, 2.368, -0.407> <0.131, 2.363, -0.386> 
		<0.237, 2.380, -0.425> <0.234, 2.355, -0.421> <0.206, 2.368, -0.375> <0.192, 2.363, -0.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.250, 2.578, -0.345> <-0.251, 2.622, -0.347> <-0.242, 2.686, -0.332> <-0.253, 2.726, -0.350> 
		<-0.190, 2.578, -0.377> <-0.191, 2.622, -0.378> <-0.182, 2.686, -0.364> <-0.192, 2.726, -0.381> 
		<-0.099, 2.578, -0.399> <-0.099, 2.622, -0.400> <-0.100, 2.686, -0.384> <-0.100, 2.726, -0.404> 
		<-0.032, 2.578, -0.399> <-0.032, 2.622, -0.400> <-0.032, 2.686, -0.384> <-0.032, 2.726, -0.404> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.253, 2.726, -0.350> <-0.258, 2.745, -0.358> <-0.292, 2.732, -0.411> <-0.292, 2.730, -0.412> 
		<-0.192, 2.726, -0.381> <-0.198, 2.745, -0.390> <-0.221, 2.732, -0.449> <-0.221, 2.730, -0.449> 
		<-0.100, 2.726, -0.404> <-0.100, 2.745, -0.413> <-0.112, 2.732, -0.475> <-0.112, 2.730, -0.475> 
		<-0.032, 2.726, -0.404> <-0.032, 2.745, -0.413> <-0.032, 2.732, -0.475> <-0.032, 2.730, -0.475> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 2.730, -0.412> <-0.293, 2.722, -0.413> <-0.311, 2.483, -0.441> <-0.300, 2.380, -0.425> 
		<-0.221, 2.730, -0.449> <-0.222, 2.722, -0.451> <-0.237, 2.483, -0.480> <-0.227, 2.380, -0.463> 
		<-0.112, 2.730, -0.475> <-0.112, 2.722, -0.477> <-0.115, 2.483, -0.509> <-0.115, 2.380, -0.490> 
		<-0.032, 2.730, -0.475> <-0.032, 2.722, -0.477> <-0.032, 2.483, -0.509> <-0.032, 2.380, -0.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.300, 2.380, -0.425> <-0.298, 2.355, -0.421> <-0.269, 2.368, -0.375> <-0.256, 2.363, -0.354> 
		<-0.227, 2.380, -0.463> <-0.225, 2.355, -0.460> <-0.208, 2.368, -0.407> <-0.194, 2.363, -0.386> 
		<-0.115, 2.380, -0.490> <-0.115, 2.355, -0.486> <-0.101, 2.368, -0.433> <-0.101, 2.363, -0.409> 
		<-0.032, 2.380, -0.490> <-0.032, 2.355, -0.486> <-0.032, 2.368, -0.433> <-0.032, 2.363, -0.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.410, 2.578, -0.199> <-0.411, 2.622, -0.200> <-0.396, 2.687, -0.192> <-0.415, 2.726, -0.202> 
		<-0.375, 2.578, -0.254> <-0.377, 2.622, -0.255> <-0.361, 2.687, -0.248> <-0.380, 2.726, -0.257> 
		<-0.308, 2.578, -0.315> <-0.308, 2.622, -0.316> <-0.300, 2.686, -0.302> <-0.311, 2.726, -0.319> 
		<-0.250, 2.578, -0.345> <-0.251, 2.622, -0.347> <-0.242, 2.686, -0.332> <-0.253, 2.726, -0.350> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.415, 2.726, -0.202> <-0.424, 2.746, -0.207> <-0.482, 2.732, -0.237> <-0.483, 2.730, -0.238> 
		<-0.380, 2.726, -0.257> <-0.389, 2.746, -0.263> <-0.441, 2.732, -0.303> <-0.441, 2.730, -0.303> 
		<-0.311, 2.726, -0.319> <-0.316, 2.745, -0.327> <-0.360, 2.732, -0.375> <-0.361, 2.730, -0.375> 
		<-0.253, 2.726, -0.350> <-0.258, 2.745, -0.358> <-0.292, 2.732, -0.411> <-0.292, 2.730, -0.412> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.483, 2.730, -0.238> <-0.485, 2.722, -0.239> <-0.515, 2.483, -0.255> <-0.497, 2.380, -0.245> 
		<-0.441, 2.730, -0.303> <-0.443, 2.722, -0.304> <-0.472, 2.483, -0.322> <-0.454, 2.380, -0.313> 
		<-0.361, 2.730, -0.375> <-0.362, 2.722, -0.377> <-0.381, 2.483, -0.404> <-0.371, 2.380, -0.388> 
		<-0.292, 2.730, -0.412> <-0.293, 2.722, -0.413> <-0.311, 2.483, -0.441> <-0.300, 2.380, -0.425> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.497, 2.380, -0.245> <-0.493, 2.354, -0.243> <-0.443, 2.368, -0.217> <-0.420, 2.363, -0.204> 
		<-0.454, 2.380, -0.313> <-0.450, 2.354, -0.310> <-0.407, 2.368, -0.273> <-0.384, 2.363, -0.261> 
		<-0.371, 2.380, -0.388> <-0.369, 2.355, -0.384> <-0.328, 2.368, -0.344> <-0.315, 2.363, -0.323> 
		<-0.300, 2.380, -0.425> <-0.298, 2.355, -0.421> <-0.269, 2.368, -0.375> <-0.256, 2.363, -0.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.468, 2.578, 0.000> <-0.470, 2.622, 0.000> <-0.453, 2.687, 0.000> <-0.474, 2.726, 0.000> 
		<-0.468, 2.578, -0.062> <-0.470, 2.622, -0.062> <-0.453, 2.687, -0.063> <-0.474, 2.726, -0.063> 
		<-0.443, 2.578, -0.147> <-0.445, 2.622, -0.147> <-0.430, 2.687, -0.139> <-0.449, 2.726, -0.149> 
		<-0.410, 2.578, -0.199> <-0.411, 2.622, -0.200> <-0.396, 2.687, -0.192> <-0.415, 2.726, -0.202> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.474, 2.726, 0.000> <-0.485, 2.746, 0.000> <-0.552, 2.732, 0.000> <-0.552, 2.730, 0.000> 
		<-0.474, 2.726, -0.063> <-0.485, 2.746, -0.063> <-0.552, 2.732, -0.074> <-0.552, 2.730, -0.074> 
		<-0.449, 2.726, -0.149> <-0.458, 2.746, -0.154> <-0.522, 2.732, -0.175> <-0.522, 2.730, -0.175> 
		<-0.415, 2.726, -0.202> <-0.424, 2.746, -0.207> <-0.482, 2.732, -0.237> <-0.483, 2.730, -0.238> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.552, 2.730, 0.000> <-0.555, 2.722, 0.000> <-0.590, 2.483, 0.000> <-0.569, 2.380, 0.000> 
		<-0.552, 2.730, -0.074> <-0.555, 2.722, -0.074> <-0.590, 2.483, -0.077> <-0.569, 2.380, -0.077> 
		<-0.522, 2.730, -0.175> <-0.524, 2.722, -0.176> <-0.556, 2.483, -0.190> <-0.538, 2.380, -0.180> 
		<-0.483, 2.730, -0.238> <-0.485, 2.722, -0.239> <-0.515, 2.483, -0.255> <-0.497, 2.380, -0.245> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.569, 2.380, 0.000> <-0.564, 2.353, 0.000> <-0.506, 2.368, 0.000> <-0.480, 2.363, 0.000> 
		<-0.569, 2.380, -0.077> <-0.564, 2.353, -0.077> <-0.506, 2.368, -0.064> <-0.480, 2.363, -0.064> 
		<-0.538, 2.380, -0.180> <-0.534, 2.354, -0.178> <-0.477, 2.368, -0.163> <-0.454, 2.363, -0.150> 
		<-0.497, 2.380, -0.245> <-0.493, 2.354, -0.243> <-0.443, 2.368, -0.217> <-0.420, 2.363, -0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.410, 2.578, 0.199> <-0.411, 2.622, 0.200> <-0.396, 2.687, 0.192> <-0.415, 2.726, 0.202> 
		<-0.443, 2.578, 0.147> <-0.445, 2.622, 0.147> <-0.430, 2.687, 0.139> <-0.449, 2.726, 0.149> 
		<-0.468, 2.578, 0.062> <-0.470, 2.622, 0.062> <-0.453, 2.687, 0.063> <-0.474, 2.726, 0.063> 
		<-0.468, 2.578, 0.000> <-0.470, 2.622, 0.000> <-0.453, 2.687, 0.000> <-0.474, 2.726, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.415, 2.726, 0.202> <-0.424, 2.746, 0.207> <-0.482, 2.732, 0.237> <-0.483, 2.730, 0.238> 
		<-0.449, 2.726, 0.149> <-0.458, 2.746, 0.154> <-0.522, 2.732, 0.175> <-0.522, 2.730, 0.175> 
		<-0.474, 2.726, 0.063> <-0.485, 2.746, 0.063> <-0.552, 2.732, 0.074> <-0.552, 2.730, 0.074> 
		<-0.474, 2.726, 0.000> <-0.485, 2.746, 0.000> <-0.552, 2.732, 0.000> <-0.552, 2.730, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.483, 2.730, 0.238> <-0.485, 2.722, 0.239> <-0.515, 2.483, 0.255> <-0.497, 2.380, 0.245> 
		<-0.522, 2.730, 0.175> <-0.524, 2.722, 0.176> <-0.556, 2.483, 0.190> <-0.538, 2.380, 0.180> 
		<-0.552, 2.730, 0.074> <-0.555, 2.722, 0.074> <-0.590, 2.483, 0.077> <-0.569, 2.380, 0.077> 
		<-0.552, 2.730, 0.000> <-0.555, 2.722, 0.000> <-0.590, 2.483, 0.000> <-0.569, 2.380, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.497, 2.380, 0.245> <-0.493, 2.354, 0.243> <-0.443, 2.368, 0.217> <-0.420, 2.363, 0.204> 
		<-0.538, 2.380, 0.180> <-0.534, 2.354, 0.178> <-0.477, 2.368, 0.163> <-0.454, 2.363, 0.150> 
		<-0.569, 2.380, 0.077> <-0.564, 2.353, 0.077> <-0.506, 2.368, 0.064> <-0.480, 2.363, 0.064> 
		<-0.569, 2.380, 0.000> <-0.564, 2.353, 0.000> <-0.506, 2.368, 0.000> <-0.480, 2.363, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.250, 2.578, 0.345> <-0.251, 2.622, 0.347> <-0.242, 2.686, 0.332> <-0.253, 2.726, 0.350> 
		<-0.308, 2.578, 0.315> <-0.308, 2.622, 0.316> <-0.300, 2.686, 0.302> <-0.311, 2.726, 0.319> 
		<-0.375, 2.578, 0.254> <-0.377, 2.622, 0.255> <-0.361, 2.687, 0.248> <-0.380, 2.726, 0.257> 
		<-0.410, 2.578, 0.199> <-0.411, 2.622, 0.200> <-0.396, 2.687, 0.192> <-0.415, 2.726, 0.202> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.253, 2.726, 0.350> <-0.258, 2.745, 0.358> <-0.292, 2.732, 0.411> <-0.292, 2.730, 0.412> 
		<-0.311, 2.726, 0.319> <-0.316, 2.745, 0.327> <-0.360, 2.732, 0.375> <-0.361, 2.730, 0.375> 
		<-0.380, 2.726, 0.257> <-0.389, 2.746, 0.263> <-0.441, 2.732, 0.303> <-0.441, 2.730, 0.303> 
		<-0.415, 2.726, 0.202> <-0.424, 2.746, 0.207> <-0.482, 2.732, 0.237> <-0.483, 2.730, 0.238> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.292, 2.730, 0.412> <-0.293, 2.722, 0.413> <-0.311, 2.483, 0.441> <-0.300, 2.380, 0.425> 
		<-0.361, 2.730, 0.375> <-0.362, 2.722, 0.377> <-0.381, 2.483, 0.404> <-0.371, 2.380, 0.388> 
		<-0.441, 2.730, 0.303> <-0.443, 2.722, 0.304> <-0.472, 2.483, 0.322> <-0.454, 2.380, 0.313> 
		<-0.483, 2.730, 0.238> <-0.485, 2.722, 0.239> <-0.515, 2.483, 0.255> <-0.497, 2.380, 0.245> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.300, 2.380, 0.425> <-0.298, 2.355, 0.421> <-0.269, 2.368, 0.375> <-0.256, 2.363, 0.354> 
		<-0.371, 2.380, 0.388> <-0.369, 2.355, 0.384> <-0.328, 2.368, 0.344> <-0.315, 2.363, 0.323> 
		<-0.454, 2.380, 0.313> <-0.450, 2.354, 0.310> <-0.407, 2.368, 0.273> <-0.384, 2.363, 0.261> 
		<-0.497, 2.380, 0.245> <-0.493, 2.354, 0.243> <-0.443, 2.368, 0.217> <-0.420, 2.363, 0.204> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 2.578, 0.399> <-0.032, 2.622, 0.400> <-0.032, 2.686, 0.384> <-0.032, 2.726, 0.404> 
		<-0.099, 2.578, 0.399> <-0.099, 2.622, 0.400> <-0.100, 2.686, 0.384> <-0.100, 2.726, 0.404> 
		<-0.190, 2.578, 0.377> <-0.191, 2.622, 0.378> <-0.182, 2.686, 0.364> <-0.192, 2.726, 0.381> 
		<-0.250, 2.578, 0.345> <-0.251, 2.622, 0.347> <-0.242, 2.686, 0.332> <-0.253, 2.726, 0.350> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 2.726, 0.404> <-0.032, 2.745, 0.413> <-0.032, 2.732, 0.475> <-0.032, 2.730, 0.475> 
		<-0.100, 2.726, 0.404> <-0.100, 2.745, 0.413> <-0.112, 2.732, 0.475> <-0.112, 2.730, 0.475> 
		<-0.192, 2.726, 0.381> <-0.198, 2.745, 0.390> <-0.221, 2.732, 0.449> <-0.221, 2.730, 0.449> 
		<-0.253, 2.726, 0.350> <-0.258, 2.745, 0.358> <-0.292, 2.732, 0.411> <-0.292, 2.730, 0.412> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 2.730, 0.475> <-0.032, 2.722, 0.477> <-0.032, 2.483, 0.509> <-0.032, 2.380, 0.490> 
		<-0.112, 2.730, 0.475> <-0.112, 2.722, 0.477> <-0.115, 2.483, 0.509> <-0.115, 2.380, 0.490> 
		<-0.221, 2.730, 0.449> <-0.222, 2.722, 0.451> <-0.237, 2.483, 0.480> <-0.227, 2.380, 0.463> 
		<-0.292, 2.730, 0.412> <-0.293, 2.722, 0.413> <-0.311, 2.483, 0.441> <-0.300, 2.380, 0.425> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 2.380, 0.490> <-0.032, 2.355, 0.486> <-0.032, 2.368, 0.433> <-0.032, 2.363, 0.409> 
		<-0.115, 2.380, 0.490> <-0.115, 2.355, 0.486> <-0.101, 2.368, 0.433> <-0.101, 2.363, 0.409> 
		<-0.227, 2.380, 0.463> <-0.225, 2.355, 0.460> <-0.208, 2.368, 0.407> <-0.194, 2.363, 0.386> 
		<-0.300, 2.380, 0.425> <-0.298, 2.355, 0.421> <-0.269, 2.368, 0.375> <-0.256, 2.363, 0.354> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.187, 2.578, 0.345> <0.187, 2.622, 0.347> <0.179, 2.686, 0.332> <0.189, 2.726, 0.350> 
		<0.127, 2.578, 0.377> <0.128, 2.622, 0.378> <0.118, 2.686, 0.364> <0.129, 2.726, 0.381> 
		<0.036, 2.578, 0.399> <0.036, 2.622, 0.400> <0.037, 2.686, 0.384> <0.037, 2.726, 0.404> 
		<-0.032, 2.578, 0.399> <-0.032, 2.622, 0.400> <-0.032, 2.686, 0.384> <-0.032, 2.726, 0.404> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.189, 2.726, 0.350> <0.195, 2.745, 0.358> <0.228, 2.732, 0.411> <0.229, 2.730, 0.412> 
		<0.129, 2.726, 0.381> <0.134, 2.745, 0.390> <0.157, 2.732, 0.449> <0.157, 2.730, 0.449> 
		<0.037, 2.726, 0.404> <0.037, 2.745, 0.413> <0.049, 2.732, 0.475> <0.049, 2.730, 0.475> 
		<-0.032, 2.726, 0.404> <-0.032, 2.745, 0.413> <-0.032, 2.732, 0.475> <-0.032, 2.730, 0.475> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.229, 2.730, 0.412> <0.230, 2.722, 0.413> <0.247, 2.483, 0.441> <0.237, 2.380, 0.425> 
		<0.157, 2.730, 0.449> <0.159, 2.722, 0.451> <0.174, 2.483, 0.480> <0.164, 2.380, 0.463> 
		<0.049, 2.730, 0.475> <0.049, 2.722, 0.477> <0.051, 2.483, 0.509> <0.051, 2.380, 0.490> 
		<-0.032, 2.730, 0.475> <-0.032, 2.722, 0.477> <-0.032, 2.483, 0.509> <-0.032, 2.380, 0.490> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.237, 2.380, 0.425> <0.234, 2.355, 0.421> <0.206, 2.368, 0.375> <0.192, 2.363, 0.354> 
		<0.164, 2.380, 0.463> <0.161, 2.355, 0.460> <0.144, 2.368, 0.407> <0.131, 2.363, 0.386> 
		<0.051, 2.380, 0.490> <0.051, 2.355, 0.486> <0.037, 2.368, 0.433> <0.037, 2.363, 0.409> 
		<-0.032, 2.380, 0.490> <-0.032, 2.355, 0.486> <-0.032, 2.368, 0.433> <-0.032, 2.363, 0.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.346, 2.578, 0.199> <0.348, 2.622, 0.200> <0.333, 2.687, 0.192> <0.351, 2.726, 0.202> 
		<0.312, 2.578, 0.254> <0.313, 2.622, 0.255> <0.297, 2.687, 0.248> <0.316, 2.726, 0.257> 
		<0.244, 2.578, 0.315> <0.245, 2.622, 0.316> <0.237, 2.686, 0.302> <0.248, 2.726, 0.319> 
		<0.187, 2.578, 0.345> <0.187, 2.622, 0.347> <0.179, 2.686, 0.332> <0.189, 2.726, 0.350> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.351, 2.726, 0.202> <0.361, 2.746, 0.207> <0.419, 2.732, 0.237> <0.419, 2.730, 0.238> 
		<0.316, 2.726, 0.257> <0.326, 2.746, 0.263> <0.377, 2.732, 0.303> <0.378, 2.730, 0.303> 
		<0.248, 2.726, 0.319> <0.253, 2.745, 0.327> <0.297, 2.732, 0.375> <0.297, 2.730, 0.375> 
		<0.189, 2.726, 0.350> <0.195, 2.745, 0.358> <0.228, 2.732, 0.411> <0.229, 2.730, 0.412> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.419, 2.730, 0.238> <0.421, 2.722, 0.239> <0.451, 2.483, 0.255> <0.434, 2.380, 0.245> 
		<0.378, 2.730, 0.303> <0.380, 2.722, 0.304> <0.409, 2.483, 0.322> <0.391, 2.380, 0.313> 
		<0.297, 2.730, 0.375> <0.298, 2.722, 0.377> <0.318, 2.483, 0.404> <0.308, 2.380, 0.388> 
		<0.229, 2.730, 0.412> <0.230, 2.722, 0.413> <0.247, 2.483, 0.441> <0.237, 2.380, 0.425> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.434, 2.380, 0.245> <0.429, 2.354, 0.243> <0.379, 2.368, 0.217> <0.356, 2.363, 0.204> 
		<0.391, 2.380, 0.313> <0.386, 2.354, 0.310> <0.344, 2.368, 0.273> <0.321, 2.363, 0.261> 
		<0.308, 2.380, 0.388> <0.305, 2.355, 0.384> <0.265, 2.368, 0.344> <0.251, 2.363, 0.323> 
		<0.237, 2.380, 0.425> <0.234, 2.355, 0.421> <0.206, 2.368, 0.375> <0.192, 2.363, 0.354> 
	}
texture { TopBottomTex }

}

#declare BagShape=
union{
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.274, 2.144, 0.313> <-0.372, 2.144, 0.308> <-0.513, 2.144, 0.340> <-0.602, 2.144, 0.298> 
		<-0.273, 2.180, 0.308> <-0.371, 2.180, 0.303> <-0.464, 2.230, 0.329> <-0.553, 2.230, 0.287> 
		<-0.274, 2.205, 0.254> <-0.291, 2.231, 0.250> <-0.398, 2.251, 0.265> <-0.412, 2.265, 0.241> 
		<-0.274, 2.230, 0.228> <-0.291, 2.256, 0.225> <-0.316, 2.303, 0.240> <-0.331, 2.317, 0.217> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.602, 2.144, 0.298> <-0.650, 2.144, 0.275> <-0.657, 2.144, 0.183> <-0.663, 2.144, 0.129> 
		<-0.553, 2.230, 0.287> <-0.602, 2.230, 0.264> <-0.602, 2.234, 0.177> <-0.608, 2.234, 0.124> 
		<-0.412, 2.265, 0.241> <-0.431, 2.284, 0.211> <-0.449, 2.265, 0.140> <-0.452, 2.265, 0.101> 
		<-0.331, 2.317, 0.217> <-0.349, 2.336, 0.187> <-0.358, 2.317, 0.128> <-0.361, 2.317, 0.089> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.663, 2.144, 0.129> <-0.676, 2.144, 0.015> <-0.679, 2.144, -0.139> <-0.663, 2.144, -0.253> 
		<-0.608, 2.234, 0.124> <-0.621, 2.234, 0.010> <-0.624, 2.234, -0.133> <-0.608, 2.234, -0.246> 
		<-0.452, 2.265, 0.101> <-0.458, 2.265, 0.014> <-0.460, 2.265, -0.130> <-0.452, 2.265, -0.217> 
		<-0.361, 2.317, 0.089> <-0.367, 2.317, 0.002> <-0.369, 2.317, -0.115> <-0.361, 2.317, -0.202> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.663, 2.144, -0.253> <-0.656, 2.144, -0.299> <-0.634, 2.144, -0.375> <-0.589, 2.144, -0.391> 
		<-0.608, 2.234, -0.246> <-0.601, 2.234, -0.292> <-0.586, 2.230, -0.364> <-0.542, 2.230, -0.380> 
		<-0.452, 2.265, -0.217> <-0.448, 2.265, -0.250> <-0.421, 2.283, -0.310> <-0.403, 2.265, -0.332> 
		<-0.361, 2.317, -0.202> <-0.358, 2.317, -0.235> <-0.341, 2.335, -0.285> <-0.323, 2.317, -0.306> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.589, 2.144, -0.391> <-0.500, 2.144, -0.422> <-0.368, 2.144, -0.391> <-0.274, 2.144, -0.391> 
		<-0.542, 2.230, -0.380> <-0.452, 2.230, -0.411> <-0.368, 2.180, -0.385> <-0.273, 2.180, -0.385> 
		<-0.403, 2.265, -0.332> <-0.387, 2.249, -0.351> <-0.289, 2.231, -0.332> <-0.274, 2.205, -0.332> 
		<-0.323, 2.317, -0.306> <-0.307, 2.301, -0.326> <-0.289, 2.256, -0.306> <-0.274, 2.230, -0.306> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.286, 1.647, 0.313> <-0.413, 1.647, 0.308> <-0.591, 1.647, 0.343> <-0.710, 1.647, 0.298> 
		<-0.286, 1.796, 0.313> <-0.413, 1.796, 0.308> <-0.571, 1.798, 0.343> <-0.690, 1.798, 0.298> 
		<-0.277, 1.996, 0.334> <-0.375, 1.996, 0.330> <-0.587, 2.012, 0.355> <-0.677, 2.012, 0.313> 
		<-0.274, 2.144, 0.313> <-0.372, 2.144, 0.308> <-0.513, 2.144, 0.340> <-0.602, 2.144, 0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.710, 1.647, 0.298> <-0.761, 1.647, 0.279> <-0.766, 1.647, 0.183> <-0.772, 1.647, 0.129> 
		<-0.690, 1.798, 0.298> <-0.741, 1.798, 0.279> <-0.746, 1.798, 0.183> <-0.752, 1.798, 0.129> 
		<-0.677, 2.012, 0.313> <-0.725, 2.012, 0.291> <-0.737, 2.014, 0.191> <-0.743, 2.014, 0.137> 
		<-0.602, 2.144, 0.298> <-0.650, 2.144, 0.275> <-0.657, 2.144, 0.183> <-0.663, 2.144, 0.129> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.772, 1.647, 0.129> <-0.784, 1.647, 0.015> <-0.788, 1.647, -0.139> <-0.772, 1.647, -0.253> 
		<-0.752, 1.798, 0.129> <-0.764, 1.798, 0.015> <-0.768, 1.798, -0.139> <-0.752, 1.798, -0.253> 
		<-0.743, 2.014, 0.137> <-0.755, 2.014, 0.023> <-0.759, 2.014, -0.149> <-0.743, 2.014, -0.263> 
		<-0.663, 2.144, 0.129> <-0.676, 2.144, 0.015> <-0.679, 2.144, -0.139> <-0.663, 2.144, -0.253> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.772, 1.647, -0.253> <-0.765, 1.647, -0.299> <-0.743, 1.647, -0.378> <-0.698, 1.647, -0.391> 
		<-0.752, 1.798, -0.253> <-0.745, 1.798, -0.299> <-0.723, 1.798, -0.378> <-0.678, 1.798, -0.391> 
		<-0.743, 2.014, -0.263> <-0.736, 2.014, -0.309> <-0.708, 2.012, -0.392> <-0.664, 2.012, -0.407> 
		<-0.663, 2.144, -0.253> <-0.656, 2.144, -0.299> <-0.634, 2.144, -0.375> <-0.589, 2.144, -0.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.698, 1.647, -0.391> <-0.579, 1.647, -0.424> <-0.409, 1.647, -0.391> <-0.286, 1.647, -0.391> 
		<-0.678, 1.798, -0.391> <-0.559, 1.798, -0.424> <-0.409, 1.796, -0.391> <-0.286, 1.796, -0.391> 
		<-0.664, 2.012, -0.407> <-0.574, 2.012, -0.439> <-0.371, 1.996, -0.412> <-0.277, 1.996, -0.412> 
		<-0.589, 2.144, -0.391> <-0.500, 2.144, -0.422> <-0.368, 2.144, -0.391> <-0.274, 2.144, -0.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.710, 1.647, 0.298> <-0.739, 1.431, 0.298> <-0.790, 1.140, 0.298> <-0.762, 0.924, 0.298> 
		<-0.591, 1.647, 0.343> <-0.619, 1.431, 0.343> <-0.651, 1.140, 0.344> <-0.623, 0.924, 0.344> 
		<-0.413, 1.647, 0.308> <-0.413, 1.430, 0.308> <-0.426, 1.141, 0.308> <-0.420, 0.924, 0.308> 
		<-0.286, 1.647, 0.313> <-0.286, 1.430, 0.313> <-0.279, 1.141, 0.313> <-0.274, 0.924, 0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.762, 0.924, 0.298> <-0.752, 0.840, 0.298> <-0.651, 0.758, 0.304> <-0.589, 0.699, 0.298> 
		<-0.623, 0.924, 0.344> <-0.612, 0.840, 0.344> <-0.562, 0.758, 0.346> <-0.500, 0.699, 0.340> 
		<-0.420, 0.924, 0.308> <-0.418, 0.857, 0.308> <-0.366, 0.766, 0.316> <-0.360, 0.699, 0.308> 
		<-0.274, 0.924, 0.313> <-0.272, 0.857, 0.313> <-0.267, 0.766, 0.320> <-0.261, 0.699, 0.313> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.589, 0.699, 0.298> <-0.552, 0.664, 0.294> <-0.486, 0.643, 0.274> <-0.441, 0.620, 0.264> 
		<-0.500, 0.699, 0.340> <-0.463, 0.664, 0.336> <-0.437, 0.640, 0.306> <-0.392, 0.616, 0.296> 
		<-0.360, 0.699, 0.308> <-0.357, 0.669, 0.305> <-0.309, 0.637, 0.284> <-0.305, 0.608, 0.274> 
		<-0.261, 0.699, 0.313> <-0.259, 0.669, 0.309> <-0.251, 0.632, 0.288> <-0.246, 0.604, 0.278> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.772, 1.647, 0.129> <-0.800, 1.431, 0.129> <-0.851, 1.140, 0.129> <-0.824, 0.924, 0.129> 
		<-0.766, 1.647, 0.183> <-0.794, 1.431, 0.183> <-0.845, 1.140, 0.183> <-0.818, 0.924, 0.183> 
		<-0.761, 1.647, 0.279> <-0.789, 1.431, 0.279> <-0.841, 1.140, 0.281> <-0.813, 0.924, 0.281> 
		<-0.710, 1.647, 0.298> <-0.739, 1.431, 0.298> <-0.790, 1.140, 0.298> <-0.762, 0.924, 0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.824, 0.924, 0.129> <-0.813, 0.840, 0.129> <-0.713, 0.757, 0.132> <-0.651, 0.699, 0.129> 
		<-0.818, 0.924, 0.183> <-0.807, 0.840, 0.183> <-0.707, 0.757, 0.186> <-0.645, 0.699, 0.183> 
		<-0.813, 0.924, 0.281> <-0.802, 0.840, 0.281> <-0.700, 0.758, 0.281> <-0.638, 0.699, 0.275> 
		<-0.762, 0.924, 0.298> <-0.752, 0.840, 0.298> <-0.651, 0.758, 0.304> <-0.589, 0.699, 0.298> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.651, 0.699, 0.129> <-0.612, 0.664, 0.127> <-0.543, 0.643, 0.118> <-0.496, 0.620, 0.112> 
		<-0.645, 0.699, 0.183> <-0.606, 0.664, 0.181> <-0.537, 0.643, 0.166> <-0.491, 0.620, 0.161> 
		<-0.638, 0.699, 0.275> <-0.601, 0.664, 0.271> <-0.526, 0.646, 0.247> <-0.481, 0.622, 0.237> 
		<-0.589, 0.699, 0.298> <-0.552, 0.664, 0.294> <-0.486, 0.643, 0.274> <-0.441, 0.620, 0.264> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.772, 1.647, -0.253> <-0.800, 1.431, -0.253> <-0.851, 1.140, -0.253> <-0.824, 0.924, -0.253> 
		<-0.788, 1.647, -0.139> <-0.816, 1.431, -0.139> <-0.867, 1.140, -0.139> <-0.840, 0.924, -0.139> 
		<-0.784, 1.647, 0.015> <-0.813, 1.431, 0.015> <-0.864, 1.140, 0.015> <-0.836, 0.924, 0.015> 
		<-0.772, 1.647, 0.129> <-0.800, 1.431, 0.129> <-0.851, 1.140, 0.129> <-0.824, 0.924, 0.129> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.824, 0.924, -0.253> <-0.813, 0.840, -0.253> <-0.713, 0.757, -0.257> <-0.651, 0.699, -0.253> 
		<-0.840, 0.924, -0.139> <-0.829, 0.840, -0.139> <-0.729, 0.757, -0.144> <-0.667, 0.699, -0.139> 
		<-0.836, 0.924, 0.015> <-0.825, 0.840, 0.015> <-0.726, 0.757, 0.019> <-0.663, 0.699, 0.015> 
		<-0.824, 0.924, 0.129> <-0.813, 0.840, 0.129> <-0.713, 0.757, 0.132> <-0.651, 0.699, 0.129> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.651, 0.699, -0.253> <-0.612, 0.663, -0.251> <-0.543, 0.643, -0.238> <-0.496, 0.620, -0.232> 
		<-0.667, 0.699, -0.139> <-0.628, 0.663, -0.137> <-0.557, 0.643, -0.136> <-0.511, 0.620, -0.129> 
		<-0.663, 0.699, 0.015> <-0.625, 0.664, 0.013> <-0.554, 0.643, 0.015> <-0.508, 0.620, 0.010> 
		<-0.651, 0.699, 0.129> <-0.612, 0.664, 0.127> <-0.543, 0.643, 0.118> <-0.496, 0.620, 0.112> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.698, 1.647, -0.391> <-0.726, 1.431, -0.391> <-0.778, 1.140, -0.391> <-0.750, 0.924, -0.391> 
		<-0.743, 1.647, -0.378> <-0.771, 1.431, -0.378> <-0.823, 1.140, -0.379> <-0.795, 0.924, -0.379> 
		<-0.765, 1.647, -0.299> <-0.793, 1.431, -0.299> <-0.845, 1.140, -0.299> <-0.817, 0.924, -0.299> 
		<-0.772, 1.647, -0.253> <-0.800, 1.431, -0.253> <-0.851, 1.140, -0.253> <-0.824, 0.924, -0.253> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.750, 0.924, -0.391> <-0.739, 0.840, -0.391> <-0.639, 0.758, -0.397> <-0.577, 0.699, -0.391> 
		<-0.795, 0.924, -0.379> <-0.785, 0.840, -0.379> <-0.683, 0.758, -0.382> <-0.621, 0.699, -0.375> 
		<-0.817, 0.924, -0.299> <-0.806, 0.840, -0.299> <-0.706, 0.757, -0.303> <-0.644, 0.699, -0.299> 
		<-0.824, 0.924, -0.253> <-0.813, 0.840, -0.253> <-0.713, 0.757, -0.257> <-0.651, 0.699, -0.253> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.577, 0.699, -0.391> <-0.540, 0.664, -0.387> <-0.474, 0.643, -0.366> <-0.430, 0.620, -0.355> 
		<-0.621, 0.699, -0.375> <-0.584, 0.664, -0.371> <-0.512, 0.646, -0.347> <-0.468, 0.622, -0.337> 
		<-0.644, 0.699, -0.299> <-0.606, 0.663, -0.297> <-0.537, 0.643, -0.280> <-0.490, 0.620, -0.273> 
		<-0.651, 0.699, -0.253> <-0.612, 0.663, -0.251> <-0.543, 0.643, -0.238> <-0.496, 0.620, -0.232> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.286, 1.647, -0.391> <-0.286, 1.430, -0.391> <-0.279, 1.141, -0.391> <-0.274, 0.924, -0.391> 
		<-0.409, 1.647, -0.391> <-0.409, 1.430, -0.391> <-0.422, 1.141, -0.391> <-0.417, 0.924, -0.391> 
		<-0.579, 1.647, -0.424> <-0.607, 1.431, -0.424> <-0.639, 1.140, -0.425> <-0.611, 0.924, -0.425> 
		<-0.698, 1.647, -0.391> <-0.726, 1.431, -0.391> <-0.778, 1.140, -0.391> <-0.750, 0.924, -0.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.274, 0.924, -0.391> <-0.272, 0.857, -0.391> <-0.267, 0.766, -0.398> <-0.261, 0.699, -0.391> 
		<-0.417, 0.924, -0.391> <-0.415, 0.857, -0.391> <-0.362, 0.766, -0.398> <-0.356, 0.699, -0.391> 
		<-0.611, 0.924, -0.425> <-0.601, 0.840, -0.425> <-0.549, 0.758, -0.429> <-0.488, 0.699, -0.422> 
		<-0.750, 0.924, -0.391> <-0.739, 0.840, -0.391> <-0.639, 0.758, -0.397> <-0.577, 0.699, -0.391> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.261, 0.699, -0.391> <-0.259, 0.669, -0.387> <-0.251, 0.632, -0.366> <-0.246, 0.604, -0.355> 
		<-0.356, 0.699, -0.391> <-0.353, 0.669, -0.387> <-0.306, 0.637, -0.366> <-0.301, 0.608, -0.355> 
		<-0.488, 0.699, -0.422> <-0.451, 0.664, -0.418> <-0.425, 0.640, -0.391> <-0.380, 0.616, -0.380> 
		<-0.577, 0.699, -0.391> <-0.540, 0.664, -0.387> <-0.474, 0.643, -0.366> <-0.430, 0.620, -0.355> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.462, 2.443, 0.000> <0.465, 2.278, 0.000> <0.467, 2.058, 0.000> <0.473, 1.894, 0.000> 
		<0.462, 2.443, 0.070> <0.465, 2.278, 0.070> <0.467, 2.058, 0.072> <0.473, 1.894, 0.072> 
		<0.434, 2.443, 0.166> <0.436, 2.278, 0.167> <0.439, 2.058, 0.167> <0.443, 1.894, 0.169> 
		<0.396, 2.443, 0.225> <0.399, 2.278, 0.227> <0.400, 2.058, 0.228> <0.405, 1.894, 0.230> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.473, 1.894, 0.000> <0.478, 1.736, 0.000> <0.498, 1.526, 0.000> <0.498, 1.368, 0.000> 
		<0.473, 1.894, 0.072> <0.478, 1.736, 0.072> <0.498, 1.526, 0.076> <0.498, 1.368, 0.076> 
		<0.443, 1.894, 0.169> <0.448, 1.736, 0.172> <0.467, 1.526, 0.178> <0.468, 1.368, 0.178> 
		<0.405, 1.894, 0.230> <0.410, 1.736, 0.233> <0.427, 1.526, 0.242> <0.427, 1.368, 0.242> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.498, 1.368, 0.000> <0.499, 1.225, 0.000> <0.478, 1.036, 0.000> <0.476, 0.893, 0.000> 
		<0.498, 1.368, 0.076> <0.499, 1.225, 0.076> <0.478, 1.036, 0.072> <0.476, 0.893, 0.072> 
		<0.468, 1.368, 0.178> <0.468, 1.225, 0.178> <0.448, 1.036, 0.171> <0.446, 0.893, 0.170> 
		<0.427, 1.368, 0.242> <0.428, 1.225, 0.242> <0.410, 1.036, 0.233> <0.408, 0.893, 0.231> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.476, 0.893, 0.000> <0.474, 0.796, 0.000> <0.488, 0.667, 0.000> <0.485, 0.570, 0.000> 
		<0.476, 0.893, 0.072> <0.474, 0.796, 0.072> <0.488, 0.667, 0.074> <0.485, 0.570, 0.074> 
		<0.446, 0.893, 0.170> <0.445, 0.796, 0.170> <0.458, 0.667, 0.175> <0.456, 0.570, 0.174> 
		<0.408, 0.893, 0.231> <0.406, 0.796, 0.231> <0.418, 0.667, 0.237> <0.416, 0.570, 0.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.485, 0.570, 0.000> <0.483, 0.482, 0.000> <0.468, 0.366, 0.000> <0.460, 0.278, 0.000> 
		<0.485, 0.570, 0.074> <0.483, 0.482, 0.074> <0.468, 0.366, 0.070> <0.460, 0.278, 0.070> 
		<0.456, 0.570, 0.174> <0.454, 0.482, 0.173> <0.438, 0.366, 0.169> <0.431, 0.278, 0.165> 
		<0.416, 0.570, 0.236> <0.414, 0.482, 0.235> <0.401, 0.366, 0.228> <0.394, 0.278, 0.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.396, 2.443, -0.225> <0.399, 2.278, -0.227> <0.400, 2.058, -0.228> <0.405, 1.894, -0.230> 
		<0.434, 2.443, -0.166> <0.436, 2.278, -0.167> <0.439, 2.058, -0.167> <0.443, 1.894, -0.169> 
		<0.462, 2.443, -0.070> <0.465, 2.278, -0.070> <0.467, 2.058, -0.072> <0.473, 1.894, -0.072> 
		<0.462, 2.443, 0.000> <0.465, 2.278, 0.000> <0.467, 2.058, 0.000> <0.473, 1.894, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.405, 1.894, -0.230> <0.410, 1.736, -0.233> <0.427, 1.526, -0.242> <0.427, 1.368, -0.242> 
		<0.443, 1.894, -0.169> <0.448, 1.736, -0.172> <0.467, 1.526, -0.178> <0.468, 1.368, -0.178> 
		<0.473, 1.894, -0.072> <0.478, 1.736, -0.072> <0.498, 1.526, -0.076> <0.498, 1.368, -0.076> 
		<0.473, 1.894, 0.000> <0.478, 1.736, 0.000> <0.498, 1.526, 0.000> <0.498, 1.368, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.427, 1.368, -0.242> <0.428, 1.225, -0.242> <0.410, 1.036, -0.233> <0.408, 0.893, -0.231> 
		<0.468, 1.368, -0.178> <0.468, 1.225, -0.178> <0.448, 1.036, -0.171> <0.446, 0.893, -0.170> 
		<0.498, 1.368, -0.076> <0.499, 1.225, -0.076> <0.478, 1.036, -0.072> <0.476, 0.893, -0.072> 
		<0.498, 1.368, 0.000> <0.499, 1.225, 0.000> <0.478, 1.036, 0.000> <0.476, 0.893, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.408, 0.893, -0.231> <0.406, 0.796, -0.231> <0.418, 0.667, -0.237> <0.416, 0.570, -0.236> 
		<0.446, 0.893, -0.170> <0.445, 0.796, -0.170> <0.458, 0.667, -0.175> <0.456, 0.570, -0.174> 
		<0.476, 0.893, -0.072> <0.474, 0.796, -0.072> <0.488, 0.667, -0.074> <0.485, 0.570, -0.074> 
		<0.476, 0.893, 0.000> <0.474, 0.796, 0.000> <0.488, 0.667, 0.000> <0.485, 0.570, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.416, 0.570, -0.236> <0.414, 0.482, -0.235> <0.401, 0.366, -0.228> <0.394, 0.278, -0.224> 
		<0.456, 0.570, -0.174> <0.454, 0.482, -0.173> <0.438, 0.366, -0.169> <0.431, 0.278, -0.165> 
		<0.485, 0.570, -0.074> <0.483, 0.482, -0.074> <0.468, 0.366, -0.070> <0.460, 0.278, -0.070> 
		<0.485, 0.570, 0.000> <0.483, 0.482, 0.000> <0.468, 0.366, 0.000> <0.460, 0.278, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.215, 2.443, -0.391> <0.217, 2.278, -0.393> <0.218, 2.058, -0.394> <0.220, 1.894, -0.399> 
		<0.280, 2.443, -0.356> <0.282, 2.278, -0.359> <0.284, 2.058, -0.359> <0.287, 1.894, -0.364> 
		<0.357, 2.443, -0.288> <0.360, 2.278, -0.289> <0.360, 2.058, -0.291> <0.365, 1.894, -0.294> 
		<0.396, 2.443, -0.225> <0.399, 2.278, -0.227> <0.400, 2.058, -0.228> <0.405, 1.894, -0.230> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.220, 1.894, -0.399> <0.223, 1.736, -0.403> <0.233, 1.526, -0.419> <0.233, 1.368, -0.419> 
		<0.287, 1.894, -0.364> <0.289, 1.736, -0.368> <0.303, 1.526, -0.382> <0.303, 1.368, -0.382> 
		<0.365, 1.894, -0.294> <0.370, 1.736, -0.296> <0.385, 1.526, -0.308> <0.385, 1.368, -0.309> 
		<0.405, 1.894, -0.230> <0.410, 1.736, -0.233> <0.427, 1.526, -0.242> <0.427, 1.368, -0.242> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.233, 1.368, -0.419> <0.234, 1.225, -0.419> <0.223, 1.036, -0.403> <0.222, 0.893, -0.401> 
		<0.303, 1.368, -0.382> <0.303, 1.225, -0.383> <0.290, 1.036, -0.368> <0.289, 0.893, -0.366> 
		<0.385, 1.368, -0.309> <0.386, 1.225, -0.309> <0.369, 1.036, -0.296> <0.367, 0.893, -0.295> 
		<0.427, 1.368, -0.242> <0.428, 1.225, -0.242> <0.410, 1.036, -0.233> <0.408, 0.893, -0.231> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.222, 0.893, -0.401> <0.221, 0.796, -0.400> <0.228, 0.667, -0.411> <0.227, 0.570, -0.409> 
		<0.289, 0.893, -0.366> <0.288, 0.796, -0.365> <0.296, 0.667, -0.375> <0.295, 0.570, -0.373> 
		<0.367, 0.893, -0.295> <0.366, 0.796, -0.295> <0.377, 0.667, -0.302> <0.375, 0.570, -0.301> 
		<0.408, 0.893, -0.231> <0.406, 0.796, -0.231> <0.418, 0.667, -0.237> <0.416, 0.570, -0.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.227, 0.570, -0.409> <0.226, 0.482, -0.407> <0.218, 0.366, -0.395> <0.214, 0.278, -0.389> 
		<0.295, 0.570, -0.373> <0.294, 0.482, -0.371> <0.283, 0.366, -0.361> <0.279, 0.278, -0.355> 
		<0.375, 0.570, -0.301> <0.373, 0.482, -0.300> <0.362, 0.366, -0.290> <0.355, 0.278, -0.286> 
		<0.416, 0.570, -0.236> <0.414, 0.482, -0.235> <0.401, 0.366, -0.228> <0.394, 0.278, -0.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 2.443, -0.451> <-0.032, 2.278, -0.454> <-0.032, 2.058, -0.455> <-0.032, 1.894, -0.460> 
		<0.045, 2.443, -0.451> <0.045, 2.278, -0.454> <0.046, 2.058, -0.455> <0.046, 1.894, -0.460> 
		<0.148, 2.443, -0.426> <0.149, 2.278, -0.429> <0.149, 2.058, -0.431> <0.152, 1.894, -0.435> 
		<0.215, 2.443, -0.391> <0.217, 2.278, -0.393> <0.218, 2.058, -0.394> <0.220, 1.894, -0.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 1.894, -0.460> <-0.032, 1.736, -0.465> <-0.032, 1.526, -0.483> <-0.032, 1.368, -0.484> 
		<0.046, 1.894, -0.460> <0.046, 1.736, -0.465> <0.050, 1.526, -0.483> <0.050, 1.368, -0.484> 
		<0.152, 1.894, -0.435> <0.154, 1.736, -0.439> <0.161, 1.526, -0.457> <0.161, 1.368, -0.457> 
		<0.220, 1.894, -0.399> <0.223, 1.736, -0.403> <0.233, 1.526, -0.419> <0.233, 1.368, -0.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 1.368, -0.484> <-0.032, 1.225, -0.484> <-0.032, 1.036, -0.465> <-0.032, 0.893, -0.463> 
		<0.050, 1.368, -0.484> <0.050, 1.225, -0.484> <0.047, 1.036, -0.465> <0.047, 0.893, -0.463> 
		<0.161, 1.368, -0.457> <0.161, 1.225, -0.458> <0.154, 1.036, -0.439> <0.153, 0.893, -0.437> 
		<0.233, 1.368, -0.419> <0.234, 1.225, -0.419> <0.223, 1.036, -0.403> <0.222, 0.893, -0.401> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.893, -0.463> <-0.032, 0.796, -0.462> <-0.032, 0.667, -0.474> <-0.032, 0.570, -0.472> 
		<0.047, 0.893, -0.463> <0.047, 0.796, -0.462> <0.048, 0.667, -0.474> <0.048, 0.570, -0.472> 
		<0.153, 0.893, -0.437> <0.152, 0.796, -0.436> <0.157, 0.667, -0.448> <0.156, 0.570, -0.446> 
		<0.222, 0.893, -0.401> <0.221, 0.796, -0.400> <0.228, 0.667, -0.411> <0.227, 0.570, -0.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.570, -0.472> <-0.032, 0.482, -0.470> <-0.032, 0.366, -0.456> <-0.032, 0.278, -0.449> 
		<0.048, 0.570, -0.472> <0.048, 0.482, -0.470> <0.044, 0.366, -0.456> <0.044, 0.278, -0.449> 
		<0.156, 0.570, -0.446> <0.155, 0.482, -0.444> <0.151, 0.366, -0.430> <0.147, 0.278, -0.424> 
		<0.227, 0.570, -0.409> <0.226, 0.482, -0.407> <0.218, 0.366, -0.395> <0.214, 0.278, -0.389> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.279, 2.443, -0.391> <-0.280, 2.278, -0.393> <-0.281, 2.058, -0.394> <-0.284, 1.894, -0.399> 
		<-0.211, 2.443, -0.426> <-0.213, 2.278, -0.429> <-0.212, 2.058, -0.431> <-0.215, 1.894, -0.435> 
		<-0.108, 2.443, -0.451> <-0.108, 2.278, -0.454> <-0.110, 2.058, -0.455> <-0.110, 1.894, -0.460> 
		<-0.032, 2.443, -0.451> <-0.032, 2.278, -0.454> <-0.032, 2.058, -0.455> <-0.032, 1.894, -0.460> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.284, 1.894, -0.399> <-0.287, 1.736, -0.403> <-0.297, 1.526, -0.419> <-0.297, 1.368, -0.419> 
		<-0.215, 1.894, -0.435> <-0.218, 1.736, -0.439> <-0.224, 1.526, -0.457> <-0.224, 1.368, -0.457> 
		<-0.110, 1.894, -0.460> <-0.110, 1.736, -0.465> <-0.114, 1.526, -0.483> <-0.114, 1.368, -0.484> 
		<-0.032, 1.894, -0.460> <-0.032, 1.736, -0.465> <-0.032, 1.526, -0.483> <-0.032, 1.368, -0.484> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.297, 1.368, -0.419> <-0.297, 1.225, -0.419> <-0.287, 1.036, -0.403> <-0.285, 0.893, -0.401> 
		<-0.224, 1.368, -0.457> <-0.225, 1.225, -0.458> <-0.217, 1.036, -0.439> <-0.216, 0.893, -0.437> 
		<-0.114, 1.368, -0.484> <-0.114, 1.225, -0.484> <-0.110, 1.036, -0.465> <-0.110, 0.893, -0.463> 
		<-0.032, 1.368, -0.484> <-0.032, 1.225, -0.484> <-0.032, 1.036, -0.465> <-0.032, 0.893, -0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.285, 0.893, -0.401> <-0.285, 0.796, -0.400> <-0.292, 0.667, -0.411> <-0.290, 0.570, -0.409> 
		<-0.216, 0.893, -0.437> <-0.215, 0.796, -0.436> <-0.221, 0.667, -0.448> <-0.220, 0.570, -0.446> 
		<-0.110, 0.893, -0.463> <-0.110, 0.796, -0.462> <-0.112, 0.667, -0.474> <-0.112, 0.570, -0.472> 
		<-0.032, 0.893, -0.463> <-0.032, 0.796, -0.462> <-0.032, 0.667, -0.474> <-0.032, 0.570, -0.472> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.290, 0.570, -0.409> <-0.289, 0.482, -0.407> <-0.281, 0.366, -0.395> <-0.278, 0.278, -0.389> 
		<-0.220, 0.570, -0.446> <-0.219, 0.482, -0.444> <-0.214, 0.366, -0.430> <-0.210, 0.278, -0.424> 
		<-0.112, 0.570, -0.472> <-0.112, 0.482, -0.470> <-0.108, 0.366, -0.456> <-0.108, 0.278, -0.449> 
		<-0.032, 0.570, -0.472> <-0.032, 0.482, -0.470> <-0.032, 0.366, -0.456> <-0.032, 0.278, -0.449> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.460, 2.443, -0.225> <-0.462, 2.278, -0.227> <-0.464, 2.058, -0.228> <-0.468, 1.894, -0.230> 
		<-0.420, 2.443, -0.288> <-0.423, 2.278, -0.289> <-0.424, 2.058, -0.291> <-0.428, 1.894, -0.294> 
		<-0.344, 2.443, -0.356> <-0.345, 2.278, -0.359> <-0.347, 2.058, -0.359> <-0.350, 1.894, -0.364> 
		<-0.279, 2.443, -0.391> <-0.280, 2.278, -0.393> <-0.281, 2.058, -0.394> <-0.284, 1.894, -0.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.468, 1.894, -0.230> <-0.473, 1.736, -0.233> <-0.490, 1.526, -0.242> <-0.491, 1.368, -0.242> 
		<-0.428, 1.894, -0.294> <-0.433, 1.736, -0.296> <-0.448, 1.526, -0.308> <-0.449, 1.368, -0.309> 
		<-0.350, 1.894, -0.364> <-0.353, 1.736, -0.368> <-0.366, 1.526, -0.382> <-0.367, 1.368, -0.382> 
		<-0.284, 1.894, -0.399> <-0.287, 1.736, -0.403> <-0.297, 1.526, -0.419> <-0.297, 1.368, -0.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.491, 1.368, -0.242> <-0.491, 1.225, -0.242> <-0.473, 1.036, -0.233> <-0.471, 0.893, -0.231> 
		<-0.449, 1.368, -0.309> <-0.449, 1.225, -0.309> <-0.433, 1.036, -0.296> <-0.431, 0.893, -0.295> 
		<-0.367, 1.368, -0.382> <-0.367, 1.225, -0.383> <-0.353, 1.036, -0.368> <-0.352, 0.893, -0.366> 
		<-0.297, 1.368, -0.419> <-0.297, 1.225, -0.419> <-0.287, 1.036, -0.403> <-0.285, 0.893, -0.401> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.471, 0.893, -0.231> <-0.470, 0.796, -0.231> <-0.482, 0.667, -0.237> <-0.480, 0.570, -0.236> 
		<-0.431, 0.893, -0.295> <-0.429, 0.796, -0.295> <-0.441, 0.667, -0.302> <-0.439, 0.570, -0.301> 
		<-0.352, 0.893, -0.366> <-0.351, 0.796, -0.365> <-0.360, 0.667, -0.375> <-0.358, 0.570, -0.373> 
		<-0.285, 0.893, -0.401> <-0.285, 0.796, -0.400> <-0.292, 0.667, -0.411> <-0.290, 0.570, -0.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.480, 0.570, -0.236> <-0.478, 0.482, -0.235> <-0.464, 0.366, -0.228> <-0.457, 0.278, -0.224> 
		<-0.439, 0.570, -0.301> <-0.437, 0.482, -0.300> <-0.425, 0.366, -0.290> <-0.418, 0.278, -0.286> 
		<-0.358, 0.570, -0.373> <-0.357, 0.482, -0.371> <-0.346, 0.366, -0.361> <-0.342, 0.278, -0.355> 
		<-0.290, 0.570, -0.409> <-0.289, 0.482, -0.407> <-0.281, 0.366, -0.395> <-0.278, 0.278, -0.389> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.526, 2.443, 0.000> <-0.529, 2.278, 0.000> <-0.531, 2.058, 0.000> <-0.536, 1.894, 0.000> 
		<-0.526, 2.443, -0.070> <-0.529, 2.278, -0.070> <-0.531, 2.058, -0.072> <-0.536, 1.894, -0.072> 
		<-0.497, 2.443, -0.166> <-0.500, 2.278, -0.167> <-0.502, 2.058, -0.167> <-0.507, 1.894, -0.169> 
		<-0.460, 2.443, -0.225> <-0.462, 2.278, -0.227> <-0.464, 2.058, -0.228> <-0.468, 1.894, -0.230> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.536, 1.894, 0.000> <-0.541, 1.736, 0.000> <-0.561, 1.526, 0.000> <-0.562, 1.368, 0.000> 
		<-0.536, 1.894, -0.072> <-0.541, 1.736, -0.072> <-0.561, 1.526, -0.076> <-0.562, 1.368, -0.076> 
		<-0.507, 1.894, -0.169> <-0.512, 1.736, -0.172> <-0.531, 1.526, -0.178> <-0.531, 1.368, -0.178> 
		<-0.468, 1.894, -0.230> <-0.473, 1.736, -0.233> <-0.490, 1.526, -0.242> <-0.491, 1.368, -0.242> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.562, 1.368, 0.000> <-0.562, 1.225, 0.000> <-0.541, 1.036, 0.000> <-0.539, 0.893, 0.000> 
		<-0.562, 1.368, -0.076> <-0.562, 1.225, -0.076> <-0.541, 1.036, -0.072> <-0.539, 0.893, -0.072> 
		<-0.531, 1.368, -0.178> <-0.532, 1.225, -0.178> <-0.512, 1.036, -0.171> <-0.510, 0.893, -0.170> 
		<-0.491, 1.368, -0.242> <-0.491, 1.225, -0.242> <-0.473, 1.036, -0.233> <-0.471, 0.893, -0.231> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.539, 0.893, 0.000> <-0.537, 0.796, 0.000> <-0.551, 0.667, 0.000> <-0.549, 0.570, 0.000> 
		<-0.539, 0.893, -0.072> <-0.537, 0.796, -0.072> <-0.551, 0.667, -0.074> <-0.549, 0.570, -0.074> 
		<-0.510, 0.893, -0.170> <-0.508, 0.796, -0.170> <-0.521, 0.667, -0.175> <-0.519, 0.570, -0.174> 
		<-0.471, 0.893, -0.231> <-0.470, 0.796, -0.231> <-0.482, 0.667, -0.237> <-0.480, 0.570, -0.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.549, 0.570, 0.000> <-0.547, 0.482, 0.000> <-0.531, 0.366, 0.000> <-0.523, 0.278, 0.000> 
		<-0.549, 0.570, -0.074> <-0.547, 0.482, -0.074> <-0.531, 0.366, -0.070> <-0.523, 0.278, -0.070> 
		<-0.519, 0.570, -0.174> <-0.517, 0.482, -0.173> <-0.502, 0.366, -0.169> <-0.495, 0.278, -0.165> 
		<-0.480, 0.570, -0.236> <-0.478, 0.482, -0.235> <-0.464, 0.366, -0.228> <-0.457, 0.278, -0.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.460, 2.443, 0.225> <-0.462, 2.278, 0.227> <-0.464, 2.058, 0.228> <-0.468, 1.894, 0.230> 
		<-0.497, 2.443, 0.166> <-0.500, 2.278, 0.167> <-0.502, 2.058, 0.167> <-0.507, 1.894, 0.169> 
		<-0.526, 2.443, 0.070> <-0.529, 2.278, 0.070> <-0.531, 2.058, 0.072> <-0.536, 1.894, 0.072> 
		<-0.526, 2.443, 0.000> <-0.529, 2.278, 0.000> <-0.531, 2.058, 0.000> <-0.536, 1.894, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.468, 1.894, 0.230> <-0.473, 1.736, 0.233> <-0.490, 1.526, 0.242> <-0.491, 1.368, 0.242> 
		<-0.507, 1.894, 0.169> <-0.512, 1.736, 0.172> <-0.531, 1.526, 0.178> <-0.531, 1.368, 0.178> 
		<-0.536, 1.894, 0.072> <-0.541, 1.736, 0.072> <-0.561, 1.526, 0.076> <-0.562, 1.368, 0.076> 
		<-0.536, 1.894, 0.000> <-0.541, 1.736, 0.000> <-0.561, 1.526, 0.000> <-0.562, 1.368, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.491, 1.368, 0.242> <-0.491, 1.225, 0.242> <-0.473, 1.036, 0.233> <-0.471, 0.893, 0.231> 
		<-0.531, 1.368, 0.178> <-0.532, 1.225, 0.178> <-0.512, 1.036, 0.171> <-0.510, 0.893, 0.170> 
		<-0.562, 1.368, 0.076> <-0.562, 1.225, 0.076> <-0.541, 1.036, 0.072> <-0.539, 0.893, 0.072> 
		<-0.562, 1.368, 0.000> <-0.562, 1.225, 0.000> <-0.541, 1.036, 0.000> <-0.539, 0.893, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.471, 0.893, 0.231> <-0.470, 0.796, 0.231> <-0.482, 0.667, 0.237> <-0.480, 0.570, 0.236> 
		<-0.510, 0.893, 0.170> <-0.508, 0.796, 0.170> <-0.521, 0.667, 0.175> <-0.519, 0.570, 0.174> 
		<-0.539, 0.893, 0.072> <-0.537, 0.796, 0.072> <-0.551, 0.667, 0.074> <-0.549, 0.570, 0.074> 
		<-0.539, 0.893, 0.000> <-0.537, 0.796, 0.000> <-0.551, 0.667, 0.000> <-0.549, 0.570, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.480, 0.570, 0.236> <-0.478, 0.482, 0.235> <-0.464, 0.366, 0.228> <-0.457, 0.278, 0.224> 
		<-0.519, 0.570, 0.174> <-0.517, 0.482, 0.173> <-0.502, 0.366, 0.169> <-0.495, 0.278, 0.165> 
		<-0.549, 0.570, 0.074> <-0.547, 0.482, 0.074> <-0.531, 0.366, 0.070> <-0.523, 0.278, 0.070> 
		<-0.549, 0.570, 0.000> <-0.547, 0.482, 0.000> <-0.531, 0.366, 0.000> <-0.523, 0.278, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.279, 2.443, 0.391> <-0.280, 2.278, 0.393> <-0.281, 2.058, 0.394> <-0.284, 1.894, 0.399> 
		<-0.344, 2.443, 0.356> <-0.345, 2.278, 0.359> <-0.347, 2.058, 0.359> <-0.350, 1.894, 0.364> 
		<-0.420, 2.443, 0.288> <-0.423, 2.278, 0.289> <-0.424, 2.058, 0.291> <-0.428, 1.894, 0.294> 
		<-0.460, 2.443, 0.225> <-0.462, 2.278, 0.227> <-0.464, 2.058, 0.228> <-0.468, 1.894, 0.230> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.284, 1.894, 0.399> <-0.287, 1.736, 0.403> <-0.297, 1.526, 0.419> <-0.297, 1.368, 0.419> 
		<-0.350, 1.894, 0.364> <-0.353, 1.736, 0.368> <-0.366, 1.526, 0.382> <-0.367, 1.368, 0.382> 
		<-0.428, 1.894, 0.294> <-0.433, 1.736, 0.296> <-0.448, 1.526, 0.308> <-0.449, 1.368, 0.309> 
		<-0.468, 1.894, 0.230> <-0.473, 1.736, 0.233> <-0.490, 1.526, 0.242> <-0.491, 1.368, 0.242> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.297, 1.368, 0.419> <-0.297, 1.225, 0.419> <-0.287, 1.036, 0.403> <-0.285, 0.893, 0.401> 
		<-0.367, 1.368, 0.382> <-0.367, 1.225, 0.383> <-0.353, 1.036, 0.368> <-0.352, 0.893, 0.366> 
		<-0.449, 1.368, 0.309> <-0.449, 1.225, 0.309> <-0.433, 1.036, 0.296> <-0.431, 0.893, 0.295> 
		<-0.491, 1.368, 0.242> <-0.491, 1.225, 0.242> <-0.473, 1.036, 0.233> <-0.471, 0.893, 0.231> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.285, 0.893, 0.401> <-0.285, 0.796, 0.400> <-0.292, 0.667, 0.411> <-0.290, 0.570, 0.409> 
		<-0.352, 0.893, 0.366> <-0.351, 0.796, 0.365> <-0.360, 0.667, 0.375> <-0.358, 0.570, 0.373> 
		<-0.431, 0.893, 0.295> <-0.429, 0.796, 0.295> <-0.441, 0.667, 0.302> <-0.439, 0.570, 0.301> 
		<-0.471, 0.893, 0.231> <-0.470, 0.796, 0.231> <-0.482, 0.667, 0.237> <-0.480, 0.570, 0.236> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.290, 0.570, 0.409> <-0.289, 0.482, 0.407> <-0.281, 0.366, 0.395> <-0.278, 0.278, 0.389> 
		<-0.358, 0.570, 0.373> <-0.357, 0.482, 0.371> <-0.346, 0.366, 0.361> <-0.342, 0.278, 0.355> 
		<-0.439, 0.570, 0.301> <-0.437, 0.482, 0.300> <-0.425, 0.366, 0.290> <-0.418, 0.278, 0.286> 
		<-0.480, 0.570, 0.236> <-0.478, 0.482, 0.235> <-0.464, 0.366, 0.228> <-0.457, 0.278, 0.224> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 2.443, 0.451> <-0.032, 2.278, 0.454> <-0.032, 2.058, 0.455> <-0.032, 1.894, 0.460> 
		<-0.108, 2.443, 0.451> <-0.108, 2.278, 0.454> <-0.110, 2.058, 0.455> <-0.110, 1.894, 0.460> 
		<-0.211, 2.443, 0.426> <-0.213, 2.278, 0.429> <-0.212, 2.058, 0.431> <-0.215, 1.894, 0.435> 
		<-0.279, 2.443, 0.391> <-0.280, 2.278, 0.393> <-0.281, 2.058, 0.394> <-0.284, 1.894, 0.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 1.894, 0.460> <-0.032, 1.736, 0.465> <-0.032, 1.526, 0.483> <-0.032, 1.368, 0.484> 
		<-0.110, 1.894, 0.460> <-0.110, 1.736, 0.465> <-0.114, 1.526, 0.483> <-0.114, 1.368, 0.484> 
		<-0.215, 1.894, 0.435> <-0.218, 1.736, 0.439> <-0.224, 1.526, 0.457> <-0.224, 1.368, 0.457> 
		<-0.284, 1.894, 0.399> <-0.287, 1.736, 0.403> <-0.297, 1.526, 0.419> <-0.297, 1.368, 0.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 1.368, 0.484> <-0.032, 1.225, 0.484> <-0.032, 1.036, 0.465> <-0.032, 0.893, 0.463> 
		<-0.114, 1.368, 0.484> <-0.114, 1.225, 0.484> <-0.110, 1.036, 0.465> <-0.110, 0.893, 0.463> 
		<-0.224, 1.368, 0.457> <-0.225, 1.225, 0.458> <-0.217, 1.036, 0.439> <-0.216, 0.893, 0.437> 
		<-0.297, 1.368, 0.419> <-0.297, 1.225, 0.419> <-0.287, 1.036, 0.403> <-0.285, 0.893, 0.401> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.893, 0.463> <-0.032, 0.796, 0.462> <-0.032, 0.667, 0.474> <-0.032, 0.570, 0.472> 
		<-0.110, 0.893, 0.463> <-0.110, 0.796, 0.462> <-0.112, 0.667, 0.474> <-0.112, 0.570, 0.472> 
		<-0.216, 0.893, 0.437> <-0.215, 0.796, 0.436> <-0.221, 0.667, 0.448> <-0.220, 0.570, 0.446> 
		<-0.285, 0.893, 0.401> <-0.285, 0.796, 0.400> <-0.292, 0.667, 0.411> <-0.290, 0.570, 0.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.032, 0.570, 0.472> <-0.032, 0.482, 0.470> <-0.032, 0.366, 0.456> <-0.032, 0.278, 0.449> 
		<-0.112, 0.570, 0.472> <-0.112, 0.482, 0.470> <-0.108, 0.366, 0.456> <-0.108, 0.278, 0.449> 
		<-0.220, 0.570, 0.446> <-0.219, 0.482, 0.444> <-0.214, 0.366, 0.430> <-0.210, 0.278, 0.424> 
		<-0.290, 0.570, 0.409> <-0.289, 0.482, 0.407> <-0.281, 0.366, 0.395> <-0.278, 0.278, 0.389> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.215, 2.443, 0.391> <0.217, 2.278, 0.393> <0.218, 2.058, 0.394> <0.220, 1.894, 0.399> 
		<0.148, 2.443, 0.426> <0.149, 2.278, 0.429> <0.149, 2.058, 0.431> <0.152, 1.894, 0.435> 
		<0.045, 2.443, 0.451> <0.045, 2.278, 0.454> <0.046, 2.058, 0.455> <0.046, 1.894, 0.460> 
		<-0.032, 2.443, 0.451> <-0.032, 2.278, 0.454> <-0.032, 2.058, 0.455> <-0.032, 1.894, 0.460> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.220, 1.894, 0.399> <0.223, 1.736, 0.403> <0.233, 1.526, 0.419> <0.233, 1.368, 0.419> 
		<0.152, 1.894, 0.435> <0.154, 1.736, 0.439> <0.161, 1.526, 0.457> <0.161, 1.368, 0.457> 
		<0.046, 1.894, 0.460> <0.046, 1.736, 0.465> <0.050, 1.526, 0.483> <0.050, 1.368, 0.484> 
		<-0.032, 1.894, 0.460> <-0.032, 1.736, 0.465> <-0.032, 1.526, 0.483> <-0.032, 1.368, 0.484> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.233, 1.368, 0.419> <0.234, 1.225, 0.419> <0.223, 1.036, 0.403> <0.222, 0.893, 0.401> 
		<0.161, 1.368, 0.457> <0.161, 1.225, 0.458> <0.154, 1.036, 0.439> <0.153, 0.893, 0.437> 
		<0.050, 1.368, 0.484> <0.050, 1.225, 0.484> <0.047, 1.036, 0.465> <0.047, 0.893, 0.463> 
		<-0.032, 1.368, 0.484> <-0.032, 1.225, 0.484> <-0.032, 1.036, 0.465> <-0.032, 0.893, 0.463> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.222, 0.893, 0.401> <0.221, 0.796, 0.400> <0.228, 0.667, 0.411> <0.227, 0.570, 0.409> 
		<0.153, 0.893, 0.437> <0.152, 0.796, 0.436> <0.157, 0.667, 0.448> <0.156, 0.570, 0.446> 
		<0.047, 0.893, 0.463> <0.047, 0.796, 0.462> <0.048, 0.667, 0.474> <0.048, 0.570, 0.472> 
		<-0.032, 0.893, 0.463> <-0.032, 0.796, 0.462> <-0.032, 0.667, 0.474> <-0.032, 0.570, 0.472> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.227, 0.570, 0.409> <0.226, 0.482, 0.407> <0.218, 0.366, 0.395> <0.214, 0.278, 0.389> 
		<0.156, 0.570, 0.446> <0.155, 0.482, 0.444> <0.151, 0.366, 0.430> <0.147, 0.278, 0.424> 
		<0.048, 0.570, 0.472> <0.048, 0.482, 0.470> <0.044, 0.366, 0.456> <0.044, 0.278, 0.449> 
		<-0.032, 0.570, 0.472> <-0.032, 0.482, 0.470> <-0.032, 0.366, 0.456> <-0.032, 0.278, 0.449> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.396, 2.443, 0.225> <0.399, 2.278, 0.227> <0.400, 2.058, 0.228> <0.405, 1.894, 0.230> 
		<0.357, 2.443, 0.288> <0.360, 2.278, 0.289> <0.360, 2.058, 0.291> <0.365, 1.894, 0.294> 
		<0.280, 2.443, 0.356> <0.282, 2.278, 0.359> <0.284, 2.058, 0.359> <0.287, 1.894, 0.364> 
		<0.215, 2.443, 0.391> <0.217, 2.278, 0.393> <0.218, 2.058, 0.394> <0.220, 1.894, 0.399> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.405, 1.894, 0.230> <0.410, 1.736, 0.233> <0.427, 1.526, 0.242> <0.427, 1.368, 0.242> 
		<0.365, 1.894, 0.294> <0.370, 1.736, 0.296> <0.385, 1.526, 0.308> <0.385, 1.368, 0.309> 
		<0.287, 1.894, 0.364> <0.289, 1.736, 0.368> <0.303, 1.526, 0.382> <0.303, 1.368, 0.382> 
		<0.220, 1.894, 0.399> <0.223, 1.736, 0.403> <0.233, 1.526, 0.419> <0.233, 1.368, 0.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.427, 1.368, 0.242> <0.428, 1.225, 0.242> <0.410, 1.036, 0.233> <0.408, 0.893, 0.231> 
		<0.385, 1.368, 0.309> <0.386, 1.225, 0.309> <0.369, 1.036, 0.296> <0.367, 0.893, 0.295> 
		<0.303, 1.368, 0.382> <0.303, 1.225, 0.383> <0.290, 1.036, 0.368> <0.289, 0.893, 0.366> 
		<0.233, 1.368, 0.419> <0.234, 1.225, 0.419> <0.223, 1.036, 0.403> <0.222, 0.893, 0.401> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.408, 0.893, 0.231> <0.406, 0.796, 0.231> <0.418, 0.667, 0.237> <0.416, 0.570, 0.236> 
		<0.367, 0.893, 0.295> <0.366, 0.796, 0.295> <0.377, 0.667, 0.302> <0.375, 0.570, 0.301> 
		<0.289, 0.893, 0.366> <0.288, 0.796, 0.365> <0.296, 0.667, 0.375> <0.295, 0.570, 0.373> 
		<0.222, 0.893, 0.401> <0.221, 0.796, 0.400> <0.228, 0.667, 0.411> <0.227, 0.570, 0.409> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.416, 0.570, 0.236> <0.414, 0.482, 0.235> <0.401, 0.366, 0.228> <0.394, 0.278, 0.224> 
		<0.375, 0.570, 0.301> <0.373, 0.482, 0.300> <0.362, 0.366, 0.290> <0.355, 0.278, 0.286> 
		<0.295, 0.570, 0.373> <0.294, 0.482, 0.371> <0.283, 0.366, 0.361> <0.279, 0.278, 0.355> 
		<0.227, 0.570, 0.409> <0.226, 0.482, 0.407> <0.218, 0.366, 0.395> <0.214, 0.278, 0.389> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.088, 2.080, -0.385> <-0.037, 2.080, -0.461> <0.010, 2.080, -0.583> <0.084, 2.080, -0.639> 
		<-0.086, 2.111, -0.383> <-0.034, 2.111, -0.459> <-0.001, 2.158, -0.549> <0.072, 2.158, -0.604> 
		<-0.050, 2.137, -0.362> <-0.040, 2.148, -0.374> <0.008, 2.157, -0.464> <0.026, 2.162, -0.466> 
		<-0.034, 2.161, -0.352> <-0.023, 2.172, -0.364> <-0.017, 2.192, -0.390> <0.002, 2.197, -0.392> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.084, 2.080, -0.639> <0.117, 2.080, -0.664> <0.184, 2.080, -0.637> <0.222, 2.080, -0.620> 
		<0.072, 2.158, -0.604> <0.105, 2.158, -0.630> <0.165, 2.162, -0.599> <0.203, 2.162, -0.582> 
		<0.026, 2.162, -0.466> <0.055, 2.170, -0.469> <0.108, 2.162, -0.455> <0.135, 2.162, -0.441> 
		<0.002, 2.197, -0.392> <0.031, 2.205, -0.395> <0.071, 2.197, -0.378> <0.098, 2.197, -0.365> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.222, 2.080, -0.620> <0.301, 2.080, -0.584> <0.402, 2.080, -0.524> <0.467, 2.080, -0.467> 
		<0.203, 2.162, -0.582> <0.283, 2.162, -0.547> <0.376, 2.163, -0.492> <0.440, 2.163, -0.434> 
		<0.135, 2.162, -0.441> <0.194, 2.162, -0.411> <0.288, 2.162, -0.355> <0.339, 2.162, -0.314> 
		<0.098, 2.197, -0.365> <0.157, 2.197, -0.335> <0.233, 2.197, -0.289> <0.284, 2.197, -0.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.467, 2.080, -0.467> <0.494, 2.080, -0.442> <0.529, 2.080, -0.389> <0.519, 2.080, -0.353> 
		<0.440, 2.163, -0.434> <0.468, 2.163, -0.409> <0.503, 2.157, -0.365> <0.493, 2.157, -0.329> 
		<0.339, 2.162, -0.314> <0.359, 2.162, -0.298> <0.383, 2.170, -0.254> <0.389, 2.162, -0.230> 
		<0.284, 2.197, -0.248> <0.305, 2.197, -0.232> <0.328, 2.205, -0.201> <0.333, 2.197, -0.177> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.519, 2.080, -0.353> <0.494, 2.080, -0.268> <0.409, 2.080, -0.178> <0.362, 2.080, -0.104> 
		<0.493, 2.157, -0.329> <0.469, 2.157, -0.244> <0.406, 2.111, -0.180> <0.359, 2.111, -0.105> 
		<0.389, 2.162, -0.230> <0.392, 2.157, -0.213> <0.332, 2.148, -0.139> <0.325, 2.137, -0.127> 
		<0.333, 2.197, -0.177> <0.336, 2.192, -0.160> <0.316, 2.172, -0.149> <0.309, 2.161, -0.138> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.082, 1.616, -0.395> <-0.031, 1.616, -0.471> <0.017, 1.616, -0.593> <0.090, 1.616, -0.648> 
		<-0.082, 1.756, -0.395> <-0.031, 1.756, -0.471> <0.017, 1.756, -0.593> <0.090, 1.756, -0.648> 
		<-0.101, 1.942, -0.396> <-0.049, 1.942, -0.472> <0.030, 1.954, -0.639> <0.103, 1.954, -0.694> 
		<-0.088, 2.080, -0.385> <-0.037, 2.080, -0.461> <0.010, 2.080, -0.583> <0.084, 2.080, -0.639> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.090, 1.616, -0.648> <0.123, 1.616, -0.673> <0.190, 1.616, -0.646> <0.228, 1.616, -0.629> 
		<0.090, 1.756, -0.648> <0.123, 1.756, -0.673> <0.190, 1.756, -0.646> <0.228, 1.756, -0.629> 
		<0.103, 1.954, -0.694> <0.136, 1.954, -0.719> <0.211, 1.956, -0.693> <0.249, 1.956, -0.676> 
		<0.084, 2.080, -0.639> <0.117, 2.080, -0.664> <0.184, 2.080, -0.637> <0.222, 2.080, -0.620> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.228, 1.616, -0.629> <0.307, 1.616, -0.594> <0.408, 1.616, -0.534> <0.473, 1.616, -0.476> 
		<0.228, 1.756, -0.629> <0.307, 1.756, -0.594> <0.408, 1.756, -0.534> <0.473, 1.756, -0.476> 
		<0.249, 1.956, -0.676> <0.329, 1.956, -0.641> <0.442, 1.956, -0.573> <0.507, 1.956, -0.515> 
		<0.222, 2.080, -0.620> <0.301, 2.080, -0.584> <0.402, 2.080, -0.524> <0.467, 2.080, -0.467> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.473, 1.616, -0.476> <0.501, 1.616, -0.451> <0.535, 1.616, -0.399> <0.525, 1.616, -0.363> 
		<0.473, 1.756, -0.476> <0.501, 1.756, -0.451> <0.535, 1.756, -0.399> <0.525, 1.756, -0.363> 
		<0.507, 1.956, -0.515> <0.535, 1.956, -0.490> <0.571, 1.954, -0.430> <0.560, 1.954, -0.394> 
		<0.467, 2.080, -0.467> <0.494, 2.080, -0.442> <0.529, 2.080, -0.389> <0.519, 2.080, -0.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.525, 1.616, -0.363> <0.500, 1.616, -0.278> <0.415, 1.616, -0.188> <0.368, 1.616, -0.113> 
		<0.525, 1.756, -0.363> <0.500, 1.756, -0.278> <0.415, 1.756, -0.188> <0.368, 1.756, -0.113> 
		<0.560, 1.954, -0.394> <0.536, 1.954, -0.309> <0.424, 1.942, -0.172> <0.378, 1.942, -0.097> 
		<0.519, 2.080, -0.353> <0.494, 2.080, -0.268> <0.409, 2.080, -0.178> <0.362, 2.080, -0.104> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.090, 1.616, -0.648> <0.090, 1.464, -0.648> <0.086, 1.260, -0.642> <0.084, 1.108, -0.639> 
		<0.017, 1.616, -0.593> <0.017, 1.464, -0.593> <0.013, 1.260, -0.586> <0.010, 1.108, -0.583> 
		<-0.031, 1.616, -0.471> <-0.031, 1.464, -0.471> <-0.035, 1.260, -0.465> <-0.037, 1.108, -0.461> 
		<-0.082, 1.616, -0.395> <-0.082, 1.464, -0.395> <-0.086, 1.260, -0.388> <-0.088, 1.108, -0.385> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.084, 1.108, -0.639> <0.082, 0.995, -0.636> <0.080, 0.844, -0.644> <0.078, 0.733, -0.629> 
		<0.010, 1.108, -0.583> <0.009, 0.995, -0.581> <0.007, 0.844, -0.589> <0.004, 0.733, -0.573> 
		<-0.037, 1.108, -0.461> <-0.038, 0.995, -0.459> <-0.045, 0.845, -0.460> <-0.043, 0.733, -0.451> 
		<-0.088, 1.108, -0.385> <-0.090, 0.995, -0.383> <-0.096, 0.845, -0.384> <-0.094, 0.733, -0.375> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.078, 0.733, -0.629> <0.077, 0.702, -0.625> <0.075, 0.670, -0.591> <0.074, 0.644, -0.574> 
		<0.004, 0.733, -0.573> <0.004, 0.702, -0.569> <0.009, 0.670, -0.542> <0.008, 0.644, -0.525> 
		<-0.043, 0.733, -0.451> <-0.042, 0.705, -0.449> <-0.038, 0.670, -0.425> <-0.033, 0.644, -0.417> 
		<-0.094, 0.733, -0.375> <-0.094, 0.705, -0.373> <-0.084, 0.670, -0.357> <-0.079, 0.644, -0.349> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.228, 1.616, -0.629> <0.228, 1.464, -0.629> <0.224, 1.260, -0.623> <0.222, 1.108, -0.620> 
		<0.190, 1.616, -0.646> <0.190, 1.464, -0.646> <0.186, 1.260, -0.640> <0.184, 1.108, -0.637> 
		<0.123, 1.616, -0.673> <0.123, 1.464, -0.673> <0.119, 1.260, -0.667> <0.117, 1.108, -0.664> 
		<0.090, 1.616, -0.648> <0.090, 1.464, -0.648> <0.086, 1.260, -0.642> <0.084, 1.108, -0.639> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.222, 1.108, -0.620> <0.220, 0.995, -0.617> <0.221, 0.844, -0.625> <0.216, 0.733, -0.610> 
		<0.184, 1.108, -0.637> <0.182, 0.995, -0.634> <0.183, 0.844, -0.642> <0.178, 0.733, -0.627> 
		<0.117, 1.108, -0.664> <0.116, 0.995, -0.661> <0.113, 0.844, -0.670> <0.111, 0.733, -0.654> 
		<0.084, 1.108, -0.639> <0.082, 0.995, -0.636> <0.080, 0.844, -0.644> <0.078, 0.733, -0.629> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.216, 0.733, -0.610> <0.214, 0.702, -0.606> <0.203, 0.670, -0.573> <0.198, 0.644, -0.557> 
		<0.178, 0.733, -0.627> <0.176, 0.702, -0.623> <0.169, 0.670, -0.588> <0.163, 0.644, -0.573> 
		<0.111, 0.733, -0.654> <0.110, 0.702, -0.650> <0.105, 0.670, -0.613> <0.104, 0.644, -0.597> 
		<0.078, 0.733, -0.629> <0.077, 0.702, -0.625> <0.075, 0.670, -0.591> <0.074, 0.644, -0.574> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.473, 1.616, -0.476> <0.473, 1.464, -0.476> <0.469, 1.260, -0.470> <0.467, 1.108, -0.467> 
		<0.408, 1.616, -0.534> <0.408, 1.464, -0.534> <0.404, 1.260, -0.528> <0.402, 1.108, -0.524> 
		<0.307, 1.616, -0.594> <0.307, 1.464, -0.594> <0.303, 1.260, -0.588> <0.301, 1.108, -0.584> 
		<0.228, 1.616, -0.629> <0.228, 1.464, -0.629> <0.224, 1.260, -0.623> <0.222, 1.108, -0.620> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.467, 1.108, -0.467> <0.465, 0.995, -0.464> <0.472, 0.844, -0.468> <0.461, 0.733, -0.457> 
		<0.402, 1.108, -0.524> <0.401, 0.995, -0.522> <0.408, 0.844, -0.526> <0.396, 0.733, -0.515> 
		<0.301, 1.108, -0.584> <0.299, 0.995, -0.582> <0.301, 0.844, -0.589> <0.295, 0.733, -0.574> 
		<0.222, 1.108, -0.620> <0.220, 0.995, -0.617> <0.221, 0.844, -0.625> <0.216, 0.733, -0.610> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.461, 0.733, -0.457> <0.457, 0.701, -0.454> <0.431, 0.670, -0.431> <0.418, 0.644, -0.419> 
		<0.396, 0.733, -0.515> <0.393, 0.701, -0.512> <0.373, 0.670, -0.483> <0.360, 0.644, -0.472> 
		<0.295, 0.733, -0.574> <0.293, 0.702, -0.570> <0.274, 0.670, -0.541> <0.269, 0.644, -0.525> 
		<0.216, 0.733, -0.610> <0.214, 0.702, -0.606> <0.203, 0.670, -0.573> <0.198, 0.644, -0.557> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.525, 1.616, -0.363> <0.525, 1.464, -0.363> <0.521, 1.260, -0.357> <0.519, 1.108, -0.353> 
		<0.535, 1.616, -0.399> <0.535, 1.464, -0.399> <0.531, 1.260, -0.393> <0.529, 1.108, -0.389> 
		<0.501, 1.616, -0.451> <0.501, 1.464, -0.451> <0.497, 1.260, -0.445> <0.494, 1.108, -0.442> 
		<0.473, 1.616, -0.476> <0.473, 1.464, -0.476> <0.469, 1.260, -0.470> <0.467, 1.108, -0.467> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.519, 1.108, -0.353> <0.517, 0.995, -0.351> <0.525, 0.844, -0.352> <0.512, 0.733, -0.344> 
		<0.529, 1.108, -0.389> <0.527, 0.995, -0.387> <0.536, 0.844, -0.388> <0.523, 0.733, -0.380> 
		<0.494, 1.108, -0.442> <0.493, 0.995, -0.439> <0.500, 0.844, -0.443> <0.488, 0.733, -0.432> 
		<0.467, 1.108, -0.467> <0.465, 0.995, -0.464> <0.472, 0.844, -0.468> <0.461, 0.733, -0.457> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.512, 0.733, -0.344> <0.509, 0.702, -0.341> <0.479, 0.670, -0.325> <0.465, 0.644, -0.318> 
		<0.523, 0.733, -0.380> <0.519, 0.702, -0.377> <0.488, 0.670, -0.358> <0.474, 0.644, -0.350> 
		<0.488, 0.733, -0.432> <0.485, 0.701, -0.429> <0.456, 0.670, -0.408> <0.443, 0.644, -0.397> 
		<0.461, 0.733, -0.457> <0.457, 0.701, -0.454> <0.431, 0.670, -0.431> <0.418, 0.644, -0.419> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.368, 1.616, -0.113> <0.368, 1.464, -0.113> <0.364, 1.260, -0.107> <0.362, 1.108, -0.104> 
		<0.415, 1.616, -0.188> <0.415, 1.464, -0.188> <0.411, 1.260, -0.182> <0.409, 1.108, -0.178> 
		<0.500, 1.616, -0.278> <0.500, 1.464, -0.278> <0.496, 1.260, -0.272> <0.494, 1.108, -0.268> 
		<0.525, 1.616, -0.363> <0.525, 1.464, -0.363> <0.521, 1.260, -0.357> <0.519, 1.108, -0.353> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.362, 1.108, -0.104> <0.361, 0.995, -0.101> <0.365, 0.845, -0.096> <0.356, 0.733, -0.094> 
		<0.409, 1.108, -0.178> <0.408, 0.995, -0.176> <0.412, 0.845, -0.171> <0.403, 0.733, -0.169> 
		<0.494, 1.108, -0.268> <0.493, 0.995, -0.266> <0.501, 0.844, -0.267> <0.488, 0.733, -0.259> 
		<0.519, 1.108, -0.353> <0.517, 0.995, -0.351> <0.525, 0.844, -0.352> <0.512, 0.733, -0.344> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.356, 0.733, -0.094> <0.354, 0.705, -0.093> <0.335, 0.670, -0.095> <0.326, 0.644, -0.096> 
		<0.403, 0.733, -0.169> <0.401, 0.705, -0.168> <0.377, 0.670, -0.162> <0.368, 0.644, -0.162> 
		<0.488, 0.733, -0.259> <0.484, 0.702, -0.256> <0.458, 0.670, -0.250> <0.443, 0.644, -0.242> 
		<0.512, 0.733, -0.344> <0.509, 0.702, -0.341> <0.479, 0.670, -0.325> <0.465, 0.644, -0.318> 
	}
texture { BagTex }
}

