
// POV-Ray Object File - Golf Players
// created 16-Sep-02
// last update 21-Sep-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Golfers.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// Golfer2 // has just hit a 7 iron, feet point to -Y, face points to +X
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Golfer origin is at the center of his feet
// Height extends into +Z

#ifndef (ThisIsMaster) // now we know this include file was not called by another
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc" // for testing only
#end

//===============================================
//             Includes
//===============================================

#include "golfer2.inc"


//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================


//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#declare SixFootCyl =
	cylinder { <0,0,0>,<0,0,6*Feet>,11 texture { pigment { rgb<1,1,1> } } }
#declare Golfer2 =
	object { golfer2_object scale 93 rotate <90,0,0> }


//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
		location  <1, -20*Feet, 5.5*Feet> // overall
		look_at <0*Feet,0*Feet,4*Feet>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 1*Feet }
/*
plane {
  z,0
  texture {
    pigment { crackle solid
    scale 20
    turbulence 0.5
    color_map {
    	[ 0.0 rgb<0.01,0.11,0.01> ]
    	[ 1.0 rgb<0.86,0.92,0.82> ]
    }
   	}
  }
}
*/
//object { TestSphere scale 20 translate <0,0,20> }

object { SixFootCyl translate <36,0,0> }
object { Golfer2 scale 1 rotate x*0 translate <0,0,0> }


#end
