
// POV-Ray Object File - A Marina
// created 6-Oct-02
// last update 27-Oct-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Marina.inc" in another .pov file
// Required #include files: "GIncludeRH.inc", "Boats.inc"
//
// Objects:
// Marina
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Marina origin is at the left main dock, at the high-tide waterline
// Sky is up

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#include "Boats.inc"
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here


//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare PlainBrownTex =
	texture {
		pigment { color rgb <0.451,0.329,0.157>*1.00 }
		normal { bumps 0.2 scale <2,3,6> }
		finish { specular 0.23 roughness 0.34 }
	}

#declare PilingTex =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.00 rgb <0.451,0.329,0.167>*0.63 ] // muddy dark brown
				[ 0.12 rgb <0.263,0.124,0.067>*0.23 ] // black tar
				[ 0.60 rgb <0.451,0.329,0.167>*0.63 ] // low tide waterline
				[ 0.80 rgb <0.451,0.329,0.167>*0.99 ] // high tide waterline
				[ 0.85 rgb <0.751,0.729,0.767>*0.99 ] // dark white paint
				[ 0.99 rgb <0.751,0.729,0.767>*0.99 ] // white paint
			}
    	turbulence 0.13
		}
		finish { specular 0.30 roughness 0.24 }
	}

//===============================================
//             Macros
//===============================================

#macro DockMacro(XLength,YWidth)
	#declare XL = XLength;
	union {
		box { // main dock base
			<0,8,0>,<XL,YWidth-8,10>
			translate <0,0,-12>
			texture { PlainBrownTex }
		}
		box { // boardwalk
			<0,0,-2>,<XL,YWidth,0>
			texture { PlainBrownTex }
		}
		#local RS = seed(74928);
		#local PC = 1;
		#while (PC < XL)
			cylinder {
				<0,0,-10*Feet>,<0,0,48>,6.5
				translate <PC,0,-1*Feet+rand(RS)*2*Feet>
				texture { PilingTex scale 14*Feet translate z*-10*Feet}

			}
			cylinder {
				<0,0,-10*Feet>,<0,0,48>,6.5
				translate <PC,YWidth,-1*Feet+rand(RS)*2*Feet>
				texture { PilingTex scale 14*Feet translate z*-10*Feet}

			}
			#local PC = PC + 8*Feet;
		#end
	} // end union
#end

//===============================================
//             Objects
//===============================================

#declare Docks =
	union {
		object { DockMacro(130*Feet,12*Feet) } // goes away from shore
		object { DockMacro(81*Feet,10*Feet) rotate z*90 translate <10*Feet,12*Feet,0> } // shoreline
		object { DockMacro(60*Feet,6*Feet) rotate z*90 translate <36*Feet,12*Feet,0> } // middle 1
		object { DockMacro(60*Feet,6*Feet) rotate z*90 translate <74*Feet,12*Feet,0> } //middle 2 
		object { DockMacro(81*Feet,10*Feet) rotate z*90 translate <124*Feet,12*Feet,0> } // far end
		translate <0,0,4*Feet> // set above waterline
	} // end union

#declare MarinaGroup =
	union {
		object { Docks }
		object { TwoMastedSchooner scale <0.4,0.5,0.6> rotate z*90 translate <20*Feet,80*Feet,0> }
		object { TwoMastedSchooner scale 0.6 rotate z*90 translate <40*Feet,50*Feet,0> }
		object { CatamaranS rotate z*90 translate <78*Feet,30*Feet,8> }
		object { TwoMastedSchooner scale <0.83,1.1,1.1> rotate z*-90 translate <108*Feet,50*Feet,0> }
		object { CatamaranS scale <1.8,1.2,1.3> rotate z*90 translate <131*Feet,60*Feet,20> }
	} // end union



//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 40
		location  <0*Feet, -180*Feet, 92*Feet> // overall
		look_at <1*Feet,0*Feet,8*Feet>
	}


light_source
{ <400*Feet,-350*Feet,500*Feet>, 2.0
  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
light_source
{ <-400*Feet,-200*Feet,300*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
plane { z,-0 pigment { checker rgb <.6,.6,.82,>, rgb <.2,.2,.45> } scale 10*Feet }


object { MarinaGroup scale 1 rotate z*-110 translate <0,100*Feet,0> }
  

#end
