
// Glenn's POV-Ray Object File - Vegetation
// created 28-Sep-02
// last update 27-Oct-02
// 2002 Glenn McCarter  ( glenn@mccarters.net )
//
// This file does not render.  #include "Vegetation.inc" in another .pov file
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// PalmTreeS -- simple version
// PalmTree -- detailed version
// TropicalPlant1
// WeedGroup
// FarTreeGroup(Quality,Number,XLength,YLength)
//
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Sky is up

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// temporary sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// mandatory sub includes go here


//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare PalmTrunkTex =
	texture {
		pigment { color rgb <0.565,0.502,0.424>*1.20 }
		finish { specular 0.13 roughness 0.24 }
	}


#declare PalmTrunkPig1 =
		pigment {
			gradient z
			color_map {

//				[ 0.0 color rgb <0.565,0.502,0.424>*1.20 ]
//				[ 0.6 color rgb <0.565,0.502,0.394>*0.35 ]
//				[ 0.9 color rgb <0.565,0.502,0.424>*1.20 ]

				[ 0.1 color rgb <0.565,0.502,0.424>*1.80 ]
				[ 0.6 color rgb <0.565,0.502,0.394>*0.35 ]
				[ 0.8 color rgb <0.565,0.502,0.424>*1.80 ]

//				[ 0.0 color rgbt<1,1,1,1> ]
			}
			turbulence 0.4
			scale <2,2,2>
		}
#declare PalmTrunkPig2 =
		pigment {
			crackle
			color_map {
//				[ 0.1 color rgb <0.565,0.502,0.424>*0.80 ]
//				[ 0.5 color rgb <0.565,0.502,0.424>*0.20 ]
//				[ 0.9 color rgb <0.565,0.502,0.424>*0.80 ]
				[ 0.2 color rgb <0.565,0.502,0.424>*1.40 ]
				[ 0.5 color rgb <0.565,0.502,0.424>*0.20 ]
				[ 0.8 color rgb <0.565,0.502,0.424>*1.40 ]
			}
			turbulence 0.01
			scale <1,1,6>
		}

#declare PalmTrunkDetailTex =
	texture {
		pigment {
			average
			pigment_map { // weights
				[ 1.0 PalmTrunkPig1 ]
				[ 1.0 PalmTrunkPig2 ]
			}
			scale 6
		}
//		normal { bumps 0.3 scale 1 }
//		finish { specular 0.13 roughness 0.24 }
	}

#declare PalmTrunkDetailSpotsTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.6 color rgbt<0.565,0.502,0.294,1.0> ]
				[ 0.7 color rgb<0.565,0.502,0.294>*0.20 ]
			}
			scale 1.3
		}
//		normal { bumps 0.3 scale 1 }
		finish { specular 0.13 roughness 0.24 }
	}

#declare DS = seed(47826);
#macro DLeavesPig(HeightShift)
//	pigment {
		bozo
		color_map {
			[ 0.20 rgbf<0.0,0.2,0.0,0.0> ]
			[ 0.50 rgbf<0.0,0.8,0.0,1-HeightShift> ]
			[ 0.60 rgbt<0.1,1.0,0.1,1.0> ]
		}
		translate <rand(DS)*100,rand(DS)*100,rand(DS)*100,>
//		scale 0.3
//	}
#end
//#declare DistantTreeTex =
#macro DistantTreeTex(HeightShift)
//	texture {
		pigment {
			spherical
			pigment_map {
				[ 0.00 rgbt<1,1,1,1> ]
				[ 0.50 DLeavesPig(HeightShift) scale 0.06 ]
			}
			turbulence 0.2

		}
		finish { ambient .5-HeightShift/2 diffuse 0.6 specular 0.0 roughness 0.10 }
//	}
#end

//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

//------------------ Trees ----------------------

#declare PalmLeafS = // simple version
	difference {
	sphere {
		<0,0,0>,90
		scale <1,.7,1>
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
//					png "TestImageMap.png"
					png "PalmLeafS.png"
					once
				}
				scale <180,180,1>
				translate <-90,-90,0>
			}
//			finish { specular 0.75 roughness .121 }
		}
	}
	box { // cut off bottom half of sphere
		<-100,-90,-100>,<100,90,0>
		texture { pigment { rgbt<1,1,1,1> } }
	}
	translate <90,0,0>
	} // end difference
#declare PalmTreeS = // simple version
	union {
		sphere_sweep {
			b_spline
			8,
			<0,0,-12>,12,
			<0,0,0>,14, // base
			<1,0,24>,12
			<1,0,29>,9
			<5,0,6*Feet>,8,
			<9,10,18*Feet>,6,
			<30,-2,24*Feet>,4
			<36,-4,26*Feet>,4
			texture { PalmTrunkTex }
		}
		#local Tip = <30,-2,23.0*Feet>;
		object { PalmLeafS rotate <0,38,0> translate Tip }
		object { PalmLeafS rotate <0,34,50> translate Tip }
		object { PalmLeafS rotate <0,30,120> translate Tip }
		object { PalmLeafS rotate <0,18,220> translate Tip }
		object { PalmLeafS rotate <0,28,300> translate Tip }
		object { PalmLeafS scale .57 rotate <0,38,18> translate Tip }
		object { PalmLeafS scale .67 rotate <0,34,138> translate Tip }
		object { PalmLeafS scale .78 rotate <0,30,246> translate Tip }
		object { PalmLeafS scale .67 rotate <0,18,328> translate Tip }
		scale <1,1,1.3>
	} // end union

#declare PalmLeaf = // detailed version
	difference {
	sphere {
		<0,0,0>,90
		scale <1,.7,1>
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
//					png "TestImageMap.png"
					png "PalmLeaf.png"
					once
				}
				scale <180,60,1>
				translate <-90,-30,0>
			}
//			finish { specular 0.75 roughness .121 }
		}
	}
	box { // cut off bottom half of sphere
		<-100,-90,-100>,<100,90,0>
		texture { pigment { rgbt<1,1,1,1> } }
	}
	translate <90,0,0>
	} // end difference

#declare PalmTree = // detailed version
	union {
		sphere_sweep {
			b_spline
			8,
			<0,0,-12>,12,
			<0,0,0>,14, // base
			<1,0,24>,12
			<1,0,29>,9
			<5,0,6*Feet>,8,
			<9,10,18*Feet>,6,
			<30,-2,24*Feet>,4
			<36,-4,26*Feet>,4
			texture { PalmTrunkDetailTex }
			texture { PalmTrunkDetailSpotsTex }
		}
		#local Tip = <30,-2,23.0*Feet>;
		object { PalmLeaf rotate <0,38,0> translate Tip }
		object { PalmLeaf rotate <0,34,50> translate Tip }
		object { PalmLeaf rotate <0,30,120> translate Tip }
		object { PalmLeaf rotate <0,18,220> translate Tip }
		object { PalmLeaf rotate <0,28,300> translate Tip }
		object { PalmLeaf scale .57 rotate <0,38,18> translate Tip }
		object { PalmLeaf scale .67 rotate <0,34,138> translate Tip }
		object { PalmLeaf scale .78 rotate <0,30,246> translate Tip }
		object { PalmLeaf scale .67 rotate <0,18,321> translate Tip }
	} // end union


#macro TreeCluster(TCount,MaxRadius)
	union {
		#declare TS = seed(23098);
		#local TC = 0;
		#while ( TC < TCount )
			object { PalmTree
				scale (0.8+rand(TS)*.46)
				rotate z*rand(TS)*360
				translate <rand(TS)*MaxRadius,0*Feet,0>
				rotate z*rand(TS)*360
			}
			#local TC = TC + 1;
		#end
	} // end union
#end


//----------- This tree is only to create shadows ------------

#declare ShadowPalmLeaf =
	difference {
	sphere {
		<0,0,0>,90
		scale <1,.7,1>
		texture {
//			pigment {
				image_pattern { // projected from -Z, with top left at <0,1,0>
//					png "TestImageMap.png"
					png "PalmLeaf.png"
					use_alpha
					once
				}
				texture_map {
					[ 0.0 pigment { color rgbf<0.3,0.8,0.3,0.2> } ]
					[ 1.0 pigment { color rgbt<1,1,1,1> } ]

				}
				scale <180,180,1>
				translate <-90,-90,0>
//			}
//			finish { specular 0.75 roughness .121 }
		}
	}
	box { // cut off bottom half of sphere
		<-100,-90,-100>,<100,90,0>
		texture { pigment { rgbt<1,1,1,1> } }
	}
	translate <90,0,0>
	} // end difference
#declare ShadowPalmTree = // use only for creating light shadows
	union {
		sphere_sweep {
			b_spline
			8,
			<0,0,-12>,12,
			<0,0,0>,14, // base
			<1,0,24>,12
			<1,0,29>,9
			<5,0,6*Feet>,8,
			<9,10,18*Feet>,6,
			<30,-2,24*Feet>,4
			<36,-4,26*Feet>,4
			texture { pigment { color rgbt<0.565,0.502,0.294,0.4> } }
		}
		#local Tip = <30,-2,23.0*Feet>;
		object { ShadowPalmLeaf rotate <0,38,0> translate Tip }
		object { ShadowPalmLeaf rotate <0,34,50> translate Tip }
		object { ShadowPalmLeaf rotate <0,30,120> translate Tip }
		object { ShadowPalmLeaf rotate <0,18,220> translate Tip }
		object { ShadowPalmLeaf rotate <0,28,300> translate Tip }
		object { ShadowPalmLeaf scale .57 rotate <0,38,18> translate Tip }
		object { ShadowPalmLeaf scale .67 rotate <0,34,138> translate Tip }
		object { ShadowPalmLeaf scale .78 rotate <0,30,246> translate Tip }
		object { ShadowPalmLeaf scale .67 rotate <0,18,328> translate Tip }

		object { ShadowPalmLeaf scale .62 rotate <0,-80,34> translate Tip }
		object { ShadowPalmLeaf scale .64 rotate <0,-64,155> translate Tip }
		object { ShadowPalmLeaf scale .57 rotate <0,-70,271> translate Tip }
		object { ShadowPalmLeaf scale .50 rotate <0,-88,352> translate Tip }

		scale <1,1,1.3>
	} // end union

//------------------ Plants ----------------------

#declare VegLeaf1 =
	difference {
	torus {
		10,10
		scale <1,1,1>
		texture {
//PalmTrunkTex }

			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "VegLeaf1.png"
					once
				}
				translate -0.5
				scale <35,35,1>
				rotate x*-90
			}
//			finish { specular 0.75 roughness .121 }
		}

	}
	box { // cut off half
		<-21,-21,-21>,<21,0,21>
		texture { pigment { rgbt<1,1,1,1> } }
	}
	rotate <90,0,0>
	} // end difference

#declare TropicalPlant1 =
	union {
		#local RS = seed(98524);
		#local LC = 1;
		#while (LC < 8)
			object { VegLeaf1
//				scale (-0.1+rand(RS)*0.2)*(1/(LC+7/8))
//				scale (-0.1+rand(RS)*0.2)+(1/(LC+7/8))
				scale (8/(LC+7))
				rotate <0,0,rand(RS)*LC*230>
				translate <0,0,LC*4-3>
			}
			#local LC = LC + 1;
			object { VegLeaf1 scale <.3,.3,.1> translate <0,0,2> }
			object { VegLeaf1 scale <.5,.5,.2> rotate z*20 translate <0,0,3> }
		#end
	} // end union


//------------------ Weeds ----------------------

#declare WeedGroup =
	box {
		<0,0,0>,<1,1,1>
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "WeedsImage.png"
					once
					map_type 0 // planar
					interpolate 2 // bilinear
				}
			}
			scale <1,1,1>
		}
		rotate x*90
		scale <4*Feet,.01,2*Feet>
	}
#declare WeedBox = // this is for testing
	box { <0,0,0>,<4*Feet,.01,2*Feet>
		texture { pigment { rgb<1,1,1> } }
	}

//-------------- Distant Forest -----------------


#declare TRS = seed(17305);

#macro FarTree(Quality)
	union {
		sphere { <0,0,0>,2
			#local RfS = TRS;
			#local RandSize = rand(RfS);
			#if ( Quality = 1 )
				texture { DistantTreeTex(RandSize) translate <0,0,-2>}
			#else
				scale 0.4
				texture { pigment { rgb<0.1,0.8,0.1> } }
			#end
			scale <15*Feet+RandSize*17*Feet,15*Feet+RandSize*17*Feet,15*Feet+RandSize*17*Feet>
			rotate x*-60
			translate <0,0,60*Feet-RandSize*40*Feet>
		}

		cone { // basic trunk
			<0,0,0>,6,<0,0,-80*Feet+RandSize*40*Feet>,12
			texture { PalmTrunkTex }
			rotate <-10+rand(RfS)*20,-10+rand(RfS)*20,0>
			translate <0,-RandSize*0.6*17*Feet,40*Feet-RandSize*40*Feet>
		}
	} // end union
#end

#macro FarTreeGroup(Quality,No,XLength,YLength)
	union {
		#local RfS = TRS;
		#local KJ = 0;
		#while ( KJ < No )
			object { FarTree(Quality)
				translate <rand(RfS)*XLength,rand(RfS)*YLength,rand(RfS)*20*Feet>
			}
			#local KJ = KJ + 1;
		#end
	} // end union
#end



//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

global_settings {	max_trace_level 50 }
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
//		angle 40
//		location  <1, -44*Feet, 42*Feet> // overall
//		look_at <0*Feet,0,26*Feet>
		angle 40
		location  <1, -40*Feet, 6*Feet> // ground
		look_at <0*Feet,0,6*Feet>
//		angle 30
//		location  <1, -8*Feet, 4*Feet> // small plant
//		look_at <0*Feet,0,1*Feet>
	}


light_source
{ <-1000*Feet,-300*Feet,1500*Feet>, 2.0
//{ <140*Feet,-135*Feet,150*Feet>, 2.0
//  spotlight point_at <0,0*Feet,2*Feet> radius 15 falloff 26
}
/*
light_source
{ <-140*Feet,-120*Feet,130*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
*/
background { color rgb <0.390,0.618,0.849>*.99 }
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 10 }
//object { TestSphere scale 20 translate <0,0,20> }

//object { ShadowPalmTree scale 1 rotate z*0 translate <20*Feet,-20*Feet,0> }
//object { PalmTree scale 1 rotate z*0 translate <0,0,0> }
//object { PalmTreeS scale 1 rotate z*0 translate <0,0,0> }
//object { TropicalPlant1 scale 1 rotate z*0 translate <0,0,0> }
//object { WeedGroup scale 1 rotate z*0 translate <-2*Feet,0,0> }
object { FarTreeGroup(0,42,300*Feet,100*Feet) rotate z*-0 translate <-130*Feet,400*Feet,20*Feet> }

#end
