#include "units.inc"   //arbitrary definition of units - 1 pov unit = 1 cm
#include "colors.inc" 

// +H180 +W320
// +H450 +w800
// +H450 +w800 +A0.3
// +H603 +w1072 +A0.3

// +h180 +w400
// +h450 +w1000 +a0.0 //use this
// +h540 +w1200 +A0.3
// +h675 +w1500
// +h900 +w2000

#local func = false;        //always set to false
#local do_sky = true;
#local do_rad = true; 
#local do_high_res_hf = false;     

#local do_arthur = false;
#local do_fenchurch = false;
#local do_marvin = true;

#local do_robot = false;

//#####################################################################

global_settings{ 
    ambient_light 0
    #if(do_rad)
        #include "rad_def.inc"
        #local rad_type = 6;  //type 1
        radiosity {
            Rad_Settings(rad_type,0,0) 
            save_file "rad_data.rad"
            //load_file "rad_data.rad" 
        }
    #end   
}
//#####################################################################
//#include "skies.inc"
#if(do_sky)
sky_sphere{
    pigment{
        gradient y
        pigment_map{
            [0 NewTan]    //horizon
            [1 Khaki]
        }
    }
} 
#local Cloud=
texture{
    pigment{
        wrinkles
        pigment_map{
            [0 White filter 1 ]
            [0.5 White filter 0.5]
            [1 White filter 1]
        }
        turbulence 0.2
        scale <1,1,5>*1000000
    }
} 
   
plane{y,8*km hollow texture{Cloud} }  
#end
//#####################################################################
#local fn_mountain = function{pattern{wood translate <0.5,0.5,0> turbulence 0.04}}
#local mountains =
#if(func)
    height_field{
        function 200,200 {-fn_mountain(x,y,0)} 
        smooth
        translate <-0.5,0,-0.5> 
        scale <2*km,500*m,2*km>
        pigment{ 
            wrinkles
            pigment_map{
                
            }
        }
    } 
#else
    height_field{
        //png "thisone1_largeblur.png" 
        //png "new.png" 
        #if(do_high_res_hf)
            tga "output.tga"    //use this for final render 
        #else
            jpeg "output256.jpeg"   //use this for test renders (low-res hf)   
        #end
        //smooth
        scale <7680*m,2000*m,7680*m>
        pigment{ 
            gradient y
            pigment_map{
                [0 color rgb <40,16,8>/255*3]
                [1 color rgb <96,56,40>/255*3]
            } 
            scale 4*km
            //turbulence 0.1
        } 
        no_shadow
    } 
#end  
#local MIN = min_extent(mountains);
#local MAX = max_extent(mountains); 
#debug concat("\nhf bounding\n min = <",vstr(3,MIN/m,",",0,1),">\n max = <",vstr(3,MAX/m,",",0,1),">\n")
mountains  

//##################################################################### 
#local cam_pos = trace(mountains,<1620*m,2*km,1620*m>,-y) + 2*m*y;
#local cam_look = <4620, 1109.9,  3360>*m;
#debug concat("\n camera position = <",vstr(3,cam_pos/m,",",0,1),"> m")
#debug concat("\n camera look_at  = <",vstr(3,cam_look/m,",",0,1),"> m\n\n")
// perspective (default) camera
camera {
  location  cam_pos
  look_at   cam_look   
  right     x*image_width/image_height
} 

//#####################################################################  
// Sun  
#local sun_pos = <tan(radians(30)),tan(radians(20)),1>*10*km;
light_source {
  0*x                 
  color rgb <96,72,56>/255*5
  translate sun_pos  
} 
// toplight
light_source {
  0*x                  // light's position (translated below)
  color rgb <48,36,28>/255*2   // light's color
  translate <0,100*km,0>
  //shadowless
} 
// reverse light
light_source {
  0*x                  // light's position (translated below)
  color rgb <48,36,28>/255*3  // light's color
  translate <-sun_pos.x,sun_pos.y,-sun_pos.z>
  shadowless
} 
//#####################################################################
#macro Position(Angle,dist,POS) 
    #local dir = vnormalize(cam_look - cam_pos);
    #local temp = (dist * <dir.x,0,dir.z>);
    #local temp = vrotate(temp,Angle.y) + <cam_pos.x,2*km,cam_pos.z>; 
    #local POS = trace(mountains,temp,-y);
#end   

//#####################################################################
#if(!do_marvin & do_robot)
    #include "poser/robot.inc"
    #local MIN = min_extent(robot);
    #local MAX = max_extent(robot);    
    
    #local robot_pos = <0,0,0>;
    Position(25,20*m,robot_pos)
    object{robot rotate 80*y scale 2*m/(MAX.y-MIN.y) translate robot_pos }  
#end

//#####################################################################
#declare group = 
union{  
    #if(do_marvin) #include "poser/marvin.inc"  object{marvin} #end 
    #if(do_arthur) #include "poser/arthur.inc"  object{Arthur} #end
    #if(do_fenchurch) #include "poser/fenchurch.inc" #object{fenchurch} #end
}

#local group_min = min_extent(group);
#local group_max = max_extent(group); 

#local group_pos = <0,0,0>;
Position(20,30*m,group_pos)   

object{group rotate 45*y scale 2*m/(group_max.y-group_min.y) translate group_pos}
//#####################################################################
 /*
#local String = "WE APOLOGISE FOR THE INCONVENIENCE";

#local text_pos = <0,0,0>;
Position(-30,100*m,text_pos)
#local Text = 
text{
    ttf "lucon.ttf" String 1*m, 0     
} 

#local MIN = min_extent(Text);
#local MAX = max_extent(Text);    
#local Size = 30*foot / (MAX.y-MIN.y);
object{Text 
    scale <Size,Size,1>  //extremely poor attempt at a fire texture
    pigment{
        agate
        pigment_map{
            [0 Red]
            [1 Yellow]
        }
    }
    rotate 45*y 
    translate text_pos
}     
     */