#macro MakeWindow(win_w, win_h, win_t)
	#local win_w_2 = win_w/2;
	#local win_h_2 = win_h/2;
	#local win_t_2 = win_t/2;
	// 
	union {
		difference {
			box {
				<-win_w_2, 0, -win_t_2>, <win_w_2, win_h, win_t_2>
			}
			box {
				<-win_w_2+win_t, win_t, -win_t_2-0.1>, <win_w_2-win_t, win_h-win_t, win_t_2+0.1>
			}
			//pigment { color Green }
			texture {
				pigment {
					color rgb <0.46, 0.60, 0.29>
				}
				normal {
					granite, 0.3
					scale 0.3
				}
			}
		}

		// 		
		box {
			<-win_w_2+win_t, win_t, -win_t_2/4>, <win_w_2-win_t, win_h-win_t, win_t_2/4>
			//pigment { color Blue }
			texture {
		    finish {
				    ambient 0.1
				    diffuse 0.1
				    reflection .25
				    specular 1
				    roughness 0.001
				}
		    pigment { color rgbf <0.8, 0.9, 0.85, 0.15> }
			}
		}
	}
#end

#macro MakeHouse(w, l, h, r)
#local w_2 = w/2;
#local l_2 = l/2;
#local h_2 = h/2;

#local win_w = h/3;
#local win_h = h/2;
#local win_t = win_w/8;

union {
	union {
		//   
		box {
			<-w_2, 0, -l_2>, <w_2, h, l_2>
		}
				
		pigment {
			brick color Black, color rgb 0.8
			scale 0.03
		}		
	}

	#local num_wnd = floor(w/win_w/2); //  
	#local win_dw = (w-num_wnd*win_w)/(num_wnd + 2); //   
	#local wnd_x = -w_2 + win_w + win_dw;
	#while(num_wnd > 0)
		object {
			MakeWindow(win_w, win_h, win_t)
			translate <wnd_x, h/3, -l_2>
		}
		object {
			MakeWindow(win_w, win_h, win_t)
			translate <wnd_x, h/3, l_2>
		}
		#local num_wnd = num_wnd-1;
		#local wnd_x = wnd_x + win_w + win_dw;
	#end
	         
	// 
	isosurface {
		function { abs(z)-1+y + 0.05*sin(x*40) }
		contained_by { box {<-w_2*1.1, 0, -w_2>, <w_2, h, w_2*1.1> } }
		max_gradient 2.2
		
		pigment { color rgb <0.8, 0, 0> }
		
		scale <1, 0.5, l/w*1.5>
		
		translate <0, h, 0>
	}
	
	// 
	#local boxwidth = min(w, l)/2;
	#local boxwidth_2 = boxwidth/2;
	#local boxheight = 2*h/3;
	difference {
		box {
			<-boxwidth_2, 0, -boxwidth_2>, <boxwidth_2, boxheight, boxwidth_2>
			pigment {
				brick color Black, color rgb 0.8
				scale 0.03
			}			
		}
		box {
			<-boxwidth_2, 0, -boxwidth_2>, <boxwidth_2, boxheight, boxwidth_2>
			scale <0.8, 1.01, 0.8>
			pigment { color Black }
		}
		
		translate <w_2/2, h, l_2/2>
	}
}

#end
