
global_settings { max_trace_level 12 }

background{color rgb 1}
#declare film_size = 0.035;
#declare focal_length = 0.05;
#declare aspect_ratio = image_height / image_width;
camera{perspective
      location <0,0,0>
      direction <0,focal_length,0>
      right <film_size,0,0>
      up <0,0,film_size*aspect_ratio>
      rotate<-20,0,0>translate<0,0,55>
}
light_source{<1e6,-1e5,1e6>color rgb <0.9,0.9,0.9>}
light_source{<-1e6,-1e4,1e5> color rgb 0.1 shadowless}
global_settings{ambient_light rgb 0.5}

// =====================================================================
// Atmosphere
sphere{<0,0,0>, 310 pigment{color rgbt<1,1,1,1>}
       interior{media{emission 0.0021}}
       hollow
}

// Sky
plane{z, 350
      texture{pigment{bozo turbulence 0.65 octaves 6 omega 0.7 lambda 2
                  color_map{[0 color rgb<0.2,0.3,0.5>]
                            [1 color rgb<1,1,1>]}
                  scale <800,2000,800>}
              finish{ambient 1}}
      hollow no_shadow}

// =====================================================================
// Near falls function
#macro waterfall1_surface( t0, t1 )
  #local px = -45 + 40*t0 - 40*pow(t1,4) + t1 * 15;
  #local py = 20+100*t1;
  #local pz = 48 - 48*pow(t0,7);
  #local px = px + pow(t0,2)*3.0*sin(t1*2*pi*6-0.4)
                 + pow(t0,2)*0.25*sin(t1*2*pi*30);
  #local pv = <px,py,pz>;
  (pv)
#end

// =====================================================================
// Near falls surface
#declare ni = 150;
#declare nj = 500;
#declare p = array[ni][nj]
#declare n = array[ni][nj]
#declare dt = 0.00001;

#declare i = 0;
#while(i < ni)
  #declare t0 = i / (ni-1);
  #declare j = 0;
  #while(j < nj)

    #declare t1 = j / (nj-1);
    #declare p[i][j] = waterfall1_surface( t0, t1 );
    #declare p0 = waterfall1_surface( t0+dt, t1 );
    #declare p1 = waterfall1_surface( t0, t1+dt );
    #declare n[i][j] = vnormalize(vcross(p[i][j]-p0,p[i][j]-p1));

  #declare j = j + 1;
  #end
  #declare i = i + 1;
#end

mesh{

  #declare i = 0;
  #while(i < ni-1)

    #declare j = 0;
    #while(j < nj-1)

      #declare n0 = n[i][j];
      #declare p0 = p[i][j];
      #declare u0 = abs(n0.x);
      #declare v0 = abs(n0.y);

      #declare n1 = n[i][j+1];
      #declare p1 = p[i][j+1];
      #declare u1 = abs(n1.x);
      #declare v1 = abs(n1.y);

      #declare n2 = n[i+1][j+1];
      #declare p2 = p[i+1][j+1];
      #declare u2 = abs(n2.x);
      #declare v2 = abs(n2.y);

      #declare n3 = n[i+1][j];
      #declare p3 = p[i+1][j];
      #declare u3 = abs(n3.x);
      #declare v3 = abs(n3.y);

     smooth_triangle{p0,n0,p1,n1,p2,n2 uv_vectors <u0,v0>,<u1,v1>,<u2,v2>}
     smooth_triangle{p2,n2,p3,n3,p0,n0 uv_vectors <u2,v2>,<u3,v3>,<u0,v0>}

      #declare j = j + 1;
    #end

    #declare i = i + 1;
  #end

  texture{
          pigment{uv_mapping image_map{png "nearmap.png" interpolate 4}}
          finish{diffuse 1 phong 1 ambient rgb 0.5} 
         }
}

// =====================================================================
// Near falls spray

#declare nj = 370; // streams
#declare ni = 600; // blobs per stream

#declare R1 = seed(1);
#declare j=0;
#while (j<nj)
  #declare tj = j / (nj-1);

  #declare t1 = pow(tj,1.8) * 0.6 + rand(R1) * 0.05;
  #declare t0_start = 0.75 + rand(R1) * 0.05;

  blob{threshold 0.2

  #declare i=0;
  #while (i<ni)
     #declare ti = i / (ni-1);
     #declare t0 = t0_start+ti*(1-t0_start);
     #declare p = waterfall1_surface(t0,t1);
     #declare tr = rand(R1);
     #declare tr = tr * tr;

     #declare r0 = 0.04 + 0.8*pow(ti,2);
     #declare r1 = 0.04 + 0.2*pow(ti,2);
     #declare rad = r0 + tr*(r1-r0);     
     #declare theta = 0.6*pi * (2*rand(R1)-1);
     #declare rv =
         <cos(theta),sin(theta),0.4*rand(R1)-0.2>*(pow(ti,3)*12)*tr;

     sphere{p+rv, rad, 1}

    #declare i=i+1;
  #end
  pigment{colour rgb <0.5,0.6,0.8>}
  finish{ambient 0.3 diffuse 1 phong 1 phong_size 2}

  }// end blob

  #declare j=j+1;
#end

// ====================================================================
// Near falls mist
merge{
   #declare p0 = <0,55,3>;
   #declare s0 = <35,30,50>;

   #declare p1 = <0,35,3>;
   #declare s1 = <35,30,50>;

   #declare p2 = <0,20,3>;
   #declare s2 = <35,30,50>;

   #declare p3 = <-2,12,3>;
   #declare s3 = <35,30,50>;

   sphere{<0,0,0>,1 scale s0 translate p0
          pigment{color rgbt<1,1,1,1>}}
   sphere{<0,0,0>,1 scale s1 translate p1
          pigment{color rgbt<1,1,1,1>}}
   sphere{<0,0,0>,1 scale s2 translate p2
          pigment{color rgbt<1,1,1,1>}}
   sphere{<0,0,0>,1 scale s3 translate p3
          pigment{color rgbt<1,1,1,1>}}

   interior{
            // 0
            media{scattering{2, 0.03 extinction 2.5}
                  emission 0.03
                  density {spherical scale 0.5 
                           warp{turbulence 0.7 omega 0.6}
                           scale s0 translate p0
                          }                 
                 }

            // 1
            media{scattering{2, 0.04 extinction 2.5}
                  emission 0.03
                  density {spherical scale 0.5 
                           warp{turbulence 0.7 omega 0.6}
                           scale s1 translate p1
                          }                 
                 }

            // 2
            media{scattering{2, 0.04 extinction 2.5}
                  emission 0.03
                  density {spherical  scale 0.5 
                           warp{turbulence 0.7 omega 0.6}
                           rotate<0,0,-10>
                           scale s2 translate p2
                          }
                 }

            // 3
            media{scattering{2, 0.06 extinction 2.5}
                  emission 0.07
                  density {spherical scale 0.5 
                           warp{turbulence 0.6 omega 0.6}
                           scale s3 translate p3
                          }                 
                 }

           } // end interior
  hollow
} // end merge

// =====================================================================
// Far falls function
#macro waterfall2_surface( t0, t1 )
  #local rad = 110 - t0*30 +
           pow(t0,2)*3*(sin(t1*31)+sin(t1*67)+sin(t1*111));
  #local theta = 0.5 + 2.5*t1;
  #local px = 15 + rad * cos(theta);
  #local py = 200 + rad * sin(theta);
  #local pz = 50 - 50*pow(t0,2);
  (<px,py,pz>)
#end

// ====================================================================
// Far falls surface
#declare ni = 200;
#declare nj = 300;
#declare p = array[ni][nj]
#declare n = array[ni][nj]
#declare dt = 0.00001;

#declare i = 0;
#while(i < ni)
  #declare t0 = i / (ni-1);
  #declare j = 0;
  #while(j < nj)

    #declare t1 = j / (nj-1);
    #declare p[i][j] = waterfall2_surface( t0, t1 );
    #declare p0 = waterfall2_surface( t0+dt, t1 );
    #declare p1 = waterfall2_surface( t0, t1+dt );
    #declare n[i][j] = vnormalize(vcross(p[i][j]-p0,p[i][j]-p1));

    #declare j = j + 1;
  #end
  #declare i = i + 1;
#end

mesh{

  #declare i = 0;
  #while(i < ni-1)

    #declare j = 0;
    #while(j < nj-1)

      #declare n0 = n[i][j];
      #declare p0 = p[i][j];
      #declare n1 = n[i][j+1];
      #declare p1 = p[i][j+1];
      #declare n2 = n[i+1][j+1];
      #declare p2 = p[i+1][j+1];
      #declare n3 = n[i+1][j];
      #declare p3 = p[i+1][j];

      smooth_triangle{p0,n0,p1,n1,p2,n2}
      smooth_triangle{p2,n2,p3,n3,p0,n0}

      #declare j = j + 1;
    #end

    #declare i = i + 1;
  #end

  texture{
   pigment{bozo turbulence 0.65 octaves 6 omega 0.7 lambda 2
           color_map{[0 color rgb<0.0,0.05,0.1>]
                     [1 color rgb<0.55,0.6,0.7>]}
           scale <2,2,20>}
   finish{diffuse 0.9 phong 0.3 phong_size 30 ambient rgb 0.5}
   normal{bumps 0.5 scale 0.4}}
}

// ====================================================================
// Far falls mist
#declare R4 = seed(3);
#declare ni=7;
#declare tm = 0.8;
#declare s = <70,70,45>;

merge{

  #declare i=0;
  #while (i<ni)
    #declare t1 = i/(ni-1);
    #declare p = waterfall2_surface(1,tm*t1);
    sphere{<0,0,0>, 1 pigment{color rgbt<1,1,1,1>}   
           scale s translate p no_shadow hollow }
    #declare i=i+1;
  #end

  interior{
           #declare i=0;
           #while (i<ni)
             #declare t1 = i/(ni-1);
             #declare p = waterfall2_surface(1,tm*t1);
             media{ scattering{2, 0.02
                     extinction 4.0
                         }
                   //emission 0.001
                   density {spherical scale 0.7
                            warp{turbulence 0.2 omega 0.6}}
                   rotate<rand(R4)*360,rand(R4)*360,rand(R4)*360>
                   scale s
                   translate p
                   }

             #declare i=i+1;
          #end
          } // end interior
 hollow
} // end merge

// =====================================================================
// Tree line
#declare R3 = seed(1);
#declare w = 250;
#declare d = 340;
#declare p3 = <-0.5*w,d,48>;
#declare h = 8.0;
#declare p2 = p3 + <0,0,h>;
#declare i=1;
#declare ni=500;
mesh{

  #while (i<ni)

    #declare t1 = i/(ni-1);
    #declare p0 = p3;
    #declare p1 = p2;

    #declare p3 = <-0.5*w+t1*w,d,48>;
    #declare h = h + (2*rand(R3)-1) * 0.7;
    #if (h < 7.0)
      #declare h = 7.0;
    #end
    #if (h > 11.0)
      #declare h = 11.0;
    #end
    #declare p2 = p3 + <0,0,h>;

    triangle{p0,p1,p2}
    triangle{p2,p3,p0}

    #declare i=i+1;
  #end

  texture{
          pigment{bozo scale <2.0,1,2.0>
                  color_map{[0 color rgb<0.0,0.0,0.0>]
                            [1 color rgb<0.5,0.5,0.1>]}}

          finish{ambient rgb 0.2}
         }
} // end mesh

// =====================================================================
// Lagoon
#declare p1 = pigment{bozo
                      turbulence 0.65 octaves 6 omega 0.7 lambda 2
                      colour_map{[0.0 colour rgb<0.0,0.0,0.0>]
                                 [0.5 colour rgb<0.5,0.6,0.7>]
                                 [1.0 colour rgb<1.0,1.0,1.0>]}
                      scale 0.02};
#declare p2 = pigment{bozo
                      turbulence 0.65 octaves 6 omega 0.7 lambda 2
                      colour_map{[0.0 colour rgb<0.0,0.0,0.0>]
                                 [0.5 colour rgb<0.0,0.1,0.2>]
                                 [1.0 colour rgb<1.0,1.0,1.0>]}
                      scale 0.005};

plane{z, 0
      pigment{gradient y phase -0.2 poly_wave 0.6 scale 240
              pigment_map{[0 p2][1 p1]} }

      // Ripples around boat
      normal{cylindrical poly_wave 2 rotate<90,0,0> scale<30,40,30>
              normal_map{[0 bumps 0]
                         [1 bumps 5 scale 0.02]}
              rotate<0,0,25> translate<35,140,0>
             }   
      finish{ambient 0.4 diffuse 0.9 phong 5 phong_size 8}
}

// =====================================================================
// Maid of the Mist
difference{
  height_field{png "boatmap.png"
               translate<-0.5,0,-0.5>
               rotate<90,0,180> scale<12,20,5>
               texture{
                       pigment{bozo scale<0.5,1,0.3>
                               color_map{[0 color rgb<0.5,0.6,0.7>]
                                         [1 color rgb<1.0,1.0,1.0>]}}
                       finish{ambient 0.1 diffuse 3.0}}
              }
  union{
        box{<-15, -8.0,1.8><15,-10,3>pigment{color rgbt <1,1,1,1>}}
        box{<-15, -5.7,1.8><15,-7.7,3>pigment{color rgbt <1,1,1,1>}}
        box{<-15, -5.4,1.8><15,-3.4,3>pigment{color rgbt <1,1,1,1>}}
        box{<-15, -3.1,1.8><15,-2.1,3>pigment{color rgbt <1,1,1,1>}}

        box{<-15,-1.8,1.8><15,-0.8,3>pigment{color rgbt <1,1,1,1>}}

        box{<-15,-0.5,1.8><15,0.5,3>pigment{color rgbt <1,1,1,1>}}
        box{<-15, 0.8,1.8><15,2.8,3>pigment{color rgbt <1,1,1,1>}}

        box{<-15, 3.1,1.8><15,6,3>pigment{color rgbt <1,1,1,1>}}

        box{<-1.5, 4.2,3.8><1.5,5.1,4.8>pigment{color rgbt <1,1,1,1>}}

       }
  rotate<0,0,25>
  translate<35,140,-0.1>
}

// Person
#declare cape = union{
  sphere{<0,0,0>,0.2 scale<1,1,1.3>translate<0,0,1.5>}
  cone{<0,0,0>,0.35 <0,0,1.5>, 0.15}
  texture{pigment{color rgb<0.6,0.7,1.0>}
          finish{ambient 0.3 diffuse 1 phong 1 phong_size 20}
          normal{bumps 0.5 scale 0.2}
         }
}

// Lower deck people
#declare R5 = seed(1);
#declare ni=50;
#declare i=0;
#while (i<ni)
  #declare ti = i/(ni-1);
  object{cape rotate<0,0,rand(R5)*360>
         translate<(2*rand(R5)-1)*2.7, -7.5+ti*15, 0>
         rotate<0,0,25>translate<35,140,1>}

  #declare i=i+1;
#end

// Upper deck people
#declare R5 = seed(4);
#declare ni=31;
#declare i=0;
#while (i<ni)
  #declare ti = i/(ni-1);
  object{cape rotate<0,0,rand(R5)*360>
         translate<(2*rand(R5)-1)*2.5, -7.4+ti*10.7, 0>
         rotate<0,0,25>translate<35,140,3.2>}

  #declare i=i+1;
#end

