//alpine road
//by tek
//if you have any trouble running this source, please mail me at: tek@evilsuperbrain.com


//includes

#declare boIncluded = on;
//uncomment these to get trees & car.
//#include "tree.pov"
//#include "lancia.pov"

#include "rad_def.inc"
#include "functions.inc"
#include "transforms.inc"

#include "groundmacros.inc"


//extra ground macros based on pixel position on a 2048x2048 texture.
//note: if you generate the height fields at lower res you DO NOT need to change this, it's used
//so I can pick camera/car position when looking in a paint program. i.e. the scale here has to
//correspond to the scale I used when I picked the positions, not necessarily the scale used in
//the render.

#macro m_GroundPixelPos( vPixelPos2D, vDisplacement )
	//position scaled + translated from image pixels.
	m_GroundPos(
		vDisplacement +
		((<vPixelPos2D.x,0,vPixelPos2D.y> - <1024,0,1024>)*<1,0,-1>*10860/2048)
	)
#end

#macro m_GroundPixelPlace( vPixelPos2D, vDisplacement )
	//position scaled + translated from image pixels.
	m_GroundPlace(
		vDisplacement +
		((<vPixelPos2D.x,0,vPixelPos2D.y> - <1024,0,1024>)*<1,0,-1>*10860/2048)
	)
#end


//global set up

global_settings {
  assumed_gamma 1.4 //fiddle with this to change the "mood" of the scene.
	max_trace_level 5
	radiosity { Rad_Settings(Radiosity_Fast, on, on) }
}

#default { pigment { rgb 1 } finish { diffuse 1 ambient 0 } }



//terragen-like texture mapping. I'll put this in an inc file one day...

#declare f_heightmap =
	function {
		pigment {
			image_map {
				tga "height.tga"
				interpolate 2
			}
			translate -.5
			rotate x*90
			scale 900*y + 10860*(x+z)
		}
	}

#declare f_SlopeFromGradient =
	//given the change in y for unit x & z, return the surface normal.y
	function(gradx, gradz) {
		1/sqrt(1+gradx*gradx+gradz*gradz) //I think that's right.
		/*wrong. it's more awkward.
		
		y = x*gradx
		y = z*gradz
		
		ax+by+cz-d=0
		norm (a,b,C)
		
		let d=0
		ax+by+cz=0
		ay/gradx+by+cy/gradz=0
		let b=1
		ay/gradx*/
	}

#declare f_slope =
	#local fSampDist = 10680/1024;//10680/2048; //size of 1 pixel
	function {
/*
		I do believe this ain't working.
		pigment {
			//if this doesn't work, just use the heightfield as an image map and colour map it to approximate these vals!
			slope {
				y, 0, 1
			}
			colour_map {
				[0	rgb -1]
				[1	rgb 1]
			}
		}*/
		f_SlopeFromGradient(
			900*(f_heightmap(x - fSampDist,0,z).red - f_heightmap(x + fSampDist,0,z).red)/(fSampDist*2),
			900*(f_heightmap(x,0,z - fSampDist).red - f_heightmap(x,0,z + fSampDist).red)/(fSampDist*2)
		)
	}

#declare f_height =
	function {
		y/900 + .5
	}

#declare f_lodnoise =
	function(x,y,z,dist) {
		//f_noise3d(x/dist,y/dist,z/dist)
		f_granite(x/dist,y/dist,z/dist)
	}

#declare f_noisiness =
	function(x,y,z, noise, value) {
		(1-noise)*value
		+
		noise*(
			select ( value - f_lodnoise(x,y,z,1/*sqrt(x*x+y*y+z*z)*/), 0, 1 )
		)
	}
	


//I want to emulate terragen's textures.
//textures are applied in layers, each texture has the following parameters:
//	density - maximum amount reached
//	noisiness:
//			if 0 then density sets the opacity of this layer,
//			if 1 then density sets the probability of any point being this texture.
//			i.e. this sets the probability value, and range, for a colour map on a noise function.
//	min,max,fuzziness height : density fades at min & max, fuziness sets the distance of the fade (centred on min/max)
//	min,max,fuzziness slope  : ditto
//	
//the difficulty is in combining noise with varying density.
//
//Some notes on the parameters:
//	height is scaled to world size, so 0 = lowest and 1 = highest.
//	slope is the dot product of the normal with y (so -1 = down, 1 = up)
//	tex is the texture to use for this surface, it should have no transparency (unless you want to see through the object)
#macro m_TerraTexLayer( tex,  dens, noise,  hmin, hmax, hfuz,  smin, smax, sfuz )

	#if ( image_width < 640 )
		//smooth textures on low quality renders
		#local noise = 0;
	#end

	#ifndef ( tTerraTex )
	
		//first layer
		#declare tTerraTex = tex;

	#else

		#local smid = (smin+smax)/2;
		#local hmid = (hmin+hmax)/2;
		#if ( sfuz < 0.0001 )
			#local sfuz = 0.0001;
		#end
		#if ( hfuz < 0.0001 )
			#local hfuz = 0.0001;
		#end

		#declare tPrevTex = tTerraTex;

		#declare tTerraTex =
			texture {
				function {
					//work out lerp value between this texture and what's underlying.
					//0 - underlay, 1 - this
					f_noisiness( x,y,z, noise,
												//apply noise to the result of the following calc,
	
						max(0,min(1,
							//read slope and scale so 0 is at smin-sfuz/2 and smax+sfuz/2, and 1 is at smin+sfuz/2 and smax-sfuz/2
							(smid - smin - abs(f_slope(x,y,z) - smid))/sfuz + .5
						))
							
						* //combine slope and height weightings.

						max(0,min(1,
							//read height and scale so 0 is at hmin-hfuz/2 and hmax+hfuz/2, and 1 is at hmin+hfuz/2 and hmax-hfuz/2
							(hmid - hmin - abs(f_height(x,y,z) - hmid))/hfuz + .5
						))

						*dens
						
					)
				}
				
				texture_map {
					[0	tPrevTex]
					[1	tex]
				}
			}

	#end //if terra tex already exists
		
#end //m_TerraTexLayer

#macro m_GetTerraTex()
	tTerraTex
#end




//declare scene elements

#declare f_Road =
	function {
		pigment {
			image_map {
				tga "roadmap.tga"
				interpolate 2
			}
			translate -.5
			rotate x*90
			scale 900*y + 10860*(x+z)
		}
	}

#declare tRoadIn =
	texture {
		pigment { rgb 1 }
		finish {
			diffuse .1
			specular .5
			roughness .05
		}
		normal {
			granite -1
			scale 5
		}
	}

#declare tRoadOut =
	texture {
		pigment { rgb <1,.9,.8> }
		finish {
			diffuse .4
		}
		normal {
			granite -1
			scale 5
		}
	}

#declare tRoadLine =
	texture {
		pigment { rgb 1 }
		finish {
			diffuse .8
			specular 1
			roughness .01
		}
		normal {
			granite .2
		}
	}

#declare tRoadLineDash =
	texture {
		gradient x+z
		scale 20
		ramp_wave
		texture_map {
			[.5 tRoadLine]
			[.6 tRoadIn]
		}
	}



#declare tRock	= texture { pigment { rgb .16 } }
#declare tEarth = texture { pigment { rgb <.15,.04,.01> } }
#declare tGrass = texture { pigment { rgb <.1,.4,.0> } }
#declare tSnow	= texture { pigment { rgb 1 } finish { diffuse 2 brilliance .5 } }
#declare tRed		= texture { pigment { rgb x } }
#declare tBlue	= texture { pigment { rgb z } }

#declare tTerrain =
	//dens, noise,  hmin, hmax, hran,  smin, smax, sran
	m_TerraTexLayer( tRock,		 0,0,0,0,0,0,0,0 ) //base layer, parameters ignored
	m_TerraTexLayer( tEarth,	 1,	.5,  -1, .75, .35,  .7, 2, .3 )
	m_TerraTexLayer( tGrass,	.6,	.4,  -1, .65, .25,  .7, 2, .2 )
	m_TerraTexLayer( tSnow,		1,	.5,  .7,  2, .3,   .7, 2, .4 )
	m_GetTerraTex()



#declare oGround =
	height_field {
		tga "height.tga"
		smooth
		translate -.5
		scale 900*y + 10860*(x+z)
		
		texture {
			function {
				f_Road(x,0,z).red
			}
			triangle_wave //texture goes from white at one side of road to black at the other, make it instead peak at the centre of the road.
			texture_map {
				[.10	tTerrain]
				[.20	tRoadOut]
				[.25	tRoadIn]
				[.92	tRoadIn]
				[.95	tRoadLineDash]
			}
		}
	}



//the scene

object { oGround }

object {
	#ifdef (oLancia)
		oLancia
	#else
		box { <-.86,-.60,-2.79>, <.86,.60,2.03> }
	#end
	translate y*0.60
	scale 6
	
//an alternative position, rejected because there was a lot of perspective distortion.
//		rotate 50*y
//		m_GroundPixelPlace( <584,1397>, 0*y )

	rotate 40*y
	m_GroundPixelPlace( <597.5,1383>, 0*y )
}

//trees
union {
	#declare rsTree = seed(1011);
	#declare nTree = 0;
	#while (nTree < 80)
	
		#local vPos = m_GroundPos( <rand(rsTree)/2-.5,0,rand(rsTree)/2-.5>*10680 );
		#if ( abs(f_Road(vPos.x,0,vPos.z).red - .5) > .4 ) //no trees in the road, please.
			object {
				//pick a tree from the list
				#ifdef (aoTree)
					aoTree[mod(nTree,dimension_size(aoTree,1))]
					scale .8
				#else
					sphere{0,30}
				#end
				
				translate vPos
			}
		#end
	
		#local nTree = nTree + 1;
	#end //tree loop.
	
	no_reflection
}


//environment

camera {
	#declare image_dim = sqrt(image_width*image_height); //kind of average dimension
	right			x*image_width/image_dim
	up				y*image_height/image_dim
	direction	z*.4

	//nice but high cam
	#declare gvCamPos = m_GroundPixelPos( <590,1440>, 10*y ); //<500,1520>, 200*y );
	#declare gvCamLook = m_GroundPixelPos( <894,1000>, 800*y );
	
	//lower view
	//direction	z*.4
	//#declare gvCamPos = m_GroundPixelPos( <540,1500>, 20*y );
	//#declare gvCamLook = m_GroundPixelPos( <894,1000>, 700*y );

	//lower view
	//direction	z*.7
	//#declare gvCamPos = m_GroundPixelPos( <540,1480>, 20*y );
	//#declare gvCamLook = m_GroundPixelPos( <894,1000>, 0*y );

	//road bend closeup (with dodgy camber)
	//direction 20
	//#declare gvCamPos = m_GroundPixelPos( <500,1520>, 100*y );
	//#declare gvCamLook = m_GroundPixelPos( <639,1290>, 0*y );
	
	//car view
	//direction 10
	//use pos of another cam.
	//#declare gvCamLook = m_GroundPixelPos( <597.5,1383>, 3.6*y );
	
	//#declare gvCamPos = y*10000;
	//#declare gvCamLook = z*100;

	location gvCamPos
	look_at gvCamLook
}


light_source {
//quite high sun
//	#declare vLightDir = vnormalize(<1,2,3>);
//	#declare colLight = rgb <1,.83,.7>;

//sunset, nice shadows.
//	#declare vLightDir = vnormalize(<1,1,5>);
//	#declare colLight = rgb <1,.83,.7>*1.3;

	//sunset from slightly different angle, to illuminate mountain.
	#declare vLightDir = vnormalize(<-1,1,5>);
	#declare colLight = rgb <1,.83,.7>*1.3;
	
	
	vLightDir*1000000 colLight

	#if ( image_width > 640 ) //switch off in previews.
	  area_light
	  200000*x, 200000*y, // lights spread out across this distance (x * z)
	  4, 4                // total number of lights in grid (4x*4z = 16 lights)
	  adaptive 1          // 0,1,2,3...
	  circular            // make the shape of the light circular
	  orient              // orient light
	#end
}


fog {
  fog_type 2               // 1=constant, 2=ground_fog
  distance 4000
  color rgb <.9,.9,1> transmit 0
  // (---ground fog---)
  fog_offset -350//-300         // height of constant fog
  fog_alt 250            // at fog_offset+fog_alt: density=25%
  // (---turbulence---)
  turbulence 1/<200,90,200>  //actually 1/turb scale
  turb_depth .3		//this is how far the turbulence displaces it.
}


sky_sphere {
	pigment {
		#local fPow = .5;	
		function {
			(
				select( y, -pow(abs(y),fPow), pow(abs(y),fPow) )
			)/2 + .5
		}
		colour_map {
			[.4	rgb 0]
			[.5	rgb 1]
			[1	rgb <.1,.2,.3>]
		}
	}
	//sun highlight
	pigment {
		gradient vLightDir
		scale 2
		translate -vLightDir
		poly_wave 8
		colour_map {
			[0	colLight transmit 1]
			[1	colLight transmit 0]
		}
	}
}


//cloud layers
sphere {
	-.9*y, 1

	no_shadow
	hollow on
	
	texture {
		pigment {
			wrinkles
			turbulence .3
			poly_wave .6
			scale .2
			colour_map {
				[0 rgb 1.5	transmit 0]
				[1 rgb 1.5	transmit 1]
			}
		}
		finish { ambient 1 diffuse 0 }
	}
	texture {
		pigment {
			wrinkles
			turbulence .3
			poly_wave .6
			translate -.01*y
			scale .2
			colour_map {
				[0 rgb .5	transmit 0]
				[1 rgb .5	transmit 1]
			}
		}
		finish { ambient 1 diffuse 0 }
	}
	texture {
		pigment {
			wrinkles
			turbulence .3
			poly_wave .6
			translate -.02*y
			scale .2
			colour_map {
				[0 rgb .0 transmit 0]
				[1 rgb .0	transmit 1]
			}
		}
		finish { ambient 1 diffuse 0 }
	}

	scale 1000000
}

