// Persistence of Vision Ray Tracer Scene Description File
// File: newseth.pov
// Vers: 3.5
// Desc: Seth's Playground
// Date: 10/31/02
// Auth: James Moore

#include "rand.inc"
#include "functions.inc"
#include "rad_def.inc"
#include "glass.inc"

global_settings {
	radiosity {Rad_Settings (Radiosity_OutdoorLight, on, on)}
	max_trace_level 40
}

#declare bounds=50;	//size of landscape

camera {
	up y
	right x*image_width/image_height
	location <1, 1, -4>
	look_at <-0.25, 0.9, 0>
}

//sky sphere to brighten sky
//#declare skyback=
sky_sphere {
	pigment {
		gradient y
		color_map {
			[0 rgb <0.5, 0.5, 0>]
			[1 rgb <0.5, 0, 0>]
		}
		scale 2
		translate y*-1
	}
}

//sky
//#declare atmosphere=
sphere {0, 1 hollow
	pigment {rgbt 1}
	interior {
		caustics 0.2
		media {
			method 3
			samples 10, 10
			intervals 1
			scattering {5, <0.2, 0.15, 0.125> eccentricity 0.3}
			density {rgb 0.025}
		}
	}
	scale <100, 25, 100>
	translate y*-3
}

//sun
light_source {<-60, 80, 400> color rgb <0.9, 0.9, 1>
	media_attenuation on
	media_interaction on
	fade_distance 1001
	fade_power 1
	looks_like {
		sphere {0, 1 hollow
			pigment {rgbt 1}
			interior {
				media {
					emission 0.1
					density {
						spherical
						density_map {
							[0 rgb 0]
							[0.25 rgb 0]
							[0.5 rgb <0.02, 0, 0>]
							[0.6 rgb <0.05, 0.01, 0>]
							[0.8 rgb <0.75, 0.35, 0.15>]
							[0.85 rgb <1, 1, 0.8>]
							[1 rgb <1, 1, 0.8>]
						}
					}
				}
			}
			scale 30
		}
	}
}

//texture of sand
#declare t_sand=
texture {
	pigment {
		wrinkles
		warp {turbulence 0.3 omega 0.7}
		color_map {
			[0 rgb <0.9, 0.6, 0.2>*1.75]
			[1 rgb <0.8, 0.5, 0.2>*2]
		}
	}
	normal {wrinkles warp {turbulence 0.3 omega 0.7}}
	finish {specular 0.1 roughness 0.3}
}

//function for sand heightfield
#declare f_sand=
function {
	pigment {
		leopard
		scale 0.05
		turbulence 0.3 omega 0.6
		color_map {
			[0 rgb 0]
			[1 rgb 1]
		}
	}
}

//dunes heightfield
#declare gnd=
height_field {
	function  2500, 2500 {f_sand(x, y, z).gray}
	smooth
	translate <-0.5, 0, -0.5>
	scale <bounds, 0.5, bounds>
}

//sand dunes
merge {
	object {gnd}
	plane {y,0}
	texture {t_sand}
}

//texture for mountain heightfield
#declare t_mtn=
texture {
	pigment {
		wrinkles
		color_map {
			[0 rgb <0.6, 0.4, 0.4>]
			[1 rgb <0.7, 0.5, 0.5>]
		}
	}
	finish {specular 0.2 roughness 0.4}
	normal {wrinkles}
}

//function of mountain height_field
#declare f_mtn=
function {
	pigment {
		wrinkles
		warp {turbulence 0.2 omega 0.2 lambda 0.8}
		poly_wave 0.5
		rotate y*-251
		scale 0.25
		color_map {
			[0 rgb 0]
			[0.8 rgb 0]
			[0.9 rgb 0.8]
			[0.95 rgb 0.85]
			[1 rgb 1]
		}
	}
}

//mountains
//#declare mtn=
height_field {
	function 2500, 2500 {f_mtn(x, y, z).gray}
	smooth
	translate <-0.5, 0, -0.5>
	scale <bounds, 5, bounds>
	texture {t_mtn scale <2, 0.25, 2>}
}

//dust
//#declare dust=
box {<-bounds, 0, -bounds>, <bounds, 1, bounds>
	hollow
	pigment {rgbt 1}
	interior {
		media {
			method 3
			intervals 1
			samples 1, 1
			scattering {4, 0.05}
			absorption (1-<0.8, 0.6, 0.2>)*0.5
			density {
				planar
				scale <10, 1, 5>
				warp {turbulence 0.8 omega 0.6 lambda 3}
				density_map {
					[0 rgb <1, 0.8, 0.3>]
					[0.1 rgb <0.5, 0.4, 0.15>]
					[0.5 rgb 0]
					[1 rgb 0]
				}
			}
		}
	}
	scale <1, 1.5, 1>
}

//crystals
#declare rd=seed(2);
#declare numcrys=200;
#declare c=1;
#while (c<numcrys)
	intersection {
		box {-1, 1 hollow rotate VRand_In_Box (0, 360, rd)}
		box {-1, 1 hollow rotate VRand_In_Box (0, 360, rd)}
		box {-1, 1 hollow rotate VRand_In_Box (0, 360, rd)}
		box {-1, 1 hollow rotate VRand_In_Box (0, 360, rd)}
		pigment {rgbft <0.97, 0.97, 1, 0.75, 0.5>}
		normal {facets coords 0.1}
		finish {F_Glass7}
		interior {I_Glass_Dispersion2
			caustics 0.9
			media {emission VRand_In_Box(0.75, 1, rd)*1.5}
		}
		translate y*0.3
		scale 0.06
		#declare tx=RRand(-30, 30, rd);
		#declare tz=RRand(-3, 30, rd);
		#declare tm=trace(gnd, <tx, 2, tz>, -y);
		translate tm
	}
	#declare c=c+1;
#end

//cloud density
#declare d_cloud=
density {
	wrinkles
	rotate <-17, -30, 0>
	scale <10, 5, 10>
	warp {turbulence 0.2 omega 0.8}
	density_map {
		[0 rgb 0]
		[0.65 rgb 0]
		[0.7 rgb <0.8, 0.7, 0.4>*0.5]
		[1 rgb <0.8, 0.7, 0.4>]
	}
}

//clouds
//#declare clouds=
sphere {0, 50
	scale <1, 0.2, 1>
	hollow
	double_illuminate
	pigment {rgbt 1}
	interior {
		caustics 0.2
		media {
			method 3
			intervals 1
			samples 30, 30
			scattering {4, 0.1}
			absorption (1-<0.8, 0.6, 0.2>)*0.25
			density {
				spherical
				density_map {
					[0 d_cloud]
					[0.5 d_cloud]
					[0.6 rgb 0]
					[1 rgb 0]
				}
			}
		}
	}
}

