#include "colors.inc"
#include "woods.inc"
#include "functions.inc"

// settings
#declare FocalBlur = 1;
#declare BlurSamples = 150;

#declare camera_location = <-5,2,-50>;
#declare camera_angle = 10;
#declare camera_target = <0,1,-9>;

#declare TexAirRing = texture {
  pigment {
    rgbt 1
  }
}

#declare IntAirRing = interior {
  ior 1.05
}

#declare TexRedFletching = texture {
  pigment {
    rgb<0.8,0,0>
  }
  finish {
    phong 0.2
    phong_size 0.2
  }
}

#declare TexBlackFletching = texture {
  pigment {
    rgb<0,0,0>
  }
  finish {
    phong 0.2
    phong_size 0.2
  }
}

#declare TexLeg = texture {
  T_Wood31
}

#declare TexShaft = texture {
  pigment {
    rgb 0.2
  }
  normal {
    dents 0.5
    scale 0.1
    scale 5*y
  }
  finish {
    specular 0.02
    roughness 2
  }
}                  

#declare TexPoint = texture {
  pigment {
    rgb 0.95
  }
  finish {
    metallic
    specular 0.9
    roughness 0.1
    reflection {
      0.4
    }
  }
}

#declare TexNock = texture {
  pigment {
    rgb <0.8,0,0>
  }
  finish {
    phong 0.2
    phong_size 0.2
  }
}

#declare FinPaper = finish {
  phong 0.1
  phong_size 40
}

#declare TexGold = texture {
  pigment {
    rgb<1,1,0>
  }
  finish {
    FinPaper
  }
}

#declare TexRed = texture {
  pigment {
    rgb<1,0,0>
  }
  finish {
    FinPaper
  }
}

#declare TexBlue = texture {
  pigment {
    rgb<0,0,1>
  }
  finish {
    FinPaper
  }
}

#declare TexBlack = texture {
  pigment {
    rgb 0
  }
  finish {
    FinPaper
  }
}

#declare TexWhite = texture {
  pigment {
    rgb 1
  }
  finish {
    FinPaper
  }
}


//////// OBJECT DECLARATIONS ////////

#macro AirRing(rad)
  torus {
    rad,0.05
    texture {
      TexAirRing
    }
    interior {
      IntAirRing
    }
  }
#end

// Arrow

#declare ArrowShaft = cylinder {
  <0,0,0>,<0,15,0>,0.1
  texture {
    TexShaft
  }
}

#declare ArrowPoint = lathe {
  cubic_spline
  5,
  <0.1,-0.1>,
  <0.1,0>,
  <0.1,0.2>,
  <0,0.45>,
  <-0.3,0.5>  
  texture {
    TexPoint
  }
}

#declare ArrowNockHolder = difference {
  cone {
    <0,0,0>,0.1
    <0,0.1,0>,0.07
    texture {
      TexPoint
    }
  }
  cylinder {
    <0,-1,0>,<0,1,0>,0.07
    texture {
      TexPoint
    }
  }
}

#declare ArrowNock = difference {
  cylinder {
    <0,0,0>,<0,0.3,0>,0.07
    texture {
      TexNock
    }
  }
  cylinder {
    <1,0.2,0>,<-1,0.2,0>,0.03
    texture {
      TexNock
    }
  }
  box {
    <1,0.2,0.03>,<-1,0.4,-0.03>
    texture {
      TexNock
    }
  }
  cylinder {
    <0.07,0.2,1>,<0.07,0.2,-1>,0.04
    texture {
      TexNock
    }
  }
  box {
    <0.05,0.2,1>,<0.08,0.4,-1>
    texture {
      TexNock
    }
  }
  cylinder {
    <-0.07,0.2,1>,<-0.07,0.2,-1>,0.04
    texture {
      TexNock
    }
  }
  box {
    <-0.05,0.2,1>,<-0.08,0.4,-1>
    texture {
      TexNock
    }
  }
}

#declare FletchingBase = difference {
  cylinder {
    <0,0,0>,<0,0,2>,0.05
    texture {
      TexRedFletching
    }
  }
  cylinder {
    <0,-0.06,-0.1>,<0,-0.06,2.1>,0.1
    texture {
      TexRedFletching
    }
  }
}

#declare FletchingTop = difference {
  prism {
    cubic_spline
    -0.005,0.005,
    6,        
    < 0.27,-0.3>,
    < 0.27,0.3>,
    <-1.5,0.0>,
    < 0.27,-0.3>,
    < 0.27,0.3>,
    <-1.5,0.0> 
    texture {
      TexRedFletching
    }
  }
  box {
    <-5,1,0>,<5,-1,-4>
    texture {
      TexRedFletching
    }
  }
}

#declare Fletching = union {
  object {
    FletchingBase
  }
  object {
    FletchingTop
    rotate -90*x
    rotate 90*y
    translate 0.5*z
  }
  rotate 90*x
}

#declare CockFletching = object {
  Fletching
  texture {
    TexBlackFletching
  }
}

#declare Arrow = union {
  object {
    ArrowShaft
  }
  object {
    ArrowPoint
    rotate 180*x
  }
  object {
    ArrowNockHolder
    translate 15*y
  }
  object {
    ArrowNock
    translate 15*y
  }
   
  object {
    Fletching
    translate 14.8*y
  }
  object {
    Fletching
    translate 14.8*y
    rotate 120*y
  }
  object {
    CockFletching
    translate 14.8*y
    rotate -120*y
  }  
}

#declare MovingArrow = union {
  object {
    Arrow
  }
  #local c = 1;
  #while(c < 15)
    object {
      AirRing(0.1*c)
      translate ((c) * 1 - 2) * y
    }
    #local c = c + 1;
  #end
}

// Boss

#declare GoldRing = cylinder {
  <0,0,-0.5>,<0,0,0.5>,2
  texture {
    TexGold
  }
}

#declare RedRing = difference {
  cylinder {
    <0,0,-0.5>,<0,0,0.5>,4
    texture {
      TexRed
    }
  }
  cylinder {
    <0,0,-0.51>,<0,0,0.51>,2
    texture {
      TexRed
    }
  }
}

#declare BlueRing = difference {
  cylinder {
    <0,0,-0.5>,<0,0,0.5>,6
    texture {
      TexBlue
    }
  }
  cylinder {
    <0,0,-0.51>,<0,0,0.51>,4
    texture {
      TexBlue
    }
  }
}

#declare BlackRing = difference {
  cylinder {
    <0,0,-0.5>,<0,0,0.5>,8
    texture {
      TexBlack
    }
  }
  cylinder {
    <0,0,-0.51>,<0,0,0.51>,6
    texture {
      TexBlack
    }
  }
}

#declare WhiteRing = difference {
  cylinder {
    <0,0,-0.5>,<0,0,0.5>,10
    texture {
      TexWhite
    }
  }
  cylinder {
    <0,0,-0.51>,<0,0,0.51>,8
    texture {
      TexWhite
    }
  }
}

#declare BlackLines = union {
  #local Count = 1;
  #while(Count < 8)
    difference {
      cylinder {
        <0,0,0>,<0,0,-0.501>,(Count - 1) + 0.01
        texture {
          TexBlack
        }
      }
      cylinder {
        <0,0,0>,<0,0,-0.51>,(Count - 1) - 0.01
      }
    }
    #local Count = Count + 1;
  #end
  difference {
    cylinder {
      <0,0,0>,<0,0,-0.502>,9.01
      texture {
        TexBlack
      }
    }
    cylinder {
      <0,0,0>,<0,0,-0.51>,8.99
    }
  }
}

#declare WhiteLine = difference {
  cylinder {
    <0,0,0>,<0,0,-0.501>,7.01
    texture {
      TexWhite
    }
  }
  cylinder {
    <0,0,0>,<0,0,-0.51>,6.99
    texture {
      TexWhite
    }
  }
}

#declare Boss = union {
  object {
    GoldRing
  }
  object {
    RedRing
  }
  object {
    BlueRing
  }
  object {
    BlackRing
  }
  object {
    WhiteRing
  }
  object {
    BlackLines
  }
  object {
    WhiteLine
  }
  translate -0.5*z
  rotate 15*x
}


// Stand
#declare TargetLeg = box {
  <1,0,0>,<-1,-30,1.5>
  texture {
    TexLeg
  }
}

#declare TargetSupport = box {
  <0.5,-20,-2>,<-0.5,-17.9,1.5>
  texture {
    TexLeg
    translate <28,2,72>
  }
}

#declare TargetStand = union {
  union {
    object {
      TargetLeg
    }
    object {
      TargetSupport
      translate 1.5*x
    }
    rotate 10*z
    rotate 15*x
    translate 2*x
  }
  union {
    object {
      TargetLeg
    }
    object {
      TargetSupport
      translate -1.5*x
    }
    rotate -10*z
    rotate 15*x
    translate -2*x
  }
  object {
    TargetLeg
    rotate -15*x
  }
}

// Entire target
#declare Target = union {
  object {
    Boss
  }
  object {
    TargetStand
    translate 9*y
    translate 3*z
  }
}


//////// SCENE CONSTRUCTION /////////

camera {
  location camera_location

//  location <0,-10,-20>
  look_at camera_target
  angle camera_angle
#if(FocalBlur = 1)
  focal_point <0,0,-15>
  aperture 0.5
  blur_samples BlurSamples
#end
}

light_source {
  <4000,9000,-1000> rgb 1.9
  parallel
}

light_source {
  <-4000,-9000,-1000> rgb 0.4
  parallel
  shadowless
}

#declare R1=seed(47237);

object {
  MovingArrow
  rotate 360*rand(R1)*y
  rotate -84*x
  rotate -0.5*y
  translate -16*z
  translate 1.9*y
  translate 1*x
}

object {
  Arrow
  rotate 360*rand(R1)*y
    rotate -84*x
  rotate -1*y
  translate -0.2*x
  translate -0.3*y
}

object {
  Arrow                  
  rotate 360*rand(R1)*y
  rotate -84*x
  rotate -1*y
  translate -0.7*x
  translate 0.1*y
}

object {
  Arrow
  rotate 360*rand(R1)*y
    rotate -84*x
  rotate -2.5*y
  translate -0.43*x
  translate 0.181*y
}

object {
  Arrow
  rotate 360*rand(R1)*y
    rotate -84*x
  rotate 0*y
  translate -0.1*x
  translate 0.5*y
}

object {
  Arrow
  rotate 360*rand(R1)*y
    rotate -84*x
  rotate -1.3*y
  translate 0.3*x
  translate -0.2*y
}

object {
  Target
}

sky_sphere {
  pigment {
    colour rgb<0.69,0.68,0.7>
  }
}
