// Persistence of Vision Ray Tracer Scene Description File
// File: AnyTimeNow.pov
// Vers: 3.5
// Desc: AnyTimeNow
// Date: 08/26/02
// Auth: Jeff M. Thomas
//

#version 3.5;

#include "functions.inc"
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "skies.inc"
#include "metals.inc"
#include "glass.inc"
#include "stones.inc"
#include "woods.inc"     

////////////////////////////////////////////////////////////
//
// --------------------------------------- Option Flags
//
////////////////////////////////////////////////////////////


#local FULL_RENDER = true;

#if (FULL_RENDER)

  #local CAMERA = 0;
  
  #local PHOTONS = true;
  #local PHOTONS_LOAD = false;
  #local RADIOSITY = true;

  #local WORKLIGHT = false;
  #local WINDOW_LIGHT = false;
  #local AREA_LIGHT = true;
  #local GROUND_LIGHTS_LIT = true;
  #local STAIR_LIGHTS = true;
  #local FOUNTAIN_LIGHTS = true;
  
  #local BOY = true;
  #local SKATEBOARD = true;
  
  #local HORSE = true;
  #local ISO_HORSE = true;
  
  #local GROUND = true;
  #local SIDE_WALLS = true;
  #local ISO_GROUND = true;
  #local ISO_STAIRS = true;
  #local COFFEE = true;
  #local GARBAGECAN = true;
  #local NO_SKATING = true;
  #local BRICK_GROUND = true;
  #local GROUND_LIGHTS = true;
  #local RAIL = true;
  
  #local PILE_ON_LEAVES = true;
  
  #local FOUNTAIN = true;
  #local WATER = true;
  #local SPRAY = true;
  
  #local STARS = true;
  #local BACKGROUND = true;  
  
  #local TREES = true;
  
#else // working render

  #local CAMERA = 0;
  
  #local PHOTONS = false;
  #local PHOTONS_LOAD = false;
  #local RADIOSITY = false;

  #local WORKLIGHT = false;
  #local WINDOW_LIGHT = false;
  #local AREA_LIGHT = true;
  #local GROUND_LIGHTS_LIT = false;
  #local STAIR_LIGHTS = false;
  #local FOUNTAIN_LIGHTS = false;
  
  #local BOY = true;
  #local SKATEBOARD = true;
  
  #local HORSE = false;
  #local ISO_HORSE = true;
  
  #local GROUND = true;
  #local SIDE_WALLS = true;
  #local ISO_GROUND = true;
  #local ISO_STAIRS = true;
  #local COFFEE = true;
  #local GARBAGECAN = true;
  #local NO_SKATING = true;
  #local BRICK_GROUND = false;
  #local GROUND_LIGHTS = false;
  #local RAIL = true;
  
  #local PILE_ON_LEAVES = false;
  
  #local FOUNTAIN = true;
  #local WATER = true;
  #local SPRAY = false;
  
  #local STARS = false;
  #local BACKGROUND = true;  
  
  #local TREES = false;
  

#end // FULL_RENDER

////////////////////////////////////////////////////////////
//
// --------------------------------------- Declares
//
////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////
//
// --------------------------------------- Global Settings
//
////////////////////////////////////////////////////////////

global_settings {
  max_trace_level 10
  assumed_gamma 1.0
  ambient_light .1
  #if (PHOTONS | PHOTONS_LOAD)
    photons
    {
      #if(PHOTONS_LOAD)
        load_file "Aiii.ph"
        #undef PHOTONS
        #declare PHOTONS = false; 
      #else
        // use non-adaptive search radius
        max_trace_level 20
    	  spacing 0.025
    	  //radius 0.005
    	  //radius 0.005
        //gather 20, 100
        //autostop 0
        media 100
        //jitter 0.9
        save_file "Aiii.ph"
      #end
    } 
  #end // PHOTONS
  #if (RADIOSITY)
    radiosity 
    {
      pretrace_start 0.08           // start pretrace at this size
      pretrace_end   0.04           // end pretrace at this size
      count 35                      // higher -> higher quality (1..1600) [35]
      nearest_count 5               // higher -> higher quality (1..10) [5]
      error_bound 1.8               // higher -> smoother, less accurate [1.8]
      recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
      low_error_factor .5           // reduce error_bound during last pretrace step
      gray_threshold 0.0            // increase for weakening colors (0..1) [0]
      minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
      brightness 1                  // brightness of radiosity effects (0..1) [1]
  
      adc_bailout 0.01/2
      //normal on                   // take surface normals into account [off]
      //media on                    // take media into account [off]
      //save_file "file_name"       // save radiosity data
      //load_file "file_name"       // load saved radiosity data
      //always_sample off           // turn sampling in final trace off [on]
      //max_sample 1.0              // maximum brightness of samples
    }
  #end // RADIOSITY
}

////////////////////////////////////////////////////////////
//
// --------------------------------------- Cameras
//
////////////////////////////////////////////////////////////

#if (CAMERA = 0)// main camera
  camera 
  {
    location  < 0.5, 0, -15.50>
    direction 1.5*z
    right     x*image_width/image_height
    look_at   <0.0, 0.50,  0.0>
  }
#end // CAMERA = 0

#if (CAMERA = 1)// top view
  camera 
  {
    location  <0.0, 25, 0>
    direction 1.5*z
    right     x*image_width/image_height
    look_at   <0.0, 0.00,  0.0>
  }
#end // CAMERA = 1

#if (CAMERA = 2)// rail cam
  camera 
  {
    location  <-.75, -.5, -6>
    direction 1.5*z
    right     x*image_width/image_height
    look_at   <0,-1.5+0.0833,-5.5>
  }
#end // CAMERA = 2

#if (CAMERA = 3)// wall cam
  camera 
  {
    location  <4.95, -1, -3>
    direction 1.5*z
    right     x*image_width/image_height
    look_at   <4.95,-1,8>
  }
#end // CAMERA = 3

#if (CAMERA = 4)// No Skateboarding cam
  camera 
  {
    location  <4.75,1.5,-4.8>
    direction 1.5*z
    right     x*image_width/image_height
    look_at   <4.75,1.5,-2.8>
  }
#end // CAMERA = 4  

#if (CAMERA = 5)// Top Down Center Fountain cam
  camera 
  {
    location  < 0, 70, 23>
    direction 1.5*z
    right     x*image_width/image_height
    look_at   <0.0, 0,  23>
  }
#end // CAMERA = 5

#if (CAMERA = 6)// Fountain cam
  camera 
  {
    location  < 0, 5, 0>
    direction 1.5*z
    right     x*image_width/image_height
    look_at   <0.0, 0,  23>
  }
#end // CAMERA = 6 

#if (CAMERA = 7)// Horse cam
  camera 
  {
    location  < 0, 6, 1>
    direction 1.5*z
    right     x*image_width/image_height
    look_at   <0.0, 6,  23>
  }
#end // CAMERA = 7

////////////////////////////////////////////////////////////
//
// --------------------------------------- Global Lighting
//
////////////////////////////////////////////////////////////

#if (AREA_LIGHT)
light_source 
{
  <0, 0, 0>
  color rgb <1.0, 1.0, 0.8>*.15 //1
  translate <150000,200000,-100000>

  area_light <0, 0, 0>, <10000,10000,-10000>, 25, 25
  adaptive 1
  jitter
  #if (PHOTONS)
    photons 
    {
      reflection off
      refraction off
    }
  #end
}
#end // AREA_LIGHT

#if (WORKLIGHT)
light_source 
{
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
  #if (PHOTONS)
    photons 
    {
      reflection off
      refraction off
    }
  #end
}
#end // WORKLIGHT

#if (FOUNTAIN_LIGHTS)
// Lights to cast photons on the horse
light_source 
{
  <0, 0, 0>            // light's position (translated below)
  #if (RADIOSITY)
    color rgb <.5, .6, .7>*.65  // light's color
  #else
    color rgb <.5, .6, .7>  // light's color
  #end
  spotlight
  radius 40
  falloff 40
  translate <8, .5, 23>
  point_at <0, 6, 23>
  #if (PHOTONS)
    photons 
    {
      reflection on
      refraction on
    }
  #end
}
light_source 
{
  <0, 0, 0>            // light's position (translated below)
  #if (RADIOSITY)
    color rgb <.5, .6, .7>*.65  // light's color
  #else
    color rgb <.5, .6, .7>  // light's color
  #end
  spotlight
  radius 40
  falloff 40
  translate <-8, .5, 23>
  point_at <0, 6, 23>
  #if (PHOTONS)
    photons 
    {
      reflection on
      refraction on
    }
  #end
}
light_source 
{
  <0, 0, 0>            // light's position (translated below)
  #if (RADIOSITY)
    color rgb <.5, .6, .7>*.65  // light's color
  #else
    color rgb <.5, .6, .7>  // light's color
  #end
  spotlight
  radius 40
  falloff 40
  translate <0, .5, 15>
  point_at <0, 6, 23>
  #if (PHOTONS)
    photons 
    {
      reflection on
      refraction on
    }
  #end
}
/*
light_source 
{
  <0, 0, 0>            // light's position (translated below)
  color rgb <.5, .6, .7>  // light's color
  spotlight
  radius 25
  falloff 25
  translate <10, 9, 23>
  point_at <5, 0, 23>
  #if (PHOTONS)
    photons 
    {
      reflection on
      refraction on
    }
  #end
}
*/
/*
light_source 
{
  <0, 0, 0>            // light's position (translated below)
  color rgb <.5, .5, .5>  // light's color
  translate <4, .5, 23>
  #if (PHOTONS)
    photons 
    {
      reflection on
      refraction on
    }
  #end
}
*/
#end // FOUNTAIN_LIGHTS

#if (GROUND_LIGHTS_LIT)
light_source 
{
  <0, 0, 0>            // light's position (translated below)
  #if (RADIOSITY)
    color rgb <.10, .10, .150>*.65  // light's color
  #else
    color rgb <.10, .10, .150>  // light's color
  #end
  looks_like
  { 
    difference
    {
      cylinder{<0,.25,0><0,0,0> .25}
      torus
      {
        .25,.21
      }
      plane{ -y, 0 translate<0,.225,0>}
      texture{ T_Chrome_5E finish{ ambient .65 } }
      translate<0,-.1750>
    }
    //sphere{ 0,.25 pigment{White} } 
  }
  translate <4.5, 3.2, -2.25>
  #if (PHOTONS)
    photons 
    {
      reflection off
      refraction off
    }
  #end
}
light_source 
{
  <0, 0, 0>            // light's position (translated below)
  #if (RADIOSITY)
    color rgb <.10, .10, .150>*.65  // light's color
  #else
    color rgb <.10, .10, .150>  // light's color
  #end
  looks_like
  { 
    difference
    {
      cylinder{<0,.25,0><0,0,0> .25}
      torus
      {
        .25,.21
      }
      plane{ -y, 0 translate<0,.225,0>}
      texture{ T_Chrome_5E finish{ ambient .65 } }
      translate<0,-.1750>
    }
    //sphere{ 0,.25 pigment{White} } 
  }
  translate <-4.5, 3.2, -2.25>
  #if (PHOTONS)
    photons 
    {
      reflection off
      refraction off
    }
  #end
}
#end // GROUND_LIGHT

#if (STAIR_LIGHTS)
#if(RADIOSITY)
  #local SLightsColor=color rgb <.1, .1, .0750>*.65;
#else
  #local SLightsColor=color rgb <.1, .1, .0750>;
#end
light_source 
{
  <-1, .5, 0>            // light's position (translated below)
  SLightsColor  // light's color
  area_light <0,.01,0>,<0,0,.01>,4,4
  adaptive 1
  spotlight
  point_at <0,0,0>
  translate<1,-.50,0>
  translate<-4.75,-2.25,-1.5>
  #if (PHOTONS)
    photons 
    {
      reflection on
      refraction on
    }
  #end
}
light_source 
{
  <1, .5, 0>            // light's position (translated below)
  SLightsColor  // light's color
  area_light <0,.01,0>,<0,0,.01>,4,4
  adaptive 1
  spotlight
  point_at <0,0,0>
  translate<-1,-.50,0>
  translate<4.5,-2.5,-1.5>
  #if (PHOTONS)
    photons 
    {
      reflection on
      refraction on
    }
  #end
}
light_source 
{
  <1, .5, 0>            // light's position (translated below)
  SLightsColor  // light's color
  area_light <0,.01,0>,<0,0,.01>,4,4
  adaptive 1
  spotlight
  point_at <0,0,0>
  translate<-1,-.50,0>
  translate<4.5,-1.5,.5>
  #if (PHOTONS)
    photons 
    {
      reflection on
      refraction on
    }
  #end
}
light_source 
{
  <-1, .5, 0>            // light's position (translated below)
  SLightsColor  // light's color
  area_light <0,.01,0>,<0,0,.01>,4,4
  adaptive 1
  spotlight
  point_at <0,0,0>
  translate<1,-.50,0>
  translate<-4.5,-1.5,.5>
  #if (PHOTONS)
    photons 
    {
      reflection on
      refraction on
    }
  #end
}

#end // STAIR_LIGHTS

////////////////////////////////////////////////////////////
//
// --------------------------------------- Macros
//
////////////////////////////////////////////////////////////

#if (TREES | PILE_ON_LEAVES)  
  // Include the leaf definition and splinetree files
  #include "leafdefs.inc"
  #include "splinetree.inc"
  #declare leafarray = array[3] {fallmaple1,fallmaple2,fallmaple3}
#end
#macro ScatterLeavesOn( Target, RandomSeed, Amount, Height, Width, Length )
  #if (PILE_ON_LEAVES)
    #local LeafRandom = seed(RandomSeed);
    #local iLeaves = 0;
    
    #while( iLeaves < Amount )
      #local thisLeafNum = floor(rand(LeafRandom)*2+.5);
      #local thisLeaf = leafarray[thisLeafNum];
      #local HitNormal = <0,0,0>;
      #local xStart = Width*rand(LeafRandom) - (Width/2); 
      #local zStart = Length*rand(LeafRandom) - (Length/2);
      #local Intercept = trace( Target, <xStart, Height, zStart>, <0,-Height,0>, HitNormal );
      #local Transition = <xStart, Intercept.y, zStart>;
      #if ( vlength(HitNormal) != 0 )
        object
        {
          thisLeaf
          scale .5
          #if ( thisLeafNum = 0 )
            rotate<40,0,0>
          #end
          #if ( thisLeafNum = 1 )
            rotate<30,0,0>
          #end
          #if ( thisLeafNum = 2 )
            rotate<40,0,0>
          #end
          rotate y*(360*rand(LeafRandom))
          translate Transition
        }
        #local iLeaves = iLeaves + 1;
      #end
    #end // while
  #else // PILE_ON_LEAVES
    sphere
    {
      -100,.0001,1
    }
  #end // PILE_ON_SNOW
#end // ScatterLeavesOn

#macro ScatterLeavesOnSteps( Target, RandomSeed, Amount, Height, Width, Length )
  #if (PILE_ON_LEAVES)
    #local LeafRandom = seed(RandomSeed);
    #local iLeaves = 0;
    
    #while( iLeaves < Amount )
      #local thisLeafNum = floor(rand(LeafRandom)*2+.5);
      #local thisLeaf = leafarray[thisLeafNum];
      #local HitNormal = <0,0,0>;
      #local xStart = Width*rand(LeafRandom) - (Width/2); 
      #local zStart = Length*rand(LeafRandom) - (Length/2);
      // reduce the chances that a leaf is in the middle of the steps
      #if ( (Width/2)*rand(LeafRandom) < abs(xStart) )
        #local Intercept = trace( Target, <xStart, Height, zStart>, <0,-Height,0>, HitNormal );
        #local Transition = <xStart, Intercept.y, zStart>;
        #if ( vlength(HitNormal) != 0 )
          object
          {
            thisLeaf
            scale .35
            #if ( thisLeafNum = 0 )
              rotate<40,0,0>
            #end
            #if ( thisLeafNum = 1 )
              rotate<30,0,0>
            #end
            #if ( thisLeafNum = 2 )
              rotate<40,0,0>
            #end
            rotate y*(360*rand(LeafRandom))
            translate Transition
          }
          #local iLeaves = iLeaves + 1;
        #end
      #end
    #end // while
  #else // PILE_ON_LEAVES
    sphere
    {
      -100,.0001,1
    }
  #end // PILE_ON_SNOW
#end // ScatterLeavesOnSteps

#macro MakeStars( Qty, RandomSeed )
  #local StarRandom = seed(RandomSeed);
  #local Current = 0;              
  #while (Current < Qty)
    #local xRot = (50*rand(StarRandom));
    #local yRot = (60*rand(StarRandom))-30;
    sphere
    {
      <0,0,1250>, .75+(.25*rand(StarRandom))
      rotate <-xRot,yRot,0>
      texture
      {
        //pigment{ White }
        //pigment{ rgbt <1,1,1,min(1.2-xRot/50,1)> }
        #local Color = int(9*rand(StarRandom));
        #if (Color < 8)
          pigment{ rgbt <1,1,1,min(1.1+(.1*rand(StarRandom))-xRot/50,1)> }
        #end
        #if (Color = 8)
          pigment{ rgbt <.85,1,1,min(1.2-xRot/50,1)> }
        #end
        #if (Color = 9)
          pigment{ rgbt <1,.85,.85,min(1.2-xRot/50,1)> }
        #end

        //#debug concat( "color index = ", str(Color,7,2), "\n" )
        //finish{ ambient (1/50) * xRot }
        finish{ ambient 1.25 + (2*rand(StarRandom)) }
      }
    }
    #local Current = Current + 1;
  #end
#end // MakeStars

////////////////////////////////////////////////////////////
//
// --------------------------------------- Textures
//
////////////////////////////////////////////////////////////

#declare hair_1 = texture {
    pigment { rgb <0.651, 0.388, 0.161> }
}

#declare laces_1 = texture {
    pigment { rgb <0.812, 0.812, 0.812> }
}

#declare souls_1 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.069, 0.061, 0.008> }
}

#declare socks_1 = texture {
    pigment { rgb <0.722, 0.722, 0.722> }
}

#declare shoes_1 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.069, 0.016, 0.082> }
}

#declare nails_H_1 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.941, 0.584, 0.635> }
}

#declare pupil_1 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
    }
    pigment { rgb <0.035, 0.027, 0.075> }
}

#declare eyeBall_1 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <1.000, 0.976, 0.933> }
}

#declare iris_1 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.424, 0.569, 0.596> }
}

#declare teeth_1 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <1.000, 0.953, 0.933> }
}

#declare tongue_1 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.937, 0.745, 0.737> }
}

#declare lashes_1 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.373, 0.216, 0.180> }
}

#declare eyeBrows_1 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.702, 0.592, 0.565> }
}

#declare lips_1 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.714, 0.545, 0.518> }
}

#declare innerMouth_1 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.424, 0.349, 0.333> }
}

#declare skin_1 = texture {
    pigment { rgb <0.910, 0.753, 0.718> }
}

#declare shirt_1 = 
texture 
{
  pigment 
  {
    granite
    color_map 
    {
      [0.00 color rgb <1.0,0.4,0.2> ]
      [0.33 color rgb <0.2,0.4,1.0> ]
      [0.66 color rgb <0.4,1.0,0.2> ]
      [1.00 color rgb <1.0,0.4,0.2> ]
    }
    scale .1
  }
}
texture
{
  pigment
  {
    image_map
    {
      png "POVLogo3.png"
      transmit 0, 1
    }
    //rotate -y*20
    translate <-.305,.35,0>
    //translate <-.5,-.5,0>
    scale .455 
    //translate <0,0,-5>
  }
}

#declare shorts_1 = texture {
    pigment { rgb <0.416, 0.427, 0.537> }
}

#declare colrF = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.000, 0.145, 0.714> }
}

#declare colrE = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.082, 0.082, 0.082> }
}

#declare colrD = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.000, 0.075, 0.212> }
}

#declare colrC = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.976, 0.969, 0.980> }
}

#declare colrB = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.506, 0.522, 0.459> }
}

#declare colrA = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.020, 0.055, 0.243> }
}

#declare Texture_Board=
  texture{ pigment{ Brown } }
  texture
  {
    pigment
    { 
      image_map
      {
        png "dont.png"
        filter   64, 1.0 
      } 
      //rotate<0,90,0> 
      translate<-.5,-.5,0>
      scale<.64583,2.660417,1>
    }
  } 

#declare tail = texture {
    finish {
        ambient 0.10
        //diffuse 0.90
        //phong 0.98
        //phong_size 29.4
        //metallic
    }
    pigment { rgb <0.247, 0.239, 0.227> }
}

#declare eyeBall = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.192, 0.192, 0.192> }
}

#declare innerEar = texture {
    finish {
        ambient 0.10
        //diffuse 0.90
        //phong 0.98
        //phong_size 29.4
        //metallic
    }
    pigment { rgb <0.122, 0.122, 0.122> }
}

#declare nose = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.043, 0.043, 0.043> }
}

#declare hooves = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.98
        phong_size 29.4
        metallic
    }
    pigment { rgb <0.016, 0.016, 0.016> }
}

#declare mane = texture {
    finish {
        ambient 0.10
        //diffuse 0.90
        //phong 0.98
        //phong_size 29.4
        //metallic
    }
    //pigment { rgb <0.639, 0.459, 0.384> }
    pigment{ Brown*.15 }
}

#declare hide1 = texture
{
  granite
  texture_map
  {
    [0 pigment{ Black }]
    [1 pigment{ Brown*15 }]
  }
}
#declare hide2 = texture
{
  granite
  texture_map
  {
    [0 pigment{ Brown*15 }]
    [1 pigment{ White }]
  }
}

#declare hide_old = texture 
{
  gradient x
  texture_map
  {
    [0 pigment{ Black }]
    [.25 hide1]
    [.5 pigment{ Brown*15 }]
    [.75 hide2]
    [1 pigment{ White }]
  }
/*
    finish {
        ambient 0.10
        //diffuse 0.90
        //phong 0.98
        //phong_size 29.4
        //metallic
    }
    //pigment { rgb <0.639, 0.459, 0.384> }
    pigment{ Brown*.5 }
*/
}

/*

 #local concrete_stone_n1=
normal {
    spotted
    turbulence 3
    scale .5
    slope_map {
      [0, <0,0>]
      [.5, <1,0>]
      [1, <0,0>]
    }
}

#local concrete_stone_n2=
normal {
  crackle
  slope_map {
    [0, <-1, 0>]
    [.25, <-1, 0>]
    [.30, <1, 0>]
    [1, <1, 0>]
  }
}

#declare concrete_stone =
texture {
  pigment {
    spotted
    scale .3
    color_map {
      [0, rgb <.5,.5,.5>]
      [.5, rgb <.4,.4,.6>]
      [1, rgb <.5,.5,.5>]
    }
  }
  normal {
    crackle
    normal_map{
      [.25, concrete_stone_n2]
      [.30, concrete_stone_n2]
      [.30, concrete_stone_n1]
    }
  }
}

#declare concrete_cement =
texture {
  pigment {
    color rgb <.5, .5, .55>
  }
  normal {
    spotted 2
    scale .025
    turbulence 0.3
    scale 2
    slope_map {
      [0, <0,0>]
      [.33, <0,0>]
      [.66, <.5,1>]
      [1, <1,0>]
    }
  }
}

#declare concrete=
texture {
  crackle
  scale .05
  texture_map {
    [0, concrete_cement]
    [.25, concrete_cement]
    [.25, concrete_stone]
    [1, concrete_stone]
  }
}
*/
#declare isobrushc1=
pigment
{
  granite
  //scale 1
  //warp { turbulence <1,1,1> octaves 3 lambda 1.5 omega 0.3 }
  scale .5
  //rotate x*90
  pigment_map
  {
    [0 color rgb <.50,.50,.50>]
    [1 color rgb <.65,.65,.65>]
  }
}

#declare isobrushc3=
pigment
{
  marble
  //warp { turbulence <0,1,1> octaves 3 lambda 1.5 omega 0.3 }
  //scale .1
  rotate y*90
  pigment_map
  {
    [.56 isobrushc1]
    [.8 DimGray]
  } 
}

#declare isobrushedcement=
pigment
{
  marble
  //warp { turbulence <0,1,1> octaves 3 lambda 1.5 omega 0.3 }
  scale .1
  //rotate x*90
  pigment_map
  {
    [.56 isobrushc3]
    [.8 DimGray]
  } 
}

#declare my_cement_pigment_base=
  pigment
  {
    granite
    pigment_map
    {
      [0 color rgb   <0.4117647,0.4039215,0.3872549>]
      [.05 color rgb <0.5686274,0.5254901,0.4705882>]
      [.15 color rgb <0.6078431,0.5921568,0.5890196>]
      [.35 color rgb <0.6392156,0.6431372,0.5803921>]
      [.55 color rgb <0.4117647,0.4039215,0.3972549>]
      [.75 color rgb <0.6666667,0.6274509,0.5886274>]
      [.85 color rgb <0.6078431,0.5921568,0.5490196>]
      [1 color rgb   <0.7019607,0.7137254,0.6978431>]
/*
      [0 color rgb   <0.4117647,0.4039215,0.3372549>]
      [.05 color rgb <0.5686274,0.5254901,0.4705882>]
      [.15 color rgb <0.6078431,0.5921568,0.5490196>]
      [.35 color rgb <0.6392156,0.6431372,0.5803921>]
      [.55 color rgb <0.4117647,0.4039215,0.3372549>]
      [.75 color rgb <0.6666667,0.6274509,0.5686274>]
      [.85 color rgb <0.6078431,0.5921568,0.5490196>]
      [1 color rgb   <0.7019607,0.7137254,0.6078431>]
*/
    }        
    triangle_wave  
    scale <100,.25,100>
    //rotate z*90
  }
#declare my_cement_pigment=
  pigment
  {
    my_cement_pigment_base
    scale 20
    warp { turbulence .2 octaves 3 lambda 1.5 omega 0.3 }
    scale .05
    scale .25
  }
#declare fn_my_cement=
  function
  {
    pigment
    {
      my_cement_pigment
    }
  }
#declare my_cement2=
texture
{
  pigment
  {
    my_cement_pigment
  }
//  normal
//  {
//    granite .001
//    //scale <10,0,10>
//    scale <100,.5,100>
//  }
}      


#declare cementbrushc1=
pigment
{
  granite
  //scale 1
  //warp { turbulence <1,1,1> octaves 3 lambda 1.5 omega 0.3 }
  scale .5
  //rotate x*90
  pigment_map
  {
    [0 color rgb <.50,.50,.50>]
    [1 color rgb <.65,.65,.65>]
  }
}

#declare cementbrushc3=
pigment
{
  marble
  //warp { turbulence <0,1,1> octaves 3 lambda 1.5 omega 0.3 }
  //scale .1
  rotate y*90
  pigment_map
  {
    [.56 cementbrushc1]
    [.8 DimGray]
  } 
}

#declare cementbrushedcement=
pigment
{
  marble
  //warp { turbulence <0,1,1> octaves 3 lambda 1.5 omega 0.3 }
  scale .1
  //rotate x*90
  pigment_map
  {
    [.56 cementbrushc3]
    [.8 my_cement_pigment rotate z*90]
  } 
}

#declare brushedcement_right=
texture
{
  pigment
  {
    cementbrushedcement scale 2 translate<-.025,0,.05>
  }
}


#declare brushedcement_left=
texture
{
  pigment
  {
    cementbrushedcement scale 2 translate<-.05,0,.3>
  }
}

#declare fn_brushedcement_right=
function
{
  pigment
  {
    isobrushedcement scale 2 translate<-.025,0,.05>
  }
}

#declare fn_brushedcement_left=
function
{
  pigment
  {
    isobrushedcement scale 2 translate<-.05,0,-.05>
  }
}

#declare rail_steel=
texture
{ 
  pigment { Brown*.3 } 
  finish{ F_MetalA roughness .3 } 
  normal
  { 
    granite
    scale .02
  }
}

#declare RailColor=color DarkSlateBlue;

#declare fn_Rail1=
  function
  {
    pigment
    { 
      marble
      color_map
      {
        [0 Black]
        [.01 Black]
        [.1 White]
      }
    }
  }
  
#declare fn_Rail2=
  function
  {
    pigment
    {
      granite
      color_map
      {
        [0 DimGray]
        [.5 DimGray]
        [.51 Black]
      }
      scale .02
    }
  }

#declare p_Rail=
  function(x,y,z){ (fn_Rail1(x,y,z).gray)*.25 }

#declare DownRail1=     
texture
{
  function{ p_Rail(x/.15,y,z) /** (fn_Rail2(x,y,z).gray*.5)*/ }
  //scale <.15,1,1>
  texture_map
  {
    [0 pigment{ RailColor }]
    [0 pigment{ RailColor }]
    [.55 rail_steel ]
    [1.0 rail_steel ]
  }
}

#declare DownRail2=     
texture
{
  function{ p_Rail(x/.15,y,z) /** (fn_Rail2(x,y,z).gray*.5)*/ }
  //scale <.5,1,1>
  texture_map
  {
    [0 pigment{ RailColor }]
    [0 pigment{ RailColor }]
    [.5 rail_steel ]
    [1 rail_steel ]
  }
}

#declare DownRail3=     
texture
{
  function{ p_Rail(x/.5,y,z) }
  texture_map
  {
    [0 pigment{ RailColor }]
    [0 pigment{ RailColor }]
    [.5 rail_steel ]
    [1 rail_steel ]
  }
}

#declare DownRail=     
texture
{
  gradient z
  texture_map
  {
    [0 pigment{ RailColor }]
    [0 pigment{ RailColor }]
    [.05 DownRail3]
    [.15 DownRail2]
    [.25 DownRail1]
    [1 DownRail1]
  }
  scale 8.5
  translate <0,0,.5>
}

#declare agp=
  pigment{ granite pigment_map{ [0 Black][1 White] } scale 2 scale <.25,1,1> }
#declare fn_agp=
  function{ pigment{ gradient x pigment_map { [0 Black][.25 Black][.5 agp][.85 White][1 White] } } }
#declare fn_GraniteFade=
function
{
  
  pigment
  {
    function{ fn_agp(x,y,z).gray } 
    pigment_map
    {
      [0 Black]
      [.4 Black]
      [.6 White]
      [1 White]
    }
  }
}
#declare BrownToMarble=
pigment
{
  function{ fn_GraniteFade(x,y,z).gray }
  pigment_map
  {
    [0 Black]
    [1 White*.5]
  }
}
#declare MarbleToBronz=
pigment
{
  function{ fn_GraniteFade(x,y,z).gray }
  pigment_map
  {
    [0 White*.5]
    [1 White]
  }
}
#declare HorseHideMap=
pigment
{
  gradient x
  pigment_map
  {
    [0  Black]
    [.30 Black]
    [.30 BrownToMarble scale .3 translate<.25,0,0>]
    [.40 BrownToMarble scale .3 translate<.25,0,0>]
    [.50 White*.5]
    [.60 White*.5]
    [.60 MarbleToBronz scale .3 translate<.50,0,0>]
    [.80 MarbleToBronz scale .3 translate<.50,0,0>]
    [.80 White]
    [1 White]
  }
}
#declare fn_HorseHideMap=
function
{
  pigment{ HorseHideMap scale <10.1,1,1> translate<-6.4/*2.97*/,0,0> rotate<0,0,45> translate <6,-6,0>   translate <-1,0,0>   translate <6,-3,0>}
}

#declare hide=
texture
{
  function{ fn_HorseHideMap(x,y,z).gray }
  texture_map
  {
    [0  pigment{ Brown*.5}]
    [.10 pigment{ Brown*.5}]
    [.40 T_Grnt19 scale<.1,1,1>]
    [.60 T_Grnt19 scale<.1,1,1>]
    [.90 T_Copper_1B]
    [1 T_Copper_1B]
  }
  //scale .5
  //rotate<0,180,0>
  //scale<1,1,1> 
  //translate <-1,0,0>
  //translate <6,-3,0>
}

#declare GCanTextureSlats=
texture
{
  pigment { DarkGreen/*DarkSlateBlue*/ }
  normal
  { 
    //granite .1
    wood .25
    turbulence 0.04
    octaves 3
    scale <0.05, .05, 1>
    scale .5
    rotate -x*90
  }
}

#declare GCanTexture=
texture
{
  pigment { DarkSlateBlue*.5 }
  normal
  { 
    granite .2
    scale 2
  }
}

#declare Floor_Bricks=
texture
{
  pigment{ Firebrick }
  normal{ granite .05 scale .75 }
  finish{ phong .6 }
}

#declare SpherePigment=
pigment
{   
  crackle
  //spiral1 5 
  //agate
  //agate_turb .25
  color_map 
  {
    [0.00 Black ]
    [1.00 color rgb <0,.5,0> ]
  }
  scale 1.25
}

#declare SphereTexture=
texture
{
  pigment 
  {
    SpherePigment
  }
  finish
  {
    specular 0.6
  }
#if (!ISO_HORSE)
  normal
  {
    agate
    agate_turb .5
  }
#end
}


////////////////////////////////////////////////////////////
//
// --------------------------------------- Object Declarations
//
//////////////////////////////////////////////////////////// 

#if (BOY)
  //#include "boy.inc"
  //#include "boy_m.inc"
  #debug "Loading Boy...\n"
  #include "boy2_o.inc"
  #declare Cap=
    object{ P_BBallCap_1 }
  #declare Boy=
  union
  {
    //object{ P_BBallCap_1 }
    object{ P_Hip_1 }
    object{ P_Abdomen_1 }
    object{ P_Chest_1 }
    object{ P_Neck_1 }
    object{ P_Head_1 }
    object{ P_Left_Eye_1 }
    object{ P_RightEye_1 }
    object{ P_RightCol_0 }
    object{ P_RightSho_1 }
    object{ P_RightFor_2 }
    object{ P_RightHan_3 }
    object{ P_RightThu_4 }
    object{ P_RightThu_5 }
    object{ P_RightThu_6 }
    object{ P_RightInd_7 }
    object{ P_RightInd_8 }
    object{ P_RightInd_9 }
    object{ P_RightMi_10 }
    object{ P_RightMi_11 }
    object{ P_RightMi_12 }
    object{ P_RightRi_13 }
    object{ P_RightRi_14 }
    object{ P_RightRi_15 }
    object{ P_RightPi_16 }
    object{ P_RightPi_17 }
    object{ P_RightPi_18 }
    object{ P_LeftCol_19 }
    object{ P_LeftSho_20 }
    object{ P_LeftFor_21 }
    object{ P_LeftHand_1 }
    object{ P_LeftThu_22 }
    object{ P_LeftThu_23 }
    object{ P_LeftThu_24 }
    object{ P_LeftInd_25 }
    object{ P_LeftInd_26 }
    object{ P_LeftInd_27 }
    object{ P_LeftMid1_1 }
    object{ P_LeftMid2_1 }
    object{ P_LeftMid3_1 }
    object{ P_LeftRin_28 }
    object{ P_LeftRin_29 }
    object{ P_LeftRin_30 }
    object{ P_LeftPin_31 }
    object{ P_LeftPin_32 }
    object{ P_LeftPin_33 }
    object{ P_RightTh_34 }
    object{ P_RightSh_35 }
    object{ P_RightFo_36 }
    object{ P_RightToe_1 }
    object{ P_LeftThi_37 }
    object{ P_LeftShin_1 }
    object{ P_LeftFoot_1 }
    object{ P_Left_Toe_1 }
    object{ P_hair_1 }
  } // boy union  
#end // BOY

#if (HORSE)
  #declare Horse=
  object
  { 
  /*
    union
    {
      #debug "Loading Horse...\n"
      #include "horse2.inc"
    }
    scale 9 rotate <-90,90,10>
    translate <6,-3,0>
    texture{ hide }
  */
    sphere
    {
      0,4
      texture{ SphereTexture }
    }
  }
  #if( ISO_HORSE )
    #declare fn_horse=
    function
    {
      pigment{ SpherePigment }
    }                         
    #declare Horse=
    isosurface
    {
      function{ f_sphere(x,y,z,4) + (1-fn_horse(x,y,z).gray)*.75 }
      contained_by { sphere{ 0, 5 } }
      accuracy 0.001
      max_gradient 1.1
      texture{ SphereTexture }
    }
/*
    #declare fn_horse= 
    function
    {
      object{ Horse }
    } 
    #declare Horse1 =
    isosurface {
      function { fn_horse(x,y,z) + (fn_HorseHideMap(x,y,z).gray*.5) }
      contained_by { box { <-4,-5,-2>,<4,6,2> } }  // container shape
      //threshold 0.0                     // optional threshold value for isosurface [0.0]
      accuracy 0.001                      // accuracy of calculation [0.001]
      max_gradient 3                      // maximum gradient the function can have [1.1]
      //evaluate .5, 2, 0.95             // evaluate the maximum gradient
      //max_trace 1                       // maybe increase for use in CSG [1]
      //all_intersections                 // alternative to 'max_trace'
      //open                              // remove visible container surface 
      texture{ hide }
    }
    #declare Horse = Horse1;
*/ 
    #declare Horse=
    object{ Horse /*rotate -x*90*/ translate<0,-1,0> }
  #end // ISO_HORSE
/*  #include "horse2_o.inc"
  
  #declare Horse=
  union
  {
    object{ P_Hip }
    object{ P_Abdomen }
    object{ P_Chest }
    object{ P_LeftShou_0 }
    object{ P_LeftUpArm }
    object{ P_LeftFore_1 }
    object{ P_Left_Wrist }
    object{ P_Left_Hand }
    object{ P_RightSho_2 }
    object{ P_RightUpArm }
    object{ P_RightFor_3 }
    object{ P_RightWrist }
    object{ P_Right_Hand }
    object{ P_Lower_Neck }
    object{ P_Upper_Neck }
    object{ P_Head }
    object{ P_Left_Thigh }
    object{ P_Left_Leg }
    object{ P_Left_Shin }
    object{ P_Left_Ankle }
    object{ P_Left_Foot }
    object{ P_RightThigh }
    object{ P_Right_Leg }
    object{ P_Right_Shin }
    object{ P_RightAnkle }
    object{ P_Right_Foot }
    object{ P_Tail_1 }
    object{ P_Tail_2 }
    object{ P_Tail_3 }
    object{ P_Tail_4 }
  }
*/
#end // HORSE

#if (SKATEBOARD)
  #include "Skateboard.inc"
#end       

#if (BACKGROUND)
  #declare Background=
  box
  {
    <-50,-50,-1>,<50,50,1>
    pigment
    {
      image_map
      {
        png "background.png"
        filter   1, 1.0 
      }
      translate<-.5,-.5,0>
      scale 100 
    }
  }
#end // BACKGROUND       

#if (TREES)  
  //#declare recursionmax = 6; // Defines the complexity of the tree
  //#declare divisions = array[6] {7,3,3,2,2,4}
  #declare recursionmax = 6; // Defines the complexity of the tree
  #declare divisions = array[recursionmax] {7,3,3,2,2,4}
  init_rand (757,4622,8976)     // Supply seeds to initialize the random variable
  
  // Variables modeled exponentially
  // Use: init_variable (start_size, end_size, base)
  init_tdev (0.5, 0.8, 0.9)
  init_rdev (70, 40, 1)
  init_twigprob (0, 0.7, 0.5)
  init_branchl (3.4, 0.2, 0.6)
  init_branchw (0.35, 0.004, 0.4)
  
  // Odd variables
  init_roots (2)			// Use: init_roots (rootrecursionmax)
  init_splinedev (0.15,0.3)	// Use: init_splinedev (min_dev, max_dev)
  init_simplify (2,2)		// Use: init_simplify (num_simplify_levels, num_segments)
  
  // Add some gravity
  #declare tendancy = <-0.05,0.2,0.05>;

  // Variables for leaves
  #declare leafarray = array[3] {fallmaple1,fallmaple2,fallmaple3}
  #declare leafprob = array[3] {0.4,0.3,0.3}
  #declare leafscale = array[3] {0.2,0.2,0.2}
  #declare leafnoise = array[3] {1,1,1}
    
  // Assign the branch texture
  #declare branchtexture = texture { standard_branch } // standard_branch is defined in leafdefs.inc
  
  // Define transformations assigned to the whole tree here.
  #declare global_transform = transform {
  	scale 2
  }
  
  // Provide feedback in the first 2 recursion levels
  #declare feedback = 2;
  
  // Call the macro
	#declare Tree1=
	  union
	  {
      splinetree(0,0)
    }
  #debug concat( "\nTree1 done.\n")
  
  init_rand (56464,433,24532)     // Supply seeds to initialize the random variable
  #declare global_transform = transform {
  	scale 2
  }
	#declare Tree2=
	  union
	  {
      splinetree(0,0)
    }
  #debug concat( "\nTree2 done.\n")  

  init_rand (876,22,46435)     // Supply seeds to initialize the random variable
  #declare global_transform = transform {
  	scale 2
  }
	#declare Tree3=
	  union
	  {
      splinetree(0,0)
    }
  #debug concat( "\nTree3 done.\n")  

  init_rand (677,6434,454)     // Supply seeds to initialize the random variable
  #declare global_transform = transform {
  	scale 2
  }
	#declare Tree4=
	  union
	  {
      splinetree(0,0)
    }
  #debug concat( "\nTree4 done.\n")  

#end // TREES

#if (GROUND)
  #declare GroundLamp=
    union
    {
      difference
      {
        cylinder
        {
          <0,0,0>,<0,1.1,0>
          .25
        }
        plane{ -y, 0 translate<0,1,0> texture{ pigment{ color rgb <.9,.9,1> } finish{ ambient 10 } } }
      }
      difference
      {
        sphere{ 0, .25 }
        plane{ y, 0 }
        translate<0,1.25,0>
      }
/*
      difference
      {
        cylinder{<0,.25,0><0,0,0> .25}
        torus
        {
          .25,.21
        }
        plane{ -y, 0 translate<0,.225,0>}
        texture{ T_Chrome_5E finish{ ambient .25 } }
        translate<0,1.02,0>
      }
*/
      difference
      {
        cylinder
        {
          <0,1,0>,<0,1.25,0>
          .25
        }
        cylinder
        {
          <0,1,0>,<0,1.25,0>
          .239
        }
        material { texture { pigment { color Clear } finish { F_Glass1 ambient .5} } interior { I_Glass fade_color Col_Blue_03 } }
      }
      texture{ pigment{ Black } finish{ F_MetalA roughness .9 } normal{ agate .1 agate_turb 0.75 scale 1 } }//normal{ dents .25 scale .05 }
    }

  #declare LightBoxFront=
  difference
  {
    box
    {
      <-.010,-.25,-.5>,<.010,.25,.5>
      texture { pigment{ DimGray } }
      //texture{ pigment{ White } normal{wood .5 scale .05 rotate y*90} }
    }
    #local slotcount = 0;
    #local slotmax = 4;
    #while (slotcount < slotmax) 
      box
      {
        <-.05,-.02,-.4>,<.05,.02,.4>
        texture { pigment{ DimGray } }
        rotate z*45
        translate <0,-.175+((.4/slotmax)*slotcount),0>
        #local slotcount = slotcount+1;
        //pigment{ White }
      }
    #end 
  }
/*  difference
  {
    box
    {
      <-.025,-.25,-.5>,<.025,.25,.5>
      texture { pigment { color rgbt<1,1,1,.25> } finish { F_Glass1 roughness 0.5 ambient 2.5} normal{wood .5 scale .05 rotate y*90} }
      //texture{ pigment{ White } normal{wood .5 scale .05 rotate y*90} }
    } 
    box
    {
      <-.05,-.25,-.5>,<-.0249,.25,.5>
      texture { pigment { color Clear } finish { F_Glass1 roughness 0.5} }
      //pigment{ White }
    }
    #if (PHOTONS)
      photons 
      {
      	target 1.0
        reflection off
        refraction on
        collect on
      }
    #end 
  }    
*/
  #declare Steps=
  union
  {
    // steps
    #local stepcount = 1;
    #local height = .5;
    #local depth = 1;
    #while (stepcount < 7)
#if (ISO_STAIRS)
      isosurface
      {
        function { f_rounded_box(x,y,z,.11,4.5,.5,.5)-(.0025-fn_my_cement(x,y,z).gray*.0025)/*-(fn_brushedcement(x,y,z).gray*.04)*/ }          // function (can also contain declared functions
        //function { fn_X(x, y, z) }        // alternative declared function
        //contained_by { box { <-4,-1-(stepcount*height),4-(stepcount*depth)>,<4,-1-((stepcount+1)*height),4-((stepcount+1)*depth)> } }  // container shape
        contained_by { box { <-4.5,-.5,-.5>,<4.5,.5,.5> } }  // container shape
        //threshold 0.0                     // optional threshold value for isosurface [0.0]
        accuracy 0.001                      // accuracy of calculation [0.001]
        max_gradient 4                      // maximum gradient the function can have [1.1]
        //evaluate 5, 1.2, 0.95             // evaluate the maximum gradient
        //max_trace 1                       // maybe increase for use in CSG [1]
        //all_intersections                 // alternative to 'max_trace'
        //open                              // remove visible container surface              
        texture{ pigment{ my_cement_pigment } }
        //<-10,-1,3>,<10,-10,20>
        translate< 0,-1.5-(stepcount*height),3.5-(stepcount*depth)>
      }
#else
      box
      {
        <-4,-1-(stepcount*height),4-(stepcount*depth)>,<4,-1-((stepcount+1)*height),4-((stepcount+1)*depth)>  
      }
#end
      #local stepcount = stepcount+1;
    #end // while
  }
  #if (PILE_ON_LEAVES)
    #declare Steps=
    union
    {
      ScatterLeavesOnSteps( Steps, 453, 100, 5, 7.75, 20 )
      Steps
    }
    #declare Steps=
    union
    {
      ScatterLeavesOnSteps( Steps, 42, 100, 5, 7.75, 20 )
      Steps
    }
  #end // PILE_ON_LEAVES
  #declare Ground=
  union           
  {
    object{ Steps }
#if (ISO_STAIRS)
    isosurface
    {
      function { f_rounded_box(x,y,z,.11,20,4.5,20)-(.0025-fn_my_cement(x,y,z).gray*.0025)/*-(fn_brushedcement(x,y,z).gray*.04)*/ }          // function (can also contain declared functions
      //function { fn_X(x, y, z) }        // alternative declared function
      contained_by { box { <-20,-4.5,-20>,<20,4.5,20> } }  // container shape
      //threshold 0.0                     // optional threshold value for isosurface [0.0]
      accuracy 0.001                      // accuracy of calculation [0.001]
      max_gradient 4                      // maximum gradient the function can have [1.1]
      //evaluate 5, 1.2, 0.95             // evaluate the maximum gradient
      //max_trace 1                       // maybe increase for use in CSG [1]
      //all_intersections                 // alternative to 'max_trace'
      //open                              // remove visible container surface              
      texture{ pigment{ my_cement_pigment } }
      //<-10,-1,3>,<10,-10,20>
      translate< 0,-5.5,23>
    }
#else
    box
    {
      <-20,-1,3>,<20,-10,43>
    }
#end // ISO_GROUND
#if (SIDE_WALLS)
    difference
    {
#if (ISO_GROUND)
      isosurface
      {
        function { f_rounded_box(x,y,z,.11,3,6,3)-(fn_brushedcement_left(x,y,z).gray*.04) }          // function (can also contain declared functions
        //function { fn_X(x, y, z) }        // alternative declared function
        //contained_by { box { <-4,-1-(stepcount*height),4-(stepcount*depth)>,<4,-1-((stepcount+1)*height),4-((stepcount+1)*depth)> } }  // container shape
        contained_by { box { <-3.1,-6.1,-3.1>,<3.1,6.1,3.1> } }  // container shape
        //threshold 0.0                     // optional threshold value for isosurface [0.0]
        accuracy 0.001                      // accuracy of calculation [0.001]
        max_gradient 4                      // maximum gradient the function can have [1.1]
        //evaluate 5, 1.2, 0.95             // evaluate the maximum gradient
        //max_trace 1                       // maybe increase for use in CSG [1]
        //all_intersections                 // alternative to 'max_trace'
        //open                              // remove visible container surface              
        texture{ brushedcement_left }
        translate< -7,-4,.2>
      }
#else
      box
      {
        <-10,-10,3>,<-4,2,-2.8>
      }
#end
      box
      {
        <-5,-2.75,-1>,<-3.9,-2.25,-2>
        texture{ T_Chrome_5A }
      } 
      box
      {
        <-5,-1.75,-0>,<-3.9,-1.25,1>
        texture{ T_Chrome_5A }
      }
    }    
    difference
    {
#if (ISO_GROUND)
      difference
      {
        isosurface
        {
          function { f_rounded_box(x,y,z,.11,3,6,3)-(fn_brushedcement_right(x,y,z).gray*.04) }          // function (can also contain declared functions
          //function { fn_X(x, y, z) }        // alternative declared function
          //contained_by { box { <-4,-1-(stepcount*height),4-(stepcount*depth)>,<4,-1-((stepcount+1)*height),4-((stepcount+1)*depth)> } }  // container shape
          contained_by { box { <-3.1,-6.1,-3.1>,<3.1,6.1,3.1> } }  // container shape
          //threshold 0.0                     // optional threshold value for isosurface [0.0]
          accuracy 0.001                      // accuracy of calculation [0.001]
          max_gradient 4                      // maximum gradient the function can have [1.1]
          //evaluate 5, 1.2, 0.95             // evaluate the maximum gradient
          //max_trace 1                       // maybe increase for use in CSG [1]
          //all_intersections                 // alternative to 'max_trace'
          //open                              // remove visible container surface              
          texture{ brushedcement_right }
          translate< 7,-4,.2>
        }
#if (NO_SKATING)
        box
        {
          //<4.2750,1.8,-3>,<5.4750,.2,-2.812>
          <4.3250,1.8,-3>,<5.4250,.2,-2.802>
          texture{ brushedcement_right }
        }       
#end // NO_SKATING
      }
#else
      difference
      {
        box
        {
          <10,-10,3>,<4,2,-2.8>
        }
        box
        {
          <4.15,1.8,-3>,<5.35,.2,-2.775>
        }
      }
#end
      box
      {
        <5,-2.75,-1>,<3.9,-2.25,-2>
        texture{ T_Chrome_5A }
      } 
      box
      {
        <5,-1.75,-0>,<3.9,-1.25,1>
        texture{ T_Chrome_5A }
      } 
    }
#end // SIDE_WALLS
    // lamps
#if (GROUND_LIGHTS)
    object
    {
      GroundLamp
      translate <4.5,2,-2.25>
    }
    object
    {
      GroundLamp
      translate <-4.5,2,-2.25>
    }
#end // GROUND_LIGHTS
    // light plates
    object
    {
      LightBoxFront
      rotate y*180
      translate<-4,-1.5,.5>
    }
    object
    {
      LightBoxFront
      translate<4,-1.5,.5>
    }
    object
    {
      LightBoxFront
      translate<4,-2.5,-1.5>
    }
    object
    {
      LightBoxFront
      rotate y*180
      translate<-4,-2.5,-1.5>
    }
    texture
    {
      pigment{ White }
/*      agate
      scale 2
      texture_map
      {
        [.25 concrete scale .5]
        [.25 pigment{ White }]
      }
*/
    }
  }
#end // GROUND

#if (RAIL)  
  #declare Rail=
  union
  {
    box
    {
      <-0.0833,-1,-0.0833>,<0.0833,2,0.0833>
    }
    box
    {
      <-0.0833,2,0.0833>,<0.0833,2.04165,-0.0833*2>
    }
    box
    {
      <-0.0833,-4.5,-0.0833>,<0.0833,-1.5,0.0833>
      translate<0,0,-8>
    }                                    
    box
    {
      <-0.0833,-4.5,-0.0833>,<0.0833,-1.5,0.0833>
      translate<0,0,-9>
    }                                    
    box
    {
      <-0.0833,-1.5,-8.0833>,<0.0833,-1.54165,-9.16666>
    }
    sphere
    {
      <0,-1.5+0.0833,-9>, 0.0833
      texture
      { 
        T_Brass_4A 
        normal
        { 
          bumps .25
          scale .02
        }
      }
    }
/*    cylinder
    {
      <0,2,0>,<0,-1.5,-8>
      0.0833

    }
*/
    box
    {
      <-.0833,2,.55>,<.0833,2.04165,-7.85>
      texture
      {
        DownRail
      }
      rotate -x*25.4
    }
    translate<0,0,3.16666>
    texture
    {
      pigment
      {
        RailColor
      }
      normal
      { 
        granite .25
        scale .2
      }
    }
  }
  union
  {
    box
    {
      <-.0833,2,-.0833>,<.0833,0,.0833>
      translate<-4.2,2,-2.6>
    } 
    box
    {
      <-.0833,2,-.0833>,<.0833,0,.0833>
      translate<-4.2,2,2.8>
    } 
    box
    {
      <-.0833,0,-2.6-.0833>,<.0833,0.04165,2.8+.0833>
      translate<-4.2,4.01,0>
    }
    box
    {
      <-.0833,0,-2.6-.0833>,<.0833,0.04165,2.8+.0833>
      translate<0,0,2.6+.0833>
      rotate -y*90
      translate<-4.2,4.01,-2.6>
    }

    box
    {
      <-.0833,2,-.0833>,<.0833,0,.0833>
      translate<4.2,2,-2.6>
    } 
    box
    {
      <-.0833,2,-.0833>,<.0833,0,.0833>
      translate<4.2,2,2.8>
    } 
    box
    {
      <-.0833,0,-2.6-.0833>,<.0833,0.04165,2.8+.0833>
      translate<4.2,4.01,0>
    }
    box
    {
      <-.0833,0,-2.6-.0833>,<.0833,0.04165,2.8+.0833>
      translate<0,0,2.6+.0833>
      rotate y*90
      translate<4.2,4.01,-2.6>
    }
    texture
    {
      pigment
      {
        RailColor
      }
      normal
      { 
        granite .25
        scale .2
      }
    }
  }
#end // RAIL

#if (NO_SKATING)  
  #include "NoSkating.inc"
#end // NO_SKATING

#if (FOUNTAIN)  
  #declare Fountain=
  union
  {
    difference
    {
      difference
      {
        cylinder
        {
          <0,0,0>,<0,2.5,0>
          10
        }
        cylinder
        {
          <0,0.1,0>,<0,2.51,0>
          9
        }
      }
      cylinder
      {
        <0,1.22,0>,<0,1.28,0>
        10.1
      }
      #local Count = 32;
      #local Current = 0;
      #while (Current < 180)
        box
        {
          <-.03,1.25,-10.1>,<.03,2.51,10.1>
          rotate y*Current
          texture{ cementbrushc1 }
        }
        #local Current = Current + (360/Count);
      #end
      #local Current = 0;
      #while (Current < 180)
        box
        {
          <-.03,0,-10.1>,<.03,1.25,10.1>
          rotate y*Current
          rotate y*((360/Count)/2)
          texture{ cementbrushc1 }
        }
        #local Current = Current + (360/Count);
      #end
      texture
      { 
        cementbrushc1 
/*        normal
        {
          granite
          normal_map {
            [ 0.0 granite .075]
            [ 0.39 granite .075]
            [ 0.4 ripples .001 scale .01]
          }
          scale 0.5
        }
*/
      }
    } 
    // morter
    difference
    {
      cylinder
      {
        <0,0,0>,<0,2.49,0>
        9.99
      }
      cylinder
      {
        <0,0,0>,<0,2.5,0>
        9.001
      }
      texture{ pigment{ White*.65 } }
    }
    // rim
    union
    { 
      difference
      {
        cylinder
        {
          <0,2.56,0>,<0,2.76,0>
          10.1
        }
        cylinder
        {
          <0,2.559,0>,<0,2.761,0>
          9                
        }
      }
      torus
      {
        10.1,.1
        translate<0,2.66,0>
      }
      texture{ cementbrushc1 }
      
    }
  }
#end // FOUNTAIN

#if (BRICK_GROUND)  
  #declare Brick_Ground=
  union
  {
    #local NumRings = 10;
    #local CurrentRing = 0;
    #local RingWidth = 1;
    #local RingInnerDiamiter = 10;
    #local RingBrickCount = 32;
    #while (CurrentRing < NumRings)
      difference
      {   
        cylinder
        {
          0,<0,1,0>
          RingInnerDiamiter + RingWidth
        }       
        cylinder
        {
          <0,-.01,0>,<0,1.01,0>
          RingInnerDiamiter
        }       
        #local Current = 0;
        #while (Current < 180)
          box
          {
            <-.03,-.01,-(RingInnerDiamiter + RingWidth)-.1>,<.03,1.01,(RingInnerDiamiter + RingWidth)+.1>
            rotate y*Current
            rotate y*(CurrentRing*((360/RingBrickCount)/2))
            pigment{Red}
          }
          #local Current = Current + (360/RingBrickCount);
        #end
        #local CurrentRing = CurrentRing + 1;
        #local RingInnerDiamiter = RingInnerDiamiter + RingWidth + .06;
        #local RingBrickCount = RingBrickCount + 1;
      }
    #end
    texture{ Floor_Bricks }
  }
  #declare Brick_Ground=
  difference
  {  
    object{ Brick_Ground }
    difference
    {
      //<-20,-1,3>,<20,-10,43>
      box
      {
        <-25,1.1,-25>,<25,-15,25>
      }
      box
      {
        <-20.1,1,-20.01>,<20.1,-10.1,20.01>
      }
      texture{ Floor_Bricks }
    }
    photons{ target off } 
  }
  #if (PILE_ON_LEAVES)
    #declare Brick_Ground=
    union
    {
      ScatterLeavesOn( Brick_Ground, 10, 200, 5, 40, 40 )
      Brick_Ground
    }
    #declare Brick_Ground=
    union
    {
      ScatterLeavesOn( Brick_Ground, 1, 200, 5, 40, 40 )
      Brick_Ground
    }
  #end // PILE_ON_LEAVES
#end // BRICK_GROUND

#if (WATER)
#declare fn_water =
function 
  { 
    pigment 
    { 
      //spiral1 3
      //wood
      ripples
      //granite
      //agate
      //agate_turb .5
      color_map {[0 rgb 1][1 rgb 0]}
      //color_map {[0 rgb 1 - clock][1 rgb clock]}
      rotate<90,0,0>  
      //poly_wave .5  
      warp 
      {                  
        turbulence .5
        octaves 6
        lambda .5
        omega .5
      }

      scale <.75,.75,.75 >
      //scale 2
      translate< 0,(1-clock)*.15,0 >
    } 
  }

#declare Water =
  difference
  {
    isosurface
    {
      //function { y + .05 - fn_water(x,y,z).gray*0.0175 }
      function { y + .05 - fn_water(x,y,z).gray*0.075 }
      //function{ y - f_ridged_mf(x*10, y*20, z*10, 0.1, 3.0, 7, 0.7, 0.7, 2)*.08 } 
      //contained_by { sphere { <0,0,0> .21 } }
      contained_by { box { <-10,-1,-10>,<10,1,10> } }
      open
      max_gradient 1.2
      accuracy 0.01
      //pigment{ White }
      material
      {
        texture{ pigment{ Col_Glass_Bluish } finish { F_Glass5 } }
        interior{ I_Glass1 }       
      }
      //hollow true
      
      photons 
      {
        target
        refraction on
        reflection on
        collect off
      }                
    }
    difference
    {
      cylinder
      {
        <0,-5,0>,<0,2.5,0>
        20
      }
      cylinder
      {
        <0,-5.1,0>,<0,2.51,0>
        9
      }
      pigment{ Gray }
    }
  }
#end // WATER

#if (SPRAY)
  #debug "Calculating Fountain Blobs...\n"
  #include "SprayFountain.inc"
  #declare Spray=
  light_group
  {
#if (FOUNTAIN_LIGHTS)
    light_source
    {
      <0,0,0>
      color rgb <.75,.86,.97>*.5
      spotlight
      radius 30
      falloff 40
      point_at <0,1,0>
      translate<0,0,-5.5>
      #if (PHOTONS)
        photons 
        {
          reflection off
          refraction off
        }
      #end
    }
    light_source
    {
      <0,0,0>
      color rgb <.75,.86,.97>*.5
      spotlight
      radius 30
      falloff 40
      point_at <0,1,0>
      translate<5,0,-.5>
      #if (PHOTONS)
        photons 
        {
          reflection off
          refraction off
        }
      #end
    }

    light_source
    {
      <0,0,0>
      color rgb <.75,.86,.97>*.5
      spotlight
      radius 30
      falloff 40
      point_at <0,1,0>
      translate<-5,0,-.5>
      #if (PHOTONS)
        photons 
        {
          reflection off
          refraction off
        }
      #end
    }
#end // FOUNTAIN_LIGHTS
    union
    {
      object{ FS(3,1.5,1000,32521) translate <0,0,-5>}
      object{ FS(3,1.5,1000,43) translate <-5,0,0>}
      object{ FS(3,1.5,1000,4342) translate <5,0,0>}
      double_illuminate
    }
    global_lights on
  }
#end // SPRAY

#if (COFFEE)
  #include "coffee.inc"
#end // COFFEE

#if (GARBAGECAN)
  #include "Garbagecan.inc"
#end // GARBAGECAN

#if (STARS)
#declare Stars=
  union
  {
    MakeStars(2000,2354)
  }
#end // STARS

////////////////////////////////////////////////////////////
//
// --------------------------------------- Scene
//
//////////////////////////////////////////////////////////// 

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.2,0.1,0.1>]
      [0.05 rgb <0.0,0,0.1>]
      [0.2 rgb <0.0,0,0>]
    }
  }
}

//plane {
//  y, -1
//  pigment { color rgb <0.7,0.5,0.3> }
//}

#if (BOY)
  #debug "Placing Boy\n"
  union
  {
    object{ Boy rotate<-90,180,0> scale 10 translate <0,-2,1> rotate<-20,0,10> photons{ target off } }
    union
    {
      object{ Cap rotate<-90,180,0> scale 10 translate <0,-2,0> rotate<10,0,-5> translate<-2,.75,1> photons{ target off } }
      rotate <0,0,-10>
    }
    translate <-.5,0,0>
  }
  #if ( PILE_ON_LEAVES )
    // scatter some leaves around behind him
    object{ leafarray[0] rotate <80,164,222> scale .5 translate<-3,0,4> }
    object{ leafarray[1] rotate <90,300,10> scale .75 translate<-3.4,-.5,3> }
    object{ leafarray[1] rotate <180,-45,180> scale .75 translate<-2.25,.05,.75> }
  #end
#end

#if (SKATEBOARD)
  #debug "Placing Skateboard\n"
  object{ Skateboard rotate <-45,-55,-10> rotate<0,20,0> scale 1.25 translate <-.5,0,-4> photons{ target off } }//translate<0,0,-1>}        
#end

#if (GROUND)
  #debug "Placing Ground\n"
  object{ Ground photons{ target off } }
#end                       

#if (RAIL)
  #debug "Placing Rail\n"
  object{ Rail photons{ target off } }
#end                       

#if (NO_SKATING)
  #debug "Placing No Skating Sign\n"
    //<10,-10,3>,<4,2,-2.8>
  object{ NoSkatingSign scale .65 translate<4.875,1,-2.8> }
#end

#if (FOUNTAIN)  
  #debug "Placing Fountain\n"
  object{ Fountain translate <0,-1,23> photons{ target off reflection off refraction off } }
  #if (WATER)
    #debug "  Placing Water in Fountain\n"
    object{ Water translate <0,1.5,23> }
  #end // WATER
#end // FOUNTAIN

#if (SPRAY)
  #debug "Placing Water Spray in Fountain\n"
  object
  {
    Spray
    translate <0,1.5,23>
  }
#end // SPRAY

#if (BRICK_GROUND)
  #debug "Placing Plaza Bricks\n"
  object{ Brick_Ground translate <0,-1.999,23> }
#end // BRICK_GROUND

#if (HORSE)  
  #debug "Placing Horse\n"
  //object{ Horse scale 9 rotate <-90,90,10> texture{ hide } translate<7,3,23> photons{ target on } }  
  object{ Horse translate <-6,3,0> translate<7,3,23> photons{ target on } }  
#end // HORSE

#if (TREES)
  #debug "Placing Trees\n"
  object{ Tree1 translate<10,-1,33> }
  object{ Tree2 translate<-10,-1,33> }
  object{ Tree3 translate<-10,-1,13> }
  object{ Tree4 translate<10,-1,13> }
#end // TREES

#if (COFFEE)
  object{ Coffee_Cup scale .75 rotate y*180 translate<-3.7,-2.5,.7> }
#end // COFFEE

#if (GARBAGECAN)
  object{ Garbagecan scale .55 translate<-4.5,-3.75,-4.5> }
#end // GARBAGECAN

#if (STARS)  
  object{ Stars }
#end // STARS

#if (BACKGROUND)
  object{ Background translate<0,6.25,70> }
#end // BACKGROUND
//box{ -.5,.5 pigment{ White } }
/*
sphere
{
  <0,0,0>
  4
  translate<0,6,26>
  texture{ pigment{ White } }
}
*/