// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc"
#include "functions.inc"
#include "glass.inc"

#macro FS(Height,Width,SprayCount,Seed)
  #local RMF=function{ f_ridged_mf(x, y, z, 0.07, 2.2,  7, 0.6, 0.9, 1)}
  #local FountainTextureSmooth=
    texture {
      pigment {
        agate
        agate_turb .5
        pigment_map
        {
          [0 color rgbt <0.2, 0.22, 0.21, 0.94>]
          [.5 color rgbt <0.2, 0.22, 0.21, 0.94>]
          [.75 color rgbt <1,1,1,.85>]
          [1 color rgbt <1,1,1,.85>]
        }
      }
      finish {
        diffuse 0.0
        ambient -0.2
  
        reflection {
          0.0, 0.95
          fresnel on
        }
  
        conserve_energy
  
        specular 0.4
        roughness 0.007
      }
      normal{
        function { RMF(x, y, z) } 0.8
        scale 0.3
      }
    }
  #local FountainTextureRough=
    texture {
      pigment {
        agate
        agate_turb .5
        pigment_map
        {
          [0 color rgbt <0.2, 0.22, 0.21, 0.94>]
          [.5 color rgbt <0.2, 0.22, 0.21, 0.94>]
          [.75 color rgbt <1,1,1,.85>]
          [1 color rgbt <1,1,1,.85>]
        }
      }
      finish {
        diffuse 0.0
        ambient -0.2
  
        reflection {
          0.0, 0.95
          fresnel on
        }
  
        conserve_energy
  
        specular 0.4
        roughness 0.0507
      }
      normal{
        function { RMF(x, y, z) } 0.8
        scale 0.3
      }
    }
  #local FountainMaterial=
    material {
      texture{ FountainTextureRough }
/*        agate
        agate_turb .5
        texture_map
        {
          [0 FountainTextureSmooth]
          [.15 FountainTextureSmooth]
          [.20 FountainTextureRough]
          [1 FountainTextureRough]
        }
      }*/
      interior {
        ior 1.31
        fade_distance 5
        fade_power 1001.0
        fade_color <0.02, 0.20, 0.06>
      }
    }
  blob
  {
    #local R1 = seed(Seed);
    //#local SprayCount = 1000;
    #local CurrentCount = 0;
    //#local Height = 3;
    //#local Width = 1.5;
    #while (CurrentCount < SprayCount)
      #local dist = (rand(R1)-.5)*2;
      #local curWidth = rand(R1)-.5;
      #local yLoc = Height-((dist*dist)/*+w*dist*/)*Height;
      #local xLoc = curWidth*((Width/2) + dist*(Width/2));
      #local shaper = Height-(xLoc*xLoc)*Height;
      #if (yLoc > shaper)
        #local yLoc = shaper;
      #end
      //#debug concat( "dist =  ", str(dist,7,2) " : strength = ", str(((1+dist)/2),7,2), "\n" )
      sphere{ <xLoc,yLoc,0>,.125, .25+((.75+dist)/1.75)  rotate y*(rand(R1)*360)}
      //sphere{ <xLoc,yLoc,0>,.05  rotate y*(rand(R1)*360)}
      #local CurrentCount = CurrentCount + 1;
    #end
    //#local yLoc = -5 + ((xLoc*xLoc)+xLoc)
    //pigment{ White }
    double_illuminate
    no_shadow 
    material{ FountainMaterial }  
  }                 
#end // macro fs
