// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Checkered Floor Example
// Date: mm/dd/yy
// Auth: ?
//

//#version 3.5;

#version unofficial MegaPov 0.4;

#include "colors.inc"
// various glass finishes, colors and interiors
//
#include "glass.inc"

#include "recursion.inc"         

#include "WOODS.INC"    // Great wooden textures created by Dan Farmer and Paul Novak


#declare simple = 0;
#declare bullet = 1;



global_settings {
  assumed_gamma 1.0
  max_trace_level 10
  #if(simple=0)
  	motion_blur 15,0.15
  #end
}

// ----------------------------------------

camera {
  location  <1.0, 0.2, 2.5>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <-0.25, -0.1,  0.0>
}

/*
camera {
  location  <-4.0, 0.5, -5.5>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}
*/
/*
//
camera {
  location  <3.0, 0.2, 18.5>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <-0.25, -0.1,  0.0>
}
*/

sky_sphere {
	/*
	pigment {
		checker Black White
		scale 0.04
	}*/

  pigment {
    gradient y
    /*
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }*/
    pigment_map {
      [0.5 rgb <0.3,0.4,0.8>]
      [0.6 
      	bozo
      	color_map {
      		[0.6 rgb <0.0,0.1,0.8>]
      		[0.9 rgb <0.6,0.7,1.0>]
      	}
      	turbulence 0.7
      	scale <0.1, 0.05, 0.05>
      ]
      //[0.7 rgb <1.0,1.0,1.0>]
    }
    translate -0.5*y
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>*3  // light's color
  translate <15, 20, -20>
}

// ----------------------------------------

/*
plane {               // checkered floor
  y, -1
  texture
  {
    pigment {
      checker
      color White
      color Black
      scale 0.5
    }
    finish{
      diffuse 0.8
      ambient 0.1
    }
  }
}
*/

#local num = 10;
#local i = num;

#declare Tres = union {
	
#while(i > 0)                                                  	
	MakeNode(<0, 0, 0>, i/num*360, 15, 0.05 0.01, 0.01, 10)
	#local i = i-1;
#end
	scale <1, 500, 1>
}


#declare Col_Glass_Clear = color rgbt<1.0, 1.0, 1.0, 0.7>;
#declare Col_Glass_Dark_Green = color rgbt <0.1, 0.7, 0.8, 0.8>;
#declare Col_Glass_Dark_Green1 = color rgbt <0.1, 0.7, 0.8, 0.6>;
#declare Col_Glass_Dark_Green2 = color rgbt <0.1, 0.7, 0.8, 0.7>;


#declare MatGlass1 = material {
	texture {
		pigment {  Col_Glass_Clear }
		finish { F_Glass4 }
	}
	interior {
    ior 1.5
    fade_distance 1.0
    fade_power 0.5
  }
}

#declare MatGlass2 = material {
	texture {
		#if(simple = 1)
		
			pigment {  Col_Glass_Dark_Green }
			
		#else
			
			pigment {
				bozo
				color_map {
					[0.48 Col_Glass_Dark_Green1]
					[0.52 Col_Glass_Dark_Green2]
				}
				scale <0.1, 0.3, 0.1>
				turbulence 0.3
				
			}
			normal {
				gradient x
				slope_map {
					[0 0]
					[0.5 0.05]
					[1 0]
				}
				turbulence 0.1
				scale 0.1			
			}		
			finish { F_Glass4 }
			
		#end
	}
	
	#if(simple = 0)
		interior {
	    ior 1.5
	    fade_distance 1.0
	    fade_power 0.5
		}
	#end
}


#declare GlassThick = 0.1;
#declare GlassThick_2 = GlassThick/2;


#declare Glass = difference {
	box {
		<-2, -2, -GlassThick_2>, <2, 2, GlassThick_2>
		material { MatGlass2 }
	}
	
	cylinder {
		<0, 0, -GlassThick_2-0.001>, <0, 0, GlassThick_2+0.001>, 0.1
		material { MatGlass2 }
	}


/*  
	object {
		Tres
		rotate -x*90
		translate <0, 0, 0>
		material { MatGlass2 }
	}
	*/
	
	

	height_field {
		tga "dirka.tga"
		
		rotate -x*90
		translate <-0.5, -0.5, 0.3>
		
		material { MatGlass2 }
	}	
}


object { Glass }


#declare TexSteel = texture {
    pigment {
      color rgb <0.8,0.8,1.0>
    }
    finish{
      diffuse 0.3
      ambient 0.0
      specular 0.6
      phong 0.8
      reflection 0.8
      //reflection { 0.8 metallic }
      //conserve_energy
    }
  }

#if(simple=0)
#if(bullet=1)
motion_blur{
        union {
        	cylinder {
        		<0, 0, 0>, <0, 0, 0.3>, 0.1
        	}
        	
        	sphere {
        	  <0, 0, 0>, 0.1
        
        		scale <1, 1, 4>
        	  translate z*0.3
        	}
        	texture { TexSteel }
        
        	scale 0.97	
        	translate z*0.7
        }
        translate clock*z
}
#end
#end



/*
#local Width=1.152;
#local Height=0.768;

box {
	<-Width/2, -Height/2, -0.01>, <Width/2, Height/2, 0.01>
	pigment {
		uv_mapping
		image_map {
			tiff "volga_zakat.tiff"
		}
	}
	
	rotate x*180
	scale 2
}
*/
 
difference {
	box {
		-1, 1

#if(simple = 1)
	pigment {
		color rgb <0.38039, 0.14902, 0.0> 
	}
#else
texture {
    pigment {
        wood turbulence 0.08
        scale 0.15
        color_map {
            [0.15 color rgbf <0.38039, 0.14902, 0.0, 0.0>]
            [0.25 color rgbf <0.23539, 0.00000, 0.0, 0.0>]
            [0.35 color rgbf <0.38139, 0.14912, 0.0, 0.0>]
            [0.45 color rgbf <0.23549, 0.00000, 0.0, 0.0>]
            [0.55 color rgbf <0.38139, 0.14902, 0.0, 0.0>]
            [0.65 color rgbf <0.23559, 0.00000, 0.0, 0.0>]
            [0.75 color rgbf <0.38139, 0.14922, 0.0, 0.0>]
            [0.85 color rgbf <0.23549, 0.00000, 0.0, 0.0>]
            [0.95 color rgbf <0.38039, 0.14902, 0.0, 0.0>]
            [0.90 color rgbf <0.23539, 0.00000, 0.0, 0.0>]
            [1.00 color rgbf <0.38039, 0.14932, 0.0, 0.0>]
        }
    }
    
    normal {
    	wood turbulence 0.08
        scale 0.15
        normal_map {
            [0.15 granite 1.0]
            [0.25 granite 0.5]
            [0.35 granite 1.0]
            [0.45 granite 0.5]
            [0.55 granite 1.0]
            [0.65 granite 0.5]
            [0.75 granite 1.0]
            [0.85 granite 0.5]
            [0.95 granite 1.0]
            [0.90 granite 0.5]
            [1.00 granite 1.0]
        }
    }
    
    
    finish {
			ambient 0.05
			diffuse 0.95			
    }
    scale 1.5
		rotate x*120
}
#end

			
	
		scale	<0.4, 2, 0.4>
		translate -x*1.2
	}
	
	box {
		<-2, -2, -GlassThick_2>, <2, 2, GlassThick_2>
		pigment { color Black }
	}
}

difference {
	difference {
		box {
			<-6, -3, 0>, <6, 4, 20>
			hollow	
		}
		box {
			<-5.9, -2.9, 0.1>, <5.9, 3.9, 19.9>			
			hollow	
		}
	}

	box {
		<-2, -2, -1>, <2, 2, 1>
		hollow
	}
	
	pigment {
		color rgb <1, 1, 1>
	}
}

/*
isosurface {
	function noise3d(x, y, z) + sqrt(x*x+y*y+z*z)
	
	contained_by { box { <-2, -2, -2>, <2, 2, 2> } }
	
	open

	//material { MatGlass2 }	
	pigment {
		color rgb 0.5
	}
	
	
	scale 0.1
}*/

#if(simple = 1)		
	#declare maxnum = 10;
#else
	#declare maxnum = 100;
#end  

#declare num = 0;
#declare R1 = seed(78373);

       
//union {
	#while(num < maxnum)  
	
	#declare pos = <0.5 - rand(R1), 0.5 - rand(R1), 0.5*rand(R1)>;
	
	motion_blur{
		box {
			-1, 1
			
			#if(simple = 1)		
				pigment {
					color rgb 0.5
				}
			#else
				material { MatGlass2 }
			#end
			
			scale 0.02*rand(R1)
			rotate <90*rand(R1), 90*rand(R1), 90*rand(R1)>
			
			translate pos
		}
		
		translate <0.3*pos.x*clock, 0.3*pos.y*clock, 0.3*pos.z*clock>
	}
		
		#declare num = num + 1;
	#end


 
/*
// 
box {
	<-5.9, -2.9, 0.1>, <5.9, 3.9, 19.9>			
	hollow	

	pigment { color rgbt < 1, 1, 1, 1> }	

	
	interior {
		media {
			scattering {
				0
				<.05, .05, .05>
			}
		}
	}
	
}
*/

/*
union {
	cylinder { 0, <10, 0, 0> 0.05 pigment{Red} }
	cylinder { 0, <0, 10, 0> 0.05 pigment{Green} }
	cylinder { 0, <0, 0, 10> 0.05 pigment{Blue} }
}
*/
