// Persistence of Vision Ray Tracer Scene Description File
// File: Creation.pov
// Vers: 3.5
// Desc: No Big-bang, it was a symphony...
// Date: 28-12-02
// Auth: Ewan


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
#include "textures.inc"	  // Standard Texture definitions
#include "glass.inc"

global_settings { 
                  photons { count 24000
                            media 200
                          }
                } 
                
#declare Resonance = 2.1;
#declare Tone = 2.1;
#declare Frequency = 1.5;
#declare Vibration = 1.1;

light_source { 0*x
               color_map { [0.000  color rgb <1.0, 0.5, 1.0> * Vibration ]
                           [0.100  color rgb <0.8, 0.2, 1.0> * Vibration ]
                           [0.214  color rgb <0.5, 0.5, 1.0> * Vibration ]
                           [0.328  color rgb <0.2, 0.2, 1.0> * Vibration ]
                           [0.442  color rgb <0.2, 1.0, 1.0> * Vibration ]
                           [0.556  color rgb <0.2, 1.0, 0.2> * Vibration ]
                           [0.670  color rgb <1.0, 1.0, 0.2> * Vibration ]
                           [0.784  color rgb <1.0, 0.5, 0.2> * Vibration ]
                           [0.900  color rgb <1.0, 0.2, 0.2> * Vibration ]
                          }
               media_attenuation on
               photons { refraction on
                         reflection on
                       } 
               spotlight
               translate < 0, 100, -50>
               point_at < 0, 41.5, 75>
               radius 5
               tightness 1
               falloff 12
              }

light_source { 0*x                     
               color rgb <0.0, 0.95, 0.0> * Resonance 
               spotlight               
               media_attenuation on
               photons { refraction on
                         reflection on
                       } 
               translate < -80, 90, 60>
               point_at < 20, 35, 70>      
               radius 10                
               tightness 2            
               falloff 20            
             }


light_source { 0*x
               color rgb <0.0, 0.0, 0.95> * Tone
               media_attenuation on
               photons { refraction on
                         reflection on
                       } 
               spotlight
               translate < 80, 90, 60>
               point_at <-20, 35, 70 >
               radius 10
               tightness 2
               falloff 20
              
              }
                           
light_source { 0*x                     
               color rgb <0.9, 0.0, 0.0> * Frequency   
               spotlight               
               media_attenuation on
               photons { refraction on
                         reflection on
                       } 
               translate < 0, 150, 80>
               point_at <0, 42.5, 70>      
               radius 6                
               tightness 3            
               falloff 20            
             }
     
#declare camera_location =  < 0, 2, 5> ;
#declare camera_look_at  =  < 0, 7, 18> ;

camera { location camera_location
         look_at  camera_look_at 
       }

#declare effect_location = < 0, 50, 70 > ;
#declare effect_type =  "rainbow2"
#declare effect_always_on_top = false;
#include "Lens.inc"
 
 
#declare Matter =

union{
difference {

sphere { 0*y, 1 
         pigment { crackle form  <-0.95, 1.05, 0>  scale 0.5
                   color_map { [ 0.0  color red 2.0 green 0.0 blue 0.0 filter 0.1 transmit 0.1 ]
                               [ 0.1  color red 1.0 green 1.0 blue 0.0 filter 0.925 ]
                               [ 0.2  Clear]
                             }
                 }
         finish { ambient 0.8 diffuse 0.8 specular 0.8 roughness 0.005 }
         photons { reflection on 
                   collect off
                 }
         hollow
       }

sphere { 0*y, 0.3 
         hollow 
         pigment { Black } 
         finish { reflection { 0.05, 1 } } } 
         } // end union
        
sphere { 0*y, 0.3 hollow
         pigment { Clear }
         translate -1*x
       }
          } //end difference
          
          
object { Matter 
         scale 5
         rotate 32*y
         translate < 18, 20, 48>
        }
#declare effect_location = < 18, 20, 48 > ;
#declare effect_scale = 0.6;
#declare effect_type =  "headlight2"
#declare effect_always_on_top = false;
#include "Lens.inc"
 

object { Matter 
         scale 5
         rotate -12*x
         translate <-10, 30, 88>
        }
#declare effect_location = < -10, 30, 88 > ;
#declare effect_scale = 0.5;
#declare effect_type =  "undersea"
#declare effect_always_on_top = false;
#include "Lens.inc"

        
object { Matter 
         scale 5
         rotate 52*z
         translate < 30, 80, 90>
        }
#declare effect_location = < 30, 80, 90 > ;
#declare effect_scale = 0.5;
#declare effect_type =  "camera2"
#declare effect_always_on_top = false;
#include "Lens.inc"

         
object { Matter 
         scale 5 
         rotate 12*x
         translate < -7, 2, 18>
        }
#declare effect_location = < -7, 2, 18 > ;
#declare effect_scale = 3.3;
#declare effect_type =  "diamond"
#declare effect_always_on_top = false;
#include "Lens.inc"         
         
 
sphere { 0*y, 6 
    texture { T_Glass3 }
    
      interior { ior 1.9
                 dispersion 1.1
                 dispersion_samples 5
                 fade_distance 50
                 fade_power 150
               } 
               
    photons { target
              refraction on
              reflection on
              collect off
            }
            
       normal { crackle } 
       
         scale < 1, 1.75, 1>
         translate < 0, 42.5, 70 >
       }
       
       
torus { 0.8, 0.2
       pigment { White filter 0.99 } 
 
    photons { target
              refraction off
              reflection on
              collect on
            }
    normal { waves 6.5}
       
       scale <48, 48, 65>
       rotate 10*x
       translate < 0, 36, 65 >
       hollow
     }
     
torus { 0.8, 0.1
       pigment {   crackle scale 3 
                   color_map { [ 0.00  color red 1.0 green 0.6 blue 0.9 filter 0.98 ]
                               [ 0.08  color red 1.0 green 0.9 blue 0.6 filter 0.99 ]
                               [ 0.15  Clear]
                             }
               }
               
    normal { waves 7.5}
               
    photons { target
              refraction off
              reflection on
              collect on
            }
       
       scale <30, 1, 56>
       rotate -5*z
       translate < 18, 49, 74 >
       hollow
     }
     

media {  scattering { 3, rgb 0.01 extinction 0.4 }
         intervals 10
         samples 3, 6
         method 3
         ratio 0.9
       }


box { <-200, -200, -200>, <200, 200, 200>
      pigment { Black }
      hollow
    }

 
   

       

             
