/*
Internet Raytracing Competition
Fernando Gonzlez del Cueto
Mexico City, Mexico
December 31, 2002
*/

#include "colors.inc"

#include "auxiliar\blobs25.inc"

global_settings {
    
    
    max_trace_level    64
    max_intersections  32
    
    /*
    radiosity {
      pretrace_start 0.08
      pretrace_end   0.01
      count 36

      nearest_count 10
      error_bound 0.5                                         |
      recursion_limit 1

      low_error_factor 0.2
      gray_threshold 0.0
      minimum_reuse 0.015
      brightness 0.01

      adc_bailout 0.01/2
      load_file "radiosity.file"
    }*/
  
    photons {
     count 5e4
     autostop 5
     jitter .4

     spacing 0.005
      //load_file "photons.file"
    }
}


background {White}

camera {
   location  < -21.0, -21.0, 12.0>
   direction <  0.0,  0.0,   2.0  >
   up        <  0.0,  0.0,   1.0  >
   sky <0,0,1>
   right     <  4/3,  0.0,   0.0  >
   look_at   <  -1.0, 0,   0.0  >
   angle 45
   //focal_point < -1, 0, 2>
   //aperture 1.5
   //blur_samples 16

}

light_source {
   <-25,-13,75>, White
    area_light <3, 0, 0>, <0, 3, 0>, 2, 2
    adaptive 1
    jitter

  fade_power 2
  fade_distance 75
  photons {
    reflection on
    refraction on
  }
}


#declare copa = 
 lathe {
  cubic_spline
  13
  <0,0>,
  <0,0>,
  <0.5,0.125>
  <1, 0.5>
  <1.5, 1.125>
  <2,2>
  <2, 2>,
  <2.1, 1.805>,
  <0.5, -1>,
  <0.2, -4.5>,
  <0.5, -5.5>,
  <1.5, -5.9>
  <1.5, -6.1>
  rotate <90,0,0>  
  translate 1*z
}

union {
difference {
 
 object { myblob }
 object {copa}
 
   texture {
    pigment { rgb <1,0,0.2> transmit 0.5 filter 0.5 }
    finish {
      phong 0.5
    }
  }
  normal {
    bozo 1
  }
  
  
  
  interior {
    ior 1.3

    fade_power 1
    fade_distance 2
  }
  
  photons {
    target
    reflection off
    refraction on
    collect off
  }
  
}

object {copa                          
 texture{
  pigment {White transmit 1 filter 0}
  finish{
    ambient 0
    //diffuse 0.125
    phong 0.125
    phong_size 10
    //specular 0.125
    reflection 0.125
  }
  normal {
    bumps
    bump_size 0.1
    scale 1
  } 
  
 }
 
 interior{ ior 1.5 }
  photons {
    target
    reflection on
    refraction on
    collect off
  }
}
 rotate <0,-30,0>
 translate <6,0,2>
}


cylinder {
  <0,0,-125>,<0,0,150>,50
  //-1,1 scale 150
  hollow 
  pigment { 
    image_map { jpeg "auxiliar\back5.jpg"
      //map_type 2
      //interpolate 2  
    }
    scale 50
    rotate <90,0,10>
    translate 20*z
    
  }
  
  finish {    
    diffuse 0.25
    specular 0
  }
  
  photons {
    collect off
  }
}

#declare madera = texture {
   pigment {
     image_map { jpeg "auxiliar\woodfloor4.jpg" }
     scale 30     
   }
   finish {
     ambient 0
     diffuse 0.75
     specular 0.25
     reflection 0.5
   }
  }

#declare radiomesa = 15;

union {
 torus {
   radiomesa, 1
   rotate 90*x
 }
 cylinder {
  -z, z, radiomesa
 }
 texture {madera}
 photons {
    target
    reflection off
    refraction off
 }
 translate -5*z
}


plane {
  z, -20
  pigment {Black}
  finish {diffuse 0.25}
  translate -6*z
  photons {
    target
    reflection off
    refraction off
  }
}