//	"Innocent Shadow"
//	Written by Mark Slone  slone@hiwaay.net
//	December 2002

//	Red, Yellow and Green Sugar Maple leaves
//	Default lying on the ground with the tips curving up

//	Color
//	Red 1  Yellow 2  Green 3
//	Leaf Curve => 0.3 more rounded rounded - 1.5 more flat
//	Size 0.6 - 1.2

#macro Leaf(Color, Size, Curve, StemSize, Seed)

#include "functions.inc"

//	Radius is set in P1r (only varies slightly after that, but narrows at the top)

#local Vary = 0.03;

#local P1r = 0.006 + (rand(Seed)*Vary*0.03);
#local P1x = (rand(Seed)-0.5)*Vary*0.6;
#local P1y = (rand(Seed)-0.5)*Vary*0.3;
#local P1z = 0.05 + (rand(Seed)-0.5)*Vary*3;

#local P2r = P1r + (rand(Seed)*Vary*0.03);
#local P2x = P1x + (rand(Seed)-0.5)*Vary*0.8;
#local P2y = P1y + (rand(Seed)-0.5)*Vary*0.4;
#local P2z = 0.08 + P1z + (rand(Seed)-0.5)*Vary*3;

#local P3r = P2r + (rand(Seed)*Vary*0.03);
#local P3x = P2x + (rand(Seed)-0.5)*Vary*0.9;
#local P3y = P2y + (rand(Seed)-0.5)*Vary*0.5;
#local P3z = 0.11 + P2z + (rand(Seed)-0.5)*Vary*2;

#local P4r = P3r + (rand(Seed)*Vary*0.03) + 0.002;  //  Stalk wider at the end
#local P4x = P3x + (rand(Seed)-0.5)*Vary;
#local P4y = P3y + (rand(Seed)-0.5)*Vary;
#local P4z = 0.13 + P3z + (rand(Seed)-0.5)*Vary;

//	The stalk (comes out toward us, +Z)

#local Stem =
union {
  cone   { <0.,0.,0.>, (P1r*0.4), <P1x, P1y, P1z>, P1r }
  sphere { <P1x, P1y, P1z>, P1r }
  cone   { <P1x, P1y, P1z>, P1r,  <P2x, P2y, P2z>, P2r }
  sphere { <P2x, P2y, P2z>, P2r }
  cone   { <P2x, P2y, P2z>, P2r,  <P3x, P3y, P3z>, P3r }
  sphere { <P3x, P3y, P3z>, P3r }
  cone   { <P3x, P3y, P3z>, P3r,  <P4x, P4y, P4z>, P4r }
	
//  sphere { <0,0,0>, 0.01  pigment { color rgb <0,5,5> } }
	scale <1, 0.75, 1>  //  flatten the stem a bit
      }

#local StemPigment =
pigment {
    crackle
    color_map {
      [0.0 color rgb <0.7, 0.5, 0.2>]
      [0.1 color rgb <0.5, 0.3, 0.1>]
      [0.2 color rgb <0.4, 0.2, 0.1>]
      [0.4 color rgb <0.6, 0.4, 0.2>]
      [0.5 color rgb <0.2, 0.4, 0.1>]  //  few
      [1.0 color rgb <0.0, 0.0, 0.0>]  //  few
               }

  scale <80, 80, 80>  //  Each stem has a dominant color

       turbulence 1.0
       octaves 8        //  6   fuzzy   8 sharper
       lambda 2.8       //  2.0 fuzzy 2.8 more swirly
       omega 0.6        //  0.5 fuzzy 0.6 crinkly
          }  //  end of pigment

#declare RedLeafPigment =
  pigment {
    image_map {
        gif "RedLeaf.gif" 

        transmit 5, 1.0  //  transparent background for RedLeaf
        transmit 25, 1.0  //  transparent background for RedLeaf

        once
        map_type 0
        interpolate 2
               }
           }

#declare RedLeaf2Pigment =
  pigment {
    image_map {
        gif "RedLeaf2.gif" 

        transmit 0, 1.0  //  transparent background for RedLeaf2

        once
        map_type 0
        interpolate 2
               }
           }

#declare RedLeaf3Pigment =
  pigment {
    image_map {
        gif "RedLeaf3.gif" 

        transmit 1, 1.0  //  transparent background for RedLeaf2

        once
        map_type 0
        interpolate 2
               }
           }

#declare YellowLeafPigment =
  pigment {
    image_map {
        gif "YellowLeaf.gif" 

        transmit 253, 1.0  //  transparent background
        transmit 254, 1.0  //  transparent background

        once
        map_type 0
        interpolate 2
               }
           }

#declare YellowLeaf2Pigment =
  pigment {
    image_map {
        gif "YellowLeaf2.gif" 

        transmit 253, 1.0  //  transparent background
        transmit 254, 1.0  //  transparent background

        once
        map_type 0
        interpolate 2
               }
           }

#declare YellowLeaf3Pigment =
  pigment {
    image_map {
        gif "YellowLeaf3.gif" 

        transmit 253, 1.0  //  transparent background
        transmit 254, 1.0  //  transparent background

        once
        map_type 0
        interpolate 2
               }
           }

#declare GreenLeafPigment =
  pigment {
    image_map {
        gif "GreenLeaf.gif" 

        transmit 254, 1.0  //  transparent background

        once
        map_type 0
        interpolate 2
               }
           }

#declare GreenLeaf2Pigment =
  pigment {
    image_map {
        gif "GreenLeaf2.gif" 

        transmit 254, 1.0  //  transparent background

        once
        map_type 0
        interpolate 2
               }
           }

#declare GreenLeaf3Pigment =
  pigment {
    image_map {
        gif "GreenLeaf3.gif" 

        transmit 254, 1.0  //  transparent background

        once
        map_type 0
        interpolate 2
               }
           }

/*
	Isosurface leaf (normal good enough for distant view)
#local FCURVE =  function { sqrt(pow(x,2) + pow(y,2) + pow(z,2) ) - Curve }
#local FLEAF  = function { pigment { granite  scale 0.3  
					translate <rand(Seed)*10, 0, 0> } }
#local FPOWER = 0.01*rand(Seed);

isosurface {
	function { FCURVE(x,y,z) + FLEAF(x,y,z).gray*FPOWER }
	max_gradient 2.0
	contained_by{ sphere { <0,0,0>, Curve } }
	clipped_by {
*/


//	DRAW A LEAF WITH A STEM

#if ( StemSize > 0 ) 
	union {
#end


//	Draw the leaf on a sphere

	sphere { 0, Curve  clipped_by { 

//	If curve is small, 1 radius clip sphere is 1 unit away

#if ( Curve < 1 )
	sphere { <0, 0, -1>, 1 } }
#else
	sphere { <0, 0, -Curve>, 1 } }
#end

//	Image map pigment
//	WARNING: Re-ordered from image names

texture {

	pigment {
#if ( Color = 1 ) RedLeaf2Pigment  	 #end
#if ( Color = 2 ) YellowLeaf2Pigment  #end
#if ( Color = 3 ) GreenLeaf2Pigment  #end

#if ( Color = 4 ) RedLeaf3Pigment  	 #end
#if ( Color = 5 ) YellowLeaf3Pigment  #end
#if ( Color = 6 ) GreenLeaf3Pigment  #end

#if ( Color = 7 ) RedLeafPigment  	 #end
#if ( Color = 8 ) YellowLeafPigment  #end
#if ( Color = 9 ) GreenLeafPigment  #end
		scale 0.8  
		translate <-0.4, -0.4, 0> 
			 }

//	A crinkly surface, random

normal { granite 0.2  scale 0.1  translate <rand(Seed)*10, 0, 0> }	

		}  //  end of texture

//	Position the image so by default the leaf lies flat

	translate <0, 0, Curve>

	rotate -90*x 

	hollow
	double_illuminate
			}  //  end of sphere

//	Add a stem

#if ( StemSize > 0 )

	object { Stem  

				scale StemSize

		texture {
			finish {
				ambient 0.0
				diffuse 0.8
				metallic
				specular 0.3  roughness 0.1  }

//			pigment { color rgb <1,1,1> }

			pigment {  
				StemPigment
				scale(rand(Seed) + 1.0)
				translate <rand(Seed)*10.0, rand(Seed)*10.0, rand(Seed)*10.0>
					 }

			normal { granite 0.3  scale <1, 1, 3> }
				 }

//	Move the stem to the leaf image's stem attach point

translate < 0.01, 0.0, -0.04>

/*
#if ( Color = 1 ) translate < 0.01, 0.0, -0.04>  #end
#if ( Color = 2 ) translate < 0.01, 0.0, -0.04>  #end
#if ( Color = 3 ) translate < 0.01, 0.0, -0.04>  #end
*/
//	rotate stem and position it to curve

			   	translate <0, -Curve, 0>
				rotate (-12/Curve)*x
				translate <0, Curve, 0>

			  }
#end
	
	scale <Size*0.7, Size*0.525, Size*0.7>  //  800x600 pixels

#if ( StemSize > 0 ) 
	   }  //  end of leaf/stem union
#end

#end  //  end macro

//	Draw lots of leaves 

#declare Leaves =

#local R47 = seed(47);

//			Leaf( Color, Size, Flatness/Curvature, StemSize, RandSeed)
union {

//	Left of flowers

	object { Leaf(2, 1.0, 0.7, 1.0, R47)  rotate  -40*y  rotate 10*x translate < 0.9, 0.02, -0.6> }
	object { Leaf(3, 0.9, 0.5, 1.0, R47)  rotate -120*y  translate < 1.0, 0.02, -0.5> }
	object { Leaf(4, 0.8, 0.3, 1.0, R47)  rotate  -90*y  rotate -40*x translate < 1.4, 0.04, -0.4> }

//	Below the mushroom

	//	First Layer (Flat)

		//	Row 1 (Red)

	object { Leaf(1, 1.1, 7.0, 1.0, R47)  rotate   60*y  translate < 5.6, -0.05, -0.3> }
	object { Leaf(4, 0.9, 5.0, 0.7, R47)  rotate  -60*y  translate < 6.0, -0.05, -0.4> }
	object { Leaf(7, 1.0, 3.0, 1.0, R47)  rotate -120*y  translate < 6.4, -0.05, -0.3> }

		//	Row 2 (Yellow)

	object { Leaf(2, 0.9, 3.0, 0.9, R47)  rotate  120*y  translate < 5.4, -0.025, -0.5> }
	object { Leaf(5, 1.0, 9.0, 0.0, R47)  rotate   30*y  translate < 5.8, -0.025, -0.6> }
	object { Leaf(8, 1.1, 4.0, 0.8, R47)  rotate  -60*y  translate < 6.2, -0.025, -0.6> }
	object { Leaf(5, 1.0, 8.0, 0.0, R47)  rotate -180*y  translate < 6.6, -0.025, -0.5> }

		//	Row 3 (Green)

	object { Leaf(3, 0.8, 5.0, 1.0, R47)  rotate   10*y  translate < 5.2, -0.04, -0.3> }
	object { Leaf(3, 1.1, 1.0, 0.0, R47)  rotate   80*y  translate < 5.6, -0.03, -0.7> }
	object { Leaf(5, 0.9, 0.9, 0.6, R47)  rotate  100*y  translate < 6.0, -0.03, -0.8> }
	object { Leaf(8, 1.0, 0.8, 0.0, R47)  rotate  -80*y  translate < 6.4, -0.03, -0.7> }
	object { Leaf(6, 0.8, 2.0, 0.9, R47)  rotate  -10*y  translate < 6.8, -0.03, -0.3> }

	//	Second Layer

		//	Row 1 (Red)

	object { Leaf(1, 1.0, 0.7, 0.0, R47)  rotate   30*y  translate < 4.7, -0.055, -0.45> }

	object { Leaf(4, 0.9, 0.4, 0.7, R47)  rotate  -40*y  translate < 5.3, -0.04, -0.4> }
	object { Leaf(1, 1.0, 0.4, 1.0, R47)  rotate   30*y  rotate -15*x  translate < 5.8, -0.01, -0.3> }  // bright
	object { Leaf(7, 1.0, 0.5, 0.0, R47)  rotate -140*y  translate < 6.1, -0.03, -0.3> }
	object { Leaf(1, 1.0, 0.3, 1.0, R47)  rotate   70*y  translate < 6.5, -0.03, -0.3> }  // bright
	object { Leaf(4, 0.9, 0.6, 0.7, R47)  rotate  -90*y  translate < 7.1, -0.03, -0.4> }

		//	Row 2 (Yellow)

	object { Leaf(5, 0.9, 0.4, 0.9, R47)  rotate  -80*y  translate < 5.2, -0.05, -0.5> }
	object { Leaf(2, 1.0, 0.6, 0.0, R47)  rotate   20*y  translate < 5.7, -0.02, -0.6> }
	object { Leaf(8, 1.0, 0.3, 0.8, R47)  rotate -100*y  translate < 6.3, -0.02, -0.6> }
	object { Leaf(2, 1.0, 0.5, 0.0, R47)  rotate   33*y  translate < 6.9, -0.02, -0.5> }

		//	Row 3 (Green)

	object { Leaf(9, 0.9, 0.6, 0.6, R47)  rotate  100*y  translate < 5.7, -0.01, -0.8> }
	object { Leaf(7, 1.0, 0.4, 0.0, R47)  rotate  -80*y  translate < 6.2, -0.01, -0.7> }
	object { Leaf(6, 0.8, 0.5, 0.0, R47)  rotate  -10*y  translate < 6.6, -0.01, -0.3> }

//	Left of door

	object { Leaf(7, 0.9, 0.5, 1.0, R47)  rotate 120*y  translate < 7.3, 0.00, -0.5> }
	object { Leaf(4, 0.9, 0.6, 0.0, R47)  rotate  40*y  rotate -20*x translate < 7.40, 0.04, -0.6> }
	object { Leaf(2, 0.8, 5.0, 1.0, R47)  rotate 90*y   translate < 7.6, 0.01, -0.5> }

	object { Leaf(3, 1.0, 9.0, 1.0, R47)  rotate -40*y  translate < 8.5, 0.020, -0.7> }
	object { Leaf(2, 0.9, 1.0, 1.0, R47)  rotate 15*y   translate < 8.8, 0.015, -0.6> }
	object { Leaf(6, 1.0, 0.6, 0.6, R47)  rotate 220*y  translate < 9.0, 0.015, -0.6> }

	object { Leaf(4, 0.9, 0.5, 1.0, R47)  rotate 110*y  translate < 9.3, 0.020, -0.2> }

//	Right of door

	object { Leaf(5, 1.0, 0.4, 0.0, R47)  rotate  40*y  translate < 11.55, 0.010, -0.2> }  //  Too deep
	object { Leaf(3, 0.8, 0.5, 0.0, R47)  rotate 210*y  translate < 11.75, 0.005, -0.2> }
	object { Leaf(2, 0.9, 0.8, 1.0, R47)  rotate 70*y   translate < 11.85, 0.015, -0.4> }
	object { Leaf(7, 1.0, 9.0, 1.0, R47)  rotate -40*y  translate < 12.05, 0.010, -0.2> }
	object { Leaf(1, 0.9, 0.9, 0.6, R47)  rotate 200*y  translate < 12.15, 0.025, -0.2> }
	object { Leaf(5, 0.9, 1.0, 1.0, R47)  rotate 15*y   translate < 12.25, 0.015, -0.4> }  //  Too deep
	object { Leaf(4, 1.0, 0.5, 0.0, R47)  rotate -90*y  translate < 12.35, 0.015, -0.6> }  //  Too deep
	object { Leaf(2, 0.9, 0.9, 1.0, R47)  rotate 15*y   translate < 12.55, 0.025, -0.3> }
	object { Leaf(6, 1.0, 1.0, 0.6, R47)  rotate 120*y  translate < 12.65, 0.015, -0.5> }
	object { Leaf(6, 1.1, 0.4, 0.8, R47)  rotate -50*y  translate < 12.75, 0.025, -0.2> }  //  Too deep
	object { Leaf(1, 0.8, 0.9, 1.0, R47)  rotate 90*y   translate < 12.85, 0.025, -0.4> }

	object { Leaf(5, 0.9, 0.6, 0.6, R47)  rotate -20*y  translate < 12.65, 0.010, -0.9> }
	object { Leaf(1, 0.7, 0.7, 0.0, R47)  rotate  40*y  rotate 10*x translate < 12.45, 0.020, -0.9> }
	object { Leaf(3, 0.8, 0.5, 1.0, R47)  rotate 120*y  translate < 12.55, 0.020, -0.7> }

//	Inside doorway

	object { Leaf(3, 0.8, 0.8, 0.8, R47)  rotate -70*y  rotate 15*z translate < 11.4, 0.175,  0.5> }
	object { Leaf(1, 1.0, 0.7, 1.0, R47)  rotate  60*y  rotate -5*x  translate < 13.0, 0.02, 1.2> }

//	Random away from wall

	object { Leaf(4, 0.7, 0.5, 0.8, R47)  rotate  45*y  translate <  1.8, 0.040, -2.3> }  // left
	object { Leaf(5, 0.6, 0.4, 0.7, R47)  rotate -70*y  translate <  3.5, 0.020, -1.3> }  // 
	object { Leaf(1, 0.9, 0.4, 1.0, R47)  rotate  30*y  translate <  8.2, 0.025, -1.7> }  // hydrant
	object { Leaf(2, 0.8, 0.5, 1.0, R47)  rotate  70*y  translate < 11.5, 0.020, -1.8> }  // bright

	   }