//	"Innocent Shadow"
//	Written by Mark Slone  slone@hiwaay.net
//	December 2002

//	The door, window, hydrant (Pipe) and other parts

#include "functions.inc"

#local WindowAmbient = 20;
#local DoorDiffuse = 0.5;

#local StoneTexture =
	texture {

	finish { ambient WindowAmbient } 

	  pigment {
    granite
    color_map {
    [0.00 rgbt <1.00, 0.95, 0.90>]
    [0.40 rgbt <0.90, 0.80, 0.75>]
    [1.00 rgbt <0.35, 0.35, 0.25>]
               }

  scale <2.5, 4.0, 2.5>

	warp { turbulence 0.7 }
    octaves 8        //  6   fuzzy   8 sharper
    lambda 2.5       //  2.0 fuzzy 2.6 more swirly
    omega 0.6        //  0.5 fuzzy 0.6 crinkly
           }
        }

  texture {
	pigment {
      bozo
    color_map {
      [0.00 color rgbt <0.31, 0.20, 0.00, 0.9>]  
      [0.10 color rgbt <0.30, 0.17, 0.10, 0.4>] 
      [0.25 color rgbt <0.39, 0.20, 0.15, 0.9>]
      [0.37 color rgbt <0.46, 0.30, 0.19, 0.9>]  
      [0.55 color rgbt <0.65, 0.39, 0.17, 0.9>]  
      [0.73 color rgbt <0.65, 0.39, 0.17, 1.0>]  
      [0.75 color rgbt <0.31, 0.25, 0.10, 0.3>]  
      [0.77 color rgbt <0.20, 0.15, 0.10, 1.0>] 
      [1.00 color rgbt <0.20, 0.15, 0.10, 1.0>]
               }
      scale <2.0, 8.0, 2.0>

       turbulence 1.00  
       lambda 2.8
       omega 0.6
       octaves 8
           }  }

//		Rusty Iron Texture

#local IronPigment =
  pigment {
    wrinkles
    color_map {
      [0.0 rgb <0.10, 0.10, 0.10>]
      [0.7 rgb <0.15, 0.15, 0.15>]
      [1.0 rgb <0.20, 0.20, 0.20>]
    	       }
	scale 5
	       }

#local IronTexture =
texture {
	pigment { IronPigment }
    normal { granite 0.2  scale 1.0}
    finish { ambient (WindowAmbient*0.5) roughness 0.015  specular .2  diffuse 0.8 }
		 }

#local RustPigment =
         pigment
                 {
                 granite
                 color_map {
                         [ 0.0 rgb <0.71, 0.30, 0.11>*0.8 ]  //  0.8
                         [ 0.4 rgb <0.21, 0.10, 0.03>*1.2 ]  //  1.2
                         [ 0.6 rgb <0.21, 0.10, 0.03>*1.2 ]  //  1.2
                         [ 1.0 rgb <0.47, 0.05, 0.01>*0.9 ]  //  0.9
                            }
                 scale .5
                 turbulence 1
                 }

#local RustTexture = 
	texture {
	finish { ambient WindowAmbient } 
         pigment { RustPigment }
         normal { wrinkles  scale 2 }
         	 }

#local RustyIronTexture = 
	texture {
		bozo
		texture_map {
                 [ 0.0 RustTexture ]
                 [ 0.3 RustTexture ]  //  was 0.2
                 [ 0.6 IronTexture ]  //  was 0.5
                 [ 1.0 IronTexture ]
					 }
		warp { turbulence 1  omega .6  lambda 4 }
		scale <1,2,1>
         	}

#local BlueIronPigment =
  pigment {
    wrinkles
    color_map {
      [0.0 rgb <0.25, 0.25, 0.3>*0.8]
      [0.5 rgb <0.35, 0.35, 0.4>*0.8]
      [1.0 rgb <0.45, 0.45, 0.5>*0.8]
    	       }
	scale 2
	       }

#local BlueIronTexture =
texture {
	pigment { BlueIronPigment }
    normal { granite 0.3  scale 1.0}
    finish { roughness 0.005  specular 0.3  diffuse DoorDiffuse }
		 }

//		Hammered Copper Verdigre Texture

#local CopperPigment =
  pigment {
    wrinkles
    color_map {
      [0.0 rgb <0.8, 0.4, 0.1>]
      [0.7 rgb <0.9, 0.5, 0.2>]
      [1.0 rgb <0.9, 0.3, 0.3>]
//      [0.0 rgb <0.8, 0.6, 0.1>]
//      [0.7 rgb <0.9, 0.7, 0.2>]
//      [1.0 rgb <0.9, 0.4, 0.2>]
    	       }
	scale 0.5
	       }

#local CopperTexture =
texture {
	pigment { CopperPigment }
    normal { dents 1.0  scale 0.2}
    finish { ambient (WindowAmbient*.5)
			 diffuse 0.6 
			 specular .1  roughness 0.001  
			 metallic  brilliance 1.5  //  reflection .15
			}
		 }

#local VerdPigment =
         pigment
                 {
                 granite
                 color_map {
      [0.0 color rgb <0.45, 0.45, 0.10>*0.5 ]  //  Yellow
      [0.2 color rgb <0.30, 0.45, 0.10>*0.5 ]  //  Green
      [0.5 color rgb <0.20, 0.40, 0.05>*0.5 ]  //  Med Green
      [0.7 color rgb <0.30, 0.45, 0.10>*0.5 ]  //  Green
      [1.0 color rgb <0.15, 0.25, 0.05>*0.5 ]  //  Dark Green
							}
                 scale .5
                 turbulence 1
                 }

#local VerdTexture = 
	texture {
         	 pigment { VerdPigment }
         	 normal { wrinkles  scale 2 }
         	 }

#local CopperVerdTexture = 
	texture {
		bozo
		texture_map {
                 [ 0.0 VerdTexture ]
                 [ 0.1 VerdTexture ]
                 [ 0.6 CopperTexture ]
                 [ 0.9 CopperTexture ]
                 [ 1.0 VerdTexture ]
					 }
		warp { turbulence 1  omega .6  lambda 4 }
		scale 0.4
//		translate <1, -.5, 0>
         	}

#local RustyMarbleTexture =
texture {

	finish { ambient WindowAmbient*0.8 } 

  pigment {
    wrinkles
    turbulence 0.50
    omega 0.80
    lambda 3.00
    color_map {
      [0.00 color rgb <0.30, 0.05, 0.00>]  //  Dark splotches
      [0.40 color rgb <0.55, 0.25, 0.15>]  //  Orange Main
      [1.00 color rgb <0.80, 0.50, 0.30>]  //  Light Stains

                }
    scale 0.4
	   }
         
	normal { wrinkles  scale 2 }
         }

#local DoorMarbleTexture =
texture {
  finish { diffuse DoorDiffuse  reflection 0.3 }  //  reflection is slow
  pigment {
    wrinkles
    turbulence 0.50
    omega 0.80
    lambda 3.00
    color_map {
//										  0.4 is good for white door

      [0.00 color rgbt <0.25, 0.05, 0.00, 0.7>]  //  Dark splotches
      [0.40 color rgbt <0.50, 0.20, 0.05, 0.7>]  //  Orange Main
      [1.00 color rgbt <0.60, 0.30, 0.10, 0.7>]  //  Light Stains

                }
    scale 0.3
	   }
         
	normal { wrinkles  scale 2 }
         }

#local ThresholdMarbleTexture =
texture {
  pigment {
    wrinkles
    turbulence 0.50
    omega 0.80
    lambda 3.00
    color_map {
      [0.00 color rgb <0.5, 0.5, 0.5>]  //  Dark splotches
      [0.40 color rgb <0.6, 0.6, 0.6>]  //  Main
      [1.00 color rgb <0.7, 0.7, 0.7>]  //  Light Stains

                }
    scale 0.4
	   }
         
	normal { wrinkles  scale 2 }
         }

#local StairsTexture =
texture {
  pigment {
    wrinkles
    turbulence 0.50
    omega 0.80
    lambda 3.00
        color_map {
            [0.00  color rgb <0.24, 0.22, 0.20>*0.0]
            [0.40  color rgb <0.27, 0.25, 0.23>*0.3]
            [1.00  color rgb <0.25, 0.23, 0.21>*0.6]
                   }
	scale <1, 0.1, 1>
	        }
  normal { granite 0.7  scale <1.0, 0.4, 1.0> }
		}

texture {  //  splotches
  pigment {
    wrinkles
    color_map {
      [0.00    color rgbt <0.40, 0.30, 0.20, 1.0>]
      [0.66    color rgbt <0.20, 0.15, 0.10, 0.8>]
      [0.66001 color rgbt <0.20, 0.15, 0.10, 0.4>]
      [1.00    color rgbt <0.25, 0.15, 0.17, 0.2>]
                }
           }
		}

#local LightStairsTexture =
texture {
  pigment {
    wrinkles
    turbulence 0.50
    omega 0.80
    lambda 3.00
        color_map {
            [0.00  color rgb <0.24, 0.22, 0.20>*0.5]
            [0.40  color rgb <0.27, 0.25, 0.23>*1.0]
            [1.00  color rgb <0.25, 0.23, 0.21>*1.5]
                   }
	scale <1, 0.1, 1>
	        }
  normal { granite 0.7  scale <0.4, 0.4, 1.0> }
		}

texture {  //  splotches
  pigment {
    wrinkles
    color_map {
      [0.00    color rgbt <0.40, 0.30, 0.20, 1.0>]
      [0.66    color rgbt <0.20, 0.15, 0.10, 0.8>]
      [0.66001 color rgbt <0.20, 0.15, 0.10, 0.4>]
      [1.00    color rgbt <0.25, 0.15, 0.17, 0.2>]
                }
           }
		}

#local WoodTexture =
texture {

	finish { ambient WindowAmbient } 

  pigment {
    wrinkles
    turbulence 0.50
    omega 0.80
    lambda 3.00
        color_map {
//	Rich brown:
//            [0.00  color rgb <0.24, 0.15, 0.07>*0.4]
//            [0.40  color rgb <0.27, 0.16, 0.07>*1.0]
//            [1.00  color rgb <0.25, 0.15, 0.07>*2.0]

//	Weathered gray:
            [0.00  color rgb <0.24, 0.18, 0.15>*0.2]
            [0.40  color rgb <0.27, 0.19, 0.15>*1.0]
            [1.00  color rgb <0.25, 0.18, 0.15>*2.0]
                     }
	scale <0.7, 0.07, 1>
	   }
     
/*    
//	A good normal for non-isosurface version:

	normal { 
		average
		normal_map {
			[ 1.0  wrinkles scale 2 ]
			[ 1.0  granite  scale 1.5 ]
			[ 1.0  granite  scale 0.5 ]
					}
			}
*/
         }

#local GlassTexture =
texture {
        finish {
          ambient 0.0
          diffuse 0.2
          reflection 0.3
                }

	pigment { color rgbt <0.0, 0.1, 0.2, 0.8> }

	normal { bumps 0.1  scale 0.02 }  //  wavy glass
	 }

#local DarkGlassTexture =

texture {
        finish {
          ambient 0.0
          diffuse 0.2
          brilliance 2
          specular 0.50 roughness 0.001
          reflection 0.4
                }

	pigment { color rgbt <0.0, 0.1, 0.2, 0.5> }

	normal { bumps 0.1  scale 0.02 }  //  wavy glass

	 }

//		Dark water stains at base (in feet)
//		(ligher for Shadow wall)

#local StreakyGreenPigment =
  pigment {
      bozo
    color_map {
      [0.00 color rgbt <0.05, 0.15, 0.0, 0.7>]
      [0.10 color rgbt <0.00, 0.15, 0.0, 0.3>]
      [0.25 color rgbt <0.05, 0.10, 0.0, 0.7>]
      [0.37 color rgbt <0.00, 0.10, 0.0, 0.3>]
      [0.63 color rgbt <0.05, 0.15, 0.0, 0.7>]
      [0.75 color rgbt <0.00, 0.15, 0.0, 0.3>]
      [0.90 color rgbt <0.05, 0.10, 0.0, 0.7>]
      [1.00 color rgbt <0.00, 0.10, 0.0, 0.3>]
               }
      scale <15., 15., 15.>
       turbulence 1.00
       lambda 2.8
       omega 0.6
       octaves 8
           }

#local StreakyClearPigment =
  pigment {
      bozo
    color_map {
      [0.00 color rgbt <0.20, 0.15, 0.00, 1.0>]  
      [1.00 color rgbt <0.20, 0.15, 0.00, 1.0>]
               }

      scale 10 

       turbulence 1.00  
       lambda 2.8
       omega 0.6
       octaves 8
           } 

#local GrayStain = pigment { color rgbt <0.01, 0.03, 0.1, 0.2> } 

//      Water mark fades as it nears the top (scaled to 1/10 foot)
//      Green tint for color

#local BaseWaterStains =
texture {
	pigment {
		gradient y
		pigment_map {
       		[0.00 GrayStain ]
       		[0.02 StreakyGreenPigment  scale 0.05 ]
       		[0.07 StreakyClearPigment  scale 0.15 ] 
       		[0.50 StreakyClearPigment  scale 0.20 ] 
       		[0.60 StreakyGreenPigment  scale 0.05 ]
       		[1.00 StreakyGreenPigment  scale 0.25 ]
             		 }
    scale 10.0  //  scale to fit the wall
        	}
	    }

#local DarkStoneTexture =
	texture {

	finish { ambient WindowAmbient*0.7 } 

	  pigment {
    granite
    color_map {
    [0.00 rgbt <1.00, 0.95, 0.90>]
    [0.40 rgbt <0.90, 0.80, 0.75>]
    [1.00 rgbt <0.35, 0.35, 0.25>]
               }

  scale <2.5, 4.0, 2.5>

	warp { turbulence 0.7 }
    octaves 8        //  6   fuzzy   8 sharper
    lambda 2.5       //  2.0 fuzzy 2.6 more swirly
    omega 0.6        //  0.5 fuzzy 0.6 crinkly
           }
        }

  texture {
	pigment {
      bozo
    color_map {
      [0.00 color rgbt <0.31, 0.20, 0.00, 0.9>]  
      [0.10 color rgbt <0.30, 0.17, 0.10, 0.4>] 
      [0.25 color rgbt <0.39, 0.20, 0.15, 0.9>]
      [0.37 color rgbt <0.46, 0.30, 0.19, 0.9>]  
      [0.55 color rgbt <0.65, 0.39, 0.17, 0.9>]  
      [0.73 color rgbt <0.65, 0.39, 0.17, 1.0>]  
      [0.75 color rgbt <0.31, 0.25, 0.10, 0.3>]  
      [0.77 color rgbt <0.20, 0.15, 0.10, 1.0>] 
      [1.00 color rgbt <0.20, 0.15, 0.10, 1.0>]
               }
      scale <2.0, 8.0, 2.0>

       turbulence 1.00  
       lambda 2.8
       omega 0.6
       octaves 8
           }  }

//	Sun and bird images by Slone Clement

#declare SunPigment =
  pigment {
    image_map {
        gif "Sun.gif" 

        transmit 254, 1.0  //  transparent background

        once
        map_type 0
        interpolate 2
               }
           }

#declare BirdPigment =
  pigment {
    image_map {
        gif "BirdBlue2.gif" 

        transmit 251, 1.0  //  transparent background
        transmit 254, 1.0  //  transparent background

        once
        map_type 0
        interpolate 2
               }
           }

#local StuccoTexture =

texture {

  pigment {
    wrinkles
    color_map {
      [0.00 color rgb <0.95, 0.70, 0.30>]  //  Washed out
      [0.30 color rgb <1.00, 0.70, 0.30>]
	  [0.45 color rgb <1.00, 0.70, 0.25>] 
      [0.55 color rgb <1.00, 0.65, 0.30>] 

      [0.86    color rgb <1.00, 0.75, 0.30>]
      [0.86001 color rgb <0.20, 0.15, 0.10>]
      [1.00    color rgb <0.25, 0.15, 0.17>]
                }
    scale <1.0, 1.0, 1.0>
           }

//	Base texture normals

	normal {
		average
		normal_map {
			[ 1.0  wrinkles 0.35  scale 4  translate <-9, -9, 0> ]  //  this "dirty's" it up
			[ 0.7  granite  0.3 ]
				    }
			}	

         }

//	Color transition

texture {
  pigment {
    gradient y

    turbulence 0.10
      octaves 8        //  6   fuzzy   8 sharper
      lambda 2.8       //  2.0 fuzzy 2.8 more swirly
      omega 0.6        //  0.5 fuzzy 0.6 crinkly

    color_map {
      [0.00 color rgbt <0.35, 0.25, 0.17, 0.75>]  //  Dark splotches
      [0.34 color rgbt <0.35, 0.25, 0.17, 0.75>]  //  Dark splotches
      [0.36 color rgbt <0.50, 0.45, 0.34, 0.75>]  //  Medium splotches
      [0.49 color rgbt <0.50, 0.45, 0.36, 0.75>]  //  Medium splotches
      [0.51 color rgbt <0.50, 0.48, 0.47, 0.75>]  //  Light Stains
      [1.00 color rgbt <0.50, 0.48, 0.45, 0.75>]  //  Light Stains
                }
    scale <23.0, 23.0, 1.0>
	   }
	 }

//	The sun and bird drawings by Slone Clement

texture {
	pigment { SunPigment }
	scale <2.1, 1.6, 1>					//  Image was 475x400 pixels
	translate <9.5, 3.3, 0>  //  was 14
		}

texture {
	pigment { BirdPigment }
	scale <2.5, 2.0, 1>					//  Image was 475x400 pixels
	translate <7.5, 0.5, 0>  //  was 12
		}


//	A wash

texture {
	pigment {
		wrinkles  
      		color_map {  //			Decrease transparency for rougher surface
				[ 0.00 color rgbt <1.0, 0.55, 0.30, 0.70> ]  //  Orange
				[ 0.35 color rgbt <1.0, 0.80, 0.50, 0.60> ]  //  Peach
        		[ 0.85 color rgbt <0.9, 0.90, 0.90, 0.70> ]  //  Light gray
        		[ 1.00 color rgbt <0.9, 0.90, 0.90, 0.80> ]  //  White
                	   }
		warp { turbulence 0.3 }
		scale <4,2,4>
		translate <30, -9.0, 0>
             } 
		normal { granite 0.25  scale 0.4 }
	   }

//	Finally, the overshaded darkness (in feet)

texture {
  pigment {
    gradient y
    color_map {
      [0.000 color rgbt <0.2, 0.0, 0.0, 0.60>]  //  Dark
      [0.010 color rgbt <0.0, 0.0, 0.0, 1.00>]  //  Clear

      [0.0750 color rgbt <0.0, 0.0, 0.0, 1.00>]  //  Clear
      [0.0755 color rgbt <0.5, 0.1, 0.0, 0.87>]  //  The red horizontal band
      [0.0850 color rgbt <0.7, 0.2, 0.0, 0.97>]  //  
      [0.0855 color rgbt <0.0, 0.0, 0.0, 1.00>]  //  Clear

      [0.215 color rgbt <0.0, 0.0, 0.0, 1.00>]  //  Clear
      [0.230 color rgbt <0.0, 0.0, 0.0, 0.60>]  //  Dark
      [1.000 color rgbt <0.0, 0.0, 0.0, 0.60>]  //  Dark
                }
    scale <1.0, 100.0, 1.0>
	   }
	 }

#local RefStuccoTexture =

texture {

	finish { reflection 0.15 }  //  3 times slower but nice

  pigment {
    wrinkles
    color_map {
      [0.00 color rgb <0.95, 0.70, 0.30>]  //  Washed out
      [0.30 color rgb <1.00, 0.70, 0.30>]
	  [0.45 color rgb <1.00, 0.70, 0.25>] 
      [0.55 color rgb <1.00, 0.65, 0.30>] 

      [0.86    color rgb <1.00, 0.75, 0.30>]
      [0.86001 color rgb <0.20, 0.15, 0.10>]
      [1.00    color rgb <0.25, 0.15, 0.17>]
                }
    scale <1.0, 1.0, 1.0>
           }

//	Base texture normals

	normal {
		average
		normal_map {
			[ 1.0  wrinkles 0.40  scale 3 ]  //  this "dirty's" it up
			[ 0.7  granite  0.25 ]
				    }
			}	

         }

//	Vertical color transition

texture {
  pigment {
    gradient y

    turbulence 0.10
      octaves 8        //  6   fuzzy   8 sharper
      lambda 2.8       //  2.0 fuzzy 2.8 more swirly
      omega 0.6        //  0.5 fuzzy 0.6 crinkly

    color_map {
      [0.00 color rgbt <0.35, 0.25, 0.17, 0.75>]  //  Dark splotches
      [0.34 color rgbt <0.35, 0.25, 0.17, 0.75>]  //  Dark splotches
      [0.36 color rgbt <0.50, 0.45, 0.34, 0.75>]  //  Medium splotches
      [0.49 color rgbt <0.50, 0.45, 0.36, 0.75>]  //  Medium splotches
      [0.51 color rgbt <0.50, 0.48, 0.47, 0.75>]  //  Light Stains
      [1.00 color rgbt <0.50, 0.48, 0.45, 0.75>]  //  Light Stains
                }
    scale <23.0, 23.0, 1.0>
	   }
	 }

//	A wash

texture {
	pigment {
		wrinkles  
      		color_map {  //			Decrease transparency for brighter floor
				[ 0.00 color rgbt <1.0, 0.55, 0.40, 0.7> ]  //  Orange
				[ 0.35 color rgbt <1.0, 0.80, 0.60, 0.6> ]  //  Peach
        		[ 0.85 color rgbt <0.9, 0.90, 1.00, 0.7> ]  //  Light gray
        		[ 1.00 color rgbt <0.9, 0.90, 1.00, 0.8> ]  //  White
                	   }
		warp { turbulence 0.3 }
		scale <4,2,4>
		translate <30, -9.0, 0>
             } 
		normal { granite 0.3  scale 0.4 }
	   }

//	Finally, the overshaded darkness (in feet)

texture {
  pigment {
    gradient y
    color_map {
      [0.000 color rgbt <0.2, 0.0, 0.0, 0.60>]  //  Dark
      [0.010 color rgbt <0.0, 0.0, 0.0, 1.00>]  //  Clear

      [0.0750 color rgbt <0.0, 0.0, 0.0, 1.00>]  //  Clear
      [0.0755 color rgbt <0.5, 0.1, 0.0, 0.87>]  //  The red horizontal band
      [0.0850 color rgbt <0.7, 0.2, 0.0, 0.97>]  //  
      [0.0855 color rgbt <0.0, 0.0, 0.0, 1.00>]  //  Clear

      [0.215 color rgbt <0.0, 0.0, 0.0, 1.00>]  //  Clear
      [0.230 color rgbt <0.0, 0.0, 0.0, 0.60>]  //  Dark
      [1.000 color rgbt <0.0, 0.0, 0.0, 0.60>]  //  Dark
                }
    scale <1.0, 100.0, 1.0>
	   }
	 }

//	White marble

#local WhiteMarbleTexture =

	texture{
     	pigment {     
			bozo
    			warp { turbulence 0.60  omega 0.80  lambda 3.00 }
    			color_map {
//	Stone colors
//    [0.00 rgbt <1.00, 0.95, 0.90>]
//    [0.40 rgbt <0.90, 0.80, 0.75>]
//    [1.00 rgbt <0.35, 0.35, 0.25>]

      				[0.00 color rgb <0.75, 0.70, 0.60>]
      				[0.20 color rgb <0.90, 0.80, 0.75>]
      				[1.00 color rgb <1.00, 0.95, 0.90>]
    					   }
 				  }

     	finish {
			brilliance 0.8  //  1.2 
			specular 0.4  //  0.5
			roughness 0.01
				}

	     normal{
			bozo 1
      		warp{ turbulence 0.6  omega 0.8  lambda 3.0 }
     			}
   			}
  texture {
	pigment {
      bozo
    color_map {
      [0.00 color rgbt <0.31, 0.20, 0.00, 0.9>]  
      [0.10 color rgbt <0.30, 0.17, 0.10, 0.4>] 
      [0.25 color rgbt <0.39, 0.20, 0.15, 0.9>]
      [0.37 color rgbt <0.46, 0.30, 0.19, 0.9>]  
      [0.55 color rgbt <0.65, 0.39, 0.17, 0.9>]  
      [0.73 color rgbt <0.65, 0.39, 0.17, 1.0>]  
      [0.75 color rgbt <0.31, 0.25, 0.10, 0.3>]  
      [0.77 color rgbt <0.20, 0.15, 0.10, 1.0>] 
      [1.00 color rgbt <0.20, 0.15, 0.10, 1.0>]
               }
      scale <1.0, 2.0, 1.0>

       turbulence 1.00  
       lambda 2.8
       omega 0.6
       octaves 8
           }  }

//	White marble

#local RefWhiteMarbleTexture =

	texture{

     	finish {
			brilliance 0.8  //  1.2 
			specular 0.4  roughness 0.01
			reflection 0.1  //  this slows it down considerably
				}

     	pigment {     
			bozo
    			warp { turbulence 0.60  omega 0.80  lambda 3.00 }
    			color_map {
//	Stone colors
//    [0.00 rgbt <1.00, 0.95, 0.90>]
//    [0.40 rgbt <0.90, 0.80, 0.75>]
//    [1.00 rgbt <0.35, 0.35, 0.25>]

      				[0.00 color rgb <0.75, 0.70, 0.60>]
      				[0.20 color rgb <0.90, 0.80, 0.75>]
      				[1.00 color rgb <1.00, 0.95, 0.90>]
    					   }
 				  }

	     normal {
			bozo 1
      		warp{ turbulence 0.6  omega 0.8  lambda 3.0 }
     			 }
   			}
  texture {
	pigment {
      bozo
    color_map {
      [0.00 color rgbt <0.31, 0.20, 0.00, 0.9>]  
      [0.10 color rgbt <0.30, 0.17, 0.10, 0.4>] 
      [0.25 color rgbt <0.39, 0.20, 0.15, 0.9>]
      [0.37 color rgbt <0.46, 0.30, 0.19, 0.9>]  
      [0.55 color rgbt <0.65, 0.39, 0.17, 0.9>]  
      [0.73 color rgbt <0.65, 0.39, 0.17, 1.0>]  
      [0.75 color rgbt <0.31, 0.25, 0.10, 0.3>]  
      [0.77 color rgbt <0.20, 0.15, 0.10, 1.0>] 
      [1.00 color rgbt <0.20, 0.15, 0.10, 1.0>]
               }
      scale <1.0, 2.0, 1.0>

       turbulence 1.00  
       lambda 2.8
       omega 0.6
       octaves 8
           }  }

#local AntiqueBrassTexture =
texture {

		finish { specular 0.3  roughness 0.001  metallic
				 ambient 0  diffuse 0.2  reflection 0.9 }

     	pigment {     
			bozo
    			warp { turbulence 0.60  omega 0.80  lambda 3.00 }
    			color_map {
      				[0.00 color rgb <0.65, 0.60, 0.20>]
      				[0.20 color rgb <0.80, 0.70, 0.35>]
      				[1.00 color rgb <0.90, 0.85, 0.40>]
    					   }
				scale <0.5, 0.2, 0.5> 
				  }
		normal { wrinkles 0.3  scale 2 }
		 }

texture {
	pigment {
      bozo
    color_map {
      [0.00 color rgbt <0.20, 0.15, 0.00, 0.8>]  
      [0.10 color rgbt <0.20, 0.15, 0.00, 0.3>] 
      [0.25 color rgbt <0.25, 0.15, 0.00, 0.9>]
      [0.37 color rgbt <0.25, 0.15, 0.00, 0.4>]  
      [0.63 color rgbt <0.20, 0.25, 0.00, 0.7>]  
      [0.75 color rgbt <0.20, 0.25, 0.00, 0.2>]  
      [0.90 color rgbt <0.20, 0.15, 0.10, 0.8>] 
      [1.00 color rgbt <0.20, 0.15, 0.10, 0.3>]
               }
      scale <1, 0.3, 1>

       turbulence 1.00  
       lambda 2.8
       omega 0.6
       octaves 8
           } 
		}

texture {
	pigment {
		wrinkles  
      		color_map { 
				[ 0.0 color rgbt <0.0, 0.0, 0.0, 0.85> ]  
				[ 0.5 color rgbt <0.4, 0.3, 0.0, 0.35> ]  
        		[ 1.0 color rgbt <0.2, 0.0, 0.0, 0.85> ]  
                	   }
		warp { turbulence 0.3 }
		scale <0.5, 0.1, 0.5>
		translate <30, -9.0, 0>
             } 
	   }

//	A stained wood texture

#local Pel0 = 0.7500;
#local Pel1 = 0.7501;

#local PeelPigment = 
pigment {
	wrinkles
	color_map {[0 rgb 0][1 rgb 1]}
	scale 5
		 }

#local PeelNormal = normal {
	wrinkles
	slope_map {
		[.4900 <.5, 0>]
		[.5000 <.5, .5>]
		[ Pel0 <1, .5>]  //  .6
		[ Pel0 <1, -3>]
		[ Pel1 <0, -3>]
		[ Pel1 <0, 0>]  //  .6001
		[.9999 <0, 0>]
				}
	scale 5
							}

//	Pigments for peeling wood

#local WoodPigment =  //  Dark wood
    pigment {
        wood
        turbulence 0.15
        color_map {

            [0.00 0.34  color rgb <0.24, 0.15, 0.06>*0.9
                        color rgb <0.27, 0.16, 0.06>*0.9]
            [0.34 0.40  color rgb <0.27, 0.16, 0.06>*0.9
                        color rgb <0.20, 0.13, 0.05>*0.9]
            [0.40 0.47  color rgb <0.20, 0.13, 0.05>*0.9
                        color rgb <0.25, 0.15, 0.06>*0.9]
            [0.47 1.00  color rgb <0.25, 0.15, 0.06>*0.9
                        color rgb <0.19, 0.11, 0.04>*0.9]
                     }

	scale <0.7, 0.1, 1>
	rotate 90*y  //  go from z to x axis
              }

#local PaintPigment =  //  Cherry wood
    pigment {
        wood
        turbulence 0.15
        color_map {

//							      +0.1  -0.04        1.0
            [0.00 0.34  color rgb <0.34, 0.11, 0.06>*1.0
                        color rgb <0.37, 0.12, 0.06>*1.0]
            [0.34 0.40  color rgb <0.37, 0.12, 0.06>*1.0
                        color rgb <0.30, 0.09, 0.05>*1.0]
            [0.40 0.47  color rgb <0.30, 0.09, 0.05>*1.0
                        color rgb <0.35, 0.11, 0.06>*1.0]
            [0.47 1.00  color rgb <0.35, 0.11, 0.06>*1.0
                        color rgb <0.29, 0.07, 0.04>*1.0]
                     }

	scale <0.7, 0.1, 1>
	rotate 90*y  //  go from z to x axis
              }

// cherry:    [0.00  color rgb <0.8, 0.5, 0.2>]
//            [0.50  color rgb <0.2, 0.1, 0.1>]
//            [1.00  color rgb <0.7, 0.3, 0.1>]

//	All together
	
#local PeelingPaint = 
texture {

  	finish { 
		specular 0.8 roughness 0.0001   //  Shiny 
		reflection 0.2
			}

	pigment { 
		pigment_pattern { PeelPigment } 
			pigment_map {
				[ Pel1  PaintPigment ]  //  Main paint
				[ Pel1  WoodPigment  ]  //  Some wood showing through
				   } 
			 }

	normal { PeelNormal  0.1 }
		}

//**************************************************************

#declare Heart1 =
difference {

prism {                                
  linear_sweep  
  cubic_spline // linear_spline | quadratic_spline | cubic_spline | bezier_spline 
    2.0,         // height 1
   -2.0,         // height 2
  10,           // number of points

	<3.0, 1.0>,  //  control point
	<3.0, 2.0>,  //  start point
	<1.5, 2.0>,  //  TEMP
	<1.0, 2.5>, 
    <0.5, 2.5>,  //  Real start control point

	<0.05, 0.875>,  //  Visible start
	<0.55, 0.300>,  //  Visible end

	<1.6, -1.0>,  //  Real end control point  was 1.8, -1.5

	<3.0, 2.0>,  //  end point (must match start point)
	<2.0, 3.0>  //  control point

  sturm
  rotate -90*x
	    }

//	Take out the top and the right parts

	box { <-10.0, 0.875, -5.0>, <20.0, 10.0, 5.0> }  //  top
	box { < 0.55, -10.0, -5.0>, <10.0, 20.0, 5.0> }  //  right
			}

//	A diamond

#declare HeartDiamond =

difference {

	box { <-.2, -0.2, -2.0>, <0.2, 0.2, 2.0> }
	cylinder { <0.2, 0.2, -3.0>, <0.2, 0.2, 3.0>, 0.2 }
	cylinder { <0.2,-0.2, -3.0>, <0.2,-0.2, 3.0>, 0.2 }
	rotate 10*z
			}

//	A circle

#macro HeartCircle(Xloc, Yloc)

	object { 
	cylinder { <0.0, 0.0, -2>, <0.0, 0.0, 2>, 0.1 }
		translate <Xloc, Yloc, 0.0>
			}
#end

//	A left heart

#declare HeartSection =
	union {

//	The heart curve

	object { Heart1 }

//	Diamonds

	object { HeartDiamond  translate <0.0, 0.4, 0.0> }
	object { HeartDiamond  translate <0.0, 1.2, 0.0> }
	object { HeartDiamond  scale <-1, 1, 1>  translate <0.6, 1.2, 0.0> }

//	Upper circles

	object { HeartCircle(0.30, 1.0) }
	object { HeartCircle(0.15, 0.875) }
	object { HeartCircle(0.45, 0.875) }
	cylinder { <0.3, 0.85, -2>, <0.3, 0.85, 2>, 0.10 }

//	Lower circles

	object { HeartCircle(0.30, 0.125) }
	object { HeartCircle(0.15, 0.000) }
	object { HeartCircle(0.45, 0.000) }
	cylinder { <0.3, 0.1, -2>, <0.3, 0.1, 2>, 0.10 }

		   }

//	SunRay Isos

#local FCONE = function { sqrt(pow(x,2) + pow(z*5,2) ) - 0.01 - 0.1*y }

#local FSPHERE =  function { sqrt(pow(x,2) + pow(y,2) + pow(z*5,2) ) - 0.60 }

#local FCYL =  function { sqrt(pow(x,2) + pow(y,2) ) - 1.78 }
#local FFAR = function { z }
#local FNEAR = function { -z }
#local FCYL2 = function { max( FCYL(x,y,z), -FFAR(x,y,z+0.02) ) }
#local FSUN5 = function { max( FCYL2(x,y,z), -FNEAR(x,y,z-0.02) ) }

#local FDENTS = function { pigment { dents  scale 1.0 } }

/*
//	Non-iso Circle top rays
#local Ray =
difference {
	cylinder { <0, 0, -0.1>, <0, 0, 0>, 2 }
	plane { <0,  1, 0>, 0 }
	plane { <0, -1, 0>, 0  rotate -11.25*z }
			}

#local RayCount = -2.8125;
#while ( RayCount < 179 )
	difference {
		object { Ray  rotate -RayCount*z }
		plane { <0,  1, 0>, 0 }
				}
#local RayCount = RayCount + 22.5;
#end
*/


#declare CopperSun =
union {

//  Sun and rays isosurface

difference {

union {

isosurface {
	function { FSPHERE(x,y,z) + FDENTS(x,y,z).gray*0.02 }
	max_gradient 6.0
	contained_by{ sphere { <0,0,0>, 0.7 } }
	scale <1, 1, 0.5>
	translate <0, 0, 0.025>
 			}

#local RayCount = 0;
#while ( RayCount < 100 )
	isosurface {
		function { FCONE(x,y,z) + FDENTS(x,y,z).gray*0.02 }
		max_gradient 6.0
		contained_by{ sphere { <0,0,0>, 1.885 } }  //  1.885 puts it inside iron
		scale <1, 1, 0.5>
		rotate RayCount*z
 			}

#local RayCount = RayCount + 22.5;
#end

	   }

	plane { <0, 1, 0>, 0 }
	translate <0, 0.0, -0.08>  //  -0.08 places it in the slot

	texture { CopperVerdTexture }
			}  //  end of difference


//	The glass behind

object {
	box { <-2.80, 0, 0.3>, <2.8, 2.5, 0.4> }
	texture { GlassTexture }  //  slowwwww...reflection
		}

//		Draw a spiral iron 

#local Spiral = function { f_spiral(x,y,z, 0.35, 0.035, 0.45, 0, 0, 1) }

union {

//	Spirals

object {
isosurface {
	function { Spiral(x,y,z) }
	max_gradient 2.0
	contained_by { sphere { <0,0,0>, 0.6 } }
		    }
	rotate -90*x
	rotate -40*z
	translate <0.40, 0.275, 0>
		}

object {
isosurface {
	function { Spiral(x,y,z) }
	max_gradient 2.0
	contained_by { sphere { <0,0,0>, 0.6 } }
		    }
	rotate -90*x
	rotate -40*z
	rotate 180*y
	translate <-0.30, 0.275, 0>
		}

//	Sunburst

	cylinder { <-2.60, 0.0, 0.0>, <2.60, 0.0, 0.0>, 0.035 }

	difference {
		union {
			torus { 2.58, 0.040  rotate -90*x }
			torus { 0.84, 0.035  rotate -90*x }
			   }
		plane { <0,1,0>, 0 }
				}

cylinder { <0.84, 0.0, 0.0>, <2.60, 0.0, 0.0>, 0.035  rotate 97.625*z }
cylinder { <0.84, 0.0, 0.0>, <2.60, 0.0, 0.0>, 0.035  rotate 106.875*z }
cylinder { <0.84, 0.0, 0.0>, <2.60, 0.0, 0.0>, 0.035  rotate 118.125*z }
cylinder { <0.84, 0.0, 0.0>, <2.60, 0.0, 0.0>, 0.035  rotate 129.375*z }
cylinder { <0.84, 0.0, 0.0>, <2.60, 0.0, 0.0>, 0.035  rotate 140.625*z }
cylinder { <0.84, 0.0, 0.0>, <2.60, 0.0, 0.0>, 0.035  rotate 151.350*z }  //  closer
cylinder { <0.84, 0.0, 0.0>, <2.60, 0.0, 0.0>, 0.035  rotate 162.600*z }
cylinder { <0.84, 0.0, 0.0>, <2.60, 0.0, 0.0>, 0.035  rotate 173.300*z }

/*
#local SunCount = 5.625;
#while ( SunCount < 175 )
	cylinder { <0.84, 0.0, 0.0>, <2.60, 0.0, 0.0>, 0.035  rotate SunCount*z }
#local SunCount = SunCount + 11.25;
#end
*/
//	Scale and position inside arch slot

	scale 0.737
	translate <0, 0.0, -0.1>
	texture { RustyIronTexture  translate <0.3, -0.3, 0>  }  //  0.5 was 1.0
		}  //  end of spiral iron union

//	Place it all above the door

	translate <11, 5.5, -0.08>

	}  //  end of Copper Sun union

#local MarbleWindow =

union {
	
difference {
	box {<-1.0, 4,   0.4>, <2.0, 8,   0.8> }
	box {<-0.5, 4.3,-0.1>, <1.4, 7., 0.9> }
	texture { RustyMarbleTexture }
			}
object {
	box {<-0.5, 4.5, 0.45>, <1.4, 7.5, 0.6> }
	texture { DarkGlassTexture }
		}
object {
	box {<-1.0, 3.9, 0.35>, <2, 4.04, 0.4> }
	texture { DarkStoneTexture  scale 0.3 }
			}

//	The bars

#local Helix = function { f_helix2(x,y,z, 0, 6, 0.030, 0.0, 0, 0, 45) }

/*
    * P0 : Not used
    * P1 : Period - is related to the number of turns per unit length
    * P2 : Minor radius (minor radius > major radius)
    * P3 : Major radius
    * P4 : Not used
    * P5 : Cross section type
	* P6 : Cross section rotation angle (degrees) 
*/

#local HelixBar =
isosurface {
	function { Helix(x,y,z) }
	max_gradient 2.0
	contained_by { box {<-0.5, -1.3, -0.5>, <0.5, 1.3, 0.5>} }
	scale <0.8, 1, 0.8>
 			}

union {

//	The bar ends

//	cylinder { <0, 3.9, 0>, <0, 4.030, 0>, 0.062  translate <-1.25, 0, -0.1> }
//	cylinder { <0, 3.9, 0>, <0, 4.035, 0>, 0.062  translate <-0.75, 0, -0.1> }

	cylinder { <-1, 4.5, 0>, <-0.75, 4.5, 0>, 0.062  translate <0, 0, -0.1> }

	cylinder { <0, 3.9, 0>, <0, 4.035, 0>, 0.062  translate <-0.25, 0, -0.1> }
	cylinder { <0, 3.9, 0>, <0, 4.030, 0>, 0.062  translate < 0.25, 0, -0.1> }
	cylinder { <0, 3.9, 0>, <0, 4.035, 0>, 0.062  translate < 0.75, 0, -0.1> }
	cylinder { <0, 3.9, 0>, <0, 4.030, 0>, 0.062  translate < 1.25, 0, -0.1> }

//		The Helix bars

	object { HelixBar  scale <1, 1.0, 1>  rotate 90*z  translate <0.5, 4.5, -0.1> }
	object { HelixBar  scale <1, 1.0, 1>  rotate 90*z  translate <0.5, 5.0, -0.1> }

//	object { HelixBar  rotate 10*y  translate <-1.25, 4.9, -0.1> }
//	object { HelixBar  rotate 90*y  translate <-0.75, 4.9, -0.1> }
	object { HelixBar  rotate 30*y  translate <-0.25, 5.2, -0.1> }
	object { HelixBar  rotate 70*y  translate < 0.25, 5.2, -0.1> }
	object { HelixBar  rotate 20*y  translate < 0.75, 5.2, -0.1> }
	object { HelixBar  rotate 10*y  translate < 1.25, 5.2, -0.1> }

	texture { RustyIronTexture  translate <0.5, 5, 0> }  //  center rust
		}

		}

#local StuccoFunction =  function { pigment { 
										wrinkles  	
										warp { turbulence 0.3 }
										scale <4,2,4>
								   }         }

#local FrameFunction = function { pigment { granite  scale 1.5 } }

//	Used by all

#local FACEUP = function { y }
#local FACEDOWN = function { -y }
#local FACEBACK = function { z }
#local FACEFORWARD = function { -z }

#local FACELEFT = function { -x }
#local FACELEFTUP = function { max( FACELEFT(x,y,z), FACEUP(x,y,z) ) }

//		Window Sides and Base

#declare Window =

union {

object { MarbleWindow }

//	Window Sides

#local C1 = function { f_rounded_box(x,y,z, 0.02, 0.20, 2, 0.3) }
#local CS = function { f_rounded_box(x,y,z, 0.02, 0.23, 0.045, 0.33) }

#local WCYL1 = function { sqrt(pow(x,2) + pow(z,2)) - 0.08 }
#local WCYL2 = function { max( WCYL1(x,y,z+0.375), -FACEUP(x,y+1.6,z) ) }  
#local C1A = function { max(  C1(x,y,z), -WCYL2(x + 0.10,y,z) ) }  
#local C1B = function { max( C1A(x,y,z), -WCYL2(x       ,y,z) ) }  
#local C1C = function { max( C1B(x,y,z), -WCYL2(x - 0.10,y,z) ) }  

union {

//	Right

object {
isosurface {
	function { C1C(x,y,z) + FrameFunction(x+2,y,z).gray*0.01 }
	max_gradient 2.0
	contained_by { box { <-0.2, -2, -0.3>, <0.2, 2, 0.3>} }
		    }
	translate <1.95, 6, 0>
		}

object {
isosurface {
	function { CS(x,y,z) + FrameFunction(x+2,y,z).gray*0.02 }
	max_gradient 2.0
	contained_by { box { <-0.23, -0.06, -0.33>, <0.23, 0.06, 0.33>} }
		    }
	translate <1.95, 4.40, 0>
		}

//	Left

object {
isosurface {
	function { C1C(x,y,z) + FrameFunction(x,y,z).gray*0.02 }
	max_gradient 2.0
	contained_by { box { <-0.2, -2, -0.3>, <0.2, 2, 0.3>} }
		    }
	translate <-0.95, 6, 0>
		}

object {
isosurface {
	function { CS(x,y,z) + FrameFunction(x,y,z).gray*0.02 }
	max_gradient 2.0
	contained_by { box { <-0.23, -0.06, -0.33>, <0.23, 0.06, 0.33>} }
		    }
	translate <-0.95, 4.40, 0>
		}

//	Base

#local C2 = function { f_rounded_box(x,y,z, 0.04, 1.9, 0.18, 0.3) }

#local BCYL1 = function { sqrt(pow(x,2) + pow(y,2)) - 0.27 }
#local BCYL2 = function { sqrt(pow(y,2) + pow(z,2)) - 0.27 }

#local C2A = function { max(   C2(x,y,z), -BCYL1(x - 1.9,y + 0.18,z) ) }  
#local C2B = function { max(  C2A(x,y,z), -BCYL1(x + 1.9,y + 0.18,z) ) }  
#local C2C = function { max(  C2B(x,y,z), -BCYL2(x,y + 0.18,z + 0.3) ) }  

object {
isosurface {
	function { C2C(x,y,z) + FrameFunction(x,y,z).gray*0.025 }
	max_gradient 2.0
	contained_by { box { <-1.9, -0.18, -0.3>, <1.9, 0.18, 0.3>} }
		    }
	translate <0.5, 3.84, -0.2> 
		}

//	Lid (sun block, offscreen)

object {
isosurface {
	function { C2(x,y,z) + FrameFunction(x,y,z).gray*0.025 }
	max_gradient 2.0
	contained_by { box { <-1.5, -0.15, -0.3>, <1.5, 0.15, 0.3>} }
		    }
	translate <0.5, 7.87, 0> 
		}

//	Texture them as one

	texture { WhiteMarbleTexture }
	texture { BaseWaterStains  translate <0, 3.4, 0> }  //  ADDED TO WINDOW

	}  //  end of sides and base

 translate <2, 0.3, 0>
	   }  //  end of union

//		Baseboard is 0.3 out from stucco wall

#local DiagSize = 8.5*0.5*1.4142;
#local Square = function { abs(x) + abs(z) - DiagSize }  
#local BoardFunction = function { max( Square(x,y,z), -FACEDOWN(x,y-0.4,z) ) }  //  top

#local DBCYL =  function { sqrt(pow(y,2) + pow(z,2) ) - 0.25 }
#local DBBOX =  function { f_rounded_box(x,y,z, 0.01, 2.80, 0.20, 0.4) }

#local THRESH = function { f_rounded_box(x,y,z, 0.03, 2.80, 0.15, 0.30) }

#local PB = function { f_rounded_box(x,y,z, 0.01, 0.35, 0.40, 0.38) }
#local DB = function { max( DBBOX(x,y,z), -DBCYL(x,y + 0.175,z + 0.4) ) }

#local DS = function { f_rounded_box(x,y,z, 0.01, 0.10, 2.80, 0.25) }

//	Pergola type top board

#local ABBOX1  = function { f_rounded_box(x,y,z, 0.0, 3.00, 0.30, 0.7) }

#local ABCYL1 = function { sqrt(pow(x,2) + pow(y,2) ) - 0.50 }
#local ABCYL2 = function { sqrt(pow(x,2) + pow(y,2) ) - 0.225 }
#local ABCYL3 = function { sqrt(pow(x,2) + pow(y,2) ) - 0.15 }

#local AB1 = function { min( ABBOX1(x,y,z), ABCYL1(x+3.05,y-0.55,z) ) }
#local AB2 = function { min( AB1(x,y,z),   ABCYL3(x+3.0,y-0.08,z) ) }
#local AB3 = function { max( AB2(x,y,z), -FACEBACK(x,y,z+0.7) ) }
#local AB4 = function { max( AB3(x,y,z),  -ABCYL2(x+3.0,y+0.30,z) ) }

/*	
#local AB5 = function { max( AB4(x,y,z),  -ABCYL2(x+1.7,y+0.30,z) ) }
#local AB6 = function { max( AB5(x,y,z),  -FACELEFTUP(x+1.7,y+0.075,z) ) }
*/

#local MARBOX  = function { f_rounded_box(x,y,z, 0.0, 3.41, 0.03, 0.70) }

//	Load the buildings image

#declare BuildingsPigment =
  pigment {
    image_map {
        gif "Buildings4.gif" 
        map_type 0
        interpolate 2
               }
    scale < 9.5, 0.7, 1.0 >  //  image is 1900x200 pixels
	translate <-1.1, 0.0, 0>  //  Center image under blast

	translate <-8.5*0.5, -0.05, -8.5*0.5>  //  Baseboard is 8.5' wide
	rotate -45*y  //  rotate to fit baseboard
           }

#local BuildingsF = function { pigment { BuildingsPigment } }

#declare BaseBoard =
union {

//	Pergola board marble top

isosurface {
	function { MARBOX(x,y,z) }
	max_gradient 3.0
	contained_by { box { <-3.5, -0.1, -1.0>, <3, 0.1, 0.8>} }
	translate <11.15, 5.445, 0.25>

//	texture { WhiteMarbleTexture }  //  Too dark
	texture { StoneTexture }
	 }

//	Top wood pergola board

isosurface {
	function { AB4(x,y,z) - FrameFunction(x*0.8,y*2,z).gray*0.04 }
	max_gradient 3.0
	contained_by { box { <-3.5, -0.22, -1.0>, <2.8, 0.22, 0.8>} }
	translate <11.0, 5.225, 0.25>

	texture { WoodTexture  scale <1.5, 1, 1>  translate <0, 0.2, 0> }
		}

union {

isosurface {
	function { BoardFunction(x,y,z) - FrameFunction(x,y,z).gray*0.04 
									- BuildingsF(x,y,z).gray*0.015 } 
	max_gradient 3
	accuracy 0.0001  //  sharper image?
	contained_by { box { <-DiagSize-0.45,-0.1, -DiagSize-0.45>, 
					     < DiagSize+0.45, 0.5,  DiagSize+0.45>} }

//	Rotate to wall

	rotate 45*y
	translate <8.5*0.5, 0.0, 8.2*0.5>
//	pigment { color rgb <1,0,0> }
		    }  //  end of isosurface

//	Dark Pillar bases (part of baseboard)

isosurface {
	function { PB(x,y,z) - FrameFunction(x,y,z).gray*0.03 }
	max_gradient 3.0
	contained_by { box { <-0.45, 0.0, -0.45>, <0.45, 0.5, 0.45>} }

 	translate <8.65, 0, 0.05>
			}

/*  Shadows the sidewalk on right side 
isosurface {
	function { PB(x,y,z) - FrameFunction(x,y,z).gray*0.03 }
	max_gradient 3.0
	contained_by { box { <-0.45, 0.0, -0.45>, <0.45, 0.5, 0.45>} }

 	translate <14.35, 0, 0>  //  was 13.35
			}
*/
	texture { DarkStoneTexture  scale <0.6, 1.0, 0.6> }
	texture { BaseWaterStains  translate <0, -.15, 0> }

	   }  //  end of darkstone union

//	Door base (threshold)

union {

isosurface {
	function { THRESH(x,y,z) - FrameFunction(x,y,z).gray*0.01 }
	max_gradient 2.0
	contained_by { box { <-2.8, -0.20, -0.4>, <2.8, 0.20, 0.4>} }
			}

	cylinder { <-2.8, 0.0, -0.05>, <2.8, 0.0, -0.05>, 0.05  
			scale <1, 0.4, 1> 
			translate <0, 0.158, 0> }

	texture { RefWhiteMarbleTexture  scale 0.02 }  //  Reflection SLOW
	texture { BaseWaterStains  translate <0, -0.1, 5> }  //  Darken to marble

 	translate <11.5, -0.05, 0.5>  //  was 11
			}

//	The metal roller door tracks

union {
	box { <0.22, 0.05,  0.00>, <0.3, 0.225,  0.03> }  //  middle
	box { <0.22, 0.05, -0.13>, <0.3, 0.225, -0.10> }


	box { <2.15, 0.05,  0.00>, <3, 0.225,  0.03> }  //  right
	box { <2.15, 0.05, -0.13>, <3, 0.225, -0.10> }

	box { <-1.7, 0.05,  0.00>, <-2, 0.225,  0.03> }  //  left
	box { <-1.7, 0.05, -0.13>, <-2, 0.225, -0.10> }

/*
//	Up the right door jamb (no longer visible)
	box { < 2.23, 0.2,  0.0>, <2.5, 2.5,  0.03> }
	box { < 2.23, 0.2, -0.1>, <2.5, 2.5,  -0.07> }
*/

	texture { AntiqueBrassTexture  scale 0.5 }  //  was copper
 	translate <11, -0.10, 0.5>
		}

//	Top of door ("wood") (Chopped by container top and bottom)

/*  Pergola above
isosurface {
	function { DB(x,y,z) - FrameFunction(x,y*3,z).gray*0.03 }
	max_gradient 3.0
	contained_by { box { <-2.8, -0.175, -0.7>, <2.8, 0.175, 0.7>} }
	translate <11.0, 5.33, 0.3>

	texture { WoodTexture  scale <1.5, 1, 1> }
		}
*/

//	Sides of door
//#local DS = function { f_rounded_box(x,y,z, 0.01, 0.10, 2.80, 0.25) }

isosurface {
	function { DS(x,y,z) - FrameFunction(x*3,y,z).gray*0.02 }
	max_gradient 3.0
	contained_by { box { <-0.1, -2.8, -0.5>, <0.175, 2.8, 0.5>} }
	translate <9.10, 2.35, 0.5>

	texture { WoodTexture  scale <1.5, 1, 1>  rotate 90*z }
		}

isosurface {
	function { DS(x,y,z) - FrameFunction(x*3,y,z).gray*0.02 }
	max_gradient 3.0
	contained_by { box { <-0.175, -2.8, -0.5>, <0.1, 2.8, 0.5>} }
	translate <13.35, 2.35, 0.5>  //  was 12.85

	texture { WoodTexture  scale <1.5, 1, 1>  rotate 90*z}
		}


		}  //  end of Baseboard union

//	Arched door

//		Draw the doorway pillar

#local D0 = function { f_rounded_box(x,y,z, 0.02, 0.40, 0.12, 0.44) }
#local D1 = function { f_rounded_box(x,y,z, 0.01, 0.30, 2.75, 0.30) }

#local D2 = function { f_rounded_box(x,y,z, 0.03, 0.38, 0.10, 0.38) }
#local D3 = function { f_rounded_box(x,y,z, 0.03, 0.33, 0.06, 0.33) }
#local D4 = function { f_rounded_box(x,y,z, 0.03, 0.35, 0.06, 0.35) }

#local CYL1 = function { sqrt(pow(x,2) + pow(z,2)) - 0.09 }
#local CYL2 = function { max( CYL1(x,y,z+0.38), -FACEUP(x,y+1.8,z) ) }  
#local CYL3 = function { max( CYL2(x,y,z), -FACEDOWN(x,y-1.8,z) ) }  
#local D1A = function { max(  D1(x,y,z), -CYL3(x + 0.15,y,z) ) }  
#local D1B = function { max( D1A(x,y,z), -CYL3(x       ,y,z) ) }  
#local D1C = function { max( D1B(x,y,z), -CYL3(x - 0.15,y,z) ) }  


#declare DoorPillar =

union {

object {		//  Main pillar
isosurface {
	function { D1C(x,y,z) + FrameFunction(x,y,z).gray*0.010 }
	max_gradient 2.0
	contained_by { box { <-0.3, -2.75, -0.3>, <0.3, 2.55, 0.3>} }
		    }
	translate <0, -0.5, 0>
		}

object {		//	Top square
isosurface {
	function { D2(x,y,z) + FrameFunction(x,y,z).gray*0.020 }
	max_gradient 2.0
	contained_by { box { <-0.38, -0.10, -0.38>, <0.38, 0.10, 0.38>} }
		    }
	translate <0, 2.065, 0>
		}

object {		//	2nd square
isosurface {
	function { D4(x,y,z) + FrameFunction(x,y,z).gray*0.020 }
	max_gradient 2.0
	contained_by { box { <-0.35, -0.06, -0.35>, <0.35, 0.06, 0.35>} }
		    }
	translate <0, 1.93, 0>
		}

//	Lower two bands

object {
isosurface {
	function { D3(x,y,z) + FrameFunction(x+2,y,z).gray*0.020 }
	max_gradient 2.0
	contained_by { box { <-0.35, -0.06, -0.35>, <0.35, 0.06, 0.35>} }
		    }
	translate <0,1.3,0>
		}

object {
isosurface {
	function { D3(x,y,z) + FrameFunction(x+4,y,z).gray*0.020 }
	max_gradient 2.0
	contained_by { box { <-0.35, -0.06, -0.35>, <0.35, 0.06, 0.35>} }
		    }
	translate <0,-2.3,0>
		}

	scale <0.9, 1, 1>
	translate <8.7, 3.25, 0.0>  //  was 8.65

	texture { WhiteMarbleTexture }
	texture { BaseWaterStains  translate <0, 0.2, 0> }

	   }  //  end of DoorPillar union

//		Door Arch

#local CYLA1 = function { sqrt(pow(x,2) + pow(y,2)) - 2.70 }
#local CYLA2 = function { sqrt(pow(x,2) + pow(y,2)) - 1.78 }  // was 1.78
#local CYLA3 = function { sqrt(pow(x,2) + pow(y,2)) - 1.95 }

#local CYLA4 = function { max( CYLA3(x,y,z), -FACEFORWARD(x,y,z) ) }  // Grate slot

#local T1 = function { f_torus(x,y,z, 2.00, 0.50) }  //  Curve out
#local T2 = function { f_torus(x,y,z, 2.59, 0.10) }  //  Outside lip

#local A1A = function { max( CYLA1(x,y,z), -CYLA2(x,y,z) ) }
#local A1B = function { max( A1A(x,y,z), -FACEBACK(x,y,z + 0.4) ) }
#local A1C = function { max( A1B(x,y,z), -FACEFORWARD(x,y,z - 0.4) ) }
#local A1D = function { max( A1C(x,y,z), -T1(x,z*1.7 + 0.85,y) ) }

#local A1E = function { min( A1D(x,y,z), T2(x,z + 0.35,y) ) }
#local A1F = function { max( A1E(x,y,z), -FACEUP(x,y+0.1,z) ) }
#local A1  = function { max( A1F(x,y,z), -CYLA4(x,y,z+0.04) ) }

#declare DoorArch =

object {

isosurface {
	function { A1(x,y,z) + FrameFunction(x,y,z).gray*0.02 }
	max_gradient 2.0
	contained_by { sphere { <0,0,0>, 4.0} }
		    }
	translate <11, 5.5, 0.0>

//	texture { WhiteMarbleTexture }  //  Too shiny
	texture { DarkStoneTexture  scale <0.6, 1, 0.6> }
	texture { BaseWaterStains  translate <0, 0.5, 0> }

		}

//	The doorway tunnel (and above and below)

#declare DoorWay =

//	The tunnel  (NOTE: draw from the top of the door at 5.5')

light_group {


//  Isosurface floor (too smooth transition)
/*
#local TOUT = function { f_rounded_box(x,y,z, 0.05, 3.0, 5.50, 8) }
#local TIN  = function { f_rounded_box(x,y,z, 0.05, 2.5, 5.45, 7) }
#local THOLE = function { max( TOUT(x,y,z), -TIN(x,y,z+2) ) }									 

isosurface {
	function { THOLE(x,y,z) }
	max_gradient 3.0
	contained_by { box { <-3, -5.5, -8>,<3, 5.5, 8> } }
	translate <0, -0.05, 8.9>
	texture { StuccoTexture  scale 0.5    translate <0, -5.65, 0>  rotate -90*y }
	texture { BaseWaterStains  scale 1.5  translate <0, -5.60, 0> }
		    }
*/

//		Wall

difference {
	box { <-3, -5.5,  0.0>, <3, 5, 15.0> }
	box { <-2, -5.55, -1.0>, <2.5, 4, 14.0> }
	translate <0, -0.05, 0.9>

	texture { StuccoTexture  scale 0.5    translate <0, -5.65, 0>  rotate -90*y }
	texture { BaseWaterStains  scale 1.5  translate <0, -5.60, 0> }
		    }

//		Floor at -5.45'

object {
	box { <-2.2, -5.45, 0.0>, <2.7, -5.55, 14.0> }
	translate <0, -0.05, 0.9>

	texture { RefStuccoTexture  scale 0.5    translate <0, -5.65, 0>  rotate -90*y }
	texture { BaseWaterStains  scale 1.5  translate <0, -5.60, 0> }
		    }

//	The stairs

#local FSTEP1 = function { f_rounded_box(x,y,z, 0.02, 3, 0.05, 0.5) }
#local FSTEP2 = function { f_rounded_box(x,y,z, 0.04, 3, 3, 0.4) }
#local FSTEP = function { min( FSTEP1(x,y,z), FSTEP2(x,y+3,z-0.2) ) }

#local AStep =
	isosurface {
		function { FSTEP(x,y,z) + FrameFunction(x,y,z).gray*0.03 }
		max_gradient 3.0
		contained_by { box { <-3, -6, -0.5>,<3, 3.05, 0.5> } }
		    }

#local HandRail =
union {
	cylinder { <0, 0, 0>, <0, 0, 10>,       0.1  scale <0.9, 0.6, 1> }
	sphere {   <0, 0, 0>, 0.1   scale <0.9, 0.6, 1> }
	cylinder { <0, -0.25, 0>, <0, -.25, 10>, 0.1  scale <0.9, 0.3, 1> }
	sphere {   <0, -0.25, 0>, 0.1   scale <0.9, 0.3, 1> }
		}

//	Draw the stairs

union {
	object { AStep 	translate <2.5, -5.0,  9> }
	object { AStep 	translate <2.5, -4.5, 10> }
	object { AStep 	translate <2.5, -4.0, 11> }
	object { AStep 	translate <2.5, -3.5, 12> }
	object { AStep 	translate <2.5, -3.0, 13> }

	texture { StairsTexture  scale 0.7 }

	}  //  end of stairs union

object { 
	HandRail  
	texture { LightStairsTexture }
	rotate -26.5*x  
	translate <2.4, -3.0, 9> 
		}

//	An antique brass hinge plate

#local Hinge =

union {
	box { <0, 0, 0.02>, <0.02, 0.3, 0.08> }
	sphere { <0,0,0>, 0.02  scale <0.2, 1,1>  translate <0,0.1,0.05> }
	sphere { <0,0,0>, 0.02  scale <0.2, 1,1>  translate <0,0.2,0.05> }
	sphere { <0,0,0>, 0.02  scale <0.2, 1,1>  translate <0,0.3,0.05> }
		}

//	The door

#local DOORF  = function { f_rounded_box(x,y,z, 0.01, 1.1, 2.475, 0.05) }

#local DoorFunction = function { pigment {  //  Not used? 
	average
	pigment_map {
		[1.0  granite   scale 1.5]
		[1.0  wrinkles  scale <1, 0.3, 1>]
				 }
										  } }

#local IsoDoor =
union {

//		Left side

difference {
isosurface {
	function { DOORF(x,y,z) - FrameFunction(x,y*0.5,z).gray*0.02 }
	max_gradient 3.0
	contained_by { box { <-1.2, -2.6, -0.1>, <1.2, 2.6, 0.1>} }
	translate <-1.1, -2.875, 0.05>
			}
union {
	plane { <-1, 0, 0>,  1.7 }
	plane { < 0, 1, 0>, 0  rotate 45*z  translate <-2.2, -5.35, 0> }
	   }
	texture { PeelingPaint  scale 0.1  rotate 90*z  translate <2, 0, 0> }
			}  //  left side difference

//	Right side

difference {
isosurface {
	function { DOORF(x,y,z) - FrameFunction(x,y*0.5,z).gray*0.02 }
	max_gradient 3.0
	contained_by { box { <-1.2, -2.6, -0.1>, <1.2, 2.6, 0.1>} }
	translate <-1.1, -2.875, 0.05>
			}
union {
	plane { <1, 0, 0>,  -0.5 }
	plane { < 0, 1, 0>, 0  rotate -45*z  translate <0, -5.35, 0> }
	   }
	texture { PeelingPaint  scale 0.1  rotate 90*z  translate <5, 0, 0> }
			}  //  right side difference

//	Bottom

difference {
isosurface {
	function { DOORF(x,y,z) - FrameFunction(y*0.5,x,z).gray*0.01 }
	max_gradient 3.0
	contained_by { box { <-1.2, -2.6, -0.1>, <1.2, 2.6, 0.1>} }
	translate <-1.1, -2.875, 0.05>
			}
union {
	plane { <0, -1, 0>,  4.85 }  //9 }
	plane { < 0, -1, 0>, 0  rotate  45*z  translate <-2.2, -5.35, 0> }
	plane { < 0, -1, 0>, 0  rotate -45*z  translate < 0.0, -5.35, 0> }
	   }
	texture { PeelingPaint  scale 0.1  translate <12, 0, 0> }
			}  //  bottom difference

//	The brass hinge boxes

union {
object {  Hinge  translate <0, -5.3, 0> }
object {  Hinge  translate <0, -3.0, 0> }
object {  Hinge  translate <0, -1.0, 0> }
	texture { AntiqueBrassTexture }
	   }

//	Curvey handle

#local CurvedHandle =
union {

//	Top curve

difference { 
	cylinder { <-0.03, 0, 0>, <0.03, 0, 0>, 0.100  scale <1.1, 2, 1> }
	cylinder { <-0.06, 0, 0>, <0.06, 0, 0>, 0.075  scale <1.1, 2.035, 1> }
	plane { < 0,1,0>, 0.0  rotate  -30*x  translate <0, -0.10, 0> }
		    }

//	Bottom curve

difference { 
	cylinder { <-0.03, 0, 0>, <0.03, 0, 0>, 0.06  scale <1.1, 1.5, 1> }
	cylinder { <-0.06, 0, 0>, <0.06, 0, 0>, 0.04  scale <1.1, 1.535, 1> }
	plane { < 0,0,1>, 0.0 }// rotate -10*x translate <0, 0, 0> }
	rotate 15*x
	translate <0, -0.365, -0.05>
		    }

//	Joiner

box { <-0.03, -0.08, 0>, <0.03, 0.08, 0.025>  
	rotate -20*x
	translate <0, -0.22, -0.05> } 

//	Key cylinder

object { 
	sphere { <0, 0, 0>, 0.1  scale <1, 1, 0.3> }
	translate <0, 0.3, 0>
		    }

	scale <1, 0.8, 1>
	translate <-1.95, -2.8, -0.03>
	   }  //  end of CurvedHandle

//	Door handle plate

object {
	CurvedHandle
	texture { AntiqueBrassTexture }
		}

object {
	box { <-2.07, -3.2, -0.01>,<-1.83, -2.50, 0.0> }  //  handle plate
	texture { AntiqueBrassTexture }
		}
difference {
	box { <-2.07, -3.2, -0.02>,<-1.83, -2.50, -0.01> }
	cylinder { <-2.07, -2.50, -0.05>, <-2.07, -2.50, 0.00> 0.05}
	cylinder { <-2.07, -3.20, -0.05>, <-2.07, -3.20, 0.00> 0.05}
	cylinder { <-1.83, -2.50, -0.05>, <-1.83, -2.50, 0.00> 0.05}
	cylinder { <-1.83, -3.20, -0.05>, <-1.83, -3.20, 0.00> 0.05}
	texture { AntiqueBrassTexture }
		}

//	Metal kickplate (etched hearts)

object {
	box { <-2.1, -5.0, -0.01>,<-0.1, -5.30,  0.00> }
	texture { AntiqueBrassTexture  translate <5,0,0> }
		}

difference {
	box { <-2.1, -5.0, -0.02>,<-0.1, -5.30, -0.01> }
	object { HeartSection  scale < 0.3, 0.28, 0.3>  translate <-1.92, -5.34, 0.3> }
	object { HeartSection  scale <-0.3, 0.28, 0.3>  translate <-1.60, -5.34, 0.3> }

	object { HeartSection  scale < 0.3, 0.28, 0.3>  translate <-1.27, -5.34, 0.3> }
	object { HeartSection  scale <-0.3, 0.28, 0.3>  translate <-0.95, -5.34, 0.3> }

	object { HeartSection  scale < 0.3, 0.28, 0.3>  translate <-0.62, -5.34, 0.3> }
	object { HeartSection  scale <-0.3, 0.28, 0.3>  translate <-0.30, -5.34, 0.3> }
	texture { AntiqueBrassTexture }
//	texture { BaseWaterStains  translate <0, -5.60, 0> }
			}

//	Interior boxes

#local IntBox =
difference {
	box { <0.00, 0.00,  0.00>, <0.60, 0.50, 0.02> }
	box { <0.02, 0.01, -0.10>, <0.58, 0.49, 0.10> }
	texture { BlueIronTexture }
			}

#local IntDia =
union {
difference {
	box { <0.0, 0.0, 0.02>, <0.6, 0.5, 0.10> }
	box { <-0.15, -0.15,-0.1>, <0.15, 0.15, 0.06>  rotate 45*z  translate <0.3, 0.25, 0> }
			}
	object { IntBox }
	   }
	
#local HeightCount = -4.85;
#while ( HeightCount < -2.65 )

object { IntDia
			translate <-1.1, HeightCount, 0.03>
	texture { DoorMarbleTexture  translate <HeightCount*10, 0, 0> }			
		}
object { IntDia
			translate <-1.7, HeightCount, 0.03>
	texture { DoorMarbleTexture  translate <HeightCount*10, 5, 0> }			
		}
#local HeightCount = HeightCount + 0.5;
#end
	  }  //  end IsoDoor union

object {  IsoDoor  
			rotate 94*y
			translate <2.15, 0, 0.4> }

object {  IsoDoor  
			rotate 86*y
			translate <-1.80, 0, 0.4> }

//	An extra light for tunnel 

light_source { <0, -3, -1>  //  tunnel light
	color rgb < 0.90, 0.95, 1>*1.3  //  Brightness increased for gamma difference
	fade_distance 5.25
	fade_power 2
			  }

    global_lights on

	translate <11.0, 5.5, 0.05>

			}

//	The Fire Hydrant (Pipe)

/*
//	A rounded isosurface cylinder, constructed using cylinder and torus
//	Drawn along the Y axis

#macro RoundedCYL(Height, Radius, Roundness)

#local FACEUP = function { y }
#local FACEDOWN = function { -y }

//	A chopped off cylinder

#local RCYL0 = function { sqrt(pow(x,2) + pow(z,2)) - Radius }
#local RCYL1 = function { max( RCYL0(x,y,z), -FACEDOWN(x,y - Height + Roundness,z) ) }
#local RCYL2 = function { max( RCYL1(x,y,z), -FACEUP(  x,y + Height - Roundness,z) ) }

//	Round the ends

#local RTOR  = function { f_torus(x,y,z, Radius-Roundness, Roundness) }
#local RCYL3 = function { min( RCYL2(x,y,z), RTOR(x,y - Height + Roundness,z) ) }
#local RCYL4 = function { min( RCYL3(x,y,z), RTOR(x,y + Height - Roundness,z) ) }

//	Fill the center

#local TCYL0 = function { sqrt(pow(x,2) + pow(z,2)) - Radius + Roundness }
#local TCYL1 = function { max( TCYL0(x,y,z), -FACEDOWN(x,y - Height,z) ) }
#local TCYL2 = function { max( TCYL1(x,y,z), -FACEUP(  x,y + Height,z) ) }

#local RCYL5 = function { min( RCYL4(x,y,z), TCYL2(x,y,z) ) }

isosurface {
	function { RCYL5(x,y,z) }// + PoleFunction(x,y,z).gray*0.02 }
	max_gradient 2.0
	contained_by { box { <-Radius, -Height, -Radius>, <Radius, Height, Radius>} }
			}

#end  //  end of RoundedCYL macro
*/

//	Draw an octogon

#macro Octo(Height, BoxDiagSize)

#local B0  = function { abs(x) + abs(z) - BoxDiagSize }
#local B45 = function { (abs(x*0.707107 - z*0.707107) + 
						 abs(x*0.707107 + z*0.707107) - BoxDiagSize ) }
#local OCT1 = function { max( B0(x,y,z), B45(x,y,z) ) }  //  "intersection"

#local FACEUP = function { y }
#local FACEDOWN = function { -y }

#local OCT2 = function { max( OCT1(x,y,z), -FACEDOWN(x,y - Height,z) ) }
#local OCT3 = function { max( OCT2(x,y,z), -FACEUP(  x,y,z) ) }

isosurface {
	function { OCT3(x,y,z) + PoleFunction(x,y,z).gray*0.0005 }
	max_gradient 2.0
	contained_by { box { <-BoxDiagSize, 0,     -BoxDiagSize>, 
						 < BoxDiagSize, Height, BoxDiagSize>} }
			}

#end  //  of Octo macro

//	Draw a rounded cap with a diagonal block blobbed end

#macro RoundedBoxCap(Height, Radius, Roundness, BoxDiagSize, BoxHeight, Tex)

#local FACEUP = function { y }
#local FACEDOWN = function { -y }

//	A chopped off cylinder

#local RCYL0 = function { sqrt(pow(x,2) + pow(z,2)) - Radius }
#local RCYL1 = function { max( RCYL0(x,y,z), -FACEDOWN(x,y - Height + Roundness,z) ) }
#local RCYL2 = function { max( RCYL1(x,y,z), -FACEUP(  x,y,z) ) }

//	Round the end

#local RTOR  = function { f_torus(x,y,z, Radius-Roundness, Roundness) }
#local RCYL3 = function { min( RCYL2(x,y,z), RTOR(x,y - Height + Roundness,z) ) }

//	Fill the center

#local TCYL0 = function { sqrt(pow(x,2) + pow(z,2)) - Radius + Roundness }
#local TCYL1 = function { max( TCYL0(x,y,z), -FACEDOWN(x,y - Height,z) ) }
#local TCYL2 = function { max( TCYL1(x,y,z), -FACEUP(  x,y,z) ) }

//	Add a diagonal block to the center cylinder

#local DBOX0 = function { abs(x) + abs(z) - BoxDiagSize }  //  square box, drawn rotated 45 degrees
#local DBOX1 = function { max( DBOX0(x,y,z), -FACEDOWN(x,y - Height - BoxHeight,z) ) }
#local DBOX2 = function { max( DBOX1(x,y,z), -FACEUP(  x,y,z) ) }

#local BLOB = function { TCYL2(x,y,z)*DBOX2(x,y,z) - 0.0002 }  //  0.0002 = rather sharp transition to the bolt

//	Blobed box raises the cylinder,, so move it down a bit (0.001)

#local RCYL4 = function { min( RCYL3(x,y,z), BLOB(x,y + 0.001,z) ) }

isosurface {
	function { RCYL4(x,y,z) + PoleFunction(x,y,z).gray*0.0005 }
	max_gradient 2.0
	accuracy 0.0001  //  Fixes shadow artifacts, 68 vs. 25 seconds render
	contained_by { box { <-Radius, 0, -Radius>, <Radius, Height + BoxHeight, Radius>} }

//	Optional texture

#if ( Tex > 0 ) 
	texture { DarkPaintedMetalTexture  translate <0, Tex, 0> } 
#end

			}

#end  //  end of RoundedCap macro

//	The handle mount

#macro HandleMount() 

#local HFACERIGHT = function { x }
#local HFACELEFT = function { -x }

//	Chopped off cylinders

#local HCYL0 = function { sqrt(pow(y,2) + pow(z,2)) - 0.11 }
#local HCYL1 = function { max( HCYL0(x,y,z), -HFACELEFT( x,y,z) ) }
#local HCYL2 = function { max( HCYL1(x,y,z), -HFACERIGHT(x+0.13,y,z) ) }

#local HCYLS = function { sqrt(pow(y,2) + pow(z,2)) - 0.08 }

#local HTOR0 = function { f_torus(y,x,z, 0.10, 0.03) }

#local HTOR1 = function { f_torus(y,x,z, 0.08, 0.04) }
#local HTOR2 = function { f_torus(y,x,z, 0.13, 0.05) }

#local HTOR3 = function { max( HTOR1(x,y,z), -HTOR2(x-0.05,y,z) ) }

//	The screw

#local HSCREW = function { f_helix2(x,y,z, 0, 60, 0.030, 0.0, 0, 0, 45) }

/*

    * P0 : Not used
    * P1 : Period - is related to the number of turns per unit length
    * P2 : Minor radius (minor radius > major radius)
    * P3 : Major radius
    * P4 : Not used
    * P5 : Cross section type
	* P6 : Cross section rotation angle (degrees) 
*/

#local HFACEUP = function { y }
#local HCONE0 = function { sqrt(pow(x,2) + pow(z,2) ) - 0.02 - 0.1*y }
#local HCONE = function { max( HCONE0(x,y,z), -HFACEUP( x,y,z) ) }

#local HSPHERE = function { sqrt(pow(x,2) + pow(y,2) + pow(z,2) ) - 0.1 }
#local HTORUS = function { f_torus(y,x,z, 0.35, 0.05) }

#local HROPE1 = function { f_torus(x,y,z, 0.06, 0.025) }

#local HROPE2 = function { f_helix2(x,y,z, 0, 40, 0.03, 0.0, 0, 0, 45) }
//#local HROPE3 = function { max( HROPE2(x,y,z), -HFACEUP(x,y + 0.1,z) ) }


union {

//	Cylinder

isosurface {
	function { HCYL2(x,y,z) }//+ PoleFunction(x,y,z).gray*0.0005 }
	max_gradient 2.0
//	accuracy 0.0001  //  Fixes shadow artifacts, 68 vs. 25 seconds render
	contained_by { box { <-0.3, -0.2, -0.2>, <0.1, 0.2, 0.2>} }
			}

//	Inside Torus

isosurface {
	function { HTOR0(x + 0.08,y,z) }//+ PoleFunction(x,y,z).gray*0.0005 }
	max_gradient 2.0
//	accuracy 0.0001  //  Fixes shadow artifacts, 68 vs. 25 seconds render
	contained_by { box { <-0.3, -0.2, -0.2>, <0.1, 0.2, 0.2>} }
			}

//	2nd Cylinder, small

isosurface {
	function { HCYLS(x,y,z) }//+ PoleFunction(x,y,z).gray*0.0005 }
	max_gradient 2.0
//	accuracy 0.0001  //  Fixes shadow artifacts, 68 vs. 25 seconds render
	contained_by { box { <-0.28, -0.2, -0.2>, <0, 0.2, 0.2>} }
			}

//	Large clipped Torus

isosurface {
	function { HTOR3(x + 0.24,y,z) }//+ PoleFunction(x,y,z).gray*0.0005 }
	max_gradient 2.0
//	accuracy 0.0001  //  Fixes shadow artifacts, 68 vs. 25 seconds render
	contained_by { box { <-0.3, -0.2, -0.2>, <0.1, 0.2, 0.2>} }
			}

//	The screw

isosurface {
	function { HSCREW(y,x,z) }
	max_gradient 6
	contained_by { box { <-0.45, -0.2, -0.2>, <-0.2, 0.2, 0.2>} }
	texture { DarkPaintTexture }
 			}

//	A blade (cone)

union {
#local BladeCount = 0;
#while ( BladeCount < 350 )

isosurface {
//	function { HCONE( (x - y*y*1.5) + 0.5,y,z*4) }  //  unrotated version
	function { HCONE(x*4, y, (z - y*y*1.5)) }
	max_gradient 5
	contained_by { sphere { <0, 0, 0>, 0.3 } }
	rotate BladeCount*x
	translate <-0.45, 0, 0>
 			}

#local BladeCount = BladeCount + 45;
#end

	texture { RustedShinyMetalTexture }
//	texture { DarkPaintedMetalTexture }
	   }

//	Center flattend sphere

isosurface {
	function { HSPHERE(x*3,y,z) }
	max_gradient 3
	contained_by { sphere { <0, 0, 0>, 0.1 } }
	translate <-0.46, 0, 0>
	texture { RustedShinyMetalTexture }
//	texture { DarkPaintedMetalTexture }
 			}

//	The hand circle part

isosurface {
	function { HTORUS(x*1.8,y,z) }
	max_gradient 3
	contained_by { sphere { <0, 0, 0>, 0.5 } }
	translate <-0.45, 0, 0>
	texture { RustedShinyMetalTexture }
//	texture { DarkPaintedMetalTexture }

 			}

//	The rope remnant

union {
isosurface {
	function { HROPE1(x*1.5,y,z) + PoleFunction(x,y,z).gray*0.005 }
	max_gradient 2
	contained_by { sphere { <0, 0, 0>, 0.2 } }
	rotate 20*z
 			}
isosurface {
	function { HROPE1(x*1.5,y,z) + PoleFunction(x,y,z).gray*0.005 }
	max_gradient 2
	contained_by { sphere { <0, 0, 0>, 0.2 } }
	rotate -20*z
 			}

	translate <-0.45, 0, -0.35>
	rotate -10*x

	texture { 
	    finish { roughness 0.015  specular 0.2  diffuse 0.4 }
		pigment { color rgb 0.15 } }
		normal { granite 1.0  scale 0.5 }

	   }  //  end of union

isosurface {
	function { HROPE2(x,y,z) }
	max_gradient 3
	contained_by { box { <-0.1, 0, -0.1>, <0.1, -0.17, 0.2> } }
	scale <0.6, 1, 0.6>
	translate <-0.46, -0.06, -0.35>
	texture { 
	    finish { roughness 0.015  specular 0.2  diffuse 0.4 }
		pigment { color rgb 0.15 } 
		normal { granite 1.0  scale 0.5}
			}	
			}

//	Invisible rope (for shadow, skinny for no shadow on sidewalk)

object {
isosurface {
	function { HROPE2(x,y,z) }
	max_gradient 3
	contained_by { box { <-0.1, 0, -0.1>, <0.1, -0.4, 0.1> } }
			}
	texture { pigment { color rgb 1 } }
	no_image

	scale <0.6, 1, 0.01>
	translate <-0.46, -0.06, -0.35>

		}
//	Place it at the left end

texture { DarkPaintedMetalTexture  rotate 90*z   translate <1,1,0> }  //  +1, 2 are clear

translate <-0.25, 2.5, 0>
	   }
#end

//	The Pipe

#macro Pipe(Full)

#local PoleDiffuse = 0.6;

//	Load the hydrant text image

#declare HydrantTextPigment =
  pigment {
    image_map {
        gif "HydrantText.gif" 

        map_type 0
        interpolate 2
               }
	scale <0.75, 2.25, 1>  //  Image is 300x900, but we want 100x300 part
	translate <-0.125, 1.9, 0>  //  place the image on the top half (center at 50 pixels)
           }

//	Load the hydrant text image

#declare HydrantTransTextPigment =
  pigment {
    image_map {
        gif "HydrantText.gif" 

#local CCount = 0;
#while ( CCount < 256 )
		transmit CCount, 0.5  //  Partially transparent text
#local CCount = CCount + 1;
#end

        transmit 0, 1.0  //  transparent background

//        once  //  (isosurface needs full coverage)
        map_type 0
        interpolate 2
               }
	scale <0.75, 2.25, 1>  //  Image is 300x900, but we want 100x300 part
	translate <-0.125, 1.9, 0>  //  place the image on the top half (center at 50 pixels)
           }

//		Rusty Red Metal Texture

#local MetalPigment =
  pigment {
    wrinkles
    color_map {
      [0.0 rgb <0.35, 0.15, 0.15>]
      [0.7 rgb <0.45, 0.20, 0.20>]
      [1.0 rgb <0.55, 0.25, 0.25>]
    	       }
	scale 1  //  was 5
	       }

#local MetalTexture =
texture {
    finish { roughness 0.015  specular 0.6  metallic  diffuse 0.4 }
	pigment { MetalPigment }
    normal { granite 0.2  scale 1.0 }
		 }

#local RustPigment =
         pigment
                 {
                 granite
                 color_map {
                         [ 0.0 rgb <0.70, 0.30, 0.10> ]
                         [ 0.4 rgb <0.25, 0.15, 0.05> ]
                         [ 0.6 rgb <0.35, 0.25, 0.15> ]
                         [ 1.0 rgb <0.50, 0.10, 0.05> ]
                            }
                 scale .5
                 turbulence 1
                 }

#local RustTexture = 
	texture {
		finish { diffuse 0.4 } 
        pigment { RustPigment }
        normal { wrinkles  scale 2 }
         	 }

#local RedPaintTexture =
	texture{

     	finish {
			diffuse 0.6
			brilliance 1.0 
			specular 0.3  roughness 0.01
				}

     	pigment {     
			wrinkles
    			color_map { 
//	In between
      				[0.00 color rgb <0.7, 0.17, 0.12>]
      				[0.20 color rgb <0.4, 0.12, 0.12>]
      				[1.00 color rgb <0.9, 0.22, 0.22>]
//	Saturated
//      				[0.00 color rgb <0.7, 0.15, 0.15>]
//      				[0.20 color rgb <0.4, 0.10, 0.10>]
//      				[1.00 color rgb <0.9, 0.20, 0.20>]
//	Washed out a bit
//      				[0.00 color rgb <0.7, 0.20, 0.20>]
//      				[0.20 color rgb <0.4, 0.15, 0.15>]
//      				[1.00 color rgb <0.9, 0.25, 0.25>]
    					   }
 				  }
    normal { granite 0.2  scale 1.0}
   			}
//	texture { pigment { HydrantTextPigment  scale <1, 0.5, 1> } }

#local PaintedMetalTexture = 
	texture {
		bozo
		warp { turbulence 1  omega .6  lambda 4 }
		texture_map {
                 [ 0.0 RedPaintTexture ]
                 [ 0.5 RedPaintTexture ]
                 [ 0.6 MetalTexture ]
                 [ 0.7 RustTexture ]
                 [ 1.0 RustTexture ]
					 }
		scale <1, 2, 1>
         	}

//	A dark blue color for the caps and base

#local DarkPaintTexture =
	texture{

     	finish {
			diffuse 0.6
			brilliance 1.0 
			specular 0.3  roughness 0.01
				}

     	pigment {     
			wrinkles
    			color_map {
      				[0.00 color rgb <0.15, 0.17, 0.25>]  //  g was 0.20
      				[0.20 color rgb <0.10, 0.12, 0.20>]  //  g was 0.15
      				[1.00 color rgb <0.20, 0.22, 0.30>]  //  g was 0.25
    					   }
 				  }
    normal { granite 0.3  scale 1.0}
   			}

#local DarkPaintedMetalTexture = 
	texture {
		bozo
		texture_map {
                 [ 0.0 DarkPaintTexture ]
                 [ 0.5 DarkPaintTexture ]
                 [ 0.6 MetalTexture ]
                 [ 0.7 RustTexture ]
                 [ 1.0 RustTexture ]
					 }
		warp { turbulence 1  omega .6  lambda 4 }
		scale <1, 0.5, 1>
         	}

//	Shiny with very little rust

#local RustedShinyMetalTexture = 
	texture {
		bozo
		texture_map {
                 [ 0.0 DarkPaintTexture ]
                 [ 0.6 DarkPaintTexture ]
                 [ 0.7 MetalTexture ]
                 [ 0.8 RustTexture ]
                 [ 1.0 RustTexture ]
					 }
		warp { turbulence 1  omega .6  lambda 4 }
		scale <0.5, 1, 1>
         	}

union {

#if ( Full > 0 )

//	Hydrant Isosurfaces

#local HydrantTextF = function { pigment { HydrantTextPigment } }

#local PCYLX = function { sqrt(pow(y,2) + pow(z,2)) - 0.16 }
#local PCYLY = function { sqrt(pow(x,2) + pow(z,2)) - 0.20 }
#local PCYLZ = function { sqrt(pow(x,2) + pow(y,2)) - 0.18 }

#local PCONE = function { sqrt(pow(x,2) + pow(z,2) ) - 0.275 + 0.05*y }


/*	Sliced every 45 degrees (too sharp)
#local Box0  = function { abs(x) + abs(z) - 1 }
#local Box45 = function { (abs(x*0.707107 - z*0.707107) + 
						   abs(x*0.707107 + z*0.707107) - 1 ) }

#local PCONE0 = function { sqrt(pow(x,2) + pow(z,2) ) - 0.3 + 0.066666*y }

#local PCONE1 = function { max( PCONE0(x,y,z), -Box0(x,y,z + 1.225) ) }  //  Front
#local PCONE2 = function { max( PCONE1(x,y,z), -Box0(x + 1.225,y,z) ) }  //  Left
#local PCONE3 = function { max( PCONE2(x,y,z), -Box45(x + 0.8662,y,z + 0.8662) ) }  //  Diag Left
#local PCONE  = function { max( PCONE3(x,y,z), -Box45(x - 0.8662,y,z + 0.8662) ) }  //  Diag Left
*/

#local PTOR1 = function { f_torus(x,(y - 0.47)*1.0,z, 0.3, 0.05) }

#local FACELEFT = function { -x }
#local FACERIGHT = function { x }
#local PCYLX1 = function { max( PCYLX(x,y,z), -FACELEFT( x-0.24,y,z) ) }
#local PCYLX2 = function { max( PCYLX1(x,y,z), -FACERIGHT(x+0.24,y,z) ) }

#local PBLOB1 = function { PCYLY(x,y,z)*PCYLX2(x,y-2.5,z) - 0.001 }
#local PBLOB2 = function { PCONE(x,y-0.3,z)*PCYLZ(x,y-1.6,z) - 0.001 }

#local PCYLXS = function { sqrt(pow(y,2) + pow(z,2)) - 0.10 }
#local PBLOB1S = function { min( PBLOB1(x,y,z), PCYLXS(x,y-2.5,z) ) }

#local PBLOBS = function { min( PBLOB1S(x,y,z), PBLOB2(x,y,z) ) } 

#local PoleFunction = function { pigment { granite  scale 0.5 } }

//	The main fire hydrant pole 

isosurface {
	function { PBLOBS(x,y,z) 

#if ( Full > 1 )
		 	- HydrantTextF(x,y,z).gray*0.0005  // Text embossed  SLOW!
 			+ PoleFunction(x,y,z).gray*0.0005 }
#else 
			}
#end

	max_gradient 3.0
	accuracy 0.0001  //  Fixes shadow artifacts, 68 vs. 25 seconds render for default 0.001
	contained_by { box { <-0.35, 0.3, -0.35>, <0.35, 2.8, 0.35>} }
			}

//	The raised white text (Transparent object scaled slightly larger)
//	Very slow

#if ( Full > 1 ) 

object {
isosurface {
	function { PBLOBS(x,y,z)

#if ( Full > 1 )
 			- HydrantTextF(x,y,z).gray*0.0005  // Text embossed  
			+ PoleFunction(x,y,z).gray*0.0005 }
#else
			}
#end

	max_gradient 3.0
	accuracy 0.0001  //  Fixes shadow artifacts, 68 vs. 25 seconds render
	contained_by { box { <-0.35, 0.3, -0.35>, <0.35, 2.8, 0.35>} }
	clipped_by { box { <-0.125, 1.9, -0.3>, <0.125, 2.8, -0.15>} }  //  clipped box showes intersection lines

			}
	hollow
	no_shadow

	scale <1, 1, 1.03>

	texture { pigment { HydrantTransTextPigment } }
		}
#end

//	The top cap

object { Octo(0.11, 0.13)  //  Octo(Height, BoxDiagSize)
		 translate <0, 2.95, 0>
		}

//	     RoundedBoxCap(Height, Radius, Roundness, BoxDiagSize, BoxHeight, Tex)

//	The top rounded cylinder and cap

object { RoundedBoxCap(0.20, 0.24, 0.02, 0.08, 0.04, 0)  
		 translate <0, 2.8, 0> }

//	On the lower front and rear (was 0.45 Z, now 0.35)

object { RoundedBoxCap(0.17, 0.21, 0.04, 0.05, 0.08, 4)  //  4 is good, 3.5, 4.5 NG
		 rotate -90*x
		 translate <0, 1.6, -0.35> }
	
object { RoundedBoxCap(0.17, 0.21, 0.04, 0.05, 0.08, 2)  
		 rotate 90*x
		 translate <0, 1.6, 0.35> }

//	On the upper right

object { RoundedBoxCap(0.08, 0.12, 0.05, 0.04, 0.05, 3) 
		 rotate -90*z
		 translate <0.32, 2.5, 0.0> }

//	The chain

#declare chain_start = <0.45, 2.52, 0.05>;
#declare chain_end =   <0.27, 2.2, 0.25>;

#declare link_thick = 0.1; //  rad
#declare link_width = 0.3;  //  rad
#declare half_torus = intersection {
  torus { link_width,link_thick }
  plane { x,0 }
  translate x*(link_width-link_thick)
}
#declare cyl_link = cylinder {
  <link_width-link_thick,0,0>,<1-(link_width-link_thick),0,0>, link_thick
}

#declare link = union {
  object { half_torus }
  object { half_torus scale <-1,1,1> translate x*1 }
  object { cyl_link translate z*link_width }
  object { cyl_link translate -z*link_width }
					   }


#declare link_length = 0.1;
#declare link_error = 0.01; // (fraction of link_length)
#declare chain_scale=22; 

#declare strand = union { #include "chain11.inc" }

object { strand 
//	texture { PaintedMetalTexture }  //  Red chain
	texture { DarkPaintedMetalTexture  translate <1,1,0> }
		}

//	Attach point for far end of chain

object { 
	box { <0.25, 2.2, 0.24>, <0.29, 2.4, 0.26> }
	texture { DarkPaintedMetalTexture  translate <1,1,0> }
		}

//	The base (Box hidden, used for sharp base)

object { RoundedBoxCap(0.1, 0.30, 0.03, 0.04, 0.05, 0)  //  top  
		 translate <0, 0.2, 0> }

//	The handle extension

object { HandleMount() }

//	The Bottom mount parts

union {

object { RoundedBoxCap(0.05, 0.30, 0.02, 0.04, 0.05, 0)  //  bottom
		 rotate 180*x
		 translate <0, 0.19, 0> }

//	The bolts

#local BoltRot = 0;
#while (BoltRot < 350 ) 
		 
	object {  
		Octo(0.05, 0.05)  //  Octo(Height, BoxDiagSize)
		translate <0, 0.10, 0.25>
		rotate BoltRot*y
			}

#local BoltRot = BoltRot + 45;
#end

//	The lower mount pole

isosurface {
	function { PCYLY(x,y,z) }//+ PoleFunction(x,y,z).gray*0.0010 }
	max_gradient 2.0
	contained_by { box { <-0.2, -1, -0.2>, <0.2, 0.1, 0.2>} }
			}

	texture { DarkPaintedMetalTexture }

	   }  //  end of Bottom mount parts union

//	Simple placeholder

#else
	cylinder { <0, -1, 0>, <0, 3, 0>, 0.15 }
	cylinder { <0, 2.5, 0>, <-1, 2.5, 0>, 0.05 } 
	cylinder { <-0.8, 2.5, 0>, <-0.7, 2.5, 0>, 0.4 } 

//	object { strand }

#end

	texture { PaintedMetalTexture }
//	texture { pigment { color rgb <1, 1, 1> } } 

	translate <7.85, 0, -1.5>
	   }

#end  //  of Pipe macro

