//	"Innocent Shadow"
//	Written by Mark Slone  slone@hiwaay.net
//	December 2002

#macro Sidewalk(Full)

#local ConcreteTexture =

texture {		//	Gravel in concrete

//	Added this finish, which brightens and roughens the surface
//  TOO MUCH?
/*
  finish {
      specular 0.20 roughness 0.1
      reflection 0.1  //05
                }
*/
  pigment {
 
   granite
    color_map {
    [0.00 rgb <0.8, 0.8, 0.8>*0.9]
    [0.75 rgb <0.7, 0.7, 0.7>*0.9]
    [0.76 rgb <0.6, 0.6, 0.6>*0.9]  //  gravel
    [1.00 rgb <0.6, 0.6, 0.6>*0.9]  //  gravel
               }

	scale 3
	warp {turbulence 1 }
	scale (1/3)  

	scale 0.4
          }
	normal { granite 0.2   scale 0.2 }
		}

//	Pebble normal

texture {

 	pigment { color rgbt <1,1,1,1> }

	normal { 
		granite 0.5
		slope_map {
			[0.1 <0,   0>]
			[0.3 <0,   0>]
			[0.5 <0,  -1>]
			[1.0 <1,   0>]
				   }
			 scale .4
			}
        }

texture {  //  Large, vague smudges (blood)
 pigment {
	bozo
	warp { turbulence .2 octaves 3 omega .3 lambda 2 }
	scale 2
	warp { turbulence .7 octaves 3 omega .3 lambda 2 }
	scale 2
	warp { turbulence 1 octaves 3 omega .3 lambda 2 }
	scale 6
	warp { turbulence 1 octaves 3 omega .3 lambda 2 }
	color_map {
		[0.00 rgbt  <0.10, 0.0, 0.0, 0> ]  //  blood
		[0.55 rgbt  <0.10, 0.0, 0.0, 1> ]
		[1.00 rgbt  <0.00, 0.0, 0.0, 1> ]
			   }
		 }
	scale 0.1
	translate <-9.5, 0, 0.2>
	   }

texture {		//	Medium blemishes
  pigment {
    bozo
    color_map {
    [0.00 rgbt <0.53, 0.43, 0.35, 1.0>]
    [0.70 rgbt <0.53, 0.43, 0.35, 1.0>]
    [0.80 rgbt <0.43, 0.33, 0.25, 0.7>]
    [0.90 rgbt <0.33, 0.23, 0.15, 0.5>]
    [1.00 rgbt <0.10, 0.10, 0.10, 0.3>]
               }
  scale 0.3
	warp { turbulence 0.5 }
    octaves 8        //  6   fuzzy   8 sharper
    lambda 2.6       //  2.0 fuzzy 2.8 more swirly
    omega 0.6        //  0.5 fuzzy 0.6 crinkly

           }
        }

//	Test crack patterns: not rotated 45?
/*
texture { 
	pigment { 
    	marble
   	 	color_map {
    		[0.00 rgbt <0.0, 0.0, 0.0, 1.0>]
    		[0.64 rgbt <0.0, 0.0, 0.0, 1.0>]  
    		[0.65 rgbt <0.0, 0.0, 0.0, 0.0>]  //  was 0.25
    		[0.66 rgbt <0.0, 0.0, 0.0, 1.0>]
    		[1.00 rgbt <0.0, 0.0, 0.0, 1.0>]
               }
	rotate -60*y
    scale 8
	translate <1.5, 0.0, 0.0>  //  position cracks

	warp { turbulence 0.7 
    octaves 6        //  6   fuzzy   8 sharper
    lambda 2.0       //  2.0 fuzzy 2.8 more swirly
    omega 0.6        //  0.5 fuzzy 0.6 crinkly
		   }
					      } 	    }
*/
//*************************************************************

//	Fast render version

#if ( Full < 2 )

object {
	box { <0, -0.06, 0>, <13, -0.4, -4.2> }
	texture { ConcreteTexture }
		}

#else

//	Slow render version

#local DiagSize = 2.20*1.4142;
#local FACEUP = function { y }
#local FACEDOWN = function { -y }

#local FCYLHOLE =  function { sqrt(pow(x,2) + pow(z,2) ) - 0.3 }
#local FCONEHOLE = function { sqrt(pow(x,2) + pow(z,2) ) - 0.22 - 0.2*y }

#local Block = function { abs(x) + abs(z) - DiagSize }  //  square box, drawn rotated 45 degrees

#local Block1 = function { max( Block(x,y,z), -FACEUP(x,y+0.6,z) ) }  //  bottom
#local Block2 = function { max( Block1(x,y,z), -FACEDOWN(x,y-0.2,z) ) }  //  top
#local Block2Hole = function { max( Block2(x,y,z), -FCONEHOLE(x-0.47,y,z-1.52) ) }  //  was -.62, -1.62

#local WalkStucco = function { pigment { wrinkles } }

//	Try a rounded box

#local BlockBox = function { f_rounded_box(x,y,z, 0.05, 2.2, 2.2, 2.2) }

//	Wide granite cracks (gradual)

#local CracksShallow = function { pigment { 
    granite
    color_map {
    [0.00 rgb <0.0, 0.0, 0.0>]
    [0.23 rgb <0.0, 0.0, 0.0>]  
    [0.24 rgb <0.5, 0.5, 0.5>]
    [0.25 rgb <1.0, 1.0, 1.0>]
    [0.26 rgb <0.5, 0.5, 0.5>]
    [0.27 rgb <0.0, 0.0, 0.0>]
/*
    [0.21 rgb <0.0, 0.0, 0.0>]  
    [0.23 rgb <0.5, 0.5, 0.5>]
    [0.25 rgb <1.0, 1.0, 1.0>]
    [0.27 rgb <0.5, 0.5, 0.5>]
    [0.29 rgb <0.0, 0.0, 0.0>]
*/
    [1.00 rgb <0.0, 0.0, 0.0>]
               }
	rotate 90*x
    scale 20  //  10
	translate <-10.5, 0.0, -0.5>  //  position cracks

	warp { turbulence 0.7 }
    octaves 8        //  6   fuzzy   8 sharper
    lambda 2.6       //  2.0 fuzzy 2.8 more swirly
    omega 0.5        //  0.5 fuzzy 0.6 crinkly

					      } 	    }

//	River-like terrain for surface abrasion

#local Cracks2 = function { pigment { 
    granite
    color_map {
    [0.00 rgb <0.0, 0.0, 0.0>]
    [0.15 rgb <0.0, 0.0, 0.0>]
    [0.20 rgb <0.5, 0.5, 0.5>]
    [0.25 rgb <1.0, 1.0, 1.0>]
    [0.30 rgb <0.5, 0.5, 0.5>]
    [0.35 rgb <0.0, 0.0, 0.0>]
    [1.00 rgb <0.0, 0.0, 0.0>]

               }
	rotate 90*x
    scale 20

	warp { turbulence 0.7 }
    octaves 8        //  6   fuzzy   8 sharper
    lambda 2.6       //  2.0 fuzzy 2.8 more swirly
    omega 0.5        //  0.5 fuzzy 0.6 crinkly

					      } 	    }

//	Deep marble running cracks

#local CracksDeep = function { pigment { 
    	marble
   	 	color_map {
    		[0.00 rgb <0.0, 0.0, 0.0>]
    		[0.64 rgb <0.0, 0.0, 0.0>]  
    		[0.65 rgb <0.8, 0.8, 0.8>]  //  was 1.0
    		[0.66 rgb <0.0, 0.0, 0.0>]
    		[1.00 rgb <0.0, 0.0, 0.0>]
               }
	rotate -105*y  //  was -60
    scale 8
	translate <0.5, 0, 1>  //  position cracks

	warp { turbulence 0.7 
    octaves 6        //  6   fuzzy   8 sharper
    lambda 2.0       //  2.0 fuzzy 2.8 more swirly
    omega 0.6        //  0.5 fuzzy 0.6 crinkly
		   }
					      } 	    }

//	The edge

#local CracksEdge = function { pigment { 
    	marble
   	 	color_map {
    		[0.00 rgb <0.0, 0.0, 0.0>]
    		[0.64 rgb <0.0, 0.0, 0.0>]  
    		[0.65 rgb <1, 1, 1>]  //  was 1.0
    		[0.66 rgb <1, 1, 1>]
    		[1.00 rgb <1, 1, 1>]
               }
	rotate -105*y  //  was -60
    scale 8
	translate <0.5, 0, 1>  //  position cracks

	warp { turbulence 0.7 
    octaves 6        //  6   fuzzy   8 sharper
    lambda 2.0       //  2.0 fuzzy 2.8 more swirly
    omega 0.6        //  0.5 fuzzy 0.6 crinkly
		   }
					      } 	    }

#local BS = 4.4;

union {

#local BlockCount = 0;
#while ( BlockCount < 14 )

//	Middle block has sharper marble cracks

isosurface {

//	Left square (deep cracks)

#if ( BlockCount < BS )
	function { Block2(x,y,z) + WalkStucco(x-BlockCount,y,z).gray*0.05 
						     + CracksDeep(x + 7.3,y,z - 5.2).gray*0.03  //  Back corner
//						     + CracksDeep(x + 9.1,y,z - 1.9).gray*0.03  //  Both
//						     + CracksDeep(x + 10, y,z + 1.7).gray*0.03  //   Front corner
#end

//	Middle square (with hole and shallow cracks)

#if ( BlockCount = BS )      
	function { Block2Hole(x,y,z) + WalkStucco(x-BlockCount,y,z).gray*0.05 
							     + CracksShallow(x-BlockCount,y,z).gray*0.02 
#end

//	To the right of middle (deep cracks)

#if ( BlockCount > BS)
	function { Block2(x,y,z) + WalkStucco(x-BlockCount,y,z).gray*0.05 
						     + CracksDeep(x-BlockCount,y,z).gray*0.03 
#end

//		All squares

							 + Cracks2(x-BlockCount,y,z).gray*0.02 }  //  more?

	max_gradient 5
	contained_by { box { <-3.3, -0.6, -3.3>, <3.3, 0.2, 3.3>} }

	rotate 45*y  //  BlockBox (rounded) doesn't need this

//	Middle block is rotated

#if ( BlockCount = BS )  
	rotate 1*x
	rotate 1*z  
#end

//	Right block is translated into the threshold (no baseboard)

#if ( BlockCount > BS )
	translate <0, 0, 0.45>
#end

//	Translate to center of sidewalk

	translate <2 + BlockCount, -0.165, -2.4>

	texture { ConcreteTexture }
			}

#local BlockCount = BlockCount + BS;
#end

		}  //  end object

#end  //  Full if

#end  //  end of Sidewalk macro

//************************************************************************
//	Potted flowers and plant

#include "Tulips.inc"
#include "GreenLeaves.inc"

#local R6 = seed(16);

#local PotTexture =
texture {
        finish {
          diffuse 0.4
          specular 0.50 roughness 0.1
		  metallic
          reflection 0.2
                }
	pigment { color rgb <0.5, 0.3, 0.0> }
	normal { crackle 1.0  scale 0.1 }
	 }

//		Vase with tulips

#local TulipVase =
union {

	difference {
		sphere { <0,0,0>, 0.20  scale <1,3,1> }
		plane { <0, -1, 0>, -0.35 }  //  chop off top
		plane { <0,  1, 0>, -0.45 }  //  chop off bottom
				}

	torus { 0.14, 0.03  translate <0, 0.35, 0> }

	sphere { <0,0,0>, 0.11  translate <0, 0.35, 0>
			pigment { color rgb <0.2, 0.4, 0.0> } }
	   }

#local YellowTulips =
union {

//	The green long leaves

	object { 
		LongLeafPlantRight  
		scale <0.23, 0.45, 0.28>
		translate <-.05, 0, -.05> 
		texture {
			pigment { 
				wrinkles
				color_map {
					[ 0.0  color rgb <0.2, 0.5, 0.15> ]
					[ 0.5  color rgb <0.2, 0.3, 0.00> ]
					[ 1.0  color rgb <0.3, 0.5, 0.40> ]
						   }
				scale 0.2
				 	}
				}  //  end texture
			}  //  end object

	object { FlowerStalk(R6, 2) }
	object { FlowerStalk(R6, 2)  rotate -20*y  translate <.1, 0, 0.1> }
	object { FlowerStalk(R6, 2) }
	object { FlowerStalk(R6, 2) }
	object { FlowerStalk(R6, 2) }
	object { FlowerStalk(R6, 2) }
	object { FlowerStalk(R6, 2)  rotate -15*y  translate <-0.15, 0, 0> }
	object { FlowerStalk(R6, 2)  translate <0, -.1, 0>  }
	object { FlowerStalk(R6, 2) }
	object { FlowerStalk(R6, 2) }
	object { FlowerStalk(R6, 2) }
	object { FlowerStalk(R6, 2) }
	   }

#declare Tulips = 

union {

object { TulipVase 	
	scale <0.8, 1, 0.8>
	texture { PotTexture  scale <1, 2, 1> } 
		}

object { YellowTulips  translate <0.0, 0.3, 0.0> }
	
	scale 0.8
	translate <1.8, 0.40, -0.9>
	   }

//	The crane wreath

#include "Crane.inc"
#include "Crane2.inc"
//#include "Crane3.inc"  //  not used
//#include "Crane4.inc"  //  not used

#declare Cranes =
union {

//	Left

object {
	Crane

	texture {
		pigment {
			wrinkles 
			color_map {
//				[ 0.0 color rgb <1.0, 0.55, 0.10> ]  //  yellow
//				[ 0.5 color rgb <1.0, 0.80, 0.20> ]
//        		[ 1.0 color rgb <0.9, 0.70, 0.00> ]
//				[ 0.0 color rgb <0.2, 0.55, 0.20> ]  //  green
//				[ 0.5 color rgb <0.3, 0.80, 0.30> ]
//        		[ 1.0 color rgb <0.4, 0.70, 0.10> ]
				[ 0.0 color rgb <0.4, 0.55, 1.0> ]  //  blue
				[ 0.5 color rgb <0.5, 0.60, 1.0> ]
				[ 1.0 color rgb <0.3, 0.50, 0.9> ]

					   }
			scale 0.1
				 }
		normal { wrinkles 0.4  scale 0.1 }
			  }	

	double_illuminate
	scale 1
    rotate<-90,105,0>

	rotate -17*x  //  right wing touching ground
	translate <2.6, 0.125, -1.0>  //  0.178 if not rotated?
		}

//	Middle

object {
	Crane

	texture {
		pigment {
			wrinkles 
			color_map {
				[ 0.0 color rgb <1.0, 0.25, 0.30> ]  //  red
				[ 0.5 color rgb <0.9, 0.30, 0.20> ]
        		[ 1.0 color rgb <1.0, 0.20, 0.40> ]
					   }
			scale 0.1
				 }
		normal { wrinkles 0.4  scale 0.1 }
			  }	

	double_illuminate
	scale 1
    rotate<-90,80,0>  //  facing +x

	translate <2.7, 0.125, -0.7>  //  0.178 if not rotated?
		}

//	Right

object {
	Crane2

	texture {
		pigment {
			wrinkles 
			color_map {
//				[ 0.0 color rgb <1.0, 0.55, 0.10> ]
//				[ 0.5 color rgb <1.0, 0.80, 0.20> ]
//        		[ 1.0 color rgb <0.9, 0.70, 0.00> ]
				[ 0.0 color rgb <1.0, 1.0, 1.0> ]  //  white
				[ 0.5 color rgb <0.9, 0.9, 0.9> ]
        		[ 1.0 color rgb <0.8, 0.8, 0.8> ]
					   }
			scale 0.1
				 }
		normal { wrinkles 0.4  scale 0.1 }
			  }	

	double_illuminate
	scale 1.2

//	For crane:
//	rotate<-90,220,0>
//	rotate 20*z  //  right wing touching ground

//	For crane2-4
	rotate <-90, 130, 0>
	translate <3.2, 0.13, -0.47>
		}

	   }  //  end of Cranes union

//	The Cenotaph

/*	Isosurface plaque  NOT USED
#local TAP0 =  function { sqrt(pow(x,2) + pow(y,2) ) - 3 }
#local FACEUP = function { y }

#local FACEBACK = function { z }
#local FACEFORWARD = function { -z }

#local FACELEFT = function { -x }
#local FACERIGHT = function { x }

#local TAP1 = function { max( TAP0(x,y,z) , -FACEUP(x,y-1.5,z) ) }
#local TAP2 = function { max( TAP1(x,y,z) , -FACERIGHT(x+1.125,y,z) ) }
#local TAP3 = function { max( TAP2(x,y,z) , -FACELEFT( x-1.125,y,z) ) }
#local TAP4 = function { max( TAP3(x,y,z) , -FACEBACK(   x,y,z+0.1) ) }
#local TAP5 = function { max( TAP4(x,y,z) , -FACEFORWARD(x,y,z-0.1) ) }

#local TapF = function { pigment { TapPigment  scale <2.25, 1.5, 1> } }
#local GraF = function { pigment { granite  scale 1.5 } }

isosurface {
	function { TAP5(x,y,z) } // + GraF(x,y,z).gray*0.02 } 
						   //+ TapF(x + 1.125,y - 1.5,z).gray*0.04 }
	max_gradient 2.0  //  10.0
	contained_by{ box { <-1.125, 1.5, -0.1>, <1.125, 3.0, 0.1> } }
	translate <0, -1.5, 0>
*/

#declare TapPigment =
  pigment {
    image_map {
        gif "Cenotaph.gif" 

        transmit 47, 1.0  //  transparent background

        map_type 0
        interpolate 2
               }
           }

#declare Cenotaph =

difference {
	cylinder { <0, 0, -0.1>, <0, 0, 0.1>, 2.99 }
	plane { < 1,0,0>, -1.12 }
	plane { <-1,0,0>, -1.12 }
	plane { < 0,1,0>, 1.5 }

	translate <0, -1.5, 0>

	texture { 

    	finish { reflection 0.3 }

		pigment { 
			granite 
			color_map {
				[0.0  color rgb <0.0, 0.0, 0.0> ]
				[1.0  color rgb <0.9, 0.9, 0.9> ]
					   }
			scale 0.05
			     }
	         }

	texture {	

		finish { ambient 15 }

		pigment { 
			TapPigment  
		 	scale <2.25, 1.5, 1>
			translate <-1.125, 0, 0>
				 }
			 }

	scale 0.55
	rotate 20*x
	translate <2.35, 0, -0.42>
 			}
