//	"Innocent Shadow"
//	Written by Mark Slone  slone@hiwaay.net
//	December 2002

//	Draw a tulip, including a stem (but no leaves here - only good for in the distance)

#declare petal = 
	sphere {
		0, 0.7
		scale <2, 1, 1>
		clipped_by {
			sphere { <0, 0, -0.7>, 0.5 }
			}
		hollow
			}

//	Draw a tulip with stem
//	Colors:
//	 1: Red
//	 2: Yellow

#macro FlowerTulip(Seed, ColorNum)

//	Petals

union {
	object { petal  scale <1.0,2.0,1.0>  rotate x*-35   translate <0.0, 0.0, -0.2>  rotate y*0}
	object { petal  scale <1.0,2.0,1.0>  rotate x*-35   translate <0.0, 0.0, -0.2>  rotate y*90}
	object { petal  scale <1.0,2.0,1.0>  rotate x*-35   translate <0.0, 0.0, -0.2>  rotate y*180}
	object { petal  scale <1.0,2.0,1.0>  rotate x*-35   translate <0.0, 0.0, -0.2>  rotate y*270}

	object { petal  scale <0.8,1.0,0.8>  rotate x*-15   translate <0.0, 0.0, -0.35>  rotate y*22.5}
	object { petal  scale <0.8,1.0,0.8>  rotate x*-15   translate <0.0, 0.0, -0.35>  rotate y*112.5}
	object { petal  scale <0.8,1.0,0.8>  rotate x*-15   translate <0.0, 0.0, -0.35>  rotate y*202.5}
	object { petal  scale <0.8,1.0,0.8>  rotate x*-15   translate <0.0, 0.0, -0.35>  rotate y*292.5}

	object { petal  scale <1.0,2.0,1.0>  rotate x*-30   translate <0.0, 0.1, -0.2>  rotate y*45}
	object { petal  scale <1.0,2.0,1.0>  rotate x*-30   translate <0.0, 0.1, -0.2>  rotate y*135}
	object { petal  scale <1.0,2.0,1.0>  rotate x*-30   translate <0.0, 0.1, -0.2>  rotate y*225}
	object { petal  scale <1.0,2.0,1.0>  rotate x*-30   translate <0.0, 0.1, -0.2>  rotate y*315}

	scale <0.75, 1.1, 0.75>
	translate <0.0, 1.0, 0.0>

	texture {
#if ( ColorNum = 1 )
		pigment { color rgb <1.0, 0.15, 0.25> }
#end

#if ( ColorNum = 2 )

			pigment { 
				bozo
				color_map {
					[ 0.0  color rgbt <0.9, 0.8, 0.15, 0.1> ]
					[ 0.5  color rgbt <0.8, 0.7, 0.10, 0.2> ]
					[ 1.0  color rgbt <0.7, 0.6, 0.05, 0.3> ]
						   }
				scale 1
				 	}



#end
			 }
	double_illuminate  //  light shows thru

		}  // end of FlowerTulip union
#end


#macro FlowerStalk(Seed, ColorNum)

#local Vary = 4.0;

//	Radius is set in P1r (only varies slightly after that, but narrows at the top)

#local P1r = 0.10 + (rand(Seed)-0.5)*Vary*0.1;
#local P1x = (rand(Seed)-0.5)*Vary*2;
#local P1y = 4.0 + (rand(Seed)-0.5)*Vary*2;
#local P1z = (rand(Seed)-0.8)*Vary;

#local P2r = (P1r + (rand(Seed)-0.5)*Vary*0.1)*0.82;
#local P2x = P1x + (rand(Seed)-0.5)*Vary;
#local P2y = 3.0 + P1y + (rand(Seed)-0.5)*Vary*0.5;
#local P2z = P1z + (rand(Seed)-0.8)*Vary;

#local P3r = (P2r + (rand(Seed)-0.5)*Vary*0.1)*0.66;
#local P3x = P2x + (rand(Seed)-0.5)*Vary*0.5;
#local P3y = 2.0 + P2y + (rand(Seed)-0.5)*Vary*0.5;
#local P3z = P2z + (rand(Seed)-0.8)*Vary*0.5;

#local P4r = (P3r + (rand(Seed)-0.5)*Vary*0.1)*0.6;  //  Stalk narrows at the top
#local P4x = P3x + (rand(Seed)-0.5)*Vary*0.3;
#local P4y = 1.0 + P3y + (rand(Seed)-0.5)*Vary*0.5;
#local P4z = P3z + (rand(Seed)-0.8)*Vary*0.3;

//	The stalk
union {

union {
  cone   { <0.,0.,0.>, P1r,       <P1x, P1y, P1z>, P1r }
  sphere { <P1x, P1y, P1z>, P1r }
  cone   { <P1x, P1y, P1z>, P1r,  <P2x, P2y, P2z>, P2r }
  sphere { <P2x, P2y, P2z>, P2r }
  cone   { <P2x, P2y, P2z>, P2r,  <P3x, P3y, P3z>, P3r }
  sphere { <P3x, P3y, P3z>, P3r }
  cone   { <P3x, P3y, P3z>, P3r,  <P4x, P4y, P4z>, P4r }
	pigment { color rgb <0.35, 0.45, 0.0> }
       }

//	The tulip

object {
	FlowerTulip(Seed, ColorNum)
	rotate (P4x - P3x)*-50*z
	rotate (P4z - P3z)*50*x
	translate <P4x, P4y, P4z>
		}	

	scale 0.05 + (rand(Seed)*0.035)
	translate <0.0, 0.0, 0.1>

		}  //  end of FlowerStalk union

#end


