// MakeSnow macro by Tom Kissmeyer - http://www.tomandlu.co.uk/
//  use freely if for non-profit/non-political purposes,
//  but any commercial use is not allowed without permission
//  Modified 12/02, Ken Allred

// MakeSnow(TO,TB,BRS,TY,MY,XL,XH,ZL,ZH,SS) 
// TO  - TargetObject
// TB  - TotalBlobs; number of blobs to make
// BRS - BlobRandomSeed; 
// TY  - Target Height (for trace)
// MY  - Maximum Height (trace must interset object below this height)
// XL  - XLow value  __
// XH  - XHigh value __\_ Xrange
// ZL  - ZLow value  __
// ZH  - ZHigh value __\_ ZRange
// SS  - Sphere Size
// TNS - Translate Sphere - switch to lower blobs height by 20%

#macro MakeSnow(TO,TB,BRS,TY,MY,XL,XH,ZL,ZH,SS,TNS)
  #debug "Making snow blobs...\n"
  #local BRand1 = seed(BRS);
  #local BCount1 = 1;
  #local Working = true;
  #while(Working)
    #if(BCount1 >= TB) #local Working = false; #end    
    #local XTrans = XH - (XH-XL)*rand(BRand1);
    #local ZTrans = ZH - (ZH-ZL)*rand(BRand1);
    #local Norm = <0,0,0>;
    #local Inter = trace(TO, <XTrans, TY, ZTrans>, <0,-TY,0>, Norm);
    #local BlobTrans = <XTrans,Inter.y,ZTrans>;
    #if(vlength(Norm)!=0 & Inter.y <= MY)
      #debug "."
      sphere{
        0,SS,1
        scale<1,0.5,1>
        transform{Reorient_Trans(y, Norm)}
        translate BlobTrans
        #if(TNS)
          translate <0,-(SS/5),0>
        #end
      }
      #local BCount1 = BCount1 + 1;
    #end
  #end
#end

//////////////////////////////////////////////////////////////////////////
// LetitSnow macro by Ken Allred... derived from MakeSnow by Tom Kissmeyer
// LetitSnow(TF,FRS,XL,XH,YL,YH,ZL,ZH)
// TF  - TotalFlakes; number of snow flakes to make
// FRS - FlakeRandomSeed; 
// XL  - XLow value  __
// XH  - XHigh value __\_ Xrange  ---
// YL  - YLow value  __               \
// YH  - YHigh value __\_ YRange     Box to fill with snow flakes
// ZL  - ZLow value  __               /
// ZH  - ZHigh value __\_ ZRange  ---

#macro LetitSnow(TF,FRS,XL,XH,YL,YH,ZL,ZH)
  #debug "Snowing...\n"
  #local FRand1 = seed(FRS);
  #local FCount1 = 1;
  #local Working = true;
  #while(Working)
    #if(FCount1 >= TF) #local Working = false; #end    
    #local XTrans = XH - (XH-XL)*rand(FRand1);
    #local YTrans = YH - (YH-YL)*rand(FRand1);
    #local ZTrans = ZH - (ZH-ZL)*rand(FRand1);
    #local FlakeTrans = <XTrans,YTrans,ZTrans>;
    box{ <0,0,0> <0.0015,0.0015,0.0015> rotate <90*rand(FRand1),90*rand(FRand1),0>
      texture { t_snow finish{ specular 0.6 roughness 0.1 diffuse 0.65}} translate FlakeTrans}
    #local FCount1 = FCount1 + 1;
  #end
#end


////////////////////////////////////////////
//////////// CROSSSTICH PICTURE ////////////
////////////////////////////////////////////

#declare t_frame =
     texture{ pigment {VeryDarkBrown}
            normal {            // Copy of WoodGrain6A pigment
            wood 0.4
            turbulence <0.05, 0.08, 1>
            octaves 4
            scale <0.015, .015, .01>
            translate -x*10
        }
                finish { ambient 0 diffuse 0.4 roughness 0.1 specular 0.1}
     } 

#declare crossstich = union{
  box{<0,0,0.005> <1,1,.02> 
    pigment { image_map { png "CrossStich.png" map_type 0 interpolate 2}}
    finish { ambient 0 diffuse 1.2 specular 0.1}
  }


box{<0,0,0> <1,1,.004>
  texture {
     pigment { color rgbf<1.0, 1.0, 1.0, 1.0> }
     finish { specular 0.4 roughness 0.002 ambient 0
     diffuse 0.1  reflection { 0.05, 0.5}
    conserve_energy
     }
  } 
}

difference{
  union{
    cylinder{<-0.060,1.030,0.015> <1.060,1.030,0.015> 0.031 texture{t_frame rotate z*91 scale 0.5}}    //top
    cylinder{<-0.060,-0.030,0.015> <1.060,-0.030,0.015> 0.031 texture{t_frame rotate z*91 scale 0.5}}  //bot
    cylinder{<1.030,-0.060,0.015> <1.030,1.060,0.015> 0.031 texture{t_frame rotate z*1 scale 0.5}}    //right
    cylinder{<-0.030,-0.060,0.015> <-0.030,1.060,0.015> 0.031 texture{t_frame rotate z*1 scale 0.5}}    //left
  }
  difference{
    box{<-0.1,1.030,-0.03> <1.1,1.1,0.05> texture{t_frame rotate z*91 scale 0.5}}
    cylinder{<-0.1,1.030,0.015> <1.1,1.030,0.015> 0.031 texture{t_frame rotate z*91 scale 0.5} scale <1,0.999,1>}    //top
  }
  difference{
    box{<-0.1,-0.030,-0.03> <1.1,-1.1,0.05> texture{t_frame rotate z*91 scale 0.5}}
    cylinder{<-0.1,-0.030,0.015> <1.1,-0.030,0.015> 0.031 texture{t_frame rotate z*91 scale 0.5} scale <1,0.999,1>}  //bot
  }
  difference{
    box{<1.030,-0.1,-0.1> <1.1,1.1,0.05> texture{t_frame rotate z*1 scale 0.5}}
    cylinder{<1.030,-0.1,0.015> <1.030,1.1,0.015> 0.031 texture{t_frame rotate z*1 scale 0.5} scale <0.999,1,1>}    //right
  }
  difference{
    box{<-0.1,-0.1,-0.03> <-0.030,1.1,0.05> texture{t_frame rotate z*1 scale 0.5}}
    cylinder{<-0.030,-0.1,0.015> <-0.030,1.1,0.015> 0.031 texture{t_frame rotate z*1 scale 0.5} scale <0.999,1,1>}    //left
  }
}

scale 36 }

////////////////////////////////////////////
/////////////// CHRISTMAS CARD /////////////
////////////////////////////////////////////
 
#declare xmascard = union{
  box{<0,0,0.0> <1,1,0.001> 
      pigment { image_map{ png "ChristmasCard.png" map_type 0 interpolate 2}}
      normal{ crackle 0.1 scale 0.01 }
      finish { ambient 0 diffuse 1.3 specular 0.3}
      scale <1,5/7,1> rotate x*10
  }
  box {<-0.001,0,0.001> <0.999,0.999,.002> pigment{White}
      finish { ambient 0 diffuse 0.60 specular 0.3} scale <1,5/7,1> rotate x*10}
  box {<1,1,0.004> <0,0,0.002> pigment{White}
      finish { ambient 0 diffuse 0.60 specular 0.3} scale <1,5/7,1>
      rotate x*349 translate <0,0,.260>
  }
scale 12}

////////////////////////////////
////// D O O R   K N O B ///////
////////////////////////////////

#declare t_doorknob = texture { pigment { rgb <0.55, 0.5, 0.45> }
                               finish {ambient 0 metallic diffuse 0.3 specular 0.5}}
#declare doorknob=
difference{
  union{
    sphere{ <0,0,0>,3 scale <1,0.4,1> texture { t_doorknob}} 
    lathe {
      linear_spline
      7,
      <1.8,0.9>, <1,1.6>, <1,3>, <1.4,3>, <2.5,3.2>, <2.5,3.6>, <0,3.6>
      texture { t_doorknob}
    }
    cylinder{<0,-1.1,0> <0,-1.0,0>, 1.5 texture { t_doorknob}}
  }
  box{<-0.08,0,0.5> <0.08,-1.2,-0.5> texture { t_doorknob}}
scale 1.1}

