#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "woods.inc"
#include "stones.inc"
#include "glass.inc"
#include "metals.inc"

global_settings {
  max_trace_level 6
  radiosity {
    pretrace_start 0.08
    pretrace_end   0.02
    count 200 
    nearest_count 5         
    error_bound 0.3
    recursion_limit 3
    low_error_factor .05
    gray_threshold 0.0
    minimum_reuse 0.01
    brightness 1
    adc_bailout 0.01/2
    normal on
    load_file "Christmas02radio.rca"
  }
}

#declare  Area_Lights       = true;
#local    UsePhotons        = false;
#local    ShowHouse         = true;
#local    Window_Glass      = true;
#local    Show_Xmas_Tree    = true;
#declare  uselights         = 2;     // 0= no lights, 1= lights off, 2= lights on
#local    ShowSnowMan       = true;
#local    Snowfall          = true;
#local    Do_SNowBlobs      = true;
#local    ShowPorchlight    = true;
#declare  PorchLightOn      = true;
#declare  PorchLightGlass   = true;
#declare  ShowFirePlace     = true;
#declare  FirePlaceLight    = false;
#declare  ShowLamppost      = true;
#declare  Do_Bushes         = true;
#local    Camera_View       = 3;

#include "Christmas02.inc"
#include "fireplace.inc"
#include "lamppost.inc"
#include "house.inc"
#include "porchlight.inc"
#include "snowbush.inc"
#include "snowbush2.inc"
#include "snowbush3.inc"
#include "snowbush4.inc"

#if(ShowSnowMan)
  #include "snowman.inc"
#end
#if(Show_Xmas_Tree)
  #include "lxtree.inc"
#end

//////////////////////////////////////////////
////// O U T D O O R   L I G H T I N G ///////
//////////////////////////////////////////////
sky_sphere {
    pigment {
        gradient y
        color_map {[0, 1  color Gray25 color Gray60]}
    }
}

//////////////////////////////////////////////
////////////// T E X T U R E S ///////////////
#declare t_snow =
texture{
  pigment{rgb <0.9,0.9,0.9>}
  finish{ambient 0 brilliance .7 diffuse 0.65 roughness 0.1}
  normal{
    average 2
    normal_map{
        [bozo 2 scale .05 turbulence 0.75]
        [bumps 0.4 scale 0.02]
        [bumps .40 scale 0.00001]
    }
  }
}

#declare t_concrete =
        texture { pigment { Gray95 }
                normal { bumps 0.2 scale 0.002 }
                finish { ambient 0 diffuse 0.3 roughness 0.1 }
        }

#declare t_exterior =
     texture{ pigment {SteelBlue}
            normal {            // Copy of WoodGrain6A pigment
            wood 0.4
            turbulence <0.05, 0.08, 1>
            octaves 4
            scale <0.015, .015, .01>
            translate -x*10
        }
                finish { ambient 0 diffuse 0.4 roughness 0.1 }
 
     }

#declare t_trim =
     texture{ pigment {CornflowerBlue}
            normal {            // Copy of WoodGrain6A pigment
            wood 0.4
            turbulence <0.05, 0.08, 1>
            octaves 4
            scale <0.003, .003, .001>
            translate -x*100
        }
                finish { ambient 0 diffuse 0.4 roughness 0.1 specular 0.1}
     } 
     
#declare t_interior =
        texture { pigment { NewTan }
                finish { ambient 0 diffuse 0.4}
        }
#declare t_ceiling =
        texture { pigment { NewTan }
                finish { ambient 0 diffuse 0.5}
        }
      
//////////////////////////////////////////////
//////////////// G R O U N D /////////////////
#declare Foundation =
  box {<1,0,2.5>,<9,.10,8.5> texture{ t_concrete }}

#declare rsole =
intersection{
  box{<-1,0.01,-1> <1,1,1>}
  height_field {
    gif "R_sole_map.gif"
    smooth
    translate <0, 0, 0>
  }
  scale <.18, .0065, .18>
  rotate <0,0,180>
  texture{ t_snow }
}  

#declare rshoe =
union{
  object{rsole}
  object{rsole translate y*0.004}
  object{rsole translate y*0.008}
  object{rsole translate y*0.012}
  object{rsole translate y*0.016}
}

#declare lsole =
intersection{
  box{<-1,0.01,-1> <1,1,1>}
  height_field {
    gif "L_sole_map.gif"
    smooth
    translate <0, 0, 0>
  }
  scale <.18, .0065, .18>
  rotate <0,0,180>
  texture{ t_snow }
}  
#declare lshoe =
union{
  object{lsole}
  object{lsole translate y*0.004}
  object{lsole translate y*0.008}
  object{lsole translate y*0.012}
  object{lsole translate y*0.016}
}

#declare Steps =
difference{
  union{
    box {<5.57,0.00,1.9>,<6.13,0.05,2.5> texture{ t_concrete }}   //Steps
    box {<5.57,0.050,1.9>,<6.13,0.054,2.5> texture{ t_snow }}
    box {<5.57,0.00,2.15>,<6.13,0.10,2.5> texture{ t_concrete }}
    box {<5.57,0.10,2.15>,<6.13,0.104,2.5> texture{ t_snow }}
  }
  object{lshoe translate <5.8,0.106,2.2> texture{ t_snow }}
  object{lshoe rotate y*-15 translate <5.75,0.106,2.24> texture{ t_snow }}
  object{rshoe translate <5.9,0.106,2.2> texture{ t_snow }}
  object{rshoe rotate y*-10 translate <5.9,0.106,2.1> texture{ t_snow }}
  object{lshoe translate <5.82,0.056,1.92> texture{ t_snow }}
  object{rshoe rotate y*5 translate <5.9,0.056,1.90> texture{ t_snow }}
}

#declare Ground =

// snowy ground level =  0.02
// sidewalk level     =  0.00
// street level       = -0.06

union{
  plane { y, -0.06 texture {t_snow}}
  difference {
    box {<0,-0.06,0>,<20,.02,10> texture {t_snow}}        // snowy yard
    box {<5.55,0.00,-0.01>,<6.15,0.021,2.5> texture {t_snow}}  // cleared walkway
    object{rshoe rotate y*8 translate <5.92,0.003,1.65> texture{ t_snow }}
    object{lshoe translate <5.82,0.003,1.50> texture{ t_snow }}
    object{rshoe translate <5.93,0.003,1.35> texture{ t_snow }}
  }
  box {<0,-0.06,-0.6>,<20,0,0.001> texture {t_snow}}  // sidewalk n
  box {<0,-0.06,-4.6>,<20,0,-4> texture {t_snow}}  // sidewalk  s
  box {<0,-0.06,-14.5>,<20,.02,-4.5> texture {t_snow}}        // snowy yard across street


  object{Foundation}
  object{Steps}
}

difference{
#if(Do_SNowBlobs)
  union{
    object{Ground}
          //                 , BRS , TY , MY , XL , XH , ZL , ZH , SS
    blob{ MakeSnow(Ground,250,12345,0.10,0.06,3.50,5.60,2.45,2.55,0.10,1)  // Foundation
          texture{t_snow}} 
    blob{ MakeSnow(Ground,50 ,12345,0.18,0.05,5.52,5.55,1.86,2.50,0.10,1)  // Steps
          texture{t_snow}} 
    blob{ MakeSnow(Ground,150 ,12345,0.18,0.05,5.53,5.56,0.90,1.90,0.05,1) // Walkway
          texture{t_snow}} 
  }
#else
  object{Ground}
#end

//object{rshoe scale 0.8 rotate y*-90 translate <5.60,0.018,1.88> texture{ t_snow }}
//object{lshoe scale 0.8 rotate y*-100 translate <5.52,0.018,1.80> texture{ t_snow }}
}

//////////////////////////////////////////////
//////////////// H O U S E ///////////////////
//house front
#if(ShowHouse)
  #declare HfRand = seed(12345); // rand(HfRand)
  #declare house_front =
  union{
    difference{
      union{
        box {<1,0.10,2.500>,<9,1.55,2.541> texture{ t_exterior }}  // total wall thickness = 0.08
        box {<1,0.10,2.540>,<9,1.55,2.580> texture{ t_interior }}
        #declare board = box {<-0.06,0.10,2.49>,<0.06,1.55,2.501>}
        #declare bp = 1.06;
        #while (bp<9)
          object{board texture{ t_exterior translate <rand(HfRand),rand(HfRand),0>} translate x*bp}      // siding
          #declare bp = bp+ 0.128;
        #end
      }
      box {<5.55,0.09,2.40>,<6.15,1.2,2.7> texture{ t_exterior }} // door cutout
      box {<3.85,0.5,2.40>,<5.05,1.2,2.7> texture{ t_exterior }}  // window cutout
    }
    box {<5.55,1.18,2.48>,<6.15,1.22,2.58> texture { t_trim rotate z*90}}   // door frame top
    box {<5.55,1.17,2.50>,<6.15,1.18,2.51> texture { t_trim rotate z*90}}  // door jam top
    box {<5.53,0.10,2.48>,<5.57,1.22,2.58> texture { t_trim }}   // door frame left
    box {<5.57,0.10,2.50>,<5.58,1.22,2.51> texture { t_trim }}  // door jam left
    box {<6.13,0.10,2.48>,<6.17,1.22,2.58> texture { t_trim }}   // door frame right
    box {<6.12,0.10,2.50>,<6.13,1.22,2.51> texture { t_trim }}  // door jam right
    box {<5.57,0.11,2.51>,<6.13,1.28,2.55> texture { pigment { color SteelBlue }finish { ambient 0 }}} // door
    object{doorknob rotate <90,0,0> scale 0.007 translate <5.62,0.6,2.48>}
    box {<5.55,0.10,2.48>,<6.15,0.11,2.6> texture { t_trim rotate z*90}}   // threshold
    box {<3.849,1.18,2.49>,<5.051,1.201,2.58>texture { t_trim rotate z*90}} //window frame top
    box {<3.849,0.499,2.49>,<5.051,0.52,2.58>texture { t_trim rotate z*90}} //window frame bottom
    box {<3.849,0.519,2.49>,<3.87,1.19,2.58>texture { t_trim}} //window frame left
    box {<5.03,0.519,2.49>,<5.051,1.19,2.58>texture { t_trim}} //window frame right
    box {<4.44,0.519,2.55>,<4.46,1.19,2.56> texture { t_trim}}  // window center
    #if(Window_Glass)
      box {<3.85,0.50,2.553>,<4.44,1.20,2.557> texture { pigment { color Clear } finish { F_Glass1 }}} // left pane
      box {<4.46,0.50,2.553>,<5.05,1.20,2.557> texture { pigment { color Clear } finish { F_Glass1 }}}  // right pane
    #end
  }
  object{ house_front }
  
  //side wall
  #declare house_lside =
  union{
    box {<1,0.10,2.5>,<1.05,1.51,8.5> texture{ t_exterior }}
    box {<1.5,0.10,2.55>,<1.15,1.51,8.5> texture{ t_interior }}
  }
  object{ house_lside}
  #declare house_back =
  union{
    box {<1,0.10,8.45>,<9,1.51,8.5> texture{ t_exterior }}
    box {<1,0.10,8.40>,<9,1.51,8.45> texture{ t_interior }}
  }
  object{ house_back}
  //interior walls
  box {<3,0.10,2.6>,<3.05,1.51,4.4> texture{ t_interior } photons{ target refraction on reflection on}}
  box {<6.3,0.10,2.6>,<6.35,1.51,5.05> texture{ t_interior } photons{ target refraction on reflection on}} // living room e wall
  box {<1,1.5,2.5>,<9,1.6,8.5> texture{ t_ceiling }} //ceiling
  #if(ShowFirePlace)
    union{
      difference{
        box {<3,0.10,5.0>,<6.36,1.51,5.05> texture{ t_interior }} // living room S wall
        box {<4,0,4.9>,<4.8,0.8,5.1> texture{ t_interior }} // fireplace cutout
        }
      object{fireplace scale .007 translate <3.85,0.1,4.71>} // fireplace
    }
    //mantle
    object{crossstich  rotate x*-1 scale .007 translate <4.25,1.1,4.99>}
    object{xmascard rotate y*9 scale .008 translate <4.10,0.94,4.92>}
  #else
    box {<3,0.10,5.0>,<6.36,1.51,5.05> texture{ t_interior }} // living room S wall
  #end
  //indoor lights
  #local t_plbulb1 = texture {pigment { rgbt <1,1,1,1> } finish { specular 1.8 roughness 0.5}}
  #if(Area_Lights)
    light_source { <6.0,1.45,4.0> color rgb <0.70,0.70,0.65>
      area_light <.1, 0, 0>, <0, 0, .1>, 3, 3
      fade_distance 3 fade_power 2 adaptive 1 jitter}
    light_source { <2.5,1.45,4.7> color rgb <0.7,0.7,0.65>
      looks_like { sphere {<2.5,1.45,4.7>, .2 texture{t_plbulb1} scale .11 }}
      area_light <.1, 0, 0>, <0, 0, .1>, 3, 3
      fade_distance 3 fade_power 2 adaptive 1 jitter}
  #else
    light_source { <6.0,1.45,4.0> color rgb <0.70,0.70,0.65> 
      fade_distance 3 fade_power 2}
    light_source { <2.5,1.45,4.7> color rgb <0.70,0.70,0.65>
      looks_like { sphere {<2.5,1.45,4.7>, .2 texture{t_plbulb1} scale .11 }}
      fade_distance 3 fade_power 2}
  #end
  //porch light
  #if(ShowPorchlight)
    object{PorchLight scale .13 translate <5.30,1.03,2.42>}
  #end
#end
//////////////////////////////////////////////
//////////////// T R E E /////////////////////
// tree decorations

#declare prism_thing =
  prism {
    conic_sweep
    linear_spline 0,1,5,<4,4>,<-4,4>,<-4,-4>,<4,-4>,<4,4>
    scale <0.004, .1, 0.005> texture { Tinny_Brass finish{ambient .2}}
  }
#declare StarOrnament =
merge{
object {prism_thing rotate <180, 45, 90> translate <-.1, 1.23, 0>}  //left
object {prism_thing rotate <180, 45, -90> translate <.1, 1.23, 0>} //right
object {prism_thing rotate <180, 45, 0> translate <0, 1.33, 0>} //top
object {prism_thing rotate <0, 45, 0> translate <0, 1.13, 0> } //bottom
}
#if(Show_Xmas_Tree)
  #declare Xmas_tree =
  union{
    object{StarOrnament  scale .7 rotate y*60 translate y*0.35 }
    object{lxtree scale .038} 
  }
#end

//////////////////////////////////////////////
//////////////// the neighbor ////////////////
object{basic_house scale 0.20 rotate y*180 translate <10.5,0,-10>}

//////////////////////////////////////////////
//////////////// the bushes ////////////////

#if(Do_Bushes)
  #declare bushes =
    union{
      object{snowybush4  scale .008 translate <4.0,0.02,2.4>}
      object{snowybush  scale .008 translate <4.4,0.02,2.4>}
      object{snowybush2  scale .008 translate <4.7,0.02,2.4>}
      object{snowybush3  scale .008 translate <5.1,0.02,2.4>}
    }
  #declare snowybushes=
    union{
     object{bushes}
     blob{ MakeSnow(bushes,2500 ,54321,0.5,0.5,3.9,5.4,2.1,2.5,0.0015,0) texture{t_snow}}
    }
  object{snowybushes}
#end
//////////////////////////////////////////////
//////////////// C A M E R A  ////////////////

#switch(Camera_View)
  #case(1)
    camera {
      location <5.2, 0.6, -1.2>
      look_at <3.40, 0.3, 5>
    }
    #if(ShowLamppost)
      object { Lamppost scale 0.01 translate <6.25, 0.3, -4.05> }
    #end
    #if(Snowfall)
      LetitSnow(25000,12345,0.5,6.00,0.01,1.5,1.0,2.50)
    #end
    #if(ShowSnowMan)
      object {SnowMan rotate <0,0,0> translate <4.2, 0, 1.2>}
    #end
    #if(Show_Xmas_Tree)
      object{Xmas_tree translate <3.95,0.10,3.5> }
    #end
  #break
  #case(2)
    camera {
      location <5.0, .7, 0.5>
      look_at <5.00, .4, 3>
    }
    #if(ShowLamppost)
      object { Lamppost scale 0.01 translate <6.25, 0.3, -4.05> }
    #end
    #if(Snowfall)
      LetitSnow(25000,12345,0.5,6.00,0.01,1.5,1.0,2.50)
    #end
    #if(ShowSnowMan)
      object {SnowMan rotate <0,-20,0> translate <5.0, 0, 1.8>}
    #end
    #if(Show_Xmas_Tree)
      object{Xmas_tree translate <3.95,0.10,3.5> }
    #end
  #break
  #case(3)
    camera {
      location <4.5, .5, 0.6>
      look_at <5.04, .4, 3>
    }
    #if(ShowLamppost)
      object { Lamppost scale 0.01 translate <6.25, 0.3, -4.05> }
    #end
    #if(Snowfall)
      LetitSnow(20000,12345,0.5,6.00,0.01,1.5,1.2,2.45)
    #end
    #if(ShowSnowMan)
      object {SnowMan translate <4.9, 0, 1.8>}
    #end
    #if(Show_Xmas_Tree)
      object{Xmas_tree translate <3.85,0.10,3.5>}
    #end
  #break
  #case(4)

camera { location <5.2, .7, 1.0> look_at <5.5,0.05,2.2>}

//    camera {
//      location <5.0,1.2,4.0> // inside living room   --- cs03
//      look_at <4.2, 1.2, 4.95> // ... looking at fireplace  ---cs03

//      location <4.0,1.10,4.4> // inside living room
//     look_at <4.45, 0.8, 1.8> // ... looking out the window
//      look_at <4.05,0.94,4.93> // ... looking at fireplace


//box {<5.55,1.18,2.48>,<6.15,1.22,2.58> texture { t_trim finish { ambient 0 }}}   // door frame top

//      look_at <5.3,1.6,2.8> // light
// in street - lamppost & house view
//    location <-4.0, 2.6, -1.5> 
//      look_at <6, .5, -1.0> 


//      location <5.6, 1.0, 2.25>
//      look_at <5.58,0.6,2.49>
//    }




// camera icon & look-at path
//box { <4.45,0.45,0.55> <4.55,0.55,0.65> pigment{color Black} finish { ambient 0}}
//cylinder {<4.5,0.5,0.6>,<5.04,0.4,3>,.01 pigment{color Red} finish { ambient .5}}
//cylinder {<4.9, 0, 1.8>,<4.9, .6, 1.8>, 0.1 pigment{color White} finish { ambient .1}}


// object { Lamppost scale 0.01 translate <6.5, 0, -4.05> }   //lamppost_test01
// object { Lamppost scale 0.01 translate <7.0, 0, -4.05> }   //lamppost_test02
// object { Lamppost scale 0.01 translate <5.5, 0.5, -4.05> } //lamppost_test03

    #if(ShowLamppost)
      object { Lamppost scale 0.01 translate <6.25, 0.3, -4.05> }
    #end
    #if(Snowfall)
      LetitSnow(25000,12345,0.5,6.00,0.01,1.5,1.0,2.50)
    #end
    #if(ShowSnowMan)
      object {SnowMan translate <4.9, 0, 1.8>}
    #end
    #if(Show_Xmas_Tree)
      object{Xmas_tree translate <3.95,0.10,3.5> }
    #end
  #break
  #case(5)
    camera {
      location <5.85,1.075, 2.40>
      look_at <5.30,1.075,2.45>    //porchlight
    }
  #break
  #else
    camera {
      location <5.8,0.6,2.55> // standing in front doorway ... looking at fireplace
      look_at <4.3,.3,5>
    }
    #if(Snowfall)
      LetitSnow(25000,12345,0.5,6.00,0.01,1.5,1.0,2.50)
    #end
    #if(ShowSnowMan)
      object {SnowMan translate <4.9, 0, 1.8>}
    #end
    #if(Show_Xmas_Tree)
      object{Xmas_tree translate <3.95,0.10,3.5> }
    #end
#end
