#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"


#local colBark=rgb <1,0.8,0.64>; // light brown, white
#local txttree=
texture{pigment{gradient y turbulence 0.7 lambda 4 color_map{[0 color colBark*.3] [0.1 color colBark][0.9 color colBark][1 color colBark*.4]}} finish{ambient 0}}
texture{pigment{bozo turbulence 0.7 lambda 4 color_map{[0 color colBark*.2][0.1 color colBark*.3] [0.3 color colBark*.4][0.4 color Clear][0.9 color Clear][1 color colBark*.4] }}finish{ambient 0}}                 
texture{
  pigment{rgbft <0.9,0.9,0.9,.4>}
  finish{ambient 0 brilliance .7 diffuse 0.65 roughness 0.1}
  normal{
    average 2
    normal_map{
        [bozo 2 scale .5 turbulence 0.75]
        [bumps 0.4 scale 0.02]
        [bumps .40 scale 0.00001]
    }
  }
}

#declare snowybush =
union{
  union{
    cone{<0,0,0> ,1,<-0.047281,0.5,0.0706476> ,0.96}
    sphere{<0,0,0> ,1}
    texture{txttree matrix <0.995559,0.094142,0,-0.0932242,0.985853,0.139296,0.0131136,-0.138678,0.990251,0,0,0> }
  }
  union{
    cone{<-0.047281,0.5,0.0706476> ,0.96,<-0.145899,0.772805,0.0011797> ,0.92}
    sphere{<-0.047281,0.5,0.0706476> ,0.96}
    texture{txttree matrix <0.940438,0.339964,0,-0.330616,0.914579,-0.232891,-0.0791746,0.21902,0.972503,-0.047281,0.5,0.0706476> }
    }
union{cone{<-0.145899,0.772805,0.0011797> ,0.92,<-0.0841811,1.04456,-0.0957038> ,0.88}
sphere{<-0.145899,0.772805,0.0011797> ,0.92}
texture{txttree matrix <0.975168,-0.221467,0,0.209186,0.921091,-0.328378,0.0727251,0.320224,0.944546,-0.145899,0.772805,0.0011797> }}
union{cone{<-0.0841811,1.04456,-0.0957038> ,0.88,<-0.0544844,1.34053,-0.0561425> ,0.84}
sphere{<-0.0841811,1.04456,-0.0957038> ,0.88}
texture{txttree matrix <0.995004,-0.0998372,0,0.0989657,0.986318,0.131839,-0.0131625,-0.131181,0.991271,-0.0841811,1.04456,-0.0957038> }}
union{cone{<-0.0544844,1.34053,-0.0561425> ,0.84,<-0.0591149,1.63457,-0.0412319> ,0.8}
sphere{<-0.0544844,1.34053,-0.0561425> ,0.84}
texture{txttree matrix <0.999876,0.0157459,0,-0.0157257,0.998593,0.0506376,0.000797332,-0.0506313,0.998717,-0.0544844,1.34053,-0.0561425> }}
union{cone{<-0.0591149,1.63457,-0.0412319> ,0.8,<-0.102077,1.8832,-0.17592> ,0.76}
sphere{<-0.0591149,1.63457,-0.0412319> ,0.8}
texture{txttree matrix <0.985397,0.170272,0,-0.15021,0.869294,-0.470919,-0.0801845,0.464042,0.882177,-0.0591149,1.63457,-0.0412319> }}
union{cone{<-0.102077,1.8832,-0.17592> ,0.76,<-0.182359,2.16848,-0.246071> ,0.72}
sphere{<-0.102077,1.8832,-0.17592> ,0.76}
texture{txttree matrix <0.96261,0.270891,0,-0.263607,0.936725,-0.230341,-0.0623973,0.221728,0.97311,-0.102077,1.8832,-0.17592> }}
union{cone{<-0.182359,2.16848,-0.246071> ,0.72,<-0.128284,2.43235,-0.381358> ,0.68}
sphere{<-0.182359,2.16848,-0.246071> ,0.72}
texture{txttree matrix <0.97964,-0.200761,0,0.179403,0.875419,-0.44884,0.0901096,0.439701,0.893612,-0.182359,2.16848,-0.246071> }}
union{cone{<-0.128284,2.43235,-0.381358> ,0.68,<-0.166639,2.69054,-0.530213> ,0.64}
sphere{<-0.128284,2.43235,-0.381358> ,0.68}
texture{txttree matrix <0.989146,0.146937,0,-0.127641,0.859248,-0.495379,-0.0727896,0.490002,0.868677,-0.128284,2.43235,-0.381358> }}
union{cone{<-0.166639,2.69054,-0.530213> ,0.64,<-0.187127,2.94422,-0.690388> ,0.6}
sphere{<-0.166639,2.69054,-0.530213> ,0.64}
texture{txttree matrix <0.996754,0.0805014,0,-0.0681312,0.843588,-0.532651,-0.0428792,0.530922,0.846335,-0.166639,2.69054,-0.530213> }}
union{cone{<-0.187127,2.94422,-0.690388> ,0.6,<-0.281499,3.0457,-0.186704> ,0.573333}
sphere{<-0.187127,2.94422,-0.690388> ,0.6}
texture{txttree matrix <0.732284,0.680999,0,-0.18065,0.194255,0.964174,0.656601,-0.706049,0.265272,-0.187127,2.94422,-0.690388> }}
union{cone{<-0.281499,3.0457,-0.186704> ,0.573333,<-0.372778,3.46913,0.124628> ,0.546667}
sphere{<-0.281499,3.0457,-0.186704> ,0.573333}
texture{txttree matrix <0.977544,0.21073,0,-0.171116,0.793784,0.583632,0.122989,-0.570527,0.812018,-0.281499,3.0457,-0.186704> }}
union{cone{<-0.372778,3.46913,0.124628> ,0.546667,<-0.499446,3.91187,0.3603> ,0.52}
sphere{<-0.372778,3.46913,0.124628> ,0.546667}
texture{txttree matrix <0.961427,0.27506,0,-0.244858,0.855861,0.455574,0.12531,-0.438001,0.890198,-0.372778,3.46913,0.124628> }}
union{cone{<-0.499446,3.91187,0.3603> ,0.52,<-0.680875,4.25784,0.704493> ,0.493333}
sphere{<-0.499446,3.91187,0.3603> ,0.52}
texture{txttree matrix <0.885609,0.464431,0,-0.348468,0.664482,0.661086,0.307029,-0.585464,0.75031,-0.499446,3.91187,0.3603> }}
union{cone{<-0.680875,4.25784,0.704493> ,0.493333,<-0.651649,4.55438,1.16281> ,0.466667}
sphere{<-0.680875,4.25784,0.704493> ,0.493333}
texture{txttree matrix <0.995179,-0.098078,0,0.0534612,0.542461,0.838378,-0.0822264,-0.834336,0.545089,-0.680875,4.25784,0.704493> }}
union{cone{<-0.651649,4.55438,1.16281> ,0.466667,<-0.769234,5.04827,1.35887> ,0.44}
sphere{<-0.651649,4.55438,1.16281> ,0.466667}
texture{txttree matrix <0.972809,0.231607,0,-0.216055,0.907487,0.360259,0.0834386,-0.350464,0.932852,-0.651649,4.55438,1.16281> }}
union{cone{<-0.769234,5.04827,1.35887> ,0.44,<-0.925763,5.49253,1.64966> ,0.413333}
sphere{<-0.769234,5.04827,1.35887> ,0.44}
texture{txttree matrix <0.94317,0.332311,0,-0.282767,0.802555,0.525307,0.174565,-0.495454,0.850913,-0.769234,5.04827,1.35887> }}
union{cone{<-0.925763,5.49253,1.64966> ,0.413333,<-1.06161,5.95271,1.93053> ,0.386667}
sphere{<-0.925763,5.49253,1.64966> ,0.413333}
texture{txttree matrix <0.959086,0.283116,0,-0.244333,0.827703,0.505183,0.143025,-0.484514,0.863012,-0.925763,5.49253,1.64966> }}
union{cone{<-1.06161,5.95271,1.93053> ,0.386667,<-0.979973,6.46807,1.94651> ,0.36}
sphere{<-1.06161,5.95271,1.93053> ,0.386667}
texture{txttree matrix <0.987686,-0.156451,0,0.156378,0.987223,0.0306002,-0.00478745,-0.0302234,0.999532,-1.06161,5.95271,1.93053> }}
union{cone{<-0.979973,6.46807,1.94651> ,0.36,<-0.529284,6.72259,2.72426> ,0.342}
sphere{<-0.979973,6.46807,1.94651> ,0.36}
texture{txttree matrix <0.491742,-0.870741,0,0.482414,0.272439,0.832498,-0.72489,-0.409374,0.554028,-0.979973,6.46807,1.94651> }}
union{cone{<-0.529284,6.72259,2.72426> ,0.342,<-0.608642,7.52852,3.2509> ,0.324}
sphere{<-0.529284,6.72259,2.72426> ,0.342}
texture{txttree matrix <0.995187,0.0979926,0,-0.0821493,0.834286,0.545177,0.0534233,-0.542553,0.838321,-0.529284,6.72259,2.72426> }}
union{cone{<-0.608642,7.52852,3.2509> ,0.324,<-0.792678,8.01742,4.02312> ,0.306}
sphere{<-0.608642,7.52852,3.2509> ,0.324}
texture{txttree matrix <0.935889,0.352295,0,-0.197398,0.524397,0.828276,0.291798,-0.775174,0.56032,-0.608642,7.52852,3.2509> }}
union{cone{<-0.792678,8.01742,4.02312> ,0.306,<-0.908946,8.88407,4.50608> ,0.288}
sphere{<-0.792678,8.01742,4.02312> ,0.306}
texture{txttree matrix <0.99112,0.132967,0,-0.116393,0.867579,0.483486,0.0642877,-0.479193,0.875352,-0.792678,8.01742,4.02312> }}
union{cone{<-0.908946,8.88407,4.50608> ,0.288,<-0.722851,9.51594,5.21462> ,0.27}
sphere{<-0.908946,8.88407,4.50608> ,0.288}
texture{txttree matrix <0.959263,-0.282515,0,0.19236,0.653147,0.732391,-0.206912,-0.702555,0.680884,-0.908946,8.88407,4.50608> }}
union{cone{<-0.722851,9.51594,5.21462> ,0.27,<-0.803227,10.4906,5.44714> ,0.252}
sphere{<-0.722851,9.51594,5.21462> ,0.27}
texture{txttree matrix <0.996617,0.0821859,0,-0.079957,0.969588,0.231313,0.0190107,-0.230531,0.972879,-0.722851,9.51594,5.21462> }}
union{cone{<-0.803227,10.4906,5.44714> ,0.252,<-0.396743,11.3026,5.60884> ,0.234}
sphere{<-0.803227,10.4906,5.44714> ,0.252}
texture{txttree matrix <0.894221,-0.447625,0,0.440693,0.880373,0.175307,-0.078472,-0.156764,0.984514,-0.803227,10.4906,5.44714> }}
union{cone{<-0.396743,11.3026,5.60884> ,0.234,<-0.491076,12.1851,5.92622> ,0.216}
sphere{<-0.396743,11.3026,5.60884> ,0.234}
texture{txttree matrix <0.994335,0.106294,0,-0.100086,0.936267,0.33673,0.0357924,-0.334823,0.941601,-0.396743,11.3026,5.60884> }}
union{cone{<-0.491076,12.1851,5.92622> ,0.216,<-0.88928,12.8882,7.41763> ,0.203657}
sphere{<-0.491076,12.1851,5.92622> ,0.216}
texture{txttree matrix <0.870141,0.492802,0,-0.234756,0.414508,0.879246,0.433294,-0.765068,0.476369,-0.491076,12.1851,5.92622> }}
union{cone{<-0.88928,12.8882,7.41763> ,0.203657,<-1.21164,14.3461,8.25976> ,0.191314}
sphere{<-0.88928,12.8882,7.41763> ,0.203657}
texture{txttree matrix <0.976414,0.215906,0,-0.188056,0.850466,0.491266,0.106067,-0.479679,0.87101,-0.88928,12.8882,7.41763> }}
union{cone{<-1.21164,14.3461,8.25976> ,0.191314,<-0.889575,15.9649,9.0302> ,0.178971}
sphere{<-1.21164,14.3461,8.25976> ,0.191314}
texture{txttree matrix <0.980777,-0.19513,0,0.176815,0.888725,0.422972,-0.0825343,-0.414841,0.906143,-1.21164,14.3461,8.25976> }}
union{cone{<-0.889575,15.9649,9.0302> ,0.178971,<-0.782196,17.4844,10.0553> ,0.166629}
sphere{<-0.889575,15.9649,9.0302> ,0.178971}
texture{txttree matrix <0.997512,-0.0704911,0,0.0584823,0.827577,0.558297,-0.039355,-0.556908,0.829641,-0.889575,15.9649,9.0302> }}
union{cone{<-0.782196,17.4844,10.0553> ,0.166629,<-0.662492,18.7927,11.1266> ,0.154286}
sphere{<-0.782196,17.4844,10.0553> ,0.166629}
texture{txttree matrix <0.99584,-0.0911169,0,0.0706146,0.771766,0.631974,-0.0575835,-0.629345,0.77499,-0.782196,17.4844,10.0553> }}
union{cone{<-0.662492,18.7927,11.1266> ,0.154286,<-0.36454,20.2573,12.0942> ,0.141943}
sphere{<-0.662492,18.7927,11.1266> ,0.154286}
texture{txttree matrix <0.979929,-0.199347,0,0.167343,0.822609,0.543424,-0.10833,-0.532517,0.839458,-0.662492,18.7927,11.1266> }}
union{cone{<-0.36454,20.2573,12.0942> ,0.141943,<-0.357378,22.0444,11.9087> ,0.1296}
sphere{<-0.36454,20.2573,12.0942> ,0.141943}
texture{txttree matrix <0.999992,-0.0040074,0,0.00398599,0.99465,-0.103227,0.000413674,0.103227,0.994658,-0.36454,20.2573,12.0942> }}
union{cone{<-0.357378,22.0444,11.9087> ,0.1296,<0.801282,24.8533,13.2948> ,0.12096}
sphere{<-0.357378,22.0444,11.9087> ,0.1296}
texture{txttree matrix <0.924442,-0.381322,0,0.346928,0.841062,0.415037,-0.158263,-0.383678,0.909804,-0.357378,22.0444,11.9087> }}
union{cone{<0.801282,24.8533,13.2948> ,0.12096,<1.03456,27.9682,12.5165> ,0.11232}
sphere{<0.801282,24.8533,13.2948> ,0.12096}
texture{txttree matrix <0.997207,-0.074682,0,0.0724663,0.967622,-0.241777,0.0180564,0.241101,0.970332,0.801282,24.8533,13.2948> }}
union{cone{<1.03456,27.9682,12.5165> ,0.11232,<1.72019,30.9196,13.243> ,0.10368}
sphere{<1.03456,27.9682,12.5165> ,0.11232}
texture{txttree matrix <0.974061,-0.226286,0,0.220049,0.947215,0.233158,-0.0527604,-0.22711,0.972439,1.03456,27.9682,12.5165> }}
union{cone{<1.72019,30.9196,13.243> ,0.10368,<2.34892,33.9679,12.1411> ,0.09504}
sphere{<1.72019,30.9196,13.243> ,0.10368}
texture{txttree matrix <0.979385,-0.202003,0,0.190422,0.923237,-0.333725,0.0674133,0.326845,0.942671,1.72019,30.9196,13.243> }}
union{cone{<2.34892,33.9679,12.1411> ,0.09504,<2.95687,37.1627,12.1492> ,0.0864}
sphere{<2.34892,33.9679,12.1411> ,0.09504}
texture{txttree matrix <0.982372,-0.186938,0,0.186937,0.982369,0.00248328,-0.000464219,-0.00243951,0.999997,2.34892,33.9679,12.1411> }}
union{cone{<2.95687,37.1627,12.1492> ,0.0864,<3.58136,40.174,10.8763> ,0.07776}
sphere{<2.95687,37.1627,12.1492> ,0.0864}
texture{txttree matrix <0.979166,-0.203063,0,0.187626,0.904729,-0.382442,0.0776596,0.374474,0.92398,2.95687,37.1627,12.1492> }}
union{cone{<-0.85424,16.4649,9.36752> ,0.1296,<-0.0644898,18.8067,11.373> ,0.12096}
sphere{<-0.85424,16.4649,9.36752> ,0.1296}
texture{txttree matrix <0.947566,-0.319559,0,0.248136,0.735779,0.630126,-0.201363,-0.597086,0.776493,-0.85424,16.4649,9.36752> }}
union{cone{<-0.0644898,18.8067,11.373> ,0.12096,<0.0968455,21.1122,13.5147> ,0.11232}
sphere{<-0.0644898,18.8067,11.373> ,0.12096}
texture{txttree matrix <0.997561,-0.069807,0,0.0512034,0.731711,0.67969,-0.0474471,-0.678031,0.7335,-0.0644898,18.8067,11.373> }}
union{cone{<0.0968455,21.1122,13.5147> ,0.11232,<0.362046,24.098,15.0457> ,0.10368}
sphere{<0.0968455,21.1122,13.5147> ,0.11232}
texture{txttree matrix <0.996079,-0.0884734,0,0.0787908,0.887067,0.454868,-0.0402437,-0.453084,0.890559,0.0968455,21.1122,13.5147> }}
union{cone{<0.362046,24.098,15.0457> ,0.10368,<1.99578,26.7972,16.3348> ,0.09504}
sphere{<0.362046,24.098,15.0457> ,0.10368}
texture{txttree matrix <0.855501,-0.517801,0,0.479334,0.791948,0.378229,-0.195847,-0.323576,0.925712,0.362046,24.098,15.0457> }}
union{cone{<1.99578,26.7972,16.3348> ,0.09504,<3.78448,29.5474,16.3326> ,0.0864}
sphere{<1.99578,26.7972,16.3348> ,0.09504}
texture{txttree matrix <0.83829,-0.545224,0,0.545224,0.83829,-0.000692041,0.000377317,0.000580131,1,1.99578,26.7972,16.3348> }}
union{cone{<3.78448,29.5474,16.3326> ,0.0864,<5.21409,32.291,17.0447> ,0.07776}
sphere{<3.78448,29.5474,16.3326> ,0.0864}
texture{txttree matrix <0.886829,-0.462097,0,0.45032,0.864227,0.224331,-0.103663,-0.198943,0.974513,3.78448,29.5474,16.3326> }}
union{cone{<-1.13846,14.7139,8.43484> ,0.1296,<0.572957,17.1837,10.0698> ,0.12096}
sphere{<-1.13846,14.7139,8.43484> ,0.1296}
texture{txttree matrix <0.82195,-0.569559,0,0.500297,0.721995,0.477939,-0.272215,-0.392842,0.878393,-1.13846,14.7139,8.43484> }}
union{cone{<0.572957,17.1837,10.0698> ,0.12096,<2.33833,19.6809,10.7291> ,0.11232}
sphere{<0.572957,17.1837,10.0698> ,0.12096}
texture{txttree matrix <0.816554,-0.577269,0,0.564304,0.798215,0.210747,-0.121658,-0.172086,0.977541,0.572957,17.1837,10.0698> }}
union{cone{<2.33833,19.6809,10.7291> ,0.11232,<3.28504,22.8039,10.6898> ,0.10368}
sphere{<2.33833,19.6809,10.7291> ,0.11232}
texture{txttree matrix <0.956996,-0.290101,0,0.29008,0.956927,-0.012035,0.00349137,0.0115175,0.999928,2.33833,19.6809,10.7291> }}
union{cone{<3.28504,22.8039,10.6898> ,0.10368,<3.80512,25.938,9.55635> ,0.09504}
sphere{<3.28504,22.8039,10.6898> ,0.10368}
texture{txttree matrix <0.98651,-0.163702,0,0.154183,0.929147,-0.336026,0.0550082,0.331493,0.941853,3.28504,22.8039,10.6898> }}
union{cone{<3.80512,25.938,9.55635> ,0.09504,<4.86756,29.0145,8.62171> ,0.0864}
sphere{<3.80512,25.938,9.55635> ,0.09504}
texture{txttree matrix <0.945222,-0.326428,0,0.313748,0.908506,-0.276005,0.0900956,0.260886,0.961156,3.80512,25.938,9.55635> }}
union{cone{<4.86756,29.0145,8.62171> ,0.0864,<5.75777,31.8546,7.5945> ,0.07776}
sphere{<4.86756,29.0145,8.62171> ,0.0864}
texture{txttree matrix <0.954223,-0.299096,0,0.282731,0.902014,-0.326243,0.0975778,0.311309,0.945286,4.86756,29.0145,8.62171> }}
union{cone{<-0.807379,17.128,9.81488> ,0.1296,<-0.677425,19.8907,11.7367> ,0.12096}
sphere{<-0.807379,17.128,9.81488> ,0.1296}
texture{txttree matrix <0.998895,-0.0469875,0,0.0385865,0.820302,0.570628,-0.0268124,-0.569998,0.821209,-0.807379,17.128,9.81488> }}
union{cone{<-0.677425,19.8907,11.7367> ,0.12096,<-0.691263,22.7696,13.1393> ,0.11232}
sphere{<-0.677425,19.8907,11.7367> ,0.12096}
texture{txttree matrix <0.999988,0.00480673,0,-0.00432114,0.898966,0.437996,0.00210533,-0.437991,0.898977,-0.677425,19.8907,11.7367> }}
union{cone{<-0.691263,22.7696,13.1393> ,0.11232,<-0.834748,26.1202,13.523> ,0.10368}
sphere{<-0.691263,22.7696,13.1393> ,0.11232}
texture{txttree matrix <0.999084,0.0427842,0,-0.0425069,0.99261,0.113663,0.00486297,-0.113559,0.993519,-0.691263,22.7696,13.1393> }}
union{cone{<-0.834748,26.1202,13.523> ,0.10368,<-0.713931,29.3991,13.4768> ,0.09504}
sphere{<-0.834748,26.1202,13.523> ,0.10368}
texture{txttree matrix <0.999322,-0.0368222,0,0.0368185,0.999223,-0.0140854,0.000518654,0.0140758,0.999901,-0.834748,26.1202,13.523> }}
union{cone{<-0.713931,29.3991,13.4768> ,0.09504,<-1.59841,32.5653,12.5695> ,0.0864}
sphere{<-0.713931,29.3991,13.4768> ,0.09504}
texture{txttree matrix <0.963126,0.269051,0,-0.259354,0.928415,-0.266048,-0.0715804,0.256238,0.96396,-0.713931,29.3991,13.4768> }}
union{cone{<-1.59841,32.5653,12.5695> ,0.0864,<-2.20072,35.7171,11.3891> ,0.07776}
sphere{<-1.59841,32.5653,12.5695> ,0.0864}
texture{txttree matrix <0.982226,0.187701,0,-0.176162,0.921839,-0.345224,-0.064799,0.339088,0.93852,-1.59841,32.5653,12.5695> }}
union{cone{<-0.438382,11.6922,5.74893> ,0.216,<0.20784,13.2368,5.56018> ,0.203657}
sphere{<-0.438382,11.6922,5.74893> ,0.216}
texture{txttree matrix <0.922518,-0.385954,0,0.383525,0.916712,-0.112019,0.0432343,0.10334,0.993706,-0.438382,11.6922,5.74893> }}
union{cone{<0.20784,13.2368,5.56018> ,0.203657,<0.676558,14.9144,5.27162> ,0.191314}
sphere{<0.20784,13.2368,5.56018> ,0.203657}
texture{txttree matrix <0.963116,-0.269088,0,0.26547,0.950166,-0.163434,0.0439782,0.157406,0.986554,0.20784,13.2368,5.56018> }}
union{cone{<0.676558,14.9144,5.27162> ,0.191314,<0.924106,16.6733,5.38548> ,0.178971}
sphere{<0.676558,14.9144,5.27162> ,0.191314}
texture{txttree matrix <0.99024,-0.13937,0,0.139085,0.988212,0.0639704,-0.00891556,-0.0633461,0.997952,0.676558,14.9144,5.27162> }}
union{cone{<0.924106,16.6733,5.38548> ,0.178971,<1.08033,18.215,4.66452> ,0.166629}
sphere{<0.924106,16.6733,5.38548> ,0.178971}
texture{txttree matrix <0.994906,-0.100811,0,0.0914029,0.902061,-0.42182,0.0425239,0.419671,0.90668,0.924106,16.6733,5.38548> }}
union{cone{<1.08033,18.215,4.66452> ,0.166629,<1.45163,20.0114,4.52483> ,0.154286}
sphere{<1.08033,18.215,4.66452> ,0.166629}
texture{txttree matrix <0.979298,-0.202423,0,0.201839,0.976471,-0.0759347,0.015371,0.0743627,0.997113,1.08033,18.215,4.66452> }}
union{cone{<1.45163,20.0114,4.52483> ,0.154286,<1.91369,21.4774,3.52333> ,0.141943}
sphere{<1.45163,20.0114,4.52483> ,0.154286}
texture{txttree matrix <0.953751,-0.300599,0,0.251858,0.799103,-0.545895,0.164096,0.520648,0.837854,1.45163,20.0114,4.52483> }}
union{cone{<1.91369,21.4774,3.52333> ,0.141943,<1.99266,23.185,3.18621> ,0.1296}
sphere{<1.91369,21.4774,3.52333> ,0.141943}
texture{txttree matrix <0.998932,-0.0461953,0,0.0453223,0.980055,-0.19349,0.00893834,0.193284,0.981102,1.91369,21.4774,3.52333> }}
union{cone{<1.99266,23.185,3.18621> ,0.1296,<2.82023,26.1174,4.02626> ,0.12096}
sphere{<1.99266,23.185,3.18621> ,0.1296}
texture{txttree matrix <0.962408,-0.271608,0,0.261838,0.927792,0.265787,-0.0721899,-0.255796,0.964032,1.99266,23.185,3.18621> }}
union{cone{<2.82023,26.1174,4.02626> ,0.12096,<3.92339,29.204,3.43844> ,0.11232}
sphere{<2.82023,26.1174,4.02626> ,0.12096}
texture{txttree matrix <0.941666,-0.336549,0,0.331265,0.92688,-0.176515,0.0594061,0.166218,0.984298,2.82023,26.1174,4.02626> }}
union{cone{<3.92339,29.204,3.43844> ,0.11232,<4.23754,32.4118,3.85909> ,0.10368}
sphere{<3.92339,29.204,3.43844> ,0.11232}
texture{txttree matrix <0.995239,-0.0974685,0,0.0966489,0.98687,0.129411,-0.0126135,-0.128794,0.991591,3.92339,29.204,3.43844> }}
union{cone{<4.23754,32.4118,3.85909> ,0.10368,<4.49592,35.6127,4.01885> ,0.09504}
sphere{<4.23754,32.4118,3.85909> ,0.10368}
texture{txttree matrix <0.996758,-0.0804586,0,0.0803592,0.995527,0.0496887,-0.00399789,-0.0495276,0.998765,4.23754,32.4118,3.85909> }}
union{cone{<4.49592,35.6127,4.01885> ,0.09504,<3.84747,38.6042,3.315> ,0.0864}
sphere{<4.49592,35.6127,4.01885> ,0.09504}
texture{txttree matrix <0.977303,0.211845,0,-0.206457,0.952447,-0.224098,-0.0474739,0.219012,0.974567,4.49592,35.6127,4.01885> }}
union{cone{<3.84747,38.6042,3.315> ,0.0864,<3.12815,41.7661,2.28874> ,0.07776}
sphere{<3.84747,38.6042,3.315> ,0.0864}
texture{txttree matrix <0.975085,0.22183,0,-0.211491,0.929638,-0.301735,-0.0669339,0.294217,0.953392,3.84747,38.6042,3.315> }}
union{cone{<1.58699,20.4408,4.23144> ,0.1296,<3.0277,23.3186,3.07239> ,0.12096}
sphere{<1.58699,20.4408,4.23144> ,0.1296}
texture{txttree matrix <0.8942,-0.447668,0,0.421185,0.841302,-0.338842,0.151689,0.302992,0.940843,1.58699,20.4408,4.23144> }}
union{cone{<3.0277,23.3186,3.07239> ,0.12096,<4.10197,25.8925,1.19623> ,0.11232}
sphere{<3.0277,23.3186,3.07239> ,0.12096}
texture{txttree matrix <0.92285,-0.38516,0,0.319585,0.76573,-0.558143,0.214974,0.515082,0.829745,3.0277,23.3186,3.07239> }}
union{cone{<4.10197,25.8925,1.19623> ,0.11232,<6.15407,28.0529,-0.29293> ,0.10368}
sphere{<4.10197,25.8925,1.19623> ,0.11232}
texture{txttree matrix <0.725035,-0.688712,0,0.616057,0.648548,-0.447057,0.307893,0.324132,0.894506,4.10197,25.8925,1.19623> }}
union{cone{<6.15407,28.0529,-0.29293> ,0.10368,<6.87344,30.9123,-1.53398> ,0.09504}
sphere{<6.15407,28.0529,-0.29293> ,0.10368}
texture{txttree matrix <0.969781,-0.243976,0,0.224869,0.893831,-0.387943,0.094649,0.37622,0.921683,6.15407,28.0529,-0.29293> }}
union{cone{<6.87344,30.9123,-1.53398> ,0.09504,<7.35345,33.6072,-3.07632> ,0.0864}
sphere{<6.87344,30.9123,-1.53398> ,0.09504}
texture{txttree matrix <0.984505,-0.175356,0,0.152774,0.857724,-0.490887,0.0860799,0.48328,0.871223,6.87344,30.9123,-1.53398> }}
union{cone{<7.35345,33.6072,-3.07632> ,0.0864,<8.71357,35.6243,-5.29604> ,0.07776}
sphere{<7.35345,33.6072,-3.07632> ,0.0864}
texture{txttree matrix <0.829121,-0.559069,0,0.412996,0.61249,-0.674011,0.376818,0.558837,0.738721,7.35345,33.6072,-3.07632> }}
union{cone{<0.710741,15.1573,5.28734> ,0.1296,<1.19703,18.4314,5.23292> ,0.12096}
sphere{<0.710741,15.1573,5.28734> ,0.1296}
texture{txttree matrix <0.98915,-0.146912,0,0.146892,0.989016,-0.01644,0.00241522,0.0162616,0.999865,0.710741,15.1573,5.28734> }}
union{cone{<1.19703,18.4314,5.23292> ,0.12096,<2.5473,20.9393,3.4823> ,0.11232}
sphere{<1.19703,18.4314,5.23292> ,0.12096}
texture{txttree matrix <0.880486,-0.474071,0,0.403882,0.750125,-0.523634,0.24824,0.461053,0.851943,1.19703,18.4314,5.23292> }}
union{cone{<2.5473,20.9393,3.4823> ,0.11232,<2.50797,24.0521,2.02348> ,0.10368}
sphere{<2.5473,20.9393,3.4823> ,0.11232}
texture{txttree matrix <0.99992,0.0126337,0,-0.0114399,0.905438,-0.424325,-0.00536079,0.424291,0.90551,2.5473,20.9393,3.4823> }}
union{cone{<2.50797,24.0521,2.02348> ,0.10368,<2.85607,26.669,0.147137> ,0.09504}
sphere{<2.50797,24.0521,2.02348> ,0.10368}
texture{txttree matrix <0.991268,-0.131859,0,0.107478,0.807977,-0.579329,0.07639,0.574271,0.815094,2.50797,24.0521,2.02348> }}
union{cone{<2.85607,26.669,0.147137> ,0.09504,<3.40808,29.8298,-0.523495> ,0.0864}
sphere{<2.85607,26.669,0.147137> ,0.09504}
texture{txttree matrix <0.98509,-0.172041,0,0.168402,0.964253,-0.204589,0.0351976,0.201538,0.978848,2.85607,26.669,0.147137> }}
union{cone{<3.40808,29.8298,-0.523495> ,0.0864,<3.43806,32.4083,-2.32856> ,0.07776}
sphere{<3.40808,29.8298,-0.523495> ,0.0864}
texture{txttree matrix <0.999932,-0.0116241,0,0.00952289,0.819179,-0.573459,0.00666596,0.57342,0.819234,3.40808,29.8298,-0.523495> }}
union{cone{<1.91635,21.535,3.51196> ,0.1296,<1.48484,24.6094,3.13422> ,0.12096}
sphere{<1.91635,21.535,3.51196> ,0.1296}
texture{txttree matrix <0.990294,0.138991,0,-0.137974,0.983044,-0.120783,-0.0167878,0.119611,0.992679,1.91635,21.535,3.51196> }}
union{cone{<1.48484,24.6094,3.13422> ,0.12096,<1.93003,27.1814,1.03735> ,0.11232}
sphere{<1.48484,24.6094,3.13422> ,0.12096}
texture{txttree matrix <0.985348,-0.170556,0,0.132965,0.768174,-0.626282,0.106816,0.617106,0.779597,1.48484,24.6094,3.13422> }}
union{cone{<1.93003,27.1814,1.03735> ,0.11232,<1.97241,30.1255,-0.578164> ,0.10368}
sphere{<1.93003,27.1814,1.03735> ,0.11232}
texture{txttree matrix <0.999896,-0.0143948,0,0.01262,0.876618,-0.481022,0.00692421,0.480972,0.876708,1.93003,27.1814,1.03735> }}
union{cone{<1.97241,30.1255,-0.578164> ,0.10368,<2.50734,32.7468,-2.25214> ,0.09504}
sphere{<1.97241,30.1255,-0.578164> ,0.10368}
texture{txttree matrix <0.979807,-0.199943,0,0.169499,0.830615,-0.530423,0.106055,0.519713,0.847733,1.97241,30.1255,-0.578164> }}
union{cone{<2.50734,32.7468,-2.25214> ,0.09504,<2.83871,35.7033,-3.6824> ,0.0864}
sphere{<2.50734,32.7468,-2.25214> ,0.09504}
texture{txttree matrix <0.993777,-0.111388,0,0.100389,0.895646,-0.43329,0.0482632,0.430593,0.901255,2.50734,32.7468,-2.25214> }}
union{cone{<2.83871,35.7033,-3.6824> ,0.0864,<2.04068,38.5422,-5.23211> ,0.07776}
sphere{<2.83871,35.7033,-3.6824> ,0.0864}
texture{txttree matrix <0.962686,0.270619,0,-0.239554,0.852178,-0.465194,-0.125891,0.447836,0.885209,2.83871,35.7033,-3.6824> }}
union{cone{<1.89983,21.4334,3.55337> ,0.1296,<2.25584,24.6388,3.04878> ,0.12096}
sphere{<1.89983,21.4334,3.55337> ,0.1296}
texture{txttree matrix <0.993889,-0.110386,0,0.109059,0.981943,-0.154579,0.0170633,0.153634,0.98798,1.89983,21.4334,3.55337> }}
union{cone{<2.25584,24.6388,3.04878> ,0.12096,<2.8559,27.6148,1.50532> ,0.11232}
sphere{<2.25584,24.6388,3.04878> ,0.12096}
texture{txttree matrix <0.980272,-0.197655,0,0.176192,0.873826,-0.453194,0.0895761,0.444253,0.891412,2.25584,24.6388,3.04878> }}
union{cone{<2.8559,27.6148,1.50532> ,0.11232,<2.26239,29.8176,-0.684213> ,0.10368}
sphere{<2.8559,27.6148,1.50532> ,0.11232}
texture{txttree matrix <0.965566,0.260159,0,-0.187698,0.69663,-0.692442,-0.180145,0.668598,0.721474,2.8559,27.6148,1.50532> }}
union{cone{<2.26239,29.8176,-0.684213> ,0.10368,<2.46578,32.4299,-2.74265> ,0.09504}
sphere{<2.26239,29.8176,-0.684213> ,0.10368}
texture{txttree matrix <0.996983,-0.0776241,0,0.0610405,0.783987,-0.617769,0.0479537,0.615905,0.78636,2.26239,29.8176,-0.684213> }}
union{cone{<2.46578,32.4299,-2.74265> ,0.09504,<2.54117,35.1964,-4.55699> ,0.0864}
sphere{<2.46578,32.4299,-2.74265> ,0.09504}
texture{txttree matrix <0.999629,-0.0272406,0,0.0227814,0.835993,-0.548267,0.0149351,0.548063,0.836304,2.46578,32.4299,-2.74265> }}
union{cone{<2.54117,35.1964,-4.55699> ,0.0864,<2.99832,37.8949,-6.07521> ,0.07776}
sphere{<2.54117,35.1964,-4.55699> ,0.0864}
texture{txttree matrix <0.985952,-0.167026,0,0.14606,0.862188,-0.485076,0.0810205,0.478261,0.874472,2.54117,35.1964,-4.55699> }}
union{cone{<-0.697489,10.7018,5.48921> ,0.216,<-1.02189,12.346,5.44383> ,0.203657}
sphere{<-0.697489,10.7018,5.48921> ,0.216}
texture{txttree matrix <0.981085,0.193576,0,-0.193505,0.980726,-0.027068,-0.00523973,0.026556,0.999634,-0.697489,10.7018,5.48921> }}
union{cone{<-1.02189,12.346,5.44383> ,0.203657,<-0.407316,13.7771,4.53789> ,0.191314}
sphere{<-1.02189,12.346,5.44383> ,0.203657}
texture{txttree matrix <0.918862,-0.394578,0,0.341078,0.794277,-0.502783,0.198387,0.461988,0.864413,-1.02189,12.346,5.44383> }}
union{cone{<-0.407316,13.7771,4.53789> ,0.191314,<-0.234469,15.4507,4.26493> ,0.178971}
sphere{<-0.407316,13.7771,4.53789> ,0.191314}
texture{txttree matrix <0.994709,-0.102734,0,0.101408,0.981871,-0.160144,0.0164523,0.159297,0.987094,-0.407316,13.7771,4.53789> }}
union{cone{<-0.234469,15.4507,4.26493> ,0.178971,<0.0517433,17.1305,3.91041> ,0.166629}
sphere{<-0.234469,15.4507,4.26493> ,0.178971}
texture{txttree matrix <0.985793,-0.167962,0,0.164441,0.965127,-0.203687,0.0342118,0.200793,0.979036,-0.234469,15.4507,4.26493> }}
union{cone{<0.0517433,17.1305,3.91041> ,0.166629,<0.480224,18.8289,3.37104> ,0.154286}
sphere{<0.0517433,17.1305,3.91041> ,0.166629}
texture{txttree matrix <0.969617,-0.244628,0,0.233794,0.926675,-0.2943,0.0719942,0.285359,0.955713,0.0517433,17.1305,3.91041> }}
union{cone{<0.480224,18.8289,3.37104> ,0.154286,<0.314709,20.1809,2.26836> ,0.141943}
sphere{<0.480224,18.8289,3.37104> ,0.154286}
texture{txttree matrix <0.99259,0.121512,0,-0.0944446,0.771483,-0.629201,-0.0764557,0.624538,0.777243,0.480224,18.8289,3.37104> }}
union{cone{<0.314709,20.1809,2.26836> ,0.141943,<0.0826324,21.5198,1.24787> ,0.1296}
sphere{<0.314709,20.1809,2.26836> ,0.141943}
texture{txttree matrix <0.985309,0.170781,0,-0.136562,0.787885,-0.600491,-0.102552,0.591669,0.799632,0.314709,20.1809,2.26836> }}
union{cone{<0.0826324,21.5198,1.24787> ,0.1296,<0.73154,24.646,0.571089> ,0.12096}
sphere{<0.0826324,21.5198,1.24787> ,0.1296}
texture{txttree matrix <0.979129,-0.203242,0,0.198824,0.957846,-0.207364,0.042145,0.203036,0.978264,0.0826324,21.5198,1.24787> }}
union{cone{<0.73154,24.646,0.571089> ,0.12096,<-0.307765,27.4243,-0.636013> ,0.11232}
sphere{<0.73154,24.646,0.571089> ,0.12096}
texture{txttree matrix <0.936614,0.350364,0,-0.324523,0.867535,-0.376918,-0.132058,0.353027,0.926247,0.73154,24.646,0.571089> }}
union{cone{<-0.307765,27.4243,-0.636013> ,0.11232,<-0.276586,30.6417,-1.75223> ,0.10368}
sphere{<-0.307765,27.4243,-0.636013> ,0.11232}
texture{txttree matrix <0.999953,-0.00969043,0,0.00915516,0.944718,-0.327755,0.00317609,0.327739,0.944763,-0.307765,27.4243,-0.636013> }}
union{cone{<-0.276586,30.6417,-1.75223> ,0.10368,<-0.683642,33.7984,-2.72942> ,0.09504}
sphere{<-0.276586,30.6417,-1.75223> ,0.10368}
texture{txttree matrix <0.991788,0.12789,0,-0.122258,0.94811,-0.293497,-0.0375355,0.291087,0.95596,-0.276586,30.6417,-1.75223> }}
union{cone{<-0.683642,33.7984,-2.72942> ,0.09504,<-0.485985,36.4791,-4.84353> ,0.0864}
sphere{<-0.683642,33.7984,-2.72942> ,0.09504}
texture{txttree matrix <0.997293,-0.0735343,0,0.057799,0.783886,-0.618208,0.0454595,0.616535,0.786014,-0.683642,33.7984,-2.72942> }}
union{cone{<-0.485985,36.4791,-4.84353> ,0.0864,<-0.24916,39.1999,-6.8867> ,0.07776}
sphere{<-0.485985,36.4791,-4.84353> ,0.0864}
texture{txttree matrix <0.996233,-0.086715,0,0.0694345,0.797705,-0.599038,0.0519455,0.596781,0.800721,-0.485985,36.4791,-4.84353> }}
union{cone{<-0.0579791,16.4865,4.04632> ,0.1296,<1.37756,19.3439,4.88468> ,0.12096}
sphere{<-0.0579791,16.4865,4.04632> ,0.1296}
texture{txttree matrix <0.89357,-0.448924,0,0.434248,0.864358,0.253603,-0.113849,-0.226612,0.967308,-0.0579791,16.4865,4.04632> }}
union{cone{<1.37756,19.3439,4.88468> ,0.12096,<2.73888,22.2819,4.29567> ,0.11232}
sphere{<1.37756,19.3439,4.88468> ,0.12096}
texture{txttree matrix <0.90733,-0.420418,0,0.413631,0.892681,-0.17897,0.0752422,0.162385,0.983855,1.37756,19.3439,4.88468> }}
union{cone{<2.73888,22.2819,4.29567> ,0.11232,<3.88518,24.9339,3.06227> ,0.10368}
sphere{<2.73888,22.2819,4.29567> ,0.11232}
texture{txttree matrix <0.917921,-0.396763,0,0.364902,0.844209,-0.39263,0.155781,0.360404,0.919696,2.73888,22.2819,4.29567> }}
union{cone{<3.88518,24.9339,3.06227> ,0.10368,<4.3827,27.7626,1.39539> ,0.09504}
sphere{<3.88518,24.9339,3.06227> ,0.10368}
texture{txttree matrix <0.984882,-0.173225,0,0.149821,0.85182,-0.501953,0.0869509,0.494365,0.864895,3.88518,24.9339,3.06227> }}
union{cone{<4.3827,27.7626,1.39539> ,0.09504,<6.18507,30.429,0.434251> ,0.0864}
sphere{<4.3827,27.7626,1.39539> ,0.09504}
texture{txttree matrix <0.828481,-0.560017,0,0.5366,0.793838,-0.286149,0.160248,0.237069,0.958185,4.3827,27.7626,1.39539> }}
union{cone{<6.18507,30.429,0.434251> ,0.0864,<7.68742,33.2659,-0.301571> ,0.07776}
sphere{<6.18507,30.429,0.434251> ,0.0864}
texture{txttree matrix <0.883733,-0.467991,0,0.456161,0.861395,-0.223419,0.104558,0.197442,0.974723,6.18507,30.429,0.434251> }}
union{cone{<0.177342,17.6283,3.7523> ,0.1296,<0.209567,19.4613,1.12624> ,0.12096}
sphere{<0.177342,17.6283,3.7523> ,0.1296}
texture{txttree matrix <0.999846,-0.0175775,0,0.0100617,0.572329,-0.819962,0.0144129,0.819836,0.572418,0.177342,17.6283,3.7523> }}
union{cone{<0.209567,19.4613,1.12624> ,0.12096,<0.579468,22.3284,-0.330681> ,0.11232}
sphere{<0.209567,19.4613,1.12624> ,0.12096}
texture{txttree matrix <0.99178,-0.127957,0,0.114266,0.885661,-0.450054,0.0575874,0.446354,0.893001,0.209567,19.4613,1.12624> }}
union{cone{<0.579468,22.3284,-0.330681> ,0.11232,<1.00852,25.4437,-1.55539> ,0.10368}
sphere{<0.579468,22.3284,-0.330681> ,0.11232}
texture{txttree matrix <0.990649,-0.136437,0,0.127136,0.923113,-0.362903,0.0495133,0.359509,0.931827,0.579468,22.3284,-0.330681> }}
union{cone{<1.00852,25.4437,-1.55539> ,0.10368,<1.66257,27.5032,-3.90561> ,0.09504}
sphere{<1.00852,25.4437,-1.55539> ,0.10368}
texture{txttree matrix <0.953094,-0.302674,0,0.20486,0.645088,-0.736134,0.222808,0.701605,0.676836,1.00852,25.4437,-1.55539> }}
union{cone{<1.66257,27.5032,-3.90561> ,0.09504,<1.85782,29.787,-6.40233> ,0.0864}
sphere{<1.66257,27.5032,-3.90561> ,0.09504}
texture{txttree matrix <0.996365,-0.0851823,0,0.0576071,0.673822,-0.736645,0.0627491,0.733967,0.67628,1.66257,27.5032,-3.90561> }}
union{cone{<1.85782,29.787,-6.40233> ,0.0864,<1.72619,32.0776,-8.9317> ,0.07776}
sphere{<1.85782,29.787,-6.40233> ,0.0864}
texture{txttree matrix <0.998353,0.0573703,0,-0.0385449,0.670755,-0.740677,-0.0424928,0.739457,0.671862,1.85782,29.787,-6.40233> }}
union{cone{<-0.312073,3.18753,-0.0824223> ,0.36,<0.46336,3.56023,0.37042> ,0.342}
sphere{<-0.312073,3.18753,-0.0824223> ,0.36}
texture{txttree matrix <0.433197,-0.901299,0,0.797566,0.383339,0.465768,-0.419796,-0.201769,0.884907,-0.312073,3.18753,-0.0824223> }}
union{cone{<0.46336,3.56023,0.37042> ,0.342,<1.33014,4.01715,0.447513> ,0.324}
sphere{<0.46336,3.56023,0.37042> ,0.342}
texture{txttree matrix <0.466324,-0.884614,0,0.881889,0.464887,0.078437,-0.0693864,-0.036577,0.996919,0.46336,3.56023,0.37042> }}
union{cone{<1.33014,4.01715,0.447513> ,0.324,<1.89978,4.37434,1.12684> ,0.306}
sphere{<1.33014,4.01715,0.447513> ,0.324}
texture{txttree matrix <0.53124,-0.847221,0,0.595988,0.373707,0.710733,-0.602148,-0.37757,0.703462,1.33014,4.01715,0.447513> }}
union{cone{<1.89978,4.37434,1.12684> ,0.306,<2.44322,5.2013,1.24676> ,0.288}
sphere{<1.89978,4.37434,1.12684> ,0.306}
texture{txttree matrix <0.835702,-0.549183,0,0.545194,0.829631,0.120315,-0.0660749,-0.100547,0.992736,1.89978,4.37434,1.12684> }}
union{cone{<2.44322,5.2013,1.24676> ,0.288,<3.12578,5.86596,1.26701> ,0.27}
sphere{<2.44322,5.2013,1.24676> ,0.288}
texture{txttree matrix <0.697656,-0.716433,0,0.716271,0.697499,0.0212431,-0.0152192,-0.0148204,0.999774,2.44322,5.2013,1.24676> }}
union{cone{<3.12578,5.86596,1.26701> ,0.27,<3.78825,6.57868,1.16389> ,0.252}
sphere{<3.12578,5.86596,1.26701> ,0.27}
texture{txttree matrix <0.732453,-0.680817,0,0.677027,0.728375,-0.10538,0.0717448,0.0771862,0.994432,3.12578,5.86596,1.26701> }}
union{cone{<3.78825,6.57868,1.16389> ,0.252,<4.29819,7.34515,0.985314> ,0.234}
sphere{<3.78825,6.57868,1.16389> ,0.252}
texture{txttree matrix <0.83257,-0.55392,0,0.543784,0.817335,-0.190428,0.105482,0.158544,0.981701,3.78825,6.57868,1.16389> }}
union{cone{<4.29819,7.34515,0.985314> ,0.234,<4.75109,8.19425,1.14217> ,0.216}
sphere{<4.29819,7.34515,0.985314> ,0.234}
texture{txttree matrix <0.882332,-0.470627,0,0.464497,0.870841,0.160869,-0.0757093,-0.14194,0.986976,4.29819,7.34515,0.985314> }}
union{cone{<4.75109,8.19425,1.14217> ,0.216,<5.05531,9.37986,2.48272> ,0.203657}
sphere{<4.75109,8.19425,1.14217> ,0.216}
texture{txttree matrix <0.968622,-0.248539,0,0.167584,0.653121,0.738477,-0.18354,-0.715306,0.674278,4.75109,8.19425,1.14217> }}
union{cone{<5.05531,9.37986,2.48272> ,0.203657,<5.29375,11.0047,3.31138> ,0.191314}
sphere{<5.05531,9.37986,2.48272> ,0.203657}
texture{txttree matrix <0.989403,-0.145193,0,0.129626,0.883323,0.450486,-0.0654073,-0.445712,0.892783,5.05531,9.37986,2.48272> }}
union{cone{<5.29375,11.0047,3.31138> ,0.191314,<6.44618,11.9872,4.18237> ,0.178971}
sphere{<5.29375,11.0047,3.31138> ,0.191314}
texture{txttree matrix <0.648782,-0.760974,0,0.659656,0.562402,0.498557,-0.379389,-0.323455,0.866857,5.29375,11.0047,3.31138> }}
union{cone{<6.44618,11.9872,4.18237> ,0.178971,<7.07936,13.3337,5.22756> ,0.166629}
sphere{<6.44618,11.9872,4.18237> ,0.178971}
texture{txttree matrix <0.904937,-0.425545,0,0.348219,0.740502,0.574804,-0.244605,-0.520162,0.818291,6.44618,11.9872,4.18237> }}
union{cone{<7.07936,13.3337,5.22756> ,0.166629,<7.08045,15.0468,5.51057> ,0.154286}
sphere{<7.07936,13.3337,5.22756> ,0.166629}
texture{txttree matrix <1,-0.000636989,0,0.000628471,0.986627,0.162995,-0.000103826,-0.162995,0.986627,7.07936,13.3337,5.22756> }}
union{cone{<7.08045,15.0468,5.51057> ,0.154286,<7.17016,16.7087,5.76194> ,0.141943}
sphere{<7.08045,15.0468,5.51057> ,0.154286}
texture{txttree matrix <0.998546,-0.0539036,0,0.0532991,0.987348,0.14934,-0.00804993,-0.149122,0.988786,7.08045,15.0468,5.51057> }}
union{cone{<7.17016,16.7087,5.76194> ,0.141943,<7.32802,18.4703,5.94802> ,0.1296}
sphere{<7.17016,16.7087,5.76194> ,0.141943}
texture{txttree matrix <0.996009,-0.0892526,0,0.0887627,0.990542,0.104632,-0.00933871,-0.104215,0.994511,7.17016,16.7087,5.76194> }}
union{cone{<7.32802,18.4703,5.94802> ,0.1296,<7.26638,21.5497,6.82628> ,0.12096}
sphere{<7.32802,18.4703,5.94802> ,0.1296}
texture{txttree matrix <0.9998,0.0200116,0,-0.0192445,0.961476,0.274215,0.00548749,-0.27416,0.961668,7.32802,18.4703,5.94802> }}
union{cone{<7.26638,21.5497,6.82628> ,0.12096,<6.66567,24.6023,7.23991> ,0.11232}
sphere{<7.26638,21.5497,6.82628> ,0.12096}
texture{txttree matrix <0.981182,0.193085,0,-0.191401,0.972623,0.131794,0.0254475,-0.129314,0.991277,7.26638,21.5497,6.82628> }}
union{cone{<6.66567,24.6023,7.23991> ,0.11232,<5.87949,27.6232,7.78411> ,0.10368}
sphere{<6.66567,24.6023,7.23991> ,0.11232}
texture{txttree matrix <0.967765,0.251855,0,-0.248113,0.953385,0.171746,0.0432551,-0.16621,0.985141,6.66567,24.6023,7.23991> }}
union{cone{<5.87949,27.6232,7.78411> ,0.10368,<5.81566,30.7111,8.454> ,0.09504}
sphere{<5.87949,27.6232,7.78411> ,0.10368}
texture{txttree matrix <0.999786,0.0206642,0,-0.0201947,0.977069,0.211964,0.00438007,-0.211918,0.977278,5.87949,27.6232,7.78411> }}
union{cone{<5.81566,30.7111,8.454> ,0.09504,<6.87976,33.6864,8.95921> ,0.0864}
sphere{<5.81566,30.7111,8.454> ,0.09504}
texture{txttree matrix <0.94159,-0.336761,0,0.332537,0.929781,0.157884,-0.053169,-0.148662,0.987458,5.81566,30.7111,8.454> }}
union{cone{<6.87976,33.6864,8.95921> ,0.0864,<6.34135,37.0606,9.20787> ,0.07776}
sphere{<6.87976,33.6864,8.95921> ,0.0864}
texture{txttree matrix <0.987508,0.15757,0,-0.157154,0.984903,0.0725818,0.0114367,-0.0716751,0.997362,6.87976,33.6864,8.95921> }}
union{cone{<6.18589,11.7653,3.98564> ,0.1296,<8.41111,13.9673,5.22995> ,0.12096}
sphere{<6.18589,11.7653,3.98564> ,0.1296}
texture{txttree matrix <0.70338,-0.710814,0,0.660548,0.65364,0.369365,-0.26255,-0.259804,0.929284,6.18589,11.7653,3.98564> }}
union{cone{<8.41111,13.9673,5.22995> ,0.12096,<10.8586,15.5273,6.9841> ,0.11232}
sphere{<8.41111,13.9673,5.22995> ,0.12096}
texture{txttree matrix <0.537506,-0.84326,0,0.721689,0.460015,0.517254,-0.436179,-0.278027,0.855832,8.41111,13.9673,5.22995> }}
union{cone{<10.8586,15.5273,6.9841> ,0.11232,<13.0358,17.4703,8.41736> ,0.10368}
sphere{<10.8586,15.5273,6.9841> ,0.11232}
texture{txttree matrix <0.66583,-0.746103,0,0.669688,0.597636,0.440851,-0.32892,-0.293532,0.89758,10.8586,15.5273,6.9841> }}
union{cone{<13.0358,17.4703,8.41736> ,0.10368,<15.5756,19.1546,9.56353> ,0.09504}
sphere{<13.0358,17.4703,8.41736> ,0.10368}
texture{txttree matrix <0.552677,-0.833396,0,0.780051,0.517301,0.352024,-0.293375,-0.194555,0.935991,13.0358,17.4703,8.41736> }}
union{cone{<15.5756,19.1546,9.56353> ,0.09504,<18.3982,20.5557,9.44901> ,0.0864}
sphere{<15.5756,19.1546,9.56353> ,0.09504}
texture{txttree matrix <0.444626,-0.895716,0,0.895125,0.444333,-0.0363185,0.0325311,0.0161481,0.99934,15.5756,19.1546,9.56353> }}
union{cone{<18.3982,20.5557,9.44901> ,0.0864,<20.5662,22.8571,10.2016> ,0.07776}
sphere{<18.3982,20.5557,9.44901> ,0.0864}
texture{txttree matrix <0.727881,-0.685703,0,0.667069,0.708101,0.231544,-0.15877,-0.168536,0.972824,18.3982,20.5557,9.44901> }}
union{cone{<7.30763,18.2428,5.92399> ,0.1296,<7.70617,21.5732,6.59084> ,0.12096}
sphere{<7.30763,18.2428,5.92399> ,0.1296}
texture{txttree matrix <0.992916,-0.11882,0,0.116539,0.973855,0.194999,-0.0231698,-0.193618,0.980803,7.30763,18.2428,5.92399> }}
union{cone{<7.70617,21.5732,6.59084> ,0.12096,<7.68393,24.8382,6.22584> ,0.11232}
sphere{<7.70617,21.5732,6.59084> ,0.12096}
texture{txttree matrix <0.999977,0.00681122,0,-0.00676906,0.993787,-0.111097,-0.000756704,0.111094,0.99381,7.70617,21.5732,6.59084> }}
union{cone{<7.68393,24.8382,6.22584> ,0.11232,<8.46318,27.3958,4.28073> ,0.10368}
sphere{<7.68393,24.8382,6.22584> ,0.11232}
texture{txttree matrix <0.956585,-0.291452,0,0.235683,0.773543,-0.588289,0.171458,0.562749,0.808651,7.68393,24.8382,6.22584> }}
union{cone{<8.46318,27.3958,4.28073> ,0.10368,<8.23826,30.4253,2.94966> ,0.09504}
sphere{<8.46318,27.3958,4.28073> ,0.10368}
texture{txttree matrix <0.997255,0.0740411,0,-0.0678166,0.913418,-0.401334,-0.0297152,0.400233,0.915932,8.46318,27.3958,4.28073> }}
union{cone{<8.23826,30.4253,2.94966> ,0.09504,<9.47738,33.1262,1.91453> ,0.0864}
sphere{<8.23826,30.4253,2.94966> ,0.09504}
texture{txttree matrix <0.908913,-0.416985,0,0.393778,0.858329,-0.328953,0.137169,0.29899,0.944346,8.23826,30.4253,2.94966> }}
union{cone{<9.47738,33.1262,1.91453> ,0.0864,<10.4719,36.0044,0.679401> ,0.07776}
sphere{<9.47738,33.1262,1.91453> ,0.0864}
texture{txttree matrix <0.94517,-0.32658,0,0.302633,0.875865,-0.375864,0.12275,0.355256,0.926675,9.47738,33.1262,1.91453> }}
union{cone{<7.09639,15.3421,5.55523> ,0.1296,<6.34701,17.7653,7.42099> ,0.12096}
sphere{<7.09639,15.3421,5.55523> ,0.1296}
texture{txttree matrix <0.955359,0.295446,0,-0.237994,0.769579,0.592542,0.175065,-0.566091,0.805539,7.09639,15.3421,5.55523> }}
union{cone{<6.34701,17.7653,7.42099> ,0.12096,<6.31139,20.9377,8.18771> ,0.11232}
sphere{<6.34701,17.7653,7.42099> ,0.12096}
texture{txttree matrix <0.999937,0.0112281,0,-0.0109139,0.971956,0.234908,0.00263756,-0.234893,0.972018,6.34701,17.7653,7.42099> }}
union{cone{<6.31139,20.9377,8.18771> ,0.11232,<5.75438,24.071,8.38324> ,0.10368}
sphere{<6.31139,20.9377,8.18771> ,0.11232}
texture{txttree matrix <0.984564,0.175024,0,-0.174695,0.982711,0.061325,0.0107334,-0.0603784,0.998118,6.31139,20.9377,8.18771> }}
union{cone{<5.75438,24.071,8.38324> ,0.10368,<4.73337,27.0968,8.55638> ,0.09504}
sphere{<5.75438,24.071,8.38324> ,0.10368}
texture{txttree matrix <0.947513,0.319719,0,-0.31925,0.946123,0.0541381,0.017309,-0.0512965,0.998533,5.75438,24.071,8.38324> }}
union{cone{<4.73337,27.0968,8.55638> ,0.09504,<4.64212,30.2363,8.52314> ,0.0864}
sphere{<4.73337,27.0968,8.55638> ,0.09504}
texture{txttree matrix <0.999578,0.0290535,0,-0.0290518,0.999522,-0.0105842,-0.000307509,0.0105798,0.999944,4.73337,27.0968,8.55638> }}
union{cone{<4.64212,30.2363,8.52314> ,0.0864,<4.47134,33.2408,7.21026> ,0.07776}
sphere{<4.64212,30.2363,8.52314> ,0.0864}
texture{txttree matrix <0.998389,0.0567484,0,-0.0520142,0.915099,-0.39986,-0.0226914,0.399216,0.916576,4.64212,30.2363,8.52314> }}
union{cone{<2.74644,5.49657,1.25576> ,0.216,<4.03627,6.20792,2.05701> ,0.203657}
sphere{<2.74644,5.49657,1.25576> ,0.216}
texture{txttree matrix <0.482934,-0.875657,0,0.769217,0.424231,0.477842,-0.418426,-0.230766,0.878446,2.74644,5.49657,1.25576> }}
union{cone{<4.03627,6.20792,2.05701> ,0.203657,<5.70328,6.12517,2.31897> ,0.191314}
sphere{<4.03627,6.20792,2.05701> ,0.203657}
texture{txttree matrix <-0.0495804,-0.99877,0,0.986691,-0.0489807,0.155052,-0.154862,0.00768755,0.987906,4.03627,6.20792,2.05701> }}
union{cone{<5.70328,6.12517,2.31897> ,0.191314,<6.92558,7.38434,2.08368> ,0.178971}
sphere{<5.70328,6.12517,2.31897> ,0.191314}
texture{txttree matrix <0.717533,-0.696525,0,0.690348,0.711169,-0.132886,0.0925582,0.0953498,0.991131,5.70328,6.12517,2.31897> }}
union{cone{<6.92558,7.38434,2.08368> ,0.178971,<8.20223,8.27966,1.34545> ,0.166629}
sphere{<6.92558,7.38434,2.08368> ,0.178971}
texture{txttree matrix <0.574182,-0.818728,0,0.739986,0.51896,-0.427904,0.350337,0.245695,0.903824,6.92558,7.38434,2.08368> }}
union{cone{<8.20223,8.27966,1.34545> ,0.166629,<9.5063,9.43528,1.4553> ,0.154286}
sphere{<8.20223,8.27966,1.34545> ,0.166629}
texture{txttree matrix <0.663223,-0.748421,0,0.746939,0.661909,0.0629177,-0.047089,-0.0417285,0.998019,8.20223,8.27966,1.34545> }}
union{cone{<9.5063,9.43528,1.4553> ,0.154286,<11.0087,10.1642,1.4172> ,0.141943}
sphere{<9.5063,9.43528,1.4553> ,0.154286}
texture{txttree matrix <0.436506,-0.899702,0,0.899468,0.436392,-0.0228069,0.0205194,0.00995533,0.99974,9.5063,9.43528,1.4553> }}
union{cone{<11.0087,10.1642,1.4172> ,0.141943,<11.8562,11.5115,0.677888> ,0.1296}
sphere{<11.0087,10.1642,1.4172> ,0.141943}
texture{txttree matrix <0.846477,-0.532425,0,0.482878,0.767705,-0.421258,0.224288,0.356585,0.906941,11.0087,10.1642,1.4172> }}
union{cone{<11.8562,11.5115,0.677888> ,0.1296,<12.8171,14.5777,-0.269357> ,0.12096}
sphere{<11.8562,11.5115,0.677888> ,0.1296}
texture{txttree matrix <0.95424,-0.299042,0,0.286838,0.915296,-0.282766,0.084559,0.269827,0.959189,11.8562,11.5115,0.677888> }}
union{cone{<12.8171,14.5777,-0.269357> ,0.12096,<13.9905,17.2842,-1.49732> ,0.11232}
sphere{<12.8171,14.5777,-0.269357> ,0.12096}
texture{txttree matrix <0.917477,-0.397789,0,0.367241,0.847019,-0.384309,0.152874,0.352594,0.923205,12.8171,14.5777,-0.269357> }}
union{cone{<13.9905,17.2842,-1.49732> ,0.11232,<16.0477,19.5059,-3.13104> ,0.10368}
sphere{<13.9905,17.2842,-1.49732> ,0.11232}
texture{txttree matrix <0.733766,-0.679402,0,0.597921,0.645765,-0.474846,0.322611,0.348426,0.880069,13.9905,17.2842,-1.49732> }}
union{cone{<16.0477,19.5059,-3.13104> ,0.10368,<17.2567,22.1516,-4.5262> ,0.09504}
sphere{<16.0477,19.5059,-3.13104> ,0.10368}
texture{txttree matrix <0.909531,-0.415637,0,0.374759,0.820079,-0.432465,0.179748,0.39334,0.901651,16.0477,19.5059,-3.13104> }}
union{cone{<17.2567,22.1516,-4.5262> ,0.09504,<18.4329,24.3835,-6.46898> ,0.0864}
sphere{<17.2567,22.1516,-4.5262> ,0.09504}
texture{txttree matrix <0.884667,-0.466224,0,0.369395,0.700933,-0.610116,0.28445,0.539749,0.792312,17.2567,22.1516,-4.5262> }}
union{cone{<18.4329,24.3835,-6.46898> ,0.0864,<19.1759,26.9073,-8.18801> ,0.07776}
sphere{<18.4329,24.3835,-6.46898> ,0.0864}
texture{txttree matrix <0.959291,-0.282419,0,0.236425,0.803063,-0.546986,0.154479,0.524719,0.837142,18.4329,24.3835,-6.46898> }}
union{cone{<2.83372,5.5447,1.30997> ,0.1296,<4.89679,6.72022,3.39201> ,0.12096}
sphere{<2.83372,5.5447,1.30997> ,0.1296}
texture{txttree matrix <0.495063,-0.868857,0,0.653284,0.372233,0.659289,-0.572828,-0.32639,0.75189,2.83372,5.5447,1.30997> }}
union{cone{<4.89679,6.72022,3.39201> ,0.12096,<7.43444,7.22092,5.5507> ,0.11232}
sphere{<4.89679,6.72022,3.39201> ,0.12096}
texture{txttree matrix <0.193578,-0.981085,0,0.75323,0.14862,0.640747,-0.628627,-0.124034,0.767752,4.89679,6.72022,3.39201> }}
union{cone{<7.43444,7.22092,5.5507> ,0.11232,<10.5344,8.43662,5.60343> ,0.10368}
sphere{<7.43444,7.22092,5.5507> ,0.11232}
texture{txttree matrix <0.365094,-0.930971,0,0.930854,0.365048,0.0158328,-0.0147399,-0.00578047,0.999875,7.43444,7.22092,5.5507> }}
union{cone{<10.5344,8.43662,5.60343> ,0.10368,<12.4479,11.1001,6.31954> ,0.09504}
sphere{<10.5344,8.43662,5.60343> ,0.10368}
texture{txttree matrix <0.812144,-0.583457,0,0.570026,0.793448,0.213331,-0.12447,-0.173256,0.97698,10.5344,8.43662,5.60343> }}
union{cone{<12.4479,11.1001,6.31954> ,0.09504,<14.3819,13.3867,7.36595> ,0.0864}
sphere{<12.4479,11.1001,6.31954> ,0.09504}
texture{txttree matrix <0.763526,-0.645777,0,0.609636,0.720795,0.329846,-0.213007,-0.251846,0.944035,12.4479,11.1001,6.31954> }}
union{cone{<14.3819,13.3867,7.36595> ,0.0864,<16.3561,16.0607,6.57> ,0.07776}
sphere{<14.3819,13.3867,7.36595> ,0.0864}
texture{txttree matrix <0.804485,-0.593973,0,0.577641,0.782364,-0.232888,0.138329,0.187355,0.972504,14.3819,13.3867,7.36595> }}
union{cone{<8.33237,8.39499,1.35641> ,0.1296,<10.8127,10.3039,1.58036> ,0.12096}
sphere{<8.33237,8.39499,1.35641> ,0.1296}
texture{txttree matrix <0.60991,-0.792471,0,0.79045,0.608354,0.0713716,-0.0565599,-0.0435302,0.99745,8.33237,8.39499,1.35641> }}
union{cone{<10.8127,10.3039,1.58036> ,0.12096,<12.9466,12.6565,1.62374> ,0.11232}
sphere{<10.8127,10.3039,1.58036> ,0.12096}
texture{txttree matrix <0.740678,-0.67186,0,0.671797,0.740609,0.0136557,-0.00917473,-0.0101145,0.999907,10.8127,10.3039,1.58036> }}
union{cone{<12.9466,12.6565,1.62374> ,0.11232,<15.0105,15.1466,0.883096> ,0.10368}
sphere{<12.9466,12.6565,1.62374> ,0.11232}
texture{txttree matrix <0.769927,-0.638132,0,0.62203,0.7505,-0.223221,0.142444,0.171864,0.974768,12.9466,12.6565,1.62374> }}
union{cone{<15.0105,15.1466,0.883096> ,0.10368,<17.0686,16.9785,-1.12902> ,0.09504}
sphere{<15.0105,15.1466,0.883096> ,0.10368}
texture{txttree matrix <0.664888,-0.746943,0,0.603214,0.536948,-0.589762,0.440519,0.392126,0.807577,15.0105,15.1466,0.883096> }}
union{cone{<17.0686,16.9785,-1.12902> ,0.09504,<18.2885,19.5967,-2.76503> ,0.0864}
sphere{<17.0686,16.9785,-1.12902> ,0.09504}
texture{txttree matrix <0.906429,-0.422359,0,0.367503,0.788702,-0.49284,0.208155,0.446724,0.87012,17.0686,16.9785,-1.12902> }}
union{cone{<18.2885,19.5967,-2.76503> ,0.0864,<20.6241,21.3526,-4.45908> ,0.07776}
sphere{<18.2885,19.5967,-2.76503> ,0.0864}
texture{txttree matrix <0.600907,-0.799319,0,0.691511,0.51986,-0.501555,0.400902,0.301388,0.865126,18.2885,19.5967,-2.76503> }}
union{cone{<7.65334,7.89472,1.66285> ,0.1296,<8.39153,9.16732,-1.08056> ,0.12096}
sphere{<7.65334,7.89472,1.66285> ,0.1296}
texture{txttree matrix <0.865008,-0.501759,0,0.237131,0.408802,-0.881278,0.442189,0.762312,0.472599,7.65334,7.89472,1.66285> }}
union{cone{<8.39153,9.16732,-1.08056> ,0.12096,<9.03908,11.8735,-2.67521> ,0.11232}
sphere{<8.39153,9.16732,-1.08056> ,0.12096}
texture{txttree matrix <0.972545,-0.232714,0,0.201909,0.843807,-0.497215,0.115709,0.483564,0.867627,8.39153,9.16732,-1.08056> }}
union{cone{<9.03908,11.8735,-2.67521> ,0.11232,<9.68982,14.5841,-4.31499> ,0.10368}
sphere{<9.03908,11.8735,-2.67521> ,0.11232}
texture{txttree matrix <0.97237,-0.233446,0,0.201214,0.838112,-0.507032,0.118365,0.493022,0.861927,9.03908,11.8735,-2.67521> }}
union{cone{<9.68982,14.5841,-4.31499> ,0.10368,<11.5487,16.3856,-6.39868> ,0.09504}
sphere{<9.68982,14.5841,-4.31499> ,0.10368}
texture{txttree matrix <0.695943,-0.718097,0,0.559393,0.542136,-0.627031,0.450269,0.436378,0.778994,9.68982,14.5841,-4.31499> }}
union{cone{<11.5487,16.3856,-6.39868> ,0.09504,<11.9049,18.7226,-8.78813> ,0.0864}
sphere{<11.5487,16.3856,-6.39868> ,0.09504}
texture{txttree matrix <0.988584,-0.150669,0,0.105966,0.695271,-0.710893,0.10711,0.702778,0.7033,11.5487,16.3856,-6.39868> }}
union{cone{<11.9049,18.7226,-8.78813> ,0.0864,<12.3125,21.2963,-10.6903> ,0.07776}
sphere{<11.9049,18.7226,-8.78813> ,0.0864}
texture{txttree matrix <0.987693,-0.156404,0,0.126325,0.797748,-0.58961,0.0922172,0.582354,0.807688,11.9049,18.7226,-8.78813> }}
union{cone{<10.584,9.95816,1.42797> ,0.1296,<12.6726,12.0763,2.94628> ,0.12096}
sphere{<10.584,9.95816,1.42797> ,0.1296}
texture{txttree matrix <0.71206,-0.702119,0,0.625368,0.634223,0.454617,-0.319195,-0.323715,0.890687,10.584,9.95816,1.42797> }}
union{cone{<12.6726,12.0763,2.94628> ,0.12096,<13.5032,15.0833,3.19408> ,0.11232}
sphere{<12.6726,12.0763,2.94628> ,0.12096}
texture{txttree matrix <0.963907,-0.26624,0,0.265404,0.96088,0.0791866,-0.0210827,-0.0763285,0.99686,12.6726,12.0763,2.94628> }}
union{cone{<13.5032,15.0833,3.19408> ,0.11232,<15.0251,17.8968,2.23948> ,0.10368}
sphere{<13.5032,15.0833,3.19408> ,0.11232}
texture{txttree matrix <0.879568,-0.475774,0,0.455906,0.842838,-0.28596,0.136053,0.251522,0.958241,13.5032,15.0833,3.19408> }}
union{cone{<15.0251,17.8968,2.23948> ,0.10368,<16.7571,20.49,1.81883> ,0.09504}
sphere{<15.0251,17.8968,2.23948> ,0.10368}
texture{txttree matrix <0.831572,-0.555418,0,0.550432,0.824108,-0.133682,0.0742496,0.111167,0.991024,15.0251,17.8968,2.23948> }}
union{cone{<16.7571,20.49,1.81883> ,0.09504,<18.6734,23.1381,1.48959> ,0.0864}
sphere{<16.7571,20.49,1.81883> ,0.09504}
texture{txttree matrix <0.810123,-0.58626,0,0.583309,0.806044,-0.100216,0.0587529,0.0811877,0.994966,16.7571,20.49,1.81883> }}
union{cone{<18.6734,23.1381,1.48959> ,0.0864,<19.6516,26.007,-0.0599232> ,0.07776}
sphere{<18.6734,23.1381,1.48959> ,0.0864}
texture{txttree matrix <0.94649,-0.322733,0,0.287362,0.842755,-0.455178,0.146901,0.430821,0.890401,18.6734,23.1381,1.48959> }}
union{cone{<3.03192,5.77457,1.26422> ,0.216,<4.25761,6.92002,0.811944> ,0.203657}
sphere{<3.03192,5.77457,1.26422> ,0.216}
texture{txttree matrix <0.682789,-0.730616,0,0.705429,0.659251,-0.260303,0.190181,0.177732,0.965527,3.03192,5.77457,1.26422> }}
union{cone{<4.25761,6.92002,0.811944> ,0.203657,<5.75597,7.19188,-0.103969> ,0.191314}
sphere{<4.25761,6.92002,0.811944> ,0.203657}
texture{txttree matrix <0.178524,-0.983936,0,0.843175,0.152985,-0.515414,0.507134,0.0920139,0.856941,4.25761,6.92002,0.811944> }}
union{cone{<5.75597,7.19188,-0.103969> ,0.191314,<6.65308,8.47521,-0.950621> ,0.178971}
sphere{<5.75597,7.19188,-0.103969> ,0.191314}
texture{txttree matrix <0.819597,-0.57294,0,0.503983,0.720952,-0.475636,0.272511,0.38983,0.879642,5.75597,7.19188,-0.103969> }}
union{cone{<6.65308,8.47521,-0.950621> ,0.178971,<8.08752,9.25708,-1.75397> ,0.166629}
sphere{<6.65308,8.47521,-0.950621> ,0.178971}
texture{txttree matrix <0.478592,-0.878038,0,0.787927,0.429475,-0.441274,0.387455,0.21119,0.897373,6.65308,8.47521,-0.950621> }}
union{cone{<8.08752,9.25708,-1.75397> ,0.166629,<9.08078,9.79104,-3.09015> ,0.154286}
sphere{<8.08752,9.25708,-1.75397> ,0.166629}
texture{txttree matrix <0.473498,-0.880795,0,0.568083,0.30539,-0.764211,0.673113,0.361852,0.644966,8.08752,9.25708,-1.75397> }}
union{cone{<9.08078,9.79104,-3.09015> ,0.154286,<10.0396,11.0145,-3.80128> ,0.141943}
sphere{<9.08078,9.79104,-3.09015> ,0.154286}
texture{txttree matrix <0.78711,-0.616813,0,0.560902,0.715762,-0.416022,0.256608,0.327455,0.909355,9.08078,9.79104,-3.09015> }}
union{cone{<10.0396,11.0145,-3.80128> ,0.141943,<11.0645,12.2476,-4.60414> ,0.1296}
sphere{<10.0396,11.0145,-3.80128> ,0.141943}
texture{txttree matrix <0.769028,-0.639215,0,0.571563,0.687638,-0.447737,0.2862,0.344323,0.894165,10.0396,11.0145,-3.80128> }}
union{cone{<11.0645,12.2476,-4.60414> ,0.1296,<12.5401,15.2289,-5.22292> ,0.12096}
sphere{<11.0645,12.2476,-4.60414> ,0.1296}
texture{txttree matrix <0.896228,-0.443595,0,0.436114,0.881113,-0.182877,0.0811231,0.163899,0.983136,11.0645,12.2476,-4.60414> }}
union{cone{<12.5401,15.2289,-5.22292> ,0.12096,<13.83,17.8072,-6.78525> ,0.11232}
sphere{<12.5401,15.2289,-5.22292> ,0.12096}
texture{txttree matrix <0.894323,-0.447422,0,0.393372,0.786286,-0.476459,0.213178,0.426108,0.879197,12.5401,15.2289,-5.22292> }}
union{cone{<13.83,17.8072,-6.78525> ,0.11232,<15.2955,20.5714,-8.01999> ,0.10368}
sphere{<13.83,17.8072,-6.78525> ,0.11232}
texture{txttree matrix <0.883518,-0.468396,0,0.435695,0.821834,-0.367094,0.171946,0.324335,0.930184,13.83,17.8072,-6.78525> }}
union{cone{<15.2955,20.5714,-8.01999> ,0.10368,<16.8376,23.3461,-8.3163> ,0.09504}
sphere{<15.2955,20.5714,-8.01999> ,0.10368}
texture{txttree matrix <0.874063,-0.485813,0,0.48371,0.87028,-0.0929402,0.0451516,0.0812356,0.995672,15.2955,20.5714,-8.01999> }}
union{cone{<16.8376,23.3461,-8.3163> ,0.09504,<18.6354,25.7145,-10.0149> ,0.0864}
sphere{<16.8376,23.3461,-8.3163> ,0.09504}
texture{txttree matrix <0.796527,-0.604603,0,0.524978,0.691626,-0.496037,0.299905,0.395106,0.868302,16.8376,23.3461,-8.3163> }}
union{cone{<18.6354,25.7145,-10.0149> ,0.0864,<20.5417,27.9252,-11.4958> ,0.07776}
sphere{<18.6354,25.7145,-10.0149> ,0.0864}
texture{txttree matrix <0.757323,-0.65304,0,0.58239,0.675391,-0.452404,0.295438,0.342616,0.891813,18.6354,25.7145,-10.0149> }}
union{cone{<4.2096,6.87516,0.829659> ,0.1296,<6.83779,8.16811,-0.943111> ,0.12096}
sphere{<4.2096,6.87516,0.829659> ,0.1296}
texture{txttree matrix <0.44143,-0.897296,0,0.767643,0.377646,-0.517791,0.464612,0.228569,0.855507,4.2096,6.87516,0.829659> }}
union{cone{<6.83779,8.16811,-0.943111> ,0.12096,<9.13229,10.2927,-1.98045> ,0.11232}
sphere{<6.83779,8.16811,-0.943111> ,0.12096}
texture{txttree matrix <0.67941,-0.733759,0,0.696439,0.644854,-0.314859,0.23103,0.213918,0.949139,6.83779,8.16811,-0.943111> }}
union{cone{<9.13229,10.2927,-1.98045> ,0.11232,<11.0272,12.4037,-3.37383> ,0.10368}
sphere{<9.13229,10.2927,-1.98045> ,0.11232}
texture{txttree matrix <0.744166,-0.667995,0,0.59957,0.667939,-0.440878,0.294504,0.328086,0.897567,9.13229,10.2927,-1.98045> }}
union{cone{<11.0272,12.4037,-3.37383> ,0.10368,<13.5988,14.2581,-3.84473> ,0.09504}
sphere{<11.0272,12.4037,-3.37383> ,0.10368}
texture{txttree matrix <0.584904,-0.811103,0,0.802301,0.578557,-0.146915,0.119163,0.0859311,0.989149,11.0272,12.4037,-3.37383> }}
union{cone{<13.5988,14.2581,-3.84473> ,0.09504,<15.084,16.8603,-5.01571> ,0.0864}
sphere{<13.5988,14.2581,-3.84473> ,0.09504}
texture{txttree matrix <0.868503,-0.495683,0,0.461678,0.808921,-0.364006,0.180432,0.31614,0.931397,13.5988,14.2581,-3.84473> }}
union{cone{<15.084,16.8603,-5.01571> ,0.0864,<17.5929,18.3736,-6.22893> ,0.07776}
sphere{<15.084,16.8603,-5.01571> ,0.0864}
texture{txttree matrix <0.516483,-0.856298,0,0.791157,0.477193,-0.382567,0.327591,0.197589,0.923928,15.084,16.8603,-5.01571> }}
union{cone{<10.8534,11.9936,-4.4388> ,0.1296,<13.5689,13.7371,-5.46299> ,0.12096}
sphere{<10.8534,11.9936,-4.4388> ,0.1296}
texture{txttree matrix <0.540284,-0.841483,0,0.802056,0.514969,-0.302511,0.254558,0.163442,0.953146,10.8534,11.9936,-4.4388> }}
union{cone{<13.5689,13.7371,-5.46299> ,0.12096,<15.8195,15.4901,-6.97387> ,0.11232}
sphere{<13.5689,13.7371,-5.46299> ,0.12096}
texture{txttree matrix <0.614482,-0.788931,0,0.697189,0.543026,-0.468027,0.369241,0.287594,0.883714,13.5689,13.7371,-5.46299> }}
union{cone{<15.8195,15.4901,-6.97387> ,0.11232,<17.1793,17.5669,-9.35432> ,0.10368}
sphere{<15.8195,15.4901,-6.97387> ,0.11232}
texture{txttree matrix <0.836624,-0.547777,0,0.395368,0.603849,-0.692135,0.379135,0.579057,0.721768,15.8195,15.4901,-6.97387> }}
union{cone{<17.1793,17.5669,-9.35432> ,0.10368,<18.1013,20.0048,-11.3444> ,0.09504}
sphere{<17.1793,17.5669,-9.35432> ,0.10368}
texture{txttree matrix <0.935337,-0.353758,0,0.28117,0.743412,-0.606862,0.214683,0.56762,0.794807,17.1793,17.5669,-9.35432> }}
union{cone{<18.1013,20.0048,-11.3444> ,0.09504,<19.631,21.7204,-13.6784> ,0.0864}
sphere{<18.1013,20.0048,-11.3444> ,0.09504}
texture{txttree matrix <0.746397,-0.665501,0,0.466954,0.523715,-0.712514,0.474179,0.531818,0.701658,18.1013,20.0048,-11.3444> }}
union{cone{<19.631,21.7204,-13.6784> ,0.0864,<20.6606,24.1755,-15.5224> ,0.07776}
sphere{<19.631,21.7204,-13.6784> ,0.0864}
texture{txttree matrix <0.922192,-0.386732,0,0.31792,0.758105,-0.569389,0.220201,0.525086,0.822069,19.631,21.7204,-13.6784> }}
union{cone{<6.65513,8.47633,-0.951768> ,0.1296,<8.51195,10.8936,-1.74363> ,0.12096}
sphere{<6.65513,8.47633,-0.951768> ,0.1296}
texture{txttree matrix <0.793034,-0.609178,0,0.589606,0.767555,-0.251444,0.153174,0.199403,0.967872,6.65513,8.47633,-0.951768> }}
union{cone{<8.51195,10.8936,-1.74363> ,0.12096,<9.73984,13.1448,-3.8093> ,0.11232}
sphere{<8.51195,10.8936,-1.74363> ,0.12096}
texture{txttree matrix <0.877909,-0.478828,0,0.372893,0.683682,-0.627319,0.300378,0.550729,0.778762,8.51195,10.8936,-1.74363> }}
union{cone{<9.73984,13.1448,-3.8093> ,0.11232,<11.0827,16.0241,-4.49782> ,0.10368}
sphere{<9.73984,13.1448,-3.8093> ,0.11232}
texture{txttree matrix <0.906282,-0.422673,0,0.413084,0.885721,-0.211799,0.089522,0.19195,0.977313,9.73984,13.1448,-3.8093> }}
union{cone{<11.0827,16.0241,-4.49782> ,0.10368,<13.3482,18.2901,-5.72696> ,0.09504}
sphere{<11.0827,16.0241,-4.49782> ,0.10368}
texture{txttree matrix <0.707181,-0.707033,0,0.66013,0.660268,-0.358156,0.253228,0.253281,0.933662,11.0827,16.0241,-4.49782> }}
union{cone{<13.3482,18.2901,-5.72696> ,0.09504,<15.4633,20.2285,-7.18701> ,0.0864}
sphere{<13.3482,18.2901,-5.72696> ,0.09504}
texture{txttree matrix <0.675631,-0.73724,0,0.65705,0.602141,-0.453554,0.334378,0.306435,0.891229,13.3482,18.2901,-5.72696> }}
union{cone{<15.4633,20.2285,-7.18701> ,0.0864,<16.7413,22.7112,-8.80871> ,0.07776}
sphere{<15.4633,20.2285,-7.18701> ,0.0864}
texture{txttree matrix <0.889113,-0.457689,0,0.395785,0.768857,-0.502209,0.229855,0.446521,0.864746,15.4633,20.2285,-7.18701> }}
union{cone{<2.33196,5.03198,1.22221> ,0.216,<2.85651,6.51577,1.90356> ,0.203657}
sphere{<2.33196,5.03198,1.22221> ,0.216}
texture{txttree matrix <0.942817,-0.33331,0,0.305875,0.865212,0.397301,-0.132425,-0.374582,0.917688,2.33196,5.03198,1.22221> }}
union{cone{<2.85651,6.51577,1.90356> ,0.203657,<2.28314,8.23633,1.87443> ,0.191314}
sphere{<2.85651,6.51577,1.90356> ,0.203657}
texture{txttree matrix <0.948707,0.316156,0,-0.316115,0.948585,-0.0160604,-0.00507759,0.0152366,0.999871,2.85651,6.51577,1.90356> }}
union{cone{<2.28314,8.23633,1.87443> ,0.191314,<2.12224,10.0053,2.07353> ,0.178971}
sphere{<2.28314,8.23633,1.87443> ,0.191314}
texture{txttree matrix <0.995889,0.0905823,0,-0.0900185,0.989691,0.111392,0.0100901,-0.110934,0.993777,2.28314,8.23633,1.87443> }}
union{cone{<2.12224,10.0053,2.07353> ,0.178971,<1.70709,11.6627,1.72009> ,0.166629}
sphere{<2.12224,10.0053,2.07353> ,0.178971}
texture{txttree matrix <0.970031,0.24298,0,-0.237942,0.949919,-0.202576,-0.0492219,0.196505,0.979267,2.12224,10.0053,2.07353> }}
union{cone{<1.70709,11.6627,1.72009> ,0.166629,<1.47769,13.2364,1.2162> ,0.154286}
sphere{<1.70709,11.6627,1.72009> ,0.166629}
texture{txttree matrix <0.989542,0.144242,0,-0.137506,0.943326,-0.302039,-0.0435669,0.298881,0.953295,1.70709,11.6627,1.72009> }}
union{cone{<1.47769,13.2364,1.2162> ,0.154286,<1.32405,14.8997,1.09151> ,0.141943}
sphere{<1.47769,13.2364,1.2162> ,0.154286}
texture{txttree matrix <0.995761,0.0919832,0,-0.091728,0.992998,-0.0744385,-0.00684709,0.0741229,0.997226,1.47769,13.2364,1.2162> }}
union{cone{<1.32405,14.8997,1.09151> ,0.141943,<1.62537,16.5802,1.00362> ,0.1296}
sphere{<1.32405,14.8997,1.09151> ,0.141943}
texture{txttree matrix <0.984302,-0.176493,0,0.176259,0.983,-0.051416,0.00907455,0.0506089,0.998677,1.32405,14.8997,1.09151> }}
union{cone{<1.62537,16.5802,1.00362> ,0.1296,<2.02536,19.416,2.75884> ,0.12096}
sphere{<1.62537,16.5802,1.00362> ,0.1296}
texture{txttree matrix <0.990199,-0.139665,0,0.11908,0.844255,0.522546,-0.0729815,-0.517424,0.852611,1.62537,16.5802,1.00362> }}
union{cone{<2.02536,19.416,2.75884> ,0.12096,<1.68096,22.5216,3.42296> ,0.11232}
sphere{<2.02536,19.416,2.75884> ,0.12096}
texture{txttree matrix <0.993907,0.11022,0,-0.107811,0.97219,0.207901,0.0229147,-0.206634,0.97815,2.02536,19.416,2.75884> }}
union{cone{<1.68096,22.5216,3.42296> ,0.11232,<2.62677,25.317,4.47804> ,0.10368}
sphere{<1.68096,22.5216,3.42296> ,0.11232}
texture{txttree matrix <0.947251,-0.320493,0,0.301786,0.89196,0.33665,-0.107894,-0.318892,0.94163,1.68096,22.5216,3.42296> }}
union{cone{<2.62677,25.317,4.47804> ,0.10368,<3.95441,28.4522,4.62843> ,0.09504}
sphere{<2.62677,25.317,4.47804> ,0.10368}
texture{txttree matrix <0.92084,-0.389941,0,0.389561,0.919943,0.0441293,-0.0172078,-0.040636,0.999026,2.62677,25.317,4.47804> }}
union{cone{<3.95441,28.4522,4.62843> ,0.09504,<3.41366,31.6618,4.54535> ,0.0864}
sphere{<3.95441,28.4522,4.62843> ,0.09504}
texture{txttree matrix <0.986103,0.166135,0,-0.166081,0.985782,-0.0255158,-0.00423907,0.0251612,0.999674,3.95441,28.4522,4.62843> }}
union{cone{<3.41366,31.6618,4.54535> ,0.0864,<3.87155,34.8488,4.61941> ,0.07776}
sphere{<3.41366,31.6618,4.54535> ,0.0864}
texture{txttree matrix <0.989836,-0.142213,0,0.142175,0.989574,0.0229947,-0.00327014,-0.022761,0.999736,3.41366,31.6618,4.54535> }}
union{cone{<2.21298,9.00767,1.96124> ,0.1296,<2.72112,11.8943,3.11049> ,0.12096}
sphere{<2.21298,9.00767,1.96124> ,0.1296}
texture{txttree matrix <0.984858,-0.173365,0,0.161402,0.916895,0.365039,-0.0632852,-0.359512,0.930992,2.21298,9.00767,1.96124> }}
union{cone{<2.72112,11.8943,3.11049> ,0.12096,<3.65627,15.0782,2.73227> ,0.11232}
sphere{<2.72112,11.8943,3.11049> ,0.12096}
texture{txttree matrix <0.95947,-0.281811,0,0.279998,0.953298,-0.113245,0.0319137,0.108655,0.993567,2.72112,11.8943,3.11049> }}
union{cone{<3.65627,15.0782,2.73227> ,0.11232,<4.04256,18.18,2.09245> ,0.10368}
sphere{<3.65627,15.0782,2.73227> ,0.11232}
texture{txttree matrix <0.992334,-0.123582,0,0.121072,0.972178,-0.20053,0.0247819,0.198993,0.979687,3.65627,15.0782,2.73227> }}
union{cone{<4.04256,18.18,2.09245> ,0.10368,<4.03117,21.3652,2.35913> ,0.09504}
sphere{<4.04256,18.18,2.09245> ,0.10368}
texture{txttree matrix <0.999994,0.00357699,0,-0.00356452,0.996507,0.0834336,0.000298441,-0.0834331,0.996513,4.04256,18.18,2.09245> }}
union{cone{<4.03117,21.3652,2.35913> ,0.09504,<5.0464,24.5337,2.46974> ,0.0864}
sphere{<4.03117,21.3652,2.35913> ,0.09504}
texture{txttree matrix <0.95231,-0.305131,0,0.304963,0.951784,0.0332255,-0.0101382,-0.031641,0.999448,4.03117,21.3652,2.35913> }}
union{cone{<5.0464,24.5337,2.46974> ,0.0864,<5.89656,27.7769,2.02219> ,0.07776}
sphere{<5.0464,24.5337,2.46974> ,0.0864}
texture{txttree matrix <0.967318,-0.253568,0,0.251338,0.958813,-0.13231,0.0335496,0.127986,0.991208,5.0464,24.5337,2.46974> }}
union{cone{<1.59541,16.4131,1.01236> ,0.1296,<1.98317,19.6695,0.305595> ,0.12096}
sphere{<1.59541,16.4131,1.01236> ,0.1296}
texture{txttree matrix <0.992985,-0.118242,0,0.115588,0.970698,-0.210678,0.0249109,0.2092,0.977556,1.59541,16.4131,1.01236> }}
union{cone{<1.98317,19.6695,0.305595> ,0.12096,<1.03885,22.925,-0.17775> ,0.11232}
sphere{<1.98317,19.6695,0.305595> ,0.12096}
texture{txttree matrix <0.960412,0.278584,0,-0.275795,0.950794,-0.141164,-0.0393261,0.135576,0.989986,1.98317,19.6695,0.305595> }}
union{cone{<1.03885,22.925,-0.17775> ,0.11232,<0.90451,26.03,-1.10492> ,0.10368}
sphere{<1.03885,22.925,-0.17775> ,0.11232}
texture{txttree matrix <0.999065,0.043225,0,-0.0414211,0.957372,-0.285873,-0.0123568,0.285605,0.958268,1.03885,22.925,-0.17775> }}
union{cone{<0.90451,26.03,-1.10492> ,0.10368,<0.0203208,29.0897,-2.13699> ,0.09504}
sphere{<0.90451,26.03,-1.10492> ,0.10368}
texture{txttree matrix <0.96069,0.277623,0,-0.264102,0.913902,-0.308273,-0.0855837,0.296155,0.951298,0.90451,26.03,-1.10492> }}
union{cone{<0.0203208,29.0897,-2.13699> ,0.09504,<0.32461,31.8829,-3.51411> ,0.0864}
sphere{<0.0203208,29.0897,-2.13699> ,0.09504}
texture{txttree matrix <0.994119,-0.108297,0,0.0972452,0.892666,-0.440103,0.0476619,0.437515,0.897947,0.0203208,29.0897,-2.13699> }}
union{cone{<0.32461,31.8829,-3.51411> ,0.0864,<-0.252023,34.399,-5.72609> ,0.07776}
sphere{<0.32461,31.8829,-3.51411> ,0.0864}
texture{txttree matrix <0.97473,0.223387,0,-0.169627,0.740153,-0.650692,-0.145356,0.634249,0.759342,0.32461,31.8829,-3.51411> }}
union{cone{<2.34985,8.03615,1.87782> ,0.1296,<0.810965,11.039,2.24855> ,0.12096}
sphere{<2.34985,8.03615,1.87782> ,0.1296}
texture{txttree matrix <0.889943,0.456072,0,-0.453343,0.884619,0.109217,0.0498106,-0.0971966,0.994018,2.34985,8.03615,1.87782> }}
union{cone{<0.810965,11.039,2.24855> ,0.12096,<-0.18887,14.0087,1.50499> ,0.11232}
sphere{<0.810965,11.039,2.24855> ,0.12096}
texture{txttree matrix <0.947729,0.319076,0,-0.310456,0.922123,-0.230883,-0.0736692,0.218814,0.972982,0.810965,11.039,2.24855> }}
union{cone{<-0.18887,14.0087,1.50499> ,0.11232,<-2.1337,16.2724,0.251431> ,0.10368}
sphere{<-0.18887,14.0087,1.50499> ,0.11232}
texture{txttree matrix <0.758496,0.651677,0,-0.600825,0.699309,-0.387267,-0.252373,0.29374,0.921968,-0.18887,14.0087,1.50499> }}
union{cone{<-2.1337,16.2724,0.251431> ,0.10368,<-2.63431,19.2033,-0.759297> ,0.09504}
sphere{<-2.1337,16.2724,0.251431> ,0.10368}
texture{txttree matrix <0.985725,0.168364,0,-0.159406,0.933278,-0.321842,-0.0541868,0.317248,0.946793,-2.1337,16.2724,0.251431> }}
union{cone{<-2.63431,19.2033,-0.759297> ,0.09504,<-4.40808,21.6492,-2.13955> ,0.0864}
sphere{<-2.63431,19.2033,-0.759297> ,0.09504}
texture{txttree matrix <0.809541,0.587063,0,-0.533984,0.736347,-0.415518,-0.243935,0.336379,0.909585,-2.63431,19.2033,-0.759297> }}
union{cone{<-4.40808,21.6492,-2.13955> ,0.0864,<-5.14303,24.907,-2.64177> ,0.07776}
sphere{<-4.40808,21.6492,-2.13955> ,0.0864}
texture{txttree matrix <0.975484,0.220071,0,-0.217624,0.964637,-0.148709,-0.0327266,0.145063,0.988881,-4.40808,21.6492,-2.13955> }}
union{cone{<-0.987127,5.70041,1.77654> ,0.36,<-1.01533,6.62074,1.46175> ,0.342}
sphere{<-0.987127,5.70041,1.77654> ,0.36}
texture{txttree matrix <0.999531,0.0306345,0,-0.0289872,0.945786,-0.323495,-0.00991008,0.323343,0.94623,-0.987127,5.70041,1.77654> }}
union{cone{<-1.01533,6.62074,1.46175> ,0.342,<-0.956368,7.56969,1.43325> ,0.324}
sphere{<-1.01533,6.62074,1.46175> ,0.342}
texture{txttree matrix <0.998075,-0.0620179,0,0.0619901,0.997627,-0.0299566,0.00185785,0.0298989,0.999551,-1.01533,6.62074,1.46175> }}
union{cone{<-0.956368,7.56969,1.43325> ,0.324,<-0.954076,8.46479,1.24829> ,0.306}
sphere{<-0.956368,7.56969,1.43325> ,0.324}
texture{txttree matrix <0.999997,-0.00256071,0,0.00250773,0.979308,-0.202358,0.00051818,0.202357,0.979312,-0.956368,7.56969,1.43325> }}
union{cone{<-0.954076,8.46479,1.24829> ,0.306,<-0.685005,9.14226,0.691159> ,0.288}
sphere{<-0.954076,8.46479,1.24829> ,0.306}
texture{txttree matrix <0.929381,-0.369121,0,0.293272,0.738406,-0.607246,0.224148,0.564363,0.794514,-0.954076,8.46479,1.24829> }}
union{cone{<-0.685005,9.14226,0.691159> ,0.288,<-0.377905,9.90037,0.23648> ,0.27}
sphere{<-0.685005,9.14226,0.691159> ,0.288}
texture{txttree matrix <0.926841,-0.375453,0,0.32816,0.810094,-0.485859,0.182417,0.450314,0.874037,-0.685005,9.14226,0.691159> }}
union{cone{<-0.377905,9.90037,0.23648> ,0.27,<-0.215545,10.7743,-0.199077> ,0.252}
sphere{<-0.377905,9.90037,0.23648> ,0.27}
texture{txttree matrix <0.983178,-0.182648,0,0.164017,0.882891,-0.440002,0.0803655,0.432601,0.897997,-0.377905,9.90037,0.23648> }}
union{cone{<-0.215545,10.7743,-0.199077> ,0.252,<-0.239868,11.6165,-0.740021> ,0.234}
sphere{<-0.215545,10.7743,-0.199077> ,0.252}
texture{txttree matrix <0.999583,0.0288691,0,-0.0242932,0.841143,-0.540266,-0.015597,0.540041,0.841494,-0.215545,10.7743,-0.199077> }}
union{cone{<-0.239868,11.6165,-0.740021> ,0.234,<-0.280174,12.5165,-1.09291> ,0.216}
sphere{<-0.239868,11.6165,-0.740021> ,0.234}
texture{txttree matrix <0.998999,0.0447395,0,-0.0416576,0.930182,-0.364727,-0.0163177,0.364362,0.931114,-0.239868,11.6165,-0.740021> }}
union{cone{<-0.280174,12.5165,-1.09291> ,0.216,<-0.197793,14.0802,-0.246312> ,0.203657}
sphere{<-0.280174,12.5165,-1.09291> ,0.216}
texture{txttree matrix <0.998615,-0.0526117,0,0.0462804,0.878441,0.475605,-0.0250224,-0.474946,0.879659,-0.280174,12.5165,-1.09291> }}
union{cone{<-0.197793,14.0802,-0.246312> ,0.203657,<-0.888889,15.7171,-0.364245> ,0.191314}
sphere{<-0.197793,14.0802,-0.246312> ,0.203657}
texture{txttree matrix <0.921257,0.388954,0,-0.3881,0.919235,-0.066228,-0.0257597,0.0610131,0.997805,-0.197793,14.0802,-0.246312> }}
union{cone{<-0.888889,15.7171,-0.364245> ,0.191314,<-1.03482,17.3168,0.0980883> ,0.178971}
sphere{<-0.888889,15.7171,-0.364245> ,0.191314}
texture{txttree matrix <0.995865,0.0908427,0,-0.0872989,0.957016,0.276585,0.0251257,-0.275441,0.96099,-0.888889,15.7171,-0.364245> }}
union{cone{<-1.03482,17.3168,0.0980883> ,0.178971,<-1.45235,18.9863,-0.270279> ,0.166629}
sphere{<-1.03482,17.3168,0.0980883> ,0.178971}
texture{txttree matrix <0.970121,0.242623,0,-0.237248,0.948632,-0.209311,-0.0507836,0.203057,0.977849,-1.03482,17.3168,0.0980883> }}
union{cone{<-1.45235,18.9863,-0.270279> ,0.166629,<-1.14752,20.6315,-0.769841> ,0.154286}
sphere{<-1.45235,18.9863,-0.270279> ,0.166629}
texture{txttree matrix <0.983264,-0.182189,0,0.174573,0.942165,-0.286092,0.0521228,0.281304,0.958202,-1.45235,18.9863,-0.270279> }}
union{cone{<-1.14752,20.6315,-0.769841> ,0.154286,<-0.998762,22.3297,-0.83477> ,0.141943}
sphere{<-1.14752,20.6315,-0.769841> ,0.154286}
texture{txttree matrix <0.996185,-0.087265,0,0.0872018,0.995463,-0.0380617,0.00332145,0.0379165,0.999275,-1.14752,20.6315,-0.769841> }}
union{cone{<-0.998762,22.3297,-0.83477> ,0.141943,<-0.964667,24.1029,-1.27536> ,0.1296}
sphere{<-0.998762,22.3297,-0.83477> ,0.141943}
texture{txttree matrix <0.999815,-0.0192239,0,0.0186569,0.970324,-0.241088,0.00463465,0.241043,0.970503,-0.998762,22.3297,-0.83477> }}
union{cone{<-0.964667,24.1029,-1.27536> ,0.1296,<-0.732459,27.0346,-0.133228> ,0.12096}
sphere{<-0.964667,24.1029,-1.27536> ,0.1296}
texture{txttree matrix <0.996878,-0.0789608,0,0.0736046,0.929256,0.36203,-0.0285862,-0.3609,0.932166,-0.964667,24.1029,-1.27536> }}
union{cone{<-0.732459,27.0346,-0.133228> ,0.12096,<0.059737,30.2015,-0.676309> ,0.11232}
sphere{<-0.732459,27.0346,-0.133228> ,0.12096}
texture{txttree matrix <0.97011,-0.242665,0,0.239375,0.956959,-0.164101,0.0398217,0.159196,0.986443,-0.732459,27.0346,-0.133228> }}
union{cone{<0.059737,30.2015,-0.676309> ,0.11232,<0.814321,33.4528,-0.422092> ,0.10368}
sphere{<0.059737,30.2015,-0.676309> ,0.11232}
texture{txttree matrix <0.974109,-0.226081,0,0.225428,0.971295,0.075946,-0.0171699,-0.0739797,0.997112,0.059737,30.2015,-0.676309> }}
union{cone{<0.814321,33.4528,-0.422092> ,0.10368,<1.0571,36.5713,0.0584048> ,0.09504}
sphere{<0.814321,33.4528,-0.422092> ,0.10368}
texture{txttree matrix <0.996983,-0.0776184,0,0.0767185,0.985424,0.151835,-0.0117852,-0.151377,0.988406,0.814321,33.4528,-0.422092> }}
union{cone{<1.0571,36.5713,0.0584048> ,0.09504,<0.404592,39.6793,-0.984933> ,0.0864}
sphere{<1.0571,36.5713,0.0584048> ,0.09504}
texture{txttree matrix <0.978665,0.205462,0,-0.195198,0.929776,-0.312114,-0.0641276,0.305455,0.950045,1.0571,36.5713,0.0584048> }}
union{cone{<0.404592,39.6793,-0.984933> ,0.0864,<0.762871,42.8479,-1.31911> ,0.07776}
sphere{<0.404592,39.6793,-0.984933> ,0.0864}
texture{txttree matrix <0.993668,-0.112357,0,0.111745,0.988256,-0.104228,0.0117107,0.103568,0.994553,0.404592,39.6793,-0.984933> }}
union{cone{<-1.00244,22.2877,-0.833167> ,0.1296,<-0.970266,25.4374,-2.14215> ,0.12096}
sphere{<-1.00244,22.2877,-0.833167> ,0.1296}
texture{txttree matrix <0.999948,-0.0102131,0,0.00943111,0.923387,-0.383755,0.00391932,0.383735,0.923435,-1.00244,22.2877,-0.833167> }}
union{cone{<-0.970266,25.4374,-2.14215> ,0.12096,<-0.304961,27.8224,-4.19406> ,0.11232}
sphere{<-0.970266,25.4374,-2.14215> ,0.12096}
texture{txttree matrix <0.963226,-0.268692,0,0.206887,0.741661,-0.638072,0.171445,0.614608,0.769976,-0.970266,25.4374,-2.14215> }}
union{cone{<-0.304961,27.8224,-4.19406> ,0.11232,<-0.272847,30.9122,-4.96927> ,0.10368}
sphere{<-0.304961,27.8224,-4.19406> ,0.11232}
texture{txttree matrix <0.999946,-0.0103931,0,0.0100807,0.969889,-0.243339,0.00252904,0.243326,0.969941,-0.304961,27.8224,-4.19406> }}
union{cone{<-0.272847,30.9122,-4.96927> ,0.10368,<0.877324,33.9045,-6.16156> ,0.09504}
sphere{<-0.272847,30.9122,-4.96927> ,0.10368}
texture{txttree matrix <0.933418,-0.35879,0,0.336284,0.874867,-0.348599,0.125074,0.325388,0.937272,-0.272847,30.9122,-4.96927> }}
union{cone{<0.877324,33.9045,-6.16156> ,0.09504,<2.18414,36.4361,-7.96922> ,0.0864}
sphere{<0.877324,33.9045,-6.16156> ,0.09504}
texture{txttree matrix <0.888599,-0.458684,0,0.387304,0.750316,-0.535744,0.245737,0.476062,0.84438,0.877324,33.9045,-6.16156> }}
union{cone{<2.18414,36.4361,-7.96922> ,0.0864,<2.30318,38.8361,-10.1815> ,0.07776}
sphere{<2.18414,36.4361,-7.96922> ,0.0864}
texture{txttree matrix <0.998772,-0.0495427,0,0.0364477,0.73478,-0.677325,0.0335565,0.676494,0.735684,2.18414,36.4361,-7.96922> }}
union{cone{<-1.39381,19.3023,-0.366219> ,0.1296,<-2.29601,21.2568,-3.04196> ,0.12096}
sphere{<-1.39381,19.3023,-0.366219> ,0.1296}
texture{txttree matrix <0.907939,0.419102,0,-0.262712,0.569137,-0.779144,-0.326541,0.707415,0.626845,-1.39381,19.3023,-0.366219> }}
union{cone{<-2.29601,21.2568,-3.04196> ,0.12096,<-3.2426,24.2968,-4.13602> ,0.11232}
sphere{<-2.29601,21.2568,-3.04196> ,0.12096}
texture{txttree matrix <0.954785,0.297298,0,-0.281162,0.902964,-0.324966,-0.0966117,0.310273,0.945726,-2.29601,21.2568,-3.04196> }}
union{cone{<-3.2426,24.2968,-4.13602> ,0.11232,<-2.94056,27.3342,-5.4312> ,0.10368}
sphere{<-3.2426,24.2968,-4.13602> ,0.11232}
texture{txttree matrix <0.995092,-0.098955,0,0.0910934,0.916036,-0.390615,0.0386534,0.388698,0.920554,-3.2426,24.2968,-4.13602> }}
union{cone{<-2.94056,27.3342,-5.4312> ,0.10368,<-3.62467,30.047,-7.22454> ,0.09504}
sphere{<-2.94056,27.3342,-5.4312> ,0.10368}
texture{txttree matrix <0.969643,0.244524,0,-0.205862,0.816333,-0.539649,-0.131957,0.523268,0.84189,-2.94056,27.3342,-5.4312> }}
union{cone{<-3.62467,30.047,-7.22454> ,0.09504,<-4.06452,32.9627,-8.61737> ,0.0864}
sphere{<-3.62467,30.047,-7.22454> ,0.09504}
texture{txttree matrix <0.988812,0.149169,0,-0.134879,0.894085,-0.427106,-0.063711,0.422328,0.904201,-3.62467,30.047,-7.22454> }}
union{cone{<-4.06452,32.9627,-8.61737> ,0.0864,<-4.18717,35.3204,-10.7051> ,0.07776}
sphere{<-4.06452,32.9627,-8.61737> ,0.0864}
texture{txttree matrix <0.99865,0.0519514,0,-0.038918,0.748112,-0.662431,-0.0344142,0.661536,0.749123,-4.06452,32.9627,-8.61737> }}
union{cone{<-0.242109,11.6666,-0.759637> ,0.216,<0.733333,13.1081,-0.709562> ,0.203657}
sphere{<-0.242109,11.6666,-0.759637> ,0.216}
texture{txttree matrix <0.828211,-0.560417,0,0.560185,0.827868,0.0287573,-0.0161161,-0.0238171,0.999586,-0.242109,11.6666,-0.759637> }}
union{cone{<0.733333,13.1081,-0.709562> ,0.203657,<1.33675,14.4919,-1.69026> ,0.191314}
sphere{<0.733333,13.1081,-0.709562> ,0.203657}
texture{txttree matrix <0.916642,-0.399708,0,0.335191,0.768687,-0.544764,0.217747,0.499354,0.83859,0.733333,13.1081,-0.709562> }}
union{cone{<1.33675,14.4919,-1.69026> ,0.191314,<2.28157,15.62,-2.55867> ,0.178971}
sphere{<1.33675,14.4919,-1.69026> ,0.191314}
texture{txttree matrix <0.766621,-0.642099,0,0.552979,0.660218,-0.508259,0.326353,0.389642,0.861205,1.33675,14.4919,-1.69026> }}
union{cone{<2.28157,15.62,-2.55867> ,0.178971,<2.52054,17.1172,-3.28467> ,0.166629}
sphere{<2.28157,15.62,-2.55867> ,0.178971}
texture{txttree matrix <0.987501,-0.157614,0,0.142157,0.890659,-0.431878,0.0680699,0.426479,0.901932,2.28157,15.62,-2.55867> }}
union{cone{<2.52054,17.1172,-3.28467> ,0.166629,<3.08609,18.7425,-3.60946> ,0.154286}
sphere{<2.52054,17.1172,-3.28467> ,0.166629}
texture{txttree matrix <0.944456,-0.328638,0,0.322936,0.928071,-0.185462,0.06095,0.175161,0.982651,2.52054,17.1172,-3.28467> }}
union{cone{<3.08609,18.7425,-3.60946> ,0.154286,<3.88302,20.2802,-4.21264> ,0.141943}
sphere{<3.08609,18.7425,-3.60946> ,0.154286}
texture{txttree matrix <0.887847,-0.460138,0,0.434539,0.838453,-0.328895,0.151337,0.292009,0.944366,3.08609,18.7425,-3.60946> }}
union{cone{<3.88302,20.2802,-4.21264> ,0.141943,<4.61046,21.5298,-5.07329> ,0.1296}
sphere{<3.88302,20.2802,-4.21264> ,0.141943}
texture{txttree matrix <0.864233,-0.503092,0,0.432308,0.742636,-0.511471,0.257317,0.44203,0.859301,3.88302,20.2802,-4.21264> }}
union{cone{<4.61046,21.5298,-5.07329> ,0.1296,<6.64206,23.7132,-6.63273> ,0.12096}
sphere{<4.61046,21.5298,-5.07329> ,0.1296}
texture{txttree matrix <0.732102,-0.681195,0,0.603654,0.648767,-0.46336,0.315639,0.339227,0.88617,4.61046,21.5298,-5.07329> }}
union{cone{<6.64206,23.7132,-6.63273> ,0.12096,<8.26744,26.2761,-7.84332> ,0.11232}
sphere{<6.64206,23.7132,-6.63273> ,0.12096}
texture{txttree matrix <0.844487,-0.535576,0,0.497458,0.784384,-0.370509,0.198436,0.31289,0.928829,6.64206,23.7132,-6.63273> }}
union{cone{<8.26744,26.2761,-7.84332> ,0.11232,<8.86172,29.4186,-8.44901> ,0.10368}
sphere{<8.26744,26.2761,-7.84332> ,0.11232}
texture{txttree matrix <0.982585,-0.185816,0,0.182571,0.965425,-0.186074,0.0345754,0.182833,0.982536,8.26744,26.2761,-7.84332> }}
union{cone{<8.86172,29.4186,-8.44901> ,0.10368,<9.52986,32.3987,-9.14872> ,0.09504}
sphere{<8.86172,29.4186,-8.44901> ,0.10368}
texture{txttree matrix <0.975776,-0.218773,0,0.213248,0.951131,-0.223326,0.0488578,0.217916,0.974744,8.86172,29.4186,-8.44901> }}
union{cone{<9.52986,32.3987,-9.14872> ,0.09504,<10.35,35.4158,-10.0948> ,0.0864}
sphere{<9.52986,32.3987,-9.14872> ,0.09504}
texture{txttree matrix <0.964987,-0.262299,0,0.251058,0.923632,-0.28961,0.0759643,0.279469,0.957145,9.52986,32.3987,-9.14872> }}
union{cone{<10.35,35.4158,-10.0948> ,0.0864,<11.2993,37.6983,-12.2572> ,0.07776}
sphere{<10.35,35.4158,-10.0948> ,0.0864}
texture{txttree matrix <0.923314,-0.384047,0,0.289058,0.694944,-0.658406,0.252858,0.607915,0.752663,10.35,35.4158,-10.0948> }}
union{cone{<-0.0900502,11.8913,-0.751831> ,0.1296,<2.41025,13.9575,0.0930836> ,0.12096}
sphere{<-0.0900502,11.8913,-0.751831> ,0.1296}
texture{txttree matrix <0.637019,-0.770848,0,0.745955,0.616448,0.252077,-0.194313,-0.160578,0.967707,-0.0900502,11.8913,-0.751831> }}
union{cone{<2.41025,13.9575,0.0930836> ,0.12096,<4.33562,16.3324,0.951773> ,0.11232}
sphere{<2.41025,13.9575,0.0930836> ,0.12096}
texture{txttree matrix <0.776796,-0.629752,0,0.606293,0.747859,0.270399,-0.170285,-0.210045,0.962748,2.41025,13.9575,0.0930836> }}
union{cone{<4.33562,16.3324,0.951773> ,0.11232,<7.07647,18.1596,0.872737> ,0.10368}
sphere{<4.33562,16.3324,0.951773> ,0.11232}
texture{txttree matrix <0.554679,-0.832065,0,0.831825,0.554519,-0.0239867,0.0199585,0.0133049,0.999712,4.33562,16.3324,0.951773> }}
union{cone{<7.07647,18.1596,0.872737> ,0.10368,<8.1549,21.0601,0.411015> ,0.09504}
sphere{<7.07647,18.1596,0.872737> ,0.10368}
texture{txttree matrix <0.93731,-0.348496,0,0.34468,0.927048,-0.147572,0.0514284,0.138321,0.989051,7.07647,18.1596,0.872737> }}
union{cone{<8.1549,21.0601,0.411015> ,0.09504,<10.489,23.2057,0.216516> ,0.0864}
sphere{<8.1549,21.0601,0.411015> ,0.09504}
texture{txttree matrix <0.676753,-0.73621,0,0.734828,0.675483,-0.0612333,0.0450806,0.0414399,0.998123,8.1549,21.0601,0.411015> }}
union{cone{<10.489,23.2057,0.216516> ,0.0864,<12.2379,25.5427,-1.15569> ,0.07776}
sphere{<10.489,23.2057,0.216516> ,0.0864}
texture{txttree matrix <0.800628,-0.599162,0,0.542234,0.724557,-0.425439,0.254907,0.340619,0.904987,10.489,23.2057,0.216516> }}
union{cone{<1.90261,15.1675,-2.21036> ,0.1296,<4.35146,15.1849,-4.40613> ,0.12096}
sphere{<1.90261,15.1675,-2.21036> ,0.1296}
texture{txttree matrix <0.00708816,-0.999975,0,0.74452,0.00527741,-0.667579,0.667563,0.00473191,0.744539,1.90261,15.1675,-2.21036> }}
union{cone{<4.35146,15.1849,-4.40613> ,0.12096,<6.18435,16.9576,-6.21377> ,0.11232}
sphere{<4.35146,15.1849,-4.40613> ,0.12096}
texture{txttree matrix <0.695201,-0.718815,0,0.58641,0.567145,-0.578333,0.415715,0.402058,0.815801,4.35146,15.1849,-4.40613> }}
union{cone{<6.18435,16.9576,-6.21377> ,0.11232,<7.56731,19.3668,-8.19573> ,0.10368}
sphere{<6.18435,16.9576,-6.21377> ,0.11232}
texture{txttree matrix <0.867274,-0.497831,0,0.405262,0.706008,-0.580789,0.289135,0.503703,0.814054,6.18435,16.9576,-6.21377> }}
union{cone{<7.56731,19.3668,-8.19573> ,0.10368,<8.2592,21.6887,-10.5129> ,0.09504}
sphere{<7.56731,19.3668,-8.19573> ,0.10368}
texture{txttree matrix <0.958355,-0.285581,0,0.206381,0.692577,-0.69119,0.19739,0.662405,0.722673,7.56731,19.3668,-8.19573> }}
union{cone{<8.2592,21.6887,-10.5129> ,0.09504,<10.0632,22.9295,-12.8052> ,0.0864}
sphere{<8.2592,21.6887,-10.5129> ,0.09504}
texture{txttree matrix <0.566706,-0.82392,0,0.56909,0.39143,-0.723131,0.595802,0.409803,0.690711,8.2592,21.6887,-10.5129> }}
union{cone{<10.0632,22.9295,-12.8052> ,0.0864,<10.7734,25.0295,-15.1352> ,0.07776}
sphere{<10.0632,22.9295,-12.8052> ,0.0864}
texture{txttree matrix <0.947288,-0.320384,0,0.220841,0.652966,-0.724476,0.23211,0.686287,0.6893,10.0632,22.9295,-12.8052> }}
union{cone{<0.981922,13.6782,-1.11358> ,0.1296,<1.15222,14.9437,-4.00987> ,0.12096}
sphere{<0.981922,13.6782,-1.11358> ,0.1296}
texture{txttree matrix <0.991067,-0.133367,0,0.053803,0.399815,-0.915015,0.122033,0.906841,0.403419,0.981922,13.6782,-1.11358> }}
union{cone{<1.15222,14.9437,-4.00987> ,0.12096,<0.858726,16.5162,-6.82428> ,0.11232}
sphere{<1.15222,14.9437,-4.00987> ,0.12096}
texture{txttree matrix <0.983024,0.183478,0,-0.0906628,0.485746,-0.869386,-0.159513,0.854627,0.494134,1.15222,14.9437,-4.00987> }}
union{cone{<0.858726,16.5162,-6.82428> ,0.11232,<1.43448,17.9262,-9.89027> ,0.10368}
sphere{<0.858726,16.5162,-6.82428> ,0.11232}
texture{txttree matrix <0.92579,-0.378037,0,0.168181,0.411865,-0.895591,0.338567,0.829129,0.444879,0.858726,16.5162,-6.82428> }}
union{cone{<1.43448,17.9262,-9.89027> ,0.10368,<1.34559,19.5846,-12.7528> ,0.09504}
sphere{<1.43448,17.9262,-9.89027> ,0.10368}
texture{txttree matrix <0.998567,0.0535233,0,-0.02686,0.501117,-0.864963,-0.0462957,0.863723,0.501836,1.43448,17.9262,-9.89027> }}
union{cone{<1.34559,19.5846,-12.7528> ,0.09504,<1.42649,22.153,-14.6482> ,0.0864}
sphere{<1.34559,19.5846,-12.7528> ,0.09504}
texture{txttree matrix <0.999504,-0.0314827,0,0.0253361,0.804364,-0.593596,0.018688,0.593302,0.804763,1.34559,19.5846,-12.7528> }}
union{cone{<1.42649,22.153,-14.6482> ,0.0864,<1.06745,24.6335,-16.6149> ,0.07776}
sphere{<1.42649,22.153,-14.6482> ,0.0864}
texture{txttree matrix <0.989686,0.143253,0,-0.112697,0.778583,-0.617339,-0.0884356,0.610972,0.786697,1.42649,22.153,-14.6482> }}
union{cone{<0.858555,13.3953,-0.913078> ,0.1296,<0.68129,15.9378,-2.74104> ,0.12096}
sphere{<0.858555,13.3953,-0.913078> ,0.1296}
texture{txttree matrix <0.997578,0.0695526,0,-0.0565184,0.810632,-0.582822,-0.0405367,0.58141,0.8126,0.858555,13.3953,-0.913078> }}
union{cone{<0.68129,15.9378,-2.74104> ,0.12096,<1.59126,18.4509,-4.483> ,0.11232}
sphere{<0.68129,15.9378,-2.74104> ,0.12096}
texture{txttree matrix <0.940259,-0.340459,0,0.285229,0.787727,-0.546013,0.185895,0.513394,0.837777,0.68129,15.9378,-2.74104> }}
union{cone{<1.59126,18.4509,-4.483> ,0.11232,<1.56433,20.8688,-6.88386> ,0.10368}
sphere{<1.59126,18.4509,-4.483> ,0.11232}
texture{txttree matrix <0.999938,0.0111382,0,-0.00790394,0.709583,-0.704578,-0.0078477,0.704534,0.709627,1.59126,18.4509,-4.483> }}
union{cone{<1.56433,20.8688,-6.88386> ,0.10368,<1.89045,23.7228,-8.65757> ,0.09504}
sphere{<1.56433,20.8688,-6.88386> ,0.10368}
texture{txttree matrix <0.993535,-0.113528,0,0.0965971,0.845366,-0.525381,0.0596454,0.521985,0.850867,1.56433,20.8688,-6.88386> }}
union{cone{<1.89045,23.7228,-8.65757> ,0.09504,<2.43143,26.761,-10.1745> ,0.0864}
sphere{<1.89045,23.7228,-8.65757> ,0.09504}
texture{txttree matrix <0.984514,-0.175304,0,0.157324,0.88354,-0.441141,0.0773337,0.43431,0.897438,1.89045,23.7228,-8.65757> }}
union{cone{<2.43143,26.761,-10.1745> ,0.0864,<2.25693,29.9873,-11.3391> ,0.07776}
sphere{<2.43143,26.761,-10.1745> ,0.0864}
texture{txttree matrix <0.99854,0.0540082,0,-0.0508085,0.939382,-0.339086,-0.0183134,0.338591,0.940755,2.43143,26.761,-10.1745> }}
union{cone{<-0.347536,10.0638,0.155012> ,0.216,<-0.285752,11.2464,-1.187> ,0.203657}
sphere{<-0.347536,10.0638,0.155012> ,0.216}
texture{txttree matrix <0.998638,-0.052173,0,0.0345203,0.66075,-0.749812,0.03912,0.748791,0.661651,-0.347536,10.0638,0.155012> }}
union{cone{<-0.285752,11.2464,-1.187> ,0.203657,<0.480721,12.5362,-2.01961> ,0.191314}
sphere{<-0.285752,11.2464,-1.187> ,0.203657}
texture{txttree matrix <0.859649,-0.510884,0,0.446705,0.751657,-0.48525,0.247906,0.417145,0.874376,-0.285752,11.2464,-1.187> }}
union{cone{<0.480721,12.5362,-2.01961> ,0.191314,<0.948121,13.1833,-3.6399> ,0.178971}
sphere{<0.480721,12.5362,-2.01961> ,0.191314}
texture{txttree matrix <0.810671,-0.585502,0,0.258765,0.358279,-0.897038,0.525217,0.727202,0.441954,0.480721,12.5362,-2.01961> }}
union{cone{<0.948121,13.1833,-3.6399> ,0.178971,<1.71617,13.8243,-5.08787> ,0.166629}
sphere{<0.948121,13.1833,-3.6399> ,0.178971}
texture{txttree matrix <0.640715,-0.767779,0,0.436414,0.36419,-0.822745,0.631686,0.527145,0.568411,0.948121,13.1833,-3.6399> }}
union{cone{<1.71617,13.8243,-5.08787> ,0.166629,<2.3799,15.0435,-6.10178> ,0.154286}
sphere{<1.71617,13.8243,-5.08787> ,0.166629}
texture{txttree matrix <0.878292,-0.478125,0,0.386104,0.709254,-0.589815,0.282005,0.51803,0.807538,1.71617,13.8243,-5.08787> }}
union{cone{<2.3799,15.0435,-6.10178> ,0.154286,<2.60325,16.4633,-7.22446> ,0.141943}
sphere{<2.3799,15.0435,-6.10178> ,0.154286}
texture{txttree matrix <0.987852,-0.1554,0,0.122466,0.778492,-0.615592,0.0956632,0.608113,0.788065,2.3799,15.0435,-6.10178> }}
union{cone{<2.60325,16.4633,-7.22446> ,0.141943,<2.85867,17.6096,-8.4293> ,0.1296}
sphere{<2.60325,16.4633,-7.22446> ,0.141943}
texture{txttree matrix <0.976063,-0.217487,0,0.151808,0.6813,-0.71609,0.15574,0.698949,0.698008,2.60325,16.4633,-7.22446> }}
union{cone{<2.85867,17.6096,-8.4293> ,0.1296,<2.61085,19.9799,-10.6013> ,0.12096}
sphere{<2.85867,17.6096,-8.4293> ,0.1296}
texture{txttree matrix <0.994579,0.103981,0,-0.0768528,0.735095,-0.673594,-0.0700412,0.669943,0.739102,2.85867,17.6096,-8.4293> }}
union{cone{<2.61085,19.9799,-10.6013> ,0.12096,<3.53325,22.251,-12.7016> ,0.11232}
sphere{<2.61085,19.9799,-10.6013> ,0.12096}
texture{txttree matrix <0.926499,-0.376297,0,0.285755,0.703572,-0.650639,0.244833,0.602816,0.759387,2.61085,19.9799,-10.6013> }}
union{cone{<3.53325,22.251,-12.7016> ,0.11232,<4.3183,24.5017,-15.054> ,0.10368}
sphere{<3.53325,22.251,-12.7016> ,0.11232}
texture{txttree matrix <0.944212,-0.329339,0,0.23441,0.672051,-0.702424,0.231335,0.663237,0.711759,3.53325,22.251,-12.7016> }}
union{cone{<4.3183,24.5017,-15.054> ,0.10368,<5.17538,27.42,-16.0415> ,0.09504}
sphere{<4.3183,24.5017,-15.054> ,0.10368}
texture{txttree matrix <0.959476,-0.28179,0,0.268017,0.91258,-0.308812,0.0870204,0.296298,0.951123,4.3183,24.5017,-15.054> }}
union{cone{<5.17538,27.42,-16.0415> ,0.09504,<6.27237,30.2626,-17.532> ,0.0864}
sphere{<5.17538,27.42,-16.0415> ,0.09504}
texture{txttree matrix <0.932939,-0.360035,0,0.323413,0.838043,-0.439419,0.158206,0.409951,0.898282,5.17538,27.42,-16.0415> }}
union{cone{<6.27237,30.2626,-17.532> ,0.0864,<6.35218,32.9902,-19.3645> ,0.07776}
sphere{<6.27237,30.2626,-17.532> ,0.0864}
texture{txttree matrix <0.999572,-0.0292454,0,0.0242788,0.829819,-0.557504,0.0163045,0.557265,0.830174,6.27237,30.2626,-17.532> }}
union{cone{<-0.296701,11.0369,-0.949165> ,0.1296,<1.00256,13.441,-2.88971> ,0.12096}
sphere{<-0.296701,11.0369,-0.949165> ,0.1296}
texture{txttree matrix <0.879746,-0.475444,0,0.387648,0.717292,-0.578982,0.275274,0.509357,0.81534,-0.296701,11.0369,-0.949165> }}
union{cone{<1.00256,13.441,-2.88971> ,0.12096,<2.98955,15.4285,-4.51955> ,0.11232}
sphere{<1.00256,13.441,-2.88971> ,0.12096}
texture{txttree matrix <0.707211,-0.707003,0,0.611599,0.611779,-0.501669,0.354682,0.354786,0.86506,1.00256,13.441,-2.88971> }}
union{cone{<2.98955,15.4285,-4.51955> ,0.11232,<4.65821,17.1303,-6.6822> ,0.10368}
sphere{<2.98955,15.4285,-4.51955> ,0.11232}
texture{txttree matrix <0.714012,-0.700134,0,0.518493,0.528771,-0.671987,0.470481,0.479807,0.740563,2.98955,15.4285,-4.51955> }}
union{cone{<4.65821,17.1303,-6.6822> ,0.10368,<4.76148,19.5819,-8.9361> ,0.09504}
sphere{<4.65821,17.1303,-6.6822> ,0.10368}
texture{txttree matrix <0.999114,-0.0420888,0,0.0309967,0.735807,-0.676481,0.0284723,0.675882,0.73646,4.65821,17.1303,-6.6822> }}
union{cone{<4.76148,19.5819,-8.9361> ,0.09504,<4.85222,22.1657,-11.1689> ,0.0864}
sphere{<4.76148,19.5819,-8.9361> ,0.09504}
texture{txttree matrix <0.999384,-0.0350948,0,0.0265612,0.756376,-0.653598,0.0229379,0.653195,0.756842,4.76148,19.5819,-8.9361> }}
union{cone{<4.85222,22.1657,-11.1689> ,0.0864,<5.048,24.5318,-13.3923> ,0.07776}
sphere{<4.85222,22.1657,-11.1689> ,0.0864}
texture{txttree matrix <0.996594,-0.0824623,0,0.0601889,0.72741,-0.683558,0.0563678,0.68123,0.729896,4.85222,22.1657,-11.1689> }}
union{cone{<-0.346956,10.0749,0.142408> ,0.1296,<0.378068,9.89755,-2.90337> ,0.12096}
sphere{<-0.346956,10.0749,0.142408> ,0.1296}
texture{txttree matrix <-0.237668,-0.971346,0,0.231201,-0.05657,-0.97126,0.94343,-0.230838,0.238021,-0.346956,10.0749,0.142408> }}
union{cone{<0.378068,9.89755,-2.90337> ,0.12096,<1.76353,11.6412,-5.18589> ,0.11232}
sphere{<0.378068,9.89755,-2.90337> ,0.12096}
texture{txttree matrix <0.782944,-0.622092,0,0.434448,0.546781,-0.715741,0.445257,0.560385,0.698366,0.378068,9.89755,-2.90337> }}
union{cone{<1.76353,11.6412,-5.18589> ,0.11232,<3.07138,13.248,-7.68176> ,0.10368}
sphere{<1.76353,11.6412,-5.18589> ,0.11232}
texture{txttree matrix <0.775559,-0.631275,0,0.403197,0.495351,-0.769454,0.485738,0.596757,0.638702,1.76353,11.6412,-5.18589> }}
union{cone{<3.07138,13.248,-7.68176> ,0.10368,<4.16957,15.2433,-10.2165> ,0.09504}
sphere{<3.07138,13.248,-7.68176> ,0.10368}
texture{txttree matrix <0.876071,-0.482182,0,0.322274,0.585535,-0.743834,0.358663,0.651651,0.668365,3.07138,13.248,-7.68176> }}
union{cone{<4.16957,15.2433,-10.2165> ,0.09504,<4.81875,17.5006,-12.6347> ,0.0864}
sphere{<4.16957,15.2433,-10.2165> ,0.09504}
texture{txttree matrix <0.961047,-0.276385,0,0.192568,0.669598,-0.717325,0.198258,0.689383,0.696738,4.16957,15.2433,-10.2165> }}
union{cone{<4.81875,17.5006,-12.6347> ,0.0864,<5.74507,19.22,-15.1599> ,0.07776}
sphere{<4.81875,17.5006,-12.6347> ,0.0864}
texture{txttree matrix <0.880357,-0.474311,0,0.290171,0.538579,-0.791033,0.375196,0.696391,0.611774,4.81875,17.5006,-12.6347> }}
union{cone{<-0.00953656,11.7112,-1.48705> ,0.1296,<1.30909,13.0304,-4.33138> ,0.12096}
sphere{<-0.00953656,11.7112,-1.48705> ,0.1296}
texture{txttree matrix <0.707248,-0.706966,0,0.387677,0.387831,-0.836238,0.591191,0.591427,0.548367,-0.00953656,11.7112,-1.48705> }}
union{cone{<1.30909,13.0304,-4.33138> ,0.12096,<1.59077,14.6715,-7.21793> ,0.11232}
sphere{<1.30909,13.0304,-4.33138> ,0.12096}
texture{txttree matrix <0.985588,-0.169165,0,0.0845289,0.492481,-0.866209,0.146532,0.853725,0.499682,1.30909,13.0304,-4.33138> }}
union{cone{<1.59077,14.6715,-7.21793> ,0.11232,<2.1106,17.4131,-8.71737> ,0.10368}
sphere{<1.59077,14.6715,-7.21793> ,0.11232}
texture{txttree matrix <0.982495,-0.186287,0,0.164097,0.865461,-0.473339,0.088177,0.465053,0.88088,1.59077,14.6715,-7.21793> }}
union{cone{<2.1106,17.4131,-8.71737> ,0.10368,<1.63535,19.9508,-10.7745> ,0.09504}
sphere{<2.1106,17.4131,-8.71737> ,0.10368}
texture{txttree matrix <0.982912,0.184077,0,-0.143967,0.768736,-0.623151,-0.114708,0.612503,0.782101,2.1106,17.4131,-8.71737> }}
union{cone{<1.63535,19.9508,-10.7745> ,0.09504,<2.65459,22.1922,-12.9803> ,0.0864}
sphere{<1.63535,19.9508,-10.7745> ,0.09504}
texture{txttree matrix <0.910299,-0.413952,0,0.308322,0.678015,-0.667258,0.276213,0.607404,0.744826,1.63535,19.9508,-10.7745> }}
union{cone{<2.65459,22.1922,-12.9803> ,0.0864,<2.43638,24.5819,-15.3708> ,0.07776}
sphere{<2.65459,22.1922,-12.9803> ,0.0864}
texture{txttree matrix <0.995857,0.0909324,0,-0.064422,0.705526,-0.70575,-0.0641755,0.702826,0.708461,2.65459,22.1922,-12.9803> }}
union{cone{<-1.00691,6.34601,1.55572> ,0.216,<-1.267,7.75212,0.685552> ,0.203657}
sphere{<-1.00691,6.34601,1.55572> ,0.216}
texture{txttree matrix <0.983321,0.181881,0,-0.155374,0.840016,-0.519839,-0.0945486,0.511168,0.854265,-1.00691,6.34601,1.55572> }}
union{cone{<-1.267,7.75212,0.685552> ,0.203657,<-1.97318,8.53451,-0.769138> ,0.191314}
sphere{<-1.267,7.75212,0.685552> ,0.203657}
texture{txttree matrix <0.742337,0.670027,0,-0.393116,0.435541,-0.809793,-0.542583,0.601139,0.586716,-1.267,7.75212,0.685552> }}
union{cone{<-1.97318,8.53451,-0.769138> ,0.191314,<-2.02081,9.9494,-1.93711> ,0.178971}
sphere{<-1.97318,8.53451,-0.769138> ,0.191314}
texture{txttree matrix <0.999434,0.033648,0,-0.025955,0.770931,-0.63639,-0.0214133,0.63603,0.771367,-1.97318,8.53451,-0.769138> }}
union{cone{<-2.02081,9.9494,-1.93711> ,0.178971,<-2.01204,10.9485,-3.31725> ,0.166629}
sphere{<-2.02081,9.9494,-1.93711> ,0.178971}
texture{txttree matrix <0.999961,-0.00878542,0,0.00515178,0.586379,-0.810021,0.00711637,0.809989,0.586401,-2.02081,9.9494,-1.93711> }}
union{cone{<-2.01204,10.9485,-3.31725> ,0.166629,<-2.69655,12.124,-4.39667> ,0.154286}
sphere{<-2.01204,10.9485,-3.31725> ,0.166629}
texture{txttree matrix <0.864162,0.503213,0,-0.394186,0.676931,-0.621596,-0.312796,0.53716,0.783338,-2.01204,10.9485,-3.31725> }}
union{cone{<-2.69655,12.124,-4.39667> ,0.154286,<-2.60788,13.4548,-5.59894> ,0.141943}
sphere{<-2.69655,12.124,-4.39667> ,0.154286}
texture{txttree matrix <0.997787,-0.0664884,0,0.0493849,0.741116,-0.669559,0.0445179,0.668077,0.742759,-2.69655,12.124,-4.39667> }}
union{cone{<-2.60788,13.4548,-5.59894> ,0.141943,<-2.69601,14.5261,-6.87743> ,0.1296}
sphere{<-2.60788,13.4548,-5.59894> ,0.141943}
texture{txttree matrix <0.996634,0.081985,0,-0.0527617,0.641386,-0.765402,-0.0627515,0.762825,0.643553,-2.60788,13.4548,-5.59894> }}
union{cone{<-2.69601,14.5261,-6.87743> ,0.1296,<-2.38309,17.4282,-8.43763> ,0.12096}
sphere{<-2.69601,14.5261,-6.87743> ,0.1296}
texture{txttree matrix <0.994237,-0.107206,0,0.0945465,0.876835,-0.471403,0.0505371,0.468687,0.881918,-2.69601,14.5261,-6.87743> }}
union{cone{<-2.38309,17.4282,-8.43763> ,0.12096,<-2.29531,19.7426,-10.9172> ,0.11232}
sphere{<-2.38309,17.4282,-8.43763> ,0.12096}
texture{txttree matrix <0.999282,-0.0378978,0,0.0258694,0.682118,-0.730785,0.0276952,0.73026,0.682608,-2.38309,17.4282,-8.43763> }}
union{cone{<-2.29531,19.7426,-10.9172> ,0.11232,<-3.26157,22.3245,-12.9475> ,0.10368}
sphere{<-2.29531,19.7426,-10.9172> ,0.11232}
texture{txttree matrix <0.936562,0.350501,0,-0.282225,0.754122,-0.593,-0.207847,0.555381,0.805203,-2.29531,19.7426,-10.9172> }}
union{cone{<-3.26157,22.3245,-12.9475> ,0.10368,<-2.85086,25.2679,-14.5481> ,0.09504}
sphere{<-3.26157,22.3245,-12.9475> ,0.10368}
texture{txttree matrix <0.990404,-0.1382,0,0.121675,0.871977,-0.474186,0.0655326,0.469636,0.880425,-3.26157,22.3245,-12.9475> }}
union{cone{<-2.85086,25.2679,-14.5481> ,0.09504,<-3.27742,28.0899,-16.3842> ,0.0864}
sphere{<-2.85086,25.2679,-14.5481> ,0.09504}
texture{txttree matrix <0.988768,0.14946,0,-0.125695,0.831548,-0.541044,-0.0808642,0.534967,0.840994,-2.85086,25.2679,-14.5481> }}
union{cone{<-3.27742,28.0899,-16.3842> ,0.0864,<-4.02882,30.4935,-18.5609> ,0.07776}
sphere{<-3.27742,28.0899,-16.3842> ,0.0864}
texture{txttree matrix <0.954451,0.298368,0,-0.225735,0.722107,-0.653916,-0.195107,0.62413,0.756567,-3.27742,28.0899,-16.3842> }}
union{cone{<-2.65276,12.7812,-4.99037> ,0.1296,<-0.905807,15.0374,-6.39929> ,0.12096}
sphere{<-2.65276,12.7812,-4.99037> ,0.1296}
texture{txttree matrix <0.790697,-0.612208,0,0.548943,0.708987,-0.442719,0.271036,0.350057,0.89666,-2.65276,12.7812,-4.99037> }}
union{cone{<-0.905807,15.0374,-6.39929> ,0.12096,<1.28867,16.9464,-7.75533> ,0.11232}
sphere{<-0.905807,15.0374,-6.39929> ,0.12096}
texture{txttree matrix <0.656311,-0.75449,0,0.683821,0.594838,-0.422559,0.318816,0.27733,0.906336,-0.905807,15.0374,-6.39929> }}
union{cone{<1.28867,16.9464,-7.75533> ,0.11232,<1.89476,18.987,-10.2326> ,0.10368}
sphere{<1.28867,16.9464,-7.75533> ,0.11232}
texture{txttree matrix <0.958612,-0.284717,0,0.185562,0.624769,-0.758439,0.21594,0.727049,0.651744,1.28867,16.9464,-7.75533> }}
union{cone{<1.89476,18.987,-10.2326> ,0.10368,<2.69156,21.1705,-12.7106> ,0.09504}
sphere{<1.89476,18.987,-10.2326> ,0.10368}
texture{txttree matrix <0.939407,-0.342803,0,0.234524,0.642682,-0.729354,0.250025,0.685161,0.684136,1.89476,18.987,-10.2326> }}
union{cone{<2.69156,21.1705,-12.7106> ,0.09504,<2.92749,23.752,-14.4515> ,0.0864}
sphere{<2.69156,21.1705,-12.7106> ,0.09504}
texture{txttree matrix <0.995849,-0.0910163,0,0.0755577,0.826711,-0.55753,0.0507443,0.555216,0.830157,2.69156,21.1705,-12.7106> }}
union{cone{<2.92749,23.752,-14.4515> ,0.0864,<4.3574,26.2741,-16.0476> ,0.07776}
sphere{<2.92749,23.752,-14.4515> ,0.0864}
texture{txttree matrix <0.869919,-0.493195,0,0.432048,0.762064,-0.482278,0.237857,0.419543,0.876018,2.92749,23.752,-14.4515> }}
union{cone{<-2.67119,14.2244,-6.51744> ,0.1296,<-1.71563,14.771,-9.60048> ,0.12096}
sphere{<-2.67119,14.2244,-6.51744> ,0.1296}
texture{txttree matrix <0.496475,-0.868051,0,0.291893,0.166946,-0.941768,0.817503,0.467564,0.336262,-2.67119,14.2244,-6.51744> }}
union{cone{<-1.71563,14.771,-9.60048> ,0.12096,<-2.02245,15.7072,-12.7777> ,0.11232}
sphere{<-1.71563,14.771,-9.60048> ,0.12096}
texture{txttree matrix <0.950267,0.311437,0,-0.0922378,0.281439,-0.955136,-0.297465,0.907634,0.296168,-1.71563,14.771,-9.60048> }}
union{cone{<-2.02245,15.7072,-12.7777> ,0.11232,<-2.51154,17.4028,-15.4937> ,0.10368}
sphere{<-2.02245,15.7072,-12.7777> ,0.11232}
texture{txttree matrix <0.960832,0.277132,0,-0.150995,0.523509,-0.838534,-0.232384,0.80569,0.544849,-2.02245,15.7072,-12.7777> }}
union{cone{<-2.51154,17.4028,-15.4937> ,0.10368,<-1.886,19.5543,-17.902> ,0.09504}
sphere{<-2.51154,17.4028,-15.4937> ,0.10368}
texture{txttree matrix <0.960238,-0.279184,0,0.190168,0.654072,-0.732137,0.204401,0.703026,0.681157,-2.51154,17.4028,-15.4937> }}
union{cone{<-1.886,19.5543,-17.902> ,0.09504,<-1.44596,21.8812,-20.0564> ,0.0864}
sphere{<-1.886,19.5543,-17.902> ,0.09504}
texture{txttree matrix <0.982584,-0.185818,0,0.13745,0.726819,-0.672935,0.125043,0.661215,0.739702,-1.886,19.5543,-17.902> }}
union{cone{<-1.44596,21.8812,-20.0564> ,0.0864,<-1.82694,23.6526,-22.9259> ,0.07776}
sphere{<-1.44596,21.8812,-20.0564> ,0.0864}
texture{txttree matrix <0.977644,0.210269,0,-0.112262,0.521964,-0.845548,-0.177792,0.826644,0.5339,-1.44596,21.8812,-20.0564> }}
union{cone{<-2.01844,10.2196,-2.31029> ,0.1296,<-2.82451,11.2696,-5.34429> ,0.12096}
sphere{<-2.01844,10.2196,-2.31029> ,0.1296}
texture{txttree matrix <0.793234,0.608917,0,-0.243511,0.31722,-0.916556,-0.558106,0.727043,0.399907,-2.01844,10.2196,-2.31029> }}
union{cone{<-2.82451,11.2696,-5.34429> ,0.12096,<-4.26809,13.3108,-7.56658> ,0.11232}
sphere{<-2.82451,11.2696,-5.34429> ,0.12096}
texture{txttree matrix <0.81645,0.577416,0,-0.431565,0.610221,-0.664366,-0.383616,0.542422,0.747407,-2.82451,11.2696,-5.34429> }}
union{cone{<-4.26809,13.3108,-7.56658> ,0.11232,<-5.64495,15.673,-9.5578> ,0.10368}
sphere{<-4.26809,13.3108,-7.56658> ,0.11232}
texture{txttree matrix <0.863956,0.503568,0,-0.407062,0.698384,-0.588693,-0.296447,0.508605,0.808357,-4.26809,13.3108,-7.56658> }}
union{cone{<-5.64495,15.673,-9.5578> ,0.10368,<-6.87377,17.6595,-12.0154> ,0.09504}
sphere{<-5.64495,15.673,-9.5578> ,0.10368}
texture{txttree matrix <0.850439,0.526074,0,-0.362421,0.58588,-0.724842,-0.381321,0.616434,0.688915,-5.64495,15.673,-9.5578> }}
union{cone{<-6.87377,17.6595,-12.0154> ,0.09504,<-6.83533,19.9077,-14.2837> ,0.0864}
sphere{<-6.87377,17.6595,-12.0154> ,0.09504}
texture{txttree matrix <0.999854,-0.0170952,0,0.0120349,0.703894,-0.710203,0.012141,0.710099,0.703997,-6.87377,17.6595,-12.0154> }}
union{cone{<-6.83533,19.9077,-14.2837> ,0.0864,<-7.54771,21.4839,-16.9327> ,0.07776}
sphere{<-6.83533,19.9077,-14.2837> ,0.0864}
texture{txttree matrix <0.911257,0.411839,0,-0.225176,0.498236,-0.837291,-0.344829,0.762987,0.546757,-6.83533,19.9077,-14.2837> }}
union{cone{<-0.276519,3.04034,-0.213279> ,0.36,<-1.25893,3.16016,-0.106288> ,0.342}
sphere{<-0.276519,3.04034,-0.213279> ,0.36}
texture{txttree matrix <0.121065,0.992645,0,-0.986894,0.120364,0.107479,0.106688,-0.013012,0.994207,-0.276519,3.04034,-0.213279> }}
union{cone{<-1.25893,3.16016,-0.106288> ,0.342,<-2.24342,3.27697,-0.142452> ,0.324}
sphere{<-1.25893,3.16016,-0.106288> ,0.342}
texture{txttree matrix <0.117823,0.993035,0,-0.992375,0.117745,-0.0364543,-0.0362003,0.00429515,0.999335,-1.25893,3.16016,-0.106288> }}
union{cone{<-2.24342,3.27697,-0.142452> ,0.324,<-2.94825,3.85346,-0.258808> ,0.306}
sphere{<-2.24342,3.27697,-0.142452> ,0.324}
texture{txttree matrix <0.633112,0.77406,0,-0.767817,0.628006,-0.126753,-0.0981141,0.0802487,0.991934,-2.24342,3.27697,-0.142452> }}
union{cone{<-2.94825,3.85346,-0.258808> ,0.306,<-3.87829,4.10484,-0.294226> ,0.288}
sphere{<-2.94825,3.85346,-0.258808> ,0.306}
texture{txttree matrix <0.260927,0.965359,0,-0.964707,0.260751,-0.0367382,-0.0354656,0.00958599,0.999325,-2.94825,3.85346,-0.258808> }}
union{cone{<-3.87829,4.10484,-0.294226> ,0.288,<-4.674,4.57078,-0.593824> ,0.27}
sphere{<-3.87829,4.10484,-0.294226> ,0.288}
texture{txttree matrix <0.505313,0.862936,0,-0.820703,0.480582,-0.309012,-0.266658,0.156148,0.951058,-3.87829,4.10484,-0.294226> }}
union{cone{<-4.674,4.57078,-0.593824> ,0.27,<-5.29279,5.27493,-0.398914> ,0.252}
sphere{<-4.674,4.57078,-0.593824> ,0.27}
texture{txttree matrix <0.751169,0.66011,0,-0.646287,0.73544,0.20357,0.134379,-0.152916,0.97906,-4.674,4.57078,-0.593824> }}
union{cone{<-5.29279,5.27493,-0.398914> ,0.252,<-5.99611,5.86554,-0.264509> ,0.234}
sphere{<-5.29279,5.27493,-0.398914> ,0.252}
texture{txttree matrix <0.643076,0.765803,0,-0.757731,0.636298,0.144803,0.11089,-0.0931193,0.989461,-5.29279,5.27493,-0.398914> }}
union{cone{<-5.99611,5.86554,-0.264509> ,0.234,<-6.66486,6.58937,-0.232957> ,0.216}
sphere{<-5.99611,5.86554,-0.264509> ,0.234}
texture{txttree matrix <0.7345,0.678609,0,-0.678261,0.734124,0.032001,0.0217162,-0.0235047,0.999488,-5.99611,5.86554,-0.264509> }}
union{cone{<-6.66486,6.58937,-0.232957> ,0.216,<-8.08782,7.5716,0.368319> ,0.203657}
sphere{<-6.66486,6.58937,-0.232957> ,0.216}
texture{txttree matrix <0.568078,0.822975,0,-0.777316,0.53656,0.328456,0.270311,-0.186589,0.944519,-6.66486,6.58937,-0.232957> }}
union{cone{<-8.08782,7.5716,0.368319> ,0.203657,<-9.44556,8.46584,0.863911> ,0.191314}
sphere{<-8.08782,7.5716,0.368319> ,0.203657}
texture{txttree matrix <0.550041,0.835138,0,-0.798846,0.526138,0.291588,0.243516,-0.160385,0.956544,-8.08782,7.5716,0.368319> }}
union{cone{<-9.44556,8.46584,0.863911> ,0.191314,<-10.6399,9.46898,1.64303> ,0.178971}
sphere{<-9.44556,8.46584,0.863911> ,0.191314}
texture{txttree matrix <0.643148,0.765742,0,-0.685031,0.575359,0.446871,0.342188,-0.287405,0.894598,-9.44556,8.46584,0.863911> }}
union{cone{<-10.6399,9.46898,1.64303> ,0.178971,<-11.382,11.1287,1.68726> ,0.166629}
sphere{<-10.6399,9.46898,1.64303> ,0.178971}
texture{txttree matrix <0.912909,0.408164,0,-0.408043,0.912639,0.0243215,0.00992717,-0.0222033,0.999704,-10.6399,9.46898,1.64303> }}
union{cone{<-11.382,11.1287,1.68726> ,0.166629,<-12.0126,12.8008,1.92357> ,0.154286}
sphere{<-11.382,11.1287,1.68726> ,0.166629}
texture{txttree matrix <0.935675,0.352864,0,-0.349819,0.927599,0.131096,0.046259,-0.122663,0.99137,-11.382,11.1287,1.68726> }}
union{cone{<-12.0126,12.8008,1.92357> ,0.154286,<-12.9922,14.0936,2.43868> ,0.141943}
sphere{<-12.0126,12.8008,1.92357> ,0.154286}
texture{txttree matrix <0.79702,0.603953,0,-0.575628,0.759639,0.302656,0.18279,-0.241223,0.9531,-12.0126,12.8008,1.92357> }}
union{cone{<-12.9922,14.0936,2.43868> ,0.141943,<-13.2886,15.7205,2.14034> ,0.1296}
sphere{<-12.9922,14.0936,2.43868> ,0.141943}
texture{txttree matrix <0.983808,0.179223,0,-0.176376,0.968178,-0.177548,-0.0318207,0.174673,0.984112,-12.9922,14.0936,2.43868> }}
union{cone{<-13.2886,15.7205,2.14034> ,0.1296,<-12.9574,18.8576,2.95666> ,0.12096}
sphere{<-13.2886,15.7205,2.14034> ,0.1296}
texture{txttree matrix <0.994473,-0.104994,0,0.101645,0.962759,0.250528,-0.0263038,-0.249143,0.968109,-13.2886,15.7205,2.14034> }}
union{cone{<-12.9574,18.8576,2.95666> ,0.12096,<-12.2764,22.0149,2.79342> ,0.11232}
sphere{<-12.9574,18.8576,2.95666> ,0.12096}
texture{txttree matrix <0.977522,-0.210833,0,0.210564,0.976276,-0.0504765,0.0106421,0.0493419,0.998725,-12.9574,18.8576,2.95666> }}
union{cone{<-12.2764,22.0149,2.79342> ,0.11232,<-13.1779,25.2144,3.26737> ,0.10368}
sphere{<-12.2764,22.0149,2.79342> ,0.11232}
texture{txttree matrix <0.962523,0.271201,0,-0.268485,0.952885,0.141156,0.0382816,-0.135866,0.989987,-12.2764,22.0149,2.79342> }}
union{cone{<-13.1779,25.2144,3.26737> ,0.10368,<-13.7657,28.2883,2.0984> ,0.09504}
sphere{<-13.1779,25.2144,3.26737> ,0.10368}
texture{txttree matrix <0.982204,0.18782,0,-0.175947,0.920115,-0.349901,-0.0657182,0.343674,0.936787,-13.1779,25.2144,3.26737> }}
union{cone{<-13.7657,28.2883,2.0984> ,0.09504,<-14.3154,31.2164,0.970105> ,0.0864}
sphere{<-13.7657,28.2883,2.0984> ,0.09504}
texture{txttree matrix <0.982831,0.184508,0,-0.172548,0.919123,-0.354174,-0.065348,0.348093,0.935179,-13.7657,28.2883,2.0984> }}
union{cone{<-14.3154,31.2164,0.970105> ,0.0864,<-14.7826,34.5634,0.711866> ,0.07776}
sphere{<-14.3154,31.2164,0.970105> ,0.0864}
texture{txttree matrix <0.9904,0.138234,0,-0.137832,0.987521,-0.0761908,-0.0105322,0.0754593,0.997093,-14.3154,31.2164,0.970105> }}
union{cone{<-12.3978,13.3091,2.1261> ,0.1296,<-13.716,16.0913,3.62361> ,0.12096}
sphere{<-12.3978,13.3091,2.1261> ,0.1296}
texture{txttree matrix <0.903691,0.428186,0,-0.385051,0.812656,0.437409,0.187292,-0.395282,0.899263,-12.3978,13.3091,2.1261> }}
union{cone{<-13.716,16.0913,3.62361> ,0.12096,<-14.1363,19.2095,4.7221> ,0.11232}
sphere{<-13.716,16.0913,3.62361> ,0.12096}
texture{txttree matrix <0.991038,0.133583,0,-0.126117,0.935653,0.329618,0.0440313,-0.326664,0.944114,-13.716,16.0913,3.62361> }}
union{cone{<-14.1363,19.2095,4.7221> ,0.11232,<-14.8337,22.5547,5.07398> ,0.10368}
sphere{<-14.1363,19.2095,4.7221> ,0.11232}
texture{txttree matrix <0.978951,0.204095,0,-0.203021,0.973802,0.102432,0.0209059,-0.100276,0.99474,-14.1363,19.2095,4.7221> }}
union{cone{<-14.8337,22.5547,5.07398> ,0.10368,<-16.1016,25.4786,5.64007> ,0.09504}
sphere{<-14.8337,22.5547,5.07398> ,0.10368}
texture{txttree matrix <0.917456,0.397836,0,-0.391705,0.903316,0.174892,0.0695782,-0.160455,0.984588,-14.8337,22.5547,5.07398> }}
union{cone{<-16.1016,25.4786,5.64007> ,0.09504,<-15.9235,28.6469,4.94893> ,0.0864}
sphere{<-16.1016,25.4786,5.64007> ,0.09504}
texture{txttree matrix <0.998424,-0.0561279,0,0.0548422,0.975554,-0.212809,0.0119445,0.212473,0.977094,-16.1016,25.4786,5.64007> }}
union{cone{<-15.9235,28.6469,4.94893> ,0.0864,<-15.6521,31.9549,4.32569> ,0.07776}
sphere{<-15.9235,28.6469,4.94893> ,0.0864}
texture{txttree matrix <0.996651,-0.081776,0,0.0803713,0.979531,-0.18455,0.0150917,0.183932,0.982823,-15.9235,28.6469,4.94893> }}
union{cone{<-12.088,12.9004,1.96326> ,0.1296,<-13.8823,15.359,2.65896> ,0.12096}
sphere{<-12.088,12.9004,1.96326> ,0.1296}
texture{txttree matrix <0.807766,0.589504,0,-0.574683,0.787457,0.222824,0.131356,-0.17999,0.974859,-12.088,12.9004,1.96326> }}
union{cone{<-13.8823,15.359,2.65896> ,0.12096,<-14.8415,18.1942,3.52605> ,0.11232}
sphere{<-13.8823,15.359,2.65896> ,0.12096}
texture{txttree matrix <0.947259,0.320469,0,-0.307813,0.909848,0.278257,0.0891729,-0.263582,0.960507,-13.8823,15.359,2.65896> }}
union{cone{<-14.8415,18.1942,3.52605> ,0.11232,<-16.8735,20.8741,2.80613> ,0.10368}
sphere{<-14.8415,18.1942,3.52605> ,0.11232}
texture{txttree matrix <0.79684,0.60419,0,-0.590807,0.779189,-0.209315,-0.126466,0.166791,0.977848,-14.8415,18.1942,3.52605> }}
union{cone{<-16.8735,20.8741,2.80613> ,0.10368,<-17.8867,23.9081,1.86851> ,0.09504}
sphere{<-16.8735,20.8741,2.80613> ,0.10368}
texture{txttree matrix <0.948509,0.316749,0,-0.30396,0.91021,-0.281295,-0.0891001,0.266811,0.959621,-16.8735,20.8741,2.80613> }}
union{cone{<-17.8867,23.9081,1.86851> ,0.09504,<-18.9656,26.5116,0.183651> ,0.0864}
sphere{<-17.8867,23.9081,1.86851> ,0.09504}
texture{txttree matrix <0.923813,0.382845,0,-0.3286,0.792917,-0.513132,-0.19645,0.474038,0.85831,-17.8867,23.9081,1.86851> }}
union{cone{<-18.9656,26.5116,0.183651> ,0.0864,<-19.566,29.5162,-1.246> ,0.07776}
sphere{<-18.9656,26.5116,0.183651> ,0.0864}
texture{txttree matrix <0.980617,0.195937,0,-0.17756,0.888644,-0.422828,-0.0828476,0.414632,0.90621,-18.9656,26.5116,0.183651> }}
union{cone{<-13.0284,14.292,2.4023> ,0.1296,<-15.0171,16.7389,1.58533> ,0.12096}
sphere{<-13.0284,14.292,2.4023> ,0.1296}
texture{txttree matrix <0.776034,0.630691,0,-0.610531,0.751228,-0.250814,-0.158186,0.19464,0.968035,-13.0284,14.292,2.4023> }}
union{cone{<-15.0171,16.7389,1.58533> ,0.12096,<-15.827,19.322,-0.0188591> ,0.11232}
sphere{<-15.0171,16.7389,1.58533> ,0.12096}
texture{txttree matrix <0.954192,0.299195,0,-0.257396,0.820886,-0.509798,-0.152529,0.486445,0.860294,-15.0171,16.7389,1.58533> }}
union{cone{<-15.827,19.322,-0.0188591> ,0.11232,<-16.1339,21.9372,-1.94172> ,0.10368}
sphere{<-15.827,19.322,-0.0188591> ,0.11232}
texture{txttree matrix <0.993185,0.116547,0,-0.0941222,0.802089,-0.589741,-0.0687324,0.585722,0.807592,-15.827,19.322,-0.0188591> }}
union{cone{<-16.1339,21.9372,-1.94172> ,0.10368,<-17.2195,23.8492,-4.19317> ,0.09504}
sphere{<-16.1339,21.9372,-1.94172> ,0.10368}
texture{txttree matrix <0.8696,0.493757,0,-0.34497,0.607558,-0.71545,-0.353259,0.622155,0.698664,-16.1339,21.9372,-1.94172> }}
union{cone{<-17.2195,23.8492,-4.19317> ,0.09504,<-18.3994,26.4748,-5.55816> ,0.0864}
sphere{<-17.2195,23.8492,-4.19317> ,0.09504}
texture{txttree matrix <0.912136,0.409889,0,-0.370358,0.824166,-0.428469,-0.175625,0.390822,0.903556,-17.2195,23.8492,-4.19317> }}
union{cone{<-18.3994,26.4748,-5.55816> ,0.0864,<-19.3575,28.946,-7.21294> ,0.07776}
sphere{<-18.3994,26.4748,-5.55816> ,0.0864}
texture{txttree matrix <0.932368,0.361511,0,-0.306653,0.790886,-0.529588,-0.191452,0.493771,0.848255,-18.3994,26.4748,-5.55816> }}
union{cone{<-6.43253,6.33791,-0.243919> ,0.216,<-6.16084,7.86965,0.553307> ,0.203657}
sphere{<-6.43253,6.33791,-0.243919> ,0.216}
texture{txttree matrix <0.984631,-0.174648,0,0.155427,0.876266,0.45607,-0.0796515,-0.44906,0.889944,-6.43253,6.33791,-0.243919> }}
union{cone{<-6.16084,7.86965,0.553307> ,0.203657,<-6.12287,9.64905,0.221754> ,0.191314}
sphere{<-6.16084,7.86965,0.553307> ,0.203657}
texture{txttree matrix <0.999772,-0.0213312,0,0.0209705,0.982864,-0.183137,0.00390652,0.183095,0.983087,-6.16084,7.86965,0.553307> }}
union{cone{<-6.12287,9.64905,0.221754> ,0.191314,<-6.75278,11.3315,-0.187482> ,0.178971}
sphere{<-6.12287,9.64905,0.221754> ,0.191314}
texture{txttree matrix <0.936516,0.350625,0,-0.341867,0.913125,-0.222102,-0.0778743,0.208002,0.975024,-6.12287,9.64905,0.221754> }}
union{cone{<-6.75278,11.3315,-0.187482> ,0.178971,<-6.52578,12.9942,-0.376008> ,0.166629}
sphere{<-6.75278,11.3315,-0.187482> ,0.178971}
texture{txttree matrix <0.990808,-0.135275,0,0.134429,0.984614,-0.111643,0.0151025,0.110616,0.993748,-6.75278,11.3315,-0.187482> }}
union{cone{<-6.52578,12.9942,-0.376008> ,0.166629,<-6.77292,14.6845,-0.395069> ,0.154286}
sphere{<-6.52578,12.9942,-0.376008> ,0.166629}
texture{txttree matrix <0.989479,0.144679,0,-0.14467,0.989417,-0.0111576,-0.00161427,0.0110402,0.999938,-6.52578,12.9942,-0.376008> }}
union{cone{<-6.77292,14.6845,-0.395069> ,0.154286,<-6.70056,16.4594,-0.470881> ,0.141943}
sphere{<-6.77292,14.6845,-0.395069> ,0.154286}
texture{txttree matrix <0.99917,-0.0407317,0,0.0406946,0.998261,-0.0426378,0.00173671,0.0426024,0.999091,-6.77292,14.6845,-0.395069> }}
union{cone{<-6.70056,16.4594,-0.470881> ,0.141943,<-6.58555,18.2147,-0.663945> ,0.1296}
sphere{<-6.70056,16.4594,-0.470881> ,0.141943}
texture{txttree matrix <0.99786,-0.0653863,0,0.0649959,0.991903,-0.109102,0.00713374,0.108868,0.994031,-6.70056,16.4594,-0.470881> }}
union{cone{<-6.58555,18.2147,-0.663945> ,0.1296,<-6.67942,21.337,-0.878636> ,0.12096}
sphere{<-6.58555,18.2147,-0.663945> ,0.1296}
texture{txttree matrix <0.999548,0.030051,0,-0.0299803,0.997196,-0.0685677,-0.00206053,0.0685367,0.997646,-6.58555,18.2147,-0.663945> }}
union{cone{<-6.67942,21.337,-0.878636> ,0.12096,<-7.03892,24.4916,-0.234354> ,0.11232}
sphere{<-6.67942,21.337,-0.878636> ,0.12096}
texture{txttree matrix <0.993569,0.113225,0,-0.110964,0.973724,0.198867,0.0225167,-0.197588,0.980027,-6.67942,21.337,-0.878636> }}
union{cone{<-7.03892,24.4916,-0.234354> ,0.11232,<-6.44924,27.624,-0.33636> ,0.10368}
sphere{<-7.03892,24.4916,-0.234354> ,0.11232}
texture{txttree matrix <0.982739,-0.184998,0,0.184904,0.982236,-0.0319861,0.00591737,0.0314339,0.999488,-7.03892,24.4916,-0.234354> }}
union{cone{<-6.44924,27.624,-0.33636> ,0.10368,<-6.65222,30.936,0.0779434> ,0.09504}
sphere{<-6.44924,27.624,-0.33636> ,0.10368}
texture{txttree matrix <0.998127,0.0611702,0,-0.0606989,0.990437,0.123895,0.00757869,-0.123663,0.992295,-6.44924,27.624,-0.33636> }}
union{cone{<-6.65222,30.936,0.0779434> ,0.09504,<-5.76512,34.0559,-0.495851> ,0.0864}
sphere{<-6.65222,30.936,0.0779434> ,0.09504}
texture{txttree matrix <0.961872,-0.273498,0,0.269317,0.947166,-0.174199,0.0476432,0.167557,0.98471,-6.65222,30.936,0.0779434> }}
union{cone{<-5.76512,34.0559,-0.495851> ,0.0864,<-5.06241,37.2248,-1.08625> ,0.07776}
sphere{<-5.76512,34.0559,-0.495851> ,0.0864}
texture{txttree matrix <0.976285,-0.216491,0,0.212996,0.960525,-0.178956,0.0387422,0.174712,0.983857,-5.76512,34.0559,-0.495851> }}
union{cone{<-6.55196,12.8024,-0.354263> ,0.1296,<-5.30743,15.6167,-1.53238> ,0.12096}
sphere{<-6.55196,12.8024,-0.354263> ,0.1296}
texture{txttree matrix <0.914564,-0.404442,0,0.377706,0.854106,-0.357549,0.144608,0.327001,0.933895,-6.55196,12.8024,-0.354263> }}
union{cone{<-5.30743,15.6167,-1.53238> ,0.12096,<-4.63901,18.4234,-2.73548> ,0.11232}
sphere{<-5.30743,15.6167,-1.53238> ,0.12096}
texture{txttree matrix <0.972795,-0.231667,0,0.213823,0.897863,-0.384866,0.0891609,0.374396,0.922972,-5.30743,15.6167,-1.53238> }}
union{cone{<-4.63901,18.4234,-2.73548> ,0.11232,<-3.75104,21.4067,-3.91199> ,0.10368}
sphere{<-4.63901,18.4234,-2.73548> ,0.11232}
texture{txttree matrix <0.958445,-0.285279,0,0.266853,0.896539,-0.353563,0.100864,0.338871,0.935411,-4.63901,18.4234,-2.73548> }}
union{cone{<-3.75104,21.4067,-3.91199> ,0.10368,<-3.11303,24.3479,-5.15173> ,0.09504}
sphere{<-3.75104,21.4067,-3.91199> ,0.10368}
texture{txttree matrix <0.977271,-0.211994,0,0.196015,0.903608,-0.380883,0.080745,0.372226,0.924623,-3.75104,21.4067,-3.91199> }}
union{cone{<-3.11303,24.3479,-5.15173> ,0.09504,<-2.56168,27.527,-5.59858> ,0.0864}
sphere{<-3.11303,24.3479,-5.15173> ,0.09504}
texture{txttree matrix <0.985292,-0.170877,0,0.169262,0.975977,-0.137181,0.0234412,0.135164,0.990546,-3.11303,24.3479,-5.15173> }}
union{cone{<-2.56168,27.527,-5.59858> ,0.0864,<-1.40998,30.398,-6.27563> ,0.07776}
sphere{<-2.56168,27.527,-5.59858> ,0.0864}
texture{txttree matrix <0.928107,-0.372314,0,0.363704,0.906645,-0.21381,0.0796043,0.198438,0.976875,-2.56168,27.527,-5.59858> }}
union{cone{<-6.55322,12.7932,-0.35322> ,0.1296,<-5.44646,15.4717,-1.82548> ,0.12096}
sphere{<-6.55322,12.7932,-0.35322> ,0.1296}
texture{txttree matrix <0.924207,-0.381893,0,0.340477,0.823978,-0.452919,0.172967,0.418591,0.891552,-6.55322,12.7932,-0.35322> }}
union{cone{<-5.44646,15.4717,-1.82548> ,0.12096,<-5.49118,17.8622,-3.87038> ,0.11232}
sphere{<-5.44646,15.4717,-1.82548> ,0.12096}
texture{txttree matrix <0.999825,0.018702,0,-0.0142129,0.759834,-0.649962,-0.0121556,0.649848,0.759967,-5.44646,15.4717,-1.82548> }}
union{cone{<-5.49118,17.8622,-3.87038> ,0.11232,<-5.16526,20.7766,-5.34198> ,0.10368}
sphere{<-5.49118,17.8622,-3.87038> ,0.11232}
texture{txttree matrix <0.993805,-0.111138,0,0.0993324,0.888238,-0.448515,0.0498471,0.445737,0.893775,-5.49118,17.8622,-3.87038> }}
union{cone{<-5.16526,20.7766,-5.34198> ,0.10368,<-4.0339,23.351,-7.23978> ,0.09504}
sphere{<-5.16526,20.7766,-5.34198> ,0.10368}
texture{txttree matrix <0.915496,-0.402327,0,0.333486,0.75885,-0.559405,0.225063,0.512133,0.828895,-5.16526,20.7766,-5.34198> }}
union{cone{<-4.0339,23.351,-7.23978> ,0.09504,<-3.10576,25.9513,-8.88047> ,0.0864}
sphere{<-4.0339,23.351,-7.23978> ,0.09504}
texture{txttree matrix <0.941803,-0.336166,0,0.28899,0.809636,-0.510857,0.171732,0.481126,0.859666,-4.0339,23.351,-7.23978> }}
union{cone{<-3.10576,25.9513,-8.88047> ,0.0864,<-2.70362,28.5259,-10.9343> ,0.07776}
sphere{<-3.10576,25.9513,-8.88047> ,0.0864}
texture{txttree matrix <0.98802,-0.154324,0,0.121202,0.77597,-0.619016,0.0955288,0.611601,0.785378,-3.10576,25.9513,-8.88047> }}
union{cone{<-6.14433,8.64344,0.409127> ,0.1296,<-6.39606,10.8328,-1.86883> ,0.12096}
sphere{<-6.14433,8.64344,0.409127> ,0.1296}
texture{txttree matrix <0.993455,0.114226,0,-0.0794222,0.690758,-0.718711,-0.0820954,0.714007,0.695308,-6.14433,8.64344,0.409127> }}
union{cone{<-6.39606,10.8328,-1.86883> ,0.12096,<-7.23435,12.9022,-4.32354> ,0.11232}
sphere{<-6.39606,10.8328,-1.86883> ,0.12096}
texture{txttree matrix <0.926838,0.375462,0,-0.252634,0.623635,-0.739767,-0.277754,0.685644,0.672863,-6.39606,10.8328,-1.86883> }}
union{cone{<-7.23435,12.9022,-4.32354> ,0.11232,<-8.29195,15.0457,-6.38128> ,0.10368}
sphere{<-7.23435,12.9022,-4.32354> ,0.11232}
texture{txttree matrix <0.89679,0.442457,0,-0.335318,0.679636,-0.652423,-0.288669,0.585086,0.757855,-7.23435,12.9022,-4.32354> }}
union{cone{<-8.29195,15.0457,-6.38128> ,0.10368,<-8.59117,18.202,-7.55513> ,0.09504}
sphere{<-8.29195,15.0457,-6.38128> ,0.10368}
texture{txttree matrix <0.995536,0.0943803,0,-0.0885085,0.9336,-0.347213,-0.0327701,0.345663,0.937786,-8.29195,15.0457,-6.38128> }}
union{cone{<-8.59117,18.202,-7.55513> ,0.09504,<-9.14563,20.3441,-9.93082> ,0.0864}
sphere{<-8.59117,18.202,-7.55513> ,0.09504}
texture{txttree matrix <0.968095,0.250582,0,-0.170786,0.659812,-0.731766,-0.183367,0.708419,0.681556,-8.59117,18.202,-7.55513> }}
union{cone{<-9.14563,20.3441,-9.93082> ,0.0864,<-9.29581,22.9659,-11.7236> ,0.07776}
sphere{<-9.14563,20.3441,-9.93082> ,0.0864}
texture{txttree matrix <0.998363,0.057189,0,-0.0472324,0.824547,-0.563818,-0.0322442,0.562896,0.825899,-9.14563,20.3441,-9.93082> }}
union{cone{<-6.20037,7.6468,0.437322> ,0.1296,<-6.98142,9.944,2.50296> ,0.12096}
sphere{<-6.20037,7.6468,0.437322> ,0.1296}
texture{txttree matrix <0.946771,0.321907,0,-0.245111,0.720907,0.648239,0.208672,-0.613734,0.761437,-6.20037,7.6468,0.437322> }}
union{cone{<-6.98142,9.944,2.50296> ,0.12096,<-6.90239,12.8117,4.25818> ,0.11232}
sphere{<-6.98142,9.944,2.50296> ,0.12096}
texture{txttree matrix <0.99962,-0.027551,0,0.0235013,0.852687,0.521894,-0.0143787,-0.521696,0.85301,-6.98142,9.944,2.50296> }}
union{cone{<-6.90239,12.8117,4.25818> ,0.11232,<-8.13612,15.6484,5.51163> ,0.10368}
sphere{<-6.90239,12.8117,4.25818> ,0.11232}
texture{txttree matrix <0.917023,0.398835,0,-0.369641,0.8499,0.375547,0.149781,-0.344386,0.926803,-6.90239,12.8117,4.25818> }}
union{cone{<-8.13612,15.6484,5.51163> ,0.10368,<-8.32902,18.7293,5.04501> ,0.09504}
sphere{<-8.13612,15.6484,5.51163> ,0.10368}
texture{txttree matrix <0.998046,0.0624886,0,-0.0617867,0.986835,-0.149461,-0.00933958,0.149168,0.988768,-8.13612,15.6484,5.51163> }}
union{cone{<-8.32902,18.7293,5.04501> ,0.09504,<-9.79134,21.5245,5.24123> ,0.0864}
sphere{<-8.32902,18.7293,5.04501> ,0.09504}
texture{txttree matrix <0.886072,0.463547,0,-0.462653,0.884363,0.0620815,0.0287777,-0.0550087,0.998071,-8.32902,18.7293,5.04501> }}
union{cone{<-9.79134,21.5245,5.24123> ,0.0864,<-9.60258,24.9259,5.48687> ,0.07776}
sphere{<-9.79134,21.5245,5.24123> ,0.0864}
texture{txttree matrix <0.998464,-0.0554092,0,0.0552657,0.995878,0.0719197,-0.00398501,-0.0718092,0.99741,-9.79134,21.5245,5.24123> }}
union{cone{<-3.17673,3.91521,-0.267508> ,0.216,<-4.45024,4.00015,-1.3973> ,0.203657}
sphere{<-3.17673,3.91521,-0.267508> ,0.216}
texture{txttree matrix <0.0665488,0.997783,0,-0.747129,0.049831,-0.662808,-0.661339,0.0441091,0.748789,-3.17673,3.91521,-0.267508> }}
union{cone{<-4.45024,4.00015,-1.3973> ,0.203657,<-5.44514,3.8546,-2.86242> ,0.191314}
sphere{<-4.45024,4.00015,-1.3973> ,0.203657}
texture{txttree matrix <-0.144757,0.989467,0,-0.559887,-0.0819102,-0.82451,-0.815826,-0.119354,0.565847,-4.45024,4.00015,-1.3973> }}
union{cone{<-5.44514,3.8546,-2.86242> ,0.191314,<-6.84183,4.58387,-3.79384> ,0.178971}
sphere{<-5.44514,3.8546,-2.86242> ,0.191314}
texture{txttree matrix <0.462845,0.886439,0,-0.763079,0.398434,-0.508882,-0.451093,0.235534,0.860836,-5.44514,3.8546,-2.86242> }}
union{cone{<-6.84183,4.58387,-3.79384> ,0.178971,<-8.33511,4.85064,-4.53401> ,0.166629}
sphere{<-6.84183,4.58387,-3.79384> ,0.178971}
texture{txttree matrix <0.175866,0.984414,0,-0.884712,0.158054,-0.438524,-0.431689,0.0771212,0.89872,-6.84183,4.58387,-3.79384> }}
union{cone{<-8.33511,4.85064,-4.53401> ,0.166629,<-9.09745,5.17882,-6.16119> ,0.154286}
sphere{<-8.33511,4.85064,-4.53401> ,0.166629}
texture{txttree matrix <0.395401,0.918509,0,-0.417348,0.17966,-0.89081,-0.818217,0.352227,0.454375,-8.33511,4.85064,-4.53401> }}
union{cone{<-9.09745,5.17882,-6.16119> ,0.154286,<-10.4529,5.36718,-7.24988> ,0.141943}
sphere{<-9.09745,5.17882,-6.16119> ,0.154286}
texture{txttree matrix <0.137649,0.990481,0,-0.775114,0.107719,-0.622571,-0.616645,0.0856966,0.782563,-9.09745,5.17882,-6.16119> }}
union{cone{<-10.4529,5.36718,-7.24988> ,0.141943,<-11.126,6.0817,-8.70104> ,0.1296}
sphere{<-10.4529,5.36718,-7.24988> ,0.141943}
texture{txttree matrix <0.727883,0.685701,0,-0.384193,0.407827,-0.828295,-0.567963,0.602902,0.560292,-10.4529,5.36718,-7.24988> }}
union{cone{<-11.126,6.0817,-8.70104> ,0.1296,<-12.7581,7.3967,-11.0578> ,0.12096}
sphere{<-11.126,6.0817,-8.70104> ,0.1296}
texture{txttree matrix <0.627405,0.778693,0,-0.517484,0.416945,-0.74724,-0.58187,0.468822,0.664554,-11.126,6.0817,-8.70104> }}
union{cone{<-12.7581,7.3967,-11.0578> ,0.12096,<-14.327,9.8446,-12.2154> ,0.11232}
sphere{<-12.7581,7.3967,-11.0578> ,0.12096}
texture{txttree matrix <0.841923,0.539597,0,-0.501322,0.782203,-0.369911,-0.199603,0.311437,0.929067,-12.7581,7.3967,-11.0578> }}
union{cone{<-14.327,9.8446,-12.2154> ,0.11232,<-16.0297,11.5485,-14.4506> ,0.10368}
sphere{<-14.327,9.8446,-12.2154> ,0.11232}
texture{txttree matrix <0.707338,0.706875,0,-0.518167,0.518507,-0.680186,-0.480807,0.481122,0.733039,-14.327,9.8446,-12.2154> }}
union{cone{<-16.0297,11.5485,-14.4506> ,0.10368,<-17.8655,13.0839,-16.4875> ,0.09504}
sphere{<-16.0297,11.5485,-14.4506> ,0.10368}
texture{txttree matrix <0.64156,0.767073,0,-0.584145,0.488564,-0.648135,-0.497167,0.415818,0.761525,-16.0297,11.5485,-14.4506> }}
union{cone{<-17.8655,13.0839,-16.4875> ,0.09504,<-19.4063,14.644,-18.9801> ,0.0864}
sphere{<-17.8655,13.0839,-16.4875> ,0.09504}
texture{txttree matrix <0.711502,0.702684,0,-0.464121,0.469945,-0.750828,-0.527595,0.534215,0.660498,-17.8655,13.0839,-16.4875> }}
union{cone{<-19.4063,14.644,-18.9801> ,0.0864,<-20.416,16.2575,-21.6669> ,0.07776}
sphere{<-19.4063,14.644,-18.9801> ,0.0864}
texture{txttree matrix <0.847712,0.530457,0,-0.306639,0.490034,-0.81599,-0.432847,0.691724,0.578066,-19.4063,14.644,-18.9801> }}
union{cone{<-7.88844,4.77085,-4.31261> ,0.1296,<-9.90692,7.26285,-4.6192> ,0.12096}
sphere{<-7.88844,4.77085,-4.31261> ,0.1296}
texture{txttree matrix <0.77707,0.629414,0,-0.626557,0.773543,-0.0951692,-0.0599008,0.0739531,0.995461,-7.88844,4.77085,-4.31261> }}
union{cone{<-9.90692,7.26285,-4.6192> ,0.12096,<-11.8287,8.966,-6.47651> ,0.11232}
sphere{<-9.90692,7.26285,-4.6192> ,0.12096}
texture{txttree matrix <0.663249,0.748399,0,-0.606406,0.537412,-0.586054,-0.438602,0.3887,0.810272,-9.90692,7.26285,-4.6192> }}
union{cone{<-11.8287,8.966,-6.47651> ,0.11232,<-13.3613,11.112,-8.38257> ,0.10368}
sphere{<-11.8287,8.966,-6.47651> ,0.11232}
texture{txttree matrix <0.813794,0.581154,0,-0.471001,0.659545,-0.585797,-0.340438,0.476718,0.810458,-11.8287,8.966,-6.47651> }}
union{cone{<-13.3613,11.112,-8.38257> ,0.10368,<-15.464,13.0424,-10.0184> ,0.09504}
sphere{<-13.3613,11.112,-8.38257> ,0.10368}
texture{txttree matrix <0.676262,0.736661,0,-0.639147,0.586743,-0.497216,-0.36628,0.336249,0.867627,-13.3613,11.112,-8.38257> }}
union{cone{<-15.464,13.0424,-10.0184> ,0.09504,<-16.6069,15.2196,-12.3252> ,0.0864}
sphere{<-15.464,13.0424,-10.0184> ,0.09504}
texture{txttree matrix <0.885435,0.464764,0,-0.338957,0.645756,-0.684183,-0.317984,0.605799,0.72931,-15.464,13.0424,-10.0184> }}
union{cone{<-16.6069,15.2196,-12.3252> ,0.0864,<-18.8285,17.3572,-13.63> ,0.07776}
sphere{<-16.6069,15.2196,-12.3252> ,0.0864}
texture{txttree matrix <0.693328,0.720622,0,-0.663634,0.638498,-0.389757,-0.280867,0.270229,0.920918,-16.6069,15.2196,-12.3252> }}
union{cone{<-9.03891,5.15362,-6.03624> ,0.1296,<-10.0736,5.63461,-9.22004> ,0.12096}
sphere{<-9.03891,5.15362,-6.03624> ,0.1296}
texture{txttree matrix <0.421553,0.906804,0,-0.305926,0.142218,-0.941373,-0.853641,0.396838,0.337368,-9.03891,5.15362,-6.03624> }}
union{cone{<-10.0736,5.63461,-9.22004> ,0.12096,<-10.1893,5.95253,-12.4696> ,0.11232}
sphere{<-10.0736,5.63461,-9.22004> ,0.12096}
texture{txttree matrix <0.939702,0.341996,0,-0.0354147,0.097309,-0.994624,-0.340157,0.93465,0.103553,-10.0736,5.63461,-9.22004> }}
union{cone{<-10.1893,5.95253,-12.4696> ,0.11232,<-10.1704,7.86165,-14.9525> ,0.10368}
sphere{<-10.1893,5.95253,-12.4696> ,0.11232}
texture{txttree matrix <0.999951,-0.00986561,0,0.0060137,0.609532,-0.792738,0.00782085,0.7927,0.609562,-10.1893,5.95253,-12.4696> }}
union{cone{<-10.1704,7.86165,-14.9525> ,0.10368,<-11.1321,8.87516,-17.8581> ,0.09504}
sphere{<-10.1704,7.86165,-14.9525> ,0.10368}
texture{txttree matrix <0.725435,0.688291,0,-0.298263,0.314359,-0.901231,-0.620309,0.653784,0.433338,-10.1704,7.86165,-14.9525> }}
union{cone{<-11.1321,8.87516,-17.8581> ,0.09504,<-11.9443,10.0682,-20.7159> ,0.0864}
sphere{<-11.1321,8.87516,-17.8581> ,0.09504}
texture{txttree matrix <0.826609,0.562776,0,-0.253701,0.372637,-0.892624,-0.502348,0.737851,0.450802,-11.1321,8.87516,-17.8581> }}
union{cone{<-11.9443,10.0682,-20.7159> ,0.0864,<-12.5132,11.074,-23.739> ,0.07776}
sphere{<-11.9443,10.0682,-20.7159> ,0.0864}
texture{txttree matrix <0.870406,0.492334,0,-0.175792,0.310786,-0.934082,-0.45988,0.813031,0.357058,-11.9443,10.0682,-20.7159> }}
union{cone{<-9.22751,5.19689,-6.26565> ,0.1296,<-10.1887,4.88192,-9.36801> ,0.12096}
sphere{<-9.22751,5.19689,-6.26565> ,0.1296}
texture{txttree matrix <-0.311399,0.950279,0,-0.29456,-0.0965251,-0.950746,-0.903474,-0.296061,0.309972,-9.22751,5.19689,-6.26565> }}
union{cone{<-10.1887,4.88192,-9.36801> ,0.12096,<-10.8702,5.33286,-12.5071> ,0.11232}
sphere{<-10.1887,4.88192,-9.36801> ,0.12096}
texture{txttree matrix <0.551793,0.833981,0,-0.210112,0.139018,-0.967743,-0.80708,0.533994,0.251938,-10.1887,4.88192,-9.36801> }}
union{cone{<-10.8702,5.33286,-12.5071> ,0.11232,<-11.3174,5.18411,-15.7101> ,0.10368}
sphere{<-10.8702,5.33286,-12.5071> ,0.11232}
texture{txttree matrix <-0.315679,0.948866,0,-0.138108,-0.0459472,-0.989351,-0.938761,-0.312317,0.145551,-10.8702,5.33286,-12.5071> }}
union{cone{<-11.3174,5.18411,-15.7101> ,0.10368,<-12.102,5.06237,-18.7881> ,0.09504}
sphere{<-11.3174,5.18411,-15.7101> ,0.10368}
texture{txttree matrix <-0.153306,0.988179,0,-0.246856,-0.0382973,-0.968295,-0.956849,-0.148446,0.249809,-11.3174,5.18411,-15.7101> }}
union{cone{<-12.102,5.06237,-18.7881> ,0.09504,<-13.9059,5.03021,-21.4611> ,0.0864}
sphere{<-12.102,5.06237,-18.7881> ,0.09504}
texture{txttree matrix <-0.0178276,0.999841,0,-0.559366,-0.00997372,-0.828861,-0.828729,-0.0147766,0.559455,-12.102,5.06237,-18.7881> }}
union{cone{<-13.9059,5.03021,-21.4611> ,0.0864,<-15.4438,6.3255,-23.8834> ,0.07776}
sphere{<-13.9059,5.03021,-21.4611> ,0.0864}
texture{txttree matrix <0.644211,0.764848,0,-0.488507,0.411456,-0.769457,-0.588518,0.495692,0.638699,-13.9059,5.03021,-21.4611> }}
union{cone{<-8.64069,4.98219,-5.18625> ,0.1296,<-11.4367,4.76329,-6.8746> ,0.12096}
sphere{<-8.64069,4.98219,-5.18625> ,0.1296}
texture{txttree matrix <-0.0780488,0.99695,0,-0.854123,-0.0668672,-0.515755,-0.514182,-0.0402541,0.856736,-8.64069,4.98219,-5.18625> }}
union{cone{<-11.4367,4.76329,-6.8746> ,0.12096,<-12.4238,5.07941,-9.99929> ,0.11232}
sphere{<-11.4367,4.76329,-6.8746> ,0.12096}
texture{txttree matrix <0.305003,0.952351,0,-0.299826,0.0960234,-0.949149,-0.903923,0.289494,0.314828,-11.4367,4.76329,-6.8746> }}
union{cone{<-12.4238,5.07941,-9.99929> ,0.11232,<-13.9686,4.50289,-12.9865> ,0.10368}
sphere{<-12.4238,5.07941,-9.99929> ,0.11232}
texture{txttree matrix <-0.349647,0.936882,0,-0.452747,-0.168966,-0.875483,-0.820224,-0.30611,0.483249,-12.4238,5.07941,-9.99929> }}
union{cone{<-13.9686,4.50289,-12.9865> ,0.10368,<-16.1035,5.41204,-15.1578> ,0.09504}
sphere{<-13.9686,4.50289,-12.9865> ,0.10368}
texture{txttree matrix <0.391789,0.920055,0,-0.671808,0.286077,-0.683252,-0.62863,0.267691,0.730182,-13.9686,4.50289,-12.9865> }}
union{cone{<-16.1035,5.41204,-15.1578> ,0.09504,<-18.1242,6.27874,-17.5718> ,0.0864}
sphere{<-16.1035,5.41204,-15.1578> ,0.09504}
texture{txttree matrix <0.394184,0.919031,0,-0.618858,0.265436,-0.739295,-0.679436,0.291419,0.673381,-16.1035,5.41204,-15.1578> }}
union{cone{<-18.1242,6.27874,-17.5718> ,0.0864,<-18.8903,7.76141,-20.3548> ,0.07776}
sphere{<-18.1242,6.27874,-17.5718> ,0.0864}
texture{txttree matrix <0.888412,0.459048,0,-0.236084,0.456901,-0.857616,-0.393687,0.761916,0.51429,-18.1242,6.27874,-17.5718> }}
union{cone{<-3.38505,3.97152,-0.275442> ,0.216,<-5.17174,3.83915,-0.31319> ,0.203657}
sphere{<-3.38505,3.97152,-0.275442> ,0.216}
texture{txttree matrix <-0.0738819,0.997267,0,-0.997046,-0.0738655,-0.021065,-0.0210074,-0.00155632,0.999778,-3.38505,3.97152,-0.275442> }}
union{cone{<-5.17174,3.83915,-0.31319> ,0.203657,<-6.8612,3.78339,-0.262105> ,0.191314}
sphere{<-5.17174,3.83915,-0.31319> ,0.203657}
texture{txttree matrix <-0.032986,0.999456,0,-0.999,-0.032971,0.0302072,0.0301908,0.000996415,0.999544,-5.17174,3.83915,-0.31319> }}
union{cone{<-6.8612,3.78339,-0.262105> ,0.191314,<-8.24665,2.89186,-0.57583> ,0.178971}
sphere{<-6.8612,3.78339,-0.262105> ,0.191314}
texture{txttree matrix <-0.541138,0.840934,0,-0.826089,-0.531586,-0.187062,-0.157307,-0.101227,0.982348,-6.8612,3.78339,-0.262105> }}
union{cone{<-8.24665,2.89186,-0.57583> ,0.178971,<-9.75159,2.2747,-1.32998> ,0.166629}
sphere{<-8.24665,2.89186,-0.57583> ,0.178971}
texture{txttree matrix <-0.379427,0.925222,0,-0.83939,-0.344228,-0.420633,-0.389178,-0.159599,0.907231,-8.24665,2.89186,-0.57583> }}
union{cone{<-9.75159,2.2747,-1.32998> ,0.166629,<-11.5688,2.34221,-1.22388> ,0.154286}
sphere{<-9.75159,2.2747,-1.32998> ,0.166629}
texture{txttree matrix <0.037129,0.99931,0,-0.997614,0.037066,0.0582492,0.058209,-0.00216274,0.998302,-9.75159,2.2747,-1.32998> }}
union{cone{<-11.5688,2.34221,-1.22388> ,0.154286,<-13.161,2.80424,-1.67736> ,0.141943}
sphere{<-11.5688,2.34221,-1.22388> ,0.154286}
texture{txttree matrix <0.278688,0.960382,0,-0.926352,0.268813,-0.263839,-0.253386,0.0735286,0.964567,-11.5688,2.34221,-1.22388> }}
union{cone{<-13.161,2.80424,-1.67736> ,0.141943,<-14.8564,2.98728,-2.07883> ,0.1296}
sphere{<-13.161,2.80424,-1.67736> ,0.141943}
texture{txttree matrix <0.107336,0.994223,0,-0.967767,0.10448,-0.229154,-0.22783,0.0245965,0.97339,-13.161,2.80424,-1.67736> }}
union{cone{<-14.8564,2.98728,-2.07883> ,0.1296,<-18.0407,3.38173,-1.52562> ,0.12096}
sphere{<-14.8564,2.98728,-2.07883> ,0.1296}
texture{txttree matrix <0.122934,0.992415,0,-0.977985,0.121147,0.169907,0.168618,-0.0208874,0.98546,-14.8564,2.98728,-2.07883> }}
union{cone{<-18.0407,3.38173,-1.52562> ,0.12096,<-20.6979,4.85665,-2.54453> ,0.11232}
sphere{<-18.0407,3.38173,-1.52562> ,0.12096}
texture{txttree matrix <0.485317,0.874338,0,-0.828987,0.460144,-0.317881,-0.277935,0.154273,0.948131,-18.0407,3.38173,-1.52562> }}
union{cone{<-20.6979,4.85665,-2.54453> ,0.11232,<-23.4581,5.41285,-4.21116> ,0.10368}
sphere{<-20.6979,4.85665,-2.54453> ,0.11232}
texture{txttree matrix <0.197537,0.980295,0,-0.843594,0.169991,-0.509364,-0.499327,0.100618,0.860551,-20.6979,4.85665,-2.54453> }}
union{cone{<-23.4581,5.41285,-4.21116> ,0.10368,<-26.4384,6.87924,-4.80893> ,0.09504}
sphere{<-23.4581,5.41285,-4.21116> ,0.10368}
texture{txttree matrix <0.441486,0.897268,0,-0.883081,0.434505,-0.177124,-0.158928,0.0781977,0.984189,-23.4581,5.41285,-4.21116> }}
union{cone{<-26.4384,6.87924,-4.80893> ,0.09504,<-28.2771,8.99901,-6.33631> ,0.0864}
sphere{<-26.4384,6.87924,-4.80893> ,0.09504}
texture{txttree matrix <0.755405,0.655258,0,-0.575528,0.663489,-0.478069,-0.313259,0.361136,0.878322,-26.4384,6.87924,-4.80893> }}
union{cone{<-28.2771,8.99901,-6.33631> ,0.0864,<-30.7007,10.8793,-7.22956> ,0.07776}
sphere{<-28.2771,8.99901,-6.33631> ,0.0864}
texture{txttree matrix <0.612987,0.790093,0,-0.758584,0.588541,-0.27959,-0.220902,0.171385,0.96012,-28.2771,8.99901,-6.33631> }}
union{cone{<-11.5403,2.34115,-1.22555> ,0.1296,<-14.7397,3.34938,-0.934234> ,0.12096}
sphere{<-11.5403,2.34115,-1.22555> ,0.1296}
texture{txttree matrix <0.300557,0.953764,0,-0.950188,0.29943,0.0865161,0.082516,-0.0260031,0.99625,-11.5403,2.34115,-1.22555> }}
union{cone{<-14.7397,3.34938,-0.934234> ,0.12096,<-17.9818,3.86108,-1.32128> ,0.11232}
sphere{<-14.7397,3.34938,-0.934234> ,0.12096}
texture{txttree matrix <0.155902,0.987773,0,-0.980976,0.154829,-0.11711,-0.115678,0.0182577,0.993119,-14.7397,3.34938,-0.934234> }}
union{cone{<-17.9818,3.86108,-1.32128> ,0.11232,<-20.4754,5.90573,-1.92211> ,0.10368}
sphere{<-17.9818,3.86108,-1.32128> ,0.11232}
texture{txttree matrix <0.634058,0.773286,0,-0.760202,0.62333,-0.183171,-0.141644,0.116141,0.983081,-17.9818,3.86108,-1.32128> }}
union{cone{<-20.4754,5.90573,-1.92211> ,0.10368,<-22.8455,7.6114,-3.05768> ,0.09504}
sphere{<-20.4754,5.90573,-1.92211> ,0.10368}
texture{txttree matrix <0.584119,0.811668,0,-0.756479,0.544403,-0.362443,-0.294183,0.21171,0.932006,-20.4754,5.90573,-1.92211> }}
union{cone{<-22.8455,7.6114,-3.05768> ,0.09504,<-25.5533,8.8069,-4.1185> ,0.0864}
sphere{<-22.8455,7.6114,-3.05768> ,0.09504}
texture{txttree matrix <0.403889,0.914808,0,-0.861174,0.38021,-0.337373,-0.308631,0.136261,0.941371,-22.8455,7.6114,-3.05768> }}
union{cone{<-25.5533,8.8069,-4.1185> ,0.0864,<-27.534,10.9847,-5.53877> ,0.07776}
sphere{<-25.5533,8.8069,-4.1185> ,0.0864}
texture{txttree matrix <0.739791,0.672837,0,-0.605994,0.666296,-0.434536,-0.292372,0.321466,0.900655,-25.5533,8.8069,-4.1185> }}
union{cone{<-10.8146,2.31419,-1.26792> ,0.1296,<-13.9455,3.26022,-1.7742> ,0.12096}
sphere{<-10.8146,2.31419,-1.26792> ,0.1296}
texture{txttree matrix <0.289248,0.957254,0,-0.945988,0.285844,-0.152972,-0.146433,0.0442469,0.988231,-10.8146,2.31419,-1.26792> }}
union{cone{<-13.9455,3.26022,-1.7742> ,0.12096,<-16.9429,4.11224,-1.80961> ,0.11232}
sphere{<-13.9455,3.26022,-1.7742> ,0.12096}
texture{txttree matrix <0.27342,0.961895,0,-0.961833,0.273403,-0.0113632,-0.0109302,0.00310692,0.999935,-13.9455,3.26022,-1.7742> }}
union{cone{<-16.9429,4.11224,-1.80961> ,0.11232,<-19.5715,4.75062,-3.51233> ,0.10368}
sphere{<-16.9429,4.11224,-1.80961> ,0.11232}
texture{txttree matrix <0.236,0.971753,0,-0.822388,0.199726,-0.532717,-0.517669,0.125721,0.846294,-16.9429,4.11224,-1.80961> }}
union{cone{<-19.5715,4.75062,-3.51233> ,0.10368,<-21.9818,5.53457,-5.33466> ,0.09504}
sphere{<-19.5715,4.75062,-3.51233> ,0.10368}
texture{txttree matrix <0.30929,0.950968,0,-0.772121,0.251122,-0.583752,-0.555129,0.180549,0.811932,-19.5715,4.75062,-3.51233> }}
union{cone{<-21.9818,5.53457,-5.33466> ,0.09504,<-24.1453,5.72151,-7.69391> ,0.0864}
sphere{<-21.9818,5.53457,-5.33466> ,0.09504}
texture{txttree matrix <0.0860895,0.996287,0,-0.674708,0.0583017,-0.735778,-0.733046,0.0633428,0.677223,-21.9818,5.53457,-5.33466> }}
union{cone{<-24.1453,5.72151,-7.69391> ,0.0864,<-27.0912,6.24165,-9.26356> ,0.07776}
sphere{<-24.1453,5.72151,-7.69391> ,0.0864}
texture{txttree matrix <0.173871,0.984768,0,-0.87202,0.153964,-0.464625,-0.457548,0.0807847,0.885508,-24.1453,5.72151,-7.69391> }}
union{cone{<-4.88568,3.86035,-0.307146> ,0.1296,<-8.0075,3.00992,-1.10055> ,0.12096}
sphere{<-4.88568,3.86035,-0.307146> ,0.1296}
texture{txttree matrix <-0.262836,0.964841,0,-0.937079,-0.255273,-0.238157,-0.229784,-0.0625963,0.971227,-4.88568,3.86035,-0.307146> }}
union{cone{<-8.0075,3.00992,-1.10055> ,0.12096,<-10.4906,1.36173,-2.07517> ,0.11232}
sphere{<-8.0075,3.00992,-1.10055> ,0.12096}
texture{txttree matrix <-0.553024,0.833165,0,-0.791897,-0.525632,-0.31082,-0.258964,-0.171891,0.950469,-8.0075,3.00992,-1.10055> }}
union{cone{<-10.4906,1.36173,-2.07517> ,0.11232,<-13.0444,0.751492,-3.79087> ,0.10368}
sphere{<-10.4906,1.36173,-2.07517> ,0.11232}
texture{txttree matrix <-0.232412,0.972617,0,-0.814203,-0.194558,-0.54701,-0.532032,-0.127132,0.837126,-10.4906,1.36173,-2.07517> }}
union{cone{<-13.0444,0.751492,-3.79087> ,0.10368,<-16.2314,0.733553,-4.69416> ,0.09504}
sphere{<-13.0444,0.751492,-3.79087> ,0.10368}
texture{txttree matrix <-0.00562856,0.999984,0,-0.96209,-0.00541527,-0.272678,-0.272674,-0.00153479,0.962105,-13.0444,0.751492,-3.79087> }}
union{cone{<-16.2314,0.733553,-4.69416> ,0.09504,<-19.41,1.46835,-4.88577> ,0.0864}
sphere{<-16.2314,0.733553,-4.69416> ,0.09504}
texture{txttree matrix <0.225234,0.974305,0,-0.972628,0.224847,-0.0586332,-0.0571266,0.0132062,0.99828,-16.2314,0.733553,-4.69416> }}
union{cone{<-19.41,1.46835,-4.88577> ,0.0864,<-21.3565,2.08505,-7.35593> ,0.07776}
sphere{<-19.41,1.46835,-4.88577> ,0.0864}
texture{txttree matrix <0.302017,0.953303,0,-0.607382,0.192426,-0.770752,-0.73476,0.23278,0.637135,-19.41,1.46835,-4.88577> }}
union{cone{<-0.0553767,1.39719,-0.0532692> ,0.6,<0.362017,1.18699,0.236569> ,0.573333}
sphere{<-0.0553767,1.39719,-0.0532692> ,0.6}
texture{txttree matrix <-0.449791,-0.893134,0,0.759012,-0.382246,0.527057,-0.470732,0.237066,0.84983,-0.0553767,1.39719,-0.0532692> }}
union{cone{<0.362017,1.18699,0.236569> ,0.573333,<0.852312,1.29061,0.413855> ,0.546667}
sphere{<0.362017,1.18699,0.236569> ,0.573333}
texture{txttree matrix <0.206781,-0.978387,0,0.922368,0.194941,0.33352,-0.326312,-0.0689656,0.942743,0.362017,1.18699,0.236569> }}
union{cone{<0.852312,1.29061,0.413855> ,0.546667,<1.37767,1.31794,0.343118> ,0.52}
sphere{<0.852312,1.29061,0.413855> ,0.546667}
texture{txttree matrix <0.0519518,-0.99865,0,0.989742,0.0514884,-0.133264,0.133084,0.00692329,0.991081,0.852312,1.29061,0.413855> }}
union{cone{<1.37767,1.31794,0.343118> ,0.52,<1.88773,1.4473,0.494335> ,0.493333}
sphere{<1.37767,1.31794,0.343118> ,0.52}
texture{txttree matrix <0.245843,-0.96931,0,0.931606,0.23628,0.276192,-0.267716,-0.0678999,0.961102,1.37767,1.31794,0.343118> }}
union{cone{<1.88773,1.4473,0.494335> ,0.493333,<2.35791,1.55388,0.26197> ,0.466667}
sphere{<1.88773,1.4473,0.494335> ,0.493333}
texture{txttree matrix <0.221057,-0.975261,0,0.878541,0.199134,-0.434179,0.423438,0.0959784,0.900826,1.88773,1.4473,0.494335> }}
union{cone{<2.35791,1.55388,0.26197> ,0.466667,<2.86307,1.60483,0.210902> ,0.44}
sphere{<2.35791,1.55388,0.26197> ,0.466667}
texture{txttree matrix <0.100363,-0.994951,0,0.989956,0.0998596,-0.100077,0.0995717,0.0100441,0.99498,2.35791,1.55388,0.26197> }}
union{cone{<2.86307,1.60483,0.210902> ,0.44,<3.40067,1.68279,0.283686> ,0.413333}
sphere{<2.86307,1.60483,0.210902> ,0.44}
texture{txttree matrix <0.143511,-0.989649,0,0.980884,0.14224,0.132797,-0.131423,-0.0190579,0.991143,2.86307,1.60483,0.210902> }}
union{cone{<3.40067,1.68279,0.283686> ,0.413333,<3.88379,1.71229,0.0613065> ,0.386667}
sphere{<3.40067,1.68279,0.283686> ,0.413333}
texture{txttree matrix <0.0609515,-0.998141,0,0.906995,0.0553857,-0.417484,0.416708,0.0254463,0.908684,3.40067,1.68279,0.283686> }}
union{cone{<3.88379,1.71229,0.0613065> ,0.386667,<4.32972,1.7954,-0.210061> ,0.36}
sphere{<3.88379,1.71229,0.0613065> ,0.386667}
texture{txttree matrix <0.183205,-0.983075,0,0.843631,0.157219,-0.513389,0.5047,0.0940556,0.858156,3.88379,1.71229,0.0613065> }}
union{cone{<4.32972,1.7954,-0.210061> ,0.36,<5.07855,1.76772,0.358842> ,0.342}
sphere{<4.32972,1.7954,-0.210061> ,0.36}
texture{txttree matrix <-0.0369358,-0.999318,0,0.795925,-0.0294182,0.604679,-0.604267,0.0223343,0.796469,4.32972,1.7954,-0.210061> }}
union{cone{<5.07855,1.76772,0.358842> ,0.342,<5.92134,1.87319,0.802522> ,0.324}
sphere{<5.07855,1.76772,0.358842> ,0.342}
texture{txttree matrix <0.124178,-0.99226,0,0.879495,0.110066,0.463005,-0.459421,-0.0574951,0.886356,5.07855,1.76772,0.358842> }}
union{cone{<5.92134,1.87319,0.802522> ,0.324,<6.65168,1.95873,1.35858> ,0.306}
sphere{<5.92134,1.87319,0.802522> ,0.324}
texture{txttree matrix <0.116328,-0.993211,0,0.792204,0.0927858,0.603161,-0.599066,-0.0701647,0.79762,5.92134,1.87319,0.802522> }}
union{cone{<6.65168,1.95873,1.35858> ,0.306,<7.55521,2.36945,1.34373> ,0.288}
sphere{<6.65168,1.95873,1.35858> ,0.306}
texture{txttree matrix <0.41382,-0.910359,0,0.910257,0.413774,-0.0149546,0.0136141,0.00618852,0.999888,6.65168,1.95873,1.35858> }}
union{cone{<7.55521,2.36945,1.34373> ,0.288,<8.45033,2.78157,1.28918> ,0.27}
sphere{<7.55521,2.36945,1.34373> ,0.288}
texture{txttree matrix <0.418213,-0.908349,0,0.90696,0.417574,-0.0552741,0.0502081,0.0231164,0.998471,7.55521,2.36945,1.34373> }}
union{cone{<8.45033,2.78157,1.28918> ,0.27,<9.13811,3.42843,1.50335> ,0.252}
sphere{<8.45033,2.78157,1.28918> ,0.27}
texture{txttree matrix <0.685106,-0.728443,0,0.710397,0.668134,0.22121,-0.161139,-0.151552,0.975226,8.45033,2.78157,1.28918> }}
union{cone{<9.13811,3.42843,1.50335> ,0.252,<9.88457,3.97601,1.18876> ,0.234}
sphere{<9.13811,3.42843,1.50335> ,0.252}
texture{txttree matrix <0.59149,-0.806313,0,0.763439,0.560038,-0.321743,0.259425,0.190307,0.946827,9.13811,3.42843,1.50335> }}
union{cone{<9.88457,3.97601,1.18876> ,0.234,<10.6368,4.47265,0.93835> ,0.216}
sphere{<9.88457,3.97601,1.18876> ,0.234}
texture{txttree matrix <0.550976,-0.834521,0,0.804069,0.530871,-0.267672,0.223378,0.147481,0.96351,9.88457,3.97601,1.18876> }}
union{cone{<10.6368,4.47265,0.93835> ,0.216,<12.2268,5.00215,1.42743> ,0.203657}
sphere{<10.6368,4.47265,0.93835> ,0.216}
texture{txttree matrix <0.315956,-0.948774,0,0.91078,0.303304,0.280154,-0.265803,-0.0885163,0.959955,10.6368,4.47265,0.93835> }}
union{cone{<12.2268,5.00215,1.42743> ,0.203657,<13.4134,6.28782,1.25552> ,0.191314}
sphere{<12.2268,5.00215,1.42743> ,0.203657}
texture{txttree matrix <0.734861,-0.678217,0,0.674967,0.731339,-0.0977873,0.066321,0.0718601,0.995207,12.2268,5.00215,1.42743> }}
union{cone{<13.4134,6.28782,1.25552> ,0.191314,<14.5357,7.46279,2.02051> ,0.178971}
sphere{<13.4134,6.28782,1.25552> ,0.191314}
texture{txttree matrix <0.723104,-0.690739,0,0.624944,0.654227,0.425949,-0.29422,-0.308006,0.904747,13.4134,6.28782,1.25552> }}
union{cone{<14.5357,7.46279,2.02051> ,0.178971,<16.0115,8.40306,2.45339> ,0.166629}
sphere{<14.5357,7.46279,2.02051> ,0.178971}
texture{txttree matrix <0.537346,-0.843362,0,0.818683,0.521622,0.240144,-0.202528,-0.12904,0.970737,14.5357,7.46279,2.02051> }}
union{cone{<16.0115,8.40306,2.45339> ,0.166629,<16.6547,10.0531,2.19646> ,0.154286}
sphere{<16.0115,8.40306,2.45339> ,0.166629}
texture{txttree matrix <0.931709,-0.363207,0,0.359444,0.922056,-0.143574,0.0521469,0.133769,0.98964,16.0115,8.40306,2.45339> }}
union{cone{<16.6547,10.0531,2.19646> ,0.154286,<17.4652,11.5399,1.56593> ,0.141943}
sphere{<16.6547,10.0531,2.19646> ,0.154286}
texture{txttree matrix <0.87802,-0.478625,0,0.448536,0.822824,-0.348965,0.167023,0.306398,0.937136,16.6547,10.0531,2.19646> }}
union{cone{<17.4652,11.5399,1.56593> ,0.141943,<18.5455,12.9282,1.76659> ,0.1296}
sphere{<17.4652,11.5399,1.56593> ,0.141943}
texture{txttree matrix <0.789217,-0.614114,0,0.610158,0.784133,0.113326,-0.069595,-0.0894387,0.993558,17.4652,11.5399,1.56593> }}
union{cone{<18.5455,12.9282,1.76659> ,0.1296,<20.1453,14.3834,4.22823> ,0.12096}
sphere{<18.5455,12.9282,1.76659> ,0.1296}
texture{txttree matrix <0.672861,-0.739769,0,0.488246,0.444087,0.751267,-0.555765,-0.505498,0.659998,18.5455,12.9282,1.76659> }}
union{cone{<20.1453,14.3834,4.22823> ,0.12096,<22.2476,16.8978,5.19662> ,0.11232}
sphere{<20.1453,14.3834,4.22823> ,0.12096}
texture{txttree matrix <0.767194,-0.641415,0,0.615126,0.735751,0.283357,-0.181749,-0.21739,0.959015,20.1453,14.3834,4.22823> }}
union{cone{<22.2476,16.8978,5.19662> ,0.11232,<24.6746,19.1209,5.3539> ,0.10368}
sphere{<22.2476,16.8978,5.19662> ,0.11232}
texture{txttree matrix <0.675433,-0.737421,0,0.736581,0.674663,0.0477336,-0.0351998,-0.0322409,0.99886,22.2476,16.8978,5.19662> }}
union{cone{<24.6746,19.1209,5.3539> ,0.10368,<26.5378,21.8114,4.57077> ,0.09504}
sphere{<24.6746,19.1209,5.3539> ,0.10368}
texture{txttree matrix <0.822122,-0.569312,0,0.55368,0.799548,-0.232724,0.132493,0.191328,0.972543,24.6746,19.1209,5.3539> }}
union{cone{<26.5378,21.8114,4.57077> ,0.09504,<28.8079,24.2176,4.36082> ,0.0864}
sphere{<26.5378,21.8114,4.57077> ,0.09504}
texture{txttree matrix <0.727388,-0.686226,0,0.684848,0.725928,-0.0633387,0.0434646,0.0460718,0.997992,26.5378,21.8114,4.57077> }}
union{cone{<28.8079,24.2176,4.36082> ,0.0864,<30.7205,26.8566,4.41552> ,0.07776}
sphere{<28.8079,24.2176,4.36082> ,0.0864}
texture{txttree matrix <0.8097,-0.586845,0,0.586762,0.809586,0.0167802,-0.00984739,-0.0135869,0.999859,28.8079,24.2176,4.36082> }}
union{cone{<14.9141,7.70387,2.1315> ,0.1296,<17.7437,9.51204,2.79879> ,0.12096}
sphere{<14.9141,7.70387,2.1315> ,0.1296}
texture{txttree matrix <0.538467,-0.842647,0,0.826487,0.52814,0.194905,-0.164236,-0.10495,0.980822,14.9141,7.70387,2.1315> }}
union{cone{<17.7437,9.51204,2.79879> ,0.12096,<20.3183,10.9064,3.99487> ,0.11232}
sphere{<17.7437,9.51204,2.79879> ,0.12096}
texture{txttree matrix <0.476222,-0.879325,0,0.814024,0.440856,0.378168,-0.332533,-0.180092,0.925737,17.7437,9.51204,2.79879> }}
union{cone{<20.3183,10.9064,3.99487> ,0.11232,<22.8086,12.7753,3.7662> ,0.10368}
sphere{<20.3183,10.9064,3.99487> ,0.11232}
texture{txttree matrix <0.600258,-0.799807,0,0.797658,0.598645,-0.0732442,0.0585812,0.0439654,0.997314,20.3183,10.9064,3.99487> }}
union{cone{<22.8086,12.7753,3.7662> ,0.10368,<25.1457,15.195,3.31865> ,0.09504}
sphere{<22.8086,12.7753,3.7662> ,0.10368}
texture{txttree matrix <0.719274,-0.694727,0,0.688659,0.712992,-0.131877,0.0916183,0.0948555,0.991266,22.8086,12.7753,3.7662> }}
union{cone{<25.1457,15.195,3.31865> ,0.09504,<26.9239,17.7293,2.64177> ,0.0864}
sphere{<25.1457,15.195,3.31865> ,0.09504}
texture{txttree matrix <0.818592,-0.574375,0,0.56112,0.799701,-0.213593,0.122683,0.174846,0.976923,25.1457,15.195,3.31865> }}
union{cone{<26.9239,17.7293,2.64177> ,0.0864,<29.7042,19.3054,2.62978> ,0.07776}
sphere{<26.9239,17.7293,2.64177> ,0.0864}
texture{txttree matrix <0.493149,-0.869945,0,0.869939,0.493146,-0.00374912,0.00326153,0.00184888,0.999993,26.9239,17.7293,2.64177> }}
union{cone{<14.7249,7.58334,2.07601> ,0.1296,<17.7867,8.07576,3.04411> ,0.12096}
sphere{<14.7249,7.58334,2.07601> ,0.1296}
texture{txttree matrix <0.158788,-0.987313,0,0.942456,0.151574,0.297998,-0.294217,-0.0473186,0.954566,14.7249,7.58334,2.07601> }}
union{cone{<17.7867,8.07576,3.04411> ,0.12096,<20.0146,10.6446,2.53771> ,0.11232}
sphere{<17.7867,8.07576,3.04411> ,0.12096}
texture{txttree matrix <0.755448,-0.655209,0,0.648061,0.747207,-0.147302,0.0965133,0.111279,0.989092,17.7867,8.07576,3.04411> }}
union{cone{<20.0146,10.6446,2.53771> ,0.11232,<21.9663,13.1552,1.45191> ,0.10368}
sphere{<20.0146,10.6446,2.53771> ,0.11232}
texture{txttree matrix <0.789514,-0.613732,0,0.580808,0.74716,-0.323131,0.198316,0.255117,0.946354,20.0146,10.6446,2.53771> }}
union{cone{<21.9663,13.1552,1.45191> ,0.10368,<24.5306,14.597,0.233079> ,0.09504}
sphere{<21.9663,13.1552,1.45191> ,0.10368}
texture{txttree matrix <0.4901,-0.871666,0,0.805287,0.452777,-0.382761,0.33364,0.187591,0.923848,21.9663,13.1552,1.45191> }}
union{cone{<24.5306,14.597,0.233079> ,0.09504,<27.3904,15.8533,-1.03374> ,0.0864}
sphere{<24.5306,14.597,0.233079> ,0.09504}
texture{txttree matrix <0.402214,-0.915546,0,0.848426,0.372727,-0.37583,0.34409,0.151164,0.926689,24.5306,14.597,0.233079> }}
union{cone{<27.3904,15.8533,-1.03374> ,0.0864,<28.7583,18.0992,-2.90954> ,0.07776}
sphere{<27.3904,15.8533,-1.03374> ,0.0864}
texture{txttree matrix <0.85406,-0.520175,0,0.423478,0.695296,-0.580715,0.302073,0.495965,0.814107,27.3904,15.8533,-1.03374> }}
union{cone{<17.5395,11.6354,1.57974> ,0.1296,<18.5145,14.6669,0.401036> ,0.12096}
sphere{<17.5395,11.6354,1.57974> ,0.1296}
texture{txttree matrix <0.951978,-0.306167,0,0.287128,0.892778,-0.347137,0.106282,0.330467,0.937814,17.5395,11.6354,1.57974> }}
union{cone{<18.5145,14.6669,0.401036> ,0.12096,<19.3304,17.5736,-0.820963> ,0.11232}
sphere{<18.5145,14.6669,0.401036> ,0.12096}
texture{txttree matrix <0.962786,-0.270265,0,0.250523,0.892455,-0.375184,0.101399,0.361222,0.92695,18.5145,14.6669,0.401036> }}
union{cone{<19.3304,17.5736,-0.820963> ,0.11232,<20.9499,20.3125,-2.07794> ,0.10368}
sphere{<19.3304,17.5736,-0.820963> ,0.11232}
texture{txttree matrix <0.860787,-0.508966,0,0.473366,0.800578,-0.367422,0.187005,0.316272,0.930054,19.3304,17.5736,-0.820963> }}
union{cone{<20.9499,20.3125,-2.07794> ,0.10368,<22.5563,23.1164,-2.64604> ,0.09504}
sphere{<20.9499,20.3125,-2.07794> ,0.10368}
texture{txttree matrix <0.867682,-0.49712,0,0.489612,0.854577,-0.173143,0.0860731,0.150233,0.984897,20.9499,20.3125,-2.07794> }}
union{cone{<22.5563,23.1164,-2.64604> ,0.09504,<23.8685,26.1616,-3.41646> ,0.0864}
sphere{<22.5563,23.1164,-2.64604> ,0.09504}
texture{txttree matrix <0.91837,-0.395723,0,0.385455,0.894541,-0.226319,0.0895597,0.207845,0.974053,22.5563,23.1164,-2.64604> }}
union{cone{<23.8685,26.1616,-3.41646> ,0.0864,<24.1665,29.2317,-4.33773> ,0.07776}
sphere{<23.8685,26.1616,-3.41646> ,0.0864}
texture{txttree matrix <0.995322,-0.0966165,0,0.0925756,0.953693,-0.286182,0.0276499,0.284843,0.958175,23.8685,26.1616,-3.41646> }}
union{cone{<18.1713,12.4474,1.69709> ,0.1296,<20.0612,15.0883,1.38769> ,0.12096}
sphere{<18.1713,12.4474,1.69709> ,0.1296}
texture{txttree matrix <0.813229,-0.581944,0,0.579321,0.809563,-0.0948446,0.0551943,0.0771304,0.995492,18.1713,12.4474,1.69709> }}
union{cone{<20.0612,15.0883,1.38769> ,0.12096,<19.8558,18.1994,1.41652> ,0.11232}
sphere{<20.0612,15.0883,1.38769> ,0.12096}
texture{txttree matrix <0.997828,0.0658722,0,-0.0658694,0.997785,0.00924507,0.000608993,-0.00922499,0.999957,20.0612,15.0883,1.38769> }}
union{cone{<19.8558,18.1994,1.41652> ,0.11232,<21.2304,20.9717,0.451082> ,0.10368}
sphere{<19.8558,18.1994,1.41652> ,0.11232}
texture{txttree matrix <0.895906,-0.444245,0,0.424083,0.855246,-0.297837,0.132312,0.266834,0.954617,19.8558,18.1994,1.41652> }}
union{cone{<21.2304,20.9717,0.451082> ,0.10368,<21.2887,24.2095,-0.541057> ,0.09504}
sphere{<21.2304,20.9717,0.451082> ,0.10368}
texture{txttree matrix <0.999838,-0.0179918,0,0.0172026,0.95598,-0.292927,0.00527029,0.29288,0.956135,21.2304,20.9717,0.451082> }}
union{cone{<21.2887,24.2095,-0.541057> ,0.09504,<21.433,27.5664,-1.13791> ,0.0864}
sphere{<21.2887,24.2095,-0.541057> ,0.09504}
texture{txttree matrix <0.999077,-0.0429595,0,0.0422974,0.983678,-0.174897,0.00751351,0.174736,0.984587,21.2887,24.2095,-0.541057> }}
union{cone{<21.433,27.5664,-1.13791> ,0.0864,<21.3076,30.5646,-2.03157> ,0.07776}
sphere{<21.433,27.5664,-1.13791> ,0.0864}
texture{txttree matrix <0.999126,0.0417997,0,-0.0400609,0.957565,-0.285421,-0.0119305,0.285171,0.958402,21.433,27.5664,-1.13791> }}
union{cone{<8.58938,2.91235,1.33248> ,0.216,<10.1843,3.39276,1.68649> ,0.203657}
sphere{<8.58938,2.91235,1.33248> ,0.216}
texture{txttree matrix <0.288412,-0.957506,0,0.936589,0.282111,0.207882,-0.199048,-0.0599556,0.978154,8.58938,2.91235,1.33248> }}
union{cone{<10.1843,3.39276,1.68649> ,0.203657,<11.6316,4.52078,1.75536> ,0.191314}
sphere{<10.1843,3.39276,1.68649> ,0.203657}
texture{txttree matrix <0.614735,-0.788733,0,0.788178,0.614303,0.0375093,-0.0295848,-0.0230583,0.999296,10.1843,3.39276,1.68649> }}
union{cone{<11.6316,4.52078,1.75536> ,0.191314,<13.1666,5.23489,1.69464> ,0.178971}
sphere{<11.6316,4.52078,1.75536> ,0.191314}
texture{txttree matrix <0.421815,-0.906682,0,0.906099,0.421544,-0.0358468,0.0325016,0.0151207,0.999357,11.6316,4.52078,1.75536> }}
union{cone{<13.1666,5.23489,1.69464> ,0.178971,<14.3464,6.55267,2.02424> ,0.166629}
sphere{<13.1666,5.23489,1.69464> ,0.178971}
texture{txttree matrix <0.745029,-0.667032,0,0.655744,0.732421,0.183191,-0.122194,-0.136483,0.983077,13.1666,5.23489,1.69464> }}
union{cone{<14.3464,6.55267,2.02424> ,0.166629,<15.7958,7.32695,2.48963> ,0.154286}
sphere{<14.3464,6.55267,2.02424> ,0.166629}
texture{txttree matrix <0.471183,-0.882035,0,0.848657,0.453353,0.272493,-0.240349,-0.128394,0.962158,14.3464,6.55267,2.02424> }}
union{cone{<15.7958,7.32695,2.48963> ,0.154286,<17.2374,8.4539,2.38233> ,0.141943}
sphere{<15.7958,7.32695,2.48963> ,0.154286}
texture{txttree matrix <0.615886,-0.787835,0,0.786484,0.61483,-0.0585403,0.0461201,0.0360541,0.998285,15.7958,7.32695,2.48963> }}
union{cone{<17.2374,8.4539,2.38233> ,0.141943,<18.7264,9.11466,1.96498> ,0.1296}
sphere{<17.2374,8.4539,2.38233> ,0.141943}
texture{txttree matrix <0.405628,-0.914038,0,0.885441,0.392937,-0.248182,0.226848,0.100669,0.968713,17.2374,8.4539,2.38233> }}
union{cone{<18.7264,9.11466,1.96498> ,0.1296,<21.9971,9.15603,2.45138> ,0.12096}
sphere{<18.7264,9.11466,1.96498> ,0.1296}
texture{txttree matrix <0.0126461,-0.99992,0,0.989045,0.0125085,0.147081,-0.14707,-0.00186,0.989124,18.7264,9.11466,1.96498> }}
union{cone{<21.9971,9.15603,2.45138> ,0.12096,<25.0323,9.86262,1.83469> ,0.11232}
sphere{<21.9971,9.15603,2.45138> ,0.12096}
texture{txttree matrix <0.226739,-0.973956,0,0.955428,0.222425,-0.194124,0.189068,0.0440155,0.980977,21.9971,9.15603,2.45138> }}
union{cone{<25.0323,9.86262,1.83469> ,0.11232,<27.2715,11.5706,0.484314> ,0.10368}
sphere{<25.0323,9.86262,1.83469> ,0.11232}
texture{txttree matrix <0.606476,-0.795101,0,0.716944,0.54686,-0.432361,0.343771,0.262217,0.901701,25.0323,9.86262,1.83469> }}
union{cone{<27.2715,11.5706,0.484314> ,0.10368,<29.0563,14.2778,0.181259> ,0.09504}
sphere{<27.2715,11.5706,0.484314> ,0.10368}
texture{txttree matrix <0.834892,-0.550413,0,0.548025,0.83127,-0.0930545,0.0512184,0.0776905,0.995661,27.2715,11.5706,0.484314> }}
union{cone{<29.0563,14.2778,0.181259> ,0.09504,<30.8742,16.1655,-1.51571> ,0.0864}
sphere{<29.0563,14.2778,0.181259> ,0.09504}
texture{txttree matrix <0.720288,-0.693675,0,0.582268,0.604607,-0.54352,0.377026,0.391491,0.839396,29.0563,14.2778,0.181259> }}
union{cone{<30.8742,16.1655,-1.51571> ,0.0864,<32.8234,18.3916,-2.7484> ,0.07776}
sphere{<30.8742,16.1655,-1.51571> ,0.0864}
texture{txttree matrix <0.752352,-0.658762,0,0.608098,0.694491,-0.384576,0.253344,0.289337,0.923093,30.8742,16.1655,-1.51571> }}
union{cone{<10.6781,3.77762,1.70999> ,0.1296,<13.7594,4.581,0.913687> ,0.12096}
sphere{<10.6781,3.77762,1.70999> ,0.1296}
texture{txttree matrix <0.252288,-0.967652,0,0.938745,0.244752,-0.242598,0.23475,0.0612046,0.970127,10.6781,3.77762,1.70999> }}
union{cone{<13.7594,4.581,0.913687> ,0.12096,<15.4714,6.66186,-0.689682> ,0.11232}
sphere{<13.7594,4.581,0.913687> ,0.12096}
texture{txttree matrix <0.772243,-0.635327,0,0.54598,0.663642,-0.511356,0.324878,0.394891,0.859369,13.7594,4.581,0.913687> }}
union{cone{<15.4714,6.66186,-0.689682> ,0.11232,<17.3236,8.78737,-2.59993> ,0.10368}
sphere{<15.4714,6.66186,-0.689682> ,0.11232}
texture{txttree matrix <0.753911,-0.656977,0,0.543888,0.624136,-0.560928,0.368517,0.422889,0.827865,15.4714,6.66186,-0.689682> }}
union{cone{<17.3236,8.78737,-2.59993> ,0.10368,<20.1074,10.168,-3.89636> ,0.09504}
sphere{<17.3236,8.78737,-2.59993> ,0.10368}
texture{txttree matrix <0.444312,-0.895872,0,0.8268,0.410056,-0.38504,0.344946,0.171078,0.9229,17.3236,8.78737,-2.59993> }}
union{cone{<20.1074,10.168,-3.89636> ,0.09504,<22.7709,11.7398,-5.1464> ,0.0864}
sphere{<20.1074,10.168,-3.89636> ,0.09504}
texture{txttree matrix <0.508223,-0.861226,0,0.798469,0.471189,-0.374738,0.322734,0.19045,0.927131,20.1074,10.168,-3.89636> }}
union{cone{<22.7709,11.7398,-5.1464> ,0.0864,<24.336,13.4969,-7.46444> ,0.07776}
sphere{<22.7709,11.7398,-5.1464> ,0.0864}
texture{txttree matrix <0.746729,-0.665129,0,0.473831,0.531962,-0.701783,0.466776,0.524042,0.71239,22.7709,11.7398,-5.1464> }}
union{cone{<17.3436,8.50105,2.35255> ,0.1296,<19.7019,10.3742,1.33088> ,0.12096}
sphere{<17.3436,8.50105,2.35255> ,0.1296}
texture{txttree matrix <0.621971,-0.78304,0,0.741533,0.589001,-0.321258,0.251558,0.199813,0.946992,17.3436,8.50105,2.35255> }}
union{cone{<19.7019,10.3742,1.33088> ,0.12096,<21.4834,11.6075,-1.27133> ,0.11232}
sphere{<19.7019,10.3742,1.33088> ,0.12096}
texture{txttree matrix <0.569189,-0.822206,0,0.526111,0.364211,-0.768477,0.631847,0.437409,0.639877,19.7019,10.3742,1.33088> }}
union{cone{<21.4834,11.6075,-1.27133> ,0.11232,<22.5529,13.77,-3.31247> ,0.10368}
sphere{<21.4834,11.6075,-1.27133> ,0.11232}
texture{txttree matrix <0.896376,-0.443295,0,0.338423,0.684317,-0.645895,0.286322,0.578965,0.763426,21.4834,11.6075,-1.27133> }}
union{cone{<22.5529,13.77,-3.31247> ,0.10368,<24.1923,16.3445,-4.87994> ,0.09504}
sphere{<22.5529,13.77,-3.31247> ,0.10368}
texture{txttree matrix <0.843499,-0.537131,0,0.477804,0.750333,-0.45684,0.245383,0.385345,0.889549,22.5529,13.77,-3.31247> }}
union{cone{<24.1923,16.3445,-4.87994> ,0.09504,<25.9743,17.9572,-7.28941> ,0.0864}
sphere{<24.1923,16.3445,-4.87994> ,0.09504}
texture{txttree matrix <0.671,-0.741457,0,0.523629,0.473872,-0.707996,0.524949,0.475066,0.706216,24.1923,16.3445,-4.87994> }}
union{cone{<25.9743,17.9572,-7.28941> ,0.0864,<26.7112,20.3591,-9.48301> ,0.07776}
sphere{<25.9743,17.9572,-7.28941> ,0.0864}
texture{txttree matrix <0.956019,-0.293304,0,0.220938,0.720146,-0.657705,0.192907,0.628779,0.753276,25.9743,17.9572,-7.28941> }}
union{cone{<10.4293,3.5837,1.69815> ,0.1296,<12.0998,6.48221,1.09488> ,0.12096}
sphere{<10.4293,3.5837,1.69815> ,0.1296}
texture{txttree matrix <0.866407,-0.499339,0,0.491413,0.852655,-0.177462,0.0886139,0.153755,0.984128,10.4293,3.5837,1.69815> }}
union{cone{<12.0998,6.48221,1.09488> ,0.12096,<12.6309,9.77477,1.75321> ,0.11232}
sphere{<12.0998,6.48221,1.09488> ,0.12096}
texture{txttree matrix <0.987238,-0.159254,0,0.15624,0.968549,0.193655,-0.0308404,-0.191184,0.98107,12.0998,6.48221,1.09488> }}
union{cone{<12.6309,9.77477,1.75321> ,0.11232,<14.4123,12.3761,2.35331> ,0.10368}
sphere{<12.6309,9.77477,1.75321> ,0.11232}
texture{txttree matrix <0.825081,-0.565014,0,0.555049,0.810529,0.186983,-0.105648,-0.154276,0.982363,12.6309,9.77477,1.75321> }}
union{cone{<14.4123,12.3761,2.35331> ,0.10368,<15.2768,15.5707,1.50759> ,0.09504}
sphere{<14.4123,12.3761,2.35331> ,0.10368}
texture{txttree matrix <0.965283,-0.261205,0,0.253073,0.935231,-0.247583,0.06467,0.238988,0.968867,14.4123,12.3761,2.35331> }}
union{cone{<15.2768,15.5707,1.50759> ,0.09504,<16.327,18.6208,1.31416> ,0.0864}
sphere{<15.2768,15.5707,1.50759> ,0.09504}
texture{txttree matrix <0.945524,-0.325554,0,0.32497,0.943828,-0.0598535,0.0194855,0.0565929,0.998207,15.2768,15.5707,1.50759> }}
union{cone{<16.327,18.6208,1.31416> ,0.0864,<16.8113,21.8037,0.641848> ,0.07776}
sphere{<16.327,18.6208,1.31416> ,0.0864}
texture{txttree matrix <0.988617,-0.150455,0,0.147278,0.967742,-0.204413,0.0307549,0.202086,0.978885,16.327,18.6208,1.31416> }}
union{cone{<9.47007,3.67195,1.36345> ,0.216,<10.5154,3.46214,-0.106879> ,0.203657}
sphere{<9.47007,3.67195,1.36345> ,0.216}
texture{txttree matrix <-0.196778,-0.980448,0,0.575566,-0.115517,-0.809555,0.793727,-0.159303,0.587044,9.47007,3.67195,1.36345> }}
union{cone{<10.5154,3.46214,-0.106879> ,0.203657,<11.4492,4.34375,-1.27844> ,0.191314}
sphere{<10.5154,3.46214,-0.106879> ,0.203657}
texture{txttree matrix <0.686513,-0.727117,0,0.537164,0.507167,-0.673971,0.490056,0.46269,0.738758,10.5154,3.46214,-0.106879> }}
union{cone{<11.4492,4.34375,-1.27844> ,0.191314,<12.7602,4.26907,-2.50991> ,0.178971}
sphere{<11.4492,4.34375,-1.27844> ,0.191314}
texture{txttree matrix <-0.0568655,-0.998382,0,0.728259,-0.0414799,-0.684046,0.682939,-0.0388986,0.729439,11.4492,4.34375,-1.27844> }}
union{cone{<12.7602,4.26907,-2.50991> ,0.178971,<13.9118,5.13263,-3.46923> ,0.166629}
sphere{<12.7602,4.26907,-2.50991> ,0.178971}
texture{txttree matrix <0.599954,-0.800035,0,0.665726,0.499235,-0.554593,0.443694,0.33273,0.832122,12.7602,4.26907,-2.50991> }}
union{cone{<13.9118,5.13263,-3.46923> ,0.166629,<14.6226,6.10621,-4.70531> ,0.154286}
sphere{<13.9118,5.13263,-3.46923> ,0.166629}
texture{txttree matrix <0.807641,-0.589675,0,0.411701,0.563882,-0.715919,0.422159,0.578205,0.698183,13.9118,5.13263,-3.46923> }}
union{cone{<14.6226,6.10621,-4.70531> ,0.154286,<15.8371,6.60247,-5.88666> ,0.141943}
sphere{<14.6226,6.10621,-4.70531> ,0.154286}
texture{txttree matrix <0.378265,-0.925697,0,0.687906,0.281097,-0.669156,0.619436,0.253119,0.743122,14.6226,6.10621,-4.70531> }}
union{cone{<15.8371,6.60247,-5.88666> ,0.141943,<16.9184,7.50236,-7.07005> ,0.1296}
sphere{<15.8371,6.60247,-5.88666> ,0.141943}
texture{txttree matrix <0.639686,-0.768636,0,0.588198,0.489519,-0.643735,0.494798,0.411788,0.765249,15.8371,6.60247,-5.88666> }}
union{cone{<16.9184,7.50236,-7.07005> ,0.1296,<18.4496,9.57719,-8.84121> ,0.12096}
sphere{<16.9184,7.50236,-7.07005> ,0.1296}
texture{txttree matrix <0.804606,-0.59381,0,0.489473,0.663231,-0.566163,0.336193,0.455538,0.824293,16.9184,7.50236,-7.07005> }}
union{cone{<18.4496,9.57719,-8.84121> ,0.12096,<20.6235,11.8303,-10.1923> ,0.11232}
sphere{<18.4496,9.57719,-8.84121> ,0.12096}
texture{txttree matrix <0.719651,-0.694336,0,0.637511,0.660754,-0.396212,0.275105,0.285135,0.918159,18.4496,9.57719,-8.84121> }}
union{cone{<20.6235,11.8303,-10.1923> ,0.11232,<22.6986,14.0149,-11.6589> ,0.10368}
sphere{<20.6235,11.8303,-10.1923> ,0.11232}
texture{txttree matrix <0.725035,-0.688712,0,0.619246,0.651905,-0.437669,0.301428,0.317325,0.899136,20.6235,11.8303,-10.1923> }}
union{cone{<22.6986,14.0149,-11.6589> ,0.10368,<24.3141,16.7806,-12.5486> ,0.09504}
sphere{<22.6986,14.0149,-11.6589> ,0.10368}
texture{txttree matrix <0.86348,-0.504383,0,0.485982,0.831979,-0.267641,0.134993,0.231102,0.963519,22.6986,14.0149,-11.6589> }}
union{cone{<24.3141,16.7806,-12.5486> ,0.09504,<25.963,19.2078,-14.3386> ,0.0864}
sphere{<24.3141,16.7806,-12.5486> ,0.09504}
texture{txttree matrix <0.827181,-0.561936,0,0.479727,0.706168,-0.520759,0.292633,0.430762,0.853704,24.3141,16.7806,-12.5486> }}
union{cone{<25.963,19.2078,-14.3386> ,0.0864,<27.2266,22.0869,-15.5162> ,0.07776}
sphere{<25.963,19.2078,-14.3386> ,0.0864}
texture{txttree matrix <0.915689,-0.401888,0,0.376356,0.857516,-0.350746,0.140961,0.321174,0.936471,25.963,19.2078,-14.3386> }}
union{cone{<13.0898,4.5162,-2.78444> ,0.1296,<16.0324,5.72052,-3.52404> ,0.12096}
sphere{<13.0898,4.5162,-2.78444> ,0.1296}
texture{txttree matrix <0.378772,-0.92549,0,0.901425,0.368922,-0.226561,0.20968,0.085815,0.973997,13.0898,4.5162,-2.78444> }}
union{cone{<16.0324,5.72052,-3.52404> ,0.12096,<17.8935,6.85693,-5.77838> ,0.11232}
sphere{<16.0324,5.72052,-3.52404> ,0.12096}
texture{txttree matrix <0.521141,-0.85347,0,0.593379,0.362325,-0.718764,0.613444,0.374578,0.695254,16.0324,5.72052,-3.52404> }}
union{cone{<17.8935,6.85693,-5.77838> ,0.11232,<20.0238,8.18311,-7.90528> ,0.10368}
sphere{<17.8935,6.85693,-5.77838> ,0.11232}
texture{txttree matrix <0.528494,-0.848937,0,0.647608,0.40316,-0.64658,0.548905,0.341714,0.762846,17.8935,6.85693,-5.77838> }}
union{cone{<20.0238,8.18311,-7.90528> ,0.10368,<22.1521,9.92147,-9.69935> ,0.09504}
sphere{<20.0238,8.18311,-7.90528> ,0.10368}
texture{txttree matrix <0.632584,-0.774492,0,0.648521,0.529695,-0.546666,0.423388,0.345812,0.837351,20.0238,8.18311,-7.90528> }}
union{cone{<22.1521,9.92147,-9.69935> ,0.09504,<23.8349,12.2657,-11.2825> ,0.0864}
sphere{<22.1521,9.92147,-9.69935> ,0.09504}
texture{txttree matrix <0.812369,-0.583144,0,0.51126,0.712229,-0.480982,0.280482,0.390735,0.876731,22.1521,9.92147,-9.69935> }}
union{cone{<23.8349,12.2657,-11.2825> ,0.0864,<25.6386,14.3828,-12.8413> ,0.07776}
sphere{<23.8349,12.2657,-11.2825> ,0.0864}
texture{txttree matrix <0.761201,-0.648516,0,0.565723,0.664022,-0.48891,0.317066,0.372159,0.872334,23.8349,12.2657,-11.2825> }}
union{cone{<14.4887,5.92283,-4.47249> ,0.1296,<15.9427,7.03189,-7.25819> ,0.12096}
sphere{<14.4887,5.92283,-4.47249> ,0.1296}
texture{txttree matrix <0.606491,-0.79509,0,0.436318,0.332822,-0.835976,0.664676,0.507012,0.548766,14.4887,5.92283,-4.47249> }}
union{cone{<15.9427,7.03189,-7.25819> ,0.12096,<16.5098,7.8205,-10.5214> ,0.11232}
sphere{<15.9427,7.03189,-7.25819> ,0.12096}
texture{txttree matrix <0.811879,-0.583826,0,0.166563,0.231625,-0.95844,0.559562,0.778137,0.285295,15.9427,7.03189,-7.25819> }}
union{cone{<16.5098,7.8205,-10.5214> ,0.11232,<16.0619,9.63505,-13.231> ,0.10368}
sphere{<16.5098,7.8205,-10.5214> ,0.11232}
texture{txttree matrix <0.970867,0.239621,0,-0.136057,0.551258,-0.823166,-0.197248,0.799185,0.5678,16.5098,7.8205,-10.5214> }}
union{cone{<16.0619,9.63505,-13.231> ,0.10368,<17.1416,11.0517,-16.1515> ,0.09504}
sphere{<16.0619,9.63505,-13.231> ,0.10368}
texture{txttree matrix <0.795318,-0.606193,0,0.315638,0.414113,-0.853747,0.517535,0.679,0.520688,16.0619,9.63505,-13.231> }}
union{cone{<17.1416,11.0517,-16.1515> ,0.09504,<17.7285,12.5289,-18.9683> ,0.0864}
sphere{<17.1416,11.0517,-16.1515> ,0.09504}
texture{txttree matrix <0.929349,-0.369203,0,0.181451,0.456742,-0.870897,0.321538,0.809367,0.491465,17.1416,11.0517,-16.1515> }}
union{cone{<17.7285,12.5289,-18.9683> ,0.0864,<17.6421,14.2371,-21.6097> ,0.07776}
sphere{<17.7285,12.5289,-18.9683> ,0.0864}
texture{txttree matrix <0.998723,0.0505279,0,-0.0274626,0.542819,-0.8394,-0.0424131,0.838328,0.543513,17.7285,12.5289,-18.9683> }}
union{cone{<11.8251,4.32234,-1.63151> ,0.1296,<13.6037,5.74535,-3.95381> ,0.12096}
sphere{<11.8251,4.32234,-1.63151> ,0.1296}
texture{txttree matrix <0.624716,-0.780852,0,0.546786,0.437453,-0.713905,0.557454,0.445988,0.700243,11.8251,4.32234,-1.63151> }}
union{cone{<13.6037,5.74535,-3.95381> ,0.12096,<16.4425,7.06174,-5.19507> ,0.11232}
sphere{<13.6037,5.74535,-3.95381> ,0.12096}
texture{txttree matrix <0.420689,-0.907205,0,0.84328,0.391046,-0.368729,0.334513,0.15512,0.929537,13.6037,5.74535,-3.95381> }}
union{cone{<16.4425,7.06174,-5.19507> ,0.11232,<18.4893,8.73542,-7.3865> ,0.10368}
sphere{<16.4425,7.06174,-5.19507> ,0.11232}
texture{txttree matrix <0.633017,-0.774138,0,0.596025,0.487373,-0.638139,0.494008,0.403953,0.769921,16.4425,7.06174,-5.19507> }}
union{cone{<18.4893,8.73542,-7.3865> ,0.10368,<20.8617,10.6113,-8.99681> ,0.09504}
sphere{<18.4893,8.73542,-7.3865> ,0.10368}
texture{txttree matrix <0.620247,-0.784407,0,0.692381,0.54748,-0.469973,0.36865,0.291499,0.882681,18.4893,8.73542,-7.3865> }}
union{cone{<20.8617,10.6113,-8.99681> ,0.09504,<22.8967,11.4084,-11.5659> ,0.0864}
sphere{<20.8617,10.6113,-8.99681> ,0.09504}
texture{txttree matrix <0.364697,-0.931126,0,0.603333,0.236309,-0.761674,0.709214,0.27778,0.647961,20.8617,10.6113,-8.99681> }}
union{cone{<22.8967,11.4084,-11.5659> ,0.0864,<24.0104,13.5738,-13.5502> ,0.07776}
sphere{<22.8967,11.4084,-11.5659> ,0.0864}
texture{txttree matrix <0.889281,-0.457362,0,0.35455,0.689377,-0.631708,0.288919,0.561765,0.775207,22.8967,11.4084,-11.5659> }}
union{cone{<5.95243,1.87683,0.82619> ,0.216,<7.02138,2.92656,1.69949> ,0.203657}
sphere{<5.95243,1.87683,0.82619> ,0.216}
texture{txttree matrix <0.70066,-0.713495,0,0.616417,0.605329,0.503593,-0.359311,-0.352848,0.863941,5.95243,1.87683,0.82619> }}
union{cone{<7.02138,2.92656,1.69949> ,0.203657,<8.15379,4.11801,2.18579> ,0.191314}
sphere{<7.02138,2.92656,1.69949> ,0.203657}
texture{txttree matrix <0.724838,-0.68892,0,0.660615,0.695058,0.283694,-0.195442,-0.205632,0.958915,7.02138,2.92656,1.69949> }}
union{cone{<8.15379,4.11801,2.18579> ,0.191314,<9.23793,5.503,2.3815> ,0.178971}
sphere{<8.15379,4.11801,2.18579> ,0.191314}
texture{txttree matrix <0.787442,-0.616389,0,0.612608,0.782612,0.11059,-0.0681665,-0.0870832,0.993866,8.15379,4.11801,2.18579> }}
union{cone{<9.23793,5.503,2.3815> ,0.178971,<10.661,6.64292,2.5919> ,0.166629}
sphere{<9.23793,5.503,2.3815> ,0.178971}
texture{txttree matrix <0.62519,-0.780472,0,0.775328,0.621069,0.114631,-0.0894663,-0.0716662,0.993408,9.23793,5.503,2.3815> }}
union{cone{<10.661,6.64292,2.5919> ,0.166629,<11.2882,8.18114,3.37261> ,0.154286}
sphere{<10.661,6.64292,2.5919> ,0.166629}
texture{txttree matrix <0.925988,-0.377552,0,0.341697,0.838049,0.425343,-0.160589,-0.393862,0.905032,10.661,6.64292,2.5919> }}
union{cone{<11.2882,8.18114,3.37261> ,0.154286,<12.2995,9.49413,3.83762> ,0.141943}
sphere{<11.2882,8.18114,3.37261> ,0.154286}
texture{txttree matrix <0.792222,-0.610232,0,0.587544,0.762767,0.270145,-0.164851,-0.214015,0.96282,11.2882,8.18114,3.37261> }}
union{cone{<12.2995,9.49413,3.83762> ,0.141943,<12.991,11.1052,4.04885> ,0.1296}
sphere{<12.2995,9.49413,3.83762> ,0.141943}
texture{txttree matrix <0.918944,-0.394388,0,0.391556,0.912346,0.119616,-0.047175,-0.10992,0.99282,12.2995,9.49413,3.83762> }}
union{cone{<12.991,11.1052,4.04885> ,0.1296,<13.7472,14.319,4.40571> ,0.12096}
sphere{<12.991,11.1052,4.04885> ,0.1296}
texture{txttree matrix <0.973413,-0.229058,0,0.227731,0.967776,0.107463,-0.0246152,-0.104606,0.994209,12.991,11.1052,4.04885> }}
union{cone{<13.7472,14.319,4.40571> ,0.12096,<14.2053,17.0147,5.91215> ,0.11232}
sphere{<13.7472,14.319,4.40571> ,0.12096}
texture{txttree matrix <0.985865,-0.16754,0,0.146743,0.86349,0.482546,-0.0808457,-0.475725,0.875871,13.7472,14.319,4.40571> }}
union{cone{<14.2053,17.0147,5.91215> ,0.11232,<15.3294,19.9783,7.01831> ,0.10368}
sphere{<14.2053,17.0147,5.91215> ,0.11232}
texture{txttree matrix <0.935001,-0.354645,0,0.33484,0.882787,0.329499,-0.116855,-0.308082,0.944156,14.2053,17.0147,5.91215> }}
union{cone{<15.3294,19.9783,7.01831> ,0.10368,<16.7562,22.9869,7.64463> ,0.09504}
sphere{<15.3294,19.9783,7.01831> ,0.10368}
texture{txttree matrix <0.903547,-0.42849,0,0.421105,0.887974,0.184857,-0.0792095,-0.167027,0.982765,15.3294,19.9783,7.01831> }}
union{cone{<16.7562,22.9869,7.64463> ,0.09504,<17.939,25.8438,6.90851> ,0.0864}
sphere{<16.7562,22.9869,7.64463> ,0.09504}
texture{txttree matrix <0.92395,-0.382513,0,0.372114,0.898831,-0.231591,0.0885867,0.213979,0.972813,16.7562,22.9869,7.64463> }}
union{cone{<17.939,25.8438,6.90851> ,0.0864,<18.1237,29.0214,6.47668> ,0.07776}
sphere{<17.939,25.8438,6.90851> ,0.0864}
texture{txttree matrix <0.998314,-0.0580504,0,0.0575234,0.989251,-0.13444,0.00780427,0.134213,0.990922,17.939,25.8438,6.90851> }}
union{cone{<10.8277,7.05193,2.79949> ,0.1296,<12.2514,9.20922,4.78983> ,0.12096}
sphere{<10.8277,7.05193,2.79949> ,0.1296}
texture{txttree matrix <0.834643,-0.550791,0,0.436397,0.661296,0.610119,-0.336048,-0.509232,0.79231,10.8277,7.05193,2.79949> }}
union{cone{<12.2514,9.20922,4.78983> ,0.12096,<14.7943,10.35,6.71089> ,0.11232}
sphere{<12.2514,9.20922,4.78983> ,0.12096}
texture{txttree matrix <0.409299,-0.9124,0,0.751233,0.337,0.567521,-0.517806,-0.232285,0.823359,12.2514,9.20922,4.78983> }}
union{cone{<14.7943,10.35,6.71089> ,0.11232,<16.1081,12.6682,8.38296> ,0.10368}
sphere{<14.7943,10.35,6.71089> ,0.11232}
texture{txttree matrix <0.870002,-0.493049,0,0.417632,0.736925,0.53153,-0.262071,-0.462432,0.847039,14.7943,10.35,6.71089> }}
union{cone{<16.1081,12.6682,8.38296> ,0.10368,<17.3303,15.7673,8.01892> ,0.09504}
sphere{<16.1081,12.6682,8.38296> ,0.10368}
texture{txttree matrix <0.930268,-0.366882,0,0.364711,0.924763,-0.108629,0.0398539,0.101054,0.994082,16.1081,12.6682,8.38296> }}
union{cone{<17.3303,15.7673,8.01892> ,0.09504,<19.9163,17.8677,7.90534> ,0.0864}
sphere{<17.3303,15.7673,8.01892> ,0.09504}
texture{txttree matrix <0.630464,-0.776218,0,0.775768,0.630098,-0.034073,0.0264481,0.0214818,0.999419,17.3303,15.7673,8.01892> }}
union{cone{<19.9163,17.8677,7.90534> ,0.0864,<21.5186,20.8404,8.43529> ,0.07776}
sphere{<19.9163,17.8677,7.90534> ,0.0864}
texture{txttree matrix <0.880272,-0.474469,0,0.468732,0.86963,0.155031,-0.0735573,-0.136469,0.98791,19.9163,17.8677,7.90534> }}
union{cone{<8.86743,5.02969,2.31462> ,0.1296,<11.0641,6.94185,0.694164> ,0.12096}
sphere{<8.86743,5.02969,2.31462> ,0.1296}
texture{txttree matrix <0.65658,-0.754256,0,0.659097,0.573745,-0.486218,0.366733,0.319241,0.873838,8.86743,5.02969,2.31462> }}
union{cone{<11.0641,6.94185,0.694164> ,0.12096,<13.6614,8.24488,-0.964809> ,0.11232}
sphere{<11.0641,6.94185,0.694164> ,0.12096}
texture{txttree matrix <0.448421,-0.893822,0,0.776228,0.389425,-0.4958,0.443157,0.222327,0.868437,11.0641,6.94185,0.694164> }}
union{cone{<13.6614,8.24488,-0.964809> ,0.11232,<15.3022,10.8906,-1.46082> ,0.10368}
sphere{<13.6614,8.24488,-0.964809> ,0.11232}
texture{txttree matrix <0.849821,-0.527071,0,0.520506,0.839237,-0.157339,0.0829287,0.13371,0.987545,13.6614,8.24488,-0.964809> }}
union{cone{<15.3022,10.8906,-1.46082> ,0.10368,<17.15,13.3912,-2.76028> ,0.09504}
sphere{<15.3022,10.8906,-1.46082> ,0.10368}
texture{txttree matrix <0.804258,-0.594281,0,0.54832,0.742057,-0.385612,0.229162,0.310131,0.922661,15.3022,10.8906,-1.46082> }}
union{cone{<17.15,13.3912,-2.76028> ,0.09504,<18.9849,15.8125,-3.50243> ,0.0864}
sphere{<17.15,13.3912,-2.76028> ,0.09504}
texture{txttree matrix <0.797004,-0.603974,0,0.586721,0.774236,-0.237312,0.143331,0.189139,0.971433,17.15,13.3912,-2.76028> }}
union{cone{<18.9849,15.8125,-3.50243> ,0.0864,<20.4982,18.3077,-4.81999> ,0.07776}
sphere{<18.9849,15.8125,-3.50243> ,0.0864}
texture{txttree matrix <0.855026,-0.518585,0,0.472646,0.779283,-0.41149,0.213393,0.351835,0.911414,18.9849,15.8125,-3.50243> }}
union{cone{<11.9594,9.05264,3.68126> ,0.1296,<12.4435,12.4151,4.22042> ,0.12096}
sphere{<11.9594,9.05264,3.68126> ,0.1296}
texture{txttree matrix <0.989795,-0.142498,0,0.140737,0.97756,0.15675,-0.0223366,-0.15515,0.987638,11.9594,9.05264,3.68126> }}
union{cone{<12.4435,12.4151,4.22042> ,0.12096,<12.5235,15.6004,3.29994> ,0.11232}
sphere{<12.4435,12.4151,4.22042> ,0.12096}
texture{txttree matrix <0.999685,-0.0250973,0,0.0241114,0.960413,-0.277534,0.00696535,0.277446,0.960716,12.4435,12.4151,4.22042> }}
union{cone{<12.5235,15.6004,3.29994> ,0.11232,<14.2289,18.196,2.75707> ,0.10368}
sphere{<12.5235,15.6004,3.29994> ,0.11232}
texture{txttree matrix <0.835736,-0.549131,0,0.54093,0.823254,-0.172186,0.0945528,0.143902,0.985064,12.5235,15.6004,3.29994> }}
union{cone{<14.2289,18.196,2.75707> ,0.10368,<15.1321,21.2666,1.9237> ,0.09504}
sphere{<14.2289,18.196,2.75707> ,0.10368}
texture{txttree matrix <0.959362,-0.282179,0,0.273075,0.928408,-0.251969,0.0711005,0.24173,0.967735,14.2289,18.196,2.75707> }}
union{cone{<15.1321,21.2666,1.9237> ,0.09504,<16.5763,24.1641,1.0891> ,0.0864}
sphere{<15.1321,21.2666,1.9237> ,0.09504}
texture{txttree matrix <0.894985,-0.446097,0,0.431974,0.86665,-0.249633,0.111361,0.223418,0.96834,15.1321,21.2666,1.9237> }}
union{cone{<16.5763,24.1641,1.0891> ,0.0864,<16.9205,26.8641,-0.802797> ,0.07776}
sphere{<16.5763,24.1641,1.0891> ,0.0864}
texture{txttree matrix <0.991972,-0.126461,0,0.10384,0.814533,-0.570748,0.0721774,0.566166,0.821125,16.5763,24.1641,1.0891> }}
union{cone{<10.3997,6.43361,2.55327> ,0.1296,<11.9257,9.23122,2.57014> ,0.12096}
sphere{<10.3997,6.43361,2.55327> ,0.1296}
texture{txttree matrix <0.877891,-0.47886,0,0.478853,0.877879,0.00529571,-0.0025359,-0.00464906,0.999986,10.3997,6.43361,2.55327> }}
union{cone{<11.9257,9.23122,2.57014> ,0.12096,<14.1398,11.4986,2.19696> ,0.11232}
sphere{<11.9257,9.23122,2.57014> ,0.12096}
texture{txttree matrix <0.715456,-0.698658,0,0.693863,0.710547,-0.116948,0.0817068,0.0836713,0.993138,11.9257,9.23122,2.57014> }}
union{cone{<14.1398,11.4986,2.19696> ,0.11232,<15.0563,14.5598,2.56362> ,0.10368}
sphere{<14.1398,11.4986,2.19696> ,0.11232}
texture{txttree matrix <0.957987,-0.28681,0,0.284941,0.951743,0.113992,-0.0326942,-0.109203,0.993482,14.1398,11.4986,2.19696> }}
union{cone{<15.0563,14.5598,2.56362> ,0.10368,<16.018,17.6221,3.03505> ,0.09504}
sphere{<15.0563,14.5598,2.56362> ,0.10368}
texture{txttree matrix <0.954054,-0.299633,0,0.296453,0.943927,0.145316,-0.0435417,-0.13864,0.989385,15.0563,14.5598,2.56362> }}
union{cone{<16.018,17.6221,3.03505> ,0.09504,<16.6794,20.857,2.07459> ,0.0864}
sphere{<16.018,17.6221,3.03505> ,0.09504}
texture{txttree matrix <0.979735,-0.200299,0,0.192328,0.940742,-0.279309,0.0559455,0.273649,0.960201,16.018,17.6221,3.03505> }}
union{cone{<16.6794,20.857,2.07459> ,0.0864,<18.0181,23.6112,0.57944> ,0.07776}
sphere{<16.6794,20.857,2.07459> ,0.0864}
texture{txttree matrix <0.899386,-0.437155,0,0.392834,0.808203,-0.438736,0.191795,0.394593,0.898616,16.6794,20.857,2.07459> }}
union{cone{<2.01785,1.4768,0.430027> ,0.36,<2.43546,0.585817,0.333049> ,0.342}
sphere{<2.01785,1.4768,0.430027> ,0.36}
texture{txttree matrix <-0.905476,-0.424398,0,0.422352,-0.90111,-0.098081,0.0416254,-0.08881,0.995178,2.01785,1.4768,0.430027> }}
union{cone{<2.43546,0.585817,0.333049> ,0.342,<3.20588,0.547536,-0.00755732> ,0.324}
sphere{<2.43546,0.585817,0.333049> ,0.342}
texture{txttree matrix <-0.0496277,-0.998768,0,0.913662,-0.0453989,-0.403932,0.403434,-0.0200462,0.914789,2.43546,0.585817,0.333049> }}
union{cone{<3.20588,0.547536,-0.00755732> ,0.324,<4.08745,0.601476,-0.339145> ,0.306}
sphere{<3.20588,0.547536,-0.00755732> ,0.324}
texture{txttree matrix <0.0610726,-0.998133,0,0.934448,0.0571759,-0.351478,0.350822,0.0214657,0.936196,3.20588,0.547536,-0.00755732> }}
union{cone{<4.08745,0.601476,-0.339145> ,0.306,<4.6679,0.796037,-1.03488> ,0.288}
sphere{<4.08745,0.601476,-0.339145> ,0.306}
texture{txttree matrix <0.31781,-0.948155,0,0.626348,0.209944,-0.750741,0.711818,0.238593,0.660597,4.08745,0.601476,-0.339145> }}
union{cone{<4.6679,0.796037,-1.03488> ,0.288,<5.35757,0.673701,-1.19359> ,0.27}
sphere{<4.6679,0.796037,-1.03488> ,0.288}
texture{txttree matrix <-0.174656,-0.984629,0,0.960286,-0.170338,-0.220989,0.217592,-0.0385972,0.975276,4.6679,0.796037,-1.03488> }}
union{cone{<5.35757,0.673701,-1.19359> ,0.27,<6.17898,0.657435,-1.43792> ,0.252}
sphere{<5.35757,0.673701,-1.19359> ,0.27}
texture{txttree matrix <-0.0197981,-0.999804,0,0.958323,-0.0189767,-0.285057,0.285001,-0.00564358,0.958511,5.35757,0.673701,-1.19359> }}
union{cone{<6.17898,0.657435,-1.43792> ,0.252,<6.70961,0.761735,-2.19929> ,0.234}
sphere{<6.17898,0.657435,-1.43792> ,0.252}
texture{txttree matrix <0.192865,-0.981225,0,0.568205,0.111684,-0.815273,0.799966,0.157238,0.579077,6.17898,0.657435,-1.43792> }}
union{cone{<6.70961,0.761735,-2.19929> ,0.234,<7.55096,0.935693,-2.69642> ,0.216}
sphere{<6.70961,0.761735,-2.19929> ,0.234}
texture{txttree matrix <0.202479,-0.979287,0,0.847613,0.175254,-0.500838,0.490464,0.101409,0.865541,6.70961,0.761735,-2.19929> }}
union{cone{<7.55096,0.935693,-2.69642> ,0.216,<8.98792,1.85092,-2.45962> ,0.203657}
sphere{<7.55096,0.935693,-2.69642> ,0.216}
texture{txttree matrix <0.53721,-0.843448,0,0.835417,0.532095,0.137668,-0.116116,-0.0739569,0.990478,7.55096,0.935693,-2.69642> }}
union{cone{<8.98792,1.85092,-2.45962> ,0.203657,<10.7863,2.00297,-2.23405> ,0.191314}
sphere{<8.98792,1.85092,-2.45962> ,0.203657}
texture{txttree matrix <0.0842416,-0.996445,0,0.988753,0.0835913,0.124017,-0.123576,-0.0104474,0.99228,8.98792,1.85092,-2.45962> }}
union{cone{<10.7863,2.00297,-2.23405> ,0.191314,<12.5792,2.15038,-2.53964> ,0.178971}
sphere{<10.7863,2.00297,-2.23405> ,0.191314}
texture{txttree matrix <0.0819451,-0.996637,0,0.982561,0.0807878,-0.167472,0.166909,0.0137235,0.985877,10.7863,2.00297,-2.23405> }}
union{cone{<12.5792,2.15038,-2.53964> ,0.178971,<14.0507,3.03948,-2.72826> ,0.166629}
sphere{<12.5792,2.15038,-2.53964> ,0.178971}
texture{txttree matrix <0.517154,-0.855893,0,0.850788,0.514069,-0.109056,0.0933401,0.0563986,0.994036,12.5792,2.15038,-2.53964> }}
union{cone{<14.0507,3.03948,-2.72826> ,0.166629,<15.2971,3.67098,-3.77627> ,0.154286}
sphere{<14.0507,3.03948,-2.72826> ,0.166629}
texture{txttree matrix <0.451963,-0.892036,0,0.713609,0.361561,-0.60003,0.535249,0.271192,0.799978,14.0507,3.03948,-2.72826> }}
union{cone{<15.2971,3.67098,-3.77627> ,0.154286,<16.6615,4.36735,-4.76127> ,0.141943}
sphere{<15.2971,3.67098,-3.77627> ,0.154286}
texture{txttree matrix <0.454583,-0.890704,0,0.749194,0.382361,-0.54084,0.481729,0.245857,0.841125,15.2971,3.67098,-3.77627> }}
union{cone{<16.6615,4.36735,-4.76127> ,0.141943,<17.5941,5.52007,-5.66363> ,0.1296}
sphere{<16.6615,4.36735,-4.76127> ,0.141943}
texture{txttree matrix <0.777447,-0.628948,0,0.53727,0.664123,-0.519886,0.326981,0.404184,0.854236,16.6615,4.36735,-4.76127> }}
union{cone{<17.5941,5.52007,-5.66363> ,0.1296,<18.7443,8.52262,-5.31076> ,0.12096}
sphere{<17.5941,5.52007,-5.66363> ,0.1296}
texture{txttree matrix <0.933821,-0.35774,0,0.355605,0.928248,0.109092,-0.0390264,-0.101872,0.994032,17.5941,5.52007,-5.66363> }}
union{cone{<18.7443,8.52262,-5.31076> ,0.12096,<21.236,10.3158,-5.95138> ,0.11232}
sphere{<18.7443,8.52262,-5.31076> ,0.12096}
texture{txttree matrix <0.584128,-0.811661,0,0.794545,0.57181,-0.204281,0.165807,0.119326,0.978912,18.7443,8.52262,-5.31076> }}
union{cone{<21.236,10.3158,-5.95138> ,0.11232,<21.9906,13.3715,-6.34651> ,0.10368}
sphere{<21.236,10.3158,-5.95138> ,0.11232}
texture{txttree matrix <0.970833,-0.239759,0,0.237891,0.963271,-0.124562,0.0298649,0.120929,0.992212,21.236,10.3158,-5.95138> }}
union{cone{<21.9906,13.3715,-6.34651> ,0.10368,<22.6407,16.3377,-7.29842> ,0.09504}
sphere{<21.9906,13.3715,-6.34651> ,0.10368}
texture{txttree matrix <0.976816,-0.21408,0,0.204279,0.932094,-0.299118,0.0640353,0.292184,0.954216,21.9906,13.3715,-6.34651> }}
union{cone{<22.6407,16.3377,-7.29842> ,0.09504,<23.3094,18.9629,-8.97011> ,0.0864}
sphere{<22.6407,16.3377,-7.29842> ,0.09504}
texture{txttree matrix <0.969058,-0.246833,0,0.210058,0.824682,-0.525143,0.129622,0.508894,0.851014,22.6407,16.3377,-7.29842> }}
union{cone{<23.3094,18.9629,-8.97011> ,0.0864,<24.7743,21.6004,-10.4234> ,0.07776}
sphere{<23.3094,18.9629,-8.97011> ,0.0864}
texture{txttree matrix <0.874209,-0.485549,0,0.437441,0.787592,-0.433986,0.210722,0.379394,0.90092,23.3094,18.9629,-8.97011> }}
union{cone{<14.7587,3.39821,-3.3236> ,0.1296,<17.0303,3.98935,-5.69542> ,0.12096}
sphere{<14.7587,3.39821,-3.3236> ,0.1296}
texture{txttree matrix <0.251845,-0.967768,0,0.680742,0.177151,-0.71078,0.687869,0.179006,0.703415,14.7587,3.39821,-3.3236> }}
union{cone{<17.0303,3.98935,-5.69542> ,0.12096,<19.5779,4.56564,-7.74762> ,0.11232}
sphere{<17.0303,3.98935,-5.69542> ,0.12096}
texture{txttree matrix <0.220633,-0.975357,0,0.766951,0.17349,-0.617808,0.602583,0.136309,0.786329,17.0303,3.98935,-5.69542> }}
union{cone{<19.5779,4.56564,-7.74762> ,0.11232,<21.8931,5.22825,-10.1712> ,0.10368}
sphere{<19.5779,4.56564,-7.74762> ,0.11232}
texture{txttree matrix <0.275155,-0.9614,0,0.677628,0.193938,-0.709372,0.68199,0.195187,0.704834,19.5779,4.56564,-7.74762> }}
union{cone{<21.8931,5.22825,-10.1712> ,0.10368,<23.62,6.25518,-12.9506> ,0.09504}
sphere{<21.8931,5.22825,-10.1712> ,0.10368}
texture{txttree matrix <0.511123,-0.859508,0,0.503535,0.299437,-0.810425,0.696567,0.414227,0.585842,21.8931,5.22825,-10.1712> }}
union{cone{<23.62,6.25518,-12.9506> ,0.09504,<25.3903,7.68317,-15.4966> ,0.0864}
sphere{<23.62,6.25518,-12.9506> ,0.09504}
texture{txttree matrix <0.62783,-0.778351,0,0.518556,0.418275,-0.745752,0.580456,0.468205,0.666224,23.62,6.25518,-12.9506> }}
union{cone{<25.3903,7.68317,-15.4966> ,0.0864,<26.9943,9.15643,-17.8178> ,0.07776}
sphere{<25.3903,7.68317,-15.4966> ,0.0864}
texture{txttree matrix <0.67647,-0.73647,0,0.503914,0.46286,-0.729268,0.537084,0.493328,0.684228,25.3903,7.68317,-15.4966> }}
union{cone{<13.157,2.49948,-2.6137> ,0.1296,<15.2855,3.78135,-4.65763> ,0.12096}
sphere{<13.157,2.49948,-2.6137> ,0.1296}
texture{txttree matrix <0.5159,-0.856649,0,0.661576,0.398421,-0.635278,0.54421,0.32774,0.772283,13.157,2.49948,-2.6137> }}
union{cone{<15.2855,3.78135,-4.65763> ,0.12096,<18.2624,4.45387,-5.69697> ,0.11232}
sphere{<15.2855,3.78135,-4.65763> ,0.12096}
texture{txttree matrix <0.220362,-0.975418,0,0.923342,0.208598,-0.322375,0.314451,0.0710394,0.946612,15.2855,3.78135,-4.65763> }}
union{cone{<18.2624,4.45387,-5.69697> ,0.11232,<20.3557,6.81022,-6.97793> ,0.10368}
sphere{<18.2624,4.45387,-5.69697> ,0.11232}
texture{txttree matrix <0.747597,-0.664153,0,0.615282,0.692586,-0.376502,0.250055,0.281472,0.926416,18.2624,4.45387,-5.69697> }}
union{cone{<20.3557,6.81022,-6.97793> ,0.10368,<22.746,8.90092,-8.03891> ,0.09504}
sphere{<20.3557,6.81022,-6.97793> ,0.10368}
texture{txttree matrix <0.658368,-0.752696,0,0.713904,0.624438,-0.316888,0.23852,0.208629,0.948463,20.3557,6.81022,-6.97793> }}
union{cone{<22.746,8.90092,-8.03891> ,0.09504,<25.0133,10.6949,-9.41741> ,0.0864}
sphere{<22.746,8.90092,-8.03891> ,0.09504}
texture{txttree matrix <0.620502,-0.784205,0,0.707862,0.560095,-0.430378,0.337504,0.26705,0.902649,22.746,8.90092,-8.03891> }}
union{cone{<25.0133,10.6949,-9.41741> ,0.0864,<26.1981,12.6825,-11.7589> ,0.07776}
sphere{<25.0133,10.6949,-9.41741> ,0.0864}
texture{txttree matrix <0.858966,-0.512033,0,0.359914,0.603777,-0.711278,0.364198,0.610963,0.702911,25.0133,10.6949,-9.41741> }}
union{cone{<13.1923,2.52082,-2.61823> ,0.1296,<15.0515,4.82467,-3.96305> ,0.12096}
sphere{<13.1923,2.52082,-2.61823> ,0.1296}
texture{txttree matrix <0.778202,-0.628015,0,0.571785,0.708525,-0.413587,0.259739,0.321854,0.910465,13.1923,2.52082,-2.61823> }}
union{cone{<15.0515,4.82467,-3.96305> ,0.12096,<17.3262,7.14256,-4.90946> ,0.11232}
sphere{<15.0515,4.82467,-3.96305> ,0.12096}
texture{txttree matrix <0.713732,-0.700419,0,0.672446,0.685228,-0.279782,0.195964,0.199689,0.960064,15.0515,4.82467,-3.96305> }}
union{cone{<17.3262,7.14256,-4.90946> ,0.11232,<18.2841,9.93974,-6.32236> ,0.10368}
sphere{<17.3262,7.14256,-4.90946> ,0.11232}
texture{txttree matrix <0.946065,-0.323977,0,0.292315,0.853606,-0.431171,0.13969,0.407916,0.90227,17.3262,7.14256,-4.90946> }}
union{cone{<18.2841,9.93974,-6.32236> ,0.10368,<19.0303,13.0889,-7.1832> ,0.09504}
sphere{<18.2841,9.93974,-6.32236> ,0.10368}
texture{txttree matrix <0.973052,-0.230588,0,0.22284,0.940356,-0.257047,0.059272,0.25012,0.966399,18.2841,9.93974,-6.32236> }}
union{cone{<19.0303,13.0889,-7.1832> ,0.09504,<20.4968,15.883,-7.5531> ,0.0864}
sphere{<19.0303,13.0889,-7.1832> ,0.09504}
texture{txttree matrix <0.885453,-0.46473,0,0.461569,0.879431,-0.116425,0.0541061,0.103089,0.9932,19.0303,13.0889,-7.1832> }}
union{cone{<20.4968,15.883,-7.5531> ,0.0864,<22.5406,18.3208,-8.55753> ,0.07776}
sphere{<20.4968,15.883,-7.5531> ,0.0864}
texture{txttree matrix <0.766308,-0.642473,0,0.61266,0.730748,-0.301089,0.193441,0.230727,0.953596,20.4968,15.883,-7.5531> }}
union{cone{<2.8489,0.565274,0.150265> ,0.216,<3.97399,0.5,-0.628596> ,0.203657}
sphere{<2.8489,0.565274,0.150265> ,0.216}
texture{txttree matrix <-0.0579192,-0.998321,0,0.821274,-0.0476475,-0.568541,0.567586,-0.0329294,0.822655,2.8489,0.565274,0.150265> }}
union{cone{<3.97399,0.5,-0.628596> ,0.203657,<5.27946,0.635726,-1.14151> ,0.191314}
sphere{<3.97399,0.5,-0.628596> ,0.203657}
texture{txttree matrix <0.103409,-0.994639,0,0.926411,0.0963159,-0.363986,0.362034,0.0376395,0.931404,3.97399,0.5,-0.628596> }}
union{cone{<5.27946,0.635726,-1.14151> ,0.191314,<6.38105,0.573889,-2.07325> ,0.178971}
sphere{<5.27946,0.635726,-1.14151> ,0.191314}
texture{txttree matrix <-0.056046,-0.998428,0,0.762814,-0.04282,-0.645199,0.644185,-0.0361608,0.764015,5.27946,0.635726,-1.14151> }}
union{cone{<6.38105,0.573889,-2.07325> ,0.178971,<7.9115,0.623868,-3.09782> ,0.166629}
sphere{<6.38105,0.573889,-2.07325> ,0.178971}
texture{txttree matrix <0.0326391,-0.999467,0,0.830675,0.027127,-0.556097,0.555801,0.0181505,0.831117,6.38105,0.573889,-2.07325> }}
union{cone{<7.9115,0.623868,-3.09782> ,0.166629,<9.01838,0.948061,-4.33775> ,0.154286}
sphere{<7.9115,0.623868,-3.09782> ,0.166629}
texture{txttree matrix <0.28108,-0.959684,0,0.653631,0.191441,-0.7322,0.70268,0.205807,0.68109,7.9115,0.623868,-3.09782> }}
union{cone{<9.01838,0.948061,-4.33775> ,0.154286,<10.554,0.928208,-5.05688> ,0.141943}
sphere{<9.01838,0.948061,-4.33775> ,0.154286}
texture{txttree matrix <-0.0129275,-0.999916,0,0.905554,-0.0117075,-0.42407,0.424035,-0.00548215,0.905629,9.01838,0.948061,-4.33775> }}
union{cone{<10.554,0.928208,-5.05688> ,0.141943,<11.5535,0.666311,-6.39059> ,0.1296}
sphere{<10.554,0.928208,-5.05688> ,0.141943}
texture{txttree matrix <-0.253477,-0.967341,0,0.59242,-0.155235,-0.790532,0.764714,-0.200381,0.612421,10.554,0.928208,-5.05688> }}
union{cone{<11.5535,0.666311,-6.39059> ,0.1296,<14.1822,0.5,-7.78052> ,0.12096}
sphere{<11.5535,0.666311,-6.39059> ,0.1296}
texture{txttree matrix <-0.0631401,-0.998005,0,0.882652,-0.0558421,-0.466699,0.465767,-0.0294674,0.884416,11.5535,0.666311,-6.39059> }}
union{cone{<14.1822,0.5,-7.78052> ,0.12096,<17.1825,1.052,-9.25215> ,0.11232}
sphere{<14.1822,0.5,-7.78052> ,0.12096}
texture{txttree matrix <0.180945,-0.983493,0,0.88581,0.162973,-0.434488,0.427316,0.0786184,0.900677,14.1822,0.5,-7.78052> }}
union{cone{<17.1825,1.052,-9.25215> ,0.11232,<19.3505,1.88233,-11.6466> ,0.10368}
sphere{<17.1825,1.052,-9.25215> ,0.11232}
texture{txttree matrix <0.35766,-0.933852,0,0.650056,0.248968,-0.717943,0.670453,0.25678,0.696101,17.1825,1.052,-9.25215> }}
union{cone{<19.3505,1.88233,-11.6466> ,0.10368,<22.1865,2.88324,-13.0493> ,0.09504}
sphere{<19.3505,1.88233,-11.6466> ,0.10368}
texture{txttree matrix <0.332808,-0.942995,0,0.854612,0.301615,-0.42269,0.398595,0.140675,0.906274,19.3505,1.88233,-11.6466> }}
union{cone{<22.1865,2.88324,-13.0493> ,0.09504,<24.6387,3.29282,-15.3748> ,0.0864}
sphere{<22.1865,2.88324,-13.0493> ,0.09504}
texture{txttree matrix <0.164747,-0.986336,0,0.720325,0.120315,-0.683122,0.673788,0.112542,0.730304,22.1865,2.88324,-13.0493> }}
union{cone{<24.6387,3.29282,-15.3748> ,0.0864,<26.5154,4.37867,-17.7668> ,0.07776}
sphere{<24.6387,3.29282,-15.3748> ,0.0864}
texture{txttree matrix <0.500799,-0.865564,0,0.581312,0.336336,-0.740914,0.641308,0.371049,0.6716,24.6387,3.29282,-15.3748> }}
union{cone{<9.50181,0.941811,-4.56414> ,0.1296,<11.9548,0.5,-6.55778> ,0.12096}
sphere{<9.50181,0.941811,-4.56414> ,0.1296}
texture{txttree matrix <-0.177258,-0.984164,0,0.768555,-0.138425,-0.62463,0.614738,-0.110721,0.780921,9.50181,0.941811,-4.56414> }}
union{cone{<11.9548,0.5,-6.55778> ,0.12096,<14.6514,0.538776,-8.02975> ,0.11232}
sphere{<11.9548,0.5,-6.55778> ,0.12096}
texture{txttree matrix <0.0143783,-0.999897,0,0.877673,0.0126207,-0.479094,0.479045,0.00688855,0.877764,11.9548,0.5,-6.55778> }}
union{cone{<14.6514,0.538776,-8.02975> ,0.11232,<16.4666,0.71675,-10.6326> ,0.10368}
sphere{<14.6514,0.538776,-8.02975> ,0.11232}
texture{txttree matrix <0.0975785,-0.995228,0,0.571129,0.0559971,-0.818948,0.81504,0.0799118,0.573867,14.6514,0.538776,-8.02975> }}
union{cone{<16.4666,0.71675,-10.6326> ,0.10368,<17.9453,1.5378,-13.4551> ,0.09504}
sphere{<16.4666,0.71675,-10.6326> ,0.10368}
texture{txttree matrix <0.485423,-0.87428,0,0.4494,0.249518,-0.857776,0.749936,0.416384,0.514023,16.4666,0.71675,-10.6326> }}
union{cone{<17.9453,1.5378,-13.4551> ,0.09504,<19.9811,1.62772,-16.1148> ,0.0864}
sphere{<17.9453,1.5378,-13.4551> ,0.09504}
texture{txttree matrix <0.044128,-0.999026,0,0.607602,0.0268384,-0.793788,0.793015,0.0350283,0.608194,17.9453,1.5378,-13.4551> }}
union{cone{<19.9811,1.62772,-16.1148> ,0.0864,<21.4059,1.7421,-19.2257> ,0.07776}
sphere{<19.9811,1.62772,-16.1148> ,0.0864}
texture{txttree matrix <0.0800229,-0.996793,0,0.416146,0.0334083,-0.908684,0.90577,0.0727155,0.417485,19.9811,1.62772,-16.1148> }}
union{cone{<7.16767,0.599577,-2.59986> ,0.1296,<9.53015,0.5,-4.79645> ,0.12096}
sphere{<7.16767,0.599577,-2.59986> ,0.1296}
texture{txttree matrix <-0.0421119,-0.999113,0,0.732003,-0.0308534,-0.680603,0.679999,-0.0286615,0.732653,7.16767,0.599577,-2.59986> }}
union{cone{<9.53015,0.5,-4.79645> ,0.12096,<10.3053,1.62311,-7.93894> ,0.11232}
sphere{<9.53015,0.5,-4.79645> ,0.12096}
texture{txttree matrix <0.823005,-0.568034,0,0.22626,0.32782,-0.917246,0.521027,0.754898,0.39832,9.53015,0.5,-4.79645> }}
union{cone{<10.3053,1.62311,-7.93894> ,0.11232,<12.0685,2.99638,-10.2107> ,0.10368}
sphere{<10.3053,1.62311,-7.93894> ,0.11232}
texture{txttree matrix <0.614471,-0.788939,0,0.553284,0.43093,-0.712865,0.562407,0.438035,0.701302,10.3053,1.62311,-7.93894> }}
union{cone{<12.0685,2.99638,-10.2107> ,0.10368,<12.675,4.15358,-13.218> ,0.09504}
sphere{<12.0685,2.99638,-10.2107> ,0.10368}
texture{txttree matrix <0.885739,-0.464183,0,0.184956,0.352927,-0.917188,0.425743,0.81239,0.398455,12.0685,2.99638,-10.2107> }}
union{cone{<12.675,4.15358,-13.218> ,0.09504,<14.4975,4.96882,-15.9301> ,0.0864}
sphere{<12.675,4.15358,-13.218> ,0.09504}
texture{txttree matrix <0.408322,-0.912838,0,0.541176,0.242074,-0.805313,0.73512,0.328827,0.59285,12.675,4.15358,-13.218> }}
union{cone{<14.4975,4.96882,-15.9301> ,0.0864,<15.2609,6.8141,-18.7199> ,0.07776}
sphere{<14.4975,4.96882,-15.9301> ,0.0864}
texture{txttree matrix <0.924043,-0.382288,0,0.222511,0.537839,-0.813153,0.310858,0.751389,0.58205,14.4975,4.96882,-15.9301> }}
union{cone{<6.57239,0.580137,-2.20135> ,0.1296,<9.00598,2.80075,-3.16044> ,0.12096}
sphere{<6.57239,0.580137,-2.20135> ,0.1296}
texture{txttree matrix <0.674044,-0.738691,0,0.709247,0.647177,-0.27952,0.206479,0.188409,0.96014,6.57239,0.580137,-2.20135> }}
union{cone{<9.00598,2.80075,-3.16044> ,0.12096,<11.2985,3.21126,-5.49451> ,0.11232}
sphere{<9.00598,2.80075,-3.16044> ,0.12096}
texture{txttree matrix <0.176265,-0.984343,0,0.695273,0.124502,-0.70788,0.696797,0.124775,0.706332,9.00598,2.80075,-3.16044> }}
union{cone{<11.2985,3.21126,-5.49451> ,0.11232,<13.1516,4.2157,-8.13763> ,0.10368}
sphere{<11.2985,3.21126,-5.49451> ,0.11232}
texture{txttree matrix <0.476517,-0.879166,0,0.54816,0.297108,-0.781823,0.687352,0.372552,0.6235,11.2985,3.21126,-5.49451> }}
union{cone{<13.1516,4.2157,-8.13763> ,0.10368,<15.5093,5.12614,-10.4061> ,0.09504}
sphere{<13.1516,4.2157,-8.13763> ,0.10368}
texture{txttree matrix <0.360241,-0.932859,0,0.694224,0.268087,-0.667969,0.623121,0.24063,0.744189,13.1516,4.2157,-8.13763> }}
union{cone{<15.5093,5.12614,-10.4061> ,0.09504,<17.9202,6.3312,-12.4044> ,0.0864}
sphere{<15.5093,5.12614,-10.4061> ,0.09504}
texture{txttree matrix <0.447097,-0.894485,0,0.718545,0.359156,-0.595568,0.532726,0.266277,0.803305,15.5093,5.12614,-10.4061> }}
union{cone{<17.9202,6.3312,-12.4044> ,0.0864,<19.215,8.75175,-14.0206> ,0.07776}
sphere{<17.9202,6.3312,-12.4044> ,0.0864}
texture{txttree matrix <0.881769,-0.471682,0,0.406464,0.75985,-0.50736,0.239312,0.447375,0.861734,17.9202,6.3312,-12.4044> }}
union{cone{<7.27361,0.878347,-2.53254> ,0.216,<8.23333,0.5,-3.7871> ,0.203657}
sphere{<7.27361,0.878347,-2.53254> ,0.216}
texture{txttree matrix <-0.366756,-0.930317,0,0.590875,-0.232939,-0.772403,0.718579,-0.283284,0.635133,7.27361,0.878347,-2.53254> }}
union{cone{<8.23333,0.5,-3.7871> ,0.203657,<9.37822,1.03449,-5.11674> ,0.191314}
sphere{<8.23333,0.5,-3.7871> ,0.203657}
texture{txttree matrix <0.42302,-0.90612,0,0.624181,0.291397,-0.724904,0.65685,0.306649,0.68885,8.23333,0.5,-3.7871> }}
union{cone{<9.37822,1.03449,-5.11674> ,0.191314,<10.457,1.45114,-6.49409> ,0.178971}
sphere{<9.37822,1.03449,-5.11674> ,0.191314}
texture{txttree matrix <0.360277,-0.932845,0,0.599851,0.23167,-0.765838,0.714408,0.275914,0.643034,9.37822,1.03449,-5.11674> }}
union{cone{<10.457,1.45114,-6.49409> ,0.178971,<11.4582,2.11114,-7.75272> ,0.166629}
sphere{<10.457,1.45114,-6.49409> ,0.178971}
texture{txttree matrix <0.550382,-0.834913,0,0.575915,0.379648,-0.724009,0.604485,0.398481,0.689791,10.457,1.45114,-6.49409> }}
union{cone{<11.4582,2.11114,-7.75272> ,0.166629,<12.3151,2.87887,-9.16476> ,0.154286}
sphere{<11.4582,2.11114,-7.75272> ,0.166629}
texture{txttree matrix <0.667326,-0.744766,0,0.470428,0.421514,-0.775257,0.577385,0.517349,0.631646,11.4582,2.11114,-7.75272> }}
union{cone{<12.3151,2.87887,-9.16476> ,0.154286,<12.783,2.99568,-10.8415> ,0.141943}
sphere{<12.3151,2.87887,-9.16476> ,0.154286}
texture{txttree matrix <0.242177,-0.970232,0,0.268209,0.066947,-0.961032,0.932424,0.23274,0.276438,12.3151,2.87887,-9.16476> }}
union{cone{<12.783,2.99568,-10.8415> ,0.141943,<13.4001,3.88221,-12.2039> ,0.1296}
sphere{<12.783,2.99568,-10.8415> ,0.141943}
texture{txttree matrix <0.820726,-0.571322,0,0.354946,0.509894,-0.783595,0.447685,0.643117,0.621272,12.783,2.99568,-10.8415> }}
union{cone{<13.4001,3.88221,-12.2039> ,0.1296,<14.6384,6.63482,-13.111> ,0.12096}
sphere{<13.4001,3.88221,-12.2039> ,0.1296}
texture{txttree matrix <0.911971,-0.410256,0,0.392899,0.873387,-0.287793,0.118069,0.262459,0.957693,13.4001,3.88221,-12.2039> }}
union{cone{<14.6384,6.63482,-13.111> ,0.12096,<15.4116,9.33766,-14.9485> ,0.11232}
sphere{<14.6384,6.63482,-13.111> ,0.12096}
texture{txttree matrix <0.961434,-0.275037,0,0.230221,0.804772,-0.54712,0.150478,0.526019,0.837054,14.6384,6.63482,-13.111> }}
union{cone{<15.4116,9.33766,-14.9485> ,0.11232,<17.5884,11.3482,-16.6642> ,0.10368}
sphere{<15.4116,9.33766,-14.9485> ,0.11232}
texture{txttree matrix <0.6785,-0.7346,0,0.635731,0.587181,-0.501063,0.368081,0.339971,0.865411,15.4116,9.33766,-14.9485> }}
union{cone{<17.5884,11.3482,-16.6642> ,0.10368,<18.5487,13.9002,-18.6059> ,0.09504}
sphere{<17.5884,11.3482,-16.6642> ,0.10368}
texture{txttree matrix <0.935935,-0.352172,0,0.286865,0.762375,-0.58008,0.204288,0.542917,0.81456,17.5884,11.3482,-16.6642> }}
union{cone{<18.5487,13.9002,-18.6059> ,0.09504,<19.7871,16.6106,-20.0809> ,0.0864}
sphere{<18.5487,13.9002,-18.6059> ,0.09504}
texture{txttree matrix <0.909553,-0.415588,0,0.372459,0.81516,-0.443608,0.184359,0.403485,0.896221,18.5487,13.9002,-18.6059> }}
union{cone{<19.7871,16.6106,-20.0809> ,0.0864,<20.376,19.0109,-22.1199> ,0.07776}
sphere{<19.7871,16.6106,-20.0809> ,0.0864}
texture{txttree matrix <0.971198,-0.238272,0,0.183796,0.749156,-0.636384,0.151632,0.618055,0.771372,19.7871,16.6106,-20.0809> }}
union{cone{<8.53973,0.643043,-4.14295> ,0.1296,<11.3939,1.01007,-5.52518> ,0.12096}
sphere{<8.53973,0.643043,-4.14295> ,0.1296}
texture{txttree matrix <0.127545,-0.991833,0,0.894044,0.11497,-0.432975,0.429439,0.0552238,0.901406,8.53973,0.643043,-4.14295> }}
union{cone{<11.3939,1.01007,-5.52518> ,0.12096,<14.1527,1.66463,-7.20115> ,0.11232}
sphere{<11.3939,1.01007,-5.52518> ,0.12096}
texture{txttree matrix <0.230853,-0.972989,0,0.837606,0.198731,-0.508844,0.495099,0.117468,0.860859,11.3939,1.01007,-5.52518> }}
union{cone{<14.1527,1.66463,-7.20115> ,0.11232,<15.6568,1.78462,-10.105> ,0.10368}
sphere{<14.1527,1.66463,-7.20115> ,0.11232}
texture{txttree matrix <0.0795232,-0.996833,0,0.459622,0.0366667,-0.887358,0.884547,0.0705655,0.461082,14.1527,1.66463,-7.20115> }}
union{cone{<15.6568,1.78462,-10.105> ,0.10368,<17.6673,3.04456,-12.5373> ,0.09504}
sphere{<15.6568,1.78462,-10.105> ,0.10368}
texture{txttree matrix <0.531008,-0.847367,0,0.591701,0.370793,-0.715823,0.606565,0.380107,0.698282,15.6568,1.78462,-10.105> }}
union{cone{<17.6673,3.04456,-12.5373> ,0.09504,<19.5329,3.35518,-15.2667> ,0.0864}
sphere{<17.6673,3.04456,-12.5373> ,0.09504}
texture{txttree matrix <0.164239,-0.986421,0,0.561809,0.0935411,-0.821962,0.8108,0.134998,0.569543,17.6673,3.04456,-12.5373> }}
union{cone{<19.5329,3.35518,-15.2667> ,0.0864,<20.9367,4.79519,-17.9297> ,0.07776}
sphere{<19.5329,3.35518,-15.2667> ,0.0864}
texture{txttree matrix <0.716069,-0.69803,0,0.420661,0.431532,-0.798012,0.557036,0.571432,0.602641,19.5329,3.35518,-15.2667> }}
union{cone{<8.63419,0.68714,-4.25265> ,0.1296,<10.5997,1.1755,-6.94528> ,0.12096}
sphere{<8.63419,0.68714,-4.25265> ,0.1296}
texture{txttree matrix <0.241136,-0.970491,0,0.583357,0.144946,-0.799178,0.775595,0.192711,0.601095,8.63419,0.68714,-4.25265> }}
union{cone{<10.5997,1.1755,-6.94528> ,0.12096,<11.606,1.89729,-9.80681> ,0.11232}
sphere{<10.5997,1.1755,-6.94528> ,0.12096}
texture{txttree matrix <0.582813,-0.812606,0,0.322761,0.231489,-0.917735,0.745757,0.534868,0.397193,10.5997,1.1755,-6.94528> }}
union{cone{<11.606,1.89729,-9.80681> ,0.11232,<13.3304,3.20072,-12.3166> ,0.10368}
sphere{<11.606,1.89729,-9.80681> ,0.11232}
texture{txttree matrix <0.602999,-0.797742,0,0.520596,0.39351,-0.757713,0.60446,0.4569,0.652587,11.606,1.89729,-9.80681> }}
union{cone{<13.3304,3.20072,-12.3166> ,0.10368,<14.0575,4.28605,-15.2519> ,0.09504}
sphere{<13.3304,3.20072,-12.3166> ,0.10368}
texture{txttree matrix <0.830801,-0.556569,0,0.226305,0.33781,-0.913603,0.508483,0.759023,0.406607,13.3304,3.20072,-12.3166> }}
union{cone{<14.0575,4.28605,-15.2519> ,0.09504,<14.7334,6.0905,-17.8755> ,0.0864}
sphere{<14.0575,4.28605,-15.2519> ,0.09504}
texture{txttree matrix <0.936453,-0.350793,0,0.207651,0.554331,-0.805976,0.282731,0.754759,0.591948,14.0575,4.28605,-15.2519> }}
union{cone{<14.7334,6.0905,-17.8755> ,0.0864,<16.2026,7.27068,-20.5788> ,0.07776}
sphere{<14.7334,6.0905,-17.8755> ,0.0864}
texture{txttree matrix <0.626256,-0.779618,0,0.445832,0.35813,-0.820351,0.639561,0.51375,0.57186,14.7334,6.0905,-17.8755> }}
union{cone{<11.1253,1.89165,-7.33416> ,0.1296,<11.8305,4.28287,-9.65537> ,0.12096}
sphere{<11.1253,1.89165,-7.33416> ,0.1296}
texture{txttree matrix <0.959151,-0.282894,0,0.207045,0.701985,-0.681433,0.192773,0.653597,0.731881,11.1253,1.89165,-7.33416> }}
union{cone{<11.8305,4.28287,-9.65537> ,0.12096,<13.3718,5.48168,-12.4813> ,0.11232}
sphere{<11.8305,4.28287,-9.65537> ,0.12096}
texture{txttree matrix <0.613955,-0.789341,0,0.448704,0.349005,-0.822715,0.649403,0.50511,0.568454,11.8305,4.28287,-9.65537> }}
union{cone{<13.3718,5.48168,-12.4813> ,0.11232,<14.8349,6.96342,-14.9089> ,0.10368}
sphere{<13.3718,5.48168,-12.4813> ,0.11232}
texture{txttree matrix <0.711582,-0.702603,0,0.457443,0.46329,-0.759018,0.533288,0.540104,0.65107,13.3718,5.48168,-12.4813> }}
union{cone{<14.8349,6.96342,-14.9089> ,0.10368,<16.0688,9.15663,-17.015> ,0.09504}
sphere{<14.8349,6.96342,-14.9089> ,0.10368}
texture{txttree matrix <0.871527,-0.490347,0,0.37603,0.668345,-0.641807,0.314708,0.559353,0.766866,14.8349,6.96342,-14.9089> }}
union{cone{<16.0688,9.15663,-17.015> ,0.09504,<16.2934,11.0679,-19.6946> ,0.0864}
sphere{<16.0688,9.15663,-17.015> ,0.09504}
texture{txttree matrix <0.99317,-0.116678,0,0.0680618,0.579347,-0.812234,0.0947697,0.806687,0.583331,16.0688,9.15663,-17.015> }}
union{cone{<16.2934,11.0679,-19.6946> ,0.0864,<16.37,13.0828,-22.4205> ,0.07776}
sphere{<16.2934,11.0679,-19.6946> ,0.0864}
texture{txttree matrix <0.999278,-0.037998,0,0.0225974,0.594269,-0.803949,0.0305484,0.803368,0.594699,16.2934,11.0679,-19.6946> }}
union{cone{<10.5735,1.52789,-6.64045> ,0.1296,<12.4325,3.91181,-7.54634> ,0.12096}
sphere{<10.5735,1.52789,-6.64045> ,0.1296}
texture{txttree matrix <0.788568,-0.614948,0,0.589069,0.755382,-0.287047,0.176519,0.226356,0.957916,10.5735,1.52789,-6.64045> }}
union{cone{<12.4325,3.91181,-7.54634> ,0.12096,<14.0097,5.52387,-9.80625> ,0.11232}
sphere{<12.4325,3.91181,-7.54634> ,0.12096}
texture{txttree matrix <0.714805,-0.699324,0,0.493987,0.504922,-0.707835,0.495006,0.505964,0.706378,12.4325,3.91181,-7.54634> }}
union{cone{<14.0097,5.52387,-9.80625> ,0.11232,<14.8221,8.03786,-11.5954> ,0.10368}
sphere{<14.0097,5.52387,-9.80625> ,0.11232}
texture{txttree matrix <0.951549,-0.307498,0,0.254611,0.78789,-0.560716,0.172419,0.533548,0.828008,14.0097,5.52387,-9.80625> }}
union{cone{<14.8221,8.03786,-11.5954> ,0.10368,<15.1146,10.6919,-13.696> ,0.09504}
sphere{<14.8221,8.03786,-11.5954> ,0.10368}
texture{txttree matrix <0.993979,-0.109568,0,0.0861133,0.781202,-0.618311,0.0677472,0.614588,0.785934,14.8221,8.03786,-11.5954> }}
union{cone{<15.1146,10.6919,-13.696> ,0.09504,<16.1245,12.3613,-16.3566> ,0.0864}
sphere{<15.1146,10.6919,-13.696> ,0.09504}
texture{txttree matrix <0.855637,-0.517576,0,0.306073,0.505988,-0.806409,0.417378,0.689993,0.591359,15.1146,10.6919,-13.696> }}
union{cone{<16.1245,12.3613,-16.3566> ,0.0864,<16.5625,14.5896,-18.6717> ,0.07776}
sphere{<16.1245,12.3613,-16.3566> ,0.0864}
texture{txttree matrix <0.981223,-0.192879,0,0.135068,0.687125,-0.713874,0.137691,0.700469,0.700274,16.1245,12.3613,-16.3566> }}
union{cone{<4.54732,0.755619,-0.890346> ,0.216,<4.2233,1.64982,-2.34397> ,0.203657}
sphere{<4.54732,0.755619,-0.890346> ,0.216}
texture{txttree matrix <0.940181,0.340675,0,-0.186523,0.514759,-0.836799,-0.285077,0.786742,0.547511,4.54732,0.755619,-0.890346> }}
union{cone{<4.2233,1.64982,-2.34397> ,0.203657,<4.74638,2.03842,-4.05486> ,0.191314}
sphere{<4.2233,1.64982,-2.34397> ,0.203657}
texture{txttree matrix <0.596353,-0.802722,0,0.28571,0.212258,-0.934514,0.750155,0.5573,0.355926,4.2233,1.64982,-2.34397> }}
union{cone{<4.74638,2.03842,-4.05486> ,0.191314,<4.60415,2.77335,-5.67193> ,0.178971}
sphere{<4.74638,2.03842,-4.05486> ,0.191314}
texture{txttree matrix <0.981785,0.189994,0,-0.0798144,0.412437,-0.907483,-0.172416,0.890953,0.420089,4.74638,2.03842,-4.05486> }}
union{cone{<4.60415,2.77335,-5.67193> ,0.178971,<4.53212,3.61681,-7.21598> ,0.166629}
sphere{<4.60415,2.77335,-5.67193> ,0.178971}
texture{txttree matrix <0.996373,0.0850948,0,-0.0409085,0.478997,-0.876863,-0.0746164,0.873682,0.480741,4.60415,2.77335,-5.67193> }}
union{cone{<4.53212,3.61681,-7.21598> ,0.166629,<4.48762,4.11415,-8.88859> ,0.154286}
sphere{<4.53212,3.61681,-7.21598> ,0.166629}
texture{txttree matrix <0.996022,0.0891058,0,-0.0254893,0.284919,-0.958213,-0.0853823,0.954401,0.286057,4.53212,3.61681,-7.21598> }}
union{cone{<4.48762,4.11415,-8.88859> ,0.154286,<4.208,5.14511,-10.3224> ,0.141943}
sphere{<4.48762,4.11415,-8.88859> ,0.154286}
texture{txttree matrix <0.965129,0.261773,0,-0.156396,0.576614,-0.801908,-0.209918,0.773945,0.597448,4.48762,4.11415,-8.88859> }}
union{cone{<4.208,5.14511,-10.3224> ,0.141943,<4.56243,6.20283,-11.6747> ,0.1296}
sphere{<4.208,5.14511,-10.3224> ,0.141943}
texture{txttree matrix <0.948183,-0.317725,0,0.202178,0.603358,-0.771417,0.245098,0.731444,0.63633,4.208,5.14511,-10.3224> }}
union{cone{<4.56243,6.20283,-11.6747> ,0.1296,<4.27302,9.3194,-13.0469> ,0.12096}
sphere{<4.56243,6.20283,-11.6747> ,0.1296}
texture{txttree matrix <0.995716,0.0924638,0,-0.084683,0.911926,-0.401521,-0.0371262,0.399801,0.91585,4.56243,6.20283,-11.6747> }}
union{cone{<4.27302,9.3194,-13.0469> ,0.12096,<5.60163,11.0934,-15.5826> ,0.11232}
sphere{<4.27302,9.3194,-13.0469> ,0.12096}
texture{txttree matrix <0.800404,-0.599461,0,0.394513,0.526755,-0.75292,0.451346,0.60264,0.658112,4.27302,9.3194,-13.0469> }}
union{cone{<5.60163,11.0934,-15.5826> ,0.11232,<6.75943,13.7475,-16.7264> ,0.10368}
sphere{<5.60163,11.0934,-15.5826> ,0.11232}
texture{txttree matrix <0.916587,-0.399836,0,0.371875,0.852488,-0.367387,0.146895,0.336742,0.930068,5.60163,11.0934,-15.5826> }}
union{cone{<6.75943,13.7475,-16.7264> ,0.10368,<6.49746,16.1578,-19.0274> ,0.09504}
sphere{<6.75943,13.7475,-16.7264> ,0.10368}
texture{txttree matrix <0.994145,0.108051,0,-0.0783724,0.721083,-0.688401,-0.0743823,0.684371,0.72533,6.75943,13.7475,-16.7264> }}
union{cone{<6.49746,16.1578,-19.0274> ,0.09504,<7.07039,19.0438,-20.7836> ,0.0864}
sphere{<6.49746,16.1578,-19.0274> ,0.09504}
texture{txttree matrix <0.98086,-0.194716,0,0.167199,0.842244,-0.512513,0.0997946,0.502703,0.85868,6.49746,16.1578,-19.0274> }}
union{cone{<7.07039,19.0438,-20.7836> ,0.0864,<8.00802,21.2325,-23.0167> ,0.07776}
sphere{<7.07039,19.0438,-20.7836> ,0.0864}
texture{txttree matrix <0.919202,-0.393786,0,0.287233,0.670478,-0.684074,0.269379,0.628802,0.729413,7.07039,19.0438,-20.7836> }}
union{cone{<4.45754,5.88982,-11.2745> ,0.1296,<5.61579,8.56801,-12.545> ,0.12096}
sphere{<4.45754,5.88982,-11.2745> ,0.1296}
texture{txttree matrix <0.917843,-0.396943,0,0.363942,0.841536,-0.399204,0.158461,0.366406,0.916862,4.45754,5.88982,-11.2745> }}
union{cone{<5.61579,8.56801,-12.545> ,0.12096,<7.15603,10.8909,-14.1715> ,0.11232}
sphere{<5.61579,8.56801,-12.545> ,0.12096}
texture{txttree matrix <0.83343,-0.552626,0,0.477295,0.719821,-0.504031,0.278541,0.420075,0.863685,5.61579,8.56801,-12.545> }}
union{cone{<7.15603,10.8909,-14.1715> ,0.11232,<8.2054,12.038,-16.8723> ,0.10368}
sphere{<7.15603,10.8909,-14.1715> ,0.11232}
texture{txttree matrix <0.73783,-0.674987,0,0.336738,0.368089,-0.866671,0.584991,0.639456,0.49888,7.15603,10.8909,-14.1715> }}
union{cone{<8.2054,12.038,-16.8723> ,0.10368,<9.39019,14.4355,-18.8951> ,0.09504}
sphere{<8.2054,12.038,-16.8723> ,0.10368}
texture{txttree matrix <0.89651,-0.443023,0,0.353332,0.715009,-0.603256,0.267257,0.540825,0.797548,8.2054,12.038,-16.8723> }}
union{cone{<9.39019,14.4355,-18.8951> ,0.09504,<11.0946,16.3048,-20.9217> ,0.0864}
sphere{<9.39019,14.4355,-18.8951> ,0.09504}
texture{txttree matrix <0.73893,-0.673783,0,0.525847,0.576691,-0.62523,0.421269,0.462001,0.780441,9.39019,14.4355,-18.8951> }}
union{cone{<11.0946,16.3048,-20.9217> ,0.0864,<12.1128,18.02,-23.7146> ,0.07776}
sphere{<11.0946,16.3048,-20.9217> ,0.0864}
texture{txttree matrix <0.859907,-0.510451,0,0.29667,0.499772,-0.813766,0.415387,0.699763,0.581193,11.0946,16.3048,-20.9217> }}
union{cone{<4.54461,3.47054,-6.94822> ,0.1296,<2.97753,2.92653,-9.80204> ,0.12096}
sphere{<4.54461,3.47054,-6.94822> ,0.1296}
texture{txttree matrix <-0.327952,0.944694,0,-0.474744,-0.164808,-0.864556,-0.816741,-0.283533,0.502537,4.54461,3.47054,-6.94822> }}
union{cone{<2.97753,2.92653,-9.80204> ,0.12096,<1.94563,2.51712,-13.0461> ,0.11232}
sphere{<2.97753,2.92653,-9.80204> ,0.12096}
texture{txttree matrix <-0.368786,0.929514,0,-0.300951,-0.119403,-0.946135,-0.879446,-0.348922,0.323773,2.97753,2.92653,-9.80204> }}
union{cone{<1.94563,2.51712,-13.0461> ,0.11232,<0.72214,3.32018,-16.0831> ,0.10368}
sphere{<1.94563,2.51712,-13.0461> ,0.11232}
texture{txttree matrix <0.548726,0.836002,0,-0.362923,0.238212,-0.900856,-0.753118,0.494323,0.434118,1.94563,2.51712,-13.0461> }}
union{cone{<0.72214,3.32018,-16.0831> ,0.10368,<0.193646,3.85989,-19.3935> ,0.09504}
sphere{<0.72214,3.32018,-16.0831> ,0.10368}
texture{txttree matrix <0.714489,0.699647,0,-0.155646,0.158948,-0.974941,-0.682114,0.696585,0.222463,0.72214,3.32018,-16.0831> }}
union{cone{<0.193646,3.85989,-19.3935> ,0.09504,<-0.379838,4.66646,-22.3836> ,0.0864}
sphere{<0.193646,3.85989,-19.3935> ,0.09504}
texture{txttree matrix <0.814992,0.579472,0,-0.182081,0.256086,-0.949351,-0.550122,0.773713,0.314219,0.193646,3.85989,-19.3935> }}
union{cone{<-0.379838,4.66646,-22.3836> ,0.0864,<-1.42052,5.65931,-25.1506> ,0.07776}
sphere{<-0.379838,4.66646,-22.3836> ,0.0864}
texture{txttree matrix <0.690285,0.723538,0,-0.33371,0.318372,-0.887286,-0.641985,0.61248,0.461219,-0.379838,4.66646,-22.3836> }}
union{cone{<3.06337,0.554617,0.0554491> ,0.216,<4.69429,0.846127,-0.459932> ,0.203657}
sphere{<3.06337,0.554617,0.0554491> ,0.216}
texture{txttree matrix <0.175951,-0.984399,0,0.939969,0.16801,-0.297036,0.292402,0.0522637,0.954866,3.06337,0.554617,0.0554491> }}
union{cone{<4.69429,0.846127,-0.459932> ,0.203657,<6.16272,1.71532,-0.963884> ,0.191314}
sphere{<4.69429,0.846127,-0.459932> ,0.203657}
texture{txttree matrix <0.509373,-0.860546,0,0.825306,0.488514,-0.283238,0.243739,0.144274,0.95905,4.69429,0.846127,-0.459932> }}
union{cone{<6.16272,1.71532,-0.963884> ,0.191314,<7.46833,2.89663,-1.06831> ,0.178971}
sphere{<6.16272,1.71532,-0.963884> ,0.191314}
texture{txttree matrix <0.670929,-0.741522,0,0.740221,0.669752,-0.0592064,0.0439028,0.0397233,0.998246,6.16272,1.71532,-0.963884> }}
union{cone{<7.46833,2.89663,-1.06831> ,0.178971,<8.9368,3.8952,-1.43188> ,0.166629}
sphere{<7.46833,2.89663,-1.06831> ,0.178971}
texture{txttree matrix <0.562314,-0.826924,0,0.81012,0.550887,-0.200571,0.165857,0.112784,0.979679,7.46833,2.89663,-1.06831> }}
union{cone{<8.9368,3.8952,-1.43188> ,0.166629,<10.1342,4.4977,-2.43277> ,0.154286}
sphere{<8.9368,3.8952,-1.43188> ,0.166629}
texture{txttree matrix <0.449465,-0.893298,0,0.715783,0.360148,-0.598288,0.534449,0.26891,0.801281,8.9368,3.8952,-1.43188> }}
union{cone{<10.1342,4.4977,-2.43277> ,0.154286,<11.2517,5.58167,-3.2849> ,0.141943}
sphere{<10.1342,4.4977,-2.43277> ,0.154286}
texture{txttree matrix <0.696282,-0.717768,0,0.62962,0.610773,-0.480141,0.34463,0.334314,0.877191,10.1342,4.4977,-2.43277> }}
union{cone{<11.2517,5.58167,-3.2849> ,0.141943,<11.956,6.79148,-4.26948> ,0.1296}
sphere{<11.2517,5.58167,-3.2849> ,0.141943}
texture{txttree matrix <0.86421,-0.503131,0,0.411538,0.706883,-0.575285,0.289444,0.497167,0.817953,11.2517,5.58167,-3.2849> }}
union{cone{<11.956,6.79148,-4.26948> ,0.1296,<12.6001,9.88203,-5.5359> ,0.12096}
sphere{<11.956,6.79148,-4.26948> ,0.1296}
texture{txttree matrix <0.978967,-0.204017,0,0.18935,0.908587,-0.372312,0.0759582,0.364482,0.928107,11.956,6.79148,-4.26948> }}
union{cone{<12.6001,9.88203,-5.5359> ,0.12096,<14.686,12.4392,-5.57156> ,0.11232}
sphere{<12.6001,9.88203,-5.5359> ,0.12096}
texture{txttree matrix <0.774898,-0.632086,0,0.632049,0.774853,-0.0108063,0.00683053,0.00837381,0.999942,12.6001,9.88203,-5.5359> }}
union{cone{<14.686,12.4392,-5.57156> ,0.11232,<15.8642,15.1382,-7.07442> ,0.10368}
sphere{<14.686,12.4392,-5.57156> ,0.11232}
texture{txttree matrix <0.916481,-0.400079,0,0.356359,0.816328,-0.454551,0.181856,0.416587,0.890721,14.686,12.4392,-5.57156> }}
union{cone{<15.8642,15.1382,-7.07442> ,0.10368,<16.6444,17.6507,-8.77849> ,0.09504}
sphere{<15.8642,15.1382,-7.07442> ,0.10368}
texture{txttree matrix <0.955012,-0.296568,0,0.248916,0.801562,-0.543636,0.161225,0.519178,0.839321,15.8642,15.1382,-7.07442> }}
union{cone{<16.6444,17.6507,-8.77849> ,0.09504,<17.7265,20.729,-9.46155> ,0.0864}
sphere{<16.6444,17.6507,-8.77849> ,0.09504}
texture{txttree matrix <0.943409,-0.331633,0,0.324596,0.923392,-0.2049,0.0679514,0.193304,0.978783,16.6444,17.6507,-8.77849> }}
union{cone{<17.7265,20.729,-9.46155> ,0.0864,<19.0168,23.0832,-11.4841> ,0.07776}
sphere{<17.7265,20.729,-9.46155> ,0.0864}
texture{txttree matrix <0.876927,-0.480624,0,0.38387,0.700394,-0.601741,0.289211,0.527683,0.798691,17.7265,20.729,-9.46155> }}
union{cone{<9.82728,4.34325,-2.17619> ,0.1296,<12.196,5.63921,-4.11842> ,0.12096}
sphere{<9.82728,4.34325,-2.17619> ,0.1296}
texture{txttree matrix <0.479974,-0.877283,0,0.712172,0.38964,-0.583945,0.512285,0.280278,0.811793,9.82728,4.34325,-2.17619> }}
union{cone{<12.196,5.63921,-4.11842> ,0.12096,<15.281,5.95211,-4.86123> ,0.11232}
sphere{<12.196,5.63921,-4.11842> ,0.12096}
texture{txttree matrix <0.100908,-0.994896,0,0.967523,0.0981314,-0.232959,0.23177,0.0235073,0.972487,12.196,5.63921,-4.11842> }}
union{cone{<15.281,5.95211,-4.86123> ,0.11232,<17.8829,6.40302,-6.77551> ,0.10368}
sphere{<15.281,5.95211,-4.86123> ,0.11232}
texture{txttree matrix <0.170755,-0.985313,0,0.79775,0.13825,-0.586925,0.578305,0.100221,0.809641,15.281,5.95211,-4.86123> }}
union{cone{<17.8829,6.40302,-6.77551> ,0.10368,<19.9013,7.83479,-8.9871> ,0.09504}
sphere{<17.8829,6.40302,-6.77551> ,0.10368}
texture{txttree matrix <0.578589,-0.81562,0,0.608141,0.431406,-0.666373,0.543507,0.385556,0.745619,17.8829,6.40302,-6.77551> }}
union{cone{<19.9013,7.83479,-8.9871> ,0.09504,<22.3138,9.29872,-10.5077> ,0.0864}
sphere{<19.9013,7.83479,-8.9871> ,0.09504}
texture{txttree matrix <0.518758,-0.854921,0,0.752613,0.456678,-0.474362,0.405542,0.246079,0.88033,19.9013,7.83479,-8.9871> }}
union{cone{<22.3138,9.29872,-10.5077> ,0.0864,<23.5128,10.7808,-13.2171> ,0.07776}
sphere{<22.3138,9.29872,-10.5077> ,0.0864}
texture{txttree matrix <0.777462,-0.62893,0,0.361912,0.447384,-0.817843,0.514366,0.635842,0.575441,22.3138,9.29872,-10.5077> }}
union{cone{<10.6654,5.01292,-2.83779> ,0.1296,<12.5987,7.23231,-4.53767> ,0.12096}
sphere{<10.6654,5.01292,-2.83779> ,0.1296}
texture{txttree matrix <0.75403,-0.65684,0,0.568797,0.652959,-0.500115,0.328496,0.377102,0.865959,10.6654,5.01292,-2.83779> }}
union{cone{<12.5987,7.23231,-4.53767> ,0.12096,<14.3502,9.3305,-6.30732> ,0.11232}
sphere{<12.5987,7.23231,-4.53767> ,0.12096}
texture{txttree matrix <0.767673,-0.640841,0,0.537931,0.644395,-0.543493,0.348293,0.417225,0.839413,12.5987,7.23231,-4.53767> }}
union{cone{<14.3502,9.3305,-6.30732> ,0.11232,<16.5759,10.8837,-8.10836> ,0.10368}
sphere{<14.3502,9.3305,-6.30732> ,0.11232}
texture{txttree matrix <0.572282,-0.820057,0,0.683299,0.476844,-0.552922,0.453428,0.316427,0.833233,14.3502,9.3305,-6.30732> }}
union{cone{<16.5759,10.8837,-8.10836> ,0.10368,<17.5788,12.0063,-11.0883> ,0.09504}
sphere{<16.5759,10.8837,-8.10836> ,0.10368}
texture{txttree matrix <0.745749,-0.666227,0,0.300382,0.336236,-0.892589,0.594667,0.665648,0.45087,16.5759,10.8837,-8.10836> }}
union{cone{<17.5788,12.0063,-11.0883> ,0.09504,<19.4598,13.7944,-13.2963> ,0.0864}
sphere{<17.5788,12.0063,-11.0883> ,0.09504}
texture{txttree matrix <0.688985,-0.724776,0,0.552028,0.524769,-0.647984,0.469643,0.446451,0.761654,17.5788,12.0063,-11.0883> }}
union{cone{<19.4598,13.7944,-13.2963> ,0.0864,<20.9601,15.8767,-15.2674> ,0.07776}
sphere{<19.4598,13.7944,-13.2963> ,0.0864}
texture{txttree matrix <0.811339,-0.584575,0,0.463623,0.643468,-0.609099,0.356064,0.494186,0.793094,19.4598,13.7944,-13.2963> }}
union{cone{<5.44924,1.293,-0.719025> ,0.1296,<6.43513,3.69451,-2.9061> ,0.12096}
sphere{<5.44924,1.293,-0.719025> ,0.1296}
texture{txttree matrix <0.92508,-0.379773,0,0.290439,0.707474,-0.644303,0.244689,0.596031,0.764771,5.44924,1.293,-0.719025> }}
union{cone{<6.43513,3.69451,-2.9061> ,0.12096,<7.00573,6.06529,-5.16607> ,0.11232}
sphere{<6.43513,3.69451,-2.9061> ,0.12096}
texture{txttree matrix <0.972237,-0.233998,0,0.171624,0.713081,-0.679751,0.15906,0.660879,0.733443,6.43513,3.69451,-2.9061> }}
union{cone{<7.00573,6.06529,-5.16607> ,0.11232,<8.2083,8.15181,-7.21505> ,0.10368}
sphere{<7.00573,6.06529,-5.16607> ,0.11232}
texture{txttree matrix <0.866402,-0.499348,0,0.380321,0.659881,-0.648007,0.323581,0.561434,0.761634,7.00573,6.06529,-5.16607> }}
union{cone{<8.2083,8.15181,-7.21505> ,0.10368,<10.2363,10.3389,-8.91522> ,0.09504}
sphere{<8.2083,8.15181,-7.21505> ,0.10368}
texture{txttree matrix <0.733273,-0.679935,0,0.590707,0.637045,-0.495215,0.336714,0.363128,0.86877,8.2083,8.15181,-7.21505> }}
union{cone{<10.2363,10.3389,-8.91522> ,0.09504,<10.6512,12.7767,-11.2577> ,0.0864}
sphere{<10.2363,10.3389,-8.91522> ,0.09504}
texture{txttree matrix <0.985827,-0.167763,0,0.121794,0.715696,-0.68771,0.115372,0.677964,0.725985,10.2363,10.3389,-8.91522> }}
union{cone{<10.6512,12.7767,-11.2577> ,0.0864,<12.4521,14.9506,-13.2081> ,0.07776}
sphere{<10.6512,12.7767,-11.2577> ,0.0864}
texture{txttree matrix <0.77007,-0.637959,0,0.524874,0.633566,-0.56842,0.362629,0.437723,0.822738,10.6512,12.7767,-11.2577> }}
union{cone{<11.6509,6.26743,-3.84299> ,0.1296,<13.3224,9.02671,-4.92975> ,0.12096}
sphere{<11.6509,6.26743,-3.84299> ,0.1296}
texture{txttree matrix <0.855303,-0.518128,0,0.491017,0.810548,-0.31924,0.165407,0.273047,0.947674,11.6509,6.26743,-3.84299> }}
union{cone{<13.3224,9.02671,-4.92975> ,0.12096,<14.4398,11.9673,-5.69112> ,0.11232}
sphere{<13.3224,9.02671,-4.92975> ,0.12096}
texture{txttree matrix <0.934785,-0.355213,0,0.345245,0.908553,-0.23524,0.0835603,0.219899,0.971937,13.3224,9.02671,-4.92975> }}
union{cone{<14.4398,11.9673,-5.69112> ,0.11232,<14.6464,14.7109,-7.24683> ,0.10368}
sphere{<14.4398,11.9673,-5.69112> ,0.11232}
texture{txttree matrix <0.997177,-0.0750891,0,0.0653637,0.868025,-0.4922,0.0369588,0.49081,0.870482,14.4398,11.9673,-5.69112> }}
union{cone{<14.6464,14.7109,-7.24683> ,0.10368,<15.3081,17.2551,-9.45546> ,0.09504}
sphere{<14.6464,14.7109,-7.24683> ,0.10368}
texture{txttree matrix <0.967807,-0.251693,0,0.192709,0.741,-0.643259,0.161904,0.62255,0.765649,14.6464,14.7109,-7.24683> }}
union{cone{<15.3081,17.2551,-9.45546> ,0.09504,<16.031,20.141,-10.9103> ,0.0864}
sphere{<15.3081,17.2551,-9.45546> ,0.09504}
texture{txttree matrix <0.970028,-0.242993,0,0.21829,0.871411,-0.439309,0.106749,0.426142,0.898336,15.3081,17.2551,-9.45546> }}
union{cone{<16.031,20.141,-10.9103> ,0.0864,<16.6692,22.4616,-13.1719> ,0.07776}
sphere{<16.031,20.141,-10.9103> ,0.0864}
texture{txttree matrix <0.964201,-0.265173,0,0.193244,0.702658,-0.684783,0.181586,0.660268,0.728747,16.031,20.141,-10.9103> }}
union{cone{<1.19976,1.30868,0.367073> ,0.36,<1.74352,1.22424,-0.472376> ,0.342}
sphere{<1.19976,1.30868,0.367073> ,0.36}
texture{txttree matrix <-0.153456,-0.988155,0,0.541736,-0.0841291,-0.836328,0.826422,-0.12834,0.548229,1.19976,1.30868,0.367073> }}
union{cone{<1.74352,1.22424,-0.472376> ,0.342,<1.86766,0.793754,-1.30838> ,0.324}
sphere{<1.74352,1.22424,-0.472376> ,0.342}
texture{txttree matrix <-0.960848,-0.277078,0,0.13088,-0.453866,-0.881406,0.244218,-0.846897,0.47236,1.74352,1.22424,-0.472376> }}
union{cone{<1.86766,0.793754,-1.30838> ,0.324,<2.27465,0.808704,-2.21872> ,0.306}
sphere{<1.86766,0.793754,-1.30838> ,0.324}
texture{txttree matrix <0.0367093,-0.999326,0,0.4081,0.0149912,-0.912814,0.912199,0.0335088,0.408376,1.86766,0.793754,-1.30838> }}
union{cone{<2.27465,0.808704,-2.21872> ,0.306,<2.88527,0.71576,-2.91053> ,0.288}
sphere{<2.27465,0.808704,-2.21872> ,0.306}
texture{txttree matrix <-0.150481,-0.988613,0,0.658411,-0.100219,-0.745957,0.737463,-0.112252,0.665994,2.27465,0.808704,-2.21872> }}
union{cone{<2.88527,0.71576,-2.91053> ,0.288,<3.02909,0.654976,-3.80933> ,0.27}
sphere{<2.88527,0.71576,-2.91053> ,0.288}
texture{txttree matrix <-0.389299,-0.921111,0,0.157651,-0.06663,-0.985244,0.90752,-0.383555,0.171154,2.88527,0.71576,-2.91053> }}
union{cone{<3.02909,0.654976,-3.80933> ,0.27,<3.24183,0.915674,-4.66751> ,0.252}
sphere{<3.02909,0.654976,-3.80933> ,0.27}
texture{txttree matrix <0.774765,-0.632249,0,0.230793,0.282816,-0.930994,0.58862,0.721302,0.365035,3.02909,0.654976,-3.80933> }}
union{cone{<3.24183,0.915674,-4.66751> ,0.252,<3.38361,0.870713,-5.65815> ,0.234}
sphere{<3.24183,0.915674,-4.66751> ,0.252}
texture{txttree matrix <-0.30228,-0.953219,0,0.141535,-0.044883,-0.988915,0.942653,-0.298929,0.148481,3.24183,0.915674,-4.66751> }}
union{cone{<3.38361,0.870713,-5.65815> ,0.234,<3.79632,0.792586,-6.51709> ,0.216}
sphere{<3.38361,0.870713,-5.65815> ,0.234}
texture{txttree matrix <-0.186,-0.98255,0,0.431635,-0.0817098,-0.89834,0.882664,-0.167091,0.439301,3.38361,0.870713,-5.65815> }}
union{cone{<3.79632,0.792586,-6.51709> ,0.216,<4.95908,0.5,-7.73546> ,0.203657}
sphere{<3.79632,0.792586,-6.51709> ,0.216}
texture{txttree matrix <-0.244024,-0.969769,0,0.680216,-0.171164,-0.712747,0.6912,-0.173928,0.701421,3.79632,0.792586,-6.51709> }}
union{cone{<4.95908,0.5,-7.73546> ,0.203657,<6.6383,0.634106,-8.27491> ,0.191314}
sphere{<4.95908,0.5,-7.73546> ,0.203657}
texture{txttree matrix <0.0796085,-0.996826,0,0.949338,0.075816,-0.304974,0.304006,0.0242785,0.952361,4.95908,0.5,-7.73546> }}
union{cone{<6.6383,0.634106,-8.27491> ,0.191314,<7.69025,0.700443,-9.68061> ,0.178971}
sphere{<6.6383,0.634106,-8.27491> ,0.191314}
texture{txttree matrix <0.0629362,-0.998018,0,0.598724,0.0377563,-0.800065,0.798479,0.050353,0.599914,6.6383,0.634106,-8.27491> }}
union{cone{<7.69025,0.700443,-9.68061> ,0.178971,<8.6644,1.26806,-11.0425> ,0.166629}
sphere{<7.69025,0.700443,-9.68061> ,0.178971}
texture{txttree matrix <0.503448,-0.864025,0,0.55098,0.321044,-0.770293,0.665553,0.387803,0.63769,7.69025,0.700443,-9.68061> }}
union{cone{<8.6644,1.26806,-11.0425> ,0.166629,<9.41057,1.85533,-12.4694> ,0.154286}
sphere{<8.6644,1.26806,-11.0425> ,0.166629}
texture{txttree matrix <0.618472,-0.785807,0,0.435342,0.342638,-0.832512,0.654194,0.514885,0.554007,8.6644,1.26806,-11.0425> }}
union{cone{<9.41057,1.85533,-12.4694> ,0.154286,<10.2065,1.93862,-13.9558> ,0.141943}
sphere{<9.41057,1.85533,-12.4694> ,0.154286}
texture{txttree matrix <0.104078,-0.994569,0,0.47148,0.0493388,-0.880495,0.875714,0.0916404,0.474055,9.41057,1.85533,-12.4694> }}
union{cone{<10.2065,1.93862,-13.9558> ,0.141943,<11.3143,2.724,-15.031> ,0.1296}
sphere{<10.2065,1.93862,-13.9558> ,0.141943}
texture{txttree matrix <0.578331,-0.815802,0,0.639612,0.453428,-0.620724,0.506388,0.358984,0.784029,10.2065,1.93862,-13.9558> }}
union{cone{<11.3143,2.724,-15.031> ,0.1296,<13.3728,4.76402,-16.2708> ,0.12096}
sphere{<11.3143,2.724,-15.031> ,0.1296}
texture{txttree matrix <0.703913,-0.710286,0,0.653036,0.647177,-0.393326,0.279374,0.276867,0.919399,11.3143,2.724,-15.031> }}
union{cone{<13.3728,4.76402,-16.2708> ,0.12096,<16.2894,5.9872,-17.2038> ,0.11232}
sphere{<13.3728,4.76402,-16.2708> ,0.12096}
texture{txttree matrix <0.386751,-0.922184,0,0.884503,0.370948,-0.282936,0.260919,0.109426,0.959139,13.3728,4.76402,-16.2708> }}
union{cone{<16.2894,5.9872,-17.2038> ,0.11232,<17.6778,8.78234,-17.9943> ,0.10368}
sphere{<16.2894,5.9872,-17.2038> ,0.11232}
texture{txttree matrix <0.895611,-0.444837,0,0.43122,0.868194,-0.245538,0.109225,0.219907,0.969387,16.2894,5.9872,-17.2038> }}
union{cone{<17.6778,8.78234,-17.9943> ,0.10368,<20.091,10.6714,-18.919> ,0.09504}
sphere{<17.6778,8.78234,-17.9943> ,0.10368}
texture{txttree matrix <0.616388,-0.787443,0,0.753872,0.59011,-0.288874,0.227472,0.178058,0.957367,17.6778,8.78234,-17.9943> }}
union{cone{<20.091,10.6714,-18.919> ,0.09504,<21.0957,13.2408,-20.8872> ,0.0864}
sphere{<20.091,10.6714,-18.919> ,0.09504}
texture{txttree matrix <0.931328,-0.36418,0,0.296466,0.758161,-0.580776,0.211507,0.540893,0.814064,20.091,10.6714,-18.919> }}
union{cone{<21.0957,13.2408,-20.8872> ,0.0864,<22.0948,15.882,-22.5233> ,0.07776}
sphere{<21.0957,13.2408,-20.8872> ,0.0864}
texture{txttree matrix <0.935326,-0.353788,0,0.30612,0.809305,-0.501314,0.177359,0.468892,0.865265,21.0957,13.2408,-20.8872> }}
union{cone{<8.43418,1.13392,-10.7207> ,0.1296,<11.1601,0.5,-12.4162> ,0.12096}
sphere{<8.43418,1.13392,-10.7207> ,0.1296}
texture{txttree matrix <-0.226508,-0.974009,0,0.833052,-0.193728,-0.518164,0.504696,-0.117368,0.855281,8.43418,1.13392,-10.7207> }}
union{cone{<11.1601,0.5,-12.4162> ,0.12096,<13.711,0.637372,-14.6522> ,0.11232}
sphere{<11.1601,0.5,-12.4162> ,0.12096}
texture{txttree matrix <0.0537746,-0.998553,0,0.751383,0.0404639,-0.658624,0.657671,0.0354172,0.752472,11.1601,0.5,-12.4162> }}
union{cone{<13.711,0.637372,-14.6522> ,0.11232,<14.9898,1.36247,-17.7201> ,0.10368}
sphere{<13.711,0.637372,-14.6522> ,0.11232}
texture{txttree matrix <0.493249,-0.869888,0,0.375894,0.213141,-0.901817,0.78448,0.444821,0.432117,13.711,0.637372,-14.6522> }}
union{cone{<14.9898,1.36247,-17.7201> ,0.10368,<16.8043,1.99726,-20.1687> ,0.09504}
sphere{<14.9898,1.36247,-17.7201> ,0.10368}
texture{txttree matrix <0.330212,-0.943907,0,0.58288,0.203912,-0.786556,0.742436,0.25973,0.617519,14.9898,1.36247,-17.7201> }}
union{cone{<16.8043,1.99726,-20.1687> ,0.09504,<18.1054,2.81585,-22.914> ,0.0864}
sphere{<16.8043,1.99726,-20.1687> ,0.09504}
texture{txttree matrix <0.532528,-0.846412,0,0.413522,0.260171,-0.872531,0.738521,0.464648,0.488559,16.8043,1.99726,-20.1687> }}
union{cone{<18.1054,2.81585,-22.914> ,0.0864,<19.0838,4.18337,-25.836> ,0.07776}
sphere{<18.1054,2.81585,-22.914> ,0.0864}
texture{txttree matrix <0.813283,-0.581868,0,0.290216,0.405637,-0.866737,0.504327,0.704903,0.498765,18.1054,2.81585,-22.914> }}
union{cone{<9.70892,1.88655,-13.0266> ,0.1296,<10.2089,0.894551,-16.1427> ,0.12096}
sphere{<9.70892,1.88655,-13.0266> ,0.1296}
texture{txttree matrix <-0.892989,-0.450079,0,0.151135,-0.299862,-0.941935,0.423945,-0.841137,0.335796,9.70892,1.88655,-13.0266> }}
union{cone{<10.2089,0.894551,-16.1427> ,0.12096,<10.9112,0.552109,-19.4373> ,0.11232}
sphere{<10.2089,0.894551,-16.1427> ,0.12096}
texture{txttree matrix <-0.438284,-0.898837,0,0.207411,-0.101136,-0.973012,0.874579,-0.426455,0.230755,10.2089,0.894551,-16.1427> }}
union{cone{<10.9112,0.552109,-19.4373> ,0.11232,<11.4278,0.579102,-22.5518> ,0.10368}
sphere{<10.9112,0.552109,-19.4373> ,0.11232}
texture{txttree matrix <0.0521733,-0.998638,0,0.163641,0.00854932,-0.986483,0.985139,0.051468,0.163864,10.9112,0.552109,-19.4373> }}
union{cone{<11.4278,0.579102,-22.5518> ,0.10368,<12.432,0.566116,-25.5802> ,0.09504}
sphere{<11.4278,0.579102,-22.5518> ,0.10368}
texture{txttree matrix <-0.0129297,-0.999916,0,0.314739,-0.00406981,-0.94917,0.94909,-0.0122724,0.314765,11.4278,0.579102,-22.5518> }}
union{cone{<12.432,0.566116,-25.5802> ,0.09504,<12.389,1.90225,-28.5479> ,0.0864}
sphere{<12.432,0.566116,-25.5802> ,0.09504}
texture{txttree matrix <0.999482,0.0321895,0,-0.013221,0.41051,-0.91176,-0.0293491,0.911288,0.410723,12.432,0.566116,-25.5802> }}
union{cone{<12.389,1.90225,-28.5479> ,0.0864,<13.517,2.98972,-31.5139> ,0.07776}
sphere{<12.389,1.90225,-28.5479> ,0.0864}
texture{txttree matrix <0.694073,-0.719905,0,0.336253,0.324187,-0.884215,0.636551,0.61371,0.467079,12.389,1.90225,-28.5479> }}
union{cone{<7.24483,0.672354,-9.0854> ,0.1296,<7.50136,0.63365,-12.2376> ,0.12096}
sphere{<7.24483,0.672354,-9.0854> ,0.1296}
texture{txttree matrix <-0.149185,-0.988809,0,0.0811096,-0.0122373,-0.99663,0.985477,-0.148682,0.0820275,7.24483,0.672354,-9.0854> }}
union{cone{<7.50136,0.63365,-12.2376> ,0.12096,<7.84606,2.66358,-14.9482> ,0.11232}
sphere{<7.50136,0.63365,-12.2376> ,0.12096}
texture{txttree matrix <0.985888,-0.167409,0,0.101264,0.596354,-0.796309,0.133309,0.785071,0.604891,7.50136,0.63365,-12.2376> }}
union{cone{<7.84606,2.66358,-14.9482> ,0.11232,<8.74934,2.89513,-18.1815> ,0.10368}
sphere{<7.84606,2.66358,-14.9482> ,0.11232}
texture{txttree matrix <0.248308,-0.968681,0,0.268427,0.0688076,-0.960839,0.930747,0.238584,0.277106,7.84606,2.66358,-14.9482> }}
union{cone{<8.74934,2.89513,-18.1815> ,0.10368,<9.69736,4.11794,-21.204> ,0.09504}
sphere{<8.74934,2.89513,-18.1815> ,0.10368}
texture{txttree matrix <0.790306,-0.612712,0,0.279198,0.360124,-0.890146,0.545403,0.703488,0.455676,8.74934,2.89513,-18.1815> }}
union{cone{<9.69736,4.11794,-21.204> ,0.09504,<9.69493,5.26442,-24.1069> ,0.0864}
sphere{<9.69736,4.11794,-21.204> ,0.09504}
texture{txttree matrix <0.999998,0.00212344,0,-0.00078001,0.367332,-0.93009,-0.00197499,0.930087,0.367333,9.69736,4.11794,-21.204> }}
union{cone{<9.69493,5.26442,-24.1069> ,0.0864,<10.7326,6.27907,-26.8862> ,0.07776}
sphere{<9.69493,5.26442,-24.1069> ,0.0864}
texture{txttree matrix <0.699145,-0.71498,0,0.330937,0.323607,-0.88643,0.63378,0.619743,0.462862,9.69493,5.26442,-24.1069> }}
union{cone{<5.53982,0.546379,-7.92202> ,0.1296,<8.44469,1.57548,-8.87097> ,0.12096}
sphere{<5.53982,0.546379,-7.92202> ,0.1296}
texture{txttree matrix <0.33393,-0.942598,0,0.900857,0.319143,-0.294286,0.277393,0.0982709,0.955717,5.53982,0.546379,-7.92202> }}
union{cone{<8.44469,1.57548,-8.87097> ,0.12096,<11.1397,2.61727,-10.0894> ,0.11232}
sphere{<8.44469,1.57548,-8.87097> ,0.12096}
texture{txttree matrix <0.360557,-0.932737,0,0.859447,0.332226,-0.388558,0.362422,0.140097,0.921424,8.44469,1.57548,-8.87097> }}
union{cone{<11.1397,2.61727,-10.0894> ,0.11232,<13.3535,4.50276,-11.65> ,0.10368}
sphere{<11.1397,2.61727,-10.0894> ,0.11232}
texture{txttree matrix <0.648415,-0.761287,0,0.670794,0.571338,-0.472873,0.359992,0.306618,0.881131,11.1397,2.61727,-10.0894> }}
union{cone{<13.3535,4.50276,-11.65> ,0.10368,<16.018,5.8754,-13.2872> ,0.09504}
sphere{<13.3535,4.50276,-11.65> ,0.10368}
texture{txttree matrix <0.457948,-0.888979,0,0.780175,0.401899,-0.479378,0.426157,0.21953,0.877608,13.3535,4.50276,-11.65> }}
union{cone{<16.018,5.8754,-13.2872> ,0.09504,<18.803,7.17619,-14.8064> ,0.0864}
sphere{<16.018,5.8754,-13.2872> ,0.09504}
texture{txttree matrix <0.423188,-0.906042,0,0.812253,0.379381,-0.443075,0.401445,0.187504,0.896485,16.018,5.8754,-13.2872> }}
union{cone{<18.803,7.17619,-14.8064> ,0.0864,<20.6622,9.48745,-16.0648> ,0.07776}
sphere{<18.803,7.17619,-14.8064> ,0.0864}
texture{txttree matrix <0.779192,-0.626785,0,0.577003,0.717305,-0.390566,0.244801,0.304326,0.920575,18.803,7.17619,-14.8064> }}
union{cone{<3.194,0.857062,-4.47457> ,0.216,<3.88177,1.22914,-5.99592> ,0.203657}
sphere{<3.194,0.857062,-4.47457> ,0.216}
texture{txttree matrix <0.475825,-0.87954,0,0.402075,0.21752,-0.889394,0.782257,0.423196,0.457142,3.194,0.857062,-4.47457> }}
union{cone{<3.88177,1.22914,-5.99592> ,0.203657,<5.19235,0.923881,-7.23534> ,0.191314}
sphere{<3.88177,1.22914,-5.99592> ,0.203657}
texture{txttree matrix <-0.226848,-0.97393,0,0.716371,-0.166857,-0.677475,0.659813,-0.153683,0.735546,3.88177,1.22914,-5.99592> }}
union{cone{<5.19235,0.923881,-7.23534> ,0.191314,<5.76317,0.885089,-8.8927> ,0.178971}
sphere{<5.19235,0.923881,-7.23534> ,0.191314}
texture{txttree matrix <-0.0678009,-0.997699,0,0.325566,-0.0221245,-0.945261,0.943085,-0.0640895,0.326316,5.19235,0.923881,-7.23534> }}
union{cone{<5.76317,0.885089,-8.8927> ,0.178971,<6.47377,0.965573,-10.5749> ,0.166629}
sphere{<5.76317,0.885089,-8.8927> ,0.178971}
texture{txttree matrix <0.112544,-0.993647,0,0.388741,0.0440301,-0.920294,0.914447,0.103573,0.391227,5.76317,0.885089,-8.8927> }}
union{cone{<6.47377,0.965573,-10.5749> ,0.166629,<7.18378,1.86121,-11.865> ,0.154286}
sphere{<6.47377,0.965573,-10.5749> ,0.166629}
texture{txttree matrix <0.783632,-0.621225,0,0.411957,0.519655,-0.748498,0.464986,0.586548,0.663137,6.47377,0.965573,-10.5749> }}
union{cone{<7.18378,1.86121,-11.865> ,0.154286,<8.0654,2.40468,-13.2044> ,0.141943}
sphere{<7.18378,1.86121,-11.865> ,0.154286}
texture{txttree matrix <0.524756,-0.851253,0,0.520711,0.320993,-0.79109,0.673418,0.415129,0.611699,7.18378,1.86121,-11.865> }}
union{cone{<8.0654,2.40468,-13.2044> ,0.141943,<8.42196,3.30815,-14.5933> ,0.1296}
sphere{<8.0654,2.40468,-13.2044> ,0.141943}
texture{txttree matrix <0.930181,-0.367102,0,0.210377,0.533063,-0.819503,0.300842,0.762286,0.573075,8.0654,2.40468,-13.2044> }}
union{cone{<8.42196,3.30815,-14.5933> ,0.1296,<9.39743,4.60682,-17.3036> ,0.12096}
sphere{<8.42196,3.30815,-14.5933> ,0.1296}
texture{txttree matrix <0.799566,-0.600578,0,0.308727,0.411016,-0.857761,0.515153,0.685836,0.514049,8.42196,3.30815,-14.5933> }}
union{cone{<9.39743,4.60682,-17.3036> ,0.12096,<10.1959,7.39017,-18.5626> ,0.11232}
sphere{<9.39743,4.60682,-17.3036> ,0.12096}
texture{txttree matrix <0.96123,-0.275749,0,0.25288,0.881511,-0.398735,0.109951,0.383276,0.917066,9.39743,4.60682,-17.3036> }}
union{cone{<10.1959,7.39017,-18.5626> ,0.11232,<10.0479,9.81037,-20.8254> ,0.10368}
sphere{<10.1959,7.39017,-18.5626> ,0.11232}
texture{txttree matrix <0.998137,0.0610178,0,-0.0446093,0.729725,-0.682284,-0.0416315,0.681013,0.731087,10.1959,7.39017,-18.5626> }}
union{cone{<10.0479,9.81037,-20.8254> ,0.10368,<10.6791,12.1097,-23.0805> ,0.09504}
sphere{<10.0479,9.81037,-20.8254> ,0.10368}
texture{txttree matrix <0.96433,-0.264705,0,0.192314,0.700609,-0.687141,0.181889,0.66263,0.726524,10.0479,9.81037,-20.8254> }}
union{cone{<10.6791,12.1097,-23.0805> ,0.09504,<10.8691,14.5408,-25.2844> ,0.0864}
sphere{<10.6791,12.1097,-23.0805> ,0.09504}
texture{txttree matrix <0.996961,-0.0779063,0,0.0577978,0.739634,-0.670523,0.052238,0.668485,0.741888,10.6791,12.1097,-23.0805> }}
union{cone{<10.8691,14.5408,-25.2844> ,0.0864,<11.0044,16.9314,-27.3691> ,0.07776}
sphere{<10.8691,14.5408,-25.2844> ,0.0864}
texture{txttree matrix <0.998402,-0.0565103,0,0.0426207,0.753006,-0.656632,0.0371065,0.655583,0.754211,10.8691,14.5408,-25.2844> }}
union{cone{<5.19999,0.923361,-7.25754> ,0.1296,<4.53059,0.962669,-10.303> ,0.12096}
sphere{<5.19999,0.923361,-7.25754> ,0.1296}
texture{txttree matrix <0.058621,0.99828,0,-0.214663,0.0126055,-0.976607,-0.974927,0.0572497,0.215033,5.19999,0.923361,-7.25754> }}
union{cone{<4.53059,0.962669,-10.303> ,0.12096,<3.60914,0.569665,-13.3804> ,0.11232}
sphere{<4.53059,0.962669,-10.303> ,0.12096}
texture{txttree matrix <-0.392311,0.919832,0,-0.28472,-0.121434,-0.950888,-0.874658,-0.373044,0.309535,4.53059,0.962669,-10.303> }}
union{cone{<3.60914,0.569665,-13.3804> ,0.11232,<3.07805,0.820098,-16.4292> ,0.10368}
sphere{<3.60914,0.569665,-13.3804> ,0.11232}
texture{txttree matrix <0.42651,0.904483,0,-0.171049,0.0806582,-0.981955,-0.888162,0.418814,0.189112,3.60914,0.569665,-13.3804> }}
union{cone{<3.07805,0.820098,-16.4292> ,0.10368,<2.10523,1.47614,-19.5167> ,0.09504}
sphere{<3.07805,0.820098,-16.4292> ,0.10368}
texture{txttree matrix <0.559114,0.829091,0,-0.294532,0.198624,-0.934772,-0.775011,0.522644,0.355247,3.07805,0.820098,-16.4292> }}
union{cone{<2.10523,1.47614,-19.5167> ,0.09504,<2.87434,2.07903,-22.6257> ,0.0864}
sphere{<2.10523,1.47614,-19.5167> ,0.09504}
texture{txttree matrix <0.61693,-0.787018,0,0.235997,0.184994,-0.953983,0.750802,0.58854,0.299862,2.10523,1.47614,-19.5167> }}
union{cone{<2.87434,2.07903,-22.6257> ,0.0864,<2.64306,3.59661,-25.6599> ,0.07776}
sphere{<2.87434,2.07903,-22.6257> ,0.0864}
texture{txttree matrix <0.988585,0.150661,0,-0.068015,0.446291,-0.8923,-0.134435,0.882114,0.451444,2.87434,2.07903,-22.6257> }}
union{cone{<1.84872,0.859435,-1.18083> ,0.216,<1.124,0.516973,-2.71001> ,0.203657}
sphere{<1.84872,0.859435,-1.18083> ,0.216}
texture{txttree matrix <-0.427243,0.904137,0,-0.419757,-0.198353,-0.885698,-0.800792,-0.378408,0.464263,1.84872,0.859435,-1.18083> }}
union{cone{<1.124,0.516973,-2.71001> ,0.203657,<0.900416,0.554938,-4.40974> ,0.191314}
sphere{<1.124,0.516973,-2.71001> ,0.203657}
texture{txttree matrix <0.167407,0.985888,0,-0.130383,0.0221395,-0.991217,-0.977228,0.165937,0.132249,1.124,0.516973,-2.71001> }}
union{cone{<0.900416,0.554938,-4.40974> ,0.191314,<0.465167,0.612937,-6.08937> ,0.178971}
sphere{<0.900416,0.554938,-4.40974> ,0.191314}
texture{txttree matrix <0.132088,0.991238,0,-0.250708,0.0334081,-0.967486,-0.959009,0.127793,0.252924,0.900416,0.554938,-4.40974> }}
union{cone{<0.465167,0.612937,-6.08937> ,0.178971,<-0.190372,0.878662,-7.73463> ,0.166629}
sphere{<0.465167,0.612937,-6.08937> ,0.178971}
texture{txttree matrix <0.375664,0.926756,0,-0.366044,0.148378,-0.918692,-0.851403,0.34512,0.394974,0.465167,0.612937,-6.08937> }}
union{cone{<-0.190372,0.878662,-7.73463> ,0.166629,<-0.367663,1.32873,-9.36117> ,0.154286}
sphere{<-0.190372,0.878662,-7.73463> ,0.166629}
texture{txttree matrix <0.930414,0.36651,0,-0.104477,0.265224,-0.95851,-0.351303,0.891811,0.28506,-0.190372,0.878662,-7.73463> }}
union{cone{<-0.367663,1.32873,-9.36117> ,0.154286,<-0.443691,2.06661,-10.9864> ,0.141943}
sphere{<-0.367663,1.32873,-9.36117> ,0.154286}
texture{txttree matrix <0.994734,0.102494,0,-0.042557,0.413029,-0.909723,-0.0932409,0.904932,0.415216,-0.367663,1.32873,-9.36117> }}
union{cone{<-0.443691,2.06661,-10.9864> ,0.141943,<-0.985648,2.26546,-12.5586> ,0.1296}
sphere{<-0.443691,2.06661,-10.9864> ,0.141943}
texture{txttree matrix <0.344463,0.9388,0,-0.323588,0.11873,-0.938719,-0.88127,0.323354,0.344682,-0.443691,2.06661,-10.9864> }}
union{cone{<-0.985648,2.26546,-12.5586> ,0.1296,<-3.48343,1.9404,-14.5382> ,0.12096}
sphere{<-0.985648,2.26546,-12.5586> ,0.1296}
texture{txttree matrix <-0.129051,0.991638,0,-0.779665,-0.101465,-0.617922,-0.612755,-0.0797435,0.786239,-0.985648,2.26546,-12.5586> }}
union{cone{<-3.48343,1.9404,-14.5382> ,0.12096,<-5.5086,3.47148,-16.3891> ,0.11232}
sphere{<-3.48343,1.9404,-14.5382> ,0.12096}
texture{txttree matrix <0.603073,0.797686,0,-0.644573,0.487316,-0.589109,-0.469924,0.355276,0.808053,-3.48343,1.9404,-14.5382> }}
union{cone{<-5.5086,3.47148,-16.3891> ,0.11232,<-6.42307,5.24878,-18.8278> ,0.10368}
sphere{<-5.5086,3.47148,-16.3891> ,0.11232}
texture{txttree matrix <0.8892,0.457518,0,-0.29002,0.563663,-0.773416,-0.353852,0.687722,0.633899,-5.5086,3.47148,-16.3891> }}
union{cone{<-6.42307,5.24878,-18.8278> ,0.10368,<-7.62218,5.9281,-21.6223> ,0.09504}
sphere{<-6.42307,5.24878,-18.8278> ,0.10368}
texture{txttree matrix <0.492912,0.870079,0,-0.384842,0.218019,-0.896864,-0.780342,0.442075,0.442307,-6.42307,5.24878,-18.8278> }}
union{cone{<-7.62218,5.9281,-21.6223> ,0.09504,<-9.11978,7.04693,-24.1208> ,0.0864}
sphere{<-7.62218,5.9281,-21.6223> ,0.09504}
texture{txttree matrix <0.598505,0.801119,0,-0.479938,0.358555,-0.800686,-0.641445,0.479215,0.599084,-7.62218,5.9281,-21.6223> }}
union{cone{<-9.11978,7.04693,-24.1208> ,0.0864,<-11.037,8.3389,-26.6331> ,0.07776}
sphere{<-9.11978,7.04693,-24.1208> ,0.0864}
texture{txttree matrix <0.558841,0.829275,0,-0.561527,0.378408,-0.735863,-0.610233,0.41123,0.67713,-9.11978,7.04693,-24.1208> }}
union{cone{<1.55506,0.720671,-1.80045> ,0.1296,<-1.06154,1.703,-3.72624> ,0.12096}
sphere{<1.55506,0.720671,-1.80045> ,0.1296}
texture{txttree matrix <0.351469,0.936199,0,-0.770916,0.289418,-0.567385,-0.531185,0.199418,0.823453,1.55506,0.720671,-1.80045> }}
union{cone{<-1.06154,1.703,-3.72624> ,0.12096,<-3.10493,1.44252,-6.06448> ,0.11232}
sphere{<-1.06154,1.703,-3.72624> ,0.12096}
texture{txttree matrix <-0.126451,0.991973,0,-0.655731,-0.0835886,-0.750353,-0.74433,-0.0948826,0.661037,-1.06154,1.703,-3.72624> }}
union{cone{<-3.10493,1.44252,-6.06448> ,0.11232,<-4.95066,1.73467,-8.83306> ,0.10368}
sphere{<-3.10493,1.44252,-6.06448> ,0.11232}
texture{txttree matrix <0.156337,0.987704,0,-0.552577,0.0874636,-0.82886,-0.818668,0.129581,0.559456,-3.10493,1.44252,-6.06448> }}
union{cone{<-4.95066,1.73467,-8.83306> ,0.10368,<-6.45277,2.37148,-11.7638> ,0.09504}
sphere{<-4.95066,1.73467,-8.83306> ,0.10368}
texture{txttree matrix <0.390314,0.920682,0,-0.447816,0.189847,-0.873738,-0.804435,0.341032,0.486396,-4.95066,1.73467,-8.83306> }}
union{cone{<-6.45277,2.37148,-11.7638> ,0.09504,<-7.1754,4.08964,-14.6122> ,0.0864}
sphere{<-6.45277,2.37148,-11.7638> ,0.09504}
texture{txttree matrix <0.921789,0.387692,0,-0.212287,0.50474,-0.836763,-0.324406,0.771319,0.547565,-6.45277,2.37148,-11.7638> }}
union{cone{<-7.1754,4.08964,-14.6122> ,0.0864,<-7.93466,4.77364,-17.5914> ,0.07776}
sphere{<-7.1754,4.08964,-14.6122> ,0.0864}
texture{txttree matrix <0.669325,0.74297,0,-0.241067,0.217172,-0.945898,-0.702774,0.633113,0.324464,-7.1754,4.08964,-14.6122> }}
union{cone{<1.40795,0.651155,-2.11085> ,0.1296,<1.31671,0.711932,-5.27203> ,0.12096}
sphere{<1.40795,0.651155,-2.11085> ,0.1296}
texture{txttree matrix <0.55439,0.832257,0,-0.0288451,0.0192146,-0.999399,-0.831757,0.554057,0.0346589,1.40795,0.651155,-2.11085> }}
union{cone{<1.31671,0.711932,-5.27203> ,0.12096,<0.472493,0.50567,-8.32554> ,0.11232}
sphere{<1.31671,0.711932,-5.27203> ,0.12096}
texture{txttree matrix <-0.237341,0.971426,0,-0.265916,-0.0649691,-0.961805,-0.934322,-0.228276,0.273737,1.31671,0.711932,-5.27203> }}
union{cone{<0.472493,0.50567,-8.32554> ,0.11232,<-0.595363,1.82884,-11.2733> ,0.10368}
sphere{<0.472493,0.50567,-8.32554> ,0.11232}
texture{txttree matrix <0.778189,0.62803,0,-0.3138,0.388828,-0.866223,-0.544014,0.674085,0.499657,0.472493,0.50567,-8.32554> }}
union{cone{<-0.595363,1.82884,-11.2733> ,0.10368,<-0.626694,2.34683,-14.5261> ,0.09504}
sphere{<-0.595363,1.82884,-11.2733> ,0.10368}
texture{txttree matrix <0.998176,0.0603765,0,-0.00951191,0.157256,-0.987512,-0.0596225,0.985711,0.157543,-0.595363,1.82884,-11.2733> }}
union{cone{<-0.626694,2.34683,-14.5261> ,0.09504,<-1.71427,4.01137,-17.1052> ,0.0864}
sphere{<-0.626694,2.34683,-14.5261> ,0.09504}
texture{txttree matrix <0.837148,0.546977,0,-0.333961,0.511127,-0.791972,-0.43319,0.662997,0.610558,-0.626694,2.34683,-14.5261> }}
union{cone{<-1.71427,4.01137,-17.1052> ,0.0864,<-2.12361,4.56188,-20.2723> ,0.07776}
sphere{<-1.71427,4.01137,-17.1052> ,0.0864}
texture{txttree matrix <0.802475,0.596685,0,-0.126315,0.16988,-0.977336,-0.583162,0.784288,0.211695,-1.71427,4.01137,-17.1052> }}
union{cone{<1.09444,0.521991,-2.93468> ,0.1296,<-0.225939,0.5,-5.91838> ,0.12096}
sphere{<1.09444,0.521991,-2.93468> ,0.1296}
texture{txttree matrix <-0.0166529,0.999861,0,-0.404669,-0.00673984,-0.914439,-0.914312,-0.0152281,0.404725,1.09444,0.521991,-2.93468> }}
union{cone{<-0.225939,0.5,-5.91838> ,0.12096,<-0.428248,0.513316,-9.13953> ,0.11232}
sphere{<-0.225939,0.5,-5.91838> ,0.12096}
texture{txttree matrix <0.0656785,0.997841,0,-0.0626824,0.0041258,-0.998025,-0.99587,0.0655488,0.0628181,-0.225939,0.5,-5.91838> }}
union{cone{<-0.428248,0.513316,-9.13953> ,0.11232,<-0.986716,1.14584,-12.3184> ,0.10368}
sphere{<-0.428248,0.513316,-9.13953> ,0.11232}
texture{txttree matrix <0.749625,0.661863,0,-0.169801,0.192316,-0.966531,-0.639711,0.724536,0.25655,-0.428248,0.513316,-9.13953> }}
union{cone{<-0.986716,1.14584,-12.3184> ,0.10368,<-2.65861,1.76144,-15.2247> ,0.09504}
sphere{<-0.986716,1.14584,-12.3184> ,0.10368}
texture{txttree matrix <0.345531,0.938407,0,-0.490444,0.180586,-0.852557,-0.800046,0.294585,0.522635,-0.986716,1.14584,-12.3184> }}
union{cone{<-2.65861,1.76144,-15.2247> ,0.09504,<-4.09334,2.26497,-17.9966> ,0.0864}
sphere{<-2.65861,1.76144,-15.2247> ,0.09504}
texture{txttree matrix <0.331151,0.943578,0,-0.453815,0.159267,-0.876747,-0.827279,0.290336,0.480951,-2.65861,1.76144,-15.2247> }}
union{cone{<-4.09334,2.26497,-17.9966> ,0.0864,<-5.33981,2.19563,-20.938> ,0.07776}
sphere{<-4.09334,2.26497,-17.9966> ,0.0864}
texture{txttree matrix <-0.055539,0.998457,0,-0.390082,-0.0216983,-0.920524,-0.919104,-0.051125,0.390685,-4.09334,2.26497,-17.9966> }}
union{cone{<1.79557,1.04373,-0.822933> ,0.216,<2.56085,1.20951,-2.48074> ,0.203657}
sphere{<1.79557,1.04373,-0.822933> ,0.216}
texture{txttree matrix <0.21172,-0.97733,0,0.417403,0.0904226,-0.904211,0.883713,0.19144,0.427085,1.79557,1.04373,-0.822933> }}
union{cone{<2.56085,1.20951,-2.48074> ,0.203657,<2.53971,1.47473,-4.24869> ,0.191314}
sphere{<2.56085,1.20951,-2.48074> ,0.203657}
texture{txttree matrix <0.996839,0.0794483,0,-0.0118231,0.148345,-0.988865,-0.0785636,0.985739,0.148816,2.56085,1.20951,-2.48074> }}
union{cone{<2.53971,1.47473,-4.24869> ,0.191314,<2.54494,1.49257,-5.94685> ,0.178971}
sphere{<2.53971,1.47473,-4.24869> ,0.191314}
texture{txttree matrix <0.95957,-0.28147,0,0.00308052,0.0105019,-0.99994,0.281453,0.959513,0.0109444,2.53971,1.47473,-4.24869> }}
union{cone{<2.54494,1.49257,-5.94685> ,0.178971,<3.06423,1.57875,-7.60774> ,0.166629}
sphere{<2.54494,1.49257,-5.94685> ,0.178971}
texture{txttree matrix <0.163735,-0.986504,0,0.298042,0.0494675,-0.95327,0.940405,0.156083,0.302119,2.54494,1.49257,-5.94685> }}
union{cone{<3.06423,1.57875,-7.60774> ,0.166629,<3.14886,1.82431,-9.30068> ,0.154286}
sphere{<3.06423,1.57875,-7.60774> ,0.166629}
texture{txttree matrix <0.945419,-0.325858,0,0.0494144,0.143367,-0.988435,0.32209,0.934485,0.151644,3.06423,1.57875,-7.60774> }}
union{cone{<3.14886,1.82431,-9.30068> ,0.154286,<3.63814,2.4796,-10.9282> ,0.141943}
sphere{<3.14886,1.82431,-9.30068> ,0.154286}
texture{txttree matrix <0.801286,-0.598282,0,0.26862,0.359766,-0.893539,0.534588,0.71598,0.448985,3.14886,1.82431,-9.30068> }}
union{cone{<3.63814,2.4796,-10.9282> ,0.141943,<3.77908,3.45746,-12.3404> ,0.1296}
sphere{<3.63814,2.4796,-10.9282> ,0.141943}
texture{txttree matrix <0.989772,-0.142661,0,0.0817808,0.56739,-0.819378,0.116893,0.810997,0.573254,3.63814,2.4796,-10.9282> }}
union{cone{<3.77908,3.45746,-12.3404> ,0.1296,<4.02481,5.78943,-14.5987> ,0.12096}
sphere{<3.77908,3.45746,-12.3404> ,0.1296}
texture{txttree matrix <0.994494,-0.104793,0,0.0754797,0.716307,-0.693691,0.0726941,0.689872,0.720273,3.77908,3.45746,-12.3404> }}
union{cone{<4.02481,5.78943,-14.5987> ,0.12096,<4.06033,8.0772,-17.1363> ,0.11232}
sphere{<4.02481,5.78943,-14.5987> ,0.12096}
texture{txttree matrix <0.99988,-0.0155229,0,0.0103949,0.669569,-0.742677,0.0115285,0.742588,0.66965,4.02481,5.78943,-14.5987> }}
union{cone{<4.06033,8.0772,-17.1363> ,0.11232,<5.12032,10.3042,-19.0845> ,0.10368}
sphere{<4.06033,8.0772,-17.1363> ,0.11232}
texture{txttree matrix <0.902941,-0.429765,0,0.337244,0.708553,-0.619854,0.266392,0.559691,0.784717,4.06033,8.0772,-17.1363> }}
union{cone{<5.12032,10.3042,-19.0845> ,0.10368,<5.03006,12.3705,-21.6384> ,0.09504}
sphere{<5.12032,10.3042,-19.0845> ,0.10368}
texture{txttree matrix <0.999047,0.0436394,0,-0.0274645,0.62875,-0.777122,-0.0339132,0.776382,0.62935,5.12032,10.3042,-19.0845> }}
union{cone{<5.03006,12.3705,-21.6384> ,0.09504,<4.62813,15.0611,-23.2156> ,0.0864}
sphere{<5.03006,12.3705,-21.6384> ,0.09504}
texture{txttree matrix <0.989025,0.147745,0,-0.127818,0.855632,-0.501554,-0.0741021,0.49605,0.865126,5.03006,12.3705,-21.6384> }}
union{cone{<4.62813,15.0611,-23.2156> ,0.0864,<4.43098,17.245,-25.6341> ,0.07776}
sphere{<4.62813,15.0611,-23.2156> ,0.0864}
texture{txttree matrix <0.99595,0.0899066,0,-0.0603893,0.668969,-0.740833,-0.0666058,0.737833,0.671689,4.62813,15.0611,-23.2156> }}
union{cone{<2.81445,1.5373,-6.80884> ,0.1296,<3.08745,0.780486,-9.88518> ,0.12096}
sphere{<2.81445,1.5373,-6.80884> ,0.1296}
texture{txttree matrix <-0.940668,-0.339328,0,0.0858558,-0.238006,-0.967462,0.328286,-0.910061,0.253018,2.81445,1.5373,-6.80884> }}
union{cone{<3.08745,0.780486,-9.88518> ,0.12096,<5.47752,0.629939,-12.1947> ,0.11232}
sphere{<3.08745,0.780486,-9.88518> ,0.12096}
texture{txttree matrix <-0.062864,-0.998022,0,0.718387,-0.0452501,-0.69417,0.692797,-0.0436383,0.719811,3.08745,0.780486,-9.88518> }}
union{cone{<5.47752,0.629939,-12.1947> ,0.11232,<6.46562,0.637521,-15.236> ,0.10368}
sphere{<5.47752,0.629939,-12.1947> ,0.11232}
texture{txttree matrix <0.00767278,-0.999971,0,0.308993,0.0023709,-0.951061,0.951033,0.00729728,0.309002,5.47752,0.629939,-12.1947> }}
union{cone{<6.46562,0.637521,-15.236> ,0.10368,<8.15771,1.41953,-17.7394> ,0.09504}
sphere{<6.46562,0.637521,-15.236> ,0.10368}
texture{txttree matrix <0.419521,-0.907746,0,0.542125,0.250547,-0.802076,0.728081,0.336488,0.597221,6.46562,0.637521,-15.236> }}
union{cone{<8.15771,1.41953,-17.7394> ,0.09504,<9.22537,1.90824,-20.6731> ,0.0864}
sphere{<8.15771,1.41953,-17.7394> ,0.09504}
texture{txttree matrix <0.416209,-0.909269,0,0.337876,0.154659,-0.928397,0.844162,0.386407,0.371591,8.15771,1.41953,-17.7394> }}
union{cone{<9.22537,1.90824,-20.6731> ,0.0864,<9.94218,2.06643,-23.9442> ,0.07776}
sphere{<9.22537,1.90824,-20.6731> ,0.0864}
texture{txttree matrix <0.215502,-0.976503,0,0.213817,0.0471867,-0.975733,0.952807,0.210272,0.218962,9.22537,1.90824,-20.6731> }}
union{cone{<1.97463,1.08252,-1.21083> ,0.1296,<3.37418,1.25154,-4.14805> ,0.12096}
sphere{<1.97463,1.08252,-1.21083> ,0.1296}
texture{txttree matrix <0.119896,-0.992786,0,0.429572,0.0518784,-0.901541,0.895038,0.108092,0.432694,1.97463,1.08252,-1.21083> }}
union{cone{<3.37418,1.25154,-4.14805> ,0.12096,<4.47726,1.72406,-7.2271> ,0.11232}
sphere{<3.37418,1.25154,-4.14805> ,0.12096}
texture{txttree matrix <0.393763,-0.919212,0,0.333796,0.142988,-0.931737,0.856464,0.366883,0.363133,3.37418,1.25154,-4.14805> }}
union{cone{<4.47726,1.72406,-7.2271> ,0.11232,<5.49961,1.60312,-10.4518> ,0.10368}
sphere{<4.47726,1.72406,-7.2271> ,0.11232}
texture{txttree matrix <-0.117481,-0.993075,0,0.302025,-0.0357295,-0.95263,0.946033,-0.111916,0.304131,4.47726,1.72406,-7.2271> }}
union{cone{<5.49961,1.60312,-10.4518> ,0.10368,<5.39856,2.86212,-13.6515> ,0.09504}
sphere{<5.49961,1.60312,-10.4518> ,0.10368}
texture{txttree matrix <0.996794,0.0800054,0,-0.0293755,0.365992,-0.930154,-0.0744174,0.927173,0.367169,5.49961,1.60312,-10.4518> }}
union{cone{<5.39856,2.86212,-13.6515> ,0.09504,<6.04724,3.07293,-16.8921> ,0.0864}
sphere{<5.39856,2.86212,-13.6515> ,0.09504}
texture{txttree matrix <0.309067,-0.95104,0,0.195882,0.0636573,-0.978559,0.930649,0.30244,0.205966,5.39856,2.86212,-13.6515> }}
union{cone{<6.04724,3.07293,-16.8921> ,0.0864,<6.222,3.08508,-20.1629> ,0.07776}
sphere{<6.04724,3.07293,-16.8921> ,0.0864}
texture{txttree matrix <0.0693482,-0.997593,0,0.0533556,0.00370904,-0.998569,0.996165,0.0692489,0.0534844,6.04724,3.07293,-16.8921> }}
union{cone{<3.61019,2.44217,-10.8353> ,0.1296,<3.85112,3.82839,-13.8192> ,0.12096}
sphere{<3.61019,2.44217,-10.8353> ,0.1296}
texture{txttree matrix <0.985231,-0.171233,0,0.0730289,0.420191,-0.904492,0.154879,0.891134,0.42649,3.61019,2.44217,-10.8353> }}
union{cone{<3.85112,3.82839,-13.8192> ,0.12096,<3.06731,4.19144,-16.8864> ,0.11232}
sphere{<3.85112,3.82839,-13.8192> ,0.12096}
texture{txttree matrix <0.420293,0.907388,0,-0.245973,0.113932,-0.962557,-0.873413,0.404557,0.271078,3.85112,3.82839,-13.8192> }}
union{cone{<3.06731,4.19144,-16.8864> ,0.11232,<3.70665,5.73364,-19.5678> ,0.10368}
sphere{<3.06731,4.19144,-16.8864> ,0.11232}
texture{txttree matrix <0.923766,-0.382959,0,0.202411,0.488251,-0.848905,0.325096,0.78419,0.528545,3.06731,4.19144,-16.8864> }}
union{cone{<3.70665,5.73364,-19.5678> ,0.10368,<2.85977,6.93135,-22.4067> ,0.09504}
sphere{<3.70665,5.73364,-19.5678> ,0.10368}
texture{txttree matrix <0.816504,0.577339,0,-0.265023,0.374809,-0.888415,-0.512917,0.725394,0.459042,3.70665,5.73364,-19.5678> }}
union{cone{<2.85977,6.93135,-22.4067> ,0.09504,<2.20811,8.68738,-25.0479> ,0.0864}
sphere{<2.85977,6.93135,-22.4067> ,0.09504}
texture{txttree matrix <0.937526,0.347916,0,-0.201258,0.542328,-0.815706,-0.283797,0.764745,0.578467,2.85977,6.93135,-22.4067> }}
union{cone{<2.20811,8.68738,-25.0479> ,0.0864,<1.63629,9.77042,-28.0253> ,0.07776}
sphere{<2.20811,8.68738,-25.0479> ,0.0864}
texture{txttree matrix <0.884312,0.466896,0,-0.177619,0.336414,-0.924812,-0.431791,0.817823,0.380425,2.20811,8.68738,-25.0479> }}
union{cone{<2.54054,1.20511,-2.43673> ,0.1296,<3.17311,1.3847,-5.55363> ,0.12096}
sphere{<2.54054,1.20511,-2.43673> ,0.1296}
texture{txttree matrix <0.273116,-0.961981,0,0.19858,0.0563788,-0.978462,0.941262,0.267234,0.206428,2.54054,1.20511,-2.43673> }}
union{cone{<3.17311,1.3847,-5.55363> ,0.12096,<5.16047,2.58086,-8.05916> ,0.11232}
sphere{<3.17311,1.3847,-5.55363> ,0.12096}
texture{txttree matrix <0.515681,-0.856781,0,0.582053,0.350327,-0.733815,0.628719,0.378415,0.679349,3.17311,1.3847,-5.55363> }}
union{cone{<5.16047,2.58086,-8.05916> ,0.11232,<5.91158,3.26712,-11.2335> ,0.10368}
sphere{<5.16047,2.58086,-8.05916> ,0.11232}
texture{txttree matrix <0.674518,-0.738259,0,0.225329,0.205874,-0.952283,0.703031,0.642331,0.305217,5.16047,2.58086,-8.05916> }}
union{cone{<5.91158,3.26712,-11.2335> ,0.10368,<7.04968,4.51401,-14.1444> ,0.09504}
sphere{<5.91158,3.26712,-11.2335> ,0.10368}
texture{txttree matrix <0.738597,-0.674148,0,0.338214,0.370548,-0.865046,0.583169,0.63892,0.501692,5.91158,3.26712,-11.2335> }}
union{cone{<7.04968,4.51401,-14.1444> ,0.09504,<7.77312,6.96633,-16.411> ,0.0864}
sphere{<7.04968,4.51401,-14.1444> ,0.09504}
texture{txttree matrix <0.959135,-0.282949,0,0.211726,0.717706,-0.663378,0.187702,0.636269,0.748285,7.04968,4.51401,-14.1444> }}
union{cone{<7.77312,6.96633,-16.411> ,0.0864,<8.0057,8.977,-18.8897> ,0.07776}
sphere{<7.77312,6.96633,-16.411> ,0.0864}
texture{txttree matrix <0.993376,-0.114905,0,0.0726784,0.62832,-0.774553,0.0889999,0.769422,0.632509,7.77312,6.96633,-16.411> }}
union{cone{<3.81191,1.70791,0.0943924> ,0.36,<4.15389,2.42912,-0.513517> ,0.342}
sphere{<3.81191,1.70791,0.0943924> ,0.36}
texture{txttree matrix <0.903568,-0.428446,0,0.340848,0.718828,-0.605895,0.259593,0.547467,0.795545,3.81191,1.70791,0.0943924> }}
union{cone{<4.15389,2.42912,-0.513517> ,0.342,<4.06447,2.94013,-1.29694> ,0.324}
sphere{<4.15389,2.42912,-0.513517> ,0.342}
texture{txttree matrix <0.98503,0.172382,0,-0.0951736,0.543844,-0.833772,-0.143727,0.821291,0.552109,4.15389,2.42912,-0.513517> }}
union{cone{<4.06447,2.94013,-1.29694> ,0.324,<4.49223,3.457,-1.97229> ,0.306}
sphere{<4.06447,2.94013,-1.29694> ,0.324}
texture{txttree matrix <0.770393,-0.63757,0,0.449344,0.542955,-0.709429,0.452311,0.546539,0.704777,4.06447,2.94013,-1.29694> }}
union{cone{<4.49223,3.457,-1.97229> ,0.306,<4.57406,3.77311,-2.90642> ,0.288}
sphere{<4.49223,3.457,-1.97229> ,0.306}
texture{txttree matrix <0.968088,-0.250612,0,0.0826952,0.319443,-0.94399,0.236575,0.913865,0.329973,4.49223,3.457,-1.97229> }}
union{cone{<4.57406,3.77311,-2.90642> ,0.288,<4.69606,4.41479,-3.64793> ,0.27}
sphere{<4.57406,3.77311,-2.90642> ,0.288}
texture{txttree matrix <0.982402,-0.186781,0,0.123462,0.649363,-0.750389,0.140159,0.737184,0.660996,4.57406,3.77311,-2.90642> }}
union{cone{<4.69606,4.41479,-3.64793> ,0.27,<4.63694,4.96538,-4.44551> ,0.252}
sphere{<4.69606,4.41479,-3.64793> ,0.27}
texture{txttree matrix <0.994284,0.106764,0,-0.0608899,0.567061,-0.821422,-0.0876986,0.816727,0.57032,4.69606,4.41479,-3.64793> }}
union{cone{<4.63694,4.96538,-4.44551> ,0.252,<4.58759,5.50143,-5.25041> ,0.234}
sphere{<4.63694,4.96538,-4.44551> ,0.252}
texture{txttree matrix <0.995789,0.0916796,0,-0.0509668,0.553582,-0.831233,-0.0762071,0.827733,0.555923,4.63694,4.96538,-4.44551> }}
union{cone{<4.58759,5.50143,-5.25041> ,0.234,<4.53435,6.11278,-5.92841> ,0.216}
sphere{<4.58759,5.50143,-5.25041> ,0.234}
texture{txttree matrix <0.99623,0.0867502,0,-0.0582142,0.668526,-0.741407,-0.0643172,0.738612,0.671056,4.58759,5.50143,-5.25041> }}
union{cone{<4.53435,6.11278,-5.92841> ,0.216,<4.18946,7.72404,-6.40336> ,0.203657}
sphere{<4.53435,6.11278,-5.92841> ,0.216}
texture{txttree matrix <0.97785,0.209307,0,-0.201119,0.939597,-0.276962,-0.05797,0.270827,0.960881,4.53435,6.11278,-5.92841> }}
union{cone{<4.18946,7.72404,-6.40336> ,0.203657,<3.84987,9.34867,-6.86423> ,0.191314}
sphere{<4.18946,7.72404,-6.40336> ,0.203657}
texture{txttree matrix <0.978845,0.204605,0,-0.197146,0.943159,-0.267553,-0.0547429,0.261893,0.963543,4.18946,7.72404,-6.40336> }}
union{cone{<3.84987,9.34867,-6.86423> ,0.191314,<3.83763,10.9228,-7.52227> ,0.178971}
sphere{<3.84987,9.34867,-6.86423> ,0.191314}
texture{txttree matrix <0.99997,0.00777582,0,-0.00717418,0.922599,-0.385693,-0.00299908,0.385681,0.922627,3.84987,9.34867,-6.86423> }}
union{cone{<3.83763,10.9228,-7.52227> ,0.178971,<3.73237,12.7034,-7.66492> ,0.166629}
sphere{<3.83763,10.9228,-7.52227> ,0.178971}
texture{txttree matrix <0.998257,0.0590133,0,-0.0588255,0.99508,-0.0797153,-0.00470427,0.0795764,0.996818,3.83763,10.9228,-7.52227> }}
union{cone{<3.73237,12.7034,-7.66492> ,0.166629,<4.03765,14.2391,-8.50845> ,0.154286}
sphere{<3.73237,12.7034,-7.66492> ,0.166629}
texture{txttree matrix <0.980808,-0.194974,0,0.171649,0.863475,-0.474285,0.0924733,0.465183,0.880371,3.73237,12.7034,-7.66492> }}
union{cone{<4.03765,14.2391,-8.50845> ,0.154286,<3.94272,15.6785,-9.45044> ,0.141943}
sphere{<4.03765,14.2391,-8.50845> ,0.154286}
texture{txttree matrix <0.997832,0.065807,0,-0.0550996,0.835476,-0.546758,-0.0359805,0.545573,0.837291,4.03765,14.2391,-8.50845> }}
union{cone{<3.94272,15.6785,-9.45044> ,0.141943,<3.64426,17.118,-10.4817> ,0.1296}
sphere{<3.94272,15.6785,-9.45044> ,0.141943}
texture{txttree matrix <0.979175,0.20302,0,-0.166203,0.801603,-0.57429,-0.116593,0.56233,0.818652,3.94272,15.6785,-9.45044> }}
union{cone{<3.64426,17.118,-10.4817> ,0.1296,<3.30763,20.0149,-11.8813> ,0.12096}
sphere{<3.64426,17.118,-10.4817> ,0.1296}
texture{txttree matrix <0.993316,0.115426,0,-0.104064,0.895534,-0.432655,-0.0499398,0.429763,0.90156,3.64426,17.118,-10.4817> }}
union{cone{<3.30763,20.0149,-11.8813> ,0.12096,<2.42388,23.1782,-11.9545> ,0.11232}
sphere{<3.30763,20.0149,-11.8813> ,0.12096}
texture{txttree matrix <0.963119,0.269077,0,-0.26901,0.962879,-0.0222892,-0.0059975,0.0214671,0.999752,3.30763,20.0149,-11.8813> }}
union{cone{<2.42388,23.1782,-11.9545> ,0.11232,<1.69676,26.3364,-12.4005> ,0.10368}
sphere{<2.42388,23.1782,-11.9545> ,0.11232}
texture{txttree matrix <0.974506,0.224361,0,-0.222266,0.965406,-0.136344,-0.0305903,0.132868,0.990662,2.42388,23.1782,-11.9545> }}
union{cone{<1.69676,26.3364,-12.4005> ,0.10368,<0.85508,29.2519,-13.9918> ,0.09504}
sphere{<1.69676,26.3364,-12.4005> ,0.10368}
texture{txttree matrix <0.960764,0.277368,0,-0.245644,0.850875,-0.464404,-0.128811,0.446183,0.885623,1.69676,26.3364,-12.4005> }}
union{cone{<0.85508,29.2519,-13.9918> ,0.09504,<0.385084,32.4165,-15.2222> ,0.0864}
sphere{<0.85508,29.2519,-13.9918> ,0.09504}
texture{txttree matrix <0.989151,0.146902,0,-0.137112,0.923234,-0.358941,-0.0527289,0.355047,0.93336,0.85508,29.2519,-13.9918> }}
union{cone{<0.385084,32.4165,-15.2222> ,0.0864,<-0.100191,35.339,-16.6463> ,0.07776}
sphere{<0.385084,32.4165,-15.2222> ,0.0864}
texture{txttree matrix <0.986493,0.163806,0,-0.147634,0.8891,-0.43325,-0.070969,0.427398,0.901274,0.385084,32.4165,-15.2222> }}
union{cone{<4.29752,7.21923,-6.25455> ,0.1296,<4.81787,10.6093,-6.22996> ,0.12096}
sphere{<4.29752,7.21923,-6.25455> ,0.1296}
texture{txttree matrix <0.988424,-0.151716,0,0.151712,0.988399,0.00716917,-0.00108767,-0.00708618,0.999974,4.29752,7.21923,-6.25455> }}
union{cone{<4.81787,10.6093,-6.22996> ,0.12096,<5.55003,13.7248,-6.61868> ,0.11232}
sphere{<4.81787,10.6093,-6.22996> ,0.12096}
texture{txttree matrix <0.973479,-0.228776,0,0.227107,0.966377,-0.120575,0.0275846,0.117377,0.992704,4.81787,10.6093,-6.22996> }}
union{cone{<5.55003,13.7248,-6.61868> ,0.11232,<5.72324,16.7315,-8.12656> ,0.10368}
sphere{<5.55003,13.7248,-6.61868> ,0.11232}
texture{txttree matrix <0.998345,-0.0575122,0,0.0514266,0.892706,-0.447696,0.025748,0.446955,0.894186,5.55003,13.7248,-6.61868> }}
union{cone{<5.72324,16.7315,-8.12656> ,0.10368,<6.14472,19.6818,-9.42649> ,0.09504}
sphere{<5.72324,16.7315,-8.12656> ,0.10368}
texture{txttree matrix <0.989949,-0.141425,0,0.12963,0.907386,-0.399808,0.0565428,0.395789,0.916599,5.72324,16.7315,-8.12656> }}
union{cone{<6.14472,19.6818,-9.42649> ,0.09504,<7.08239,22.6581,-10.6316> ,0.0864}
sphere{<6.14472,19.6818,-9.42649> ,0.09504}
texture{txttree matrix <0.953786,-0.300486,0,0.280309,0.88974,-0.360265,0.108255,0.343616,0.93285,6.14472,19.6818,-9.42649> }}
union{cone{<7.08239,22.6581,-10.6316> ,0.0864,<7.01337,25.8344,-11.6075> ,0.07776}
sphere{<7.08239,22.6581,-10.6316> ,0.0864}
texture{txttree matrix <0.999764,0.0217222,0,-0.0207647,0.955694,-0.293627,-0.00637823,0.293558,0.95592,7.08239,22.6581,-10.6316> }}
union{cone{<3.93545,13.725,-8.22605> ,0.1296,<4.32259,15.5118,-11.1165> ,0.12096}
sphere{<3.93545,13.725,-8.22605> ,0.1296}
texture{txttree matrix <0.977321,-0.211762,0,0.113198,0.522427,-0.845137,0.178968,0.82597,0.53455,3.93545,13.725,-8.22605> }}
union{cone{<4.32259,15.5118,-11.1165> ,0.12096,<4.62859,16.9778,-14.0559> ,0.11232}
sphere{<4.32259,15.5118,-11.1165> ,0.12096}
texture{txttree matrix <0.978902,-0.204328,0,0.0927573,0.444385,-0.891021,0.182061,0.872222,0.453962,4.32259,15.5118,-11.1165> }}
union{cone{<4.62859,16.9778,-14.0559> ,0.11232,<4.68085,19.5547,-16> ,0.10368}
sphere{<4.62859,16.9778,-14.0559> ,0.11232}
texture{txttree matrix <0.999794,-0.0202749,0,0.0161868,0.798201,-0.602173,0.012209,0.60205,0.798365,4.62859,16.9778,-14.0559> }}
union{cone{<4.68085,19.5547,-16> ,0.10368,<6.1016,21.4441,-18.0842> ,0.09504}
sphere{<4.68085,19.5547,-16> ,0.10368}
texture{txttree matrix <0.799247,-0.601003,0,0.450809,0.599511,-0.66133,0.397461,0.528566,0.750095,4.68085,19.5547,-16> }}
union{cone{<6.1016,21.4441,-18.0842> ,0.09504,<6.56929,23.9993,-20.1538> ,0.0864}
sphere{<6.1016,21.4441,-18.0842> ,0.09504}
texture{txttree matrix <0.983659,-0.180041,0,0.140814,0.769341,-0.623126,0.112188,0.612943,0.782122,6.1016,21.4441,-18.0842> }}
union{cone{<6.56929,23.9993,-20.1538> ,0.0864,<7.17813,26.5713,-22.0757> ,0.07776}
sphere{<6.56929,23.9993,-20.1538> ,0.0864}
texture{txttree matrix <0.973107,-0.230355,0,0.186309,0.78704,-0.588096,0.135471,0.57228,0.808791,6.56929,23.9993,-20.1538> }}
union{cone{<3.84333,10.1903,-7.21607> ,0.1296,<4.12876,12.8636,-9.33806> ,0.12096}
sphere{<3.84333,10.1903,-7.21607> ,0.1296}
texture{txttree matrix <0.994348,-0.106168,0,0.0833366,0.780514,-0.619558,0.0657772,0.616056,0.784951,3.84333,10.1903,-7.21607> }}
union{cone{<4.12876,12.8636,-9.33806> ,0.12096,<3.34792,14.2969,-12.3459> ,0.11232}
sphere{<4.12876,12.8636,-9.33806> ,0.12096}
texture{txttree matrix <0.878145,0.478394,0,-0.228172,0.418835,-0.878928,-0.420474,0.771826,0.476955,4.12876,12.8636,-9.33806> }}
union{cone{<3.34792,14.2969,-12.3459> ,0.11232,<2.63195,16.0316,-14.9041> ,0.10368}
sphere{<3.34792,14.2969,-12.3459> ,0.11232}
texture{txttree matrix <0.924366,0.381506,0,-0.225659,0.54676,-0.806307,-0.307611,0.745324,0.591497,3.34792,14.2969,-12.3459> }}
union{cone{<2.63195,16.0316,-14.9041> ,0.10368,<2.60693,18.2482,-17.3258> ,0.09504}
sphere{<2.63195,16.0316,-14.9041> ,0.10368}
texture{txttree matrix <0.999936,0.0112897,0,-0.00762283,0.675159,-0.737633,-0.00832766,0.737586,0.675202,2.63195,16.0316,-14.9041> }}
union{cone{<2.60693,18.2482,-17.3258> ,0.09504,<2.49559,21.0086,-19.0454> ,0.0864}
sphere{<2.60693,18.2482,-17.3258> ,0.09504}
texture{txttree matrix <0.999188,0.0403025,0,-0.0342152,0.848271,-0.528457,-0.0212981,0.528027,0.84896,2.60693,18.2482,-17.3258> }}
union{cone{<2.49559,21.0086,-19.0454> ,0.0864,<2.5179,23.0799,-21.7916> ,0.07776}
sphere{<2.49559,21.0086,-19.0454> ,0.0864}
texture{txttree matrix <0.999942,-0.0107688,0,0.00648495,0.602165,-0.798345,0.00859719,0.798299,0.6022,2.49559,21.0086,-19.0454> }}
union{cone{<4.41002,6.69364,-6.09963> ,0.1296,<3.48824,9.38112,-7.63238> ,0.12096}
sphere{<4.41002,6.69364,-6.09963> ,0.1296}
texture{txttree matrix <0.945907,0.324438,0,-0.285537,0.832489,-0.474796,-0.154042,0.449113,0.880096,4.41002,6.69364,-6.09963> }}
union{cone{<3.48824,9.38112,-7.63238> ,0.12096,<1.49537,11.4929,-8.89292> ,0.11232}
sphere{<3.48824,9.38112,-7.63238> ,0.12096}
texture{txttree matrix <0.727283,0.686338,0,-0.629571,0.66713,-0.398218,-0.273312,0.289617,0.917291,3.48824,9.38112,-7.63238> }}
union{cone{<1.49537,11.4929,-8.89292> ,0.11232,<-0.342191,13.6308,-10.2968> ,0.10368}
sphere{<1.49537,11.4929,-8.89292> ,0.11232}
texture{txttree matrix <0.758373,0.651821,0,-0.583471,0.67885,-0.445784,-0.290571,0.33807,0.895141,1.49537,11.4929,-8.89292> }}
union{cone{<-0.342191,13.6308,-10.2968> ,0.10368,<-1.54889,16.6672,-10.9804> ,0.09504}
sphere{<-0.342191,13.6308,-10.2968> ,0.10368}
texture{txttree matrix <0.929304,0.369315,0,-0.36149,0.909615,-0.204758,-0.0756201,0.190282,0.978813,-0.342191,13.6308,-10.2968> }}
union{cone{<-1.54889,16.6672,-10.9804> ,0.09504,<-2.92378,19.2761,-12.3655> ,0.0864}
sphere{<-1.54889,16.6672,-10.9804> ,0.09504}
texture{txttree matrix <0.884666,0.466226,0,-0.421995,0.800738,-0.425135,-0.198209,0.376102,0.90513,-1.54889,16.6672,-10.9804> }}
union{cone{<-2.92378,19.2761,-12.3655> ,0.0864,<-3.40581,21.9394,-14.3536> ,0.07776}
sphere{<-2.92378,19.2761,-12.3655> ,0.0864}
texture{txttree matrix <0.984014,0.178094,0,-0.143532,0.793054,-0.592,-0.105431,0.582536,0.805938,-2.92378,19.2761,-12.3655> }}
union{cone{<4.67053,4.65251,-3.99229> ,0.216,<5.88242,5.80261,-4.46396> ,0.203657}
sphere{<4.67053,4.65251,-3.99229> ,0.216}
texture{txttree matrix <0.688374,-0.725356,0,0.698072,0.66248,-0.271691,0.197073,0.187025,0.962385,4.67053,4.65251,-3.99229> }}
union{cone{<5.88242,5.80261,-4.46396> ,0.203657,<6.26918,7.26204,-5.40703> ,0.191314}
sphere{<5.88242,5.80261,-4.46396> ,0.203657}
texture{txttree matrix <0.966634,-0.256162,0,0.217261,0.819841,-0.529772,0.135708,0.512096,0.84814,5.88242,5.80261,-4.46396> }}
union{cone{<6.26918,7.26204,-5.40703> ,0.191314,<6.70778,8.49927,-6.55752> ,0.178971}
sphere{<6.26918,7.26204,-5.40703> ,0.191314}
texture{txttree matrix <0.942526,-0.334132,0,0.251279,0.708814,-0.659121,0.220233,0.621239,0.752037,6.26918,7.26204,-5.40703> }}
union{cone{<6.70778,8.49927,-6.55752> ,0.178971,<7.24795,9.51689,-7.8306> ,0.166629}
sphere{<6.70778,8.49927,-6.55752> ,0.178971}
texture{txttree matrix <0.883276,-0.468854,0,0.3146,0.592676,-0.741459,0.347636,0.654913,0.670998,6.70778,8.49927,-6.55752> }}
union{cone{<7.24795,9.51689,-7.8306> ,0.166629,<8.14991,10.5284,-9.01756> ,0.154286}
sphere{<7.24795,9.51689,-7.8306> ,0.166629}
texture{txttree matrix <0.746375,-0.665526,0,0.500656,0.561476,-0.658854,0.438484,0.491752,0.752271,7.24795,9.51689,-7.8306> }}
union{cone{<8.14991,10.5284,-9.01756> ,0.154286,<8.97602,11.5018,-10.1932> ,0.141943}
sphere{<8.14991,10.5284,-9.01756> ,0.154286}
texture{txttree matrix <0.762439,-0.64706,0,0.475999,0.560875,-0.677381,0.438306,0.516462,0.735632,8.14991,10.5284,-9.01756> }}
union{cone{<8.97602,11.5018,-10.1932> ,0.141943,<9.70888,12.7807,-11.2222> ,0.1296}
sphere{<8.97602,11.5018,-10.1932> ,0.141943}
texture{txttree matrix <0.86764,-0.497193,0,0.407676,0.711428,-0.572425,0.284606,0.496659,0.819957,8.97602,11.5018,-10.1932> }}
union{cone{<9.70888,12.7807,-11.2222> ,0.1296,<11.3905,15.0643,-12.7615> ,0.12096}
sphere{<9.70888,12.7807,-11.2222> ,0.1296}
texture{txttree matrix <0.805216,-0.592981,0,0.521158,0.707687,-0.477048,0.28288,0.384127,0.878877,9.70888,12.7807,-11.2222> }}
union{cone{<11.3905,15.0643,-12.7615> ,0.12096,<12.6561,18.1068,-13.2432> ,0.11232}
sphere{<11.3905,15.0643,-12.7615> ,0.12096}
texture{txttree matrix <0.923304,-0.384071,0,0.380032,0.913595,-0.144639,0.0555517,0.133546,0.989484,11.3905,15.0643,-12.7615> }}
union{cone{<12.6561,18.1068,-13.2432> ,0.11232,<13.6352,21.2785,-14.1405> ,0.10368}
sphere{<12.6561,18.1068,-13.2432> ,0.11232}
texture{txttree matrix <0.955516,-0.29494,0,0.28472,0.922408,-0.260956,0.0769664,0.249348,0.965351,12.6561,18.1068,-13.2432> }}
union{cone{<13.6352,21.2785,-14.1405> ,0.10368,<15.3888,23.8065,-15.025> ,0.09504}
sphere{<13.6352,21.2785,-14.1405> ,0.10368}
texture{txttree matrix <0.821658,-0.569981,0,0.547794,0.789675,-0.276288,0.157479,0.227014,0.961075,13.6352,21.2785,-14.1405> }}
union{cone{<15.3888,23.8065,-15.025> ,0.09504,<15.6252,26.6289,-16.389> ,0.0864}
sphere{<15.3888,23.8065,-15.025> ,0.09504}
texture{txttree matrix <0.996511,-0.0834569,0,0.0751914,0.897817,-0.433902,0.0362121,0.432388,0.90096,15.3888,23.8065,-15.025> }}
union{cone{<15.6252,26.6289,-16.389> ,0.0864,<15.8258,29.4621,-17.904> ,0.07776}
sphere{<15.6252,26.6289,-16.389> ,0.0864}
texture{txttree matrix <0.997502,-0.0706374,0,0.062326,0.880133,-0.470618,0.0332432,0.469442,0.882337,15.6252,26.6289,-16.389> }}
union{cone{<7.77064,10.1031,-8.51845> ,0.1296,<11.0257,10.572,-9.27334> ,0.12096}
sphere{<7.77064,10.1031,-8.51845> ,0.1296}
texture{txttree matrix <0.1426,-0.98978,0,0.964692,0.138985,-0.223723,0.221436,0.0319028,0.974653,7.77064,10.1031,-8.51845> }}
union{cone{<11.0257,10.572,-9.27334> ,0.12096,<13.4531,10.8194,-11.2176> ,0.11232}
sphere{<11.0257,10.572,-9.27334> ,0.12096}
texture{txttree matrix <0.101372,-0.994849,0,0.778046,0.0792801,-0.623185,0.619974,0.0631732,0.782075,11.0257,10.572,-9.27334> }}
union{cone{<13.4531,10.8194,-11.2176> ,0.11232,<16.2784,11.5614,-12.973> ,0.10368}
sphere{<13.4531,10.8194,-11.2176> ,0.11232}
texture{txttree matrix <0.254017,-0.9672,0,0.829022,0.217727,-0.51509,0.498195,0.130842,0.857136,13.4531,10.8194,-11.2176> }}
union{cone{<16.2784,11.5614,-12.973> ,0.10368,<18.6969,12.4382,-15.1475> ,0.09504}
sphere{<16.2784,11.5614,-12.973> ,0.10368}
texture{txttree matrix <0.340841,-0.940121,0,0.717998,0.260311,-0.645537,0.606882,0.220026,0.763729,16.2784,11.5614,-12.973> }}
union{cone{<18.6969,12.4382,-15.1475> ,0.09504,<19.7349,13.9738,-17.7328> ,0.0864}
sphere{<18.6969,12.4382,-15.1475> ,0.09504}
texture{txttree matrix <0.828472,-0.560031,0,0.326299,0.482704,-0.812728,0.455153,0.673322,0.582644,18.6969,12.4382,-15.1475> }}
union{cone{<19.7349,13.9738,-17.7328> ,0.0864,<21.5645,16.0062,-19.4771> ,0.07776}
sphere{<19.7349,13.9738,-17.7328> ,0.0864}
texture{txttree matrix <0.743221,-0.669046,0,0.564069,0.626606,-0.537766,0.35979,0.399679,0.843094,19.7349,13.9738,-17.7328> }}
union{cone{<8.42746,10.8555,-9.41253> ,0.1296,<9.38999,11.5919,-12.5661> ,0.12096}
sphere{<8.42746,10.8555,-9.41253> ,0.1296}
texture{txttree matrix <0.607648,-0.794207,0,0.284909,0.217984,-0.93344,0.741344,0.567203,0.358734,8.42746,10.8555,-9.41253> }}
union{cone{<9.38999,11.5919,-12.5661> ,0.12096,<10.9311,13.1001,-14.9759> ,0.11232}
sphere{<9.38999,11.5919,-12.5661> ,0.12096}
texture{txttree matrix <0.699451,-0.714681,0,0.476562,0.466407,-0.74522,0.532595,0.521245,0.666818,9.38999,11.5919,-12.5661> }}
union{cone{<10.9311,13.1001,-14.9759> ,0.11232,<11.2826,14.1847,-18.1059> ,0.10368}
sphere{<10.9311,13.1001,-14.9759> ,0.11232}
texture{txttree matrix <0.951281,-0.308324,0,0.105523,0.325572,-0.93961,0.289705,0.893834,0.342246,10.9311,13.1001,-14.9759> }}
union{cone{<11.2826,14.1847,-18.1059> ,0.10368,<11.825,15.3395,-20.9782> ,0.09504}
sphere{<11.2826,14.1847,-18.1059> ,0.10368}
texture{txttree matrix <0.905119,-0.425158,0,0.172592,0.367432,-0.913896,0.38855,0.827185,0.405948,11.2826,14.1847,-18.1059> }}
union{cone{<11.825,15.3395,-20.9782> ,0.09504,<12.7193,16.1284,-23.9213> ,0.0864}
sphere{<11.825,15.3395,-20.9782> ,0.09504}
texture{txttree matrix <0.661557,-0.749895,0,0.281626,0.248451,-0.9268,0.695002,0.613132,0.375555,11.825,15.3395,-20.9782> }}
union{cone{<12.7193,16.1284,-23.9213> ,0.0864,<13.4224,17.4013,-26.7689> ,0.07776}
sphere{<12.7193,16.1284,-23.9213> ,0.0864}
texture{txttree matrix <0.875357,-0.483478,0,0.219873,0.398089,-0.890607,0.430589,0.779599,0.454774,12.7193,16.1284,-23.9213> }}
union{cone{<6.80966,8.69119,-6.79761> ,0.1296,<6.36746,11.1731,-9.10004> ,0.12096}
sphere{<6.80966,8.69119,-6.79761> ,0.1296}
texture{txttree matrix <0.984497,0.175404,0,-0.129517,0.726943,-0.674374,-0.118288,0.663918,0.73839,6.80966,8.69119,-6.79761> }}
union{cone{<6.36746,11.1731,-9.10004> ,0.12096,<5.96265,11.8111,-12.2407> ,0.11232}
sphere{<6.36746,11.1731,-9.10004> ,0.12096}
texture{txttree matrix <0.844378,0.535747,0,-0.125318,0.19751,-0.972258,-0.520884,0.820954,0.233912,6.36746,11.1731,-9.10004> }}
union{cone{<5.96265,11.8111,-12.2407> ,0.11232,<5.49316,12.7478,-15.2036> ,0.10368}
sphere{<5.96265,11.8111,-12.2407> ,0.11232}
texture{txttree matrix <0.893995,0.448077,0,-0.149393,0.298066,-0.942782,-0.42244,0.842842,0.333409,5.96265,11.8111,-12.2407> }}
union{cone{<5.49316,12.7478,-15.2036> ,0.10368,<4.54925,14.5489,-17.6784> ,0.09504}
sphere{<5.49316,12.7478,-15.2036> ,0.10368}
texture{txttree matrix <0.885729,0.464203,0,-0.294691,0.562291,-0.772649,-0.358665,0.684357,0.634834,5.49316,12.7478,-15.2036> }}
union{cone{<4.54925,14.5489,-17.6784> ,0.09504,<4.98966,16.051,-20.5827> ,0.0864}
sphere{<4.54925,14.5489,-17.6784> ,0.09504}
texture{txttree matrix <0.959607,-0.281343,0,0.133488,0.455302,-0.880273,0.247658,0.844717,0.474467,4.54925,14.5489,-17.6784> }}
union{cone{<4.98966,16.051,-20.5827> ,0.0864,<4.97715,17.5868,-23.3349> ,0.07776}
sphere{<4.98966,16.051,-20.5827> ,0.0864}
texture{txttree matrix <0.999967,0.00814264,0,-0.00396772,0.487261,-0.873248,-0.00711055,0.873219,0.487277,4.98966,16.051,-20.5827> }}
union{cone{<8.00738,10.3686,-8.83> ,0.1296,<9.59751,11.7696,-11.2956> ,0.12096}
sphere{<8.00738,10.3686,-8.83> ,0.1296}
texture{txttree matrix <0.661073,-0.750322,0,0.489081,0.430906,-0.758366,0.569019,0.501335,0.651829,8.00738,10.3686,-8.83> }}
union{cone{<9.59751,11.7696,-11.2956> ,0.12096,<10.6129,14.085,-13.3775> ,0.11232}
sphere{<9.59751,11.7696,-11.2956> ,0.12096}
texture{txttree matrix <0.915817,-0.401595,0,0.310019,0.706982,-0.635661,0.255278,0.582149,0.771968,9.59751,11.7696,-11.2956> }}
union{cone{<10.6129,14.085,-13.3775> ,0.11232,<12.0279,15.925,-15.7941> ,0.10368}
sphere{<10.6129,14.085,-13.3775> ,0.11232}
texture{txttree matrix <0.792701,-0.609611,0,0.422296,0.549128,-0.721196,0.439649,0.571693,0.692731,10.6129,14.085,-13.3775> }}
union{cone{<12.0279,15.925,-15.7941> ,0.10368,<12.0434,18.8303,-17.6292> ,0.09504}
sphere{<12.0279,15.925,-15.7941> ,0.10368}
texture{txttree matrix <0.999986,-0.00535503,0,0.0045275,0.845456,-0.534027,0.00285973,0.534019,0.845468,12.0279,15.925,-15.7941> }}
union{cone{<12.0434,18.8303,-17.6292> ,0.09504,<11.9386,21.471,-19.6379> ,0.0864}
sphere{<12.0434,18.8303,-17.6292> ,0.09504}
texture{txttree matrix <0.999212,0.0396849,0,-0.0315943,0.795502,-0.605126,-0.0240143,0.60465,0.79613,12.0434,18.8303,-17.6292> }}
union{cone{<11.9386,21.471,-19.6379> ,0.0864,<13.1047,23.7387,-21.5374> ,0.07776}
sphere{<11.9386,21.471,-19.6379> ,0.0864}
texture{txttree matrix <0.889314,-0.457298,0,0.366732,0.713189,-0.597384,0.273183,0.531262,0.801955,11.9386,21.471,-19.6379> }}
union{cone{<4.64791,4.16152,-3.35526> ,0.216,<3.76982,4.22545,-4.93864> ,0.203657}
sphere{<4.64791,4.16152,-3.35526> ,0.216}
texture{txttree matrix <0.0726122,0.99736,0,-0.484678,0.0352867,-0.87398,-0.871673,0.0634616,0.485961,4.64791,4.16152,-3.35526> }}
union{cone{<3.76982,4.22545,-4.93864> ,0.203657,<2.74361,4.4784,-6.407> ,0.191314}
sphere{<3.76982,4.22545,-4.93864> ,0.203657}
texture{txttree matrix <0.239325,0.970939,0,-0.567222,0.139814,-0.811611,-0.788025,0.194239,0.584199,3.76982,4.22545,-4.93864> }}
union{cone{<2.74361,4.4784,-6.407> ,0.191314,<2.78454,5.3092,-7.91875> ,0.178971}
sphere{<2.74361,4.4784,-6.407> ,0.191314}
texture{txttree matrix <0.998789,-0.0492045,0,0.0237201,0.481488,-0.876132,0.0431097,0.87507,0.482072,2.74361,4.4784,-6.407> }}
union{cone{<2.78454,5.3092,-7.91875> ,0.178971,<1.95056,5.77853,-9.39804> ,0.166629}
sphere{<2.78454,5.3092,-7.91875> ,0.178971}
texture{txttree matrix <0.490435,0.871478,0,-0.473355,0.266386,-0.839627,-0.731716,0.411783,0.543163,2.78454,5.3092,-7.91875> }}
union{cone{<1.95056,5.77853,-9.39804> ,0.166629,<1.49877,6.67648,-10.9194> ,0.154286}
sphere{<1.95056,5.77853,-9.39804> ,0.166629}
texture{txttree matrix <0.893305,0.449451,0,-0.247771,0.492456,-0.834324,-0.374988,0.745306,0.551274,1.95056,5.77853,-9.39804> }}
union{cone{<1.49877,6.67648,-10.9194> ,0.154286,<1.43759,7.24665,-12.5217> ,0.141943}
sphere{<1.49877,6.67648,-10.9194> ,0.154286}
texture{txttree matrix <0.994292,0.106691,0,-0.0359493,0.335024,-0.941523,-0.100452,0.936149,0.336947,1.49877,6.67648,-10.9194> }}
union{cone{<1.43759,7.24665,-12.5217> ,0.141943,<0.938337,7.96106,-13.9806> ,0.1296}
sphere{<1.43759,7.24665,-12.5217> ,0.141943}
texture{txttree matrix <0.819681,0.57282,0,-0.293784,0.420392,-0.858465,-0.491745,0.703667,0.512873,1.43759,7.24665,-12.5217> }}
union{cone{<0.938337,7.96106,-13.9806> ,0.1296,<-0.650532,9.94104,-15.8585> ,0.12096}
sphere{<0.938337,7.96106,-13.9806> ,0.1296}
texture{txttree matrix <0.779929,0.625868,0,-0.503164,0.62702,-0.594702,-0.372205,0.463825,0.803946,0.938337,7.96106,-13.9806> }}
union{cone{<-0.650532,9.94104,-15.8585> ,0.12096,<-2.05305,11.5689,-18.2821> ,0.11232}
sphere{<-0.650532,9.94104,-15.8585> ,0.12096}
texture{txttree matrix <0.757598,0.652722,0,-0.43302,0.502595,-0.748259,-0.488405,0.56688,0.663406,-0.650532,9.94104,-15.8585> }}
union{cone{<-2.05305,11.5689,-18.2821> ,0.11232,<-3.91339,13.7949,-19.6901> ,0.10368}
sphere{<-2.05305,11.5689,-18.2821> ,0.11232}
texture{txttree matrix <0.767314,0.641271,0,-0.576912,0.690305,-0.436638,-0.280003,0.335038,0.899638,-2.05305,11.5689,-18.2821> }}
union{cone{<-3.91339,13.7949,-19.6901> ,0.10368,<-5.66242,15.8838,-21.3186> ,0.09504}
sphere{<-3.91339,13.7949,-19.6901> ,0.10368}
texture{txttree matrix <0.766722,0.64198,0,-0.551042,0.658114,-0.513067,-0.329379,0.39338,0.858348,-3.91339,13.7949,-19.6901> }}
union{cone{<-5.66242,15.8838,-21.3186> ,0.09504,<-6.47307,18.019,-23.7473> ,0.0864}
sphere{<-5.66242,15.8838,-21.3186> ,0.09504}
texture{txttree matrix <0.934889,0.354941,0,-0.243153,0.640448,-0.728493,-0.258572,0.68106,0.685053,-5.66242,15.8838,-21.3186> }}
union{cone{<-6.47307,18.019,-23.7473> ,0.0864,<-7.49089,20.184,-26.2027> ,0.07776}
sphere{<-6.47307,18.019,-23.7473> ,0.0864}
texture{txttree matrix <0.904986,0.425442,0,-0.296897,0.631549,-0.716239,-0.304718,0.648186,0.697855,-6.47307,18.019,-23.7473> }}
union{cone{<2.75217,4.47629,-6.39475> ,0.1296,<0.944841,6.32814,-8.61647> ,0.12096}
sphere{<2.75217,4.47629,-6.39475> ,0.1296}
texture{txttree matrix <0.715659,0.69845,0,-0.529923,0.542979,-0.651425,-0.454988,0.466198,0.758713,2.75217,4.47629,-6.39475> }}
union{cone{<0.944841,6.32814,-8.61647> ,0.12096,<0.0644887,8.00702,-11.3361> ,0.11232}
sphere{<0.944841,6.32814,-8.61647> ,0.12096}
texture{txttree matrix <0.885627,0.464396,0,-0.265559,0.506434,-0.820368,-0.380976,0.72654,0.571836,0.944841,6.32814,-8.61647> }}
union{cone{<0.0644887,8.00702,-11.3361> ,0.11232,<-1.08369,9.2399,-14.0008> ,0.10368}
sphere{<0.0644887,8.00702,-11.3361> ,0.11232}
texture{txttree matrix <0.731799,0.68152,0,-0.364192,0.39106,-0.845244,-0.576051,0.618549,0.534381,0.0644887,8.00702,-11.3361> }}
union{cone{<-1.08369,9.2399,-14.0008> ,0.10368,<-2.49763,11.0801,-16.5162> ,0.09504}
sphere{<-1.08369,9.2399,-14.0008> ,0.10368}
texture{txttree matrix <0.79296,0.609274,0,-0.413143,0.537699,-0.734978,-0.447803,0.582808,0.678091,-1.08369,9.2399,-14.0008> }}
union{cone{<-2.49763,11.0801,-16.5162> ,0.09504,<-3.13389,12.5685,-19.4529> ,0.0864}
sphere{<-2.49763,11.0801,-16.5162> ,0.09504}
texture{txttree matrix <0.919507,0.393073,0,-0.189744,0.443865,-0.875775,-0.344243,0.805281,0.48272,-2.49763,11.0801,-16.5162> }}
union{cone{<-3.13389,12.5685,-19.4529> ,0.0864,<-4.53245,14.2955,-21.9301> ,0.07776}
sphere{<-3.13389,12.5685,-19.4529> ,0.0864}
texture{txttree matrix <0.777139,0.629329,0,-0.420249,0.518952,-0.744365,-0.468451,0.578475,0.667773,-3.13389,12.5685,-19.4529> }}
union{cone{<2.77012,5.01649,-7.38614> ,0.1296,<2.56934,4.42742,-10.5498> ,0.12096}
sphere{<2.77012,5.01649,-7.38614> ,0.1296}
texture{txttree matrix <-0.94653,0.322615,0,-0.0622715,-0.1827,-0.981195,-0.316548,-0.92873,0.193021,2.77012,5.01649,-7.38614> }}
union{cone{<2.56934,4.42742,-10.5498> ,0.12096,<1.39277,4.16888,-13.4857> ,0.11232}
sphere{<2.56934,4.42742,-10.5498> ,0.12096}
texture{txttree matrix <-0.214618,0.976698,0,-0.370751,-0.0814682,-0.925152,-0.903594,-0.198554,0.379596,2.56934,4.42742,-10.5498> }}
union{cone{<1.39277,4.16888,-13.4857> ,0.11232,<0.291281,5.62531,-16.3242> ,0.10368}
sphere{<1.39277,4.16888,-13.4857> ,0.11232}
texture{txttree matrix <0.797583,0.603209,0,-0.326352,0.431514,-0.841005,-0.507302,0.670772,0.541027,1.39277,4.16888,-13.4857> }}
union{cone{<0.291281,5.62531,-16.3242> ,0.10368,<-1.00245,6.30054,-19.3599> ,0.09504}
sphere{<0.291281,5.62531,-16.3242> ,0.10368}
texture{txttree matrix <0.462695,0.886518,0,-0.384102,0.200472,-0.901264,-0.798986,0.41701,0.433271,0.291281,5.62531,-16.3242> }}
union{cone{<-1.00245,6.30054,-19.3599> ,0.09504,<-1.93095,8.06969,-21.7793> ,0.0864}
sphere{<-1.00245,6.30054,-19.3599> ,0.09504}
texture{txttree matrix <0.88546,0.464716,0,-0.295914,0.563828,-0.77106,-0.358324,0.682743,0.636763,-1.00245,6.30054,-19.3599> }}
union{cone{<-1.93095,8.06969,-21.7793> ,0.0864,<-2.46526,8.93582,-24.8132> ,0.07776}
sphere{<-1.93095,8.06969,-21.7793> ,0.0864}
texture{txttree matrix <0.851087,0.525025,0,-0.166966,0.270658,-0.948086,-0.497769,0.806903,0.318015,-1.93095,8.06969,-21.7793> }}
union{cone{<1.45414,7.09243,-12.0883> ,0.1296,<0.218662,8.11881,-14.7787> ,0.12096}
sphere{<1.45414,7.09243,-12.0883> ,0.1296}
texture{txttree matrix <0.639012,0.769196,0,-0.394298,0.327564,-0.858622,-0.660449,0.54867,0.51261,1.45414,7.09243,-12.0883> }}
union{cone{<0.218662,8.11881,-14.7787> ,0.12096,<-1.04453,8.74888,-17.6027> ,0.11232}
sphere{<0.218662,8.11881,-14.7787> ,0.12096}
texture{txttree matrix <0.446349,0.894859,0,-0.400103,0.199569,-0.894477,-0.800431,0.399249,0.447113,0.218662,8.11881,-14.7787> }}
union{cone{<-1.04453,8.74888,-17.6027> ,0.11232,<-2.5945,10.6577,-19.6047> ,0.10368}
sphere{<-1.04453,8.74888,-17.6027> ,0.11232}
texture{txttree matrix <0.776303,0.63036,0,-0.488823,0.601997,-0.631388,-0.398002,0.490149,0.775467,-1.04453,8.74888,-17.6027> }}
union{cone{<-2.5945,10.6577,-19.6047> ,0.10368,<-4.09363,12.2605,-22.0703> ,0.09504}
sphere{<-2.5945,10.6577,-19.6047> ,0.10368}
texture{txttree matrix <0.730326,0.683099,0,-0.454167,0.485566,-0.746966,-0.510252,0.545528,0.664862,-2.5945,10.6577,-19.6047> }}
union{cone{<-4.09363,12.2605,-22.0703> ,0.09504,<-5.60991,13.8996,-24.2648> ,0.0864}
sphere{<-4.09363,12.2605,-22.0703> ,0.09504}
texture{txttree matrix <0.734083,0.67906,0,-0.484321,0.523564,-0.700938,-0.475979,0.514547,0.713222,-4.09363,12.2605,-22.0703> }}
union{cone{<-5.60991,13.8996,-24.2648> ,0.0864,<-5.7256,16.0637,-26.71> ,0.07776}
sphere{<-5.60991,13.8996,-24.2648> ,0.0864}
texture{txttree matrix <0.998574,0.0533808,0,-0.0354069,0.662344,-0.748363,-0.0399482,0.747296,0.663289,-5.60991,13.8996,-24.2648> }}
union{cone{<4.06164,2.23457,-0.349526> ,0.216,<4.09862,4.04238,-0.642766> ,0.203657}
sphere{<4.06164,2.23457,-0.349526> ,0.216}
texture{txttree matrix <0.999791,-0.0204517,0,0.0201879,0.986897,-0.160082,0.00327394,0.160048,0.987104,4.06164,2.23457,-0.349526> }}
union{cone{<4.09862,4.04238,-0.642766> ,0.203657,<3.85766,5.44316,-1.69413> ,0.191314}
sphere{<4.09862,4.04238,-0.642766> ,0.203657}
texture{txttree matrix <0.985525,0.169532,0,-0.136297,0.792322,-0.594684,-0.100818,0.586076,0.803959,4.09862,4.04238,-0.642766> }}
union{cone{<3.85766,5.44316,-1.69413> ,0.191314,<3.01923,6.82433,-2.43495> ,0.178971}
sphere{<3.85766,5.44316,-1.69413> ,0.191314}
texture{txttree matrix <0.854825,0.518917,0,-0.471699,0.777042,-0.41678,-0.216274,0.356274,0.909007,3.85766,5.44316,-1.69413> }}
union{cone{<3.01923,6.82433,-2.43495> ,0.178971,<2.60953,8.01372,-3.61101> ,0.166629}
sphere{<3.01923,6.82433,-2.43495> ,0.178971}
texture{txttree matrix <0.94548,0.325679,0,-0.237905,0.690664,-0.682923,-0.222414,0.645691,0.73049,3.01923,6.82433,-2.43495> }}
union{cone{<2.60953,8.01372,-3.61101> ,0.166629,<2.22763,9.52586,-4.42843> ,0.154286}
sphere{<2.60953,8.01372,-3.61101> ,0.166629}
texture{txttree matrix <0.969556,0.244869,0,-0.216886,0.858756,-0.464218,-0.113673,0.450085,0.885721,2.60953,8.01372,-3.61101> }}
union{cone{<2.22763,9.52586,-4.42843> ,0.154286,<1.73742,11.0639,-5.29462> ,0.141943}
sphere{<2.22763,9.52586,-4.42843> ,0.154286}
texture{txttree matrix <0.952775,0.303678,0,-0.267587,0.839543,-0.472826,-0.143587,0.450496,0.881156,2.22763,9.52586,-4.42843> }}
union{cone{<1.73742,11.0639,-5.29462> ,0.141943,<1.7604,12.6536,-6.16996> ,0.1296}
sphere{<1.73742,11.0639,-5.29462> ,0.141943}
texture{txttree matrix <0.999896,-0.0144562,0,0.0126637,0.875917,-0.482296,0.00697215,0.482246,0.876008,1.73742,11.0639,-5.29462> }}
union{cone{<1.7604,12.6536,-6.16996> ,0.1296,<1.87932,15.9568,-6.35503> ,0.12096}
sphere{<1.7604,12.6536,-6.16996> ,0.1296}
texture{txttree matrix <0.999353,-0.0359769,0,0.0359207,0.99779,-0.0559015,0.00201117,0.0558653,0.998436,1.7604,12.6536,-6.16996> }}
union{cone{<1.87932,15.9568,-6.35503> ,0.12096,<1.42054,18.5893,-8.00651> ,0.11232}
sphere{<1.87932,15.9568,-6.35503> ,0.12096}
texture{txttree matrix <0.985151,0.171692,0,-0.14605,0.838018,-0.525733,-0.0902642,0.517927,0.850649,1.87932,15.9568,-6.35503> }}
union{cone{<1.42054,18.5893,-8.00651> ,0.11232,<2.19158,21.663,-8.4408> ,0.10368}
sphere{<1.42054,18.5893,-8.00651> ,0.11232}
texture{txttree matrix <0.969948,-0.243312,0,0.241059,0.960966,-0.135776,0.033036,0.131696,0.99074,1.42054,18.5893,-8.00651> }}
union{cone{<2.19158,21.663,-8.4408> ,0.10368,<2.65687,24.6543,-9.38154> ,0.09504}
sphere{<2.19158,21.663,-8.4408> ,0.10368}
texture{txttree matrix <0.988118,-0.153697,0,0.146773,0.943607,-0.296754,0.0456101,0.293228,0.954954,2.19158,21.663,-8.4408> }}
union{cone{<2.65687,24.6543,-9.38154> ,0.09504,<2.0231,27.6614,-10.3959> ,0.0864}
sphere{<2.65687,24.6543,-9.38154> ,0.09504}
texture{txttree matrix <0.978504,0.206228,0,-0.195836,0.929193,-0.313446,-0.0646415,0.306708,0.949606,2.65687,24.6543,-9.38154> }}
union{cone{<2.0231,27.6614,-10.3959> ,0.0864,<1.40972,30.509,-11.5705> ,0.07776}
sphere{<2.0231,27.6614,-10.3959> ,0.0864}
texture{txttree matrix <0.977578,0.210572,0,-0.195292,0.906644,-0.373976,-0.0787488,0.365591,0.927438,2.0231,27.6614,-10.3959> }}
union{cone{<2.14989,9.76976,-4.56579> ,0.1296,<3.09887,12.9809,-5.04595> ,0.12096}
sphere{<2.14989,9.76976,-4.56579> ,0.1296}
texture{txttree matrix <0.958998,-0.283412,0,0.280542,0.949288,-0.141947,0.0402294,0.136127,0.989874,2.14989,9.76976,-4.56579> }}
union{cone{<3.09887,12.9809,-5.04595> ,0.12096,<2.65559,15.6408,-6.85392> ,0.11232}
sphere{<3.09887,12.9809,-5.04595> ,0.12096}
texture{txttree matrix <0.986397,0.164382,0,-0.136535,0.819294,-0.55688,-0.0915412,0.549305,0.830593,3.09887,12.9809,-5.04595> }}
union{cone{<2.65559,15.6408,-6.85392> ,0.11232,<3.25071,18.6729,-8.30319> ,0.10368}
sphere{<2.65559,15.6408,-6.85392> ,0.11232}
texture{txttree matrix <0.981278,-0.192595,0,0.174369,0.888415,-0.424634,0.0817824,0.416685,0.905365,2.65559,15.6408,-6.85392> }}
union{cone{<3.25071,18.6729,-8.30319> ,0.10368,<2.69724,21.144,-10.3527> ,0.09504}
sphere{<3.25071,18.6729,-8.30319> ,0.10368}
texture{txttree matrix <0.975822,0.218568,0,-0.169896,0.75852,-0.629112,-0.137504,0.613901,0.777314,3.25071,18.6729,-8.30319> }}
union{cone{<2.69724,21.144,-10.3527> ,0.09504,<3.41652,23.7881,-12.1348> ,0.0864}
sphere{<2.69724,21.144,-10.3527> ,0.09504}
texture{txttree matrix <0.964933,-0.262496,0,0.220049,0.808899,-0.545216,0.143117,0.526097,0.838296,2.69724,21.144,-10.3527> }}
union{cone{<3.41652,23.7881,-12.1348> ,0.0864,<3.09973,26.0407,-14.3513> ,0.07776}
sphere{<3.41652,23.7881,-12.1348> ,0.0864}
texture{txttree matrix <0.990256,0.139256,0,-0.0997407,0.709261,-0.697854,-0.0971804,0.691054,0.71624,3.41652,23.7881,-12.1348> }}
union{cone{<3.88288,5.29653,-1.58408> ,0.1296,<2.49531,7.19848,-3.91208> ,0.12096}
sphere{<3.88288,5.29653,-1.58408> ,0.1296}
texture{txttree matrix <0.80786,0.589375,0,-0.419086,0.574444,-0.703122,-0.414402,0.568024,0.711069,3.88288,5.29653,-1.58408> }}
union{cone{<2.49531,7.19848,-3.91208> ,0.12096,<1.52785,8.03225,-7.02389> ,0.11232}
sphere{<2.49531,7.19848,-3.91208> ,0.12096}
texture{txttree matrix <0.652826,0.757508,0,-0.287617,0.247871,-0.925114,-0.700781,0.603939,0.379689,2.49531,7.19848,-3.91208> }}
union{cone{<1.52785,8.03225,-7.02389> ,0.11232,<-0.00722818,9.87962,-9.0209> ,0.10368}
sphere{<1.52785,8.03225,-7.02389> ,0.11232}
texture{txttree matrix <0.769121,0.639103,0,-0.491435,0.591411,-0.639316,-0.408589,0.491711,0.768944,1.52785,8.03225,-7.02389> }}
union{cone{<-0.00722818,9.87962,-9.0209> ,0.10368,<-0.186537,11.1305,-11.8996> ,0.09504}
sphere{<-0.00722818,9.87962,-9.0209> ,0.10368}
texture{txttree matrix <0.989882,0.141892,0,-0.0570348,0.397892,-0.915658,-0.129924,0.906393,0.401959,-0.00722818,9.87962,-9.0209> }}
union{cone{<-0.186537,11.1305,-11.8996> ,0.09504,<-0.275469,12.6522,-14.9517> ,0.0864}
sphere{<-0.186537,11.1305,-11.8996> ,0.09504}
texture{txttree matrix <0.998297,0.058344,0,-0.026068,0.446037,-0.894635,-0.0521966,0.893111,0.446798,-0.186537,11.1305,-11.8996> }}
union{cone{<-0.275469,12.6522,-14.9517> ,0.0864,<-0.678447,14.9769,-17.2191> ,0.07776}
sphere{<-0.275469,12.6522,-14.9517> ,0.0864}
texture{txttree matrix <0.985306,0.170796,0,-0.123148,0.71043,-0.692909,-0.118346,0.682728,0.721025,-0.275469,12.6522,-14.9517> }}
union{cone{<2.49735,8.45788,-3.85111> ,0.1296,<0.622939,11.0054,-3.59123> ,0.12096}
sphere{<2.49735,8.45788,-3.85111> ,0.1296}
texture{txttree matrix <0.805461,0.592648,0,-0.590657,0.802756,0.0818946,0.0485347,-0.0659629,0.996641,2.49735,8.45788,-3.85111> }}
union{cone{<0.622939,11.0054,-3.59123> ,0.12096,<-0.69251,13.5818,-5.25232> ,0.11232}
sphere{<0.622939,11.0054,-3.59123> ,0.12096}
texture{txttree matrix <0.890633,0.454724,0,-0.394338,0.772361,-0.497952,-0.226431,0.443493,0.867204,0.622939,11.0054,-3.59123> }}
union{cone{<-0.69251,13.5818,-5.25232> ,0.11232,<-1.53142,16.038,-7.05829> ,0.10368}
sphere{<-0.69251,13.5818,-5.25232> ,0.11232}
texture{txttree matrix <0.946322,0.323226,0,-0.265316,0.776776,-0.571163,-0.184614,0.540504,0.820837,-0.69251,13.5818,-5.25232> }}
union{cone{<-1.53142,16.038,-7.05829> ,0.10368,<-3.29831,18.5478,-8.3014> ,0.09504}
sphere{<-1.53142,16.038,-7.05829> ,0.10368}
texture{txttree matrix <0.817701,0.575644,0,-0.533547,0.757903,-0.375381,-0.216086,0.306949,0.926871,-1.53142,16.038,-7.05829> }}
union{cone{<-3.29831,18.5478,-8.3014> ,0.09504,<-4.92297,21.1035,-9.2773> ,0.0864}
sphere{<-3.29831,18.5478,-8.3014> ,0.09504}
texture{txttree matrix <0.843918,0.536473,0,-0.510615,0.803241,-0.306718,-0.164546,0.258844,0.951801,-3.29831,18.5478,-8.3014> }}
union{cone{<-4.92297,21.1035,-9.2773> ,0.0864,<-5.38062,23.8866,-11.0178> ,0.07776}
sphere{<-4.92297,21.1035,-9.2773> ,0.0864}
texture{txttree matrix <0.986748,0.162261,0,-0.138085,0.83973,-0.525154,-0.0852118,0.518194,0.851007,-4.92297,21.1035,-9.2773> }}
union{cone{<1.37989,1.3185,0.343775> ,0.36,<1.36899,2.28214,0.581954> ,0.342}
sphere{<1.37989,1.3185,0.343775> ,0.36}
texture{txttree matrix <0.999936,0.0113128,0,-0.0109823,0.970728,0.239932,0.0027143,-0.239917,0.97079,1.37989,1.3185,0.343775> }}
union{cone{<1.36899,2.28214,0.581954> ,0.342,<1.91989,3.06376,0.757234> ,0.324}
sphere{<1.36899,2.28214,0.581954> ,0.342}
texture{txttree matrix <0.81738,-0.576098,0,0.566658,0.803986,0.180294,-0.103867,-0.147369,0.983613,1.36899,2.28214,0.581954> }}
union{cone{<1.91989,3.06376,0.757234> ,0.324,<1.85376,3.91532,1.12057> ,0.306}
sphere{<1.91989,3.06376,0.757234> ,0.324}
texture{txttree matrix <0.996998,0.0774215,0,-0.0712432,0.917438,0.391448,0.0303065,-0.390273,0.9202,1.91989,3.06376,0.757234> }}
union{cone{<1.85376,3.91532,1.12057> ,0.306,<2.17399,4.85146,1.11653> ,0.288}
sphere{<1.85376,3.91532,1.12057> ,0.306}
texture{txttree matrix <0.946173,-0.32366,0,0.323658,0.946165,-0.00408306,0.00132152,0.00386328,0.999992,1.85376,3.91532,1.12057> }}
union{cone{<2.17399,4.85146,1.11653> ,0.288,<2.15228,5.79235,1.41836> ,0.27}
sphere{<2.17399,4.85146,1.11653> ,0.288}
texture{txttree matrix <0.999734,0.023061,0,-0.0219594,0.951977,0.305382,0.0070424,-0.3053,0.95223,2.17399,4.85146,1.11653> }}
union{cone{<2.15228,5.79235,1.41836> ,0.27,<2.34665,6.70899,1.56337> ,0.252}
sphere{<2.15228,5.79235,1.41836> ,0.27}
texture{txttree matrix <0.978249,-0.207436,0,0.204995,0.966741,0.152933,-0.0317237,-0.149607,0.988237,2.15228,5.79235,1.41836> }}
union{cone{<2.34665,6.70899,1.56337> ,0.252,<2.28051,7.64811,1.45013> ,0.234}
sphere{<2.34665,6.70899,1.56337> ,0.252}
texture{txttree matrix <0.997529,0.070253,0,-0.0697503,0.990391,-0.119419,-0.00838955,0.119124,0.992844,2.34665,6.70899,1.56337> }}
union{cone{<2.28051,7.64811,1.45013> ,0.234,<2.34394,8.58818,1.36298> ,0.216}
sphere{<2.28051,7.64811,1.45013> ,0.234}
texture{txttree matrix <0.997731,-0.0673211,0,0.067035,0.993491,-0.0921025,0.00620044,0.0918936,0.99575,2.28051,7.64811,1.45013> }}
union{cone{<2.34394,8.58818,1.36298> ,0.216,<1.91735,10.2421,2.03521> ,0.203657}
sphere{<2.34394,8.58818,1.36298> ,0.216}
texture{txttree matrix <0.968308,0.24976,0,-0.232408,0.901034,0.36623,0.0914695,-0.354623,0.930524,2.34394,8.58818,1.36298> }}
union{cone{<1.91735,10.2421,2.03521> ,0.203657,<2.4988,11.8706,2.40413> ,0.191314}
sphere{<1.91735,10.2421,2.03521> ,0.203657}
texture{txttree matrix <0.941773,-0.336249,0,0.328849,0.921046,0.208645,-0.0701566,-0.196496,0.977992,1.91735,10.2421,2.03521> }}
union{cone{<2.4988,11.8706,2.40413> ,0.191314,<2.50307,13.4245,3.27218> ,0.178971}
sphere{<2.4988,11.8706,2.40413> ,0.191314}
texture{txttree matrix <0.999996,-0.00274758,0,0.00239866,0.873004,0.487708,-0.00134002,-0.487706,0.873007,2.4988,11.8706,2.40413> }}
union{cone{<2.50307,13.4245,3.27218> ,0.178971,<2.71501,15.1353,2.93925> ,0.166629}
sphere{<2.50307,13.4245,3.27218> ,0.178971}
texture{txttree matrix <0.992414,-0.122937,0,0.120707,0.974409,-0.189623,0.0233117,0.188185,0.981857,2.50307,13.4245,3.27218> }}
union{cone{<2.71501,15.1353,2.93925> ,0.166629,<2.53154,16.8073,3.44041> ,0.154286}
sphere{<2.71501,15.1353,2.93925> ,0.166629}
texture{txttree matrix <0.994034,0.109074,0,-0.104533,0.952648,0.285544,0.0311455,-0.28384,0.958366,2.71501,15.1353,2.93925> }}
union{cone{<2.53154,16.8073,3.44041> ,0.154286,<2.37324,18.4914,3.39324> ,0.141943}
sphere{<2.53154,16.8073,3.44041> ,0.154286}
texture{txttree matrix <0.995611,0.0935881,0,-0.0935517,0.995224,-0.0278776,-0.00260901,0.0277553,0.999611,2.53154,16.8073,3.44041> }}
union{cone{<2.37324,18.4914,3.39324> ,0.141943,<2.54364,20.2209,3.50504> ,0.1296}
sphere{<2.37324,18.4914,3.39324> ,0.141943}
texture{txttree matrix <0.995182,-0.0980484,0,0.0978461,0.993129,0.0642004,-0.00629474,-0.063891,0.997937,2.37324,18.4914,3.39324> }}
union{cone{<2.54364,20.2209,3.50504> ,0.1296,<3.51245,22.2405,5.95605> ,0.12096}
sphere{<2.54364,20.2209,3.50504> ,0.1296}
texture{txttree matrix <0.901623,-0.432524,0,0.291782,0.608237,0.738181,-0.319281,-0.66556,0.674603,2.54364,20.2209,3.50504> }}
union{cone{<3.51245,22.2405,5.95605> ,0.12096,<3.64755,24.9756,7.88424> ,0.11232}
sphere{<3.51245,22.2405,5.95605> ,0.12096}
texture{txttree matrix <0.998782,-0.0493323,0,0.0403365,0.816654,0.575716,-0.0284014,-0.575015,0.81765,3.51245,22.2405,5.95605> }}
union{cone{<3.64755,24.9756,7.88424> ,0.11232,<3.80843,28.4007,7.9266> ,0.10368}
sphere{<3.64755,24.9756,7.88424> ,0.11232}
texture{txttree matrix <0.998899,-0.0469211,0,0.0469175,0.998822,0.0123507,-0.00057951,-0.0123371,0.999924,3.64755,24.9756,7.88424> }}
union{cone{<3.80843,28.4007,7.9266> ,0.10368,<4.79591,31.4892,8.48089> ,0.09504}
sphere{<3.80843,28.4007,7.9266> ,0.10368}
texture{txttree matrix <0.9525,-0.30454,0,0.300185,0.93888,0.168502,-0.0513154,-0.160498,0.985701,3.80843,28.4007,7.9266> }}
union{cone{<4.79591,31.4892,8.48089> ,0.09504,<4.12022,34.5997,8.41127> ,0.0864}
sphere{<4.79591,31.4892,8.48089> ,0.09504}
texture{txttree matrix <0.977209,0.21228,0,-0.21223,0.976975,-0.0218693,-0.00464243,0.0213709,0.999761,4.79591,31.4892,8.48089> }}
union{cone{<4.12022,34.5997,8.41127> ,0.0864,<4.10851,37.9174,8.23458> ,0.07776}
sphere{<4.12022,34.5997,8.41127> ,0.0864}
texture{txttree matrix <0.999994,0.00352997,0,-0.00352498,0.998579,-0.0531808,-0.000187727,0.0531804,0.998585,4.12022,34.5997,8.41127> }}
union{cone{<2.09404,9.55704,1.75678> ,0.1296,<1.12796,12.5805,1.00435> ,0.12096}
sphere{<2.09404,9.55704,1.75678> ,0.1296}
texture{txttree matrix <0.952554,0.30437,0,-0.296162,0.926867,-0.230665,-0.0702075,0.219721,0.973033,2.09404,9.55704,1.75678> }}
union{cone{<1.12796,12.5805,1.00435> ,0.12096,<1.93672,15.7326,0.149917> ,0.11232}
sphere{<1.12796,12.5805,1.00435> ,0.12096}
texture{txttree matrix <0.968626,-0.248525,0,0.240377,0.936871,-0.25395,0.0631129,0.245983,0.967217,1.12796,12.5805,1.00435> }}
union{cone{<1.93672,15.7326,0.149917> ,0.11232,<1.3201,19.0795,-0.166926> ,0.10368}
sphere{<1.93672,15.7326,0.149917> ,0.11232}
texture{txttree matrix <0.983448,0.181188,0,-0.180408,0.979214,-0.0927003,-0.0167962,0.091166,0.995694,1.93672,15.7326,0.149917> }}
union{cone{<1.3201,19.0795,-0.166926> ,0.10368,<1.99796,22.3919,-0.410539> ,0.09504}
sphere{<1.3201,19.0795,-0.166926> ,0.10368}
texture{txttree matrix <0.979697,-0.200485,0,0.199967,0.977164,-0.0718658,0.014408,0.0704067,0.997414,1.3201,19.0795,-0.166926> }}
union{cone{<1.99796,22.3919,-0.410539> ,0.09504,<1.38806,25.5325,-1.32324> ,0.0864}
sphere{<1.99796,22.3919,-0.410539> ,0.09504}
texture{txttree matrix <0.98166,0.190638,0,-0.183324,0.943996,-0.274343,-0.0523003,0.269312,0.961632,1.99796,22.3919,-0.410539> }}
union{cone{<1.38806,25.5325,-1.32324> ,0.0864,<1.00346,28.5209,-2.66937> ,0.07776}
sphere{<1.38806,25.5325,-1.32324> ,0.0864}
texture{txttree matrix <0.99182,0.127647,0,-0.116545,0.905553,-0.40791,-0.0520685,0.404573,0.913022,1.38806,25.5325,-1.32324> }}
union{cone{<1.92221,10.2557,2.0383> ,0.1296,<2.97461,13.2598,1.78878> ,0.12096}
sphere{<1.92221,10.2557,2.0383> ,0.1296}
texture{txttree matrix <0.943762,-0.330625,0,0.329614,0.940876,-0.0781497,0.0258383,0.0737548,0.996942,1.92221,10.2557,2.0383> }}
union{cone{<2.97461,13.2598,1.78878> ,0.12096,<2.83043,16.4808,2.28039> ,0.11232}
sphere{<2.97461,13.2598,1.78878> ,0.12096}
texture{txttree matrix <0.999,0.044719,0,-0.0442081,0.987586,0.15073,0.00674049,-0.150579,0.988575,2.97461,13.2598,1.78878> }}
union{cone{<2.83043,16.4808,2.28039> ,0.11232,<2.43368,19.6097,1.68879> ,0.10368}
sphere{<2.83043,16.4808,2.28039> ,0.11232}
texture{txttree matrix <0.992057,0.125791,0,-0.123635,0.975052,-0.184356,-0.0231904,0.182892,0.98286,2.83043,16.4808,2.28039> }}
union{cone{<2.43368,19.6097,1.68879> ,0.10368,<1.89865,22.8671,1.0257> ,0.09504}
sphere{<2.43368,19.6097,1.68879> ,0.10368}
texture{txttree matrix <0.986778,0.162079,0,-0.158905,0.967452,-0.19694,-0.0319198,0.194336,0.980416,2.43368,19.6097,1.68879> }}
union{cone{<1.89865,22.8671,1.0257> ,0.09504,<1.93659,25.8946,-0.362557> ,0.0864}
sphere{<1.89865,22.8671,1.0257> ,0.09504}
texture{txttree matrix <0.999921,-0.012532,0,0.0113916,0.908927,-0.416799,0.00522332,0.416766,0.908999,1.89865,22.8671,1.0257> }}
union{cone{<1.93659,25.8946,-0.362557> ,0.0864,<2.54057,28.767,-1.82186> ,0.07776}
sphere{<1.93659,25.8946,-0.362557> ,0.0864}
texture{txttree matrix <0.9786,-0.205771,0,0.184255,0.876275,-0.445187,0.0916065,0.43566,0.895437,1.93659,25.8946,-0.362557> }}
union{cone{<2.68871,14.923,2.98056> ,0.1296,<3.04502,18.1947,3.63498> ,0.12096}
sphere{<2.68871,14.923,2.98056> ,0.1296}
texture{txttree matrix <0.994122,-0.108267,0,0.106188,0.975031,0.195033,-0.0211156,-0.193887,0.980797,2.68871,14.923,2.98056> }}
union{cone{<3.04502,18.1947,3.63498> ,0.12096,<1.67883,21.1038,3.57888> ,0.11232}
sphere{<3.04502,18.1947,3.63498> ,0.12096}
texture{txttree matrix <0.905155,0.425082,0,-0.425017,0.905017,-0.0174542,-0.00741947,0.0157988,0.999848,3.04502,18.1947,3.63498> }}
union{cone{<1.67883,21.1038,3.57888> ,0.11232,<1.88612,24.2033,2.48377> ,0.10368}
sphere{<1.67883,21.1038,3.57888> ,0.11232}
texture{txttree matrix <0.997771,-0.0667336,0,0.0629372,0.941008,-0.332481,0.0221877,0.33174,0.94311,1.67883,21.1038,3.57888> }}
union{cone{<1.88612,24.2033,2.48377> ,0.10368,<1.66362,27.477,2.02703> ,0.09504}
sphere{<1.88612,24.2033,2.48377> ,0.10368}
texture{txttree matrix <0.997698,0.0678089,0,-0.0671614,0.988171,-0.137865,-0.00934849,0.137548,0.990451,1.88612,24.2033,2.48377> }}
union{cone{<1.66362,27.477,2.02703> ,0.09504,<1.86543,30.3756,0.851706> ,0.0864}
sphere{<1.66362,27.477,2.02703> ,0.09504}
texture{txttree matrix <0.997585,-0.0694554,0,0.0643871,0.92479,-0.374991,0.0260452,0.374086,0.927028,1.66362,27.477,2.02703> }}
union{cone{<1.86543,30.3756,0.851706> ,0.0864,<1.95523,33.3496,-0.439239> ,0.07776}
sphere{<1.86543,30.3756,0.851706> ,0.0864}
texture{txttree matrix <0.999544,-0.030182,0,0.0276882,0.916956,-0.398027,0.0120132,0.397845,0.917374,1.86543,30.3756,0.851706> }}
union{cone{<2.15334,5.74658,1.40368> ,0.216,<3.17605,7.17494,1.63401> ,0.203657}
sphere{<2.15334,5.74658,1.40368> ,0.216}
texture{txttree matrix <0.813073,-0.582162,0,0.577222,0.806173,0.13,-0.0756808,-0.105699,0.991514,2.15334,5.74658,1.40368> }}
union{cone{<3.17605,7.17494,1.63401> ,0.203657,<4.02517,8.69258,1.58909> ,0.191314}
sphere{<3.17605,7.17494,1.63401> ,0.203657}
texture{txttree matrix <0.872691,-0.488273,0,0.48811,0.8724,-0.0258204,0.0126074,0.0225333,0.999667,3.17605,7.17494,1.63401> }}
union{cone{<4.02517,8.69258,1.58909> ,0.191314,<4.94548,10.2096,1.99404> ,0.178971}
sphere{<4.02517,8.69258,1.58909> ,0.191314}
texture{txttree matrix <0.854966,-0.518685,0,0.505682,0.833533,0.222506,-0.11541,-0.190235,0.974931,4.02517,8.69258,1.58909> }}
union{cone{<4.94548,10.2096,1.99404> ,0.178971,<5.41974,11.9707,1.95777> ,0.166629}
sphere{<4.94548,10.2096,1.99404> ,0.178971}
texture{txttree matrix <0.965601,-0.260028,0,0.259976,0.96541,-0.0198806,0.00516951,0.0191967,0.999802,4.94548,10.2096,1.99404> }}
union{cone{<5.41974,11.9707,1.95777> ,0.166629,<6.0387,13.5054,2.45456> ,0.154286}
sphere{<5.41974,11.9707,1.95777> ,0.166629}
texture{txttree matrix <0.927413,-0.374039,0,0.358244,0.888248,0.287536,-0.10755,-0.266665,0.95777,5.41974,11.9707,1.95777> }}
union{cone{<6.0387,13.5054,2.45456> ,0.154286,<6.77597,15.0035,1.99317> ,0.141943}
sphere{<6.0387,13.5054,2.45456> ,0.154286}
texture{txttree matrix <0.897228,-0.441567,0,0.425615,0.864816,-0.266355,0.117613,0.238981,0.963875,6.0387,13.5054,2.45456> }}
union{cone{<6.77597,15.0035,1.99317> ,0.141943,<7.41547,16.6371,2.20636> ,0.1296}
sphere{<6.77597,15.0035,1.99317> ,0.141943}
texture{txttree matrix <0.931195,-0.364521,0,0.361859,0.924395,0.120636,-0.0439742,-0.112335,0.992697,6.77597,15.0035,1.99317> }}
union{cone{<7.41547,16.6371,2.20636> ,0.1296,<9.11299,18.4859,4.11848> ,0.12096}
sphere{<7.41547,16.6371,2.20636> ,0.1296}
texture{txttree matrix <0.736599,-0.67633,0,0.537994,0.585935,0.606006,-0.40986,-0.446383,0.79546,7.41547,16.6371,2.20636> }}
union{cone{<9.11299,18.4859,4.11848> ,0.12096,<9.30224,21.5122,5.46336> ,0.11232}
sphere{<9.11299,18.4859,4.11848> ,0.12096}
texture{txttree matrix <0.998051,-0.06241,0,0.0570505,0.912342,0.405436,-0.0253033,-0.404645,0.914124,9.11299,18.4859,4.11848> }}
union{cone{<9.30224,21.5122,5.46336> ,0.11232,<10.4225,24.5112,6.41133> ,0.10368}
sphere{<9.30224,21.5122,5.46336> ,0.11232}
texture{txttree matrix <0.93677,-0.349946,0,0.335544,0.898218,0.283927,-0.0993592,-0.265975,0.958846,9.30224,21.5122,5.46336> }}
union{cone{<10.4225,24.5112,6.41133> ,0.10368,<11.9849,27.3207,6.64047> ,0.09504}
sphere{<10.4225,24.5112,6.41133> ,0.10368}
texture{txttree matrix <0.873957,-0.486003,0,0.484773,0.871745,0.0710972,-0.0345534,-0.0621359,0.997469,10.4225,24.5112,6.41133> }}
union{cone{<11.9849,27.3207,6.64047> ,0.09504,<12.0606,30.5269,6.96713> ,0.0864}
sphere{<11.9849,27.3207,6.64047> ,0.09504}
texture{txttree matrix <0.999721,-0.0236127,0,0.0234912,0.994575,0.101332,-0.00239273,-0.101304,0.994853,11.9849,27.3207,6.64047> }}
union{cone{<12.0606,30.5269,6.96713> ,0.0864,<13.1401,33.6456,6.54898> ,0.07776}
sphere{<12.0606,30.5269,6.96713> ,0.0864}
texture{txttree matrix <0.944995,-0.327085,0,0.324491,0.9375,-0.125697,0.0411138,0.118783,0.992069,12.0606,30.5269,6.96713> }}
union{cone{<2.23831,5.86525,1.42281> ,0.1296,<4.58521,7.90365,2.72425> ,0.12096}
sphere{<2.23831,5.86525,1.42281> ,0.1296}
texture{txttree matrix <0.655742,-0.754985,0,0.696414,0.604871,0.386184,-0.291563,-0.253237,0.922422,2.23831,5.86525,1.42281> }}
union{cone{<4.58521,7.90365,2.72425> ,0.12096,<6.10942,10.8263,3.10413> ,0.11232}
sphere{<4.58521,7.90365,2.72425> ,0.12096}
texture{txttree matrix <0.886665,-0.462412,0,0.459372,0.880834,0.114493,-0.0529429,-0.101517,0.993424,4.58521,7.90365,2.72425> }}
union{cone{<6.10942,10.8263,3.10413> ,0.11232,<8.54933,12.6276,2.23727> ,0.10368}
sphere{<6.10942,10.8263,3.10413> ,0.11232}
texture{txttree matrix <0.593944,-0.804507,0,0.773529,0.571074,-0.274823,0.221097,0.163229,0.961495,6.10942,10.8263,3.10413> }}
union{cone{<8.54933,12.6276,2.23727> ,0.10368,<10.2105,15.4129,2.5764> ,0.09504}
sphere{<8.54933,12.6276,2.23727> ,0.10368}
texture{txttree matrix <0.85886,-0.512211,0,0.509433,0.854202,0.104003,-0.0532712,-0.0893236,0.994577,8.54933,12.6276,2.23727> }}
union{cone{<10.2105,15.4129,2.5764> ,0.09504,<11.4363,18.4115,1.43601> ,0.0864}
sphere{<10.2105,15.4129,2.5764> ,0.09504}
texture{txttree matrix <0.925642,-0.3784,0,0.356929,0.873121,-0.332057,0.12565,0.307366,0.943259,10.2105,15.4129,2.5764> }}
union{cone{<11.4363,18.4115,1.43601> ,0.0864,<13.7425,20.3785,0.662451> ,0.07776}
sphere{<11.4363,18.4115,1.43601> ,0.0864}
texture{txttree matrix <0.648928,-0.76085,0,0.737222,0.628776,-0.247274,0.188139,0.160463,0.968946,11.4363,18.4115,1.43601> }}
union{cone{<5.71691,12.7075,2.19628> ,0.1296,<7.99101,14.9492,2.71508> ,0.12096}
sphere{<5.71691,12.7075,2.19628> ,0.1296}
texture{txttree matrix <0.702014,-0.712163,0,0.702946,0.692928,0.160367,-0.114207,-0.11258,0.987058,5.71691,12.7075,2.19628> }}
union{cone{<7.99101,14.9492,2.71508> ,0.12096,<9.78531,17.7862,2.91177> ,0.11232}
sphere{<7.99101,14.9492,2.71508> ,0.12096}
texture{txttree matrix <0.84515,-0.534529,0,0.533614,0.843703,0.0584924,-0.0312659,-0.0494349,0.998288,7.99101,14.9492,2.71508> }}
union{cone{<9.78531,17.7862,2.91177> ,0.11232,<10.4185,20.9435,3.07085> ,0.10368}
sphere{<9.78531,17.7862,2.91177> ,0.11232}
texture{txttree matrix <0.980478,-0.196627,0,0.196388,0.979284,0.0493428,-0.00970216,-0.0483796,0.998782,9.78531,17.7862,2.91177> }}
union{cone{<10.4185,20.9435,3.07085> ,0.10368,<11.7782,23.8652,2.64375> ,0.09504}
sphere{<10.4185,20.9435,3.07085> ,0.10368}
texture{txttree matrix <0.906623,-0.421942,0,0.418284,0.898764,-0.131385,0.0554369,0.119117,0.991331,10.4185,20.9435,3.07085> }}
union{cone{<11.7782,23.8652,2.64375> ,0.09504,<12.495,26.7536,0.955598> ,0.0864}
sphere{<11.7782,23.8652,2.64375> ,0.09504}
texture{txttree matrix <0.970565,-0.240839,0,0.209483,0.844202,-0.493396,0.118829,0.478873,0.869805,11.7782,23.8652,2.64375> }}
union{cone{<12.495,26.7536,0.955598> ,0.0864,<13.707,29.9166,0.404931> ,0.07776}
sphere{<12.495,26.7536,0.955598> ,0.0864}
texture{txttree matrix <0.933788,-0.357828,0,0.353191,0.921687,-0.160465,0.0574189,0.14984,0.987041,12.495,26.7536,0.955598> }}
union{cone{<7.08668,15.7972,2.09675> ,0.1296,<8.06741,18.7615,2.13157> ,0.12096}
sphere{<7.08668,15.7972,2.09675> ,0.1296}
texture{txttree matrix <0.949389,-0.314102,0,0.314083,0.94933,0.0111527,-0.00350309,-0.0105883,0.999938,7.08668,15.7972,2.09675> }}
union{cone{<8.06741,18.7615,2.13157> ,0.12096,<7.55811,21.7394,0.931452> ,0.11232}
sphere{<8.06741,18.7615,2.13157> ,0.12096}
texture{txttree matrix <0.985688,0.168579,0,-0.15667,0.916056,-0.369182,-0.0622363,0.363898,0.929357,8.06741,18.7615,2.13157> }}
union{cone{<7.55811,21.7394,0.931452> ,0.11232,<7.35884,24.6857,-0.356925> ,0.10368}
sphere{<7.55811,21.7394,0.931452> ,0.11232}
texture{txttree matrix <0.997721,0.0674776,0,-0.0618478,0.914479,-0.39988,-0.0269829,0.398968,0.916568,7.55811,21.7394,0.931452> }}
union{cone{<7.35884,24.6857,-0.356925> ,0.10368,<8.24515,27.8333,-0.991114> ,0.09504}
sphere{<7.35884,24.6857,-0.356925> ,0.10368}
texture{txttree matrix <0.962568,-0.271041,0,0.266083,0.94496,-0.190393,0.0516044,0.183266,0.981708,7.35884,24.6857,-0.356925> }}
union{cone{<8.24515,27.8333,-0.991114> ,0.09504,<8.83674,30.5489,-2.41688> ,0.0864}
sphere{<8.24515,27.8333,-0.991114> ,0.09504}
texture{txttree matrix <0.977082,-0.212862,0,0.189394,0.869358,-0.456449,0.0971606,0.445989,0.889749,8.24515,27.8333,-0.991114> }}
union{cone{<8.83674,30.5489,-2.41688> ,0.0864,<9.39103,33.4002,-3.98091> ,0.07776}
sphere{<8.83674,30.5489,-2.41688> ,0.0864}
texture{txttree matrix <0.981624,-0.190826,0,0.168017,0.864294,-0.474094,0.0904695,0.465382,0.880474,8.83674,30.5489,-2.41688> }}
union{cone{<5.12682,10.8829,1.98017> ,0.1296,<5.4996,14.2041,1.45291> ,0.12096}
sphere{<5.12682,10.8829,1.98017> ,0.1296}
texture{txttree matrix <0.99376,-0.111542,0,0.11018,0.981618,-0.155838,0.0173826,0.154866,0.987783,5.12682,10.8829,1.98017> }}
union{cone{<5.4996,14.2041,1.45291> ,0.12096,<4.82753,17.246,0.673846> ,0.11232}
sphere{<5.4996,14.2041,1.45291> ,0.12096}
texture{txttree matrix <0.976452,0.215736,0,-0.209291,0.94728,-0.242608,-0.0523393,0.236895,0.970124,5.4996,14.2041,1.45291> }}
union{cone{<4.82753,17.246,0.673846> ,0.11232,<4.79113,20.4166,-0.50401> ,0.10368}
sphere{<4.82753,17.246,0.673846> ,0.11232}
texture{txttree matrix <0.999934,0.0114796,0,-0.0107611,0.937351,-0.348221,-0.00399742,0.348198,0.937412,4.82753,17.246,0.673846> }}
union{cone{<4.79113,20.4166,-0.50401> ,0.10368,<5.27964,23.7992,-0.464732> ,0.09504}
sphere{<4.79113,20.4166,-0.50401> ,0.10368}
texture{txttree matrix <0.989732,-0.142936,0,0.142926,0.989667,0.0114918,-0.00164259,-0.0113738,0.999934,4.79113,20.4166,-0.50401> }}
union{cone{<5.27964,23.7992,-0.464732> ,0.09504,<4.4739,26.8687,-0.555789> ,0.0864}
sphere{<5.27964,23.7992,-0.464732> ,0.09504}
texture{txttree matrix <0.96723,0.253901,0,-0.253796,0.966832,-0.0286817,-0.0072823,0.0277418,0.999589,5.27964,23.7992,-0.464732> }}
union{cone{<4.4739,26.8687,-0.555789> ,0.0864,<3.77169,30.0421,-1.53187> ,0.07776}
sphere{<4.4739,26.8687,-0.555789> ,0.0864}
texture{txttree matrix <0.976381,0.216055,0,-0.206925,0.935122,-0.287626,-0.0621431,0.280833,0.957743,4.4739,26.8687,-0.555789> }}
union{cone{<1.37321,1.90898,0.489722> ,0.216,<1.63453,3.3896,-0.349055> ,0.203657}
sphere{<1.37321,1.90898,0.489722> ,0.216}
texture{txttree matrix <0.98478,-0.173807,0,0.151785,0.860002,-0.487194,0.0846779,0.479778,0.873294,1.37321,1.90898,0.489722> }}
union{cone{<1.63453,3.3896,-0.349055> ,0.203657,<2.46951,4.70273,-1.20354> ,0.191314}
sphere{<1.63453,3.3896,-0.349055> ,0.203657}
texture{txttree matrix <0.84385,-0.536579,0,0.470335,0.739672,-0.481321,0.258267,0.406163,0.876544,1.63453,3.3896,-0.349055> }}
union{cone{<2.46951,4.70273,-1.20354> ,0.191314,<3.43482,6.1043,-1.76451> ,0.178971}
sphere{<2.46951,4.70273,-1.20354> ,0.191314}
texture{txttree matrix <0.823567,-0.567219,0,0.538707,0.782169,-0.313061,0.177574,0.257826,0.949733,2.46951,4.70273,-1.20354> }}
union{cone{<3.43482,6.1043,-1.76451> ,0.178971,<3.40339,7.86242,-2.20456> ,0.166629}
sphere{<3.43482,6.1043,-1.76451> ,0.178971}
texture{txttree matrix <0.99984,0.017876,0,-0.0173412,0.969929,-0.242771,-0.00433978,0.242732,0.970084,3.43482,6.1043,-1.76451> }}
union{cone{<3.40339,7.86242,-2.20456> ,0.166629,<4.06617,9.14464,-3.06027> ,0.154286}
sphere{<3.40339,7.86242,-2.20456> ,0.166629}
texture{txttree matrix <0.88834,-0.459187,0,0.39499,0.764147,-0.509963,0.234168,0.453021,0.860196,3.40339,7.86242,-2.20456> }}
union{cone{<4.06617,9.14464,-3.06027> ,0.154286,<4.65116,10.5507,-3.74842> ,0.141943}
sphere{<4.06617,9.14464,-3.06027> ,0.154286}
texture{txttree matrix <0.923279,-0.384131,0,0.350052,0.841367,-0.411783,0.158179,0.380191,0.911282,4.06617,9.14464,-3.06027> }}
union{cone{<4.65116,10.5507,-3.74842> ,0.141943,<4.75741,12.2857,-4.2342> ,0.1296}
sphere{<4.65116,10.5507,-3.74842> ,0.141943}
texture{txttree matrix <0.99813,-0.0611243,0,0.0588688,0.961299,-0.269146,0.0164514,0.268643,0.963099,4.65116,10.5507,-3.74842> }}
union{cone{<4.75741,12.2857,-4.2342> ,0.1296,<4.43136,15.3961,-4.76108> ,0.12096}
sphere{<4.75741,12.2857,-4.2342> ,0.1296}
texture{txttree matrix <0.994551,0.104254,0,-0.102805,0.98073,-0.166131,-0.0173198,0.165226,0.986104,4.75741,12.2857,-4.2342> }}
union{cone{<4.43136,15.3961,-4.76108> ,0.12096,<5.27135,18.3005,-5.94637> ,0.11232}
sphere{<4.43136,15.3961,-4.76108> ,0.12096}
texture{txttree matrix <0.960632,-0.277823,0,0.258657,0.894362,-0.364984,0.101401,0.350616,0.931014,4.43136,15.3961,-4.76108> }}
union{cone{<5.27135,18.3005,-5.94637> ,0.11232,<5.72676,21.5133,-5.55092> ,0.10368}
sphere{<5.27135,18.3005,-5.94637> ,0.11232}
texture{txttree matrix <0.990102,-0.140349,0,0.139318,0.982831,0.120973,-0.0169784,-0.119776,0.992656,5.27135,18.3005,-5.94637> }}
union{cone{<5.72676,21.5133,-5.55092> ,0.10368,<5.48951,24.3063,-7.15317> ,0.09504}
sphere{<5.72676,21.5133,-5.55092> ,0.10368}
texture{txttree matrix <0.996411,0.0846417,0,-0.0734838,0.865059,-0.496259,-0.0420042,0.494478,0.868175,5.72676,21.5133,-5.55092> }}
union{cone{<5.48951,24.3063,-7.15317> ,0.09504,<5.92609,27.467,-7.53032> ,0.0864}
sphere{<5.48951,24.3063,-7.15317> ,0.09504}
texture{txttree matrix <0.990595,-0.136829,0,0.135883,0.983746,-0.117386,0.0160617,0.116282,0.993086,5.48951,24.3063,-7.15317> }}
union{cone{<5.92609,27.467,-7.53032> ,0.0864,<6.37492,30.0886,-9.20663> ,0.07776}
sphere{<5.92609,27.467,-7.53032> ,0.0864}
texture{txttree matrix <0.98566,-0.168745,0,0.142759,0.833868,-0.533183,0.0899723,0.525537,0.846,5.92609,27.467,-7.53032> }}
union{cone{<4.6614,10.7179,-3.79523> ,0.1296,<6.00258,13.6159,-3.18069> ,0.12096}
sphere{<4.6614,10.7179,-3.79523> ,0.1296}
texture{txttree matrix <0.907525,-0.419998,0,0.41243,0.891172,0.188981,-0.0793715,-0.171505,0.981981,4.6614,10.7179,-3.79523> }}
union{cone{<6.00258,13.6159,-3.18069> ,0.12096,<6.39865,16.5607,-4.71625> ,0.11232}
sphere{<6.00258,13.6159,-3.18069> ,0.12096}
texture{txttree matrix <0.991076,-0.133298,0,0.118419,0.880452,-0.459109,0.0611982,0.455011,0.88838,6.00258,13.6159,-3.18069> }}
union{cone{<6.39865,16.5607,-4.71625> ,0.11232,<6.65408,19.9157,-5.33533> ,0.10368}
sphere{<6.39865,16.5607,-4.71625> ,0.11232}
texture{txttree matrix <0.997114,-0.0759145,0,0.0746613,0.980653,-0.180956,0.0137372,0.180433,0.983491,6.39865,16.5607,-4.71625> }}
union{cone{<6.65408,19.9157,-5.33533> ,0.10368,<7.07686,23.1666,-6.33828> ,0.09504}
sphere{<6.65408,19.9157,-5.33533> ,0.10368}
texture{txttree matrix <0.991649,-0.128965,0,0.123323,0.948264,-0.292551,0.0377288,0.290108,0.95625,6.65408,19.9157,-5.33533> }}
union{cone{<7.07686,23.1666,-6.33828> ,0.09504,<8.15964,25.8796,-7.42422> ,0.0864}
sphere{<7.07686,23.1666,-6.33828> ,0.09504}
texture{txttree matrix <0.928764,-0.370672,0,0.347441,0.870554,-0.348455,0.129163,0.323632,0.937325,7.07686,23.1666,-6.33828> }}
union{cone{<8.15964,25.8796,-7.42422> ,0.0864,<8.52659,28.3785,-9.37339> ,0.07776}
sphere{<8.15964,25.8796,-7.42422> ,0.0864}
texture{txttree matrix <0.98939,-0.145286,0,0.115018,0.783266,-0.610954,0.0887628,0.604472,0.791666,8.15964,25.8796,-7.42422> }}
union{cone{<3.42135,6.85764,-1.95307> ,0.1296,<5.1232,8.83161,-4.13624> ,0.12096}
sphere{<3.42135,6.85764,-1.95307> ,0.1296}
texture{txttree matrix <0.757382,-0.652973,0,0.500563,0.580602,-0.642136,0.419297,0.486342,0.766591,3.42135,6.85764,-1.95307> }}
union{cone{<5.1232,8.83161,-4.13624> ,0.12096,<5.52289,10.9721,-6.79634> ,0.11232}
sphere{<5.1232,8.83161,-4.13624> ,0.12096}
texture{txttree matrix <0.983009,-0.183557,0,0.116269,0.62266,-0.773806,0.142038,0.760659,0.633422,5.1232,8.83161,-4.13624> }}
union{cone{<5.52289,10.9721,-6.79634> ,0.11232,<5.394,13.634,-8.43833> ,0.10368}
sphere{<5.52289,10.9721,-6.79634> ,0.11232}
texture{txttree matrix <0.99883,0.0483651,0,-0.0411771,0.850383,-0.52455,-0.0253699,0.523936,0.85138,5.52289,10.9721,-6.79634> }}
union{cone{<5.394,13.634,-8.43833> ,0.10368,<5.93259,16.0546,-10.6896> ,0.09504}
sphere{<5.394,13.634,-8.43833> ,0.10368}
texture{txttree matrix <0.976128,-0.217196,0,0.16081,0.722717,-0.672176,0.145994,0.656129,0.740392,5.394,13.634,-8.43833> }}
union{cone{<5.93259,16.0546,-10.6896> ,0.09504,<5.92743,18.9149,-12.2907> ,0.0864}
sphere{<5.93259,16.0546,-10.6896> ,0.09504}
texture{txttree matrix <0.999998,0.00180396,0,-0.00157413,0.872597,-0.488438,-0.000881121,0.488437,0.872598,5.93259,16.0546,-10.6896> }}
union{cone{<5.92743,18.9149,-12.2907> ,0.0864,<5.628,21.5168,-14.2542> ,0.07776}
sphere{<5.92743,18.9149,-12.2907> ,0.0864}
texture{txttree matrix <0.993443,0.114329,0,-0.0914762,0.79487,-0.599845,-0.0685795,0.595912,0.800116,5.92743,18.9149,-12.2907> }}
union{cone{<1.42555,2.20555,0.321713> ,0.1296,<0.707537,4.69243,-1.7973> ,0.12096}
sphere{<1.42555,2.20555,0.321713> ,0.1296}
texture{txttree matrix <0.960757,0.277391,0,-0.214641,0.743418,-0.63345,-0.175713,0.608591,0.773784,1.42555,2.20555,0.321713> }}
union{cone{<0.707537,4.69243,-1.7973> ,0.12096,<-0.437461,6.99721,-3.85915> ,0.11232}
sphere{<0.707537,4.69243,-1.7973> ,0.12096}
texture{txttree matrix <0.895573,0.444915,0,-0.34722,0.698922,-0.625257,-0.278186,0.559963,0.780419,0.707537,4.69243,-1.7973> }}
union{cone{<-0.437461,6.99721,-3.85915> ,0.11232,<-0.775519,10.0963,-4.34593> ,0.10368}
sphere{<-0.437461,6.99721,-3.85915> ,0.11232}
texture{txttree matrix <0.994103,0.108441,0,-0.107142,0.982201,-0.154278,-0.0167299,0.153368,0.988028,-0.437461,6.99721,-3.85915> }}
union{cone{<-0.775519,10.0963,-4.34593> ,0.10368,<-0.726183,13.1869,-5.20958> ,0.09504}
sphere{<-0.775519,10.0963,-4.34593> ,0.10368}
texture{txttree matrix <0.999873,-0.0159611,0,0.0153723,0.96299,-0.269097,0.00429509,0.269063,0.963113,-0.775519,10.0963,-4.34593> }}
union{cone{<-0.726183,13.1869,-5.20958> ,0.09504,<-0.482271,16.3085,-6.48096> ,0.0864}
sphere{<-0.726183,13.1869,-5.20958> ,0.09504}
texture{txttree matrix <0.996961,-0.0778991,0,0.0721761,0.923717,-0.376214,0.0293067,0.375071,0.926533,-0.726183,13.1869,-5.20958> }}
union{cone{<-0.482271,16.3085,-6.48096> ,0.0864,<-1.43491,18.8847,-7.97848> ,0.07776}
sphere{<-0.482271,16.3085,-6.48096> ,0.0864}
texture{txttree matrix <0.937928,0.346831,0,-0.304512,0.823487,-0.478687,-0.166023,0.448974,0.877985,-0.482271,16.3085,-6.48096> }}
union{cone{<1.49416,2.45973,0.621779> ,0.216,<2.14509,4.07123,0.856941> ,0.203657}
sphere{<1.49416,2.45973,0.621779> ,0.216}
texture{txttree matrix <0.927214,-0.374531,0,0.371149,0.918841,0.134084,-0.0502187,-0.124325,0.99097,1.49416,2.45973,0.621779> }}
union{cone{<2.14509,4.07123,0.856941> ,0.203657,<2.09441,5.70426,0.351005> ,0.191314}
sphere{<2.14509,4.07123,0.856941> ,0.203657}
texture{txttree matrix <0.999519,0.0310187,0,-0.0296305,0.954788,-0.295807,-0.00917554,0.295665,0.955248,2.14509,4.07123,0.856941> }}
union{cone{<2.09441,5.70426,0.351005> ,0.191314,<2.48452,7.3691,0.252095> ,0.178971}
sphere{<2.09441,5.70426,0.351005> ,0.191314}
texture{txttree matrix <0.973628,-0.228141,0,0.227761,0.972003,-0.0577481,0.0131747,0.0562252,0.998331,2.09441,5.70426,0.351005> }}
union{cone{<2.48452,7.3691,0.252095> ,0.178971,<2.79975,9.01288,0.0345077> ,0.166629}
sphere{<2.48452,7.3691,0.252095> ,0.178971}
texture{txttree matrix <0.982104,-0.188337,0,0.186765,0.973909,-0.128916,0.0242797,0.126609,0.991655,2.48452,7.3691,0.252095> }}
union{cone{<2.79975,9.01288,0.0345077> ,0.166629,<3.23542,10.7343,-0.312201> ,0.154286}
sphere{<2.79975,9.01288,0.0345077> ,0.166629}
texture{txttree matrix <0.969435,-0.24535,0,0.240803,0.951468,-0.191631,0.0470165,0.185773,0.981467,2.79975,9.01288,0.0345077> }}
union{cone{<3.23542,10.7343,-0.312201> ,0.154286,<3.78398,12.2447,-1.08214> ,0.141943}
sphere{<3.23542,10.7343,-0.312201> ,0.154286}
texture{txttree matrix <0.939929,-0.34137,0,0.307857,0.847655,-0.432094,0.147504,0.406137,0.901829,3.23542,10.7343,-0.312201> }}
union{cone{<3.78398,12.2447,-1.08214> ,0.141943,<4.3451,13.7252,-1.79553> ,0.1296}
sphere{<3.78398,12.2447,-1.08214> ,0.141943}
texture{txttree matrix <0.935092,-0.354405,0,0.323119,0.852545,-0.410806,0.145592,0.384142,0.911723,3.78398,12.2447,-1.08214> }}
union{cone{<4.3451,13.7252,-1.79553> ,0.1296,<4.56927,17.0691,-2.40512> ,0.12096}
sphere{<4.3451,13.7252,-1.79553> ,0.1296}
texture{txttree matrix <0.99776,-0.0668898,0,0.06581,0.981653,-0.178957,0.0119704,0.178556,0.983857,4.3451,13.7252,-1.79553> }}
union{cone{<4.56927,17.0691,-2.40512> ,0.12096,<5.65386,19.9482,-3.53905> ,0.11232}
sphere{<4.56927,17.0691,-2.40512> ,0.12096}
texture{txttree matrix <0.935801,-0.352527,0,0.330776,0.878061,-0.345826,0.121913,0.323625,0.938298,4.56927,17.0691,-2.40512> }}
union{cone{<5.65386,19.9482,-3.53905> ,0.11232,<7.10174,22.6532,-4.75072> ,0.10368}
sphere{<5.65386,19.9482,-3.53905> ,0.11232}
texture{txttree matrix <0.881652,-0.4719,0,0.438914,0.820025,-0.367306,0.173332,0.323836,0.9301,5.65386,19.9482,-3.53905> }}
union{cone{<7.10174,22.6532,-4.75072> ,0.10368,<7.56783,25.5076,-6.18409> ,0.09504}
sphere{<7.10174,22.6532,-4.75072> ,0.10368}
texture{txttree matrix <0.986929,-0.161154,0,0.144393,0.884287,-0.444058,0.0715616,0.438254,0.895998,7.10174,22.6532,-4.75072> }}
union{cone{<7.56783,25.5076,-6.18409> ,0.09504,<8.69709,28.1019,-7.76731> ,0.0864}
sphere{<7.56783,25.5076,-6.18409> ,0.09504}
texture{txttree matrix <0.916902,-0.399112,0,0.348294,0.800156,-0.488304,0.194888,0.447727,0.872673,7.56783,25.5076,-6.18409> }}
union{cone{<8.69709,28.1019,-7.76731> ,0.0864,<9.46424,30.9301,-9.47779> ,0.07776}
sphere{<8.69709,28.1019,-7.76731> ,0.0864}
texture{txttree matrix <0.965124,-0.261793,0,0.226094,0.833516,-0.504115,0.131974,0.486534,0.863636,8.69709,28.1019,-7.76731> }}
union{cone{<3.82051,12.3411,-1.12857> ,0.1296,<5.37879,14.8914,-2.36037> ,0.12096}
sphere{<3.82051,12.3411,-1.12857> ,0.1296}
texture{txttree matrix <0.853313,-0.521399,0,0.48206,0.788931,-0.381059,0.198684,0.325162,0.924551,3.82051,12.3411,-1.12857> }}
union{cone{<5.37879,14.8914,-2.36037> ,0.12096,<7.08714,17.0774,-4.37025> ,0.11232}
sphere{<5.37879,14.8914,-2.36037> ,0.12096}
texture{txttree matrix <0.787931,-0.615763,0,0.498659,0.638085,-0.586674,0.361252,0.462259,0.809823,5.37879,14.8914,-2.36037> }}
union{cone{<7.08714,17.0774,-4.37025> ,0.11232,<7.67374,19.2611,-6.69339> ,0.10368}
sphere{<7.08714,17.0774,-4.37025> ,0.11232}
texture{txttree matrix <0.965762,-0.259431,0,0.180946,0.673593,-0.71661,0.185911,0.692075,0.697474,7.08714,17.0774,-4.37025> }}
union{cone{<7.67374,19.2611,-6.69339> ,0.10368,<9.43749,20.8536,-9.01678> ,0.09504}
sphere{<7.67374,19.2611,-6.69339> ,0.10368}
texture{txttree matrix <0.670163,-0.742214,0,0.530701,0.479183,-0.699099,0.518881,0.46851,0.715025,7.67374,19.2611,-6.69339> }}
union{cone{<9.43749,20.8536,-9.01678> ,0.09504,<10.5599,23.374,-11.0092> ,0.0864}
sphere{<9.43749,20.8536,-9.01678> ,0.09504}
texture{txttree matrix <0.913514,-0.406808,0,0.329804,0.740597,-0.585445,0.238163,0.534812,0.810712,9.43749,20.8536,-9.01678> }}
union{cone{<10.5599,23.374,-11.0092> ,0.0864,<11.5234,25.8439,-12.7287> ,0.07776}
sphere{<10.5599,23.374,-11.0092> ,0.0864}
texture{txttree matrix <0.931621,-0.363431,0,0.304915,0.781623,-0.544144,0.197759,0.506936,0.838992,10.5599,23.374,-11.0092> }}
union{cone{<2.10362,5.40763,0.442905> ,0.1296,<1.14191,8.35722,-1.00051> ,0.12096}
sphere{<2.10362,5.40763,0.442905> ,0.1296}
texture{txttree matrix <0.950741,0.309987,0,-0.281056,0.86201,-0.421836,-0.130764,0.401057,0.906672,2.10362,5.40763,0.442905> }}
union{cone{<1.14191,8.35722,-1.00051> ,0.12096,<-0.354763,10.5536,-2.92872> ,0.11232}
sphere{<1.14191,8.35722,-1.00051> ,0.12096}
texture{txttree matrix <0.826371,0.563126,0,-0.455806,0.668883,-0.587227,-0.330683,0.485268,0.809422,1.14191,8.35722,-1.00051> }}
union{cone{<-0.354763,10.5536,-2.92872> ,0.11232,<-1.30933,13.5538,-4.04024> ,0.10368}
sphere{<-0.354763,10.5536,-2.92872> ,0.11232}
texture{txttree matrix <0.952932,0.303184,0,-0.285891,0.898579,-0.332899,-0.10093,0.31723,0.942962,-0.354763,10.5536,-2.92872> }}
union{cone{<-1.30933,13.5538,-4.04024> ,0.10368,<-1.39105,15.7492,-6.65066> ,0.09504}
sphere{<-1.30933,13.5538,-4.04024> ,0.10368}
texture{txttree matrix <0.999308,0.0371977,0,-0.0239517,0.643456,-0.765108,-0.0284603,0.764579,0.643902,-1.30933,13.5538,-4.04024> }}
union{cone{<-1.39105,15.7492,-6.65066> ,0.09504,<-1.53644,18.4343,-8.61063> ,0.0864}
sphere{<-1.39105,15.7492,-6.65066> ,0.09504}
texture{txttree matrix <0.998537,0.0540708,0,-0.0436957,0.806936,-0.58902,-0.0318488,0.588158,0.808119,-1.39105,15.7492,-6.65066> }}
union{cone{<-1.53644,18.4343,-8.61063> ,0.0864,<-1.48523,21.106,-10.6599> ,0.07776}
sphere{<-1.53644,18.4343,-8.61063> ,0.0864}
texture{txttree matrix <0.999816,-0.0191666,0,0.0152092,0.793382,-0.608534,0.0116635,0.608423,0.793527,-1.53644,18.4343,-8.61063> }}
union{cone{<1.89751,3.45831,0.767499> ,0.1296,<1.6904,6.66232,1.5113> ,0.12096}
sphere{<1.89751,3.45831,0.767499> ,0.1296}
texture{txttree matrix <0.997917,0.0645068,0,-0.0628425,0.972171,0.225687,0.0145583,-0.225217,0.9742,1.89751,3.45831,0.767499> }}
union{cone{<1.6904,6.66232,1.5113> ,0.12096,<1.93879,9.7243,0.983523> ,0.11232}
sphere{<1.6904,6.66232,1.5113> ,0.12096}
texture{txttree matrix <0.996726,-0.0808541,0,0.0796867,0.982334,-0.169321,0.0136903,0.168767,0.985561,1.6904,6.66232,1.5113> }}
union{cone{<1.93879,9.7243,0.983523> ,0.11232,<2.68361,12.8425,0.441669> ,0.10368}
sphere{<1.93879,9.7243,0.983523> ,0.11232}
texture{txttree matrix <0.972638,-0.232327,0,0.229078,0.959036,-0.166654,0.0387183,0.162094,0.986015,1.93879,9.7243,0.983523> }}
union{cone{<2.68361,12.8425,0.441669> ,0.10368,<2.33498,15.7482,-0.677851> ,0.09504}
sphere{<2.68361,12.8425,0.441669> ,0.10368}
texture{txttree matrix <0.992879,0.119127,0,-0.111264,0.927341,-0.357293,-0.0425632,0.354749,0.933992,2.68361,12.8425,0.441669> }}
union{cone{<2.33498,15.7482,-0.677851> ,0.09504,<2.5007,19.0787,-0.622907> ,0.0864}
sphere{<2.33498,15.7482,-0.677851> ,0.09504}
texture{txttree matrix <0.998764,-0.0496956,0,0.0496889,0.998629,0.0164747,-0.000818719,-0.0164543,0.999864,2.33498,15.7482,-0.677851> }}
union{cone{<2.5007,19.0787,-0.622907> ,0.0864,<2.59747,22.1891,-1.21709> ,0.07776}
sphere{<2.5007,19.0787,-0.622907> ,0.0864}
texture{txttree matrix <0.999516,-0.0310983,0,0.0305464,0.98178,-0.187551,0.00583252,0.187461,0.982255,2.5007,19.0787,-0.622907> }}
union{cone{<-0.0693945,0.561172,0.0550705> ,0.6,<0.123697,0.638673,-0.432773> ,0.573333}
sphere{<-0.0693945,0.561172,0.0550705> ,0.6}
texture{txttree matrix <0.372485,-0.928038,0,0.364076,0.146128,-0.919835,0.853642,0.342624,0.392307,-0.0693945,0.561172,0.0550705> }}
union{cone{<0.123697,0.638673,-0.432773> ,0.573333,<0.413275,0.586607,-0.847364> ,0.546667}
sphere{<0.123697,0.638673,-0.432773> ,0.573333}
texture{txttree matrix <-0.176963,-0.984218,0,0.569607,-0.102416,-0.815511,0.802641,-0.144315,0.578741,0.123697,0.638673,-0.432773> }}
union{cone{<0.413275,0.586607,-0.847364> ,0.546667,<0.614261,0.799174,-1.31527> ,0.52}
sphere{<0.413275,0.586607,-0.847364> ,0.546667}
texture{txttree matrix <0.726624,-0.687036,0,0.364216,0.385202,-0.847919,0.58255,0.616118,0.530126,0.413275,0.586607,-0.847364> }}
union{cone{<0.614261,0.799174,-1.31527> ,0.52,<0.979148,0.919666,-1.67054> ,0.493333}
sphere{<0.614261,0.799174,-1.31527> ,0.52}
texture{txttree matrix <0.313565,-0.949567,0,0.697239,0.230241,-0.678857,0.64462,0.212866,0.73427,0.614261,0.799174,-1.31527> }}
union{cone{<0.979148,0.919666,-1.67054> ,0.493333,<1.14765,1.1711,-2.09888> ,0.466667}
sphere{<0.979148,0.919666,-1.67054> ,0.493333}
texture{txttree matrix <0.830712,-0.556702,0,0.321267,0.479396,-0.816681,0.454648,0.678427,0.57709,0.979148,0.919666,-1.67054> }}
union{cone{<1.14765,1.1711,-2.09888> ,0.466667,<1.3515,1.46939,-2.50075> ,0.44}
sphere{<1.14765,1.1711,-2.09888> ,0.466667}
texture{txttree matrix <0.825622,-0.564224,0,0.377218,0.551978,-0.743657,0.419589,0.61398,0.668561,1.14765,1.1711,-2.09888> }}
union{cone{<1.3515,1.46939,-2.50075> ,0.44,<1.5018,1.55165,-2.99193> ,0.413333}
sphere{<1.3515,1.46939,-2.50075> ,0.44}
texture{txttree matrix <0.480052,-0.87724,0,0.28894,0.158116,-0.9442,0.82829,0.453264,0.329374,1.3515,1.46939,-2.50075> }}
union{cone{<1.5018,1.55165,-2.99193> ,0.413333,<1.73571,1.73063,-3.4655> ,0.386667}
sphere{<1.5018,1.55165,-2.99193> ,0.413333}
texture{txttree matrix <0.607708,-0.794161,0,0.419415,0.320945,-0.849167,0.674375,0.516046,0.528124,1.5018,1.55165,-2.99193> }}
union{cone{<1.73571,1.73063,-3.4655> ,0.386667,<1.91259,2.0163,-3.90891> ,0.36}
sphere{<1.73571,1.73063,-3.4655> ,0.386667}
texture{txttree matrix <0.850214,-0.526437,0,0.317939,0.513481,-0.797027,0.419585,0.677643,0.603944,1.73571,1.73063,-3.4655> }}
union{cone{<1.91259,2.0163,-3.90891> ,0.36,<2.10735,2.95382,-3.61022> ,0.342}
sphere{<1.91259,2.0163,-3.90891> ,0.36}
texture{txttree matrix <0.979096,-0.203397,0,0.194169,0.934677,0.297789,-0.0605693,-0.291564,0.954632,1.91259,2.0163,-3.90891> }}
union{cone{<2.10735,2.95382,-3.61022> ,0.342,<2.79747,3.63183,-3.76963> ,0.324}
sphere{<2.10735,2.95382,-3.61022> ,0.342}
texture{txttree matrix <0.700824,-0.713335,0,0.703844,0.6915,-0.162579,0.115973,0.113939,0.986696,2.10735,2.95382,-3.61022> }}
union{cone{<2.79747,3.63183,-3.76963> ,0.324,<2.92988,4.56951,-3.90355> ,0.306}
sphere{<2.79747,3.63183,-3.76963> ,0.324}
texture{txttree matrix <0.990177,-0.139823,0,0.138445,0.980421,-0.140025,0.0195788,0.13865,0.990148,2.79747,3.63183,-3.76963> }}
union{cone{<2.92988,4.56951,-3.90355> ,0.306,<3.50221,5.29317,-3.99481> ,0.288}
sphere{<2.92988,4.56951,-3.90355> ,0.306}
texture{txttree matrix <0.784345,-0.620325,0,0.617313,0.780536,-0.0984307,0.061059,0.0772036,0.995144,2.92988,4.56951,-3.90355> }}
union{cone{<3.50221,5.29317,-3.99481> ,0.288,<3.87386,6.09454,-4.30583> ,0.27}
sphere{<3.50221,5.29317,-3.99481> ,0.288}
texture{txttree matrix <0.907185,-0.420732,0,0.396852,0.855695,-0.332106,0.139727,0.301281,0.943242,3.50221,5.29317,-3.99481> }}
union{cone{<3.87386,6.09454,-4.30583> ,0.27,<4.21782,6.97107,-4.52113> ,0.252}
sphere{<3.87386,6.09454,-4.30583> ,0.27}
texture{txttree matrix <0.930894,-0.36529,0,0.3561,0.907473,-0.222901,0.0814234,0.207497,0.974841,3.87386,6.09454,-4.30583> }}
union{cone{<4.21782,6.97107,-4.52113> ,0.252,<4.50378,7.84215,-4.73131> ,0.234}
sphere{<4.21782,6.97107,-4.52113> ,0.252}
texture{txttree matrix <0.950114,-0.311904,0,0.304017,0.92609,-0.223452,0.0696956,0.212305,0.974715,4.21782,6.97107,-4.52113> }}
union{cone{<4.50378,7.84215,-4.73131> ,0.234,<4.70182,8.76678,-4.90709> ,0.216}
sphere{<4.50378,7.84215,-4.73131> ,0.234}
texture{txttree matrix <0.977824,-0.209428,0,0.2059,0.961354,-0.182768,0.0382768,0.178715,0.983156,4.50378,7.84215,-4.73131> }}
union{cone{<4.70182,8.76678,-4.90709> ,0.216,<5.45365,10.1921,-4.34802> ,0.203657}
sphere{<4.70182,8.76678,-4.90709> ,0.216}
texture{txttree matrix <0.884494,-0.466552,0,0.440779,0.835633,0.327767,-0.15292,-0.289908,0.944759,4.70182,8.76678,-4.90709> }}
union{cone{<5.45365,10.1921,-4.34802> ,0.203657,<5.93424,11.6445,-3.56195> ,0.191314}
sphere{<5.45365,10.1921,-4.34802> ,0.203657}
texture{txttree matrix <0.949376,-0.314141,0,0.279415,0.844429,0.45702,-0.143569,-0.433884,0.889456,5.45365,10.1921,-4.34802> }}
union{cone{<5.93424,11.6445,-3.56195> ,0.191314,<6.28401,13.4007,-3.9867> ,0.178971}
sphere{<5.93424,11.6445,-3.56195> ,0.191314}
texture{txttree matrix <0.980739,-0.195322,0,0.190049,0.954262,-0.230791,0.0450787,0.226346,0.973003,5.93424,11.6445,-3.56195> }}
union{cone{<6.28401,13.4007,-3.9867> ,0.178971,<6.85356,15.0544,-4.30806> ,0.166629}
sphere{<6.28401,13.4007,-3.9867> ,0.178971}
texture{txttree matrix <0.94549,-0.325651,0,0.320289,0.929922,-0.180721,0.0588522,0.17087,0.983534,6.28401,13.4007,-3.9867> }}
union{cone{<6.85356,15.0544,-4.30806> ,0.166629,<7.32148,16.8139,-4.03563> ,0.154286}
sphere{<6.85356,15.0544,-4.30806> ,0.166629}
texture{txttree matrix <0.966411,-0.257002,0,0.254172,0.95577,0.147984,-0.0380321,-0.143013,0.98899,6.85356,15.0544,-4.30806> }}
union{cone{<7.32148,16.8139,-4.03563> ,0.154286,<7.55139,18.3924,-4.67664> ,0.141943}
sphere{<7.32148,16.8139,-4.03563> ,0.154286}
texture{txttree matrix <0.989559,-0.144125,0,0.133732,0.918198,-0.372864,0.0537391,0.368972,0.927886,7.32148,16.8139,-4.03563> }}
union{cone{<7.55139,18.3924,-4.67664> ,0.141943,<8.022,20.0253,-4.78398> ,0.1296}
sphere{<7.55139,18.3924,-4.67664> ,0.141943}
texture{txttree matrix <0.960887,-0.276939,0,0.276388,0.958976,-0.0630415,0.0174587,0.0605758,0.998011,7.55139,18.3924,-4.67664> }}
union{cone{<8.022,20.0253,-4.78398> ,0.1296,<9.26868,22.8164,-3.22563> ,0.12096}
sphere{<8.022,20.0253,-4.78398> ,0.1296}
texture{txttree matrix <0.913058,-0.407829,0,0.36334,0.813455,0.454174,-0.185225,-0.414688,0.890913,8.022,20.0253,-4.78398> }}
union{cone{<9.26868,22.8164,-3.22563> ,0.12096,<9.38874,26.1395,-2.95679> ,0.11232}
sphere{<9.26868,22.8164,-3.22563> ,0.12096}
texture{txttree matrix <0.999348,-0.0361049,0,0.0359874,0.996098,0.0805875,-0.0029096,-0.080535,0.996748,9.26868,22.8164,-3.22563> }}
union{cone{<9.38874,26.1395,-2.95679> ,0.11232,<11.1482,28.9751,-2.73535> ,0.10368}
sphere{<9.38874,26.1395,-2.95679> ,0.11232}
texture{txttree matrix <0.849719,-0.527237,0,0.52608,0.847854,0.066211,-0.0349088,-0.0562607,0.997806,9.38874,26.1395,-2.95679> }}
union{cone{<11.1482,28.9751,-2.73535> ,0.10368,<12.2612,32.1752,-2.42948> ,0.09504}
sphere{<11.1482,28.9751,-2.73535> ,0.10368}
texture{txttree matrix <0.944508,-0.328488,0,0.327158,0.940682,0.0899123,-0.0295351,-0.0849229,0.99595,11.1482,28.9751,-2.73535> }}
union{cone{<12.2612,32.1752,-2.42948> ,0.09504,<12.5913,35.2886,-3.63931> ,0.0864}
sphere{<12.2612,32.1752,-2.42948> ,0.09504}
texture{txttree matrix <0.994427,-0.105431,0,0.0983433,0.92758,-0.36045,0.0380024,0.358441,0.932779,12.2612,32.1752,-2.42948> }}
union{cone{<12.5913,35.2886,-3.63931> ,0.0864,<13.4332,38.1386,-4.84593> ,0.07776}
sphere{<12.5913,35.2886,-3.63931> ,0.0864}
texture{txttree matrix <0.959027,-0.283314,0,0.262501,0.888574,-0.376205,0.106584,0.360791,0.926537,12.5913,35.2886,-3.63931> }}
union{cone{<5.6201,10.6951,-4.07578> ,0.1296,<5.28756,13.6673,-2.42713> ,0.12096}
sphere{<5.6201,10.6951,-4.07578> ,0.1296}
texture{txttree matrix <0.993799,0.111192,0,-0.0973765,0.87032,0.482764,0.0536795,-0.47977,0.875751,5.6201,10.6951,-4.07578> }}
union{cone{<5.28756,13.6673,-2.42713> ,0.12096,<6.54494,16.4977,-2.77147> ,0.11232}
sphere{<5.28756,13.6673,-2.42713> ,0.12096}
texture{txttree matrix <0.913883,-0.405977,0,0.403491,0.908287,-0.110496,0.0448588,0.10098,0.993877,5.28756,13.6673,-2.42713> }}
union{cone{<6.54494,16.4977,-2.77147> ,0.11232,<7.62505,19.3967,-2.30478> ,0.10368}
sphere{<6.54494,16.4977,-2.77147> ,0.11232}
texture{txttree matrix <0.937069,-0.349143,0,0.345237,0.926586,0.149165,-0.05208,-0.139778,0.988812,6.54494,16.4977,-2.77147> }}
union{cone{<7.62505,19.3967,-2.30478> ,0.10368,<7.31488,22.4416,-3.26693> ,0.09504}
sphere{<7.62505,19.3967,-2.30478> ,0.10368}
texture{txttree matrix <0.994852,0.101341,0,-0.0966772,0.949064,-0.299886,-0.0303909,0.298342,0.953975,7.62505,19.3967,-2.30478> }}
union{cone{<7.31488,22.4416,-3.26693> ,0.09504,<7.22647,25.4735,-4.63308> ,0.0864}
sphere{<7.31488,22.4416,-3.26693> ,0.09504}
texture{txttree matrix <0.999575,0.0291462,0,-0.026575,0.911396,-0.410672,-0.0119695,0.410498,0.911783,7.31488,22.4416,-3.26693> }}
union{cone{<7.22647,25.4735,-4.63308> ,0.0864,<6.98876,28.4241,-5.82417> ,0.07776}
sphere{<7.22647,25.4735,-4.63308> ,0.0864}
texture{txttree matrix <0.996771,0.080303,0,-0.0744984,0.92472,-0.373286,-0.029976,0.37208,0.927716,7.22647,25.4735,-4.63308> }}
union{cone{<5.31045,9.92063,-4.45451> ,0.1296,<5.51118,13.074,-4.19291> ,0.12096}
sphere{<5.31045,9.92063,-4.45451> ,0.1296}
texture{txttree matrix <0.99798,-0.0635301,0,0.0633135,0.994577,0.0825114,-0.00524196,-0.0823447,0.99659,5.31045,9.92063,-4.45451> }}
union{cone{<5.51118,13.074,-4.19291> ,0.12096,<6.28823,15.8335,-2.51828> ,0.11232}
sphere{<5.51118,13.074,-4.19291> ,0.12096}
texture{txttree matrix <0.962567,-0.271043,0,0.234041,0.831158,0.504383,-0.13671,-0.485502,0.86348,5.51118,13.074,-4.19291> }}
union{cone{<6.28823,15.8335,-2.51828> ,0.11232,<7.17721,18.951,-2.49114> ,0.10368}
sphere{<6.28823,15.8335,-2.51828> ,0.11232}
texture{txttree matrix <0.961666,-0.274224,0,0.274214,0.961632,0.00837275,-0.00229601,-0.00805179,0.999965,6.28823,15.8335,-2.51828> }}
union{cone{<7.17721,18.951,-2.49114> ,0.10368,<7.01965,22.1075,-3.18935> ,0.09504}
sphere{<7.17721,18.951,-2.49114> ,0.10368}
texture{txttree matrix <0.998756,0.0498548,0,-0.048681,0.975241,-0.21572,-0.0107547,0.215451,0.976455,7.17721,18.951,-2.49114> }}
union{cone{<7.01965,22.1075,-3.18935> ,0.09504,<7.9953,25.3093,-2.70014> ,0.0864}
sphere{<7.01965,22.1075,-3.18935> ,0.09504}
texture{txttree matrix <0.956573,-0.291494,0,0.288429,0.946516,0.144624,-0.0421569,-0.138343,0.989487,7.01965,22.1075,-3.18935> }}
union{cone{<7.9953,25.3093,-2.70014> ,0.0864,<8.97426,28.155,-3.57825> ,0.07776}
sphere{<7.9953,25.3093,-2.70014> ,0.0864}
texture{txttree matrix <0.945611,-0.325299,0,0.312277,0.907758,-0.280106,0.0911182,0.264872,0.959969,7.9953,25.3093,-2.70014> }}
union{cone{<3.95476,6.30069,-4.35646> ,0.216,<5.18538,7.65055,-4.5771> ,0.203657}
sphere{<3.95476,6.30069,-4.35646> ,0.216}
texture{txttree matrix <0.738992,-0.673714,0,0.668853,0.73366,-0.119916,0.0807888,0.0886166,0.992784,3.95476,6.30069,-4.35646> }}
union{cone{<5.18538,7.65055,-4.5771> ,0.203657,<6.7149,8.4813,-4.39855> ,0.191314}
sphere{<5.18538,7.65055,-4.5771> ,0.203657}
texture{txttree matrix <0.477291,-0.878745,0,0.874158,0.4748,0.102046,-0.0896728,-0.0487059,0.99478,5.18538,7.65055,-4.5771> }}
union{cone{<6.7149,8.4813,-4.39855> ,0.191314,<7.71397,9.84395,-4.97433> ,0.178971}
sphere{<6.7149,8.4813,-4.39855> ,0.191314}
texture{txttree matrix <0.806462,-0.591285,0,0.559681,0.763357,-0.322557,0.190723,0.26013,0.94655,6.7149,8.4813,-4.39855> }}
union{cone{<7.71397,9.84395,-4.97433> ,0.178971,<8.31786,11.4069,-5.18425> ,0.166629}
sphere{<7.71397,9.84395,-4.97433> ,0.178971}
texture{txttree matrix <0.932796,-0.360406,0,0.35761,0.925561,-0.124304,0.0447999,0.11595,0.992244,7.71397,9.84395,-4.97433> }}
union{cone{<8.31786,11.4069,-5.18425> ,0.166629,<9.04896,12.851,-5.89694> ,0.154286}
sphere{<8.31786,11.4069,-5.18425> ,0.166629}
texture{txttree matrix <0.892174,-0.451691,0,0.413391,0.816525,-0.402983,0.182024,0.359531,0.915208,8.31786,11.4069,-5.18425> }}
union{cone{<9.04896,12.851,-5.89694> ,0.154286,<9.70456,14.4113,-6.1779> ,0.141943}
sphere{<9.04896,12.851,-5.89694> ,0.154286}
texture{txttree matrix <0.921923,-0.387374,0,0.382144,0.909474,-0.163776,0.0634425,0.150989,0.986498,9.04896,12.851,-5.89694> }}
union{cone{<9.70456,14.4113,-6.1779> ,0.141943,<10.332,15.9859,-6.5347> ,0.1296}
sphere{<9.70456,14.4113,-6.1779> ,0.141943}
texture{txttree matrix <0.928961,-0.370178,0,0.362241,0.909041,-0.205976,0.076248,0.191344,0.978557,9.70456,14.4113,-6.1779> }}
union{cone{<10.332,15.9859,-6.5347> ,0.1296,<10.9984,18.8448,-5.44689> ,0.12096}
sphere{<10.332,15.9859,-6.5347> ,0.1296}
texture{txttree matrix <0.973891,-0.227016,0,0.21287,0.913205,0.347482,-0.078884,-0.33841,0.937687,10.332,15.9859,-6.5347> }}
union{cone{<10.9984,18.8448,-5.44689> ,0.12096,<12.4857,21.6332,-6.24839> ,0.11232}
sphere{<10.9984,18.8448,-5.44689> ,0.12096}
texture{txttree matrix <0.882344,-0.470605,0,0.456162,0.855266,-0.245838,0.115692,0.216913,0.969311,10.9984,18.8448,-5.44689> }}
union{cone{<12.4857,21.6332,-6.24839> ,0.11232,<13.864,24.5805,-7.24818> ,0.10368}
sphere{<12.4857,21.6332,-6.24839> ,0.11232}
texture{txttree matrix <0.905834,-0.423632,0,0.404946,0.865878,-0.293724,0.124431,0.266065,0.95589,12.4857,21.6332,-6.24839> }}
union{cone{<13.864,24.5805,-7.24818> ,0.10368,<13.9502,27.6927,-7.869> ,0.09504}
sphere{<13.864,24.5805,-7.24818> ,0.10368}
texture{txttree matrix <0.999617,-0.0276702,0,0.027136,0.980317,-0.195556,0.00541109,0.195481,0.980692,13.864,24.5805,-7.24818> }}
union{cone{<13.9502,27.6927,-7.869> ,0.09504,<15.339,30.663,-8.80391> ,0.0864}
sphere{<13.9502,27.6927,-7.869> ,0.09504}
texture{txttree matrix <0.905874,-0.423547,0,0.407314,0.871154,-0.274199,0.116136,0.24839,0.961673,13.9502,27.6927,-7.869> }}
union{cone{<15.339,30.663,-8.80391> ,0.0864,<16.5466,33.4801,-10.0802> ,0.07776}
sphere{<15.339,30.663,-8.80391> ,0.0864}
texture{txttree matrix <0.919111,-0.393999,0,0.363726,0.848491,-0.384405,0.151455,0.353311,0.923164,15.339,30.663,-8.80391> }}
union{cone{<7.61393,9.70751,-4.91668> ,0.1296,<10.526,11.1779,-5.80925> ,0.12096}
sphere{<7.61393,9.70751,-4.91668> ,0.1296}
texture{txttree matrix <0.450733,-0.892659,0,0.861013,0.434755,-0.263902,0.235574,0.118949,0.96455,7.61393,9.70751,-4.91668> }}
union{cone{<10.526,11.1779,-5.80925> ,0.12096,<12.7975,12.673,-7.53946> ,0.11232}
sphere{<10.526,11.1779,-5.80925> ,0.12096}
texture{txttree matrix <0.549797,-0.835298,0,0.704739,0.463863,-0.536819,0.448404,0.295141,0.843698,10.526,11.1779,-5.80925> }}
union{cone{<12.7975,12.673,-7.53946> ,0.11232,<15.548,14.3834,-8.50579> ,0.10368}
sphere{<12.7975,12.673,-7.53946> ,0.11232}
texture{txttree matrix <0.528083,-0.849193,0,0.813748,0.506041,-0.285896,0.242781,0.150977,0.958261,12.7975,12.673,-7.53946> }}
union{cone{<15.548,14.3834,-8.50579> ,0.10368,<16.9357,17.2153,-9.87008> ,0.09504}
sphere{<15.548,14.3834,-8.50579> ,0.10368}
texture{txttree matrix <0.897979,-0.440038,0,0.403865,0.824162,-0.397051,0.174717,0.356543,0.917797,15.548,14.3834,-8.50579> }}
union{cone{<16.9357,17.2153,-9.87008> ,0.09504,<18.4813,20.1196,-10.7561> ,0.0864}
sphere{<16.9357,17.2153,-9.87008> ,0.09504}
texture{txttree matrix <0.882771,-0.469804,0,0.453642,0.852402,-0.260036,0.122166,0.229552,0.965599,16.9357,17.2153,-9.87008> }}
union{cone{<18.4813,20.1196,-10.7561> ,0.0864,<19.3149,22.5659,-12.6057> ,0.07776}
sphere{<18.4813,20.1196,-10.7561> ,0.0864}
texture{txttree matrix <0.946557,-0.322535,0,0.262284,0.769734,-0.581993,0.187713,0.55089,0.813194,18.4813,20.1196,-10.7561> }}
union{cone{<6.72231,8.49142,-4.40282> ,0.1296,<7.86774,11.4069,-5.43233> ,0.12096}
sphere{<6.72231,8.49142,-4.40282> ,0.1296}
texture{txttree matrix <0.930746,-0.365668,0,0.347386,0.884214,-0.312232,0.114173,0.290608,0.950006,6.72231,8.49142,-4.40282> }}
union{cone{<7.86774,11.4069,-5.43233> ,0.12096,<8.18104,14.2836,-6.62018> ,0.11232}
sphere{<7.86774,11.4069,-5.43233> ,0.12096}
texture{txttree matrix <0.994122,-0.108267,0,0.100157,0.919654,-0.379744,0.0411138,0.377511,0.925092,7.86774,11.4069,-5.43233> }}
union{cone{<8.18104,14.2836,-6.62018> ,0.11232,<8.63258,17.3292,-8.13343> ,0.10368}
sphere{<8.18104,14.2836,-6.62018> ,0.11232}
texture{txttree matrix <0.989187,-0.146659,0,0.131621,0.887755,-0.441097,0.0646909,0.436327,0.89746,8.18104,14.2836,-6.62018> }}
union{cone{<8.63258,17.3292,-8.13343> ,0.10368,<8.80435,20.0552,-9.77815> ,0.09504}
sphere{<8.63258,17.3292,-8.13343> ,0.10368}
texture{txttree matrix <0.998021,-0.0628858,0,0.0538731,0.854986,-0.515845,0.0324393,0.514824,0.856682,8.63258,17.3292,-8.13343> }}
union{cone{<8.80435,20.0552,-9.77815> ,0.09504,<9.96523,22.6718,-11.5803> ,0.0864}
sphere{<8.80435,20.0552,-9.77815> ,0.09504}
texture{txttree matrix <0.914073,-0.405549,0,0.343199,0.773541,-0.532774,0.216066,0.486995,0.846257,8.80435,20.0552,-9.77815> }}
union{cone{<9.96523,22.6718,-11.5803> ,0.0864,<10.1312,25.0187,-13.6546> ,0.07776}
sphere{<9.96523,22.6718,-11.5803> ,0.0864}
texture{txttree matrix <0.997508,-0.0705477,0,0.0529185,0.74824,-0.661314,0.0466542,0.659666,0.750109,9.96523,22.6718,-11.5803> }}
union{cone{<10.2096,15.6786,-6.46507> ,0.1296,<11.0641,18.6906,-7.40017> ,0.12096}
sphere{<10.2096,15.6786,-6.46507> ,0.1296}
texture{txttree matrix <0.962037,-0.27292,0,0.261505,0.9218,-0.286182,0.0781047,0.275317,0.958175,10.2096,15.6786,-6.46507> }}
union{cone{<11.0641,18.6906,-7.40017> ,0.12096,<12.0458,21.8926,-7.43747> ,0.11232}
sphere{<11.0641,18.6906,-7.40017> ,0.12096}
texture{txttree matrix <0.956072,-0.29313,0,0.293112,0.956013,-0.0111366,0.00326449,0.0106474,0.999938,11.0641,18.6906,-7.40017> }}
union{cone{<12.0458,21.8926,-7.43747> ,0.11232,<11.6506,24.8295,-8.95243> ,0.10368}
sphere{<12.0458,21.8926,-7.43747> ,0.11232}
texture{txttree matrix <0.991067,0.133367,0,-0.11875,0.882442,-0.455187,-0.060707,0.451121,0.890396,12.0458,21.8926,-7.43747> }}
union{cone{<11.6506,24.8295,-8.95243> ,0.10368,<11.6751,27.801,-10.3485> ,0.09504}
sphere{<11.6506,24.8295,-8.95243> ,0.10368}
texture{txttree matrix <0.999966,-0.0082662,0,0.00748162,0.905055,-0.425229,0.00351503,0.425215,0.905086,11.6506,24.8295,-8.95243> }}
union{cone{<11.6751,27.801,-10.3485> ,0.09504,<11.9631,30.9015,-11.2651> ,0.0864}
sphere{<11.6751,27.801,-10.3485> ,0.09504}
texture{txttree matrix <0.995714,-0.0924824,0,0.088719,0.955196,-0.282363,0.0261136,0.281153,0.959308,11.6751,27.801,-10.3485> }}
union{cone{<11.9631,30.9015,-11.2651> ,0.0864,<11.8854,34.0168,-11.955> ,0.07776}
sphere{<11.9631,30.9015,-11.2651> ,0.0864}
texture{txttree matrix <0.999689,0.0249309,0,-0.0243414,0.976052,-0.21617,-0.0053893,0.216102,0.976356,11.9631,30.9015,-11.2651> }}
union{cone{<2.92298,4.5207,-3.89658> ,0.216,<3.91126,6.00966,-4.24978> ,0.203657}
sphere{<2.92298,4.5207,-3.89658> ,0.216}
texture{txttree matrix <0.833176,-0.553008,0,0.542514,0.817365,-0.193888,0.107222,0.161543,0.981024,2.92298,4.5207,-3.89658> }}
union{cone{<3.91126,6.00966,-4.24978> ,0.203657,<5.07201,7.07569,-4.96509> ,0.191314}
sphere{<3.91126,6.00966,-4.24978> ,0.203657}
texture{txttree matrix <0.676416,-0.736519,0,0.670671,0.615941,-0.413301,0.304404,0.279563,0.910595,3.91126,6.00966,-4.24978> }}
union{cone{<5.07201,7.07569,-4.96509> ,0.191314,<5.56747,8.44222,-5.85067> ,0.178971}
sphere{<5.07201,7.07569,-4.96509> ,0.191314}
texture{txttree matrix <0.940116,-0.340856,0,0.291088,0.80285,-0.520288,0.177343,0.48913,0.853991,5.07201,7.07569,-4.96509> }}
union{cone{<5.56747,8.44222,-5.85067> ,0.178971,<6.02702,9.94705,-6.43013> ,0.166629}
sphere{<5.56747,8.44222,-5.85067> ,0.178971}
texture{txttree matrix <0.956398,-0.292066,0,0.27407,0.897471,-0.345588,0.100934,0.33052,0.938386,5.56747,8.44222,-5.85067> }}
union{cone{<6.02702,9.94705,-6.43013> ,0.166629,<6.59422,11.4645,-7.07771> ,0.154286}
sphere{<6.02702,9.94705,-6.43013> ,0.166629}
texture{txttree matrix <0.936702,-0.350128,0,0.325115,0.869784,-0.371182,0.129961,0.347687,0.92856,6.02702,9.94705,-6.43013> }}
union{cone{<6.59422,11.4645,-7.07771> ,0.154286,<6.83055,13.0453,-7.87599> ,0.141943}
sphere{<6.59422,11.4645,-7.07771> ,0.154286}
texture{txttree matrix <0.989009,-0.147855,0,0.132276,0.884796,-0.446809,0.0660632,0.441898,0.894629,6.59422,11.4645,-7.07771> }}
union{cone{<6.83055,13.0453,-7.87599> ,0.141943,<7.01124,14.6318,-8.7606> ,0.1296}
sphere{<6.83055,13.0453,-7.87599> ,0.141943}
texture{txttree matrix <0.993577,-0.11316,0,0.0989842,0.869113,-0.484607,0.0548379,0.481494,0.874732,6.83055,13.0453,-7.87599> }}
union{cone{<7.01124,14.6318,-8.7606> ,0.1296,<8.51265,17.3362,-9.71276> ,0.12096}
sphere{<7.01124,14.6318,-8.7606> ,0.1296}
texture{txttree matrix <0.874302,-0.485383,0,0.463903,0.83561,-0.294196,0.142798,0.257216,0.955745,7.01124,14.6318,-8.7606> }}
union{cone{<8.51265,17.3362,-9.71276> ,0.12096,<9.3628,20.0341,-11.1128> ,0.11232}
sphere{<8.51265,17.3362,-9.71276> ,0.12096}
texture{txttree matrix <0.953765,-0.300552,0,0.269362,0.854789,-0.443599,0.133325,0.42309,0.896225,8.51265,17.3362,-9.71276> }}
union{cone{<9.3628,20.0341,-11.1128> ,0.11232,<10.0005,22.593,-13.0669> ,0.10368}
sphere{<9.3628,20.0341,-11.1128> ,0.11232}
texture{txttree matrix <0.970328,-0.241793,0,0.194273,0.779631,-0.595343,0.14395,0.577678,0.803472,9.3628,20.0341,-11.1128> }}
union{cone{<10.0005,22.593,-13.0669> ,0.10368,<9.43186,25.7343,-13.8893> ,0.09504}
sphere{<10.0005,22.593,-13.0669> ,0.10368}
texture{txttree matrix <0.98401,0.178111,0,-0.17248,0.952899,-0.249469,-0.0444333,0.24548,0.968383,10.0005,22.593,-13.0669> }}
union{cone{<9.43186,25.7343,-13.8893> ,0.09504,<9.28265,28.8746,-14.5979> ,0.0864}
sphere{<9.43186,25.7343,-13.8893> ,0.09504}
texture{txttree matrix <0.998873,0.0474615,0,-0.0462999,0.974426,-0.219889,-0.0104363,0.219641,0.975525,9.43186,25.7343,-13.8893> }}
union{cone{<9.28265,28.8746,-14.5979> ,0.0864,<10.1434,31.5753,-15.9246> ,0.07776}
sphere{<9.28265,28.8746,-14.5979> ,0.0864}
texture{txttree matrix <0.952779,-0.303665,0,0.275032,0.862939,-0.423902,0.128724,0.403885,0.905708,9.28265,28.8746,-14.5979> }}
union{cone{<4.62862,6.66848,-4.69185> ,0.1296,<8.04917,6.59908,-4.95568> ,0.12096}
sphere{<4.62862,6.66848,-4.69185> ,0.1296}
texture{txttree matrix <-0.0202853,-0.999794,0,0.996835,-0.0202253,-0.076886,0.0768702,-0.00155966,0.99704,4.62862,6.66848,-4.69185> }}
union{cone{<8.04917,6.59908,-4.95568> ,0.12096,<10.5246,8.39139,-6.08077> ,0.11232}
sphere{<8.04917,6.59908,-4.95568> ,0.12096}
texture{txttree matrix <0.586455,-0.809982,0,0.760111,0.550347,-0.34547,0.279824,0.202603,0.93843,8.04917,6.59908,-4.95568> }}
union{cone{<10.5246,8.39139,-6.08077> ,0.11232,<13.3465,8.93059,-7.7491> ,0.10368}
sphere{<10.5246,8.39139,-6.08077> ,0.11232}
texture{txttree matrix <0.187684,-0.982229,0,0.849396,0.162302,-0.50218,0.493256,0.0942512,0.864763,10.5246,8.39139,-6.08077> }}
union{cone{<13.3465,8.93059,-7.7491> ,0.10368,<16.3477,10.1217,-8.73814> ,0.09504}
sphere{<13.3465,8.93059,-7.7491> ,0.10368}
texture{txttree matrix <0.368897,-0.92947,0,0.888714,0.352721,-0.292875,0.272219,0.108041,0.956151,13.3465,8.93059,-7.7491> }}
union{cone{<16.3477,10.1217,-8.73814> ,0.09504,<18.8831,11.4483,-9.98501> ,0.0864}
sphere{<16.3477,10.1217,-8.73814> ,0.09504}
texture{txttree matrix <0.463587,-0.886052,0,0.812286,0.424992,-0.399465,0.353947,0.185187,0.916748,16.3477,10.1217,-8.73814> }}
union{cone{<18.8831,11.4483,-9.98501> ,0.0864,<20.8009,12.7803,-12.4217> ,0.07776}
sphere{<18.8831,11.4483,-9.98501> ,0.0864}
texture{txttree matrix <0.570474,-0.821316,0,0.568252,0.394699,-0.722013,0.593001,0.411889,0.691879,18.8831,11.4483,-9.98501> }}
union{cone{<6.77321,12.6617,-7.6823> ,0.1296,<7.05791,15.2096,-9.9637> ,0.12096}
sphere{<6.77321,12.6617,-7.6823> ,0.1296}
texture{txttree matrix <0.993815,-0.111049,0,0.0829585,0.742424,-0.664774,0.0738225,0.660663,0.747044,6.77321,12.6617,-7.6823> }}
union{cone{<7.05791,15.2096,-9.9637> ,0.12096,<8.46858,17.978,-11.3248> ,0.11232}
sphere{<7.05791,15.2096,-9.9637> ,0.12096}
texture{txttree matrix <0.890991,-0.454022,0,0.415871,0.816122,-0.401243,0.182173,0.357504,0.915972,7.05791,15.2096,-9.9637> }}
union{cone{<8.46858,17.978,-11.3248> ,0.11232,<9.08831,20.3581,-13.6395> ,0.10368}
sphere{<8.46858,17.978,-11.3248> ,0.11232}
texture{txttree matrix <0.967732,-0.25198,0,0.183494,0.704711,-0.685356,0.172696,0.663241,0.728208,8.46858,17.978,-11.3248> }}
union{cone{<9.08831,20.3581,-13.6395> ,0.10368,<10.1002,22.4097,-15.9401> ,0.09504}
sphere{<9.08831,20.3581,-13.6395> ,0.10368}
texture{txttree matrix <0.896842,-0.442351,0,0.311904,0.632367,-0.709104,0.313673,0.635954,0.705104,9.08831,20.3581,-13.6395> }}
union{cone{<10.1002,22.4097,-15.9401> ,0.09504,<11.4289,24.5456,-17.9887> ,0.0864}
sphere{<10.1002,22.4097,-15.9401> ,0.09504}
texture{txttree matrix <0.849121,-0.528198,0,0.409555,0.658393,-0.631493,0.333553,0.536214,0.775382,10.1002,22.4097,-15.9401> }}
union{cone{<11.4289,24.5456,-17.9887> ,0.0864,<12.1488,26.6011,-20.2416> ,0.07776}
sphere{<11.4289,24.5456,-17.9887> ,0.0864}
texture{txttree matrix <0.943785,-0.330561,0,0.229751,0.65596,-0.718979,0.237667,0.678561,0.695032,11.4289,24.5456,-17.9887> }}
union{cone{<6.65621,11.8792,-7.28711> ,0.1296,<6.13058,13.3809,-10.0411> ,0.12096}
sphere{<6.65621,11.8792,-7.28711> ,0.1296}
texture{txttree matrix <0.943854,0.330363,0,-0.165266,0.472167,-0.865878,-0.286055,0.817263,0.500255,6.65621,11.8792,-7.28711> }}
union{cone{<6.13058,13.3809,-10.0411> ,0.12096,<5.26797,15.0538,-12.6028> ,0.11232}
sphere{<6.13058,13.3809,-10.0411> ,0.12096}
texture{txttree matrix <0.888791,0.458314,0,-0.271359,0.526237,-0.805878,-0.369345,0.716256,0.592082,6.13058,13.3809,-10.0411> }}
union{cone{<5.26797,15.0538,-12.6028> ,0.11232,<5.131,16.7754,-15.3546> ,0.10368}
sphere{<5.26797,15.0538,-12.6028> ,0.11232}
texture{txttree matrix <0.99685,0.0793115,0,-0.0421619,0.529924,-0.846996,-0.0671765,0.844328,0.531599,5.26797,15.0538,-12.6028> }}
union{cone{<5.131,16.7754,-15.3546> ,0.10368,<4.10223,19.1694,-17.562> ,0.09504}
sphere{<5.131,16.7754,-15.3546> ,0.10368}
texture{txttree matrix <0.918764,0.394807,0,-0.301243,0.70103,-0.646382,-0.255196,0.593872,0.763014,5.131,16.7754,-15.3546> }}
union{cone{<4.10223,19.1694,-17.562> ,0.09504,<3.36925,21.4906,-19.9479> ,0.0864}
sphere{<4.10223,19.1694,-17.562> ,0.09504}
texture{txttree matrix <0.953585,0.301123,0,-0.215045,0.680996,-0.7,-0.210786,0.66751,0.714143,4.10223,19.1694,-17.562> }}
union{cone{<3.36925,21.4906,-19.9479> ,0.0864,<2.68444,23.5671,-22.5615> ,0.07776}
sphere{<3.36925,21.4906,-19.9479> ,0.0864}
texture{txttree matrix <0.949686,0.313203,0,-0.200968,0.609369,-0.766995,-0.240225,0.728405,0.641653,3.36925,21.4906,-19.9479> }}
union{cone{<2.68446,3.52081,-3.74353> ,0.216,<2.97828,5.22044,-4.32381> ,0.203657}
sphere{<2.68446,3.52081,-3.74353> ,0.216}
texture{txttree matrix <0.985384,-0.170349,0,0.161457,0.933947,-0.318865,0.0543184,0.314204,0.9478,2.68446,3.52081,-3.74353> }}
union{cone{<2.97828,5.22044,-4.32381> ,0.203657,<3.98722,6.4573,-5.15653> ,0.191314}
sphere{<2.97828,5.22044,-4.32381> ,0.203657}
texture{txttree matrix <0.774891,-0.632094,0,0.560415,0.687019,-0.462537,0.292367,0.358416,0.8866,2.97828,5.22044,-4.32381> }}
union{cone{<3.98722,6.4573,-5.15653> ,0.191314,<4.6281,7.34105,-6.4731> ,0.178971}
sphere{<3.98722,6.4573,-5.15653> ,0.191314}
texture{txttree matrix <0.809541,-0.587064,0,0.37472,0.516726,-0.769792,0.451917,0.623178,0.638295,3.98722,6.4573,-5.15653> }}
union{cone{<4.6281,7.34105,-6.4731> ,0.178971,<4.60722,8.70672,-7.4327> ,0.166629}
sphere{<4.6281,7.34105,-6.4731> ,0.178971}
texture{txttree matrix <0.999883,0.0152868,0,-0.0125083,0.818143,-0.574879,-0.00878807,0.574811,0.818239,4.6281,7.34105,-6.4731> }}
union{cone{<4.60722,8.70672,-7.4327> ,0.166629,<5.27935,9.86368,-8.5153> ,0.154286}
sphere{<4.60722,8.70672,-7.4327> ,0.166629}
texture{txttree matrix <0.864679,-0.502326,0,0.390511,0.672207,-0.628999,0.315962,0.543882,0.777406,4.60722,8.70672,-7.4327> }}
union{cone{<5.27935,9.86368,-8.5153> ,0.154286,<5.31914,11.0119,-9.84723> ,0.141943}
sphere{<5.27935,9.86368,-8.5153> ,0.154286}
texture{txttree matrix <0.9994,-0.0346292,0,0.0226191,0.652786,-0.757204,0.0262214,0.75675,0.653178,5.27935,9.86368,-8.5153> }}
union{cone{<5.31914,11.0119,-9.84723> ,0.141943,<5.57543,12.5482,-10.6788> ,0.1296}
sphere{<5.31914,11.0119,-9.84723> ,0.141943}
texture{txttree matrix <0.986368,-0.164556,0,0.145162,0.87012,-0.470976,0.0775019,0.464555,0.882146,5.31914,11.0119,-9.84723> }}
union{cone{<5.57543,12.5482,-10.6788> ,0.1296,<6.74137,15.0809,-12.2135> ,0.12096}
sphere{<5.57543,12.5482,-10.6788> ,0.1296}
texture{txttree matrix <0.908369,-0.41817,0,0.366341,0.795785,-0.482203,0.201643,0.438018,0.876059,5.57543,12.5482,-10.6788> }}
union{cone{<6.74137,15.0809,-12.2135> ,0.12096,<6.22006,18.0282,-13.4121> ,0.11232}
sphere{<6.74137,15.0809,-12.2135> ,0.12096}
texture{txttree matrix <0.984715,0.174176,0,-0.161691,0.91413,-0.371782,-0.0647555,0.366099,0.92832,6.74137,15.0809,-12.2135> }}
union{cone{<6.22006,18.0282,-13.4121> ,0.11232,<6.42093,21.1284,-14.0018> ,0.10368}
sphere{<6.22006,18.0282,-13.4121> ,0.11232}
texture{txttree matrix <0.997907,-0.0646586,0,0.0635244,0.980402,-0.186482,0.0120577,0.186092,0.982458,6.22006,18.0282,-13.4121> }}
union{cone{<6.42093,21.1284,-14.0018> ,0.10368,<7.20634,24.2354,-14.5878> ,0.09504}
sphere{<6.42093,21.1284,-14.0018> ,0.10368}
texture{txttree matrix <0.969504,-0.245074,0,0.241077,0.953694,-0.179862,0.0440794,0.174377,0.983692,6.42093,21.1284,-14.0018> }}
union{cone{<7.20634,24.2354,-14.5878> ,0.09504,<7.29264,27.5813,-15.2933> ,0.0864}
sphere{<7.20634,24.2354,-14.5878> ,0.09504}
texture{txttree matrix <0.999668,-0.0257842,0,0.0252298,0.978171,-0.206264,0.00531837,0.206196,0.978496,7.20634,24.2354,-14.5878> }}
union{cone{<7.29264,27.5813,-15.2933> ,0.0864,<8.21318,30.3255,-16.699> ,0.07776}
sphere{<7.29264,27.5813,-15.2933> ,0.0864}
texture{txttree matrix <0.94808,-0.318033,0,0.286082,0.852833,-0.436845,0.138931,0.414164,0.899537,7.29264,27.5813,-15.2933> }}
union{cone{<2.82657,4.34285,-4.02418> ,0.1296,<3.83083,7.56418,-3.69141> ,0.12096}
sphere{<2.82657,4.34285,-4.02418> ,0.1296}
texture{txttree matrix <0.954682,-0.297626,0,0.296189,0.950073,0.0981453,-0.0292106,-0.0936976,0.995172,2.82657,4.34285,-4.02418> }}
union{cone{<3.83083,7.56418,-3.69141> ,0.12096,<5.4213,10.4279,-4.05954> ,0.11232}
sphere{<3.83083,7.56418,-3.69141> ,0.12096}
texture{txttree matrix <0.874217,-0.485535,0,0.482498,0.868749,-0.111677,0.0542232,0.0976302,0.993745,3.83083,7.56418,-3.69141> }}
union{cone{<5.4213,10.4279,-4.05954> ,0.11232,<7.49745,12.3993,-5.42576> ,0.10368}
sphere{<5.4213,10.4279,-4.05954> ,0.11232}
texture{txttree matrix <0.688585,-0.725155,0,0.654459,0.621454,-0.430671,0.312304,0.296554,0.902509,5.4213,10.4279,-4.05954> }}
union{cone{<7.49745,12.3993,-5.42576> ,0.10368,<8.93439,14.5114,-7.3236> ,0.09504}
sphere{<7.49745,12.3993,-5.42576> ,0.10368}
texture{txttree matrix <0.826791,-0.562509,0,0.451534,0.663678,-0.596363,0.33546,0.493068,0.802715,7.49745,12.3993,-5.42576> }}
union{cone{<8.93439,14.5114,-7.3236> ,0.09504,<9.3899,17.1517,-9.22048> ,0.0864}
sphere{<8.93439,14.5114,-7.3236> ,0.09504}
texture{txttree matrix <0.985442,-0.17001,0,0.138756,0.804282,-0.577821,0.0982354,0.569409,0.816163,8.93439,14.5114,-7.3236> }}
union{cone{<9.3899,17.1517,-9.22048> ,0.0864,<9.90622,20.1861,-10.2916> ,0.07776}
sphere{<9.3899,17.1517,-9.22048> ,0.0864}
texture{txttree matrix <0.985831,-0.16774,0,0.158421,0.931067,-0.328658,0.055129,0.324002,0.944449,9.3899,17.1517,-9.22048> }}
union{cone{<5.46652,11.8954,-10.3254> ,0.1296,<5.95626,14.8843,-11.9168> ,0.12096}
sphere{<5.46652,11.8954,-10.3254> ,0.1296}
texture{txttree matrix <0.986841,-0.161695,0,0.143139,0.873592,-0.465132,0.0752093,0.459011,0.885242,5.46652,11.8954,-10.3254> }}
union{cone{<5.95626,14.8843,-11.9168> ,0.12096,<7.13563,17.207,-13.9038> ,0.11232}
sphere{<5.95626,14.8843,-11.9168> ,0.12096}
texture{txttree matrix <0.891644,-0.452737,0,0.359973,0.70895,-0.606473,0.274573,0.540758,0.795104,5.95626,14.8843,-11.9168> }}
union{cone{<7.13563,17.207,-13.9038> ,0.11232,<8.01509,19.8215,-15.3923> ,0.10368}
sphere{<7.13563,17.207,-13.9038> ,0.11232}
texture{txttree matrix <0.947811,-0.318832,0,0.280587,0.834119,-0.474886,0.151409,0.450103,0.880047,7.13563,17.207,-13.9038> }}
union{cone{<8.01509,19.8215,-15.3923> ,0.10368,<8.14622,22.3123,-17.6819> ,0.09504}
sphere{<8.01509,19.8215,-15.3923> ,0.10368}
texture{txttree matrix <0.998617,-0.05257,0,0.0387271,0.735658,-0.676246,0.0355502,0.67531,0.736676,8.01509,19.8215,-15.3923> }}
union{cone{<8.14622,22.3123,-17.6819> ,0.09504,<8.59023,24.5152,-19.8462> ,0.0864}
sphere{<8.14622,22.3123,-17.6819> ,0.09504}
texture{txttree matrix <0.980286,-0.197584,0,0.142316,0.70608,-0.693684,0.137061,0.680009,0.720279,8.14622,22.3123,-17.6819> }}
union{cone{<8.59023,24.5152,-19.8462> ,0.0864,<8.72604,26.2206,-22.4569> ,0.07776}
sphere{<8.59023,24.5152,-19.8462> ,0.0864}
texture{txttree matrix <0.996844,-0.0793808,0,0.0435091,0.546377,-0.836409,0.0663948,0.833769,0.548107,8.59023,24.5152,-19.8462> }}
union{cone{<3.43952,5.78586,-4.70448> ,0.1296,<3.52787,8.73075,-6.43632> ,0.12096}
sphere{<3.43952,5.78586,-4.70448> ,0.1296}
texture{txttree matrix <0.99955,-0.0299886,0,0.0258529,0.861703,-0.506754,0.0151969,0.506526,0.86209,3.43952,5.78586,-4.70448> }}
union{cone{<3.52787,8.73075,-6.43632> ,0.12096,<4.2987,10.4903,-8.96019> ,0.11232}
sphere{<3.52787,8.73075,-6.43632> ,0.12096}
texture{txttree matrix <0.915964,-0.40126,0,0.243028,0.554765,-0.795722,0.319291,0.728853,0.605662,3.52787,8.73075,-6.43632> }}
union{cone{<4.2987,10.4903,-8.96019> ,0.11232,<4.5991,12.2214,-11.6858> ,0.10368}
sphere{<4.2987,10.4903,-8.96019> ,0.11232}
texture{txttree matrix <0.985274,-0.17098,0,0.0926348,0.533809,-0.840516,0.143711,0.828139,0.541787,4.2987,10.4903,-8.96019> }}
union{cone{<4.5991,12.2214,-11.6858> ,0.10368,<4.6429,14.2123,-14.152> ,0.09504}
sphere{<4.5991,12.2214,-11.6858> ,0.10368}
texture{txttree matrix <0.999758,-0.0219963,0,0.0138188,0.628084,-0.778023,0.0171136,0.777835,0.628236,4.5991,12.2214,-11.6858> }}
union{cone{<4.6429,14.2123,-14.152> ,0.09504,<5.06724,16.3541,-16.7743> ,0.0864}
sphere{<4.6429,14.2123,-14.152> ,0.09504}
texture{txttree matrix <0.980933,-0.194344,0,0.124357,0.627679,-0.768476,0.149349,0.753823,0.639879,4.6429,14.2123,-14.152> }}
union{cone{<5.06724,16.3541,-16.7743> ,0.0864,<5.45662,18.9911,-18.7905> ,0.07776}
sphere{<5.06724,16.3541,-16.7743> ,0.0864}
texture{txttree matrix <0.989273,-0.146079,0,0.116503,0.788977,-0.603276,0.0881262,0.596804,0.797533,5.06724,16.3541,-16.7743> }}
union{cone{<2.90252,4.78217,-4.17418> ,0.1296,<2.45077,8.1024,-3.52319> ,0.12096}
sphere{<2.90252,4.78217,-4.17418> ,0.1296}
texture{txttree matrix <0.99087,0.134818,0,-0.132343,0.972684,0.190711,0.0257111,-0.188969,0.981646,2.90252,4.78217,-4.17418> }}
union{cone{<2.45077,8.1024,-3.52319> ,0.12096,<2.13262,11.3965,-3.43208> ,0.11232}
sphere{<2.45077,8.1024,-3.52319> ,0.12096}
texture{txttree matrix <0.995368,0.0961351,0,-0.0960987,0.994991,0.0275223,0.00264586,-0.0273948,0.999621,2.45077,8.1024,-3.52319> }}
union{cone{<2.13262,11.3965,-3.43208> ,0.11232,<1.12424,14.1374,-4.88144> ,0.10368}
sphere{<2.13262,11.3965,-3.43208> ,0.11232}
texture{txttree matrix <0.938501,0.345277,0,-0.309285,0.84067,-0.444541,-0.15349,0.417203,0.895758,2.13262,11.3965,-3.43208> }}
union{cone{<1.12424,14.1374,-4.88144> ,0.10368,<-0.121268,16.8202,-6.62085> ,0.09504}
sphere{<1.12424,14.1374,-4.88144> ,0.10368}
texture{txttree matrix <0.907023,0.421082,0,-0.362973,0.781853,-0.506909,-0.21345,0.459777,0.862,1.12424,14.1374,-4.88144> }}
union{cone{<-0.121268,16.8202,-6.62085> ,0.09504,<-0.0295981,19.8266,-7.45083> ,0.0864}
sphere{<-0.121268,16.8202,-6.62085> ,0.09504}
texture{txttree matrix <0.999535,-0.0304783,0,0.0293802,0.963523,-0.266009,0.00810749,0.265885,0.963971,-0.121268,16.8202,-6.62085> }}
union{cone{<-0.0295981,19.8266,-7.45083> ,0.0864,<0.135156,22.6267,-9.35774> ,0.07776}
sphere{<-0.0295981,19.8266,-7.45083> ,0.0864}
texture{txttree matrix <0.998274,-0.0587359,0,0.0485742,0.825566,-0.562212,0.033022,0.561241,0.826993,-0.0295981,19.8266,-7.45083> }}
union{cone{<1.99985,2.43635,-3.77509> ,0.216,<1.11696,3.94073,-3.51495> ,0.203657}
sphere{<1.99985,2.43635,-3.77509> ,0.216}
texture{txttree matrix <0.862446,0.50615,0,-0.500613,0.853012,0.147503,0.0746584,-0.127213,0.989062,1.99985,2.43635,-3.77509> }}
union{cone{<1.11696,3.94073,-3.51495> ,0.203657,<0.348064,5.44332,-3.08446> ,0.191314}
sphere{<1.11696,3.94073,-3.51495> ,0.203657}
texture{txttree matrix <0.890217,0.455537,0,-0.441407,0.862604,0.247133,0.112578,-0.220002,0.968982,1.11696,3.94073,-3.51495> }}
union{cone{<0.348064,5.44332,-3.08446> ,0.191314,<0.0892973,7.12287,-3.1541> ,0.178971}
sphere{<0.348064,5.44332,-3.08446> ,0.191314}
texture{txttree matrix <0.988338,0.152273,0,-0.152145,0.98751,-0.0409473,-0.00623516,0.0404698,0.999161,0.348064,5.44332,-3.08446> }}
union{cone{<0.0892973,7.12287,-3.1541> ,0.178971,<0.0548697,8.85141,-3.37604> ,0.166629}
sphere{<0.0892973,7.12287,-3.1541> ,0.178971}
texture{txttree matrix <0.999802,0.0199131,0,-0.019751,0.991664,-0.127324,-0.00253542,0.127299,0.991861,0.0892973,7.12287,-3.1541> }}
union{cone{<0.0548697,8.85141,-3.37604> ,0.166629,<-0.667698,10.4722,-3.6647> ,0.154286}
sphere{<0.0548697,8.85141,-3.37604> ,0.166629}
texture{txttree matrix <0.913344,0.407188,0,-0.401905,0.901495,-0.16056,-0.0653781,0.146647,0.987026,0.0548697,8.85141,-3.37604> }}
union{cone{<-0.667698,10.4722,-3.6647> ,0.154286,<-0.713901,12.1287,-4.04203> ,0.141943}
sphere{<-0.667698,10.4722,-3.6647> ,0.154286}
texture{txttree matrix <0.999611,0.0278801,0,-0.0271844,0.974666,-0.222006,-0.00618955,0.221919,0.975045,-0.667698,10.4722,-3.6647> }}
union{cone{<-0.713901,12.1287,-4.04203> ,0.141943,<-1.37413,13.7954,-4.24575> ,0.1296}
sphere{<-0.713901,12.1287,-4.04203> ,0.141943}
texture{txttree matrix <0.929712,0.368287,0,-0.365932,0.923766,-0.112915,-0.0415853,0.104979,0.993605,-0.713901,12.1287,-4.04203> }}
union{cone{<-1.37413,13.7954,-4.24575> ,0.1296,<-2.01449,17.0597,-3.84796> ,0.12096}
sphere{<-1.37413,13.7954,-4.24575> ,0.1296}
texture{txttree matrix <0.981296,0.192506,0,-0.191144,0.974354,0.118738,0.0228578,-0.116517,0.992926,-1.37413,13.7954,-4.24575> }}
union{cone{<-2.01449,17.0597,-3.84796> ,0.12096,<-3.31241,20.2028,-3.94567> ,0.11232}
sphere{<-2.01449,17.0597,-3.84796> ,0.12096}
texture{txttree matrix <0.924296,0.381675,0,-0.381518,0.923915,-0.0287231,-0.0109629,0.0265487,0.999587,-2.01449,17.0597,-3.84796> }}
union{cone{<-3.31241,20.2028,-3.94567> ,0.11232,<-4.6786,22.9961,-3.4215> ,0.10368}
sphere{<-3.31241,20.2028,-3.94567> ,0.11232}
texture{txttree matrix <0.898314,0.439355,0,-0.433242,0.885817,0.166222,0.0730306,-0.14932,0.986088,-3.31241,20.2028,-3.94567> }}
union{cone{<-4.6786,22.9961,-3.4215> ,0.10368,<-5.39841,26.0432,-2.88003> ,0.09504}
sphere{<-4.6786,22.9961,-3.4215> ,0.10368}
texture{txttree matrix <0.973213,0.229907,0,-0.226544,0.958977,0.170416,0.0391798,-0.165851,0.985372,-4.6786,22.9961,-3.4215> }}
union{cone{<-5.39841,26.0432,-2.88003> ,0.09504,<-5.41444,29.1079,-3.71956> ,0.0864}
sphere{<-5.39841,26.0432,-2.88003> ,0.09504}
texture{txttree matrix <0.999986,0.0052289,0,-0.00504311,0.964456,-0.264197,-0.00138146,0.264193,0.964469,-5.39841,26.0432,-2.88003> }}
union{cone{<-5.41444,29.1079,-3.71956> ,0.0864,<-6.23846,32.2649,-3.62585> ,0.07776}
sphere{<-5.41444,29.1079,-3.71956> ,0.0864}
texture{txttree matrix <0.967582,0.252556,0,-0.252452,0.967183,0.0287098,0.00725085,-0.0277791,0.999588,-5.41444,29.1079,-3.71956> }}
union{cone{<-1.03175,12.9311,-4.1401> ,0.1296,<-2.14997,15.8578,-4.33133> ,0.12096}
sphere{<-1.03175,12.9311,-4.1401> ,0.1296}
texture{txttree matrix <0.934136,0.356916,0,-0.356253,0.932401,-0.0609214,-0.0217438,0.0569089,0.998143,-1.03175,12.9311,-4.1401> }}
union{cone{<-2.14997,15.8578,-4.33133> ,0.12096,<-1.71855,18.4403,-6.35283> ,0.11232}
sphere{<-2.14997,15.8578,-4.33133> ,0.12096}
texture{txttree matrix <0.986332,-0.164768,0,0.130421,0.780723,-0.611115,0.100692,0.602762,0.791542,-2.14997,15.8578,-4.33133> }}
union{cone{<-1.71855,18.4403,-6.35283> ,0.11232,<-1.39695,21.3182,-8.16468> ,0.10368}
sphere{<-1.71855,18.4403,-6.35283> ,0.11232}
texture{txttree matrix <0.993814,-0.11106,0,0.0941494,0.842491,-0.53042,0.0589084,0.527139,0.847735,-1.71855,18.4403,-6.35283> }}
union{cone{<-1.39695,21.3182,-8.16468> ,0.10368,<-1.0639,24.1011,-9.61271> ,0.09504}
sphere{<-1.39695,21.3182,-8.16468> ,0.10368}
texture{txttree matrix <0.992915,-0.118827,0,0.105571,0.882141,-0.459001,0.0545419,0.455749,0.888436,-1.39695,21.3182,-8.16468> }}
union{cone{<-1.0639,24.1011,-9.61271> ,0.09504,<-0.619764,26.8178,-11.3967> ,0.0864}
sphere{<-1.0639,24.1011,-9.61271> ,0.09504}
texture{txttree matrix <0.986899,-0.161341,0,0.135395,0.828191,-0.543845,0.0877443,0.53672,0.839186,-1.0639,24.1011,-9.61271> }}
union{cone{<-0.619764,26.8178,-11.3967> ,0.0864,<-0.248197,29.4795,-13.0909> ,0.07776}
sphere{<-0.619764,26.8178,-11.3967> ,0.0864}
texture{txttree matrix <0.990396,-0.13826,0,0.116959,0.837813,-0.533283,0.0737316,0.528161,0.845937,-0.619764,26.8178,-11.3967> }}
union{cone{<0.263877,5.98974,-3.10712> ,0.1296,<-2.11784,7.97623,-3.48448> ,0.12096}
sphere{<0.263877,5.98974,-3.10712> ,0.1296}
texture{txttree matrix <0.640512,0.767948,0,-0.762326,0.635823,-0.120783,-0.092755,0.0773629,0.992679,0.263877,5.98974,-3.10712> }}
union{cone{<-2.11784,7.97623,-3.48448> ,0.12096,<-3.35493,10.9716,-2.88151> ,0.11232}
sphere{<-2.11784,7.97623,-3.48448> ,0.12096}
texture{txttree matrix <0.924276,0.381725,0,-0.375285,0.908682,0.182916,0.0698234,-0.169065,0.983129,-2.11784,7.97623,-3.48448> }}
union{cone{<-3.35493,10.9716,-2.88151> ,0.11232,<-4.10255,14.0783,-2.69121> ,0.10368}
sphere{<-3.35493,10.9716,-2.88151> ,0.11232}
texture{txttree matrix <0.972245,0.233967,0,-0.233553,0.970525,0.0594491,0.0139091,-0.0577991,0.998231,-3.35493,10.9716,-2.88151> }}
union{cone{<-4.10255,14.0783,-2.69121> ,0.10368,<-6.20399,16.4842,-3.54284> ,0.09504}
sphere{<-4.10255,14.0783,-2.69121> ,0.10368}
texture{txttree matrix <0.753148,0.657851,0,-0.635649,0.72773,-0.257603,-0.169464,0.194013,0.966251,-4.10255,14.0783,-2.69121> }}
union{cone{<-6.20399,16.4842,-3.54284> ,0.09504,<-7.11067,19.5678,-3.83266> ,0.0864}
sphere{<-6.20399,16.4842,-3.54284> ,0.09504}
texture{txttree matrix <0.959387,0.282093,0,-0.280953,0.95551,-0.0898072,-0.025334,0.0861598,0.995959,-6.20399,16.4842,-3.54284> }}
union{cone{<-7.11067,19.5678,-3.83266> ,0.0864,<-8.90351,22.1303,-4.93228> ,0.07776}
sphere{<-7.11067,19.5678,-3.83266> ,0.0864}
texture{txttree matrix <0.819376,0.573256,0,-0.540803,0.772989,-0.331694,-0.190146,0.271782,0.943387,-7.11067,19.5678,-3.83266> }}
union{cone{<0.915721,0.898721,-1.60879> ,0.36,<1.3728,0.61319,-2.43038> ,0.342}
sphere{<0.915721,0.898721,-1.60879> ,0.36}
texture{txttree matrix <-0.529807,-0.848118,0,0.465182,-0.290592,-0.836159,0.709162,-0.443003,0.548487,0.915721,0.898721,-1.60879> }}
union{cone{<1.3728,0.61319,-2.43038> ,0.342,<1.71269,0.501416,-3.27273> ,0.324}
sphere{<1.3728,0.61319,-2.43038> ,0.342}
texture{txttree matrix <-0.312399,-0.949951,0,0.371386,-0.122133,-0.920411,0.874345,-0.287535,0.390953,1.3728,0.61319,-2.43038> }}
union{cone{<1.71269,0.501416,-3.27273> ,0.324,<1.78079,0.621339,-4.18793> ,0.306}
sphere{<1.71269,0.501416,-3.27273> ,0.324}
texture{txttree matrix <0.869565,-0.493818,0,0.0735827,0.129572,-0.988836,0.488305,0.859858,0.149008,1.71269,0.501416,-3.27273> }}
union{cone{<1.78079,0.621339,-4.18793> ,0.306,<1.69627,0.739959,-5.0932> ,0.288}
sphere{<1.78079,0.621339,-4.18793> ,0.306}
texture{txttree matrix <0.814407,0.580294,0,-0.0921805,0.12937,-0.987303,-0.572926,0.804066,0.158851,1.78079,0.621339,-4.18793> }}
union{cone{<1.69627,0.739959,-5.0932> ,0.288,<1.77801,0.505219,-5.98996> ,0.27}
sphere{<1.69627,0.739959,-5.0932> ,0.288}
texture{txttree matrix <-0.944381,-0.328853,0,0.0878395,-0.252252,-0.963666,0.316905,-0.910068,0.267108,1.69627,0.739959,-5.0932> }}
union{cone{<1.77801,0.505219,-5.98996> ,0.27,<1.61851,0.540937,-6.87746> ,0.252}
sphere{<1.77801,0.505219,-5.98996> ,0.27}
texture{txttree matrix <0.218526,0.975831,0,-0.176743,0.0395796,-0.983461,-0.959692,0.214912,0.181121,1.77801,0.505219,-5.98996> }}
union{cone{<1.61851,0.540937,-6.87746> ,0.252,<1.80109,0.607145,-7.85856> ,0.234}
sphere{<1.61851,0.540937,-6.87746> ,0.252}
texture{txttree matrix <0.340904,-0.940098,0,0.182555,0.0661992,-0.980964,0.922203,0.334414,0.194187,1.61851,0.540937,-6.87746> }}
union{cone{<1.80109,0.607145,-7.85856> ,0.234,<1.92616,0.907342,-8.8126> ,0.216}
sphere{<1.80109,0.607145,-7.85856> ,0.234}
texture{txttree matrix <0.923093,-0.384576,0,0.124082,0.297832,-0.94652,0.364009,0.873726,0.322645,1.80109,0.607145,-7.85856> }}
union{cone{<1.92616,0.907342,-8.8126> ,0.216,<1.93282,2.02038,-10.1395> ,0.203657}
sphere{<1.92616,0.907342,-8.8126> ,0.216}
texture{txttree matrix <0.999982,-0.00598462,0,0.00384619,0.642669,-0.766135,0.00458502,0.766121,0.64268,1.92616,0.907342,-8.8126> }}
union{cone{<1.93282,2.02038,-10.1395> ,0.203657,<2.43569,3.20094,-11.2598> ,0.191314}
sphere{<1.93282,2.02038,-10.1395> ,0.203657}
texture{txttree matrix <0.920012,-0.391889,0,0.295207,0.693037,-0.657688,0.257741,0.605081,0.753291,1.93282,2.02038,-10.1395> }}
union{cone{<2.43569,3.20094,-11.2598> ,0.191314,<3.32574,4.3188,-12.3574> ,0.178971}
sphere{<2.43569,3.20094,-11.2598> ,0.191314}
texture{txttree matrix <0.782313,-0.622886,0,0.493975,0.620407,-0.609166,0.379441,0.476559,0.793042,2.43569,3.20094,-11.2598> }}
union{cone{<3.32574,4.3188,-12.3574> ,0.178971,<4.11922,5.53284,-13.221> ,0.166629}
sphere{<3.32574,4.3188,-12.3574> ,0.178971}
texture{txttree matrix <0.837071,-0.547095,0,0.470071,0.719223,-0.511617,0.279903,0.42826,0.859214,3.32574,4.3188,-12.3574> }}
union{cone{<4.11922,5.53284,-13.221> ,0.166629,<4.26251,6.92323,-14.3754> ,0.154286}
sphere{<4.11922,5.53284,-13.221> ,0.166629}
texture{txttree matrix <0.994731,-0.102516,0,0.0790434,0.766975,-0.636789,0.0652809,0.633434,0.771038,4.11922,5.53284,-13.221> }}
union{cone{<4.26251,6.92323,-14.3754> ,0.154286,<4.79998,8.13567,-15.6387> ,0.141943}
sphere{<4.26251,6.92323,-14.3754> ,0.154286}
texture{txttree matrix <0.914202,-0.40526,0,0.293443,0.661962,-0.689709,0.279511,0.630533,0.724087,4.26251,6.92323,-14.3754> }}
union{cone{<4.79998,8.13567,-15.6387> ,0.141943,<5.29669,9.52086,-16.4473> ,0.1296}
sphere{<4.79998,8.13567,-15.6387> ,0.141943}
texture{txttree matrix <0.941311,-0.337539,0,0.295814,0.824951,-0.481611,0.162563,0.453346,0.876385,4.79998,8.13567,-15.6387> }}
union{cone{<5.29669,9.52086,-16.4473> ,0.1296,<7.38839,11.8262,-16.6268> ,0.12096}
sphere{<5.29669,9.52086,-16.4473> ,0.1296}
texture{txttree matrix <0.740584,-0.671964,0,0.67085,0.739356,-0.0575533,0.0386737,0.042623,0.998342,5.29669,9.52086,-16.4473> }}
union{cone{<7.38839,11.8262,-16.6268> ,0.12096,<8.27305,14.6116,-17.7138> ,0.11232}
sphere{<7.38839,11.8262,-16.6268> ,0.12096}
texture{txttree matrix <0.953084,-0.302705,0,0.283715,0.893291,-0.348621,0.105529,0.332265,0.937264,7.38839,11.8262,-16.6268> }}
union{cone{<8.27305,14.6116,-17.7138> ,0.11232,<8.16675,17.6906,-18.4156> ,0.10368}
sphere{<8.27305,14.6116,-17.7138> ,0.11232}
texture{txttree matrix <0.999405,0.0345025,0,-0.0336409,0.974446,-0.222087,-0.00766257,0.221955,0.975027,8.27305,14.6116,-17.7138> }}
union{cone{<8.16675,17.6906,-18.4156> ,0.10368,<9.14375,20.763,-19.107> ,0.09504}
sphere{<8.16675,17.6906,-18.4156> ,0.10368}
texture{txttree matrix <0.952978,-0.30304,0,0.296302,0.93179,-0.209697,0.0635466,0.199837,0.977766,8.16675,17.6906,-18.4156> }}
union{cone{<9.14375,20.763,-19.107> ,0.09504,<10.4989,23.2815,-20.5827> ,0.0864}
sphere{<9.14375,20.763,-19.107> ,0.09504}
texture{txttree matrix <0.880612,-0.473838,0,0.42109,0.782582,-0.458529,0.217269,0.403786,0.888679,9.14375,20.763,-19.107> }}
union{cone{<10.4989,23.2815,-20.5827> ,0.0864,<11.3736,26.0499,-21.7349> ,0.07776}
sphere{<10.4989,23.2815,-20.5827> ,0.0864}
texture{txttree matrix <0.953541,-0.301265,0,0.280019,0.886294,-0.368881,0.111131,0.351743,0.929477,10.4989,23.2815,-20.5827> }}
union{cone{<1.93087,1.69343,-9.7497> ,0.1296,<3.94616,3.69579,-11.5041> ,0.12096}
sphere{<1.93087,1.69343,-9.7497> ,0.1296}
texture{txttree matrix <0.704827,-0.709379,0,0.603569,0.599696,-0.525423,0.372724,0.370333,0.850841,1.93087,1.69343,-9.7497> }}
union{cone{<3.94616,3.69579,-11.5041> ,0.12096,<5.14191,6.32686,-12.7243> ,0.11232}
sphere{<3.94616,3.69579,-11.5041> ,0.12096}
texture{txttree matrix <0.910391,-0.41375,0,0.381169,0.838703,-0.388957,0.160931,0.354103,0.921256,3.94616,3.69579,-11.5041> }}
union{cone{<5.14191,6.32686,-12.7243> ,0.11232,<6.80452,8.74735,-14.3667> ,0.10368}
sphere{<5.14191,6.32686,-12.7243> ,0.11232}
texture{txttree matrix <0.824277,-0.566187,0,0.494146,0.719395,-0.48815,0.276384,0.402371,0.87276,5.14191,6.32686,-12.7243> }}
union{cone{<6.80452,8.74735,-14.3667> ,0.10368,<7.18231,10.8423,-16.7059> ,0.09504}
sphere{<6.80452,8.74735,-14.3667> ,0.10368}
texture{txttree matrix <0.984126,-0.17747,0,0.119446,0.662365,-0.739598,0.131257,0.727858,0.673049,6.80452,8.74735,-14.3667> }}
union{cone{<7.18231,10.8423,-16.7059> ,0.09504,<7.50938,13.6702,-18.418> ,0.0864}
sphere{<7.18231,10.8423,-16.7059> ,0.09504}
texture{txttree matrix <0.993378,-0.114891,0,0.0984568,0.851286,-0.515381,0.0592124,0.511968,0.856961,7.18231,10.8423,-16.7059> }}
union{cone{<7.50938,13.6702,-18.418> ,0.0864,<8.50709,15.856,-20.809> ,0.07776}
sphere{<7.50938,13.6702,-18.418> ,0.0864}
texture{txttree matrix <0.909711,-0.415241,0,0.294339,0.644838,-0.705371,0.292899,0.641684,0.708838,7.50938,13.6702,-18.418> }}
union{cone{<2.57306,3.37347,-11.4292> ,0.1296,<3.76008,3.83026,-14.3971> ,0.12096}
sphere{<2.57306,3.37347,-11.4292> ,0.1296}
texture{txttree matrix <0.359149,-0.93328,0,0.367624,0.141471,-0.919151,0.857826,0.330112,0.393905,2.57306,3.37347,-11.4292> }}
union{cone{<3.76008,3.83026,-14.3971> ,0.12096,<4.35863,5.97349,-16.8786> ,0.11232}
sphere{<3.76008,3.83026,-14.3971> ,0.12096}
texture{txttree matrix <0.963145,-0.268983,0,0.179577,0.643012,-0.744505,0.200259,0.717066,0.667617,3.76008,3.83026,-14.3971> }}
union{cone{<4.35863,5.97349,-16.8786> ,0.11232,<4.72806,7.55128,-19.6134> ,0.10368}
sphere{<4.35863,5.97349,-16.8786> ,0.11232}
texture{txttree matrix <0.973666,-0.22798,0,0.116214,0.496334,-0.860318,0.196135,0.837662,0.509758,4.35863,5.97349,-16.8786> }}
union{cone{<4.72806,7.55128,-19.6134> ,0.10368,<5.5549,10.015,-21.8119> ,0.09504}
sphere{<4.72806,7.55128,-19.6134> ,0.10368}
texture{txttree matrix <0.948035,-0.318166,0,0.242906,0.723783,-0.645859,0.205491,0.612297,0.763456,4.72806,7.55128,-19.6134> }}
union{cone{<5.5549,10.015,-21.8119> ,0.09504,<6.02951,11.3426,-24.7344> ,0.0864}
sphere{<5.5549,10.015,-21.8119> ,0.09504}
texture{txttree matrix <0.941638,-0.336627,0,0.146266,0.409147,-0.900669,0.303189,0.848105,0.434505,5.5549,10.015,-21.8119> }}
union{cone{<6.02951,11.3426,-24.7344> ,0.0864,<6.27827,12.9204,-27.4379> ,0.07776}
sphere{<6.02951,11.3426,-24.7344> ,0.0864}
texture{txttree matrix <0.987799,-0.155734,0,0.0792178,0.502467,-0.86096,0.134081,0.850455,0.508673,6.02951,11.3426,-24.7344> }}
union{cone{<4.0498,5.42662,-13.1455> ,0.1296,<5.02972,7.6922,-15.2932> ,0.12096}
sphere{<4.0498,5.42662,-13.1455> ,0.1296}
texture{txttree matrix <0.917825,-0.396985,0,0.299491,0.69242,-0.6564,0.260581,0.60246,0.754413,4.0498,5.42662,-13.1455> }}
union{cone{<5.02972,7.6922,-15.2932> ,0.12096,<6.53627,10.1367,-16.8824> ,0.11232}
sphere{<5.02972,7.6922,-15.2932> ,0.12096}
texture{txttree matrix <0.851312,-0.524659,0,0.459045,0.744846,-0.484234,0.254058,0.412234,0.874939,5.02972,7.6922,-15.2932> }}
union{cone{<6.53627,10.1367,-16.8824> ,0.11232,<7.84156,12.5362,-18.4658> ,0.10368}
sphere{<6.53627,10.1367,-16.8824> ,0.11232}
texture{txttree matrix <0.878434,-0.477863,0,0.413423,0.759977,-0.501514,0.239655,0.440547,0.86515,6.53627,10.1367,-16.8824> }}
union{cone{<7.84156,12.5362,-18.4658> ,0.10368,<8.38828,15.2577,-20.2891> ,0.09504}
sphere{<7.84156,12.5362,-18.4658> ,0.10368}
texture{txttree matrix <0.980414,-0.196949,0,0.164616,0.819464,-0.548981,0.108121,0.538229,0.835835,7.84156,12.5362,-18.4658> }}
union{cone{<8.38828,15.2577,-20.2891> ,0.09504,<8.75662,18.2291,-21.2454> ,0.0864}
sphere{<8.38828,15.2577,-20.2891> ,0.09504}
texture{txttree matrix <0.992404,-0.123022,0,0.117189,0.945348,-0.304275,0.0374325,0.301963,0.952584,8.38828,15.2577,-20.2891> }}
union{cone{<8.75662,18.2291,-21.2454> ,0.0864,<8.56796,21.002,-22.8489> ,0.07776}
sphere{<8.75662,18.2291,-21.2454> ,0.0864}
texture{txttree matrix <0.997694,0.0678767,0,-0.058794,0.86419,-0.499718,-0.0339192,0.498565,0.866188,8.75662,18.2291,-21.2454> }}
union{cone{<1.91475,0.879958,-8.72557> ,0.216,<3.27149,1.38833,-9.80542> ,0.203657}
sphere{<1.91475,0.879958,-8.72557> ,0.216}
texture{txttree matrix <0.350877,-0.936421,0,0.750824,0.281334,-0.597591,0.559597,0.209681,0.801801,1.91475,0.879958,-8.72557> }}
union{cone{<3.27149,1.38833,-9.80542> ,0.203657,<4.3816,1.44915,-11.2703> ,0.191314}
sphere{<3.27149,1.38833,-9.80542> ,0.203657}
texture{txttree matrix <0.0547029,-0.998503,0,0.603638,0.0330703,-0.796572,0.79538,0.0435748,0.604543,3.27149,1.38833,-9.80542> }}
union{cone{<4.3816,1.44915,-11.2703> ,0.191314,<4.94042,2.20227,-12.7179> ,0.178971}
sphere{<4.3816,1.44915,-11.2703> ,0.191314}
texture{txttree matrix <0.80307,-0.595885,0,0.324001,0.436653,-0.83926,0.500103,0.673984,0.54373,4.3816,1.44915,-11.2703> }}
union{cone{<4.94042,2.20227,-12.7179> ,0.178971,<5.68746,3.0009,-14.0751> ,0.166629}
sphere{<4.94042,2.20227,-12.7179> ,0.178971}
texture{txttree matrix <0.730306,-0.683121,0,0.428591,0.458195,-0.778696,0.531943,0.568686,0.627401,4.94042,2.20227,-12.7179> }}
union{cone{<5.68746,3.0009,-14.0751> ,0.166629,<6.26878,4.10111,-15.2121> ,0.154286}
sphere{<5.68746,3.0009,-14.0751> ,0.166629}
texture{txttree matrix <0.884168,-0.467169,0,0.344884,0.652731,-0.674535,0.315122,0.596402,0.738243,5.68746,3.0009,-14.0751> }}
union{cone{<6.26878,4.10111,-15.2121> ,0.154286,<7.22103,4.49917,-16.553> ,0.141943}
sphere{<6.26878,4.10111,-15.2121> ,0.154286}
texture{txttree matrix <0.385672,-0.922636,0,0.562758,0.235239,-0.792443,0.731136,0.305623,0.609946,6.26878,4.10111,-15.2121> }}
union{cone{<7.22103,4.49917,-16.553> ,0.141943,<7.63106,5.10538,-18.0755> ,0.1296}
sphere{<7.22103,4.49917,-16.553> ,0.141943}
texture{txttree matrix <0.82832,-0.560255,0,0.242727,0.358865,-0.901277,0.504945,0.746546,0.433244,7.22103,4.49917,-16.553> }}
union{cone{<7.63106,5.10538,-18.0755> ,0.1296,<7.88108,7.64538,-20.1724> ,0.12096}
sphere{<7.63106,5.10538,-18.0755> ,0.1296}
texture{txttree matrix <0.99519,-0.0979606,0,0.0756909,0.76895,-0.634812,0.0621866,0.631759,0.772667,7.63106,5.10538,-18.0755> }}
union{cone{<7.88108,7.64538,-20.1724> ,0.12096,<8.49007,9.9841,-22.5612> ,0.11232}
sphere{<7.88108,7.64538,-20.1724> ,0.12096}
texture{txttree matrix <0.96773,-0.251991,0,0.179216,0.688251,-0.702988,0.177146,0.680303,0.711201,7.88108,7.64538,-20.1724> }}
union{cone{<8.49007,9.9841,-22.5612> ,0.11232,<9.72595,12.2692,-24.3247> ,0.10368}
sphere{<8.49007,9.9841,-22.5612> ,0.11232}
texture{txttree matrix <0.879595,-0.475723,0,0.393602,0.727756,-0.561648,0.267189,0.494023,0.827376,8.49007,9.9841,-22.5612> }}
union{cone{<9.72595,12.2692,-24.3247> ,0.10368,<9.98874,14.5957,-26.4645> ,0.09504}
sphere{<9.72595,12.2692,-24.3247> ,0.10368}
texture{txttree matrix <0.993681,-0.112243,0,0.0828523,0.733486,-0.674636,0.0757231,0.670372,0.738151,9.72595,12.2692,-24.3247> }}
union{cone{<9.98874,14.5957,-26.4645> ,0.09504,<11.3821,16.7788,-28.4999> ,0.0864}
sphere{<9.98874,14.5957,-26.4645> ,0.09504}
texture{txttree matrix <0.842938,-0.538011,0,0.423013,0.662762,-0.617905,0.33244,0.520856,0.786253,9.98874,14.5957,-26.4645> }}
union{cone{<11.3821,16.7788,-28.4999> ,0.0864,<12.1276,18.2059,-31.2526> ,0.07776}
sphere{<11.3821,16.7788,-28.4999> ,0.0864}
texture{txttree matrix <0.886356,-0.463004,0,0.233766,0.447511,-0.863185,0.399658,0.765089,0.504889,11.3821,16.7788,-28.4999> }}
union{cone{<7.18454,4.48391,-16.5016> ,0.1296,<8.7115,3.61994,-19.3447> ,0.12096}
sphere{<7.18454,4.48391,-16.5016> ,0.1296}
texture{txttree matrix <-0.49245,-0.870341,0,0.457064,-0.258613,-0.851006,0.740665,-0.419078,0.525156,7.18454,4.48391,-16.5016> }}
union{cone{<8.7115,3.61994,-19.3447> ,0.12096,<10.8457,4.21649,-21.6479> ,0.11232}
sphere{<8.7115,3.61994,-19.3447> ,0.12096}
texture{txttree matrix <0.269198,-0.963085,0,0.667731,0.186642,-0.720625,0.694023,0.193991,0.693325,8.7115,3.61994,-19.3447> }}
union{cone{<10.8457,4.21649,-21.6479> ,0.11232,<13.5665,5.08761,-23.3236> ,0.10368}
sphere{<10.8457,4.21649,-21.6479> ,0.11232}
texture{txttree matrix <0.304931,-0.952374,0,0.821481,0.263022,-0.505953,0.481856,0.154281,0.862561,10.8457,4.21649,-21.6479> }}
union{cone{<13.5665,5.08761,-23.3236> ,0.10368,<15.5606,6.23357,-25.7465> ,0.09504}
sphere{<13.5665,5.08761,-23.3236> ,0.10368}
texture{txttree matrix <0.498248,-0.867035,0,0.596929,0.343029,-0.725263,0.628829,0.361361,0.688471,13.5665,5.08761,-23.3236> }}
union{cone{<15.5606,6.23357,-25.7465> ,0.09504,<16.8999,6.45201,-28.7192> ,0.0864}
sphere{<15.5606,6.23357,-25.7465> ,0.09504}
texture{txttree matrix <0.160977,-0.986958,0,0.409848,0.0668481,-0.909701,0.897837,0.146441,0.415264,15.5606,6.23357,-25.7465> }}
union{cone{<16.8999,6.45201,-28.7192> ,0.0864,<18.7135,6.99219,-31.2441> ,0.07776}
sphere{<16.8999,6.45201,-28.7192> ,0.0864}
texture{txttree matrix <0.28545,-0.958394,0,0.574783,0.171195,-0.800198,0.766904,0.228416,0.599736,16.8999,6.45201,-28.7192> }}
union{cone{<2.7301,1.18547,-9.37452> ,0.1296,<4.59878,1.73088,-12.1685> ,0.12096}
sphere{<2.7301,1.18547,-9.37452> ,0.1296}
texture{txttree matrix <0.280179,-0.959948,0,0.548757,0.160165,-0.820495,0.787633,0.229885,0.571653,2.7301,1.18547,-9.37452> }}
union{cone{<4.59878,1.73088,-12.1685> ,0.12096,<6.13771,3.22798,-14.7538> ,0.11232}
sphere{<4.59878,1.73088,-12.1685> ,0.12096}
texture{txttree matrix <0.697299,-0.71678,0,0.457947,0.445501,-0.769294,0.551415,0.536428,0.638895,4.59878,1.73088,-12.1685> }}
union{cone{<6.13771,3.22798,-14.7538> ,0.11232,<7.36476,5.63027,-16.8418> ,0.10368}
sphere{<6.13771,3.22798,-14.7538> ,0.11232}
texture{txttree matrix <0.890553,-0.454879,0,0.359709,0.704232,-0.6121,0.278431,0.545108,0.79078,6.13771,3.22798,-14.7538> }}
union{cone{<7.36476,5.63027,-16.8418> ,0.10368,<8.74099,6.63416,-19.6459> ,0.09504}
sphere{<7.36476,5.63027,-16.8418> ,0.10368}
texture{txttree matrix <0.589318,-0.807901,0,0.419452,0.305966,-0.854661,0.690482,0.503667,0.519187,7.36476,5.63027,-16.8418> }}
union{cone{<8.74099,6.63416,-19.6459> ,0.09504,<9.96534,7.76068,-22.6309> ,0.0864}
sphere{<8.74099,6.63416,-19.6459> ,0.09504}
texture{txttree matrix <0.677095,-0.735895,0,0.358273,0.329646,-0.873484,0.642792,0.591432,0.486854,8.74099,6.63416,-19.6459> }}
union{cone{<9.96534,7.76068,-22.6309> ,0.0864,<10.9313,9.21212,-25.4309> ,0.07776}
sphere{<9.96534,7.76068,-22.6309> ,0.0864}
texture{txttree matrix <0.832506,-0.554016,0,0.292839,0.440042,-0.848887,0.470297,0.706703,0.528575,9.96534,7.76068,-22.6309> }}
union{cone{<5.45441,2.75176,-13.6517> ,0.1296,<5.6045,5.13673,-15.6857> ,0.12096}
sphere{<5.45441,2.75176,-13.6517> ,0.1296}
texture{txttree matrix <0.998026,-0.062804,0,0.0478253,0.759999,-0.648163,0.0407072,0.646883,0.761502,5.45441,2.75176,-13.6517> }}
union{cone{<5.6045,5.13673,-15.6857> ,0.12096,<5.48016,7.66777,-17.8441> ,0.11232}
sphere{<5.6045,5.13673,-15.6857> ,0.12096}
texture{txttree matrix <0.998796,0.0490651,0,-0.0373529,0.760374,-0.64841,-0.0318143,0.647629,0.761291,5.6045,5.13673,-15.6857> }}
union{cone{<5.48016,7.66777,-17.8441> ,0.11232,<5.61148,10.1974,-19.8144> ,0.10368}
sphere{<5.48016,7.66777,-17.8441> ,0.11232}
texture{txttree matrix <0.998655,-0.0518417,0,0.0409196,0.788258,-0.613983,0.0318299,0.613158,0.789319,5.48016,7.66777,-17.8441> }}
union{cone{<5.61148,10.1974,-19.8144> ,0.10368,<5.82271,12.9486,-21.3162> ,0.09504}
sphere{<5.61148,10.1974,-19.8144> ,0.10368}
texture{txttree matrix <0.997065,-0.0765547,0,0.0672409,0.87576,-0.478041,0.0365963,0.476638,0.878338,5.61148,10.1974,-19.8144> }}
union{cone{<5.82271,12.9486,-21.3162> ,0.09504,<5.71407,15.6356,-23.2612> ,0.0864}
sphere{<5.82271,12.9486,-21.3162> ,0.09504}
texture{txttree matrix <0.999184,0.0403973,0,-0.0327335,0.809627,-0.586031,-0.0236741,0.585553,0.810288,5.82271,12.9486,-21.3162> }}
union{cone{<5.71407,15.6356,-23.2612> ,0.0864,<5.72881,17.5983,-25.7956> ,0.07776}
sphere{<5.71407,15.6356,-23.2612> ,0.0864}
texture{txttree matrix <0.999972,-0.00750647,0,0.0045961,0.612268,-0.790637,0.00593489,0.790615,0.612285,5.71407,15.6356,-23.2612> }}
union{cone{<1.19791,0.722444,-2.11601> ,0.216,<0.531547,0.5,-3.32545> ,0.203657}
sphere{<1.19791,0.722444,-2.11601> ,0.216}
texture{txttree matrix <-0.316643,0.948545,0,-0.476427,-0.159041,-0.86471,-0.820216,-0.273804,0.502272,1.19791,0.722444,-2.11601> }}
union{cone{<0.531547,0.5,-3.32545> ,0.203657,<-0.222587,0.564725,-4.84774> ,0.191314}
sphere{<0.531547,0.5,-3.32545> ,0.203657}
texture{txttree matrix <0.0855119,0.996337,0,-0.443588,0.0380715,-0.895422,-0.892142,0.0765692,0.445219,0.531547,0.5,-3.32545> }}
union{cone{<-0.222587,0.564725,-4.84774> ,0.191314,<-0.00312072,0.718403,-6.56994> ,0.178971}
sphere{<-0.222587,0.564725,-4.84774> ,0.191314}
texture{txttree matrix <0.573593,-0.81914,0,0.125919,0.0881731,-0.988114,0.809404,0.566775,0.153721,-0.222587,0.564725,-4.84774> }}
union{cone{<-0.00312072,0.718403,-6.56994> ,0.178971,<-0.605544,0.761193,-8.11923> ,0.166629}
sphere{<-0.00312072,0.718403,-6.56994> ,0.178971}
texture{txttree matrix <0.0708509,0.997487,0,-0.362286,0.025733,-0.931712,-0.92937,0.0660126,0.363199,-0.00312072,0.718403,-6.56994> }}
union{cone{<-0.605544,0.761193,-8.11923> ,0.166629,<-0.463233,0.65055,-9.87983> ,0.154286}
sphere{<-0.605544,0.761193,-8.11923> ,0.166629}
texture{txttree matrix <-0.613791,-0.789469,0,0.0804103,-0.0625168,-0.994799,0.785363,-0.610599,0.101854,-0.605544,0.761193,-8.11923> }}
union{cone{<-0.463233,0.65055,-9.87983> ,0.154286,<-0.218823,0.761113,-11.6979> ,0.141943}
sphere{<-0.463233,0.65055,-9.87983> ,0.154286}
texture{txttree matrix <0.412156,-0.911113,0,0.132995,0.0601625,-0.989289,0.901354,0.407742,0.14597,-0.463233,0.65055,-9.87983> }}
union{cone{<-0.218823,0.761113,-11.6979> ,0.141943,<-0.323978,1.12687,-13.4935> ,0.1296}
sphere{<-0.218823,0.761113,-11.6979> ,0.141943}
texture{txttree matrix <0.961069,0.276309,0,-0.057289,0.199264,-0.97827,-0.270305,0.940184,0.207336,-0.218823,0.761113,-11.6979> }}
union{cone{<-0.323978,1.12687,-13.4935> ,0.1296,<-0.813149,4.02899,-15.257> ,0.12096}
sphere{<-0.323978,1.12687,-13.4935> ,0.1296}
texture{txttree matrix <0.98609,0.166212,0,-0.142577,0.84587,-0.51398,-0.0854294,0.506831,0.857802,-0.323978,1.12687,-13.4935> }}
union{cone{<-0.813149,4.02899,-15.257> ,0.12096,<-2.21576,5.46499,-17.9551> ,0.11232}
sphere{<-0.813149,4.02899,-15.257> ,0.12096}
texture{txttree matrix <0.715374,0.698742,0,-0.417082,0.427009,-0.802313,-0.56061,0.573953,0.596904,-0.813149,4.02899,-15.257> }}
union{cone{<-2.21576,5.46499,-17.9551> ,0.11232,<-3.52591,7.49971,-20.1697> ,0.10368}
sphere{<-2.21576,5.46499,-17.9551> ,0.11232}
texture{txttree matrix <0.84078,0.541376,0,-0.399383,0.620259,-0.675109,-0.365488,0.567618,0.737718,-2.21576,5.46499,-17.9551> }}
union{cone{<-3.52591,7.49971,-20.1697> ,0.10368,<-4.41764,9.60344,-22.3055> ,0.09504}
sphere{<-3.52591,7.49971,-20.1697> ,0.10368}
texture{txttree matrix <0.920702,0.390267,0,-0.28511,0.67262,-0.682858,-0.266497,0.628708,0.730551,-3.52591,7.49971,-20.1697> }}
union{cone{<-4.41764,9.60344,-22.3055> ,0.09504,<-4.36481,12.0719,-24.3273> ,0.0864}
sphere{<-4.41764,9.60344,-22.3055> ,0.09504}
texture{txttree matrix <0.999771,-0.0213945,0,0.0165527,0.773512,-0.633565,0.0135548,0.63342,0.773689,-4.41764,9.60344,-22.3055> }}
union{cone{<-4.36481,12.0719,-24.3273> ,0.0864,<-4.9216,13.908,-26.8879> ,0.07776}
sphere{<-4.36481,12.0719,-24.3273> ,0.0864}
texture{txttree matrix <0.956967,0.290197,0,-0.174014,0.573837,-0.800269,-0.232236,0.765831,0.599641,-4.36481,12.0719,-24.3273> }}
union{cone{<-0.289348,1.00642,-12.9022> ,0.1296,<-0.848735,2.61128,-15.546> ,0.12096}
sphere{<-0.289348,1.00642,-12.9022> ,0.1296}
texture{txttree matrix <0.944283,0.329136,0,-0.177979,0.510619,-0.841185,-0.276864,0.794316,0.540748,-0.289348,1.00642,-12.9022> }}
union{cone{<-0.848735,2.61128,-15.546> ,0.12096,<0.134565,4.68884,-18.0642> ,0.11232}
sphere{<-0.848735,2.61128,-15.546> ,0.12096}
texture{txttree matrix <0.903873,-0.4278,0,0.288407,0.609358,-0.738583,0.315966,0.667585,0.674163,-0.848735,2.61128,-15.546> }}
union{cone{<0.134565,4.68884,-18.0642> ,0.11232,<0.0603345,6.00915,-21.0015> ,0.10368}
sphere{<0.134565,4.68884,-18.0642> ,0.11232}
texture{txttree matrix <0.998423,0.0561337,0,-0.0230439,0.409871,-0.911852,-0.0511857,0.910415,0.410518,0.134565,4.68884,-18.0642> }}
union{cone{<0.0603345,6.00915,-21.0015> ,0.10368,<-0.208332,7.42486,-24.0191> ,0.09504}
sphere{<0.0603345,6.00915,-21.0015> ,0.10368}
texture{txttree matrix <0.982465,0.186448,0,-0.0803438,0.423362,-0.902391,-0.168249,0.886567,0.430918,0.0603345,6.00915,-21.0015> }}
union{cone{<-0.208332,7.42486,-24.0191> ,0.09504,<0.494646,9.70896,-26.4098> ,0.0864}
sphere{<-0.208332,7.42486,-24.0191> ,0.09504}
texture{txttree matrix <0.955758,-0.294154,0,0.20796,0.6757,-0.707236,0.208036,0.675946,0.706978,-0.208332,7.42486,-24.0191> }}
union{cone{<0.494646,9.70896,-26.4098> ,0.0864,<0.812395,11.711,-28.992> ,0.07776}
sphere{<0.494646,9.70896,-26.4098> ,0.0864}
texture{txttree matrix <0.987639,-0.156747,0,0.0967886,0.609849,-0.786585,0.123295,0.776862,0.617481,0.494646,9.70896,-26.4098> }}
union{cone{<-0.269621,0.937801,-12.5653> ,0.1296,<-0.312415,0.5,-15.6312> ,0.12096}
sphere{<-0.269621,0.937801,-12.5653> ,0.1296}
texture{txttree matrix <-0.995257,0.0972853,0,-0.0138168,-0.14135,-0.989863,-0.0962992,-0.985168,0.142023,-0.269621,0.937801,-12.5653> }}
union{cone{<-0.312415,0.5,-15.6312> ,0.12096,<0.89662,1.60516,-18.6166> ,0.11232}
sphere{<-0.312415,0.5,-15.6312> ,0.12096}
texture{txttree matrix <0.67469,-0.738101,0,0.355048,0.324546,-0.876705,0.647097,0.591504,0.481029,-0.312415,0.5,-15.6312> }}
union{cone{<0.89662,1.60516,-18.6166> ,0.11232,<2.14077,1.48903,-21.5851> ,0.10368}
sphere{<0.89662,1.60516,-18.6166> ,0.11232}
texture{txttree matrix <-0.0929423,-0.995671,0,0.386285,-0.0360583,-0.921674,0.917685,-0.0856626,0.387964,0.89662,1.60516,-18.6166> }}
union{cone{<2.14077,1.48903,-21.5851> ,0.10368,<3.56757,1.87398,-24.4462> ,0.09504}
sphere{<2.14077,1.48903,-21.5851> ,0.10368}
texture{txttree matrix <0.260488,-0.965477,0,0.443078,0.119543,-0.888477,0.857804,0.231437,0.458921,2.14077,1.48903,-21.5851> }}
union{cone{<3.56757,1.87398,-24.4462> ,0.09504,<4.84887,3.09023,-27.3166> ,0.0864}
sphere{<3.56757,1.87398,-24.4462> ,0.09504}
texture{txttree matrix <0.688453,-0.725281,0,0.380157,0.360854,-0.851625,0.617667,0.586304,0.524152,3.56757,1.87398,-24.4462> }}
union{cone{<4.84887,3.09023,-27.3166> ,0.0864,<4.68074,4.01158,-30.4466> ,0.07776}
sphere{<4.84887,3.09023,-27.3166> ,0.0864}
texture{txttree matrix <0.983755,0.179518,0,-0.051462,0.282011,-0.95803,-0.171983,0.942466,0.286668,4.84887,3.09023,-27.3166> }}
union{cone{<0.51018,0.501834,-3.36858> ,0.1296,<-0.889115,0.751158,-6.38944> ,0.12096}
sphere{<0.51018,0.501834,-3.36858> ,0.1296}
texture{txttree matrix <0.175415,0.984495,0,-0.419134,0.0746806,-0.904848,-0.890817,0.158724,0.425736,0.51018,0.501834,-3.36858> }}
union{cone{<-0.889115,0.751158,-6.38944> ,0.12096,<-2.39089,0.808866,-9.43179> ,0.11232}
sphere{<-0.889115,0.751158,-6.38944> ,0.12096}
texture{txttree matrix <0.0383986,0.999263,0,-0.442569,0.0170066,-0.896573,-0.895912,0.0344271,0.442896,-0.889115,0.751158,-6.38944> }}
union{cone{<-2.39089,0.808866,-9.43179> ,0.11232,<-2.75145,0.810556,-12.6676> ,0.10368}
sphere{<-2.39089,0.808866,-9.43179> ,0.11232}
texture{txttree matrix <0.00468708,0.999989,0,-0.110742,0.000519061,-0.993849,-0.993838,0.00465825,0.110743,-2.39089,0.808866,-9.43179> }}
union{cone{<-2.75145,0.810556,-12.6676> ,0.10368,<-3.75695,1.78341,-15.5015> ,0.09504}
sphere{<-2.75145,0.810556,-12.6676> ,0.10368}
texture{txttree matrix <0.695342,0.718679,0,-0.318158,0.307827,-0.896671,-0.644419,0.623492,0.442699,-2.75145,0.810556,-12.6676> }}
union{cone{<-3.75695,1.78341,-15.5015> ,0.09504,<-3.99399,1.6406,-18.7348> ,0.0864}
sphere{<-3.75695,1.78341,-15.5015> ,0.09504}
texture{txttree matrix <-0.516054,0.856556,0,-0.0730438,-0.0440071,-0.996357,-0.853436,-0.514175,0.0852761,-3.75695,1.78341,-15.5015> }}
union{cone{<-3.99399,1.6406,-18.7348> ,0.0864,<-4.69639,1.98199,-21.7769> ,0.07776}
sphere{<-3.99399,1.6406,-18.7348> ,0.0864}
texture{txttree matrix <0.437134,0.899396,0,-0.223641,0.108696,-0.968592,-0.871148,0.423405,0.248657,-3.99399,1.6406,-18.7348> }}
union{cone{<1.72322,0.519966,-3.4143> ,0.216,<0.803761,0.5,-4.94056> ,0.203657}
sphere{<1.72322,0.519966,-3.4143> ,0.216}
texture{txttree matrix <-0.0217103,0.999764,0,-0.515991,-0.0112049,-0.856521,-0.856319,-0.0185953,0.516113,1.72322,0.519966,-3.4143> }}
union{cone{<0.803761,0.5,-4.94056> ,0.203657,<-0.0105409,0.663751,-6.43146> ,0.191314}
sphere{<0.803761,0.5,-4.94056> ,0.203657}
texture{txttree matrix <0.197147,0.980374,0,-0.477134,0.0959487,-0.873577,-0.856432,0.172223,0.486685,0.803761,0.5,-4.94056> }}
union{cone{<-0.0105409,0.663751,-6.43146> ,0.191314,<-0.448436,0.97437,-8.11854> ,0.178971}
sphere{<-0.0105409,0.663751,-6.43146> ,0.191314}
texture{txttree matrix <0.578568,0.815634,0,-0.247335,0.175447,-0.952913,-0.777229,0.551325,0.303243,-0.0105409,0.663751,-6.43146> }}
union{cone{<-0.448436,0.97437,-8.11854> ,0.178971,<-1.34198,1.38591,-9.51318> ,0.166629}
sphere{<-0.448436,0.97437,-8.11854> ,0.178971}
texture{txttree matrix <0.418337,0.908292,0,-0.523551,0.241135,-0.817159,-0.742219,0.341848,0.576413,-0.448436,0.97437,-8.11854> }}
union{cone{<-1.34198,1.38591,-9.51318> ,0.166629,<-1.49568,1.98051,-11.0942> ,0.154286}
sphere{<-1.34198,1.38591,-9.51318> ,0.166629}
texture{txttree matrix <0.968176,0.250272,0,-0.0906188,0.350558,-0.932147,-0.23329,0.902482,0.362081,-1.34198,1.38591,-9.51318> }}
union{cone{<-1.49568,1.98051,-11.0942> ,0.154286,<-1.99551,2.27631,-12.7639> ,0.141943}
sphere{<-1.49568,1.98051,-11.0942> ,0.154286}
texture{txttree matrix <0.5093,0.860589,0,-0.282747,0.167331,-0.944486,-0.812815,0.481027,0.32855,-1.49568,1.98051,-11.0942> }}
union{cone{<-1.99551,2.27631,-12.7639> ,0.141943,<-2.21981,2.89515,-14.4196> ,0.1296}
sphere{<-1.99551,2.27631,-12.7639> ,0.141943}
texture{txttree matrix <0.940154,0.34075,0,-0.125883,0.347319,-0.929259,-0.316646,0.873647,0.369428,-1.99551,2.27631,-12.7639> }}
union{cone{<-2.21981,2.89515,-14.4196> ,0.1296,<-2.00025,4.93935,-17.1228> ,0.12096}
sphere{<-2.21981,2.89515,-14.4196> ,0.1296}
texture{txttree matrix <0.994281,-0.106792,0,0.0646474,0.601899,-0.795952,0.085001,0.7914,0.60536,-2.21981,2.89515,-14.4196> }}
union{cone{<-2.00025,4.93935,-17.1228> ,0.12096,<-2.69333,7.73255,-18.9804> ,0.11232}
sphere{<-2.00025,4.93935,-17.1228> ,0.12096}
texture{txttree matrix <0.970567,0.24083,0,-0.202342,0.815459,-0.542295,-0.130601,0.526334,0.840188,-2.00025,4.93935,-17.1228> }}
union{cone{<-2.69333,7.73255,-18.9804> ,0.11232,<-2.30837,10.1573,-21.3586> ,0.10368}
sphere{<-2.69333,7.73255,-18.9804> ,0.11232}
texture{txttree matrix <0.987631,-0.156797,0,0.112623,0.709385,-0.695765,0.109094,0.687159,0.718269,-2.69333,7.73255,-18.9804> }}
union{cone{<-2.30837,10.1573,-21.3586> ,0.10368,<-2.00498,12.4771,-23.8777> ,0.09504}
sphere{<-2.30837,10.1573,-21.3586> ,0.10368}
texture{txttree matrix <0.991556,-0.129679,0,0.0882481,0.674763,-0.73274,0.0950213,0.726552,0.680509,-2.30837,10.1573,-21.3586> }}
union{cone{<-2.00498,12.4771,-23.8777> ,0.09504,<-3.12976,14.6121,-26.0807> ,0.0864}
sphere{<-2.00498,12.4771,-23.8777> ,0.09504}
texture{txttree matrix <0.884731,0.466102,0,-0.344232,0.653403,-0.674217,-0.314254,0.596501,0.738533,-2.00498,12.4771,-23.8777> }}
union{cone{<-3.12976,14.6121,-26.0807> ,0.0864,<-3.80411,17.1316,-28.0318> ,0.07776}
sphere{<-3.12976,14.6121,-26.0807> ,0.0864}
texture{txttree matrix <0.965998,0.258551,0,-0.207032,0.773515,-0.59901,-0.154874,0.578642,0.800742,-3.12976,14.6121,-26.0807> }}
union{cone{<-0.0749873,0.709466,-6.67975> ,0.1296,<1.41642,2.28867,-9.33687> ,0.12096}
sphere{<-0.0749873,0.709466,-6.67975> ,0.1296}
texture{txttree matrix <0.727028,-0.686608,0,0.434563,0.460145,-0.774224,0.531588,0.562882,0.632912,-0.0749873,0.709466,-6.67975> }}
union{cone{<1.41642,2.28867,-9.33687> ,0.12096,<2.46519,3.72147,-11.9435> ,0.11232}
sphere{<1.41642,2.28867,-9.33687> ,0.12096}
texture{txttree matrix <0.806928,-0.59065,0,0.332528,0.454289,-0.826467,0.488153,0.666899,0.562986,1.41642,2.28867,-9.33687> }}
union{cone{<2.46519,3.72147,-11.9435> ,0.11232,<3.48921,3.95403,-15.0938> ,0.10368}
sphere{<2.46519,3.72147,-11.9435> ,0.11232}
texture{txttree matrix <0.221467,-0.975168,0,0.308373,0.0700333,-0.948684,0.925126,0.210102,0.316225,2.46519,3.72147,-11.9435> }}
union{cone{<3.48921,3.95403,-15.0938> ,0.10368,<3.31556,5.51865,-18.1357> ,0.09504}
sphere{<3.48921,3.95403,-15.0938> ,0.10368}
texture{txttree matrix <0.993897,0.110313,0,-0.0507007,0.456804,-0.888121,-0.097971,0.882701,0.459609,3.48921,3.95403,-15.0938> }}
union{cone{<3.31556,5.51865,-18.1357> ,0.09504,<3.32617,6.50658,-21.3865> ,0.0864}
sphere{<3.31556,5.51865,-18.1357> ,0.09504}
texture{txttree matrix <0.999942,-0.0107374,0,0.0031224,0.290779,-0.956785,0.0102734,0.95673,0.290795,3.31556,5.51865,-18.1357> }}
union{cone{<3.32617,6.50658,-21.3865> ,0.0864,<4.42824,7.89725,-24.2727> ,0.07776}
sphere{<3.32617,6.50658,-21.3865> ,0.0864}
texture{txttree matrix <0.783736,-0.621094,0,0.325285,0.410465,-0.851885,0.529101,0.667653,0.523729,3.32617,6.50658,-21.3865> }}
union{cone{<-1.65959,2.07751,-11.6418> ,0.1296,<-1.50226,1.49377,-14.7906> ,0.12096}
sphere{<-1.65959,2.07751,-11.6418> ,0.1296}
texture{txttree matrix <-0.965546,-0.260232,0,0.0490679,-0.182058,-0.982063,0.255564,-0.948227,0.188554,-1.65959,2.07751,-11.6418> }}
union{cone{<-1.50226,1.49377,-14.7906> ,0.12096,<-2.3197,1.308,-18.0304> ,0.11232}
sphere{<-1.50226,1.49377,-14.7906> ,0.12096}
texture{txttree matrix <-0.221608,0.975136,0,-0.24427,-0.0555124,-0.968117,-0.944046,-0.214542,0.250498,-1.50226,1.49377,-14.7906> }}
union{cone{<-2.3197,1.308,-18.0304> ,0.11232,<-3.77682,1.31962,-20.9164> ,0.10368}
sphere{<-2.3197,1.308,-18.0304> ,0.11232}
texture{txttree matrix <0.00797868,0.999968,0,-0.450699,0.00359609,-0.892669,-0.89264,0.00712232,0.450713,-2.3197,1.308,-18.0304> }}
union{cone{<-3.77682,1.31962,-20.9164> ,0.10368,<-4.18267,2.08478,-24.1881> ,0.09504}
sphere{<-3.77682,1.31962,-20.9164> ,0.10368}
texture{txttree matrix <0.883421,0.468579,0,-0.119917,0.226081,-0.966699,-0.452975,0.854003,0.255916,-3.77682,1.31962,-20.9164> }}
union{cone{<-4.18267,2.08478,-24.1881> ,0.09504,<-5.15121,3.48673,-27.1748> ,0.0864}
sphere{<-4.18267,2.08478,-24.1881> ,0.09504}
texture{txttree matrix <0.822751,0.568402,0,-0.281671,0.407714,-0.86858,-0.493702,0.714625,0.49555,-4.18267,2.08478,-24.1881> }}
union{cone{<-5.15121,3.48673,-27.1748> ,0.0864,<-6.30453,4.53883,-30.2112> ,0.07776}
sphere{<-5.15121,3.48673,-27.1748> ,0.0864}
texture{txttree matrix <0.673945,0.738782,0,-0.337796,0.308151,-0.889346,-0.657033,0.59937,0.457235,-5.15121,3.48673,-27.1748> }}
union{cone{<-1.6383,2.06491,-11.5706> ,0.1296,<-3.4719,2.83091,-14.0512> ,0.12096}
sphere{<-1.6383,2.06491,-11.5706> ,0.1296}
texture{txttree matrix <0.385472,0.92272,0,-0.576896,0.241002,-0.780455,-0.720141,0.300843,0.625212,-1.6383,2.06491,-11.5706> }}
union{cone{<-3.4719,2.83091,-14.0512> ,0.12096,<-4.42842,3.55315,-17.1859> ,0.11232}
sphere{<-3.4719,2.83091,-14.0512> ,0.12096}
texture{txttree matrix <0.602587,0.798053,0,-0.285019,0.21521,-0.93405,-0.745421,0.562846,0.357143,-3.4719,2.83091,-14.0512> }}
union{cone{<-4.42842,3.55315,-17.1859> ,0.11232,<-4.99357,4.81379,-20.2217> ,0.10368}
sphere{<-4.42842,3.55315,-17.1859> ,0.11232}
texture{txttree matrix <0.912499,0.40908,0,-0.169439,0.377954,-0.910187,-0.372339,0.830545,0.414197,-4.42842,3.55315,-17.1859> }}
union{cone{<-4.99357,4.81379,-20.2217> ,0.10368,<-6.40498,5.0685,-23.2746> ,0.09504}
sphere{<-4.99357,4.81379,-20.2217> ,0.10368}
texture{txttree matrix <0.177595,0.984104,0,-0.418447,0.0755146,-0.905097,-0.890709,0.160741,0.425206,-4.99357,4.81379,-20.2217> }}
union{cone{<-6.40498,5.0685,-23.2746> ,0.09504,<-6.95024,5.68843,-26.2987> ,0.0864}
sphere{<-6.40498,5.0685,-23.2746> ,0.09504}
texture{txttree matrix <0.750883,0.660435,0,-0.173941,0.197763,-0.964694,-0.637117,0.724373,0.263374,-6.40498,5.0685,-23.2746> }}
union{cone{<-6.95024,5.68843,-26.2987> ,0.0864,<-7.97209,6.66156,-29.4355> ,0.07776}
sphere{<-6.95024,5.68843,-26.2987> ,0.0864}
texture{txttree matrix <0.689632,0.72416,0,-0.297085,0.28292,-0.911974,-0.660415,0.628927,0.410248,-6.95024,5.68843,-26.2987> }}
union{cone{<1.02376,0.831234,-1.80298> ,0.216,<2.52248,1.62721,-2.28636> ,0.203657}
sphere{<1.02376,0.831234,-1.80298> ,0.216}
texture{txttree matrix <0.469052,-0.883171,0,0.849384,0.451108,-0.273948,0.241943,0.128496,0.961744,1.02376,0.831234,-1.80298> }}
union{cone{<2.52248,1.62721,-2.28636> ,0.203657,<3.59859,2.68776,-3.28706> ,0.191314}
sphere{<2.52248,1.62721,-2.28636> ,0.203657}
texture{txttree matrix <0.701941,-0.712235,0,0.593803,0.58522,-0.552193,0.393291,0.387606,0.833717,2.52248,1.62721,-2.28636> }}
union{cone{<3.59859,2.68776,-3.28706> ,0.191314,<4.98573,3.09143,-4.26892> ,0.178971}
sphere{<3.59859,2.68776,-3.28706> ,0.191314}
texture{txttree matrix <0.279416,-0.96017,0,0.794123,0.231095,-0.562106,0.539717,0.157061,0.827065,3.59859,2.68776,-3.28706> }}
union{cone{<4.98573,3.09143,-4.26892> ,0.178971,<5.95648,4.22606,-5.22929> ,0.166629}
sphere{<4.98573,3.09143,-4.26892> ,0.178971}
texture{txttree matrix <0.759849,-0.6501,0,0.546777,0.639083,-0.540933,0.35166,0.411027,0.841066,4.98573,3.09143,-4.26892> }}
union{cone{<5.95648,4.22606,-5.22929> ,0.166629,<6.89175,5.29522,-6.1122> ,0.154286}
sphere{<5.95648,4.22606,-5.22929> ,0.166629}
texture{txttree matrix <0.752665,-0.658403,0,0.559192,0.639251,-0.527885,0.347561,0.397321,0.849316,5.95648,4.22606,-5.22929> }}
union{cone{<6.89175,5.29522,-6.1122> ,0.154286,<7.47971,6.26706,-7.40273> ,0.141943}
sphere{<6.89175,5.29522,-6.1122> ,0.154286}
texture{txttree matrix <0.855598,-0.517641,0,0.342001,0.565286,-0.750658,0.388571,0.642261,0.660691,6.89175,5.29522,-6.1122> }}
union{cone{<7.47971,6.26706,-7.40273> ,0.141943,<8.34784,7.29378,-8.50031> ,0.1296}
sphere{<7.47971,6.26706,-7.40273> ,0.141943}
texture{txttree matrix <0.76362,-0.645665,0,0.500173,0.591548,-0.632375,0.408303,0.482895,0.774662,7.47971,6.26706,-7.40273> }}
union{cone{<8.34784,7.29378,-8.50031> ,0.1296,<11.0521,9.02691,-8.44925> ,0.12096}
sphere{<8.34784,7.29378,-8.50031> ,0.1296}
texture{txttree matrix <0.539591,-0.841927,0,0.841821,0.539523,0.0158936,-0.0133813,-0.00857606,0.999874,8.34784,7.29378,-8.50031> }}
union{cone{<11.0521,9.02691,-8.44925> ,0.12096,<12.3036,11.9742,-8.80991> ,0.11232}
sphere{<11.0521,9.02691,-8.44925> ,0.12096}
texture{txttree matrix <0.920452,-0.390855,0,0.388399,0.914668,-0.111929,0.043748,0.103025,0.993716,11.0521,9.02691,-8.44925> }}
union{cone{<12.3036,11.9742,-8.80991> ,0.11232,<14.3097,14.4976,-9.46683> ,0.10368}
sphere{<12.3036,11.9742,-8.80991> ,0.11232}
texture{txttree matrix <0.782776,-0.622304,0,0.609772,0.767012,-0.199677,0.124259,0.156302,0.979862,12.3036,11.9742,-8.80991> }}
union{cone{<14.3097,14.4976,-9.46683> ,0.10368,<15.8751,16.5602,-11.7127> ,0.09504}
sphere{<14.3097,14.4976,-9.46683> ,0.10368}
texture{txttree matrix <0.796567,-0.604551,0,0.456702,0.601759,-0.655218,0.396112,0.521925,0.75544,14.3097,14.4976,-9.46683> }}
union{cone{<15.8751,16.5602,-11.7127> ,0.09504,<17.4982,19.2623,-12.6052> ,0.0864}
sphere{<15.8751,16.5602,-11.7127> ,0.09504}
texture{txttree matrix <0.857231,-0.514932,0,0.495456,0.824808,-0.272425,0.14028,0.233531,0.962177,15.8751,16.5602,-11.7127> }}
union{cone{<17.4982,19.2623,-12.6052> ,0.0864,<18.2015,22.1005,-13.8394> ,0.07776}
sphere{<17.4982,19.2623,-12.6052> ,0.0864}
texture{txttree matrix <0.970644,-0.240521,0,0.221589,0.894242,-0.388883,0.0935346,0.377467,0.921287,17.4982,19.2623,-12.6052> }}
union{cone{<6.7223,5.10152,-5.95224> ,0.1296,<8.71475,7.45191,-6.62351> ,0.12096}
sphere{<6.7223,5.10152,-5.95224> ,0.1296}
texture{txttree matrix <0.762801,-0.646633,0,0.631814,0.745319,-0.212862,0.137644,0.162372,0.977082,6.7223,5.10152,-5.95224> }}
union{cone{<8.71475,7.45191,-6.62351> ,0.12096,<10.796,9.74581,-7.3728> ,0.11232}
sphere{<8.71475,7.45191,-6.62351> ,0.12096}
texture{txttree matrix <0.740606,-0.67194,0,0.653101,0.719842,-0.235132,0.157994,0.17414,0.971963,8.71475,7.45191,-6.62351> }}
union{cone{<10.796,9.74581,-7.3728> ,0.11232,<12.3436,11.4039,-9.51436> ,0.10368}
sphere{<10.796,9.74581,-7.3728> ,0.11232}
texture{txttree matrix <0.731028,-0.682348,0,0.49614,0.531535,-0.686524,0.468448,0.501868,0.727107,10.796,9.74581,-7.3728> }}
union{cone{<12.3436,11.4039,-9.51436> ,0.10368,<14.4063,13.6408,-10.7264> ,0.09504}
sphere{<12.3436,11.4039,-9.51436> ,0.10368}
texture{txttree matrix <0.73516,-0.677894,0,0.629769,0.682969,-0.37006,0.250861,0.272053,0.929008,12.3436,11.4039,-9.51436> }}
union{cone{<14.4063,13.6408,-10.7264> ,0.09504,<16.7271,15.5963,-12.344> ,0.0864}
sphere{<14.4063,13.6408,-10.7264> ,0.09504}
texture{txttree matrix <0.64434,-0.764739,0,0.674863,0.568614,-0.470359,0.359702,0.303071,0.882475,14.4063,13.6408,-10.7264> }}
union{cone{<16.7271,15.5963,-12.344> ,0.0864,<18.3327,17.4893,-14.5684> ,0.07776}
sphere{<16.7271,15.5963,-12.344> ,0.0864}
texture{txttree matrix <0.762654,-0.646807,0,0.481688,0.567961,-0.667381,0.431666,0.508981,0.744717,16.7271,15.5963,-12.344> }}
union{cone{<2.95931,2.05772,-2.69257> ,0.1296,<5.11325,3.70888,-4.60973> ,0.12096}
sphere{<2.95931,2.05772,-2.69257> ,0.1296}
texture{txttree matrix <0.608386,-0.793641,0,0.648223,0.496912,-0.576962,0.457901,0.351016,0.816771,2.95931,2.05772,-2.69257> }}
union{cone{<5.11325,3.70888,-4.60973> ,0.12096,<7.23815,3.83231,-6.91438> ,0.11232}
sphere{<5.11325,3.70888,-4.60973> ,0.12096}
texture{txttree matrix <0.0579858,-0.998317,0,0.67733,0.0393417,-0.734627,0.733391,0.0425979,0.678472,5.11325,3.70888,-4.60973> }}
union{cone{<7.23815,3.83231,-6.91438> ,0.11232,<7.97911,5.71832,-9.64157> ,0.10368}
sphere{<7.23815,3.83231,-6.91438> ,0.11232}
texture{txttree matrix <0.930747,-0.365663,0,0.218083,0.555103,-0.802684,0.293512,0.747096,0.596405,7.23815,3.83231,-6.91438> }}
union{cone{<7.97911,5.71832,-9.64157> ,0.10368,<8.97389,6.85475,-12.4857> ,0.09504}
sphere{<7.97911,5.71832,-9.64157> ,0.10368}
texture{txttree matrix <0.752445,-0.658655,0,0.308909,0.352897,-0.883198,0.581723,0.664558,0.469,7.97911,5.71832,-9.64157> }}
union{cone{<8.97389,6.85475,-12.4857> ,0.09504,<10.708,7.78038,-15.0106> ,0.0864}
sphere{<8.97389,6.85475,-12.4857> ,0.09504}
texture{txttree matrix <0.470893,-0.882191,0,0.541944,0.289277,-0.78906,0.696101,0.371562,0.614317,8.97389,6.85475,-12.4857> }}
union{cone{<10.708,7.78038,-15.0106> ,0.0864,<11.8876,8.89656,-17.9266> ,0.07776}
sphere{<10.708,7.78038,-15.0106> ,0.0864}
texture{txttree matrix <0.687327,-0.726348,0,0.353398,0.334413,-0.873658,0.634579,0.600489,0.486541,10.708,7.78038,-15.0106> }}
union{cone{<3.36833,2.46083,-3.07293> ,0.1296,<4.29406,4.60512,-5.22606> ,0.12096}
sphere{<3.36833,2.46083,-3.07293> ,0.1296}
texture{txttree matrix <0.918096,-0.396359,0,0.29142,0.675023,-0.677804,0.268654,0.622289,0.735242,3.36833,2.46083,-3.07293> }}
union{cone{<4.29406,4.60512,-5.22606> ,0.12096,<4.28777,6.48876,-7.82382> ,0.11232}
sphere{<4.29406,4.60512,-5.22606> ,0.12096}
texture{txttree matrix <0.999994,0.0033378,0,-0.00195937,0.58702,-0.80957,-0.00270218,0.809565,0.587023,4.29406,4.60512,-5.22606> }}
union{cone{<4.28777,6.48876,-7.82382> ,0.11232,<5.63231,8.94817,-9.41043> ,0.10368}
sphere{<4.28777,6.48876,-7.82382> ,0.11232}
texture{txttree matrix <0.877439,-0.479688,0,0.41745,0.763593,-0.492606,0.236297,0.432232,0.870252,4.28777,6.48876,-7.82382> }}
union{cone{<5.63231,8.94817,-9.41043> ,0.10368,<6.78649,10.3568,-12.1849> ,0.09504}
sphere{<5.63231,8.94817,-9.41043> ,0.10368}
texture{txttree matrix <0.773515,-0.633778,0,0.347778,0.424456,-0.835995,0.529835,0.646655,0.548737,5.63231,8.94817,-9.41043> }}
union{cone{<6.78649,10.3568,-12.1849> ,0.09504,<7.61437,11.8534,-14.936> ,0.0864}
sphere{<6.78649,10.3568,-12.1849> ,0.09504}
texture{txttree matrix <0.875042,-0.484047,0,0.255561,0.461994,-0.849264,0.411084,0.743142,0.527968,6.78649,10.3568,-12.1849> }}
union{cone{<7.61437,11.8534,-14.936> ,0.0864,<8.3772,14.0861,-17.1792> ,0.07776}
sphere{<7.61437,11.8534,-14.936> ,0.0864}
texture{txttree matrix <0.946291,-0.323317,0,0.234316,0.685801,-0.689037,0.222778,0.65203,0.724726,7.61437,11.8534,-14.936> }}
union{cone{<3.69047,2.7145,-3.35209> ,0.1296,<5.71054,5.24516,-4.34101> ,0.12096}
sphere{<3.69047,2.7145,-3.35209> ,0.1296}
texture{txttree matrix <0.78154,-0.623856,0,0.596651,0.747458,-0.292086,0.18222,0.228277,0.956392,3.69047,2.7145,-3.35209> }}
union{cone{<5.71054,5.24516,-4.34101> ,0.12096,<6.96924,7.73742,-6.15032> ,0.11232}
sphere{<5.71054,5.24516,-4.34101> ,0.12096}
texture{txttree matrix <0.892619,-0.450812,0,0.378323,0.749089,-0.543818,0.24516,0.485422,0.839203,5.71054,5.24516,-4.34101> }}
union{cone{<6.96924,7.73742,-6.15032> ,0.11232,<9.45762,9.39665,-7.48528> ,0.10368}
sphere{<6.96924,7.73742,-6.15032> ,0.11232}
texture{txttree matrix <0.554772,-0.832002,0,0.759755,0.506598,-0.407591,0.339117,0.22612,0.913165,6.96924,7.73742,-6.15032> }}
union{cone{<9.45762,9.39665,-7.48528> ,0.10368,<11.4214,11.0351,-9.64276> ,0.09504}
sphere{<9.45762,9.39665,-7.48528> ,0.10368}
texture{txttree matrix <0.640641,-0.767841,0,0.586898,0.489673,-0.644803,0.495106,0.413087,0.764349,9.45762,9.39665,-7.48528> }}
union{cone{<11.4214,11.0351,-9.64276> ,0.09504,<12.0656,13.4138,-11.6756> ,0.0864}
sphere{<11.4214,11.0351,-9.64276> ,0.09504}
texture{txttree matrix <0.965228,-0.261408,0,0.201654,0.744592,-0.636332,0.166342,0.614205,0.771416,11.4214,11.0351,-9.64276> }}
union{cone{<12.0656,13.4138,-11.6756> ,0.0864,<12.8629,15.9253,-13.7562> ,0.07776}
sphere{<12.0656,13.4138,-11.6756> ,0.0864}
texture{txttree matrix <0.953119,-0.302595,0,0.237489,0.748046,-0.619698,0.187518,0.590646,0.78484,12.0656,13.4138,-11.6756> }}
union{cone{<-0.033994,0.575381,-0.0343686> ,0.36,<-0.601346,0.680646,-0.799445> ,0.342}
sphere{<-0.033994,0.575381,-0.0343686> ,0.36}
texture{txttree matrix <0.182423,0.98322,0,-0.592049,0.109847,-0.79838,-0.784984,0.145643,0.602153,-0.033994,0.575381,-0.0343686> }}
union{cone{<-0.601346,0.680646,-0.799445> ,0.342,<-1.22151,1.29774,-1.29484> ,0.324}
sphere{<-0.601346,0.680646,-0.799445> ,0.342}
texture{txttree matrix <0.70535,0.708859,0,-0.616833,0.61378,-0.492738,-0.349282,0.347553,0.870178,-0.601346,0.680646,-0.799445> }}
union{cone{<-1.22151,1.29774,-1.29484> ,0.324,<-1.45473,1.76391,-2.05491> ,0.306}
sphere{<-1.22151,1.29774,-1.29484> ,0.324}
texture{txttree matrix <0.894323,0.447422,0,-0.253052,0.50581,-0.824694,-0.368986,0.737543,0.565579,-1.22151,1.29774,-1.29484> }}
union{cone{<-1.45473,1.76391,-2.05491> ,0.306,<-2.09443,2.2807,-2.59432> ,0.288}
sphere{<-1.45473,1.76391,-2.05491> ,0.306}
texture{txttree matrix <0.628419,0.777875,0,-0.650441,0.525469,-0.548461,-0.426635,0.344663,0.836176,-1.45473,1.76391,-2.05491> }}
union{cone{<-2.09443,2.2807,-2.59432> ,0.288,<-2.32159,2.59769,-3.43324> ,0.27}
sphere{<-2.09443,2.2807,-2.59432> ,0.288}
texture{txttree matrix <0.812836,0.582493,0,-0.245537,0.342632,-0.906816,-0.528214,0.737092,0.421527,-2.09443,2.2807,-2.59432> }}
union{cone{<-2.32159,2.59769,-3.43324> ,0.27,<-2.92164,3.11576,-4.03885> ,0.252}
sphere{<-2.32159,2.59769,-3.43324> ,0.27}
texture{txttree matrix <0.653514,0.756914,0,-0.601488,0.51932,-0.607057,-0.45949,0.396721,0.794658,-2.32159,2.59769,-3.43324> }}
union{cone{<-2.92164,3.11576,-4.03885> ,0.252,<-3.09841,3.60599,-4.80661> ,0.234}
sphere{<-2.92164,3.11576,-4.03885> ,0.252}
texture{txttree matrix <0.940706,0.339222,0,-0.190509,0.528306,-0.827405,-0.280674,0.778345,0.561605,-2.92164,3.11576,-4.03885> }}
union{cone{<-3.09841,3.60599,-4.80661> ,0.234,<-3.49,4.17805,-5.46426> ,0.216}
sphere{<-3.09841,3.60599,-4.80661> ,0.234}
texture{txttree matrix <0.825194,0.564849,0,-0.409792,0.59867,-0.688233,-0.388748,0.567926,0.725489,-3.09841,3.60599,-4.80661> }}
union{cone{<-3.49,4.17805,-5.46426> ,0.216,<-4.77917,5.08218,-6.05796> ,0.203657}
sphere{<-3.49,4.17805,-5.46426> ,0.216}
texture{txttree matrix <0.574188,0.818723,0,-0.766079,0.537268,-0.352797,-0.288843,0.202572,0.9357,-3.49,4.17805,-5.46426> }}
union{cone{<-4.77917,5.08218,-6.05796> ,0.203657,<-5.17139,6.67279,-6.67534> ,0.191314}
sphere{<-4.77917,5.08218,-6.05796> ,0.203657}
texture{txttree matrix <0.970918,0.239414,0,-0.224034,0.908544,-0.352642,-0.0844274,0.342386,0.935758,-4.77917,5.08218,-6.05796> }}
union{cone{<-5.17139,6.67279,-6.67534> ,0.191314,<-6.40603,7.70215,-7.21884> ,0.178971}
sphere{<-5.17139,6.67279,-6.67534> ,0.191314}
texture{txttree matrix <0.640364,0.768071,0,-0.727606,0.606628,-0.320299,-0.246013,0.205108,0.947316,-5.17139,6.67279,-6.67534> }}
union{cone{<-6.40603,7.70215,-7.21884> ,0.178971,<-7.45147,9.20642,-7.29513> ,0.166629}
sphere{<-6.40603,7.70215,-7.21884> ,0.178971}
texture{txttree matrix <0.821164,0.570692,0,-0.570198,0.820453,-0.0416116,-0.0237474,0.0341699,0.999134,-6.40603,7.70215,-7.21884> }}
union{cone{<-7.45147,9.20642,-7.29513> ,0.166629,<-8.19622,10.7079,-7.85412> ,0.154286}
sphere{<-7.45147,9.20642,-7.29513> ,0.166629}
texture{txttree matrix <0.895849,0.444358,0,-0.42153,0.849829,-0.316391,-0.140591,0.283439,0.948629,-7.45147,9.20642,-7.29513> }}
union{cone{<-8.19622,10.7079,-7.85412> ,0.154286,<-8.51967,12.2194,-8.63535> ,0.141943}
sphere{<-8.19622,10.7079,-7.85412> ,0.154286}
texture{txttree matrix <0.977862,0.209252,0,-0.186756,0.872732,-0.451067,-0.0943868,0.441081,0.89249,-8.19622,10.7079,-7.85412> }}
union{cone{<-8.51967,12.2194,-8.63535> ,0.141943,<-8.94233,13.8234,-9.03835> ,0.1296}
sphere{<-8.51967,12.2194,-8.63535> ,0.141943}
texture{txttree matrix <0.96699,0.254815,0,-0.247612,0.939654,-0.236092,-0.0601597,0.228298,0.971731,-8.51967,12.2194,-8.63535> }}
union{cone{<-8.94233,13.8234,-9.03835> ,0.1296,<-9.10358,16.7933,-7.89407> ,0.12096}
sphere{<-8.94233,13.8234,-9.03835> ,0.1296}
texture{txttree matrix <0.998529,0.0542149,0,-0.0505995,0.931941,0.359063,0.0194666,-0.358535,0.933313,-8.94233,13.8234,-9.03835> }}
union{cone{<-9.10358,16.7933,-7.89407> ,0.12096,<-9.30348,19.9175,-8.14405> ,0.11232}
sphere{<-9.10358,16.7933,-7.89407> ,0.12096}
texture{txttree matrix <0.997959,0.0638527,0,-0.0636501,0.994793,-0.0795957,-0.0050824,0.0794333,0.996827,-9.10358,16.7933,-7.89407> }}
union{cone{<-9.30348,19.9175,-8.14405> ,0.11232,<-9.50928,23.252,-7.32428> ,0.10368}
sphere{<-9.30348,19.9175,-8.14405> ,0.11232}
texture{txttree matrix <0.998101,0.0616019,0,-0.0598271,0.969344,0.238311,0.0146804,-0.237858,0.971189,-9.30348,19.9175,-8.14405> }}
union{cone{<-9.50928,23.252,-7.32428> ,0.10368,<-9.45096,26.5157,-7.79952> ,0.09504}
sphere{<-9.50928,23.252,-7.32428> ,0.10368}
texture{txttree matrix <0.99984,-0.0178662,0,0.0176798,0.989409,-0.144074,0.00257405,0.144051,0.989567,-9.50928,23.252,-7.32428> }}
union{cone{<-9.45096,26.5157,-7.79952> ,0.09504,<-10.03,29.7423,-8.21091> ,0.0864}
sphere{<-9.45096,26.5157,-7.79952> ,0.09504}
texture{txttree matrix <0.984275,0.176641,0,-0.175267,0.976616,-0.124513,-0.0219942,0.122555,0.992218,-9.45096,26.5157,-7.79952> }}
union{cone{<-10.03,29.7423,-8.21091> ,0.0864,<-10.869,32.7356,-8.94676> ,0.07776}
sphere{<-10.03,29.7423,-8.21091> ,0.0864}
texture{txttree matrix <0.962894,0.269879,0,-0.262621,0.936999,-0.230352,-0.0621672,0.221805,0.973107,-10.03,29.7423,-8.21091> }}
union{cone{<-7.93644,10.1841,-7.65914> ,0.1296,<-9.3564,13.2653,-7.27818> ,0.12096}
sphere{<-7.93644,10.1841,-7.65914> ,0.1296}
texture{txttree matrix <0.908198,0.418541,0,-0.415927,0.902526,0.111588,0.0467042,-0.101344,0.993755,-7.93644,10.1841,-7.65914> }}
union{cone{<-9.3564,13.2653,-7.27818> ,0.12096,<-10.7096,16.3285,-7.44229> ,0.11232}
sphere{<-9.3564,13.2653,-7.27818> ,0.12096}
texture{txttree matrix <0.91472,0.404089,0,-0.403604,0.913623,-0.0489474,-0.0197791,0.0447732,0.998801,-9.3564,13.2653,-7.27818> }}
union{cone{<-10.7096,16.3285,-7.44229> ,0.11232,<-11.2495,19.4183,-8.77173> ,0.10368}
sphere{<-10.7096,16.3285,-7.44229> ,0.11232}
texture{txttree matrix <0.985075,0.172127,0,-0.158479,0.90697,-0.390243,-0.0671712,0.384418,0.920712,-10.7096,16.3285,-7.44229> }}
union{cone{<-11.2495,19.4183,-8.77173> ,0.10368,<-11.3429,22.084,-10.7995> ,0.09504}
sphere{<-11.2495,19.4183,-8.77173> ,0.10368}
texture{txttree matrix <0.999387,0.0350228,0,-0.0278812,0.795599,-0.605181,-0.0211951,0.60481,0.796088,-11.2495,19.4183,-8.77173> }}
union{cone{<-11.3429,22.084,-10.7995> ,0.09504,<-10.8994,24.9256,-12.5345> ,0.0864}
sphere{<-11.3429,22.084,-10.7995> ,0.09504}
texture{txttree matrix <0.988037,-0.154218,0,0.132049,0.846007,-0.516561,0.0796631,0.510381,0.856251,-11.3429,22.084,-10.7995> }}
union{cone{<-10.8994,24.9256,-12.5345> ,0.0864,<-11.639,28.0071,-13.676> ,0.07776}
sphere{<-10.8994,24.9256,-12.5345> ,0.0864}
texture{txttree matrix <0.972385,0.233383,0,-0.219573,0.914845,-0.338889,-0.079091,0.32953,0.940826,-10.8994,24.9256,-12.5345> }}
union{cone{<-6.24749,7.56997,-7.14905> ,0.1296,<-8.20302,8.75483,-9.38725> ,0.12096}
sphere{<-6.24749,7.56997,-7.14905> ,0.1296}
texture{txttree matrix <0.518203,0.855257,0,-0.611176,0.370314,-0.699522,-0.598272,0.362495,0.714611,-6.24749,7.56997,-7.14905> }}
union{cone{<-8.20302,8.75483,-9.38725> ,0.12096,<-8.95959,11.6942,-10.7656> ,0.11232}
sphere{<-8.20302,8.75483,-9.38725> ,0.12096}
texture{txttree matrix <0.968434,0.249269,0,-0.226962,0.881769,-0.413487,-0.103069,0.400435,0.91051,-8.20302,8.75483,-9.38725> }}
union{cone{<-8.95959,11.6942,-10.7656> ,0.11232,<-10.8759,13.8204,-12.1237> ,0.10368}
sphere{<-8.95959,11.6942,-10.7656> ,0.11232}
texture{txttree matrix <0.742807,0.669505,0,-0.604876,0.671102,-0.428658,-0.286989,0.31841,0.903467,-8.95959,11.6942,-10.7656> }}
union{cone{<-10.8759,13.8204,-12.1237> ,0.10368,<-11.301,16.5351,-13.6949> ,0.09504}
sphere{<-10.8759,13.8204,-12.1237> ,0.10368}
texture{txttree matrix <0.98796,0.154711,0,-0.134303,0.857639,-0.496405,-0.0767993,0.490429,0.868091,-10.8759,13.8204,-12.1237> }}
union{cone{<-11.301,16.5351,-13.6949> ,0.09504,<-11.9546,19.4561,-15.2563> ,0.0864}
sphere{<-11.301,16.5351,-13.6949> ,0.09504}
texture{txttree matrix <0.975871,0.218349,0,-0.193592,0.865227,-0.462497,-0.100986,0.451338,0.886621,-11.301,16.5351,-13.6949> }}
union{cone{<-11.9546,19.4561,-15.2563> ,0.0864,<-12.8426,21.788,-17.3346> ,0.07776}
sphere{<-11.9546,19.4561,-15.2563> ,0.0864}
texture{txttree matrix <0.93454,0.355858,0,-0.273439,0.718094,-0.639978,-0.227741,0.598085,0.768393,-11.9546,19.4561,-15.2563> }}
union{cone{<-8.3633,11.4887,-8.25768> ,0.1296,<-10.4566,13.9426,-8.72061> ,0.12096}
sphere{<-8.3633,11.4887,-8.25768> ,0.1296}
texture{txttree matrix <0.760804,0.648982,0,-0.642399,0.753087,-0.142067,-0.0921988,0.108085,0.989857,-8.3633,11.4887,-8.25768> }}
union{cone{<-10.4566,13.9426,-8.72061> ,0.12096,<-11.2578,16.7856,-10.3942> ,0.11232}
sphere{<-10.4566,13.9426,-8.72061> ,0.12096}
texture{txttree matrix <0.962499,0.271284,0,-0.236028,0.837415,-0.492978,-0.133737,0.474491,0.870042,-10.4566,13.9426,-8.72061> }}
union{cone{<-11.2578,16.7856,-10.3942> ,0.11232,<-13.0488,18.7642,-12.074> ,0.10368}
sphere{<-11.2578,16.7856,-10.3942> ,0.11232}
texture{txttree matrix <0.741404,0.671059,0,-0.567921,0.627455,-0.532696,-0.35747,0.394943,0.846307,-11.2578,16.7856,-10.3942> }}
union{cone{<-13.0488,18.7642,-12.074> ,0.10368,<-14.7186,20.8259,-14.1255> ,0.09504}
sphere{<-13.0488,18.7642,-12.074> ,0.10368}
texture{txttree matrix <0.777079,0.629404,0,-0.497912,0.614736,-0.611705,-0.38501,0.475343,0.791086,-13.0488,18.7642,-12.074> }}
union{cone{<-14.7186,20.8259,-14.1255> ,0.09504,<-16.0508,23.1379,-16.1477> ,0.0864}
sphere{<-14.7186,20.8259,-14.1255> ,0.09504}
texture{txttree matrix <0.866453,0.499259,0,-0.397904,0.690552,-0.603995,-0.30155,0.523333,0.796988,-14.7186,20.8259,-14.1255> }}
union{cone{<-16.0508,23.1379,-16.1477> ,0.0864,<-16.631,25.86,-18.1236> ,0.07776}
sphere{<-16.0508,23.1379,-16.1477> ,0.0864}
texture{txttree matrix <0.978031,0.208461,0,-0.169984,0.797509,-0.578865,-0.120671,0.566148,0.815423,-16.0508,23.1379,-16.1477> }}
union{cone{<-2.87477,3.07529,-3.99154> ,0.216,<-3.59968,4.36826,-4.91625> ,0.203657}
sphere{<-2.87477,3.07529,-3.99154> ,0.216}
texture{txttree matrix <0.872259,0.489045,0,-0.414928,0.740064,-0.529282,-0.258843,0.461671,0.848446,-2.87477,3.07529,-3.99154> }}
union{cone{<-3.59968,4.36826,-4.91625> ,0.203657,<-4.52731,5.70424,-5.69017> ,0.191314}
sphere{<-3.59968,4.36826,-4.91625> ,0.203657}
texture{txttree matrix <0.82141,0.570339,0,-0.515008,0.741721,-0.429671,-0.245058,0.352936,0.902986,-3.59968,4.36826,-4.91625> }}
union{cone{<-4.52731,5.70424,-5.69017> ,0.191314,<-5.00925,7.1269,-6.50689> ,0.178971}
sphere{<-4.52731,5.70424,-5.69017> ,0.191314}
texture{txttree matrix <0.94713,0.320849,0,-0.281876,0.832084,-0.477684,-0.153264,0.452429,0.878532,-4.52731,5.70424,-5.69017> }}
union{cone{<-5.00925,7.1269,-6.50689> ,0.178971,<-5.40909,8.49799,-7.61586> ,0.166629}
sphere{<-5.00925,7.1269,-6.50689> ,0.178971}
texture{txttree matrix <0.960012,0.279958,0,-0.221125,0.758267,-0.613298,-0.171697,0.588774,0.789851,-5.00925,7.1269,-6.50689> }}
union{cone{<-5.40909,8.49799,-7.61586> ,0.166629,<-5.64063,9.97863,-8.43866> ,0.154286}
sphere{<-5.40909,8.49799,-7.61586> ,0.166629}
texture{txttree matrix <0.987992,0.154506,0,-0.135436,0.866045,-0.481272,-0.0743596,0.475493,0.876571,-5.40909,8.49799,-7.61586> }}
union{cone{<-5.64063,9.97863,-8.43866> ,0.154286,<-5.76785,11.2092,-9.575> ,0.141943}
sphere{<-5.64063,9.97863,-8.43866> ,0.154286}
texture{txttree matrix <0.994699,0.102834,0,-0.0757328,0.732552,-0.676485,-0.0695657,0.672898,0.736457,-5.64063,9.97863,-8.43866> }}
union{cone{<-5.76785,11.2092,-9.575> ,0.141943,<-6.05711,12.5867,-10.4933> ,0.1296}
sphere{<-5.76785,11.2092,-9.575> ,0.141943}
texture{txttree matrix <0.978657,0.2055,0,-0.172112,0.819655,-0.546391,-0.112283,0.534729,0.83753,-5.76785,11.2092,-9.575> }}
union{cone{<-6.05711,12.5867,-10.4933> ,0.1296,<-6.38859,15.845,-11.3899> ,0.12096}
sphere{<-6.05711,12.5867,-10.4933> ,0.1296}
texture{txttree matrix <0.994865,0.101212,0,-0.0976203,0.959559,-0.264039,-0.0267239,0.262683,0.964512,-6.05711,12.5867,-10.4933> }}
union{cone{<-6.38859,15.845,-11.3899> ,0.12096,<-6.32138,19.2637,-11.598> ,0.11232}
sphere{<-6.38859,15.845,-11.3899> ,0.12096}
texture{txttree matrix <0.999807,-0.0196564,0,0.0196201,0.997961,-0.0607431,0.00119399,0.0607314,0.998153,-6.38859,15.845,-11.3899> }}
union{cone{<-6.32138,19.2637,-11.598> ,0.11232,<-6.09463,22.6533,-12.0544> ,0.10368}
sphere{<-6.32138,19.2637,-11.598> ,0.11232}
texture{txttree matrix <0.99777,-0.0667453,0,0.0661507,0.988883,-0.133174,0.0088887,0.132877,0.991093,-6.32138,19.2637,-11.598> }}
union{cone{<-6.09463,22.6533,-12.0544> ,0.10368,<-6.10777,25.9692,-12.7481> ,0.09504}
sphere{<-6.09463,22.6533,-12.0544> ,0.10368}
texture{txttree matrix <0.999992,0.00396249,0,-0.00387853,0.978804,-0.204762,-0.000811367,0.20476,0.978812,-6.09463,22.6533,-12.0544> }}
union{cone{<-6.10777,25.9692,-12.7481> ,0.09504,<-5.96184,28.7746,-14.5825> ,0.0864}
sphere{<-6.10777,25.9692,-12.7481> ,0.09504}
texture{txttree matrix <0.99865,-0.0519476,0,0.0434953,0.836161,-0.546756,0.0284027,0.546018,0.837292,-6.10777,25.9692,-12.7481> }}
union{cone{<-5.96184,28.7746,-14.5825> ,0.0864,<-5.74946,31.7713,-16.2075> ,0.07776}
sphere{<-5.96184,28.7746,-14.5825> ,0.0864}
texture{txttree matrix <0.997498,-0.0706926,0,0.0621795,0.877376,-0.475758,0.0336326,0.474568,0.879576,-5.96184,28.7746,-14.5825> }}
union{cone{<-5.81668,11.4417,-9.73001> ,0.1296,<-4.37576,13.6397,-11.8661> ,0.12096}
sphere{<-5.81668,11.4417,-9.73001> ,0.1296}
texture{txttree matrix <0.836313,-0.548252,0,0.425456,0.648997,-0.630706,0.345786,0.527467,0.776022,-5.81668,11.4417,-9.73001> }}
union{cone{<-4.37576,13.6397,-11.8661> ,0.12096,<-4.64348,16.7247,-12.7641> ,0.11232}
sphere{<-4.37576,13.6397,-11.8661> ,0.12096}
texture{txttree matrix <0.996256,0.0864553,0,-0.0830338,0.956828,-0.27854,-0.0240813,0.277497,0.960425,-4.37576,13.6397,-11.8661> }}
union{cone{<-4.64348,16.7247,-12.7641> ,0.11232,<-4.04067,18.9634,-15.1258> ,0.10368}
sphere{<-4.64348,16.7247,-12.7641> ,0.11232}
texture{txttree matrix <0.965606,-0.260009,0,0.182149,0.676453,-0.713606,0.185544,0.689062,0.700547,-4.64348,16.7247,-12.7641> }}
union{cone{<-4.04067,18.9634,-15.1258> ,0.10368,<-3.10426,21.3481,-17.144> ,0.09504}
sphere{<-4.04067,18.9634,-15.1258> ,0.10368}
texture{txttree matrix <0.930809,-0.365506,0,0.28712,0.731189,-0.618809,0.226178,0.575993,0.785541,-4.04067,18.9634,-15.1258> }}
union{cone{<-3.10426,21.3481,-17.144> ,0.09504,<-2.09705,23.9496,-18.5958> ,0.0864}
sphere{<-3.10426,21.3481,-17.144> ,0.09504}
texture{txttree matrix <0.932545,-0.361053,0,0.320275,0.827222,-0.461657,0.166683,0.430516,0.887059,-3.10426,21.3481,-17.144> }}
union{cone{<-2.09705,23.9496,-18.5958> ,0.0864,<-2.22758,26.8136,-19.9995> ,0.07776}
sphere{<-2.09705,23.9496,-18.5958> ,0.0864}
texture{txttree matrix <0.998963,0.0455272,0,-0.0408894,0.8972,-0.439727,-0.0200195,0.439271,0.898132,-2.09705,23.9496,-18.5958> }}
union{cone{<-4.20578,5.24117,-5.42192> ,0.1296,<-4.57541,7.72571,-7.58128> ,0.12096}
sphere{<-4.20578,5.24117,-5.42192> ,0.1296}
texture{txttree matrix <0.989114,0.147149,0,-0.111585,0.750059,-0.65189,-0.0959252,0.644793,0.758314,-4.20578,5.24117,-5.42192> }}
union{cone{<-4.57541,7.72571,-7.58128> ,0.12096,<-4.52514,9.54623,-10.2895> ,0.11232}
sphere{<-4.57541,7.72571,-7.58128> ,0.12096}
texture{txttree matrix <0.999619,-0.0276008,0,0.0154023,0.557827,-0.829814,0.0229035,0.829498,0.55804,-4.57541,7.72571,-7.58128> }}
union{cone{<-4.52514,9.54623,-10.2895> ,0.11232,<-5.01962,11.632,-12.8061> ,0.10368}
sphere{<-4.52514,9.54623,-10.2895> ,0.11232}
texture{txttree matrix <0.973029,0.230684,0,-0.149581,0.630935,-0.761279,-0.175615,0.740747,0.648424,-4.52514,9.54623,-10.2895> }}
union{cone{<-5.01962,11.632,-12.8061> ,0.10368,<-5.60297,14.4763,-14.4402> ,0.09504}
sphere{<-5.01962,11.632,-12.8061> ,0.10368}
texture{txttree matrix <0.979609,0.200913,0,-0.175088,0.853692,-0.490464,-0.0985407,0.480463,0.871462,-5.01962,11.632,-12.8061> }}
union{cone{<-5.60297,14.4763,-14.4402> ,0.09504,<-5.49167,17.1111,-16.1722> ,0.0864}
sphere{<-5.60297,14.4763,-14.4402> ,0.09504}
texture{txttree matrix <0.999109,-0.0422062,0,0.035278,0.835103,-0.548962,0.0231696,0.548472,0.835848,-5.60297,14.4763,-14.4402> }}
union{cone{<-5.49167,17.1111,-16.1722> ,0.0864,<-6.26455,19.6294,-18.2837> ,0.07776}
sphere{<-5.49167,17.1111,-16.1722> ,0.0864}
texture{txttree matrix <0.955989,0.293403,0,-0.228938,0.745943,-0.625425,-0.183501,0.597899,0.780284,-5.49167,17.1111,-16.1722> }}
union{cone{<-5.69325,10.4875,-8.90863> ,0.1296,<-6.33427,13.0809,-10.8986> ,0.12096}
sphere{<-5.69325,10.4875,-8.90863> ,0.1296}
texture{txttree matrix <0.970784,0.239955,0,-0.192434,0.778529,-0.597379,-0.143344,0.579926,0.801959,-5.69325,10.4875,-8.90863> }}
union{cone{<-6.33427,13.0809,-10.8986> ,0.12096,<-6.70349,16.0148,-12.5959> ,0.11232}
sphere{<-6.33427,13.0809,-10.8986> ,0.12096}
texture{txttree matrix <0.992174,0.12486,0,-0.108289,0.860496,-0.497816,-0.0621573,0.49392,0.867283,-6.33427,13.0809,-10.8986> }}
union{cone{<-6.70349,16.0148,-12.5959> ,0.11232,<-7.76022,17.9801,-15.0164> ,0.10368}
sphere{<-6.70349,16.0148,-12.5959> ,0.11232}
texture{txttree matrix <0.880745,0.473591,0,-0.320992,0.596954,-0.735262,-0.348214,0.647578,0.677783,-6.70349,16.0148,-12.5959> }}
union{cone{<-7.76022,17.9801,-15.0164> ,0.10368,<-8.7386,20.655,-16.3303> ,0.09504}
sphere{<-7.76022,17.9801,-15.0164> ,0.10368}
texture{txttree matrix <0.939151,0.343503,0,-0.311917,0.852794,-0.418867,-0.143882,0.39338,0.908048,-7.76022,17.9801,-15.0164> }}
union{cone{<-8.7386,20.655,-16.3303> ,0.09504,<-9.22594,23.4976,-17.9059> ,0.0864}
sphere{<-8.7386,20.655,-16.3303> ,0.09504}
texture{txttree matrix <0.98562,0.168976,0,-0.14829,0.864963,-0.479426,-0.0810114,0.472532,0.877582,-8.7386,20.655,-16.3303> }}
union{cone{<-9.22594,23.4976,-17.9059> ,0.0864,<-10.1293,26.1659,-19.4544> ,0.07776}
sphere{<-9.22594,23.4976,-17.9059> ,0.0864}
texture{txttree matrix <0.947189,0.320677,0,-0.281021,0.830055,-0.481701,-0.15447,0.456262,0.876336,-9.22594,23.4976,-17.9059> }}
union{cone{<-1.47887,1.78341,-2.07527> ,0.216,<-2.19171,2.39534,-3.47109> ,0.203657}
sphere{<-1.47887,1.78341,-2.07527> ,0.216}
texture{txttree matrix <0.651359,0.758769,0,-0.423666,0.363693,-0.829599,-0.629474,0.540367,0.55836,-1.47887,1.78341,-2.07527> }}
union{cone{<-2.19171,2.39534,-3.47109> ,0.203657,<-1.96433,3.02686,-5.04191> ,0.191314}
sphere{<-2.19171,2.39534,-3.47109> ,0.203657}
texture{txttree matrix <0.940875,-0.338755,0,0.133106,0.369696,-0.919569,0.311509,0.8652,0.392928,-2.19171,2.39534,-3.47109> }}
union{cone{<-1.96433,3.02686,-5.04191> ,0.191314,<-1.69584,3.92548,-6.58138> ,0.178971}
sphere{<-1.96433,3.02686,-5.04191> ,0.191314}
texture{txttree matrix <0.958147,-0.286277,0,0.148943,0.4985,-0.853999,0.24448,0.818256,0.520275,-1.96433,3.02686,-5.04191> }}
union{cone{<-1.69584,3.92548,-6.58138> ,0.178971,<-1.55546,5.23248,-7.78775> ,0.166629}
sphere{<-1.69584,3.92548,-6.58138> ,0.178971}
texture{txttree matrix <0.994281,-0.106795,0,0.0786825,0.732548,-0.676152,0.0722097,0.672285,0.736762,-1.69584,3.92548,-6.58138> }}
union{cone{<-1.55546,5.23248,-7.78775> ,0.166629,<-1.83594,6.13131,-9.30991> ,0.154286}
sphere{<-1.55546,5.23248,-7.78775> ,0.166629}
texture{txttree matrix <0.9546,0.297892,0,-0.156711,0.502184,-0.850443,-0.25334,0.811833,0.526067,-1.55546,5.23248,-7.78775> }}
union{cone{<-1.83594,6.13131,-9.30991> ,0.154286,<-2.35627,7.15034,-10.6705> ,0.141943}
sphere{<-1.83594,6.13131,-9.30991> ,0.154286}
texture{txttree matrix <0.890616,0.454756,0,-0.292688,0.573214,-0.765349,-0.348047,0.681632,0.643615,-1.83594,6.13131,-9.30991> }}
union{cone{<-2.35627,7.15034,-10.6705> ,0.141943,<-2.40183,8.42905,-11.8093> ,0.1296}
sphere{<-2.35627,7.15034,-10.6705> ,0.141943}
texture{txttree matrix <0.999366,0.0356036,0,-0.0265959,0.746527,-0.664823,-0.0236701,0.664402,0.747001,-2.35627,7.15034,-10.6705> }}
union{cone{<-2.40183,8.42905,-11.8093> ,0.1296,<-2.11587,11.8354,-11.8918> ,0.12096}
sphere{<-2.40183,8.42905,-11.8093> ,0.1296}
texture{txttree matrix <0.996495,-0.0836532,0,0.0836289,0.996205,-0.0241318,0.0020187,0.0240472,0.999709,-2.40183,8.42905,-11.8093> }}
union{cone{<-2.11587,11.8354,-11.8918> ,0.12096,<-1.19979,14.5797,-13.0528> ,0.11232}
sphere{<-2.11587,11.8354,-11.8918> ,0.12096}
texture{txttree matrix <0.948545,-0.316642,0,0.293864,0.880309,-0.372425,0.117925,0.353261,0.928062,-2.11587,11.8354,-11.8918> }}
union{cone{<-1.19979,14.5797,-13.0528> ,0.11232,<-1.78097,17.4017,-14.36> ,0.10368}
sphere{<-1.19979,14.5797,-13.0528> ,0.11232}
texture{txttree matrix <0.979446,0.201708,0,-0.183687,0.891937,-0.413167,-0.0833392,0.404675,0.910655,-1.19979,14.5797,-13.0528> }}
union{cone{<-1.78097,17.4017,-14.36> ,0.10368,<-1.65642,20.2272,-15.7352> ,0.09504}
sphere{<-1.78097,17.4017,-14.36> ,0.10368}
texture{txttree matrix <0.99903,-0.0440358,0,0.0396028,0.898459,-0.437268,0.0192554,0.436844,0.899331,-1.78097,17.4017,-14.36> }}
union{cone{<-1.65642,20.2272,-15.7352> ,0.09504,<-1.87628,23.2068,-16.7447> ,0.0864}
sphere{<-1.65642,20.2272,-15.7352> ,0.09504}
texture{txttree matrix <0.997289,0.073591,0,-0.0697185,0.944809,-0.320119,-0.0235579,0.319251,0.947377,-1.65642,20.2272,-15.7352> }}
union{cone{<-1.87628,23.2068,-16.7447> ,0.0864,<-2.36878,25.9184,-18.2998> ,0.07776}
sphere{<-1.87628,23.2068,-16.7447> ,0.0864}
texture{txttree matrix <0.983903,0.178703,0,-0.155634,0.856892,-0.491441,-0.0878219,0.483531,0.870911,-1.87628,23.2068,-16.7447> }}
union{cone{<-1.76144,3.70591,-6.20522> ,0.1296,<0.204889,5.8149,-7.95389> ,0.12096}
sphere{<-1.76144,3.70591,-6.20522> ,0.1296}
texture{txttree matrix <0.731411,-0.681937,0,0.583091,0.625394,-0.518544,0.353614,0.379269,0.855051,-1.76144,3.70591,-6.20522> }}
union{cone{<0.204889,5.8149,-7.95389> ,0.12096,<1.4997,8.22372,-9.9612> ,0.11232}
sphere{<0.204889,5.8149,-7.95389> ,0.12096}
texture{txttree matrix <0.880813,-0.473464,0,0.381683,0.710067,-0.591712,0.280154,0.521188,0.806149,0.204889,5.8149,-7.95389> }}
union{cone{<1.4997,8.22372,-9.9612> ,0.11232,<2.22257,10.1243,-12.6121> ,0.10368}
sphere{<1.4997,8.22372,-9.9612> ,0.11232}
texture{txttree matrix <0.934681,-0.355488,0,0.216362,0.568878,-0.793452,0.282063,0.741624,0.608633,1.4997,8.22372,-9.9612> }}
union{cone{<2.22257,10.1243,-12.6121> ,0.10368,<3.86069,12.0417,-14.5301> ,0.09504}
sphere{<2.22257,10.1243,-12.6121> ,0.10368}
texture{txttree matrix <0.760306,-0.649565,0,0.517023,0.605168,-0.605358,0.39322,0.460258,0.795953,2.22257,10.1243,-12.6121> }}
union{cone{<3.86069,12.0417,-14.5301> ,0.09504,<5.0236,14.2987,-16.3397> ,0.0864}
sphere{<3.86069,12.0417,-14.5301> ,0.09504}
texture{txttree matrix <0.888936,-0.458031,0,0.372993,0.723897,-0.580387,0.265835,0.515927,0.814341,3.86069,12.0417,-14.5301> }}
union{cone{<5.0236,14.2987,-16.3397> ,0.0864,<6.38604,15.8772,-18.7461> ,0.07776}
sphere{<5.0236,14.2987,-16.3397> ,0.0864}
texture{txttree matrix <0.757023,-0.653388,0,0.427875,0.495742,-0.755753,0.4938,0.572123,0.654857,5.0236,14.2987,-16.3397> }}
union{cone{<-1.71098,3.87481,-6.49456> ,0.1296,<-0.215424,5.21467,-9.22654> ,0.12096}
sphere{<-1.71098,3.87481,-6.49456> ,0.1296}
texture{txttree matrix <0.667275,-0.744811,0,0.441099,0.39518,-0.805769,0.600146,0.53767,0.59223,-1.71098,3.87481,-6.49456> }}
union{cone{<-0.215424,5.21467,-9.22654> ,0.12096,<0.535738,5.11241,-12.3739> ,0.11232}
sphere{<-0.215424,5.21467,-9.22654> ,0.12096}
texture{txttree matrix <-0.134891,-0.99086,0,0.23203,-0.0315875,-0.972195,0.96331,-0.13114,0.234171,-0.215424,5.21467,-9.22654> }}
union{cone{<0.535738,5.11241,-12.3739> ,0.11232,<1.60587,5.38621,-15.359> ,0.10368}
sphere{<0.535738,5.11241,-12.3739> ,0.11232}
texture{txttree matrix <0.247866,-0.968794,0,0.336205,0.0860182,-0.937852,0.908586,0.232462,0.347035,0.535738,5.11241,-12.3739> }}
union{cone{<1.60587,5.38621,-15.359> ,0.10368,<2.03665,5.86519,-18.4804> ,0.09504}
sphere{<1.60587,5.38621,-15.359> ,0.10368}
texture{txttree matrix <0.743527,-0.668705,0,0.135161,0.150285,-0.97936,0.654903,0.728181,0.202124,1.60587,5.38621,-15.359> }}
union{cone{<2.03665,5.86519,-18.4804> ,0.09504,<2.06055,7.66997,-21.0241> ,0.0864}
sphere{<2.03665,5.86519,-18.4804> ,0.09504}
texture{txttree matrix <0.999912,-0.0132424,0,0.00766338,0.57865,-0.81554,0.0107997,0.815468,0.578701,2.03665,5.86519,-18.4804> }}
union{cone{<2.06055,7.66997,-21.0241> ,0.0864,<2.19041,8.66934,-24.0683> ,0.07776}
sphere{<2.06055,7.66997,-21.0241> ,0.0864}
texture{txttree matrix <0.991664,-0.128854,0,0.0404951,0.311651,-0.949333,0.122326,0.941419,0.314271,2.06055,7.66997,-21.0241> }}
union{cone{<-1.66874,4.17781,-6.81428> ,0.1296,<-0.914351,6.05397,-9.27899> ,0.12096}
sphere{<-1.66874,4.17781,-6.81428> ,0.1296}
texture{txttree matrix <0.927807,-0.373062,0,0.236627,0.588492,-0.773101,0.288414,0.717288,0.634283,-1.66874,4.17781,-6.81428> }}
union{cone{<-0.914351,6.05397,-9.27899> ,0.12096,<-1.81804,6.91604,-12.3417> ,0.11232}
sphere{<-0.914351,6.05397,-9.27899> ,0.12096}
texture{txttree matrix <0.69025,0.723571,0,-0.273215,0.260633,-0.925972,-0.670006,0.639152,0.377593,-0.914351,6.05397,-9.27899> }}
union{cone{<-1.81804,6.91604,-12.3417> ,0.11232,<-2.59774,8.19032,-15.2313> ,0.10368}
sphere{<-1.81804,6.91604,-12.3417> ,0.11232}
texture{txttree matrix <0.852991,0.521926,0,-0.239697,0.39174,-0.888305,-0.463629,0.757716,0.459255,-1.81804,6.91604,-12.3417> }}
union{cone{<-2.59774,8.19032,-15.2313> ,0.10368,<-2.72184,9.95022,-17.8176> ,0.09504}
sphere{<-2.59774,8.19032,-15.2313> ,0.10368}
texture{txttree matrix <0.997523,0.0703415,0,-0.0396387,0.562122,-0.826104,-0.0581094,0.824057,0.563518,-2.59774,8.19032,-15.2313> }}
union{cone{<-2.72184,9.95022,-17.8176> ,0.09504,<-2.59229,11.9061,-20.3575> ,0.0864}
sphere{<-2.72184,9.95022,-17.8176> ,0.09504}
texture{txttree matrix <0.997813,-0.0660936,0,0.0403809,0.60963,-0.791657,0.0523235,0.789926,0.610966,-2.72184,9.95022,-17.8176> }}
union{cone{<-2.59229,11.9061,-20.3575> ,0.0864,<-3.38869,14.1546,-22.534> ,0.07776}
sphere{<-2.59229,11.9061,-20.3575> ,0.0864}
texture{txttree matrix <0.942619,0.33387,0,-0.246636,0.69633,-0.674014,-0.225033,0.635338,0.738719,-2.59229,11.9061,-20.3575> }}
union{cone{<-2.36087,7.27941,-10.7855> ,0.1296,<-4.01971,9.88553,-11.5481> ,0.12096}
sphere{<-2.36087,7.27941,-10.7855> ,0.1296}
texture{txttree matrix <0.843603,0.536968,0,-0.521319,0.819018,-0.239657,-0.128688,0.202175,0.970858,-2.36087,7.27941,-10.7855> }}
union{cone{<-4.01971,9.88553,-11.5481> ,0.12096,<-5.05167,13.0273,-12.4663> ,0.11232}
sphere{<-4.01971,9.88553,-11.5481> ,0.12096}
texture{txttree matrix <0.950062,0.31206,0,-0.300683,0.915425,-0.267559,-0.0834945,0.254198,0.963541,-4.01971,9.88553,-11.5481> }}
union{cone{<-5.05167,13.0273,-12.4663> ,0.11232,<-6.40805,15.7703,-13.5769> ,0.10368}
sphere{<-5.05167,13.0273,-12.4663> ,0.11232}
texture{txttree matrix <0.896393,0.44326,0,-0.416667,0.842617,-0.341153,-0.151219,0.305808,0.940008,-5.05167,13.0273,-12.4663> }}
union{cone{<-6.40805,15.7703,-13.5769> ,0.10368,<-8.05275,18.2726,-15.2239> ,0.09504}
sphere{<-6.40805,15.7703,-13.5769> ,0.10368}
texture{txttree matrix <0.835652,0.549259,0,-0.481262,0.732199,-0.481945,-0.264713,0.402739,0.876201,-6.40805,15.7703,-13.5769> }}
union{cone{<-8.05275,18.2726,-15.2239> ,0.09504,<-8.51604,20.5399,-17.7404> ,0.0864}
sphere{<-8.05275,18.2726,-15.2239> ,0.09504}
texture{txttree matrix <0.979756,0.200194,0,-0.135512,0.663198,-0.736074,-0.147358,0.721173,0.676901,-8.05275,18.2726,-15.2239> }}
union{cone{<-8.51604,20.5399,-17.7404> ,0.0864,<-9.00737,22.9358,-19.9388> ,0.07776}
sphere{<-8.51604,20.5399,-17.7404> ,0.0864}
texture{txttree matrix <0.979614,0.200891,0,-0.149405,0.728551,-0.6685,-0.134296,0.654872,0.743712,-8.51604,20.5399,-17.7404> }}
union{cone{<-2.93409,3.15029,-4.09293> ,0.216,<-2.79039,3.03826,-5.78181> ,0.203657}
sphere{<-2.93409,3.15029,-4.09293> ,0.216}
texture{txttree matrix <-0.614869,-0.788629,0,0.0845922,-0.0659538,-0.99423,0.784079,-0.611322,0.107265,-2.93409,3.15029,-4.09293> }}
union{cone{<-2.79039,3.03826,-5.78181> ,0.203657,<-2.93455,2.73391,-7.56454> ,0.191314}
sphere{<-2.79039,3.03826,-5.78181> ,0.203657}
texture{txttree matrix <-0.903753,0.428053,0,-0.0794551,-0.167754,-0.982622,-0.420615,-0.888048,0.18562,-2.79039,3.03826,-5.78181> }}
union{cone{<-2.93455,2.73391,-7.56454> ,0.191314,<-3.54509,3.40554,-9.15116> ,0.178971}
sphere{<-2.93455,2.73391,-7.56454> ,0.191314}
texture{txttree matrix <0.739957,0.672655,0,-0.334012,0.367431,-0.868004,-0.583867,0.642285,0.496557,-2.93455,2.73391,-7.56454> }}
union{cone{<-3.54509,3.40554,-9.15116> ,0.178971,<-3.86034,3.95939,-10.8374> ,0.166629}
sphere{<-3.54509,3.40554,-9.15116> ,0.178971}
texture{txttree matrix <0.869073,0.494683,0,-0.174883,0.30724,-0.935425,-0.462739,0.812953,0.353526,-3.54509,3.40554,-9.15116> }}
union{cone{<-3.86034,3.95939,-10.8374> ,0.166629,<-4.3757,4.49814,-12.3756> ,0.154286}
sphere{<-3.86034,3.95939,-10.8374> ,0.166629}
texture{txttree matrix <0.72262,0.691245,0,-0.301492,0.315177,-0.89987,-0.622031,0.650264,0.436158,-3.86034,3.95939,-10.8374> }}
union{cone{<-4.3757,4.49814,-12.3756> ,0.154286,<-4.56167,4.66342,-14.1164> ,0.141943}
sphere{<-4.3757,4.49814,-12.3756> ,0.154286}
texture{txttree matrix <0.664302,0.747464,0,-0.10576,0.0939929,-0.98994,-0.739944,0.657619,0.141491,-4.3757,4.49814,-12.3756> }}
union{cone{<-4.56167,4.66342,-14.1164> ,0.141943,<-4.8835,5.61718,-15.4893> ,0.1296}
sphere{<-4.56167,4.66342,-14.1164> ,0.141943}
texture{txttree matrix <0.947513,0.319717,0,-0.189048,0.560262,-0.806453,-0.257837,0.764125,0.591298,-4.56167,4.66342,-14.1164> }}
union{cone{<-4.8835,5.61718,-15.4893> ,0.1296,<-4.9646,8.74073,-16.8878> ,0.12096}
sphere{<-4.8835,5.61718,-15.4893> ,0.1296}
texture{txttree matrix <0.999663,0.0259547,0,-0.02369,0.912436,-0.408533,-0.0106033,0.408395,0.912744,-4.8835,5.61718,-15.4893> }}
union{cone{<-4.9646,8.74073,-16.8878> ,0.12096,<-6.25964,11.5078,-17.9948> ,0.11232}
sphere{<-4.9646,8.74073,-16.8878> ,0.12096}
texture{txttree matrix <0.905713,0.423892,0,-0.398536,0.851536,-0.340668,-0.144406,0.308547,0.940184,-4.9646,8.74073,-16.8878> }}
union{cone{<-6.25964,11.5078,-17.9948> ,0.11232,<-7.11742,14.3594,-18.9084> ,0.10368}
sphere{<-6.25964,11.5078,-17.9948> ,0.11232}
texture{txttree matrix <0.957612,0.28806,0,-0.275391,0.915496,-0.293302,-0.0844886,0.280869,0.95602,-6.25964,11.5078,-17.9948> }}
union{cone{<-7.11742,14.3594,-18.9084> ,0.10368,<-8.42854,16.5115,-21.1247> ,0.09504}
sphere{<-7.11742,14.3594,-18.9084> ,0.10368}
texture{txttree matrix <0.853999,0.520274,0,-0.390677,0.641274,-0.660408,-0.343593,0.563988,0.750907,-7.11742,14.3594,-18.9084> }}
union{cone{<-8.42854,16.5115,-21.1247> ,0.09504,<-8.47539,18.7485,-23.4637> ,0.0864}
sphere{<-8.42854,16.5115,-21.1247> ,0.09504}
texture{txttree matrix <0.999781,0.0209368,0,-0.0144726,0.691098,-0.722617,-0.0151293,0.722458,0.691249,-8.42854,16.5115,-21.1247> }}
union{cone{<-8.47539,18.7485,-23.4637> ,0.0864,<-9.01694,21.4163,-25.4502> ,0.07776}
sphere{<-8.47539,18.7485,-23.4637> ,0.0864}
texture{txttree matrix <0.980012,0.198936,0,-0.160699,0.791646,-0.589467,-0.117267,0.577685,0.807792,-8.47539,18.7485,-23.4637> }}
union{cone{<-4.44533,4.56002,-13.0274> ,0.1296,<-4.46797,5.05047,-16.4057> ,0.12096}
sphere{<-4.44533,4.56002,-13.0274> ,0.1296}
texture{txttree matrix <0.998936,0.0461081,0,-0.00663123,0.143666,-0.989604,-0.0456288,0.988551,0.143819,-4.44533,4.56002,-13.0274> }}
union{cone{<-4.46797,5.05047,-16.4057> ,0.12096,<-5.07739,7.08717,-19.1093> ,0.11232}
sphere{<-4.46797,5.05047,-16.4057> ,0.12096}
texture{txttree matrix <0.958032,0.286661,0,-0.177191,0.592179,-0.786083,-0.22534,0.753093,0.618121,-4.46797,5.05047,-16.4057> }}
union{cone{<-5.07739,7.08717,-19.1093> ,0.11232,<-5.14033,7.93449,-22.4366> ,0.10368}
sphere{<-5.07739,7.08717,-19.1093> ,0.11232}
texture{txttree matrix <0.997252,0.0740858,0,-0.0183303,0.24674,-0.968908,-0.0717823,0.966246,0.24742,-5.07739,7.08717,-19.1093> }}
union{cone{<-5.14033,7.93449,-22.4366> ,0.10368,<-4.50509,9.18714,-25.2779> ,0.09504}
sphere{<-5.14033,7.93449,-22.4366> ,0.10368}
texture{txttree matrix <0.891873,-0.452285,0,0.200423,0.39522,-0.896455,0.405453,0.799525,0.443134,-5.14033,7.93449,-22.4366> }}
union{cone{<-4.50509,9.18714,-25.2779> ,0.09504,<-4.38187,10.3383,-28.4905> ,0.0864}
sphere{<-4.50509,9.18714,-25.2779> ,0.09504}
texture{txttree matrix <0.994319,-0.106438,0,0.0360853,0.337101,-0.940777,0.100134,0.935432,0.339027,-4.50509,9.18714,-25.2779> }}
union{cone{<-4.38187,10.3383,-28.4905> ,0.0864,<-3.58655,12.0532,-31.1835> ,0.07776}
sphere{<-4.38187,10.3383,-28.4905> ,0.0864}
texture{txttree matrix <0.907187,-0.420727,0,0.241719,0.521203,-0.818486,0.344359,0.74252,0.574526,-4.38187,10.3383,-28.4905> }}
union{cone{<-2.83152,2.95142,-6.29045> ,0.1296,<-2.12085,3.12484,-9.64148> ,0.12096}
sphere{<-2.83152,2.95142,-6.29045> ,0.1296}
texture{txttree matrix <0.237061,-0.971495,0,0.207196,0.0505592,-0.976992,0.949143,0.231607,0.213275,-2.83152,2.95142,-6.29045> }}
union{cone{<-2.12085,3.12484,-9.64148> ,0.12096,<-2.05314,3.22582,-12.8046> ,0.11232}
sphere{<-2.12085,3.12484,-9.64148> ,0.12096}
texture{txttree matrix <0.830559,-0.55693,0,0.0213908,0.0319004,-0.999262,0.556519,0.829946,0.0384083,-2.12085,3.12484,-9.64148> }}
union{cone{<-2.05314,3.22582,-12.8046> ,0.11232,<-1.98855,4.95443,-15.6572> ,0.10368}
sphere{<-2.05314,3.22582,-12.8046> ,0.11232}
texture{txttree matrix <0.999303,-0.0373414,0,0.0193619,0.518148,-0.855072,0.0319295,0.854475,0.51851,-2.05314,3.22582,-12.8046> }}
union{cone{<-1.98855,4.95443,-15.6572> ,0.10368,<-1.77245,5.32588,-18.8567> ,0.09504}
sphere{<-1.98855,4.95443,-15.6572> ,0.10368}
texture{txttree matrix <0.864369,-0.502858,0,0.0669387,0.115062,-0.9911,0.498383,0.856676,0.133117,-1.98855,4.95443,-15.6572> }}
union{cone{<-1.77245,5.32588,-18.8567> ,0.09504,<-1.23581,6.73874,-21.9373> ,0.0864}
sphere{<-1.77245,5.32588,-18.8567> ,0.09504}
texture{txttree matrix <0.934838,-0.355074,0,0.156394,0.411753,-0.897775,0.318776,0.839275,0.440454,-1.77245,5.32588,-18.8567> }}
union{cone{<-1.23581,6.73874,-21.9373> ,0.0864,<-1.64337,7.89019,-24.9686> ,0.07776}
sphere{<-1.23581,6.73874,-21.9373> ,0.0864}
texture{txttree matrix <0.94269,0.333669,0,-0.124706,0.352324,-0.927532,-0.309488,0.874376,0.373743,-1.23581,6.73874,-21.9373> }}
union{cone{<-4.62841,4.86119,-14.4011> ,0.1296,<-5.97597,4.61226,-17.2037> ,0.12096}
sphere{<-4.62841,4.86119,-14.4011> ,0.1296}
texture{txttree matrix <-0.181647,0.983364,0,-0.431955,-0.0797908,-0.898359,-0.883413,-0.163184,0.439263,-4.62841,4.86119,-14.4011> }}
union{cone{<-5.97597,4.61226,-17.2037> ,0.12096,<-7.78473,5.26819,-20.0487> ,0.11232}
sphere{<-5.97597,4.61226,-17.2037> ,0.12096}
texture{txttree matrix <0.340918,0.940093,0,-0.526642,0.190983,-0.828356,-0.778732,0.282401,0.560202,-5.97597,4.61226,-17.2037> }}
union{cone{<-7.78473,5.26819,-20.0487> ,0.11232,<-7.92991,5.92815,-23.1742> ,0.10368}
sphere{<-7.78473,5.26819,-20.0487> ,0.11232}
texture{txttree matrix <0.976646,0.214855,0,-0.0454024,0.206381,-0.977418,-0.210003,0.954591,0.211316,-7.78473,5.26819,-20.0487> }}
union{cone{<-7.92991,5.92815,-23.1742> ,0.10368,<-8.55106,7.68782,-25.7509> ,0.09504}
sphere{<-7.92991,5.92815,-23.1742> ,0.10368}
texture{txttree matrix <0.942975,0.332863,0,-0.195243,0.553108,-0.809908,-0.269588,0.763723,0.586557,-7.92991,5.92815,-23.1742> }}
union{cone{<-8.55106,7.68782,-25.7509> ,0.09504,<-8.79155,8.61226,-28.9611> ,0.0864}
sphere{<-8.55106,7.68782,-25.7509> ,0.09504}
texture{txttree matrix <0.967788,0.251767,0,-0.071802,0.276006,-0.95847,-0.241311,0.927596,0.285193,-8.55106,7.68782,-25.7509> }}
union{cone{<-8.79155,8.61226,-28.9611> ,0.0864,<-9.85868,10.659,-31.4453> ,0.07776}
sphere{<-8.79155,8.61226,-28.9611> ,0.0864}
texture{txttree matrix <0.886718,0.462311,0,-0.314687,0.603573,-0.732579,-0.338679,0.649591,0.680682,-8.79155,8.61226,-28.9611> }}
union{cone{<-4.78226,5.31714,-15.0574> ,0.1296,<-6.45667,7.13039,-17.414> ,0.12096}
sphere{<-4.78226,5.31714,-15.0574> ,0.1296}
texture{txttree matrix <0.734675,0.67842,0,-0.490664,0.53135,-0.690591,-0.468511,0.50736,0.723246,-4.78226,5.31714,-15.0574> }}
union{cone{<-6.45667,7.13039,-17.414> ,0.12096,<-6.90898,8.49399,-20.1935> ,0.11232}
sphere{<-6.45667,7.13039,-17.414> ,0.12096}
texture{txttree matrix <0.949145,0.31484,0,-0.144567,0.435825,-0.888345,-0.279687,0.843168,0.459177,-6.45667,7.13039,-17.414> }}
union{cone{<-6.90898,8.49399,-20.1935> ,0.11232,<-8.26159,11.1035,-21.827> ,0.10368}
sphere{<-6.90898,8.49399,-20.1935> ,0.11232}
texture{txttree matrix <0.88782,0.460191,0,-0.402242,0.776023,-0.485788,-0.223555,0.431292,0.874077,-6.90898,8.49399,-20.1935> }}
union{cone{<-8.26159,11.1035,-21.827> ,0.10368,<-9.3711,13.5575,-23.6701> ,0.09504}
sphere{<-8.26159,11.1035,-21.827> ,0.10368}
texture{txttree matrix <0.911194,0.411978,0,-0.339983,0.751958,-0.564775,-0.232675,0.51462,0.825245,-8.26159,11.1035,-21.827> }}
union{cone{<-9.3711,13.5575,-23.6701> ,0.09504,<-9.87517,15.0406,-26.4176> ,0.0864}
sphere{<-9.3711,13.5575,-23.6701> ,0.09504}
texture{txttree matrix <0.946809,0.321797,0,-0.159382,0.468941,-0.86873,-0.279555,0.822521,0.495286,-9.3711,13.5575,-23.6701> }}
union{cone{<-9.87517,15.0406,-26.4176> ,0.0864,<-10.3782,17.1763,-28.8464> ,0.07776}
sphere{<-9.87517,15.0406,-26.4176> ,0.0864}
texture{txttree matrix <0.973366,0.229255,0,-0.153683,0.652505,-0.742037,-0.170115,0.722274,0.670359,-9.87517,15.0406,-26.4176> }}
union{cone{<-3.03387,3.42699,-4.52628> ,0.216,<-4.58143,3.79893,-5.11779> ,0.203657}
sphere{<-3.03387,3.42699,-4.52628> ,0.216}
texture{txttree matrix <0.233682,0.972313,0,-0.911408,0.219044,-0.348361,-0.338716,0.0814056,0.937361,-3.03387,3.42699,-4.52628> }}
union{cone{<-4.58143,3.79893,-5.11779> ,0.203657,<-5.85284,4.81603,-5.93542> ,0.191314}
sphere{<-4.58143,3.79893,-5.11779> ,0.203657}
texture{txttree matrix <0.624686,0.780876,0,-0.69783,0.558251,-0.448765,-0.35043,0.280337,0.89365,-4.58143,3.79893,-5.11779> }}
union{cone{<-5.85284,4.81603,-5.93542> ,0.191314,<-6.82986,5.26075,-7.31803> ,0.178971}
sphere{<-5.85284,4.81603,-5.93542> ,0.191314}
texture{txttree matrix <0.414284,0.910148,0,-0.558165,0.254067,-0.789875,-0.718903,0.327232,0.613268,-5.85284,4.81603,-5.93542> }}
union{cone{<-6.82986,5.26075,-7.31803> ,0.178971,<-7.95829,5.94441,-8.55514> ,0.166629}
sphere{<-6.82986,5.26075,-7.31803> ,0.178971}
texture{txttree matrix <0.51817,0.855277,0,-0.62391,0.377996,-0.684,-0.58501,0.354428,0.729482,-6.82986,5.26075,-7.31803> }}
union{cone{<-7.95829,5.94441,-8.55514> ,0.166629,<-8.49929,7.22096,-9.48631> ,0.154286}
sphere{<-7.95829,5.94441,-8.55514> ,0.166629}
texture{txttree matrix <0.920731,0.390198,0,-0.323923,0.764343,-0.557542,-0.217552,0.513346,0.830148,-7.95829,5.94441,-8.55514> }}
union{cone{<-8.49929,7.22096,-9.48631> ,0.154286,<-9.40559,8.51825,-10.3809> ,0.141943}
sphere{<-8.49929,7.22096,-9.48631> ,0.154286}
texture{txttree matrix <0.819763,0.572703,0,-0.498552,0.713623,-0.492126,-0.281842,0.403426,0.870524,-8.49929,7.22096,-9.48631> }}
union{cone{<-9.40559,8.51825,-10.3809> ,0.141943,<-10.2912,9.38752,-11.5224> ,0.1296}
sphere{<-9.40559,8.51825,-10.3809> ,0.141943}
texture{txttree matrix <0.700482,0.71367,0,-0.525257,0.515551,-0.676988,-0.483146,0.474218,0.735994,-9.40559,8.51825,-10.3809> }}
union{cone{<-10.2912,9.38752,-11.5224> ,0.1296,<-13.2526,10.7344,-12.166> ,0.12096}
sphere{<-10.2912,9.38752,-11.5224> ,0.1296}
texture{txttree matrix <0.414017,0.910269,0,-0.892962,0.406145,-0.194078,-0.176663,0.0803514,0.980986,-10.2912,9.38752,-11.5224> }}
union{cone{<-13.2526,10.7344,-12.166> ,0.12096,<-15.0867,12.0461,-14.3576> ,0.11232}
sphere{<-13.2526,10.7344,-12.166> ,0.12096}
texture{txttree matrix <0.581701,0.813403,0,-0.583306,0.417148,-0.696952,-0.566903,0.405418,0.717118,-13.2526,10.7344,-12.166> }}
union{cone{<-15.0867,12.0461,-14.3576> ,0.11232,<-17.0619,13.8872,-16.1796> ,0.10368}
sphere{<-15.0867,12.0461,-14.3576> ,0.11232}
texture{txttree matrix <0.681852,0.73149,0,-0.606358,0.565211,-0.559345,-0.409155,0.38139,0.828935,-15.0867,12.0461,-14.3576> }}
union{cone{<-17.0619,13.8872,-16.1796> ,0.10368,<-18.8038,15.8254,-18.1397> ,0.09504}
sphere{<-17.0619,13.8872,-16.1796> ,0.10368}
texture{txttree matrix <0.743774,0.668431,0,-0.534186,0.594397,-0.601114,-0.401803,0.447093,0.799163,-17.0619,13.8872,-16.1796> }}
union{cone{<-18.8038,15.8254,-18.1397> ,0.09504,<-20.034,17.5673,-20.4906> ,0.0864}
sphere{<-18.8038,15.8254,-18.1397> ,0.09504}
texture{txttree matrix <0.816822,0.57689,0,-0.38759,0.548791,-0.740677,-0.427289,0.605002,0.671861,-18.8038,15.8254,-18.1397> }}
union{cone{<-20.034,17.5673,-20.4906> ,0.0864,<-21.7356,19.9884,-21.7154> ,0.07776}
sphere{<-20.034,17.5673,-20.4906> ,0.0864}
texture{txttree matrix <0.818139,0.57502,0,-0.531313,0.755952,-0.382418,-0.219898,0.312871,0.923989,-20.034,17.5673,-20.4906> }}
union{cone{<-8.71396,7.52826,-9.69822> ,0.1296,<-8.95675,9.86806,-11.7541> ,0.12096}
sphere{<-8.71396,7.52826,-9.69822> ,0.1296}
texture{txttree matrix <0.99466,0.103209,0,-0.0777122,0.748941,-0.658064,-0.0679179,0.65455,0.752962,-8.71396,7.52826,-9.69822> }}
union{cone{<-8.95675,9.86806,-11.7541> ,0.12096,<-10.0585,11.4956,-14.2311> ,0.11232}
sphere{<-8.95675,9.86806,-11.7541> ,0.12096}
texture{txttree matrix <0.82809,0.560595,0,-0.348448,0.514714,-0.78336,-0.439148,0.648693,0.621568,-8.95675,9.86806,-11.7541> }}
union{cone{<-10.0585,11.4956,-14.2311> ,0.11232,<-11.0705,13.8342,-16.3146> ,0.10368}
sphere{<-10.0585,11.4956,-14.2311> ,0.11232}
texture{txttree matrix <0.917759,0.397137,0,-0.307449,0.710497,-0.632984,-0.251381,0.580927,0.774165,-10.0585,11.4956,-14.2311> }}
union{cone{<-11.0705,13.8342,-16.3146> ,0.10368,<-10.9214,16.2059,-18.4751> ,0.09504}
sphere{<-11.0705,13.8342,-16.3146> ,0.10368}
texture{txttree matrix <0.99803,-0.062736,0,0.0464193,0.738457,-0.672701,0.0422025,0.671376,0.739915,-11.0705,13.8342,-16.3146> }}
union{cone{<-10.9214,16.2059,-18.4751> ,0.09504,<-12.0796,18.7156,-20.5098> ,0.0864}
sphere{<-10.9214,16.2059,-18.4751> ,0.09504}
texture{txttree matrix <0.907979,0.419015,0,-0.337442,0.731216,-0.592837,-0.248408,0.538284,0.805323,-10.9214,16.2059,-18.4751> }}
union{cone{<-12.0796,18.7156,-20.5098> ,0.0864,<-13.0352,20.5576,-23.0626> ,0.07776}
sphere{<-12.0796,18.7156,-20.5098> ,0.0864}
texture{txttree matrix <0.887665,0.460489,0,-0.290461,0.55991,-0.775972,-0.357327,0.688804,0.630767,-12.0796,18.7156,-20.5098> }}
union{cone{<-7.39519,5.60326,-7.93781> ,0.1296,<-8.70646,5.17112,-10.9772> ,0.12096}
sphere{<-7.39519,5.60326,-7.93781> ,0.1296}
texture{txttree matrix <-0.312999,0.949754,0,-0.392797,-0.129449,-0.910469,-0.864721,-0.284975,0.413578,-7.39519,5.60326,-7.93781> }}
union{cone{<-8.70646,5.17112,-10.9772> ,0.12096,<-10.5273,6.45503,-13.2138> ,0.11232}
sphere{<-8.70646,5.17112,-10.9772> ,0.12096}
texture{txttree matrix <0.576277,0.817255,0,-0.576762,0.406696,-0.70848,-0.579009,0.408281,0.705731,-8.70646,5.17112,-10.9772> }}
union{cone{<-10.5273,6.45503,-13.2138> ,0.11232,<-11.3622,8.18528,-15.6692> ,0.10368}
sphere{<-10.5273,6.45503,-13.2138> ,0.11232}
texture{txttree matrix <0.900622,0.434603,0,-0.267811,0.554982,-0.787574,-0.342282,0.709306,0.61622,-10.5273,6.45503,-13.2138> }}
union{cone{<-11.3622,8.18528,-15.6692> ,0.10368,<-13.1098,9.03402,-18.3047> ,0.09504}
sphere{<-11.3622,8.18528,-15.6692> ,0.10368}
texture{txttree matrix <0.436858,0.89953,0,-0.533769,0.259225,-0.804918,-0.724048,0.351635,0.593386,-11.3622,8.18528,-15.6692> }}
union{cone{<-13.1098,9.03402,-18.3047> ,0.09504,<-14.0424,10.2996,-21.358> ,0.0864}
sphere{<-13.1098,9.03402,-18.3047> ,0.09504}
texture{txttree matrix <0.805062,0.59319,0,-0.271531,0.368514,-0.889083,-0.527395,0.715767,0.457747,-13.1098,9.03402,-18.3047> }}
union{cone{<-14.0424,10.2996,-21.358> ,0.0864,<-14.9141,11.0448,-24.2739> ,0.07776}
sphere{<-14.0424,10.2996,-21.358> ,0.0864}
texture{txttree matrix <0.649779,0.760123,0,-0.278225,0.237836,-0.930605,-0.707375,0.604687,0.366026,-14.0424,10.2996,-21.358> }}
union{cone{<-10.0825,9.18265,-11.2534> ,0.1296,<-11.9792,9.76392,-14.0573> ,0.12096}
sphere{<-10.0825,9.18265,-11.2534> ,0.1296}
texture{txttree matrix <0.293013,0.956108,0,-0.55222,0.169236,-0.816341,-0.78051,0.239199,0.57757,-10.0825,9.18265,-11.2534> }}
union{cone{<-11.9792,9.76392,-14.0573> ,0.12096,<-14.6874,10.9413,-15.5305> ,0.11232}
sphere{<-11.9792,9.76392,-14.0573> ,0.12096}
texture{txttree matrix <0.398712,0.917076,0,-0.82062,0.356776,-0.446422,-0.409403,0.177994,0.894822,-11.9792,9.76392,-14.0573> }}
union{cone{<-14.6874,10.9413,-15.5305> ,0.11232,<-17.2931,12.3288,-16.9139> ,0.10368}
sphere{<-14.6874,10.9413,-15.5305> ,0.11232}
texture{txttree matrix <0.47,0.882666,0,-0.799258,0.425587,-0.424338,-0.374549,0.199439,0.905504,-14.6874,10.9413,-15.5305> }}
union{cone{<-17.2931,12.3288,-16.9139> ,0.10368,<-19.8941,13.7494,-18.3941> ,0.09504}
sphere{<-17.2931,12.3288,-16.9139> ,0.10368}
texture{txttree matrix <0.479343,0.877628,0,-0.78515,0.428834,-0.446812,-0.392134,0.214176,0.894628,-17.2931,12.3288,-16.9139> }}
union{cone{<-19.8941,13.7494,-18.3941> ,0.09504,<-21.669,15.1785,-20.8022> ,0.0864}
sphere{<-19.8941,13.7494,-18.3941> ,0.09504}
texture{txttree matrix <0.627124,0.778919,0,-0.535376,0.431042,-0.726343,-0.565763,0.455507,0.687332,-19.8941,13.7494,-18.3941> }}
union{cone{<-21.669,15.1785,-20.8022> ,0.0864,<-23.8764,16.3508,-23.0474> ,0.07776}
sphere{<-21.669,15.1785,-20.8022> ,0.0864}
texture{txttree matrix <0.469032,0.883181,0,-0.657018,0.348923,-0.668267,-0.590201,0.313439,0.743922,-21.669,15.1785,-20.8022> }}
union{cone{<1.32088,1.4246,-2.4404> ,0.36,<0.858586,2.17437,-2.67888> ,0.342}
sphere{<1.32088,1.4246,-2.4404> ,0.36}
texture{txttree matrix <0.851202,0.524838,0,-0.506599,0.821622,-0.261331,-0.137157,0.222446,0.965249,1.32088,1.4246,-2.4404> }}
union{cone{<0.858586,2.17437,-2.67888> ,0.342,<0.667114,2.97254,-3.1455> ,0.324}
sphere{<0.858586,2.17437,-2.67888> ,0.342}
texture{txttree matrix <0.972412,0.233271,0,-0.202792,0.845359,-0.49421,-0.115285,0.480576,0.869342,0.858586,2.17437,-2.67888> }}
union{cone{<0.667114,2.97254,-3.1455> ,0.324,<0.655677,3.91404,-3.36379> ,0.306}
sphere{<0.667114,2.97254,-3.1455> ,0.324}
texture{txttree matrix <0.999926,0.0121467,0,-0.0118328,0.97409,-0.22585,-0.00274332,0.225833,0.974162,0.667114,2.97254,-3.1455> }}
union{cone{<0.655677,3.91404,-3.36379> ,0.306,<0.246056,4.56027,-3.91746> ,0.288}
sphere{<0.655677,3.91404,-3.36379> ,0.306}
texture{txttree matrix <0.844619,0.535368,0,-0.433721,0.684256,-0.586241,-0.313855,0.49515,0.810137,0.655677,3.91404,-3.36379> }}
union{cone{<0.246056,4.56027,-3.91746> ,0.288,<-0.224474,5.36118,-4.23281> ,0.27}
sphere{<0.246056,4.56027,-3.91746> ,0.288}
texture{txttree matrix <0.862214,0.506545,0,-0.479658,0.816449,-0.321463,-0.162835,0.27717,0.946922,0.246056,4.56027,-3.91746> }}
union{cone{<-0.224474,5.36118,-4.23281> ,0.27,<-0.253441,6.19007,-4.77795> ,0.252}
sphere{<-0.224474,5.36118,-4.23281> ,0.27}
texture{txttree matrix <0.99939,0.0349249,0,-0.029185,0.835141,-0.549262,-0.0191829,0.548927,0.83565,-0.224474,5.36118,-4.23281> }}
union{cone{<-0.253441,6.19007,-4.77795> ,0.252,<-0.563201,7.09479,-5.08411> ,0.234}
sphere{<-0.253441,6.19007,-4.77795> ,0.252}
texture{txttree matrix <0.946084,0.323921,0,-0.308497,0.901033,-0.304909,-0.0987666,0.28847,0.952381,-0.253441,6.19007,-4.77795> }}
union{cone{<-0.563201,7.09479,-5.08411> ,0.234,<-0.648661,7.7899,-5.68212> ,0.216}
sphere{<-0.563201,7.09479,-5.08411> ,0.234}
texture{txttree matrix <0.992527,0.122025,0,-0.092798,0.7548,-0.649358,-0.0792381,0.644506,0.760483,-0.563201,7.09479,-5.08411> }}
union{cone{<-0.648661,7.7899,-5.68212> ,0.216,<-0.434288,9.4949,-5.65679> ,0.203657}
sphere{<-0.648661,7.7899,-5.68212> ,0.216}
texture{txttree matrix <0.992188,-0.12475,0,0.124736,0.99208,0.0147392,-0.00183871,-0.0146241,0.999891,-0.648661,7.7899,-5.68212> }}
union{cone{<-0.434288,9.4949,-5.65679> ,0.203657,<-1.12941,10.9942,-6.3702> ,0.191314}
sphere{<-0.434288,9.4949,-5.65679> ,0.203657}
texture{txttree matrix <0.90723,0.420634,0,-0.386184,0.832929,-0.396348,-0.166717,0.359579,0.9181,-0.434288,9.4949,-5.65679> }}
union{cone{<-1.12941,10.9942,-6.3702> ,0.191314,<-1.07863,12.5346,-7.20353> ,0.178971}
sphere{<-1.12941,10.9942,-6.3702> ,0.191314}
texture{txttree matrix <0.999457,-0.0329437,0,0.0289791,0.879178,-0.475612,0.0156685,0.475354,0.879655,-1.12941,10.9942,-6.3702> }}
union{cone{<-1.07863,12.5346,-7.20353> ,0.178971,<-1.01757,14.245,-7.30152> ,0.166629}
sphere{<-1.07863,12.5346,-7.20353> ,0.178971}
texture{txttree matrix <0.999363,-0.0356771,0,0.0356187,0.997729,-0.0571597,0.00203929,0.0571233,0.998365,-1.07863,12.5346,-7.20353> }}
union{cone{<-1.01757,14.245,-7.30152> ,0.166629,<-0.720295,15.8724,-7.77607> ,0.154286}
sphere{<-1.01757,14.245,-7.30152> ,0.166629}
texture{txttree matrix <0.983722,-0.179696,0,0.17273,0.945587,-0.275735,0.0495485,0.271247,0.961234,-1.01757,14.245,-7.30152> }}
union{cone{<-0.720295,15.8724,-7.77607> ,0.154286,<-1.05567,17.5596,-8.26689> ,0.141943}
sphere{<-0.720295,15.8724,-7.77607> ,0.154286}
texture{txttree matrix <0.980811,0.194963,0,-0.18748,0.943169,-0.274379,-0.0534937,0.269114,0.961622,-0.720295,15.8724,-7.77607> }}
union{cone{<-1.05567,17.5596,-8.26689> ,0.141943,<-1.13869,19.0413,-9.07189> ,0.1296}
sphere{<-1.05567,17.5596,-8.26689> ,0.141943}
texture{txttree matrix <0.998434,0.0559432,0,-0.0491743,0.877627,-0.476815,-0.0266746,0.476069,0.879003,-1.05567,17.5596,-8.26689> }}
union{cone{<-1.13869,19.0413,-9.07189> ,0.1296,<-1.93616,22.3862,-9.16405> ,0.12096}
sphere{<-1.13869,19.0413,-9.07189> ,0.1296}
texture{txttree matrix <0.972736,0.231915,0,-0.231831,0.972387,-0.0267912,-0.00621328,0.0260608,0.999641,-1.13869,19.0413,-9.07189> }}
union{cone{<-1.93616,22.3862,-9.16405> ,0.12096,<-2.76549,25.0678,-10.6367> ,0.11232}
sphere{<-1.93616,22.3862,-9.16405> ,0.12096}
texture{txttree matrix <0.955356,0.295458,0,-0.261634,0.845989,-0.464597,-0.137269,0.443856,0.885522,-1.93616,22.3862,-9.16405> }}
union{cone{<-2.76549,25.0678,-10.6367> ,0.11232,<-3.52629,27.8143,-12.1418> ,0.10368}
sphere{<-2.76549,25.0678,-10.6367> ,0.11232}
texture{txttree matrix <0.963709,0.266956,0,-0.23606,0.852173,-0.466987,-0.124665,0.450039,0.884264,-2.76549,25.0678,-10.6367> }}
union{cone{<-3.52629,27.8143,-12.1418> ,0.10368,<-2.92817,30.5401,-13.7688> ,0.09504}
sphere{<-3.52629,27.8143,-12.1418> ,0.10368}
texture{txttree matrix <0.976762,-0.214328,0,0.185156,0.843817,-0.503676,0.107952,0.491972,0.863892,-3.52629,27.8143,-12.1418> }}
union{cone{<-2.92817,30.5401,-13.7688> ,0.09504,<-2.42913,33.4669,-14.8372> ,0.0864}
sphere{<-2.92817,30.5401,-13.7688> ,0.09504}
texture{txttree matrix <0.985773,-0.168083,0,0.158155,0.927548,-0.338587,0.0569108,0.33377,0.940935,-2.92817,30.5401,-13.7688> }}
union{cone{<-2.42913,33.4669,-14.8372> ,0.0864,<-1.85513,36.5235,-16.0606> ,0.07776}
sphere{<-2.42913,33.4669,-14.8372> ,0.0864}
texture{txttree matrix <0.982821,-0.184561,0,0.17175,0.9146,-0.366071,0.0675625,0.359782,0.930587,-2.42913,33.4669,-14.8372> }}
union{cone{<-0.872483,15.0393,-7.53313> ,0.1296,<0.184803,18.3045,-7.42174> ,0.12096}
sphere{<-0.872483,15.0393,-7.53313> ,0.1296}
texture{txttree matrix <0.951367,-0.30806,0,0.307898,0.950866,0.0324396,-0.00999336,-0.030862,0.999474,-0.872483,15.0393,-7.53313> }}
union{cone{<0.184803,18.3045,-7.42174> ,0.12096,<1.23719,21.2646,-7.34543> ,0.11232}
sphere{<0.184803,18.3045,-7.42174> ,0.12096}
texture{txttree matrix <0.942227,-0.334976,0,0.334877,0.941949,0.0242815,-0.00813374,-0.0228787,0.999705,0.184803,18.3045,-7.42174> }}
union{cone{<1.23719,21.2646,-7.34543> ,0.11232,<2.52372,23.5778,-9.00281> ,0.10368}
sphere{<1.23719,21.2646,-7.34543> ,0.11232}
texture{txttree matrix <0.873929,-0.486053,0,0.411957,0.740704,-0.530706,0.257951,0.4638,0.847556,1.23719,21.2646,-7.34543> }}
union{cone{<2.52372,23.5778,-9.00281> ,0.10368,<4.44311,26.1755,-9.83664> ,0.09504}
sphere{<2.52372,23.5778,-9.00281> ,0.10368}
texture{txttree matrix <0.804269,-0.594265,0,0.5754,0.778737,-0.249967,0.148547,0.201041,0.968254,2.52372,23.5778,-9.00281> }}
union{cone{<4.44311,26.1755,-9.83664> ,0.09504,<4.70288,28.8352,-11.5084> ,0.0864}
sphere{<4.44311,26.1755,-9.83664> ,0.09504}
texture{txttree matrix <0.995264,-0.0972063,0,0.0824091,0.843761,-0.530355,0.0515539,0.527844,0.847775,4.44311,26.1755,-9.83664> }}
union{cone{<4.70288,28.8352,-11.5084> ,0.0864,<5.18224,31.3373,-13.4056> ,0.07776}
sphere{<4.70288,28.8352,-11.5084> ,0.0864}
texture{txttree matrix <0.982138,-0.188161,0,0.150913,0.787715,-0.597269,0.112383,0.586601,0.802041,4.70288,28.8352,-11.5084> }}
union{cone{<-1.0355,13.7427,-7.27274> ,0.1296,<0.37387,16.4961,-8.17673> ,0.12096}
sphere{<-1.0355,13.7427,-7.27274> ,0.1296}
texture{txttree matrix <0.890161,-0.455647,0,0.437352,0.854419,-0.280522,0.127819,0.24971,0.959848,-1.0355,13.7427,-7.27274> }}
union{cone{<0.37387,16.4961,-8.17673> ,0.12096,<1.07172,19.7514,-8.92635> ,0.11232}
sphere{<0.37387,16.4961,-8.17673> ,0.12096}
texture{txttree matrix <0.977785,-0.209612,0,0.204493,0.953903,-0.219663,0.0460441,0.214783,0.975576,0.37387,16.4961,-8.17673> }}
union{cone{<1.07172,19.7514,-8.92635> ,0.11232,<1.44653,22.7786,-9.59299> ,0.10368}
sphere{<1.07172,19.7514,-8.92635> ,0.11232}
texture{txttree matrix <0.992422,-0.122878,0,0.120044,0.969537,-0.213511,0.0262358,0.211893,0.976941,1.07172,19.7514,-8.92635> }}
union{cone{<1.44653,22.7786,-9.59299> ,0.10368,<1.89887,25.829,-10.3416> ,0.09504}
sphere{<1.44653,22.7786,-9.59299> ,0.10368}
texture{txttree matrix <0.989183,-0.146685,0,0.142545,0.961261,-0.235918,0.0346057,0.233366,0.971773,1.44653,22.7786,-9.59299> }}
union{cone{<1.89887,25.829,-10.3416> ,0.09504,<2.06352,28.9554,-11.4314> ,0.0864}
sphere{<1.89887,25.829,-10.3416> ,0.09504}
texture{txttree matrix <0.998616,-0.052591,0,0.0496683,0.943119,-0.328725,0.017288,0.32827,0.944426,1.89887,25.829,-10.3416> }}
union{cone{<2.06352,28.9554,-11.4314> ,0.0864,<2.65382,31.8454,-12.7336> ,0.07776}
sphere{<2.06352,28.9554,-11.4314> ,0.0864}
texture{txttree matrix <0.979771,-0.200123,0,0.183076,0.896313,-0.403865,0.0808228,0.395695,0.914819,2.06352,28.9554,-11.4314> }}
union{cone{<-0.941214,14.663,-7.42341> ,0.1296,<-2.18168,17.5997,-8.55549> ,0.12096}
sphere{<-0.941214,14.663,-7.42341> ,0.1296}
texture{txttree matrix <0.921188,0.389119,0,-0.366684,0.868076,-0.334646,-0.130217,0.308271,0.942344,-0.941214,14.663,-7.42341> }}
union{cone{<-2.18168,17.5997,-8.55549> ,0.12096,<-1.77345,20.2491,-10.2093> ,0.11232}
sphere{<-2.18168,17.5997,-8.55549> ,0.12096}
texture{txttree matrix <0.988337,-0.152285,0,0.129606,0.841149,-0.525043,0.0799562,0.51892,0.851075,-2.18168,17.5997,-8.55549> }}
union{cone{<-1.77345,20.2491,-10.2093> ,0.11232,<-1.24456,23.3098,-11.3572> ,0.10368}
sphere{<-1.77345,20.2491,-10.2093> ,0.11232}
texture{txttree matrix <0.985396,-0.170276,0,0.159718,0.924295,-0.346654,0.0590267,0.341591,0.937993,-1.77345,20.2491,-10.2093> }}
union{cone{<-1.24456,23.3098,-11.3572> ,0.10368,<-0.688285,25.6964,-13.3083> ,0.09504}
sphere{<-1.24456,23.3098,-11.3572> ,0.10368}
texture{txttree matrix <0.973895,-0.227,0,0.177584,0.761886,-0.622891,0.141397,0.60663,0.782308,-1.24456,23.3098,-11.3572> }}
union{cone{<-0.688285,25.6964,-13.3083> ,0.09504,<-0.916088,28.0178,-15.5333> ,0.0864}
sphere{<-0.688285,25.6964,-13.3083> ,0.09504}
texture{txttree matrix <0.99522,0.0976606,0,-0.0706683,0.720152,-0.690208,-0.0674062,0.686909,0.723611,-0.688285,25.6964,-13.3083> }}
union{cone{<-0.916088,28.0178,-15.5333> ,0.0864,<-1.02016,30.5739,-17.7259> ,0.07776}
sphere{<-0.916088,28.0178,-15.5333> ,0.0864}
texture{txttree matrix <0.999172,0.0406804,0,-0.0308875,0.758643,-0.650774,-0.0264738,0.650235,0.759271,-0.916088,28.0178,-15.5333> }}
union{cone{<1.25489,1.53163,-2.47444> ,0.216,<1.47337,3.17425,-2.86924> ,0.203657}
sphere{<1.25489,1.53163,-2.47444> ,0.216}
texture{txttree matrix <0.99127,-0.131848,0,0.128258,0.96428,-0.231761,0.0305572,0.229737,0.972773,1.25489,1.53163,-2.47444> }}
union{cone{<1.47337,3.17425,-2.86924> ,0.203657,<1.19178,4.83631,-3.35226> ,0.191314}
sphere{<1.47337,3.17425,-2.86924> ,0.203657}
texture{txttree matrix <0.98595,0.16704,0,-0.160578,0.947809,-0.275449,-0.0460111,0.271579,0.961316,1.47337,3.17425,-2.86924> }}
union{cone{<1.19178,4.83631,-3.35226> ,0.191314,<1.74153,6.51111,-3.62759> ,0.178971}
sphere{<1.19178,4.83631,-3.35226> ,0.191314}
texture{txttree matrix <0.950123,-0.311874,0,0.308138,0.938741,-0.154323,0.0481294,0.146626,0.98802,1.19178,4.83631,-3.35226> }}
union{cone{<1.74153,6.51111,-3.62759> ,0.178971,<2.10503,8.12496,-3.96928> ,0.166629}
sphere{<1.74153,6.51111,-3.62759> ,0.178971}
texture{txttree matrix <0.97556,-0.219732,0,0.21519,0.955393,-0.20228,0.0444474,0.197336,0.979328,1.74153,6.51111,-3.62759> }}
union{cone{<2.10503,8.12496,-3.96928> ,0.166629,<2.42477,9.77117,-4.29845> ,0.154286}
sphere{<2.10503,8.12496,-3.96928> ,0.166629}
texture{txttree matrix <0.981655,-0.190668,0,0.187097,0.963273,-0.192613,0.0367251,0.18908,0.981275,2.10503,8.12496,-3.96928> }}
union{cone{<2.42477,9.77117,-4.29845> ,0.154286,<2.4382,11.4322,-4.60393> ,0.141943}
sphere{<2.42477,9.77117,-4.29845> ,0.154286}
texture{txttree matrix <0.999967,-0.0080817,0,0.0079484,0.983474,-0.180875,0.00146177,0.180869,0.983506,2.42477,9.77117,-4.29845> }}
union{cone{<2.4382,11.4322,-4.60393> ,0.141943,<2.41186,13.0055,-5.19396> ,0.1296}
sphere{<2.4382,11.4322,-4.60393> ,0.141943}
texture{txttree matrix <0.99986,0.0167363,0,-0.0156709,0.93621,-0.351092,-0.00587599,0.351043,0.936341,2.4382,11.4322,-4.60393> }}
union{cone{<2.41186,13.0055,-5.19396> ,0.1296,<3.26454,15.9301,-4.17347> ,0.12096}
sphere{<2.41186,13.0055,-5.19396> ,0.1296}
texture{txttree matrix <0.960029,-0.2799,0,0.265405,0.910311,0.317638,-0.0889068,-0.304941,0.948212,2.41186,13.0055,-5.19396> }}
union{cone{<3.26454,15.9301,-4.17347> ,0.12096,<2.24547,19.0703,-3.96692> ,0.11232}
sphere{<3.26454,15.9301,-4.17347> ,0.12096}
texture{txttree matrix <0.951165,0.308682,0,-0.30808,0.949309,0.062442,0.0192747,-0.0593926,0.998049,3.26454,15.9301,-4.17347> }}
union{cone{<2.24547,19.0703,-3.96692> ,0.11232,<3.13239,22.1053,-3.95749> ,0.10368}
sphere{<2.24547,19.0703,-3.96692> ,0.11232}
texture{txttree matrix <0.959854,-0.280499,0,0.280498,0.95985,0.00298278,-0.000836666,-0.00286303,0.999996,2.24547,19.0703,-3.96692> }}
union{cone{<3.13239,22.1053,-3.95749> ,0.10368,<3.26266,25.1383,-5.03856> ,0.09504}
sphere{<3.13239,22.1053,-3.95749> ,0.10368}
texture{txttree matrix <0.999079,-0.0429112,0,0.0404246,0.941183,-0.33547,0.0143954,0.335161,0.942051,3.13239,22.1053,-3.95749> }}
union{cone{<3.26266,25.1383,-5.03856> ,0.09504,<2.63555,28.0055,-6.38908> ,0.0864}
sphere{<3.26266,25.1383,-5.03856> ,0.09504}
texture{txttree matrix <0.976907,0.213665,0,-0.194102,0.887462,-0.418013,-0.0893147,0.40836,0.908441,3.26266,25.1383,-5.03856> }}
union{cone{<2.63555,28.0055,-6.38908> ,0.0864,<2.2683,30.8361,-7.6403> ,0.07776}
sphere{<2.63555,28.0055,-6.38908> ,0.0864}
texture{txttree matrix <0.991688,0.128666,0,-0.117841,0.908253,-0.401485,-0.0516573,0.398148,0.915866,2.63555,28.0055,-6.38908> }}
union{cone{<1.38388,2.50146,-2.70754> ,0.1296,<4.17201,4.45375,-2.85688> ,0.12096}
sphere{<1.38388,2.50146,-2.70754> ,0.1296}
texture{txttree matrix <0.573581,-0.819149,0,0.818361,0.57303,-0.0438345,0.035907,0.0251426,0.999039,1.38388,2.50146,-2.70754> }}
union{cone{<4.17201,4.45375,-2.85688> ,0.12096,<6.34341,6.96574,-3.07055> ,0.11232}
sphere{<4.17201,4.45375,-2.85688> ,0.12096}
texture{txttree matrix <0.756531,-0.653958,0,0.652608,0.754969,-0.0642176,0.0419956,0.0485826,0.997936,4.17201,4.45375,-2.85688> }}
union{cone{<6.34341,6.96574,-3.07055> ,0.11232,<8.18297,9.22996,-4.72474> ,0.10368}
sphere{<6.34341,6.96574,-3.07055> ,0.11232}
texture{txttree matrix <0.776135,-0.630567,0,0.548522,0.675151,-0.493249,0.311026,0.382828,0.869888,6.34341,6.96574,-3.07055> }}
union{cone{<8.18297,9.22996,-4.72474> ,0.10368,<8.69602,11.9841,-6.3173> ,0.09504}
sphere{<8.18297,9.22996,-4.72474> ,0.10368}
texture{txttree matrix <0.983088,-0.183131,0,0.159205,0.85465,-0.494194,0.0905023,0.485836,0.869352,8.18297,9.22996,-4.72474> }}
union{cone{<8.69602,11.9841,-6.3173> ,0.09504,<10.5492,14.7369,-7.05243> ,0.0864}
sphere{<8.69602,11.9841,-6.3173> ,0.09504}
texture{txttree matrix <0.829544,-0.558442,0,0.545224,0.809909,-0.216282,0.120781,0.179415,0.976331,8.69602,11.9841,-6.3173> }}
union{cone{<10.5492,14.7369,-7.05243> ,0.0864,<11.8185,16.9852,-8.83371> ,0.07776}
sphere{<10.5492,14.7369,-7.05243> ,0.0864}
texture{txttree matrix <0.87081,-0.49162,0,0.404656,0.71677,-0.567886,0.279184,0.494521,0.823107,10.5492,14.7369,-7.05243> }}
union{cone{<1.31847,4.08855,-3.13495> ,0.1296,<0.64809,6.3624,-5.34152> ,0.12096}
sphere{<1.31847,4.08855,-3.13495> ,0.1296}
texture{txttree matrix <0.959183,0.282787,0,-0.206995,0.702102,-0.681327,-0.192671,0.653517,0.73198,1.31847,4.08855,-3.13495> }}
union{cone{<0.64809,6.3624,-5.34152> ,0.12096,<0.53814,9.5592,-6.35108> ,0.11232}
sphere{<0.64809,6.3624,-5.34152> ,0.12096}
texture{txttree matrix <0.999409,0.0343734,0,-0.0327795,0.953067,-0.300981,-0.0103457,0.300803,0.95363,0.64809,6.3624,-5.34152> }}
union{cone{<0.53814,9.5592,-6.35108> ,0.11232,<1.34903,12.3915,-7.88277> ,0.10368}
sphere{<0.53814,9.5592,-6.35108> ,0.11232}
texture{txttree matrix <0.961376,-0.27524,0,0.244207,0.852983,-0.461284,0.126964,0.443467,0.887253,0.53814,9.5592,-6.35108> }}
union{cone{<1.34903,12.3915,-7.88277> ,0.10368,<1.36446,14.6267,-10.2977> ,0.09504}
sphere{<1.34903,12.3915,-7.88277> ,0.10368}
texture{txttree matrix <0.999976,-0.00690209,0,0.00468838,0.679253,-0.733889,0.00506537,0.733872,0.679269,1.34903,12.3915,-7.88277> }}
union{cone{<1.36446,14.6267,-10.2977> ,0.09504,<1.87899,17.1394,-12.4524> ,0.0864}
sphere{<1.36446,14.6267,-10.2977> ,0.09504}
texture{txttree matrix <0.979672,-0.200607,0,0.153601,0.750115,-0.643222,0.129035,0.630147,0.765679,1.36446,14.6267,-10.2977> }}
union{cone{<1.87899,17.1394,-12.4524> ,0.0864,<2.27667,19.3392,-14.877> ,0.07776}
sphere{<1.87899,17.1394,-12.4524> ,0.0864}
texture{txttree matrix <0.984049,-0.177896,0,0.120586,0.667031,-0.735207,0.130791,0.72348,0.677843,1.87899,17.1394,-12.4524> }}
union{cone{<2.19536,8.59005,-4.06228> ,0.1296,<3.57479,11.5001,-5.23281> ,0.12096}
sphere{<2.19536,8.59005,-4.06228> ,0.1296}
texture{txttree matrix <0.903622,-0.428331,0,0.402565,0.849265,-0.341601,0.146318,0.308679,0.939845,2.19536,8.59005,-4.06228> }}
union{cone{<3.57479,11.5001,-5.23281> ,0.12096,<4.34763,14.6132,-6.10121> ,0.11232}
sphere{<3.57479,11.5001,-5.23281> ,0.12096}
texture{txttree matrix <0.970538,-0.240946,0,0.232573,0.936812,-0.261331,0.0629667,0.253631,0.965249,3.57479,11.5001,-5.23281> }}
union{cone{<4.34763,14.6132,-6.10121> ,0.11232,<5.23241,17.2363,-7.84305> ,0.10368}
sphere{<4.34763,14.6132,-6.10121> ,0.11232}
texture{txttree matrix <0.947549,-0.31961,0,0.270516,0.802,-0.532558,0.170211,0.504625,0.846394,4.34763,14.6132,-6.10121> }}
union{cone{<5.23241,17.2363,-7.84305> ,0.10368,<4.53691,19.9853,-9.38556> ,0.09504}
sphere{<5.23241,17.2363,-7.84305> ,0.10368}
texture{txttree matrix <0.969455,0.245269,0,-0.215456,0.851613,-0.477843,-0.1172,0.463247,0.878445,5.23241,17.2363,-7.84305> }}
union{cone{<4.53691,19.9853,-9.38556> ,0.09504,<4.30537,22.8998,-10.6715> ,0.0864}
sphere{<4.53691,19.9853,-9.38556> ,0.09504}
texture{txttree matrix <0.996859,0.0791931,0,-0.0724913,0.912499,-0.402606,-0.0318836,0.401341,0.915373,4.53691,19.9853,-9.38556> }}
union{cone{<4.30537,22.8998,-10.6715> ,0.0864,<4.58641,25.4303,-12.5964> ,0.07776}
sphere{<4.30537,22.8998,-10.6715> ,0.0864}
texture{txttree matrix <0.993889,-0.11038,0,0.0880482,0.792811,-0.603074,0.066567,0.599389,0.797686,4.30537,22.8998,-10.6715> }}
union{cone{<1.42463,3.46192,-2.95284> ,0.1296,<-0.267451,5.74612,-4.66311> ,0.12096}
sphere{<1.42463,3.46192,-2.95284> ,0.1296}
texture{txttree matrix <0.803543,0.595246,0,-0.510049,0.688533,-0.515531,-0.306868,0.414251,0.856871,1.42463,3.46192,-2.95284> }}
union{cone{<-0.267451,5.74612,-4.66311> ,0.12096,<-0.684067,8.76184,-5.76426> ,0.11232}
sphere{<-0.267451,5.74612,-4.66311> ,0.12096}
texture{txttree matrix <0.990592,0.136848,0,-0.128689,0.931529,-0.340136,-0.0465471,0.336936,0.940376,-0.267451,5.74612,-4.66311> }}
union{cone{<-0.684067,8.76184,-5.76426> ,0.11232,<-2.87559,11.219,-6.2257> ,0.10368}
sphere{<-0.684067,8.76184,-5.76426> ,0.11232}
texture{txttree matrix <0.7463,0.665609,0,-0.659167,0.739077,-0.138792,-0.0923814,0.103581,0.990322,-0.684067,8.76184,-5.76426> }}
union{cone{<-2.87559,11.219,-6.2257> ,0.10368,<-3.80573,14.0417,-7.47523> ,0.09504}
sphere{<-2.87559,11.219,-6.2257> ,0.10368}
texture{txttree matrix <0.949765,0.312965,0,-0.288503,0.87553,-0.387573,-0.121297,0.368103,0.921839,-2.87559,11.219,-6.2257> }}
union{cone{<-3.80573,14.0417,-7.47523> ,0.09504,<-4.45483,16.9376,-8.92237> ,0.0864}
sphere{<-3.80573,14.0417,-7.47523> ,0.09504}
texture{txttree matrix <0.975788,0.218718,0,-0.196591,0.877071,-0.43829,-0.0958617,0.427678,0.898834,-3.80573,14.0417,-7.47523> }}
union{cone{<-4.45483,16.9376,-8.92237> ,0.0864,<-5.23768,19.2684,-10.9244> ,0.07776}
sphere{<-4.45483,16.9376,-8.92237> ,0.0864}
texture{txttree matrix <0.947957,0.318398,0,-0.246902,0.735095,-0.631407,-0.201038,0.598546,0.775452,-4.45483,16.9376,-8.92237> }}
union{cone{<-0.621882,7.57209,-5.49474> ,0.216,<-0.535081,8.77578,-6.795> ,0.203657}
sphere{<-0.621882,7.57209,-5.49474> ,0.216}
texture{txttree matrix <0.99741,-0.0719262,0,0.0489297,0.678515,-0.732956,0.0527187,0.731057,0.680277,-0.621882,7.57209,-5.49474> }}
union{cone{<-0.535081,8.77578,-6.795> ,0.203657,<0.120224,9.83276,-7.99673> ,0.191314}
sphere{<-0.535081,8.77578,-6.795> ,0.203657}
texture{txttree matrix <0.849911,-0.526926,0,0.378923,0.611187,-0.694887,0.366154,0.590592,0.719119,-0.535081,8.77578,-6.795> }}
union{cone{<0.120224,9.83276,-7.99673> ,0.191314,<0.866887,10.7176,-9.39438> ,0.178971}
sphere{<0.120224,9.83276,-7.99673> ,0.191314}
texture{txttree matrix <0.764247,-0.644924,0,0.411408,0.487527,-0.770104,0.496659,0.58855,0.637918,0.120224,9.83276,-7.99673> }}
union{cone{<0.866887,10.7176,-9.39438> ,0.178971,<1.20084,11.9311,-10.5458> ,0.166629}
sphere{<0.866887,10.7176,-9.39438> ,0.178971}
texture{txttree matrix <0.964161,-0.265316,0,0.195761,0.711397,-0.674975,0.179082,0.650785,0.737841,0.866887,10.7176,-9.39438> }}
union{cone{<1.20084,11.9311,-10.5458> ,0.166629,<1.06264,12.9325,-11.897> ,0.154286}
sphere{<1.20084,11.9311,-10.5458> ,0.166629}
texture{txttree matrix <0.990611,0.136713,0,-0.0818972,0.593419,-0.800716,-0.109469,0.793198,0.599044,1.20084,11.9311,-10.5458> }}
union{cone{<1.06264,12.9325,-11.897> ,0.154286,<1.63819,13.919,-13.1554> ,0.141943}
sphere{<1.06264,12.9325,-11.897> ,0.154286}
texture{txttree matrix <0.863754,-0.503913,0,0.338668,0.580508,-0.740483,0.373139,0.639595,0.672075,1.06264,12.9325,-11.897> }}
union{cone{<1.63819,13.919,-13.1554> ,0.141943,<1.71709,14.906,-14.65> ,0.1296}
sphere{<1.63819,13.919,-13.1554> ,0.141943}
texture{txttree matrix <0.99682,-0.0796889,0,0.0440103,0.55052,-0.833661,0.0664336,0.83101,0.552276,1.63819,13.919,-13.1554> }}
union{cone{<1.71709,14.906,-14.65> ,0.1296,<1.10558,18.1197,-15.4914> ,0.12096}
sphere{<1.71709,14.906,-14.65> ,0.1296}
texture{txttree matrix <0.982374,0.186925,0,-0.181032,0.951406,-0.249105,-0.0465638,0.244714,0.968477,1.71709,14.906,-14.65> }}
union{cone{<1.10558,18.1197,-15.4914> ,0.12096,<1.55777,21.2474,-16.4455> ,0.11232}
sphere{<1.10558,18.1197,-15.4914> ,0.12096}
texture{txttree matrix <0.98971,-0.143087,0,0.136981,0.947473,-0.289018,0.0413547,0.286044,0.957324,1.10558,18.1197,-15.4914> }}
union{cone{<1.55777,21.2474,-16.4455> ,0.11232,<0.743357,23.7358,-18.4944> ,0.10368}
sphere{<1.55777,21.2474,-16.4455> ,0.11232}
texture{txttree matrix <0.950394,0.311048,0,-0.244959,0.748463,-0.616277,-0.191692,0.585707,0.787529,1.55777,21.2474,-16.4455> }}
union{cone{<0.743357,23.7358,-18.4944> ,0.10368,<1.25919,25.9146,-20.9098> ,0.09504}
sphere{<0.743357,23.7358,-18.4944> ,0.10368}
texture{txttree matrix <0.973099,-0.230388,0,0.156623,0.661535,-0.733377,0.168961,0.713648,0.679823,0.743357,23.7358,-18.4944> }}
union{cone{<1.25919,25.9146,-20.9098> ,0.09504,<0.924208,28.2218,-23.3181> ,0.0864}
sphere{<1.25919,25.9146,-20.9098> ,0.09504}
texture{txttree matrix <0.989624,0.143684,0,-0.0999391,0.688332,-0.718478,-0.103234,0.711023,0.69555,1.25919,25.9146,-20.9098> }}
union{cone{<0.924208,28.2218,-23.3181> ,0.0864,<1.21289,31.191,-24.7288> ,0.07776}
sphere{<0.924208,28.2218,-23.3181> ,0.0864}
texture{txttree matrix <0.995307,-0.0967709,0,0.087482,0.899769,-0.427508,0.0413703,0.425501,0.904012,0.924208,28.2218,-23.3181> }}
union{cone{<1.108,12.6038,-11.4535> ,0.1296,<3.23036,14.5281,-13.1377> ,0.12096}
sphere{<1.108,12.6038,-11.4535> ,0.1296}
texture{txttree matrix <0.671704,-0.74082,0,0.638638,0.579055,-0.506791,0.375441,0.340413,0.862069,1.108,12.6038,-11.4535> }}
union{cone{<3.23036,14.5281,-13.1377> ,0.12096,<4.18428,17.2493,-14.859> ,0.11232}
sphere{<3.23036,14.5281,-13.1377> ,0.12096}
texture{txttree matrix <0.943694,-0.330819,0,0.284053,0.810288,-0.512588,0.169574,0.483726,0.858635,3.23036,14.5281,-13.1377> }}
union{cone{<4.18428,17.2493,-14.859> ,0.11232,<5.4632,18.9642,-17.5002> ,0.10368}
sphere{<4.18428,17.2493,-14.859> ,0.11232}
texture{txttree matrix <0.801631,-0.59782,0,0.376277,0.504559,-0.777069,0.464547,0.622922,0.629416,4.18428,17.2493,-14.859> }}
union{cone{<5.4632,18.9642,-17.5002> ,0.10368,<6.48039,21.4241,-19.5705> ,0.09504}
sphere{<5.4632,18.9642,-17.5002> ,0.10368}
texture{txttree matrix <0.924106,-0.382136,0,0.301643,0.729452,-0.613932,0.234605,0.567338,0.789359,5.4632,18.9642,-17.5002> }}
union{cone{<6.48039,21.4241,-19.5705> ,0.09504,<6.85153,23.7216,-22.0773> ,0.0864}
sphere{<6.48039,21.4241,-19.5705> ,0.09504}
texture{txttree matrix <0.987203,-0.159469,0,0.108502,0.671688,-0.732845,0.116866,0.723467,0.680395,6.48039,21.4241,-19.5705> }}
union{cone{<6.85153,23.7216,-22.0773> ,0.0864,<7.60373,26.3702,-23.8114> ,0.07776}
sphere{<6.85153,23.7216,-22.0773> ,0.0864}
texture{txttree matrix <0.961958,-0.273198,0,0.231167,0.813964,-0.53294,0.145598,0.512666,0.846153,6.85153,23.7216,-22.0773> }}
union{cone{<0.0870054,9.77918,-7.93581> ,0.1296,<0.760376,11.3591,-10.5653> ,0.12096}
sphere{<0.0870054,9.77918,-7.93581> ,0.1296}
texture{txttree matrix <0.919934,-0.392073,0,0.214401,0.503055,-0.837238,0.328259,0.770204,0.546838,0.0870054,9.77918,-7.93581> }}
union{cone{<0.760376,11.3591,-10.5653> ,0.12096,<1.896,13.3952,-12.9932> ,0.11232}
sphere{<0.760376,11.3591,-10.5653> ,0.12096}
texture{txttree matrix <0.87334,-0.48711,0,0.337382,0.604892,-0.721303,0.351354,0.629943,0.692619,0.760376,11.3591,-10.5653> }}
union{cone{<1.896,13.3952,-12.9932> ,0.11232,<2.61714,15.492,-15.5749> ,0.10368}
sphere{<1.896,13.3952,-12.9932> ,0.11232}
texture{txttree matrix <0.945638,-0.325222,0,0.2119,0.616136,-0.7586,0.246713,0.717361,0.651556,1.896,13.3952,-12.9932> }}
union{cone{<2.61714,15.492,-15.5749> ,0.10368,<3.15439,16.6577,-18.5827> ,0.09504}
sphere{<2.61714,15.492,-15.5749> ,0.10368}
texture{txttree matrix <0.908189,-0.418559,0,0.164283,0.356461,-0.919753,0.384971,0.83531,0.392497,2.61714,15.492,-15.5749> }}
union{cone{<3.15439,16.6577,-18.5827> ,0.09504,<3.88016,18.8534,-20.9066> ,0.0864}
sphere{<3.15439,16.6577,-18.5827> ,0.09504}
texture{txttree matrix <0.949471,-0.313854,0,0.221381,0.669723,-0.708845,0.222474,0.673028,0.705364,3.15439,16.6577,-18.5827> }}
union{cone{<3.88016,18.8534,-20.9066> ,0.0864,<5.29149,20.2147,-23.4468> ,0.07776}
sphere{<3.88016,18.8534,-20.9066> ,0.0864}
texture{txttree matrix <0.694252,-0.719732,0,0.439805,0.424235,-0.791579,0.569724,0.549555,0.611067,3.88016,18.8534,-20.9066> }}
union{cone{<1.16501,12.1907,-10.8961> ,0.1296,<1.33173,13.5579,-13.9915> ,0.12096}
sphere{<1.16501,12.1907,-10.8961> ,0.1296}
texture{txttree matrix <0.992647,-0.121049,0,0.0492093,0.403536,-0.91364,0.110595,0.906921,0.406525,1.16501,12.1907,-10.8961> }}
union{cone{<1.33173,13.5579,-13.9915> ,0.12096,<1.88164,14.7166,-16.998> ,0.11232}
sphere{<1.33173,13.5579,-13.9915> ,0.12096}
texture{txttree matrix <0.903422,-0.428752,0,0.168237,0.354492,-0.9198,0.394366,0.830968,0.392388,1.33173,13.5579,-13.9915> }}
union{cone{<1.88164,14.7166,-16.998> ,0.11232,<0.619967,16.7033,-19.4771> ,0.10368}
sphere{<1.88164,14.7166,-16.998> ,0.11232}
texture{txttree matrix <0.84416,0.536092,0,-0.369094,0.581195,-0.725246,-0.388799,0.612224,0.688489,1.88164,14.7166,-16.998> }}
union{cone{<0.619967,16.7033,-19.4771> ,0.10368,<0.696682,18.4723,-22.2022> ,0.09504}
sphere{<0.619967,16.7033,-19.4771> ,0.10368}
texture{txttree matrix <0.999061,-0.0433273,0,0.0236062,0.544324,-0.838543,0.0363318,0.837755,0.544836,0.619967,16.7033,-19.4771> }}
union{cone{<0.696682,18.4723,-22.2022> ,0.09504,<-0.218782,20.5268,-24.762> ,0.0864}
sphere{<0.696682,18.4723,-22.2022> ,0.09504}
texture{txttree matrix <0.913427,0.407002,0,-0.268651,0.602927,-0.751203,-0.305741,0.686169,0.660072,0.696682,18.4723,-22.2022> }}
union{cone{<-0.218782,20.5268,-24.762> ,0.0864,<-0.486597,22.7788,-27.158> ,0.07776}
sphere{<-0.218782,20.5268,-24.762> ,0.0864}
texture{txttree matrix <0.993003,0.11809,0,-0.0811779,0.682615,-0.726255,-0.0857633,0.721174,0.687425,-0.218782,20.5268,-24.762> }}
union{cone{<1.68947,14.5606,-14.1268> ,0.1296,<0.0281262,16.2744,-16.1264> ,0.12096}
sphere{<1.68947,14.5606,-14.1268> ,0.1296}
texture{txttree matrix <0.718026,0.696016,0,-0.533543,0.550415,-0.642165,-0.446957,0.461091,0.766567,1.68947,14.5606,-14.1268> }}
union{cone{<0.0281262,16.2744,-16.1264> ,0.12096,<-1.5494,17.7332,-18.5583> ,0.11232}
sphere{<0.0281262,16.2744,-16.1264> ,0.12096}
texture{txttree matrix <0.678918,0.734214,0,-0.486133,0.449521,-0.749404,-0.550222,0.508784,0.662113,0.0281262,16.2744,-16.1264> }}
union{cone{<-1.5494,17.7332,-18.5583> ,0.11232,<-1.6352,19.527,-21.1707> ,0.10368}
sphere{<-1.5494,17.7332,-18.5583> ,0.11232}
texture{txttree matrix <0.998858,0.0477705,0,-0.0270624,0.565863,-0.824055,-0.0393655,0.823115,0.566509,-1.5494,17.7332,-18.5583> }}
union{cone{<-1.6352,19.527,-21.1707> ,0.10368,<-1.62972,22.2422,-23.1416> ,0.09504}
sphere{<-1.6352,19.527,-21.1707> ,0.10368}
texture{txttree matrix <0.999998,-0.00201742,0,0.00163262,0.809261,-0.587447,0.00118513,0.587446,0.809263,-1.6352,19.527,-21.1707> }}
union{cone{<-1.62972,22.2422,-23.1416> ,0.09504,<-2.05725,23.7615,-25.9376> ,0.0864}
sphere{<-1.62972,22.2422,-23.1416> ,0.09504}
texture{txttree matrix <0.962614,0.270878,0,-0.133159,0.473202,-0.870832,-0.23589,0.838275,0.491581,-1.62972,22.2422,-23.1416> }}
union{cone{<-2.05725,23.7615,-25.9376> ,0.0864,<-2.95878,25.5522,-28.7026> ,0.07776}
sphere{<-2.05725,23.7615,-25.9376> ,0.0864}
texture{txttree matrix <0.893189,0.449681,0,-0.26397,0.524317,-0.809575,-0.36405,0.723104,0.587017,-2.05725,23.7615,-25.9376> }}
union{cone{<0.877704,2.14336,-2.66902> ,0.216,<-0.444535,3.18244,-3.32511> ,0.203657}
sphere{<0.877704,2.14336,-2.66902> ,0.216}
texture{txttree matrix <0.617887,0.786267,0,-0.732494,0.575629,-0.363461,-0.285778,0.224578,0.931609,0.877704,2.14336,-2.66902> }}
union{cone{<-0.444535,3.18244,-3.32511> ,0.203657,<-1.73257,3.48869,-4.54693> ,0.191314}
sphere{<-0.444535,3.18244,-3.32511> ,0.203657}
texture{txttree matrix <0.231318,0.972878,0,-0.71495,0.169991,-0.678196,-0.659802,0.156879,0.734881,-0.444535,3.18244,-3.32511> }}
union{cone{<-1.73257,3.48869,-4.54693> ,0.191314,<-2.37242,4.02151,-6.15495> ,0.178971}
sphere{<-1.73257,3.48869,-4.54693> ,0.191314}
texture{txttree matrix <0.639904,0.768455,0,-0.353352,0.294242,-0.888011,-0.682397,0.568242,0.459822,-1.73257,3.48869,-4.54693> }}
union{cone{<-2.37242,4.02151,-6.15495> ,0.178971,<-3.38499,4.58079,-7.53617> ,0.166629}
sphere{<-2.37242,4.02151,-6.15495> ,0.178971}
texture{txttree matrix <0.483492,0.875349,0,-0.562027,0.310431,-0.766654,-0.67109,0.370671,0.642061,-2.37242,4.02151,-6.15495> }}
union{cone{<-3.38499,4.58079,-7.53617> ,0.166629,<-4.50264,5.2686,-8.67559> ,0.154286}
sphere{<-3.38499,4.58079,-7.53617> ,0.166629}
texture{txttree matrix <0.524109,0.851651,0,-0.643085,0.395757,-0.655605,-0.558347,0.343609,0.755104,-3.38499,4.58079,-7.53617> }}
union{cone{<-4.50264,5.2686,-8.67559> ,0.154286,<-5.30157,6.01664,-10.1523> ,0.141943}
sphere{<-4.50264,5.2686,-8.67559> ,0.154286}
texture{txttree matrix <0.68348,0.729969,0,-0.434651,0.406969,-0.803402,-0.586459,0.549109,0.595437,-4.50264,5.2686,-8.67559> }}
union{cone{<-5.30157,6.01664,-10.1523> ,0.141943,<-6.08177,7.21013,-11.1552> ,0.1296}
sphere{<-5.30157,6.01664,-10.1523> ,0.141943}
texture{txttree matrix <0.837019,0.547174,0,-0.447556,0.684632,-0.575302,-0.31479,0.481538,0.817941,-5.30157,6.01664,-10.1523> }}
union{cone{<-6.08177,7.21013,-11.1552> ,0.1296,<-7.70253,9.49068,-12.529> ,0.12096}
sphere{<-6.08177,7.21013,-11.1552> ,0.1296}
texture{txttree matrix <0.815119,0.579294,0,-0.519991,0.731675,-0.44075,-0.255324,0.359264,0.89763,-6.08177,7.21013,-11.1552> }}
union{cone{<-7.70253,9.49068,-12.529> ,0.12096,<-9.14539,11.7129,-14.1904> ,0.11232}
sphere{<-7.70253,9.49068,-12.529> ,0.12096}
texture{txttree matrix <0.838716,0.544569,0,-0.461362,0.710566,-0.531264,-0.28931,0.44558,0.847206,-7.70253,9.49068,-12.529> }}
union{cone{<-9.14539,11.7129,-14.1904> ,0.11232,<-9.50763,14.6026,-15.5005> ,0.10368}
sphere{<-9.14539,11.7129,-14.1904> ,0.11232}
texture{txttree matrix <0.992234,0.124383,0,-0.113434,0.904892,-0.410247,-0.0510279,0.407062,0.911974,-9.14539,11.7129,-14.1904> }}
union{cone{<-9.50763,14.6026,-15.5005> ,0.10368,<-10.4148,17.0309,-17.6269> ,0.09504}
sphere{<-9.50763,14.6026,-15.5005> ,0.10368}
texture{txttree matrix <0.936769,0.349948,0,-0.270567,0.724274,-0.634208,-0.22194,0.594107,0.773162,-9.50763,14.6026,-15.5005> }}
union{cone{<-10.4148,17.0309,-17.6269> ,0.09504,<-11.0892,20.2227,-18.4996> ,0.0864}
sphere{<-10.4148,17.0309,-17.6269> ,0.09504}
texture{txttree matrix <0.978395,0.206745,0,-0.199722,0.94516,-0.258427,-0.0534285,0.252843,0.966031,-10.4148,17.0309,-17.6269> }}
union{cone{<-11.0892,20.2227,-18.4996> ,0.0864,<-11.9434,23.1724,-19.3856> ,0.07776}
sphere{<-11.0892,20.2227,-18.4996> ,0.0864}
texture{txttree matrix <0.960537,0.278151,0,-0.267252,0.922898,-0.277194,-0.0771018,0.266255,0.960814,-11.0892,20.2227,-18.4996> }}
union{cone{<-3.49612,4.64918,-7.64947> ,0.1296,<-5.897,6.76975,-8.59532> ,0.12096}
sphere{<-3.49612,4.64918,-7.64947> ,0.1296}
texture{txttree matrix <0.661998,0.749505,0,-0.718824,0.634899,-0.283188,-0.212251,0.18747,0.959064,-3.49612,4.64918,-7.64947> }}
union{cone{<-5.897,6.76975,-8.59532> ,0.12096,<-6.39847,9.34613,-10.5845> ,0.11232}
sphere{<-5.897,6.76975,-8.59532> ,0.12096}
texture{txttree matrix <0.981579,0.191056,0,-0.15227,0.782308,-0.603993,-0.115397,0.592867,0.796989,-5.897,6.76975,-8.59532> }}
union{cone{<-6.39847,9.34613,-10.5845> ,0.11232,<-8.02152,11.7866,-12.0844> ,0.10368}
sphere{<-6.39847,9.34613,-10.5845> ,0.11232}
texture{txttree matrix <0.83267,0.55377,0,-0.492962,0.741236,-0.455585,-0.252289,0.379352,0.890192,-6.39847,9.34613,-10.5845> }}
union{cone{<-8.02152,11.7866,-12.0844> ,0.10368,<-9.34914,13.4452,-14.6296> ,0.09504}
sphere{<-8.02152,11.7866,-12.0844> ,0.10368}
texture{txttree matrix <0.780704,0.624901,0,-0.400451,0.500292,-0.76769,-0.47973,0.599338,0.640822,-8.02152,11.7866,-12.0844> }}
union{cone{<-9.34914,13.4452,-14.6296> ,0.09504,<-9.81197,15.7389,-16.8824> ,0.0864}
sphere{<-9.34914,13.4452,-14.6296> ,0.09504}
texture{txttree matrix <0.980242,0.1978,0,-0.142492,0.706153,-0.693573,-0.137188,0.67987,0.720386,-9.34914,13.4452,-14.6296> }}
union{cone{<-9.81197,15.7389,-16.8824> ,0.0864,<-10.3016,17.7194,-19.3975> ,0.07776}
sphere{<-9.81197,15.7389,-16.8824> ,0.0864}
texture{txttree matrix <0.970771,0.240006,0,-0.151194,0.611545,-0.77663,-0.186396,0.75393,0.629957,-9.81197,15.7389,-16.8824> }}
union{cone{<-2.08391,3.78126,-5.42989> ,0.1296,<-1.49877,5.66855,-8.23242> ,0.12096}
sphere{<-2.08391,3.78126,-5.42989> ,0.1296}
texture{txttree matrix <0.955146,-0.296136,0,0.170642,0.550381,-0.81729,0.242029,0.780631,0.576227,-2.08391,3.78126,-5.42989> }}
union{cone{<-1.49877,5.66855,-8.23242> ,0.12096,<-1.02735,7.11046,-10.9517> ,0.11232}
sphere{<-1.49877,5.66855,-8.23242> ,0.12096}
texture{txttree matrix <0.950489,-0.310758,0,0.151398,0.463069,-0.873296,0.271383,0.830058,0.487191,-1.49877,5.66855,-8.23242> }}
union{cone{<-1.02735,7.11046,-10.9517> ,0.11232,<-0.124158,7.74818,-13.9665> ,0.10368}
sphere{<-1.02735,7.11046,-10.9517> ,0.11232}
texture{txttree matrix <0.576792,-0.816891,0,0.281262,0.198594,-0.938857,0.766943,0.541525,0.344308,-1.02735,7.11046,-10.9517> }}
union{cone{<-0.124158,7.74818,-13.9665> ,0.10368,<-0.126341,8.4595,-17.2358> ,0.09504}
sphere{<-0.124158,7.74818,-13.9665> ,0.10368}
texture{txttree matrix <0.999995,0.00306917,0,-0.00065252,0.212603,-0.977138,-0.00299901,0.977134,0.212604,-0.124158,7.74818,-13.9665> }}
union{cone{<-0.126341,8.4595,-17.2358> ,0.09504,<-0.491436,10.4659,-19.8881> ,0.0864}
sphere{<-0.126341,8.4595,-17.2358> ,0.09504}
texture{txttree matrix <0.983844,0.179029,0,-0.109125,0.59969,-0.792757,-0.141927,0.779949,0.609538,-0.126341,8.4595,-17.2358> }}
union{cone{<-0.491436,10.4659,-19.8881> ,0.0864,<0.00203465,12.1546,-22.7118> ,0.07776}
sphere{<-0.491436,10.4659,-19.8881> ,0.0864}
texture{txttree matrix <0.95986,-0.280481,0,0.148322,0.507588,-0.848737,0.238055,0.814669,0.528814,-0.491436,10.4659,-19.8881> }}
union{cone{<-2.24945,3.91911,-5.8459> ,0.1296,<-3.46618,3.77034,-8.76349> ,0.12096}
sphere{<-2.24945,3.91911,-5.8459> ,0.1296}
texture{txttree matrix <-0.12136,0.992609,0,-0.384479,-0.0470078,-0.921936,-0.915122,-0.111886,0.387342,-2.24945,3.91911,-5.8459> }}
union{cone{<-3.46618,3.77034,-8.76349> ,0.12096,<-3.60471,3.2535,-11.9226> ,0.11232}
sphere{<-3.46618,3.77034,-8.76349> ,0.12096}
texture{txttree matrix <-0.965905,0.258898,0,-0.0432364,-0.161308,-0.985957,-0.255262,-0.95234,0.167002,-3.46618,3.77034,-8.76349> }}
union{cone{<-3.60471,3.2535,-11.9226> ,0.11232,<-4.61312,4.21892,-14.879> ,0.10368}
sphere{<-3.60471,3.2535,-11.9226> ,0.11232}
texture{txttree matrix <0.691544,0.722334,0,-0.30843,0.295283,-0.904256,-0.653175,0.625333,0.426991,-3.60471,3.2535,-11.9226> }}
union{cone{<-4.61312,4.21892,-14.879> ,0.10368,<-4.64927,4.55166,-18.2593> ,0.09504}
sphere{<-4.61312,4.21892,-14.879> ,0.10368}
texture{txttree matrix <0.994149,0.10802,0,-0.0106434,0.0979547,-0.995134,-0.107495,0.989311,0.0985312,-4.61312,4.21892,-14.879> }}
union{cone{<-4.64927,4.55166,-18.2593> ,0.09504,<-4.91519,5.14188,-21.5174> ,0.0864}
sphere{<-4.64927,4.55166,-18.2593> ,0.09504}
texture{txttree matrix <0.911735,0.410779,0,-0.0800533,0.17768,-0.980827,-0.402903,0.894254,0.194882,-4.64927,4.55166,-18.2593> }}
union{cone{<-4.91519,5.14188,-21.5174> ,0.0864,<-5.31742,6.27579,-24.4203> ,0.07776}
sphere{<-4.91519,5.14188,-21.5174> ,0.0864}
texture{txttree matrix <0.942462,0.334314,0,-0.128005,0.360857,-0.923795,-0.308838,0.870641,0.382887,-4.91519,5.14188,-21.5174> }}
union{cone{<-5.3127,6.03368,-10.1666> ,0.1296,<-7.04522,8.23478,-11.8282> ,0.12096}
sphere{<-5.3127,6.03368,-10.1666> ,0.1296}
texture{txttree matrix <0.785783,0.618502,0,-0.531957,0.675831,-0.510171,-0.315542,0.400884,0.860073,-5.3127,6.03368,-10.1666> }}
union{cone{<-7.04522,8.23478,-11.8282> ,0.12096,<-9.16663,10.4543,-13.1746> ,0.11232}
sphere{<-7.04522,8.23478,-11.8282> ,0.12096}
texture{txttree matrix <0.72291,0.690943,0,-0.632773,0.662049,-0.401608,-0.277488,0.290326,0.915812,-7.04522,8.23478,-11.8282> }}
union{cone{<-9.16663,10.4543,-13.1746> ,0.11232,<-10.529,13.0928,-14.3484> ,0.10368}
sphere{<-9.16663,10.4543,-13.1746> ,0.11232}
texture{txttree matrix <0.888538,0.458804,0,-0.426675,0.826315,-0.36763,-0.16867,0.326653,0.929972,-9.16663,10.4543,-13.1746> }}
union{cone{<-10.529,13.0928,-14.3484> ,0.10368,<-12.2388,14.5966,-16.8732> ,0.09504}
sphere{<-10.529,13.0928,-14.3484> ,0.10368}
texture{txttree matrix <0.660425,0.750892,0,-0.502906,0.442315,-0.742592,-0.557607,0.490426,0.669744,-10.529,13.0928,-14.3484> }}
union{cone{<-12.2388,14.5966,-16.8732> ,0.09504,<-12.958,17.0968,-19.053> ,0.0864}
sphere{<-12.2388,14.5966,-16.8732> ,0.09504}
texture{txttree matrix <0.961032,0.276436,0,-0.211891,0.736639,-0.642234,-0.177537,0.617208,0.766508,-12.2388,14.5966,-16.8732> }}
union{cone{<-12.958,17.0968,-19.053> ,0.0864,<-14.8156,18.8934,-20.8628> ,0.07776}
sphere{<-12.958,17.0968,-19.053> ,0.0864}
texture{txttree matrix <0.695203,0.718814,0,-0.588778,0.569438,-0.573655,-0.412351,0.398807,0.819097,-12.958,17.0968,-19.053> }}
union{cone{<-0.227448,5.44629,-4.28878> ,0.216,<-1.43009,6.51164,-5.02867> ,0.203657}
sphere{<-0.227448,5.44629,-4.28878> ,0.216}
texture{txttree matrix <0.66309,0.748539,0,-0.679907,0.602293,-0.418295,-0.31311,0.277367,0.908311,-0.227448,5.44629,-4.28878> }}
union{cone{<-1.43009,6.51164,-5.02867> ,0.203657,<-2.64687,7.56459,-5.80667> ,0.191314}
sphere{<-1.43009,6.51164,-5.02867> ,0.203657}
texture{txttree matrix <0.654364,0.75618,0,-0.680783,0.589119,-0.435285,-0.329154,0.284835,0.900293,-1.43009,6.51164,-5.02867> }}
union{cone{<-2.64687,7.56459,-5.80667> ,0.191314,<-3.36577,9.10432,-6.02456> ,0.178971}
sphere{<-2.64687,7.56459,-5.80667> ,0.191314}
texture{txttree matrix <0.906103,0.423057,0,-0.419621,0.898745,-0.127187,-0.0538073,0.115244,0.991879,-2.64687,7.56459,-5.80667> }}
union{cone{<-3.36577,9.10432,-6.02456> ,0.178971,<-4.39847,10.3863,-6.46693> ,0.166629}
sphere{<-3.36577,9.10432,-6.02456> ,0.178971}
texture{txttree matrix <0.778744,0.627342,0,-0.605847,0.752062,-0.259522,-0.162809,0.202101,0.965737,-3.36577,9.10432,-6.02456> }}
union{cone{<-4.39847,10.3863,-6.46693> ,0.166629,<-5.137,11.7475,-7.11716> ,0.154286}
sphere{<-4.39847,10.3863,-6.46693> ,0.166629}
texture{txttree matrix <0.878973,0.476871,0,-0.43969,0.81044,-0.387118,-0.184606,0.340267,0.92203,-4.39847,10.3863,-6.46693> }}
union{cone{<-5.137,11.7475,-7.11716> ,0.154286,<-5.838,12.8818,-8.38195> ,0.141943}
sphere{<-5.137,11.7475,-7.11716> ,0.154286}
texture{txttree matrix <0.850648,0.525736,0,-0.381433,0.617163,-0.688199,-0.361811,0.585415,0.725522,-5.137,11.7475,-7.11716> }}
union{cone{<-5.838,12.8818,-8.38195> ,0.141943,<-6.71667,14.1652,-9.16656> ,0.1296}
sphere{<-5.838,12.8818,-8.38195> ,0.141943}
texture{txttree matrix <0.825148,0.564917,0,-0.504376,0.736719,-0.450389,-0.254432,0.371637,0.892832,-5.838,12.8818,-8.38195> }}
union{cone{<-6.71667,14.1652,-9.16656> ,0.1296,<-8.644,16.646,-8.15738> ,0.12096}
sphere{<-6.71667,14.1652,-9.16656> ,0.1296}
texture{txttree matrix <0.789691,0.613505,0,-0.584106,0.751849,0.305847,0.187639,-0.241525,0.952081,-6.71667,14.1652,-9.16656> }}
union{cone{<-8.644,16.646,-8.15738> ,0.12096,<-9.77129,19.3282,-9.3113> ,0.11232}
sphere{<-8.644,16.646,-8.15738> ,0.12096}
texture{txttree matrix <0.92189,0.387452,0,-0.36016,0.856952,-0.368669,-0.142842,0.339872,0.929561,-8.644,16.646,-8.15738> }}
union{cone{<-9.77129,19.3282,-9.3113> ,0.11232,<-11.598,21.6295,-10.9165> ,0.10368}
sphere{<-9.77129,19.3282,-9.3113> ,0.11232}
texture{txttree matrix <0.783237,0.621724,0,-0.545605,0.687344,-0.47945,-0.298086,0.375523,0.877569,-9.77129,19.3282,-9.3113> }}
union{cone{<-11.598,21.6295,-10.9165> ,0.10368,<-13.2014,24.4521,-11.1529> ,0.09504}
sphere{<-11.598,21.6295,-10.9165> ,0.10368}
texture{txttree matrix <0.869508,0.49392,0,-0.492615,0.867212,-0.0726218,-0.0358693,0.0631452,0.99736,-11.598,21.6295,-10.9165> }}
union{cone{<-13.2014,24.4521,-11.1529> ,0.09504,<-13.5888,27.1974,-12.6076> ,0.0864}
sphere{<-13.2014,24.4521,-11.1529> ,0.09504}
texture{txttree matrix <0.990187,0.139751,0,-0.12375,0.876818,-0.464625,-0.0649317,0.460066,0.885508,-13.2014,24.4521,-11.1529> }}
union{cone{<-13.5888,27.1974,-12.6076> ,0.0864,<-15.0372,29.5736,-14.355> ,0.07776}
sphere{<-13.5888,27.1974,-12.6076> ,0.0864}
texture{txttree matrix <0.853882,0.520467,0,-0.440782,0.723151,-0.531755,-0.276761,0.454056,0.846898,-13.5888,27.1974,-12.6076> }}
union{cone{<-5.92403,13.0074,-8.45877> ,0.1296,<-6.23893,15.3604,-10.5161> ,0.12096}
sphere{<-5.92403,13.0074,-8.45877> ,0.1296}
texture{txttree matrix <0.991163,0.13265,0,-0.100245,0.749029,-0.65491,-0.0868738,0.649122,0.755707,-5.92403,13.0074,-8.45877> }}
union{cone{<-6.23893,15.3604,-10.5161> ,0.12096,<-6.40439,17.886,-12.7625> ,0.11232}
sphere{<-6.23893,15.3604,-10.5161> ,0.12096}
texture{txttree matrix <0.997861,0.0653695,0,-0.0488904,0.746309,-0.663801,-0.0433923,0.662382,0.747909,-6.23893,15.3604,-10.5161> }}
union{cone{<-6.40439,17.886,-12.7625> ,0.11232,<-6.46711,20.9042,-13.8719> ,0.10368}
sphere{<-6.40439,17.886,-12.7625> ,0.11232}
texture{txttree matrix <0.999784,0.0207765,0,-0.0195014,0.938426,-0.34493,-0.00716643,0.344856,0.938628,-6.40439,17.886,-12.7625> }}
union{cone{<-6.46711,20.9042,-13.8719> ,0.10368,<-7.79563,23.701,-14.896> ,0.09504}
sphere{<-6.46711,20.9042,-13.8719> ,0.10368}
texture{txttree matrix <0.903271,0.429071,0,-0.407364,0.857575,-0.314038,-0.134744,0.283661,0.949411,-6.46711,20.9042,-13.8719> }}
union{cone{<-7.79563,23.701,-14.896> ,0.09504,<-8.8309,26.4375,-16.1254> ,0.0864}
sphere{<-7.79563,23.701,-14.896> ,0.09504}
texture{txttree matrix <0.935306,0.35384,0,-0.326211,0.862276,-0.387384,-0.137072,0.362323,0.921918,-7.79563,23.701,-14.896> }}
union{cone{<-8.8309,26.4375,-16.1254> ,0.0864,<-8.93572,28.8475,-18.2602> ,0.07776}
sphere{<-8.8309,26.4375,-16.1254> ,0.0864}
texture{txttree matrix <0.999055,0.043453,0,-0.0325406,0.748163,-0.662716,-0.028797,0.66209,0.748871,-8.8309,26.4375,-16.1254> }}
union{cone{<-4.29469,10.2574,-6.42248> ,0.1296,<-4.78618,12.7883,-8.45246> ,0.12096}
sphere{<-4.29469,10.2574,-6.42248> ,0.1296}
texture{txttree matrix <0.981661,0.190637,0,-0.14978,0.771274,-0.61863,-0.117934,0.607285,0.785682,-4.29469,10.2574,-6.42248> }}
union{cone{<-4.78618,12.7883,-8.45246> ,0.12096,<-6.34542,14.6073,-10.747> ,0.11232}
sphere{<-4.78618,12.7883,-8.45246> ,0.12096}
texture{txttree matrix <0.759239,0.650812,0,-0.470026,0.548335,-0.691668,-0.450145,0.525141,0.722216,-4.78618,12.7883,-8.45246> }}
union{cone{<-6.34542,14.6073,-10.747> ,0.11232,<-7.25411,16.6068,-13.0326> ,0.10368}
sphere{<-6.34542,14.6073,-10.747> ,0.11232}
texture{txttree matrix <0.910395,0.413741,0,-0.28667,0.630787,-0.721061,-0.298332,0.65645,0.692872,-6.34542,14.6073,-10.747> }}
union{cone{<-7.25411,16.6068,-13.0326> ,0.10368,<-7.77175,18.5027,-15.5504> ,0.09504}
sphere{<-7.25411,16.6068,-13.0326> ,0.10368}
texture{txttree matrix <0.964689,0.263391,0,-0.162063,0.593569,-0.788297,-0.20763,0.760461,0.615295,-7.25411,16.6068,-13.0326> }}
union{cone{<-7.77175,18.5027,-15.5504> ,0.09504,<-8.68154,20.6737,-17.7278> ,0.0864}
sphere{<-7.77175,18.5027,-15.5504> ,0.09504}
texture{txttree matrix <0.922294,0.38649,0,-0.283726,0.677063,-0.679033,-0.262439,0.626267,0.734108,-7.77175,18.5027,-15.5504> }}
union{cone{<-8.68154,20.6737,-17.7278> ,0.0864,<-9.19873,23.616,-19.2618> ,0.07776}
sphere{<-8.68154,20.6737,-17.7278> ,0.0864}
texture{txttree matrix <0.9849,0.173127,0,-0.15401,0.876146,-0.456782,-0.0790811,0.449884,0.889579,-8.68154,20.6737,-17.7278> }}
union{cone{<-4.98018,11.4585,-6.97909> ,0.1296,<-5.95498,14.2675,-8.26801> ,0.12096}
sphere{<-4.98018,11.4585,-6.97909> ,0.1296}
texture{txttree matrix <0.944733,0.32784,0,-0.300795,0.866798,-0.397724,-0.13039,0.375743,0.917505,-4.98018,11.4585,-6.97909> }}
union{cone{<-5.95498,14.2675,-8.26801> ,0.12096,<-6.74722,16.473,-10.4295> ,0.11232}
sphere{<-5.95498,14.2675,-8.26801> ,0.12096}
texture{txttree matrix <0.941123,0.338064,0,-0.248499,0.691787,-0.677997,-0.229206,0.638078,0.735065,-5.95498,14.2675,-8.26801> }}
union{cone{<-6.74722,16.473,-10.4295> ,0.11232,<-7.24865,19.0821,-12.4761> ,0.10368}
sphere{<-6.74722,16.473,-10.4295> ,0.11232}
texture{txttree matrix <0.982029,0.188732,0,-0.149517,0.777985,-0.610233,-0.11517,0.599266,0.792222,-6.74722,16.473,-10.4295> }}
union{cone{<-7.24865,19.0821,-12.4761> ,0.10368,<-8.30179,20.6424,-15.0158> ,0.09504}
sphere{<-7.24865,19.0821,-12.4761> ,0.10368}
texture{txttree matrix <0.828863,0.559452,0,-0.333137,0.493563,-0.803378,-0.449452,0.66589,0.59547,-7.24865,19.0821,-12.4761> }}
union{cone{<-8.30179,20.6424,-15.0158> ,0.09504,<-8.98825,22.5485,-17.5849> ,0.0864}
sphere{<-8.30179,20.6424,-15.0158> ,0.09504}
texture{txttree matrix <0.940844,0.338839,0,-0.209807,0.582567,-0.785237,-0.266069,0.738786,0.619196,-8.30179,20.6424,-15.0158> }}
union{cone{<-8.98825,22.5485,-17.5849> ,0.0864,<-10.1302,24.9883,-19.4615> ,0.07776}
sphere{<-8.98825,22.5485,-17.5849> ,0.0864}
texture{txttree matrix <0.9057,0.42392,0,-0.347838,0.743152,-0.571606,-0.242315,0.517703,0.820529,-8.98825,22.5485,-17.5849> }}
union{cone{<-0.138436,2.50068,-0.420754> ,0.6,<-0.203131,2.17421,-0.827091> ,0.573333}
sphere{<-0.138436,2.50068,-0.420754> ,0.6}
texture{txttree matrix <-0.980925,0.194386,0,-0.123173,-0.621561,-0.773622,-0.150382,-0.758865,0.633647,-0.138436,2.50068,-0.420754> }}
union{cone{<-0.203131,2.17421,-0.827091> ,0.573333,<-0.593161,2.0034,-1.15621> ,0.546667}
sphere{<-0.203131,2.17421,-0.827091> ,0.573333}
texture{txttree matrix <-0.401156,0.91601,0,-0.724749,-0.317395,-0.611555,-0.56019,-0.245329,0.791202,-0.203131,2.17421,-0.827091> }}
union{cone{<-0.593161,2.0034,-1.15621> ,0.546667,<-0.84387,1.70364,-1.48881> ,0.52}
sphere{<-0.593161,2.0034,-1.15621> ,0.546667}
texture{txttree matrix <-0.767075,0.641558,0,-0.488557,-0.58414,-0.648145,-0.415823,-0.497176,0.761517,-0.593161,2.0034,-1.15621> }}
union{cone{<-0.84387,1.70364,-1.48881> ,0.52,<-1.09764,1.50428,-1.88978> ,0.493333}
sphere{<-0.84387,1.70364,-1.48881> ,0.52}
texture{txttree matrix <-0.617775,0.786355,0,-0.493038,-0.38734,-0.779026,-0.612591,-0.481263,0.626992,-0.84387,1.70364,-1.48881> }}
union{cone{<-1.09764,1.50428,-1.88978> ,0.493333,<-1.3782,1.39926,-2.34566> ,0.466667}
sphere{<-1.09764,1.50428,-1.88978> ,0.493333}
texture{txttree matrix <-0.350566,0.936538,0,-0.514324,-0.192522,-0.835707,-0.782671,-0.292971,0.549176,-1.09764,1.50428,-1.88978> }}
union{cone{<-1.3782,1.39926,-2.34566> ,0.466667,<-1.56134,1.31676,-2.82216> ,0.44}
sphere{<-1.3782,1.39926,-2.34566> ,0.466667}
texture{txttree matrix <-0.410739,0.911753,0,-0.354149,-0.159542,-0.92148,-0.840162,-0.378487,0.388427,-1.3782,1.39926,-2.34566> }}
union{cone{<-1.56134,1.31676,-2.82216> ,0.44,<-1.81426,1.3933,-3.29921> ,0.413333}
sphere{<-1.56134,1.31676,-2.82216> ,0.44}
texture{txttree matrix <0.289675,0.957125,0,-0.46378,0.140364,-0.874761,-0.837255,0.253397,0.484555,-1.56134,1.31676,-2.82216> }}
union{cone{<-1.81426,1.3933,-3.29921> ,0.413333,<-2.07355,1.31157,-3.72829> ,0.386667}
sphere{<-1.81426,1.3933,-3.29921> ,0.413333}
texture{txttree matrix <-0.300645,0.953736,0,-0.510456,-0.160911,-0.844714,-0.805634,-0.253959,0.535218,-1.81426,1.3933,-3.29921> }}
union{cone{<-2.07355,1.31157,-3.72829> ,0.386667,<-2.18136,1.45205,-4.20499> ,0.36}
sphere{<-2.07355,1.31157,-3.72829> ,0.386667}
texture{txttree matrix <0.793307,0.608821,0,-0.212008,0.276251,-0.93741,-0.570716,0.743654,0.348227,-2.07355,1.31157,-3.72829> }}
union{cone{<-2.18136,1.45205,-4.20499> ,0.36,<-2.75351,2.11367,-4.64989> ,0.342}
sphere{<-2.18136,1.45205,-4.20499> ,0.36}
texture{txttree matrix <0.756397,0.654113,0,-0.583028,0.674196,-0.453364,-0.296551,0.342923,0.891326,-2.18136,1.45205,-4.20499> }}
union{cone{<-2.75351,2.11367,-4.64989> ,0.342,<-3.16779,2.9323,-4.66196> ,0.324}
sphere{<-2.75351,2.11367,-4.64989> ,0.342}
texture{txttree matrix <0.892255,0.451532,0,-0.451493,0.892178,-0.0131534,-0.00593917,0.0117362,0.999913,-2.75351,2.11367,-4.64989> }}
union{cone{<-3.16779,2.9323,-4.66196> ,0.324,<-3.5746,3.7746,-4.96213> ,0.306}
sphere{<-3.16779,2.9323,-4.66196> ,0.324}
texture{txttree matrix <0.900476,0.434905,0,-0.414106,0.857411,-0.305552,-0.132886,0.275142,0.952175,-3.16779,2.9323,-4.66196> }}
union{cone{<-3.5746,3.7746,-4.96213> ,0.306,<-4.07303,4.42623,-5.5324> ,0.288}
sphere{<-3.5746,3.7746,-4.96213> ,0.306}
texture{txttree matrix <0.794279,0.607553,0,-0.49887,0.652193,-0.570766,-0.34677,0.453347,0.821113,-3.5746,3.7746,-4.96213> }}
union{cone{<-4.07303,4.42623,-5.5324> ,0.288,<-4.6499,5.04886,-5.89953> ,0.27}
sphere{<-4.07303,4.42623,-5.5324> ,0.288}
texture{txttree matrix <0.733547,0.679639,0,-0.623788,0.673266,-0.396991,-0.269811,0.291211,0.917823,-4.07303,4.42623,-5.5324> }}
union{cone{<-4.6499,5.04886,-5.89953> ,0.27,<-4.7927,5.86665,-6.36614> ,0.252}
sphere{<-4.6499,5.04886,-5.89953> ,0.27}
texture{txttree matrix <0.985095,0.17201,0,-0.149947,0.858742,-0.489977,-0.0842809,0.482674,0.871735,-4.6499,5.04886,-5.89953> }}
union{cone{<-4.7927,5.86665,-6.36614> ,0.252,<-5.35577,6.5391,-6.84218> ,0.234}
sphere{<-4.7927,5.86665,-6.36614> ,0.252}
texture{txttree matrix <0.766709,0.641995,0,-0.564242,0.673851,-0.477028,-0.30625,0.365742,0.878888,-4.7927,5.86665,-6.36614> }}
union{cone{<-5.35577,6.5391,-6.84218> ,0.234,<-5.67441,7.34968,-7.1348> ,0.216}
sphere{<-5.35577,6.5391,-6.84218> ,0.234}
texture{txttree matrix <0.930674,0.36585,0,-0.3468,0.882213,-0.31848,-0.116516,0.296401,0.94793,-5.35577,6.5391,-6.84218> }}
union{cone{<-5.67441,7.34968,-7.1348> ,0.216,<-6.283,8.49994,-6.08301> ,0.203657}
sphere{<-5.67441,7.34968,-7.1348> ,0.216}
texture{txttree matrix <0.883904,0.467669,0,-0.363721,0.68744,0.628596,0.293975,-0.555619,0.777732,-5.67441,7.34968,-7.1348> }}
union{cone{<-6.283,8.49994,-6.08301> ,0.203657,<-7.40151,9.92041,-6.13187> ,0.191314}
sphere{<-6.283,8.49994,-6.08301> ,0.203657}
texture{txttree matrix <0.785668,0.618648,0,-0.618422,0.785382,-0.0270174,-0.0167143,0.0212267,0.999635,-6.283,8.49994,-6.08301> }}
union{cone{<-7.40151,9.92041,-6.13187> ,0.191314,<-7.69658,11.4753,-5.55996> ,0.178971}
sphere{<-7.40151,9.92041,-6.13187> ,0.191314}
texture{txttree matrix <0.982465,0.186446,0,-0.175348,0.923986,0.339856,0.0633647,-0.333897,0.940477,-7.40151,9.92041,-6.13187> }}
union{cone{<-7.69658,11.4753,-5.55996> ,0.178971,<-8.30982,13.133,-5.84815> ,0.166629}
sphere{<-7.69658,11.4753,-5.55996> ,0.178971}
texture{txttree matrix <0.937883,0.346953,0,-0.342431,0.925659,-0.160926,-0.0558336,0.150929,0.986967,-7.69658,11.4753,-5.55996> }}
union{cone{<-8.30982,13.133,-5.84815> ,0.166629,<-8.90966,14.8483,-5.84294> ,0.154286}
sphere{<-8.30982,13.133,-5.84815> ,0.166629}
texture{txttree matrix <0.943948,0.330095,0,-0.330093,0.943944,0.00286541,0.000945856,-0.00270479,0.999996,-8.30982,13.133,-5.84815> }}
union{cone{<-8.90966,14.8483,-5.84294> ,0.154286,<-9.4534,16.4214,-6.19414> ,0.141943}
sphere{<-8.90966,14.8483,-5.84294> ,0.154286}
texture{txttree matrix <0.945133,0.326687,0,-0.319648,0.92477,-0.206459,-0.0674475,0.195131,0.978455,-8.90966,14.8483,-5.84294> }}
union{cone{<-9.4534,16.4214,-6.19414> ,0.141943,<-9.65324,18.2235,-6.19318> ,0.1296}
sphere{<-9.4534,16.4214,-6.19414> ,0.141943}
texture{txttree matrix <0.993908,0.110216,0,-0.110216,0.993908,0.000530924,5.85162e-005,-0.000527689,1,-9.4534,16.4214,-6.19414> }}
union{cone{<-9.65324,18.2235,-6.19318> ,0.1296,<-9.51467,21.6244,-6.22461> ,0.12096}
sphere{<-9.65324,18.2235,-6.19318> ,0.1296}
texture{txttree matrix <0.999171,-0.040711,0,0.0407092,0.999128,-0.00923542,0.000375983,0.00922776,0.999957,-9.65324,18.2235,-6.19318> }}
union{cone{<-9.51467,21.6244,-6.22461> ,0.12096,<-8.89372,24.6791,-6.40312> ,0.11232}
sphere{<-9.51467,21.6244,-6.22461> ,0.12096}
texture{txttree matrix <0.979959,-0.1992,0,0.198874,0.978356,-0.0571708,0.0113884,0.056025,0.998364,-9.51467,21.6244,-6.22461> }}
union{cone{<-8.89372,24.6791,-6.40312> ,0.11232,<-9.94723,27.6904,-5.54638> ,0.10368}
sphere{<-8.89372,24.6791,-6.40312> ,0.11232}
texture{txttree matrix <0.943902,0.330227,0,-0.318927,0.911603,0.259358,0.0856469,-0.244809,0.965781,-8.89372,24.6791,-6.40312> }}
union{cone{<-9.94723,27.6904,-5.54638> ,0.10368,<-10.7817,30.8804,-4.88795> ,0.09504}
sphere{<-9.94723,27.6904,-5.54638> ,0.10368}
texture{txttree matrix <0.967448,0.25307,0,-0.24817,0.948718,0.195821,0.0495564,-0.189447,0.98064,-9.94723,27.6904,-5.54638> }}
union{cone{<-10.7817,30.8804,-4.88795> ,0.09504,<-11.4475,34.0668,-5.84305> ,0.0864}
sphere{<-10.7817,30.8804,-4.88795> ,0.09504}
texture{txttree matrix <0.97886,0.20453,0,-0.196257,0.939265,-0.28154,-0.0575835,0.275589,0.959549,-10.7817,30.8804,-4.88795> }}
union{cone{<-11.4475,34.0668,-5.84305> ,0.0864,<-10.9804,37.1691,-6.92449> ,0.07776}
sphere{<-11.4475,34.0668,-5.84305> ,0.0864}
texture{txttree matrix <0.988857,-0.148872,0,0.140744,0.934871,-0.325894,0.0485163,0.322262,0.945406,-11.4475,34.0668,-5.84305> }}
union{cone{<-9.52448,17.0623,-6.1938> ,0.1296,<-10.4176,20.0654,-6.5415> ,0.12096}
sphere{<-9.52448,17.0623,-6.1938> ,0.1296}
texture{txttree matrix <0.958513,0.285049,0,-0.28331,0.952664,-0.1103,-0.0314409,0.105724,0.993898,-9.52448,17.0623,-6.1938> }}
union{cone{<-10.4176,20.0654,-6.5415> ,0.12096,<-10.9198,23.1629,-6.88942> ,0.11232}
sphere{<-10.4176,20.0654,-6.5415> ,0.12096}
texture{txttree matrix <0.987105,0.160072,0,-0.159097,0.981093,-0.110201,-0.0176401,0.10878,0.993909,-10.4176,20.0654,-6.5415> }}
union{cone{<-10.9198,23.1629,-6.88942> ,0.11232,<-11.6438,26.2236,-8.05206> ,0.10368}
sphere{<-10.9198,23.1629,-6.88942> ,0.11232}
texture{txttree matrix <0.973148,0.23018,0,-0.215901,0.912781,-0.346725,-0.0798093,0.337415,0.937967,-10.9198,23.1629,-6.88942> }}
union{cone{<-11.6438,26.2236,-8.05206> ,0.10368,<-11.7858,29.3454,-8.71185> ,0.09504}
sphere{<-11.6438,26.2236,-8.05206> ,0.10368}
texture{txttree matrix <0.998967,0.045441,0,-0.0444609,0.97742,-0.206576,-0.00938701,0.206362,0.978431,-11.6438,26.2236,-8.05206> }}
union{cone{<-11.7858,29.3454,-8.71185> ,0.09504,<-11.0959,31.8773,-10.7163> ,0.0864}
sphere{<-11.7858,29.3454,-8.71185> ,0.09504}
texture{txttree matrix <0.96482,-0.262911,0,0.208935,0.766742,-0.607003,0.159588,0.585649,0.7947,-11.7858,29.3454,-8.71185> }}
union{cone{<-11.0959,31.8773,-10.7163> ,0.0864,<-10.6882,34.9027,-11.7793> ,0.07776}
sphere{<-11.0959,31.8773,-10.7163> ,0.0864}
texture{txttree matrix <0.991044,-0.133539,0,0.126111,0.935921,-0.328859,0.0439154,0.325914,0.944379,-11.0959,31.8773,-10.7163> }}
union{cone{<-9.37356,16.1904,-6.14257> ,0.1296,<-12.0495,17.7141,-5.51013> ,0.12096}
sphere{<-9.37356,16.1904,-6.14257> ,0.1296}
texture{txttree matrix <0.494798,0.869008,0,-0.85124,0.484681,0.201183,0.17483,-0.0995448,0.979554,-9.37356,16.1904,-6.14257> }}
union{cone{<-12.0495,17.7141,-5.51013> ,0.12096,<-13.6049,20.7084,-5.52101> ,0.11232}
sphere{<-12.0495,17.7141,-5.51013> ,0.12096}
texture{txttree matrix <0.887426,0.46095,0,-0.460948,0.887422,-0.00322473,-0.00148644,0.00286171,0.999995,-12.0495,17.7141,-5.51013> }}
union{cone{<-13.6049,20.7084,-5.52101> ,0.11232,<-15.3651,22.8023,-7.27615> ,0.10368}
sphere{<-13.6049,20.7084,-5.52101> ,0.11232}
texture{txttree matrix <0.765449,0.643497,0,-0.541599,0.644241,-0.540022,-0.347503,0.413359,0.841651,-13.6049,20.7084,-5.52101> }}
union{cone{<-15.3651,22.8023,-7.27615> ,0.10368,<-16.3466,25.4813,-8.67757> ,0.09504}
sphere{<-15.3651,22.8023,-7.27615> ,0.10368}
texture{txttree matrix <0.938972,0.343993,0,-0.308757,0.84279,-0.44088,-0.15166,0.413974,0.897566,-15.3651,22.8023,-7.27615> }}
union{cone{<-16.3466,25.4813,-8.67757> ,0.09504,<-17.4008,28.0357,-10.5436> ,0.0864}
sphere{<-16.3466,25.4813,-8.67757> ,0.09504}
texture{txttree matrix <0.924376,0.381482,0,-0.316152,0.766072,-0.559626,-0.213487,0.517305,0.828745,-16.3466,25.4813,-8.67757> }}
union{cone{<-17.4008,28.0357,-10.5436> ,0.0864,<-18.3409,31.0364,-11.6066> ,0.07776}
sphere{<-17.4008,28.0357,-10.5436> ,0.0864}
texture{txttree matrix <0.954264,0.298965,0,-0.283221,0.904012,-0.320232,-0.095738,0.305585,0.947339,-17.4008,28.0357,-10.5436> }}
union{cone{<-4.62077,5.01741,-5.88099> ,0.216,<-5.42889,6.31395,-6.8504> ,0.203657}
sphere{<-4.62077,5.01741,-5.88099> ,0.216}
texture{txttree matrix <0.848649,0.528957,0,-0.446632,0.716568,-0.535771,-0.283399,0.454681,0.844364,-4.62077,5.01741,-5.88099> }}
union{cone{<-5.42889,6.31395,-6.8504> ,0.203657,<-5.89309,6.9597,-8.40679> ,0.191314}
sphere{<-5.42889,6.31395,-6.8504> ,0.203657}
texture{txttree matrix <0.811976,0.58369,0,-0.265589,0.369464,-0.890482,-0.519766,0.723051,0.455018,-5.42889,6.31395,-6.8504> }}
union{cone{<-5.89309,6.9597,-8.40679> ,0.191314,<-5.70974,7.96568,-9.88903> ,0.178971}
sphere{<-5.89309,6.9597,-8.40679> ,0.191314}
texture{txttree matrix <0.983793,-0.17931,0,0.101821,0.558649,-0.823131,0.147595,0.80979,0.567852,-5.89309,6.9597,-8.40679> }}
union{cone{<-5.70974,7.96568,-9.88903> ,0.178971,<-5.62484,8.78964,-11.3899> ,0.166629}
sphere{<-5.70974,7.96568,-9.88903> ,0.178971}
texture{txttree matrix <0.994733,-0.102495,0,0.0495244,0.480642,-0.875517,0.0897363,0.870906,0.483187,-5.70974,7.96568,-9.88903> }}
union{cone{<-5.62484,8.78964,-11.3899> ,0.166629,<-5.59283,9.70598,-12.9342> ,0.154286}
sphere{<-5.62484,8.78964,-11.3899> ,0.166629}
texture{txttree matrix <0.999391,-0.0349085,0,0.017822,0.510222,-0.859858,0.0300164,0.859334,0.510533,-5.62484,8.78964,-11.3899> }}
union{cone{<-5.59283,9.70598,-12.9342> ,0.154286,<-6.10531,11.0334,-14.0488> ,0.141943}
sphere{<-5.59283,9.70598,-12.9342> ,0.154286}
texture{txttree matrix <0.932893,0.360153,0,-0.283523,0.734402,-0.616659,-0.222091,0.575277,0.78723,-5.59283,9.70598,-12.9342> }}
union{cone{<-6.10531,11.0334,-14.0488> ,0.141943,<-6.02491,12.0429,-15.5624> ,0.1296}
sphere{<-6.10531,11.0334,-14.0488> ,0.141943}
texture{txttree matrix <0.996844,-0.0793901,0,0.0441477,0.55433,-0.831125,0.0659831,0.828502,0.556085,-6.10531,11.0334,-14.0488> }}
union{cone{<-6.02491,12.0429,-15.5624> ,0.1296,<-5.25381,14.1299,-17.92> ,0.12096}
sphere{<-6.02491,12.0429,-15.5624> ,0.1296}
texture{txttree matrix <0.93802,-0.34658,0,0.237875,0.643809,-0.727273,0.252058,0.682197,0.686348,-6.02491,12.0429,-15.5624> }}
union{cone{<-5.25381,14.1299,-17.92> ,0.12096,<-5.17139,17.1675,-19.375> ,0.11232}
sphere{<-5.25381,14.1299,-17.92> ,0.12096}
texture{txttree matrix <0.999632,-0.0271216,0,0.0244619,0.901602,-0.431874,0.0117131,0.431716,0.901934,-5.25381,14.1299,-17.92> }}
union{cone{<-5.17139,17.1675,-19.375> ,0.11232,<-4.38993,19.8966,-20.7793> ,0.10368}
sphere{<-5.17139,17.1675,-19.375> ,0.11232}
texture{txttree matrix <0.961363,-0.275285,0,0.246745,0.861697,-0.443391,0.122059,0.426259,0.896328,-5.17139,17.1675,-19.375> }}
union{cone{<-4.38993,19.8966,-20.7793> ,0.10368,<-3.37244,22.3596,-22.8808> ,0.09504}
sphere{<-4.38993,19.8966,-20.7793> ,0.10368}
texture{txttree matrix <0.924239,-0.381815,0,0.299806,0.725726,-0.619224,0.236429,0.572311,0.785214,-4.38993,19.8966,-20.7793> }}
union{cone{<-3.37244,22.3596,-22.8808> ,0.09504,<-2.5774,24.7678,-25.057> ,0.0864}
sphere{<-3.37244,22.3596,-22.8808> ,0.09504}
texture{txttree matrix <0.949589,-0.313499,0,0.237911,0.720632,-0.65122,0.204157,0.618391,0.758889,-3.37244,22.3596,-22.8808> }}
union{cone{<-2.5774,24.7678,-25.057> ,0.0864,<-2.28559,27.4981,-26.7498> ,0.07776}
sphere{<-2.5774,24.7678,-25.057> ,0.0864}
texture{txttree matrix <0.994337,-0.106272,0,0.0904631,0.846421,-0.524774,0.0557687,0.521802,0.851242,-2.5774,24.7678,-25.057> }}
union{cone{<-6.0276,12.0093,-15.5119> ,0.1296,<-4.72403,13.0746,-18.4704> ,0.12096}
sphere{<-6.0276,12.0093,-15.5119> ,0.1296}
texture{txttree matrix <0.632814,-0.774304,0,0.382955,0.312978,-0.869132,0.672972,0.549999,0.49458,-6.0276,12.0093,-15.5119> }}
union{cone{<-4.72403,13.0746,-18.4704> ,0.12096,<-3.36891,15.2791,-20.3444> ,0.11232}
sphere{<-4.72403,13.0746,-18.4704> ,0.12096}
texture{txttree matrix <0.851913,-0.523683,0,0.424145,0.689988,-0.58653,0.307155,0.499673,0.809928,-4.72403,13.0746,-18.4704> }}
union{cone{<-3.36891,15.2791,-20.3444> ,0.11232,<-2.95238,17.3071,-22.7026> ,0.10368}
sphere{<-3.36891,15.2791,-20.3444> ,0.11232}
texture{txttree matrix <0.979551,-0.201195,0,0.132737,0.646249,-0.751494,0.151197,0.736127,0.65974,-3.36891,15.2791,-20.3444> }}
union{cone{<-2.95238,17.3071,-22.7026> ,0.10368,<-1.62616,18.8562,-25.2561> ,0.09504}
sphere{<-2.95238,17.3071,-22.7026> ,0.10368}
texture{txttree matrix <0.759642,-0.650341,0,0.405831,0.474038,-0.781402,0.508178,0.593586,0.624028,-2.95238,17.3071,-22.7026> }}
union{cone{<-1.62616,18.8562,-25.2561> ,0.09504,<-1.40374,21.3875,-27.1797> ,0.0864}
sphere{<-1.62616,18.8562,-25.2561> ,0.09504}
texture{txttree matrix <0.996162,-0.0875278,0,0.0697872,0.794255,-0.603563,0.0528286,0.601247,0.797315,-1.62616,18.8562,-25.2561> }}
union{cone{<-1.40374,21.3875,-27.1797> ,0.0864,<-1.15988,23.9797,-29.1633> ,0.07776}
sphere{<-1.40374,21.3875,-27.1797> ,0.0864}
texture{txttree matrix <0.995604,-0.0936659,0,0.0745069,0.791957,-0.606014,0.0567628,0.60335,0.795454,-1.40374,21.3875,-27.1797> }}
union{cone{<-5.57244,6.51364,-7.3317> ,0.1296,<-6.36094,7.253,-10.485> ,0.12096}
sphere{<-5.57244,6.51364,-7.3317> ,0.1296}
texture{txttree matrix <0.684012,0.729471,0,-0.236543,0.221802,-0.945966,-0.690055,0.647052,0.324266,-5.57244,6.51364,-7.3317> }}
union{cone{<-6.36094,7.253,-10.485> ,0.12096,<-5.2687,8.0118,-13.5832> ,0.11232}
sphere{<-6.36094,7.253,-10.485> ,0.12096}
texture{txttree matrix <0.570544,-0.821267,0,0.323957,0.225056,-0.918913,0.754673,0.52428,0.39446,-6.36094,7.253,-10.485> }}
union{cone{<-5.2687,8.0118,-13.5832> ,0.11232,<-5.80513,10.0028,-16.2052> ,0.10368}
sphere{<-5.2687,8.0118,-13.5832> ,0.11232}
texture{txttree matrix <0.96557,0.260145,0,-0.160813,0.596882,-0.786048,-0.204486,0.758984,0.618166,-5.2687,8.0118,-13.5832> }}
union{cone{<-5.80513,10.0028,-16.2052> ,0.10368,<-5.42834,11.8358,-18.8518> ,0.09504}
sphere{<-5.80513,10.0028,-16.2052> ,0.10368}
texture{txttree matrix <0.979518,-0.201356,0,0.116247,0.565495,-0.816518,0.164411,0.799794,0.57732,-5.80513,10.0028,-16.2052> }}
union{cone{<-5.42834,11.8358,-18.8518> ,0.09504,<-4.82091,12.9219,-22.0302> ,0.0864}
sphere{<-5.42834,11.8358,-18.8518> ,0.09504}
texture{txttree matrix <0.872791,-0.488095,0,0.177956,0.318214,-0.931167,0.454497,0.812714,0.364594,-5.42834,11.8358,-18.8518> }}
union{cone{<-4.82091,12.9219,-22.0302> ,0.0864,<-5.43179,14.6848,-24.7326> ,0.07776}
sphere{<-4.82091,12.9219,-22.0302> ,0.0864}
texture{txttree matrix <0.944875,0.327431,0,-0.186024,0.536812,-0.822938,-0.269456,0.777574,0.568131,-4.82091,12.9219,-22.0302> }}
union{cone{<-6.05559,11.6578,-14.985> ,0.1296,<-6.22653,11.8718,-18.4143> ,0.12096}
sphere{<-6.05559,11.6578,-14.985> ,0.1296}
texture{txttree matrix <0.781287,0.624172,0,-0.0496908,0.0621989,-0.996826,-0.622191,0.778807,0.0796107,-6.05559,11.6578,-14.985> }}
union{cone{<-6.22653,11.8718,-18.4143> ,0.12096,<-6.38201,13.3846,-21.2589> ,0.11232}
sphere{<-6.22653,11.8718,-18.4143> ,0.12096}
texture{txttree matrix <0.994761,0.102233,0,-0.0481993,0.468997,-0.881883,-0.0901572,0.877263,0.471468,-6.22653,11.8718,-18.4143> }}
union{cone{<-6.38201,13.3846,-21.2589> ,0.11232,<-7.23726,14.8576,-24.087> ,0.10368}
sphere{<-6.38201,13.3846,-21.2589> ,0.11232}
texture{txttree matrix <0.86479,0.502134,0,-0.259062,0.446164,-0.856636,-0.430146,0.74081,0.515921,-6.38201,13.3846,-21.2589> }}
union{cone{<-7.23726,14.8576,-24.087> ,0.10368,<-6.77866,16.4773,-27.0731> ,0.09504}
sphere{<-7.23726,14.8576,-24.087> ,0.10368}
texture{txttree matrix <0.962175,-0.272431,0,0.133784,0.472498,-0.871119,0.23732,0.838169,0.491073,-7.23726,14.8576,-24.087> }}
union{cone{<-6.77866,16.4773,-27.0731> ,0.09504,<-7.7488,18.1533,-29.6404> ,0.0864}
sphere{<-6.77866,16.4773,-27.0731> ,0.09504}
texture{txttree matrix <0.865479,0.500946,0,-0.301677,0.521204,-0.798334,-0.399922,0.690941,0.602215,-6.77866,16.4773,-27.0731> }}
union{cone{<-7.7488,18.1533,-29.6404> ,0.0864,<-8.43414,19.6022,-32.4238> ,0.07776}
sphere{<-7.7488,18.1533,-29.6404> ,0.0864}
texture{txttree matrix <0.903971,0.427594,0,-0.213377,0.451099,-0.866591,-0.370549,0.783373,0.499019,-7.7488,18.1533,-29.6404> }}
union{cone{<-6.03963,11.8581,-15.2853> ,0.1296,<-6.27039,14.12,-17.4548> ,0.12096}
sphere{<-6.03963,11.8581,-15.2853> ,0.1296}
texture{txttree matrix <0.994836,0.101494,0,-0.0734286,0.719744,-0.690345,-0.0700656,0.68678,0.72348,-6.03963,11.8581,-15.2853> }}
union{cone{<-6.27039,14.12,-17.4548> ,0.12096,<-7.39415,15.3475,-20.4108> ,0.11232}
sphere{<-6.27039,14.12,-17.4548> ,0.12096}
texture{txttree matrix <0.737598,0.67524,0,-0.331266,0.361858,-0.871391,-0.588398,0.642736,0.49059,-6.27039,14.12,-17.4548> }}
union{cone{<-7.39415,15.3475,-20.4108> ,0.11232,<-8.63558,17.2962,-22.6537> ,0.10368}
sphere{<-7.39415,15.3475,-20.4108> ,0.11232}
texture{txttree matrix <0.84339,0.537302,0,-0.38553,0.605157,-0.696528,-0.374246,0.587445,0.717529,-7.39415,15.3475,-20.4108> }}
union{cone{<-8.63558,17.2962,-22.6537> ,0.10368,<-9.14843,18.8777,-25.3396> ,0.09504}
sphere{<-8.63558,17.2962,-22.6537> ,0.10368}
texture{txttree matrix <0.951238,0.308459,0,-0.162354,0.500675,-0.850274,-0.262275,0.808813,0.52634,-8.63558,17.2962,-22.6537> }}
union{cone{<-9.14843,18.8777,-25.3396> ,0.09504,<-9.67187,21.256,-27.6395> ,0.0864}
sphere{<-9.14843,18.8777,-25.3396> ,0.09504}
texture{txttree matrix <0.976626,0.214948,0,-0.15627,0.710019,-0.686624,-0.147588,0.670574,0.727013,-9.14843,18.8777,-25.3396> }}
union{cone{<-9.67187,21.256,-27.6395> ,0.0864,<-10.9957,23.384,-29.837> ,0.07776}
sphere{<-9.67187,21.256,-27.6395> ,0.0864}
texture{txttree matrix <0.849095,0.52824,0,-0.397179,0.638427,-0.659288,-0.348262,0.559798,0.751891,-9.67187,21.256,-27.6395> }}
union{cone{<-5.42522,6.71577,-6.90596> ,0.216,<-5.91112,7.95752,-8.01673> ,0.203657}
sphere{<-5.42522,6.71577,-6.90596> ,0.216}
texture{txttree matrix <0.931243,0.364399,0,-0.279983,0.715512,-0.640041,-0.233231,0.596033,0.768341,-5.42522,6.71577,-6.90596> }}
union{cone{<-5.91112,7.95752,-8.01673> ,0.203657,<-6.41095,8.55685,-9.58214> ,0.191314}
sphere{<-5.91112,7.95752,-8.01673> ,0.203657}
texture{txttree matrix <0.767977,0.640478,0,-0.285754,0.342639,-0.894954,-0.573199,0.687304,0.446157,-5.91112,7.95752,-8.01673> }}
union{cone{<-6.41095,8.55685,-9.58214> ,0.191314,<-7.21654,9.62008,-10.5965> ,0.178971}
sphere{<-6.41095,8.55685,-9.58214> ,0.191314}
texture{txttree matrix <0.797052,0.603911,0,-0.480706,0.634444,-0.605312,-0.365555,0.482465,0.795988,-6.41095,8.55685,-9.58214> }}
union{cone{<-7.21654,9.62008,-10.5965> ,0.178971,<-8.26199,10.4905,-11.6836> ,0.166629}
sphere{<-7.21654,9.62008,-10.5965> ,0.178971}
texture{txttree matrix <0.639862,0.76849,0,-0.600362,0.499875,-0.624252,-0.479732,0.399435,0.781223,-7.21654,9.62008,-10.5965> }}
union{cone{<-8.26199,10.4905,-11.6836> ,0.166629,<-8.6804,11.1774,-13.15> ,0.154286}
sphere{<-8.26199,10.4905,-11.6836> ,0.166629}
texture{txttree matrix <0.854006,0.520263,0,-0.250178,0.410664,-0.876793,-0.456163,0.748787,0.480868,-8.26199,10.4905,-11.6836> }}
union{cone{<-8.6804,11.1774,-13.15> ,0.154286,<-9.57844,11.9475,-14.4937> ,0.141943}
sphere{<-8.6804,11.1774,-13.15> ,0.154286}
texture{txttree matrix <0.650981,0.759094,0,-0.501618,0.430175,-0.750552,-0.56974,0.488595,0.660811,-8.6804,11.1774,-13.15> }}
union{cone{<-9.57844,11.9475,-14.4937> ,0.141943,<-9.82751,13.1819,-15.682> ,0.1296}
sphere{<-9.57844,11.9475,-14.4937> ,0.141943}
texture{txttree matrix <0.980243,0.197796,0,-0.143859,0.712939,-0.686311,-0.13575,0.672751,0.727309,-9.57844,11.9475,-14.4937> }}
union{cone{<-9.82751,13.1819,-15.682> ,0.1296,<-11.2744,16.1245,-16.2981> ,0.12096}
sphere{<-9.82751,13.1819,-15.682> ,0.1296}
texture{txttree matrix <0.897381,0.441257,0,-0.433669,0.881949,-0.184657,-0.0814811,0.165707,0.982803,-9.82751,13.1819,-15.682> }}
union{cone{<-11.2744,16.1245,-16.2981> ,0.12096,<-12.1613,19.163,-16.4904> ,0.11232}
sphere{<-11.2744,16.1245,-16.2981> ,0.12096}
texture{txttree matrix <0.959952,0.280165,0,-0.279649,0.958185,-0.0606477,-0.0169913,0.0582189,0.998159,-11.2744,16.1245,-16.2981> }}
union{cone{<-12.1613,19.163,-16.4904> ,0.11232,<-11.5745,22.0373,-18.126> ,0.10368}
sphere{<-12.1613,19.163,-16.4904> ,0.11232}
texture{txttree matrix <0.979794,-0.200012,0,0.174695,0.855774,-0.486963,0.0973983,0.477123,0.873423,-12.1613,19.163,-16.4904> }}
union{cone{<-11.5745,22.0373,-18.126> ,0.10368,<-12.3836,25.0003,-18.9224> ,0.09504}
sphere{<-11.5745,22.0373,-18.126> ,0.10368}
texture{txttree matrix <0.964682,0.263416,0,-0.254983,0.933801,-0.250997,-0.0661165,0.242132,0.967988,-11.5745,22.0373,-18.126> }}
union{cone{<-12.3836,25.0003,-18.9224> ,0.09504,<-12.2308,27.907,-20.5098> ,0.0864}
sphere{<-12.3836,25.0003,-18.9224> ,0.09504}
texture{txttree matrix <0.998622,-0.0524725,0,0.0460671,0.876719,-0.478792,0.0251234,0.478133,0.877928,-12.3836,25.0003,-18.9224> }}
union{cone{<-12.2308,27.907,-20.5098> ,0.0864,<-12.8308,30.5486,-22.5136> ,0.07776}
sphere{<-12.2308,27.907,-20.5098> ,0.0864}
texture{txttree matrix <0.975167,0.22147,0,-0.178048,0.783976,-0.594711,-0.131711,0.579943,0.80394,-12.2308,27.907,-20.5098> }}
union{cone{<-5.50371,6.91636,-7.08539> ,0.1296,<-5.89692,8.72136,-9.64267> ,0.12096}
sphere{<-5.50371,6.91636,-7.08539> ,0.1296}
texture{txttree matrix <0.977084,0.212855,0,-0.124643,0.572155,-0.810619,-0.172544,0.792042,0.585574,-5.50371,6.91636,-7.08539> }}
union{cone{<-5.89692,8.72136,-9.64267> ,0.12096,<-5.1757,10.8576,-11.8691> ,0.11232}
sphere{<-5.89692,8.72136,-9.64267> ,0.12096}
texture{txttree matrix <0.94746,-0.319874,0,0.227606,0.674165,-0.702635,0.224755,0.665719,0.71155,-5.89692,8.72136,-9.64267> }}
union{cone{<-5.1757,10.8576,-11.8691> ,0.11232,<-4.91132,12.8576,-14.3793> ,0.10368}
sphere{<-5.1757,10.8576,-11.8691> ,0.11232}
texture{txttree matrix <0.991376,-0.131046,0,0.0820936,0.621047,-0.779462,0.102145,0.77274,0.62645,-5.1757,10.8576,-11.8691> }}
union{cone{<-4.91132,12.8576,-14.3793> ,0.10368,<-4.82444,15.8956,-15.7554> ,0.09504}
sphere{<-4.91132,12.8576,-14.3793> ,0.10368}
texture{txttree matrix <0.999591,-0.0285886,0,0.0260434,0.910598,-0.412473,0.011792,0.412304,0.91097,-4.91132,12.8576,-14.3793> }}
union{cone{<-4.82444,15.8956,-15.7554> ,0.09504,<-5.29329,18.2618,-17.8301> ,0.0864}
sphere{<-4.82444,15.8956,-15.7554> ,0.09504}
texture{txttree matrix <0.98093,0.194361,0,-0.147358,0.74371,-0.652059,-0.126735,0.639625,0.758168,-4.82444,15.8956,-15.7554> }}
union{cone{<-5.29329,18.2618,-17.8301> ,0.0864,<-5.88773,21.112,-19.4823> ,0.07776}
sphere{<-5.29329,18.2618,-17.8301> ,0.0864}
texture{txttree matrix <0.978935,0.204174,0,-0.177574,0.851399,-0.493547,-0.100769,0.48315,0.869719,-5.29329,18.2618,-17.8301> }}
union{cone{<-6.21077,8.31682,-8.9552> ,0.1296,<-6.20957,8.11851,-12.217> ,0.12096}
sphere{<-6.21077,8.31682,-8.9552> ,0.1296}
texture{txttree matrix <-0.999982,-0.00604164,0,0.000366646,-0.0606854,-0.998157,0.0060305,-0.998139,0.0606866,-6.21077,8.31682,-8.9552> }}
union{cone{<-6.20957,8.11851,-12.217> ,0.12096,<-5.95666,8.83521,-15.3926> ,0.11232}
sphere{<-6.20957,8.11851,-12.217> ,0.12096}
texture{txttree matrix <0.943007,-0.332772,0,0.0774551,0.219492,-0.972535,0.323632,0.917107,0.232757,-6.20957,8.11851,-12.217> }}
union{cone{<-5.95666,8.83521,-15.3926> ,0.11232,<-7.66678,9.67472,-18.1571> ,0.10368}
sphere{<-5.95666,8.83521,-15.3926> ,0.11232}
texture{txttree matrix <0.440672,0.897668,0,-0.509363,0.25005,-0.823422,-0.73916,0.362859,0.567429,-5.95666,8.83521,-15.3926> }}
union{cone{<-7.66678,9.67472,-18.1571> ,0.10368,<-9.10203,10.4675,-21.1002> ,0.09504}
sphere{<-7.66678,9.67472,-18.1571> ,0.10368}
texture{txttree matrix <0.483489,0.87535,0,-0.426026,0.23531,-0.873574,-0.764683,0.422363,0.486692,-7.66678,9.67472,-18.1571> }}
union{cone{<-9.10203,10.4675,-21.1002> ,0.09504,<-10.159,12.133,-23.6146> ,0.0864}
sphere{<-9.10203,10.4675,-21.1002> ,0.09504}
texture{txttree matrix <0.844325,0.535832,0,-0.330733,0.521146,-0.78678,-0.421582,0.664298,0.617234,-9.10203,10.4675,-21.1002> }}
union{cone{<-10.159,12.133,-23.6146> ,0.0864,<-11.3402,12.9783,-26.5489> ,0.07776}
sphere{<-10.159,12.133,-23.6146> ,0.0864}
texture{txttree matrix <0.581961,0.813217,0,-0.360768,0.258176,-0.89621,-0.728813,0.521559,0.443631,-10.159,12.133,-23.6146> }}
union{cone{<-8.11437,10.3676,-11.5301> ,0.1296,<-10.8143,10.7006,-13.4694> ,0.12096}
sphere{<-8.11437,10.3676,-11.5301> ,0.1296}
texture{txttree matrix <0.122384,0.992483,0,-0.808166,0.0996557,-0.580462,-0.576099,0.0710393,0.814287,-8.11437,10.3676,-11.5301> }}
union{cone{<-10.8143,10.7006,-13.4694> ,0.12096,<-14.0453,10.8816,-14.518> ,0.11232}
sphere{<-10.8143,10.7006,-13.4694> ,0.12096}
texture{txttree matrix <0.0559574,0.998433,0,-0.94981,0.0532323,-0.308264,-0.307781,0.0172496,0.951301,-10.8143,10.7006,-13.4694> }}
union{cone{<-14.0453,10.8816,-14.518> ,0.11232,<-16.3128,12.2992,-16.3259> ,0.10368}
sphere{<-14.0453,10.8816,-14.518> ,0.11232}
texture{txttree matrix <0.530101,0.847934,0,-0.70246,0.439155,-0.560083,-0.474914,0.296901,0.828436,-14.0453,10.8816,-14.518> }}
union{cone{<-16.3128,12.2992,-16.3259> ,0.10368,<-19.1151,13.003,-17.9942> ,0.09504}
sphere{<-16.3128,12.2992,-16.3259> ,0.10368}
texture{txttree matrix <0.243571,0.969883,0,-0.839917,0.210932,-0.500047,-0.484987,0.121797,0.865998,-16.3128,12.2992,-16.3259> }}
union{cone{<-19.1151,13.003,-17.9942> ,0.09504,<-21.1683,14.663,-20.1843> ,0.0864}
sphere{<-19.1151,13.003,-17.9942> ,0.09504}
texture{txttree matrix <0.628698,0.777649,0,-0.598551,0.483905,-0.638414,-0.496462,0.40137,0.769693,-19.1151,13.003,-17.9942> }}
union{cone{<-21.1683,14.663,-20.1843> ,0.0864,<-23.0703,16.0741,-22.3432> ,0.07776}
sphere{<-21.1683,14.663,-20.1843> ,0.0864}
texture{txttree matrix <0.595851,0.803095,0,-0.593495,0.44034,-0.673694,-0.54104,0.401421,0.73901,-21.1683,14.663,-20.1843> }}
union{cone{<-3.54585,3.71508,-4.94092> ,0.216,<-4.49847,5.02103,-5.46849> ,0.203657}
sphere{<-3.54585,3.71508,-4.94092> ,0.216}
texture{txttree matrix <0.807899,0.589321,0,-0.560238,0.76803,-0.310265,-0.182845,0.250663,0.95065,-3.54585,3.71508,-4.94092> }}
union{cone{<-4.49847,5.02103,-5.46849> ,0.203657,<-6.0345,5.95202,-5.44026> ,0.191314}
sphere{<-4.49847,5.02103,-5.46849> ,0.203657}
texture{txttree matrix <0.51833,0.855181,0,-0.855075,0.518266,0.0157124,0.0134369,-0.00814419,0.999877,-4.49847,5.02103,-5.46849> }}
union{cone{<-6.0345,5.95202,-5.44026> ,0.191314,<-7.08993,7.3547,-5.56103> ,0.178971}
sphere{<-6.0345,5.95202,-5.44026> ,0.191314}
texture{txttree matrix <0.799063,0.601247,0,-0.599829,0.797179,-0.0686373,-0.041268,0.0548455,0.997642,-6.0345,5.95202,-5.44026> }}
union{cone{<-7.08993,7.3547,-5.56103> ,0.178971,<-8.02232,8.67192,-6.21736> ,0.166629}
sphere{<-7.08993,7.3547,-5.56103> ,0.178971}
texture{txttree matrix <0.81621,0.577755,0,-0.535188,0.756075,-0.376728,-0.217656,0.307489,0.926324,-7.08993,7.3547,-5.56103> }}
union{cone{<-8.02232,8.67192,-6.21736> ,0.166629,<-8.74169,9.93178,-7.27758> ,0.154286}
sphere{<-8.02232,8.67192,-6.21736> ,0.166629}
texture{txttree matrix <0.868408,0.495851,0,-0.40034,0.701135,-0.590032,-0.292568,0.512388,0.80738,-8.02232,8.67192,-6.21736> }}
union{cone{<-8.74169,9.93178,-7.27758> ,0.154286,<-9.87217,11.2792,-7.77495> ,0.141943}
sphere{<-8.74169,9.93178,-7.27758> ,0.154286}
texture{txttree matrix <0.766073,0.642754,0,-0.618499,0.737165,-0.272115,-0.174903,0.20846,0.962265,-8.74169,9.93178,-7.27758> }}
union{cone{<-9.87217,11.2792,-7.77495> ,0.141943,<-10.5542,12.397,-8.91873> ,0.1296}
sphere{<-9.87217,11.2792,-7.77495> ,0.141943}
texture{txttree matrix <0.853637,0.520869,0,-0.392293,0.642917,-0.657848,-0.342653,0.561563,0.753151,-9.87217,11.2792,-7.77495> }}
union{cone{<-10.5542,12.397,-8.91873> ,0.1296,<-12.9613,14.7529,-8.86894> ,0.12096}
sphere{<-10.5542,12.397,-8.91873> ,0.1296}
texture{txttree matrix <0.699479,0.714653,0,-0.714575,0.699403,0.0147831,0.0105648,-0.0103405,0.999891,-10.5542,12.397,-8.91873> }}
union{cone{<-12.9613,14.7529,-8.86894> ,0.12096,<-13.2402,17.6151,-10.0844> ,0.11232}
sphere{<-12.9613,14.7529,-8.86894> ,0.12096}
texture{txttree matrix <0.995285,0.0969973,0,-0.0893446,0.916761,-0.389316,-0.0377625,0.38748,0.921104,-12.9613,14.7529,-8.86894> }}
union{cone{<-13.2402,17.6151,-10.0844> ,0.11232,<-14.0729,20.7496,-10.6225> ,0.10368}
sphere{<-13.2402,17.6151,-10.0844> ,0.11232}
texture{txttree matrix <0.966474,0.256766,0,-0.253303,0.95344,-0.163677,-0.0420266,0.15819,0.986514,-13.2402,17.6151,-10.0844> }}
union{cone{<-14.0729,20.7496,-10.6225> ,0.10368,<-14.5468,23.9371,-11.7594> ,0.09504}
sphere{<-14.0729,20.7496,-10.6225> ,0.10368}
texture{txttree matrix <0.989128,0.147057,0,-0.13868,0.932784,-0.332689,-0.0489243,0.329072,0.943037,-14.0729,20.7496,-10.6225> }}
union{cone{<-14.5468,23.9371,-11.7594> ,0.09504,<-15.0992,26.4087,-13.9934> ,0.0864}
sphere{<-14.5468,23.9371,-11.7594> ,0.09504}
texture{txttree matrix <0.975927,0.218099,0,-0.163559,0.731879,-0.661514,-0.144275,0.64559,0.749933,-14.5468,23.9371,-11.7594> }}
union{cone{<-15.0992,26.4087,-13.9934> ,0.0864,<-15.4758,29.1435,-15.5109> ,0.07776}
sphere{<-15.0992,26.4087,-13.9934> ,0.0864}
texture{txttree matrix <0.990649,0.136437,0,-0.119563,0.868132,-0.481717,-0.0657238,0.477212,0.876327,-15.0992,26.4087,-13.9934> }}
union{cone{<-4.75435,5.17612,-5.46379> ,0.1296,<-7.17776,7.13316,-5.35942> ,0.12096}
sphere{<-4.75435,5.17612,-5.46379> ,0.1296}
texture{txttree matrix <0.628274,0.777992,0,-0.777556,0.627921,0.0334855,0.0260514,-0.021038,0.999439,-4.75435,5.17612,-5.46379> }}
union{cone{<-7.17776,7.13316,-5.35942> ,0.12096,<-9.35786,9.48119,-6.41709> ,0.11232}
sphere{<-7.17776,7.13316,-5.35942> ,0.12096}
texture{txttree matrix <0.732826,0.680416,0,-0.646123,0.695892,-0.313463,-0.213285,0.229714,0.9496,-7.17776,7.13316,-5.35942> }}
union{cone{<-9.35786,9.48119,-6.41709> ,0.11232,<-10.6891,12.3987,-5.93475> ,0.10368}
sphere{<-9.35786,9.48119,-6.41709> ,0.11232}
texture{txttree matrix <0.909771,0.41511,0,-0.410493,0.899652,0.148736,0.0617418,-0.135316,0.988877,-9.35786,9.48119,-6.41709> }}
union{cone{<-10.6891,12.3987,-5.93475> ,0.10368,<-11.8313,15.4345,-5.77705> ,0.09504}
sphere{<-10.6891,12.3987,-5.93475> ,0.10368}
texture{txttree matrix <0.935939,0.352163,0,-0.351747,0.934835,0.0485615,0.0171016,-0.0454506,0.99882,-10.6891,12.3987,-5.93475> }}
union{cone{<-11.8313,15.4345,-5.77705> ,0.09504,<-13.5268,18.2761,-5.74237> ,0.0864}
sphere{<-11.8313,15.4345,-5.77705> ,0.09504}
texture{txttree matrix <0.858761,0.512376,0,-0.512348,0.858714,0.0104808,0.0053701,-0.00900048,0.999945,-11.8313,15.4345,-5.77705> }}
union{cone{<-13.5268,18.2761,-5.74237> ,0.0864,<-14.4969,21.3239,-6.30396> ,0.07776}
sphere{<-13.5268,18.2761,-5.74237> ,0.0864}
texture{txttree matrix <0.952893,0.303306,0,-0.298736,0.938536,-0.172934,-0.0524521,0.164788,0.984933,-13.5268,18.2761,-5.74237> }}
union{cone{<-8.04713,8.71536,-6.25392> ,0.1296,<-9.61776,10.8092,-8.39735> ,0.12096}
sphere{<-8.04713,8.71536,-6.25392> ,0.1296}
texture{txttree matrix <0.799955,0.60006,0,-0.464258,0.618914,-0.63357,-0.38018,0.506827,0.773686,-8.04713,8.71536,-6.25392> }}
union{cone{<-9.61776,10.8092,-8.39735> ,0.12096,<-10.3959,12.4464,-11.1478> ,0.11232}
sphere{<-9.61776,10.8092,-8.39735> ,0.12096}
texture{txttree matrix <0.90317,0.429283,0,-0.23623,0.497005,-0.834974,-0.35844,0.754124,0.55029,-9.61776,10.8092,-8.39735> }}
union{cone{<-10.3959,12.4464,-11.1478> ,0.11232,<-9.84088,14.014,-13.8027> ,0.10368}
sphere{<-10.3959,12.4464,-11.1478> ,0.11232}
texture{txttree matrix <0.942654,-0.333773,0,0.177179,0.500395,-0.847474,0.282864,0.798875,0.530836,-10.3959,12.4464,-11.1478> }}
union{cone{<-9.84088,14.014,-13.8027> ,0.10368,<-9.7361,15.5421,-16.5524> ,0.09504}
sphere{<-9.84088,14.014,-13.8027> ,0.10368}
texture{txttree matrix <0.997658,-0.0684038,0,0.0332874,0.48549,-0.873608,0.0597582,0.871562,0.48663,-9.84088,14.014,-13.8027> }}
union{cone{<-9.7361,15.5421,-16.5524> ,0.09504,<-9.6061,17.4789,-19.0827> ,0.0864}
sphere{<-9.7361,15.5421,-16.5524> ,0.09504}
texture{txttree matrix <0.997755,-0.0669729,0,0.040766,0.607327,-0.793405,0.0531366,0.791624,0.608694,-9.7361,15.5421,-16.5524> }}
union{cone{<-9.6061,17.4789,-19.0827> ,0.0864,<-9.34753,20.0218,-21.2247> ,0.07776}
sphere{<-9.6061,17.4789,-19.0827> ,0.0864}
texture{txttree matrix <0.99487,-0.101158,0,0.0775326,0.762516,-0.642307,0.0649748,0.639012,0.766447,-9.6061,17.4789,-19.0827> }}
union{cone{<-8.61008,9.70129,-7.08362> ,0.1296,<-9.75915,9.76937,-10.1119> ,0.12096}
sphere{<-8.61008,9.70129,-7.08362> ,0.1296}
texture{txttree matrix <0.0591443,0.998249,0,-0.354682,0.0210142,-0.934751,-0.933115,0.0552852,0.355304,-8.61008,9.70129,-7.08362> }}
union{cone{<-9.75915,9.76937,-10.1119> ,0.12096,<-10.7527,11.4284,-12.9268> ,0.11232}
sphere{<-9.75915,9.76937,-10.1119> ,0.12096}
texture{txttree matrix <0.857909,0.513802,0,-0.290936,0.485784,-0.824239,-0.423495,0.707122,0.566242,-9.75915,9.76937,-10.1119> }}
union{cone{<-10.7527,11.4284,-12.9268> ,0.11232,<-12.0635,12.0986,-15.8301> ,0.10368}
sphere{<-10.7527,11.4284,-12.9268> ,0.11232}
texture{txttree matrix <0.455241,0.890368,0,-0.402675,0.205886,-0.891888,-0.794109,0.406024,0.452257,-10.7527,11.4284,-12.9268> }}
union{cone{<-12.0635,12.0986,-15.8301> ,0.10368,<-13.8908,13.1908,-18.2895> ,0.09504}
sphere{<-12.0635,12.0986,-15.8301> ,0.10368}
texture{txttree matrix <0.513069,0.858347,0,-0.561761,0.335787,-0.75609,-0.648987,0.387926,0.654468,-12.0635,12.0986,-15.8301> }}
union{cone{<-13.8908,13.1908,-18.2895> ,0.09504,<-14.3499,14.4954,-21.3583> ,0.0864}
sphere{<-13.8908,13.1908,-18.2895> ,0.09504}
texture{txttree matrix <0.943301,0.331939,0,-0.136379,0.387561,-0.9117,-0.302629,0.860008,0.410856,-13.8908,13.1908,-18.2895> }}
union{cone{<-14.3499,14.4954,-21.3583> ,0.0864,<-15.3884,16.0796,-23.9113> ,0.07776}
sphere{<-14.3499,14.4954,-21.3583> ,0.0864}
texture{txttree matrix <0.83631,0.548256,0,-0.326691,0.498334,-0.803079,-0.440293,0.671623,0.595872,-14.3499,14.4954,-21.3583> }}
union{cone{<-3.95089,4.27035,-5.16524> ,0.1296,<-5.85182,6.7014,-4.74909> ,0.12096}
sphere{<-3.95089,4.27035,-5.16524> ,0.1296}
texture{txttree matrix <0.787762,0.61598,0,-0.610455,0.780696,0.133639,0.082319,-0.105276,0.99103,-3.95089,4.27035,-5.16524> }}
union{cone{<-5.85182,6.7014,-4.74909> ,0.12096,<-8.70844,7.90327,-5.99735> ,0.11232}
sphere{<-5.85182,6.7014,-4.74909> ,0.12096}
texture{txttree matrix <0.387806,0.921741,0,-0.854995,0.359724,-0.373608,-0.34437,0.144887,0.927587,-5.85182,6.7014,-4.74909> }}
union{cone{<-8.70844,7.90327,-5.99735> ,0.11232,<-10.0661,10.7631,-6.94562> ,0.10368}
sphere{<-8.70844,7.90327,-5.99735> ,0.11232}
texture{txttree matrix <0.90337,0.428863,0,-0.410827,0.865379,-0.286949,-0.123061,0.259221,0.957946,-8.70844,7.90327,-5.99735> }}
union{cone{<-10.0661,10.7631,-6.94562> ,0.10368,<-11.8179,12.7794,-9.04779> ,0.09504}
sphere{<-10.0661,10.7631,-6.94562> ,0.10368}
texture{txttree matrix <0.754888,0.655854,0,-0.515378,0.5932,-0.618465,-0.405623,0.466872,0.785812,-10.0661,10.7631,-6.94562> }}
union{cone{<-11.8179,12.7794,-9.04779> ,0.09504,<-14.1322,14.856,-10.0592> ,0.0864}
sphere{<-11.8179,12.7794,-9.04779> ,0.09504}
texture{txttree matrix <0.667852,0.744294,0,-0.707796,0.635102,-0.309305,-0.230214,0.20657,0.950963,-11.8179,12.7794,-9.04779> }}
union{cone{<-14.1322,14.856,-10.0592> ,0.0864,<-14.9758,17.5953,-11.539> ,0.07776}
sphere{<-14.1322,14.856,-10.0592> ,0.0864}
texture{txttree matrix <0.955712,0.294305,0,-0.261509,0.849212,-0.45875,-0.135012,0.438433,0.888565,-14.1322,14.856,-10.0592> }}
union{cone{<-1.28275,1.43499,-2.19055> ,0.36,<-1.74814,2.19988,-2.57626> ,0.342}
sphere{<-1.28275,1.43499,-2.19055> ,0.36}
texture{txttree matrix <0.854293,0.519791,0,-0.477379,0.784589,-0.395638,-0.205649,0.337991,0.918407,-1.28275,1.43499,-2.19055> }}
union{cone{<-1.74814,2.19988,-2.57626> ,0.342,<-2.58391,2.58658,-2.79085> ,0.324}
sphere{<-1.74814,2.19988,-2.57626> ,0.342}
texture{txttree matrix <0.419921,0.907561,0,-0.883879,0.408964,-0.226949,-0.20597,0.0953005,0.973907,-1.74814,2.19988,-2.57626> }}
union{cone{<-2.58391,2.58658,-2.79085> ,0.324,<-3.39395,3.0263,-3.04279> ,0.306}
sphere{<-2.58391,2.58658,-2.79085> ,0.324}
texture{txttree matrix <0.477077,0.878861,0,-0.84776,0.460194,-0.263673,-0.231732,0.125792,0.964612,-2.58391,2.58658,-2.79085> }}
union{cone{<-3.39395,3.0263,-3.04279> ,0.306,<-3.72158,3.75719,-3.51225> ,0.288}
sphere{<-3.39395,3.0263,-3.04279> ,0.306}
texture{txttree matrix <0.912511,0.409053,0,-0.352903,0.787253,-0.505661,-0.206842,0.461421,0.862732,-3.39395,3.0263,-3.04279> }}
union{cone{<-3.72158,3.75719,-3.51225> ,0.288,<-4.25319,4.38672,-3.99388> ,0.27}
sphere{<-3.72158,3.75719,-3.51225> ,0.288}
texture{txttree matrix <0.764023,0.645189,0,-0.557012,0.659605,-0.504638,-0.325587,0.385555,0.863331,-3.72158,3.75719,-3.51225> }}
union{cone{<-4.25319,4.38672,-3.99388> ,0.27,<-4.71431,4.84889,-4.67312> ,0.252}
sphere{<-4.25319,4.38672,-3.99388> ,0.27}
texture{txttree matrix <0.707918,0.706294,0,-0.489441,0.490566,-0.720966,-0.509214,0.510385,0.69297,-4.25319,4.38672,-3.99388> }}
union{cone{<-4.71431,4.84889,-4.67312> ,0.252,<-5.32564,5.45051,-5.07204> ,0.234}
sphere{<-4.71431,4.84889,-4.67312> ,0.252}
texture{txttree matrix <0.701425,0.712743,0,-0.646261,0.635999,-0.421725,-0.300581,0.295808,0.906724,-4.71431,4.84889,-4.67312> }}
union{cone{<-5.32564,5.45051,-5.07204> ,0.234,<-5.69559,6.02674,-5.68043> ,0.216}
sphere{<-5.32564,5.45051,-5.07204> ,0.234}
texture{txttree matrix <0.841498,0.54026,0,-0.403881,0.629077,-0.664185,-0.358833,0.55891,0.747568,-5.32564,5.45051,-5.07204> }}
union{cone{<-5.69559,6.02674,-5.68043> ,0.216,<-6.37012,7.68979,-5.84915> ,0.203657}
sphere{<-5.69559,6.02674,-5.68043> ,0.216}
texture{txttree matrix <0.926676,0.375861,0,-0.374211,0.922608,-0.0935967,-0.0351793,0.0867338,0.99561,-5.69559,6.02674,-5.68043> }}
union{cone{<-6.37012,7.68979,-5.84915> ,0.203657,<-6.99895,9.26549,-6.18184> ,0.191314}
sphere{<-6.37012,7.68979,-5.84915> ,0.203657}
texture{txttree matrix <0.928772,0.370652,0,-0.363725,0.911413,-0.192435,-0.0713264,0.178728,0.98131,-6.37012,7.68979,-5.84915> }}
union{cone{<-6.99895,9.26549,-6.18184> ,0.191314,<-7.96638,10.6657,-6.34431> ,0.178971}
sphere{<-6.99895,9.26549,-6.18184> ,0.191314}
texture{txttree matrix <0.822736,0.568424,0,-0.565851,0.819012,-0.0950331,-0.0540191,0.0781872,0.995474,-6.99895,9.26549,-6.18184> }}
union{cone{<-7.96638,10.6657,-6.34431> ,0.178971,<-9.11723,12.0219,-6.62619> ,0.166629}
sphere{<-7.96638,10.6657,-6.34431> ,0.178971}
texture{txttree matrix <0.762462,0.647033,0,-0.639058,0.753064,-0.156524,-0.101276,0.119343,0.987674,-7.96638,10.6657,-6.34431> }}
union{cone{<-9.11723,12.0219,-6.62619> ,0.166629,<-10.2263,13.3312,-7.17546> ,0.154286}
sphere{<-9.11723,12.0219,-6.62619> ,0.166629}
texture{txttree matrix <0.763036,0.646356,0,-0.615585,0.72671,-0.304872,-0.197056,0.232628,0.952393,-9.11723,12.0219,-6.62619> }}
union{cone{<-10.2263,13.3312,-7.17546> ,0.154286,<-10.9465,14.7436,-7.74476> ,0.141943}
sphere{<-10.2263,13.3312,-7.17546> ,0.154286}
texture{txttree matrix <0.890871,0.454257,0,-0.427531,0.838457,-0.337946,-0.153514,0.301066,0.941166,-10.2263,13.3312,-7.17546> }}
union{cone{<-10.9465,14.7436,-7.74476> ,0.141943,<-11.5197,16.3878,-8.21658> ,0.1296}
sphere{<-10.9465,14.7436,-7.74476> ,0.141943}
texture{txttree matrix <0.944267,0.329181,0,-0.317723,0.9114,-0.261538,-0.0860933,0.246962,0.965193,-10.9465,14.7436,-7.74476> }}
union{cone{<-11.5197,16.3878,-8.21658> ,0.1296,<-12.9937,19.3911,-7.4471> ,0.12096}
sphere{<-11.5197,16.3878,-8.21658> ,0.1296}
texture{txttree matrix <0.897704,0.4406,0,-0.429389,0.874862,0.224147,0.0987593,-0.201218,0.974555,-11.5197,16.3878,-8.21658> }}
union{cone{<-12.9937,19.3911,-7.4471> ,0.12096,<-15.0602,22.1268,-7.20334> ,0.11232}
sphere{<-12.9937,19.3911,-7.4471> ,0.12096}
texture{txttree matrix <0.797929,0.602752,0,-0.601234,0.795919,0.0709206,0.0427475,-0.0565896,0.997482,-12.9937,19.3911,-7.4471> }}
union{cone{<-15.0602,22.1268,-7.20334> ,0.11232,<-16.6465,24.8988,-6.81127> ,0.10368}
sphere{<-15.0602,22.1268,-7.20334> ,0.11232}
texture{txttree matrix <0.867941,0.496666,0,-0.492966,0.861475,0.121843,0.0605152,-0.105752,0.992549,-15.0602,22.1268,-7.20334> }}
union{cone{<-16.6465,24.8988,-6.81127> ,0.10368,<-16.7322,27.8957,-7.84888> ,0.09504}
sphere{<-16.6465,24.8988,-6.81127> ,0.10368}
texture{txttree matrix <0.999592,0.0285791,0,-0.0270074,0.944619,-0.327055,-0.00934695,0.326921,0.945005,-16.6465,24.8988,-6.81127> }}
union{cone{<-16.7322,27.8957,-7.84888> ,0.09504,<-16.8982,31.0729,-9.10393> ,0.0864}
sphere{<-16.7322,27.8957,-7.84888> ,0.09504}
texture{txttree matrix <0.998638,0.0521767,0,-0.0485367,0.92897,-0.366959,-0.0191467,0.366459,0.930237,-16.7322,27.8957,-7.84888> }}
union{cone{<-16.8982,31.0729,-9.10393> ,0.0864,<-17.9018,34.1445,-9.48777> ,0.07776}
sphere{<-16.8982,31.0729,-9.10393> ,0.0864}
texture{txttree matrix <0.950551,0.310567,0,-0.308399,0.943916,-0.117952,-0.0366321,0.11212,0.993019,-16.8982,31.0729,-9.10393> }}
union{cone{<-5.97362,6.71223,-5.74997> ,0.1296,<-6.72284,9.81604,-5.8445> ,0.12096}
sphere{<-5.97362,6.71223,-5.74997> ,0.1296}
texture{txttree matrix <0.972081,0.234647,0,-0.234544,0.971655,-0.0295903,-0.00694328,0.0287642,0.999562,-5.97362,6.71223,-5.74997> }}
union{cone{<-6.72284,9.81604,-5.8445> ,0.12096,<-7.52209,12.7913,-6.74843> ,0.11232}
sphere{<-6.72284,9.81604,-5.8445> ,0.12096}
texture{txttree matrix <0.965762,0.25943,0,-0.248936,0.926695,-0.281543,-0.0730409,0.271904,0.959549,-6.72284,9.81604,-5.8445> }}
union{cone{<-7.52209,12.7913,-6.74843> ,0.11232,<-8.67908,15.7157,-7.13806> ,0.10368}
sphere{<-7.52209,12.7913,-6.74843> ,0.11232}
texture{txttree matrix <0.929866,0.367898,0,-0.365107,0.922811,-0.122953,-0.0452343,0.11433,0.992412,-7.52209,12.7913,-6.74843> }}
union{cone{<-8.67908,15.7157,-7.13806> ,0.10368,<-8.79745,18.9093,-8.15141> ,0.09504}
sphere{<-8.67908,15.7157,-7.13806> ,0.10368}
texture{txttree matrix <0.999314,0.0370379,0,-0.0353056,0.952573,-0.302255,-0.0111949,0.302048,0.953227,-8.67908,15.7157,-7.13806> }}
union{cone{<-8.79745,18.9093,-8.15141> ,0.09504,<-8.44016,21.9693,-9.4941> ,0.0864}
sphere{<-8.79745,18.9093,-8.15141> ,0.09504}
texture{txttree matrix <0.993252,-0.115973,0,0.106314,0.910534,-0.399532,0.0463347,0.396836,0.916719,-8.79745,18.9093,-8.15141> }}
union{cone{<-8.44016,21.9693,-9.4941> ,0.0864,<-9.02305,24.904,-10.5177> ,0.07776}
sphere{<-8.44016,21.9693,-9.4941> ,0.0864}
texture{txttree matrix <0.980841,0.194812,0,-0.184325,0.92804,-0.323677,-0.0630561,0.317476,0.946168,-8.44016,21.9693,-9.4941> }}
union{cone{<-7.16691,9.50859,-6.21005> ,0.1296,<-9.69584,10.497,-7.93445> ,0.12096}
sphere{<-7.16691,9.50859,-6.21005> ,0.1296}
texture{txttree matrix <0.364014,0.931394,0,-0.786234,0.307281,-0.536111,-0.49933,0.195152,0.844148,-7.16691,9.50859,-6.21005> }}
union{cone{<-9.69584,10.497,-7.93445> ,0.12096,<-10.8184,13.3023,-9.45552> ,0.11232}
sphere{<-9.69584,10.497,-7.93445> ,0.12096}
texture{txttree matrix <0.92843,0.371508,0,-0.331833,0.829279,-0.449647,-0.167048,0.417466,0.893206,-9.69584,10.497,-7.93445> }}
union{cone{<-10.8184,13.3023,-9.45552> ,0.11232,<-13.0758,15.4301,-10.0592> ,0.10368}
sphere{<-10.8184,13.3023,-9.45552> ,0.11232}
texture{txttree matrix <0.685923,0.727674,0,-0.714276,0.673294,-0.191011,-0.138994,0.131019,0.981588,-10.8184,13.3023,-9.45552> }}
union{cone{<-13.0758,15.4301,-10.0592> ,0.10368,<-14.5071,17.2655,-12.5> ,0.09504}
sphere{<-13.0758,15.4301,-10.0592> ,0.10368}
texture{txttree matrix <0.788546,0.614976,0,-0.424398,0.544179,-0.723709,-0.445064,0.570678,0.690105,-13.0758,15.4301,-10.0592> }}
union{cone{<-14.5071,17.2655,-12.5> ,0.09504,<-15.1572,19.9281,-14.4264> ,0.0864}
sphere{<-14.5071,17.2655,-12.5> ,0.09504}
texture{txttree matrix <0.971467,0.237174,0,-0.194043,0.794801,-0.575011,-0.136378,0.558605,0.818145,-14.5071,17.2655,-12.5> }}
union{cone{<-15.1572,19.9281,-14.4264> ,0.0864,<-16.5467,21.9469,-16.7962> ,0.07776}
sphere{<-15.1572,19.9281,-14.4264> ,0.0864}
texture{txttree matrix <0.823728,0.566985,0,-0.407591,0.592157,-0.69514,-0.394134,0.572607,0.718874,-15.1572,19.9281,-14.4264> }}
union{cone{<-8.34774,11.1151,-6.43772> ,0.1296,<-11.1458,12.6028,-5.89263> ,0.12096}
sphere{<-8.34774,11.1151,-6.43772> ,0.1296}
texture{txttree matrix <0.469446,0.882961,0,-0.870182,0.462651,0.16952,0.149679,-0.0795804,0.985527,-8.34774,11.1151,-6.43772> }}
union{cone{<-11.1458,12.6028,-5.89263> ,0.12096,<-13.702,14.7187,-5.33166> ,0.11232}
sphere{<-11.1458,12.6028,-5.89263> ,0.12096}
texture{txttree matrix <0.637651,0.770325,0,-0.759548,0.628731,0.166688,0.128404,-0.106289,0.98601,-11.1458,12.6028,-5.89263> }}
union{cone{<-13.702,14.7187,-5.33166> ,0.11232,<-15.6161,17.5249,-5.6007> ,0.10368}
sphere{<-13.702,14.7187,-5.33166> ,0.11232}
texture{txttree matrix <0.826116,0.563501,0,-0.561741,0.823537,-0.0789581,-0.044493,0.0652286,0.996878,-13.702,14.7187,-5.33166> }}
union{cone{<-15.6161,17.5249,-5.6007> ,0.10368,<-17.3094,20.4208,-6.15309> ,0.09504}
sphere{<-15.6161,17.5249,-5.6007> ,0.10368}
texture{txttree matrix <0.863256,0.504766,0,-0.498059,0.851786,-0.162474,-0.0820112,0.140257,0.986713,-15.6161,17.5249,-5.6007> }}
union{cone{<-17.3094,20.4208,-6.15309> ,0.09504,<-19.5576,22.3097,-7.56277> ,0.0864}
sphere{<-17.3094,20.4208,-6.15309> ,0.09504}
texture{txttree matrix <0.643272,0.765638,0,-0.690219,0.579907,-0.432788,-0.331359,0.2784,0.901496,-17.3094,20.4208,-6.15309> }}
union{cone{<-19.5576,22.3097,-7.56277> ,0.0864,<-20.9397,24.4267,-9.62025> ,0.07776}
sphere{<-19.5576,22.3097,-7.56277> ,0.0864}
texture{txttree matrix <0.837345,0.546674,0,-0.424013,0.649463,-0.631198,-0.34506,0.528531,0.775622,-19.5576,22.3097,-7.56277> }}
union{cone{<-3.64471,3.5857,-3.4021> ,0.216,<-3.82235,5.40035,-3.49802> ,0.203657}
sphere{<-3.64471,3.5857,-3.4021> ,0.216}
texture{txttree matrix <0.995243,0.097424,0,-0.0972894,0.993869,-0.0525332,-0.00511799,0.0522833,0.998619,-3.64471,3.5857,-3.4021> }}
union{cone{<-3.82235,5.40035,-3.49802> ,0.203657,<-4.02713,7.06929,-3.65868> ,0.191314}
sphere{<-3.82235,5.40035,-3.49802> ,0.203657}
texture{txttree matrix <0.992556,0.121787,0,-0.121234,0.988056,-0.0951173,-0.011584,0.0944093,0.995466,-3.82235,5.40035,-3.49802> }}
union{cone{<-4.02713,7.06929,-3.65868> ,0.191314,<-4.32854,8.69793,-4.41305> ,0.178971}
sphere{<-4.02713,7.06929,-3.65868> ,0.191314}
texture{txttree matrix <0.983302,0.181982,0,-0.165613,0.894858,-0.414489,-0.0754294,0.407568,0.910054,-4.02713,7.06929,-3.65868> }}
union{cone{<-4.32854,8.69793,-4.41305> ,0.178971,<-3.87386,10.4091,-4.83779> ,0.166629}
sphere{<-4.32854,8.69793,-4.41305> ,0.178971}
texture{txttree matrix <0.966465,-0.256799,0,0.249715,0.939802,-0.233268,0.059903,0.225445,0.972413,-4.32854,8.69793,-4.41305> }}
union{cone{<-3.87386,10.4091,-4.83779> ,0.166629,<-3.55125,11.8037,-5.93792> ,0.154286}
sphere{<-3.87386,10.4091,-4.83779> ,0.166629}
texture{txttree matrix <0.974269,-0.225389,0,0.178704,0.772468,-0.609392,0.13735,0.593711,0.792869,-3.87386,10.4091,-4.83779> }}
union{cone{<-3.55125,11.8037,-5.93792> ,0.154286,<-3.47855,13.3206,-6.96922> ,0.141943}
sphere{<-3.55125,11.8037,-5.93792> ,0.154286}
texture{txttree matrix <0.998854,-0.0478644,0,0.0395974,0.826335,-0.561785,0.0268895,0.561141,0.827283,-3.55125,11.8037,-5.93792> }}
union{cone{<-3.47855,13.3206,-6.96922> ,0.141943,<-3.72247,14.7869,-8.05061> ,0.1296}
sphere{<-3.47855,13.3206,-6.96922> ,0.141943}
texture{txttree matrix <0.986445,0.164094,0,-0.132695,0.797689,-0.588289,-0.0965347,0.580315,0.808651,-3.47855,13.3206,-6.96922> }}
union{cone{<-3.72247,14.7869,-8.05061> ,0.1296,<-3.23492,18.1111,-7.99938> ,0.12096}
sphere{<-3.72247,14.7869,-8.05061> ,0.1296}
texture{txttree matrix <0.989415,-0.145116,0,0.145099,0.9893,0.0152467,-0.00221254,-0.0150853,0.999884,-3.72247,14.7869,-8.05061> }}
union{cone{<-3.23492,18.1111,-7.99938> ,0.12096,<-4.7594,21.0347,-8.80245> ,0.11232}
sphere{<-3.23492,18.1111,-7.99938> ,0.12096}
texture{txttree matrix <0.886691,0.462362,0,-0.449229,0.861505,-0.236647,-0.109417,0.209833,0.971596,-3.23492,18.1111,-7.99938> }}
union{cone{<-4.7594,21.0347,-8.80245> ,0.11232,<-5.46579,24.2305,-9.63105> ,0.10368}
sphere{<-4.7594,21.0347,-8.80245> ,0.11232}
texture{txttree matrix <0.976432,0.215826,0,-0.209225,0.946569,-0.245424,-0.0529689,0.239639,0.969416,-4.7594,21.0347,-8.80245> }}
union{cone{<-5.46579,24.2305,-9.63105> ,0.10368,<-5.8886,26.7262,-11.7245> ,0.09504}
sphere{<-5.46579,24.2305,-9.63105> ,0.10368}
texture{txttree matrix <0.985951,0.167033,0,-0.128718,0.759789,-0.637301,-0.10645,0.628348,0.770615,-5.46579,24.2305,-9.63105> }}
union{cone{<-5.8886,26.7262,-11.7245> ,0.09504,<-5.43318,29.5921,-13.4976> ,0.0864}
sphere{<-5.8886,26.7262,-11.7245> ,0.09504}
texture{txttree matrix <0.987608,-0.156939,0,0.133918,0.842733,-0.521409,0.0818295,0.514947,0.853307,-5.8886,26.7262,-11.7245> }}
union{cone{<-5.43318,29.5921,-13.4976> ,0.0864,<-5.29474,32.4206,-15.417> ,0.07776}
sphere{<-5.43318,29.5921,-13.4976> ,0.0864}
texture{txttree matrix <0.998804,-0.0488861,0,0.0404671,0.826793,-0.561048,0.0274274,0.560377,0.827783,-5.43318,29.5921,-13.4976> }}
union{cone{<-4.1688,7.83482,-4.01327> ,0.1296,<-3.43116,10.9401,-4.58165> ,0.12096}
sphere{<-4.1688,7.83482,-4.01327> ,0.1296}
texture{txttree matrix <0.972926,-0.231117,0,0.227538,0.957856,-0.175324,0.0405203,0.170577,0.984511,-4.1688,7.83482,-4.01327> }}
union{cone{<-3.43116,10.9401,-4.58165> ,0.12096,<-3.46898,14.1217,-5.32169> ,0.11232}
sphere{<-3.43116,10.9401,-4.58165> ,0.12096}
texture{txttree matrix <0.999929,0.0118877,0,-0.0115787,0.973933,-0.226538,-0.00269302,0.226522,0.974002,-3.43116,10.9401,-4.58165> }}
union{cone{<-3.46898,14.1217,-5.32169> ,0.11232,<-3.67698,16.8475,-7.39707> ,0.10368}
sphere{<-3.46898,14.1217,-5.32169> ,0.11232}
texture{txttree matrix <0.997101,0.0760854,0,-0.0606009,0.794176,-0.604658,-0.0460057,0.602905,0.796485,-3.46898,14.1217,-5.32169> }}
union{cone{<-3.67698,16.8475,-7.39707> ,0.10368,<-4.12687,19.575,-9.19544> ,0.09504}
sphere{<-3.67698,16.8475,-7.39707> ,0.10368}
texture{txttree matrix <0.986668,0.162748,0,-0.13642,0.827053,-0.545319,-0.0887496,0.538049,0.838228,-3.67698,16.8475,-7.39707> }}
union{cone{<-4.12687,19.575,-9.19544> ,0.09504,<-3.27245,22.6788,-10.2115> ,0.0864}
sphere{<-4.12687,19.575,-9.19544> ,0.09504}
texture{txttree matrix <0.964135,-0.265412,0,0.253105,0.919427,-0.300985,0.0798851,0.29019,0.953629,-4.12687,19.575,-9.19544> }}
union{cone{<-3.27245,22.6788,-10.2115> ,0.0864,<-3.53357,25.6059,-11.3953> ,0.07776}
sphere{<-3.27245,22.6788,-10.2115> ,0.0864}
texture{txttree matrix <0.996045,0.0888551,0,-0.0824194,0.923902,-0.373647,-0.0332004,0.372169,0.927571,-3.27245,22.6788,-10.2115> }}
union{cone{<-3.73504,4.50847,-3.45088> ,0.1296,<-4.14434,7.28093,-5.06399> ,0.12096}
sphere{<-3.73504,4.50847,-3.45088> ,0.1296}
texture{txttree matrix <0.989278,0.146047,0,-0.126577,0.857391,-0.498858,-0.0728569,0.493509,0.866684,-3.73504,4.50847,-3.45088> }}
union{cone{<-4.14434,7.28093,-5.06399> ,0.12096,<-4.67486,10.5309,-5.53398> ,0.11232}
sphere{<-4.14434,7.28093,-5.06399> ,0.12096}
texture{txttree matrix <0.986938,0.161103,0,-0.159487,0.977036,-0.141293,-0.0227627,0.139448,0.989968,-4.14434,7.28093,-5.06399> }}
union{cone{<-4.67486,10.5309,-5.53398> ,0.11232,<-5.31335,13.3563,-7.29444> ,0.10368}
sphere{<-4.67486,10.5309,-5.53398> ,0.11232}
texture{txttree matrix <0.975403,0.220427,0,-0.188367,0.833534,-0.519364,-0.114482,0.506589,0.854553,-4.67486,10.5309,-5.53398> }}
union{cone{<-5.31335,13.3563,-7.29444> ,0.10368,<-5.08139,16.5578,-7.86104> ,0.09504}
sphere{<-5.31335,13.3563,-7.29444> ,0.10368}
texture{txttree matrix <0.997385,-0.0722651,0,0.0711649,0.9822,-0.173833,0.0125621,0.173379,0.984775,-5.31335,13.3563,-7.29444> }}
union{cone{<-5.08139,16.5578,-7.86104> ,0.09504,<-5.33815,19.5276,-9.119> ,0.0864}
sphere{<-5.08139,16.5578,-7.86104> ,0.09504}
texture{txttree matrix <0.996284,0.0861332,0,-0.0793565,0.917899,-0.388798,-0.0334884,0.387353,0.921323,-5.08139,16.5578,-7.86104> }}
union{cone{<-5.33815,19.5276,-9.119> ,0.0864,<-5.7726,22.1726,-11.0173> ,0.07776}
sphere{<-5.33815,19.5276,-9.119> ,0.0864}
texture{txttree matrix <0.986777,0.162084,0,-0.132272,0.80528,-0.577952,-0.0936768,0.57031,0.816071,-5.33815,19.5276,-9.119> }}
union{cone{<-2.78347,2.69491,-2.85292> ,0.216,<-3.30575,3.19157,-4.40671> ,0.203657}
sphere{<-2.78347,2.69491,-2.85292> ,0.216}
texture{txttree matrix <0.689105,0.724662,0,-0.304926,0.289964,-0.907161,-0.657385,0.625129,0.420784,-2.78347,2.69491,-2.85292> }}
union{cone{<-3.30575,3.19157,-4.40671> ,0.203657,<-3.53212,4.35536,-5.77746> ,0.191314}
sphere{<-3.30575,3.19157,-4.40671> ,0.203657}
texture{txttree matrix <0.981603,0.190934,0,-0.124906,0.642147,-0.756337,-0.144411,0.742423,0.654182,-3.30575,3.19157,-4.40671> }}
union{cone{<-3.53212,4.35536,-5.77746> ,0.191314,<-3.61566,5.5055,-7.11175> ,0.178971}
sphere{<-3.53212,4.35536,-5.77746> ,0.191314}
texture{txttree matrix <0.997373,0.0724422,0,-0.0473691,0.65217,-0.756592,-0.0548092,0.754604,0.653888,-3.53212,4.35536,-5.77746> }}
union{cone{<-3.61566,5.5055,-7.11175> ,0.178971,<-4.50163,6.51395,-8.25325> ,0.166629}
sphere{<-3.61566,5.5055,-7.11175> ,0.178971}
texture{txttree matrix <0.751256,0.660011,0,-0.502798,0.572308,-0.647809,-0.427562,0.486671,0.761802,-3.61566,5.5055,-7.11175> }}
union{cone{<-4.50163,6.51395,-8.25325> ,0.166629,<-5.23809,7.91648,-9.18605> ,0.154286}
sphere{<-4.50163,6.51395,-8.25325> ,0.166629}
texture{txttree matrix <0.885365,0.464897,0,-0.400605,0.762924,-0.507408,-0.235893,0.449241,0.861706,-4.50163,6.51395,-8.25325> }}
union{cone{<-5.23809,7.91648,-9.18605> ,0.154286,<-5.3708,8.95118,-10.5321> ,0.141943}
sphere{<-5.23809,7.91648,-9.18605> ,0.154286}
texture{txttree matrix <0.991874,0.127223,0,-0.0779328,0.607593,-0.790416,-0.100559,0.783993,0.61257,-5.23809,7.91648,-9.18605> }}
union{cone{<-5.3708,8.95118,-10.5321> ,0.141943,<-5.79769,10.3849,-11.6088> ,0.1296}
sphere{<-5.3708,8.95118,-10.5321> ,0.141943}
texture{txttree matrix <0.958419,0.285365,0,-0.231613,0.777887,-0.584164,-0.1667,0.559873,0.811636,-5.3708,8.95118,-10.5321> }}
union{cone{<-5.79769,10.3849,-11.6088> ,0.1296,<-6.72637,13.0636,-13.2595> ,0.12096}
sphere{<-5.79769,10.3849,-11.6088> ,0.1296}
texture{txttree matrix <0.94483,0.327561,0,-0.283073,0.816507,-0.503175,-0.164821,0.475415,0.864184,-5.79769,10.3849,-11.6088> }}
union{cone{<-6.72637,13.0636,-13.2595> ,0.12096,<-8.20192,16.0726,-13.5154> ,0.11232}
sphere{<-6.72637,13.0636,-13.2595> ,0.12096}
texture{txttree matrix <0.897856,0.440288,0,-0.439011,0.895251,-0.0761193,-0.0335145,0.0683442,0.997099,-6.72637,13.0636,-13.2595> }}
union{cone{<-8.20192,16.0726,-13.5154> ,0.11232,<-8.36476,18.662,-15.4758> ,0.10368}
sphere{<-8.20192,16.0726,-13.5154> ,0.11232}
texture{txttree matrix <0.998028,0.0627625,0,-0.0500742,0.796262,-0.602876,-0.037838,0.601687,0.797835,-8.20192,16.0726,-13.5154> }}
union{cone{<-8.36476,18.662,-15.4758> ,0.10368,<-8.16888,21.4531,-17.301> ,0.09504}
sphere{<-8.36476,18.662,-15.4758> ,0.10368}
texture{txttree matrix <0.997546,-0.0700071,0,0.0586347,0.835498,-0.546357,0.0382489,0.545016,0.837553,-8.36476,18.662,-15.4758> }}
union{cone{<-8.16888,21.4531,-17.301> ,0.09504,<-8.31436,24.0461,-19.0703> ,0.0864}
sphere{<-8.16888,21.4531,-17.301> ,0.09504}
texture{txttree matrix <0.99843,0.056017,0,-0.0462951,0.825149,-0.563014,-0.0315384,0.56213,0.826447,-8.16888,21.4531,-17.301> }}
union{cone{<-8.31436,24.0461,-19.0703> ,0.0864,<-9.24887,26.4784,-21.279> ,0.07776}
sphere{<-8.31436,24.0461,-19.0703> ,0.0864}
texture{txttree matrix <0.933476,0.358639,0,-0.273578,0.712077,-0.646608,-0.231899,0.603593,0.762823,-8.31436,24.0461,-19.0703> }}
union{cone{<-5.25314,8.03383,-9.33871> ,0.1296,<-7.6036,9.57157,-10.7559> ,0.12096}
sphere{<-5.25314,8.03383,-9.33871> ,0.1296}
texture{txttree matrix <0.547474,0.836823,0,-0.747115,0.488785,-0.450453,-0.37695,0.246611,0.8928,-5.25314,8.03383,-9.33871> }}
union{cone{<-7.6036,9.57157,-10.7559> ,0.12096,<-9.7744,11.2966,-12.4652> ,0.11232}
sphere{<-7.6036,9.57157,-10.7559> ,0.12096}
texture{txttree matrix <0.62214,0.782906,0,-0.666438,0.529589,-0.524781,-0.410854,0.326488,0.851237,-7.6036,9.57157,-10.7559> }}
union{cone{<-9.7744,11.2966,-12.4652> ,0.11232,<-10.7072,13.8831,-14.0501> ,0.10368}
sphere{<-9.7744,11.2966,-12.4652> ,0.11232}
texture{txttree matrix <0.940688,0.339274,0,-0.29394,0.814993,-0.499384,-0.169428,0.469765,0.86638,-9.7744,11.2966,-12.4652> }}
union{cone{<-10.7072,13.8831,-14.0501> ,0.10368,<-11.8175,15.5452,-16.5495> ,0.09504}
sphere{<-10.7072,13.8831,-14.0501> ,0.10368}
texture{txttree matrix <0.831554,0.555444,0,-0.346903,0.519348,-0.780984,-0.433793,0.649431,0.62455,-10.7072,13.8831,-14.0501> }}
union{cone{<-11.8175,15.5452,-16.5495> ,0.09504,<-12.1828,17.764,-18.8203> ,0.0864}
sphere{<-11.8175,15.5452,-16.5495> ,0.09504}
texture{txttree matrix <0.986716,0.162454,0,-0.11431,0.694295,-0.710555,-0.115433,0.701116,0.703642,-11.8175,15.5452,-16.5495> }}
union{cone{<-12.1828,17.764,-18.8203> ,0.0864,<-13.2484,19.4793,-21.264> ,0.07776}
sphere{<-12.1828,17.764,-18.8203> ,0.0864}
texture{txttree matrix <0.849422,0.527713,0,-0.336157,0.541088,-0.770859,-0.406792,0.654785,0.637006,-12.1828,17.764,-18.8203> }}
union{cone{<-2.34228,2.47478,-2.72881> ,0.216,<-3.60942,2.37251,-3.87267> ,0.203657}
sphere{<-2.34228,2.47478,-2.72881> ,0.216}
texture{txttree matrix <-0.0804491,0.996759,0,-0.740964,-0.0598038,-0.668876,-0.666708,-0.0538105,0.743374,-2.34228,2.47478,-2.72881> }}
union{cone{<-3.60942,2.37251,-3.87267> ,0.203657,<-4.60616,2.51034,-5.28351> ,0.191314}
sphere{<-3.60942,2.37251,-3.87267> ,0.203657}
texture{txttree matrix <0.136971,0.990575,0,-0.575185,0.0795334,-0.814148,-0.806474,0.111515,0.580658,-3.60942,2.37251,-3.87267> }}
union{cone{<-4.60616,2.51034,-5.28351> ,0.191314,<-5.96117,3.04165,-6.11731> ,0.178971}
sphere{<-4.60616,2.51034,-5.28351> ,0.191314}
texture{txttree matrix <0.365049,0.930988,0,-0.80782,0.316754,-0.497085,-0.46278,0.181461,0.867702,-4.60616,2.51034,-5.28351> }}
union{cone{<-5.96117,3.04165,-6.11731> ,0.178971,<-7.37237,3.00289,-7.11618> ,0.166629}
sphere{<-5.96117,3.04165,-6.11731> ,0.178971}
texture{txttree matrix <-0.0274557,0.999623,0,-0.816017,-0.0224127,-0.577594,-0.577376,-0.0158582,0.816324,-5.96117,3.04165,-6.11731> }}
union{cone{<-7.37237,3.00289,-7.11618> ,0.166629,<-8.73548,3.0862,-8.27678> ,0.154286}
sphere{<-7.37237,3.00289,-7.11618> ,0.166629}
texture{txttree matrix <0.0610062,0.998137,0,-0.760578,0.0464865,-0.647581,-0.646374,0.0395064,0.761997,-7.37237,3.00289,-7.11618> }}
union{cone{<-8.73548,3.0862,-8.27678> ,0.154286,<-9.37881,3.81697,-9.69359> ,0.141943}
sphere{<-8.73548,3.0862,-8.27678> ,0.154286}
texture{txttree matrix <0.750585,0.660773,0,-0.374227,0.425092,-0.824167,-0.544587,0.618607,0.566347,-8.73548,3.0862,-8.27678> }}
union{cone{<-9.37881,3.81697,-9.69359> ,0.141943,<-10.0197,4.12492,-11.3766> ,0.1296}
sphere{<-9.37881,3.81697,-9.69359> ,0.141943}
texture{txttree matrix <0.433082,0.901354,0,-0.350796,0.16855,-0.921159,-0.83029,0.398937,0.389188,-9.37881,3.81697,-9.69359> }}
union{cone{<-10.0197,4.12492,-11.3766> ,0.1296,<-12.211,5.76386,-12.8917> ,0.12096}
sphere{<-10.0197,4.12492,-11.3766> ,0.1296}
texture{txttree matrix <0.598949,0.800787,0,-0.700566,0.523989,-0.484398,-0.3879,0.29013,0.874848,-10.0197,4.12492,-11.3766> }}
union{cone{<-12.211,5.76386,-12.8917> ,0.12096,<-13.1238,6.2159,-15.9064> ,0.11232}
sphere{<-12.211,5.76386,-12.8917> ,0.12096}
texture{txttree matrix <0.443787,0.896133,0,-0.286847,0.142054,-0.947386,-0.848983,0.420437,0.320095,-12.211,5.76386,-12.8917> }}
union{cone{<-13.1238,6.2159,-15.9064> ,0.11232,<-14.7437,8.00513,-18.1087> ,0.10368}
sphere{<-13.1238,6.2159,-15.9064> ,0.11232}
texture{txttree matrix <0.741309,0.671163,0,-0.495792,0.547609,-0.674029,-0.452384,0.499664,0.738705,-13.1238,6.2159,-15.9064> }}
union{cone{<-14.7437,8.00513,-18.1087> ,0.10368,<-16.5134,9.70952,-20.0953> ,0.09504}
sphere{<-14.7437,8.00513,-18.1087> ,0.10368}
texture{txttree matrix <0.693685,0.720278,0,-0.560104,0.539425,-0.628732,-0.452862,0.436142,0.777622,-14.7437,8.00513,-18.1087> }}
union{cone{<-16.5134,9.70952,-20.0953> ,0.09504,<-17.7304,12.0102,-22.3114> ,0.0864}
sphere{<-16.5134,9.70952,-20.0953> ,0.09504}
texture{txttree matrix <0.883948,0.467585,0,-0.356017,0.673034,-0.648287,-0.303129,0.573052,0.761396,-16.5134,9.70952,-20.0953> }}
union{cone{<-17.7304,12.0102,-22.3114> ,0.0864,<-18.4518,13.1798,-25.379> ,0.07776}
sphere{<-17.7304,12.0102,-22.3114> ,0.0864}
texture{txttree matrix <0.851116,0.524978,0,-0.21462,0.347951,-0.912616,-0.479103,0.776742,0.408818,-17.7304,12.0102,-22.3114> }}
union{cone{<-6.51191,3.02652,-6.50713> ,0.1296,<-9.55908,3.92533,-7.35742> ,0.12096}
sphere{<-6.51191,3.02652,-6.50713> ,0.1296}
texture{txttree matrix <0.282914,0.959145,0,-0.926534,0.273295,-0.258543,-0.247981,0.0731457,0.966,-6.51191,3.02652,-6.50713> }}
union{cone{<-9.55908,3.92533,-7.35742> ,0.12096,<-11.9491,4.46571,-9.3159> ,0.11232}
sphere{<-9.55908,3.92533,-7.35742> ,0.12096}
texture{txttree matrix <0.220529,0.97538,0,-0.761917,0.172266,-0.624345,-0.608974,0.137686,0.781149,-9.55908,3.92533,-7.35742> }}
union{cone{<-11.9491,4.46571,-9.3159> ,0.11232,<-14.2905,5.61214,-11.323> ,0.10368}
sphere{<-11.9491,4.46571,-9.3159> ,0.11232}
texture{txttree matrix <0.439753,0.898119,0,-0.71165,0.348451,-0.61003,-0.54788,0.268263,0.792378,-11.9491,4.46571,-9.3159> }}
union{cone{<-14.2905,5.61214,-11.323> ,0.10368,<-16.3098,6.91559,-13.7142> ,0.09504}
sphere{<-14.2905,5.61214,-11.323> ,0.10368}
texture{txttree matrix <0.542319,0.840173,0,-0.5956,0.384451,-0.705307,-0.59258,0.382501,0.708902,-14.2905,5.61214,-11.323> }}
union{cone{<-16.3098,6.91559,-13.7142> ,0.09504,<-18.1284,8.41256,-16.1308> ,0.0864}
sphere{<-16.3098,6.91559,-13.7142> ,0.09504}
texture{txttree matrix <0.635534,0.772073,0,-0.538904,0.4436,-0.716101,-0.552882,0.455107,0.697996,-16.3098,6.91559,-13.7142> }}
union{cone{<-18.1284,8.41256,-16.1308> ,0.0864,<-20.0418,9.61533,-18.5625> ,0.07776}
sphere{<-18.1284,8.41256,-16.1308> ,0.0864}
texture{txttree matrix <0.532191,0.846624,0,-0.576366,0.362305,-0.732487,-0.620141,0.389823,0.680781,-18.1284,8.41256,-16.1308> }}
union{cone{<-3.29858,2.3976,-3.59207> ,0.1296,<-5.19171,2.27365,-6.21688> ,0.12096}
sphere{<-3.29858,2.3976,-3.59207> ,0.1296}
texture{txttree matrix <-0.065335,0.997863,0,-0.584542,-0.0382728,-0.810461,-0.808729,-0.0529514,0.585793,-3.29858,2.3976,-3.59207> }}
union{cone{<-5.19171,2.27365,-6.21688> ,0.12096,<-7.4133,2.98724,-8.30091> ,0.11232}
sphere{<-5.19171,2.27365,-6.21688> ,0.12096}
texture{txttree matrix <0.305821,0.952089,0,-0.710101,0.228092,-0.666131,-0.634216,0.203716,0.745835,-5.19171,2.27365,-6.21688> }}
union{cone{<-7.4133,2.98724,-8.30091> ,0.11232,<-8.10331,4.5813,-10.927> ,0.10368}
sphere{<-7.4133,2.98724,-8.30091> ,0.11232}
texture{txttree matrix <0.917713,0.397244,0,-0.219151,0.506282,-0.834057,-0.331324,0.765425,0.551678,-7.4133,2.98724,-8.30091> }}
union{cone{<-8.10331,4.5813,-10.927> ,0.10368,<-9.43829,5.05543,-13.7369> ,0.09504}
sphere{<-8.10331,4.5813,-10.927> ,0.10368}
texture{txttree matrix <0.334678,0.942333,0,-0.424222,0.150666,-0.892936,-0.841443,0.298846,0.450183,-8.10331,4.5813,-10.927> }}
union{cone{<-9.43829,5.05543,-13.7369> ,0.09504,<-10.6244,6.52141,-16.5515> ,0.0864}
sphere{<-9.43829,5.05543,-13.7369> ,0.09504}
texture{txttree matrix <0.777402,0.629004,0,-0.35011,0.432709,-0.830774,-0.52256,0.645846,0.556609,-9.43829,5.05543,-13.7369> }}
union{cone{<-10.6244,6.52141,-16.5515> ,0.0864,<-11.5377,7.36623,-19.7162> ,0.07776}
sphere{<-10.6244,6.52141,-16.5515> ,0.0864}
texture{txttree matrix <0.679058,0.734084,0,-0.268578,0.248446,-0.930667,-0.683188,0.631977,0.365868,-10.6244,6.52141,-16.5515> }}
union{cone{<-4.17118,2.45019,-4.66783> ,0.1296,<-4.99668,0.732628,-7.48845> ,0.12096}
sphere{<-4.17118,2.45019,-4.66783> ,0.1296}
texture{txttree matrix <-0.901306,0.433183,0,-0.242505,-0.504569,-0.828614,-0.358942,-0.746835,0.55982,-4.17118,2.45019,-4.66783> }}
union{cone{<-4.99668,0.732628,-7.48845> ,0.12096,<-5.27594,0.572378,-10.4577> ,0.11232}
sphere{<-4.99668,0.732628,-7.48845> ,0.12096}
texture{txttree matrix <-0.497707,0.867345,0,-0.0935046,-0.0536555,-0.994172,-0.86229,-0.494806,0.107805,-4.99668,0.732628,-7.48845> }}
union{cone{<-5.27594,0.572378,-10.4577> ,0.11232,<-5.31262,0.66725,-13.5923> ,0.10368}
sphere{<-5.27594,0.572378,-10.4577> ,0.11232}
texture{txttree matrix <0.932729,0.360578,0,-0.0116942,0.03025,-0.999474,-0.360388,0.932238,0.0324317,-5.27594,0.572378,-10.4577> }}
union{cone{<-5.31262,0.66725,-13.5923> ,0.10368,<-6.86106,0.575078,-16.3952> ,0.09504}
sphere{<-5.31262,0.66725,-13.5923> ,0.10368}
texture{txttree matrix <-0.0594205,0.998233,0,-0.483359,-0.0287723,-0.874949,-0.873403,-0.05199,0.484215,-5.31262,0.66725,-13.5923> }}
union{cone{<-6.86106,0.575078,-16.3952> ,0.09504,<-7.00124,0.736593,-19.7556> ,0.0864}
sphere{<-6.86106,0.575078,-16.3952> ,0.09504}
texture{txttree matrix <0.755207,0.655486,0,-0.0416333,0.0479671,-0.997981,-0.654163,0.753682,0.0635152,-6.86106,0.575078,-16.3952> }}
union{cone{<-7.00124,0.736593,-19.7556> ,0.0864,<-7.08276,1.00274,-22.935> ,0.07776}
sphere{<-7.00124,0.736593,-19.7556> ,0.0864}
texture{txttree matrix <0.956162,0.292839,0,-0.0255401,0.0833923,-0.996189,-0.291723,0.952518,0.0872157,-7.00124,0.736593,-19.7556> }}
union{cone{<-5.46377,2.84661,-5.81123> ,0.1296,<-8.17668,1.89672,-7.28453> ,0.12096}
sphere{<-5.46377,2.84661,-5.81123> ,0.1296}
texture{txttree matrix <-0.330465,0.943818,0,-0.839915,-0.294085,-0.456132,-0.430506,-0.150736,0.889912,-5.46377,2.84661,-5.81123> }}
union{cone{<-8.17668,1.89672,-7.28453> ,0.12096,<-10.6489,1.6978,-9.56281> ,0.11232}
sphere{<-8.17668,1.89672,-7.28453> ,0.12096}
texture{txttree matrix <-0.0802047,0.996778,0,-0.734078,-0.0590668,-0.676491,-0.674312,-0.0542578,0.736451,-8.17668,1.89672,-7.28453> }}
union{cone{<-10.6489,1.6978,-9.56281> ,0.11232,<-13.5779,1.91397,-11.1025> ,0.10368}
sphere{<-10.6489,1.6978,-9.56281> ,0.11232}
texture{txttree matrix <0.0736045,0.997288,0,-0.883265,0.0651891,-0.464321,-0.463062,0.0341761,0.885667,-10.6489,1.6978,-9.56281> }}
union{cone{<-13.5779,1.91397,-11.1025> ,0.10368,<-16.0347,2.90751,-12.9683> ,0.09504}
sphere{<-13.5779,1.91397,-11.1025> ,0.10368}
texture{txttree matrix <0.3749,0.927065,0,-0.758049,0.30655,-0.575664,-0.533678,0.215816,0.817686,-13.5779,1.91397,-11.1025> }}
union{cone{<-16.0347,2.90751,-12.9683> ,0.09504,<-18.5843,3.64575,-14.8731> ,0.0864}
sphere{<-16.0347,2.90751,-12.9683> ,0.09504}
texture{txttree matrix <0.278135,0.960542,0,-0.780386,0.225969,-0.58304,-0.560034,0.162164,0.812443,-16.0347,2.90751,-12.9683> }}
union{cone{<-18.5843,3.64575,-14.8731> ,0.0864,<-19.9771,4.81609,-17.595> ,0.07776}
sphere{<-18.5843,3.64575,-14.8731> ,0.0864}
texture{txttree matrix <0.643315,0.765601,0,-0.425425,0.357474,-0.8314,-0.636521,0.534852,0.555674,-18.5843,3.64575,-14.8731> }}
union{cone{<-4.50696,4.64106,-4.36768> ,0.216,<-6.27605,4.34711,-4.71194> ,0.203657}
sphere{<-4.50696,4.64106,-4.36768> ,0.216}
texture{txttree matrix <-0.163915,0.986475,0,-0.968786,-0.160975,-0.188522,-0.185973,-0.0309016,0.982069,-4.50696,4.64106,-4.36768> }}
union{cone{<-6.27605,4.34711,-4.71194> ,0.203657,<-7.47529,4.12649,-5.86887> ,0.191314}
sphere{<-6.27605,4.34711,-4.71194> ,0.203657}
texture{txttree matrix <-0.180926,0.983497,0,-0.713463,-0.13125,-0.688291,-0.676932,-0.12453,0.725435,-6.27605,4.34711,-4.71194> }}
union{cone{<-7.47529,4.12649,-5.86887> ,0.191314,<-9.103,4.20351,-6.52902> ,0.178971}
sphere{<-7.47529,4.12649,-5.86887> ,0.191314}
texture{txttree matrix <0.0472632,0.998882,0,-0.925796,0.043805,-0.375476,-0.375056,0.0177462,0.926832,-7.47529,4.12649,-5.86887> }}
union{cone{<-9.103,4.20351,-6.52902> ,0.178971,<-10.2904,5.14475,-7.55662> ,0.166629}
sphere{<-9.103,4.20351,-6.52902> ,0.178971}
texture{txttree matrix <0.621201,0.783651,0,-0.648566,0.514118,-0.561289,-0.439855,0.348673,0.82762,-9.103,4.20351,-6.52902> }}
union{cone{<-10.2904,5.14475,-7.55662> ,0.166629,<-11.3502,5.42913,-8.97673> ,0.154286}
sphere{<-10.2904,5.14475,-7.55662> ,0.166629}
texture{txttree matrix <0.259158,0.965835,0,-0.590547,0.158459,-0.791294,-0.764259,0.20507,0.611436,-10.2904,5.14475,-7.55662> }}
union{cone{<-11.3502,5.42913,-8.97673> ,0.154286,<-12.1554,5.83212,-10.3807> ,0.141943}
sphere{<-11.3502,5.42913,-8.97673> ,0.154286}
texture{txttree matrix <0.447577,0.894246,0,-0.482735,0.241612,-0.841778,-0.752756,0.37676,0.539824,-11.3502,5.42913,-8.97673> }}
union{cone{<-12.1554,5.83212,-10.3807> ,0.141943,<-12.8676,6.35238,-11.8089> ,0.1296}
sphere{<-12.1554,5.83212,-10.3807> ,0.141943}
texture{txttree matrix <0.589856,0.807508,0,-0.424302,0.309938,-0.850827,-0.687049,0.501866,0.525446,-12.1554,5.83212,-10.3807> }}
union{cone{<-12.8676,6.35238,-11.8089> ,0.1296,<-13.817,8.20264,-14.1521> ,0.12096}
sphere{<-12.8676,6.35238,-11.8089> ,0.1296}
texture{txttree matrix <0.889708,0.45653,0,-0.303042,0.590583,-0.747916,-0.341446,0.665426,0.663794,-12.8676,6.35238,-11.8089> }}
union{cone{<-13.817,8.20264,-14.1521> ,0.12096,<-15.8904,9.93375,-15.8594> ,0.11232}
sphere{<-13.817,8.20264,-14.1521> ,0.12096}
texture{txttree matrix <0.640907,0.767618,0,-0.648861,0.541754,-0.534305,-0.410142,0.34244,0.845292,-13.817,8.20264,-14.1521> }}
union{cone{<-15.8904,9.93375,-15.8594> ,0.11232,<-17.4069,12.1931,-17.4721> ,0.10368}
sphere{<-15.8904,9.93375,-15.8594> ,0.11232}
texture{txttree matrix <0.830308,0.557305,0,-0.479436,0.714294,-0.509828,-0.28413,0.423314,0.860276,-15.8904,9.93375,-15.8594> }}
union{cone{<-17.4069,12.1931,-17.4721> ,0.10368,<-19.1846,13.555,-19.7862> ,0.09504}
sphere{<-17.4069,12.1931,-17.4721> ,0.10368}
texture{txttree matrix <0.60814,0.79383,0,-0.552025,0.422897,-0.718628,-0.570469,0.437026,0.695395,-17.4069,12.1931,-17.4721> }}
union{cone{<-19.1846,13.555,-19.7862> ,0.09504,<-20.4891,15.0347,-22.5964> ,0.0864}
sphere{<-19.1846,13.555,-19.7862> ,0.09504}
texture{txttree matrix <0.750106,0.661317,0,-0.37996,0.430973,-0.81847,-0.541268,0.613939,0.574549,-19.1846,13.555,-19.7862> }}
union{cone{<-20.4891,15.0347,-22.5964> ,0.0864,<-22.1655,17.2435,-24.2887> ,0.07776}
sphere{<-20.4891,15.0347,-22.5964> ,0.0864}
texture{txttree matrix <0.796556,0.604564,0,-0.516048,0.67993,-0.52095,-0.314948,0.414966,0.853587,-20.4891,15.0347,-22.5964> }}
union{cone{<-5.3382,4.50294,-4.52944> ,0.1296,<-8.08484,5.15556,-6.19755> ,0.12096}
sphere{<-5.3382,4.50294,-4.52944> ,0.1296}
texture{txttree matrix <0.231172,0.972913,0,-0.837618,0.199025,-0.508709,-0.49493,0.117599,0.860938,-5.3382,4.50294,-4.52944> }}
union{cone{<-8.08484,5.15556,-6.19755> ,0.12096,<-10.3905,5.13932,-8.69713> ,0.11232}
sphere{<-8.08484,5.15556,-6.19755> ,0.12096}
texture{txttree matrix <-0.00704401,0.999975,0,-0.678011,-0.00477604,-0.735036,-0.735018,-0.00517761,0.678028,-8.08484,5.15556,-6.19755> }}
union{cone{<-10.3905,5.13932,-8.69713> ,0.11232,<-13.4397,5.39993,-9.97209> ,0.10368}
sphere{<-10.3905,5.13932,-8.69713> ,0.11232}
texture{txttree matrix <0.0851588,0.996367,0,-0.919741,0.0786096,-0.384574,-0.383177,0.0327498,0.923094,-10.3905,5.13932,-8.69713> }}
union{cone{<-13.4397,5.39993,-9.97209> ,0.10368,<-16.2747,5.54729,-11.663> ,0.09504}
sphere{<-13.4397,5.39993,-9.97209> ,0.10368}
texture{txttree matrix <0.0519093,0.998652,0,-0.857982,0.0445974,-0.511739,-0.51105,0.026564,0.859141,-13.4397,5.39993,-9.97209> }}
union{cone{<-16.2747,5.54729,-11.663> ,0.09504,<-17.992,7.26678,-14.0623> ,0.0864}
sphere{<-16.2747,5.54729,-11.663> ,0.09504}
texture{txttree matrix <0.70754,0.706674,0,-0.502879,0.503496,-0.70257,-0.496488,0.497096,0.711615,-16.2747,5.54729,-11.663> }}
union{cone{<-17.992,7.26678,-14.0623> ,0.0864,<-20.0194,8.7512,-16.0262> ,0.07776}
sphere{<-17.992,7.26678,-14.0623> ,0.0864}
texture{txttree matrix <0.590759,0.806848,0,-0.635719,0.465461,-0.615799,-0.496856,0.363788,0.787903,-17.992,7.26678,-14.0623> }}
union{cone{<-11.7372,5.62284,-9.65159> ,0.1296,<-13.2758,4.51464,-12.1716> ,0.12096}
sphere{<-11.7372,5.62284,-9.65159> ,0.1296}
texture{txttree matrix <-0.584446,0.811432,0,-0.487871,-0.351396,-0.799063,-0.648386,-0.46701,0.601247,-11.7372,5.62284,-9.65159> }}
union{cone{<-13.2758,4.51464,-12.1716> ,0.12096,<-14.1661,3.69702,-15.141> ,0.11232}
sphere{<-13.2758,4.51464,-12.1716> ,0.12096}
texture{txttree matrix <-0.676407,0.736528,0,-0.277693,-0.255025,-0.926201,-0.682173,-0.626489,0.377029,-13.2758,4.51464,-12.1716> }}
union{cone{<-14.1661,3.69702,-15.141> ,0.11232,<-14.6433,5.06698,-18.0478> ,0.10368}
sphere{<-14.1661,3.69702,-15.141> ,0.11232}
texture{txttree matrix <0.944364,0.328903,0,-0.146869,0.421696,-0.894764,-0.294291,0.844982,0.44654,-14.1661,3.69702,-15.141> }}
union{cone{<-14.6433,5.06698,-18.0478> ,0.10368,<-14.8666,4.91802,-21.3914> ,0.09504}
sphere{<-14.6433,5.06698,-18.0478> ,0.10368}
texture{txttree matrix <-0.554943,0.831888,0,-0.0665708,-0.0444086,-0.996793,-0.82922,-0.553163,0.0800238,-14.6433,5.06698,-18.0478> }}
union{cone{<-14.8666,4.91802,-21.3914> ,0.09504,<-14.7733,5.3611,-24.7448> ,0.0864}
sphere{<-14.8666,4.91802,-21.3914> ,0.09504}
texture{txttree matrix <0.978556,-0.20598,0,0.0275625,0.130942,-0.991007,0.204128,0.969756,0.133811,-14.8666,4.91802,-21.3914> }}
union{cone{<-14.7733,5.3611,-24.7448> ,0.0864,<-16.045,5.93858,-27.7391> ,0.07776}
sphere{<-14.7733,5.3611,-24.7448> ,0.0864}
texture{txttree matrix <0.413469,0.910518,0,-0.384887,0.174778,-0.906264,-0.82517,0.374712,0.422712,-14.7733,5.3611,-24.7448> }}
union{cone{<-8.22872,4.16214,-6.17444> ,0.1296,<-11.5302,3.97154,-6.20697> ,0.12096}
sphere{<-8.22872,4.16214,-6.17444> ,0.1296}
texture{txttree matrix <-0.0576362,0.998338,0,-0.998289,-0.0576334,-0.00983744,-0.00982108,-0.000566992,0.999952,-8.22872,4.16214,-6.17444> }}
union{cone{<-11.5302,3.97154,-6.20697> ,0.12096,<-14.4477,4.79234,-7.37253> ,0.11232}
sphere{<-11.5302,3.97154,-6.20697> ,0.12096}
texture{txttree matrix <0.270829,0.962627,0,-0.898474,0.25278,-0.358953,-0.345538,0.0972149,0.933356,-11.5302,3.97154,-6.20697> }}
union{cone{<-14.4477,4.79234,-7.37253> ,0.11232,<-17.6745,5.15289,-7.97088> ,0.10368}
sphere{<-14.4477,4.79234,-7.37253> ,0.11232}
texture{txttree matrix <0.111044,0.993815,0,-0.977358,0.109205,-0.181234,-0.180113,0.0201249,0.98344,-14.4477,4.79234,-7.37253> }}
union{cone{<-17.6745,5.15289,-7.97088> ,0.10368,<-20.7179,4.54318,-9.10366> ,0.09504}
sphere{<-17.6745,5.15289,-7.97088> ,0.10368}
texture{txttree matrix <-0.19643,0.980518,0,-0.921096,-0.184526,-0.34283,-0.336151,-0.0673422,0.939397,-17.6745,5.15289,-7.97088> }}
union{cone{<-20.7179,4.54318,-9.10366> ,0.09504,<-23.1749,6.05608,-10.5364> ,0.0864}
sphere{<-20.7179,4.54318,-9.10366> ,0.09504}
texture{txttree matrix <0.524323,0.851519,0,-0.762679,0.469619,-0.444723,-0.378691,0.233179,0.895668,-20.7179,4.54318,-9.10366> }}
union{cone{<-23.1749,6.05608,-10.5364> ,0.0864,<-25.9047,7.02712,-11.7965> ,0.07776}
sphere{<-23.1749,6.05608,-10.5364> ,0.0864}
texture{txttree matrix <0.335147,0.942166,0,-0.863989,0.307338,-0.398831,-0.375765,0.133667,0.917025,-23.1749,6.05608,-10.5364> }}
union{cone{<-1.37426,1.40073,-2.33925> ,0.36,<-1.38098,1.70315,-3.25104> ,0.342}
sphere{<-1.37426,1.40073,-2.33925> ,0.36}
texture{txttree matrix <0.999753,0.0222142,0,-0.00699487,0.314805,-0.94913,-0.0210842,0.948896,0.314883,-1.37426,1.40073,-2.33925> }}
union{cone{<-1.38098,1.70315,-3.25104> ,0.342,<-1.32468,2.26582,-4.02502> ,0.324}
sphere{<-1.38098,1.70315,-3.25104> ,0.342}
texture{txttree matrix <0.995031,-0.0995623,0,0.0587355,0.587006,-0.807449,0.0803915,0.803437,0.589937,-1.38098,1.70315,-3.25104> }}
union{cone{<-1.32468,2.26582,-4.02502> ,0.324,<-1.04616,2.87143,-4.69482> ,0.306}
sphere{<-1.32468,2.26582,-4.02502> ,0.324}
texture{txttree matrix <0.908525,-0.417831,0,0.294741,0.640879,-0.708804,0.29616,0.643966,0.705406,-1.32468,2.26582,-4.02502> }}
union{cone{<-1.04616,2.87143,-4.69482> ,0.306,<-0.945359,3.20744,-5.59493> ,0.288}
sphere{<-1.04616,2.87143,-4.69482> ,0.306}
texture{txttree matrix <0.957827,-0.287346,0,0.104344,0.347815,-0.931739,0.267732,0.892444,0.363129,-1.04616,2.87143,-4.69482> }}
union{cone{<-0.945359,3.20744,-5.59493> ,0.288,<-0.996873,3.91789,-6.18379> ,0.27}
sphere{<-0.945359,3.20744,-5.59493> ,0.288}
texture{txttree matrix <0.997381,0.07232,0,-0.0557396,0.768718,-0.637155,-0.046079,0.635486,0.770736,-0.945359,3.20744,-5.59493> }}
union{cone{<-0.996873,3.91789,-6.18379> ,0.27,<-1.09214,4.44573,-6.97526> ,0.252}
sphere{<-0.996873,3.91789,-6.18379> ,0.27}
texture{txttree matrix <0.984101,0.177608,0,-0.0996375,0.552076,-0.827819,-0.147028,0.814658,0.560995,-0.996873,3.91789,-6.18379> }}
union{cone{<-1.09214,4.44573,-6.97526> ,0.252,<-1.15994,4.85431,-7.86743> ,0.234}
sphere{<-1.09214,4.44573,-6.97526> ,0.252}
texture{txttree matrix <0.98651,0.163703,0,-0.0689298,0.415387,-0.907029,-0.148483,0.894793,0.421067,-1.09214,4.44573,-6.97526> }}
union{cone{<-1.15994,4.85431,-7.86743> ,0.234,<-1.24674,5.52954,-8.47845> ,0.216}
sphere{<-1.15994,4.85431,-7.86743> ,0.234}
texture{txttree matrix <0.991837,0.127511,0,-0.0948949,0.738137,-0.667944,-0.0851699,0.662491,0.744212,-1.15994,4.85431,-7.86743> }}
union{cone{<-1.24674,5.52954,-8.47845> ,0.216,<-1.6851,7.1624,-8.42844> ,0.203657}
sphere{<-1.24674,5.52954,-8.47845> ,0.216}
texture{txttree matrix <0.965803,0.259276,0,-0.259163,0.965381,0.0295724,0.00766741,-0.0285611,0.999563,-1.24674,5.52954,-8.47845> }}
union{cone{<-1.6851,7.1624,-8.42844> ,0.203657,<-1.4429,8.72389,-9.31754> ,0.191314}
sphere{<-1.6851,7.1624,-8.42844> ,0.203657}
texture{txttree matrix <0.988184,-0.153273,0,0.133579,0.861216,-0.490371,0.0751604,0.484577,0.871514,-1.6851,7.1624,-8.42844> }}
union{cone{<-1.4429,8.72389,-9.31754> ,0.191314,<-1.7223,10.425,-9.4809> ,0.178971}
sphere{<-1.4429,8.72389,-9.31754> ,0.191314}
texture{txttree matrix <0.986779,0.162074,0,-0.161351,0.982377,-0.0943446,-0.0152908,0.0930972,0.99554,-1.4429,8.72389,-9.31754> }}
union{cone{<-1.7223,10.425,-9.4809> ,0.178971,<-1.68587,12.1521,-9.71875> ,0.166629}
sphere{<-1.7223,10.425,-9.4809> ,0.178971}
texture{txttree matrix <0.999778,-0.0210855,0,0.0208884,0.990434,-0.136397,0.00287599,0.136366,0.990654,-1.7223,10.425,-9.4809> }}
union{cone{<-1.68587,12.1521,-9.71875> ,0.166629,<-1.3971,13.8253,-10.3976> ,0.154286}
sphere{<-1.68587,12.1521,-9.71875> ,0.166629}
texture{txttree matrix <0.985432,-0.170069,0,0.157915,0.915006,-0.371251,0.0631385,0.365843,0.928532,-1.68587,12.1521,-9.71875> }}
union{cone{<-1.3971,13.8253,-10.3976> ,0.154286,<-1.25422,15.4101,-11.1916> ,0.141943}
sphere{<-1.3971,13.8253,-10.3976> ,0.154286}
texture{txttree matrix <0.995961,-0.0897917,0,0.0803447,0.891176,-0.446486,0.0400908,0.444683,0.89479,-1.3971,13.8253,-10.3976> }}
union{cone{<-1.25422,15.4101,-11.1916> ,0.141943,<-1.44618,17.1643,-11.6567> ,0.1296}
sphere{<-1.25422,15.4101,-11.1916> ,0.141943}
texture{txttree matrix <0.994066,0.108779,0,-0.105188,0.961248,-0.254829,-0.0277201,0.253317,0.966986,-1.25422,15.4101,-11.1916> }}
union{cone{<-1.44618,17.1643,-11.6567> ,0.1296,<-2.31237,20.3059,-12.1477> ,0.12096}
sphere{<-1.44618,17.1643,-11.6567> ,0.1296}
texture{txttree matrix <0.964028,0.265801,0,-0.262835,0.953269,-0.148982,-0.0395997,0.143623,0.98884,-1.44618,17.1643,-11.6567> }}
union{cone{<-2.31237,20.3059,-12.1477> ,0.12096,<-2.71026,23.4105,-12.9704> ,0.11232}
sphere{<-2.31237,20.3059,-12.1477> ,0.12096}
texture{txttree matrix <0.991887,0.12712,0,-0.122943,0.959299,-0.254226,-0.0323173,0.252164,0.967145,-2.31237,20.3059,-12.1477> }}
union{cone{<-2.71026,23.4105,-12.9704> ,0.11232,<-3.25416,26.6781,-12.2595> ,0.10368}
sphere{<-2.71026,23.4105,-12.9704> ,0.11232}
texture{txttree matrix <0.986428,0.164192,0,-0.160538,0.964471,0.20982,0.0344508,-0.206972,0.97774,-2.71026,23.4105,-12.9704> }}
union{cone{<-3.25416,26.6781,-12.2595> ,0.10368,<-2.69602,30.0398,-12.3625> ,0.09504}
sphere{<-3.25416,26.6781,-12.2595> ,0.10368}
texture{txttree matrix <0.986496,-0.163787,0,0.163713,0.986046,-0.0301829,0.00494358,0.0297753,0.999544,-3.25416,26.6781,-12.2595> }}
union{cone{<-2.69602,30.0398,-12.3625> ,0.09504,<-3.33346,32.9789,-13.2559> ,0.0864}
sphere{<-2.69602,30.0398,-12.3625> ,0.09504}
texture{txttree matrix <0.97728,0.211954,0,-0.203177,0.936811,-0.284789,-0.0603623,0.278319,0.95859,-2.69602,30.0398,-12.3625> }}
union{cone{<-3.33346,32.9789,-13.2559> ,0.0864,<-4.10264,36.0301,-13.622> ,0.07776}
sphere{<-3.33346,32.9789,-13.2559> ,0.0864}
texture{txttree matrix <0.969663,0.244446,0,-0.242809,0.963168,-0.115548,-0.0282452,0.112043,0.993302,-3.33346,32.9789,-13.2559> }}
union{cone{<-1.3525,14.32,-10.6455> ,0.1296,<-1.29219,16.3956,-13.1605> ,0.12096}
sphere{<-1.3525,14.32,-10.6455> ,0.1296}
texture{txttree matrix <0.999578,-0.0290472,0,0.0184935,0.636401,-0.771136,0.0223994,0.770811,0.63667,-1.3525,14.32,-10.6455> }}
union{cone{<-1.29219,16.3956,-13.1605> ,0.12096,<-1.71722,18.3658,-15.6378> ,0.11232}
sphere{<-1.29219,16.3956,-13.1605> ,0.12096}
texture{txttree matrix <0.977511,0.210886,0,-0.13309,0.616907,-0.775702,-0.163585,0.758257,0.6311,-1.29219,16.3956,-13.1605> }}
union{cone{<-1.71722,18.3658,-15.6378> ,0.11232,<-1.36757,20.1969,-18.1807> ,0.10368}
sphere{<-1.71722,18.3658,-15.6378> ,0.11232}
texture{txttree matrix <0.982253,-0.187562,0,0.110895,0.58075,-0.806494,0.151268,0.792181,0.591243,-1.71722,18.3658,-15.6378> }}
union{cone{<-1.36757,20.1969,-18.1807> ,0.10368,<-0.832688,22.4027,-20.7392> ,0.09504}
sphere{<-1.36757,20.1969,-18.1807> ,0.10368}
texture{txttree matrix <0.971835,-0.235661,0,0.156393,0.644945,-0.748055,0.176287,0.726987,0.663636,-1.36757,20.1969,-18.1807> }}
union{cone{<-0.832688,22.4027,-20.7392> ,0.09504,<-1.11024,24.5106,-23.0158> ,0.0864}
sphere{<-0.832688,22.4027,-20.7392> ,0.09504}
texture{txttree matrix <0.991442,0.130546,0,-0.0891007,0.676684,-0.730862,-0.095411,0.724608,0.682525,-0.832688,22.4027,-20.7392> }}
union{cone{<-1.11024,24.5106,-23.0158> ,0.0864,<-0.578957,26.8575,-25.2009> ,0.07776}
sphere{<-1.11024,24.5106,-23.0158> ,0.0864}
texture{txttree matrix <0.975321,-0.220791,0,0.163455,0.722048,-0.672256,0.148428,0.655666,0.740318,-1.11024,24.5106,-23.0158> }}
union{cone{<-1.30988,15.9187,-11.3265> ,0.1296,<-2.77843,18.8255,-12.2264> ,0.12096}
sphere{<-1.30988,15.9187,-11.3265> ,0.1296}
texture{txttree matrix <0.892558,0.450932,0,-0.434644,0.860319,-0.266338,-0.1201,0.237722,0.96388,-1.30988,15.9187,-11.3265> }}
union{cone{<-2.77843,18.8255,-12.2264> ,0.12096,<-4.11993,21.0857,-13.9546> ,0.11232}
sphere{<-2.77843,18.8255,-12.2264> ,0.12096}
texture{txttree matrix <0.859939,0.510397,0,-0.426467,0.71853,-0.5494,-0.280412,0.472451,0.835559,-2.77843,18.8255,-12.2264> }}
union{cone{<-4.11993,21.0857,-13.9546> ,0.11232,<-5.8742,23.6198,-15.0412> ,0.10368}
sphere{<-4.11993,21.0857,-13.9546> ,0.11232}
texture{txttree matrix <0.8222,0.569198,0,-0.53681,0.775416,-0.332514,-0.189267,0.273393,0.943098,-4.11993,21.0857,-13.9546> }}
union{cone{<-5.8742,23.6198,-15.0412> ,0.10368,<-5.93767,26.587,-16.1219> ,0.09504}
sphere{<-5.8742,23.6198,-15.0412> ,0.10368}
texture{txttree matrix <0.999771,0.0213819,0,-0.0200915,0.939434,-0.342139,-0.00731558,0.342061,0.939649,-5.8742,23.6198,-15.0412> }}
union{cone{<-5.93767,26.587,-16.1219> ,0.09504,<-7.30035,29.4083,-17.4487> ,0.0864}
sphere{<-5.93767,26.587,-16.1219> ,0.09504}
texture{txttree matrix <0.900465,0.434928,0,-0.400494,0.829175,-0.389966,-0.169607,0.351151,0.920829,-5.93767,26.587,-16.1219> }}
union{cone{<-7.30035,29.4083,-17.4487> ,0.0864,<-8.27359,32.3419,-18.404> ,0.07776}
sphere{<-7.30035,29.4083,-17.4487> ,0.0864}
texture{txttree matrix <0.949131,0.314881,0,-0.300839,0.906807,-0.29529,-0.0929813,0.280269,0.955408,-7.30035,29.4083,-17.4487> }}
union{cone{<-1.2231,5.3456,-8.31201> ,0.216,<-1.01137,6.94632,-8.87584> ,0.203657}
sphere{<-1.2231,5.3456,-8.31201> ,0.216}
texture{txttree matrix <0.991366,-0.131126,0,0.123796,0.935942,-0.329677,0.0432293,0.32683,0.944094,-1.2231,5.3456,-8.31201> }}
union{cone{<-1.01137,6.94632,-8.87584> ,0.203657,<-0.503196,8.05164,-10.0413> ,0.191314}
sphere{<-1.01137,6.94632,-8.87584> ,0.203657}
texture{txttree matrix <0.908574,-0.417723,0,0.301637,0.65608,-0.69179,0.288977,0.628543,0.722098,-1.01137,6.94632,-8.87584> }}
union{cone{<-0.503196,8.05164,-10.0413> ,0.191314,<0.345133,9.14903,-11.2024> ,0.178971}
sphere{<-0.503196,8.05164,-10.0413> ,0.191314}
texture{txttree matrix <0.791165,-0.611602,0,0.468989,0.606681,-0.641862,0.392564,0.507819,0.76682,-0.503196,8.05164,-10.0413> }}
union{cone{<0.345133,9.14903,-11.2024> ,0.178971,<1.06986,10.5404,-12.1168> ,0.166629}
sphere{<0.345133,9.14903,-11.2024> ,0.178971}
texture{txttree matrix <0.886904,-0.461954,0,0.399101,0.766233,-0.503593,0.232637,0.446638,0.863941,0.345133,9.14903,-11.2024> }}
union{cone{<1.06986,10.5404,-12.1168> ,0.166629,<1.29437,11.7935,-13.3685> ,0.154286}
sphere{<1.06986,10.5404,-12.1168> ,0.166629}
texture{txttree matrix <0.984324,-0.176367,0,0.125756,0.701857,-0.70113,0.123656,0.690139,0.713034,1.06986,10.5404,-12.1168> }}
union{cone{<1.29437,11.7935,-13.3685> ,0.154286,<1.94409,12.9781,-14.5335> ,0.141943}
sphere{<1.29437,11.7935,-13.3685> ,0.154286}
texture{txttree matrix <0.876795,-0.480864,0,0.364193,0.66406,-0.652984,0.313996,0.572533,0.757372,1.29437,11.7935,-13.3685> }}
union{cone{<1.94409,12.9781,-14.5335> ,0.141943,<2.07349,14.3872,-15.6238> ,0.1296}
sphere{<1.94409,12.9781,-14.5335> ,0.141943}
texture{txttree matrix <0.99581,-0.0914496,0,0.0724386,0.788796,-0.610372,0.0558183,0.607815,0.792115,1.94409,12.9781,-14.5335> }}
union{cone{<2.07349,14.3872,-15.6238> ,0.1296,<1.80637,17.6098,-16.0259> ,0.12096}
sphere{<2.07349,14.3872,-15.6238> ,0.1296}
texture{txttree matrix <0.996583,0.0826018,0,-0.0819703,0.988963,-0.123419,-0.0101946,0.122997,0.992355,2.07349,14.3872,-15.6238> }}
union{cone{<1.80637,17.6098,-16.0259> ,0.12096,<2.32559,20.5917,-17.0893> ,0.11232}
sphere{<1.80637,17.6098,-16.0259> ,0.12096}
texture{txttree matrix <0.985177,-0.171542,0,0.161844,0.929483,-0.331463,0.0568597,0.32655,0.943468,1.80637,17.6098,-16.0259> }}
union{cone{<2.32559,20.5917,-17.0893> ,0.11232,<1.59616,23.6334,-18.4448> ,0.10368}
sphere{<2.32559,20.5917,-17.0893> ,0.11232}
texture{txttree matrix <0.972428,0.233204,0,-0.213976,0.892251,-0.397621,-0.0927265,0.386657,0.91755,2.32559,20.5917,-17.0893> }}
union{cone{<1.59616,23.6334,-18.4448> ,0.10368,<2.01099,26.6786,-19.101> ,0.09504}
sphere{<1.59616,23.6334,-18.4448> ,0.10368}
texture{txttree matrix <0.990849,-0.134975,0,0.132,0.969009,-0.2088,0.0281827,0.206889,0.977958,1.59616,23.6334,-18.4448> }}
union{cone{<2.01099,26.6786,-19.101> ,0.09504,<1.80142,29.6233,-20.6282> ,0.0864}
sphere{<2.01099,26.6786,-19.101> ,0.09504}
texture{txttree matrix <0.997477,0.0709872,0,-0.0630497,0.885942,-0.45949,-0.0326179,0.458331,0.888183,2.01099,26.6786,-19.101> }}
union{cone{<1.80142,29.6233,-20.6282> ,0.0864,<1.47626,32.8247,-21.8336> ,0.07776}
sphere{<1.80142,29.6233,-20.6282> ,0.0864}
texture{txttree matrix <0.994881,0.101049,0,-0.0946285,0.931666,-0.350775,-0.0354455,0.34898,0.93646,1.80142,29.6233,-20.6282> }}
union{cone{<1.56076,12.2792,-13.8462> ,0.1296,<4.00852,14.5829,-14.4978> ,0.12096}
sphere{<1.56076,12.2792,-13.8462> ,0.1296}
texture{txttree matrix <0.685357,-0.728207,0,0.714896,0.67283,-0.190324,0.138595,0.13044,0.981721,1.56076,12.2792,-13.8462> }}
union{cone{<4.00852,14.5829,-14.4978> ,0.12096,<6.55355,15.7952,-15.9211> ,0.11232}
sphere{<4.00852,14.5829,-14.4978> ,0.12096}
texture{txttree matrix <0.43003,-0.902815,0,0.805919,0.383876,-0.450704,0.406902,0.193816,0.892673,4.00852,14.5829,-14.4978> }}
union{cone{<6.55355,15.7952,-15.9211> ,0.11232,<7.2766,18.2531,-17.8231> ,0.10368}
sphere{<6.55355,15.7952,-15.9211> ,0.11232}
texture{txttree matrix <0.959352,-0.282212,0,0.226596,0.770292,-0.596074,0.168219,0.571845,0.80293,6.55355,15.7952,-15.9211> }}
union{cone{<7.2766,18.2531,-17.8231> ,0.10368,<9.12351,20.5778,-19.3623> ,0.09504}
sphere{<7.2766,18.2531,-17.8231> ,0.10368}
texture{txttree matrix <0.78298,-0.622047,0,0.552252,0.695128,-0.460234,0.286287,0.360354,0.887798,7.2766,18.2531,-17.8231> }}
union{cone{<9.12351,20.5778,-19.3623> ,0.09504,<9.93414,22.332,-22.0525> ,0.0864}
sphere{<9.12351,20.5778,-19.3623> ,0.09504}
texture{txttree matrix <0.907761,-0.419488,0,0.244735,0.529601,-0.812174,0.340697,0.73726,0.583415,9.12351,20.5778,-19.3623> }}
union{cone{<9.93414,22.332,-22.0525> ,0.0864,<11.7299,24.0382,-24.1377> ,0.07776}
sphere{<9.93414,22.332,-22.0525> ,0.0864}
texture{txttree matrix <0.688782,-0.724968,0,0.554619,0.526936,-0.644001,0.46688,0.443576,0.765025,9.93414,22.332,-22.0525> }}
union{cone{<-0.902875,7.18231,-9.12468> ,0.1296,<-0.457287,8.54772,-12.1798> ,0.12096}
sphere{<-0.902875,7.18231,-9.12468> ,0.1296}
texture{txttree matrix <0.950659,-0.310239,0,0.131991,0.404458,-0.904982,0.280761,0.860329,0.425451,-0.902875,7.18231,-9.12468> }}
union{cone{<-0.457287,8.54772,-12.1798> ,0.12096,<1.36524,9.6782,-14.5293> ,0.11232}
sphere{<-0.457287,8.54772,-12.1798> ,0.12096}
texture{txttree matrix <0.527113,-0.849795,0,0.572911,0.355367,-0.738571,0.627634,0.38931,0.674176,-0.457287,8.54772,-12.1798> }}
union{cone{<1.36524,9.6782,-14.5293> ,0.11232,<1.73983,11.4161,-17.3782> ,0.10368}
sphere{<1.36524,9.6782,-14.5293> ,0.11232}
texture{txttree matrix <0.977551,-0.210697,0,0.111546,0.517532,-0.848362,0.178747,0.829318,0.529417,1.36524,9.6782,-14.5293> }}
union{cone{<1.73983,11.4161,-17.3782> ,0.10368,<3.21632,12.1967,-20.1451> ,0.09504}
sphere{<1.73983,11.4161,-17.3782> ,0.10368}
texture{txttree matrix <0.467376,-0.884059,0,0.456857,0.241527,-0.856123,0.756863,0.400131,0.516772,1.73983,11.4161,-17.3782> }}
union{cone{<3.21632,12.1967,-20.1451> ,0.09504,<4.62669,13.2055,-23.0635> ,0.0864}
sphere{<3.21632,12.1967,-20.1451> ,0.09504}
texture{txttree matrix <0.581746,-0.81337,0,0.415459,0.297148,-0.859707,0.69926,0.500131,0.510787,3.21632,12.1967,-20.1451> }}
union{cone{<4.62669,13.2055,-23.0635> ,0.0864,<5.44721,14.9586,-25.599> ,0.07776}
sphere{<4.62669,13.2055,-23.0635> ,0.0864}
texture{txttree matrix <0.905709,-0.423901,0,0.257225,0.549588,-0.794851,0.336938,0.719904,0.606804,4.62669,13.2055,-23.0635> }}
union{cone{<0.743724,9.91428,-11.7053> ,0.1296,<0.086377,12.7572,-13.5058> ,0.12096}
sphere{<0.743724,9.91428,-11.7053> ,0.1296}
texture{txttree matrix <0.974293,0.225283,0,-0.191721,0.829145,-0.52513,-0.118303,0.511631,0.851022,0.743724,9.91428,-11.7053> }}
union{cone{<0.086377,12.7572,-13.5058> ,0.12096,<-0.579326,15.71,-14.506> ,0.11232}
sphere{<0.086377,12.7572,-13.5058> ,0.12096}
texture{txttree matrix <0.975516,0.219927,0,-0.208822,0.926257,-0.313755,-0.0690033,0.306073,0.949504,0.086377,12.7572,-13.5058> }}
union{cone{<-0.579326,15.71,-14.506> ,0.11232,<-0.307079,18.6448,-15.5663> ,0.10368}
sphere{<-0.579326,15.71,-14.506> ,0.11232}
texture{txttree matrix <0.995725,-0.0923681,0,0.0869153,0.936944,-0.338498,0.0312664,0.337051,0.940967,-0.579326,15.71,-14.506> }}
union{cone{<-0.307079,18.6448,-15.5663> ,0.10368,<-0.373719,21.7461,-16.8304> ,0.09504}
sphere{<-0.307079,18.6448,-15.5663> ,0.10368}
texture{txttree matrix <0.999769,0.0214824,0,-0.0198942,0.925854,-0.377358,-0.00810657,0.377271,0.926067,-0.307079,18.6448,-15.5663> }}
union{cone{<-0.373719,21.7461,-16.8304> ,0.09504,<-0.763601,24.8715,-18.0362> ,0.0864}
sphere{<-0.373719,21.7461,-16.8304> ,0.09504}
texture{txttree matrix <0.992309,0.123789,0,-0.115605,0.926707,-0.357562,-0.0442622,0.354812,0.933889,-0.373719,21.7461,-16.8304> }}
union{cone{<-0.763601,24.8715,-18.0362> ,0.0864,<-0.0625252,27.5652,-19.9811> ,0.07776}
sphere{<-0.763601,24.8715,-18.0362> ,0.0864}
texture{txttree matrix <0.96776,-0.251874,0,0.206466,0.793292,-0.572765,0.144264,0.554299,0.81972,-0.763601,24.8715,-18.0362> }}
union{cone{<-1.06397,2.83271,-4.65198> ,0.216,<-0.541227,3.70559,-5.97639> ,0.203657}
sphere{<-1.06397,2.83271,-4.65198> ,0.216}
texture{txttree matrix <0.857921,-0.513782,0,0.313002,0.522655,-0.793007,0.407433,0.680337,0.609212,-1.06397,2.83271,-4.65198> }}
union{cone{<-0.541227,3.70559,-5.97639> ,0.203657,<0.51857,3.77701,-7.33872> ,0.191314}
sphere{<-0.541227,3.70559,-5.97639> ,0.203657}
texture{txttree matrix <0.0672371,-0.997737,0,0.613489,0.0413428,-0.78862,0.786835,0.0530245,0.614881,-0.541227,3.70559,-5.97639> }}
union{cone{<0.51857,3.77701,-7.33872> ,0.191314,<1.50515,4.3919,-8.53772> ,0.178971}
sphere{<0.51857,3.77701,-7.33872> ,0.191314}
texture{txttree matrix <0.528928,-0.848667,0,0.590756,0.368186,-0.717946,0.609297,0.379742,0.696099,0.51857,3.77701,-7.33872> }}
union{cone{<1.50515,4.3919,-8.53772> ,0.178971,<2.03307,5.26843,-9.93288> ,0.166629}
sphere{<1.50515,4.3919,-8.53772> ,0.178971}
texture{txttree matrix <0.85663,-0.515931,0,0.305125,0.506617,-0.806373,0.416033,0.690764,0.591407,1.50515,4.3919,-8.53772> }}
union{cone{<2.03307,5.26843,-9.93288> ,0.166629,<2.39715,6.29223,-11.2228> ,0.154286}
sphere{<2.03307,5.26843,-9.93288> ,0.166629}
texture{txttree matrix <0.942199,-0.335053,0,0.215867,0.607036,-0.764794,0.256247,0.720588,0.644275,2.03307,5.26843,-9.93288> }}
union{cone{<2.39715,6.29223,-11.2228> ,0.154286,<3.10476,6.91677,-12.6511> ,0.141943}
sphere{<2.39715,6.29223,-11.2228> ,0.154286}
texture{txttree matrix <0.661723,-0.749748,0,0.413323,0.364796,-0.834319,0.625529,0.552088,0.551282,2.39715,6.29223,-11.2228> }}
union{cone{<3.10476,6.91677,-12.6511> ,0.141943,<3.78093,7.40225,-14.2921> ,0.1296}
sphere{<3.10476,6.91677,-12.6511> ,0.141943}
texture{txttree matrix <0.583227,-0.812309,0,0.367483,0.263848,-0.891819,0.724433,0.520133,0.452393,3.10476,6.91677,-12.6511> }}
union{cone{<3.78093,7.40225,-14.2921> ,0.1296,<5.21406,10.0314,-15.944> ,0.12096}
sphere{<3.78093,7.40225,-14.2921> ,0.1296}
texture{txttree matrix <0.878031,-0.478604,0,0.419065,0.768803,-0.483039,0.231185,0.424123,0.875599,3.78093,7.40225,-14.2921> }}
union{cone{<5.21406,10.0314,-15.944> ,0.12096,<6.92406,12.4099,-17.4851> ,0.11232}
sphere{<5.21406,10.0314,-15.944> ,0.12096}
texture{txttree matrix <0.811944,-0.583735,0,0.516605,0.718569,-0.465594,0.271783,0.378036,0.884999,5.21406,10.0314,-15.944> }}
union{cone{<6.92406,12.4099,-17.4851> ,0.11232,<7.95483,14.521,-19.8534> ,0.10368}
sphere{<6.92406,12.4099,-17.4851> ,0.11232}
texture{txttree matrix <0.898607,-0.438754,0,0.308998,0.632855,-0.70994,0.311489,0.637957,0.704262,6.92406,12.4099,-17.4851> }}
union{cone{<7.95483,14.521,-19.8534> ,0.10368,<8.90507,16.8189,-21.9865> ,0.09504}
sphere{<7.95483,14.521,-19.8534> ,0.10368}
texture{txttree matrix <0.9241,-0.38215,0,0.290045,0.701376,-0.651112,0.248822,0.601692,0.758982,7.95483,14.521,-19.8534> }}
union{cone{<8.90507,16.8189,-21.9865> ,0.09504,<9.48424,18.8724,-24.351> ,0.0864}
sphere{<8.90507,16.8189,-21.9865> ,0.09504}
texture{txttree matrix <0.962453,-0.271449,0,0.181856,0.644792,-0.74241,0.201526,0.714534,0.669946,8.90507,16.8189,-21.9865> }}
union{cone{<9.48424,18.8724,-24.351> ,0.0864,<10.0692,20.886,-26.8369> ,0.07776}
sphere{<9.48424,18.8724,-24.351> ,0.0864}
texture{txttree matrix <0.960293,-0.278994,0,0.179883,0.619156,-0.764387,0.213259,0.734036,0.644758,9.48424,18.8724,-24.351> }}
union{cone{<1.09405,4.13568,-8.0381> ,0.1296,<3.99657,3.0983,-9.44084> ,0.12096}
sphere{<1.09405,4.13568,-8.0381> ,0.1296}
texture{txttree matrix <-0.336555,-0.941664,0,0.857084,-0.306325,-0.414213,0.390049,-0.139405,0.91018,1.09405,4.13568,-8.0381> }}
union{cone{<3.99657,3.0983,-9.44084> ,0.12096,<6.51316,4.0881,-11.3541> ,0.11232}
sphere{<3.99657,3.0983,-9.44084> ,0.12096}
texture{txttree matrix <0.366017,-0.930608,0,0.759692,0.298794,-0.577573,0.537494,0.211401,0.816339,3.99657,3.0983,-9.44084> }}
union{cone{<6.51316,4.0881,-11.3541> ,0.11232,<9.33016,5.04556,-13.0255> ,0.10368}
sphere{<6.51316,4.0881,-11.3541> ,0.11232}
texture{txttree matrix <0.321805,-0.946806,0,0.825474,0.280567,-0.48977,0.463717,0.157611,0.871852,6.51316,4.0881,-11.3541> }}
union{cone{<9.33016,5.04556,-13.0255> ,0.10368,<11.7179,6.62897,-14.58> ,0.09504}
sphere{<9.33016,5.04556,-13.0255> ,0.10368}
texture{txttree matrix <0.552668,-0.833402,0,0.732524,0.485771,-0.476901,0.39745,0.263568,0.878957,9.33016,5.04556,-13.0255> }}
union{cone{<11.7179,6.62897,-14.58> ,0.09504,<13.1981,8.63558,-16.7071> ,0.0864}
sphere{<11.7179,6.62897,-14.58> ,0.09504}
texture{txttree matrix <0.804734,-0.593635,0,0.451631,0.612233,-0.648999,0.385269,0.522272,0.760789,11.7179,6.62897,-14.58> }}
union{cone{<13.1981,8.63558,-16.7071> ,0.0864,<15.138,9.89185,-18.8305> ,0.07776}
sphere{<13.1981,8.63558,-16.7071> ,0.0864}
texture{txttree matrix <0.543582,-0.839356,0,0.61808,0.40028,-0.676574,0.567887,0.367773,0.736374,13.1981,8.63558,-16.7071> }}
union{cone{<1.51214,4.4035,-8.55618> ,0.1296,<2.32817,4.20326,-11.5949> ,0.12096}
sphere{<1.51214,4.4035,-8.55618> ,0.1296}
texture{txttree matrix <-0.238311,-0.971189,0,0.258828,-0.0635114,-0.963833,0.936064,-0.229692,0.266507,1.51214,4.4035,-8.55618> }}
union{cone{<2.32817,4.20326,-11.5949> ,0.12096,<3.4283,5.80282,-14.3551> ,0.11232}
sphere{<2.32817,4.20326,-11.5949> ,0.12096}
texture{txttree matrix <0.823936,-0.566683,0,0.326013,0.474012,-0.817941,0.463513,0.673931,0.575302,2.32817,4.20326,-11.5949> }}
union{cone{<3.4283,5.80282,-14.3551> ,0.11232,<4.7807,6.29578,-17.196> ,0.10368}
sphere{<3.4283,5.80282,-14.3551> ,0.11232}
texture{txttree matrix <0.342466,-0.93953,0,0.424647,0.154787,-0.892029,0.838088,0.30549,0.451979,3.4283,5.80282,-14.3551> }}
union{cone{<4.7807,6.29578,-17.196> ,0.10368,<4.97445,6.83309,-20.3616> ,0.09504}
sphere{<4.7807,6.29578,-17.196> ,0.10368}
texture{txttree matrix <0.940711,-0.339208,0,0.0602312,0.167036,-0.984109,0.333818,0.925763,0.177564,4.7807,6.29578,-17.196> }}
union{cone{<4.97445,6.83309,-20.3616> ,0.09504,<4.9563,8.31633,-23.1332> ,0.0864}
sphere{<4.97445,6.83309,-20.3616> ,0.09504}
texture{txttree matrix <0.999925,0.0122404,0,-0.00577586,0.471835,-0.881668,-0.0107919,0.881602,0.47187,4.97445,6.83309,-20.3616> }}
union{cone{<4.9563,8.31633,-23.1332> ,0.0864,<4.89059,9.63489,-26.1382> ,0.07776}
sphere{<4.9563,8.31633,-23.1332> ,0.0864}
texture{txttree matrix <0.998761,0.0497718,0,-0.0200195,0.401728,-0.91554,-0.0455681,0.914406,0.402226,4.9563,8.31633,-23.1332> }}
union{cone{<2.43715,6.32754,-11.3035> ,0.1296,<2.22227,6.45804,-14.5312> ,0.12096}
sphere{<2.43715,6.32754,-11.3035> ,0.1296}
texture{txttree matrix <0.519066,0.854734,0,-0.0663732,0.0403073,-0.99698,-0.852153,0.517498,0.0776536,2.43715,6.32754,-11.3035> }}
union{cone{<2.22227,6.45804,-14.5312> ,0.12096,<2.65529,7.57992,-17.7028> ,0.11232}
sphere{<2.22227,6.45804,-14.5312> ,0.12096}
texture{txttree matrix <0.93292,-0.360084,0,0.127663,0.330755,-0.935042,0.336694,0.872319,0.354538,2.22227,6.45804,-14.5312> }}
union{cone{<2.65529,7.57992,-17.7028> ,0.11232,<2.04371,8.37402,-20.99> ,0.10368}
sphere{<2.65529,7.57992,-17.7028> ,0.11232}
texture{txttree matrix <0.792272,0.610168,0,-0.177958,0.231069,-0.956524,-0.583641,0.757827,0.291654,2.65529,7.57992,-17.7028> }}
union{cone{<2.04371,8.37402,-20.99> ,0.10368,<2.61647,10.3976,-23.5037> ,0.09504}
sphere{<2.04371,8.37402,-20.99> ,0.10368}
texture{txttree matrix <0.9622,-0.272343,0,0.174761,0.617439,-0.76696,0.208876,0.73797,0.641694,2.04371,8.37402,-20.99> }}
union{cone{<2.61647,10.3976,-23.5037> ,0.09504,<2.44581,12.2182,-26.1526> ,0.0864}
sphere{<2.61647,10.3976,-23.5037> ,0.09504}
texture{txttree matrix <0.995635,0.0933272,0,-0.0530188,0.565616,-0.822963,-0.0768048,0.819371,0.568096,2.61647,10.3976,-23.5037> }}
union{cone{<2.44581,12.2182,-26.1526> ,0.0864,<1.90835,13.5984,-28.9729> ,0.07776}
sphere{<2.44581,12.2182,-26.1526> ,0.0864}
texture{txttree matrix <0.931834,0.362884,0,-0.168721,0.433251,-0.88534,-0.321276,0.82499,0.464944,2.44581,12.2182,-26.1526> }}
union{cone{<-0.696016,3.44712,-5.58422> ,0.1296,<-1.61341,5.36806,-8.0342> ,0.12096}
sphere{<-0.696016,3.44712,-5.58422> ,0.1296}
texture{txttree matrix <0.902374,0.430954,0,-0.282657,0.591856,-0.754858,-0.325309,0.681165,0.655888,-0.696016,3.44712,-5.58422> }}
union{cone{<-1.61341,5.36806,-8.0342> ,0.12096,<-2.03045,7.84091,-9.94815> ,0.11232}
sphere{<-1.61341,5.36806,-8.0342> ,0.12096}
texture{txttree matrix <0.986075,0.1663,0,-0.132197,0.783862,-0.606699,-0.100894,0.598251,0.794932,-1.61341,5.36806,-8.0342> }}
union{cone{<-2.03045,7.84091,-9.94815> ,0.11232,<-1.76952,10.7957,-11.4969> ,0.10368}
sphere{<-2.03045,7.84091,-9.94815> ,0.11232}
texture{txttree matrix <0.996123,-0.0879678,0,0.077979,0.883013,-0.462826,0.0407138,0.461032,0.886449,-2.03045,7.84091,-9.94815> }}
union{cone{<-1.76952,10.7957,-11.4969> ,0.10368,<-1.51183,12.5015,-14.272> ,0.09504}
sphere{<-1.76952,10.7957,-11.4969> ,0.10368}
texture{txttree matrix <0.988782,-0.149369,0,0.0788596,0.522029,-0.849275,0.126855,0.839747,0.527951,-1.76952,10.7957,-11.4969> }}
union{cone{<-1.51183,12.5015,-14.272> ,0.09504,<-1.24129,14.9998,-16.1969> ,0.0864}
sphere{<-1.51183,12.5015,-14.272> ,0.09504}
texture{txttree matrix <0.994188,-0.107661,0,0.0854686,0.789252,-0.608093,0.0654681,0.604559,0.793866,-1.51183,12.5015,-14.272> }}
union{cone{<-1.24129,14.9998,-16.1969> ,0.0864,<-1.10217,17.7712,-17.9003> ,0.07776}
sphere{<-1.24129,14.9998,-16.1969> ,0.0864}
texture{txttree matrix <0.998742,-0.0501346,0,0.0427266,0.851168,-0.523152,0.026228,0.522494,0.852239,-1.24129,14.9998,-16.1969> }}
union{cone{<-0.948946,3.25691,-5.63594> ,0.216,<-1.45599,3.32573,-7.32532> ,0.203657}
sphere{<-0.948946,3.25691,-5.63594> ,0.216}
texture{txttree matrix <0.134492,0.990915,0,-0.28725,0.0389872,-0.957062,-0.948367,0.128718,0.289884,-0.948946,3.25691,-5.63594> }}
union{cone{<-1.45599,3.32573,-7.32532> ,0.203657,<-1.86815,3.47884,-8.97126> ,0.191314}
sphere{<-1.45599,3.32573,-7.32532> ,0.203657}
texture{txttree matrix <0.348234,0.937408,0,-0.241925,0.0898719,-0.966124,-0.905652,0.336437,0.258079,-1.45599,3.32573,-7.32532> }}
union{cone{<-1.86815,3.47884,-8.97126> ,0.191314,<-2.0996,4.61234,-10.3455> ,0.178971}
sphere{<-1.86815,3.47884,-8.97126> ,0.191314}
texture{txttree matrix <0.979782,0.200067,0,-0.128845,0.63099,-0.765017,-0.153054,0.74955,0.64401,-1.86815,3.47884,-8.97126> }}
union{cone{<-2.0996,4.61234,-10.3455> ,0.178971,<-2.97989,5.08783,-11.8719> ,0.166629}
sphere{<-2.0996,4.61234,-10.3455> ,0.178971}
texture{txttree matrix <0.475256,0.879848,0,-0.482324,0.260531,-0.836354,-0.735864,0.397482,0.54819,-2.0996,4.61234,-10.3455> }}
union{cone{<-2.97989,5.08783,-11.8719> ,0.166629,<-3.15275,5.62897,-13.4693> ,0.154286}
sphere{<-2.97989,5.08783,-11.8719> ,0.166629}
texture{txttree matrix <0.95258,0.304287,0,-0.101961,0.319192,-0.942189,-0.286696,0.897511,0.335081,-2.97989,5.08783,-11.8719> }}
union{cone{<-3.15275,5.62897,-13.4693> ,0.154286,<-3.37387,6.80798,-14.6907> ,0.141943}
sphere{<-3.15275,5.62897,-13.4693> ,0.154286}
texture{txttree matrix <0.982863,0.184336,0,-0.129164,0.688693,-0.713456,-0.131516,0.701229,0.7007,-3.15275,5.62897,-13.4693> }}
union{cone{<-3.37387,6.80798,-14.6907> ,0.141943,<-3.76042,8.07902,-15.9537> ,0.1296}
sphere{<-3.37387,6.80798,-14.6907> ,0.141943}
texture{txttree matrix <0.956734,0.290965,0,-0.210875,0.693388,-0.689017,-0.20048,0.659206,0.724745,-3.37387,6.80798,-14.6907> }}
union{cone{<-3.76042,8.07902,-15.9537> ,0.1296,<-4.44857,10.2363,-18.261> ,0.12096}
sphere{<-3.76042,8.07902,-15.9537> ,0.1296}
texture{txttree matrix <0.952706,0.303893,0,-0.212861,0.667318,-0.713707,-0.216891,0.679953,0.700445,-3.76042,8.07902,-15.9537> }}
union{cone{<-4.44857,10.2363,-18.261> ,0.12096,<-5.43817,12.2799,-20.7074> ,0.11232}
sphere{<-4.44857,10.2363,-18.261> ,0.12096}
texture{txttree matrix <0.900024,0.43584,0,-0.296489,0.612259,-0.732962,-0.319454,0.659683,0.68027,-4.44857,10.2363,-18.261> }}
union{cone{<-5.43817,12.2799,-20.7074> ,0.11232,<-7.01607,14.586,-22.2512> ,0.10368}
sphere{<-5.43817,12.2799,-20.7074> ,0.11232}
texture{txttree matrix <0.825296,0.5647,0,-0.494285,0.722385,-0.483572,-0.273073,0.39909,0.875305,-5.43817,12.2799,-20.7074> }}
union{cone{<-7.01607,14.586,-22.2512> ,0.10368,<-7.85133,17.2866,-24.064> ,0.09504}
sphere{<-7.01607,14.586,-22.2512> ,0.10368}
texture{txttree matrix <0.955352,0.295471,0,-0.248722,0.804199,-0.539815,-0.1595,0.515714,0.841783,-7.01607,14.586,-22.2512> }}
union{cone{<-7.85133,17.2866,-24.064> ,0.09504,<-8.63563,19.6854,-26.3033> ,0.0864}
sphere{<-7.85133,17.2866,-24.064> ,0.09504}
texture{txttree matrix <0.950484,0.310772,0,-0.232454,0.71095,-0.663713,-0.206264,0.630849,0.747987,-7.85133,17.2866,-24.064> }}
union{cone{<-8.63563,19.6854,-26.3033> ,0.0864,<-9.68395,22.4508,-27.7302> ,0.07776}
sphere{<-8.63563,19.6854,-26.3033> ,0.0864}
texture{txttree matrix <0.935068,0.354467,0,-0.319254,0.842178,-0.434527,-0.154026,0.406312,0.900659,-8.63563,19.6854,-26.3033> }}
union{cone{<-1.74448,3.4329,-8.47739> ,0.1296,<-3.14573,3.91525,-11.5367> ,0.12096}
sphere{<-1.74448,3.4329,-8.47739> ,0.1296}
texture{txttree matrix <0.325484,0.945548,0,-0.41221,0.141894,-0.899972,-0.850966,0.292926,0.435949,-1.74448,3.4329,-8.47739> }}
union{cone{<-3.14573,3.91525,-11.5367> ,0.12096,<-5.07908,2.61152,-13.8812> ,0.11232}
sphere{<-3.14573,3.91525,-11.5367> ,0.12096}
texture{txttree matrix <-0.559094,0.829104,0,-0.584673,-0.394266,-0.709021,-0.587853,-0.39641,0.705187,-3.14573,3.91525,-11.5367> }}
union{cone{<-5.07908,2.61152,-13.8812> ,0.11232,<-6.24671,3.48796,-16.9392> ,0.10368}
sphere{<-5.07908,2.61152,-13.8812> ,0.11232}
texture{txttree matrix <0.600314,0.799765,0,-0.344579,0.258645,-0.902424,-0.721726,0.541737,0.43085,-5.07908,2.61152,-13.8812> }}
union{cone{<-6.24671,3.48796,-16.9392> ,0.10368,<-6.64742,4.20678,-20.1177> ,0.09504}
sphere{<-6.24671,3.48796,-16.9392> ,0.10368}
texture{txttree matrix <0.873451,0.486912,0,-0.122045,0.218932,-0.968077,-0.471368,0.845568,0.250651,-6.24671,3.48796,-16.9392> }}
union{cone{<-6.64742,4.20678,-20.1177> ,0.09504,<-8.3737,4.16524,-22.9031> ,0.0864}
sphere{<-6.64742,4.20678,-20.1177> ,0.09504}
texture{txttree matrix <-0.0240538,0.999711,0,-0.526748,-0.0126739,-0.849927,-0.849681,-0.0204439,0.526901,-6.64742,4.20678,-20.1177> }}
union{cone{<-8.3737,4.16524,-22.9031> ,0.0864,<-8.68456,4.84539,-25.9953> ,0.07776}
sphere{<-8.3737,4.16524,-22.9031> ,0.0864}
texture{txttree matrix <0.909506,0.41569,0,-0.0977112,0.213787,-0.971981,-0.404043,0.884023,0.235058,-8.3737,4.16524,-22.9031> }}
union{cone{<-1.23989,5.47624,-8.43022> ,0.216,<-2.62485,6.5267,-8.47697> ,0.203657}
sphere{<-1.23989,5.47624,-8.43022> ,0.216}
texture{txttree matrix <0.604318,0.796743,0,-0.796455,0.6041,-0.0268851,-0.0214205,0.0162472,0.999639,-1.23989,5.47624,-8.43022> }}
union{cone{<-2.62485,6.5267,-8.47697> ,0.203657,<-3.2505,7.69002,-9.5039> ,0.191314}
sphere{<-2.62485,6.5267,-8.47697> ,0.203657}
texture{txttree matrix <0.880707,0.473661,0,-0.373945,0.695299,-0.613779,-0.290723,0.54056,0.789478,-2.62485,6.5267,-8.47697> }}
union{cone{<-3.2505,7.69002,-9.5039> ,0.191314,<-4.20462,8.46518,-10.6981> ,0.178971}
sphere{<-3.2505,7.69002,-9.5039> ,0.191314}
texture{txttree matrix <0.630561,0.77614,0,-0.556706,0.452285,-0.69679,-0.540807,0.439368,0.717275,-3.2505,7.69002,-9.5039> }}
union{cone{<-4.20462,8.46518,-10.6981> ,0.178971,<-4.76271,9.70995,-11.7456> ,0.166629}
sphere{<-4.20462,8.46518,-10.6981> ,0.178971}
texture{txttree matrix <0.912484,0.409113,0,-0.324483,0.723726,-0.609041,-0.249166,0.55574,0.793139,-4.20462,8.46518,-10.6981> }}
union{cone{<-4.76271,9.70995,-11.7456> ,0.166629,<-5.55926,11.1702,-12.4425> ,0.154286}
sphere{<-4.76271,9.70995,-11.7456> ,0.166629}
texture{txttree matrix <0.877891,0.478861,0,-0.441667,0.809703,-0.386409,-0.185036,0.339225,0.922328,-4.76271,9.70995,-11.7456> }}
union{cone{<-5.55926,11.1702,-12.4425> ,0.154286,<-6.13986,12.5295,-13.4853> ,0.141943}
sphere{<-5.55926,11.1702,-12.4425> ,0.154286}
texture{txttree matrix <0.919615,0.392821,0,-0.320973,0.751414,-0.576501,-0.226462,0.530159,0.817096,-5.55926,11.1702,-12.4425> }}
union{cone{<-6.13986,12.5295,-13.4853> ,0.141943,<-7.16138,13.569,-14.4772> ,0.1296}
sphere{<-6.13986,12.5295,-13.4853> ,0.141943}
texture{txttree matrix <0.713261,0.700898,0,-0.579446,0.589667,-0.562615,-0.394336,0.401292,0.826719,-6.13986,12.5295,-13.4853> }}
union{cone{<-7.16138,13.569,-14.4772> ,0.1296,<-9.43715,15.35,-15.816> ,0.12096}
sphere{<-7.16138,13.569,-14.4772> ,0.1296}
texture{txttree matrix <0.616306,0.787507,0,-0.71455,0.55921,-0.420361,-0.331037,0.259071,0.907357,-7.16138,13.569,-14.4772> }}
union{cone{<-9.43715,15.35,-15.816> ,0.12096,<-11.1327,17.34,-17.5654> ,0.11232}
sphere{<-9.43715,15.35,-15.816> ,0.12096}
texture{txttree matrix <0.761175,0.648546,0,-0.539001,0.632606,-0.556137,-0.360681,0.423318,0.831091,-9.43715,15.35,-15.816> }}
union{cone{<-11.1327,17.34,-17.5654> ,0.11232,<-13.6867,19.2693,-18.6245> ,0.10368}
sphere{<-11.1327,17.34,-17.5654> ,0.11232}
texture{txttree matrix <0.602762,0.797921,0,-0.757529,0.572249,-0.314136,-0.250656,0.18935,0.949378,-11.1327,17.34,-17.5654> }}
union{cone{<-13.6867,19.2693,-18.6245> ,0.10368,<-14.9321,22.2626,-19.5329> ,0.09504}
sphere{<-13.6867,19.2693,-18.6245> ,0.10368}
texture{txttree matrix <0.923269,0.384155,0,-0.369909,0.889029,-0.269804,-0.103647,0.249102,0.962915,-13.6867,19.2693,-18.6245> }}
union{cone{<-14.9321,22.2626,-19.5329> ,0.09504,<-16.032,25.0125,-20.5091> ,0.0864}
sphere{<-14.9321,22.2626,-19.5329> ,0.09504}
texture{txttree matrix <0.92849,0.371357,0,-0.352691,0.88182,-0.313053,-0.116254,0.290666,0.949736,-14.9321,22.2626,-19.5329> }}
union{cone{<-16.032,25.0125,-20.5091> ,0.0864,<-16.9178,27.402,-22.3371> ,0.07776}
sphere{<-16.032,25.0125,-20.5091> ,0.0864}
texture{txttree matrix <0.937644,0.347598,0,-0.282454,0.761919,-0.582837,-0.202593,0.546494,0.812589,-16.032,25.0125,-20.5091> }}
union{cone{<-2.28813,6.27131,-8.4656> ,0.1296,<-4.45231,8.51582,-8.72468> ,0.12096}
sphere{<-2.28813,6.27131,-8.4656> ,0.1296}
texture{txttree matrix <0.719871,0.694108,0,-0.691724,0.717399,-0.0828084,-0.057478,0.0596114,0.996565,-2.28813,6.27131,-8.4656> }}
union{cone{<-4.45231,8.51582,-8.72468> ,0.12096,<-7.19124,10.0792,-9.98139> ,0.11232}
sphere{<-4.45231,8.51582,-8.72468> ,0.12096}
texture{txttree matrix <0.495717,0.868484,0,-0.806787,0.460501,-0.370181,-0.321496,0.183505,0.92896,-4.45231,8.51582,-8.72468> }}
union{cone{<-7.19124,10.0792,-9.98139> ,0.11232,<-9.25488,12.4346,-10.4805> ,0.10368}
sphere{<-7.19124,10.0792,-9.98139> ,0.11232}
texture{txttree matrix <0.752158,0.658983,0,-0.650769,0.742781,-0.157404,-0.103727,0.118393,0.987534,-7.19124,10.0792,-9.98139> }}
union{cone{<-9.25488,12.4346,-10.4805> ,0.10368,<-10.7281,15.4112,-11.1133> ,0.09504}
sphere{<-9.25488,12.4346,-10.4805> ,0.10368}
texture{txttree matrix <0.896234,0.443582,0,-0.435744,0.880397,-0.187159,-0.0830204,0.167738,0.98233,-9.25488,12.4346,-10.4805> }}
union{cone{<-10.7281,15.4112,-11.1133> ,0.09504,<-11.39,18.1498,-12.7687> ,0.0864}
sphere{<-10.7281,15.4112,-11.1133> ,0.09504}
texture{txttree matrix <0.972012,0.23493,0,-0.202554,0.838061,-0.506582,-0.119011,0.492404,0.862192,-10.7281,15.4112,-11.1133> }}
union{cone{<-11.39,18.1498,-12.7687> ,0.0864,<-12.4544,21.0444,-13.8858> ,0.07776}
sphere{<-11.39,18.1498,-12.7687> ,0.0864}
texture{txttree matrix <0.938561,0.345114,0,-0.324485,0.88246,-0.340548,-0.117528,0.319625,0.940227,-11.39,18.1498,-12.7687> }}
union{cone{<-5.79036,11.7113,-12.8576> ,0.1296,<-8.04593,12.0673,-15.0837> ,0.12096}
sphere{<-5.79036,11.7113,-12.8576> ,0.1296}
texture{txttree matrix <0.155919,0.98777,0,-0.707291,0.111646,-0.69805,-0.689513,0.10884,0.716049,-5.79036,11.7113,-12.8576> }}
union{cone{<-8.04593,12.0673,-15.0837> ,0.12096,<-8.84151,12.9066,-18.0572> ,0.11232}
sphere{<-8.04593,12.0673,-15.0837> ,0.12096}
texture{txttree matrix <0.725773,0.687934,0,-0.249359,0.263075,-0.931993,-0.64115,0.676416,0.362476,-8.04593,12.0673,-15.0837> }}
union{cone{<-8.84151,12.9066,-18.0572> ,0.11232,<-10.2894,15.0369,-20.1638> ,0.10368}
sphere{<-8.84151,12.9066,-18.0572> ,0.11232}
texture{txttree matrix <0.827054,0.562123,0,-0.435126,0.640202,-0.633093,-0.355876,0.523602,0.774076,-8.84151,12.9066,-18.0572> }}
union{cone{<-10.2894,15.0369,-20.1638> ,0.10368,<-11.1113,16.0435,-23.0579> ,0.09504}
sphere{<-10.2894,15.0369,-20.1638> ,0.10368}
texture{txttree matrix <0.774592,0.632461,0,-0.259078,0.317299,-0.91225,-0.576963,0.706622,0.409634,-10.2894,15.0369,-20.1638> }}
union{cone{<-11.1113,16.0435,-23.0579> ,0.09504,<-11.8893,18.0917,-25.4516> ,0.0864}
sphere{<-11.1113,16.0435,-23.0579> ,0.09504}
texture{txttree matrix <0.934825,0.355108,0,-0.239759,0.63117,-0.737659,-0.261948,0.689582,0.675174,-11.1113,16.0435,-23.0579> }}
union{cone{<-11.8893,18.0917,-25.4516> ,0.0864,<-13.2874,20.2197,-27.6015> ,0.07776}
sphere{<-11.8893,18.0917,-25.4516> ,0.0864}
texture{txttree matrix <0.83577,0.549079,0,-0.419534,0.638585,-0.645136,-0.354231,0.539185,0.764068,-11.8893,18.0917,-25.4516> }}
union{cone{<-1.54889,1.32236,-2.78978> ,0.36,<-0.913155,1.15782,-3.47078> ,0.342}
sphere{<-1.54889,1.32236,-2.78978> ,0.36}
texture{txttree matrix <-0.25057,-0.968099,0,0.671991,-0.173929,-0.719845,0.696881,-0.180371,0.694135,-1.54889,1.32236,-2.78978> }}
union{cone{<-0.913155,1.15782,-3.47078> ,0.342,<-0.196564,0.77015,-3.95487> ,0.324}
sphere{<-0.913155,1.15782,-3.47078> ,0.342}
texture{txttree matrix <-0.475822,-0.879542,0,0.75614,-0.409063,-0.510803,0.449273,-0.243051,0.859698,-0.913155,1.15782,-3.47078> }}
union{cone{<-0.196564,0.77015,-3.95487> ,0.324,<0.216593,1.00852,-4.79213> ,0.306}
sphere{<-0.196564,0.77015,-3.95487> ,0.324}
texture{txttree matrix <0.499736,-0.866178,0,0.428764,0.247372,-0.868889,0.752613,0.434215,0.495007,-0.196564,0.77015,-3.95487> }}
union{cone{<0.216593,1.00852,-4.79213> ,0.306,<0.764437,1.05959,-5.52219> ,0.288}
sphere{<0.216593,1.00852,-4.79213> ,0.306}
texture{txttree matrix <0.0928202,-0.995683,0,0.599275,0.055866,-0.798592,0.795144,0.0741255,0.601873,0.216593,1.00852,-4.79213> }}
union{cone{<0.764437,1.05959,-5.52219> ,0.288,<1.11545,0.903095,-6.35326> ,0.27}
sphere{<0.764437,1.05959,-5.52219> ,0.288}
texture{txttree matrix <-0.407204,-0.913337,0,0.383355,-0.170915,-0.907649,0.82899,-0.369598,0.419729,0.764437,1.05959,-5.52219> }}
union{cone{<1.11545,0.903095,-6.35326> ,0.27,<1.57782,0.927611,-7.17774> ,0.252}
sphere{<1.11545,0.903095,-6.35326> ,0.27}
texture{txttree matrix <0.0529495,-0.998597,0,0.48897,0.0259271,-0.871915,0.870692,0.0461675,0.489657,1.11545,0.903095,-6.35326> }}
union{cone{<1.57782,0.927611,-7.17774> ,0.252,<2.05644,0.996976,-7.97075> ,0.234}
sphere{<1.57782,0.927611,-7.17774> ,0.252}
texture{txttree matrix <0.14343,-0.98966,0,0.515284,0.0746794,-0.853759,0.844932,0.122455,0.520668,1.57782,0.927611,-7.17774> }}
union{cone{<2.05644,0.996976,-7.97075> ,0.234,<2.24539,1.34398,-8.89386> ,0.216}
sphere{<2.05644,0.996976,-7.97075> ,0.234}
texture{txttree matrix <0.878236,-0.478228,0,0.188182,0.345584,-0.919325,0.439647,0.807384,0.393498,2.05644,0.996976,-7.97075> }}
union{cone{<2.24539,1.34398,-8.89386> ,0.216,<2.3917,2.86885,-9.77886> ,0.203657}
sphere{<2.24539,1.34398,-8.89386> ,0.216}
texture{txttree matrix <0.995428,-0.09551,0,0.0827005,0.861925,-0.500245,0.0477784,0.497958,0.865884,2.24539,1.34398,-8.89386> }}
union{cone{<2.3917,2.86885,-9.77886> ,0.203657,<2.76789,4.35055,-10.692> ,0.191314}
sphere{<2.3917,2.86885,-9.77886> ,0.203657}
texture{txttree matrix <0.969248,-0.246085,0,0.211267,0.832112,-0.512792,0.12619,0.497023,0.858513,2.3917,2.86885,-9.77886> }}
union{cone{<2.76789,4.35055,-10.692> ,0.191314,<3.35513,5.83334,-11.3663> ,0.178971}
sphere{<2.76789,4.35055,-10.692> ,0.191314}
texture{txttree matrix <0.929742,-0.368212,0,0.339139,0.856331,-0.389464,0.143406,0.362101,0.921042,2.76789,4.35055,-10.692> }}
union{cone{<3.35513,5.83334,-11.3663> ,0.178971,<4.10896,6.8591,-12.5276> ,0.166629}
sphere{<3.35513,5.83334,-11.3663> ,0.178971}
texture{txttree matrix <0.805802,-0.592185,0,0.437498,0.595315,-0.67394,0.399097,0.543062,0.738786,3.35513,5.83334,-11.3663> }}
union{cone{<4.10896,6.8591,-12.5276> ,0.166629,<4.68565,7.77997,-13.854> ,0.154286}
sphere{<4.10896,6.8591,-12.5276> ,0.166629}
texture{txttree matrix <0.847527,-0.530752,0,0.336335,0.537075,-0.773582,0.41058,0.655632,0.633696,4.10896,6.8591,-12.5276> }}
union{cone{<4.68565,7.77997,-13.854> ,0.154286,<4.91871,9.23893,-14.9069> ,0.141943}
sphere{<4.68565,7.77997,-13.854> ,0.154286}
texture{txttree matrix <0.98748,-0.157745,0,0.12846,0.804159,-0.580368,0.0915501,0.573101,0.814355,4.68565,7.77997,-13.854> }}
union{cone{<4.91871,9.23893,-14.9069> ,0.141943,<5.12686,10.7819,-15.8012> ,0.1296}
sphere{<4.91871,9.23893,-14.9069> ,0.141943}
texture{txttree matrix <0.991023,-0.133688,0,0.115926,0.859352,-0.498071,0.0665863,0.4936,0.867136,4.91871,9.23893,-14.9069> }}
union{cone{<5.12686,10.7819,-15.8012> ,0.1296,<6.06988,13.4952,-17.3667> ,0.12096}
sphere{<5.12686,10.7819,-15.8012> ,0.1296}
texture{txttree matrix <0.944574,-0.328298,0,0.288267,0.829398,-0.478541,0.157104,0.452018,0.878065,5.12686,10.7819,-15.8012> }}
union{cone{<6.06988,13.4952,-17.3667> ,0.12096,<7.50321,16.2197,-18.1717> ,0.11232}
sphere{<6.06988,13.4952,-17.3667> ,0.12096}
texture{txttree matrix <0.885004,-0.465583,0,0.450437,0.856215,-0.252988,0.117787,0.223896,0.967469,6.06988,13.4952,-17.3667> }}
union{cone{<7.50321,16.2197,-18.1717> ,0.11232,<8.51878,19.0474,-19.831> ,0.10368}
sphere{<7.50321,16.2197,-18.1717> ,0.11232}
texture{txttree matrix <0.941143,-0.33801,0,0.295887,0.823856,-0.483438,0.163407,0.454984,0.875378,7.50321,16.2197,-18.1717> }}
union{cone{<8.51878,19.0474,-19.831> ,0.10368,<8.3857,22.125,-20.9596> ,0.09504}
sphere{<8.51878,19.0474,-19.831> ,0.10368}
texture{txttree matrix <0.999066,0.0432005,0,-0.0405637,0.938087,-0.344016,-0.0148617,0.343695,0.938964,8.51878,19.0474,-19.831> }}
union{cone{<8.3857,22.125,-20.9596> ,0.09504,<8.53413,24.9873,-22.2965> ,0.0864}
sphere{<8.3857,22.125,-20.9596> ,0.09504}
texture{txttree matrix <0.998658,-0.0517865,0,0.0469324,0.90505,-0.422707,0.0218905,0.42214,0.906266,8.3857,22.125,-20.9596> }}
union{cone{<8.53413,24.9873,-22.2965> ,0.0864,<8.2161,27.6255,-24.0052> ,0.07776}
sphere{<8.53413,24.9873,-22.2965> ,0.0864}
texture{txttree matrix <0.992812,0.119682,0,-0.100666,0.835063,-0.540866,-0.064732,0.536978,0.841109,8.53413,24.9873,-22.2965> }}
union{cone{<3.9812,6.68524,-12.3308> ,0.1296,<6.5057,7.83115,-13.9919> ,0.12096}
sphere{<3.9812,6.68524,-12.3308> ,0.1296}
texture{txttree matrix <0.413326,-0.910583,0,0.781102,0.354553,-0.513976,0.468018,0.212439,0.857804,3.9812,6.68524,-12.3308> }}
union{cone{<6.5057,7.83115,-13.9919> ,0.12096,<9.1782,8.69478,-15.7314> ,0.11232}
sphere{<6.5057,7.83115,-13.9919> ,0.12096}
texture{txttree matrix <0.307498,-0.951549,0,0.808962,0.26142,-0.526537,0.501025,0.161909,0.850152,6.5057,7.83115,-13.9919> }}
union{cone{<9.1782,8.69478,-15.7314> ,0.11232,<11.5471,10.8429,-16.9125> ,0.10368}
sphere{<9.1782,8.69478,-15.7314> ,0.11232}
texture{txttree matrix <0.671734,-0.740792,0,0.694906,0.630126,-0.346478,0.256668,0.232741,0.938058,9.1782,8.69478,-15.7314> }}
union{cone{<11.5471,10.8429,-16.9125> ,0.10368,<12.5549,12.7592,-19.3836> ,0.09504}
sphere{<11.5471,10.8429,-16.9125> ,0.10368}
texture{txttree matrix <0.885081,-0.465436,0,0.30673,0.583283,-0.752129,0.350068,0.665695,0.659016,11.5471,10.8429,-16.9125> }}
union{cone{<12.5549,12.7592,-19.3836> ,0.09504,<14.1634,15.0306,-20.8666> ,0.0864}
sphere{<12.5549,12.7592,-19.3836> ,0.09504}
texture{txttree matrix <0.816093,-0.57792,0,0.510038,0.720235,-0.470238,0.27176,0.383758,0.88254,12.5549,12.7592,-19.3836> }}
union{cone{<14.1634,15.0306,-20.8666> ,0.0864,<15.8706,16.5228,-23.4152> ,0.07776}
sphere{<14.1634,15.0306,-20.8666> ,0.0864}
texture{txttree matrix <0.658097,-0.752934,0,0.50046,0.437424,-0.747128,0.562537,0.491682,0.664681,14.1634,15.0306,-20.8666> }}
union{cone{<3.49902,6.02913,-11.588> ,0.1296,<4.71736,8.12177,-13.6819> ,0.12096}
sphere{<3.49902,6.02913,-11.588> ,0.1296}
texture{txttree matrix <0.864205,-0.50314,0,0.380584,0.6537,-0.654088,0.329098,0.565266,0.756418,3.49902,6.02913,-11.588> }}
union{cone{<4.71736,8.12177,-13.6819> ,0.12096,<5.10969,9.42794,-16.672> ,0.11232}
sphere{<4.71736,8.12177,-13.6819> ,0.12096}
texture{txttree matrix <0.957728,-0.287676,0,0.11938,0.39744,-0.90983,0.261736,0.871369,0.414982,4.71736,8.12177,-13.6819> }}
union{cone{<5.10969,9.42794,-16.672> ,0.11232,<5.92287,10.9388,-19.2845> ,0.10368}
sphere{<5.10969,9.42794,-16.672> ,0.11232}
texture{txttree matrix <0.880561,-0.473933,0,0.26017,0.483393,-0.835849,0.396136,0.736016,0.54896,5.10969,9.42794,-16.672> }}
union{cone{<5.92287,10.9388,-19.2845> ,0.10368,<7.1613,11.6208,-22.0707> ,0.09504}
sphere{<5.92287,10.9388,-19.2845> ,0.10368}
texture{txttree matrix <0.482376,-0.875964,0,0.396379,0.218278,-0.891761,0.781151,0.430164,0.452506,5.92287,10.9388,-19.2845> }}
union{cone{<7.1613,11.6208,-22.0707> ,0.09504,<7.42467,13.1097,-24.9221> ,0.0864}
sphere{<7.1613,11.6208,-22.0707> ,0.09504}
texture{txttree matrix <0.984714,-0.174178,0,0.0816018,0.461334,-0.883466,0.153881,0.869961,0.468496,7.1613,11.6208,-22.0707> }}
union{cone{<7.42467,13.1097,-24.9221> ,0.0864,<7.77641,15.182,-27.4192> ,0.07776}
sphere{<7.42467,13.1097,-24.9221> ,0.0864}
texture{txttree matrix <0.985898,-0.167346,0,0.107765,0.634885,-0.765054,0.128028,0.754265,0.643966,7.42467,13.1097,-24.9221> }}
union{cone{<5.01586,9.95912,-15.3243> ,0.1296,<3.71757,12.569,-17.009> ,0.12096}
sphere{<5.01586,9.95912,-15.3243> ,0.1296}
texture{txttree matrix <0.895335,0.445394,0,-0.385625,0.775186,-0.50038,-0.222866,0.448007,0.865806,5.01586,9.95912,-15.3243> }}
union{cone{<3.71757,12.569,-17.009> ,0.12096,<2.76078,14.6422,-19.5827> ,0.11232}
sphere{<3.71757,12.569,-17.009> ,0.12096}
texture{txttree matrix <0.907976,0.419022,0,-0.278087,0.602585,-0.748037,-0.313444,0.6792,0.663657,3.71757,12.569,-17.009> }}
union{cone{<2.76078,14.6422,-19.5827> ,0.11232,<2.07855,16.0623,-22.3761> ,0.10368}
sphere{<2.76078,14.6422,-19.5827> ,0.11232}
texture{txttree matrix <0.901381,0.433027,0,-0.212727,0.442809,-0.871015,-0.377173,0.785117,0.491256,2.76078,14.6422,-19.5827> }}
union{cone{<2.07855,16.0623,-22.3761> ,0.10368,<1.36256,18.4808,-24.5946> ,0.09504}
sphere{<2.07855,16.0623,-22.3761> ,0.10368}
texture{txttree matrix <0.958863,0.28387,0,-0.213149,0.719981,-0.660451,-0.187482,0.633282,0.750869,2.07855,16.0623,-22.3761> }}
union{cone{<1.36256,18.4808,-24.5946> ,0.09504,<1.38711,21.0392,-26.768> ,0.0864}
sphere{<1.36256,18.4808,-24.5946> ,0.09504}
texture{txttree matrix <0.999954,-0.0095973,0,0.00731429,0.762085,-0.647436,0.00621364,0.647406,0.76212,1.36256,18.4808,-24.5946> }}
union{cone{<1.38711,21.0392,-26.768> ,0.0864,<1.65089,23.3197,-29.2759> ,0.07776}
sphere{<1.38711,21.0392,-26.768> ,0.0864}
texture{txttree matrix <0.993377,-0.114901,0,0.0775841,0.670756,-0.737609,0.0847517,0.732724,0.675228,1.38711,21.0392,-26.768> }}
union{cone{<4.84324,8.7665,-14.566> ,0.1296,<3.99294,11.7894,-15.564> ,0.12096}
sphere{<4.84324,8.7665,-14.566> ,0.1296}
texture{txttree matrix <0.962641,0.270782,0,-0.258061,0.917419,-0.302898,-0.0820193,0.291582,0.953023,4.84324,8.7665,-14.566> }}
union{cone{<3.99294,11.7894,-15.564> ,0.12096,<4.19074,14.5204,-17.5496> ,0.11232}
sphere{<3.99294,11.7894,-15.564> ,0.12096}
texture{txttree matrix <0.997387,-0.0722388,0,0.0584805,0.807429,-0.587059,0.0424085,0.585525,0.809544,3.99294,11.7894,-15.564> }}
union{cone{<4.19074,14.5204,-17.5496> ,0.11232,<4.5139,16.8101,-19.8395> ,0.10368}
sphere{<4.19074,14.5204,-17.5496> ,0.11232}
texture{txttree matrix <0.990187,-0.139751,0,0.0993014,0.703584,-0.703639,0.0983346,0.696734,0.710557,4.19074,14.5204,-17.5496> }}
union{cone{<4.5139,16.8101,-19.8395> ,0.10368,<4.76556,19.6024,-21.557> ,0.09504}
sphere{<4.5139,16.8101,-19.8395> ,0.10368}
texture{txttree matrix <0.995963,-0.0897626,0,0.0765425,0.849279,-0.522366,0.0468889,0.520257,0.852721,4.5139,16.8101,-19.8395> }}
union{cone{<4.76556,19.6024,-21.557> ,0.09504,<4.34756,21.8799,-23.7746> ,0.0864}
sphere{<4.76556,19.6024,-21.557> ,0.09504}
texture{txttree matrix <0.983571,0.18052,0,-0.130373,0.710343,-0.691676,-0.124861,0.680313,0.722208,4.76556,19.6024,-21.557> }}
union{cone{<4.34756,21.8799,-23.7746> ,0.0864,<3.4144,24.3724,-25.5975> ,0.07776}
sphere{<4.34756,21.8799,-23.7746> ,0.0864}
texture{txttree matrix <0.93652,0.350615,0,-0.289271,0.772664,-0.565078,-0.198125,0.529206,0.825038,4.34756,21.8799,-23.7746> }}
union{cone{<1.17542,0.906275,-6.4602> ,0.216,<2.71401,0.5,-7.30795> ,0.203657}
sphere{<1.17542,0.906275,-6.4602> ,0.216}
texture{txttree matrix <-0.255306,-0.96686,0,0.853325,-0.225326,-0.470174,0.454593,-0.120038,0.882574,1.17542,0.906275,-6.4602> }}
union{cone{<2.71401,0.5,-7.30795> ,0.203657,<4.02876,0.614878,-8.42513> ,0.191314}
sphere{<2.71401,0.5,-7.30795> ,0.203657}
texture{txttree matrix <0.0870448,-0.996204,0,0.760357,0.0664373,-0.646099,0.643647,0.0562396,0.763254,2.71401,0.5,-7.30795> }}
union{cone{<4.02876,0.614878,-8.42513> ,0.191314,<5.05225,0.525464,-9.83596> ,0.178971}
sphere{<4.02876,0.614878,-8.42513> ,0.191314}
texture{txttree matrix <-0.0870309,-0.996206,0,0.586438,-0.0512326,-0.808372,0.805305,-0.0703534,0.588672,4.02876,0.614878,-8.42513> }}
union{cone{<5.05225,0.525464,-9.83596> ,0.178971,<5.90294,0.684992,-11.1548> ,0.166629}
sphere{<5.05225,0.525464,-9.83596> ,0.178971}
texture{txttree matrix <0.184316,-0.982867,0,0.539264,0.101128,-0.836043,0.821719,0.154096,0.548664,5.05225,0.525464,-9.83596> }}
union{cone{<5.90294,0.684992,-11.1548> ,0.166629,<6.69525,0.849573,-12.7172> ,0.154286}
sphere{<5.90294,0.684992,-11.1548> ,0.166629}
texture{txttree matrix <0.20338,-0.9791,0,0.450306,0.0935383,-0.887961,0.869403,0.180594,0.459919,5.90294,0.684992,-11.1548> }}
union{cone{<6.69525,0.849573,-12.7172> ,0.154286,<7.2845,0.939136,-14.3855> ,0.141943}
sphere{<6.69525,0.849573,-12.7172> ,0.154286}
texture{txttree matrix <0.150271,-0.988645,0,0.332616,0.0505565,-0.941706,0.931013,0.141511,0.336436,6.69525,0.849573,-12.7172> }}
union{cone{<7.2845,0.939136,-14.3855> ,0.141943,<7.88112,0.792657,-16.031> ,0.1296}
sphere{<7.2845,0.939136,-14.3855> ,0.141943}
texture{txttree matrix <-0.238434,-0.971159,0,0.339675,-0.0833951,-0.936839,0.909819,-0.223374,0.349762,7.2845,0.939136,-14.3855> }}
union{cone{<7.88112,0.792657,-16.031> ,0.1296,<9.01055,1.02065,-19.0844> ,0.12096}
sphere{<7.88112,0.792657,-16.031> ,0.1296}
texture{txttree matrix <0.19787,-0.980228,0,0.346072,0.0698587,-0.935603,0.917105,0.185128,0.353053,7.88112,0.792657,-16.031> }}
union{cone{<9.01055,1.02065,-19.0844> ,0.12096,<10.3709,0.833476,-22.1187> ,0.11232}
sphere{<9.01055,1.02065,-19.0844> ,0.12096}
texture{txttree matrix <-0.136305,-0.990667,0,0.408441,-0.0561969,-0.911053,0.90255,-0.124181,0.412289,9.01055,1.02065,-19.0844> }}
union{cone{<10.3709,0.833476,-22.1187> ,0.11232,<12.2977,0.507594,-24.5275> ,0.10368}
sphere{<10.3709,0.833476,-22.1187> ,0.11232}
texture{txttree matrix <-0.166765,-0.985997,0,0.621183,-0.105063,-0.776591,0.765716,-0.129508,0.630005,10.3709,0.833476,-22.1187> }}
union{cone{<12.2977,0.507594,-24.5275> ,0.10368,<14.4714,1.36187,-26.7706> ,0.09504}
sphere{<12.2977,0.507594,-24.5275> ,0.10368}
texture{txttree matrix <0.365772,-0.930704,0,0.671262,0.26381,-0.692685,0.644685,0.253365,0.72124,12.2977,0.507594,-24.5275> }}
union{cone{<14.4714,1.36187,-26.7706> ,0.09504,<15.6419,2.69219,-29.511> ,0.0864}
sphere{<14.4714,1.36187,-26.7706> ,0.09504}
texture{txttree matrix <0.750765,-0.660569,0,0.358677,0.407652,-0.839744,0.554709,0.630451,0.542982,14.4714,1.36187,-26.7706> }}
union{cone{<15.6419,2.69219,-29.511> ,0.0864,<16.9248,3.63332,-32.2076> ,0.07776}
sphere{<15.6419,2.69219,-29.511> ,0.0864}
texture{txttree matrix <0.59148,-0.80632,0,0.409758,0.30058,-0.861249,0.694442,0.509412,0.508183,15.6419,2.69219,-29.511> }}
union{cone{<5.95314,0.695421,-11.2538> ,0.1296,<6.69846,0.5,-14.4457> ,0.12096}
sphere{<5.95314,0.695421,-11.2538> ,0.1296}
texture{txttree matrix <-0.253626,-0.967302,0,0.226986,-0.0595155,-0.972078,0.940293,-0.246544,0.234659,5.95314,0.695421,-11.2538> }}
union{cone{<6.69846,0.5,-14.4457> ,0.12096,<9.15053,0.510936,-16.554> ,0.11232}
sphere{<6.69846,0.5,-14.4457> ,0.12096}
texture{txttree matrix <0.00445983,-0.99999,0,0.758256,0.00338173,-0.651948,0.651942,0.00290758,0.758264,6.69846,0.5,-14.4457> }}
union{cone{<9.15053,0.510936,-16.554> ,0.11232,<10.8203,1.71025,-19.1379> ,0.10368}
sphere{<9.15053,0.510936,-16.554> ,0.11232}
texture{txttree matrix <0.583361,-0.812213,0,0.505695,0.363208,-0.782529,0.635581,0.456497,0.622614,9.15053,0.510936,-16.554> }}
union{cone{<10.8203,1.71025,-19.1379> ,0.10368,<12.9132,1.48871,-21.7471> ,0.09504}
sphere{<10.8203,1.71025,-19.1379> ,0.10368}
texture{txttree matrix <-0.105267,-0.994444,0,0.624332,-0.0660885,-0.778358,0.774034,-0.0819351,0.62782,10.8203,1.71025,-19.1379> }}
union{cone{<12.9132,1.48871,-21.7471> ,0.09504,<13.8901,1.50668,-24.9607> ,0.0864}
sphere{<12.9132,1.48871,-21.7471> ,0.09504}
texture{txttree matrix <0.0183874,-0.999831,0,0.290831,0.00534855,-0.956759,0.956598,0.0175924,0.29088,12.9132,1.48871,-21.7471> }}
union{cone{<13.8901,1.50668,-24.9607> ,0.0864,<15.5739,2.84129,-27.4215> ,0.07776}
sphere{<13.8901,1.50668,-24.9607> ,0.0864}
texture{txttree matrix <0.621161,-0.783683,0,0.515429,0.408537,-0.75328,0.590333,0.467908,0.6577,13.8901,1.50668,-24.9607> }}
union{cone{<6.33746,0.775253,-12.0117> ,0.1296,<6.01497,0.703266,-15.4257> ,0.12096}
sphere{<6.33746,0.775253,-12.0117> ,0.1296}
texture{txttree matrix <-0.217862,0.97598,0,-0.0940186,-0.0209872,-0.995349,-0.971441,-0.216849,0.0963325,6.33746,0.775253,-12.0117> }}
union{cone{<6.01497,0.703266,-15.4257> ,0.12096,<7.1209,0.560695,-18.3772> ,0.11232}
sphere{<6.01497,0.703266,-15.4257> ,0.12096}
texture{txttree matrix <-0.127857,-0.991793,0,0.350524,-0.0451879,-0.935463,0.927785,-0.119606,0.353425,6.01497,0.703266,-15.4257> }}
union{cone{<7.1209,0.560695,-18.3772> ,0.11232,<6.9569,1.49873,-21.6779> ,0.10368}
sphere{<7.1209,0.560695,-18.3772> ,0.11232}
texture{txttree matrix <0.985058,0.172224,0,-0.04774,0.273055,-0.960813,-0.165475,0.946456,0.277197,7.1209,0.560695,-18.3772> }}
union{cone{<6.9569,1.49873,-21.6779> ,0.10368,<6.81119,1.34855,-25.065> ,0.09504}
sphere{<6.9569,1.49873,-21.6779> ,0.10368}
texture{txttree matrix <-0.717717,0.696334,0,-0.0429356,-0.044254,-0.998097,-0.695009,-0.716352,0.0616594,6.9569,1.49873,-21.6779> }}
union{cone{<6.81119,1.34855,-25.065> ,0.09504,<7.5545,2.82487,-28.037> ,0.0864}
sphere{<6.81119,1.34855,-25.065> ,0.09504}
texture{txttree matrix <0.893179,-0.449702,0,0.218573,0.43412,-0.873937,0.393011,0.780582,0.486039,6.81119,1.34855,-25.065> }}
union{cone{<7.5545,2.82487,-28.037> ,0.0864,<8.24423,3.30858,-31.054> ,0.07776}
sphere{<7.5545,2.82487,-28.037> ,0.0864}
texture{txttree matrix <0.57418,-0.818729,0,0.220197,0.154425,-0.963154,0.788563,0.553024,0.26895,7.5545,2.82487,-28.037> }}
union{cone{<7.36188,0.920137,-14.5989> ,0.1296,<8.07612,2.30216,-17.5899> ,0.12096}
sphere{<7.36188,0.920137,-14.5989> ,0.1296}
texture{txttree matrix <0.888376,-0.459117,0,0.211853,0.409928,-0.887174,0.407316,0.788144,0.461436,7.36188,0.920137,-14.5989> }}
union{cone{<8.07612,2.30216,-17.5899> ,0.12096,<8.49317,2.56436,-20.9259> ,0.11232}
sphere{<8.07612,2.30216,-17.5899> ,0.12096}
texture{txttree matrix <0.532253,-0.846585,0,0.123673,0.0777543,-0.989272,0.837503,0.526543,0.146085,8.07612,2.30216,-17.5899> }}
union{cone{<8.49317,2.56436,-20.9259> ,0.11232,<7.84184,3.52411,-23.8307> ,0.10368}
sphere{<8.49317,2.56436,-20.9259> ,0.11232}
texture{txttree matrix <0.827448,0.561542,0,-0.208239,0.306846,-0.928699,-0.521504,0.76845,0.370834,8.49317,2.56436,-20.9259> }}
union{cone{<7.84184,3.52411,-23.8307> ,0.10368,<7.95633,5.48816,-26.3644> ,0.09504}
sphere{<7.84184,3.52411,-23.8307> ,0.10368}
texture{txttree matrix <0.998305,-0.0581921,0,0.0356896,0.612268,-0.789845,0.0459627,0.788506,0.613307,7.84184,3.52411,-23.8307> }}
union{cone{<7.95633,5.48816,-26.3644> ,0.09504,<8.66603,6.42628,-29.4741> ,0.0864}
sphere{<7.95633,5.48816,-26.3644> ,0.09504}
texture{txttree matrix <0.797497,-0.603322,0,0.213461,0.282162,-0.935318,0.564298,0.745914,0.353809,7.95633,5.48816,-26.3644> }}
union{cone{<8.66603,6.42628,-29.4741> ,0.0864,<8.48628,8.54773,-32.0988> ,0.07776}
sphere{<8.66603,6.42628,-29.4741> ,0.0864}
texture{txttree matrix <0.99643,0.0844264,0,-0.0531863,0.627723,-0.776618,-0.0655671,0.773845,0.629972,8.66603,6.42628,-29.4741> }}
union{cone{<3.08818,0.532694,-7.6259> ,0.1296,<5.435,1.75566,-9.79284> ,0.12096}
sphere{<3.08818,0.532694,-7.6259> ,0.1296}
texture{txttree matrix <0.462132,-0.886811,0,0.686132,0.357555,-0.633543,0.561833,0.292781,0.773707,3.08818,0.532694,-7.6259> }}
union{cone{<5.435,1.75566,-9.79284> ,0.12096,<8.45799,2.5575,-11.1108> ,0.11232}
sphere{<5.435,1.75566,-9.79284> ,0.12096}
texture{txttree matrix <0.25638,-0.966576,0,0.890717,0.236259,-0.388337,0.375357,0.099562,0.921517,5.435,1.75566,-9.79284> }}
union{cone{<8.45799,2.5575,-11.1108> ,0.11232,<10.1265,4.96914,-12.2936> ,0.10368}
sphere{<8.45799,2.5575,-11.1108> ,0.11232}
texture{txttree matrix <0.822366,-0.568958,0,0.527654,0.762666,-0.374061,0.212825,0.307615,0.927404,8.45799,2.5575,-11.1108> }}
union{cone{<10.1265,4.96914,-12.2936> ,0.10368,<11.4596,7.08318,-14.631> ,0.09504}
sphere{<10.1265,4.96914,-12.2936> ,0.10368}
texture{txttree matrix <0.845861,-0.533404,0,0.389579,0.617785,-0.683059,0.364346,0.577773,0.730363,10.1265,4.96914,-12.2936> }}
union{cone{<11.4596,7.08318,-14.631> ,0.09504,<13.6394,9.28992,-16.0069> ,0.0864}
sphere{<11.4596,7.08318,-14.631> ,0.09504}
texture{txttree matrix <0.711447,-0.70274,0,0.64238,0.650339,-0.405471,0.28494,0.288471,0.914108,11.4596,7.08318,-14.631> }}
union{cone{<13.6394,9.28992,-16.0069> ,0.0864,<15.1295,10.9789,-18.3113> ,0.07776}
sphere{<13.6394,9.28992,-16.0069> ,0.0864}
texture{txttree matrix <0.749855,-0.661602,0,0.462445,0.524132,-0.715144,0.473141,0.536254,0.698978,13.6394,9.28992,-16.0069> }}
union{cone{<0.930156,0.985705,-5.91455> ,0.216,<0.438367,1.35653,-7.60523> ,0.203657}
sphere{<0.930156,0.985705,-5.91455> ,0.216}
texture{txttree matrix <0.602058,0.798452,0,-0.273311,0.206085,-0.93959,-0.750218,0.565688,0.342301,0.930156,0.985705,-5.91455> }}
union{cone{<0.438367,1.35653,-7.60523> ,0.203657,<-0.127789,2.18849,-9.06652> ,0.191314}
sphere{<0.438367,1.35653,-7.60523> ,0.203657}
texture{txttree matrix <0.826729,0.5626,0,-0.319091,0.468897,-0.8236,-0.463357,0.680894,0.567172,0.438367,1.35653,-7.60523> }}
union{cone{<-0.127789,2.18849,-9.06652> ,0.191314,<0.270471,2.62543,-10.717> ,0.178971}
sphere{<-0.127789,2.18849,-9.06652> ,0.191314}
texture{txttree matrix <0.739065,-0.673634,0,0.227162,0.249226,-0.941426,0.634177,0.695775,0.337219,-0.127789,2.18849,-9.06652> }}
union{cone{<0.270471,2.62543,-10.717> ,0.178971,<0.578017,3.40946,-12.2452> ,0.166629}
sphere{<0.270471,2.62543,-10.717> ,0.178971}
texture{txttree matrix <0.930939,-0.365174,0,0.176256,0.449329,-0.875807,0.319821,0.815323,0.482662,0.270471,2.62543,-10.717> }}
union{cone{<0.578017,3.40946,-12.2452> ,0.166629,<0.725891,4.43633,-13.5968> ,0.154286}
sphere{<0.578017,3.40946,-12.2452> ,0.166629}
texture{txttree matrix <0.98979,-0.142534,0,0.0867865,0.602666,-0.79326,0.113067,0.785161,0.608883,0.578017,3.40946,-12.2452> }}
union{cone{<0.725891,4.43633,-13.5968> ,0.154286,<0.538278,5.49002,-14.9083> ,0.141943}
sphere{<0.725891,4.43633,-13.5968> ,0.154286}
texture{txttree matrix <0.984516,0.175296,0,-0.110834,0.62248,-0.774748,-0.13581,0.762752,0.63227,0.725891,4.43633,-13.5968> }}
union{cone{<0.538278,5.49002,-14.9083> ,0.141943,<0.753092,6.55829,-16.3158> ,0.1296}
sphere{<0.538278,5.49002,-14.9083> ,0.141943}
texture{txttree matrix <0.980375,-0.197141,0,0.120679,0.600134,-0.790744,0.155888,0.775226,0.612147,0.538278,5.49002,-14.9083> }}
union{cone{<0.753092,6.55829,-16.3158> ,0.1296,<1.4426,8.38351,-18.9176> ,0.12096}
sphere{<0.753092,6.55829,-16.3158> ,0.1296}
texture{txttree matrix <0.935476,-0.35339,0,0.212022,0.561255,-0.800025,0.28272,0.748404,0.599967,0.753092,6.55829,-16.3158> }}
union{cone{<1.4426,8.38351,-18.9176> ,0.12096,<1.5663,11.1995,-20.7539> ,0.11232}
sphere{<1.4426,8.38351,-18.9176> ,0.12096}
texture{txttree matrix <0.999037,-0.0438859,0,0.0367709,0.837067,-0.545863,0.0239557,0.545337,0.837874,1.4426,8.38351,-18.9176> }}
union{cone{<1.5663,11.1995,-20.7539> ,0.11232,<1.06114,14.1214,-22.3137> ,0.10368}
sphere{<1.5663,11.1995,-20.7539> ,0.11232}
texture{txttree matrix <0.985381,0.170365,0,-0.150777,0.872086,-0.465546,-0.0793126,0.45874,0.885024,1.5663,11.1995,-20.7539> }}
union{cone{<1.06114,14.1214,-22.3137> ,0.10368,<1.16834,16.0769,-24.8674> ,0.09504}
sphere{<1.06114,14.1214,-22.3137> ,0.10368}
texture{txttree matrix <0.998501,-0.0547374,0,0.0333108,0.607644,-0.793511,0.0434347,0.792321,0.608556,1.06114,14.1214,-22.3137> }}
union{cone{<1.16834,16.0769,-24.8674> ,0.09504,<2.2458,18.5948,-26.7286> ,0.0864}
sphere{<1.16834,16.0769,-24.8674> ,0.09504}
texture{txttree matrix <0.919359,-0.39342,0,0.32539,0.760385,-0.562081,0.221134,0.516754,0.827082,1.16834,16.0769,-24.8674> }}
union{cone{<2.2458,18.5948,-26.7286> ,0.0864,<1.90077,21.2943,-28.5904> ,0.07776}
sphere{<2.2458,18.5948,-26.7286> ,0.0864}
texture{txttree matrix <0.991931,0.126781,0,-0.104637,0.818676,-0.564642,-0.0715861,0.560086,0.825336,2.2458,18.5948,-26.7286> }}
union{cone{<-0.048165,2.07148,-8.86101> ,0.1296,<0.88029,4.22584,-10.9273> ,0.12096}
sphere{<-0.048165,2.07148,-8.86101> ,0.1296}
texture{txttree matrix <0.918347,-0.395775,0,0.296996,0.689141,-0.660967,0.261595,0.606998,0.750415,-0.048165,2.07148,-8.86101> }}
union{cone{<0.88029,4.22584,-10.9273> ,0.12096,<0.681405,7.23898,-12.397> ,0.11232}
sphere{<0.88029,4.22584,-10.9273> ,0.12096}
texture{txttree matrix <0.997829,0.0658627,0,-0.059221,0.897207,-0.437622,-0.028823,0.436672,0.899159,0.88029,4.22584,-10.9273> }}
union{cone{<0.681405,7.23898,-12.397> ,0.11232,<1.30959,9.75255,-14.2374> ,0.10368}
sphere{<0.681405,7.23898,-12.397> ,0.11232}
texture{txttree matrix <0.970161,-0.24246,0,0.197667,0.79093,-0.579101,0.140409,0.561822,0.815256,0.681405,7.23898,-12.397> }}
union{cone{<1.30959,9.75255,-14.2374> ,0.10368,<0.786332,12.5535,-15.9894> ,0.09504}
sphere{<1.30959,9.75255,-14.2374> ,0.10368}
texture{txttree matrix <0.982995,0.183634,0,-0.156431,0.837374,-0.52377,-0.0961821,0.514863,0.85186,1.30959,9.75255,-14.2374> }}
union{cone{<0.786332,12.5535,-15.9894> ,0.09504,<0.544251,14.2266,-18.7623> ,0.0864}
sphere{<0.786332,12.5535,-15.9894> ,0.09504}
texture{txttree matrix <0.989694,0.143199,0,-0.0745407,0.515173,-0.853839,-0.122269,0.845039,0.520538,0.786332,12.5535,-15.9894> }}
union{cone{<0.544251,14.2266,-18.7623> ,0.0864,<-0.01175,16.0069,-21.2915> ,0.07776}
sphere{<0.544251,14.2266,-18.7623> ,0.0864}
texture{txttree matrix <0.954531,0.298113,0,-0.176928,0.566509,-0.804838,-0.239932,0.768242,0.593495,0.544251,14.2266,-18.7623> }}
union{cone{<0.877743,1.02523,-6.09474> ,0.1296,<2.10306,0.896502,-9.26001> ,0.12096}
sphere{<0.877743,1.02523,-6.09474> ,0.1296}
texture{txttree matrix <-0.104479,-0.994527,0,0.360748,-0.037898,-0.931893,0.926793,-0.0973632,0.362734,0.877743,1.02523,-6.09474> }}
union{cone{<2.10306,0.896502,-9.26001> ,0.12096,<2.36466,1.0535,-12.3994> ,0.11232}
sphere{<2.10306,0.896502,-9.26001> ,0.12096}
texture{txttree matrix <0.514594,-0.857434,0,0.0829376,0.0497756,-0.995311,0.853413,0.512181,0.0967278,2.10306,0.896502,-9.26001> }}
union{cone{<2.36466,1.0535,-12.3994> ,0.11232,<3.49339,2.29952,-15.0471> ,0.10368}
sphere{<2.36466,1.0535,-12.3994> ,0.11232}
texture{txttree matrix <0.741127,-0.671365,0,0.359884,0.397281,-0.844187,0.566757,0.62565,0.536049,2.36466,1.0535,-12.3994> }}
union{cone{<3.49339,2.29952,-15.0471> ,0.10368,<4.28388,4.12477,-17.6036> ,0.09504}
sphere{<3.49339,2.29952,-15.0471> ,0.10368}
texture{txttree matrix <0.917638,-0.397418,0,0.24404,0.563487,-0.789257,0.313665,0.724252,0.614063,3.49339,2.29952,-15.0471> }}
union{cone{<4.28388,4.12477,-17.6036> ,0.09504,<5.11913,5.05329,-20.5808> ,0.0864}
sphere{<4.28388,4.12477,-17.6036> ,0.09504}
texture{txttree matrix <0.74346,-0.66878,0,0.258711,0.2876,-0.922147,0.616714,0.685579,0.38684,4.28388,4.12477,-17.6036> }}
union{cone{<5.11913,5.05329,-20.5808> ,0.0864,<5.47729,6.29156,-23.5256> ,0.07776}
sphere{<5.11913,5.05329,-20.5808> ,0.0864}
texture{txttree matrix <0.960623,-0.277854,0,0.111419,0.385209,-0.916078,0.254536,0.880006,0.400999,5.11913,5.05329,-20.5808> }}
union{cone{<0.508042,3.23107,-11.8975> ,0.1296,<1.28426,4.58067,-14.6571> ,0.12096}
sphere{<0.508042,3.23107,-11.8975> ,0.1296}
texture{txttree matrix <0.866851,-0.498568,0,0.244983,0.425946,-0.87095,0.434228,0.754983,0.491372,0.508042,3.23107,-11.8975> }}
union{cone{<1.28426,4.58067,-14.6571> ,0.12096,<1.4244,5.82228,-17.7567> ,0.11232}
sphere{<1.28426,4.58067,-14.6571> ,0.12096}
texture{txttree matrix <0.993691,-0.112154,0,0.0419326,0.371526,-0.927475,0.10402,0.921624,0.373884,1.28426,4.58067,-14.6571> }}
union{cone{<1.4244,5.82228,-17.7567> ,0.11232,<2.13585,8.18146,-19.9593> ,0.10368}
sphere{<1.4244,5.82228,-17.7567> ,0.11232}
texture{txttree matrix <0.957413,-0.288723,0,0.215258,0.7138,-0.666449,0.192419,0.638067,0.745551,1.4244,5.82228,-17.7567> }}
union{cone{<2.13585,8.18146,-19.9593> ,0.10368,<1.64389,9.62336,-22.8873> ,0.09504}
sphere{<2.13585,8.18146,-19.9593> ,0.10368}
texture{txttree matrix <0.94643,0.322909,0,-0.149049,0.436857,-0.887097,-0.286451,0.839575,0.461584,2.13585,8.18146,-19.9593> }}
union{cone{<1.64389,9.62336,-22.8873> ,0.09504,<0.796579,12.0524,-25.0137> ,0.0864}
sphere{<1.64389,9.62336,-22.8873> ,0.09504}
texture{txttree matrix <0.944202,0.329366,0,-0.25387,0.727776,-0.637097,-0.209838,0.601548,0.770784,1.64389,9.62336,-22.8873> }}
union{cone{<0.796579,12.0524,-25.0137> ,0.0864,<1.06027,13.7163,-27.7425> ,0.07776}
sphere{<0.796579,12.0524,-25.0137> ,0.0864}
texture{txttree matrix <0.987676,-0.156516,0,0.0822223,0.518855,-0.850899,0.133179,0.840412,0.52533,0.796579,12.0524,-25.0137> }}
union{cone{<-1.99585,1.33606,-3.59971> ,0.36,<-2.16308,0.5,-3.76357> ,0.342}
sphere{<-1.99585,1.33606,-3.59971> ,0.36}
texture{txttree matrix <-0.980575,0.196142,0,-0.192617,-0.962954,-0.188728,-0.0370176,-0.185062,0.982029,-1.99585,1.33606,-3.59971> }}
union{cone{<-2.16308,0.5,-3.76357> ,0.342,<-2.10842,0.54629,-4.48345> ,0.324}
sphere{<-2.16308,0.5,-3.76357> ,0.342}
texture{txttree matrix <0.646238,-0.763136,0,0.0755607,0.0639861,-0.995086,0.759386,0.643062,0.0990133,-2.16308,0.5,-3.76357> }}
union{cone{<-2.10842,0.54629,-4.48345> ,0.324,<-2.38474,0.715866,-4.81499> ,0.306}
sphere{<-2.10842,0.54629,-4.48345> ,0.324}
texture{txttree matrix <0.523047,0.852304,0,-0.595899,0.365695,-0.714963,-0.609365,0.373959,0.699162,-2.10842,0.54629,-4.48345> }}
union{cone{<-2.38474,0.715866,-4.81499> ,0.306,<-2.62324,0.699239,-5.64551> ,0.288}
sphere{<-2.38474,0.715866,-4.81499> ,0.306}
texture{txttree matrix <-0.0695489,0.997579,0,-0.275955,-0.019239,-0.960978,-0.958651,-0.066835,0.276625,-2.38474,0.715866,-4.81499> }}
union{cone{<-2.62324,0.699239,-5.64551> ,0.288,<-2.8061,0.539969,-6.20911> ,0.27}
sphere{<-2.62324,0.699239,-5.64551> ,0.288}
texture{txttree matrix <-0.65678,0.754082,0,-0.298045,-0.259587,-0.918577,-0.692683,-0.603303,0.395242,-2.62324,0.699239,-5.64551> }}
union{cone{<-2.8061,0.539969,-6.20911> ,0.27,<-2.62052,0.917916,-7.0589> ,0.252}
sphere{<-2.8061,0.539969,-6.20911> ,0.27}
texture{txttree matrix <0.897621,-0.440768,0,0.195687,0.398516,-0.896042,0.394947,0.804306,0.443969,-2.8061,0.539969,-6.20911> }}
union{cone{<-2.62052,0.917916,-7.0589> ,0.252,<-2.61184,0.814879,-7.96623> ,0.234}
sphere{<-2.62052,0.917916,-7.0589> ,0.252}
texture{txttree matrix <-0.996471,-0.0839426,0,0.00950491,-0.112831,-0.993569,0.0834027,-0.990062,0.113231,-2.62052,0.917916,-7.0589> }}
union{cone{<-2.61184,0.814879,-7.96623> ,0.234,<-3.1013,0.622202,-8.80319> ,0.216}
sphere{<-2.61184,0.814879,-7.96623> ,0.234}
texture{txttree matrix <-0.36629,0.930501,0,-0.495142,-0.194912,-0.846666,-0.787824,-0.310125,0.532124,-2.61184,0.814879,-7.96623> }}
union{cone{<-3.1013,0.622202,-8.80319> ,0.216,<-4.71011,0.5,-9.42824> ,0.203657}
sphere{<-3.1013,0.622202,-8.80319> ,0.216}
texture{txttree matrix <-0.0757398,0.997128,0,-0.929793,-0.0706252,-0.361243,-0.360205,-0.0273604,0.932472,-3.1013,0.622202,-8.80319> }}
union{cone{<-4.71011,0.5,-9.42824> ,0.203657,<-5.79788,0.572775,-10.6087> ,0.191314}
sphere{<-4.71011,0.5,-9.42824> ,0.203657}
texture{txttree matrix <0.0667539,0.997769,0,-0.676958,0.0452906,-0.734627,-0.732988,0.0490392,0.678471,-4.71011,0.5,-9.42824> }}
union{cone{<-5.79788,0.572775,-10.6087> ,0.191314,<-7.13139,0.644186,-11.7423> ,0.178971}
sphere{<-5.79788,0.572775,-10.6087> ,0.191314}
texture{txttree matrix <0.0534743,0.998569,0,-0.761258,0.0407661,-0.647167,-0.646241,0.0346068,0.762349,-5.79788,0.572775,-10.6087> }}
union{cone{<-7.13139,0.644186,-11.7423> ,0.178971,<-8.29404,0.644745,-13.0785> ,0.166629}
sphere{<-7.13139,0.644186,-11.7423> ,0.178971}
texture{txttree matrix <0.000480713,1,0,-0.656432,0.000315555,-0.754385,-0.754385,0.000362643,0.656432,-7.13139,0.644186,-11.7423> }}
union{cone{<-8.29404,0.644745,-13.0785> ,0.166629,<-9.53874,0.839866,-14.2225> ,0.154286}
sphere{<-8.29404,0.644745,-13.0785> ,0.166629}
texture{txttree matrix <0.154869,0.987935,0,-0.731387,0.114653,-0.672256,-0.664145,0.104112,0.740319,-8.29404,0.644745,-13.0785> }}
union{cone{<-9.53874,0.839866,-14.2225> ,0.154286,<-10.6182,1.50267,-15.5203> ,0.141943}
sphere{<-9.53874,0.839866,-14.2225> ,0.154286}
texture{txttree matrix <0.523247,0.852181,0,-0.595251,0.36549,-0.715607,-0.609827,0.374439,0.698503,-9.53874,0.839866,-14.2225> }}
union{cone{<-10.6182,1.50267,-15.5203> ,0.141943,<-11.369,2.14854,-16.8904> ,0.1296}
sphere{<-10.6182,1.50267,-15.5203> ,0.141943}
texture{txttree matrix <0.652178,0.758066,0,-0.444074,0.382044,-0.810457,-0.61438,0.528562,0.585798,-10.6182,1.50267,-15.5203> }}
union{cone{<-11.369,2.14854,-16.8904> ,0.1296,<-13.3738,4.51389,-17.746> ,0.12096}
sphere{<-11.369,2.14854,-16.8904> ,0.1296}
texture{txttree matrix <0.76285,0.646576,0,-0.623285,0.73537,-0.265984,-0.171979,0.202906,0.963977,-11.369,2.14854,-16.8904> }}
union{cone{<-13.3738,4.51389,-17.746> ,0.12096,<-14.5228,5.89163,-20.3007> ,0.11232}
sphere{<-13.3738,4.51389,-17.746> ,0.12096}
texture{txttree matrix <0.767982,0.640472,0,-0.368065,0.441342,-0.818379,-0.524149,0.6285,0.574678,-13.3738,4.51389,-17.746> }}
union{cone{<-14.5228,5.89163,-20.3007> ,0.11232,<-16.1182,8.58196,-21.6357> ,0.10368}
sphere{<-14.5228,5.89163,-20.3007> ,0.11232}
texture{txttree matrix <0.860123,0.510087,0,-0.469139,0.791077,-0.392563,-0.200241,0.337653,0.919725,-14.5228,5.89163,-20.3007> }}
union{cone{<-16.1182,8.58196,-21.6357> ,0.10368,<-17.8854,10.5676,-23.6878> ,0.09504}
sphere{<-16.1182,8.58196,-21.6357> ,0.10368}
texture{txttree matrix <0.747006,0.664818,0,-0.526246,0.591302,-0.611087,-0.406261,0.456485,0.791563,-16.1182,8.58196,-21.6357> }}
union{cone{<-17.8854,10.5676,-23.6878> ,0.09504,<-19.9707,12.1854,-25.8599> ,0.0864}
sphere{<-17.8854,10.5676,-23.6878> ,0.09504}
texture{txttree matrix <0.612969,0.790107,0,-0.610066,0.473292,-0.635464,-0.502085,0.38952,0.77213,-17.8854,10.5676,-23.6878> }}
union{cone{<-19.9707,12.1854,-25.8599> ,0.0864,<-21.6575,13.9269,-28.0303> ,0.07776}
sphere{<-19.9707,12.1854,-25.8599> ,0.0864}
texture{txttree matrix <0.718299,0.695735,0,-0.518378,0.535189,-0.666976,-0.464038,0.479088,0.745079,-19.9707,12.1854,-25.8599> }}
union{cone{<-10.6987,1.57187,-15.6671> ,0.1296,<-10.9924,3.7419,-18.0012> ,0.12096}
sphere{<-10.6987,1.57187,-15.6671> ,0.1296}
texture{txttree matrix <0.990964,0.134129,0,-0.0917711,0.678017,-0.729295,-0.0978198,0.722705,0.684199,-10.6987,1.57187,-15.6671> }}
union{cone{<-10.9924,3.7419,-18.0012> ,0.12096,<-12.5455,6.23151,-19.5052> ,0.11232}
sphere{<-10.9924,3.7419,-18.0012> ,0.12096}
texture{txttree matrix <0.848441,0.52929,0,-0.471024,0.755043,-0.45612,-0.24142,0.386991,0.889918,-10.9924,3.7419,-18.0012> }}
union{cone{<-12.5455,6.23151,-19.5052> ,0.11232,<-13.2232,8.08977,-22.023> ,0.10368}
sphere{<-12.5455,6.23151,-19.5052> ,0.11232}
texture{txttree matrix <0.939466,0.342642,0,-0.21167,0.580365,-0.786367,-0.269442,0.738765,0.61776,-12.5455,6.23151,-19.5052> }}
union{cone{<-13.2232,8.08977,-22.023> ,0.10368,<-14.4757,10.4513,-23.8998> ,0.09504}
sphere{<-13.2232,8.08977,-22.023> ,0.10368}
texture{txttree matrix <0.883447,0.468531,0,-0.383462,0.723043,-0.574601,-0.269219,0.50763,0.818433,-13.2232,8.08977,-22.023> }}
union{cone{<-14.4757,10.4513,-23.8998> ,0.09504,<-14.338,12.8139,-26.1032> ,0.0864}
sphere{<-14.4757,10.4513,-23.8998> ,0.09504}
texture{txttree matrix <0.998306,-0.0581833,0,0.0425835,0.730646,-0.681427,0.0396477,0.680273,0.731886,-14.4757,10.4513,-23.8998> }}
union{cone{<-14.338,12.8139,-26.1032> ,0.0864,<-15.264,15.4488,-28.0676> ,0.07776}
sphere{<-14.338,12.8139,-26.1032> ,0.0864}
texture{txttree matrix <0.94343,0.331571,0,-0.271203,0.771663,-0.575314,-0.190757,0.542768,0.817933,-14.338,12.8139,-26.1032> }}
union{cone{<-10.5908,1.48586,-15.4874> ,0.1296,<-10.7438,1.6865,-18.8879> ,0.12096}
sphere{<-10.5908,1.48586,-15.4874> ,0.1296}
texture{txttree matrix <0.795202,0.606345,0,-0.0448665,0.058841,-0.997259,-0.604682,0.793022,0.073995,-10.5908,1.48586,-15.4874> }}
union{cone{<-10.7438,1.6865,-18.8879> ,0.12096,<-11.0951,3.77009,-21.3503> ,0.11232}
sphere{<-10.7438,1.6865,-18.8879> ,0.12096}
texture{txttree matrix <0.986081,0.166268,0,-0.108277,0.642157,-0.758888,-0.126179,0.748325,0.651221,-10.7438,1.6865,-18.8879> }}
union{cone{<-11.0951,3.77009,-21.3503> ,0.11232,<-10.8514,5.79324,-24.0138> ,0.10368}
sphere{<-11.0951,3.77009,-21.3503> ,0.11232}
texture{txttree matrix <0.992821,-0.119607,0,0.0726764,0.603264,-0.794223,0.0949948,0.788522,0.607626,-11.0951,3.77009,-21.3503> }}
union{cone{<-10.8514,5.79324,-24.0138> ,0.10368,<-10.4773,7.50544,-26.9016> ,0.09504}
sphere{<-10.8514,5.79324,-24.0138> ,0.10368}
texture{txttree matrix <0.976957,-0.213436,0,0.110737,0.506875,-0.854877,0.182462,0.835178,0.518831,-10.8514,5.79324,-24.0138> }}
union{cone{<-10.4773,7.50544,-26.9016> ,0.09504,<-10.3735,9.76324,-29.282> ,0.0864}
sphere{<-10.4773,7.50544,-26.9016> ,0.09504}
texture{txttree matrix <0.998943,-0.0459594,0,0.0316453,0.687822,-0.725189,0.0333292,0.724423,0.68855,-10.4773,7.50544,-26.9016> }}
union{cone{<-10.3735,9.76324,-29.282> ,0.0864,<-10.5286,11.0246,-32.3342> ,0.07776}
sphere{<-10.3735,9.76324,-29.282> ,0.0864}
texture{txttree matrix <0.992524,0.122051,0,-0.0469152,0.381517,-0.923171,-0.112674,0.916269,0.384391,-10.3735,9.76324,-29.282> }}
union{cone{<-3.85867,0.564673,-9.09744> ,0.1296,<-6.88077,0.726772,-10.463> ,0.12096}
sphere{<-3.85867,0.564673,-9.09744> ,0.1296}
texture{txttree matrix <0.0535607,0.998565,0,-0.910204,0.0488212,-0.411272,-0.410682,0.022028,0.911513,-3.85867,0.564673,-9.09744> }}
union{cone{<-6.88077,0.726772,-10.463> ,0.12096,<-9.18027,0.537877,-12.5749> ,0.11232}
sphere{<-6.88077,0.726772,-10.463> ,0.12096}
texture{txttree matrix <-0.0818703,0.996643,0,-0.735159,-0.0603904,-0.6752,-0.672933,-0.0552788,0.737635,-6.88077,0.726772,-10.463> }}
union{cone{<-9.18027,0.537877,-12.5749> ,0.11232,<-10.9847,0.670623,-15.3127> ,0.10368}
sphere{<-9.18027,0.537877,-12.5749> ,0.11232}
texture{txttree matrix <0.0733693,0.997305,0,-0.549848,0.040451,-0.834284,-0.832036,0.0612108,0.551334,-9.18027,0.537877,-12.5749> }}
union{cone{<-10.9847,0.670623,-15.3127> ,0.10368,<-13.3374,0.721921,-17.5697> ,0.09504}
sphere{<-10.9847,0.670623,-15.3127> ,0.10368}
texture{txttree matrix <0.0217988,0.999762,0,-0.721544,0.0157325,-0.69219,-0.692025,0.0150889,0.721716,-10.9847,0.670623,-15.3127> }}
union{cone{<-13.3374,0.721921,-17.5697> ,0.09504,<-14.7993,0.851082,-20.4296> ,0.0864}
sphere{<-13.3374,0.721921,-17.5697> ,0.09504}
texture{txttree matrix <0.0880052,0.99612,0,-0.454806,0.0401812,-0.889683,-0.886231,0.0782967,0.456578,-13.3374,0.721921,-17.5697> }}
union{cone{<-14.7993,0.851082,-20.4296> ,0.0864,<-16.2122,2.41362,-22.7511> ,0.07776}
sphere{<-14.7993,0.851082,-20.4296> ,0.0864}
texture{txttree matrix <0.741751,0.670676,0,-0.450686,0.498448,-0.740562,-0.496677,0.549312,0.671989,-14.7993,0.851082,-20.4296> }}
union{cone{<-8.72498,0.7123,-13.4746> ,0.1296,<-10.689,0.5,-15.9398> ,0.12096}
sphere{<-8.72498,0.7123,-13.4746> ,0.1296}
texture{txttree matrix <-0.107467,0.994209,0,-0.621718,-0.0672031,-0.780353,-0.775833,-0.0838618,0.62534,-8.72498,0.7123,-13.4746> }}
union{cone{<-10.689,0.5,-15.9398> ,0.12096,<-12.6409,0.634043,-18.4295> ,0.11232}
sphere{<-10.689,0.5,-15.9398> ,0.12096}
texture{txttree matrix <0.0685117,0.99765,0,-0.616421,0.0423316,-0.786278,-0.78443,0.0538693,0.617873,-10.689,0.5,-15.9398> }}
union{cone{<-12.6409,0.634043,-18.4295> ,0.11232,<-15.1855,1.64073,-19.9506> ,0.10368}
sphere{<-12.6409,0.634043,-18.4295> ,0.11232}
texture{txttree matrix <0.367885,0.929871,0,-0.812743,0.321545,-0.485858,-0.451785,0.17874,0.874038,-12.6409,0.634043,-18.4295> }}
union{cone{<-15.1855,1.64073,-19.9506> ,0.10368,<-16.7269,3.00165,-22.2958> ,0.09504}
sphere{<-15.1855,1.64073,-19.9506> ,0.10368}
texture{txttree matrix <0.661841,0.749644,0,-0.494218,0.436333,-0.751906,-0.563661,0.497642,0.659271,-15.1855,1.64073,-19.9506> }}
union{cone{<-16.7269,3.00165,-22.2958> ,0.09504,<-18.8179,2.88491,-24.8519> ,0.0864}
sphere{<-16.7269,3.00165,-22.2958> ,0.09504}
texture{txttree matrix <-0.0557445,0.998445,0,-0.632776,-0.0353287,-0.773529,-0.772326,-0.04312,0.633761,-16.7269,3.00165,-22.2958> }}
union{cone{<-18.8179,2.88491,-24.8519> ,0.0864,<-20.6579,3.69592,-27.4563> ,0.07776}
sphere{<-18.8179,2.88491,-24.8519> ,0.0864}
texture{txttree matrix <0.403323,0.915058,0,-0.559208,0.246478,-0.79154,-0.724305,0.319246,0.611118,-18.8179,2.88491,-24.8519> }}
union{cone{<-2.97119,0.673421,-8.5807> ,0.216,<-4.1233,0.674565,-9.818> ,0.203657}
sphere{<-2.97119,0.673421,-8.5807> ,0.216}
texture{txttree matrix <0.000993447,1,0,-0.681464,0.000676999,-0.731851,-0.731851,0.000727055,0.681464,-2.97119,0.673421,-8.5807> }}
union{cone{<-4.1233,0.674565,-9.818> ,0.203657,<-5.74754,1.20734,-10.4176> ,0.191314}
sphere{<-4.1233,0.674565,-9.818> ,0.203657}
texture{txttree matrix <0.311678,0.950188,0,-0.896619,0.294106,-0.331022,-0.314533,0.103172,0.943623,-4.1233,0.674565,-9.818> }}
union{cone{<-5.74754,1.20734,-10.4176> ,0.191314,<-7.23209,1.84743,-11.1705> ,0.178971}
sphere{<-5.74754,1.20734,-10.4176> ,0.191314}
texture{txttree matrix <0.395929,0.918281,0,-0.832438,0.358916,-0.422168,-0.387669,0.167148,0.906518,-5.74754,1.20734,-10.4176> }}
union{cone{<-7.23209,1.84743,-11.1705> ,0.178971,<-7.85946,2.68927,-12.5773> ,0.166629}
sphere{<-7.23209,1.84743,-11.1705> ,0.178971}
texture{txttree matrix <0.801829,0.597554,0,-0.357403,0.479582,-0.801414,-0.478888,0.642597,0.59811,-7.23209,1.84743,-11.1705> }}
union{cone{<-7.85946,2.68927,-12.5773> ,0.166629,<-8.36485,3.45865,-14.0073> ,0.154286}
sphere{<-7.85946,2.68927,-12.5773> ,0.166629}
texture{txttree matrix <0.835805,0.549026,0,-0.297171,0.452397,-0.840848,-0.461647,0.702786,0.541271,-7.85946,2.68927,-12.5773> }}
union{cone{<-8.36485,3.45865,-14.0073> ,0.154286,<-9.00451,4.71859,-15.1815> ,0.141943}
sphere{<-8.36485,3.45865,-14.0073> ,0.154286}
texture{txttree matrix <0.89167,0.452687,0,-0.348168,0.685797,-0.63911,-0.289317,0.569875,0.769115,-8.36485,3.45865,-14.0073> }}
union{cone{<-9.00451,4.71859,-15.1815> ,0.141943,<-10.1108,5.61329,-16.2966> ,0.1296}
sphere{<-9.00451,4.71859,-15.1815> ,0.141943}
texture{txttree matrix <0.628818,0.777552,0,-0.611986,0.494922,-0.616868,-0.479647,0.387898,0.787067,-9.00451,4.71859,-15.1815> }}
union{cone{<-10.1108,5.61329,-16.2966> ,0.1296,<-13.2576,6.64204,-16.5742> ,0.12096}
sphere{<-10.1108,5.61329,-16.2966> ,0.1296}
texture{txttree matrix <0.310742,0.950494,0,-0.947171,0.309656,-0.0835433,-0.0794074,0.0259604,0.996504,-10.1108,5.61329,-16.2966> }}
union{cone{<-13.2576,6.64204,-16.5742> ,0.12096,<-14.4621,9.30211,-18.0704> ,0.11232}
sphere{<-13.2576,6.64204,-16.5742> ,0.12096}
texture{txttree matrix <0.91095,0.412516,0,-0.367131,0.810727,-0.456,-0.188108,0.415393,0.88998,-13.2576,6.64204,-16.5742> }}
union{cone{<-14.4621,9.30211,-18.0704> ,0.11232,<-15.5433,11.7432,-19.9061> ,0.10368}
sphere{<-14.4621,9.30211,-18.0704> ,0.11232}
texture{txttree matrix <0.914339,0.404949,0,-0.333677,0.753413,-0.566594,-0.229442,0.518059,0.823997,-14.4621,9.30211,-18.0704> }}
union{cone{<-15.5433,11.7432,-19.9061> ,0.10368,<-17.4292,14.1186,-20.8312> ,0.09504}
sphere{<-15.5433,11.7432,-19.9061> ,0.10368}
texture{txttree matrix <0.783188,0.621785,0,-0.594737,0.749119,-0.291736,-0.181397,0.228484,0.956499,-15.5433,11.7432,-19.9061> }}
union{cone{<-17.4292,14.1186,-20.8312> ,0.09504,<-19.4656,16.4907,-21.9423> ,0.0864}
sphere{<-17.4292,14.1186,-20.8312> ,0.09504}
texture{txttree matrix <0.758741,0.651393,0,-0.613782,0.714931,-0.334882,-0.218139,0.254088,0.94226,-17.4292,14.1186,-20.8312> }}
union{cone{<-19.4656,16.4907,-21.9423> ,0.0864,<-21.5148,18.3077,-23.5787> ,0.07776}
sphere{<-19.4656,16.4907,-21.9423> ,0.0864}
texture{txttree matrix <0.663462,0.74821,0,-0.642292,0.569541,-0.512918,-0.38377,0.340301,0.858438,-19.4656,16.4907,-21.9423> }}
union{cone{<-3.67887,0.674124,-9.3407> ,0.1296,<-6.21473,1.01622,-11.4108> ,0.12096}
sphere{<-3.67887,0.674124,-9.3407> ,0.1296}
texture{txttree matrix <0.133693,0.991023,0,-0.77046,0.103938,-0.628959,-0.623312,0.0840871,0.777439,-3.67887,0.674124,-9.3407> }}
union{cone{<-6.21473,1.01622,-11.4108> ,0.12096,<-8.3732,2.34697,-13.6889> ,0.11232}
sphere{<-6.21473,1.01622,-11.4108> ,0.12096}
texture{txttree matrix <0.524801,0.851225,0,-0.633223,0.390398,-0.668295,-0.568869,0.350722,0.743896,-6.21473,1.01622,-11.4108> }}
union{cone{<-8.3732,2.34697,-13.6889> ,0.11232,<-10.494,2.81575,-16.2708> ,0.10368}
sphere{<-8.3732,2.34697,-13.6889> ,0.11232}
texture{txttree matrix <0.215824,0.976432,0,-0.628579,0.138937,-0.765236,-0.747201,0.165156,0.64375,-8.3732,2.34697,-13.6889> }}
union{cone{<-10.494,2.81575,-16.2708> ,0.10368,<-12.4308,3.35223,-18.6615> ,0.09504}
sphere{<-10.494,2.81575,-16.2708> ,0.10368}
texture{txttree matrix <0.266948,0.963711,0,-0.620118,0.171773,-0.765472,-0.737693,0.204341,0.643469,-10.494,2.81575,-16.2708> }}
union{cone{<-12.4308,3.35223,-18.6615> ,0.09504,<-14.5201,5.11752,-20.698> ,0.0864}
sphere{<-12.4308,3.35223,-18.6615> ,0.09504}
texture{txttree matrix <0.645386,0.763857,0,-0.61269,0.517665,-0.597188,-0.456166,0.385417,0.802101,-12.4308,3.35223,-18.6615> }}
union{cone{<-14.5201,5.11752,-20.698> ,0.0864,<-15.7061,6.28208,-23.3352> ,0.07776}
sphere{<-14.5201,5.11752,-20.698> ,0.0864}
texture{txttree matrix <0.700621,0.713533,0,-0.380455,0.373571,-0.84599,-0.603642,0.592719,0.533199,-14.5201,5.11752,-20.698> }}
union{cone{<-8.6099,3.94133,-14.4571> ,0.1296,<-9.08453,6.2525,-16.5596> ,0.12096}
sphere{<-8.6099,3.94133,-14.4571> ,0.1296}
texture{txttree matrix <0.979558,0.201164,0,-0.150186,0.731324,-0.665289,-0.133832,0.651689,0.746586,-8.6099,3.94133,-14.4571> }}
union{cone{<-9.08453,6.2525,-16.5596> ,0.12096,<-9.8944,8.32983,-18.9773> ,0.11232}
sphere{<-9.08453,6.2525,-16.5596> ,0.12096}
texture{txttree matrix <0.931699,0.363232,0,-0.246248,0.631633,-0.73512,-0.267019,0.68491,0.677937,-9.08453,6.2525,-16.5596> }}
union{cone{<-9.8944,8.32983,-18.9773> ,0.11232,<-9.98135,9.53855,-21.9099> ,0.10368}
sphere{<-9.8944,8.32983,-18.9773> ,0.11232}
texture{txttree matrix <0.997423,0.0717517,0,-0.0274027,0.380926,-0.924199,-0.0663129,0.921817,0.38191,-9.8944,8.32983,-18.9773> }}
union{cone{<-9.98135,9.53855,-21.9099> ,0.10368,<-10.031,11.004,-24.6748> ,0.09504}
sphere{<-9.98135,9.53855,-21.9099> ,0.10368}
texture{txttree matrix <0.999426,0.0338867,0,-0.0158766,0.46825,-0.883454,-0.0299373,0.882946,0.468519,-9.98135,9.53855,-21.9099> }}
union{cone{<-10.031,11.004,-24.6748> ,0.09504,<-9.87848,12.6766,-27.6107> ,0.0864}
sphere{<-10.031,11.004,-24.6748> ,0.09504}
texture{txttree matrix <0.995866,-0.0908341,0,0.045104,0.494502,-0.868006,0.0788445,0.864417,0.496554,-10.031,11.004,-24.6748> }}
union{cone{<-9.87848,12.6766,-27.6107> ,0.0864,<-10.0489,14.2693,-30.3534> ,0.07776}
sphere{<-9.87848,12.6766,-27.6107> ,0.0864}
texture{txttree matrix <0.994323,0.106403,0,-0.0536602,0.501448,-0.863522,-0.0918814,0.85862,0.504311,-9.87848,12.6766,-27.6107> }}
union{cone{<-8.08873,3.03829,-13.226> ,0.1296,<-8.37153,2.72581,-16.5442> ,0.12096}
sphere{<-8.08873,3.03829,-13.226> ,0.1296}
texture{txttree matrix <-0.741446,0.671012,0,-0.0845473,-0.093422,-0.99203,-0.665665,-0.735537,0.126,-8.08873,3.03829,-13.226> }}
union{cone{<-8.37153,2.72581,-16.5442> ,0.12096,<-8.39663,3.14043,-19.7693> ,0.11232}
sphere{<-8.37153,2.72581,-16.5442> ,0.12096}
texture{txttree matrix <0.998172,0.0604454,0,-0.00772156,0.127511,-0.991807,-0.0599502,0.989994,0.127744,-8.37153,2.72581,-16.5442> }}
union{cone{<-8.39663,3.14043,-19.7693> ,0.11232,<-10.0122,3.88607,-22.6516> ,0.10368}
sphere{<-8.39663,3.14043,-19.7693> ,0.11232}
texture{txttree matrix <0.419046,0.907965,0,-0.476953,0.220124,-0.850918,-0.772604,0.356574,0.525299,-8.39663,3.14043,-19.7693> }}
union{cone{<-10.0122,3.88607,-22.6516> ,0.10368,<-10.3115,5.54593,-25.2784> ,0.09504}
sphere{<-10.0122,3.88607,-22.6516> ,0.10368}
texture{txttree matrix <0.984131,0.177442,0,-0.0958706,0.531719,-0.841477,-0.149313,0.828124,0.540292,-10.0122,3.88607,-22.6516> }}
union{cone{<-10.3115,5.54593,-25.2784> ,0.09504,<-11.2217,7.25667,-27.8203> ,0.0864}
sphere{<-10.3115,5.54593,-25.2784> ,0.09504}
texture{txttree matrix <0.882829,0.469695,0,-0.28476,0.535229,-0.795262,-0.373531,0.70208,0.606266,-10.3115,5.54593,-25.2784> }}
union{cone{<-11.2217,7.25667,-27.8203> ,0.0864,<-11.7415,8.04613,-31.0712> ,0.07776}
sphere{<-11.2217,7.25667,-27.8203> ,0.0864}
texture{txttree matrix <0.835203,0.549942,0,-0.153543,0.233187,-0.960234,-0.528073,0.80199,0.279198,-11.2217,7.25667,-27.8203> }}
union{cone{<-9.27419,4.93669,-15.4533> ,0.1296,<-12.0186,5.08962,-17.3438> ,0.12096}
sphere{<-9.27419,4.93669,-15.4533> ,0.1296}
texture{txttree matrix <0.0556395,0.998451,0,-0.822657,0.0458432,-0.566687,-0.56581,0.0315302,0.823933,-9.27419,4.93669,-15.4533> }}
union{cone{<-12.0186,5.08962,-17.3438> ,0.12096,<-13.8708,5.67031,-19.9206> ,0.11232}
sphere{<-12.0186,5.08962,-17.3438> ,0.12096}
texture{txttree matrix <0.299153,0.954205,0,-0.574131,0.179996,-0.798733,-0.762155,0.238943,0.601685,-12.0186,5.08962,-17.3438> }}
union{cone{<-13.8708,5.67031,-19.9206> ,0.11232,<-15.5652,7.01349,-22.5128> ,0.10368}
sphere{<-13.8708,5.67031,-19.9206> ,0.11232}
texture{txttree matrix <0.6212,0.783652,0,-0.501964,0.397906,-0.767921,-0.601783,0.477032,0.640545,-13.8708,5.67031,-19.9206> }}
union{cone{<-15.5652,7.01349,-22.5128> ,0.10368,<-16.9723,8.40444,-25.0572> ,0.09504}
sphere{<-15.5652,7.01349,-22.5128> ,0.10368}
texture{txttree matrix <0.703017,0.711173,0,-0.436562,0.431556,-0.789413,-0.561409,0.554971,0.613862,-15.5652,7.01349,-22.5128> }}
union{cone{<-16.9723,8.40444,-25.0572> ,0.09504,<-18.2305,10.5162,-27.02> ,0.0864}
sphere{<-16.9723,8.40444,-25.0572> ,0.09504}
texture{txttree matrix <0.859095,0.511816,0,-0.399954,0.671333,-0.623978,-0.319362,0.536056,0.781442,-16.9723,8.40444,-25.0572> }}
union{cone{<-18.2305,10.5162,-27.02> ,0.0864,<-20.317,12.1674,-29.0131> ,0.07776}
sphere{<-18.2305,10.5162,-27.02> ,0.0864}
texture{txttree matrix <0.620542,0.784173,0,-0.627622,0.496657,-0.599519,-0.470127,0.372026,0.800361,-18.2305,10.5162,-27.02> }}
union{cone{<-2.33518,0.685451,-4.75552> ,0.216,<-2.86372,1.26094,-6.42183> ,0.203657}
sphere{<-2.33518,0.685451,-4.75552> ,0.216}
texture{txttree matrix <0.73651,0.676427,0,-0.287187,0.312696,-0.905398,-0.612435,0.666834,0.424564,-2.33518,0.685451,-4.75552> }}
union{cone{<-2.86372,1.26094,-6.42183> ,0.203657,<-3.23304,1.5568,-8.0866> ,0.191314}
sphere{<-2.86372,1.26094,-6.42183> ,0.203657}
texture{txttree matrix <0.62522,0.780449,0,-0.213389,0.170947,-0.961895,-0.75071,0.601396,0.273419,-2.86372,1.26094,-6.42183> }}
union{cone{<-3.23304,1.5568,-8.0866> ,0.191314,<-3.2954,2.24846,-9.79192> ,0.178971}
sphere{<-3.23304,1.5568,-8.0866> ,0.191314}
texture{txttree matrix <0.995961,0.0897899,0,-0.0338652,0.375637,-0.926148,-0.0831587,0.922407,0.377161,-3.23304,1.5568,-8.0866> }}
union{cone{<-3.2954,2.24846,-9.79192> ,0.178971,<-3.03421,2.77411,-11.3773> ,0.166629}
sphere{<-3.2954,2.24846,-9.79192> ,0.178971}
texture{txttree matrix <0.895541,-0.444979,0,0.154498,0.310934,-0.93779,0.417297,0.83983,0.347202,-3.2954,2.24846,-9.79192> }}
union{cone{<-3.03421,2.77411,-11.3773> ,0.166629,<-3.38849,3.37825,-12.9059> ,0.154286}
sphere{<-3.03421,2.77411,-11.3773> ,0.166629}
texture{txttree matrix <0.862614,0.505862,0,-0.210703,0.359298,-0.909126,-0.459892,0.784225,0.416522,-3.03421,2.77411,-11.3773> }}
union{cone{<-3.38849,3.37825,-12.9059> ,0.154286,<-3.31824,4.60925,-14.2255> ,0.141943}
sphere{<-3.38849,3.37825,-12.9059> ,0.154286}
texture{txttree matrix <0.998376,-0.0569747,0,0.0388996,0.681644,-0.73065,0.0416286,0.729463,0.682753,-3.38849,3.37825,-12.9059> }}
union{cone{<-3.31824,4.60925,-14.2255> ,0.141943,<-3.75466,5.52496,-15.7062> ,0.1296}
sphere{<-3.31824,4.60925,-14.2255> ,0.141943}
texture{txttree matrix <0.902719,0.43023,0,-0.243143,0.510169,-0.82499,-0.354935,0.744735,0.565147,-3.31824,4.60925,-14.2255> }}
union{cone{<-3.75466,5.52496,-15.7062> ,0.1296,<-4.44685,7.18895,-18.3459> ,0.12096}
sphere{<-3.75466,5.52496,-15.7062> ,0.1296}
texture{txttree matrix <0.923301,0.384077,0,-0.216562,0.520604,-0.825877,-0.3172,0.762533,0.563851,-3.75466,5.52496,-15.7062> }}
union{cone{<-4.44685,7.18895,-18.3459> ,0.12096,<-5.54219,9.58443,-20.2554> ,0.11232}
sphere{<-4.44685,7.18895,-18.3459> ,0.12096}
texture{txttree matrix <0.909436,0.415843,0,-0.336685,0.736321,-0.58692,-0.244066,0.533766,0.809645,-4.44685,7.18895,-18.3459> }}
union{cone{<-5.54219,9.58443,-20.2554> ,0.11232,<-7.02323,12.1632,-21.7469> ,0.10368}
sphere{<-5.54219,9.58443,-20.2554> ,0.11232}
texture{txttree matrix <0.86716,0.49803,0,-0.445173,0.775126,-0.448331,-0.223282,0.388774,0.893868,-5.54219,9.58443,-20.2554> }}
union{cone{<-7.02323,12.1632,-21.7469> ,0.10368,<-8.26254,14.4484,-23.8058> ,0.09504}
sphere{<-7.02323,12.1632,-21.7469> ,0.10368}
texture{txttree matrix <0.879051,0.476728,0,-0.373719,0.689109,-0.620856,-0.29598,0.545764,0.783924,-7.02323,12.1632,-21.7469> }}
union{cone{<-8.26254,14.4484,-23.8058> ,0.09504,<-9.64915,16.5454,-25.7099> ,0.0864}
sphere{<-8.26254,14.4484,-23.8058> ,0.09504}
texture{txttree matrix <0.834135,0.551561,0,-0.43968,0.664935,-0.603774,-0.333018,0.503629,0.797155,-8.26254,14.4484,-23.8058> }}
union{cone{<-9.64915,16.5454,-25.7099> ,0.0864,<-10.7215,19.2339,-27.4905> ,0.07776}
sphere{<-9.64915,16.5454,-25.7099> ,0.0864}
texture{txttree matrix <0.928839,0.370483,0,-0.315555,0.791128,-0.523967,-0.194121,0.486681,0.851738,-9.64915,16.5454,-25.7099> }}
union{cone{<-2.54431,0.913159,-5.41484> ,0.1296,<-3.11542,2.48751,-8.32442> ,0.12096}
sphere{<-2.54431,0.913159,-5.41484> ,0.1296}
texture{txttree matrix <0.940058,0.341014,0,-0.170118,0.468956,-0.866683,-0.295551,0.814733,0.498859,-2.54431,0.913159,-5.41484> }}
union{cone{<-3.11542,2.48751,-8.32442> ,0.12096,<-3.21667,2.77162,-11.4739> ,0.11232}
sphere{<-3.11542,2.48751,-8.32442> ,0.12096}
texture{txttree matrix <0.941969,0.335699,0,-0.032002,0.0897976,-0.995446,-0.33417,0.937679,0.0953296,-3.11542,2.48751,-8.32442> }}
union{cone{<-3.21667,2.77162,-11.4739> ,0.11232,<-3.03361,3.1417,-14.6866> ,0.10368}
sphere{<-3.21667,2.77162,-11.4739> ,0.11232}
texture{txttree matrix <0.896331,-0.443385,0,0.0565168,0.114253,-0.991843,0.439768,0.88902,0.127467,-3.21667,2.77162,-11.4739> }}
union{cone{<-3.03361,3.1417,-14.6866> ,0.10368,<-2.24102,4.49486,-17.6853> ,0.09504}
sphere{<-3.03361,3.1417,-14.6866> ,0.10368}
texture{txttree matrix <0.862878,-0.505413,0,0.234216,0.399871,-0.886141,0.447867,0.764631,0.463416,-3.03361,3.1417,-14.6866> }}
union{cone{<-2.24102,4.49486,-17.6853> ,0.09504,<-1.21626,5.86615,-20.3731> ,0.0864}
sphere{<-2.24102,4.49486,-17.6853> ,0.09504}
texture{txttree matrix <0.801038,-0.598614,0,0.321574,0.430316,-0.843456,0.504904,0.67564,0.537198,-2.24102,4.49486,-17.6853> }}
union{cone{<-1.21626,5.86615,-20.3731> ,0.0864,<-1.48447,7.59994,-23.1134> ,0.07776}
sphere{<-1.21626,5.86615,-20.3731> ,0.0864}
texture{txttree matrix <0.988246,0.152874,0,-0.0824283,0.532854,-0.842183,-0.128748,0.832284,0.539192,-1.21626,5.86615,-20.3731> }}
union{cone{<-3.32993,4.63377,-14.2651> ,0.1296,<-5.10726,3.77407,-17.062> ,0.12096}
sphere{<-3.32993,4.63377,-14.2651> ,0.1296}
texture{txttree matrix <-0.435438,0.900219,0,-0.519148,-0.251113,-0.816962,-0.735445,-0.355736,0.576691,-3.32993,4.63377,-14.2651> }}
union{cone{<-5.10726,3.77407,-17.062> ,0.12096,<-5.01033,4.36347,-20.4417> ,0.11232}
sphere{<-5.10726,3.77407,-17.062> ,0.12096}
texture{txttree matrix <0.986744,-0.162283,0,0.0282437,0.171733,-0.984739,0.159806,0.971685,0.17404,-5.10726,3.77407,-17.062> }}
union{cone{<-5.01033,4.36347,-20.4417> ,0.11232,<-5.59541,5.97868,-23.3914> ,0.10368}
sphere{<-5.01033,4.36347,-20.4417> ,0.11232}
texture{txttree matrix <0.940216,0.340579,0,-0.171403,0.473182,-0.86413,-0.294304,0.812469,0.503269,-5.01033,4.36347,-20.4417> }}
union{cone{<-5.59541,5.97868,-23.3914> ,0.10368,<-6.21152,7.86055,-26.0287> ,0.09504}
sphere{<-5.59541,5.97868,-23.3914> ,0.10368}
texture{txttree matrix <0.950363,0.311143,0,-0.186815,0.570615,-0.799687,-0.248817,0.759993,0.600417,-5.59541,5.97868,-23.3914> }}
union{cone{<-6.21152,7.86055,-26.0287> ,0.09504,<-7.64656,8.59372,-28.9537> ,0.0864}
sphere{<-6.21152,7.86055,-26.0287> ,0.09504}
texture{txttree matrix <0.454968,0.890508,0,-0.429713,0.219544,-0.875869,-0.779968,0.398493,0.482548,-6.21152,7.86055,-26.0287> }}
union{cone{<-7.64656,8.59372,-28.9537> ,0.0864,<-8.21865,10.5428,-31.5809> ,0.07776}
sphere{<-7.64656,8.59372,-28.9537> ,0.0864}
texture{txttree matrix <0.959521,0.281638,0,-0.172271,0.586917,-0.791107,-0.222805,0.759084,0.611677,-7.64656,8.59372,-28.9537> }}
union{cone{<-3.37077,3.68876,-13.2388> ,0.1296,<-5.08885,5.59411,-15.2269> ,0.12096}
sphere{<-3.37077,3.68876,-13.2388> ,0.1296}
texture{txttree matrix <0.74266,0.669668,0,-0.529335,0.587031,-0.612535,-0.410195,0.454906,0.790443,-3.37077,3.68876,-13.2388> }}
union{cone{<-5.08885,5.59411,-15.2269> ,0.12096,<-4.8401,8.49797,-16.9912> ,0.11232}
sphere{<-5.08885,5.59411,-15.2269> ,0.12096}
texture{txttree matrix <0.996351,-0.0853517,0,0.0730153,0.852343,-0.517861,0.0442004,0.515972,0.855464,-5.08885,5.59411,-15.2269> }}
union{cone{<-4.8401,8.49797,-16.9912> ,0.11232,<-5.168,11.3756,-18.3953> ,0.10368}
sphere{<-4.8401,8.49797,-16.9912> ,0.11232}
texture{txttree matrix <0.99357,0.113217,0,-0.101876,0.894046,-0.436237,-0.0493896,0.433432,0.899832,-4.8401,8.49797,-16.9912> }}
union{cone{<-5.168,11.3756,-18.3953> ,0.10368,<-5.57537,13.8968,-20.2481> ,0.09504}
sphere{<-5.168,11.3756,-18.3953> ,0.10368}
texture{txttree matrix <0.987196,0.159511,0,-0.129112,0.799057,-0.58723,-0.0936699,0.579711,0.80942,-5.168,11.3756,-18.3953> }}
union{cone{<-5.57537,13.8968,-20.2481> ,0.09504,<-6.00306,16.2548,-22.3581> ,0.0864}
sphere{<-5.57537,13.8968,-20.2481> ,0.09504}
texture{txttree matrix <0.983947,0.178459,0,-0.133944,0.73851,-0.660804,-0.117926,0.650196,0.750559,-5.57537,13.8968,-20.2481> }}
union{cone{<-6.00306,16.2548,-22.3581> ,0.0864,<-6.69789,18.6392,-24.5793> ,0.07776}
sphere{<-6.00306,16.2548,-22.3581> ,0.0864}
texture{txttree matrix <0.960066,0.279774,0,-0.208538,0.715613,-0.666641,-0.186509,0.640019,0.745379,-6.00306,16.2548,-22.3581> }}
union{cone{<-2.77974,0.748783,-8.25334> ,0.216,<-3.11733,0.5,-9.8971> ,0.203657}
sphere{<-2.77974,0.748783,-8.25334> ,0.216}
texture{txttree matrix <-0.593256,0.805014,0,-0.198999,-0.146653,-0.968965,-0.78003,-0.574844,0.247199,-2.77974,0.748783,-8.25334> }}
union{cone{<-3.11733,0.5,-9.8971> ,0.203657,<-2.36928,0.531758,-11.4234> ,0.191314}
sphere{<-3.11733,0.5,-9.8971> ,0.203657}
texture{txttree matrix <0.0424168,-0.9991,0,0.440026,0.0186813,-0.897791,0.896983,0.0380814,0.440422,-3.11733,0.5,-9.8971> }}
union{cone{<-2.36928,0.531758,-11.4234> ,0.191314,<-1.80868,0.685368,-12.9212> ,0.178971}
sphere{<-2.36928,0.531758,-11.4234> ,0.191314}
texture{txttree matrix <0.264267,-0.964449,0,0.348923,0.0956079,-0.932262,0.899119,0.246366,0.361785,-2.36928,0.531758,-11.4234> }}
union{cone{<-1.80868,0.685368,-12.9212> ,0.178971,<-1.11709,0.737435,-14.5011> ,0.166629}
sphere{<-1.80868,0.685368,-12.9212> ,0.178971}
texture{txttree matrix <0.0750738,-0.997178,0,0.400824,0.0301766,-0.915658,0.913074,0.0687419,0.401959,-1.80868,0.685368,-12.9212> }}
union{cone{<-1.11709,0.737435,-14.5011> ,0.166629,<-0.985389,1.23624,-16.2374> ,0.154286}
sphere{<-1.11709,0.737435,-14.5011> ,0.166629}
texture{txttree matrix <0.966865,-0.255288,0,0.072709,0.275375,-0.958583,0.244714,0.926821,0.284812,-1.11709,0.737435,-14.5011> }}
union{cone{<-0.985389,1.23624,-16.2374> ,0.154286,<-0.925059,1.62333,-17.9743> ,0.141943}
sphere{<-0.985389,1.23624,-16.2374> ,0.154286}
texture{txttree matrix <0.988072,-0.153996,0,0.0338839,0.217407,-0.975493,0.150222,0.963857,0.220031,-0.985389,1.23624,-16.2374> }}
union{cone{<-0.925059,1.62333,-17.9743> ,0.141943,<-1.00166,2.30861,-19.6341> ,0.1296}
sphere{<-0.925059,1.62333,-17.9743> ,0.141943}
texture{txttree matrix <0.993811,0.111081,0,-0.0426167,0.381279,-0.923477,-0.102581,0.917762,0.383653,-0.925059,1.62333,-17.9743> }}
union{cone{<-1.00166,2.30861,-19.6341> ,0.1296,<-2.08117,3.42159,-22.4988> ,0.12096}
sphere{<-1.00166,2.30861,-19.6341> ,0.1296}
texture{txttree matrix <0.717814,0.696235,0,-0.331405,0.341677,-0.879447,-0.612302,0.63128,0.475997,-1.00166,2.30861,-19.6341> }}
union{cone{<-2.08117,3.42159,-22.4988> ,0.12096,<-2.25439,5.51777,-25.0729> ,0.11232}
sphere{<-2.08117,3.42159,-22.4988> ,0.12096}
texture{txttree matrix <0.996603,0.0823539,0,-0.0521079,0.630582,-0.774371,-0.0637725,0.771741,0.632732,-2.08117,3.42159,-22.4988> }}
union{cone{<-2.25439,5.51777,-25.0729> ,0.11232,<-2.74004,6.84259,-28.0702> ,0.10368}
sphere{<-2.25439,5.51777,-25.0729> ,0.11232}
texture{txttree matrix <0.938901,0.344187,0,-0.1466,0.399908,-0.904755,-0.311405,0.849476,0.425932,-2.25439,5.51777,-25.0729> }}
union{cone{<-2.74004,6.84259,-28.0702> ,0.10368,<-2.66645,9.53622,-30.0925> ,0.09504}
sphere{<-2.74004,6.84259,-28.0702> ,0.10368}
texture{txttree matrix <0.999627,-0.0273099,0,0.0218428,0.799515,-0.600249,0.0163927,0.600025,0.799813,-2.74004,6.84259,-28.0702> }}
union{cone{<-2.66645,9.53622,-30.0925> ,0.09504,<-2.63827,11.6343,-32.5755> ,0.0864}
sphere{<-2.66645,9.53622,-30.0925> ,0.09504}
texture{txttree matrix <0.99991,-0.0134339,0,0.00867086,0.645391,-0.763804,0.0102608,0.763735,0.645449,-2.66645,9.53622,-30.0925> }}
union{cone{<-2.63827,11.6343,-32.5755> ,0.0864,<-2.55586,13.7029,-35.0388> ,0.07776}
sphere{<-2.63827,11.6343,-32.5755> ,0.0864}
texture{txttree matrix <0.999208,-0.0398025,0,0.0256086,0.642882,-0.765537,0.0304703,0.764931,0.643392,-2.63827,11.6343,-32.5755> }}
union{cone{<-3.02279,0.504014,-10.09> ,0.1296,<-1.8651,0.5,-12.8403> ,0.12096}
sphere{<-3.02279,0.504014,-10.09> ,0.1296}
texture{txttree matrix <-0.00346693,-0.999994,0,0.387958,-0.00134503,-0.921676,0.921671,-0.00319539,0.38796,-3.02279,0.504014,-10.09> }}
union{cone{<-1.8651,0.5,-12.8403> ,0.12096,<0.570149,0.611551,-15.1961> ,0.11232}
sphere{<-1.8651,0.5,-12.8403> ,0.12096}
texture{txttree matrix <0.0457588,-0.998953,0,0.718352,0.0329054,-0.694901,0.694173,0.0317978,0.719106,-1.8651,0.5,-12.8403> }}
union{cone{<0.570149,0.611551,-15.1961> ,0.11232,<1.16849,0.748368,-18.1104> ,0.10368}
sphere{<0.570149,0.611551,-15.1961> ,0.11232}
texture{txttree matrix <0.222908,-0.97484,0,0.200901,0.0459382,-0.978534,0.953913,0.218123,0.206086,0.570149,0.611551,-15.1961> }}
union{cone{<1.16849,0.748368,-18.1104> ,0.10368,<1.6523,1.2616,-21.4289> ,0.09504}
sphere{<1.16849,0.748368,-18.1104> ,0.10368}
texture{txttree matrix <0.727656,-0.685942,0,0.142609,0.151281,-0.97815,0.670954,0.711757,0.207902,1.16849,0.748368,-18.1104> }}
union{cone{<1.6523,1.2616,-21.4289> ,0.09504,<3.43027,1.12926,-24.2581> ,0.0864}
sphere{<1.6523,1.2616,-21.4289> ,0.09504}
texture{txttree matrix <-0.0742299,-0.997241,0,0.531672,-0.0395752,-0.846025,0.843691,-0.0628004,0.533143,1.6523,1.2616,-21.4289> }}
union{cone{<3.43027,1.12926,-24.2581> ,0.0864,<5.0835,1.44566,-27.1873> ,0.07776}
sphere{<3.43027,1.12926,-24.2581> ,0.0864}
texture{txttree matrix <0.187969,-0.982175,0,0.489353,0.0936527,-0.867043,0.851588,0.162977,0.498234,3.43027,1.12926,-24.2581> }}
union{cone{<-1.17155,0.733335,-14.3767> ,0.1296,<0.0425022,0.5,-17.0761> ,0.12096}
sphere{<-1.17155,0.733335,-14.3767> ,0.1296}
texture{txttree matrix <-0.188741,-0.982027,0,0.408905,-0.0785899,-0.909186,0.892845,-0.171601,0.416389,-1.17155,0.733335,-14.3767> }}
union{cone{<0.0425022,0.5,-17.0761> ,0.12096,<1.13277,0.543193,-20.165> ,0.11232}
sphere{<0.0425022,0.5,-17.0761> ,0.12096}
texture{txttree matrix <0.0395857,-0.999216,0,0.332809,0.0131848,-0.942902,0.942163,0.0373254,0.33307,0.0425022,0.5,-17.0761> }}
union{cone{<1.13277,0.543193,-20.165> ,0.11232,<0.58043,0.6367,-23.5345> ,0.10368}
sphere{<1.13277,0.543193,-20.165> ,0.11232}
texture{txttree matrix <0.166918,0.985971,0,-0.1617,0.0273748,-0.98646,-0.972621,0.164658,0.164001,1.13277,0.543193,-20.165> }}
union{cone{<0.58043,0.6367,-23.5345> ,0.10368,<0.691649,0.978702,-26.7214> ,0.09504}
sphere{<0.58043,0.6367,-23.5345> ,0.10368}
texture{txttree matrix <0.950978,-0.309258,0,0.0346789,0.106639,-0.993693,0.307307,0.94498,0.112136,0.58043,0.6367,-23.5345> }}
union{cone{<0.691649,0.978702,-26.7214> ,0.09504,<1.80957,1.57711,-29.8082> ,0.0864}
sphere{<0.691649,0.978702,-26.7214> ,0.09504}
texture{txttree matrix <0.471928,-0.881637,0,0.334998,0.17932,-0.924998,0.815512,0.436532,0.379973,0.691649,0.978702,-26.7214> }}
union{cone{<1.80957,1.57711,-29.8082> ,0.0864,<2.76008,2.01528,-32.8264> ,0.07776}
sphere{<1.80957,1.57711,-29.8082> ,0.0864}
texture{txttree matrix <0.418644,-0.908151,0,0.297542,0.137162,-0.944804,0.858025,0.395536,0.327635,1.80957,1.57711,-29.8082> }}
union{cone{<-2.3476,0.537698,-11.4813> ,0.1296,<-1.43183,1.42616,-14.6756> ,0.12096}
sphere{<-2.3476,0.537698,-11.4813> ,0.1296}
texture{txttree matrix <0.696326,-0.717725,0,0.266232,0.258294,-0.928658,0.666521,0.646649,0.370938,-2.3476,0.537698,-11.4813> }}
union{cone{<-1.43183,1.42616,-14.6756> ,0.12096,<-1.89331,2.2625,-17.9269> ,0.11232}
sphere{<-1.43183,1.42616,-14.6756> ,0.12096}
texture{txttree matrix <0.875557,0.483115,0,-0.136181,0.246803,-0.959449,-0.463524,0.840053,0.281881,-1.43183,1.42616,-14.6756> }}
union{cone{<-1.89331,2.2625,-17.9269> ,0.11232,<-2.78987,4.00552,-20.743> ,0.10368}
sphere{<-1.89331,2.2625,-17.9269> ,0.11232}
texture{txttree matrix <0.889257,0.457408,0,-0.261302,0.508002,-0.820765,-0.375425,0.729871,0.571265,-1.89331,2.2625,-17.9269> }}
union{cone{<-2.78987,4.00552,-20.743> ,0.10368,<-3.48774,5.74539,-23.3154> ,0.09504}
sphere{<-2.78987,4.00552,-20.743> ,0.10368}
texture{txttree matrix <0.928123,0.372275,0,-0.219255,0.546627,-0.808162,-0.300858,0.750073,0.58896,-2.78987,4.00552,-20.743> }}
union{cone{<-3.48774,5.74539,-23.3154> ,0.09504,<-3.25697,6.69414,-26.6058> ,0.0864}
sphere{<-3.48774,5.74539,-23.3154> ,0.09504}
texture{txttree matrix <0.971669,-0.236346,0,0.0672364,0.276423,-0.958681,0.226581,0.931521,0.284483,-3.48774,5.74539,-23.3154> }}
union{cone{<-3.25697,6.69414,-26.6058> ,0.0864,<-3.62001,7.74245,-29.811> ,0.07776}
sphere{<-3.25697,6.69414,-26.6058> ,0.0864}
texture{txttree matrix <0.944941,0.327241,0,-0.107035,0.309076,-0.944995,-0.309241,0.892965,0.327085,-3.25697,6.69414,-26.6058> }}
union{cone{<-3.04762,0.551371,-9.55768> ,0.1296,<-3.71655,0.5,-12.1633> ,0.12096}
sphere{<-3.04762,0.551371,-9.55768> ,0.1296}
texture{txttree matrix <-0.0765696,0.997064,0,-0.248618,-0.0190927,-0.968413,-0.96557,-0.0741511,0.24935,-3.04762,0.551371,-9.55768> }}
union{cone{<-3.71655,0.5,-12.1633> ,0.12096,<-3.09015,0.556543,-14.7595> ,0.11232}
sphere{<-3.71655,0.5,-12.1633> ,0.12096}
texture{txttree matrix <0.0899004,-0.995951,0,0.234491,0.0211665,-0.971888,0.967952,0.0873731,0.235444,-3.71655,0.5,-12.1633> }}
union{cone{<-3.09015,0.556543,-14.7595> ,0.11232,<-4.11872,0.684038,-17.8399> ,0.10368}
sphere{<-3.09015,0.556543,-14.7595> ,0.11232}
texture{txttree matrix <0.123012,0.992405,0,-0.31648,0.0392288,-0.947788,-0.940589,0.116589,0.318902,-3.09015,0.556543,-14.7595> }}
union{cone{<-4.11872,0.684038,-17.8399> ,0.10368,<-3.44218,0.529251,-21.1187> ,0.09504}
sphere{<-4.11872,0.684038,-17.8399> ,0.10368}
texture{txttree matrix <-0.223029,-0.974812,0,0.201863,-0.0461846,-0.978324,0.953682,-0.218194,0.207079,-4.11872,0.684038,-17.8399> }}
union{cone{<-3.44218,0.529251,-21.1187> ,0.09504,<-2.97318,0.65317,-24.4186> ,0.0864}
sphere{<-3.44218,0.529251,-21.1187> ,0.09504}
texture{txttree matrix <0.255457,-0.96682,0,0.140612,0.037153,-0.989367,0.956541,0.252741,0.145437,-3.44218,0.529251,-21.1187> }}
union{cone{<-2.97318,0.65317,-24.4186> ,0.0864,<-3.03656,1.29776,-27.5372> ,0.07776}
sphere{<-2.97318,0.65317,-24.4186> ,0.0864}
texture{txttree matrix <0.995202,0.0978411,0,-0.0198958,0.202373,-0.979106,-0.0957969,0.974409,0.203348,-2.97318,0.65317,-24.4186> }}
union{cone{<-2.61479,0.849934,-7.65754> ,0.216,<-1.79486,0.5,-9.01595> ,0.203657}
sphere{<-2.61479,0.849934,-7.65754> ,0.216}
texture{txttree matrix <-0.392529,-0.919739,0,0.504631,-0.215368,-0.836041,0.76894,-0.328171,0.548667,-2.61479,0.849934,-7.65754> }}
union{cone{<-1.79486,0.5,-9.01595> ,0.203657,<-0.678771,0.882839,-10.2699> ,0.191314}
sphere{<-1.79486,0.5,-9.01595> ,0.203657}
texture{txttree matrix <0.324462,-0.945899,0,0.648213,0.22235,-0.728272,0.688872,0.236297,0.685288,-1.79486,0.5,-9.01595> }}
union{cone{<-0.678771,0.882839,-10.2699> ,0.191314,<0.335829,1.37259,-11.5522> ,0.178971}
sphere{<-0.678771,0.882839,-10.2699> ,0.191314}
texture{txttree matrix <0.43471,-0.900571,0,0.594414,0.286926,-0.751229,0.676535,0.326567,0.660041,-0.678771,0.882839,-10.2699> }}
union{cone{<0.335829,1.37259,-11.5522> ,0.178971,<0.724814,1.19783,-13.1944> ,0.166629}
sphere{<0.335829,1.37259,-11.5522> ,0.178971}
texture{txttree matrix <-0.409811,-0.912171,0,0.229254,-0.102997,-0.967902,0.882892,-0.396657,0.251328,0.335829,1.37259,-11.5522> }}
union{cone{<0.724814,1.19783,-13.1944> ,0.166629,<1.5207,1.09231,-14.8374> ,0.154286}
sphere{<0.724814,1.19783,-13.1944> ,0.166629}
texture{txttree matrix <-0.131439,-0.991324,0,0.435233,-0.0577075,-0.898466,0.890671,-0.118094,0.439042,0.724814,1.19783,-13.1944> }}
union{cone{<1.5207,1.09231,-14.8374> ,0.154286,<2.00374,1.17448,-16.5525> ,0.141943}
sphere{<1.5207,1.09231,-14.8374> ,0.154286}
texture{txttree matrix <0.167705,-0.985837,0,0.270805,0.0460678,-0.961531,0.947913,0.161253,0.274696,1.5207,1.09231,-14.8374> }}
union{cone{<2.00374,1.17448,-16.5525> ,0.141943,<2.68869,1.31343,-18.1089> ,0.1296}
sphere{<2.00374,1.17448,-16.5525> ,0.141943}
texture{txttree matrix <0.198819,-0.980036,0,0.401476,0.0814472,-0.912241,0.894029,0.181371,0.409654,2.00374,1.17448,-16.5525> }}
union{cone{<2.68869,1.31343,-18.1089> ,0.1296,<4.70447,2.0996,-20.4177> ,0.12096}
sphere{<2.68869,1.31343,-18.1089> ,0.1296}
texture{txttree matrix <0.363352,-0.931652,0,0.637056,0.248457,-0.729677,0.679805,0.26513,0.683792,2.68869,1.31343,-18.1089> }}
union{cone{<4.70447,2.0996,-20.4177> ,0.12096,<6.53148,3.44509,-22.8276> ,0.11232}
sphere{<4.70447,2.0996,-20.4177> ,0.12096}
texture{txttree matrix <0.59299,-0.80521,0,0.551974,0.406497,-0.728069,0.586248,0.431738,0.685504,4.70447,2.0996,-20.4177> }}
union{cone{<6.53148,3.44509,-22.8276> ,0.11232,<8.50623,3.35175,-25.465> ,0.10368}
sphere{<6.53148,3.44509,-22.8276> ,0.11232}
texture{txttree matrix <-0.047212,-0.998885,0,0.599121,-0.0283173,-0.800158,0.799265,-0.0377771,0.59979,6.53148,3.44509,-22.8276> }}
union{cone{<8.50623,3.35175,-25.465> ,0.10368,<10.6444,5.18076,-27.3989> ,0.09504}
sphere{<8.50623,3.35175,-25.465> ,0.10368}
texture{txttree matrix <0.650031,-0.759908,0,0.626246,0.535696,-0.566432,0.430437,0.368198,0.824108,8.50623,3.35175,-25.465> }}
union{cone{<10.6444,5.18076,-27.3989> ,0.09504,<12.3465,5.6397,-30.3351> ,0.0864}
sphere{<10.6444,5.18076,-27.3989> ,0.09504}
texture{txttree matrix <0.260334,-0.965519,0,0.497,0.134007,-0.857341,0.827779,0.223195,0.514749,10.6444,5.18076,-27.3989> }}
union{cone{<12.3465,5.6397,-30.3351> ,0.0864,<13.4269,7.70137,-32.6011> ,0.07776}
sphere{<12.3465,5.6397,-30.3351> ,0.0864}
texture{txttree matrix <0.88574,-0.464182,0,0.3326,0.63466,-0.697556,0.323793,0.617853,0.716531,12.3465,5.6397,-30.3351> }}
union{cone{<2.19218,1.21271,-16.9807> ,0.1296,<3.19904,0.5,-19.5487> ,0.12096}
sphere{<2.19218,1.21271,-16.9807> ,0.1296}
texture{txttree matrix <-0.577755,-0.81621,0,0.353417,-0.250166,-0.901395,0.735728,-0.520786,0.432997,2.19218,1.21271,-16.9807> }}
union{cone{<3.19904,0.5,-19.5487> ,0.12096,<4.03982,0.928053,-22.7422> ,0.11232}
sphere{<3.19904,0.5,-19.5487> ,0.12096}
texture{txttree matrix <0.453699,-0.891155,0,0.252492,0.128547,-0.959022,0.854638,0.435107,0.283331,3.19904,0.5,-19.5487> }}
union{cone{<4.03982,0.928053,-22.7422> ,0.11232,<6.32175,0.608523,-24.8882> ,0.10368}
sphere{<4.03982,0.928053,-22.7422> ,0.11232}
texture{txttree matrix <-0.138673,-0.990338,0,0.724702,-0.101477,-0.681549,0.674964,-0.0945125,0.731773,4.03982,0.928053,-22.7422> }}
union{cone{<6.32175,0.608523,-24.8882> ,0.10368,<7.78576,0.957797,-27.7011> ,0.09504}
sphere{<6.32175,0.608523,-24.8882> ,0.10368}
texture{txttree matrix <0.23206,-0.972702,0,0.458909,0.109483,-0.881712,0.857643,0.20461,0.471788,6.32175,0.608523,-24.8882> }}
union{cone{<7.78576,0.957797,-27.7011> ,0.09504,<8.90751,0.879807,-30.9514> ,0.0864}
sphere{<7.78576,0.957797,-27.7011> ,0.09504}
texture{txttree matrix <-0.0693579,-0.997592,0,0.32615,-0.0226757,-0.945046,0.94277,-0.0655464,0.326938,7.78576,0.957797,-27.7011> }}
union{cone{<8.90751,0.879807,-30.9514> ,0.0864,<9.85738,0.995287,-34.0828> ,0.07776}
sphere{<8.90751,0.879807,-30.9514> ,0.0864}
texture{txttree matrix <0.120685,-0.992691,0,0.290097,0.035268,-0.956347,0.949357,0.115417,0.292233,8.90751,0.879807,-30.9514> }}
union{cone{<0.48833,1.30408,-12.196> ,0.1296,<0.245985,1.90377,-15.3073> ,0.12096}
sphere{<0.48833,1.30408,-12.196> ,0.1296}
texture{txttree matrix <0.927155,0.374678,0,-0.0762614,0.188712,-0.979067,-0.366835,0.907747,0.203539,0.48833,1.30408,-12.196> }}
union{cone{<0.245985,1.90377,-15.3073> ,0.12096,<-0.681315,1.26426,-18.5147> ,0.11232}
sphere{<0.245985,1.90377,-15.3073> ,0.12096}
texture{txttree matrix <-0.56773,0.823215,0,-0.272777,-0.188121,-0.943506,-0.776708,-0.535656,0.331356,0.245985,1.90377,-15.3073> }}
union{cone{<-0.681315,1.26426,-18.5147> ,0.11232,<-0.965545,2.38811,-21.5238> ,0.10368}
sphere{<-0.681315,1.26426,-18.5147> ,0.11232}
texture{txttree matrix <0.969476,0.245186,0,-0.0881424,0.348519,-0.933148,-0.228795,0.904665,0.359492,-0.681315,1.26426,-18.5147> }}
union{cone{<-0.965545,2.38811,-21.5238> ,0.10368,<-0.670538,3.54469,-24.654> ,0.09504}
sphere{<-0.965545,2.38811,-21.5238> ,0.10368}
texture{txttree matrix <0.968976,-0.247156,0,0.0880615,0.345245,-0.934372,0.230936,0.905384,0.356299,-0.965545,2.38811,-21.5238> }}
union{cone{<-0.670538,3.54469,-24.654> ,0.09504,<-0.854605,4.97307,-27.4887> ,0.0864}
sphere{<-0.670538,3.54469,-24.654> ,0.09504}
texture{txttree matrix <0.991799,0.127807,0,-0.0578909,0.44924,-0.891533,-0.113944,0.884222,0.452955,-0.670538,3.54469,-24.654> }}
union{cone{<-0.854605,4.97307,-27.4887> ,0.0864,<-1.29564,5.39016,-30.729> ,0.07776}
sphere{<-0.854605,4.97307,-27.4887> ,0.0864}
texture{txttree matrix <0.687108,0.726556,0,-0.133781,0.126517,-0.982902,-0.714133,0.675359,0.18413,-0.854605,4.97307,-27.4887> }}
union{cone{<2.63404,1.30235,-17.9847> ,0.1296,<2.02285,1.18481,-21.2803> ,0.12096}
sphere{<2.63404,1.30235,-17.9847> ,0.1296}
texture{txttree matrix <-0.188842,0.982007,0,-0.182234,-0.0350439,-0.982631,-0.964951,-0.185562,0.185573,2.63404,1.30235,-17.9847> }}
union{cone{<2.02285,1.18481,-21.2803> ,0.12096,<2.4681,0.971883,-24.6119> ,0.11232}
sphere{<2.02285,1.18481,-21.2803> ,0.12096}
texture{txttree matrix <-0.431428,-0.902148,0,0.132204,-0.0632229,-0.989204,0.892408,-0.42677,0.146543,2.02285,1.18481,-21.2803> }}
union{cone{<2.4681,0.971883,-24.6119> ,0.11232,<2.24985,1.29905,-27.7736> ,0.10368}
sphere{<2.4681,0.971883,-24.6119> ,0.11232}
texture{txttree matrix <0.83189,0.55494,0,-0.068499,0.102684,-0.992353,-0.550697,0.825528,0.123435,2.4681,0.971883,-24.6119> }}
union{cone{<2.24985,1.29905,-27.7736> ,0.10368,<2.98279,2.94867,-30.5028> ,0.09504}
sphere{<2.24985,1.29905,-27.7736> ,0.10368}
texture{txttree matrix <0.913858,-0.406035,0,0.223997,0.504146,-0.834064,0.338659,0.762215,0.551668,2.24985,1.29905,-27.7736> }}
union{cone{<2.98279,2.94867,-30.5028> ,0.09504,<3.42466,3.65543,-33.5752> ,0.0864}
sphere{<2.98279,2.94867,-30.5028> ,0.09504}
texture{txttree matrix <0.847923,-0.53012,0,0.138799,0.222008,-0.965115,0.511626,0.818343,0.261826,2.98279,2.94867,-30.5028> }}
union{cone{<3.42466,3.65543,-33.5752> ,0.0864,<3.172,5.42626,-36.1927> ,0.07776}
sphere{<3.42466,3.65543,-33.5752> ,0.0864}
texture{txttree matrix <0.989974,0.141249,0,-0.0796955,0.558564,-0.825624,-0.116618,0.817346,0.564221,3.42466,3.65543,-33.5752> }}
union{cone{<-2.39745,0.757177,-8.01761> ,0.1296,<0.265141,0.930125,-9.81605> ,0.12096}
sphere{<-2.39745,0.757177,-8.01761> ,0.1296}
texture{txttree matrix <0.0648181,-0.997897,0,0.82748,0.0537487,-0.558917,0.557741,0.0362279,0.829224,-2.39745,0.757177,-8.01761> }}
union{cone{<0.265141,0.930125,-9.81605> ,0.12096,<2.67073,2.26763,-11.4771> ,0.11232}
sphere{<0.265141,0.930125,-9.81605> ,0.12096}
texture{txttree matrix <0.485938,-0.873993,0,0.748288,0.416047,-0.516692,0.451585,0.25108,0.856172,0.265141,0.930125,-9.81605> }}
union{cone{<2.67073,2.26763,-11.4771> ,0.11232,<3.91449,3.67011,-13.9963> ,0.10368}
sphere{<2.67073,2.26763,-11.4771> ,0.11232}
texture{txttree matrix <0.748175,-0.663502,0,0.396087,0.446633,-0.802268,0.532306,0.600237,0.596964,2.67073,2.26763,-11.4771> }}
union{cone{<3.91449,3.67011,-13.9963> ,0.10368,<6.41297,4.15613,-16.2688> ,0.09504}
sphere{<3.91449,3.67011,-13.9963> ,0.10368}
texture{txttree matrix <0.190948,-0.9816,0,0.732233,0.14244,-0.665992,0.653738,0.12717,0.745959,3.91449,3.67011,-13.9963> }}
union{cone{<6.41297,4.15613,-16.2688> ,0.09504,<7.43829,5.6955,-18.8164> ,0.0864}
sphere{<6.41297,4.15613,-16.2688> ,0.09504}
texture{txttree matrix <0.832282,-0.554352,0,0.32568,0.488962,-0.809227,0.448597,0.673505,0.587496,6.41297,4.15613,-16.2688> }}
union{cone{<7.43829,5.6955,-18.8164> ,0.0864,<9.29452,7.32116,-21.076> ,0.07776}
sphere{<7.43829,5.6955,-18.8164> ,0.0864}
texture{txttree matrix <0.65884,-0.752283,0,0.554804,0.48589,-0.675355,0.508058,0.44495,0.737493,7.43829,5.6955,-18.8164> }}
union{cone{<-0.13691,2.00698,-0.206357> ,0.6,<-0.621819,1.89723,-0.0541238> ,0.573333}
sphere{<-0.13691,2.00698,-0.206357> ,0.6}
texture{txttree matrix <-0.220741,0.975332,0,-0.932593,-0.211068,0.29278,0.285557,0.0646285,0.95618,-0.13691,2.00698,-0.206357> }}
union{cone{<-0.621819,1.89723,-0.0541238> ,0.573333,<-1.09064,1.65046,0.116273> ,0.546667}
sphere{<-0.621819,1.89723,-0.0541238> ,0.573333}
texture{txttree matrix <-0.465784,0.884898,0,-0.8424,-0.443414,0.30618,0.270938,0.142614,0.951974,-0.621819,1.89723,-0.0541238> }}
union{cone{<-1.09064,1.65046,0.116273> ,0.546667,<-1.54336,1.68192,0.350115> ,0.52}
sphere{<-1.09064,1.65046,0.116273> ,0.546667}
texture{txttree matrix <0.0693355,0.997593,0,-0.886789,0.0616343,0.458046,0.456944,-0.0317588,0.888929,-1.09064,1.65046,0.116273> }}
union{cone{<-1.54336,1.68192,0.350115> ,0.52,<-2.00507,1.55755,0.624926> ,0.493333}
sphere{<-1.54336,1.68192,0.350115> ,0.52}
texture{txttree matrix <-0.260099,0.965582,0,-0.837171,-0.225509,0.498288,0.481138,0.129604,0.867011,-1.54336,1.68192,0.350115> }}
union{cone{<-2.00507,1.55755,0.624926> ,0.493333,<-2.50088,1.66739,0.579753> ,0.466667}
sphere{<-2.00507,1.55755,0.624926> ,0.493333}
texture{txttree matrix <0.21628,0.976331,0,-0.972491,0.21543,-0.0886029,-0.0865058,0.0191631,0.996067,-2.00507,1.55755,0.624926> }}
union{cone{<-2.50088,1.66739,0.579753> ,0.466667,<-2.99875,1.67665,0.412005> ,0.44}
sphere{<-2.50088,1.66739,0.579753> ,0.466667}
texture{txttree matrix <0.0185943,0.999827,0,-0.947509,0.0176213,-0.319242,-0.319187,0.00593608,0.947673,-2.50088,1.66739,0.579753> }}
union{cone{<-2.99875,1.67665,0.412005> ,0.44,<-3.5116,1.68914,0.307989> ,0.413333}
sphere{<-2.99875,1.67665,0.412005> ,0.44}
texture{txttree matrix <0.0243501,0.999703,0,-0.979766,0.0238645,-0.198717,-0.198658,0.00483879,0.980057,-2.99875,1.67665,0.412005> }}
union{cone{<-3.5116,1.68914,0.307989> ,0.413333,<-4.00834,1.81156,0.381458> ,0.386667}
sphere{<-3.5116,1.68914,0.307989> ,0.413333}
texture{txttree matrix <0.239296,0.970947,0,-0.961087,0.236866,0.142146,0.138016,-0.034015,0.989846,-3.5116,1.68914,0.307989> }}
union{cone{<-4.00834,1.81156,0.381458> ,0.386667,<-4.46438,1.95243,0.163586> ,0.36}
sphere{<-4.00834,1.81156,0.381458> ,0.386667}
texture{txttree matrix <0.295142,0.955453,0,-0.869182,0.268493,-0.415253,-0.396755,0.122559,0.909706,-4.00834,1.81156,0.381458> }}
union{cone{<-4.46438,1.95243,0.163586> ,0.36,<-5.41182,1.95155,0.471633> ,0.342}
sphere{<-4.46438,1.95243,0.163586> ,0.36}
texture{txttree matrix <-0.000934178,1,0,-0.950996,-0.0008884,0.309201,0.309201,0.000288849,0.950997,-4.46438,1.95243,0.163586> }}
union{cone{<-5.41182,1.95155,0.471633> ,0.342,<-6.05196,2.20617,1.1996> ,0.324}
sphere{<-5.41182,1.95155,0.471633> ,0.342}
texture{txttree matrix <0.369596,0.929192,0,-0.638688,0.254045,0.726318,0.674889,-0.268445,0.687359,-5.41182,1.95155,0.471633> }}
union{cone{<-6.05196,2.20617,1.1996> ,0.324,<-6.74802,2.44343,1.82258> ,0.306}
sphere{<-6.05196,2.20617,1.1996> ,0.324}
texture{txttree matrix <0.322629,0.946526,0,-0.722207,0.246168,0.646389,0.611823,-0.208544,0.763008,-6.05196,2.20617,1.1996> }}
union{cone{<-6.74802,2.44343,1.82258> ,0.306,<-7.44388,2.67452,2.37326> ,0.288}
sphere{<-6.74802,2.44343,1.82258> ,0.306}
texture{txttree matrix <0.315168,0.949036,0,-0.758856,0.252011,0.600523,0.569918,-0.189266,0.799607,-6.74802,2.44343,1.82258> }}
union{cone{<-7.44388,2.67452,2.37326> ,0.288,<-8.20963,3.23045,2.55267> ,0.27}
sphere{<-7.44388,2.67452,2.37326> ,0.288}
texture{txttree matrix <0.587494,0.809229,0,-0.795064,0.57721,0.186285,0.150747,-0.109441,0.982496,-7.44388,2.67452,2.37326> }}
union{cone{<-8.20963,3.23045,2.55267> ,0.27,<-8.7393,3.96563,2.97031> ,0.252}
sphere{<-8.20963,3.23045,2.55267> ,0.27}
texture{txttree matrix <0.811358,0.58455,0,-0.530875,0.736857,0.418585,0.244684,-0.339622,0.908178,-8.20963,3.23045,2.55267> }}
union{cone{<-8.7393,3.96563,2.97031> ,0.252,<-9.33973,4.67319,3.29891> ,0.234}
sphere{<-8.7393,3.96563,2.97031> ,0.252}
texture{txttree matrix <0.762468,0.647026,0,-0.609916,0.718737,0.333796,0.215974,-0.254509,0.942645,-8.7393,3.96563,2.97031> }}
union{cone{<-9.33973,4.67319,3.29891> ,0.234,<-10.1777,5.17608,3.29247> ,0.216}
sphere{<-9.33973,4.67319,3.29891> ,0.234}
texture{txttree matrix <0.514559,0.857455,0,-0.857436,0.514548,-0.00659256,-0.00565282,0.00339226,0.999978,-9.33973,4.67319,3.29891> }}
union{cone{<-10.1777,5.17608,3.29247> ,0.216,<-11.8677,5.57328,3.76215> ,0.203657}
sphere{<-10.1777,5.17608,3.29247> ,0.216}
texture{txttree matrix <0.228805,0.973472,0,-0.939687,0.220864,0.261165,0.254237,-0.059756,0.965294,-10.1777,5.17608,3.29247> }}
union{cone{<-11.8677,5.57328,3.76215> ,0.203657,<-13.2986,6.01971,4.51245> ,0.191314}
sphere{<-11.8677,5.57328,3.76215> ,0.203657}
texture{txttree matrix <0.297835,0.954617,0,-0.853643,0.266332,0.447617,0.427303,-0.133316,0.894225,-11.8677,5.57328,3.76215> }}
union{cone{<-13.2986,6.01971,4.51245> ,0.191314,<-14.5878,7.26181,4.62035> ,0.178971}
sphere{<-13.2986,6.01971,4.51245> ,0.191314}
texture{txttree matrix <0.693814,0.720154,0,-0.718849,0.692558,0.060162,0.0433259,-0.0417413,0.998189,-13.2986,6.01971,4.51245> }}
union{cone{<-14.5878,7.26181,4.62035> ,0.178971,<-15.8505,8.474,4.63236> ,0.166629}
sphere{<-14.5878,7.26181,4.62035> ,0.178971}
texture{txttree matrix <0.692531,0.721388,0,-0.721371,0.692515,0.00685974,0.00494854,-0.00475059,0.999976,-14.5878,7.26181,4.62035> }}
union{cone{<-15.8505,8.474,4.63236> ,0.166629,<-17.216,9.57534,5.00166> ,0.154286}
sphere{<-15.8505,8.474,4.63236> ,0.166629}
texture{txttree matrix <0.627794,0.77838,0,-0.761685,0.614329,0.206,0.160346,-0.129326,0.978552,-15.8505,8.474,4.63236> }}
union{cone{<-17.216,9.57534,5.00166> ,0.154286,<-18.1333,10.9542,5.22988> ,0.141943}
sphere{<-17.216,9.57534,5.00166> ,0.154286}
texture{txttree matrix <0.832597,0.553879,0,-0.548693,0.824802,0.136519,0.0756152,-0.113666,0.990637,-17.216,9.57534,5.00166> }}
union{cone{<-18.1333,10.9542,5.22988> ,0.141943,<-18.7781,12.6184,4.77348> ,0.1296}
sphere{<-18.1333,10.9542,5.22988> ,0.141943}
texture{txttree matrix <0.932461,0.361272,0,-0.350009,0.90339,-0.247751,-0.0895056,0.231018,0.968824,-18.1333,10.9542,5.22988> }}
union{cone{<-18.7781,12.6184,4.77348> ,0.1296,<-18.6348,15.9265,5.48867> ,0.12096}
sphere{<-18.7781,12.6184,4.77348> ,0.1296}
texture{txttree matrix <0.999064,-0.043256,0,0.0422811,0.976546,0.211117,-0.0091321,-0.21092,0.977461,-18.7781,12.6184,4.77348> }}
union{cone{<-18.6348,15.9265,5.48867> ,0.12096,<-20.3831,18.6978,6.13991> ,0.11232}
sphere{<-18.6348,15.9265,5.48867> ,0.12096}
texture{txttree matrix <0.845761,0.533562,0,-0.523326,0.829536,0.194937,0.104011,-0.16487,0.980816,-18.6348,15.9265,5.48867> }}
union{cone{<-20.3831,18.6978,6.13991> ,0.11232,<-20.5165,21.9653,5.22854> ,0.10368}
sphere{<-20.3831,18.6978,6.13991> ,0.11232}
texture{txttree matrix <0.999168,0.0407823,0,-0.0392853,0.96249,-0.268458,-0.0109484,0.268235,0.963291,-20.3831,18.6978,6.13991> }}
union{cone{<-20.5165,21.9653,5.22854> ,0.10368,<-21.5821,24.8451,4.18356> ,0.09504}
sphere{<-20.5165,21.9653,5.22854> ,0.10368}
texture{txttree matrix <0.937852,0.347035,0,-0.328532,0.887849,-0.322167,-0.111803,0.302145,0.946683,-20.5165,21.9653,5.22854> }}
union{cone{<-21.5821,24.8451,4.18356> ,0.09504,<-22.0494,28.0393,4.13413> ,0.0864}
sphere{<-21.5821,24.8451,4.18356> ,0.09504}
texture{txttree matrix <0.989467,0.144761,0,-0.144744,0.989351,-0.0153083,-0.00221605,0.0151471,0.999883,-21.5821,24.8451,4.18356> }}
union{cone{<-22.0494,28.0393,4.13413> ,0.0864,<-22.3083,31.0509,2.88558> ,0.07776}
sphere{<-22.0494,28.0393,4.13413> ,0.0864}
texture{txttree matrix <0.996327,0.0856244,0,-0.0791388,0.920861,-0.381774,-0.0326892,0.380372,0.924256,-22.0494,28.0393,4.13413> }}
union{cone{<-14.1745,6.8636,4.58576> ,0.1296,<-16.0542,9.47625,4.08573> ,0.12096}
sphere{<-14.1745,6.8636,4.58576> ,0.1296}
texture{txttree matrix <0.811739,0.584021,0,-0.577098,0.802117,-0.153516,-0.0896565,0.124615,0.988146,-14.1745,6.8636,4.58576> }}
union{cone{<-16.0542,9.47625,4.08573> ,0.12096,<-17.3261,12.6403,4.0405> ,0.11232}
sphere{<-16.0542,9.47625,4.08573> ,0.12096}
texture{txttree matrix <0.927843,0.37297,0,-0.372938,0.927762,-0.0132597,-0.00494547,0.0123029,0.999912,-16.0542,9.47625,4.08573> }}
union{cone{<-17.3261,12.6403,4.0405> ,0.11232,<-18.5096,15.6875,3.15789> ,0.10368}
sphere{<-17.3261,12.6403,4.0405> ,0.11232}
texture{txttree matrix <0.932164,0.362035,0,-0.349519,0.899939,-0.260666,-0.0943703,0.242984,0.965429,-17.3261,12.6403,4.0405> }}
union{cone{<-18.5096,15.6875,3.15789> ,0.10368,<-19.0338,18.7371,2.64769> ,0.09504}
sphere{<-18.5096,15.6875,3.15789> ,0.10368}
texture{txttree matrix <0.985546,0.169408,0,-0.167151,0.972416,-0.162686,-0.0275603,0.160335,0.986678,-18.5096,15.6875,3.15789> }}
union{cone{<-19.0338,18.7371,2.64769> ,0.09504,<-20.4654,21.5459,1.86094> ,0.0864}
sphere{<-19.0338,18.7371,2.64769> ,0.09504}
texture{txttree matrix <0.890938,0.454126,0,-0.440612,0.864426,-0.242133,-0.109959,0.215726,0.970243,-19.0338,18.7371,2.64769> }}
union{cone{<-20.4654,21.5459,1.86094> ,0.0864,<-20.5359,24.7636,1.14366> ,0.07776}
sphere{<-20.4654,21.5459,1.86094> ,0.0864}
texture{txttree matrix <0.99976,0.0218876,0,-0.0213635,0.975821,-0.217522,-0.00476104,0.21747,0.976055,-20.4654,21.5459,1.86094> }}
union{cone{<-14.1175,6.80872,4.58099> ,0.1296,<-16.0779,8.87467,3.09628> ,0.12096}
sphere{<-14.1175,6.80872,4.58099> ,0.1296}
texture{txttree matrix <0.725392,0.688336,0,-0.610376,0.643235,-0.462265,-0.318194,0.335324,0.886742,-14.1175,6.80872,4.58099> }}
union{cone{<-16.0779,8.87467,3.09628> ,0.12096,<-18.4633,10.9723,2.83105> ,0.11232}
sphere{<-16.0779,8.87467,3.09628> ,0.12096}
texture{txttree matrix <0.660368,0.750942,0,-0.748338,0.658078,-0.0832076,-0.0624841,0.0549476,0.996532,-16.0779,8.87467,3.09628> }}
union{cone{<-18.4633,10.9723,2.83105> ,0.11232,<-19.0787,13.7675,1.2007> ,0.10368}
sphere{<-18.4633,10.9723,2.83105> ,0.11232}
texture{txttree matrix <0.976608,0.215026,0,-0.186839,0.848588,-0.494964,-0.10643,0.483386,0.868913,-18.4633,10.9723,2.83105> }}
union{cone{<-19.0787,13.7675,1.2007> ,0.10368,<-19.7241,16.5843,-0.481718> ,0.09504}
sphere{<-19.0787,13.7675,1.2007> ,0.10368}
texture{txttree matrix <0.974747,0.22331,0,-0.192987,0.842386,-0.503131,-0.112354,0.490426,0.86421,-19.0787,13.7675,1.2007> }}
union{cone{<-19.7241,16.5843,-0.481718> ,0.09504,<-21.2263,19.2938,-1.62476> ,0.0864}
sphere{<-19.7241,16.5843,-0.481718> ,0.09504}
texture{txttree matrix <0.87458,0.484882,0,-0.454907,0.820513,-0.346147,-0.16784,0.302733,0.93818,-19.7241,16.5843,-0.481718> }}
union{cone{<-21.2263,19.2938,-1.62476> ,0.0864,<-22.0068,22.0269,-3.26719> ,0.07776}
sphere{<-21.2263,19.2938,-1.62476> ,0.0864}
texture{txttree matrix <0.961555,0.274614,0,-0.237771,0.832551,-0.500324,-0.137396,0.481088,0.865838,-21.2263,19.2938,-1.62476> }}
union{cone{<-18.3662,11.5553,5.06502> ,0.1296,<-20.8167,13.6817,4.33309> ,0.12096}
sphere{<-18.3662,11.5553,5.06502> ,0.1296}
texture{txttree matrix <0.655394,0.755287,0,-0.736772,0.639327,-0.220064,-0.166212,0.144229,0.975485,-18.3662,11.5553,5.06502> }}
union{cone{<-20.8167,13.6817,4.33309> ,0.12096,<-21.5141,15.6956,1.71106> ,0.11232}
sphere{<-20.8167,13.6817,4.33309> ,0.12096}
texture{txttree matrix <0.944939,0.327247,0,-0.20641,0.596017,-0.775988,-0.25394,0.733261,0.630747,-20.8167,13.6817,4.33309> }}
union{cone{<-21.5141,15.6956,1.71106> ,0.11232,<-22.9193,17.4385,-0.790783> ,0.10368}
sphere{<-21.5141,15.6956,1.71106> ,0.11232}
texture{txttree matrix <0.778509,0.627634,0,-0.418531,0.51914,-0.745202,-0.467714,0.580146,0.666839,-21.5141,15.6956,1.71106> }}
union{cone{<-22.9193,17.4385,-0.790783> ,0.10368,<-24.3926,20.1403,-1.9745> ,0.09504}
sphere{<-22.9193,17.4385,-0.790783> ,0.10368}
texture{txttree matrix <0.877939,0.478773,0,-0.446855,0.81941,-0.359011,-0.171885,0.315189,0.933333,-22.9193,17.4385,-0.790783> }}
union{cone{<-24.3926,20.1403,-1.9745> ,0.09504,<-25.0952,22.1453,-4.652> ,0.0864}
sphere{<-24.3926,20.1403,-1.9745> ,0.09504}
texture{txttree matrix <0.943732,0.33071,0,-0.205565,0.586612,-0.783345,-0.25906,0.739268,0.621588,-24.3926,20.1403,-1.9745> }}
union{cone{<-25.0952,22.1453,-4.652> ,0.0864,<-25.5578,24.3278,-7.13312> ,0.07776}
sphere{<-25.0952,22.1453,-4.652> ,0.0864}
texture{txttree matrix <0.978271,0.207328,0,-0.138627,0.654105,-0.743592,-0.154168,0.727435,0.668634,-25.0952,22.1453,-4.652> }}
union{cone{<-8.67182,3.87196,2.9171> ,0.216,<-9.12193,5.51591,3.46013> ,0.203657}
sphere{<-8.67182,3.87196,2.9171> ,0.216}
texture{txttree matrix <0.9645,0.264083,0,-0.251621,0.918987,0.303561,0.0801654,-0.292785,0.952812,-8.67182,3.87196,2.9171> }}
union{cone{<-9.12193,5.51591,3.46013> ,0.203657,<-8.94581,7.06597,4.28091> ,0.191314}
sphere{<-9.12193,5.51591,3.46013> ,0.203657}
texture{txttree matrix <0.993607,-0.112897,0,0.0999119,0.879328,0.465618,-0.0525667,-0.462641,0.884986,-9.12193,5.51591,3.46013> }}
union{cone{<-8.94581,7.06597,4.28091> ,0.191314,<-9.3494,8.83032,4.33728> ,0.178971}
sphere{<-8.94581,7.06597,4.28091> ,0.191314}
texture{txttree matrix <0.974822,0.222986,0,-0.222878,0.974349,0.0311276,0.00694102,-0.0303438,0.999515,-8.94581,7.06597,4.28091> }}
union{cone{<-9.3494,8.83032,4.33728> ,0.178971,<-9.19036,10.4928,5.084> ,0.166629}
sphere{<-9.3494,8.83032,4.33728> ,0.178971}
texture{txttree matrix <0.995455,-0.0952317,0,0.0869369,0.90875,0.408186,-0.0388723,-0.406331,0.912899,-9.3494,8.83032,4.33728> }}
union{cone{<-9.19036,10.4928,5.084> ,0.166629,<-8.6966,12.2225,5.11833> ,0.154286}
sphere{<-9.19036,10.4928,5.084> ,0.166629}
texture{txttree matrix <0.961592,-0.274482,0,0.274432,0.961417,0.019082,-0.00523766,-0.0183491,0.999818,-9.19036,10.4928,5.084> }}
union{cone{<-8.6966,12.2225,5.11833> ,0.154286,<-9.0463,13.9221,5.02045> ,0.141943}
sphere{<-8.6966,12.2225,5.11833> ,0.154286}
texture{txttree matrix <0.979481,0.201536,0,-0.201216,0.977926,-0.0563232,-0.0113511,0.0551675,0.998413,-8.6966,12.2225,5.11833> }}
union{cone{<-9.0463,13.9221,5.02045> ,0.141943,<-9.16355,15.69,5.19132> ,0.1296}
sphere{<-9.0463,13.9221,5.02045> ,0.141943}
texture{txttree matrix <0.997808,0.0661787,0,-0.0658731,0.9932,0.095995,0.00635282,-0.0957845,0.995382,-9.0463,13.9221,5.02045> }}
union{cone{<-9.16355,15.69,5.19132> ,0.1296,<-8.22158,18.8531,6.02226> ,0.12096}
sphere{<-9.16355,15.69,5.19132> ,0.1296}
texture{txttree matrix <0.958403,-0.285418,0,0.27678,0.929398,0.244157,-0.0696868,-0.234001,0.969736,-9.16355,15.69,5.19132> }}
union{cone{<-8.22158,18.8531,6.02226> ,0.12096,<-7.68302,21.8948,7.27757> ,0.11232}
sphere{<-8.22158,18.8531,6.02226> ,0.12096}
texture{txttree matrix <0.984684,-0.174349,0,0.161521,0.912237,0.376475,-0.065638,-0.370709,0.926427,-8.22158,18.8531,6.02226> }}
union{cone{<-7.68302,21.8948,7.27757> ,0.11232,<-8.71734,25.1426,7.28351> ,0.10368}
sphere{<-7.68302,21.8948,7.27757> ,0.11232}
texture{txttree matrix <0.952848,0.303449,0,-0.303449,0.952846,0.00174425,0.000529291,-0.00166201,0.999998,-7.68302,21.8948,7.27757> }}
union{cone{<-8.71734,25.1426,7.28351> ,0.10368,<-9.61272,28.2043,6.96274> ,0.09504}
sphere{<-8.71734,25.1426,7.28351> ,0.10368}
texture{txttree matrix <0.959798,0.280692,0,-0.279283,0.954982,-0.100054,-0.0280842,0.0960312,0.994982,-8.71734,25.1426,7.28351> }}
union{cone{<-9.61272,28.2043,6.96274> ,0.09504,<-9.79427,31.5353,6.71549> ,0.0864}
sphere{<-9.61272,28.2043,6.96274> ,0.09504}
texture{txttree matrix <0.998518,0.0544228,0,-0.0542739,0.995787,-0.0739131,-0.00402256,0.0738036,0.997265,-9.61272,28.2043,6.96274> }}
union{cone{<-9.79427,31.5353,6.71549> ,0.0864,<-9.19193,34.8138,6.45341> ,0.07776}
sphere{<-9.79427,31.5353,6.71549> ,0.0864}
texture{txttree matrix <0.983538,-0.180702,0,0.180146,0.980512,-0.078382,0.0141638,0.0770917,0.996923,-9.79427,31.5353,6.71549> }}
union{cone{<-8.9668,7.15773,4.28384> ,0.1296,<-8.47581,10.2112,3.46735> ,0.12096}
sphere{<-8.9668,7.15773,4.28384> ,0.1296}
texture{txttree matrix <0.987317,-0.158761,0,0.153501,0.954609,-0.255263,0.0405257,0.252025,0.966872,-8.9668,7.15773,4.28384> }}
union{cone{<-8.47581,10.2112,3.46735> ,0.12096,<-8.64093,13.5619,4.17278> ,0.11232}
sphere{<-8.47581,10.2112,3.46735> ,0.12096}
texture{txttree matrix <0.998788,0.0492197,0,-0.0481664,0.977413,0.205774,0.0101281,-0.205524,0.9786,-8.47581,10.2112,3.46735> }}
union{cone{<-8.64093,13.5619,4.17278> ,0.11232,<-7.97808,16.8766,4.12761> ,0.10368}
sphere{<-8.64093,13.5619,4.17278> ,0.11232}
texture{txttree matrix <0.980586,-0.19609,0,0.196073,0.980498,-0.0133615,0.00262006,0.0131021,0.999911,-8.64093,13.5619,4.17278> }}
union{cone{<-7.97808,16.8766,4.12761> ,0.10368,<-8.87817,20.1445,3.76772> ,0.09504}
sphere{<-7.97808,16.8766,4.12761> ,0.10368}
texture{txttree matrix <0.9641,0.26554,0,-0.264056,0.958711,-0.10558,-0.0280357,0.10179,0.994411,-7.97808,16.8766,4.12761> }}
union{cone{<-8.87817,20.1445,3.76772> ,0.09504,<-9.69136,23.3187,2.84626> ,0.0864}
sphere{<-8.87817,20.1445,3.76772> ,0.09504}
texture{txttree matrix <0.968714,0.248179,0,-0.238911,0.932541,-0.270718,-0.0671865,0.262248,0.962659,-8.87817,20.1445,3.76772> }}
union{cone{<-9.69136,23.3187,2.84626> ,0.0864,<-9.96533,26.3447,1.72867> ,0.07776}
sphere{<-9.69136,23.3187,2.84626> ,0.0864}
texture{txttree matrix <0.995927,0.0901679,0,-0.0846248,0.934701,-0.345213,-0.0311271,0.343807,0.938524,-9.69136,23.3187,2.84626> }}
union{cone{<-8.89,4.6688,3.18031> ,0.1296,<-9.45856,7.8633,3.64061> ,0.12096}
sphere{<-8.89,4.6688,3.18031> ,0.1296}
texture{txttree matrix <0.984528,0.175229,0,-0.173492,0.974768,0.140456,0.024612,-0.138283,0.990087,-8.89,4.6688,3.18031> }}
union{cone{<-9.45856,7.8633,3.64061> ,0.12096,<-8.60871,10.8881,3.83586> ,0.11232}
sphere{<-9.45856,7.8633,3.64061> ,0.12096}
texture{txttree matrix <0.962724,-0.270487,0,0.269966,0.96087,0.0620236,-0.0167765,-0.0597116,0.998075,-9.45856,7.8633,3.64061> }}
union{cone{<-8.60871,10.8881,3.83586> ,0.11232,<-8.83638,14.055,3.87092> ,0.10368}
sphere{<-8.60871,10.8881,3.83586> ,0.11232}
texture{txttree matrix <0.997426,0.0717058,0,-0.0717014,0.997365,0.0110424,0.000791805,-0.011014,0.999939,-8.60871,10.8881,3.83586> }}
union{cone{<-8.83638,14.055,3.87092> ,0.10368,<-8.27122,16.9751,2.42839> ,0.09504}
sphere{<-8.83638,14.055,3.87092> ,0.10368}
texture{txttree matrix <0.981781,-0.190015,0,0.170968,0.883367,-0.436385,0.0829195,0.428435,0.89976,-8.83638,14.055,3.87092> }}
union{cone{<-8.27122,16.9751,2.42839> ,0.09504,<-7.57024,19.842,1.21788> ,0.0864}
sphere{<-8.27122,16.9751,2.42839> ,0.09504}
texture{txttree matrix <0.971384,-0.237516,0,0.21975,0.898724,-0.379479,0.0901323,0.36862,0.9252,-8.27122,16.9751,2.42839> }}
union{cone{<-7.57024,19.842,1.21788> ,0.0864,<-7.09503,23.0591,0.62754> ,0.07776}
sphere{<-7.57024,19.842,1.21788> ,0.0864}
texture{txttree matrix <0.989266,-0.146127,0,0.143777,0.973358,-0.178612,0.0261,0.176694,0.98392,-7.57024,19.842,1.21788> }}
union{cone{<-8.98854,13.6414,5.03661> ,0.1296,<-10.1622,16.7644,5.08311> ,0.12096}
sphere{<-8.98854,13.6414,5.03661> ,0.1296}
texture{txttree matrix <0.93608,0.351788,0,-0.351754,0.935989,0.0139351,0.0049022,-0.0130443,0.999903,-8.98854,13.6414,5.03661> }}
union{cone{<-10.1622,16.7644,5.08311> ,0.12096,<-12.4805,18.9654,5.8619> ,0.11232}
sphere{<-10.1622,16.7644,5.08311> ,0.12096}
texture{txttree matrix <0.68852,0.725218,0,-0.704609,0.668954,0.236698,0.171658,-0.162971,0.971583,-10.1622,16.7644,5.08311> }}
union{cone{<-12.4805,18.9654,5.8619> ,0.11232,<-13.1404,22.0213,5.94082> ,0.10368}
sphere{<-12.4805,18.9654,5.8619> ,0.11232}
texture{txttree matrix <0.977471,0.211068,0,-0.211001,0.97716,0.0252343,0.00532615,-0.0246658,0.999682,-12.4805,18.9654,5.8619> }}
union{cone{<-13.1404,22.0213,5.94082> ,0.10368,<-15.1477,24.2431,4.78417> ,0.09504}
sphere{<-13.1404,22.0213,5.94082> ,0.10368}
texture{txttree matrix <0.74201,0.670388,0,-0.625352,0.692163,-0.36034,-0.241568,0.267376,0.932821,-13.1404,22.0213,5.94082> }}
union{cone{<-15.1477,24.2431,4.78417> ,0.09504,<-15.9891,27.3983,3.94845> ,0.0864}
sphere{<-15.1477,24.2431,4.78417> ,0.09504}
texture{txttree matrix <0.966233,0.25767,0,-0.249625,0.936065,-0.247931,-0.0638844,0.239559,0.968778,-15.1477,24.2431,4.78417> }}
union{cone{<-15.9891,27.3983,3.94845> ,0.0864,<-17.0682,30.1451,2.73336> ,0.07776}
sphere{<-15.9891,27.3983,3.94845> ,0.0864}
texture{txttree matrix <0.930759,0.365634,0,-0.338098,0.860662,-0.380723,-0.139205,0.354361,0.924689,-15.9891,27.3983,3.94845> }}
union{cone{<-6.45136,2.34231,1.55707> ,0.216,<-7.33101,3.60335,2.32831> ,0.203657}
sphere{<-6.45136,2.34231,1.55707> ,0.216}
texture{txttree matrix <0.820172,0.572117,0,-0.511387,0.733112,0.448363,0.256516,-0.367735,0.893851,-6.45136,2.34231,1.55707> }}
union{cone{<-7.33101,3.60335,2.32831> ,0.203657,<-8.53428,4.88997,2.61604> ,0.191314}
sphere{<-7.33101,3.60335,2.32831> ,0.203657}
texture{txttree matrix <0.73037,0.683052,0,-0.674119,0.720818,0.161198,0.110107,-0.117734,0.986922,-7.33101,3.60335,2.32831> }}
union{cone{<-8.53428,4.88997,2.61604> ,0.191314,<-9.7733,6.02017,2.39755> ,0.178971}
sphere{<-8.53428,4.88997,2.61604> ,0.191314}
texture{txttree matrix <0.673917,0.738807,0,-0.732616,0.66827,-0.129188,-0.0954449,0.0870619,0.99162,-8.53428,4.88997,2.61604> }}
union{cone{<-9.7733,6.02017,2.39755> ,0.178971,<-11.1241,7.09754,2.76357> ,0.166629}
sphere{<-9.7733,6.02017,2.39755> ,0.178971}
texture{txttree matrix <0.623541,0.78179,0,-0.764818,0.610004,0.207242,0.16202,-0.129224,0.97829,-9.7733,6.02017,2.39755> }}
union{cone{<-11.1241,7.09754,2.76357> ,0.166629,<-12.2913,8.35579,2.18371> ,0.154286}
sphere{<-11.1241,7.09754,2.76357> ,0.166629}
texture{txttree matrix <0.733128,0.680091,0,-0.64431,0.694557,-0.320087,-0.217688,0.234665,0.947388,-11.1241,7.09754,2.76357> }}
union{cone{<-12.2913,8.35579,2.18371> ,0.154286,<-13.5104,9.43977,1.55451> ,0.141943}
sphere{<-12.2913,8.35579,2.18371> ,0.154286}
texture{txttree matrix <0.664487,0.7473,0,-0.697234,0.619969,-0.359865,-0.268927,0.239126,0.933004,-12.2913,8.35579,2.18371> }}
union{cone{<-13.5104,9.43977,1.55451> ,0.141943,<-14.1653,10.8879,1.02373> ,0.1296}
sphere{<-13.5104,9.43977,1.55451> ,0.141943}
texture{txttree matrix <0.911164,0.412045,0,-0.390825,0.86424,-0.316772,-0.130524,0.288631,0.948502,-13.5104,9.43977,1.55451> }}
union{cone{<-14.1653,10.8879,1.02373> ,0.1296,<-16.1947,13.4125,0.464809> ,0.12096}
sphere{<-14.1653,10.8879,1.02373> ,0.1296}
texture{txttree matrix <0.779394,0.626534,0,-0.61741,0.768045,-0.170033,-0.106531,0.132523,0.985438,-14.1653,10.8879,1.02373> }}
union{cone{<-16.1947,13.4125,0.464809> ,0.12096,<-16.7414,16.5426,0.905577> ,0.11232}
sphere{<-16.1947,13.4125,0.464809> ,0.12096}
texture{txttree matrix <0.98509,0.172038,0,-0.170406,0.975747,0.1374,0.023638,-0.135352,0.990516,-16.1947,13.4125,0.464809> }}
union{cone{<-16.7414,16.5426,0.905577> ,0.11232,<-17.8929,19.7618,0.791294> ,0.10368}
sphere{<-16.7414,16.5426,0.905577> ,0.11232}
texture{txttree matrix <0.941571,0.336815,0,-0.336627,0.941045,-0.0334081,-0.0112523,0.0314561,0.999442,-16.7414,16.5426,0.905577> }}
union{cone{<-17.8929,19.7618,0.791294> ,0.10368,<-18.9783,22.8311,0.50301> ,0.09504}
sphere{<-17.8929,19.7618,0.791294> ,0.10368}
texture{txttree matrix <0.942787,0.333396,0,-0.332097,0.939112,-0.0882068,-0.0294078,0.0831602,0.996102,-17.8929,19.7618,0.791294> }}
union{cone{<-18.9783,22.8311,0.50301> ,0.09504,<-19.3506,26.0287,-0.35259> ,0.0864}
sphere{<-18.9783,22.8311,0.50301> ,0.09504}
texture{txttree matrix <0.99329,0.11565,0,-0.11177,0.959963,-0.256863,-0.0297063,0.255139,0.966448,-18.9783,22.8311,0.50301> }}
union{cone{<-19.3506,26.0287,-0.35259> ,0.0864,<-19.4437,29.1319,-1.5459> ,0.07776}
sphere{<-19.3506,26.0287,-0.35259> ,0.0864}
texture{txttree matrix <0.99955,0.0299911,0,-0.0279945,0.933006,-0.358771,-0.01076,0.35861,0.933426,-19.3506,26.0287,-0.35259> }}
union{cone{<-9.14938,5.45105,2.50757> ,0.1296,<-11.3672,7.73516,2.99396> ,0.12096}
sphere{<-9.14938,5.45105,2.50757> ,0.1296}
texture{txttree matrix <0.717447,0.696613,0,-0.688623,0.709218,0.151024,0.105205,-0.108352,0.98853,-9.14938,5.45105,2.50757> }}
union{cone{<-11.3672,7.73516,2.99396> ,0.12096,<-13.4663,10.0805,2.71205> ,0.11232}
sphere{<-11.3672,7.73516,2.99396> ,0.12096}
texture{txttree matrix <0.745144,0.666903,0,-0.664244,0.742174,-0.0892065,-0.0594921,0.0664717,0.996013,-11.3672,7.73516,2.99396> }}
union{cone{<-13.4663,10.0805,2.71205> ,0.11232,<-15.1311,12.7576,2.3299> ,0.10368}
sphere{<-13.4663,10.0805,2.71205> ,0.11232}
texture{txttree matrix <0.849185,0.528096,0,-0.524258,0.843013,-0.120342,-0.0635521,0.102193,0.992732,-13.4663,10.0805,2.71205> }}
union{cone{<-15.1311,12.7576,2.3299> ,0.10368,<-15.4653,15.8812,1.81994> ,0.09504}
sphere{<-15.1311,12.7576,2.3299> ,0.10368}
texture{txttree matrix <0.994325,0.106381,0,-0.105007,0.981478,-0.160232,-0.0170457,0.159322,0.987079,-15.1311,12.7576,2.3299> }}
union{cone{<-15.4653,15.8812,1.81994> ,0.09504,<-16.4405,18.8648,1.21964> ,0.0864}
sphere{<-15.4653,15.8812,1.81994> ,0.09504}
texture{txttree matrix <0.950512,0.310687,0,-0.305157,0.933592,-0.187843,-0.0583605,0.178547,0.982199,-15.4653,15.8812,1.81994> }}
union{cone{<-16.4405,18.8648,1.21964> ,0.0864,<-17.9324,21.5215,-0.0321843> ,0.07776}
sphere{<-16.4405,18.8648,1.21964> ,0.0864}
texture{txttree matrix <0.871925,0.48964,0,-0.452906,0.806511,-0.38002,-0.186073,0.331349,0.924978,-16.4405,18.8648,1.21964> }}
union{cone{<-14.0663,10.669,1.10397> ,0.1296,<-15.4809,12.5857,-1.37596> ,0.12096}
sphere{<-14.0663,10.669,1.10397> ,0.1296}
texture{txttree matrix <0.804597,0.593821,0,-0.411378,0.557397,-0.721163,-0.428242,0.580246,0.692765,-14.0663,10.669,1.10397> }}
union{cone{<-15.4809,12.5857,-1.37596> ,0.12096,<-16.5847,15.4899,-2.45467> ,0.11232}
sphere{<-15.4809,12.5857,-1.37596> ,0.12096}
texture{txttree matrix <0.934766,0.355264,0,-0.33561,0.883055,-0.327994,-0.116524,0.306598,0.94468,-15.4809,12.5857,-1.37596> }}
union{cone{<-16.5847,15.4899,-2.45467> ,0.11232,<-15.9827,18.3361,-4.19152> ,0.10368}
sphere{<-16.5847,15.4899,-2.45467> ,0.11232}
texture{txttree matrix <0.978357,-0.206924,0,0.177668,0.84003,-0.512624,0.106074,0.501529,0.858613,-16.5847,15.4899,-2.45467> }}
union{cone{<-15.9827,18.3361,-4.19152> ,0.10368,<-16.5709,20.5708,-6.35591> ,0.09504}
sphere{<-15.9827,18.3361,-4.19152> ,0.10368}
texture{txttree matrix <0.967066,0.254524,0,-0.185767,0.705821,-0.683599,-0.173993,0.661085,0.729858,-15.9827,18.3361,-4.19152> }}
union{cone{<-16.5709,20.5708,-6.35591> ,0.09504,<-17.4624,22.7491,-8.77288> ,0.0864}
sphere{<-16.5709,20.5708,-6.35591> ,0.09504}
texture{txttree matrix <0.925482,0.378791,0,-0.264268,0.645672,-0.716429,-0.271377,0.663043,0.69766,-16.5709,20.5708,-6.35591> }}
union{cone{<-17.4624,22.7491,-8.77288> ,0.0864,<-17.3062,25.6524,-10.368> ,0.07776}
sphere{<-17.4624,22.7491,-8.77288> ,0.0864}
texture{txttree matrix <0.998557,-0.0537086,0,0.0470874,0.875454,-0.481001,0.0258339,0.480307,0.87672,-17.4624,22.7491,-8.77288> }}
union{cone{<-8.10028,4.42592,2.51226> ,0.1296,<-11.0555,5.54718,2.20537> ,0.12096}
sphere{<-8.10028,4.42592,2.51226> ,0.1296}
texture{txttree matrix <0.354738,0.934966,0,-0.93059,0.353078,-0.0966377,-0.090353,0.0342811,0.99532,-8.10028,4.42592,2.51226> }}
union{cone{<-11.0555,5.54718,2.20537> ,0.12096,<-13.9979,7.1754,2.35146> ,0.11232}
sphere{<-11.0555,5.54718,2.20537> ,0.12096}
texture{txttree matrix <0.484187,0.874965,0,-0.87414,0.48373,0.0434041,0.037977,-0.0210157,0.999058,-11.0555,5.54718,2.20537> }}
union{cone{<-13.9979,7.1754,2.35146> ,0.11232,<-16.8461,8.53656,1.71539> ,0.10368}
sphere{<-13.9979,7.1754,2.35146> ,0.11232}
texture{txttree matrix <0.431189,0.902262,0,-0.884485,0.422694,-0.197525,-0.17822,0.0851708,0.980298,-13.9979,7.1754,2.35146> }}
union{cone{<-16.8461,8.53656,1.71539> ,0.10368,<-19.6116,10.3735,1.10997> ,0.09504}
sphere{<-16.8461,8.53656,1.71539> ,0.10368}
texture{txttree matrix <0.5533,0.832982,0,-0.819468,0.544323,-0.1794,-0.149437,0.0992622,0.983776,-16.8461,8.53656,1.71539> }}
union{cone{<-19.6116,10.3735,1.10997> ,0.09504,<-21.4663,12.7244,0.0859765> ,0.0864}
sphere{<-19.6116,10.3735,1.10997> ,0.09504}
texture{txttree matrix <0.785093,0.619378,0,-0.586059,0.742859,-0.323566,-0.20041,0.25403,0.946206,-19.6116,10.3735,1.10997> }}
union{cone{<-21.4663,12.7244,0.0859765> ,0.0864,<-23.2319,15.1995,-0.801636> ,0.07776}
sphere{<-21.4663,12.7244,0.0859765> ,0.0864}
texture{txttree matrix <0.814078,0.580756,0,-0.557484,0.781456,-0.280247,-0.162755,0.228143,0.959928,-21.4663,12.7244,0.0859765> }}
union{cone{<-7.82863,2.95384,2.4634> ,0.216,<-9.28578,3.34377,1.58126> ,0.203657}
sphere{<-7.82863,2.95384,2.4634> ,0.216}
texture{txttree matrix <0.258502,0.966011,0,-0.833883,0.223144,-0.504823,-0.487664,0.130497,0.863223,-7.82863,2.95384,2.4634> }}
union{cone{<-9.28578,3.34377,1.58126> ,0.203657,<-10.8857,3.78422,1.32172> ,0.191314}
sphere{<-9.28578,3.34377,1.58126> ,0.203657}
texture{txttree matrix <0.265425,0.964131,0,-0.952551,0.262237,-0.154528,-0.148985,0.0410156,0.987988,-9.28578,3.34377,1.58126> }}
union{cone{<-10.8857,3.78422,1.32172> ,0.191314,<-11.9742,4.54448,0.295639> ,0.178971}
sphere{<-10.8857,3.78422,1.32172> ,0.191314}
texture{txttree matrix <0.572592,0.81984,0,-0.648708,0.45307,-0.611478,-0.501315,0.350128,0.791261,-10.8857,3.78422,1.32172> }}
union{cone{<-11.9742,4.54448,0.295639> ,0.178971,<-13.0552,4.92971,-0.97722> ,0.166629}
sphere{<-11.9742,4.54448,0.295639> ,0.178971}
texture{txttree matrix <0.335693,0.941972,0,-0.630744,0.22478,-0.742722,-0.699623,0.249326,0.6696,-11.9742,4.54448,0.295639> }}
union{cone{<-13.0552,4.92971,-0.97722> ,0.166629,<-13.9261,6.09261,-1.85539> ,0.154286}
sphere{<-13.0552,4.92971,-0.97722> ,0.166629}
texture{txttree matrix <0.800426,0.599432,0,-0.512999,0.685012,-0.517292,-0.310081,0.414054,0.855809,-13.0552,4.92971,-0.97722> }}
union{cone{<-13.9261,6.09261,-1.85539> ,0.154286,<-14.8072,6.69024,-3.19906> ,0.141943}
sphere{<-13.9261,6.09261,-1.85539> ,0.154286}
texture{txttree matrix <0.5613,0.827612,0,-0.513996,0.348601,-0.783764,-0.648653,0.439927,0.621059,-13.9261,6.09261,-1.85539> }}
union{cone{<-14.8072,6.69024,-3.19906> ,0.141943,<-15.9632,7.23079,-4.38532> ,0.1296}
sphere{<-14.8072,6.69024,-3.19906> ,0.141943}
texture{txttree matrix <0.423593,0.905853,0,-0.663463,0.310247,-0.680855,-0.616754,0.288405,0.732419,-14.8072,6.69024,-3.19906> }}
union{cone{<-15.9632,7.23079,-4.38532> ,0.1296,<-19.0062,7.59973,-5.34725> ,0.12096}
sphere{<-15.9632,7.23079,-4.38532> ,0.1296}
texture{txttree matrix <0.120363,0.99273,0,-0.947185,0.114841,-0.299419,-0.297242,0.036039,0.954122,-15.9632,7.23079,-4.38532> }}
union{cone{<-19.0062,7.59973,-5.34725> ,0.12096,<-21.868,9.02256,-6.56889> ,0.11232}
sphere{<-19.0062,7.59973,-5.34725> ,0.12096}
texture{txttree matrix <0.445188,0.895437,0,-0.836417,0.415845,-0.357043,-0.31971,0.158951,0.934088,-19.0062,7.59973,-5.34725> }}
union{cone{<-21.868,9.02256,-6.56889> ,0.11232,<-24.3651,11.0486,-7.47783> ,0.10368}
sphere{<-21.868,9.02256,-6.56889> ,0.11232}
texture{txttree matrix <0.630059,0.776547,0,-0.747268,0.606303,-0.272005,-0.211225,0.171379,0.962296,-21.868,9.02256,-6.56889> }}
union{cone{<-24.3651,11.0486,-7.47783> ,0.10368,<-26.6822,12.3797,-9.35598> ,0.09504}
sphere{<-24.3651,11.0486,-7.47783> ,0.10368}
texture{txttree matrix <0.498119,0.867108,0,-0.709413,0.40753,-0.575024,-0.498609,0.286431,0.818136,-24.3651,11.0486,-7.47783> }}
union{cone{<-26.6822,12.3797,-9.35598> ,0.09504,<-28.2761,14.4655,-11.0363> ,0.0864}
sphere{<-26.6822,12.3797,-9.35598> ,0.09504}
texture{txttree matrix <0.794565,0.607179,0,-0.511385,0.669208,-0.539115,-0.327339,0.428363,0.842232,-26.6822,12.3797,-9.35598> }}
union{cone{<-28.2761,14.4655,-11.0363> ,0.0864,<-30.1097,16.8525,-12.6776> ,0.07776}
sphere{<-28.2761,14.4655,-11.0363> ,0.0864}
texture{txttree matrix <0.793029,0.609184,0,-0.534839,0.696248,-0.478733,-0.291636,0.379649,0.877961,-28.2761,14.4655,-11.0363> }}
union{cone{<-8.38898,3.10379,2.12417> ,0.1296,<-11.4901,3.64129,1.34327> ,0.12096}
sphere{<-8.38898,3.10379,2.12417> ,0.1296}
texture{txttree matrix <0.170779,0.985309,0,-0.956314,0.165753,-0.240811,-0.237274,0.0411255,0.970572,-8.38898,3.10379,2.12417> }}
union{cone{<-11.4901,3.64129,1.34327> ,0.12096,<-13.0956,5.10156,-1.09933> ,0.11232}
sphere{<-11.4901,3.64129,1.34327> ,0.12096}
texture{txttree matrix <0.67287,0.739761,0,-0.491345,0.446916,-0.74756,-0.553016,0.503011,0.664194,-11.4901,3.64129,1.34327> }}
union{cone{<-13.0956,5.10156,-1.09933> ,0.11232,<-15.3288,7.12507,-2.11545> ,0.10368}
sphere{<-13.0956,5.10156,-1.09933> ,0.11232}
texture{txttree matrix <0.671457,0.741044,0,-0.702202,0.636263,-0.319502,-0.236765,0.214532,0.947586,-13.0956,5.10156,-1.09933> }}
union{cone{<-15.3288,7.12507,-2.11545> ,0.10368,<-17.3706,8.36321,-4.14631> ,0.09504}
sphere{<-15.3288,7.12507,-2.11545> ,0.10368}
texture{txttree matrix <0.518502,0.855076,0,-0.651363,0.394974,-0.64786,-0.55397,0.335916,0.76176,-15.3288,7.12507,-2.11545> }}
union{cone{<-17.3706,8.36321,-4.14631> ,0.09504,<-18.319,10.7714,-6.05035> ,0.0864}
sphere{<-17.3706,8.36321,-4.14631> ,0.09504}
texture{txttree matrix <0.930447,0.366427,0,-0.29516,0.749482,-0.592586,-0.21714,0.551369,0.805507,-17.3706,8.36321,-4.14631> }}
union{cone{<-18.319,10.7714,-6.05035> ,0.0864,<-19.9336,13.0833,-7.98275> ,0.07776}
sphere{<-18.319,10.7714,-6.05035> ,0.0864}
texture{txttree matrix <0.819863,0.57256,0,-0.472303,0.676304,-0.565281,-0.323657,0.463453,0.824898,-18.319,10.7714,-6.05035> }}
union{cone{<-14.1811,6.26558,-2.2443> ,0.1296,<-16.5096,7.06165,-4.25461> ,0.12096}
sphere{<-14.1811,6.26558,-2.2443> ,0.1296}
texture{txttree matrix <0.323492,0.946231,0,-0.732796,0.250524,-0.632651,-0.598634,0.204658,0.774437,-14.1811,6.26558,-2.2443> }}
union{cone{<-16.5096,7.06165,-4.25461> ,0.12096,<-18.3404,7.3034,-6.94915> ,0.11232}
sphere{<-16.5096,7.06165,-4.25461> ,0.12096}
texture{txttree matrix <0.130913,0.991394,0,-0.560443,0.0740062,-0.82488,-0.81778,0.107987,0.565309,-16.5096,7.06165,-4.25461> }}
union{cone{<-18.3404,7.3034,-6.94915> ,0.11232,<-20.169,8.55621,-9.17725> ,0.10368}
sphere{<-18.3404,7.3034,-6.94915> ,0.11232}
texture{txttree matrix <0.56518,0.824968,0,-0.581837,0.398613,-0.708924,-0.58484,0.400669,0.705285,-18.3404,7.3034,-6.94915> }}
union{cone{<-20.169,8.55621,-9.17725> ,0.10368,<-21.8685,9.83753,-11.5192> ,0.09504}
sphere{<-20.169,8.55621,-9.17725> ,0.10368}
texture{txttree matrix <0.602018,0.798482,0,-0.537019,0.404887,-0.740052,-0.590918,0.445525,0.67255,-20.169,8.55621,-9.17725> }}
union{cone{<-21.8685,9.83753,-11.5192> ,0.09504,<-22.858,10.4117,-14.7577> ,0.0864}
sphere{<-21.8685,9.83753,-11.5192> ,0.09504}
texture{txttree matrix <0.501923,0.864912,0,-0.288089,0.167183,-0.942897,-0.815523,0.473262,0.333084,-21.8685,9.83753,-11.5192> }}
union{cone{<-22.858,10.4117,-14.7577> ,0.0864,<-23.4899,12.0384,-17.4928> ,0.07776}
sphere{<-22.858,10.4117,-14.7577> ,0.0864}
texture{txttree matrix <0.932133,0.362115,0,-0.194774,0.501376,-0.843022,-0.305271,0.785809,0.53788,-22.858,10.4117,-14.7577> }}
union{cone{<-6.56285,2.38031,1.65686> ,0.216,<-7.65596,2.43965,2.96968> ,0.203657}
sphere{<-6.56285,2.38031,1.65686> ,0.216}
texture{txttree matrix <0.0542074,0.99853,0,-0.639484,0.0347158,0.768021,0.766891,-0.0416324,0.640425,-6.56285,2.38031,1.65686> }}
union{cone{<-7.65596,2.43965,2.96968> ,0.203657,<-9.09387,2.01573,4.01935> ,0.191314}
sphere{<-7.65596,2.43965,2.96968> ,0.203657}
texture{txttree matrix <-0.282784,0.959184,0,-0.785718,-0.231643,0.573576,0.550164,0.162198,0.819153,-7.65596,2.43965,2.96968> }}
union{cone{<-9.09387,2.01573,4.01935> ,0.191314,<-10.4209,1.06819,4.72765> ,0.178971}
sphere{<-9.09387,2.01573,4.01935> ,0.191314}
texture{txttree matrix <-0.581101,0.813831,0,-0.74645,-0.532989,0.398415,0.324243,0.23152,0.917205,-9.09387,2.01573,4.01935> }}
union{cone{<-10.4209,1.06819,4.72765> ,0.178971,<-12.1892,1.03476,5.00649> ,0.166629}
sphere{<-10.4209,1.06819,4.72765> ,0.178971}
texture{txttree matrix <-0.0189032,0.999821,0,-0.987622,-0.0186726,0.155738,0.15571,0.00294395,0.987798,-10.4209,1.06819,4.72765> }}
union{cone{<-12.1892,1.03476,5.00649> ,0.166629,<-13.3801,1.05011,6.1838> ,0.154286}
sphere{<-12.1892,1.03476,5.00649> ,0.166629}
texture{txttree matrix <0.0128895,0.999917,0,-0.711132,0.0091669,0.702999,0.70294,-0.0090613,0.711191,-12.1892,1.03476,5.00649> }}
union{cone{<-13.3801,1.05011,6.1838> ,0.154286,<-15.0505,1.24629,6.16107> ,0.141943}
sphere{<-13.3801,1.05011,6.1838> ,0.154286}
texture{txttree matrix <0.116645,0.993174,0,-0.993083,0.116634,-0.0135141,-0.0134218,0.00157635,0.999909,-13.3801,1.05011,6.1838> }}
union{cone{<-15.0505,1.24629,6.16107> ,0.141943,<-16.5696,2.09777,6.7486> ,0.1296}
sphere{<-15.0505,1.24629,6.16107> ,0.141943}
texture{txttree matrix <0.488939,0.872318,0,-0.826546,0.463284,0.31967,0.278854,-0.156299,0.947529,-15.0505,1.24629,6.16107> }}
union{cone{<-16.5696,2.09777,6.7486> ,0.1296,<-18.4302,3.06217,9.08107> ,0.12096}
sphere{<-16.5696,2.09777,6.7486> ,0.1296}
texture{txttree matrix <0.460174,0.887829,0,-0.593381,0.307558,0.743846,0.660408,-0.342299,0.668351,-16.5696,2.09777,6.7486> }}
union{cone{<-18.4302,3.06217,9.08107> ,0.12096,<-20.5876,5.15478,10.7285> ,0.11232}
sphere{<-18.4302,3.06217,9.08107> ,0.12096}
texture{txttree matrix <0.696254,0.717795,0,-0.629436,0.610547,0.48067,0.345023,-0.334669,0.876902,-18.4302,3.06217,9.08107> }}
union{cone{<-20.5876,5.15478,10.7285> ,0.11232,<-23.4398,6.26399,11.8879> ,0.10368}
sphere{<-20.5876,5.15478,10.7285> ,0.11232}
texture{txttree matrix <0.362456,0.932001,0,-0.871554,0.338948,0.354272,0.330182,-0.128408,0.935142,-20.5876,5.15478,10.7285> }}
union{cone{<-23.4398,6.26399,11.8879> ,0.10368,<-25.5147,8.51443,12.7882> ,0.09504}
sphere{<-23.4398,6.26399,11.8879> ,0.10368}
texture{txttree matrix <0.735191,0.67786,0,-0.650316,0.705318,0.282162,0.191267,-0.207443,0.959367,-23.4398,6.26399,11.8879> }}
union{cone{<-25.5147,8.51443,12.7882> ,0.09504,<-27.4928,11.014,13.1784> ,0.0864}
sphere{<-25.5147,8.51443,12.7882> ,0.09504}
texture{txttree matrix <0.784157,0.620562,0,-0.615963,0.778346,0.121516,0.075408,-0.0952875,0.99259,-25.5147,8.51443,12.7882> }}
union{cone{<-27.4928,11.014,13.1784> ,0.0864,<-28.648,13.9213,12.656> ,0.07776}
sphere{<-27.4928,11.014,13.1784> ,0.0864}
texture{txttree matrix <0.92933,0.369251,0,-0.364208,0.916637,-0.164707,-0.0608181,0.153067,0.986343,-27.4928,11.014,13.1784> }}
union{cone{<-12.507,1.03886,5.32071> ,0.1296,<-14.962,0.705754,7.47162> ,0.12096}
sphere{<-12.507,1.03886,5.32071> ,0.1296}
texture{txttree matrix <-0.134455,0.99092,0,-0.748259,-0.101529,0.655591,0.649638,0.0881479,0.755116,-12.507,1.03886,5.32071> }}
union{cone{<-14.962,0.705754,7.47162> ,0.12096,<-16.0634,2.17374,10.3361> ,0.11232}
sphere{<-14.962,0.705754,7.47162> ,0.12096}
texture{txttree matrix <0.799899,0.600135,0,-0.323747,0.43151,0.842014,0.505322,-0.673526,0.539456,-14.962,0.705754,7.47162> }}
union{cone{<-16.0634,2.17374,10.3361> ,0.11232,<-18.7017,2.99085,12.2204> ,0.10368}
sphere{<-16.0634,2.17374,10.3361> ,0.11232}
texture{txttree matrix <0.295842,0.955237,0,-0.789091,0.244386,0.563569,0.538342,-0.166728,0.826069,-16.0634,2.17374,10.3361> }}
union{cone{<-18.7017,2.99085,12.2204> ,0.10368,<-21.6654,4.35958,12.8997> ,0.09504}
sphere{<-18.7017,2.99085,12.2204> ,0.10368}
texture{txttree matrix <0.419272,0.907861,0,-0.888823,0.41048,0.203716,0.184946,-0.0854125,0.97903,-18.7017,2.99085,12.2204> }}
union{cone{<-21.6654,4.35958,12.8997> ,0.09504,<-23.7904,6.8774,12.8701> ,0.0864}
sphere{<-21.6654,4.35958,12.8997> ,0.09504}
texture{txttree matrix <0.764204,0.644974,0,-0.644948,0.764174,-0.00899799,-0.00580347,0.0068763,0.99996,-21.6654,4.35958,12.8997> }}
union{cone{<-23.7904,6.8774,12.8701> ,0.0864,<-25.6773,9.02028,14.4742> ,0.07776}
sphere{<-23.7904,6.8774,12.8701> ,0.0864}
texture{txttree matrix <0.750512,0.660857,0,-0.576152,0.654316,0.489815,0.323697,-0.367612,0.871826,-23.7904,6.8774,12.8701> }}
union{cone{<-11.6233,1.04546,4.91725> ,0.1296,<-14.5475,2.08351,5.71368> ,0.12096}
sphere{<-11.6233,1.04546,4.91725> ,0.1296}
texture{txttree matrix <0.334525,0.942387,0,-0.912801,0.324023,0.248604,0.234281,-0.0831642,0.968605,-11.6233,1.04546,4.91725> }}
union{cone{<-14.5475,2.08351,5.71368> ,0.12096,<-17.3333,3.00222,4.61905> ,0.11232}
sphere{<-14.5475,2.08351,5.71368> ,0.12096}
texture{txttree matrix <0.313194,0.949689,0,-0.889758,0.29343,-0.349614,-0.332025,0.109497,0.936894,-14.5475,2.08351,5.71368> }}
union{cone{<-17.3333,3.00222,4.61905> ,0.11232,<-20.4023,3.51515,4.31364> ,0.10368}
sphere{<-17.3333,3.00222,4.61905> ,0.11232}
texture{txttree matrix <0.164847,0.986319,0,-0.981602,0.164058,-0.0976855,-0.0963491,0.0161031,0.995217,-17.3333,3.00222,4.61905> }}
union{cone{<-20.4023,3.51515,4.31364> ,0.10368,<-22.5734,4.89296,2.24343> ,0.09504}
sphere{<-20.4023,3.51515,4.31364> ,0.10368}
texture{txttree matrix <0.535812,0.844337,0,-0.657684,0.417363,-0.627105,-0.529488,0.336011,0.778935,-20.4023,3.51515,4.31364> }}
union{cone{<-22.5734,4.89296,2.24343> ,0.09504,<-25.135,5.83762,0.247018> ,0.0864}
sphere{<-22.5734,4.89296,2.24343> ,0.09504}
texture{txttree matrix <0.346005,0.938233,0,-0.757355,0.2793,-0.590258,-0.553799,0.204232,0.807215,-22.5734,4.89296,2.24343> }}
union{cone{<-25.135,5.83762,0.247018> ,0.0864,<-27.3875,6.94111,-1.89539> ,0.07776}
sphere{<-25.135,5.83762,0.247018> ,0.0864}
texture{txttree matrix <0.439932,0.898031,0,-0.682854,0.33452,-0.649466,-0.583241,0.285721,0.76039,-25.135,5.83762,0.247018> }}
union{cone{<-10.9422,1.05834,4.80986> ,0.1296,<-14.0575,0.5,5.46557> ,0.12096}
sphere{<-10.9422,1.05834,4.80986> ,0.1296}
texture{txttree matrix <-0.176416,0.984316,0,-0.963847,-0.172748,0.202874,0.199692,0.0357903,0.979205,-10.9422,1.05834,4.80986> }}
union{cone{<-14.0575,0.5,5.46557> ,0.12096,<-17.1312,1.01966,4.94236> ,0.11232}
sphere{<-14.0575,0.5,5.46557> ,0.12096}
texture{txttree matrix <0.166701,0.986008,0,-0.972406,0.164401,-0.165524,-0.163208,0.027593,0.986206,-14.0575,0.5,5.46557> }}
union{cone{<-17.1312,1.01966,4.94236> ,0.11232,<-19.7628,2.03706,3.21072> ,0.10368}
sphere{<-17.1312,1.01966,4.94236> ,0.11232}
texture{txttree matrix <0.360594,0.932723,0,-0.794944,0.307329,-0.523081,-0.487889,0.18862,0.852283,-17.1312,1.01966,4.94236> }}
union{cone{<-19.7628,2.03706,3.21072> ,0.10368,<-22.3098,2.6043,1.15302> ,0.09504}
sphere{<-19.7628,2.03706,3.21072> ,0.10368}
texture{txttree matrix <0.217385,0.976086,0,-0.766444,0.170696,-0.619215,-0.604407,0.134608,0.785222,-19.7628,2.03706,3.21072> }}
union{cone{<-22.3098,2.6043,1.15302> ,0.09504,<-25.0031,3.35577,-0.369119> ,0.0864}
sphere{<-22.3098,2.6043,1.15302> ,0.09504}
texture{txttree matrix <0.268751,0.96321,0,-0.845985,0.236044,-0.478114,-0.460524,0.128494,0.878298,-22.3098,2.6043,1.15302> }}
union{cone{<-25.0031,3.35577,-0.369119> ,0.0864,<-27.589,4.31333,-2.07829> ,0.07776}
sphere{<-25.0031,3.35577,-0.369119> ,0.0864}
texture{txttree matrix <0.347252,0.937772,0,-0.797079,0.295154,-0.526829,-0.494045,0.182942,0.849971,-25.0031,3.35577,-0.369119> }}
union{cone{<-8.24592,2.26572,3.40035> ,0.1296,<-10.6241,0.5,4.60615> ,0.12096}
sphere{<-8.24592,2.26572,3.40035> ,0.1296}
texture{txttree matrix <-0.596118,0.802897,0,-0.743641,-0.552123,0.37704,0.302724,0.224761,0.926197,-8.24592,2.26572,3.40035> }}
union{cone{<-10.6241,0.5,4.60615> ,0.12096,<-11.8802,0.622904,5.83946> ,0.11232}
sphere{<-10.6241,0.5,4.60615> ,0.12096}
texture{txttree matrix <0.0973859,0.995247,0,-0.711797,0.0696501,0.698923,0.695601,-0.0680652,0.715197,-10.6241,0.5,4.60615> }}
union{cone{<-11.8802,0.622904,5.83946> ,0.11232,<-13.4212,0.822904,8.04086> ,0.10368}
sphere{<-11.8802,0.622904,5.83946> ,0.11232}
texture{txttree matrix <0.128703,0.991683,0,-0.571897,0.0742222,0.816961,0.810166,-0.105145,0.576693,-11.8802,0.622904,5.83946> }}
union{cone{<-13.4212,0.822904,8.04086> ,0.10368,<-14.5908,0.732956,9.94869> ,0.09504}
sphere{<-13.4212,0.822904,8.04086> ,0.10368}
texture{txttree matrix <-0.0766816,0.997056,0,-0.522218,-0.0401628,0.851866,0.849357,0.0653224,0.52376,-13.4212,0.822904,8.04086> }}
union{cone{<-14.5908,0.732956,9.94869> ,0.09504,<-15.9949,0.504094,11.7142> ,0.0864}
sphere{<-14.5908,0.732956,9.94869> ,0.09504}
texture{txttree matrix <-0.160873,0.986975,0,-0.619257,-0.100936,0.778674,0.768532,0.125267,0.627429,-14.5908,0.732956,9.94869> }}
union{cone{<-15.9949,0.504094,11.7142> ,0.0864,<-18.6749,0.597635,12.3048> ,0.07776}
sphere{<-15.9949,0.504094,11.7142> ,0.0864}
texture{txttree matrix <0.0348813,0.999391,0,-0.976003,0.034065,0.215076,0.214945,-0.00750214,0.976597,-15.9949,0.504094,11.7142> }}
union{cone{<-3.46953,1.68811,0.316522> ,0.36,<-3.96641,2.36581,0.758253> ,0.342}
sphere{<-3.46953,1.68811,0.316522> ,0.36}
texture{txttree matrix <0.806459,0.59129,0,-0.523384,0.713843,0.465293,0.275123,-0.37524,0.885157,-3.46953,1.68811,0.316522> }}
union{cone{<-3.96641,2.36581,0.758253> ,0.342,<-4.47356,3.14961,0.970643> ,0.324}
sphere{<-3.96641,2.36581,0.758253> ,0.342}
texture{txttree matrix <0.83958,0.543236,0,-0.529701,0.818661,0.221835,0.120508,-0.186248,0.975084,-3.96641,2.36581,0.758253> }}
union{cone{<-4.47356,3.14961,0.970643> ,0.324,<-4.99675,3.91375,0.923741> ,0.306}
sphere{<-4.47356,3.14961,0.970643> ,0.324}
texture{txttree matrix <0.825127,0.564947,0,-0.564224,0.824071,-0.0505802,-0.0285751,0.0417351,0.99872,-4.47356,3.14961,0.970643> }}
union{cone{<-4.99675,3.91375,0.923741> ,0.306,<-5.21991,4.80247,0.932448> ,0.288}
sphere{<-4.99675,3.91375,0.923741> ,0.306}
texture{txttree matrix <0.969889,0.243549,0,-0.243538,0.969845,0.00950153,0.00231409,-0.00921543,0.999955,-4.99675,3.91375,0.923741> }}
union{cone{<-5.21991,4.80247,0.932448> ,0.288,<-5.5289,5.72117,0.761999> ,0.27}
sphere{<-5.21991,4.80247,0.932448> ,0.288}
texture{txttree matrix <0.947828,0.318781,0,-0.313963,0.933504,-0.173195,-0.0552112,0.164159,0.984888,-5.21991,4.80247,0.932448> }}
union{cone{<-5.5289,5.72117,0.761999> ,0.27,<-6.05693,6.44387,0.325716> ,0.252}
sphere{<-5.5289,5.72117,0.761999> ,0.27}
texture{txttree matrix <0.80744,0.58995,0,-0.530305,0.725806,-0.438159,-0.258492,0.353787,0.898898,-5.5289,5.72117,0.761999> }}
union{cone{<-6.05693,6.44387,0.325716> ,0.252,<-6.58832,7.29307,0.261848> ,0.234}
sphere{<-6.05693,6.44387,0.325716> ,0.252}
texture{txttree matrix <0.847713,0.530456,0,-0.529381,0.845995,-0.0636273,-0.0337514,0.0539377,0.997974,-6.05693,6.44387,0.325716> }}
union{cone{<-6.58832,7.29307,0.261848> ,0.234,<-6.77931,8.2251,0.0791239> ,0.216}
sphere{<-6.58832,7.29307,0.261848> ,0.234}
texture{txttree matrix <0.979643,0.200748,0,-0.197145,0.96206,-0.188612,-0.0378636,0.184773,0.982052,-6.58832,7.29307,0.261848> }}
union{cone{<-6.77931,8.2251,0.0791239> ,0.216,<-7.30901,9.24208,1.33108> ,0.203657}
sphere{<-6.77931,8.2251,0.0791239> ,0.216}
texture{txttree matrix <0.886909,0.461945,0,-0.312005,0.599032,0.737437,0.340655,-0.654039,0.675416,-6.77931,8.2251,0.0791239> }}
union{cone{<-7.30901,9.24208,1.33108> ,0.203657,<-7.36614,10.7654,2.24107> ,0.191314}
sphere{<-7.30901,9.24208,1.33108> ,0.203657}
texture{txttree matrix <0.999297,0.037482,0,-0.0321836,0.85804,0.512574,0.0192123,-0.512214,0.858643,-7.30901,9.24208,1.33108> }}
union{cone{<-7.36614,10.7654,2.24107> ,0.191314,<-7.61068,12.2547,3.22013> ,0.178971}
sphere{<-7.36614,10.7654,2.24107> ,0.191314}
texture{txttree matrix <0.986787,0.162024,0,-0.135928,0.827853,0.544226,0.0881776,-0.537035,0.838938,-7.36614,10.7654,2.24107> }}
union{cone{<-7.61068,12.2547,3.22013> ,0.178971,<-8.01328,13.7761,3.8557> ,0.166629}
sphere{<-7.61068,12.2547,3.22013> ,0.178971}
texture{txttree matrix <0.966722,0.255828,0,-0.237213,0.896381,0.374475,0.0958011,-0.362013,0.927237,-7.61068,12.2547,3.22013> }}
union{cone{<-8.01328,13.7761,3.8557> ,0.166629,<-7.76778,15.5407,4.12116> ,0.154286}
sphere{<-8.01328,13.7761,3.8557> ,0.166629}
texture{txttree matrix <0.990461,-0.137793,0,0.136289,0.979647,0.147366,-0.0203061,-0.145961,0.989082,-8.01328,13.7761,3.8557> }}
union{cone{<-7.76778,15.5407,4.12116> ,0.154286,<-8.01037,17.1828,4.36822> ,0.141943}
sphere{<-7.76778,15.5407,4.12116> ,0.154286}
texture{txttree matrix <0.989263,0.146148,0,-0.144556,0.978483,0.147223,0.0215164,-0.145643,0.989103,-7.76778,15.5407,4.12116> }}
union{cone{<-8.01037,17.1828,4.36822> ,0.141943,<-7.83618,18.8522,4.19849> ,0.1296}
sphere{<-8.01037,17.1828,4.36822> ,0.141943}
texture{txttree matrix <0.994601,-0.103777,0,0.103251,0.989554,-0.10061,0.010441,0.100067,0.994926,-8.01037,17.1828,4.36822> }}
union{cone{<-7.83618,18.8522,4.19849> ,0.1296,<-8.22516,21.8714,4.87434> ,0.12096}
sphere{<-7.83618,18.8522,4.19849> ,0.1296}
texture{txttree matrix <0.991803,0.127777,0,-0.124739,0.968228,0.216738,0.0276941,-0.214962,0.97623,-7.83618,18.8522,4.19849> }}
union{cone{<-8.22516,21.8714,4.87434> ,0.12096,<-7.03616,24.87,6.04745> ,0.11232}
sphere{<-8.22516,21.8714,4.87434> ,0.12096}
texture{txttree matrix <0.929588,-0.368601,0,0.346404,0.873609,0.341776,-0.125979,-0.317711,0.939781,-8.22516,21.8714,4.87434> }}
union{cone{<-7.03616,24.87,6.04745> ,0.11232,<-6.11083,27.9355,5.70957> ,0.10368}
sphere{<-7.03616,24.87,6.04745> ,0.11232}
texture{txttree matrix <0.957335,-0.288979,0,0.287384,0.95205,-0.104937,0.0303247,0.10046,0.994479,-7.03616,24.87,6.04745> }}
union{cone{<-6.11083,27.9355,5.70957> ,0.10368,<-6.69064,31.1158,4.93947> ,0.09504}
sphere{<-6.11083,27.9355,5.70957> ,0.10368}
texture{txttree matrix <0.983784,0.179355,0,-0.174473,0.957005,-0.231736,-0.041563,0.227978,0.972779,-6.11083,27.9355,5.70957> }}
union{cone{<-6.69064,31.1158,4.93947> ,0.09504,<-5.82243,34.2537,4.92402> ,0.0864}
sphere{<-6.69064,31.1158,4.93947> ,0.09504}
texture{txttree matrix <0.963789,-0.266665,0,0.266662,0.963779,-0.00474504,0.00126533,0.00457322,0.999989,-6.69064,31.1158,4.93947> }}
union{cone{<-5.82243,34.2537,4.92402> ,0.0864,<-5.53762,37.2815,4.16873> ,0.07776}
sphere{<-5.82243,34.2537,4.92402> ,0.0864}
texture{txttree matrix <0.995605,-0.0936496,0,0.0908887,0.966253,-0.241027,0.0225721,0.239968,0.970518,-5.82243,34.2537,4.92402> }}
union{cone{<-7.93961,17.8609,4.29927> ,0.1296,<-6.02175,20.3428,3.19432> ,0.12096}
sphere{<-7.93961,17.8609,4.29927> ,0.1296}
texture{txttree matrix <0.791278,-0.611457,0,0.576717,0.746321,-0.332269,0.203168,0.262917,0.943185,-7.93961,17.8609,4.29927> }}
union{cone{<-6.02175,20.3428,3.19432> ,0.12096,<-5.72261,23.6534,3.0613> ,0.11232}
sphere{<-6.02175,20.3428,3.19432> ,0.12096}
texture{txttree matrix <0.995942,-0.0899927,0,0.0899207,0.995146,-0.0399838,0.00359825,0.0398215,0.9992,-6.02175,20.3428,3.19432> }}
union{cone{<-5.72261,23.6534,3.0613> ,0.11232,<-5.28586,26.4969,1.81459> ,0.10368}
sphere{<-5.72261,23.6534,3.0613> ,0.11232}
texture{txttree matrix <0.988409,-0.151812,0,0.139295,0.906914,-0.397624,0.0603639,0.393015,0.917549,-5.72261,23.6534,3.0613> }}
union{cone{<-5.28586,26.4969,1.81459> ,0.10368,<-4.972,29.5783,0.86191> ,0.09504}
sphere{<-5.28586,26.4969,1.81459> ,0.10368}
texture{txttree matrix <0.994852,-0.101334,0,0.0968562,0.950888,-0.293993,0.0297916,0.292479,0.955808,-5.28586,26.4969,1.81459> }}
union{cone{<-4.972,29.5783,0.86191> ,0.09504,<-4.19933,32.6763,0.386976> ,0.0864}
sphere{<-4.972,29.5783,0.86191> ,0.09504}
texture{txttree matrix <0.970278,-0.241993,0,0.23936,0.959719,-0.147127,0.0356037,0.142754,0.989118,-4.972,29.5783,0.86191> }}
union{cone{<-4.19933,32.6763,0.386976> ,0.0864,<-3.93481,35.4978,-1.18976> ,0.07776}
sphere{<-4.19933,32.6763,0.386976> ,0.0864}
texture{txttree matrix <0.995634,-0.0933441,0,0.0815685,0.870032,-0.486201,0.0453839,0.484078,0.873847,-4.19933,32.6763,0.386976> }}
union{cone{<-7.18859,9.01088,1.04647> ,0.1296,<-7.05365,11.1038,3.53802> ,0.12096}
sphere{<-7.18859,9.01088,1.04647> ,0.1296}
texture{txttree matrix <0.997928,-0.0643387,0,0.0414321,0.642634,0.765052,-0.0492224,-0.763467,0.643968,-7.18859,9.01088,1.04647> }}
union{cone{<-7.05365,11.1038,3.53802> ,0.12096,<-8.26721,14.0328,4.3651> ,0.11232}
sphere{<-7.05365,11.1038,3.53802> ,0.12096}
texture{txttree matrix <0.923847,0.382761,0,-0.370367,0.893932,0.252416,0.096615,-0.233194,0.967619,-7.05365,11.1038,3.53802> }}
union{cone{<-8.26721,14.0328,4.3651> ,0.11232,<-9.58801,16.9249,4.44669> ,0.10368}
sphere{<-8.26721,14.0328,4.3651> ,0.11232}
texture{txttree matrix <0.909627,0.415426,0,-0.415289,0.909328,0.025655,0.0106578,-0.0233365,0.999671,-8.26721,14.0328,4.3651> }}
union{cone{<-9.58801,16.9249,4.44669> ,0.10368,<-9.62877,20.1702,4.22563> ,0.09504}
sphere{<-9.58801,16.9249,4.44669> ,0.10368}
texture{txttree matrix <0.999921,0.0125581,0,-0.012529,0.99761,-0.0679552,-0.000853387,0.0679499,0.997688,-9.58801,16.9249,4.44669> }}
union{cone{<-9.62877,20.1702,4.22563> ,0.09504,<-10.2703,23.3865,4.02025> ,0.0864}
sphere{<-9.62877,20.1702,4.22563> ,0.09504}
texture{txttree matrix <0.98068,0.195617,0,-0.195235,0.978763,-0.0624977,-0.0122256,0.0612903,0.998045,-9.62877,20.1702,4.22563> }}
union{cone{<-10.2703,23.3865,4.02025> ,0.0864,<-10.9986,26.463,4.45685> ,0.07776}
sphere{<-10.2703,23.3865,4.02025> ,0.0864}
texture{txttree matrix <0.973108,0.230351,0,-0.228186,0.963959,0.1368,0.031512,-0.133121,0.990599,-10.2703,23.3865,4.02025> }}
union{cone{<-7.84665,18.7519,4.20869> ,0.1296,<-8.89416,21.5756,2.61259> ,0.12096}
sphere{<-7.84665,18.7519,4.20869> ,0.1296}
texture{txttree matrix <0.937568,0.347802,0,-0.307315,0.828427,-0.468258,-0.162861,0.439024,0.883592,-7.84665,18.7519,4.20869> }}
union{cone{<-8.89416,21.5756,2.61259> ,0.12096,<-8.50187,23.9901,0.436861> ,0.11232}
sphere{<-8.89416,21.5756,2.61259> ,0.12096}
texture{txttree matrix <0.987056,-0.160373,0,0.11983,0.737524,-0.664605,0.106585,0.656002,0.747195,-8.89416,21.5756,2.61259> }}
union{cone{<-8.50187,23.9901,0.436861> ,0.11232,<-9.11696,26.4249,-1.42676> ,0.10368}
sphere{<-8.50187,23.9901,0.436861> ,0.11232}
texture{txttree matrix <0.969541,0.24493,0,-0.196688,0.778576,-0.59593,-0.145961,0.577779,0.803036,-8.50187,23.9901,0.436861> }}
union{cone{<-9.11696,26.4249,-1.42676> ,0.10368,<-9.58913,28.9668,-3.18229> ,0.09504}
sphere{<-9.11696,26.4249,-1.42676> ,0.10368}
texture{txttree matrix <0.983183,0.182623,0,-0.151086,0.813397,-0.561746,-0.102588,0.552299,0.82731,-9.11696,26.4249,-1.42676> }}
union{cone{<-9.58913,28.9668,-3.18229> ,0.09504,<-9.40978,31.3651,-5.23655> ,0.0864}
sphere{<-9.58913,28.9668,-3.18229> ,0.09504}
texture{txttree matrix <0.997216,-0.0745727,0,0.0567025,0.758248,-0.649495,0.0484346,0.647687,0.760366,-9.58913,28.9668,-3.18229> }}
union{cone{<-9.40978,31.3651,-5.23655> ,0.0864,<-9.00144,34.167,-6.64591> ,0.07776}
sphere{<-9.40978,31.3651,-5.23655> ,0.0864}
texture{txttree matrix <0.989546,-0.144216,0,0.129107,0.885874,-0.445598,0.0642624,0.44094,0.895233,-9.40978,31.3651,-5.23655> }}
union{cone{<-6.78654,8.23898,0.0962132> ,0.1296,<-9.01344,9.97768,1.62383> ,0.12096}
sphere{<-6.78654,8.23898,0.0962132> ,0.1296}
texture{txttree matrix <0.61541,0.788207,0,-0.693346,0.541345,0.475623,0.37489,-0.292703,0.879649,-6.78654,8.23898,0.0962132> }}
union{cone{<-9.01344,9.97768,1.62383> ,0.12096,<-10.2056,12.4215,3.17723> ,0.11232}
sphere{<-9.01344,9.97768,1.62383> ,0.12096}
texture{txttree matrix <0.898758,0.438445,0,-0.380701,0.78039,0.496042,0.217488,-0.445822,0.868298,-9.01344,9.97768,1.62383> }}
union{cone{<-10.2056,12.4215,3.17723> ,0.11232,<-11.8488,15.0596,3.84394> ,0.10368}
sphere{<-10.2056,12.4215,3.17723> ,0.11232}
texture{txttree matrix <0.848807,0.528703,0,-0.516942,0.829926,0.209745,0.110893,-0.178033,0.977756,-10.2056,12.4215,3.17723> }}
union{cone{<-11.8488,15.0596,3.84394> ,0.10368,<-14.489,17.0877,4.49357> ,0.09504}
sphere{<-11.8488,15.0596,3.84394> ,0.10368}
texture{txttree matrix <0.609178,0.793034,0,-0.778354,0.597901,0.191518,0.15188,-0.116668,0.981489,-11.8488,15.0596,3.84394> }}
union{cone{<-14.489,17.0877,4.49357> ,0.09504,<-16.5972,19.7473,4.98685> ,0.0864}
sphere{<-14.489,17.0877,4.49357> ,0.09504}
texture{txttree matrix <0.783663,0.621186,0,-0.614727,0.775514,0.143835,0.0893483,-0.112718,0.989602,-14.489,17.0877,4.49357> }}
union{cone{<-16.5972,19.7473,4.98685> ,0.0864,<-17.8218,22.6713,5.77459> ,0.07776}
sphere{<-16.5972,19.7473,4.98685> ,0.0864}
texture{txttree matrix <0.922374,0.386299,0,-0.374898,0.89515,0.241161,0.0931604,-0.222441,0.970485,-16.5972,19.7473,4.98685> }}
union{cone{<-4.19288,2.71583,0.853098> ,0.216,<-3.76969,4.10947,1.76672> ,0.203657}
sphere{<-4.19288,2.71583,0.853098> ,0.216}
texture{txttree matrix <0.956857,-0.290558,0,0.246141,0.810583,0.531385,-0.154398,-0.50846,0.847131,-4.19288,2.71583,0.853098> }}
union{cone{<-3.76969,4.10947,1.76672> ,0.203657,<-4.17186,5.74107,2.10029> ,0.191314}
sphere{<-3.76969,4.10947,1.76672> ,0.203657}
texture{txttree matrix <0.970939,0.239327,0,-0.234747,0.952357,0.194706,0.0465983,-0.189047,0.980862,-3.76969,4.10947,1.76672> }}
union{cone{<-4.17186,5.74107,2.10029> ,0.191314,<-3.73518,7.39061,2.68744> ,0.178971}
sphere{<-4.17186,5.74107,2.10029> ,0.191314}
texture{txttree matrix <0.9667,-0.255912,0,0.241987,0.914098,0.325372,-0.0832668,-0.314537,0.945586,-4.17186,5.74107,2.10029> }}
union{cone{<-3.73518,7.39061,2.68744> ,0.178971,<-3.68144,9.10771,2.24424> ,0.166629}
sphere{<-3.73518,7.39061,2.68744> ,0.178971}
texture{txttree matrix <0.999511,-0.0312833,0,0.0302915,0.967822,-0.249805,0.00781472,0.249683,0.968296,-3.73518,7.39061,2.68744> }}
union{cone{<-3.68144,9.10771,2.24424> ,0.166629,<-4.06519,10.8229,2.17677> ,0.154286}
sphere{<-3.68144,9.10771,2.24424> ,0.166629}
texture{txttree matrix <0.975874,0.218336,0,-0.218175,0.975155,-0.0383619,-0.00837579,0.0374364,0.999264,-3.68144,9.10771,2.24424> }}
union{cone{<-4.06519,10.8229,2.17677> ,0.154286,<-3.84708,12.4237,1.57412> ,0.141943}
sphere{<-4.06519,10.8229,2.17677> ,0.154286}
texture{txttree matrix <0.990845,-0.135002,0,0.126489,0.928358,-0.349503,0.0471837,0.346303,0.936935,-4.06519,10.8229,2.17677> }}
union{cone{<-3.84708,12.4237,1.57412> ,0.141943,<-3.49797,14.2131,1.4543> ,0.1296}
sphere{<-3.84708,12.4237,1.57412> ,0.141943}
texture{txttree matrix <0.981496,-0.191483,0,0.191071,0.979383,-0.0655759,0.0125567,0.0643625,0.997848,-3.84708,12.4237,1.57412> }}
union{cone{<-3.49797,14.2131,1.4543> ,0.1296,<-2.23151,17.3287,1.8261> ,0.12096}
sphere{<-3.49797,14.2131,1.4543> ,0.1296}
texture{txttree matrix <0.926389,-0.376569,0,0.374289,0.920779,0.109881,-0.0413779,-0.101793,0.993945,-3.49797,14.2131,1.4543> }}
union{cone{<-2.23151,17.3287,1.8261> ,0.12096,<-1.59422,20.394,2.81985> ,0.11232}
sphere{<-2.23151,17.3287,1.8261> ,0.12096}
texture{txttree matrix <0.979063,-0.203557,0,0.194017,0.933182,0.302538,-0.0615837,-0.296204,0.953137,-2.23151,17.3287,1.8261> }}
union{cone{<-1.59422,20.394,2.81985> ,0.11232,<-0.388774,23.3145,2.43155> ,0.10368}
sphere{<-1.59422,20.394,2.81985> ,0.11232}
texture{txttree matrix <0.924357,-0.381528,0,0.378679,0.917455,-0.121981,0.046539,0.112754,0.992532,-1.59422,20.394,2.81985> }}
union{cone{<-0.388774,23.3145,2.43155> ,0.10368,<-0.624754,26.5548,2.01291> ,0.09504}
sphere{<-0.388774,23.3145,2.43155> ,0.10368}
texture{txttree matrix <0.997359,0.0726346,0,-0.072039,0.98918,-0.127802,-0.00928286,0.127465,0.9918,-0.388774,23.3145,2.43155> }}
union{cone{<-0.624754,26.5548,2.01291> ,0.09504,<-0.900814,29.6729,1.01148> ,0.0864}
sphere{<-0.624754,26.5548,2.01291> ,0.09504}
texture{txttree matrix <0.996104,0.0881894,0,-0.0839959,0.948737,-0.304701,-0.0268714,0.303513,0.952448,-0.624754,26.5548,2.01291> }}
union{cone{<-0.900814,29.6729,1.01148> ,0.0864,<-0.90122,33.0444,1.1043> ,0.07776}
sphere{<-0.900814,29.6729,1.01148> ,0.0864}
texture{txttree matrix <1,0.000120639,0,-0.000120594,0.999621,0.0275202,3.32002e-006,-0.0275202,0.999621,-0.900814,29.6729,1.01148> }}
union{cone{<-3.8592,3.8147,1.57348> ,0.1296,<-3.55101,6.51197,3.41086> ,0.12096}
sphere{<-3.8592,3.8147,1.57348> ,0.1296}
texture{txttree matrix <0.993536,-0.113521,0,0.0940134,0.822804,0.560495,-0.063628,-0.556872,0.828158,-3.8592,3.8147,1.57348> }}
union{cone{<-3.55101,6.51197,3.41086> ,0.12096,<-1.38675,8.92226,3.42972> ,0.11232}
sphere{<-3.55101,6.51197,3.41086> ,0.12096}
texture{txttree matrix <0.744062,-0.668111,0,0.668099,0.744049,0.00582293,-0.00389036,-0.00433262,0.999983,-3.55101,6.51197,3.41086> }}
union{cone{<-1.38675,8.92226,3.42972> ,0.11232,<-1.06573,12.2101,4.03585> ,0.10368}
sphere{<-1.38675,8.92226,3.42972> ,0.11232}
texture{txttree matrix <0.995267,-0.0971777,0,0.095582,0.978925,0.180473,-0.017538,-0.179619,0.98358,-1.38675,8.92226,3.42972> }}
union{cone{<-1.06573,12.2101,4.03585> ,0.10368,<0.0879755,15.0443,3.1797> ,0.09504}
sphere{<-1.06573,12.2101,4.03585> ,0.10368}
texture{txttree matrix <0.926204,-0.377024,0,0.363081,0.891951,-0.269437,0.101584,0.249553,0.963018,-1.06573,12.2101,4.03585> }}
union{cone{<0.0879755,15.0443,3.1797> ,0.09504,<0.296028,18.2648,2.69398> ,0.0864}
sphere{<0.0879755,15.0443,3.1797> ,0.09504}
texture{txttree matrix <0.99792,-0.0644669,0,0.063749,0.986806,-0.148829,0.00959455,0.148519,0.988863,0.0879755,15.0443,3.1797> }}
union{cone{<0.296028,18.2648,2.69398> ,0.0864,<0.482024,21.444,2.03286> ,0.07776}
sphere{<0.296028,18.2648,2.69398> ,0.0864}
texture{txttree matrix <0.998293,-0.0584049,0,0.0571856,0.977452,-0.203265,0.0118717,0.202918,0.979124,0.296028,18.2648,2.69398> }}
union{cone{<-4.12069,5.53345,2.05784> ,0.1296,<-5.96009,7.90452,1.11107> ,0.12096}
sphere{<-4.12069,5.53345,2.05784> ,0.1296}
texture{txttree matrix <0.790119,0.612953,0,-0.584551,0.753507,-0.300879,-0.184425,0.23773,0.953662,-4.12069,5.53345,2.05784> }}
union{cone{<-5.96009,7.90452,1.11107> ,0.12096,<-7.82046,10.414,0.731605> ,0.11232}
sphere{<-5.96009,7.90452,1.11107> ,0.12096}
texture{txttree matrix <0.803333,0.59553,0,-0.591184,0.797471,-0.120586,-0.0718123,0.0968705,0.992703,-5.96009,7.90452,1.11107> }}
union{cone{<-7.82046,10.414,0.731605> ,0.11232,<-9.92606,12.8223,-0.440849> ,0.10368}
sphere{<-7.82046,10.414,0.731605> ,0.11232}
texture{txttree matrix <0.752827,0.658218,0,-0.618016,0.706847,-0.344127,-0.226511,0.259068,0.938923,-7.82046,10.414,0.731605> }}
union{cone{<-9.92606,12.8223,-0.440849> ,0.10368,<-11.8091,15.2427,-1.70691> ,0.09504}
sphere{<-9.92606,12.8223,-0.440849> ,0.10368}
texture{txttree matrix <0.789277,0.614038,0,-0.567569,0.729547,-0.38161,-0.234323,0.301196,0.924323,-9.92606,12.8223,-0.440849> }}
union{cone{<-11.8091,15.2427,-1.70691> ,0.09504,<-12.8909,18.3334,-2.15319> ,0.0864}
sphere{<-11.8091,15.2427,-1.70691> ,0.09504}
texture{txttree matrix <0.94385,0.330374,0,-0.327348,0.935205,-0.135039,-0.0446133,0.127456,0.99084,-11.8091,15.2427,-1.70691> }}
union{cone{<-12.8909,18.3334,-2.15319> ,0.0864,<-14.3031,21.0284,-3.51014> ,0.07776}
sphere{<-12.8909,18.3334,-2.15319> ,0.0864}
texture{txttree matrix <0.885755,0.464153,0,-0.423906,0.808951,-0.407311,-0.189055,0.360777,0.91329,-12.8909,18.3334,-2.15319> }}
union{cone{<-3.84833,4.42853,1.83195> ,0.1296,<-4.5981,7.53948,1.83008> ,0.12096}
sphere{<-3.84833,4.42853,1.83195> ,0.1296}
texture{txttree matrix <0.972164,0.234301,0,-0.234301,0.972164,-0.00058288,-0.000136569,0.000566655,1,-3.84833,4.42853,1.83195> }}
union{cone{<-4.5981,7.53948,1.83008> ,0.12096,<-5.9318,9.98937,3.33576> ,0.11232}
sphere{<-4.5981,7.53948,1.83008> ,0.12096}
texture{txttree matrix <0.878287,0.478133,0,-0.420749,0.772878,0.475005,0.227116,-0.417191,0.879983,-4.5981,7.53948,1.83008> }}
union{cone{<-5.9318,9.98937,3.33576> ,0.11232,<-6.57972,13.2649,2.80394> ,0.10368}
sphere{<-5.9318,9.98937,3.33576> ,0.11232}
texture{txttree matrix <0.980992,0.194048,0,-0.191632,0.96878,-0.157295,-0.0305227,0.154305,0.987552,-5.9318,9.98937,3.33576> }}
union{cone{<-6.57972,13.2649,2.80394> ,0.10368,<-8.33605,16.0898,2.13168> ,0.09504}
sphere{<-6.57972,13.2649,2.80394> ,0.10368}
texture{txttree matrix <0.84925,0.527991,0,-0.517528,0.832421,-0.198092,-0.104591,0.16823,0.980183,-6.57972,13.2649,2.80394> }}
union{cone{<-8.33605,16.0898,2.13168> ,0.09504,<-10.0036,18.7966,1.9766> ,0.0864}
sphere{<-8.33605,16.0898,2.13168> ,0.09504}
texture{txttree matrix <0.8514,0.524517,0,-0.523894,0.850389,-0.0487199,-0.0255544,0.0414801,0.998812,-8.33605,16.0898,2.13168> }}
union{cone{<-10.0036,18.7966,1.9766> ,0.0864,<-10.7983,21.9922,1.60239> ,0.07776}
sphere{<-10.0036,18.7966,1.9766> ,0.0864}
texture{txttree matrix <0.970444,0.241325,0,-0.239782,0.964238,-0.112913,-0.0272489,0.109576,0.993605,-10.0036,18.7966,1.9766> }}
union{cone{<-5.96271,6.31491,0.403566> ,0.216,<-6.57064,7.23335,-0.955481> ,0.203657}
sphere{<-5.96271,6.31491,0.403566> ,0.216}
texture{txttree matrix <0.833872,0.551957,0,-0.347524,0.525024,-0.776902,-0.428817,0.647837,0.629622,-5.96271,6.31491,0.403566> }}
union{cone{<-6.57064,7.23335,-0.955481> ,0.203657,<-7.04632,8.61368,-1.96465> ,0.191314}
sphere{<-6.57064,7.23335,-0.955481> ,0.203657}
texture{txttree matrix <0.945436,0.325807,0,-0.268013,0.777728,-0.568601,-0.185254,0.537576,0.822613,-6.57064,7.23335,-0.955481> }}
union{cone{<-7.04632,8.61368,-1.96465> ,0.191314,<-7.04164,9.98181,-2.94813> ,0.178971}
sphere{<-7.04632,8.61368,-1.96465> ,0.191314}
texture{txttree matrix <0.999994,-0.0034177,0,0.0027751,0.811973,-0.583688,0.00199487,0.583684,0.811978,-7.04632,8.61368,-1.96465> }}
union{cone{<-7.04164,9.98181,-2.94813> ,0.178971,<-6.64177,11.312,-4.08082> ,0.166629}
sphere{<-7.04164,9.98181,-2.94813> ,0.178971}
texture{txttree matrix <0.957661,-0.287898,0,0.223114,0.742164,-0.631991,0.181949,0.605233,0.774975,-7.04164,9.98181,-2.94813> }}
union{cone{<-6.64177,11.312,-4.08082> ,0.166629,<-6.99942,12.6434,-5.16568> ,0.154286}
sphere{<-6.64177,11.312,-4.08082> ,0.166629}
texture{txttree matrix <0.965761,0.259433,0,-0.203876,0.758946,-0.618414,-0.160437,0.59724,0.785853,-6.64177,11.312,-4.08082> }}
union{cone{<-6.99942,12.6434,-5.16568> ,0.154286,<-6.8102,14.0838,-6.207> ,0.141943}
sphere{<-6.99942,12.6434,-5.16568> ,0.154286}
texture{txttree matrix <0.991482,-0.130241,0,0.105859,0.805867,-0.582557,0.075873,0.577595,0.81279,-6.99942,12.6434,-5.16568> }}
union{cone{<-6.8102,14.0838,-6.207> ,0.141943,<-6.86172,15.2614,-7.50844> ,0.1296}
sphere{<-6.8102,14.0838,-6.207> ,0.141943}
texture{txttree matrix <0.999044,0.0437077,0,-0.0293405,0.670648,-0.741195,-0.0323959,0.740487,0.67129,-6.8102,14.0838,-6.207> }}
union{cone{<-6.86172,15.2614,-7.50844> ,0.1296,<-7.42777,17.9291,-9.20847> ,0.12096}
sphere{<-6.86172,15.2614,-7.50844> ,0.1296}
texture{txttree matrix <0.978221,0.207567,0,-0.176144,0.83013,-0.529016,-0.109806,0.517494,0.848612,-6.86172,15.2614,-7.50844> }}
union{cone{<-7.42777,17.9291,-9.20847> ,0.12096,<-7.86351,21.2629,-9.91386> ,0.11232}
sphere{<-7.42777,17.9291,-9.20847> ,0.12096}
texture{txttree matrix <0.991566,0.1296,0,-0.126839,0.970439,-0.205328,-0.0266106,0.203597,0.978693,-7.42777,17.9291,-9.20847> }}
union{cone{<-7.86351,21.2629,-9.91386> ,0.11232,<-7.41894,23.8614,-11.7901> ,0.10368}
sphere{<-7.86351,21.2629,-9.91386> ,0.11232}
texture{txttree matrix <0.985677,-0.168644,0,0.137396,0.803043,-0.579866,0.0977907,0.57156,0.814712,-7.86351,21.2629,-9.91386> }}
union{cone{<-7.41894,23.8614,-11.7901> ,0.10368,<-7.12968,26.4768,-13.5854> ,0.09504}
sphere{<-7.41894,23.8614,-11.7901> ,0.10368}
texture{txttree matrix <0.99394,-0.109925,0,0.0908046,0.821057,-0.563578,0.061951,0.560162,0.826063,-7.41894,23.8614,-11.7901> }}
union{cone{<-7.12968,26.4768,-13.5854> ,0.09504,<-6.82853,29.3377,-14.9431> ,0.0864}
sphere{<-7.12968,26.4768,-13.5854> ,0.09504}
texture{txttree matrix <0.994505,-0.104688,0,0.094673,0.899362,-0.426831,0.0446843,0.424486,0.904331,-7.12968,26.4768,-13.5854> }}
union{cone{<-6.82853,29.3377,-14.9431> ,0.0864,<-6.2483,31.9664,-16.9748> ,0.07776}
sphere{<-6.82853,29.3377,-14.9431> ,0.0864}
texture{txttree matrix <0.976496,-0.215535,0,0.17204,0.779438,-0.602394,0.129837,0.588235,0.798199,-6.82853,29.3377,-14.9431> }}
union{cone{<-6.79066,7.87179,-1.42225> ,0.1296,<-5.85676,10.829,-2.02651> ,0.12096}
sphere{<-6.79066,7.87179,-1.42225> ,0.1296}
texture{txttree matrix <0.953579,-0.301144,0,0.295585,0.935976,-0.191253,0.0575948,0.182375,0.981541,-6.79066,7.87179,-1.42225> }}
union{cone{<-5.85676,10.829,-2.02651> ,0.12096,<-4.89058,13.6868,-3.50547> ,0.11232}
sphere{<-5.85676,10.829,-2.02651> ,0.12096}
texture{txttree matrix <0.947325,-0.320274,0,0.287575,0.850605,-0.440195,0.140983,0.417008,0.897902,-5.85676,10.829,-2.02651> }}
union{cone{<-4.89058,13.6868,-3.50547> ,0.11232,<-5.18996,15.9648,-6.00192> ,0.10368}
sphere{<-4.89058,13.6868,-3.50547> ,0.11232}
texture{txttree matrix <0.991474,0.130307,0,-0.0882426,0.671415,-0.73581,-0.0958813,0.729536,0.677189,-4.89058,13.6868,-3.50547> }}
union{cone{<-5.18996,15.9648,-6.00192> ,0.10368,<-5.63235,18.7936,-7.8362> ,0.09504}
sphere{<-5.18996,15.9648,-6.00192> ,0.10368}
texture{txttree matrix <0.987992,0.154506,0,-0.130098,0.831915,-0.539436,-0.0833461,0.532959,0.842026,-5.18996,15.9648,-6.00192> }}
union{cone{<-5.63235,18.7936,-7.8362> ,0.09504,<-5.23913,21.1741,-9.95082> ,0.0864}
sphere{<-5.63235,18.7936,-7.8362> ,0.09504}
texture{txttree matrix <0.98663,-0.162977,0,0.122565,0.741985,-0.659118,0.107421,0.650305,0.75204,-5.63235,18.7936,-7.8362> }}
union{cone{<-5.23913,21.1741,-9.95082> ,0.0864,<-5.31771,24.2397,-11.2769> ,0.07776}
sphere{<-5.23913,21.1741,-9.95082> ,0.0864}
texture{txttree matrix <0.999672,0.025626,0,-0.0235212,0.917562,-0.396895,-0.0101708,0.396765,0.917864,-5.23913,21.1741,-9.95082> }}
union{cone{<-6.80064,10.7835,-3.63081> ,0.1296,<-5.93154,12.6081,-6.15374> ,0.12096}
sphere{<-6.80064,10.7835,-3.63081> ,0.1296}
texture{txttree matrix <0.902818,-0.430023,0,0.268852,0.564444,-0.780462,0.335617,0.704615,0.625203,-6.80064,10.7835,-3.63081> }}
union{cone{<-5.93154,12.6081,-6.15374> ,0.12096,<-6.38865,13.6422,-9.09582> ,0.11232}
sphere{<-5.93154,12.6081,-6.15374> ,0.12096}
texture{txttree matrix <0.914629,0.404293,0,-0.145029,0.328098,-0.933445,-0.377385,0.853756,0.358722,-5.93154,12.6081,-6.15374> }}
union{cone{<-6.38865,13.6422,-9.09582> ,0.11232,<-6.38262,16.0771,-11.5089> ,0.10368}
sphere{<-6.38865,13.6422,-9.09582> ,0.11232}
texture{txttree matrix <0.999997,-0.00247582,0,0.00175851,0.71027,-0.703927,0.0017428,0.703925,0.710272,-6.38865,13.6422,-9.09582> }}
union{cone{<-6.38262,16.0771,-11.5089> ,0.10368,<-6.10583,17.8493,-14.2326> ,0.09504}
sphere{<-6.38262,16.0771,-11.5089> ,0.10368}
texture{txttree matrix <0.988022,-0.154314,0,0.0848744,0.543423,-0.835157,0.128876,0.825154,0.550011,-6.38262,16.0771,-11.5089> }}
union{cone{<-6.10583,17.8493,-14.2326> ,0.09504,<-5.49048,19.6626,-16.8506> ,0.0864}
sphere{<-6.10583,17.8493,-14.2326> ,0.09504}
texture{txttree matrix <0.946959,-0.321355,0,0.189714,0.559045,-0.807142,0.259379,0.76433,0.590358,-6.10583,17.8493,-14.2326> }}
union{cone{<-5.49048,19.6626,-16.8506> ,0.0864,<-6.00961,21.4831,-19.3678> ,0.07776}
sphere{<-5.49048,19.6626,-16.8506> ,0.0864}
texture{txttree matrix <0.961665,0.274227,0,-0.164823,0.578004,-0.799215,-0.219166,0.768577,0.601045,-5.49048,19.6626,-16.8506> }}
union{cone{<-6.51159,7.14414,-0.823479> ,0.1296,<-7.47856,9.39779,-2.92054> ,0.12096}
sphere{<-6.51159,7.14414,-0.823479> ,0.1296}
texture{txttree matrix <0.91898,0.394303,0,-0.299676,0.698438,-0.649907,-0.25626,0.597252,0.760014,-6.51159,7.14414,-0.823479> }}
union{cone{<-7.47856,9.39779,-2.92054> ,0.12096,<-8.23413,11.6421,-5.36747> ,0.11232}
sphere{<-7.47856,9.39779,-2.92054> ,0.12096}
texture{txttree matrix <0.947735,0.319059,0,-0.221886,0.659091,-0.718586,-0.229271,0.681029,0.695438,-7.47856,9.39779,-2.92054> }}
union{cone{<-8.23413,11.6421,-5.36747> ,0.11232,<-9.4117,13.2817,-7.7975> ,0.10368}
sphere{<-8.23413,11.6421,-5.36747> ,0.11232}
texture{txttree matrix <0.812218,0.583355,0,-0.372757,0.518997,-0.769217,-0.448726,0.624771,0.638988,-8.23413,11.6421,-5.36747> }}
union{cone{<-9.4117,13.2817,-7.7975> ,0.10368,<-10.218,14.6669,-10.7747> ,0.09504}
sphere{<-9.4117,13.2817,-7.7975> ,0.10368}
texture{txttree matrix <0.864244,0.503072,0,-0.238468,0.409672,-0.880512,-0.442961,0.760978,0.474024,-9.4117,13.2817,-7.7975> }}
union{cone{<-10.218,14.6669,-10.7747> ,0.09504,<-11.0657,16.4033,-13.5869> ,0.0864}
sphere{<-10.218,14.6669,-10.7747> ,0.09504}
texture{txttree matrix <0.898645,0.438676,0,-0.248429,0.508917,-0.824188,-0.361552,0.740653,0.566316,-10.218,14.6669,-10.7747> }}
union{cone{<-11.0657,16.4033,-13.5869> ,0.0864,<-11.7428,17.7895,-16.3137> ,0.07776}
sphere{<-11.0657,16.4033,-13.5869> ,0.0864}
texture{txttree matrix <0.898536,0.4389,0,-0.216116,0.442443,-0.870366,-0.382004,0.782056,0.492405,-11.0657,16.4033,-13.5869> }}
union{cone{<-5.19436,4.70069,0.931451> ,0.216,<-6.62807,5.563,1.51602> ,0.203657}
sphere{<-5.19436,4.70069,0.931451> ,0.216}
texture{txttree matrix <0.515409,0.856945,0,-0.808985,0.486564,0.329847,0.282661,-0.170006,0.944034,-5.19436,4.70069,0.931451> }}
union{cone{<-6.62807,5.563,1.51602> ,0.203657,<-7.35024,7.15544,1.22179> ,0.191314}
sphere{<-6.62807,5.563,1.51602> ,0.203657}
texture{txttree matrix <0.910724,0.413014,0,-0.407289,0.898099,-0.165935,-0.0685337,0.151121,0.986137,-6.62807,5.563,1.51602> }}
union{cone{<-7.35024,7.15544,1.22179> ,0.191314,<-7.9325,8.72563,0.736072> ,0.178971}
sphere{<-7.35024,7.15544,1.22179> ,0.191314}
texture{txttree matrix <0.937612,0.347683,0,-0.333921,0.900501,-0.278559,-0.0968502,0.26118,0.960419,-7.35024,7.15544,1.22179> }}
union{cone{<-7.9325,8.72563,0.736072> ,0.178971,<-9.19347,9.94218,0.883576> ,0.166629}
sphere{<-7.9325,8.72563,0.736072> ,0.178971}
texture{txttree matrix <0.694317,0.71967,0,-0.717133,0.691869,0.0838881,0.0603717,-0.0582449,0.996475,-7.9325,8.72563,0.736072> }}
union{cone{<-9.19347,9.94218,0.883576> ,0.166629,<-10.2133,11.3484,0.690236> ,0.154286}
sphere{<-9.19347,9.94218,0.883576> ,0.166629}
texture{txttree matrix <0.809515,0.5871,0,-0.583497,0.804547,-0.110615,-0.0649419,0.0895442,0.993863,-9.19347,9.94218,0.883576> }}
union{cone{<-10.2133,11.3484,0.690236> ,0.154286,<-11.386,12.504,0.204568> ,0.141943}
sphere{<-10.2133,11.3484,0.690236> ,0.154286}
texture{txttree matrix <0.70189,0.712285,0,-0.683179,0.673208,-0.282944,-0.201537,0.198596,0.959136,-10.2133,11.3484,0.690236> }}
union{cone{<-11.386,12.504,0.204568> ,0.141943,<-12.3921,13.9404,0.0424829> ,0.1296}
sphere{<-11.386,12.504,0.204568> ,0.141943}
texture{txttree matrix <0.819082,0.573676,0,-0.571241,0.815606,-0.0920314,-0.0527962,0.0753813,0.995756,-11.386,12.504,0.204568> }}
union{cone{<-12.3921,13.9404,0.0424829> ,0.1296,<-13.3823,17.1283,-0.116955> ,0.12096}
sphere{<-12.3921,13.9404,0.0424829> ,0.1296}
texture{txttree matrix <0.954992,0.29663,0,-0.296293,0.953905,-0.0477083,-0.0141517,0.0455611,0.998861,-12.3921,13.9404,0.0424829> }}
union{cone{<-13.3823,17.1283,-0.116955> ,0.12096,<-14.0892,20.3232,0.792463> ,0.11232}
sphere{<-13.3823,17.1283,-0.116955> ,0.12096}
texture{txttree matrix <0.976384,0.216042,0,-0.208152,0.940729,0.267772,0.05785,-0.261448,0.963482,-13.3823,17.1283,-0.116955> }}
union{cone{<-14.0892,20.3232,0.792463> ,0.11232,<-15.9769,22.6627,-0.164624> ,0.10368}
sphere{<-14.0892,20.3232,0.792463> ,0.11232}
texture{txttree matrix <0.778247,0.627958,0,-0.598363,0.74157,-0.303375,-0.190507,0.236101,0.952871,-14.0892,20.3232,0.792463> }}
union{cone{<-15.9769,22.6627,-0.164624> ,0.10368,<-16.8171,25.6947,-1.23146> ,0.09504}
sphere{<-15.9769,22.6627,-0.164624> ,0.10368}
texture{txttree matrix <0.963686,0.267038,0,-0.252896,0.912647,-0.321121,-0.0857516,0.30946,0.947038,-15.9769,22.6627,-0.164624> }}
union{cone{<-16.8171,25.6947,-1.23146> ,0.09504,<-18.7243,28.4685,-1.26868> ,0.0864}
sphere{<-16.8171,25.6947,-1.23146> ,0.09504}
texture{txttree matrix <0.824006,0.566582,0,-0.566547,0.823955,-0.0110578,-0.00626514,0.00911169,0.999939,-16.8171,25.6947,-1.23146> }}
union{cone{<-18.7243,28.4685,-1.26868> ,0.0864,<-19.2387,31.5792,-2.41373> ,0.07776}
sphere{<-18.7243,28.4685,-1.26868> ,0.0864}
texture{txttree matrix <0.986601,0.163152,0,-0.153352,0.92734,-0.341357,-0.055693,0.336783,0.939934,-18.7243,28.4685,-1.26868> }}
union{cone{<-6.99052,6.36223,1.36835> ,0.1296,<-7.61406,9.46039,2.59515> ,0.12096}
sphere{<-6.99052,6.36223,1.36835> ,0.1296}
texture{txttree matrix <0.980343,0.197303,0,-0.183931,0.913898,0.361885,0.071401,-0.354771,0.932223,-6.99052,6.36223,1.36835> }}
union{cone{<-7.61406,9.46039,2.59515> ,0.12096,<-8.61136,12.4108,1.7487> ,0.11232}
sphere{<-7.61406,9.46039,2.59515> ,0.12096}
texture{txttree matrix <0.947341,0.320226,0,-0.309016,0.914178,-0.262274,-0.0839869,0.248463,0.964994,-7.61406,9.46039,2.59515> }}
union{cone{<-8.61136,12.4108,1.7487> ,0.11232,<-9.39811,15.5256,1.38616> ,0.10368}
sphere{<-8.61136,12.4108,1.7487> ,0.11232}
texture{txttree matrix <0.969551,0.244891,0,-0.243347,0.963435,-0.112136,-0.0274612,0.108722,0.993693,-8.61136,12.4108,1.7487> }}
union{cone{<-9.39811,15.5256,1.38616> ,0.10368,<-8.90995,18.5492,0.0954836> ,0.09504}
sphere{<-9.39811,15.5256,1.38616> ,0.10368}
texture{txttree matrix <0.987217,-0.159384,0,0.146875,0.909737,-0.388338,0.0618948,0.383373,0.921517,-9.39811,15.5256,1.38616> }}
union{cone{<-8.90995,18.5492,0.0954836> ,0.09504,<-9.66933,21.6286,-0.386442> ,0.0864}
sphere{<-8.90995,18.5492,0.0954836> ,0.09504}
texture{txttree matrix <0.970916,0.239422,0,-0.236705,0.959898,-0.150221,-0.0359661,0.145852,0.988652,-8.90995,18.5492,0.0954836> }}
union{cone{<-9.66933,21.6286,-0.386442> ,0.0864,<-10.2599,24.361,-2.1076> ,0.07776}
sphere{<-9.66933,21.6286,-0.386442> ,0.0864}
texture{txttree matrix <0.97743,0.211261,0,-0.179896,0.832319,-0.524292,-0.110762,0.512459,0.851538,-9.66933,21.6286,-0.386442> }}
union{cone{<-10.826,11.9522,0.436482> ,0.1296,<-13.6917,13.2183,-0.0111977> ,0.12096}
sphere{<-10.826,11.9522,0.436482> ,0.1296}
texture{txttree matrix <0.404134,0.9147,0,-0.905502,0.40007,-0.141459,-0.129392,0.0571682,0.989944,-10.826,11.9522,0.436482> }}
union{cone{<-13.6917,13.2183,-0.0111977> ,0.12096,<-16.1425,15.5082,0.217803> ,0.11232}
sphere{<-13.6917,13.2183,-0.0111977> ,0.12096}
texture{txttree matrix <0.682722,0.730678,0,-0.728981,0.681137,0.0681165,0.0497712,-0.0465047,0.997677,-13.6917,13.2183,-0.0111977> }}
union{cone{<-16.1425,15.5082,0.217803> ,0.11232,<-18.3259,16.9115,-1.69404> ,0.10368}
sphere{<-16.1425,15.5082,0.217803> ,0.11232}
texture{txttree matrix <0.540662,0.84124,0,-0.67732,0.435311,-0.593078,-0.498921,0.320655,0.805145,-16.1425,15.5082,0.217803> }}
union{cone{<-18.3259,16.9115,-1.69404> ,0.10368,<-20.9002,18.266,-3.45259> ,0.09504}
sphere{<-18.3259,16.9115,-1.69404> ,0.10368}
texture{txttree matrix <0.465653,0.884967,0,-0.757332,0.398494,-0.51735,-0.457837,0.240906,0.855774,-18.3259,16.9115,-1.69404> }}
union{cone{<-20.9002,18.266,-3.45259> ,0.09504,<-22.8168,19.6876,-5.49971> ,0.0864}
sphere{<-20.9002,18.266,-3.45259> ,0.09504}
texture{txttree matrix <0.595741,0.803176,0,-0.6096,0.45216,-0.651106,-0.522953,0.387891,0.758987,-20.9002,18.266,-3.45259> }}
union{cone{<-22.8168,19.6876,-5.49971> ,0.0864,<-23.9159,22.2059,-7.03969> ,0.07776}
sphere{<-22.8168,19.6876,-5.49971> ,0.0864}
texture{txttree matrix <0.916505,0.400023,0,-0.348952,0.799496,-0.488916,-0.195578,0.448094,0.872331,-22.8168,19.6876,-5.49971> }}
union{cone{<-0.920408,1.74006,0.0544018> ,0.36,<-1.80868,1.71171,-0.34736> ,0.342}
sphere{<-0.920408,1.74006,0.0544018> ,0.36}
texture{txttree matrix <-0.0319042,0.999491,0,-0.910752,-0.0290716,-0.411929,-0.41172,-0.0131423,0.911216,-0.920408,1.74006,0.0544018> }}
union{cone{<-1.80868,1.71171,-0.34736> ,0.342,<-2.69021,1.74921,-0.786556> ,0.324}
sphere{<-1.80868,1.71171,-0.34736> ,0.342}
texture{txttree matrix <0.0425049,0.999096,0,-0.894416,0.0380515,-0.445614,-0.445211,0.0189408,0.895225,-1.80868,1.71171,-0.34736> }}
union{cone{<-2.69021,1.74921,-0.786556> ,0.324,<-3.29106,1.8225,-1.56084> ,0.306}
sphere{<-2.69021,1.74921,-0.786556> ,0.324}
texture{txttree matrix <0.121078,0.992643,0,-0.611361,0.0745711,-0.78783,-0.782034,0.0953891,0.615892,-2.69021,1.74921,-0.786556> }}
union{cone{<-3.29106,1.8225,-1.56084> ,0.306,<-4.01621,2.28773,-1.89102> ,0.288}
sphere{<-3.29106,1.8225,-1.56084> ,0.306}
texture{txttree matrix <0.539987,0.841673,0,-0.785935,0.504227,-0.357857,-0.301199,0.193238,0.933776,-3.29106,1.8225,-1.56084> }}
union{cone{<-4.01621,2.28773,-1.89102> ,0.288,<-4.47027,2.81188,-2.5803> ,0.27}
sphere{<-4.01621,2.28773,-1.89102> ,0.288}
texture{txttree matrix <0.755836,0.654761,0,-0.464386,0.536073,-0.704962,-0.461581,0.532836,0.709245,-4.01621,2.28773,-1.89102> }}
union{cone{<-4.47027,2.81188,-2.5803> ,0.27,<-4.90786,3.06395,-3.35173> ,0.252}
sphere{<-4.47027,2.81188,-2.5803> ,0.27}
texture{txttree matrix <0.499142,0.86652,0,-0.4746,0.273384,-0.83667,-0.724991,0.417617,0.547708,-4.47027,2.81188,-2.5803> }}
union{cone{<-4.90786,3.06395,-3.35173> ,0.252,<-5.58735,3.44097,-3.88546> ,0.234}
sphere{<-4.90786,3.06395,-3.35173> ,0.252}
texture{txttree matrix <0.485183,0.874412,0,-0.720774,0.399934,-0.566161,-0.495058,0.274692,0.824295,-4.90786,3.06395,-3.35173> }}
union{cone{<-5.58735,3.44097,-3.88546> ,0.234,<-6.13185,3.9851,-4.45814> ,0.216}
sphere{<-5.58735,3.44097,-3.88546> ,0.234}
texture{txttree matrix <0.706867,0.707346,0,-0.56752,0.567136,-0.59689,-0.422208,0.421922,0.802323,-5.58735,3.44097,-3.88546> }}
union{cone{<-6.13185,3.9851,-4.45814> ,0.216,<-7.38733,4.94734,-4.99281> ,0.203657}
sphere{<-6.13185,3.9851,-4.45814> ,0.216}
texture{txttree matrix <0.608311,0.793699,0,-0.751908,0.576281,-0.320212,-0.254152,0.194788,0.947346,-6.13185,3.9851,-4.45814> }}
union{cone{<-7.38733,4.94734,-4.99281> ,0.203657,<-8.8359,6.00244,-4.68619> ,0.191314}
sphere{<-7.38733,4.94734,-4.99281> ,0.203657}
texture{txttree matrix <0.588755,0.808311,0,-0.796734,0.580322,0.168645,0.136317,-0.0992904,0.985677,-7.38733,4.94734,-4.99281> }}
union{cone{<-8.8359,6.00244,-4.68619> ,0.191314,<-9.5458,7.2777,-5.514> ,0.178971}
sphere{<-8.8359,6.00244,-4.68619> ,0.191314}
texture{txttree matrix <0.873744,0.486386,0,-0.423074,0.76001,-0.493348,-0.239958,0.43106,0.869832,-8.8359,6.00244,-4.68619> }}
union{cone{<-9.5458,7.2777,-5.514> ,0.178971,<-10.2733,8.64349,-6.2738> ,0.166629}
sphere{<-9.5458,7.2777,-5.514> ,0.178971}
texture{txttree matrix <0.882612,0.470102,0,-0.42198,0.792263,-0.440741,-0.207193,0.389003,0.897634,-9.5458,7.2777,-5.514> }}
union{cone{<-10.2733,8.64349,-6.2738> ,0.166629,<-10.9453,9.85411,-7.24277> ,0.154286}
sphere{<-10.2733,8.64349,-6.2738> ,0.166629}
texture{txttree matrix <0.874329,0.485334,0,-0.397637,0.716344,-0.573354,-0.278268,0.501301,0.819307,-10.2733,8.64349,-6.2738> }}
union{cone{<-10.9453,9.85411,-7.24277> ,0.154286,<-11.7731,11.1616,-7.86611> ,0.141943}
sphere{<-10.9453,9.85411,-7.24277> ,0.154286}
texture{txttree matrix <0.844887,0.534945,0,-0.496206,0.783702,-0.373619,-0.199866,0.315666,0.927582,-10.9453,9.85411,-7.24277> }}
union{cone{<-11.7731,11.1616,-7.86611> ,0.141943,<-12.7323,12.5167,-8.56499> ,0.1296}
sphere{<-11.7731,11.1616,-7.86611> ,0.141943}
texture{txttree matrix <0.816224,0.577736,0,-0.532479,0.752286,-0.387985,-0.224153,0.316682,0.921666,-11.7731,11.1616,-7.86611> }}
union{cone{<-12.7323,12.5167,-8.56499> ,0.1296,<-14.352,14.9956,-9.82693> ,0.12096}
sphere{<-12.7323,12.5167,-8.56499> ,0.1296}
texture{txttree matrix <0.837135,0.546997,0,-0.503207,0.770117,-0.392049,-0.21445,0.328198,0.919944,-12.7323,12.5167,-8.56499> }}
union{cone{<-14.352,14.9956,-9.82693> ,0.12096,<-16.0544,17.9096,-9.62945> ,0.11232}
sphere{<-14.352,14.9956,-9.82693> ,0.12096}
texture{txttree matrix <0.863453,0.504429,0,-0.503568,0.861978,0.0584183,0.0294679,-0.0504415,0.998292,-14.352,14.9956,-9.82693> }}
union{cone{<-16.0544,17.9096,-9.62945> ,0.11232,<-17.2843,20.634,-11.2112> ,0.10368}
sphere{<-16.0544,17.9096,-9.62945> ,0.11232}
texture{txttree matrix <0.911423,0.411471,0,-0.363694,0.805596,-0.467699,-0.192444,0.426272,0.883888,-16.0544,17.9096,-9.62945> }}
union{cone{<-17.2843,20.634,-11.2112> ,0.10368,<-18.4958,23.0703,-12.9555> ,0.09504}
sphere{<-17.2843,20.634,-11.2112> ,0.10368}
texture{txttree matrix <0.895405,0.445253,0,-0.374838,0.753801,-0.539703,-0.240304,0.483253,0.841855,-17.2843,20.634,-11.2112> }}
union{cone{<-18.4958,23.0703,-12.9555> ,0.09504,<-19.325,26.3452,-13.5918> ,0.0864}
sphere{<-18.4958,23.0703,-12.9555> ,0.09504}
texture{txttree matrix <0.969411,0.245444,0,-0.241203,0.952662,-0.185085,-0.045428,0.179423,0.982723,-18.4958,23.0703,-12.9555> }}
union{cone{<-19.325,26.3452,-13.5918> ,0.0864,<-20.3869,28.7417,-15.5063> ,0.07776}
sphere{<-19.325,26.3452,-13.5918> ,0.0864}
texture{txttree matrix <0.914259,0.40513,0,-0.327158,0.738299,-0.589815,-0.238952,0.539244,0.807538,-19.325,26.3452,-13.5918> }}
union{cone{<-8.55053,5.79459,-4.74659> ,0.1296,<-9.58166,8.57177,-2.99908> ,0.12096}
sphere{<-8.55053,5.79459,-4.74659> ,0.1296}
texture{txttree matrix <0.937469,0.348068,0,-0.299794,0.807451,0.508081,0.176847,-0.47631,0.86131,-8.55053,5.79459,-4.74659> }}
union{cone{<-9.58166,8.57177,-2.99908> ,0.12096,<-11.7184,10.8261,-3.47353> ,0.11232}
sphere{<-9.58166,8.57177,-2.99908> ,0.12096}
texture{txttree matrix <0.725783,0.687924,0,-0.680036,0.717461,-0.150999,-0.103876,0.109592,0.988534,-9.58166,8.57177,-2.99908> }}
union{cone{<-11.7184,10.8261,-3.47353> ,0.11232,<-13.8698,13.109,-2.90336> ,0.10368}
sphere{<-11.7184,10.8261,-3.47353> ,0.11232}
texture{txttree matrix <0.727752,0.68584,0,-0.674784,0.71602,0.178837,0.122653,-0.130149,0.983879,-11.7184,10.8261,-3.47353> }}
union{cone{<-13.8698,13.109,-2.90336> ,0.10368,<-14.6765,16.2832,-2.79019> ,0.09504}
sphere{<-13.8698,13.109,-2.90336> ,0.10368}
texture{txttree matrix <0.969192,0.246308,0,-0.246161,0.968613,0.0345329,0.00850574,-0.033469,0.999404,-13.8698,13.109,-2.90336> }}
union{cone{<-14.6765,16.2832,-2.79019> ,0.09504,<-16.5985,18.8933,-3.86433> ,0.0864}
sphere{<-14.6765,16.2832,-2.79019> ,0.09504}
texture{txttree matrix <0.80524,0.592949,0,-0.562849,0.764365,-0.314559,-0.186517,0.253296,0.949238,-14.6765,16.2832,-2.79019> }}
union{cone{<-16.5985,18.8933,-3.86433> ,0.0864,<-18.2314,21.8346,-3.99531> ,0.07776}
sphere{<-16.5985,18.8933,-3.86433> ,0.0864}
texture{txttree matrix <0.874299,0.485387,0,-0.48502,0.873637,-0.0389052,-0.0188841,0.0340148,0.999243,-16.5985,18.8933,-3.86433> }}
union{cone{<-10.7883,9.57134,-7.01644> ,0.1296,<-10.468,12.4319,-8.74083> ,0.12096}
sphere{<-10.7883,9.57134,-7.01644> ,0.1296}
texture{txttree matrix <0.993791,-0.111259,0,0.0954428,0.852519,-0.513909,0.057177,0.510719,0.857845,-10.7883,9.57134,-7.01644> }}
union{cone{<-10.468,12.4319,-8.74083> ,0.12096,<-10.0421,14.1361,-11.6727> ,0.11232}
sphere{<-10.468,12.4319,-8.74083> ,0.12096}
texture{txttree matrix <0.970155,-0.242485,0,0.124627,0.49862,-0.857815,0.208007,0.832213,0.513959,-10.468,12.4319,-8.74083> }}
union{cone{<-10.0421,14.1361,-11.6727> ,0.11232,<-10.8609,15.5486,-14.4422> ,0.10368}
sphere{<-10.0421,14.1361,-11.6727> ,0.11232}
texture{txttree matrix <0.865142,0.501527,0,-0.254691,0.439345,-0.861457,-0.432044,0.745283,0.50783,-10.0421,14.1361,-11.6727> }}
union{cone{<-10.8609,15.5486,-14.4422> ,0.10368,<-10.3879,17.9233,-16.7334> ,0.09504}
sphere{<-10.8609,15.5486,-14.4422> ,0.10368}
texture{txttree matrix <0.980732,-0.195357,0,0.1419,0.712368,-0.687311,0.134271,0.674068,0.726364,-10.8609,15.5486,-14.4422> }}
union{cone{<-10.3879,17.9233,-16.7334> ,0.09504,<-10.3662,20.2609,-18.8129> ,0.0864}
sphere{<-10.3879,17.9233,-16.7334> ,0.09504}
texture{txttree matrix <0.999957,-0.00927223,0,0.00692779,0.747123,-0.66465,0.00616279,0.664622,0.747155,-10.3879,17.9233,-16.7334> }}
union{cone{<-10.3662,20.2609,-18.8129> ,0.0864,<-10.1578,22.828,-21.0913> ,0.07776}
sphere{<-10.3662,20.2609,-18.8129> ,0.0864}
texture{txttree matrix <0.996722,-0.0809009,0,0.0605944,0.74654,-0.662575,0.0536029,0.660403,0.748995,-10.3662,20.2609,-18.8129> }}
union{cone{<-6.85856,4.54207,-4.76762> ,0.1296,<-9.12858,6.74175,-5.64401> ,0.12096}
sphere{<-6.85856,4.54207,-4.76762> ,0.1296}
texture{txttree matrix <0.695893,0.718145,0,-0.692039,0.670596,-0.267177,-0.191872,0.185927,0.963647,-6.85856,4.54207,-4.76762> }}
union{cone{<-9.12858,6.74175,-5.64401> ,0.12096,<-11.7896,8.45585,-6.57582> ,0.11232}
sphere{<-9.12858,6.74175,-5.64401> ,0.12096}
texture{txttree matrix <0.54153,0.840681,0,-0.806462,0.519488,-0.282403,-0.23741,0.15293,0.959296,-9.12858,6.74175,-5.64401> }}
union{cone{<-11.7896,8.45585,-6.57582> ,0.11232,<-13.9166,10.2922,-8.15488> ,0.10368}
sphere{<-11.7896,8.45585,-6.57582> ,0.11232}
texture{txttree matrix <0.653494,0.756932,0,-0.659883,0.569707,-0.489886,-0.37081,0.320137,0.871786,-11.7896,8.45585,-6.57582> }}
union{cone{<-13.9166,10.2922,-8.15488> ,0.10368,<-15.5072,12.2757,-10.2234> ,0.09504}
sphere{<-13.9166,10.2922,-8.15488> ,0.10368}
texture{txttree matrix <0.780138,0.625608,0,-0.485282,0.605151,-0.631105,-0.394824,0.492349,0.775697,-13.9166,10.2922,-8.15488> }}
union{cone{<-15.5072,12.2757,-10.2234> ,0.09504,<-17.4921,14.336,-11.8258> ,0.0864}
sphere{<-15.5072,12.2757,-10.2234> ,0.09504}
texture{txttree matrix <0.720146,0.693822,0,-0.605338,0.628304,-0.488671,-0.339051,0.351915,0.872468,-15.5072,12.2757,-10.2234> }}
union{cone{<-17.4921,14.336,-11.8258> ,0.0864,<-18.5937,15.7307,-14.4126> ,0.07776}
sphere{<-17.4921,14.336,-11.8258> ,0.0864}
texture{txttree matrix <0.784769,0.619789,0,-0.350971,0.444394,-0.824217,-0.51084,0.646819,0.566274,-17.4921,14.336,-11.8258> }}
union{cone{<-6.24699,4.07335,-4.50717> ,0.1296,<-8.72422,5.38252,-6.4699> ,0.12096}
sphere{<-6.24699,4.07335,-4.50717> ,0.1296}
texture{txttree matrix <0.467244,0.884129,0,-0.724136,0.382691,-0.573738,-0.507258,0.268075,0.819039,-6.24699,4.07335,-4.50717> }}
union{cone{<-8.72422,5.38252,-6.4699> ,0.12096,<-10.821,7.25502,-8.33924> ,0.11232}
sphere{<-8.72422,5.38252,-6.4699> ,0.12096}
texture{txttree matrix <0.666091,0.745871,0,-0.621089,0.554656,-0.55372,-0.413004,0.368828,0.832703,-8.72422,5.38252,-6.4699> }}
union{cone{<-10.821,7.25502,-8.33924> ,0.11232,<-12.9324,9.51126,-9.70209> ,0.10368}
sphere{<-10.821,7.25502,-8.33924> ,0.11232}
texture{txttree matrix <0.730159,0.683278,0,-0.625175,0.668069,-0.403535,-0.275727,0.294645,0.914964,-10.821,7.25502,-8.33924> }}
union{cone{<-12.9324,9.51126,-9.70209> ,0.10368,<-15.8412,10.4383,-11.1567> ,0.09504}
sphere{<-12.9324,9.51126,-9.70209> ,0.10368}
texture{txttree matrix <0.303647,0.952785,0,-0.86014,0.274122,-0.430136,-0.409827,0.13061,0.902764,-12.9324,9.51126,-9.70209> }}
union{cone{<-15.8412,10.4383,-11.1567> ,0.09504,<-18.5263,11.8922,-12.6941> ,0.0864}
sphere{<-15.8412,10.4383,-11.1567> ,0.09504}
texture{txttree matrix <0.476158,0.87936,0,-0.785431,0.425297,-0.44969,-0.395439,0.214123,0.893185,-15.8412,10.4383,-11.1567> }}
union{cone{<-18.5263,11.8922,-12.6941> ,0.0864,<-20.9651,13.6944,-13.8083> ,0.07776}
sphere{<-18.5263,11.8922,-12.6941> ,0.0864}
texture{txttree matrix <0.594296,0.804246,0,-0.754901,0.557833,-0.344888,-0.277375,0.204966,0.938644,-18.5263,11.8922,-12.6941> }}
union{cone{<-2.1739,1.72725,-0.52932> ,0.216,<-2.87836,2.60257,-1.9636> ,0.203657}
sphere{<-2.1739,1.72725,-0.52932> ,0.216}
texture{txttree matrix <0.779043,0.626971,0,-0.386644,0.480425,-0.787209,-0.493557,0.61327,0.616686,-2.1739,1.72725,-0.52932> }}
union{cone{<-2.87836,2.60257,-1.9636> ,0.203657,<-3.96232,2.89707,-3.35601> ,0.191314}
sphere{<-2.87836,2.60257,-1.9636> ,0.203657}
texture{txttree matrix <0.262182,0.965019,0,-0.605907,0.164616,-0.778318,-0.751091,0.204061,0.627871,-2.87836,2.60257,-1.9636> }}
union{cone{<-3.96232,2.89707,-3.35601> ,0.191314,<-4.79202,3.52088,-4.71378> ,0.178971}
sphere{<-3.96232,2.89707,-3.35601> ,0.191314}
texture{txttree matrix <0.600945,0.799291,0,-0.485456,0.364989,-0.794428,-0.634979,0.477407,0.607358,-3.96232,2.89707,-3.35601> }}
union{cone{<-4.79202,3.52088,-4.71378> ,0.178971,<-5.08636,4.35012,-6.20963> ,0.166629}
sphere{<-4.79202,3.52088,-4.71378> ,0.178971}
texture{txttree matrix <0.942394,0.334504,0,-0.169604,0.477823,-0.861928,-0.288318,0.812276,0.507031,-4.79202,3.52088,-4.71378> }}
union{cone{<-5.08636,4.35012,-6.20963> ,0.166629,<-5.80982,4.98802,-7.72822> ,0.154286}
sphere{<-5.08636,4.35012,-6.20963> ,0.166629}
texture{txttree matrix <0.661362,0.750067,0,-0.402142,0.354583,-0.844129,-0.633153,0.558274,0.536141,-5.08636,4.35012,-6.20963> }}
union{cone{<-5.80982,4.98802,-7.72822> ,0.154286,<-6.3021,5.94043,-9.10365> ,0.141943}
sphere{<-5.80982,4.98802,-7.72822> ,0.154286}
texture{txttree matrix <0.88835,0.459167,0,-0.282284,0.546134,-0.788703,-0.362147,0.700644,0.614774,-5.80982,4.98802,-7.72822> }}
union{cone{<-6.3021,5.94043,-9.10365> ,0.141943,<-7.0353,6.56499,-10.4964> ,0.1296}
sphere{<-6.3021,5.94043,-9.10365> ,0.141943}
texture{txttree matrix <0.648456,0.761252,0,-0.432985,0.368829,-0.822489,-0.626122,0.533348,0.568781,-6.3021,5.94043,-9.10365> }}
union{cone{<-7.0353,6.56499,-10.4964> ,0.1296,<-9.69118,8.04901,-11.169> ,0.12096}
sphere{<-7.0353,6.56499,-10.4964> ,0.1296}
texture{txttree matrix <0.487782,0.872965,0,-0.852384,0.476283,-0.21586,-0.188439,0.105293,0.976424,-7.0353,6.56499,-10.4964> }}
union{cone{<-9.69118,8.04901,-11.169> ,0.12096,<-10.7175,10.2258,-13.2478> ,0.11232}
sphere{<-9.69118,8.04901,-11.169> ,0.12096}
texture{txttree matrix <0.904517,0.426438,0,-0.322714,0.684509,-0.653684,-0.278756,0.591268,0.756767,-9.69118,8.04901,-11.169> }}
union{cone{<-10.7175,10.2258,-13.2478> ,0.11232,<-13.1497,11.753,-14.714> ,0.10368}
sphere{<-10.7175,10.2258,-13.2478> ,0.11232}
texture{txttree matrix <0.531764,0.846893,0,-0.754276,0.47361,-0.454709,-0.38509,0.241798,0.89064,-10.7175,10.2258,-13.2478> }}
union{cone{<-13.1497,11.753,-14.714> ,0.10368,<-15.0808,14.0477,-16.0399> ,0.09504}
sphere{<-13.1497,11.753,-14.714> ,0.10368}
texture{txttree matrix <0.765107,0.643904,0,-0.58892,0.699773,-0.404339,-0.260355,0.309362,0.914609,-13.1497,11.753,-14.714> }}
union{cone{<-15.0808,14.0477,-16.0399> ,0.09504,<-16.0254,15.7114,-18.558> ,0.0864}
sphere{<-15.0808,14.0477,-16.0399> ,0.09504}
texture{txttree matrix <0.869602,0.493754,0,-0.298703,0.526077,-0.796254,-0.393153,0.692423,0.604963,-15.0808,14.0477,-16.0399> }}
union{cone{<-16.0254,15.7114,-18.558> ,0.0864,<-16.8535,18.1042,-20.6404> ,0.07776}
sphere{<-16.0254,15.7114,-18.558> ,0.0864}
texture{txttree matrix <0.945019,0.327014,0,-0.25257,0.729887,-0.635196,-0.207718,0.600272,0.772351,-16.0254,15.7114,-18.558> }}
union{cone{<-4.82869,3.62418,-4.90012> ,0.1296,<-5.61292,4.92581,-7.84389> ,0.12096}
sphere{<-4.82869,3.62418,-4.90012> ,0.1296}
texture{txttree matrix <0.856548,0.516068,0,-0.236722,0.392902,-0.888589,-0.458572,0.761119,0.458704,-4.82869,3.62418,-4.90012> }}
union{cone{<-5.61292,4.92581,-7.84389> ,0.12096,<-4.34366,7.09158,-10.041> ,0.11232}
sphere{<-5.61292,4.92581,-7.84389> ,0.12096}
texture{txttree matrix <0.862756,-0.50562,0,0.380473,0.649214,-0.658606,0.333004,0.568217,0.752488,-5.61292,4.92581,-7.84389> }}
union{cone{<-4.34366,7.09158,-10.041> ,0.11232,<-4.69059,9.36034,-12.5672> ,0.10368}
sphere{<-4.34366,7.09158,-10.041> ,0.11232}
texture{txttree matrix <0.988509,0.151159,0,-0.101647,0.664725,-0.740141,-0.111879,0.731637,0.672451,-4.34366,7.09158,-10.041> }}
union{cone{<-4.69059,9.36034,-12.5672> ,0.10368,<-5.34061,11.5588,-14.9514> ,0.09504}
sphere{<-4.69059,9.36034,-12.5672> ,0.10368}
texture{txttree matrix <0.95896,0.28354,0,-0.196521,0.664652,-0.720845,-0.204389,0.691262,0.693096,-4.69059,9.36034,-12.5672> }}
union{cone{<-5.34061,11.5588,-14.9514> ,0.09504,<-5.64617,13.1375,-17.6545> ,0.0864}
sphere{<-5.34061,11.5588,-14.9514> ,0.09504}
texture{txttree matrix <0.981781,0.190018,0,-0.0971496,0.501951,-0.859422,-0.163305,0.843764,0.511266,-5.34061,11.5588,-14.9514> }}
union{cone{<-5.64617,13.1375,-17.6545> ,0.0864,<-5.9673,14.8731,-20.4797> ,0.07776}
sphere{<-5.64617,13.1375,-17.6545> ,0.0864}
texture{txttree matrix <0.98331,0.181937,0,-0.0964001,0.521011,-0.848088,-0.154299,0.833934,0.529855,-5.64617,13.1375,-17.6545> }}
union{cone{<-4.25832,3.11962,-3.8404> ,0.1296,<-4.3776,4.01805,-7.02642> ,0.12096}
sphere{<-4.25832,3.11962,-3.8404> ,0.1296}
texture{txttree matrix <0.991302,0.131609,0,-0.0360096,0.271231,-0.96184,-0.126586,0.953474,0.273611,-4.25832,3.11962,-3.8404> }}
union{cone{<-4.3776,4.01805,-7.02642> ,0.12096,<-3.78672,5.10146,-10.2084> ,0.11232}
sphere{<-4.3776,4.01805,-7.02642> ,0.12096}
texture{txttree matrix <0.877921,-0.478806,0,0.173133,0.317449,-0.932336,0.446408,0.818517,0.361592,-4.3776,4.01805,-7.02642> }}
union{cone{<-3.78672,5.10146,-10.2084> ,0.11232,<-3.29863,6.98204,-12.838> ,0.10368}
sphere{<-3.78672,5.10146,-10.2084> ,0.11232}
texture{txttree matrix <0.96793,-0.25122,0,0.149283,0.575177,-0.804292,0.202054,0.778498,0.594234,-3.78672,5.10146,-10.2084> }}
union{cone{<-3.29863,6.98204,-12.838> ,0.10368,<-3.34524,7.81484,-16.1392> ,0.09504}
sphere{<-3.29863,6.98204,-12.838> ,0.10368}
texture{txttree matrix <0.998437,0.0558818,0,-0.0136896,0.244591,-0.96953,-0.0541791,0.968015,0.244973,-3.29863,6.98204,-12.838> }}
union{cone{<-3.34524,7.81484,-16.1392> ,0.09504,<-4.03307,8.85272,-19.0224> ,0.0864}
sphere{<-3.34524,7.81484,-16.1392> ,0.09504}
texture{txttree matrix <0.833564,0.552422,0,-0.219013,0.330474,-0.918052,-0.507153,0.765256,0.396459,-3.34524,7.81484,-16.1392> }}
union{cone{<-4.03307,8.85272,-19.0224> ,0.0864,<-4.61522,10.6826,-21.7832> ,0.07776}
sphere{<-4.03307,8.85272,-19.0224> ,0.0864}
texture{txttree matrix <0.952939,0.303163,0,-0.173106,0.544129,-0.82095,-0.248881,0.782315,0.571001,-4.03307,8.85272,-19.0224> }}
union{cone{<-4.8511,3.68732,-5.01401> ,0.1296,<-4.78684,4.79117,-8.21531> ,0.12096}
sphere{<-4.8511,3.68732,-5.01401> ,0.1296}
texture{txttree matrix <0.99831,-0.0581124,0,0.0189721,0.32592,-0.945207,0.0549283,0.94361,0.326472,-4.8511,3.68732,-5.01401> }}
union{cone{<-4.78684,4.79117,-8.21531> ,0.12096,<-5.47745,5.99601,-11.2694> ,0.11232}
sphere{<-4.78684,4.79117,-8.21531> ,0.12096}
texture{txttree matrix <0.867583,0.497293,0,-0.205846,0.359121,-0.910308,-0.452689,0.789767,0.413933,-4.78684,4.79117,-8.21531> }}
union{cone{<-5.47745,5.99601,-11.2694> ,0.11232,<-6.94568,7.34894,-13.7213> ,0.10368}
sphere{<-5.47745,5.99601,-11.2694> ,0.11232}
texture{txttree matrix <0.677643,0.735391,0,-0.464338,0.427875,-0.775444,-0.570254,0.525474,0.631417,-5.47745,5.99601,-11.2694> }}
union{cone{<-6.94568,7.34894,-13.7213> ,0.10368,<-8.36594,7.9372,-16.6614> ,0.09504}
sphere{<-6.94568,7.34894,-13.7213> ,0.10368}
texture{txttree matrix <0.382669,0.923886,0,-0.428083,0.17731,-0.886175,-0.818724,0.339112,0.463351,-6.94568,7.34894,-13.7213> }}
union{cone{<-8.36594,7.9372,-16.6614> ,0.09504,<-8.55359,9.4973,-19.5213> ,0.0864}
sphere{<-8.36594,7.9372,-16.6614> ,0.09504}
texture{txttree matrix <0.992844,0.119418,0,-0.0575052,0.478099,-0.876421,-0.104661,0.87015,0.481545,-8.36594,7.9372,-16.6614> }}
union{cone{<-8.55359,9.4973,-19.5213> ,0.0864,<-9.33021,11.3615,-21.9169> ,0.07776}
sphere{<-8.55359,9.4973,-19.5213> ,0.0864}
texture{txttree matrix <0.9231,0.38456,0,-0.247864,0.594974,-0.764571,-0.294023,0.705776,0.644539,-8.55359,9.4973,-19.5213> }}
union{cone{<-0.976643,1.73827,0.0289667> ,0.216,<-2.196,1.67616,-1.11758> ,0.203657}
sphere{<-0.976643,1.73827,0.0289667> ,0.216}
texture{txttree matrix <-0.0508665,0.998705,0,-0.728023,-0.03708,-0.684549,-0.683663,-0.0348206,0.728967,-0.976643,1.73827,0.0289667> }}
union{cone{<-2.196,1.67616,-1.11758> ,0.203657,<-3.24045,1.68893,-2.61143> ,0.191314}
sphere{<-2.196,1.67616,-1.11758> ,0.203657}
texture{txttree matrix <0.0122264,0.999925,0,-0.572987,0.00700609,-0.819534,-0.819473,0.0100199,0.57303,-2.196,1.67616,-1.11758> }}
union{cone{<-3.24045,1.68893,-2.61143> ,0.191314,<-3.95131,1.91591,-4.18576> ,0.178971}
sphere{<-3.24045,1.68893,-2.61143> ,0.191314}
texture{txttree matrix <0.304174,0.952617,0,-0.408019,0.130282,-0.90363,-0.860813,0.274861,0.428314,-3.24045,1.68893,-2.61143> }}
union{cone{<-3.95131,1.91591,-4.18576> ,0.178971,<-4.59852,1.53875,-5.81651> ,0.166629}
sphere{<-3.95131,1.91591,-4.18576> ,0.178971}
texture{txttree matrix <-0.5035,0.863995,0,-0.360648,-0.21017,-0.908714,-0.785125,-0.457538,0.417419,-3.95131,1.91591,-4.18576> }}
union{cone{<-4.59852,1.53875,-5.81651> ,0.166629,<-5.3765,1.14896,-7.40902> ,0.154286}
sphere{<-4.59852,1.53875,-5.81651> ,0.166629}
texture{txttree matrix <-0.447939,0.894064,0,-0.428704,-0.214787,-0.877542,-0.784578,-0.393086,0.4795,-4.59852,1.53875,-5.81651> }}
union{cone{<-5.3765,1.14896,-7.40902> ,0.154286,<-5.98235,0.823559,-8.98249> ,0.141943}
sphere{<-5.3765,1.14896,-7.40902> ,0.154286}
texture{txttree matrix <-0.473172,0.88097,0,-0.352815,-0.189498,-0.916304,-0.807236,-0.433569,0.400485,-5.3765,1.14896,-7.40902> }}
union{cone{<-5.98235,0.823559,-8.98249> ,0.141943,<-6.8476,0.645889,-10.5764> ,0.1296}
sphere{<-5.98235,0.823559,-8.98249> ,0.141943}
texture{txttree matrix <-0.201145,0.979561,0,-0.474809,-0.0974983,-0.874672,-0.856795,-0.175936,0.484715,-5.98235,0.823559,-8.98249> }}
union{cone{<-6.8476,0.645889,-10.5764> ,0.1296,<-9.3163,0.5,-12.2626> ,0.12096}
sphere{<-6.8476,0.645889,-10.5764> ,0.1296}
texture{txttree matrix <-0.0589924,0.998258,0,-0.824776,-0.0487404,-0.563354,-0.562373,-0.0332336,0.826215,-6.8476,0.645889,-10.5764> }}
union{cone{<-9.3163,0.5,-12.2626> ,0.12096,<-11.9697,0.9741,-13.9597> ,0.11232}
sphere{<-9.3163,0.5,-12.2626> ,0.12096}
texture{txttree matrix <0.17589,0.98441,0,-0.833054,0.148846,-0.532791,-0.524484,0.0937125,0.846247,-9.3163,0.5,-12.2626> }}
union{cone{<-11.9697,0.9741,-13.9597> ,0.11232,<-14.5272,1.13585,-16.2456> ,0.10368}
sphere{<-11.9697,0.9741,-13.9597> ,0.11232}
texture{txttree matrix <0.0631214,0.998006,0,-0.744751,0.0471037,-0.665678,-0.664351,0.0420186,0.746239,-11.9697,0.9741,-13.9597> }}
union{cone{<-14.5272,1.13585,-16.2456> ,0.10368,<-15.528,1.87903,-19.1273> ,0.09504}
sphere{<-14.5272,1.13585,-16.2456> ,0.10368}
texture{txttree matrix <0.596157,0.802868,0,-0.318769,0.236697,-0.917802,-0.736874,0.547155,0.397038,-14.5272,1.13585,-16.2456> }}
union{cone{<-15.528,1.87903,-19.1273> ,0.09504,<-16.7626,1.99157,-22.1307> ,0.0864}
sphere{<-15.528,1.87903,-19.1273> ,0.09504}
texture{txttree matrix <0.0907731,0.995872,0,-0.37997,0.0346341,-0.92435,-0.920534,0.0839062,0.381545,-15.528,1.87903,-19.1273> }}
union{cone{<-16.7626,1.99157,-22.1307> ,0.0864,<-18.1939,3.68053,-24.48> ,0.07776}
sphere{<-16.7626,1.99157,-22.1307> ,0.0864}
texture{txttree matrix <0.762909,0.646506,0,-0.44338,0.52321,-0.727781,-0.470515,0.55523,0.68581,-16.7626,1.99157,-22.1307> }}
union{cone{<-4.8203,1.42763,-6.27048> ,0.1296,<-6.49444,0.91487,-8.84499> ,0.12096}
sphere{<-4.8203,1.42763,-6.27048> ,0.1296}
texture{txttree matrix <-0.292855,0.956157,0,-0.537708,-0.164691,-0.82689,-0.790636,-0.242159,0.562364,-4.8203,1.42763,-6.27048> }}
union{cone{<-6.49444,0.91487,-8.84499> ,0.12096,<-9.20537,1.35111,-10.62> ,0.11232}
sphere{<-6.49444,0.91487,-8.84499> ,0.12096}
texture{txttree matrix <0.158875,0.987299,0,-0.82914,0.133424,-0.542886,-0.535991,0.086251,0.839806,-6.49444,0.91487,-8.84499> }}
union{cone{<-9.20537,1.35111,-10.62> ,0.11232,<-10.2571,1.53754,-13.6203> ,0.10368}
sphere{<-9.20537,1.35111,-10.62> ,0.11232}
texture{txttree matrix <0.174529,0.984652,0,-0.330246,0.0585358,-0.942078,-0.927619,0.16442,0.335393,-9.20537,1.35111,-10.62> }}
union{cone{<-10.2571,1.53754,-13.6203> ,0.10368,<-12.4749,1.961,-16.1028> ,0.09504}
sphere{<-10.2571,1.53754,-13.6203> ,0.10368}
texture{txttree matrix <0.18755,0.982255,0,-0.660917,0.126194,-0.739773,-0.726646,0.138744,0.672857,-10.2571,1.53754,-13.6203> }}
union{cone{<-12.4749,1.961,-16.1028> ,0.09504,<-14.1947,3.307,-18.6384> ,0.0864}
sphere{<-12.4749,1.961,-16.1028> ,0.09504}
texture{txttree matrix <0.616343,0.787478,0,-0.513895,0.402215,-0.757717,-0.596685,0.467013,0.652584,-12.4749,1.961,-16.1028> }}
union{cone{<-14.1947,3.307,-18.6384> ,0.0864,<-15.4775,4.90567,-21.2816> ,0.07776}
sphere{<-14.1947,3.307,-18.6384> ,0.0864}
texture{txttree matrix <0.779932,0.625865,0,-0.383541,0.477956,-0.790224,-0.494573,0.616321,0.612818,-14.1947,3.307,-18.6384> }}
union{cone{<-3.84338,1.88145,-3.94673> ,0.1296,<-5.25917,1.11149,-6.88745> ,0.12096}
sphere{<-3.84338,1.88145,-3.94673> ,0.1296}
texture{txttree matrix <-0.477761,0.87849,0,-0.422197,-0.229609,-0.876943,-0.770386,-0.418969,0.480594,-3.84338,1.88145,-3.94673> }}
union{cone{<-5.25917,1.11149,-6.88745> ,0.12096,<-5.48453,0.89174,-10.1944> ,0.11232}
sphere{<-5.25917,1.11149,-6.88745> ,0.12096}
texture{txttree matrix <-0.698122,0.715979,0,-0.0678423,-0.0661503,-0.995501,-0.712757,-0.694981,0.0947546,-5.25917,1.11149,-6.88745> }}
union{cone{<-5.48453,0.89174,-10.1944> ,0.11232,<-6.56727,0.849219,-13.2791> ,0.10368}
sphere{<-5.48453,0.89174,-10.1944> ,0.11232}
texture{txttree matrix <-0.0392413,0.99923,0,-0.331166,-0.0130054,-0.943483,-0.942756,-0.0370235,0.331421,-5.48453,0.89174,-10.1944> }}
union{cone{<-6.56727,0.849219,-13.2791> ,0.10368,<-7.85576,1.82416,-16.0773> ,0.09504}
sphere{<-6.56727,0.849219,-13.2791> ,0.10368}
texture{txttree matrix <0.603391,0.797445,0,-0.398768,0.301729,-0.865993,-0.690582,0.522532,0.500056,-6.56727,0.849219,-13.2791> }}
union{cone{<-7.85576,1.82416,-16.0773> ,0.09504,<-9.19102,2.64863,-19.0879> ,0.0864}
sphere{<-7.85576,1.82416,-16.0773> ,0.09504}
texture{txttree matrix <0.525378,0.850869,0,-0.393293,0.242843,-0.886763,-0.754519,0.465885,0.462225,-7.85576,1.82416,-16.0773> }}
union{cone{<-9.19102,2.64863,-19.0879> ,0.0864,<-10.3133,3.8012,-21.9309> ,0.07776}
sphere{<-9.19102,2.64863,-19.0879> ,0.0864}
texture{txttree matrix <0.716464,0.697624,0,-0.34356,0.352838,-0.870328,-0.607162,0.623559,0.492472,-9.19102,2.64863,-19.0879> }}
union{cone{<-1.28041,1.72279,-0.256658> ,0.1296,<-2.9612,0.5,-2.81276> ,0.12096}
sphere{<-1.28041,1.72279,-0.256658> ,0.1296}
texture{txttree matrix <-0.588297,0.808645,0,-0.510177,-0.371158,-0.775862,-0.627397,-0.456437,0.630903,-1.28041,1.72279,-0.256658> }}
union{cone{<-2.9612,0.5,-2.81276> ,0.12096,<-4.33033,0.618884,-5.8539> ,0.11232}
sphere{<-2.9612,0.5,-2.81276> ,0.12096}
texture{txttree matrix <0.0865065,0.996251,0,-0.410257,0.0356235,-0.911274,-0.907858,0.0788311,0.411801,-2.9612,0.5,-2.81276> }}
union{cone{<-4.33033,0.618884,-5.8539> ,0.11232,<-6.43634,0.763537,-8.19111> ,0.10368}
sphere{<-4.33033,0.618884,-5.8539> ,0.11232}
texture{txttree matrix <0.0685246,0.997649,0,-0.6687,0.0459304,-0.742112,-0.740368,0.0508529,0.670276,-4.33033,0.618884,-5.8539> }}
union{cone{<-6.43634,0.763537,-8.19111> ,0.10368,<-9.01525,0.943292,-10.2079> ,0.09504}
sphere{<-6.43634,0.763537,-8.19111> ,0.10368}
texture{txttree matrix <0.069533,0.99758,0,-0.786547,0.0548237,-0.615091,-0.613603,0.0427692,0.788456,-6.43634,0.763537,-8.19111> }}
union{cone{<-9.01525,0.943292,-10.2079> ,0.09504,<-11.1684,0.778162,-12.5915> ,0.0864}
sphere{<-9.01525,0.943292,-10.2079> ,0.09504}
texture{txttree matrix <-0.0764672,0.997072,0,-0.669435,-0.0513401,-0.741095,-0.738925,-0.0566694,0.671401,-9.01525,0.943292,-10.2079> }}
union{cone{<-11.1684,0.778162,-12.5915> ,0.0864,<-12.335,2.00087,-15.4677> ,0.07776}
sphere{<-11.1684,0.778162,-12.5915> ,0.0864}
texture{txttree matrix <0.723521,0.690302,0,-0.349697,0.366526,-0.86219,-0.595171,0.623812,0.506586,-11.1684,0.778162,-12.5915> }}
union{cone{<-3.13445,1.67995,0.384483> ,0.36,<-3.23506,1.13551,-0.344129> ,0.342}
sphere{<-3.13445,1.67995,0.384483> ,0.36}
texture{txttree matrix <-0.983352,0.181713,0,-0.109941,-0.594953,-0.796206,-0.144681,-0.78295,0.605026,-3.13445,1.67995,0.384483> }}
union{cone{<-3.23506,1.13551,-0.344129> ,0.342,<-3.62124,1.03137,-1.19815> ,0.324}
sphere{<-3.23506,1.13551,-0.344129> ,0.342}
texture{txttree matrix <-0.260352,0.965514,0,-0.409501,-0.110423,-0.905602,-0.874371,-0.235775,0.424128,-3.23506,1.13551,-0.344129> }}
union{cone{<-3.62124,1.03137,-1.19815> ,0.324,<-4.00006,1.13267,-2.06836> ,0.306}
sphere{<-3.62124,1.03137,-1.19815> ,0.324}
texture{txttree matrix <0.258332,0.966056,0,-0.396889,0.106132,-0.91171,-0.880763,0.235524,0.410835,-3.62124,1.03137,-1.19815> }}
union{cone{<-4.00006,1.13267,-2.06836> ,0.306,<-4.44383,0.931529,-2.88588> ,0.288}
sphere{<-4.00006,1.13267,-2.06836> ,0.306}
texture{txttree matrix <-0.412837,0.910805,0,-0.466295,-0.211356,-0.859009,-0.78239,-0.354631,0.51196,-4.00006,1.13267,-2.06836> }}
union{cone{<-4.44383,0.931529,-2.88588> ,0.288,<-4.42473,0.737487,-3.84419> ,0.27}
sphere{<-4.44383,0.931529,-2.88588> ,0.288}
texture{txttree matrix <-0.99519,-0.0979667,0,0.0195323,-0.198418,-0.979923,0.0959998,-0.975209,0.199377,-4.44383,0.931529,-2.88588> }}
union{cone{<-4.42473,0.737487,-3.84419> ,0.27,<-4.71099,0.942278,-4.73444> ,0.252}
sphere{<-4.42473,0.737487,-3.84419> ,0.27}
texture{txttree matrix <0.581847,0.813299,0,-0.299023,0.213926,-0.929958,-0.756333,0.541093,0.367667,-4.42473,0.737487,-3.84419> }}
union{cone{<-4.71099,0.942278,-4.73444> ,0.252,<-5.15,0.911015,-5.55161> ,0.234}
sphere{<-4.71099,0.942278,-4.73444> ,0.252}
texture{txttree matrix <-0.0710328,0.997474,0,-0.472997,-0.0336834,-0.88042,-0.878196,-0.0625387,0.474195,-4.71099,0.942278,-4.73444> }}
union{cone{<-5.15,0.911015,-5.55161> ,0.234,<-5.31419,0.850003,-6.5238> ,0.216}
sphere{<-5.15,0.911015,-5.55161> ,0.234}
texture{txttree matrix <-0.348331,0.937372,0,-0.166206,-0.0617627,-0.984155,-0.922519,-0.342812,0.17731,-5.15,0.911015,-5.55161> }}
union{cone{<-5.31419,0.850003,-6.5238> ,0.216,<-6.67114,0.5,-7.35028> ,0.203657}
sphere{<-5.31419,0.850003,-6.5238> ,0.216}
texture{txttree matrix <-0.24976,0.968308,0,-0.834058,-0.215132,-0.508002,-0.491902,-0.126878,0.861356,-5.31419,0.850003,-6.5238> }}
union{cone{<-6.67114,0.5,-7.35028> ,0.203657,<-7.7425,0.542921,-8.4055> ,0.191314}
sphere{<-6.67114,0.5,-7.35028> ,0.203657}
texture{txttree matrix <0.04003,0.999198,0,-0.712163,0.0285308,-0.701434,-0.700872,0.0280784,0.712735,-6.67114,0.5,-7.35028> }}
union{cone{<-7.7425,0.542921,-8.4055> ,0.191314,<-9.05493,1.00973,-9.58651> ,0.178971}
sphere{<-7.7425,0.542921,-8.4055> ,0.191314}
texture{txttree matrix <0.335119,0.942176,0,-0.718648,0.255613,-0.646689,-0.609295,0.216718,0.762753,-7.7425,0.542921,-8.4055> }}
union{cone{<-9.05493,1.00973,-9.58651> ,0.178971,<-9.90778,1.47279,-11.1434> ,0.166629}
sphere{<-9.05493,1.00973,-9.58651> ,0.178971}
texture{txttree matrix <0.477157,0.878818,0,-0.464883,0.25241,-0.84863,-0.745791,0.40493,0.528987,-9.05493,1.00973,-9.58651> }}
union{cone{<-9.90778,1.47279,-11.1434> ,0.166629,<-10.9357,1.31583,-12.5575> ,0.154286}
sphere{<-9.90778,1.47279,-11.1434> ,0.166629}
texture{txttree matrix <-0.15095,0.988541,0,-0.585611,-0.0894229,-0.805645,-0.796413,-0.121612,0.592399,-9.90778,1.47279,-11.1434> }}
union{cone{<-10.9357,1.31583,-12.5575> ,0.154286,<-11.9052,1.44304,-14.1007> ,0.141943}
sphere{<-10.9357,1.31583,-12.5575> ,0.154286}
texture{txttree matrix <0.130093,0.991502,0,-0.530701,0.0696322,-0.844694,-0.837516,0.109889,0.535249,-10.9357,1.31583,-12.5575> }}
union{cone{<-11.9052,1.44304,-14.1007> ,0.141943,<-12.9097,2.08906,-15.4397> ,0.1296}
sphere{<-11.9052,1.44304,-14.1007> ,0.141943}
texture{txttree matrix <0.540936,0.841064,0,-0.55982,0.360052,-0.7463,-0.627686,0.4037,0.66561,-11.9052,1.44304,-14.1007> }}
union{cone{<-12.9097,2.08906,-15.4397> ,0.1296,<-15.323,3.38624,-17.4974> ,0.12096}
sphere{<-12.9097,2.08906,-15.4397> ,0.1296}
texture{txttree matrix <0.473452,0.88082,0,-0.704315,0.378578,-0.600516,-0.528946,0.284315,0.799613,-12.9097,2.08906,-15.4397> }}
union{cone{<-15.323,3.38624,-17.4974> ,0.12096,<-17.9019,5.55347,-17.9314> ,0.11232}
sphere{<-15.323,3.38624,-17.4974> ,0.12096}
texture{txttree matrix <0.64336,0.765564,0,-0.759287,0.638085,-0.127792,-0.0978331,0.0822164,0.991801,-15.323,3.38624,-17.4974> }}
union{cone{<-17.9019,5.55347,-17.9314> ,0.11232,<-19.239,7.10234,-20.3366> ,0.10368}
sphere{<-17.9019,5.55347,-17.9314> ,0.11232}
texture{txttree matrix <0.756954,0.653469,0,-0.423435,0.490491,-0.761657,-0.497719,0.576539,0.64798,-17.9019,5.55347,-17.9314> }}
union{cone{<-19.239,7.10234,-20.3366> ,0.10368,<-21.2499,8.43733,-22.4232> ,0.09504}
sphere{<-19.239,7.10234,-20.3366> ,0.10368}
texture{txttree matrix <0.553085,0.833125,0,-0.63026,0.418409,-0.653992,-0.544857,0.361713,0.756501,-19.239,7.10234,-20.3366> }}
union{cone{<-21.2499,8.43733,-22.4232> ,0.09504,<-23.4591,9.97084,-24.5692> ,0.0864}
sphere{<-21.2499,8.43733,-22.4232> ,0.09504}
texture{txttree matrix <0.570243,0.821476,0,-0.642093,0.445721,-0.623738,-0.512385,0.355682,0.781634,-21.2499,8.43733,-22.4232> }}
union{cone{<-23.4591,9.97084,-24.5692> ,0.0864,<-25.4611,12.2866,-25.9862> ,0.07776}
sphere{<-23.4591,9.97084,-24.5692> ,0.0864}
texture{txttree matrix <0.756479,0.654018,0,-0.59352,0.686503,-0.420058,-0.274725,0.317765,0.907497,-23.4591,9.97084,-24.5692> }}
union{cone{<-12.7216,1.96811,-15.189> ,0.1296,<-12.6747,4.11118,-17.7824> ,0.12096}
sphere{<-12.7216,1.96811,-15.189> ,0.1296}
texture{txttree matrix <0.99976,-0.0219086,0,0.0139579,0.636941,-0.770786,0.0168869,0.770601,0.637094,-12.7216,1.96811,-15.189> }}
union{cone{<-12.6747,4.11118,-17.7824> ,0.12096,<-12.8934,5.90961,-20.4625> ,0.11232}
sphere{<-12.6747,4.11118,-17.7824> ,0.12096}
texture{txttree matrix <0.992686,0.120723,0,-0.067609,0.555939,-0.828469,-0.100015,0.82241,0.560035,-12.6747,4.11118,-17.7824> }}
union{cone{<-12.8934,5.90961,-20.4625> ,0.11232,<-13.8836,6.82437,-23.4367> ,0.10368}
sphere{<-12.8934,5.90961,-20.4625> ,0.11232}
texture{txttree matrix <0.678574,0.734532,0,-0.303233,0.280132,-0.910811,-0.669019,0.618052,0.412825,-12.8934,5.90961,-20.4625> }}
union{cone{<-13.8836,6.82437,-23.4367> ,0.10368,<-14.0127,8.01353,-26.4134> ,0.09504}
sphere{<-13.8836,6.82437,-23.4367> ,0.10368}
texture{txttree matrix <0.994153,0.10798,0,-0.040262,0.370685,-0.927885,-0.100193,0.92246,0.372865,-13.8836,6.82437,-23.4367> }}
union{cone{<-14.0127,8.01353,-26.4134> ,0.09504,<-15.0393,9.61857,-28.9097> ,0.0864}
sphere{<-14.0127,8.01353,-26.4134> ,0.09504}
texture{txttree matrix <0.842426,0.538812,0,-0.326903,0.511109,-0.794922,-0.428314,0.669663,0.606711,-14.0127,8.01353,-26.4134> }}
union{cone{<-15.0393,9.61857,-28.9097> ,0.0864,<-15.7549,11.3287,-31.5999> ,0.07776}
sphere{<-15.0393,9.61857,-28.9097> ,0.0864}
texture{txttree matrix <0.922502,0.385992,0,-0.219023,0.523455,-0.823422,-0.317834,0.759608,0.56743,-15.0393,9.61857,-28.9097> }}
union{cone{<-12.4502,1.79351,-14.8271> ,0.1296,<-13.4374,3.16328,-17.5635> ,0.12096}
sphere{<-12.4502,1.79351,-14.8271> ,0.1296}
texture{txttree matrix <0.811266,0.584677,0,-0.30702,0.426004,-0.851034,-0.49758,0.690415,0.525111,-12.4502,1.79351,-14.8271> }}
union{cone{<-13.4374,3.16328,-17.5635> ,0.12096,<-14.6838,4.57405,-20.393> ,0.11232}
sphere{<-13.4374,3.16328,-17.5635> ,0.12096}
texture{txttree matrix <0.749402,0.662115,0,-0.366766,0.415117,-0.832563,-0.551252,0.623924,0.553931,-13.4374,3.16328,-17.5635> }}
union{cone{<-14.6838,4.57405,-20.393> ,0.11232,<-14.9455,5.42642,-23.517> ,0.10368}
sphere{<-14.6838,4.57405,-20.393> ,0.11232}
texture{txttree matrix <0.955969,0.293467,0,-0.0805437,0.262371,-0.9616,-0.282198,0.91926,0.274455,-14.6838,4.57405,-20.393> }}
union{cone{<-14.9455,5.42642,-23.517> ,0.10368,<-15.1781,6.3868,-26.5712> ,0.09504}
sphere{<-14.9455,5.42642,-23.517> ,0.10368}
texture{txttree matrix <0.971898,0.235401,0,-0.0724627,0.299176,-0.951443,-0.223971,0.924705,0.307826,-14.9455,5.42642,-23.517> }}
union{cone{<-15.1781,6.3868,-26.5712> ,0.09504,<-16.1299,6.87496,-29.6828> ,0.0864}
sphere{<-15.1781,6.3868,-26.5712> ,0.09504}
texture{txttree matrix <0.45636,0.889795,0,-0.289273,0.148363,-0.94568,-0.841461,0.431571,0.3251,-15.1781,6.3868,-26.5712> }}
union{cone{<-16.1299,6.87496,-29.6828> ,0.0864,<-17.1576,8.02229,-32.7097> ,0.07776}
sphere{<-16.1299,6.87496,-29.6828> ,0.0864}
texture{txttree matrix <0.744854,0.667228,0,-0.302613,0.337819,-0.891237,-0.594658,0.663841,0.453538,-16.1299,6.87496,-29.6828> }}
union{cone{<-9.16924,1.0718,-9.79518> ,0.1296,<-11.963,1.73935,-11.6012> ,0.12096}
sphere{<-9.16924,1.0718,-9.79518> ,0.1296}
texture{txttree matrix <0.232403,0.972619,0,-0.823384,0.196744,-0.532288,-0.517714,0.123706,0.846563,-9.16924,1.0718,-9.79518> }}
union{cone{<-11.963,1.73935,-11.6012> ,0.12096,<-12.7448,1.82956,-14.6332> ,0.11232}
sphere{<-11.963,1.73935,-11.6012> ,0.12096}
texture{txttree matrix <0.114623,0.993409,0,-0.249572,0.0287965,-0.967928,-0.961548,0.110947,0.251228,-11.963,1.73935,-11.6012> }}
union{cone{<-12.7448,1.82956,-14.6332> ,0.11232,<-14.2505,3.58324,-17.1292> ,0.10368}
sphere{<-12.7448,1.82956,-14.6332> ,0.11232}
texture{txttree matrix <0.758709,0.65143,0,-0.442618,0.515509,-0.733716,-0.477965,0.556677,0.679456,-12.7448,1.82956,-14.6332> }}
union{cone{<-14.2505,3.58324,-17.1292> ,0.10368,<-15.7121,3.81373,-20.0249> ,0.09504}
sphere{<-14.2505,3.58324,-17.1292> ,0.10368}
texture{txttree matrix <0.155766,0.987794,0,-0.449478,0.0708785,-0.890475,-0.879606,0.138706,0.455032,-14.2505,3.58324,-17.1292> }}
union{cone{<-15.7121,3.81373,-20.0249> ,0.09504,<-17.5163,4.19099,-22.5984> ,0.0864}
sphere{<-15.7121,3.81373,-20.0249> ,0.09504}
texture{txttree matrix <0.204678,0.978829,0,-0.569952,0.11918,-0.812989,-0.795777,0.166401,0.582279,-15.7121,3.81373,-20.0249> }}
union{cone{<-17.5163,4.19099,-22.5984> ,0.0864,<-19.2001,4.78064,-25.1849> ,0.07776}
sphere{<-17.5163,4.19099,-22.5984> ,0.0864}
texture{txttree matrix <0.330517,0.9438,0,-0.535876,0.187663,-0.823176,-0.776914,0.272074,0.567786,-17.5163,4.19099,-22.5984> }}
union{cone{<-5.20212,0.89165,-5.86018> ,0.216,<-5.39617,1.84248,-7.42654> ,0.203657}
sphere{<-5.20212,0.89165,-5.86018> ,0.216}
texture{txttree matrix <0.979802,0.19997,0,-0.105317,0.516024,-0.850075,-0.16999,0.832905,0.526662,-5.20212,0.89165,-5.86018> }}
union{cone{<-5.39617,1.84248,-7.42654> ,0.203657,<-4.86559,2.5297,-8.86475> ,0.191314}
sphere{<-5.39617,1.84248,-7.42654> ,0.203657}
texture{txttree matrix <0.791535,-0.611123,0,0.31583,0.409068,-0.856104,0.523185,0.677637,0.516803,-5.39617,1.84248,-7.42654> }}
union{cone{<-4.86559,2.5297,-8.86475> ,0.191314,<-4.53821,3.39818,-10.3255> ,0.178971}
sphere{<-4.86559,2.5297,-8.86475> ,0.191314}
texture{txttree matrix <0.935724,-0.352734,0,0.189167,0.501817,-0.844035,0.29772,0.789784,0.536288,-4.86559,2.5297,-8.86475> }}
union{cone{<-4.53821,3.39818,-10.3255> ,0.178971,<-3.86745,4.20741,-11.7768> ,0.166629}
sphere{<-4.53821,3.39818,-10.3255> ,0.178971}
texture{txttree matrix <0.769906,-0.638157,0,0.374318,0.451597,-0.809905,0.516846,0.623551,0.586562,-4.53821,3.39818,-10.3255> }}
union{cone{<-3.86745,4.20741,-11.7768> ,0.166629,<-3.66969,5.21905,-13.2715> ,0.154286}
sphere{<-3.86745,4.20741,-11.7768> ,0.166629}
texture{txttree matrix <0.981422,-0.191862,0,0.108924,0.55717,-0.823224,0.157946,0.80793,0.567717,-3.86745,4.20741,-11.7768> }}
union{cone{<-3.66969,5.21905,-13.2715> ,0.154286,<-3.6011,5.81237,-14.9337> ,0.141943}
sphere{<-3.66969,5.21905,-13.2715> ,0.154286}
texture{txttree matrix <0.993385,-0.114827,0,0.0388293,0.335918,-0.941091,0.108063,0.934866,0.338155,-3.66969,5.21905,-13.2715> }}
union{cone{<-3.6011,5.81237,-14.9337> ,0.141943,<-3.72308,6.7999,-16.2852> ,0.1296}
sphere{<-3.6011,5.81237,-14.9337> ,0.141943}
texture{txttree matrix <0.992458,0.122585,0,-0.0726819,0.588439,-0.805268,-0.0987138,0.799195,0.59291,-3.6011,5.81237,-14.9337> }}
union{cone{<-3.72308,6.7999,-16.2852> ,0.1296,<-3.6978,9.36254,-18.1726> ,0.12096}
sphere{<-3.72308,6.7999,-16.2852> ,0.1296}
texture{txttree matrix <0.999951,-0.00986483,0,0.00794306,0.80515,-0.593018,0.00585002,0.592989,0.805189,-3.72308,6.7999,-16.2852> }}
union{cone{<-3.6978,9.36254,-18.1726> ,0.12096,<-3.08251,12.3158,-19.7427> ,0.11232}
sphere{<-3.6978,9.36254,-18.1726> ,0.12096}
texture{txttree matrix <0.978979,-0.203962,0,0.180923,0.868394,-0.461691,0.0941677,0.451986,0.887041,-3.6978,9.36254,-18.1726> }}
union{cone{<-3.08251,12.3158,-19.7427> ,0.11232,<-3.88863,14.8953,-21.5595> ,0.10368}
sphere{<-3.08251,12.3158,-19.7427> ,0.11232}
texture{txttree matrix <0.954476,0.298289,0,-0.247553,0.792128,-0.557898,-0.166415,0.5325,0.829909,-3.08251,12.3158,-19.7427> }}
union{cone{<-3.88863,14.8953,-21.5595> ,0.10368,<-4.15322,16.9826,-23.9428> ,0.09504}
sphere{<-3.88863,14.8953,-21.5595> ,0.10368}
texture{txttree matrix <0.992062,0.125751,0,-0.0832252,0.65657,-0.74966,-0.0942708,0.743709,0.661823,-3.88863,14.8953,-21.5595> }}
union{cone{<-4.15322,16.9826,-23.9428> ,0.09504,<-4.99782,19.1848,-26.4475> ,0.0864}
sphere{<-4.15322,16.9826,-23.9428> ,0.09504}
texture{txttree matrix <0.933683,0.3581,0,-0.245497,0.640092,-0.72802,-0.260704,0.679741,0.685555,-4.15322,16.9826,-23.9428> }}
union{cone{<-4.99782,19.1848,-26.4475> ,0.0864,<-5.18781,21.9804,-27.9347> ,0.07776}
sphere{<-4.99782,19.1848,-26.4475> ,0.0864}
texture{txttree matrix <0.997699,0.0678035,0,-0.0598906,0.881263,-0.468816,-0.0317874,0.467737,0.883296,-4.99782,19.1848,-26.4475> }}
union{cone{<-5.15487,2.15503,-8.08064> ,0.1296,<-3.42104,3.68473,-10.3505> ,0.12096}
sphere{<-5.15487,2.15503,-8.08064> ,0.1296}
texture{txttree matrix <0.661586,-0.749869,0,0.535109,0.472109,-0.700551,0.525322,0.463474,0.713603,-5.15487,2.15503,-8.08064> }}
union{cone{<-3.42104,3.68473,-10.3505> ,0.12096,<-2.16674,4.76026,-13.2595> ,0.11232}
sphere{<-3.42104,3.68473,-10.3505> ,0.12096}
texture{txttree matrix <0.650937,-0.759131,0,0.37492,0.321486,-0.86953,0.660087,0.566009,0.493881,-3.42104,3.68473,-10.3505> }}
union{cone{<-2.16674,4.76026,-13.2595> ,0.11232,<-0.353158,5.35084,-15.9155> ,0.10368}
sphere{<-2.16674,4.76026,-13.2595> ,0.11232}
texture{txttree matrix <0.309641,-0.950854,0,0.55464,0.180616,-0.812251,0.772332,0.251506,0.583308,-2.16674,4.76026,-13.2595> }}
union{cone{<-0.353158,5.35084,-15.9155> ,0.10368,<0.726395,6.92962,-18.5697> ,0.09504}
sphere{<-0.353158,5.35084,-15.9155> ,0.10368}
texture{txttree matrix <0.825468,-0.564448,0,0.329984,0.48258,-0.811312,0.457944,0.669712,0.584614,-0.353158,5.35084,-15.9155> }}
union{cone{<0.726395,6.92962,-18.5697> ,0.09504,<2.62528,8.07525,-20.7837> ,0.0864}
sphere{<0.726395,6.92962,-18.5697> ,0.09504}
texture{txttree matrix <0.516582,-0.856238,0,0.605961,0.365587,-0.706511,0.604941,0.364971,0.707702,0.726395,6.92962,-18.5697> }}
union{cone{<2.62528,8.07525,-20.7837> ,0.0864,<4.05565,9.36305,-23.6223> ,0.07776}
sphere{<2.62528,8.07525,-20.7837> ,0.0864}
texture{txttree matrix <0.669101,-0.743171,0,0.417062,0.375495,-0.827685,0.615112,0.553806,0.561192,2.62528,8.07525,-20.7837> }}
union{cone{<-5.22995,1.02804,-6.08487> ,0.1296,<-4.47099,0.534851,-9.22265> ,0.12096}
sphere{<-5.22995,1.02804,-6.08487> ,0.1296}
texture{txttree matrix <-0.544881,-0.838513,0,0.232404,-0.151021,-0.960823,0.805663,-0.523535,0.277162,-5.22995,1.02804,-6.08487> }}
union{cone{<-4.47099,0.534851,-9.22265> ,0.12096,<-3.78424,2.43926,-11.7898> ,0.11232}
sphere{<-4.47099,0.534851,-9.22265> ,0.12096}
texture{txttree matrix <0.940705,-0.339226,0,0.210055,0.5825,-0.78522,0.266367,0.738661,0.619216,-4.47099,0.534851,-9.22265> }}
union{cone{<-3.78424,2.43926,-11.7898> ,0.11232,<-2.52664,3.52245,-14.4904> ,0.10368}
sphere{<-3.78424,2.43926,-11.7898> ,0.11232}
texture{txttree matrix <0.652613,-0.757692,0,0.396732,0.341712,-0.85196,0.645523,0.556,0.523606,-3.78424,2.43926,-11.7898> }}
union{cone{<-2.52664,3.52245,-14.4904> ,0.10368,<-2.47795,5.45933,-16.9654> ,0.09504}
sphere{<-2.52664,3.52245,-14.4904> ,0.10368}
texture{txttree matrix <0.999684,-0.0251335,0,0.0154929,0.616228,-0.787415,0.0197905,0.787167,0.616423,-2.52664,3.52245,-14.4904> }}
union{cone{<-2.47795,5.45933,-16.9654> ,0.09504,<-1.45097,6.9777,-19.5875> ,0.0864}
sphere{<-2.47795,5.45933,-16.9654> ,0.09504}
texture{txttree matrix <0.828321,-0.560254,0,0.321001,0.474592,-0.819586,0.459176,0.67888,0.572957,-2.47795,5.45933,-16.9654> }}
union{cone{<-1.45097,6.9777,-19.5875> ,0.0864,<-0.911876,7.91043,-22.623> ,0.07776}
sphere{<-1.45097,6.9777,-19.5875> ,0.0864}
texture{txttree matrix <0.865792,-0.500404,0,0.167365,0.289573,-0.94241,0.471586,0.815931,0.33446,-1.45097,6.9777,-19.5875> }}
union{cone{<-3.63183,5.54654,-14.189> ,0.1296,<-3.50094,5.17627,-17.3637> ,0.12096}
sphere{<-3.63183,5.54654,-14.189> ,0.1296}
texture{txttree matrix <-0.942824,-0.33329,0,0.0409171,-0.115748,-0.992435,0.330769,-0.935692,0.122767,-3.63183,5.54654,-14.189> }}
union{cone{<-3.50094,5.17627,-17.3637> ,0.12096,<-4.04212,6.43975,-20.3322> ,0.11232}
sphere{<-3.50094,5.17627,-17.3637> ,0.12096}
texture{txttree matrix <0.919226,0.39373,0,-0.165435,0.386235,-0.907444,-0.357288,0.834146,0.420174,-3.50094,5.17627,-17.3637> }}
union{cone{<-4.04212,6.43975,-20.3322> ,0.11232,<-4.1258,6.86629,-23.5911> ,0.10368}
sphere{<-4.04212,6.43975,-20.3322> ,0.11232}
texture{txttree matrix <0.981294,0.192515,0,-0.0254519,0.129735,-0.991222,-0.190825,0.97268,0.132208,-4.04212,6.43975,-20.3322> }}
union{cone{<-4.1258,6.86629,-23.5911> ,0.10368,<-5.5028,7.47096,-26.4685> ,0.09504}
sphere{<-4.1258,6.86629,-23.5911> ,0.10368}
texture{txttree matrix <0.402069,0.915609,0,-0.424124,0.186245,-0.886246,-0.811455,0.356332,0.463215,-4.1258,6.86629,-23.5911> }}
union{cone{<-5.5028,7.47096,-26.4685> ,0.09504,<-6.53366,8.63075,-29.1986> ,0.0864}
sphere{<-5.5028,7.47096,-26.4685> ,0.09504}
texture{txttree matrix <0.747428,0.664343,0,-0.328276,0.369332,-0.869384,-0.577569,0.649802,0.494137,-5.5028,7.47096,-26.4685> }}
union{cone{<-6.53366,8.63075,-29.1986> ,0.0864,<-7.32115,9.27011,-32.4001> ,0.07776}
sphere{<-6.53366,8.63075,-29.1986> ,0.0864}
texture{txttree matrix <0.630311,0.776343,0,-0.234482,0.190376,-0.953297,-0.740085,0.600874,0.302035,-6.53366,8.63075,-29.1986> }}
union{cone{<-4.06429,1.10356,-2.18668> ,0.216,<-4.0909,0.556416,-3.84352> ,0.203657}
sphere{<-4.06429,1.10356,-2.18668> ,0.216}
texture{txttree matrix <-0.998819,0.048577,0,-0.015249,-0.313543,-0.949452,-0.0461215,-0.948331,0.313913,-4.06429,1.10356,-2.18668> }}
union{cone{<-4.0909,0.556416,-3.84352> ,0.203657,<-4.28746,0.535233,-5.58657> ,0.191314}
sphere{<-4.0909,0.556416,-3.84352> ,0.203657}
texture{txttree matrix <-0.107141,0.994244,0,-0.112053,-0.0120749,-0.993629,-0.987909,-0.106458,0.112701,-4.0909,0.556416,-3.84352> }}
union{cone{<-4.28746,0.535233,-5.58657> ,0.191314,<-4.71753,0.527476,-7.23707> ,0.178971}
sphere{<-4.28746,0.535233,-5.58657> ,0.191314}
texture{txttree matrix <-0.0180354,0.999837,0,-0.252147,-0.00454831,-0.967678,-0.967521,-0.0174525,0.252188,-4.28746,0.535233,-5.58657> }}
union{cone{<-4.71753,0.527476,-7.23707> ,0.178971,<-5.23766,0.682454,-8.98257> ,0.166629}
sphere{<-4.71753,0.527476,-7.23707> ,0.178971}
texture{txttree matrix <0.285555,0.958362,0,-0.284546,0.0847837,-0.954906,-0.915146,0.272678,0.296909,-4.71753,0.527476,-7.23707> }}
union{cone{<-5.23766,0.682454,-8.98257> ,0.166629,<-4.93049,0.595558,-10.742> ,0.154286}
sphere{<-5.23766,0.682454,-8.98257> ,0.166629}
texture{txttree matrix <-0.27221,-0.962238,0,0.171778,-0.0485947,-0.983936,0.946781,-0.267838,0.178519,-5.23766,0.682454,-8.98257> }}
union{cone{<-4.93049,0.595558,-10.742> ,0.154286,<-5.05378,0.761446,-12.4624> ,0.141943}
sphere{<-4.93049,0.595558,-10.742> ,0.154286}
texture{txttree matrix <0.802607,0.596509,0,-0.0711538,0.0957379,-0.99286,-0.59225,0.796876,0.119284,-4.93049,0.595558,-10.742> }}
union{cone{<-5.05378,0.761446,-12.4624> ,0.141943,<-4.78243,1.4097,-13.9863> ,0.1296}
sphere{<-5.05378,0.761446,-12.4624> ,0.141943}
texture{txttree matrix <0.922446,-0.386126,0,0.161694,0.386283,-0.908097,0.350639,0.837671,0.41876,-5.05378,0.761446,-12.4624> }}
union{cone{<-4.78243,1.4097,-13.9863> ,0.1296,<-4.98353,3.36903,-16.5876> ,0.12096}
sphere{<-4.78243,1.4097,-13.9863> ,0.1296}
texture{txttree matrix <0.994774,0.102099,0,-0.0616331,0.600503,-0.797243,-0.081398,0.793077,0.603658,-4.78243,1.4097,-13.9863> }}
union{cone{<-4.98353,3.36903,-16.5876> ,0.12096,<-3.2766,5.43937,-18.1661> ,0.11232}
sphere{<-4.98353,3.36903,-16.5876> ,0.12096}
texture{txttree matrix <0.771574,-0.63614,0,0.5483,0.665033,-0.507048,0.322554,0.391225,0.861918,-4.98353,3.36903,-16.5876> }}
union{cone{<-3.2766,5.43937,-18.1661> ,0.11232,<-2.81797,7.34252,-20.985> ,0.10368}
sphere{<-3.2766,5.43937,-18.1661> ,0.11232}
texture{txttree matrix <0.97217,-0.234275,0,0.133633,0.554535,-0.821361,0.192424,0.798503,0.570409,-3.2766,5.43937,-18.1661> }}
union{cone{<-2.81797,7.34252,-20.985> ,0.10368,<-2.78391,9.74637,-23.4065> ,0.09504}
sphere{<-2.81797,7.34252,-20.985> ,0.10368}
texture{txttree matrix <0.9999,-0.0141672,0,0.00998151,0.704479,-0.709655,0.0100538,0.709584,0.704549,-2.81797,7.34252,-20.985> }}
union{cone{<-2.78391,9.74637,-23.4065> ,0.09504,<-1.66928,11.8629,-25.7115> ,0.0864}
sphere{<-2.78391,9.74637,-23.4065> ,0.09504}
texture{txttree matrix <0.884803,-0.465965,0,0.33554,0.637145,-0.693872,0.32332,0.613941,0.720098,-2.78391,9.74637,-23.4065> }}
union{cone{<-1.66928,11.8629,-25.7115> ,0.0864,<-0.99545,14.6541,-27.3991> ,0.07776}
sphere{<-1.66928,11.8629,-25.7115> ,0.0864}
texture{txttree matrix <0.972075,-0.23467,0,0.202315,0.838052,-0.506694,0.118906,0.492544,0.862126,-1.66928,11.8629,-25.7115> }}
union{cone{<-4.99219,0.613012,-10.3886> ,0.1296,<-6.80672,0.5,-13.2474> ,0.12096}
sphere{<-4.99219,0.613012,-10.3886> ,0.1296}
texture{txttree matrix <-0.0621612,0.998066,0,-0.535593,-0.0333576,-0.843817,-0.842185,-0.0524527,0.536631,-4.99219,0.613012,-10.3886> }}
union{cone{<-6.80672,0.5,-13.2474> ,0.12096,<-6.19079,0.62336,-16.4305> ,0.11232}
sphere{<-6.80672,0.5,-13.2474> ,0.12096}
texture{txttree matrix <0.196384,-0.980527,0,0.189836,0.0380211,-0.981079,0.961975,0.192669,0.193606,-6.80672,0.5,-13.2474> }}
union{cone{<-6.19079,0.62336,-16.4305> ,0.11232,<-7.33586,0.74619,-19.4717> ,0.10368}
sphere{<-6.19079,0.62336,-16.4305> ,0.11232}
texture{txttree matrix <0.106656,0.994296,0,-0.35212,0.0377711,-0.935192,-0.929858,0.0997438,0.35414,-6.19079,0.62336,-16.4305> }}
union{cone{<-7.33586,0.74619,-19.4717> ,0.10368,<-7.458,2.10424,-22.5226> ,0.09504}
sphere{<-7.33586,0.74619,-19.4717> ,0.10368}
texture{txttree matrix <0.99598,0.0895759,0,-0.0365494,0.406387,-0.91297,-0.08178,0.909299,0.408028,-7.33586,0.74619,-19.4717> }}
union{cone{<-7.458,2.10424,-22.5226> ,0.09504,<-8.41711,2.60305,-25.4893> ,0.0864}
sphere{<-7.458,2.10424,-22.5226> ,0.09504}
texture{txttree matrix <0.461407,0.887189,0,-0.303753,0.157975,-0.939563,-0.833569,0.433521,0.342377,-7.458,2.10424,-22.5226> }}
union{cone{<-8.41711,2.60305,-25.4893> ,0.0864,<-8.35415,2.80436,-28.8443> ,0.07776}
sphere{<-8.41711,2.60305,-25.4893> ,0.0864}
texture{txttree matrix <0.954412,-0.298494,0,0.0187289,0.0598842,-0.99803,0.297906,0.952531,0.0627446,-8.41711,2.60305,-25.4893> }}
union{cone{<-4.96071,0.636217,-11.1637> ,0.1296,<-5.40097,0.97728,-14.4695> ,0.12096}
sphere{<-4.96071,0.636217,-11.1637> ,0.1296}
texture{txttree matrix <0.612419,0.790534,0,-0.131324,0.101736,-0.986105,-0.779549,0.603909,0.166121,-4.96071,0.636217,-11.1637> }}
union{cone{<-5.40097,0.97728,-14.4695> ,0.12096,<-5.15803,0.569893,-17.5801> ,0.11232}
sphere{<-5.40097,0.97728,-14.4695> ,0.12096}
texture{txttree matrix <-0.85888,-0.512177,0,0.0772085,-0.129472,-0.988573,0.506325,-0.849065,0.150746,-5.40097,0.97728,-14.4695> }}
union{cone{<-5.15803,0.569893,-17.5801> ,0.11232,<-4.54766,0.705641,-20.8155> ,0.10368}
sphere{<-5.15803,0.569893,-17.5801> ,0.11232}
texture{txttree matrix <0.217099,-0.976149,0,0.185227,0.0411951,-0.981832,0.958415,0.213155,0.189752,-5.15803,0.569893,-17.5801> }}
union{cone{<-4.54766,0.705641,-20.8155> ,0.10368,<-3.83474,1.40073,-23.8048> ,0.09504}
sphere{<-4.54766,0.705641,-20.8155> ,0.10368}
texture{txttree matrix <0.698098,-0.716002,0,0.226269,0.220611,-0.948753,0.67931,0.662323,0.316017,-4.54766,0.705641,-20.8155> }}
union{cone{<-3.83474,1.40073,-23.8048> ,0.09504,<-3.53905,2.66646,-26.6926> ,0.0864}
sphere{<-3.83474,1.40073,-23.8048> ,0.09504}
texture{txttree matrix <0.973781,-0.227488,0,0.0933701,0.399679,-0.911888,0.207443,0.887979,0.41044,-3.83474,1.40073,-23.8048> }}
union{cone{<-3.53905,2.66646,-26.6926> ,0.0864,<-3.37927,3.6885,-29.6981> ,0.07776}
sphere{<-3.53905,2.66646,-26.6926> ,0.0864}
texture{txttree matrix <0.987999,-0.15446,0,0.0502694,0.321546,-0.945559,0.146051,0.934211,0.325452,-3.53905,2.66646,-26.6926> }}
union{cone{<-4.08716,0.633212,-3.61097> ,0.1296,<-2.92754,0.5,-6.05267> ,0.12096}
sphere{<-4.08716,0.633212,-3.61097> ,0.1296}
texture{txttree matrix <-0.114124,-0.993467,0,0.428482,-0.0492217,-0.902209,0.896314,-0.102964,0.4313,-4.08716,0.633212,-3.61097> }}
union{cone{<-2.92754,0.5,-6.05267> ,0.12096,<-0.784488,0.617585,-8.41569> ,0.11232}
sphere{<-2.92754,0.5,-6.05267> ,0.12096}
texture{txttree matrix <0.0547857,-0.998498,0,0.671333,0.0368348,-0.74024,0.739128,0.0405546,0.672343,-2.92754,0.5,-6.05267> }}
union{cone{<-0.784488,0.617585,-8.41569> ,0.11232,<-0.123497,0.795821,-11.4524> ,0.10368}
sphere{<-0.784488,0.617585,-8.41569> ,0.11232}
texture{txttree matrix <0.26035,-0.965514,0,0.212337,0.0572565,-0.975518,0.941876,0.253976,0.219921,-0.784488,0.617585,-8.41569> }}
union{cone{<-0.123497,0.795821,-11.4524> ,0.10368,<1.29592,1.58503,-14.4579> ,0.09504}
sphere{<-0.123497,0.795821,-11.4524> ,0.10368}
texture{txttree matrix <0.485947,-0.873988,0,0.415492,0.231018,-0.879771,0.76891,0.427522,0.475398,-0.123497,0.795821,-11.4524> }}
union{cone{<1.29592,1.58503,-14.4579> ,0.09504,<2.20786,1.35909,-17.5537> ,0.0864}
sphere{<1.29592,1.58503,-14.4579> ,0.09504}
texture{txttree matrix <-0.240487,-0.970652,0,0.281879,-0.0698379,-0.956905,0.928822,-0.230124,0.290402,1.29592,1.58503,-14.4579> }}
union{cone{<2.20786,1.35909,-17.5537> ,0.0864,<3.55754,1.43689,-20.3763> ,0.07776}
sphere{<2.20786,1.35909,-17.5537> ,0.0864}
texture{txttree matrix <0.0575482,-0.998343,0,0.431259,0.0248594,-0.901886,0.900391,0.0519019,0.431975,2.20786,1.35909,-17.5537> }}
union{cone{<-3.76091,1.06872,-1.51899> ,0.216,<-4.49217,0.5,-2.56546> ,0.203657}
sphere{<-3.76091,1.06872,-1.51899> ,0.216}
texture{txttree matrix <-0.613916,0.789371,0,-0.523226,-0.406928,-0.748762,-0.591051,-0.459677,0.662839,-3.76091,1.06872,-1.51899> }}
union{cone{<-4.49217,0.5,-2.56546> ,0.203657,<-5.28967,0.526543,-4.10963> ,0.191314}
sphere{<-4.49217,0.5,-2.56546> ,0.203657}
texture{txttree matrix <0.0332648,0.999447,0,-0.458823,0.0152711,-0.888396,-0.887905,0.0295523,0.459077,-4.49217,0.5,-2.56546> }}
union{cone{<-5.28967,0.526543,-4.10963> ,0.191314,<-6.45241,0.528702,-5.21039> ,0.178971}
sphere{<-5.28967,0.526543,-4.10963> ,0.191314}
texture{txttree matrix <0.00185663,0.999998,0,-0.726192,0.00134827,-0.68749,-0.687489,0.00127641,0.726193,-5.28967,0.526543,-4.10963> }}
union{cone{<-6.45241,0.528702,-5.21039> ,0.178971,<-7.2117,0.572772,-6.63266> ,0.166629}
sphere{<-6.45241,0.528702,-5.21039> ,0.178971}
texture{txttree matrix <0.0579431,0.99832,0,-0.470776,0.0273241,-0.88183,-0.880348,0.051096,0.471568,-6.45241,0.528702,-5.21039> }}
union{cone{<-7.2117,0.572772,-6.63266> ,0.166629,<-8.15557,0.546726,-8.08784> ,0.154286}
sphere{<-7.2117,0.572772,-6.63266> ,0.166629}
texture{txttree matrix <-0.027585,0.999619,0,-0.544115,-0.0150151,-0.838876,-0.838557,-0.0231404,0.544322,-7.2117,0.572772,-6.63266> }}
union{cone{<-8.15557,0.546726,-8.08784> ,0.154286,<-8.98706,1.1098,-9.60042> ,0.141943}
sphere{<-8.15557,0.546726,-8.08784> ,0.154286}
texture{txttree matrix <0.560717,0.828007,0,-0.457976,0.310136,-0.833111,-0.689822,0.467139,0.553106,-8.15557,0.546726,-8.08784> }}
union{cone{<-8.98706,1.1098,-9.60042> ,0.141943,<-10.0724,1.4066,-10.874> ,0.1296}
sphere{<-8.98706,1.1098,-9.60042> ,0.141943}
texture{txttree matrix <0.263769,0.964586,0,-0.638659,0.174643,-0.74941,-0.72287,0.197671,0.662107,-8.98706,1.1098,-9.60042> }}
union{cone{<-10.0724,1.4066,-10.874> ,0.1296,<-12.4512,3.10429,-12.1051> ,0.12096}
sphere{<-10.0724,1.4066,-10.874> ,0.1296}
texture{txttree matrix <0.58091,0.813968,0,-0.750129,0.53535,-0.388211,-0.315991,0.225515,0.921571,-10.0724,1.4066,-10.874> }}
union{cone{<-12.4512,3.10429,-12.1051> ,0.12096,<-15.4655,3.47537,-13.2993> ,0.11232}
sphere{<-12.4512,3.10429,-12.1051> ,0.12096}
texture{txttree matrix <0.122187,0.992507,0,-0.923658,0.113711,-0.365958,-0.363216,0.0447152,0.930631,-12.4512,3.10429,-12.1051> }}
union{cone{<-15.4655,3.47537,-13.2993> ,0.11232,<-17.1696,5.22672,-15.6549> ,0.10368}
sphere{<-15.4655,3.47537,-13.2993> ,0.11232}
texture{txttree matrix <0.716697,0.697385,0,-0.502088,0.515992,-0.694017,-0.483997,0.4974,0.719959,-15.4655,3.47537,-13.2993> }}
union{cone{<-17.1696,5.22672,-15.6549> ,0.10368,<-19.2072,7.25644,-16.861> ,0.09504}
sphere{<-17.1696,5.22672,-15.6549> ,0.10368}
texture{txttree matrix <0.705746,0.708465,0,-0.653345,0.650838,-0.386717,-0.273975,0.272924,0.922198,-17.1696,5.22672,-15.6549> }}
union{cone{<-19.2072,7.25644,-16.861> ,0.09504,<-21.4099,8.12308,-19.3447> ,0.0864}
sphere{<-19.2072,7.25644,-16.861> ,0.09504}
texture{txttree matrix <0.366123,0.930566,0,-0.641991,0.252586,-0.723912,-0.673648,0.265041,0.689892,-19.2072,7.25644,-16.861> }}
union{cone{<-21.4099,8.12308,-19.3447> ,0.0864,<-23.4758,10.3659,-20.9045> ,0.07776}
sphere{<-21.4099,8.12308,-19.3447> ,0.0864}
texture{txttree matrix <0.735524,0.677499,0,-0.603169,0.654828,-0.455399,-0.308532,0.334957,0.890287,-21.4099,8.12308,-19.3447> }}
union{cone{<-7.82416,0.555871,-7.5769> ,0.1296,<-10.4276,0.756483,-9.33065> ,0.12096}
sphere{<-7.82416,0.555871,-7.5769> ,0.1296}
texture{txttree matrix <0.07683,0.997044,0,-0.827683,0.0637794,-0.55756,-0.555912,0.0428373,0.830136,-7.82416,0.555871,-7.5769> }}
union{cone{<-10.4276,0.756483,-9.33065> ,0.12096,<-12.3756,0.985235,-11.8045> ,0.11232}
sphere{<-10.4276,0.756483,-9.33065> ,0.12096}
texture{txttree matrix <0.116626,0.993176,0,-0.617038,0.0724574,-0.783591,-0.778243,0.0913873,0.621278,-10.4276,0.756483,-9.33065> }}
union{cone{<-12.3756,0.985235,-11.8045> ,0.11232,<-14.5765,2.59348,-13.4929> ,0.10368}
sphere{<-12.3756,0.985235,-11.8045> ,0.11232}
texture{txttree matrix <0.589987,0.807412,0,-0.686411,0.50157,-0.526563,-0.425153,0.310665,0.850136,-12.3756,0.985235,-11.8045> }}
union{cone{<-14.5765,2.59348,-13.4929> ,0.10368,<-15.1926,4.30848,-16.2991> ,0.09504}
sphere{<-14.5765,2.59348,-13.4929> ,0.10368}
texture{txttree matrix <0.941114,0.338089,0,-0.184133,0.512557,-0.838678,-0.283548,0.789292,0.544628,-14.5765,2.59348,-13.4929> }}
union{cone{<-15.1926,4.30848,-16.2991> ,0.09504,<-16.6979,5.66689,-19.0743> ,0.0864}
sphere{<-15.1926,4.30848,-16.2991> ,0.09504}
texture{txttree matrix <0.669963,0.742394,0,-0.437961,0.395232,-0.807454,-0.599449,0.540964,0.589931,-15.1926,4.30848,-16.2991> }}
union{cone{<-16.6979,5.66689,-19.0743> ,0.0864,<-18.0781,7.25516,-21.6356> ,0.07776}
sphere{<-16.6979,5.66689,-19.0743> ,0.0864}
texture{txttree matrix <0.754819,0.655933,0,-0.416376,0.479147,-0.77269,-0.506833,0.583241,0.634784,-16.6979,5.66689,-19.0743> }}
union{cone{<-6.70974,0.543638,-5.69242> ,0.1296,<-7.81897,0.802381,-8.93796> ,0.12096}
sphere{<-6.70974,0.543638,-5.69242> ,0.1296}
texture{txttree matrix <0.227164,0.973856,0,-0.322488,0.0752244,-0.94358,-0.918911,0.214348,0.331145,-6.70974,0.543638,-5.69242> }}
union{cone{<-7.81897,0.802381,-8.93796> ,0.12096,<-7.56133,1.96806,-12.0362> ,0.11232}
sphere{<-7.81897,0.802381,-8.93796> ,0.12096}
texture{txttree matrix <0.976434,-0.215817,0,0.0775968,0.351075,-0.933126,0.201385,0.911136,0.359549,-7.81897,0.802381,-8.93796> }}
union{cone{<-7.56133,1.96806,-12.0362> ,0.11232,<-7.83868,2.74279,-15.1818> ,0.10368}
sphere{<-7.56133,1.96806,-12.0362> ,0.11232}
texture{txttree matrix <0.941489,0.337044,0,-0.0852994,0.238273,-0.967445,-0.326071,0.910839,0.253081,-7.56133,1.96806,-12.0362> }}
union{cone{<-7.83868,2.74279,-15.1818> ,0.10368,<-7.73567,3.37556,-18.3653> ,0.09504}
sphere{<-7.83868,2.74279,-15.1818> ,0.10368}
texture{txttree matrix <0.987008,-0.160673,0,0.0317196,0.194852,-0.98032,0.157511,0.967583,0.197417,-7.83868,2.74279,-15.1818> }}
union{cone{<-7.73567,3.37556,-18.3653> ,0.09504,<-7.51114,4.77688,-21.4116> ,0.0864}
sphere{<-7.73567,3.37556,-18.3653> ,0.09504}
texture{txttree matrix <0.987406,-0.158209,0,0.0668126,0.416987,-0.906454,0.143409,0.895037,0.422306,-7.73567,3.37556,-18.3653> }}
union{cone{<-7.51114,4.77688,-21.4116> ,0.0864,<-7.14812,5.9086,-24.5139> ,0.07776}
sphere{<-7.51114,4.77688,-21.4116> ,0.0864}
texture{txttree matrix <0.95221,-0.305445,0,0.109271,0.340647,-0.93382,0.28523,0.889192,0.357744,-7.51114,4.77688,-21.4116> }}
union{cone{<-3.80927,1.03111,-1.58819> ,0.1296,<-4.20761,0.779594,-4.9506> ,0.12096}
sphere{<-3.80927,1.03111,-1.58819> ,0.1296}
texture{txttree matrix <-0.533895,0.845551,0,-0.117323,-0.0740796,-0.990327,-0.837372,-0.528731,0.138753,-3.80927,1.03111,-1.58819> }}
union{cone{<-4.20761,0.779594,-4.9506> ,0.12096,<-3.81527,0.535461,-7.9272> ,0.11232}
sphere{<-4.20761,0.779594,-4.9506> ,0.12096}
texture{txttree matrix <-0.528322,-0.849044,0,0.130247,-0.0810465,-0.988164,0.838995,-0.522068,0.153404,-4.20761,0.779594,-4.9506> }}
union{cone{<-3.81527,0.535461,-7.9272> ,0.11232,<-4.98278,0.859983,-10.8786> ,0.10368}
sphere{<-3.81527,0.535461,-7.9272> ,0.11232}
texture{txttree matrix <0.267809,0.963472,0,-0.365938,0.101717,-0.925064,-0.891273,0.24774,0.379811,-3.81527,0.535461,-7.9272> }}
union{cone{<-4.98278,0.859983,-10.8786> ,0.10368,<-5.75873,1.64503,-13.8061> ,0.09504}
sphere{<-4.98278,0.859983,-10.8786> ,0.10368}
texture{txttree matrix <0.711215,0.702975,0,-0.248014,0.250921,-0.935697,-0.657771,0.665481,0.352806,-4.98278,0.859983,-10.8786> }}
union{cone{<-5.75873,1.64503,-13.8061> ,0.09504,<-6.52301,2.13662,-17.0152> ,0.0864}
sphere{<-5.75873,1.64503,-13.8061> ,0.09504}
texture{txttree matrix <0.540965,0.841045,0,-0.229145,0.147387,-0.962169,-0.809228,0.520499,0.272453,-5.75873,1.64503,-13.8061> }}
union{cone{<-6.52301,2.13662,-17.0152> ,0.0864,<-7.33359,2.57735,-20.3216> ,0.07776}
sphere{<-6.52301,2.13662,-17.0152> ,0.0864}
texture{txttree matrix <0.477677,0.878536,0,-0.236138,0.128393,-0.9632,-0.846205,0.460098,0.268786,-6.52301,2.13662,-17.0152> }}
union{cone{<-9.0237,1.11982,-9.64342> ,0.1296,<-11.9316,0.763302,-11.3288> ,0.12096}
sphere{<-9.0237,1.11982,-9.64342> ,0.1296}
texture{txttree matrix <-0.121693,0.992568,0,-0.860357,-0.105484,-0.498658,-0.494952,-0.0606833,0.866799,-9.0237,1.11982,-9.64342> }}
union{cone{<-11.9316,0.763302,-11.3288> ,0.12096,<-14.6089,0.599835,-12.9204> ,0.11232}
sphere{<-11.9316,0.763302,-11.3288> ,0.12096}
texture{txttree matrix <-0.0609428,0.998141,0,-0.858405,-0.052411,-0.510288,-0.509339,-0.0310984,0.860004,-11.9316,0.763302,-11.3288> }}
union{cone{<-14.6089,0.599835,-12.9204> ,0.11232,<-17.356,0.797286,-14.8894> ,0.10368}
sphere{<-14.6089,0.599835,-12.9204> ,0.11232}
texture{txttree matrix <0.0716902,0.997427,0,-0.8114,0.0583195,-0.581575,-0.580079,0.0416932,0.813493,-14.6089,0.599835,-12.9204> }}
union{cone{<-17.356,0.797286,-14.8894> ,0.10368,<-18.643,1.13139,-17.9291> ,0.09504}
sphere{<-17.356,0.797286,-14.8894> ,0.10368}
texture{txttree matrix <0.251288,0.967912,0,-0.387883,0.100702,-0.916191,-0.886792,0.230228,0.400742,-17.356,0.797286,-14.8894> }}
union{cone{<-18.643,1.13139,-17.9291> ,0.09504,<-21.093,1.19042,-20.2886> ,0.0864}
sphere{<-18.643,1.13139,-17.9291> ,0.09504}
texture{txttree matrix <0.0240845,0.99971,0,-0.720177,0.0173501,-0.693574,-0.693373,0.0167043,0.720385,-18.643,1.13139,-17.9291> }}
union{cone{<-21.093,1.19042,-20.2886> ,0.0864,<-22.8622,2.54119,-22.6702> ,0.07776}
sphere{<-21.093,1.19042,-20.2886> ,0.0864}
texture{txttree matrix <0.606833,0.794829,0,-0.542741,0.41437,-0.730568,-0.580677,0.443333,0.68284,-21.093,1.19042,-20.2886> }}
union{
union{cone{<0,0.5,0> ,0.6,<0.486156,0.408945,0.134128> ,0.533333}
sphere{<0,0.5,0> ,0.6}
texture{txttree matrix <-0.184094,-0.982909,0,0.948646,-0.177677,0.261726,-0.257253,0.0481823,0.965142,0,0.5,0> }}
union{cone{<0.486156,0.408945,0.134128> ,0.533333,<0.924803,0.0725445,0.134493> ,0.466667}
sphere{<0.486156,0.408945,0.134128> ,0.533333}
texture{txttree matrix <-0.608551,-0.793515,0,0.793515,-0.608551,0.000661213,-0.000524682,0.000402382,1,0.486156,0.408945,0.134128> }}
union{cone{<0.924803,0.0725445,0.134493> ,0.466667,<1.36874,-0.211237,-0.0183638> ,0.4}
sphere{<0.924803,0.0725445,0.134493> ,0.466667}
texture{txttree matrix <-0.538602,-0.842561,0,0.809195,-0.517273,-0.278626,0.234759,-0.150068,0.9604,0.924803,0.0725445,0.134493> }}
union{cone{<1.36874,-0.211237,-0.0183638> ,0.4,<1.87418,-0.323211,-0.217588> ,0.333333}
sphere{<1.36874,-0.211237,-0.0183638> ,0.4}
texture{txttree matrix <-0.21629,-0.976329,0,0.911189,-0.201859,-0.359148,0.350647,-0.0776801,0.933281,1.36874,-0.211237,-0.0183638> }}
union{cone{<1.87418,-0.323211,-0.217588> ,0.333333,<2.36179,-0.333518,-0.355569> ,0.266667}
sphere{<1.87418,-0.323211,-0.217588> ,0.333333}
texture{txttree matrix <-0.0211328,-0.999777,0,0.962017,-0.0203346,-0.27223,0.272169,-0.00575297,0.962232,1.87418,-0.323211,-0.217588> }}
union{cone{<2.36179,-0.333518,-0.355569> ,0.266667,<2.86517,-0.417759,-0.267477> ,0.2}
sphere{<2.36179,-0.333518,-0.355569> ,0.266667}
texture{txttree matrix <-0.165056,-0.986284,0,0.971913,-0.162651,0.170086,-0.167753,0.0280738,0.985429,2.36179,-0.333518,-0.355569> }}
union{cone{<2.86517,-0.417759,-0.267477> ,0.2,<3.34078,-0.501211,-0.1001> ,0.133333}
sphere{<2.86517,-0.417759,-0.267477> ,0.2}
texture{txttree matrix <-0.172821,-0.984953,0,0.930632,-0.16329,0.327506,-0.322578,0.0566,0.944849,2.86517,-0.417759,-0.267477> }}
union{cone{<3.34078,-0.501211,-0.1001> ,0.133333,<3.76812,-0.836445,-0.0686238> ,0.0666667}
sphere{<3.34078,-0.501211,-0.1001> ,0.133333}
texture{txttree matrix <-0.617221,-0.78679,0,0.785472,-0.616187,0.0578552,-0.0455199,0.0357094,0.998325,3.34078,-0.501211,-0.1001> }}
union{cone{<3.76812,-0.836445,-0.0686238> ,0.0666667,<4.25842,-1.03286,0.0928283> ,0}
sphere{<3.76812,-0.836445,-0.0686238> ,0.0666667}
texture{txttree matrix <-0.371876,-0.928282,0,0.887734,-0.355632,0.292325,-0.27136,0.108709,0.956319,3.76812,-0.836445,-0.0686238> }}
rotate y*-1.5912}
union{
union{cone{<0,0.5,0> ,0.6,<0.463904,0.278162,0.0875902> ,0.533333}
sphere{<0,0.5,0> ,0.6}
texture{txttree matrix <-0.43141,-0.902156,0,0.889346,-0.425284,0.167918,-0.151489,0.0724416,0.985801,0,0.5,0> }}
union{cone{<0.463904,0.278162,0.0875902> ,0.533333,<0.945515,0.142087,0.168785> ,0.466667}
sphere{<0.463904,0.278162,0.0875902> ,0.533333}
texture{txttree matrix <-0.271896,-0.962327,0,0.949906,-0.268387,0.160146,-0.154112,0.0435429,0.987093,0.463904,0.278162,0.0875902> }}
union{cone{<0.945515,0.142087,0.168785> ,0.466667,<1.42516,0.0644305,-0.0156272> ,0.4}
sphere{<0.945515,0.142087,0.168785> ,0.466667}
texture{txttree matrix <-0.159824,-0.987146,0,0.92291,-0.149423,-0.354838,0.350276,-0.0567114,0.934928,0.945515,0.142087,0.168785> }}
union{cone{<1.42516,0.0644305,-0.0156272> ,0.4,<1.87575,-0.130058,0.119381> ,0.333333}
sphere{<1.42516,0.0644305,-0.0156272> ,0.4}
texture{txttree matrix <-0.39629,-0.918125,0,0.88524,-0.382096,0.265241,-0.243525,0.105113,0.964182,1.42516,0.0644305,-0.0156272> }}
union{cone{<1.87575,-0.130058,0.119381> ,0.333333,<2.37761,-0.298641,0.260024> ,0.266667}
sphere{<1.87575,-0.130058,0.119381> ,0.333333}
texture{txttree matrix <-0.318429,-0.947947,0,0.91617,-0.307755,0.256748,-0.243383,0.0817559,0.966478,1.87575,-0.130058,0.119381> }}
union{cone{<2.37761,-0.298641,0.260024> ,0.266667,<2.89215,-0.418235,0.19988> ,0.2}
sphere{<2.37761,-0.298641,0.260024> ,0.266667}
texture{txttree matrix <-0.226396,-0.974035,0,0.967783,-0.224943,-0.113125,0.110188,-0.0256111,0.993581,2.37761,-0.298641,0.260024> }}
union{cone{<2.89215,-0.418235,0.19988> ,0.2,<3.40858,-0.483216,0.113813> ,0.133333}
sphere{<2.89215,-0.418235,0.19988> ,0.2}
texture{txttree matrix <-0.124843,-0.992177,0,0.978885,-0.12317,-0.163137,0.161861,-0.0203665,0.986603,2.89215,-0.418235,0.19988> }}
union{cone{<3.40858,-0.483216,0.113813> ,0.133333,<3.91846,-0.565741,0.0138535> ,0.0666667}
sphere{<3.40858,-0.483216,0.113813> ,0.133333}
texture{txttree matrix <-0.159771,-0.987154,0,0.969172,-0.15686,-0.19,0.187559,-0.0303565,0.981784,3.40858,-0.483216,0.113813> }}
union{cone{<3.91846,-0.565741,0.0138535> ,0.0666667,<4.40265,-0.64155,-0.174487> ,0}
sphere{<3.91846,-0.565741,0.0138535> ,0.0666667}
texture{txttree matrix <-0.154687,-0.987964,0,0.922208,-0.144391,-0.358726,0.354408,-0.0554902,0.933443,3.91846,-0.565741,0.0138535> }}
rotate y*73.3305}
union{
union{cone{<0,0.5,0> ,0.6,<0.504219,0.396244,0.165695> ,0.533333}
sphere{<0,0.5,0> ,0.6}
texture{txttree matrix <-0.201552,-0.979478,0,0.93237,-0.191859,0.306393,-0.300105,0.0617543,0.951905,0,0.5,0> }}
union{cone{<0.504219,0.396244,0.165695> ,0.533333,<0.937416,0.171399,0.341932> ,0.466667}
sphere{<0.504219,0.396244,0.165695> ,0.533333}
texture{txttree matrix <-0.46068,-0.887567,0,0.834811,-0.433297,0.339624,-0.301439,0.156458,0.940561,0.504219,0.396244,0.165695> }}
union{cone{<0.937416,0.171399,0.341932> ,0.466667,<1.38654,-0.0761518,0.502916> ,0.4}
sphere{<0.937416,0.171399,0.341932> ,0.466667}
texture{txttree matrix <-0.48272,-0.875775,0,0.835572,-0.46056,0.299506,-0.2623,0.144577,0.954094,0.937416,0.171399,0.341932> }}
union{cone{<1.38654,-0.0761518,0.502916> ,0.4,<1.87577,-0.259748,0.62911> ,0.333333}
sphere{<1.38654,-0.0761518,0.502916> ,0.4}
texture{txttree matrix <-0.351347,-0.936245,0,0.910083,-0.341529,0.234748,-0.219782,0.0824781,0.972056,1.38654,-0.0761518,0.502916> }}
union{cone{<1.87577,-0.259748,0.62911> ,0.333333,<2.37905,-0.400483,0.670955> ,0.266667}
sphere{<1.87577,-0.259748,0.62911> ,0.333333}
texture{txttree matrix <-0.269303,-0.963055,0,0.959983,-0.268444,0.0798174,-0.0768686,0.0214951,0.99681,1.87577,-0.259748,0.62911> }}
union{cone{<2.37905,-0.400483,0.670955> ,0.266667,<2.85763,-0.503289,0.488701> ,0.2}
sphere{<2.37905,-0.400483,0.670955> ,0.266667}
texture{txttree matrix <-0.210025,-0.977696,0,0.916247,-0.196825,-0.348929,0.341147,-0.0732838,0.937149,2.37905,-0.400483,0.670955> }}
union{cone{<2.85763,-0.503289,0.488701> ,0.2,<3.31615,-0.689617,0.682745> ,0.133333}
sphere{<2.85763,-0.503289,0.488701> ,0.2}
texture{txttree matrix <-0.37647,-0.926429,0,0.862509,-0.350495,0.365009,-0.338155,0.137415,0.931004,2.85763,-0.503289,0.488701> }}
union{cone{<3.31615,-0.689617,0.682745> ,0.133333,<3.77898,-0.828812,0.519926> ,0.0666667}
sphere{<3.31615,-0.689617,0.682745> ,0.133333}
texture{txttree matrix <-0.288005,-0.957629,0,0.907516,-0.272933,-0.319254,0.305727,-0.0919465,0.947669,3.31615,-0.689617,0.682745> }}
union{cone{<3.77898,-0.828812,0.519926> ,0.0666667,<4.25278,-1.08621,0.663139> ,0}
sphere{<3.77898,-0.828812,0.519926> ,0.0666667}
texture{txttree matrix <-0.477373,-0.878701,0,0.849256,-0.461377,0.2567,-0.225563,0.122542,0.966491,3.77898,-0.828812,0.519926> }}
rotate y*146.213}
union{
union{cone{<0,0.5,0> ,0.6,<0.50349,0.47042,0.172216> ,0.533333}
sphere{<0,0.5,0> ,0.6}
texture{txttree matrix <-0.0586481,-0.998279,0,0.944723,-0.0555018,0.323137,-0.32258,0.0189514,0.946352,0,0.5,0> }}
union{cone{<0.50349,0.47042,0.172216> ,0.533333,<0.995901,0.37193,0.304015> ,0.466667}
sphere{<0.50349,0.47042,0.172216> ,0.533333}
texture{txttree matrix <-0.196131,-0.980578,0,0.948454,-0.189706,0.253864,-0.248933,0.0497906,0.96724,0.50349,0.47042,0.172216> }}
union{cone{<0.995901,0.37193,0.304015> ,0.466667,<1.47253,0.274451,0.139808> ,0.4}
sphere{<0.995901,0.37193,0.304015> ,0.466667}
texture{txttree matrix <-0.200369,-0.97972,0,0.92827,-0.189847,-0.319802,0.313317,-0.0640785,0.947484,0.995901,0.37193,0.304015> }}
union{cone{<1.47253,0.274451,0.139808> ,0.4,<1.96422,0,0.107101> ,0.333333}
sphere{<1.47253,0.274451,0.139808> ,0.4}
texture{txttree matrix <-0.487397,-0.873181,0,0.871711,-0.486577,-0.0579867,0.0506328,-0.0282625,0.998317,1.47253,0.274451,0.139808> }}
union{cone{<1.96422,0,0.107101> ,0.333333,<2.50457,0,0.0295754> ,0.266667}
sphere{<1.96422,0,0.107101> ,0.333333}
texture{txttree matrix <0,-1,0,0.989864,0,-0.142017,0.142017,0,0.989864,1.96422,0,0.107101> }}
union{cone{<2.50457,0,0.0295754> ,0.266667,<2.9647,-0.223727,-0.159107> ,0.2}
sphere{<2.50457,0,0.0295754> ,0.266667}
texture{txttree matrix <-0.437278,-0.899326,0,0.843778,-0.410269,-0.346004,0.31117,-0.1513,0.938233,2.50457,0,0.0295754> }}
union{cone{<2.9647,-0.223727,-0.159107> ,0.2,<3.44986,-0.344547,-0.358649> ,0.133333}
sphere{<2.9647,-0.223727,-0.159107> ,0.2}
texture{txttree matrix <-0.241649,-0.970364,0,0.901239,-0.224435,-0.37067,0.359685,-0.089572,0.928765,2.9647,-0.223727,-0.159107> }}
union{cone{<3.44986,-0.344547,-0.358649> ,0.133333,<3.96552,-0.498865,-0.209905> ,0.0666667}
sphere{<3.44986,-0.344547,-0.358649> ,0.133333}
texture{txttree matrix <-0.286699,-0.958021,0,0.923411,-0.276342,0.266361,-0.255179,0.0763654,0.963873,3.44986,-0.344547,-0.358649> }}
union{cone{<3.96552,-0.498865,-0.209905> ,0.0666667,<4.4368,-0.566599,-0.0324376> ,0}
sphere{<3.96552,-0.498865,-0.209905> ,0.0666667}
texture{txttree matrix <-0.142263,-0.989829,0,0.927493,-0.133304,0.349267,-0.345714,0.0496879,0.937023,3.96552,-0.498865,-0.209905> }}
rotate y*218.306}
union{
union{cone{<0,0.5,0> ,0.6,<0.477593,0.452838,0.202676> ,0.533333}
sphere{<0,0.5,0> ,0.6}
texture{txttree matrix <-0.0982711,-0.99516,0,0.916759,-0.0905291,0.389046,-0.387163,0.0382319,0.921218,0,0.5,0> }}
union{cone{<0.477593,0.452838,0.202676> ,0.533333,<0.918932,0.227183,0.0235202> ,0.466667}
sphere{<0.477593,0.452838,0.202676> ,0.533333}
texture{txttree matrix <-0.455243,-0.890367,0,0.837352,-0.428137,-0.339913,0.302648,-0.154743,0.940457,0.477593,0.452838,0.202676> }}
union{cone{<0.918932,0.227183,0.0235202> ,0.466667,<1.46744,0.198589,0.0825917> ,0.4}
sphere{<0.918932,0.227183,0.0235202> ,0.466667}
texture{txttree matrix <-0.0520587,-0.998644,0,0.992918,-0.0517602,0.106931,-0.106786,0.00556671,0.994266,0.918932,0.227183,0.0235202> }}
union{cone{<1.46744,0.198589,0.0825917> ,0.4,<1.94373,0,-0.0873505> ,0.333333}
sphere{<1.46744,0.198589,0.0825917> ,0.4}
texture{txttree matrix <-0.384839,-0.922984,0,0.876667,-0.365528,-0.3128,0.288709,-0.120378,0.949819,1.46744,0.198589,0.0825917> }}
union{cone{<1.94373,0,-0.0873505> ,0.333333,<2.45383,-0.165545,0.0122813> ,0.266667}
sphere{<1.94373,0,-0.0873505> ,0.333333}
texture{txttree matrix <-0.308688,-0.951163,0,0.935162,-0.303495,0.182656,-0.173736,0.0563836,0.983177,1.94373,0,-0.0873505> }}
union{cone{<2.45383,-0.165545,0.0122813> ,0.266667,<3.00959,-0.185917,-0.00736045> ,0.2}
sphere{<2.45383,-0.165545,0.0122813> ,0.266667}
texture{txttree matrix <-0.0366321,-0.999329,0,0.998706,-0.0366093,-0.035296,0.0352723,-0.00129297,0.999377,2.45383,-0.165545,0.0122813> }}
union{cone{<3.00959,-0.185917,-0.00736045> ,0.2,<3.488,-0.317116,-0.209293> ,0.133333}
sphere{<3.00959,-0.185917,-0.00736045> ,0.2}
texture{txttree matrix <-0.264473,-0.964393,0,0.893225,-0.244956,-0.377023,0.363598,-0.0997123,0.926204,3.00959,-0.185917,-0.00736045> }}
union{cone{<3.488,-0.317116,-0.209293> ,0.133333,<3.97325,-0.507677,-0.0286819> ,0.0666667}
sphere{<3.488,-0.317116,-0.209293> ,0.133333}
texture{txttree matrix <-0.365533,-0.930798,0,0.879511,-0.345392,0.327359,-0.304705,0.11966,0.9449,3.488,-0.317116,-0.209293> }}
union{cone{<3.97325,-0.507677,-0.0286819> ,0.0666667,<4.49856,-0.614031,-0.021615> ,0}
sphere{<3.97325,-0.507677,-0.0286819> ,0.0666667}
texture{txttree matrix <-0.198434,-0.980114,0,0.980029,-0.198417,0.0131841,-0.0129219,0.00261618,0.999913,3.97325,-0.507677,-0.0286819> }}
rotate y*292.723}
}
// Tree in box{<-30.7007,-1.08621,-36.1927>,<32.8234,42.8479,17.0447> pigment{Green}}
