// IRTC Stills Entry
// Topic: "Frozen Moment"
// Created 10/99 by Mark Wagner for the IRTC Animation round "Robot"
// Updated 11/02 by Mark Wagner for the IRTC Stills round "Frozen Moment"

// Scale: 1 POV unit = 1 cm (see units.inc)
// Time scale: 1 unit = 1 second

//	RoboMain.pov
//		Contains the general environment for the anim (lights, cameras)
//		Action is defined in Computer.inc and the *arm.inc files.

#declare included = true;

#include "units.inc"
#include "RoboMacs.inc"
#include "RoboText.inc"
#include "colors.inc"
#declare oldver = version;
#include "woods.inc"
#version oldver;
#include "metals.inc"

#declare Clock = .07;
#declare MonitorHeight = 3.5*feet;
#declare ViewDistance = 3*feet;

//Generate a pseudo-random sequence based on the current value of clock
#declare Q = seed((clock*1000));

//Declare all timing variables
//Timing for the display
#declare PowerUpTime = 1.5;    // Time at which to turn the computer on 
#declare StartCodeTime = 7;
#declare StopCodeTime = 22;
#declare StopShowTime = 27; // Time at which to clear the screen
#declare StartRunTime = 29; // Time at which to display first line of output
#declare FullRunTime = 31;	 // Time at which to display the full output
#declare StopRunTime = 42;

//Timing for the robot arms
#declare StartMovingTime = PowerUpTime + 1; //Start moving 1 second after powering up
#declare StopMovingTime = StartCodeTime - 1;
#declare StartTypingTime = StartCodeTime; //Start typing at the same time letters start appearing
#declare StopTypingTime = StopCodeTime;
#declare StartFoldingTime = FullRunTime;  //Time at which to cross arms
#declare StopFoldingTime = FullRunTime + 5;

//Fading the display in and out
#declare FadeInTime = 2;
#declare FadeOutStartTime = StopRunTime - 2;
#declare FadeOutStopTime = StopRunTime; 

#declare MoveTime = StopMovingTime-StartMovingTime;
#declare FoldTime = StopFoldingTime-StartFoldingTime;

//Include the computer
#include "computer.inc"

//Monitor is placed at <0,MonitorHeight,0>
object{Computer translate y*MonitorHeight}

//Furniture
box{<-1.8*feet,MonitorHeight,-1*feet>,<2.8,0,1.25>*feet texture{T_Wood14 finish{ambient 0} scale feet}}
//Cameras
#declare AnimCam1 = camera{
	location <sin(Clock*2*pi)*ViewDistance, MonitorHeight+1*foot, cos(Clock*2*pi)*ViewDistance>
	look_at <0,MonitorHeight+10*inches,0>
}
#declare Top1 = camera{
	location y*10*feet
	look_at 0
}

//Camera control splines
#declare CamPathSpline = spline{
	linear_spline
	0,<1.27734*feet, MonitorHeight+1*foot, 2.71448*feet>,
/*	StopMovingTime, <1.27734*feet, MonitorHeight+1*foot, 2.71448*feet>,
	StartTypingTime, <2*in,MonitorHeight+1*foot,2*feet>, //Switch to almost-square-on view, moving inward
	StartRunTime, <2*in,MonitorHeight+1*foot,2*feet>, // Start zooming out by moving camera back
	StartFoldingTime, <0,MonitorHeight+1*foot,3*feet>, //Zoomed out to watch arms fold
	StopFoldingTime, <0,MonitorHeight+1*foot,3*feet>, //Stay zoomed out until arms are done folding
	FadeOutStartTime-2, <0,MonitorHeight+9.5*in,3*feet> //Drop the camera down to be square on to the monitor */
}
#declare CamLookSpline = spline{
	linear_spline
	0,<0,MonitorHeight+10*inches,0>, 
/*	StartTypingTime, <0,MonitorHeight+8*inches,0>,
	StartTypingTime+1, <0,MonitorHeight,1*feet>,//Watch hands typing
	StartTypingTime+9, <0,MonitorHeight,1*feet>,//keep watching
	StartTypingTime+10, <0,MonitorHeight+10*in,.5*feet>,//Watch letters appear on screen, keeping hands at edge of view
	StartRunTime, <0,MonitorHeight+10*in,.5*feet>,//Start zooming out to watch robot fold arms
	StopFoldingTime, <0,MonitorHeight+9.5*in,.5*feet>//Square on to monitor, zoom in until monitor fills screen */
	
}
#declare CamAngleSpline = spline{
	linear_spline
	0, 67,
/*	StopTypingTime, 67,
	StopTypingTime+2, 40, //Zoom in on code
	StartRunTime, 40,
	StartFoldingTime, 67,
	StopFoldingTime, 67, // Start zooming in
	FadeOutStartTime-2, 21 */
}
#declare AnimCam2 = camera{
	location <0,0,0>+CamPathSpline(clock)
	look_at <0,0,0>+CamLookSpline(clock)
	angle CamAngleSpline(clock).x
}


//Filter for fading in/out
#if(/*clock < FadeInTime | */clock > FadeOutStartTime)
	sphere{
		<0,0,0>+CamPathSpline(clock),.01
		hollow
		finish{ambient 0 diffuse 0}
		pigment{
			#if(clock < FadeInTime)
				rgbt <1,1,1,(clock/FadeInTime)>
			#else //fading out
				rgbt <1,1,1,(1-((clock-FadeOutStartTime)/(FadeOutStopTime-FadeOutStartTime)))>
			#end
		}
	}
#end


camera{AnimCam2}

light_source{ 
	y*10*feet+z*0*feet, .5
	spotlight
	radius 15
	falloff 35
	point_at z*0*feet
}

light_source{
	<0,MonitorHeight+5*in,10*feet>, .04
	shadowless
}

global_settings{
	max_intersections 100
	max_trace_level 5
	radiosity{
		count 150
		distance_maximum .25*feet
		brightness 1
		recursion_limit 2
		gray_threshold 0
		nearest_count 5
		minimum_reuse .015
		error_bound 1
		low_error_factor .5
		max_sample 10
		adc_bailout .01/10
	}
//	assumed_gamma 1
//	ini_option "Preview_Start_Size=8"
//	ini_option "Preview_End_Size=4"
}
