// Display.inc
//	Determines what to display on the screen given the current clock value

#ifndef(included)
	#include "units.inc"
	#include "RoboMacs.inc"
	#declare DisplayTextScale = .5*in;
	#declare DisplayTextLeft  = -6*in;
	#declare DisplayTextCenter = 5*in;
	#declare DisplayTextTexture = texture{pigment{rgb 1}finish{ambient 1 diffuse 0}}

	// The following are clock values	
	#declare StartCodeTime = 0;
	#declare StopCodeTime = .6;
	#declare StopShowTime = .62; // Time at which to clear the screen
	#declare StartRunTime = .65; // Time at which to display first line of output
	#declare FullRunTime = .8;	 // Time at which to display the full output
	#declare StopRunTime = 1;
	//Number of characters in program
#end

#declare NumCharacters = 80;
// The strings to display on the screen
#declare TextString = array[4]
{ " " , "     " , "     " , " "}

#declare ProgramString = array[NumCharacters]
{ "m", "a", "i", "n", "(", ")", "{", // first 7 chars
"    ", "p", "r", "i", "n", "t", "f", "(", "\"", "\\", "n", "\\", "n", "\\", "n", "\\", "n", "\\", "n", "\\", "n", "\\", "n", "\\", "n", "\"", ")",";",
"    ", "p", "r", "i", "n", "t", "f", "(", "\"","H", "e", "l", "l", "o", " ", "W", "o", "r", "l", "d", ".", "\\", "n", "I", " ", "a", "m", " ", "y", "o", "u", "r", " ", "m", "a", "s", "t", "e", "r", ".", "\"", ")", ";", " ",
"}"}  

#declare TypingRate = (StopCodeTime-StartCodeTime)/dimension_size(ProgramString, 1);

// Build up the string for display on the screen
#switch(clock)
	#range(StartCodeTime, StopCodeTime)
		// Build program string
		#local Typed = 0;
		#local ToType = max(0,clock-StartCodeTime)/TypingRate;
//		#warning concat(str(ToType,0,0),"\n")
		#while(Typed < ToType)
//			#warning ProgramString[Typed] #warning "\n"
			#if(Typed < 8)
				#declare TextString[0] = concat(TextString[0], ProgramString[Typed])
			#else #if(Typed < 36)
				#declare TextString[1] = concat(TextString[1], ProgramString[Typed])
			#else #if(Typed < 80)
				#declare TextString[2] = concat(TextString[2], ProgramString[Typed])
			#else 
				#declare TextString[3] = concat(TextString[3], ProgramString[Typed])
			#end #end #end
			#declare Typed = Typed + 1;
		#end 
	#break
	#range(StartRunTime, StopRunTime)
		// Build program output string
		#declare TextString[1] = "Hello World."
		#if(clock > FullRunTime)
			#declare TextString[2] = "I am your master."
		#end
	#break
	#range(StopCodeTime, StopShowTime)
		//Show completed program
		#declare TextString[0] = concat(TextString[0],"main(){")
		#declare TextString[1] = concat(TextString[1],"printf(\"\\","n\\","n\\","n\\","n\\","n\\","n\\","n\\","n\");")
		#declare TextString[2] = concat(TextString[2],"printf(\"Hello World.\\","nI am your master.\");")
		#declare TextString[3] = concat(TextString[3],"}")
	#break
#end	
	
// Build the text object for output

#declare DisplayFont = "c:\\windows\\fonts\\lucon.ttf"

#declare DisplayText = union{
	text{ ttf DisplayFont TextString[0], 2*in,0 translate y*1.50}
	text{ ttf DisplayFont TextString[1], 2*in,0 translate y*0.50}
	text{ ttf DisplayFont TextString[2], 2*in,0 translate y*-0.5}
	text{ ttf DisplayFont TextString[3], 2*in,0 translate y*-1.5}
	scale DisplayTextScale
	scale <-1,1,1>
}

#declare DisplayText = object{
//	#warning concat(str(min_extent(DisplayText).x,2,2), ", ", str(min_extent(DisplayText).y,2,2), ", ", str(min_extent(DisplayText).z,2,2),"\n")
//	#warning concat(str(max_extent(DisplayText).x,2,2), ", ", str(max_extent(DisplayText).y,2,2), ", ", str(max_extent(DisplayText).z,2,2)."\n")
	DisplayText
	//Center
	translate <-DisplayTextLeft,DisplayTextCenter-((max_extent(DisplayText).y-min_extent(DisplayText).y)/2+min_extent(DisplayText).y),-1*in>
}
#declare DisplayText = intersection{
	sphere{ z*-59*inches+y*9.5, 4.95*feet }
//	box{<-100,-100,0>,<100,100,.01>}
	object{DisplayText}
	texture{DisplayTextTexture}
	translate z*5.5*in
}
//	#warning concat(str(min_extent(DisplayText).x,2,2), ", ", str(min_extent(DisplayText).y,2,2), ", ", str(min_extent(DisplayText).z,2,2))
//	#warning concat(str(max_extent(DisplayText).x,2,2), ", ", str(max_extent(DisplayText).y,2,2), ", ", str(max_extent(DisplayText).z,2,2)."\n")

#ifndef(included)
	#warning concat( TextString[0],"\n",TextString[1],"\n",TextString[2],"\n",TextString[3],"\n")
//	#warning concat(str(min_extent(DisplayText).x,2,2), ", ", str(min_extent(DisplayText).y,2,2), ", ", str(min_extent(DisplayText).z,2,2))
	camera{location <0,DisplayTextCenter,1.3*feet> look_at y*DisplayTextCenter}
	light_source{ 10*feet, 1}
	object{DisplayText}
	plane{y, 0 pigment{rgb .5}}
	background{.5}
#end