// RightArm.inc
//	The computer's right arm

#ifndef(included)
	#include "colors.inc"
	#include "textures.inc"
	#include "woods.inc"
	#include "metals.inc"
	#include "units.inc"
	#include "RoboText.inc"
	#include "RoboMacs.inc"
	#declare RightArmBasePos = y*9.5*in;
	#declare StartMovingTime = 1;
	#declare StopMovingTime = 1;
	#declare StartFoldingTime = 4;
	#declare MoveTime = StopMovingTime-StartMovingTime;
//	#declare FoldTime = StopFoldingTime-StartFoldingTime;
#end

#declare JointTexture = Gold1
#declare ArmTexture = texture{T_Chrome_4C finish{ambient 0}}

//Splines take care of moving the arms -- specify angles, heights, etc

#declare RightArmBaseSpline = spline{
	//Positive number rotates up
	cubic_spline
	0, -155,
	StartMovingTime, -155,
	StartMovingTime+(MoveTime/4), -155,
	StartMovingTime+(3*MoveTime/4), -180, //a
	StartMovingTime+MoveTime-.001, -194
	StartMovingTime+MoveTime, -194,
	
	StartFoldingTime, -194,
	StartFoldingTime+.001, -194,
	StartFoldingTime+(FoldTime/5), -188, //Arm out
	StartFoldingTime+(2*FoldTime/5), -188,
	StartFoldingTime+FoldTime, -212,     //Arm down
}
 
#declare RightUpperArmSpline = spline{
	//Negative number rotates forward
	cubic_spline
	0,0,
	StartMovingTime,0,
	StartMovingTime+(MoveTime/4),45
	StartMovingTime+(3*MoveTime/4),135,
	StartMovingTime+MoveTime-.001, 155
	StartMovingTime+MoveTime,155,
	
	StartFoldingTime+(2*FoldTime/5), 155,
	StartFoldingTime+(2*FoldTime/5)+.001, 155,
	StartFoldingTime+FoldTime, 165, //Almost parallel to monitor
} 
 
#declare RightUpperArmScaleSpline = spline{
	cubic_spline
	0, .9,
	StartMovingTime, .9,
	StartMovingTime+(MoveTime/4),.9,
	StartMovingTime+(MoveTime/2),.5,
	StartMovingTime+(3*MoveTime/4)-.001,.8
	StartMovingTime+(3*MoveTime/4),.8
	
	StartFoldingTime+(2*FoldTime/5),.8
	StartFoldingTime+(2*FoldTime/5)+.001,.8
	StartFoldingTime+FoldTime,.9
}

#declare RightUpperArmRotateSpline = spline{
	cubic_spline
	0, -90,
	StartMovingTime, -90
	StartMovingTime+(MoveTime/4),-180
}

#declare RightLowerArmSpline = spline{
	cubic_spline
	0,-150,
	StartMovingTime,-150
	StartMovingTime+(MoveTime/4),-150,
	StartMovingTime+(3*MoveTime/4), -70,
	StartMovingTime+MoveTime-.001,-70
	StartMovingTime+MoveTime,-70,
	
	StartFoldingTime+(FoldTime/5), -70,
	StartFoldingTime+(FoldTime/5)+.001, -70,
	StartFoldingTime+(2*FoldTime/5), -105 //Slightly outward
}

#declare RightWristXAngle = spline{
	cubic_spline
	0, 90,
	StartMovingTime, 90
	StartMovingTime+(MoveTime/4), 0
	StartMovingTime+(3*MoveTime/4), 0
	StartMovingTime+MoveTime-.001, -180
	StartMovingTime+MoveTime, -180,

	StartFoldingTime+(FoldTime/5), -180,	
	StartFoldingTime+(FoldTime/5)+.001, -180,
	StartFoldingTime+(2*FoldTime/5), 0,
}

#declare RightWristYAngle = spline{
	cubic_spline
	0, 0,
	StartMovingTime, 0
	StartMovingTime+(3*MoveTime/4), 0
	StartMovingTime+MoveTime-.001, 45
	StartMovingTime+MoveTime, 45,

	StartFoldingTime+(FoldTime/5), 45,
	StartFoldingTime+(FoldTime/5)+.001, 45,
	StartFoldingTime+(2*FoldTime/5), 0,
}

#declare RightWristBend = spline{
	cubic_spline
	0, 0,
	StartMovingTime, 0
	StartMovingTime+(3*MoveTime/4),0
	StartMovingTime+MoveTime-.001, 166
	StartMovingTime+MoveTime, 166
	
	StartFoldingTime+(FoldTime/5), 166,
	StartFoldingTime+(FoldTime/5)+.001, 166,
	StartFoldingTime+(2*FoldTime/5), 0,
}

//Resting locations for the fingers
#declare BaseRightIndexPosition =  <11.5,2.5,3.9375>*in; 
#declare BaseRightMiddlePosition = <11.5,2.5,3.1875>*in; 
#declare BaseRightRingPosition =   <11.5,2.5,2.4375>*in; 
#declare BaseRightLittlePosition = <11.5,2.5,1.6875>*in; 
#declare BaseRightThumbPosition =  <13,  2.5,4>*in;

//Splines for the fingers
//These positions are absolute fingertip positions
#declare RightIndexSpline = spline{
	linear_spline
	StopMovingTime, BaseRightIndexPosition,
	StartTypingTime+17*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+18*TypeSpeed,<10.95,1.8,3.5575>*in, //r
	StartTypingTime+19*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+23*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+24*TypeSpeed,<10.90,2.3,4.1075>*in, //t
	StartTypingTime+25*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+26*TypeSpeed,<11.5,1.8,3.9375>*in, //f
	StartTypingTime+27*TypeSpeed,BaseRightIndexPosition,
	
	StartTypingTime+73*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+74*TypeSpeed,<10.95,1.8,3.5575>*in, //r
	StartTypingTime+75*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+79*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+80*TypeSpeed,<10.90,2.3,4.1075>*in, //t
	StartTypingTime+81*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+82*TypeSpeed,<11.5,1.8,3.9375>*in, //f
	StartTypingTime+83*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+105*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+106*TypeSpeed,<10.95,1.8,3.5575>*in, //r
	StartTypingTime+107*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+133*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+134*TypeSpeed,<10.95,1.8,3.5575>*in, //r
	StartTypingTime+135*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+143*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+144*TypeSpeed,<10.90,2.3,4.1075>*in, //t
	StartTypingTime+145*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+147*TypeSpeed,BaseRightIndexPosition,
	StartTypingTime+148*TypeSpeed,<10.95,1.8,3.5575>*in, //r
	StartTypingTime+149*TypeSpeed,BaseRightIndexPosition,
}
#declare RightMiddleSpline = spline{
	linear_spline
	StopMovingTime, BaseRightMiddlePosition,
	StartTypingTime+89*TypeSpeed,BaseRightMiddlePosition,
	StartTypingTime+90*TypeSpeed,<10.75,1.8,2.8075>*in, //e
	StartTypingTime+91*TypeSpeed,BaseRightMiddlePosition,
	StartTypingTime+109*TypeSpeed,BaseRightMiddlePosition,
	StartTypingTime+110*TypeSpeed,<11.5,1.7,3.1875>*in, //d
	StartTypingTime+111*TypeSpeed,BaseRightMiddlePosition,
	StartTypingTime+145*TypeSpeed,BaseRightMiddlePosition,
	StartTypingTime+146*TypeSpeed,<10.75,1.8,2.8075>*in, //e
	StartTypingTime+147*TypeSpeed,BaseRightMiddlePosition,
}
#declare RightRingSpline = spline{
	linear_spline
	StopMovingTime, BaseRightRingPosition,
	StartTypingTime+101*TypeSpeed,BaseRightRingPosition,
	StartTypingTime+102*TypeSpeed,<10.75,2.4,2.1075>*in, //W
	StartTypingTime+103*TypeSpeed,BaseRightRingPosition,
	StartTypingTime+141*TypeSpeed,BaseRightRingPosition,
	StartTypingTime+142*TypeSpeed,<11.5,2.5,2.4375>*in,  //s
	StartTypingTime+143*TypeSpeed,BaseRightRingPosition,
}
#declare RightLittleSpline = spline{
	linear_spline
	StopMovingTime, BaseRightLittlePosition,
	StartTypingTime+1*TypeSpeed,BaseRightLittlePosition,
	StartTypingTime+2*TypeSpeed,<11.5,1.9,1.6875>*in      //a
	StartTypingTime+3*TypeSpeed,BaseRightLittlePosition,
	StartTypingTime+7*TypeSpeed,BaseRightLittlePosition,
	StartTypingTime+8*TypeSpeed,<12.25,1.9,1.3375>*in,  //Shift 
	StartTypingTime+12*TypeSpeed,<12.25,1.9,1.3375>*in, //Still shift 
	StartTypingTime+13*TypeSpeed,BaseRightLittlePosition,

	StartTypingTime+87*TypeSpeed,BaseRightLittlePosition,
	StartTypingTime+88*TypeSpeed,<12.25,1.9,1.3375>*in,  //Shift 
	StartTypingTime+89*TypeSpeed,BaseRightLittlePosition,
	StartTypingTime+99*TypeSpeed,BaseRightLittlePosition,
	StartTypingTime+100*TypeSpeed,<12.25,1.9,1.3375>*in,  //Shift 
	StartTypingTime+101*TypeSpeed,BaseRightLittlePosition,
	StartTypingTime+121*TypeSpeed,BaseRightLittlePosition,
	StartTypingTime+122*TypeSpeed,<11.5,1.9,1.6875>*in      //a
	StartTypingTime+123*TypeSpeed,BaseRightLittlePosition,
	StartTypingTime+139*TypeSpeed,BaseRightLittlePosition,
	StartTypingTime+140*TypeSpeed,<11.5,1.9,1.6875>*in      //a
	StartTypingTime+141*TypeSpeed,BaseRightLittlePosition,
}
#declare RightThumbSpline = spline{
	linear_spline
	StopMovingTime, BaseRightThumbPosition,
}

#macro Theta()
	//Find rotation for wrist by finding minimum for a truly ugly equation
	#local __theta = <0,0,0>;
	__theta
#end

//The location of the right wrist theta pivot point
	// Wrist positioning
#declare RightWristPivot = vrotate(vrotate(vrotate(vrotate(vrotate(<0,0,0>+x*.3*in,z*(RightWristBend(clock)/3))+x*in,z*(RightWristBend(clock)/3))+x*in,z*(RightWristBend(clock)/3))+x*1.2*in,x*RightWristXAngle(clock)),y*RightWristYAngle(clock));
	// Arm positioning
#declare RightWristPivot = vrotate(vrotate(vrotate(vrotate(RightWristPivot+x*12*in,y*RightLowerArmSpline(clock))+x*14*in*RightUpperArmScaleSpline(clock),x*RightUpperArmRotateSpline(clock)),y*RightUpperArmSpline(clock))+z*-1.1*in,z*RightArmBaseSpline(clock))+RightArmBasePos;
//The up direction of the pivot point
	// Wrist positioning
#declare RightWristUp = vrotate(vrotate(vrotate(vrotate(vrotate(<0,1,0>+x*.3*in,z*(RightWristBend(clock)/3))+x*in,z*(RightWristBend(clock)/3))+x*in,z*(RightWristBend(clock)/3))+x*1.2*in,x*RightWristXAngle(clock)),y*RightWristYAngle(clock));
	// Arm positioning
#declare RightWristUp = vrotate(vrotate(vrotate(vrotate(RightWristUp+x*12*in,y*RightLowerArmSpline(clock))+x*14*in*RightUpperArmScaleSpline(clock),x*RightUpperArmRotateSpline(clock)),y*RightUpperArmSpline(clock))+z*-1.1*in,z*RightArmBaseSpline(clock))+RightArmBasePos;
//The location of the base for the fingers
	// Wrist positioning
#declare RightWristFinger = vrotate(vrotate(vrotate(vrotate(vrotate(vrotate(<3*in,0,0>+x*.3*in, y*Theta()),z*(RightWristBend(clock)/3))+x*in,z*(RightWristBend(clock)/3))+x*in,z*(RightWristBend(clock)/3))+x*1.2*in,x*RightWristXAngle(clock)),y*RightWristYAngle(clock));
	// Arm positioning
#declare RightWristFinger = vrotate(vrotate(vrotate(vrotate(RightWristFinger+x*12*in,y*RightLowerArmSpline(clock))+x*14*in*RightUpperArmScaleSpline(clock),x*RightUpperArmRotateSpline(clock)),y*RightUpperArmSpline(clock))+z*-1.1*in,z*RightArmBaseSpline(clock))+RightArmBasePos;

#declare RightSpheres = union{
	sphere{RightWristPivot, .75*in pigment{rgb <0,1,0>}}
	sphere{RightWristUp, .75*in pigment{rgb <0,0,1>}}
	sphere{RightWristFinger, .75*in pigment{rgb <1,0,0>}}
}
//#warning concat("RightWristFinger = ", vstr(RightWristFinger/in,2,2), "\n") 

//Helper macro for Finger() -- returns the joint position given two fixed points and the lengths of the 
// segments between them, with a value to multiply RightWristUp by
#macro FindJoint(Start, End, R1, R2, Sign)
	#local _d = vlength(Start-End); //Distance between spheres
	#local _r = sqrt(-(_d+R2+R1)*(_d-R2+R1)*(_d+R2-R1)*(_d-R2-R1))/(2*_d); //Radius of circle of intersection
	#local _q = ((_d*_d)+(R2*R2)-(R1*R1))/(2*_d);
	#local _v = vnormalize(End-Start) * _q; //The position along the line between End and Start where the two spheres intersect.  This is also the direction from End to Start
	#local _p = vcross(_v, (RightWristUp-RightWristPivot) * Sign); // Find the vector perpendicular to the line between Start and End and RightWristUp
	vnormalize(vcross(_p,_v)) * _r - _v + End //Find the vector perpendicular to the previous vector and the line.
	// This is the absolute 3D space joint position
#end

// Creates a finger given a base point, a point for the tip, finger thickness, and finger length
#macro Finger(Start, End, Length, Thick)
	#warning "Start and End:\n"
	#warning concat( Vstr(Start/in,2,2),"\n")
	#warning concat( Vstr(End/in,2,2),"\n")
	#local _Length = vlength(Start-End);
	//Lengths of sections of finger
	#local _Top = Length/2;
	#local _Middle = Length/3;
	#local _Tip = Length/6;
	#warning concat(str(Length/in,4,4),", ",str(_Length/in,4,4),"\n")
	//Approximate _Joint2 position from distance between Start and End
	#local _J2Theta = acos(_Length/Length)/2;  //Angle formed by joint
	#local _J2Length = _Tip*cos(_J2Theta)+_Middle*cos(_J2Theta); //Combined length of finger tip
//	#warning concat(str(_J2Theta,2,2),"\n")

	#local _handAxis = RightWristFinger - RightWristPivot;
    //Handle special case of Start-End being parallel to RightWristUp
    #if(vdot(vnormalize(RightWristUp-RightWristPivot),vnormalize(Start-End)) = 1)
    	#local __temp = RightWristUp;
    	#declare RightWristUp = RightWristFinger;
    	#local _Joint1 = FindJoint(Start, End, _Top, _J2Length, 1);
		#if((vdot((Start-_Joint1),_handAxis)/vlength(Start-_Joint1)) > 0 ) //If finger has "snapped through" and is pointing the wrong way, fix it
			#local _Joint1 = FindJoint(Start, End, _Top, _J2Length, -1);
//			#warning "Special Case\n"
		#end
    	#declare RightWristUp = __temp;
	#else
		//Compute _Joint1 position by finding intersection point of 2 spheres for which 
		// length in either the positive or negative RightWristUp direction is a maximum
		#local _Joint1 = FindJoint(Start, End, _Top, _J2Length, 1);
		#if((vdot((Start-_Joint1),_handAxis)/vlength(Start-_Joint1)) > 0 ) //If finger has "snapped through" and is pointing the wrong way, fix it
			#local _Joint1 = FindJoint(Start, End, _Top, _J2Length, -1);
//			#warning "Inv1\n"
		#end
	//		#local _Joint1 = FindJoint(Start, End, _Top, _J2Length, -1);
	//	#end
	#end
//	#warning concat( str(vdot(_Joint1, z),3,3),"\n")
//	#warning concat( vstr(_Joint1/in,2,2),"\n")

//	#warning concat( vstr(_handAxis/in,2,2),"\n")

//	#warning concat( "Vector ",str(abs(vdot((End-_Joint1),_handAxis)/vlength(End-_Joint1)),3,3),"\n")

	#if((vdot((End-_Joint1),_handAxis)/vlength(End-_Joint1)) < 0 ) //If fingertip position is closer to hand along axis of hand than joint1 is,
		#local _Joint2 = FindJoint(_Joint1,End,_Middle,_Tip,-1); //invert RightWristUp for computing Joint2 position
//		#warning "Inverted\n"
	#else
		#local _Joint2 = FindJoint(_Joint1,End,_Middle,_Tip,1); //otherwise, calculate it normally
	#end
				
	//Build finger 
	union{
		//Finger
		cylinder{Start, _Joint1, Thick texture{ArmTexture}}
		cylinder{_Joint1, _Joint2, Thick texture{ArmTexture}}
		cylinder{_Joint2, End, Thick texture{ArmTexture}}
		sphere{End, Thick texture{ArmTexture}}
		//Joints
		sphere{Start, Thick*1.1 texture{JointTexture}}
		sphere{_Joint1, Thick*1.1 texture{JointTexture}}
		sphere{_Joint2, Thick*1.1 texture{JointTexture}}
	}		
#end


#declare RightPalm = difference{
	union{
		box{<.9*in,-.35*in,-1.2*in>,<3*in,.35*in,1.2*in>}
		cylinder{<.9*in,-.35*in,0>,<.9*in,.35*in,0>,1.2*in}
		torus{1.2*in,.35*in translate <.9*in,0,0>}
		cylinder{<.9,0,1.2>*in,<3,0,1.2>*in,.35*in}
		cylinder{<.9,0,-1.2>*in,<3,0,-1.2>*in,.35*in}
	}
	box{<.8,.3,-1.6>*in,<-.7,-.3,1.6>*in}
//	cylinder{<.9*in,.3*in,0>,<.9*in,-.3*in,0>,1.6*in}
	texture{ArmTexture}
	rotate y*Theta()
}

#declare RightWrist = union{
	cylinder{<-.4*in,0,0>,<.4*in,0,0>,.4*in texture{JointTexture}} //Pivot in lower arm
	union{
		//Anchor for bend section
		box{<.4,-.4,-1>*in,<1.2,.4,1>*in}
		cylinder{<1.2,0,-1>*in,<1.2,0,-.6>*in,.4*in}
		cylinder{<1.2,0,1>*in,<1.2,0,.6>*in,.4*in}
		union{
			// First bend section
			cylinder{<0,0,-.8>*in,<1,0,-.8>*in,.2*in texture{ArmTexture}}
			cylinder{<0,0,.8>*in,<1,0,.8>*in,.2*in texture{ArmTexture}}
			cylinder{<1,0,-1>*in,<1,0,-.6>*in,.3*in}
			cylinder{<1,0,1>*in,<1,0,.6>*in,.3*in}
			union{
				// Second bend section
				cylinder{<0,0,-.8>*in,<1,0,-.8>*in,.2*in texture{ArmTexture}}
				cylinder{<0,0,.8>*in,<1,0,.8>*in,.2*in texture{ArmTexture}}
				union{
					//Lower anchor for bend section
					cylinder{<0,0,-1>*in,<0,0,-.6>*in,.3*in}
					cylinder{<0,0,1>*in,<0,0,.6>*in,.3*in}
					box{<0,-.3,-1>*in,<.6,.3,1>*in}
					object{RightPalm translate x*.3*in}
					#if(clock <= StopMovingTime | clock >= StartFoldingTime)
						//Include fingers	
						sphere{<1.2,0,-1.3>*in, .35*1.1*in texture{JointTexture}}
						#declare RightWristUp = -z;
						#declare RightWristPivot = <0,0,0>;
						#local _J1 = FindJoint(<1.2,0,-1.3>*in, <4.2,-.5,-1.6>*in,2*in,1.5*in,1);
						sphere{_J1, .35*1.1*in texture{JointTexture}}
						cylinder{<1.2,0,-1.3>*in,_J1,.35*in texture{ArmTexture}}
						cylinder{<4.2,-.5,-1.6>*in,_J1,.35*in texture{ArmTexture}}
						sphere{<4.2,-.5,-1.6>*in, .35*in texture{ArmTexture}}
						
						#declare RightWristUp = -y;
						#declare RightWristFinger = -x*3.3*in;
						#declare RightWristPivot = x*.3*in;
						
						union{
							object{Finger(<3.3*in,0,-1.05*in>,<6.1,-.5,-1.05>*in,3*in,.35*in) } //Index Finger
							object{Finger(<3.3*in,0,-.35*in>,<6.5,-.5,-.35>*in,3.4*in,.35*in) } //Middle finger
							object{Finger(<3.3*in,0,.35*in>,<6.1,-.5,.35>*in,3*in,.35*in) } //Ring finger
							object{Finger(<3.3*in,0,1.05*in>,<5.5,-.5,1.05>*in,2.4*in,.35*in) } //Little finger
						}
					#end
					
					rotate z*(RightWristBend(clock)/3)
					translate x*1*in
				}
				rotate z*(RightWristBend(clock)/3)
				translate x*1*in
			}
			rotate z*(RightWristBend(clock)/3)
			translate x*1.2*in
		}
		texture{JointTexture}
		rotate x*RightWristXAngle(clock)
	}
	rotate y*RightWristYAngle(clock)
}

//Calculate the positions of the fingers
#declare RightFingerBinormal = -1*vcross(vnormalize(RightWristUp-RightWristPivot),vnormalize(RightWristFinger-RightWristPivot));

#declare RightIndexBase = RightWristFinger - RightFingerBinormal*1.05*in;
#declare RightMiddleBase = RightWristFinger - RightFingerBinormal*.35*in;
#declare RightRingBase = RightWristFinger - RightFingerBinormal*-.35*in;
#declare RightLittleBase = RightWristFinger - RightFingerBinormal*-1.05*in;
#declare RightThumbBase = RightWristPivot + vnormalize(RightWristFinger-RightWristPivot)*1.2*in - RightFingerBinormal*1.3*in;
//#warning concat(vstr(<0,0,0>+RightIndexSpline(clock)/in,2,2), "\n") 

//sphere{RightIndexBase, .75*in pigment{rgb <1,1,0>}}
#if(clock > StopMovingTime & clock < StartFoldingTime)
	#declare RightThumb = union{
		#local __temp = RightWristUp;
		#declare RightWristUp = RightWristPivot - RightFingerBinormal;
		sphere{RightThumbBase, .35*1.1*in texture{JointTexture}}

//		#warning concat(vstr(RightThumbBase/in,2,2),",",str(vlength(RightThumbBase-RightThumbSpline(clock))/in,2,2),"\n")

		#local _J1 = FindJoint(RightThumbBase, <0,0,0>+RightThumbSpline(clock),2*in,1.5*in,1);
		sphere{_J1, .35*1.1*in texture{JointTexture}}
		cylinder{RightThumbBase,_J1,.35*in texture{ArmTexture}}
		cylinder{RightThumbSpline(clock),_J1,.35*in texture{ArmTexture}}
		sphere{RightThumbSpline(clock), .35*in texture{ArmTexture}}
		
		#declare RightWristUp = __temp;
	}

	//Create the fingers in their final positions
	#declare RightFingers = union{
		object{RightThumb} //Thumb uses binormal rather than Up for up
	//	#warning concat(vstr(RightIndexBase/in,2,2),",",vstr(RightFingerBinormal/in,2,2),",",vstr(RightWristFinger/in,2,2),"\n")
		object{Finger(RightIndexBase,<0,0,0>+RightIndexSpline(clock),3*in,.35*in) } //Index Finger
		object{Finger(RightMiddleBase,<0,0,0>+RightMiddleSpline(clock),3.4*in,.35*in) } //Middle finger
		object{Finger(RightRingBase,<0,0,0>+RightRingSpline(clock),3*in,.35*in) } //Ring finger
		object{Finger(RightLittleBase,<0,0,0>+RightLittleSpline(clock),2.5*in,.35*in) } //Little finger
	}	
#end 

//Lower arm
#declare RightLowerArm = union{
	cylinder{<0,-.75*in,0>,<12*in,-.75*in,0>,.25*in}
	cylinder{<0,.75*in,0>,<12*in,.75*in,0>,.25*in}
	
	cylinder{<12*in,1*in,0>,<12*in,-1*in,0>,.4*in texture{JointTexture}}
	
	object{RightWrist translate x*12*in}
	
	texture{ArmTexture}
	rotate y*RightLowerArmSpline(clock)
}

//Upper arm
#declare UpperRightArm = union{
	cylinder{<0,.5*in,0>,<0,-.5*in,0>,1.2*in texture{JointTexture}}
	cylinder{<0,0,0>,<14*in,0,0>,.45*in scale <RightUpperArmScaleSpline(clock).x,1,1>}
	cylinder{<14*in*RightUpperArmScaleSpline(clock).x,-1*in,0>,<14*in*RightUpperArmScaleSpline(clock).x,1*in,0>,.6*in texture{JointTexture} rotate x*RightUpperArmRotateSpline(clock)}
	object{RightLowerArm rotate x*RightUpperArmRotateSpline(clock) translate x*14*in*RightUpperArmScaleSpline(clock)}
	
	texture{ArmTexture}
	rotate y*RightUpperArmSpline(clock)
	translate z*-1.1*in
}
//Shoulder pivot
#declare RightArmBase = union{
	cylinder{<0,0,0>,<0,0,-.5*in>,2*in}
	box{<1.4*in,.5*in,-.5*in>,<-1.4*in,1*in,-1.1*in>}
	cylinder{<0,.5*in,-1.1*in>,<0,.8*in,-1.1*in>,1.4*in}
	cylinder{<0,.8*in,-1.1*in>,<0,1*in,-1.1*in>,1.2*in}
	torus{1.2*in,.2*in translate <0,.8*in,-1.1*in>}
	
	box{<1.4*in,-.5*in,-.5*in>,<-1.4*in,-1*in,-1.1*in>}
	cylinder{<0,-.5*in,-1.1*in>,<0,-.8*in,-1.1*in>,1.4*in}
	cylinder{<0,-.8*in,-1.1*in>,<0,-1*in,-1.1*in>,1.2*in}
	torus{1.2*in,.2*in translate <0,-.8*in,-1.1*in>}

	object{UpperRightArm}

	texture{JointTexture}
	rotate z*RightArmBaseSpline(clock)
}

//Base
#declare RightArm = union{
	object{RightArmBase}
	#if(clock > StopMovingTime & clock < StartFoldingTime)
		object{RightFingers translate -1*RightArmBasePos}
	#end
//	object{RightSpheres translate -1*RightArmBasePos}
}


#ifndef(included)
	#declare RightWristPivot = vrotate(vrotate(vrotate(vrotate(<0,0,0>+x*.3*in,z*(RightWristBend(clock)/3))+x*in,z*(RightWristBend(clock)/3))+x*in,z*(RightWristBend(clock)/3))+x*1.2*in,x*RightWristXAngle(clock));
	#declare RightWristPivot = vrotate(vrotate(vrotate(vrotate(RightWristPivot+x*12*in,y*RightLowerArmSpline(clock))+x*14*in*RightUpperArmScaleSpline(clock),x*RightUpperArmRotateSpline(clock)),y*RightUpperArmSpline(clock))+z*-1.1*in,z*RightArmBaseSpline(clock))+RightArmBasePos;
//	camera{location <2,2,2>*feet look_at y*.7*feet angle 50} //Normal view
//	camera{location 10*feet*y look_at 0 angle 40} //Top view
	camera{location 3*feet+RightWristPivot look_at RightWristPivot angle 10} //Follow hand
	light_source{10*feet 1}
	object{RightArm translate RightArmBasePos}
	plane{y, 0 texture{T_Wood14 scale feet}}
#end