// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Orthographic Scene Example
//       useful for generating image_maps, heightfields, etc.
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  orthographic
  location <0,0,1>     // position & direction of view
  look_at  <0,0,0>
  right 1*x            // horizontal size of view  \___ to be rendered at square size
  up 1*y               // vertical size of view    /
}
//+FN +W150 +H300
// ----------------------------------------
#declare sm = pigment{
      		wrinkles scale <.05,.025,1>*3
      		color_map {
      		  [0.0 color rgb 0.4 ]
      		  [1.0 color rgb 1.0 ]
      		}
}
#declare lg = pigment{
    			bozo scale <.2,.1,1> 
       		color_map {
        		[0.0 color rgb 0.0 ]
        		[1.0 color rgb 1.0 ]
      		}
}

box {                  // this box fits exactly in view
  <-0.5, -0.5, 0>, <0.5, 0.5, 0>
  texture {
    pigment {
    	average pigment_map{
    		[.75 sm]
    		[1 lg]
    	}
    }
    
    finish {
      ambient 0.0
      diffuse 1.0
    }
  }
}

light_source{
	<-.5,-.5,1>
	color rgb 1
	spotlight
	point_at <-.5,-.5,0>
	tightness 8
	radius 0
	falloff 45
}

light_source{
	<-.15, -.5,.2>
	color rgb .25 //.45
	spotlight
	point_at <-.1, -.5, 0>
	tightness 12
	radius 0
	falloff 90
}

