#version 3.5;
//-f +W280 +H400
//these proportions are a bit better:
//-f +W300 +H400 +HTN

// Cmd: declare=allRad=yes Width=450 Height=600 Display_gamma=2.2 Output_File_Name="C:\Documents and Settings\TheWinner\My Documents\My Pictures\images\momenttest"
//save the radiostity data when doing a final copy!

//find a way to reduce pretrace_end without crashing! (maybe reduce pretrace_start, too)
#include "shapes.inc"
#declare quick = no;

#declare moniter = on;
#declare keyboard = on;
#declare ref = on;

global_settings {
	max_trace_level 12
	charset utf8
  assumed_gamma 1.0
  // radiosity (global illumination) settings
	#if(!quick)
  radiosity {
    pretrace_start 0.04           // start pretrace at this size
    pretrace_end   0.02           // end pretrace at this size
    count 350 //count 700 //400                     // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 0.65 //0.6              // higher -> smoother, less accurate [1.8]
    recursion_limit 3 //4            // how much interreflections are calculated (1..5+) [3]
    low_error_factor 0.7           // reduce error_bound during last pretrace step
    gray_threshold 0.2            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.0035 //0.0025 for 400 width          // reuse of old radiosity samples [0.015]
    brightness 3.6                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.03
    
    normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    #ifdef(allRad)
    	//save_file "moment3.rad"       // save radiosity data
    	//load_file "moment.rad"       // load saved radiosity data
    	//always_sample off
    #end
    
    //always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
  #end

}


default{
	finish{ ambient 0}
}
#if(quick)
	light_source{
		<0,10,-2>
		color rgb 1
		shadowless
	}
#end

camera {
  location  <2.0, 14.0, -9.0> -y*.3 //from above, show the important details close-up
  //location  <14, 8, -4> //overview of setup
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 2.0,  2.0>+<0,2.0,0>+1.00*y
  angle     30
}

/*camera{
	location <0,4.5,-2>*1.5
	right x*image_width/image_height
	look_at <0,0,1>
}*/


/*sky_sphere {
  pigment {
    gradient y scale <1,2,1> translate <0,1,0>
    color_map {
      [0.0 rgb <0.5,0.6,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }  
}*/
background {rgb <0,0,0>}

/*light_source { //more conventional light_source
  <10,10,-3>
  color rgb <1, 1, 1>*.05
}*/


#declare monTex = texture{
		pigment{rgb <.95,.95,.9>*.8}
	normal{granite .02 scale .5}
	finish{diffuse .4 specular .1 roughness .2}
}

//add specular here to slow down the render even more
#declare keyTex = texture{
		pigment{rgb <.95,.95,.9>*.8}
	normal{granite .02 scale .5}
	finish{diffuse .4 specular 0}
}

#declare smWood = pigment{wood scale .15 translate <10,0,0> rotate <10,0,0> turbulence .09
				color_map{
					[0.0 rgb <.2,.05,.03>]
					[1.0 rgb <.2,.13,.01>]
				}
}
#declare bgWood = pigment{wood scale .45 translate <10,0,0> rotate <10,0,0> turbulence .4
				color_map{
					[0.0 rgb <.2,.05,.03>]
					[1.0 rgb <.2,.13,.01>]
				}
}

//desk
box{ <-20,0,0> <20,-1,15> 
	pigment{ average
		pigment_map{
			[1.0 smWood]
			[1.0 bgWood]
		}
		rotate <0,90,0>
	}
	finish{specular .2 diffuse .4}
	normal{wood scale .1 translate <10,0,0> rotate <10,90,0> turbulence .09}
		
}
plane{z,13 inverse pigment{rgb <.9,.9,.9>} normal{granite .3 scale .3}}

#declare monTrans = transform{rotate <7,10,0> translate <0,3.6+1.0,2> translate z*2.5}
//#declare monTrans = transform{translate 2*y}

/*light_source{
	<0,0,0>
	color rgb .6
	area_light 3.1*x, 2.6*y, 8,8//<3.09999,0,0>, <0,2.5999,0>, 8,8
	
	adaptive 1
	//looks_like{box{<-3.1,-2.6,0> <3.1,2.6,0> pigment{rgb <1,0,0>} finish{ambient 1}}}
	translate <0,0,0.1>
	transform{monTrans}
	projected_through{box{<-3.1,-2.6,0> <3.1,2.6,0> transform{monTrans}}}
}*/


#if(moniter)

#declare screenPyr =
intersection{
	plane{y,0 inverse rotate <-35,0,0> translate -2.6*y}
	plane{y,0 rotate <35,0,0> translate 2.6*y}
	plane{x,0 inverse rotate 35*y translate -3.1*x}
	plane{x,0 rotate -35*y translate 3.1*x}
}

difference{
	//box{ <-3.5,-3,0>-<0,.6,0> <3.5,3,1>	}
	Round_Box_Union(<-3.5,-3,0>-<0,.6,0>,<3.5,3,1>,.1)
	object{screenPyr}
	
	cylinder{<-2.5,-3,-0.001>, <-2.5,-3,0.2>, .2}
	
	cylinder{<2.5, -3,-0.001>, <2.5, -3,0.2>, .07}
	cylinder{<2.3, -3,-0.001>, <2.3, -3,0.2>, .07}
	
	texture{monTex}
	transform{monTrans}
}

//text{ttf "lcallig.ttf" "V-Ron" 0.0001 y*.25 scale .25 no_shadow pigment{rgb 0} finish{diffuse 0 ambient 0} translate <-2.3,-3.2,-0.001> transform{monTrans}}
//text{ttf "lcallig.ttf" "Technologies" 0.0001 y*.25 scale .17 translate <.14,-.18,0> no_shadow pigment{rgb 0} finish{diffuse 0 ambient 0} translate <-2.3,-3.2,-0.001> transform{monTrans}}

union{//this must be restructured if the y component of monTrans is changed
	cylinder{<0,-4.3,3.7> <0,-4.0,3.7> 3.5}
	cone{<0,-4.0,3.7> 3.5 <0,-3.5,3.7> 2}
	texture{monTex}
	transform{monTrans}
}
	

union{
	difference{
		Round_Cylinder_Union(<-2.5, -3,-0.05>, <-2.5, -3,0.2>, .185,.02)
		torus{.12, .03 rotate <90,0,0> scale <1,1,.5> translate <-2.5,-3,-0.05>}
		cylinder{<-2.5, -3.04, 0> <-2.5,-2.96,0> .03 scale <1,1,.5> translate <0,0,-0.05>}
	}
	
	Round_Cylinder_Union(<2.5, -3,-0.05>, <2.5, -3,0.2>, .055,.02)
	Round_Cylinder_Union(<2.3, -3,-0.05>, <2.3, -3,0.2>, .055,.02)
	texture{monTex}
	transform{monTrans}
}

union{ //on light for moniter
	sphere{<-2.9,-3,0.01>, .05 no_shadow pigment{rgb <.2,.9,.2>} finish{ambient 1 diffuse 0}}
	sphere{<-2.9,-3,0.01>, .07 no_shadow pigment{rgbf <.2,.9,.2,1>} finish{ambient .6 diffuse .5}}
	light_source{ <-2.9,-3,-0.05> color rgb <.2,.9,.2>*.005}
	transform{monTrans}
}


intersection{
	sphere{<0,0,0>, 3 scale <3.7,3.7,1> translate <0,0,3>}
	object{screenPyr}
	//pigment{rgb .01}
	pigment{image_map{png "paused.png"}
		scale .987
		scale <6.2,5.2,1>
		translate <-3.1,-2.6,0>
	}
	
	//finish{specular .1 reflection .02 diffuse 0 ambient .7}
	finish{specular 0 reflection 0 diffuse 0 ambient 0.7} // this one renders faster (?)
	transform{monTrans}
	no_shadow
}
#end

#macro key(lr,fb,dia,ht,tex,char, charb)
#if(strcmp(char,"F")*strcmp(char,"J")*(strcmp(char,"5")+strcmp(charb,"")) =0)
	union{
#end
difference{
	union{
		#declare lrRot = 10;
		#declare fRot = 25;
		#declare bRot = 8;
		/*box{<.15,0,.25> <.85,1,.85>}
		cylinder{<.15,0,.85> <.15,1,.85> .15}
		cylinder{<.85,0,.85> <.85,1,.85> .15}
		
		cylinder{<.15,0,.25> <.15,1,.15> .15}
		cylinder{<.85,0,.25> <.85,1,.25> .15}*/
		cylinder{<0,0,0> <0,ht,0> dia rotate <-bRot,0,-lrRot>}
		cylinder{<0,0,0> <0,ht,0> dia rotate <-bRot,0,lrRot> translate <lr,0,0>}
		cylinder{<0,0,0> <0,ht,0> dia rotate <fRot,0,-lrRot> translate <0,0,-fb>}
		cylinder{<0,0,0> <0,ht,0> dia rotate <fRot,0,lrRot> translate <lr,0,-fb>}
		intersection{
			plane{x,0 inverse rotate <0,0,-lrRot>}
			plane{x,0 rotate <0,0,lrRot> translate <lr,0,0>}
			plane{y,0 inverse}
			plane{y,ht }
			plane{z,0 rotate <-bRot,0,0> translate <0,0,dia>}
			plane{z,0 inverse rotate <fRot,0,0> translate <0,0,-fb -dia>}
			
			bounded_by{box{<-lr*.2,0,fb*2> <lr*1.2,ht,-fb*1.2>}}
		}
		intersection{
			plane{x,0 inverse rotate <0,0,-lrRot> translate <-dia,0,0>}
			plane{x,0 rotate <0,0,lrRot> translate <lr+dia,0,0>}
			plane{y,0 inverse}
			plane{y,ht }
			plane{z,0 rotate <-bRot,0,0> }
			plane{z,0 inverse rotate <fRot,0,0> translate <0,0,-fb>}
			
			bounded_by{box{<-lr*.2,0,fb*2> <lr*1.2,ht,-fb*1.2>}}
		}
		
	}
	sphere{<0,0,0> 3.35 scale <lr*.9,1,fb*.9> translate <lr/2,4,-fb/2> scale <1,ht,1>}
	plane{y,0}
#if(strcmp(char,"F")*strcmp(char,"J")*(strcmp(char,"5")+strcmp(charb,"")) =0)
	}
	sphere{<0,0,0> .02 translate <lr/2,ht-.018,-2*fb/3> }
#end


#local aDrop = 0;
#local bDrop = 0;

#if(strlen(char) > 1)
	//#declare scaleFact = <fb*.8*.32,1,fb*.32>;
	#declare scaleFact = <.35*.8*.32,1,.35*.32>;
	
	#if( ((strlen(char) > 3) | strcmp(char,"End") = 0) & (strcmp(charb,"") = 0) & (lr = .23) )
		#debug concat("Shrinking text on a small key: ", char, ".\n")
		//#debug concat("(it's length is ", str(lr, 0, -1), ".)\n")
		#declare scaleFact = scaleFact * <.7,1,.7>;
		
	#end
	
#else
	//#declare scaleFact = <fb*.5,1,fb*.5>;
	#declare scaleFact = <.35*.5,1,.35*.5>;
#end

#if( strlen(char) > 2 & strlen(charb) > 2)
	#declare aDrop = 0.02;
#end

#if( strlen(char) = 1 & strlen(charb) = 1)
	#declare bDrop = 0.02;
#end

#declare aFact = 1;
#declare bFact = 1;

#if(strlen(charb) > 1 & strlen(char) = 1) //some num. keys need special treatment


	#if(strcmp(charb, "UP") = 0)     //"\u00E1"
		#local texObj = text{ttf "wingdng3.ttf", "\u0094", ht/2, 0 rotate <90,0,0> scale scaleFact*<.7,1,.7>*bFact translate <.02,ht*1.1,-fb*.4>+<-.1,0,.12> +<.05,0,-.1> }
	#end
	
	#if(strcmp(charb, "LEFT") = 0)//"\u00DF"
		#local texObj = text{ttf "wingdng3.ttf" "\u0091" ht/2, 0 rotate <90,0,0> scale scaleFact*<.7,1,.7>*bFact translate <.02,ht*1.1,-fb*.4> +<.05,0,-.1> }
	#end
	
	#if(strcmp(charb, "DOWN") = 0)
		#local texObj = text{ttf "wingdng3.ttf" "\u0093" ht/2, 0 rotate <90,0,0> scale scaleFact*<.7,1,.7>*bFact translate <.02,ht*1.1,-fb*.4>+<.1,0,-.12>  +<.05,0,-.1>}
	#end
	
	#if(strcmp(charb, "RIGHT") = 0)
		#local texObj = text{ttf "wingdng3.ttf" "\u0092" ht/2, 0 rotate <90,0,0> scale scaleFact*<.7,1,.7>*bFact translate <.02,ht*1.1,-fb*.4>  +<.05,0,-.1>}
	#end		
	
	#ifndef(texObj) //if it isn't an arrow, scale it down
		#debug concat("shrinking and droping: ", charb, "\n")
		#declare bFact = bFact * <.73,1,.73>;
		#if(strcmp(charb,"Ins") = 0)
			#declare bDrop = -0.00;
		#else
			#declare bDrop = 0.05;
		#end
	#end


#end

#if(strcmp(char, "(") = 0 | strcmp(char, ")") = 0 | strcmp(char, "{") = 0 | strcmp(char, "}") = 0)
	#declare aFact = <.85,1,.85>;
#end
#if(strcmp(charb, "[") = 0 | strcmp(charb, "]") = 0)
	#declare bFact = <.85,1,.85>;
#end
// <= wingdings.ttf ^<v> arrows   <= wingdings.ttf windows key 8! <= wingdings3.ttf enter, backspace
//4 <= wingdings2.ttf menu key FX <= wingdings3.ttf tab, shift


	#if(strcmp(charb, "")=0) //one-line key
		#local texObj = text{ttf "Eurostib.ttf" char ht/2, 0 rotate <90,0,0> scale scaleFact translate <.02,ht*1.1,-fb*.4> }
		
		#if(strcmp(char, "Tab") = 0)
			#local texObj = union{text{ttf "wingdng3.TTF" "F" ht/2, 0 rotate <90,0,0> scale scaleFact*1.45 translate <.02+(scaleFact.x*1.75),ht*1.1,-fb*.4> }
			text{ttf "Eurostib.ttf" "Tab" ht/2, 0 rotate <90,0,0> scale scaleFact translate <.02,ht*1.1,-fb*.4> }
			}
		#end
		
		
		#if(strcmp(char, "Shift") = 0)
			#local texObj = union{text{ttf "wingdng3.ttf" "X" ht/2, 0 rotate <90,0,0> scale scaleFact*1.15 translate <.02,ht*1.1,-fb*.4> }
			text{ttf "Eurostib.ttf" "Shift" ht/2, 0 rotate <90,0,0> scale scaleFact translate <.02+scaleFact.x*1.1,ht*1.1,-fb*.4> }
			}
		#end
		
		#if(strcmp(char, "Backspace") = 0)
			#local texObj = union{text{ttf "wingdng3.ttf" "!" ht/2, 0 rotate <90,0,0> scale scaleFact*1.45 translate <.02,ht*1.1,-fb*.4> }
			text{ttf "Eurostib.ttf" "Backspace" ht/2, 0 rotate <90,0,0> scale scaleFact translate <.02+scaleFact.x*1.2 + 0.03,ht*1.1,-fb*.4> }
			}
		#end
		
		#if(strcmp(char, "Enter") = 0 & fb = .35)
			#local texObj = union{text{ttf "wingdng3.ttf" "8" ht/2, 0 rotate <90,0,0> scale scaleFact*1.45 translate <.02,ht*1.1,-fb*.4 -.05 > }
			text{ttf "Eurostib.ttf" "Enter" ht/2, 0 rotate <90,0,0> scale scaleFact translate <.02+scaleFact.x*1.2 + 0.03,ht*1.1,-fb*.4> }
			}
		#end
		//The following mess works.  I have no idea why.
		//   //  //wingdings3: ?  hfig  #!$"     
		#if(strcmp(char, "UP") = 0)     //"\u00E1"
			#local texObj = text{ttf "wingdng3.ttf", "\u0094", ht/2, 0 rotate <90,0,0> scale scaleFact*1.2 translate <.02,ht*1.1,-fb*.4>+<-.08,0,.13> +<.05,0,-.05> }
		#end
		
		#if(strcmp(char, "LEFT") = 0)//"\u00DF"
			#local texObj = text{ttf "wingdng3.ttf" "\u0091" ht/2, 0 rotate <90,0,0> scale scaleFact*1.2 translate <.02,ht*1.1,-fb*.4> +<.05,0,-.05> }
		#end
		
		#if(strcmp(char, "DOWN") = 0)
			#local texObj = text{ttf "wingdng3.ttf" "\u0093" ht/2, 0 rotate <90,0,0> scale scaleFact*1.2 translate <.02,ht*1.1,-fb*.4>+<.08,0,-.13>  +<.05,0,-.05>}
		#end
		
		#if(strcmp(char, "RIGHT") = 0)
			#local texObj = text{ttf "wingdng3.ttf" "\u0092" ht/2, 0 rotate <90,0,0> scale scaleFact*1.2 translate <.02,ht*1.1,-fb*.4>  +<.05,0,-.05>}
		#end		
		
		
		#if(strcmp(char, "MENU") = 0)
			#local texObj = text{ttf "wingdng2.ttf" "4" ht/2, 0 rotate <90,0,0> scale scaleFact*1.2 translate <.02,ht*1.1,-fb*.4> }
		#end
		
		#if(strcmp(char, "WIN") = 0)
			#local texObj = text{ttf "wingding.ttf" "\u00FF" ht/2, 0 rotate <90,0,0> scale scaleFact*1.35 translate <.02,ht*1.1,-fb*.4> }
		#end
		
		#if(strcmp(char, "/")*strcmp(char,"*")*strcmp(char,"-")*strcmp(char,"+") = 0)
			#local texObj = object{texObj translate <.05,0,-0.02>}
		#end
		
		#if(strcmp(char, "+") = 0)
			#local texObj = object{texObj translate <0,0,-0.15>}
		#end
		
		texture{object{
			texObj
			texture{tex},
			texture{pigment{rgb 0}}
			}
		}
	#else
	texture{object{
		#if(lr != .23)
			union{
				text{ttf "Eurostib.ttf" char ht/2, 0 rotate <90,0,0> scale scaleFact*aFact scale <.7,1,.7>
					translate <.02,ht*1.1,-fb*.3>-aDrop*z}

					text{ttf "Eurostib.ttf" charb ht/2, 0 rotate <90,0,0> scale scaleFact*bFact scale <.7,1,.7>
						translate <.02,ht*1.1,-fb*.7>-bDrop*z}
			}
		#else
			union{
				text{ttf "Eurostib.ttf" char ht/2, 0 rotate <90,0,0> scale scaleFact*aFact scale <.7,1,.7>
					translate <.02,ht*1.1,-fb*.3>-aDrop*z}
				#ifdef(texObj)
					#debug "printing special second-line numpad character\n"
					object{texObj}
				#else
				text{ttf "Eurostib.ttf" charb ht/2, 0 rotate <90,0,0> scale scaleFact*bFact scale <.7,1,.7>
					translate <.02,ht*1.1,-fb*.57>-bDrop*z}
				#end
			}
		#end
		
		texture{tex},
		texture{pigment{rgb 0} finish{diffuse 0}}
		}
	}
	#end
bounded_by{box{<-lr*.2,0,fb*2> <lr*1.2,ht,-fb*1.2>}}
//clipped_by{bounded_by}
}
#ifdef(texObj)
	#undef texObj
#end

#end

//keyboard ends at 1.62!

//object{key(2,2,.2,2, keyTex,"Q") translate <-.5,1,0>}
#macro fntr(n)
	translate (<-3.00 + n*.31, 0.06,2.61> - <0,0,.04>*5)
#end
#macro numtr(n)
	translate (<-3.00 + n*.31, 0.06,2.1> - <0,0,.04>*4)
#end
#macro ttr(n) //tab = -1; first normal-width key is 0
 translate (<-2.5 + n*.31,   0.06,1.69> - <0,0,.04>*3)
#end
#macro mtr(n)
	translate (<-2.4 + n*.31,  0.06,1.28> - <0,0,.04>*2)
#end
#macro btr(n)
	translate (<-2.2 + n*.31,  0.06,0.87> - <0,0,.04>)
#end
//#macro ctr(n)
//	translate <-2.2 + n*.31,  0.06,0.46>
//#end


#declare keyLR = -3.3; //keyboard size
#declare keyDepth = 2.6;

#declare kWd = .23;
#declare kHt = .35;
#declare rd = .04;

#declare kSl = 1.1; //scale the keyboard

union{
	difference{
		union{
			cylinder{<-keyLR+1.0,0,0> <keyLR,0,0> .15}
			cylinder{<-keyLR+1.0,0,keyDepth> <keyLR,0,keyDepth> .15}
			box{<-keyLR+1.0,.15,0> <keyLR,-.15,keyDepth>}
		}
		box{<-3.04,0.1,0.11> <1.66,0.15001,1.98> pigment{rgb 0} finish{diffuse 0}} //darken the depths of the keyboard
		
		#declare fnAdj = .18;
		box{<-3.04,0.1,2.06> <-3.04+.31,0.15001,2.06+.37> pigment{rgb 0} finish{diffuse 0}}
		box{<-3.04+.31*2,0.1,2.06> <-3.04+.31*6,0.15001,2.06+.37> pigment{rgb 0} finish{diffuse 0}}
		box{<-3.04+.31*6+fnAdj,0.1,2.06> <-3.04+.31*10+fnAdj,0.15001,2.06+.37> pigment{rgb 0} finish{diffuse 0}}
		box{<-3.04+.31*10+fnAdj*2,0.1,2.06> <-3.04+.31*14+fnAdj*2,0.15001,2.06+.37> pigment{rgb 0} finish{diffuse 0}}
		
		box{<1.62+.18-0.05,0.1,2.06> <1.62+.18+.31*3-0.05,0.15001,2.06+.37> pigment{rgb 0} finish{diffuse 0}}
		
		box{<1.62+.18-0.05,0.1,0.11+0.37*3> <1.62+.18+.31*3-0.05,0.15001,1.98> pigment{rgb 0} finish{diffuse 0}}
		
		box{<1.62+.18-0.05,0.1,0.11> <1.62+.18+.31*3-.05,0.15001,0.11+.37> pigment{rgb 0} finish{diffuse 0}}
		box{<1.62+.18+.31-0.05,0.1,0.11+.37> <1.62+.18+.31*2-0.05,0.15001,0.11+.37*2> pigment{rgb 0} finish{diffuse 0}}
		
		box{<1.62+.18*2 + .31*3 -.05,0.1,0.11> <1.62+.18*2+.31*6 -.05, 0.15001,1.98> pigment{rgb 0} finish{diffuse 0}}
		
		box{<-.1,0.13,-.1> <.1,0.15001,0> pigment{rgb <0,1,0>} finish{diffuse 0 ambient 1} fntr(0)*<0,1,1> translate <1.62+.18*2+.31*3.5-.067,0,-.15>}
		box{<-.1,0.13,-.1> <.1,0.15001,0> pigment{rgb <0,1,0>} finish{diffuse 0 ambient .1} fntr(0)*<0,1,1> translate <1.62+.18*2+.31*5-.067,0,-.15>}
		box{<-.1,0.13,-.1> <.1,0.15001,0> pigment{rgb <0,1,0>} finish{diffuse 0 ambient 0} fntr(0)*<0,1,1> translate <1.62+.18*2+.31*6.5-.067,0,-.15>}
	}
	
	#declare n_lock = text{ttf "Eurostib.ttf" "Num Lock", 0.3, 0 rotate <90,0,0> scale .085 }
	#declare c_lock = text{ttf "Eurostib.ttf" "Caps Lock", 0.3, 0 rotate <90,0,0> scale .085 }
	#declare s_lock = text{ttf "Eurostib.ttf" "Scroll Lock", 0.3, 0 rotate <90,0,0> scale .085 }
	
	#debug str(max_extent(n_lock).x,0,-1)
	#debug " "
	#debug str(min_extent(n_lock).x,0,-1)
	#debug " "
	
	
	object{n_lock translate -abs(max_extent(n_lock).x - min_extent(n_lock).x)*x/2
		no_shadow
		pigment{rgb <0,0,0>}
		finish{ambient 0 diffuse 0}
		translate y*0.15001
		fntr(0)*<0,1,1> +  <1.62+.18*2+.31*3.5-.067,0,-.35>}
	
	object{c_lock translate -abs(max_extent(c_lock).x - min_extent(c_lock).x)*x/2
		no_shadow
		pigment{rgb <0,0,0>}
		finish{ambient 0 diffuse 0}
		translate y*0.15001
		fntr(0)*<0,1,1> +  <1.62+.18*2+.31*5-.067,0,-.35>}
	
	object{s_lock translate -abs(max_extent(s_lock).x - min_extent(s_lock).x)*x/2
		no_shadow
		pigment{rgb <0,0,0>}
		finish{ambient 0 diffuse 0}
		translate y*0.15001
		fntr(0)*<0,1,1> +  <1.62+.18*2+.31*6.5-.067,0,-.35>}
	
	box{<-.099,0.145,-.099> <.099,0.15001,-0.01> pigment{rgbf <.5,1,.5,.7>} finish{diffuse .2 ambient 1} fntr(0)*<0,1,1> translate <1.62+.18*2+.31*3.5-.067,0,-.15>}
	light_source{ <.099,0.15001,-0.01>
		color rgb <.2,.9,.2>*.02 fade_power 2 fade_distance 1
	}
	box{<-.099,0.145,-.099> <.099,0.15001,-0.01> pigment{rgbf <.5,1,.5,.7>} finish{diffuse .2 ambient .1} fntr(0)*<0,1,1> translate <1.62+.18*2+.31*5-.067,0,-.15>}
	box{<-.099,0.145,-.099> <.099,0.15001,-0.01> pigment{rgbf <.5,1,.5,.7>} finish{diffuse .2 ambient .03} fntr(0)*<0,1,1> translate <1.62+.18*2+.31*6.5-.067,0,-.15>}

#if(keyboard)	
	union{
		object{key(.4,.35,.04,.3, keyTex, "Tab","") ttr(-1)*<0,1,1> translate <-3,0,0>}
		object{key(.23,.35,.04,.3, keyTex, "Q","") ttr(0)}
		object{key(.23,.35,.04,.3, keyTex, "W","") ttr(1)}
		object{key(.23,.35,.04,.3, keyTex, "E","") ttr(2)}
		object{key(.23,.35,.04,.3, keyTex, "R","") ttr(3)}
		object{key(.23,.35,.04,.3, keyTex, "T","") ttr(4)}
		object{key(.23,.35,.04,.3, keyTex, "Y","") ttr(5)}
		object{key(.23,.35,.04,.3, keyTex, "U","") ttr(6)}
		object{key(.23,.35,.04,.3, keyTex, "I","") ttr(7)}
		object{key(.23,.35,.04,.3, keyTex, "O","") ttr(8)}
		object{key(.23,.35,.04,.3, keyTex, "P","") ttr(9)}
		object{key(.23,.35,.04,.3, keyTex, "{", "[") ttr(10)}
		object{key(.23,.35,.04,.3, keyTex, "}", "]") ttr(11)}
		object{key(.4,.35,.04,.3, keyTex, "|", "\\") ttr(12)}
		object{key(.23,.35,.04,.3, keyTex, "Delete", "") ttr(0)*<0,1,1> translate <1.62+.18,0,0>}
		object{key(.23,.35,.04,.3, keyTex, "End", "") ttr(0)*<0,1,1> translate <1.62+.18+.31*1,0,0>}
		object{key(.23,.35,.04,.3, keyTex, "Page", "Down") ttr(0)*<0,1,1> translate <1.62+.18+.31*2,0,0>}
	}
	union{	
		object{key(.23,.35,.04,.3, keyTex, "7","Home") ttr(-1)*<0,1,1> translate <1.62+.18*2+.31*3,0,0>}
		object{key(.23,.35,.04,.3, keyTex, "8","UP") ttr(-1)*<0,1,1> translate <1.62+.18*2+.31*4,0,0>}
		object{key(.23,.35,.04,.3, keyTex, "9","PgUp") ttr(-1)*<0,1,1> translate <1.62+.18*2+.31*5,0,0>}
		object{key(.23,.72,.04,.3, keyTex, "+","") ttr(-1)*<0,1,1> translate <1.62+.18*2+.31*6,0,0>}
		
	}
	
	union{
		object{key(.35,.35,.04,.3, keyTex, "Caps","") mtr(-1)*<0,1,1> translate <-3,0,0>}
		object{key(.5,.35,.04,.2, keyTex, "","") mtr(-1)*<0,1,1> translate <-3,0,0>}
		
		object{key(.23,.35,.04,.3, keyTex, "A","") mtr(0)}
		object{key(.23,.35,.04,.3, keyTex, "S","") mtr(1)}
		object{key(.23,.35,.04,.3, keyTex, "D","") mtr(2)}
		object{key(.23,.35,.04,.3, keyTex, "F","") mtr(3)}
		object{key(.23,.35,.04,.3, keyTex, "G","") mtr(4)}
		object{key(.23,.35,.04,.3, keyTex, "H","") mtr(5)}
		object{key(.23,.35,.04,.3, keyTex, "J","") mtr(6)}
		object{key(.23,.35,.04,.3, keyTex, "K","") mtr(7)}
		object{key(.23,.35,.04,.3, keyTex, "L","") mtr(8)}
		object{key(.23,.35,.04,.3, keyTex, ":",";") mtr(9)}
		object{key(.23,.35,.04,.3, keyTex, "\"", "'") mtr(10)}
		object{key(.62,.35,.04,.3, keyTex, "Enter", "") mtr(11)}
	}
	union{	
		object{key(.23,.35,.04,.3, keyTex, "4","LEFT") mtr(-1)*<0,1,1> translate <1.62+.18*2+.31*3,0,0>}
		object{key(.23,.35,.04,.3, keyTex, "5"," ") mtr(-1)*<0,1,1> translate <1.62+.18*2+.31*4,0,0>}
		object{key(.23,.35,.04,.3, keyTex, "6","RIGHT") mtr(-1)*<0,1,1> translate <1.62+.18*2+.31*5,0,0>}
		
	}
	
	union{
		object{key(.71, kHt,rd,.3, keyTex, "Shift", "") btr(-1)*<0,1,1> translate <-3,0,0>}
		object{key(.23,.35,rd,.3, keyTex, "Z", "") btr(0)}
		object{key(.23,.35,rd,.3, keyTex, "X", "") btr(1)}
		object{key(.23,.35,rd,.3, keyTex, "C", "") btr(2)}
		object{key(kWd,kHt,rd,.3, keyTex, "V", "") btr(3)}
		object{key(kWd,kHt,rd,.3, keyTex, "B", "") btr(4)}
		object{key(kWd,kHt,rd,.3, keyTex, "N", "") btr(5)}	
		object{key(kWd,kHt,rd,.3, keyTex, "M", "") btr(6)}
		object{key(kWd,kHt,rd,.3, keyTex, "<", ",") btr(7)}
		object{key(kWd,kHt,rd,.3, keyTex, ">", ".") btr(8)}
		object{key(kWd,kHt,rd,.3, keyTex, "?", "/") btr(9)}
		object{key(.71,kHt,rd,.3, keyTex, "Shift", "") btr(10)}
	}
		object{key(.23,.35,.04,.3, keyTex, "UP", "") btr(0)*<0,1,1> translate <1.62+.18+.31,0,0>}
	union{	
		object{key(.23,.35,.04,.3, keyTex, "1", "End") btr(0)*<0,1,1> translate <1.62+.18*2+.31*3,0,0>}
		object{key(.23,.35,.04,.3, keyTex, "2", "DOWN") btr(0)*<0,1,1> translate <1.62+.18*2+.31*4,0,0>}
		object{key(.23,.35,.04,.3, keyTex, "3", "PgDn") btr(0)*<0,1,1> translate <1.62+.18*2+.31*5,0,0>}
		object{key(.23,.72,.04,.3, keyTex, "Enter","") btr(0)*<0,1,1> translate <1.62+.18*2+.31*6,0,0>}
		
	}
	
	union{
		object{key(.23,.35,.04,.3, keyTex, "~", "`") numtr(0)}
		object{key(.23,.35,.04,.3, keyTex, "!", "1") numtr(1)}
		object{key(.23,.35,.04,.3, keyTex, "@", "2") numtr(2)}
		object{key(.23,.35,.04,.3, keyTex, "#", "3") numtr(3)}	
		object{key(.23,.35,.04,.3, keyTex, "$", "4") numtr(4)}
		object{key(.23,.35,.04,.3, keyTex, "%", "5") numtr(5)}
		object{key(.23,.35,.04,.3, keyTex, "^", "6") numtr(6)}
		object{key(.23,.35,.04,.3, keyTex, "&", "7") numtr(7)}
		object{key(.23,.35,.04,.3, keyTex, "*", "8") numtr(8)}
		object{key(.23,.35,.04,.3, keyTex, "(", "9") numtr(9)}
		object{key(.23,.35,.04,.3, keyTex, ")", "0") numtr(10)}
		//object{key(.23,.35,.04,.3, keyTex, "-", "") numtr(11)}
		object{key(.23,.35,.04,.3, keyTex, "\u2014", "\u2013") numtr(11)}
		object{key(.23,.35,.04,.3, keyTex, "+", "=") numtr(12)}
		object{key(.6,.35,.04,.3, keyTex, "Backspace", "") numtr(13)}
	}
	union{
		object{key(.23,.35,.04,.3, keyTex, "Insert", "") numtr(0)*<0,1,1> translate <1.62+.18,0,0>}
		object{key(.23,.35,.04,.3, keyTex, "Home", "") numtr(0)*<0,1,1> translate <1.62+.18+.31*1,0,0>}
		object{key(.23,.35,.04,.3, keyTex, "Page", "Up") numtr(0)*<0,1,1> translate <1.62+.18+.31*2,0,0>}
	}
	union{
		object{key(.23,.35,.04,.3, keyTex, "Num", "Lock") numtr(0)*<0,1,1> translate <1.62+.18*2+.31*3,0,0>}
		object{key(.23,.35,.04,.3, keyTex, "/", "") numtr(0)*<0,1,1> translate <1.62+.18*2+.31*4,0,0>}
		object{key(.23,.35,.04,.3, keyTex, "*", "") numtr(0)*<0,1,1> translate <1.62+.18*2+.31*5,0,0>}
		object{key(.23,.35,.04,.3, keyTex, "\u2013", "") numtr(0)*<0,1,1> translate <1.62+.18*2+.31*6,0,0>}
		
	}
	
	union{
		object{key(.23,kHt,rd,.3,keyTex, "Esc", "") fntr(0)}
		object{key(.23,kHt,rd,.3,keyTex, "F1", "") fntr(2)}
		object{key(.23,kHt,rd,.3,keyTex, "F2", "") fntr(3)}
		object{key(.23,kHt,rd,.3,keyTex, "F3", "") fntr(4)}
		object{key(.23,kHt,rd,.3,keyTex, "F4", "") fntr(5)}
	}
	union{
		object{key(.23,kHt,rd,.3,keyTex, "F5", "") fntr(6)+fnAdj*x}
		object{key(.23,kHt,rd,.3,keyTex, "F6", "") fntr(7)+fnAdj*x}
		object{key(.23,kHt,rd,.3,keyTex, "F7", "") fntr(8)+fnAdj*x}
		object{key(.23,kHt,rd,.3,keyTex, "F8", "") fntr(9)+fnAdj*x}
	}
	union{
		object{key(.23,kHt,rd,.3,keyTex, "F9", "") fntr(10)+fnAdj*2*x}
		object{key(.23,kHt,rd,.3,keyTex, "F10", "") fntr(11)+fnAdj*2*x}
		object{key(.23,kHt,rd,.3,keyTex, "F11", "") fntr(12)+fnAdj*2*x}
		object{key(.23,kHt,rd,.3,keyTex, "F12", "") fntr(13)+fnAdj*2*x}
	}
	union{
		object{key(.23,kHt,rd,.3,keyTex, "Print", "Screen") fntr(0)*<0,1,1> translate <1.62+.18,0,0>}
		object{key(.23,kHt,rd,.3,keyTex, "Scroll", "Lock") fntr(0)*<0,1,1> translate <1.62+.18+.31*1,0,0>}
		object{key(.23,kHt,rd,.3,keyTex, "Pause", "") fntr(0)*<0,1,1> translate <1.62+.18+.31*2,0,0>}
	}
	
		
	
	#declare SBLen = 1.72;
	union{
		object{key(.33,kHt,rd,.3, keyTex, "Ctrl", "") translate <-3,0.06,0.46>}
		object{key(.33,kHt,rd,.3, keyTex, "WIN", "") translate <-3+.33 + 0.08,0.06,0.46>}
		object{key(.33,kHt,rd,.3, keyTex, "Alt", "") translate <-3+.33*2 + 0.08*2,0.06,0.46>}
		object{key(SBLen,kHt,rd,.3, keyTex, "", "") translate <-3+.33*3 + 0.08*3,0.06,0.46>}
		object{key(.33,kHt,rd,.3, keyTex, "Alt", "") translate <-3+.33*3+SBLen + 0.08*4,0.06,0.46>}
		object{key(.33,kHt,rd,.3, keyTex, "WIN", "") translate <-3+.33*4+SBLen + 0.08*5,0.06,0.46>}
		object{key(.33,kHt,rd,.3, keyTex, "MENU", "") translate <-3+.33*5+SBLen + 0.08*6,0.06,0.46>}
		object{key(.33,kHt,rd,.3, keyTex, "Ctrl", "") translate <-3+.33*6+SBLen + 0.08*7,0.06,0.46>}
	}
	
	union{
		object{key(.23,.35,.04,.3, keyTex, "LEFT", "") translate <1.62+.18,0.06,0.46>}
		object{key(.23,.35,.04,.3, keyTex, "DOWN", "") translate <1.62+.18+.31*1,0.06,0.46>}
		object{key(.23,.35,.04,.3, keyTex, "RIGHT", "") translate <1.62+.18+.31*2,0.06,0.46>}
	}
	union{
		object{key(.23+.31,.35,.04,.3, keyTex, "0", "Ins") translate <1.62+.18*2+.31*3,0.06,0.46>}
		object{key(.23,.35,.04,.3, keyTex, ".", "Del") translate <1.62+.18*2+.31*5,0.06,0.46>}
		/*object{key(.42,kHt,rd,.3, keyTex, "Alt", "") translate <-3+.38+.08*1,0.06,0.46>}
		object{key(2.5,kHt,rd,.3, keyTex, "", "") translate <-3+.38+.42+.08*2,0.06,0.46>}
		object{key(.42,kHt,rd,.3, keyTex, "Alt", "") translate <-3+.38+.42+2.5+.08*3,0.06,0.46>}
		object{key(.42,kHt,rd,.3, keyTex, "Ctrl", "") translate <-3+.38+.42+2.5+.42+.08*4,0.06,0.46>}*/
	}
#end //if(keyboard)
	
	scale <kSl,1,kSl>
	rotate <-15,6,0>
	translate <0,.15,.2>
	texture{monTex}
}


sphere_sweep{
	b_spline, 7
	
	/*vrotate(<keyLR,0,keyDepth*.9>,<-15,6,0>) + <.5,.15,.2>, .07
	vrotate(<keyLR,0,keyDepth*.9>,<-15,6,0>) + <0,.1,.2>, .07
	vrotate(<keyLR,0,keyDepth*.9>,<-15,6,0>) + <-.5,.05,.7>, .07
	<keyLR - .7, .2, 2.8>, .07
	<keyLR - .8, .15, 6>, .07
	<keyLR - .4, .12, 10>, .07
	<keyLR + .1, .1, 10>, .07*/
	
	
	// keyLR is negative.  Why I did that is something I don't know.
	vrotate(<keyLR*.9,0,keyDepth>*kSl,<-15,6,0>) + <0,.15,-.2>, .06
	vrotate(<keyLR*.9,0,keyDepth>*kSl,<-15,6,0>) + <0,.085,.0>, .06
	//vrotate(<keyLR*.9,0,keyDepth>*kSl,<-15,6,0>) + <0,-.05,0.7>, .06
	vrotate(<keyLR*.9,0,keyDepth>*kSl,<-15,6,0>) + <-.5*0,-.2,1.1>, .06
	<keyLR, .18, 3.6 + 0.5>, .06
	<keyLR - .4, .12, 4.1 + 0.7>, .06 //****
	<keyLR + .2, .12, 7>, .06
	<keyLR + .5, .12, 10>, .06
	
	
	texture{monTex}
}

sphere_sweep{ //mouse cord
	b_spline, 9
	
	<-keyLR+1.8+.5,.06,2.3>, .04
	<-keyLR+1.2+.5,.04,3.0>, .04
	<-keyLR+.8+.5,.04,4.5>, .04
	<-keyLR - 1+.5,.04, 4.2>, .04
	<0,.04, 3.7>, .04
	<keyLR - 0.4,.22,4.1 +0.7> + y*.02, .04 //****
	<keyLR - 1.6,.12,6.5>, .04
	<keyLR - 0.8,.04,8.0>, .04
	<keyLR +.3, .04, 10.0>, .04

	texture{monTex}
}


#if(moniter)
intersection{
	plane{y,0 inverse rotate <-17,0,0> translate -3*y}
	plane{y,0 rotate <17,0,0> translate 3*y}
	plane{x,0 inverse rotate 17*y translate -3.5*x}
	plane{x,0 rotate -17*y translate 3.5*x}
	clipped_by{plane{z,0.1 inverse}}
	texture{monTex}
	transform{monTrans}
}
#end
#declare paper = height_field{png "hf_paper.png" smooth}

#declare paper = polygon{5 <0,0,0> <1,0,0> <1,0,1> <0,0,1> <0,0,0>}

object{ paper scale <(8.5/11),1,1> scale <7,.1,7>
	pigment{image_map{png "commapp.png" } rotate <90,0,0> scale <(8.5/11),1,1> scale <7,1,7>}
	rotate <0,-20,0>
	translate <-5,.05,.05>
	finish{diffuse .95}
	}

object{paper scale <(8.5/11),1,1> scale <7,.067,7>
	pigment{image_map{png "commapp.png" } rotate <90,0,0> scale <(8.5/11),1,1> scale <7,1,7>}
	rotate <0,-25,0>
	translate <-5.5,.02,.4>
	finish{diffuse .95}
	}

object{ paper  scale <(8.5/11),1,1> scale <7,.033,7>
	pigment{image_map{png "commapp.png" } rotate <90,0,0> scale <(8.5/11),1,1> scale <7,1,7>}
	rotate <0,-32,0>
	translate <-6,.01,.4>
	finish{diffuse .95}
	}

merge{
	torus{.70 .05 translate <0,.05,0>}
	cylinder{<0,0,0> <0,.05,0> .70}
	difference{
		cylinder{<0,.05,0> <0,3.5,0> .75}
		cylinder{<0,.4,0> <0,3.5001,0> .67}
		sphere{<0,0,0> .67 scale <1,.04,1> translate <0,.4,0>}
	}
	torus{.71 .04 translate <0,3.5,0>}
	

	pigment{rgbf 1}
	
	
	interior{
		#if(ref)
			ior 1.5
		#end
		fade_power 2
		fade_distance .5
	}
	#if(!quick & ref)
	finish{specular .2 reflection .15}
	#end
	
	translate <-4.7,.001,3.65>
}
difference{
	sphere{<0,0,0> .67 scale <1,.04,1> translate <0,.4,0>}
	plane{y, .378 inverse }
	pigment{rgbt <0.95, 0.7,0.0,1.0>*.75}
	//pigment{rgbf <1.00, 0.98,0.92,1.0>}
	finish{specular 0.8 reflection .2}
	translate <-4.7,.002,3.65>
}


/*merge{   //no OJ, I drank it.
	cylinder{<0,.39999,0> <0,1.0,0> .66999}
	sphere{<0,0,0> .66999 scale <1,.4,1> translate <0,.39999,0>}
	
	pigment{
		bozo scale .9 pigment_map{
		[0.0 rgb <0.95,0.8,0.1>*.8]
		[1.0 rgb <0.94,0.75,0.1>*.8]
		}
	}
	translate <-4.5,.001,3>
	finish{specular .3}
}*/

	

//width is 6 units
#declare line = polygon{ 7
	<.5+.1,0> <1 + .25, 0.5> <5.5 - .25, 0.5> <6 -.1, 0> 
	 <6.5 - .15, -0.5> <1-.15, -0.5> <.5+.1,0>
}
#declare topline = polygon{ 7
	<.5+.1,0> <1 + .25, 0.1> <5.5 - .25, 0.1> <6 -.1, 0> 
	 <6.5 - .15, -0.5> <1-.15, -0.5> <.5+.1,0>
}


#macro digNumber(digit)
	union{
		#if(digit = 0 | digit = 2 | digit = 3 | digit = 5 | digit = 6 | digit = 7 | digit = 8 | digit = 9)
			object{topline translate <0,6,0>-x*.2}
		#end

		#if(digit = 0 | digit = 2 | digit = 3 | digit = 5 | digit = 6 | digit = 8 | digit = 9)
			object{topline rotate <0,0,180> translate <6,-6,0>+x*.2}
		#end
		
		#if(digit = 0 | digit = 4 | digit = 5 | digit = 6 | digit = 8 | digit = 9)
			object{line rotate <0,0,90>}
		#end
		
		#if(digit = 0 | digit = 1 | digit = 2 | digit = 3 | digit = 4 | digit = 7 | digit = 8 | digit = 9)
			object{line rotate <0,0,90> translate <6,0,0>-y*.4}
		#end
		
		#if(digit = 2 | digit = 3 | digit = 4 | digit = 5 | digit = 6 | digit = 8 | digit = 9)
			object{line}
		#end
		
		#if(digit = 0 | digit = 2 | digit = 6 | digit = 8)
			object{line rotate <0,0,90> translate <0,-6,0>}
		#end
		
		#if(digit = 0 | digit = 1 | digit = 3 | digit = 4 | digit = 5 | digit = 6 | digit = 7 | digit = 8 | digit = 9)
			object{line rotate <0,0,90> translate <6,-6,0>-y*.4}
		#end
		
		scale 1/6*.25
			
			}
#end


difference{
	Round_Box_Union(<-1.1,0,0>, <1.1,1,1.2>, .15)
	box{ <-0.9,0.2,-0.0001> <.9, .8, 0.1> pigment{rgb <0,0,0>} }
	
	pigment{rgb <.1,.1,.1>}
	finish{specular .3}
	
	rotate <0,-35,0>
	translate <-5.25,1,6.5>
}

union{
	disc{<-0.8,0.65,0> <0,0,-1> .035 }
	//object{digNumber(1) translate <-0.8, 0.5, 0> }
	object{digNumber(2) translate <-0.5, 0.5, 0> }
	disc{<-0.1,0.6,0> <0,0,-1> .035}
	disc{<-0.1,0.4,0> <0,0,-1> .035}
	object{digNumber(2) translate <0.0,0.5,0> }
	object{digNumber(3) translate <0.4,0.5,0> }
	rotate <0,-35,0>
	translate <-5.25,1,6.5>
	
	pigment{rgb <1,0,0>}
	finish{ambient 1 diffuse 0}
}		

union{
	cylinder{ <-1.5,0,0> <.8,0,0> .08
		texture{
			/*object{
				text{ttf "Eurosti.ttf" "POV-Write" 10 0 scale <.15,1,.1> rotate <90,0,0> translate <-1.3,1.0,-.05>}
				texture{
					pigment{rgb <0,0,.3>}
					finish{specular .5 diffuse .5}
				}
				texture{
					pigment{rgb <.9,.9,.3>}
					finish{specular 1 metallic diffuse .3 reflection .3}
				}
			}*/
			image_pattern{sys "POV-Write.bmp" map_type 2} scale <1,3.3,1> rotate <0,-75,90> translate <-1.5,0,0>
			texture_map{
				[0
					pigment{rgb <.9,.9,.3>}
					finish{specular 1 roughness 0.5 metallic diffuse .6 reflection .3}
				]
				[1
					pigment{rgb <0,0,.3>}
					finish{specular .05 diffuse .5}
				]
			}
		}
	}
	/*text{ttf "Eurosti.ttf" "POV-Write" 10/.07 0 scale .07 rotate <90,0,0> translate <-1.3,1.0,-.035>texture{
					pigment{rgb <.9,.9,.3>}
					finish{specular 1 metallic diffuse .3 reflection .3}
				}
			}*/
	union{
		cylinder{ <-1.48,0,0> <-1.75,0,0> .085}
		torus{.085, .015 rotate <90,0,0> translate <-1.55,0,0>}
		torus{.085, .015 rotate <90,0,0> translate <-1.6,0,0>}
		torus{.085, .015 rotate <90,0,0> translate <-1.65,0,0>}
		torus{.085, .015 rotate <90,0,0> translate <-1.7,0,0>}
		//torus{.085, .015 rotate <90,0,0> translate <-1.75,0,0>}
		
		pigment{rgb <.8,.6,.3>}
		finish{specular 1 metallic diffuse .3 reflection .3}
	}
	cylinder{<-1.75,0,0> <-1.9,0,0> .08 pigment{ rgb <.9,.3,.3> }}
	cone{<0.8,0,0> .08 <1.00,0,0> 0.08/3 pigment{ rgb <.9,.85,.5> }}
	cone{<1.00,0,0> .08/3 <1.1,0,0> 0.0 pigment{ rgb <0,0,0>}}
	
	
	//rotate <-45,15,-7>
	//translate <keyLR + 1.2, .25,4.55>
	
	rotate <-30,97+180,0>
	translate <keyLR -.65, .085, 2.55> +y*.05
}
