// Persistence of Vision Ray Tracer Scene			
// Fichier        : coquelicot.inc by  Martial Rameaux
// Date           : Mai/Juin 2001 and corected december 2002
// Description    : part of mrhomeweb.pov IRTC Juin 2001
//                  special thanks to Fabien Mosen for the downy mesh around the flowers
//======================================================================================
////// START_FILE //////////////////////////////////////////////////////////////////////
//======================================================================================
//**************************************************************************************
//======================================================================================
#include "transforms.inc"

#declare hasard1=seed(12); // 12 //12 //12,12,12
#declare hasard2=seed(37); // 41 //18 //,17,1225,42
#declare hasard3=seed(187); 

//======================================================================================

//======================================================================================= 
/* By: John VanSickle */
#macro Reorient(Axis1,Axis2)
  #local vX1=vnormalize(Axis1);
  #local vX2=vnormalize(Axis2);
  #local vY=vnormalize(vcross(vX1,vX2));
  #local vZ1=vnormalize(vcross(vX1,vY));
  #local vZ2=vnormalize(vcross(vX2,vY));
  matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
  matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
#end
//======================================================================================= 

//-TEXTURE_FLEURS	
#macro  T_Petal()
texture {
		pigment { image_map { png "map\petal" once}}
		finish {	ambient 0.1 diffuse 0.6 specular .0001 roughness 0.001}
		normal {	bump_map {png "map\petal" once bump_size 5	}
		}
		translate <-.5,-.5,0>
}
#end

#macro  T_Petal2()
texture {
		pigment { image_map {png "map\petal" once }}
		finish {	ambient .1 diffuse 0.8 specular .001 roughness 0.001}
		normal {	bump_map {png "map\petal"	once	bump_size 5	}
		} 
      translate <-.5,-.5,0>
}
#end

#declare Tan0=rgb<0.858824,0.576471,0.539216>;
#declare Green0=rgb<0.4,1,0.4>;
#declare Blue0=rgb<.1,.2,.3>;

                
#declare T_tig=texture{
                  pigment{
                     spotted
                     color_map {
                        [0.0 color Tan0*.4 ]
                        [0.2 color Green0]
                        [0.4 color Blue0 ]
                     }
                     turbulence .9
                   }
                finish {ambient 0.35 diffuse 0.65 phong .01} 
                scale <0.001,1,0.001>
              }

#declare Media_Poil= media {
                   intervals 2
                   samples 1,4 
                   scattering {2, White}
                   density { wrinkles 
                             scale .3 
                             color_map {[0 Black][1 White]}
                            } 
                  }
        
#declare Duvets=material{
            texture { pigment {rgbft <.7,.7,.7,1,.4>} }                
            interior { media {Media_Poil}}
}

           
//====================================================================================

#declare Poils = mesh {
         #declare ra=seed(120);
         #declare rb=seed(1250);
         #declare PRayon = 0.03;//.0015;
         #declare PLong = .13; //.18 
         #declare PBase = .005;
         #declare PHaut = .25;//.1
         
         #declare Pt1 = <PBase/2,0,0>;
         #declare Pt2 = <0,PBase/2,0>;
         #declare Pt3 = <0,0,PLong>;
         
         #declare I=0;
         #while (I < .9)
                #declare PTrans = transform {
                           rotate z*360*rand(ra)
                           translate x*PRayon 
                           rotate y*360*rand(rb) 
                           translate y*PHaut*rand(ra)
                           }
                #declare Ptt1 = vtransform (Pt1,PTrans);
                #declare Ptt2 = vtransform (Pt2,PTrans);
                #declare Ptt3 = vtransform (Pt3,PTrans);
                
                triangle {Ptt1,Ptt2,Ptt3}
               
               #declare I=I+.65435;//.35
         #end
         hollow
}

#macro Poils2(Object)// Sur object  
#declare Norm = <0, 0, 0>; 
#declare Start = <0,0, 0>; 
#declare Inter=trace ( Object, Start,y*-1, Norm ); 
 mesh {
         #declare r2=seed(2);
         #declare PLong = .09; //.3
         #declare PBase = .01;
         
         #declare Pt1 = <PBase/2,0,0>;
         #declare Pt2 = <0,PBase/3,0>;
         #declare Pt3 = <0,0,PLong>;
         
         #declare J=0;
         #while (J<360)
         #declare PRayon =0.12;
         #declare I=0;
         #while (I < 360)
                 
                #declare PTrans = transform {
                           Reorient (z,Inter)
                           translate y*Inter*1.01 
                         //  translate y*Inter 
                           rotate x*I*rand(r2) 
                           rotate z*J*rand(r2) 
                           }
                #declare Ptt1 = vtransform (Pt1,PTrans);
                #declare Ptt2 = vtransform (Pt2,PTrans);
                #declare Ptt3 = vtransform (Pt3,PTrans);
                triangle {Ptt1,Ptt2,Ptt3}  
               #declare I=I+40;
               #end
               #declare J=J+40;
         #end
} 
#end

//=== QUEUES ==========================================================================
//--initialisation des splines
 
#declare Spline1 =
spline {
  cubic_spline
  0,  <-2,-10,0>
  0.2,<-0.05,-2,0> 
  0.4,<0.05,0.0,0>
  0.5,<-0.05,.6,0> 
  0.6,<0.05,.8,0>
  1,<0,1,0>
}

//#init_3d_spline {"Spline2",natural,<0.1,-6,0>,<0,0,0>,<-.1,.5,0>,<0,1,0>} 
//#init_3d_spline {"Spline3",natural,<0,-6,-.2>,<.01,0,.2><0,.8,-.1>,<-.01,1,-.2>,<0,.2,0>} //crosses

//--Macro d'appel des Splines
#macro Mcr_Spline(Spline,rad1,step)
      #local Var=1-(rand(hasard2)*0.01);
      #local Seed1=seed(1236);
      #local Seed2=seed(106);
      #local Seed3=seed(16);
   union  {  
   #local i=0;
   #local j=0; 
      #while (i<1)
         sphere { Spline1(i),rad1 }  
          #if(j<1)
                object {Poils material {Duvets} 
                translate Spline1(j) 
            hollow 
             }
            #local j=j+step+.0003; 
         #end // IF_J
 
         #local i=i+step;
      #end  // While_I
   }
#end // MCR_Spline

#macro Mcr_Spline2(Spline,rad1,step)
      #local Var=1-(rand(hasard2)*0.01);
      #local Seed1=seed(1236);
      #local Seed2=seed(106);
      #local Seed3=seed(16);
   union  {  
   #local i=0;
   #local j=0; 
      #while (i<1)
         sphere { Spline1(i),rad1 }  
          #if(j<1)
                object {Poils material {Duvets} 
                translate Spline1(j) 
            hollow 
             }
            #local j=j+step+.0003; 
         #end // IF_J
 
         #local i=i+step;
      #end  // While_I
   }
#end // MCR_Spline2


//------Randomize les couleurs des Queues---------------------------------------------

#macro Pig_tig() 
   #local Var2=1-(rand(hasard2)*0.32);
   #local Var3=1-(rand(hasard1)*0.32);
   #local P1=pigment{rgb <.3,.85,.1>*Var2} 
   #local P2=pigment{rgb <.3,.50,.8>*Var3}
   #declare T_Queue=
    texture {T_tig}
#end

//-------Declaration des Variables utilis dans les splines
#declare srad1=0.03;
#declare srad2=0.001;
#declare spas=0.001;

//--------appel des Splines------------------------------------------------------------ 

#declare Queue1=object { Mcr_Spline("Spline1",srad1,spas) }   
#declare Queue2=object { Mcr_Spline("Spline2",srad1,spas) }   
#declare Queue3=object { Mcr_Spline("Spline3",srad1,spas) }   
#declare QueueBleuet=object {Mcr_Spline2("Spline2",srad1,spas) }   

//==LES FLEURS =========================================================================   
//--COQUELICOTS-------------------------------------------------------------------------


#macro Coquelicot()  
#local Petal=sphere {0,0.7 scale <2,.8,1> 
      clipped_by{sphere {<0, 0,-0.7>,.5}}
     	T_Petal()
       rotate x*-20*(1+rand(hasard2))
       translate <0,1,0.2>
      #debug "." 
      }
      
#local typ=rand(hasard2);

 #if(typ < 0.5 )  
    union{ 
      object {Queue1 Pig_tig() rotate y*rand(hasard1)*360  } // Coquelicot_Fleur
         union {
               object { Petal}
               object { Petal rotate y*(120-rand(hasard2))}
               object { Petal rotate y*(240-rand(hasard1))}
               object { Petal rotate y*270} 
               #debug "." 
      	   } 
      }
   #end
   #if((typ > 0.5) & (typ < .65) ) // Coquelicot_Graine
   #local Graine= 
      union {
         cone {<0,0,0>0.02,<0,.3,0>0.09 pigment { rgb <0,.5-(rand(hasard1)*.1),0> }}
         cone {<0,.3,0>0.1,<0,.32,0>0 pigment { rgb <0.0,0.5,0.0> } }
         sphere {<0,.32,0>0.09 scale <1,.8,1>}
         scale 2  translate y*.99
         }
      
   union {
      object {Queue2 Pig_tig() rotate y*rand(hasard2)*360}
      object {Graine}
      #debug "." 
       }
   #end//Fin_Coquelicot_Graine 
   
   #if(typ >.65 ) // Coquelicot_bouton  
      #local Bouton=sphere{0,.12}             
      #local FuturFleurs=sphere {Bouton scale <1.15,2.6,.3> pigment {rgb <1,.1,.1> } normal{spotted -10 scale .1} translate y*.08} 
      union {
              object {Queue3 Pig_tig()}
              union {
                 object{Bouton}
                 object { Poils2(Bouton)  material {Duvets}}
                 scale <1,2.5,1> translate y*.1
              }
              object {FuturFleurs}
              #local Rotate=360*rand(hasard2); 
              rotate y*Rotate   
              #debug "." 
      }
   #end//FIN_Coquelicot_bouton
   texture {T_Queue }   
   scale 0.35-(rand(hasard2)*0.2) 
#end //Fin_Macro_Coquelicot


//-CHAMPS DE COQUELICOTS----
#macro ChampCoquelicot(Num_Coq)   
#debug concat ("\nCoquelicot in parse\n")
union {
#local i=0;
#while (i<Num_Coq) //5
        #local k=0;
        #local Coef=.5;//.5
        #while (k<Num_Coq)//5
                   #local j=1.0+(rand(hasard1)*-2.6)+(i*Coef);//definir la largeur -2.2
                   #local l=0;
                   #local ht=(i*.1+rand(hasard2));  //  -.8+
                   #local TRS=<j,0,i*Coef>;
                   object {Coquelicot() translate <j,0,i*Coef> }   
                  #local k=k+1;//.18;
        #end //while_k
     #local i=i+1;
#end//while_i 
#debug "\n"
}
#end//MAcro
//======================================================================================
////// END_FILE  ///////////////////////////////////////////////////////////////////////
//======================================================================================
