// Persistence of Vision Ray Tracer Scene Description File 
// File: PeTIT_ARBRE BONSA.pov suspend ton vol suspended flight Suspended flight(theft)
// Vers: MLpov08.1 by Mael based on povray3.5 
//       download Mlpov http://cathemline.org/mael/mlpov081.zip
// Auth: Martial Rameaux december 2002
// +w600 +h800 +a0.3
// +w768 +h1024 +a0.3

// File and tools  use 
// 3ds Butterfly    http://www.toucan.co.jp/product/3ds/3dsFrameSetE.html
// 3ds Rat find on internet.....
// HDRI  http://www.debevec.org/ 
//      image  from collection01  http://www.akuratny.com/hdri.htm
// PoseRay     http://user.txcyber.com/~sgalls/
// SpilinEditor http://www.flashnet.it/users/fn027571/spil/index.html
// POSER4 model  http://www.curiouslabs.com/
// Xfrog  model Avage Tree  

// render in two passe 
//   the first juste in low resolution 384x512render time: 45mn 
//   the second with saved data in hight resolution 3h41mn35s
//==========================================================================
#version unofficial mlpov 0.8;
//-------------------------------INCLUDES
#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "shapes.inc"
#include "functions.inc"
//----------------------
#include "inc\VASE.inc"
//-------------------------------SWITCH   
#declare Use_RAD=1; //0=no rad; 1=load Rad;  2=save rad data
//------------------------------
#declare ARBRE  =1;
#declare RAPID  =0; 
#declare ATMOS  =1; //Light on the butterfly
#declare PERSN  =1;
#declare GRASS  =1; 
#declare TERRE  =1;
#declare POTSW  =1;
#declare TABLO  =1;
//-------------------------------SETTINGS
global_settings{
     assumed_gamma 2.0
     ambient_light 1.0
     noise_generator 3
     charset utf8
     // radiosity (global illumination) settings 
#if(Use_RAD)
  radiosity{ 
  #if (Use_RAD=2) 
    pretrace_start .001
    pretrace_end   .001
    count 300
    nearest_count 20
    error_bound 1
    recursion_limit 1
    low_error_factor .1
    gray_threshold 0.0
    minimum_reuse 0.0001
    brightness 1.5
    adc_bailout 0.01/2
    save_file "radsvl_67.rad"
  #else
    // load settings  
    pretrace_start 1 pretrace_end 1 
    load_file "radsvl_67.rad" 
    error_bound 1    // it's important to specify the same value used to save data
    recursion_limit 1  // also the same if specified
    always_sample off  // no more samples: specially useful with focal blur
  #end
 }
#end  
}     
//---------------------------------------ENVIRONNEMENT
#declare Cam_Location=<0, 5, -6>;
#declare Cam_Look_at =<0, 0,  4>;
camera {
	location Cam_Location
	right x*image_width/image_height
	up y
	look_at Cam_Look_at
	angle 35//35
}
//---------------------------------------
#declare filename=
"..\\hdr\\probe\\memorial.hdr"
//"..\\HDR\\napavalley"
//"..\\HDR\\collection01\\Parks and Recreation\\park1_s.hdr"

sphere { 
  0,1000000
   pigment { image_map { hdr filename  once interpolate 2 map_type 7 }  }     
   finish { ambient 2.5 diffuse 0 } 
   hollow
  no_shadow
}


//----------------------------
//fog{80 rgbf .01}
//---------------------------------------
#if(ATMOS)
light_source { <20, 50,-10>  <1,1,1.5>*2
        spotlight 
        cylinder
        radius .1 
        falloff 2  
        point_at <-0.5,0,0>  
        fade_distance 30
        fade_power 2
        media_attenuation off   
}
#end//IF_Light
//----END ENVIRONNEMENT
//-------------------------------------- LE POT
#declare Normal_Pot=normal { 
        slope {Cam_Look_at-Cam_Location,0,0.5}
                  normal_map {
                          [0 crackle 2 bump_size 1  scale .05]
                          [1 bozo 2 bump_size 1  scale .05 ]
                   }  
                 turbulence .3
                 accuracy 1
           }  
#declare finPot=finish{ambient 0.3 diffuse 1.5 specular 0.2 roughness 0.1}

#declare T_Pot0=
texture{  

          pigment{
            bumps 
            color_map{
                [.000 color rgb <0.741, 0.460, 0.320>]
                [.383 color rgb <0.706, 0.325, 0.136>]
            } 
            turbulence 10 
            scale .0009
            
            }
        }
        texture{
                pigment{
                      bumps 
                        color_map{
                        [.000 color rgbt 1]
                        [.10 color rgbt  <0.871, 0.353, 0.031>]
                        [.22 color rgbt 1]
                }
                warp {turbulence 1}
                warp {repeat y*5}
                warp {turbulence .5}
                 }
               scale 1 
               finish{finPot}   
               normal {Normal_Pot}
        }
// Texture  
#declare T_Pot=texture{
           pigment_pattern{
                slope {Cam_Look_at-Cam_Location,0,0.5}
                    color_map{
                      [0 rgb 0]
                      [0.5 rgb 0.5]
                      [1 rgb 1]
                    }
           }
           texture_map{
              [0 T_Pot0 finish{diffuse 0.5}]
              [0.5 T_Pot0 finish{diffuse 0.8}]
              [1 T_Pot0 finish{diffuse 1.2 specular .2 roughness .01}]
            }
}
//--------------------------------------
// PLACE FONTE KANJI
#macro KanjiFonte(TEXTE)
     object{   
       Center_Object(text{
          ttf  //   unicode font
          //"msmincho.ttf"
          //"fontes\mimp5.ttc",
          // "msgothic" 
         "arialuni.ttf" 
          TEXTE, 2.5, 0 },  x)
     scale <.2,.25,.6>  translate <0,0.26,-1.8>
     }
#end
//--------------------------------------
#declare Pot=difference {
       object{Pot }
//KanjiFonte("夏 ")     //Automne
//KanjiFonte("冬")      //Hiver
//KanjiFonte("")       //Lointain 
//KanjiFonte("銀杏")    //GINKGO TREE
//KanjiFonte("巨木")   //BIG TREE
//KanjiFonte("植木")   //Plante en Pot

//KanjiFonte("盆栽")   //bonsai
KanjiFonte("一瞬間") //un moment un instant

//KanjiFonte("壷")      //Vase, POT
//KanjiFonte("問")      //Problme Question
//KanjiFonte("安")    //quiet sleep
//KanjiFonte("曇")      //Ombre
//KanjiFonte("有無")   //yes or no, existence
//KanjiFonte("夢想")   //Dream
//KanjiFonte("空想")   //Rverie
//KanjiFonte("育つ")   //Pousser grandir
//KanjiFonte("奉弊")   //Offrande
//KanjiFonte("武徳")   //Martial Arts
//KanjiFonte("韻事")   //artistic poursuite
//KanjiFonte("隠匿者") //hider, person in hiding
//KanjiFonte("隠れん坊")//Jouer  cache-cache
//KanjiFonte("レイトレーシング") //Ray-Tracing
//KanjiFonte("尚武") // martial 
}
//--------------------------------------
// COLOR TERRE
//Macro Fa3ien_Mosen COLOR_ Scan_MAp
#macro ColorMapScan(FichierImage,NombreCoul,Haut)
 #declare PigScan = pigment {image_map {jpeg FichierImage}}
 #local I=0;   
 #while (I < 1)
 [I rgb eval_pigment(PigScan,<I,Haut,.5>)]
  #local I=I+(1/NombreCoul);
 #end  
#end
//-----L'IMAGE SCAN ---------------------
#declare FileMap="map\\017terresable"
//---------------------------------------
#declare ColorMap=color_map{ColorMapScan(FileMap,5,.9)}
 #declare fn_Pigm=function {
    pigment {
      granite
      color_map {
        [0. color rgb 0]
        [1 color rgb 1]
      }
      scale .01
    }
  }
//---- TEXTURE TERREAU  
#declare T_HF=texture{
             //   pigment{function {fn_Pigm(x,y,z).gray}
                 pigment { aoi  Cam_Location//<20, 50,-10> 
                color_map{ColorMap}}
                finish{ambient .3 diffuse .6 } 
                }
//-----------------------------------TERREAU 
#declare F_Sphere=function(x,y,z,Ray,F0,Cut){f_sphere(x, y, z,Ray)- (f_noise3d(x*F0,y*F0,z*F0)/Cut)+fn_Pigm(x/2, y/2, z/2).gray*0.16}
#declare HF=isosurface {
        function { F_Sphere(x, y, z,.65,5,2.8)}  
        threshold 0
        max_gradient 1     
 contained_by { sphere  {0,2.5}}//2.5
}
//-----------------------------------LE POT  
#declare Pot=union{
#if(TERRE)object{HF texture{T_HF} translate y*.5}#end// scale <1.3,1.2,1.3>*1.6 rotate y*90 }
object{Pot  texture {T_Pot} scale <1,1.5,1>} 
scale <2,1,1>
}
//---END POT
//
//
//-----------------------------------L'ARBRE
#if(ARBRE)
// tree via L system
// Oliver Knill, Feb, 11, 2000
//----------------------------GRAINE
#declare R1 = seed(15);
#declare R2 = seed(20);
//----------------------------TEXTURE
#declare Col_Ecorce=color <0.439, 0.478, 0.412>;
#declare T_Ecorce = texture {
        pigment {crackle  
                 color_map { [0 Col_Ecorce] [.5 Tan*.5] [1 White] } 
         }    
        normal{crackle 1 }
        finish {specular .01 roughness .001 ambient .1 diffuse 1}
        scale <.5,-2,1>*.02
}
#declare leaf_texture=
texture {
       pigment {color rgb <.3,1,.3>*rand(R2) filter .5}
         pigment {image_map {tga "map\chene" }}
        //normal{crackle 1 }
        normal {bump_map {tga "map\chene"  bump_size 2}}
        finish {specular .5 roughness .001 ambient .3 diffuse 1}
}
//------------------------
#include "inc\leafteste02.inc" //BY GILLES TRAN
// MakeLeaf(lsize,seg,ll,wl,fl,lpow,al,apow,ndents)
#declare Feuille03 =object{MakeLeaf(.15,40,30,2,.2,1,100,1,0)  } 
 //---------------------------
#declare Feuille=object{Feuille03 texture {leaf_texture}double_illuminate}
//----------------------------
#macro twig(Dev)
        
        #local U=1;
        #if(rand(R2)< .8 ) #local U=-1; #end
        #local dv0=rand(R1)*Dev*.1*U;
        
union {
    sphere {<0,0,0>,0.1        }
    cone {<0,0,0>.1,<.2,dv0,0>, 0.098 }
   
    sphere{<.2,dv0,0>, 0.098}
    cone {<.2,dv0,0>.098,<.3,dv0,0>, 0.095 }
   
    sphere{<.3,dv0,0>, 0.095}
    cone {<.3,dv0,0>.095,<.4,dv0,0>, 0.090 }
   
   
    sphere{<.4,dv0,0>, 0.090}
    cone {<.4,dv0,0>.090,<.5,dv0,0>, 0.085 }
   
    sphere{<.5,dv0,0>, 0.085}
    cone {<.5,dv0,0>.085,<.6,dv0,0>, 0.080 }
   
    sphere{<.6,dv0,0>, 0.080}
    cone {<.6,dv0,0>.080,<.7,dv0,0>, 0.075 }
    
    
    sphere{<.7,dv0,0>, 0.075}
    cone {<.7,dv0,0>.075,<.8,dv0,0>, 0.07 }

    sphere   {<.8,dv0,0>, 0.070}
    cone {<.8,dv0,0>.070,<.9,dv0,0>, 0.065 }
    
    sphere{<.9,dv0,0>, 0.065       }
    cone {<.9,dv0,0>.065,<1,0,0>, 0.060 }
    sphere   {<1,0,0>, 0.060 }
    
    texture  {T_Ecorce}
}
#end
//----------------------------MACRO
#macro draw_twig(Niv,Dev) 
  #if (Niv=0) 
        twig(Dev) 
   #else 
        draw_twig(Niv-1,Dev) 
  #end
#end

#macro draw_leaf(Niv,Dev,ScLf)                 
       #macro Rand_Angle(Ang)  Ang*rand(R1)#end
       #macro Epsilon() #local RD=rand(R1);  1-(RD*.3) #end              
    #if (Niv=0) 
        object{Feuille scale ScLf}
    #else 
        union {           
                object{ draw_twig(Niv-1,Dev) translate -x    }
                object{ draw_leaf(Niv-1,Dev,ScLf) scale Epsilon() rotate z*(Rand_Angle(70))  rotate x*0 } // rotate y*Rand_Angle(5)
                object{ draw_leaf(Niv-1,Dev,ScLf) scale Epsilon() rotate z*(Rand_Angle(70))  rotate x*(85) }
                object{ draw_leaf(Niv-1,Dev,ScLf) scale Epsilon() rotate z*(Rand_Angle(30))  rotate x*(170)}
                translate x scale 0.69
        }     

 #end//IF
#end

#macro draw_plant(i,Dev,ScLf)
  object{ draw_leaf(i,Dev,ScLf) rotate z*90}
#end


//--------------------------------------MAKE ARBRE
#declare Iterat=8;
#declare ScLeaf=0.6;//1.1; 
#if(RAPID)#declare Iterat=5; #declare ScLeaf=0.3;#end
#declare Deviat=5;//8;
#declare Arbre=object{draw_plant(Iterat,Deviat,ScLeaf)}
//-------------
#end//IF_ARBRE 
//-----------------
//------------- END ARBRE

//--------------------------------------FLOOR
#declare T_Sol=
texture {
	 pigment {image_map {jpeg "map\solkamen" } }
                normal  {bump_map  {jpeg "map\solkamen"} bump_size 1 }
		finish {ambient 0.2 diffuse 0.5	specular 0.2} 
		scale <477/640,1,1>
		scale 10 rotate x*90 
} 

#declare Sol=
plane {y,0
	texture {T_Sol}
	hollow
}

//-------------------------------------PERSONNAGES
#if(PERSN)

//Le rat
#include "inc\labrat.inc" //the geometry is in this file
//light_group{
     //  light_source {< 20, 50,  20>  color rgb  1 spotlight radius 1 falloff 2 point_at  <-5.8,.12,14.8>  fade_distance 18 fade_power 2 media_interaction off}
       object{labrat scale .00025 rotate x*-90 rotate y*55 translate <-5.8,.11,14.8> }//13
     //  object{Sol}
   //    global_lights on
//}

//La femme assise 
#include "inc\assise02.inc"
object{assise02 scale 2 rotate y*-55 translate <-.22,.65,-.10>}



//Material definitions papillons 
#declare p_map1=pigment {image_map{png "map\HimeGiT" interpolate 2 filter all 0.5}  }
#declare Material= 
texture {
         pigment{p_map1}
         finish {ambient rgb 0 diffuse .65 reflection{0,.1}}
         }

#include "inc\HimeGifu0.inc"
object{HimeGifu0 double_illuminate scale 2.3 rotate <-110,60,0> rotate x*-50 translate <0.9,3.7,-.8> no_shadow}//scale 1.5  translate <-1.5,0,0> rotate y*190 } translate <0.9,3.7,-.8> 
//------------- END PERSONNAGE
#end //IF_PERSN
//--------------------------------------TABLEAU 
#declare Peinture=texture {pigment{image_map{png "map\tableau" }} finish{ambient 0 diffuse 1}}
#declare Tableau=box{<0,0,0><1,1,0.1> texture{Peinture}}
#declare M_Vitre=material{texture{pigment {rgbf <1,1,1, 1>}finish{ambient 0 diffuse 1 phong .001 reflection .01}}
        interior{ior 1.5}
}
#declare Vitre= box{<-.02,.051,-0.005><1.02,1.052,-0.001> material{M_Vitre} hollow}
#declare Cadre=difference {
      box{<-.05,-.05,-.010><1.05,1.05,0.5>}
      box{<-.02,-.02,-.012><1.02,1.02,0.0>}
      box{<0,0,-.1><1,1,0.8>}
   pigment{rgb 1}
   finish{ brilliance 2 ambient .2 diffuse 1 reflection .01 metallic}
} 

#declare Tableau=union {
//object{Vitre}
object{Cadre}
object{Tableau}   
}
//---END TABLEAU
//
//

//-----------------------------------GRASS
#declare Pat_Herbe = pigment {
	gradient y
	warp { turbulence .2 octaves 3 omega .3 lambda 2 }
	warp { turbulence .7 octaves 3 omega .3 lambda 2 }
	warp { turbulence 1 octaves 3 omega .3 lambda 2 }
	color_map {[0 rgb 0][1 rgb 1]}
}

#declare T_Herbe = 
   material{  // T_Herbe
   texture {
       pigment_pattern {Pat_Herbe}
       texture_map {
       [0.0 pigment { rgb <0.5, 0.7, 0.35>*0.8}finish { diffuse .6 ambient 0.2 specular 0.3 roughness 0.02}]
       [0.6 pigment{ rgb <0.925,0.976,0.533>} finish { diffuse .6 ambient 0.2 specular 0.3 roughness 0.02}]
       [1.0 pigment{ rgb <0.573,0.443,0.090>} finish { diffuse .6 ambient 0.2 specular 0.3 roughness 0.02}]
       }
       scale .5
      }
}
#include "inc\KHGrass.inc"
#declare touffe= object {brin_d_herbe double_illuminate
  material {
    T_Herbe
  }
scale 0.04               
//rotate <90,90,90>
}
#macro Strew (
Objet_support,//objet "parent" sur lequel les autres objets doivent tre disposs
Masque, //Chemin du bitmap qui servira de masque
A_poser, // objets  poser
Taille, // Taille de l'objet
Densite, // "Linature" du balayage: nombre de test= densit au carr
Pente_max, // pas d'objet si pente > Pente_max 
Alt_min, // pas d'objet si plus bas que Alt_min
Alt_max) // pas d'objet si plus haut 
#declare PigMap = pigment {
  image_map {tga Masque once }  translate 0 scale 1 //rotate z*180
}
#local Fun1 =function {pigment {PigMap}} //transformation de l'image en fonction           rand( seed(120)); //

#declare Pente=<0,0,0>;// Initialisation vecteur pente
        #declare S1=seed(154);
        #declare S2=seed(3213);
        #declare S3=seed(225);
        #declare S4=seed(25);
        #declare dir =<0,-1,0>;
        #declare I=0;  
        #while (I<Densite)
         #declare J=0;
            #while (J<Densite)
              #declare depart=<-1+2*(I+rand(S1))/Densite,100,-1+2*(J+rand(S2))/Densite>; 
              #declare Prob2=Fun1(depart.x+0.5,depart.z+0.5,0);            
              #declare point = trace(Objet_support,depart,dir,Pente);       
              #if (Pente.y>Pente_max )                       
             //  #if (point.y > Alt_min)
                       // #if (point.y< Alt_max)
                                #if (Prob2.gray>rand(S4))
                        object {A_poser rotate y*360*rand(S1) scale Taille*Prob2.gray translate point } 
                                #end                                 
                       //  #end
              //  #end
              #end
              #declare J=J+1;
            #end
        #declare I=I+1; 
        #end       
 #end //C'est fini! 
 //#undef Fun1   
    
#declare HF1 = 
 height_field {
 function 500,500 {pigment {wrinkles}}
 translate <-.5,0,-.5>   
}

#if(GRASS)

union{
object {HF1  pigment{rgb 1}}
 Strew(HF1, "map\\suport",touffe,<1,2,1>,100,0,0,2)
 scale <50,3,50>   
 translate <0,-1.8,41>
}
//--------------------------------------COQUELICOTS
#include "inc\coquelicot02.inc"
object { ChampCoquelicot(3) translate <6.2,.75,33>  }
#end//IF_Grass
//--------------------------------------SCREEN
object{Sol}

union {
        #if(ARBRE)object{ Arbre scale 3.5 rotate y*120 translate <0.15,0,-.5>} #end
        #if(POTSW)object {Pot translate y*.01}#end
        scale .7
        rotate y*10
}

#if(TABLO)object{Tableau scale 5 rotate <90,-20,0> translate <-2,0.1,.5>}#end

object{Vase_02    scale 3.5 rotate y*60 translate <2,0.1,10>}  //<2,0.1,8>}


union {
object{Vase_04 texture{T_Pot} scale 1.2} 
#include "inc\agave.inc" object{Agave scale .1 rotate y*45 translate <0,.9,0>}
scale 1.5 translate <7.2,0,20>   
}//  <0,0,2>}//

//--------------------------------------
////////////  END OF FILE  /////////////
//--------------------------------------
