// buggy include for PovRay 3.5
// 2003 by Ron Gow 

#include "colors.inc"
#include "woods.inc"

//  ***************  textures ******************** 

#local med_wood = texture { T_Wood16
    scale .2
    finish { ambient 0 phong .1 }
} 

#local drk_wood = texture { T_Wood12
    scale .2
    finish { ambient 0 phong .2 }
}

#local rim_metal = texture {
    pigment { rgb <.52,.25,.12> }
    normal { wrinkles .15 scale .1 }
    finish { ambient 0 specular .25 phong .3 phong_size 2 brilliance 2 }
} 

#local blk_metal = texture {
    pigment { rgb <.15,.15,.12> }
    finish { ambient 0 specular .35 phong 3 metallic brilliance 2 }
}

#local blk_laq = texture {
    pigment { rgb 0 }
    finish { ambient 0 phong 1 phong_size 220 reflection .1}
} 

#local blk_lth = texture {
    pigment { rgb .0025 }
    finish { ambient 0 phong .2 phong_size 20 specular .2}
}

//  *****************  wheel  *******************

#local i_rim = difference {
    cylinder { <-.025,0,0> <.025,0,0> .60 }  
    cylinder { <-.026,0,0> <.026,0,0> .58 }
}

#local rim = difference {
    cylinder { <-.025,0,0> <.025,0,0> .62 }  
    cylinder { <-.026,0,0> <.026,0,0> .60 }
    texture { rim_metal }
}

#local hub = union {
    cylinder { <-.04,0,0> <.04,0,0> .1 }
    cone { <-.065,0,0>, .075, <-.04,0,0>, .1 }
}

#local cap = union {
    cylinder { <-.08,0,0> <-.075,0,0> .075 }
    #local cnt = 0;
    #while (cnt < 9)
        cylinder { <-.08,0,.06> <-.085,0,.06> .008 
            rotate x*cnt*40
            texture { rim_metal }
        } 
        #local cnt = cnt+1;
    #end
    texture { blk_metal }
}    

#local wheel = union {
    #local cnt = 0;
    #while (cnt < 180)
        cylinder { <0,0,-.58> <0,0,.58> .015 
            texture { med_wood }
            rotate x*cnt 
        } 
        #local cnt = cnt+18;
    #end
    object { hub }
    object { cap }
    object { i_rim }
    object { rim }
    texture { med_wood }
}

//  *****************  spring  ******************

#local leaf = difference {
    difference {
        cylinder { <-.025,0,0> <.025,0,0> .51 }  
        cylinder { <-.026,0,0> <.026,0,0> .50 }
}
    box { <-.026,-.52,-.52> <.026,.26,.52> }
    scale <1,.2,1>
}

#local l_spring = union {
    object { leaf scale <1,.8,1.1> translate y*.02 }
    object { leaf scale <1,.85,1.3> translate y*.01 }
    object { leaf scale <1,1.15,1.6> translate -y*.03 }
    object { leaf scale <1,1.35,1.9> translate -y*.06 }
    box { <-.026,.05,-.025> <.026,.077,.025> 
        rotate -x*5
        translate -z*.45 
    }
    box { <-.026,.05,-.025> <.026,.077,.025> 
        rotate x*5
        translate z*.45 
    }
}

#local spring = union {
    object { l_spring }
    object { l_spring rotate z*180 }
    cylinder { <-.04,0,0> <.04,0,0> .02 scale <1,1,1.6> translate -z*.85 }
    cylinder { <-.04,0,0> <.04,0,0> .02 scale <1,1,1.6> translate z*.85 }
    texture { rim_metal }
}

//  ******************  base  ******************* 

#local b_len = 1.1;

#local brace = union {
    cylinder { <0,0,-.02>  <0,0,.02>  .014 
        scale <11,1,1>
    }
    cylinder { <-.085,0,-.019>  <-.085,0,.019>  .027 }
    cylinder { < .085,0,-.019>  < .085,0,.019>  .027 }
    scale <1,.75,1>
    texture { blk_metal }
}

#local axle =  union {
    sphere_sweep {
        b_spline, 9
        <-1.2,0,0> .03, <-1.1,0,0> .03, <-.7,0,0> .03, <-.32,-.1,0> .03, 
        <0,-.15,0> .03, <.32,-.1,0> .03, <.7,0,0> .03, <1,0,0> .03, 
        <1.2,0,0> .03 
    }
    cylinder { <0,-.085,-.023>  <0,-.085,.023>  .025 
        scale <10,1,1>
    }
    texture { blk_metal }
}

#local clamp = union { 
    cylinder { <0,-.055,-.026>  <0,.05,-.026>  .003 } 
    cylinder { <0,-.055, .026>  <0,.05, .026>  .003 }
    box { <-.006,-.055,-.032> <.006,-.05,.032> }
    box { <-.006,.033,-.032> <.006,.04,.032> }
    texture { rim_metal }
}

#local w_axle = union {
    object { axle }
    
    object { spring scale <.85,1.1,.55> rotate y* 90 translate y*.09 }
    object { brace translate -y*.04}
    object { clamp scale <1,.75,1> translate <.05,-.016,0> }
    object { clamp scale <1,.75,1> translate <-.05,-.016,0> }
}

#local w_pair = union {
    object { w_axle }
    object { wheel translate -x*.9 }
    object { wheel rotate y*180 translate x*.9 }
    texture { drk_wood }
}

#local w_base = union {
    object { w_pair translate -z*b_len }
    object { w_pair translate z*b_len }
    cylinder { <0,-.1,-b_len> <-.23,-.1,b_len> .02 } 
    cylinder { <0,-.1,-b_len> < .23,-.1,b_len> .02 }
    texture { blk_metal }
}

//  ******************  body  *******************

#local b_bot = difference {
    box { <-.4,.1,-(b_len-.035)> < .4,.3,(b_len-.035)> }
    box { <-.36,.15,-(b_len-.04)> < .36,.31,(b_len-.04)> }
    texture { blk_laq }      
}

#local bed = union {
    object { b_bot }
    object { brace translate <0,.22,-b_len>}
    object { brace translate <0,.22, b_len>}
    cylinder { <-.085,.22,-(b_len+.035)> <-.085,.22,-(b_len-.05)> .005 }
    cylinder { < .085,.22,-(b_len+.035)> < .085,.22,-(b_len-.05)> .005 }
    cylinder { <-.085,.22, (b_len+.035)> <-.085,.22, (b_len-.05)> .005 }
    cylinder { < .085,.22, (b_len+.035)> < .085,.22, (b_len-.05)> .005 }
    object { clamp scale <1,.75,1> translate <.05,.2,-b_len> }
    object { clamp scale <1,.75,1> translate <-.05,.2,-b_len> }
    object { clamp scale <1,.75,1> translate <.05,.2, b_len> }
    object { clamp scale <1,.75,1> translate <-.05,.2, b_len> }
    texture { rim_metal }
}

#local f_guard = union {
    box { <-.4,0,-.01> <.4,.35,.01> }
    box { <-.2,-.1,.01> <-.18,.33,.03> }
    box { < .2,-.1,.01> < .18,.33,.03> }
    box { <-.4,0,-.01> <.4,.15,.01> rotate -x*25 translate y*.35}
    texture { blk_laq }   
}

#local s_base = prism {
	cubic_spline
	0, 1, 19,
	<0.055,0.950>, <0.080,0.800>, <0.105,0.460>, <0.170,0.200>,
	<0.275,0.050>, <0.400,0.005>, <0.845,0.010>, <0.965,0.105>,
	<0.950,0.280>, <0.840,0.385>, <0.490,0.400>, <0.325,0.525>,
	<0.270,0.775>, <0.230,0.885>, <0.155,0.955>, <0.000,1.000>,
	<0.055,0.950>, <0.080,0.800>, <0.105,0.460>
    rotate <-90,90,0>
    translate <.5,0,.5>
}

#local s_shape = intersection {
    object { s_base }
    sphere { 0, .9 scale <.75,.85,1> translate <0,.6,-.1>}
}

#local s_back = difference {
    object { s_shape }
    object { s_shape scale <.95,.98,1.1> translate <0..085,-.08> }
    texture { blk_laq }
}

#local seat = union {
    object { s_back }
    sphere { <-.35,-.01,-.3> .02 }
    sphere { < .35,-.01,-.3> .02 }
    sphere { <-.35,-.01,.15> .02 }
    sphere { < .35,-.01,.15> .02 }
    texture { rim_metal }
}

#local r_deck = intersection {
    box { <-.4,0,-.65> <.4,.22,.6> }
    box { <-.41,-.25,-.65> <.41,.19,.7> rotate x*20}    
}

//  ******************  roof  *******************

#local cut1 =  intersection { 
    torus { .5, .1 rotate x*90}
    box { <-.6,0,-.11> <0,.6,.11> }
}

#local cut = union {
    cylinder { <-.49,.5,0> <.49,.5,0> .1 }
    object {cut1 scale <.2,1,1> translate -x*.49}
    object {cut1 scale <.2,1,1> rotate y*180 translate x*.49}
}

#local c_top = difference {
    union {
        box { <-.5,0,-.5> <.5,.3,.5> }
        cylinder { <0,0,-.5> <0,0,.5> .3 scale <.3,1,1> translate -x*.5 }
        cylinder { <0,0,-.5> <0,0,.5> .3 scale <.3,1,1> translate  x*.5 }
    }
    union {
        box { <-.5,0,-.5> <.5,.3,.5> }
        cylinder { <0,0,-.5> <0,0,.5> .3 scale <.3,1,1> translate -x*.5 }
        cylinder { <0,0,-.5> <0,0,.5> .3 scale <.3,1,1> translate  x*.5 }
        scale <.9,1,1.1> translate -y*.1
    }
    box { <-.6,-.51,-.51> <.6,.1,.51> }
    box { <-.6,-.1,-.1> <.6,.32,.1> rotate -x*25 translate -z*.435}
    object { cut scale <1.1,1,1.9> translate <0,-.175,0>}
    object { cut scale <1.1,1,1.6> translate <0,-.175,.35>}
    object { cut scale <1.1,1,1.3> translate <0,-.175,-.32>}
    scale <1,.85,1.5>
    texture { blk_lth }  
}

#local hinge = union {
    cylinder { <0,0,0> <0,.9,0> .005 rotate -x*20 }
    cylinder { <0,0,0> <0,.9,0> .005 rotate x*13 }
    cylinder { <0,0,0> <0,1.05,0> .005 rotate -x*36 }
    cylinder { <0,0,0> <0,1.05,0> .005 rotate x*35 }
    texture { blk_metal }
}

#local hinge_b = union {
    cylinder { <0,0,0> <0,.6,0> .005 }
    cylinder { <-.007,.53,0> <.007,.53,0> .02 }
    cylinder { <0,.53,0> <0,.53,-.9> .005 }
    box { <-.01,-.01,-.1> <.01,.01,.005> rotate -x*10}
    texture { blk_metal }
}

#local roof = union {
    object { hinge translate <-.57,.75,-.2> }
    object { hinge translate < .57,.75,-.2> }
    object { hinge_b rotate x*8 translate <-.57,1,.345> } 
    object { hinge_b rotate x*8 translate < .57,1,.345> }
    object { c_top translate <0,1.5,-.275> }
} 

#local t_bar = sphere_sweep {
    b_spline, 7
    <0,0,.1> .03, <0,0,0> .03, <0,.0,-.3> .03, <0,.40,-.5> .025, 
    <0,.45,-1.5> .02, <0,.50,-2.55> .015, <0,.50,-2.56> .015
}

#local traces = union {
    object { t_bar rotate <8,-4,-4> translate -x*.56 }
    object { t_bar rotate <8, 4,4> translate x*.56 }
    texture { drk_wood }
}

#declare buggy = union {
    object { roof }
    object { r_deck scale <1,1.1,1.2> 
        translate <0,.3,.345> 
        texture { blk_laq } 
    }
    object { seat scale <1.1,.75,.75>  
        translate <0,.55,0> 
    }
    object { f_guard translate <0,.31,-(b_len-.05)> }
    object { traces translate <0,-.05,-b_len> }
    object { w_base }
    object { bed }
}

