/*
IRTC entry January - February 2003
20(C)03 Peter Hertel http://hertel.no/peter
*/

#macro DoWalls(Wall_Any,Wall_Floor,Wall_Roof,Wall_XN,Wall_XP,Wall_Back,Wall_Front)
    #if(Wall_Any)
    #if(Wall_Floor)box{xn-wt,<xp.x+wt,xn.y,xp.z+wt> texture {T_Walls}}#end
    #if(cam_ortho)#else// turns off roof if orthographic camera is set
    #if(Wall_Roof)box{<xn.x-wt,xp.y,xn.z-wt>,xp+wt texture {T_Walls}}#end
    #end
    #if(Wall_XN)box{<xn.x-wt,xn.y,xn.z>,<xn.x,xp.y,xp.z> texture {T_Walls}}#end
    #if(Wall_XP)box{<xp.x,xn.y,xn.z>,<xp.x+wt,xp.y,xp.z> texture {T_Walls}}#end
    #if(Wall_Back)box{<xn.x-wt,xn.y,xp.z>,<xp.x+wt,xp.y,xp.z+wt> texture {T_Walls}}#end
    #if(Wall_Front)
    
    difference{
        box{<xn.x-wt,xn.y,xn.z>,<xp.x+wt,xp.y,xn.z-wt>}
        box{<xn.x+150,xn.y+5,xn.z-wt*2>,<xn.x+230,200,xn.z+1>}// door opening
    //texture {T_Ceramic}
    texture {T_Walls}
    }
    #end
    //outside bathroom
    difference{
        box{xn-z*0.5,<xp.x,xp.y,xn.z-200>}
        union{
            box{<xn.x+150,xn.y+5,xn.z-wt*2>,<xn.x+230,200,xn.z+1> scale 1.0001}
            box{xn-z*0.5+<5,3,-5>,<xp.x,xp.y,xn.z-200>+<-5,-5,5>}
        }
    //pigment {rgb 1}
    pigment {image_map{jpeg "wallpaper.jpg"}scale 25 turbulence 0.01}
    finish {diffuse 0.25}
    }
    //floor outside
    box{xn-z*0.5,<xp.x,4,xn.z-200>
        pigment {image_map{jpeg "floor.jpg" interpolate 2}rotate x*90 scale 50} finish {diffuse 0.05}
    }
    #end
#end

//door handle 16x3 - from "my room" project i did some years ago (never finished, as usual =)
#declare Door_Handle =
union{
        union{
        #local DH = 0.4;
        difference{
                box      {<  DH,DH,-DH>,<3-DH,1.5,0>}
                sphere   {<1.5,DH+0.5,-DH-0.2>,0.4}
        }
                difference{//screw
                        sphere {<0,0,-DH+0.3>,0.4}
                        box {<-1,-0.05,-0.37>,<1,0.05,-1>}
                rotate z*-40
                translate <1.5,DH+0.5,0>
                }
        box      {<  DH,1.5,-DH>,<3-DH,2.5,-DH+0.2>}
        difference{//keyhole
                box  {<  DH,2.5,-DH>,<3-DH,5,-DH+0.2>}
                union{
                        cylinder {<0,0,-1>,<0,0,1>,0.5}
                        prism    {linear_spline -1,1,9,
                                <-0.2,   0>,<-0.2,-0.6>,<-0.5,-0.6>,
                                <-0.3,-2.5>,< 0.3,-2.5>,< 0.5,-0.6>,
                                < 0.2,-0.6>,< 0.2,   0>,<-0.2,   0>
                                rotate x*-90}
                translate <1.5,4.5,0>
                }
        }
        box      {<  DH,  5,-DH>,<3-DH,16-DH-1,-DH+0.2>}
        difference{
                box      {<  DH,16-DH-1,-DH>,<3-DH,16-DH,0>}
                sphere   {<1.5,16-DH-0.5,-DH-0.2>,0.4}
        }
                difference{//screw2
                        sphere {<0,0,-DH+0.3>,0.4}
                        box {<-1,-0.05,-0.37>,<1,0.05,-1>}
                rotate z*-40
                translate <1.5,16-DH-0.5,0>
                }
                //round borders
                cylinder {<  DH,   DH,0>,<3-DH,   DH,0>,DH}
                cylinder {<  DH,   DH,0>,<  DH,16-DH,0>,DH}
                cylinder {<3-DH,   DH,0>,<3-DH,16-DH,0>,DH}
                cylinder {<  DH,16-DH,0>,<3-DH,16-DH,0>,DH}
                sphere   {<  DH,   DH,0>,DH}
                sphere   {<3-DH,   DH,0>,DH}
                sphere   {<  DH,16-DH,0>,DH}
                sphere   {<3-DH,16-DH,0>,DH}
        
        #undef DH
        translate <-1.5,-11.5,0>
        }
        
        union{//Handle
        cylinder {<0,0,0>,<0,0,-1>,1.1}
        cylinder {<0,0,-1.05>,<0,0,-1.2>,1 pigment {rgbf <1,1,1,0.5>} finish {specular 0.5}}
        cylinder {<0,0,0>,<0,0,-2.5>,0.65}
        intersection{
                box {<-4,-1,0>,<0,1,-4>}
                torus {1.5,0.65}
        translate <1.5,0,-2.5>
        }
        cylinder {<1.5,0,-2-2>,<5,0,-2-2>,0.65}
        
        #local DHR = 0.8+0.8;
        blob {threshold 0.5
                cylinder {<2,0,0>,<9,0,0>,DHR,0.8}

                #ifndef (Door_Handle_Detail)
                        #local Door_Handle_Detail = 4;
                #end

                #if (Door_Handle_Detail >= 1)
                        sphere {<3,0,0>,DHR,0.7}
                        sphere {<4,0,0>,DHR,0.7}
                        sphere {<5,0,0>,DHR,0.6}
                        sphere {<6,0,0>,DHR,0.5}
                        sphere {<7,0,0>,DHR,0.3}
                        sphere {<8,0,0>,DHR,0.2}
                #end
                #if (Door_Handle_Detail >= 2)
                        sphere {<3.5,0,0>,DHR,0.7}
                        sphere {<4.5,0,0>,DHR,0.7}
                        sphere {<5.5,0,0>,DHR,0.6}
                        sphere {<6.5,0,0>,DHR,0.5}
                        sphere {<7.5,0,0>,DHR,0.3}
                        sphere {<8.5,0,0>,DHR,0.2}
                #end
                #if (Door_Handle_Detail >= 3)
                        sphere {<3.25,0,0>,DHR,0.7}
                        sphere {<4.25,0,0>,DHR,0.7}
                        sphere {<5.25,0,0>,DHR,0.6}
                        sphere {<6.25,0,0>,DHR,0.5}
                        sphere {<7.25,0,0>,DHR,0.3}
                        sphere {<8.25,0,0>,DHR,0.2}
                #end
                #if (Door_Handle_Detail >= 4)
                        sphere {<3.75,0,0>,DHR,0.7}
                        sphere {<4.75,0,0>,DHR,0.7}
                        sphere {<5.75,0,0>,DHR,0.6}
                        sphere {<6.75,0,0>,DHR,0.5}
                        sphere {<7.75,0,0>,DHR,0.3}
                        sphere {<8.75,0,0>,DHR,0.2}
                #end
                #undef DHR
        #undef Door_Handle_Detail
        
        texture {T_Plastic}
        //pigment {rgb 0.4} finish {phong 0.1 phong_size 50 diffuse 0.1}
        //finish {specular 0.2 reflection 0.01 phong 0.5 phong_size 50 diffuse 0.2}//a more shiny texture
        scale <1,1,0.8>
        translate z*-4
        }

                #ifndef (Door_Handle_Rotate)
                #local Door_Handle_Rotate = 0;
                #end
                        rotate z*(-30*Door_Handle_Rotate)
                #undef Door_Handle_Rotate
        }
texture {T_Metal}
}

#declare Hengsle =
union{
        sphere {<0,0,0>,0.5}
        cylinder {<0,0,0>,<0,8,0>,0.5}
        cylinder {<0,3.9,0>,<0,4.1,0>,0.55 pigment {rgb 0}}
        sphere {<0,8,0>,0.5}
texture {T_Copper_5B}
//translate z*0.5
}


//Door
#macro DoDoor(Door_Rotate,Door_Detail)
    union{
        box{<-80,5,-6>,<-0.25,200,0> texture {T_Door}}
        #if(Door_Detail)  object {Door_Handle                translate <-75,110,-6>}
                          object {Door_Handle scale <1,1,-1> translate <-75,110,0>}   #end
    rotate y*Door_Rotate
    translate <xn.x+230,0,xn.z>
    }
    #if(Door_Detail)
        //hengsler
        union{
            object {Hengsle translate y*150}
            object {Hengsle translate y*50}
        translate <xn.x+230,0,xn.z>
        }
    #end
#end        