/*
IRTC entry January - February 2003
20(C)03 Peter Hertel http://hertel.no/peter
*/

// +w120 +h160
// +w240 +h320
// +w360 +h480
// +w384 +h512
// rad save
// +w480 +h640
// +w600 +h800
// +w768 +h1024


//best not to tamper with these..
#local xn = <-200,0,-150>; // x negative
#local xp = <100,235,100>; // x positive
#local wt = 10; // wall_thickness
#declare TT = 0.1; // Tiles_Thickness

#local cam_ortho = 0;

#declare AL = 0;// Area Lights [9 for final]
#declare R = 0;// radiosity (settings is in t_bathroom.inc)
#declare R_Save = 0;
#declare Rad_Fast = 0;

#declare Focal_Blur = 0;

#declare F = 0;// finish
#declare AT = 0; //Advanced Textures (normals/pigment maps)
#declare D = 1;// details, for rounded off tiles on the walls, and doorknob etc.

//objects
#declare DO_Mirror      = 1;
#declare DO_Tiles       = 1;
#declare DO_KledeHenger = 1;
#declare DO_ToiletPaper = 1;
#declare DO_Ad          = 1;
#declare DO_Remington   = 1;
//meshes
#declare DO_Towel      = 1;
#declare DO_Vask       = 1;//sink, this is what might cause the heavy memory eating..
#declare DO_Handrazor  = 1;
#declare DO_Toilet     = 1;
#declare DO_Toothpaste = 1;

#declare Use_Jaime_Lights = R;

#include "t_bathroom.inc"
#include "o_larger.inc"
#include "o_smaller.inc"

#if(DO_Towel)       #include "meshes/klede.inc"     #end
#if(DO_Vask)        #include "meshes/vask.inc"      #end
#if(DO_Handrazor)   #include "meshes/razor_hand.inc"#end
#if(DO_Toilet)      #include "meshes/toilet.inc"    #end
#if(DO_Toothpaste)
    #include "meshes/toothpaste.inc"
    #include "meshes/ToothBrush_Kid.inc"
    #include "meshes/ToothBrush_Adult.inc"
#end


#if(cam_ortho)
    camera{
        orthographic location (xn+xp)/2+y*300 look_at (xn+xp)/2
    }
    light_source {(xn+xp)/2+y*300 1}
#else
    camera {
        //location <-150,180,xn.z+1> look_at (xn+xp)/2-x*75+y*15 // original view
        location <-100,170,-50> look_at <xn.x+65,122,xp.z-50> //second view
        //look_at <xn.x+100,80+2,xp.z-70> //angle 5 //looking at ad
        //location <50,180,xp.z-1>
            //look_at <-200,0,-150> // look at toilet
            //look_at <-100,100,xn.z+10> angle 35
            //look_at (xn+xp)/2+x*50+y*50 // look at door
    right x up y*1.3333
    angle 60
    //angle 20 //closeup

        #if(Focal_Blur)
            #macro Focal_Blur_Accuracy (FB_Accuracy)
              #declare C = 1-pow(10,-FB_Accuracy);
              confidence C
              #declare V = pow(10,-FB_Accuracy-2);
              variance V 
                            #debug concat(str(C,0,5),"\n")
                            #debug concat(str(V,0,5),"\n")
            #end
            
            #include "DoF.inc"
            
            DoF (<-100,170,-50>, image_width/8 , 60, <xn.x+65,122,xp.z-50>,<-160,100,35>,<-100,120,250>)
            blur_samples 50
            Focal_Blur_Accuracy(6)//[9]
        #end
    }
#end

#if (Use_Jaime_Lights)

  #include "i_lights.inc"      // main light macro
  #include "i_spectra.inc"     // spectrum conversion macros
  #include "i_light_const.inc" // useful constants
      #declare REF_WHITE=ft_daylight;  // predefined film type
      #declare EXPOSURE=<250,250,150>*1.5;             // overall light multiplier
      #declare COLOR_FILTER=0;         // color correction
  // create a light_source for a typical 60 watt incandescent bulb
  #declare incandescent=light(k3200,720,<12,0,0>,<0,12,0>,AL,AL,1,1,1) // predefined Kelvin temp., 720 lumens
  light_source{incandescent translate <20,220,-300>}
  // create a light_source for a typical cool white fluorescent
  #declare cl_cool_fluor=SpectrumToRGB(sp_cool_white_fluor);
  #declare fluorescent=light(cl_cool_fluor,300,<4,0,0>,<0,4,0>,AL,AL,1,1,1); // predefined spectrum, 900 lumens
  //light_source{fluorescent translate <xn.x+75,200,xp.z-25>}

//sphere {<xn.x+75,190,xp.z-5>,50 pigment {rgb x*11} finish {ambient 10}}

#else

    light_source {<20,220,-300> <1,0.9,0.9>}
    light_source {<xn.x+75,200,xp.z-175>, <0.9,0.9,1>}

#end

//*********************************OBJECTS*********************************

//Any,Floor,Roof,XN,XP,Back,Front
DoWalls(1,1,1,1,1,1,1)
//Door_Rotate,Door_Detail
DoDoor(25,D)

#declare Sink_Translate = 100;

//sink thingy
difference{
    box{<xn.x,xn.y,xp.z>,<xn.x+150-TT,80-TT,xp.z-70+TT> texture {T_Walls}}
    box{<-0.99,-2,0.001>,<0.99,1,2> scale 30 translate <xn.x+Sink_Translate,80+2,xp.z-70+TT> texture{T_Vask_Main}}
}

//water?
//box{<-0.99,-0.5,0.001>,<0.99,1,2> scale 30 translate <xn.x+150/2+Sink_Translate,80+2,xp.z-70>}

//Sink
#if(DO_Vask)
    object {vask translate z*-1 scale <1,1,-1>*30 translate <xn.x+Sink_Translate,80+2,xp.z-70>}
        // Wire in sink
        #declare T_OBJ = // object to be traced upon
        union{
            difference{
                box{<xn.x,xn.y,xp.z>,<xn.x+150-TT,80-TT,xp.z-70+TT> texture {T_Walls}}
                box{<-0.99,-2,0.001>,<0.99,1,2> scale 30 translate <xn.x+Sink_Translate,80+2,xp.z-70+TT> texture{T_Vask_Main}}
            }
            object {vask translate z*-1 scale <1,1,-1>*30 translate <xn.x+Sink_Translate,80+2,xp.z-70>}
            plane{y,0}
        }
        #local SP_Start = 1.5;
        #local SP_Length = 11;
        #local SP_Detail = 0.05;
        #local Kabel_Thickness = 0.25;
        #declare Spline=
        spline{
            natural_spline
            #local Q = SP_Start;
            #while (Q < SP_Length)
                Q-SP_Detail,trace(T_OBJ,<-150+Q*10,100,65-cos(Q*4)-Q*1.8>,-y),
            #local Q = Q+SP_Detail;
            #end
            Q+SP_Detail,trace(T_OBJ,<-150+(Q+SP_Detail)*10,100,65-cos(Q*4)-Q*1.8>,-y)
        }
        #local Q = SP_Start-SP_Detail;
        #while (Q < SP_Length)
            #local Point1 = Spline(Q)+y*Kabel_Thickness;
            #local Point2 = Spline(Q+SP_Detail)+y*Kabel_Thickness;
            sphere {Point1,Kabel_Thickness pigment {rgb 1}}
            cylinder {Point1,Point2,Kabel_Thickness pigment {rgb 1}}
            sphere {Point1,Kabel_Thickness pigment {rgb 1} translate z*Kabel_Thickness*1.5}
            cylinder {Point1,Point2,Kabel_Thickness pigment {rgb 1} translate z*Kabel_Thickness*1.5}
        #local Q = Q+SP_Detail;
        #end
    //soap
    #include "functions.inc"
    isosurface{
        function { f_sphere(x*2, y*3, z, 2)-f_noise3d(x*2,y*2,z)*0.5 }
        contained_by{box{<-1,-1,-3>,<1,1,3>}}
        accuracy 0.001
        max_gradient 4
        pigment {rgb 1}
    translate y*0.7
    scale 3
    rotate y*-80
    translate trace(T_OBJ,<-115,100,80>,-y)
    }
#end

#if(DO_Mirror)
box{<-200+10,90,100-0.5>,<-200+140,190,100-0.1>
  pigment {rgb 1}
  finish { reflection {0.9} ambient 0 diffuse 0}  
}
#end

#if(DO_KledeHenger)
    object {Klede_Henger rotate y*90 translate <-200+10,100,-5>}
    object {Klede_Henger rotate y*90 translate <-200+10,155,-5>}

#end

#if(DO_Towel)
    object {Klede(T_MP_Klede1) translate <-0.75,-0.5,0> scale 25 rotate y*90 translate <-200+10,100-0.25,-5>}
    object {Klede(T_MP_Klede2) translate <-0.85,-0.5,0> scale 25 rotate y*90 translate <-200+10,155-0.25,-5>}
#end

#if(DO_Handrazor)
union{
    //object{razor_hand rotate <0,90,85.5> rotate y*25 translate y*0.25 scale 2 translate <xn.x+20,80,xp.z-10>}
    object {razor_hand scale 2.25 rotate <0,90,85.5> rotate y*25 translate y*0.625 translate <xn.x+80,80,xp.z-25>}
    object {Shave_Cup scale 1.25 translate <xn.x+60,80,xp.z-15>}
    object {Shave_Brush translate y*2 scale 1 rotate y*40 translate <xn.x+61,80,xp.z-25>}
translate x*-20
}
#end

#if(DO_Ad)
    object{Remington_Ad translate z*-1 scale 25 rotate y*-48 translate <xn.x+30,80+0.05,xp.z-55>}
#end

#if (DO_Tiles)

#macro Macro_Tiles(Tiles_Start,Tiles_End,Tiles_Transform)

#if(D)
    #declare Tile =
    union{
        box{<-1,-1,-TT>,<1,1,TT>}
        cylinder{<-1,-1,0>,<-1, 1,0>,TT}
        cylinder{< 1,-1,0>,< 1, 1,0>,TT}
        cylinder{<-1,-1,0>,< 1,-1,0>,TT}
        cylinder{<-1, 1,0>,< 1, 1,0>,TT}
        sphere {<-1,-1,0>,TT}                
        sphere {<-1, 1,0>,TT}                
        sphere {< 1, 1,0>,TT}                
        sphere {< 1,-1,0>,TT}
    texture{T_Tiles}
    }    
#else
    #declare Tile = box{<-1,-1,-TT>,<1,1,TT> texture{T_Tiles}}
#end

#local TS = Tiles_Start;
#local TE = Tiles_End;
    #local Y = TS.y;
    #while (Y<=TE.y)
        #local X = TS.x;
        #while(X<=TE.x)
            object {Tile
            scale <6.5,6.5,1> translate <7.5,7.5,0>+<X,Y,0>*15 transform{Tiles_Transform}
            }
        #local X = X+1;
        #end
    #local Y = Y+1;
    #end
#end

    Macro_Tiles(<-200,0,0>/15,<100,235,0>/15,transform{translate z*100})//front wall
    Macro_Tiles(<-155,0,0>/15,<100,235,0>/15,transform{rotate y*-90 translate x*-200})//left wall
    Macro_Tiles(<-100,0,0>/15,<150,235,0>/15,transform{rotate y*90 translate x*100})//right wall
    //tiles at door
    Macro_Tiles(<-100,0,0>/15,<-50,235,0>/15,transform{rotate y*180 translate z*-150})
    difference{
        union{
            Macro_Tiles(<-40,0,0>/15,<-30,235,0>/15,transform{rotate y*180 translate z*-150})
        }
        box{<-80,5.001,-2>,<0,199.999,2> translate <30,0,-150> pigment {rgb x*1}}
    }
    Macro_Tiles(<-100,0,0>/15,<40,235,0>/15,transform{rotate y*180 translate <-10*15,0,-150>})
    difference{
        union{
            Macro_Tiles(<-40,0,0>/15,<40,30,0>/15,transform{rotate y*180 translate <0,13*15,-150>})
        }
        box{<-80,5.001,-2>,<0,199.999,2> translate <30,0,-150> pigment {rgb x*1}}
    }

difference{//top of sink thing
    union{
        Macro_Tiles(<-200,0,0>/15,<-60,70,0>/15,transform{rotate x*90 translate <0,80-TT,30>})
    }
    box{<-0.99,-TT*2,0.001>,<0.99,1,2> scale 30 translate <xn.x+Sink_Translate,80+2,xp.z-70+TT> texture{T_Tiles}}
}
//sink thing front
Macro_Tiles(<-200,-15,0>/15,<-60,70,0>/15,transform{translate <0,5,30+TT>})

//floor
Macro_Tiles(<-200,-150,0>,<100,100,0>,transform{rotate x*90 translate y*0})
#end

#if(DO_Toilet)
    object {toilet rotate y*90 translate <1.5,1,1.5> scale 40 translate <-200,0,-150>}
#end
#if(DO_ToiletPaper)
    object {Toilet_Paper(4) scale 1.5 rotate y*180 translate <-75,100,xn.z+TT>}
#end

#if(DO_Remington)
    object {
    Remington_Shaver
    translate x*-3
    scale 1.6
    rotate y*-45
    translate <xn.x+60,80,xp.z-40>
    }
#end

#if(DO_Toothpaste)
union{
    object{toothpaste scale 3 rotate y*-10 translate <xn.x+5,80,xp.z-41>}

    object {Cup_Toothbrush translate <xn.x+13,80,xp.z-40>}
    object {Cup_Toothbrush translate <xn.x+12,80,xp.z-32>}

    union{
        object {ToothBrush_Kid}
            #local X = -1;
            #while (X <= 1)
                #local Y = 1;
                #while (Y < 7)
                    cylinder {<X/10,Y/10,-0.1>,<X/10,Y/10,-0.4>,0.025 translate y*2.6 pigment {rgb 1.5}}
                #local Y = Y+1;
                #end
            #local X = X+1;
            #end
    scale 4 rotate y*-90 rotate z*19
    translate <xn.x+12,80,xp.z-32>
    }
    #macro ToothBrush_Adult(ToothBrush_Adult_Texture)
    union{
        object {M_ToothBrush_Adult(ToothBrush_Adult_Texture)}
            #local X = -1;
            #while (X <= 1)
                #local Y = 1;
                #while (Y < 10)
                    cylinder {<X/12,Y/12,0.1>,<X/12,Y/12,-0.25>,0.025 translate y*3.1 pigment {rgb 1.5}}
                #local Y = Y+1;
                #end
            #local X = X+1;
            #end
    scale 4 rotate y*-90 rotate z*19
    }
    #end
    object{ToothBrush_Adult(T_ToothBrush_Adult1) rotate y*-20   translate <xn.x+13,80,xp.z-40>}
    object{ToothBrush_Adult(T_ToothBrush_Adult2) rotate y*-102 translate <xn.x+13,80,xp.z-40>}
    object{ToothBrush_Adult(T_ToothBrush_Adult3) rotate y*80   translate <xn.x+13,80,xp.z-32>}
translate z*-10
}
#end

