/*
IRTC entry January - February 2003
20(C)03 Peter Hertel http://hertel.no/peter
*/
global_settings{//rad from jamies rad-save-load.pov
 assumed_gamma 1.0-0.2
 ambient_light 0.0
 max_trace_level 5
 #if (R)
 radiosity{ 
        //cadman
        #if(R_Save)
             pretrace_start 1-0.92*Rad_Fast // 1 for final
             pretrace_end   0.01+0.04*Rad_Fast // 0.01 for final
             count 600-400*Rad_Fast // 600 for final
             nearest_count 5-3*Rad_Fast // 5
             error_bound 0.25
             recursion_limit 5 // 5
             low_error_factor .5
             gray_threshold 0.0
             minimum_reuse 0.05
             brightness 1
             adc_bailout 0.01/1
             normal on
             save_file "bathroom.main.radiosity"
        #else
                pretrace_start 1 pretrace_end 1 
                load_file "bathroom.main.radiosity" 
                error_bound 0.25    // it's important to specify the same value used to save data
                recursion_limit 5  // also the same if specified
                always_sample off  // no more samples: specially useful with focal blur
        #end
 }
 #end
}

#include "metals.inc"

//simple metal texture
#declare F_Metal = 
finish {
#if(F)
    metallic
    //ambient 0.2
    diffuse 0.7
    brilliance 6
    reflection 0.25
    phong 0.75
    phong_size 80
#end
}

#declare T_Metal =
texture {
    pigment{rgb 0.5}
    finish {F_Metal}
}

//the plastic on the door handle
#declare T_Plastic = texture {pigment {rgb 0.4}#if(F)finish {phong 0.1 phong_size 50 diffuse 0.1}#end}

//wall ceramic
#declare F_Ceramic =
finish {
    #if(F)
    diffuse 0.75
    reflection {0.1,0.01}
    specular 0.2
    phong 0.4
    phong_size 80
    #end
}

#declare T_Ceramic =
texture {
    pigment {rgb 1}
    finish {F_Ceramic}
}
//duller wall
#declare T_Walls =
texture {
    pigment {rgb 0.8}
    
}

//tiles
#declare T_Tiles =
texture {
    pigment {rgb 1}
    finish {F_Ceramic}
}

/*
//handklede
#declare T_Handklede1= 
texture {
    //pigment {image_map{png "handklede_klede_auv_map_Kd.png" interpolate 2}}
    //pigment {image_map{png "handklede_green.png" interpolate 2}}
    pigment {image_map{png "handklede_stripes.png" interpolate 2}}
    finish {diffuse 0.75}
}

#declare T_Handklede2= 
texture {
    pigment {image_map{png "handklede_stripes3.png" interpolate 2}}
    finish {diffuse 0.75}
}
*/
//klede (towel)
#declare T_MP_Klede1 =
texture {
    pigment {image_map{jpeg "handklede_stripes_mp.jpg" interpolate 2}}
    finish {diffuse 0.75}
}
#declare T_MP_Klede2 =
texture {
    pigment {image_map{jpeg "handklede_stripes_mp2.jpg" interpolate 2}}
    finish {diffuse 0.75}
}

#include "woods.inc"

#declare T_Door =
texture {
    T_Wood17 scale <15,100,15>
    #if(F)finish {diffuse 0.5 reflection {0.25}}#end
}

// Medium brown
#declare T_Door = 
    texture {  pigment{ P_WoodGrain17A color_map { M_Wood17A } translate x*-10 warp{repeat 1*x offset z*6}}} 
    texture {  pigment{ P_WoodGrain17B color_map { M_Wood17B } translate x*-10 warp{repeat 1*x offset z*6}}}

#declare T_Door = texture {T_Door scale <15,100,15> #if(F)finish {diffuse 0.7 reflection {0.1}}#end}

//vask (sink)
#declare F_Vask_Metal = 
finish {
#if(F)
    metallic
    diffuse 0.7
    brilliance 6
    reflection 0.15
    phong 0.75
    phong_size 80
#end
}

#declare F_Vask_Ceramic =
finish {
#if(F)
    diffuse 0.75
    reflection {0.1,0.01}
    specular 0.1
    phong 0.5
    phong_size 80
#end
}

#declare T_Vask_Kran= 
texture {
    pigment {color rgb <0.705882,0.705882,0.705882>}
    //normal {bumps -0.5 scale <0.001,0.001,1>*5}
    finish {F_Vask_Metal}
}

#declare T_Vask_Kran_Cold= 
texture {
    pigment {color rgb <0,0,1>}
    finish {F_Vask_Metal}
}
#declare T_Vask_Kran_Hot= 
texture {
    pigment {color rgb <1,0,0>}
    finish {F_Vask_Metal}
}
#declare T_Vask_Main= 
texture {
    pigment {color rgb <1,0.773333,0.824218>}
    finish {F_Vask_Ceramic}
}
#declare T_Vask_Sluk= texture {T_Vask_Kran}
#declare T_Vask_Spak= texture {T_Vask_Kran}

//old "hand" razor
#declare T_Razor_Grip= 
texture {
    pigment {rgb 0.5}
    #if(AT)normal {granite 0.5 scale <0.25,0.5,0.25>*0.5}#end
    #if(F)
    finish {
        metallic
        diffuse 0.7
        brilliance 3
        reflection 0.1
        phong 0.25
        phong_size 80
    }
    #end
}
#declare T_Razor_Metal= 
texture {
    pigment {rgb 0.5} 
    #if(F)
    finish {
        metallic
        diffuse 0.7
        brilliance 6
        reflection 0.25
        phong 0.75
        phong_size 80
    }
    #end
    #if(AT)normal {bumps 0.2 scale 0.5}#end
}
#declare T_Razor_Screw= 
texture {T_Razor_Grip}

//Shave cup
#declare T_Shave_Cup =
texture {
    #if(AT)   
        pigment {
        crackle
            color_map{
                [0,rgb <1,1,0.8>]
                [0.1, rgb <0.9,0.9,0.7>]
            }
        turbulence 0.1
        }
        normal {crackle 0.5 turbulence 0.1}
    #else
        pigment {rgb <1,1,0.8>}
    #end
    #if(F)
    finish {
        reflection {0.1,0.01}
        phong 0.1
        phong_size 100
        specular 0.02
        diffuse 0.5
    }
    #end
}

//Shave brush
#declare T_Shave_Brush_Grip = 
texture {
    #if(AT)
        T_Wood13
        rotate 5
        scale 2
    #else
    pigment {rgb <243,213,161>/300}
        #end
    #if(F)
    finish {
        reflection 0.1
        diffuse 0.5
    }
    #end
}
#declare T_Shave_Brush =
texture {
    #if(AT)
        pigment {
            bumps
            color_map{
                #local Q = 0;
                #while (Q < 1)
                    [Q rgb (<124,119,87>*2)/255]
                    [Q+0.2 rgb 1]
                    [Q+0.4 rgb (<124,119,87>*1.75)/255]
                #local Q = Q+0.6;
                #end
            }
        scale <0.1,0.1,2>
        turbulence 0.5
        }                
        normal {bumps 0.1 scale <0.1,0.1,0.5>}
    #else
        pigment {rgb (<124,119,87>*2)/255}
    #end
}


//ad
#declare T_Ad =
texture{
    pigment {image_map{jpeg "ad.jpg" interpolate 2}}
    finish {diffuse 0.8}
}

/*
#declare p_map1=pigment {image_map{jpeg "remington_ad.jpg" interpolate 2 transmit all 0 filter all 0}  }
 
#declare cube1_auv= 
//texture {pigment {color rgb <1,1,1> transmit 0} }
texture {pigment{p_map1} finish{diffuse 0.8}}
*/
//toilet
#declare T_Toilet_Base= 
texture {
    pigment {color rgb <1,0.773333,0.824218>}
    finish {F_Vask_Ceramic}
}
#declare T_Toilet_Flusher= 
texture {
    pigment {rgb 0.1}
    #if(F)finish {specular 0.5}#end
}
#declare T_Toilet_Seat_Upper= 
texture {
    pigment {color rgb <1,0.773333,0.824218>*0.8}
    finish {F_Vask_Ceramic}
}
#declare T_Toilet_Seat_Lower= 
texture {
    pigment {color rgb <1,0.773333,0.824218>*0.8}
    finish {F_Vask_Ceramic}
}

//Toothpaste mesh
#declare T_Paste_Body= 
texture {
    pigment {rgb <0.631373,1-0.1,1>}
    #if(F)finish {specular 0.2 phong 0.4}#end
}
#declare T_Paste_Bottom= 
texture {
    pigment {rgb 0.66}
    #if(F)finish {F_Metal}#end
}
#declare T_Paste_Cap= 
texture {
    pigment {rgb <0.2,0.2,1>*0.25}
}
#declare T_Paste_Top= 
texture {
    pigment {rgb 0.66}
    #if(F)finish {F_Metal}#end 
}

//Toothbrushes and cup
//Finish
#declare F_Plastic = // *_ToothBrush_*
    finish {#if(F)phong 0.5 phong_size 25 specular 0.2 reflection {0.025}#end}

#declare T_Cup_Toothbrush =
texture {
    pigment {rgb <179,214,16>/255}
    finish {F_Plastic}
}

//KID
#declare T_ToothBrush_Kid= 
texture {
        pigment {rgb <0.933333,0.313725,0.172549>} 
        #if(F)finish {F_Plastic}#end
}
#declare T_ToothBrush_Adult1=
texture {
        pigment {rgb <0.313725,0.933333,0.172549>} 
        finish {F_Plastic}
}
#declare T_ToothBrush_Adult2=
texture {
        pigment {rgb 1} 
        finish {F_Plastic}
}
#declare T_ToothBrush_Adult3=
texture {
        pigment {rgb <0.313725,0.172549,0.933333>} 
        finish {F_Plastic}
}
