// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// Persistence of Vision Ray Tracer Scene Description File
// File: blacksmithingtools.pov
// Vers: 3.5
// Desc: blacksmithing tools : a hammer and anvil
// Date: January 16th, 2003
// Auth: Steve Shoopak

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// ----------------------------------------------------------+
// Version: 1.0                                               
//                                                            
// History: 0.1 <Auth> 20030116 - File created.               
//          1.0 <Auth> 20030227 - Scene completed.               
// ----------------------------------------------------------+

// | ------------------------------------------------------- |
// | IRTC Stills Topic: Old Technology                       |
// | ------------------------------------------------------- |
// | Details : Technology which is identifiably "old". Plow, |
// |           shadouf, chariot, aqueduct, square-rigger,    |
// |           printing press, Jacquard loom, cotton gin,    |
// |           telegraph key, vacuum tube radio or computer, |
// |           Sputnik. Modern technology in its formative   |
// |           stages.                                       |
// | ------------------------------------------------------- |
// | Stills Competition Ending : February 28th, 2003         |
// | ------------------------------------------------------- |

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// radiosity ------------------------------------------------+

// used for final render
global_settings {
  radiosity {
    pretrace_start 0.08
    pretrace_end   0.04
    count 350          
    nearest_count 5    
    error_bound 5      
    recursion_limit 5  
    low_error_factor .5
    gray_threshold 0.0 
    minimum_reuse 0.015
    brightness 1       
    adc_bailout 0.01/2
    normal on          
    media on           
  }
}

// standard includes ----------------------------------------+

#include "anvil.inc"
#include "hammer.inc"
#include "stones.inc"
#include "woods.inc"

// lights ---------------------------------------------------+

// :: basic ambient area light
light_source {
  0*x                 // light's position (translated below)
  color rgb 0.1       // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <-40, 80, -40>   // <x y z> position of light
}

// :: spotlight on scene
light_source {
  0*x                     // light's position (translated below)
  color rgb <1,1,1>       // light's color
  spotlight               // this kind of light source
  translate <-15, 30, -30> // <x y z> position of light
  point_at <0, 0, 0>      // direction of spotlight
  jitter              // adds random softening of light
  radius 5                // hotspot (inner, in degrees)
  tightness 100            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 12               // intensity falloff radius (outer, in degrees)
}

// :: spotlight on hardy hole of anvil
light_source {
  0*x                     // light's position (translated below)
  color rgb 0.25          // light's color
  spotlight               // this kind of light source
  translate <3, 10, 2> // <x y z> position of light
  point_at <3, 0, 0>      // direction of spotlight
  jitter              // adds random softening of light
  radius 8                // hotspot (inner, in degrees)
  tightness 10            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 25              // intensity falloff radius (outer, in degrees)
}

// camera ---------------------------------------------------+

camera {
  location  <0.0, 4, -5.0>
  look_at   <-0.25, 1.0, -0.5>
  right     x*image_width/image_height
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// floor/table ----------------------------------------------+

#declare table = box {
  -1,1
  texture
  {
    T_Stone10
    scale <0.5,1,0.25>
  }
  translate -y
  scale <3,0.1,3>
}

// scene ----------------------------------------------------+

#declare scene = merge {
  object { table scale <7,1,7> }
  object { hammer rotate 180*y rotate 95*x rotate y*70 scale 0.125 translate <-0.5,2.25,-0.25> }
  object { anvil }
}

object { scene rotate -y*20 }