// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// Persistence of Vision Ray Tracer Scene Description File
// File: hammer.inc
// Vers: 3.5
// Desc: hammer for blacksmithing tools
// Date: January 23rd, 2003
// Auth: Steve Shoopak

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// ----------------------------------------------------------+
// Version: 1.0                                               
//                                                            
// History: 0.1 <Auth> 20030123 - File created.               
//          0.2 <Auth> 20030215 - Added head.               
//          0.3 <Auth> 20030224 - Added handle.               
//          1.0 <Auth> 20030225 - Hammer finished.               
// ----------------------------------------------------------+

// | ------------------------------------------------------- |
// | IRTC Stills Topic: Old Technology                       |
// | ------------------------------------------------------- |
// | Details : Technology which is identifiably "old". Plow, |
// |           shadouf, chariot, aqueduct, square-rigger,    |
// |           printing press, Jacquard loom, cotton gin,    |
// |           telegraph key, vacuum tube radio or computer, |
// |           Sputnik. Modern technology in its formative   |
// |           stages.                                       |
// | ------------------------------------------------------- |
// | Stills Competition Ending : February 28th, 2003         |
// | ------------------------------------------------------- |

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// standard includes ----------------------------------------+

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// head -----------------------------------------------------+

// head components

// :: headBase
#declare headBase = box { -1,1 }

// :: cutouts
#declare headco = box { -1,1 rotate x*45 }
#declare headro = torus { 1.1625,0.1 rotate 90*z }
#declare headca = difference {
  sphere { 0,3 scale <0.25,0.5,0.5> }
  sphere { 0,3 scale <0.25,0.5,0.5> translate 0.125*x }
}

// :: cutout composite
#declare headComp = union {
  object { headco translate <0,+1.414,-1.414> }
  object { headco translate <0,-1.414,-1.414> }
  object { headco translate <0,+1.414,+1.414> }
  object { headco translate <0,-1.414,+1.414> }
  object { headro scale <20,1,1> }
  object { headca translate -0.5*x }
}

// :: complete hammerhead composite
#declare hammerHead = difference {
  object { headBase }
  object { headComp scale 1.0001 }
}

// :: peen --------------------------------------------------+

// peen components

// :: peenBase + neck
#declare peenBase = box { -1,1 scale <2,1,1> translate -x }

// :: peen stats
#declare peenROS = 0.1;
#declare peenAng = 45;
#declare peenOff = peenROS/sin(radians(peenAng/2));
#declare peenOf2 = peenROS*sin(radians(peenAng/2));

// :: peenRoundover Fill
#declare peenRof = cylinder { 
  -z,z,peenROS
  scale <1.1,1.1,1.001>
  translate <1-peenOff,0,0>
}

// :: cutouts
#declare upeenco = box { -1,1 scale <3,1,1> rotate -z*22.5 }
#declare lpeenco = box { -1,1 scale <3,1,1> rotate +z*22.5 }
#declare peenroc = box { -1,1 scale 1.0001 }

// :: cutout composite
#declare peenComp = union {
  object { upeenco translate <+1.846,+0.765,0> }
  object { lpeenco translate <+1.846,-0.765,0> }
  object { peenroc translate <(1-peenOff)+peenOf2+1,0,0> }
}

// :: complete hammerpeen composite
#declare hammerPeen = merge {
  difference {
    object { peenBase }
    object { peenComp scale 1.0001 }
  }
  object { peenRof }
}

// handle----------------------------------------------------+
#declare hammerHandle = blob {
  threshold 0.75
  #local ind = 0;
  #while(ind<8)
    cylinder { ind*y, 8*y, 1*sin(ind*pi/2.5), 0.25 }
    #local ind = ind + 0.25;
  #end
  texture {
    T_Wood3
    finish { ambient 0.825 }
    scale 1.5
  }
  matrix
  <
    1.25,-0.5,0,
    0,1,0,
    0,0,1,
    0,0,0
  >
  scale y*2
}

// hammer ---------------------------------------------------+

// :: complete hammer composite
#declare hammerComp = merge {
  object { hammerHead scale <1,0.95,0.95> translate -2*x }
  object { hammerPeen translate +2*x }
  object { hammerHandle translate -0.25*x }
}

// :: hammer with texture
#declare hammer = object {
  hammerComp
  texture {
    normal { granite 0.05 }
    pigment { color rgb <0.4, 0.4, 0.5> }
    finish { ambient 0.125 diffuse 0.925 specular 0.625 }
  }
  translate y
}


