// Persistence of Vision Ray Tracer Scene Description File
// File: cassette.inc
// Vers: 3.5
// Desc: macro to create cassette "case"
// Date: 2-11-03
// Auth: James Moore

//macro to create cassette tape with dims <-0.3, 0, -0.0275> to <0.3, 0.4, 0.0275>, label= .png file
#macro cassette (label, tape)

//texture of outer case
#local t_caso=
texture {
	pigment {rgbf <0.9, 0.9, 0.9, 0.85>}
	finish {
    	ambient 0
    	diffuse 0
    	specular 0.7
    	roughness 0.1
    	reflection 0.1
    }
	//normal {gradient z} - test
	normal {
		gradient z
		normal_map {
			[0 gradient z scale 0.1]
			[0.47 gradient z scale 0.1]
			[0.47 agate scale <0.2, 0.05, 0.05>]
			[0.53 agate scale <0.2, 0.05, 0.05>]
			[0.53 gradient z scale 0.1]
			[1 gradient z scale 0.1]
		}
	}
}

//texure of interior of case
#local t_casi=
texture {
	pigment {rgbf <0.9, 0.9, 0.9, 0.85>}
	finish {
		ambient 0
    	diffuse 0
    	specular 0.7
    	roughness 0.1
    	reflection 0.1
    }
	//finish {phong 0.3 phong_size 60 irid {0.25 thickness 0.05}}
}

//interior of outer case
#local i_cas=interior {ior 1.5}

//texture of black pieces inside case
#local t_cas2=
texture {
	pigment {rgb 0.01}
	finish {Dull}
}

//texture of tape around reels
#local t_tape=
texture {
	pigment {rgb <0.15, 0.05, 0.025>}
	finish {F_MetalA}
}

union {
	union {
	
		//outside case
		difference {
			object {
				Round_Box_Merge (<-0.3, -0.2, -0.5>, <0.3, 0.2, 0.5>, 0.025)
				texture {t_caso scale <1, 1, 25>}
				interior {i_cas}
			}
			object {
				Round_Box_Merge (<-0.275, -0.12, -0.5>, <0.275, 0.175, 0.5>, 0.025)
				scale <1, 1, 0.1>
				translate z*-0.5
				texture {
					image_pattern {png label interpolate 2}
					texture_map {
						[0 pigment {rgb 1}]
						[1 t_caso scale <1, 1, 25>]
					}
					translate <-0.5, -0.5, 0>
					scale <0.55, 0.295, 1>
				}
				interior {i_cas}
			}
			object {
				Round_Box_Merge (<-0.275, -0.12, -0.5>, <0.275, 0.175, 0.5>, 0.025)
				scale <1, 1, 0.1>
				translate z*0.5
				texture {t_caso scale <1, 1, 25>}
				interior {i_cas}
			}
			box {<-0.25, 0.165, -0.3>, <-0.21, 1, 0.3> texture {t_casi} interior {i_cas}}
			box {<0.25, 0.165, -0.3>, <0.21, 1, 0.3> texture {t_casi} interior {i_cas}}
			scale <1, 1, 0.04>
		}
		
		//extruding bottom of case
		difference {
			box {<-0.2, -0.001, -0.0275>, <0.2, 0.075, 0.0275>}
			plane {x, 0 inverse rotate z*15 translate x*0.2}
			plane {-x, 0 inverse rotate z*-15 translate x*-0.2}
			translate y*-0.2
			texture {t_caso}
			interior {i_cas}
		}
		
		// holes for reels & cutout at bottom
		clipped_by {
			cylinder {<-0.12, 0.01, -1>, <-0.12, 0.01, 1>, 0.035 inverse}
			cylinder {<0.12, 0.01, -1>, <0.12, 0.01, 1>, 0.035 inverse}		
			cylinder {<-0.12, -0.18, -1>, <-0.12, -0.18, 1>, 0.01 inverse}
			cylinder {<0.12, -0.18, -1>, <0.12, -0.18, 1>, 0.01 inverse}		
			cylinder {<-0.07, -0.175, -1>, <-0.07, -0.175, 1>, 0.01 inverse}
			cylinder {<0.07, -0.175, -1>, <0.07, -0.175, 1>, 0.01 inverse}
			box {<-0.195, -1, -0.0179>, <0.195, 0, 0.0179> inverse}
		}
	}
	
	//tick marks on case between reels
	merge {
		box {<-0.001, -0.02+0.01, -0.02>, <0.001, 0.02+0.01, -0.019>}
		box {<-0.001+0.01, -0.01+0.01, -0.02>, <0.001+0.01, 0.01+0.01, -0.019>}
		box {<-0.001+0.02, -0.01+0.01, -0.02>, <0.001+0.02, 0.01+0.01, -0.019>}
		box {<-0.001+0.03, -0.01+0.01, -0.02>, <0.001+0.03, 0.01+0.01, -0.019>}
		box {<-0.001+0.04, -0.01+0.01, -0.02>, <0.001+0.04, 0.01+0.01, -0.019>}
		box {<-0.001+0.05, -0.02+0.01, -0.02>, <0.001+0.05, 0.02+0.01, -0.019>}
		box {<-0.001-0.01, -0.01+0.01, -0.02>, <0.001-0.01, 0.01+0.01, -0.019>}
		box {<-0.001-0.02, -0.01+0.01, -0.02>, <0.001-0.02, 0.01+0.01, -0.019>}
		box {<-0.001-0.03, -0.01+0.01, -0.02>, <0.001-0.03, 0.01+0.01, -0.019>}
		box {<-0.001-0.04, -0.01+0.01, -0.02>, <0.001-0.04, 0.01+0.01, -0.019>}
		box {<-0.001-0.05, -0.02+0.01, -0.02>, <0.001-0.05, 0.02+0.01, -0.019>}
		texture {t_casi}
		interior {i_cas}
	}
	// paper background inside tape
	difference {
		box {<-0.285, -0.12, -0.018>, <0.285, 0.16, 0.018> hollow}
		box {<-1, -1, -0.0179>, <1, 1, 0.0179>}
		box {<-0.07, -0.03, -1>, <0.07, 0.05, 1>}
		cylinder {<-0.12, 0.01, -1>, <-0.12, 0.01, 1>, 0.037}
		cylinder {<0.12, 0.01, -1>, <0.12, 0.01, 1>, 0.037}
		pigment {rgb 0.25}
	}
	
	//tape around reels
	difference {
		cylinder {<0, 0, -0.0125>, <0, 0, 0.0125>, 0.075}
		cylinder {<0, 0, -1>, <0, 0, 1>, 0.05}
		texture {t_tape normal {wood 1 scale <0.005, 0.005, 1>}}
		translate <-0.12, 0.01, 0>
	}
	difference {
		cylinder {<0, 0, -0.0125>, <0, 0, 0.0125>, 0.1}
		cylinder {<0, 0, -1>, <0, 0, 1>, 0.05}
		texture {t_tape normal {wood 1 scallop_wave scale <0.005, 0.005, 1>}}
		translate <0.12, 0.01, 0>
	}
	
	// reels
	union {
		difference {
			cylinder {<0, 0, -0.0175>, <0, 0, 0.0175>, 0.05}
			cylinder {<0, 0, -1>, <0, 0, 1>, 0.036}
		}
		cylinder {<0, 0.0275, 0>, <0, 0.036, 0>, 0.0035 rotate z*0}
		cylinder {<0, 0.0275, 0>, <0, 0.036, 0>, 0.0035 rotate z*60}
		cylinder {<0, 0.0275, 0>, <0, 0.036, 0>, 0.0035 rotate z*120}
		cylinder {<0, 0.0275, 0>, <0, 0.036, 0>, 0.0035 rotate z*180}
		cylinder {<0, 0.0275, 0>, <0, 0.036, 0>, 0.0035 rotate z*240}
		cylinder {<0, 0.0275, 0>, <0, 0.036, 0>, 0.0035 rotate z*300}
		rotate z*5
		translate <-0.12, 0.01, 0>
		texture {t_cas2}
	}
	union {
		difference {
			cylinder {<0, 0, -0.0175>, <0, 0, 0.0175>, 0.05}
			cylinder {<0, 0, -1>, <0, 0, 1>, 0.036}
		}
		cylinder {<0, 0.0275, 0>, <0, 0.036, 0>, 0.0035 rotate z*0}
		cylinder {<0, 0.0275, 0>, <0, 0.036, 0>, 0.0035 rotate z*60}
		cylinder {<0, 0.0275, 0>, <0, 0.036, 0>, 0.0035 rotate z*120}
		cylinder {<0, 0.0275, 0>, <0, 0.036, 0>, 0.0035 rotate z*180}
		cylinder {<0, 0.0275, 0>, <0, 0.036, 0>, 0.0035 rotate z*240}
		cylinder {<0, 0.0275, 0>, <0, 0.036, 0>, 0.0035 rotate z*300}
		rotate z*37
		translate <0.12, 0.01, 0>
		texture {t_cas2}
	}
	
	// lips on case holding reels
	cylinder {<-0.12, 0.01, -0.02>, <-0.12, 0.01, -0.01>, 0.035 open texture {t_casi} interior {i_cas}}
	cylinder {<-0.12, 0.01, 0.02>, <-0.12, 0.01, 0.01>, 0.035 open texture {t_casi} interior {i_cas}}
	cylinder {<0.12, 0.01, -0.02>, <0.12, 0.01, -0.01>, 0.035 open texture {t_casi} interior {i_cas}}
	cylinder {<0.12, 0.01, 0.02>, <0.12, 0.01, 0.01>, 0.035 open texture {t_casi} interior {i_cas}}
	
	// pegs holding rollers at bottom of case
	difference {
		cylinder {<0.24, -0.17, -0.0199>, <0.24, -0.17, 0.0199>, 0.009}
		cylinder {<0.24, -0.17, -1>, <0.24, -0.17, 1>, 0.005}
		texture {t_casi}
		interior {i_cas}
	}
	difference {
		cylinder {<-0.24, -0.17, -0.0199>, <-0.24, -0.17, 0.0199>, 0.009}
		cylinder {<-0.24, -0.17, -1>, <-0.24, -0.17, 1>, 0.005}
		texture {t_casi}
		interior {i_cas}
	}
	
	// rollers at bottom of case
	difference {
		cylinder {<0.24, -0.17, -0.0195>, <0.24, -0.17, 0.0195>, 0.015}
		cylinder {<0.24, -0.17, -1>, <0.24, -0.17, 1>, 0.009}
		texture {t_cas2}
	}
	difference {
		cylinder {<-0.24, -0.17, -0.0195>, <-0.24, -0.17, 0.0195>, 0.015}
		cylinder {<-0.24, -0.17, -1>, <-0.24, -0.17, 1>, 0.009}
		texture {t_cas2}
	}
	
	// pegs in corners of case
	difference {
		cylinder {<-0.28, 0.18, -0.0195>, <-0.28, 0.18, 0.0195>, 0.0125}
		cylinder {<-0.28, 0.18, -1>, <-0.28, 0.18, 1>, 0.01}
		texture {t_casi}
		interior {i_cas}
	}
	difference {
		cylinder {<0.28, 0.18, -0.0195>, <0.28, 0.18, 0.0195>, 0.0125}
		cylinder {<0.28, 0.18, -1>, <0.28, 0.18, 1>, 0.01}
		texture {t_casi}
		interior {i_cas}
	}
	difference {
		cylinder {<-0.28, -0.18, -0.0195>, <-0.28, -0.18, 0.0195>, 0.0125}
		cylinder {<-0.28, -0.18, -1>, <-0.28, -0.18, 1>, 0.01}
		texture {t_casi}
		interior {i_cas}
	}
	difference {
		cylinder {<0.28, -0.18, -0.0195>, <0.28, -0.18, 0.0195>, 0.0125}
		cylinder {<0.28, -0.18, -1>, <0.28, -0.18, 1>, 0.01}
		texture {t_casi}
		interior {i_cas}
	}
	
	// divider in bottom of case
	difference {
		cylinder {<0, -0.1525, -0.0274>, <0, -0.155, 0.0274>, 0.007}
		cylinder {<0, -0.1525, -1>, <0, -0.155, 1>, 0.005}
		texture {t_casi}
		interior {i_cas}
	}
	prism {
		linear_spline
		-0.0274, 0.0274,
		15,
		<0, 0>, <0.1, -0.015>, <0.19, -0.015>, <0.2, -0.05>, <0.195, -0.05>, <0.185, -0.02>, <0.1, -0.02>, <0, -0.005>,
		<-0.1, -0.02>, <-0.185, -0.02>, <-0.195, -0.05>, <-0.2, -0.05>, <-0.19, -0.015>, <-0.1, -0.015>, <0, 0>
		rotate x*-90
		translate y*-0.15
		clipped_by {
			cylinder {<0, -0.1525, -0.0274>, <0, -0.155, 0.0274>, 0.007 inverse}
			box {<-1, -1, -0.017>, <1, -0.1875, 0.075> inverse}
		}
		texture {t_casi}
		interior {i_cas}
	}
	
	// covers over bottom of case
	union {
		box {<-0.025, -0.2, -0.0274>, <-0.01, -0.195, 0.0274>}
		box {<0.025, -0.2, -0.0274>, <0.01, -0.195, 0.0274>}
		box {<-0.015, -0.2, -0.0274>, <0.01, -0.195, -0.017>}
		box {<-0.015, -0.2, 0.0274>, <0.01, -0.195, 0.017>}
		box {<-0.02, -0.2, -0.0274>, <-0.015, -0.165, -0.017>}
		box {<-0.02, -0.2, 0.0274>, <-0.015, -0.165, 0.017>}
		box {<0.02, -0.2, -0.0274>, <0.015, -0.16, -0.017>}
		box {<0.02, -0.2, 0.0274>, <0.015, -0.16, 0.017>}
		box {<0.02, -0.16, -0.0274>, <0.015, -0.179, 0.0274>}
		translate x*-0.0725
		texture {t_casi}
		interior {i_cas}
	}
	union {
		box {<-0.025, -0.2, -0.0274>, <-0.01, -0.195, 0.0274>}
		box {<0.025, -0.2, -0.0274>, <0.01, -0.195, 0.0274>}
		box {<-0.015, -0.2, -0.0274>, <0.01, -0.195, -0.017>}
		box {<-0.015, -0.2, 0.0274>, <0.01, -0.195, 0.017>}
		box {<-0.02, -0.2, -0.0274>, <-0.015, -0.165, -0.017>}
		box {<-0.02, -0.2, 0.0274>, <-0.015, -0.165, 0.017>}
		box {<0.02, -0.2, -0.0274>, <0.015, -0.16, -0.017>}
		box {<0.02, -0.2, 0.0274>, <0.015, -0.16, 0.017>}
		box {<0.02, -0.16, -0.0274>, <0.015, -0.179, 0.0274>}
		rotate y*180
		translate x*0.0725
		texture {t_casi}
		interior {i_cas}
	}
	
	//ridges on sides of case
	box {<0.3, -0.17, -0.0025>, <0.3025, -0.075, 0.0025> texture {t_casi} interior {i_cas}}
	box {<-0.3, -0.17, -0.0025>, <-0.3025, -0.075, 0.0025> texture {t_casi} interior {i_cas}}
	
	// copper strip and pad
	box {<-0.06, -0.18, -0.01>, <0.06, -0.179, 0.01> texture {T_Copper_5B}}
	box {<-0.007, -0.18, -0.015>, <0.007, -0.19, 0.015> pigment {rgb <1, 1, 0.85>} finish {ambient 0.2}}
	
	//tape between reels
	#if (tape=yes)
		sphere_sweep {
			cubic_spline
			23
			<0.02, 0, 0>, 0.001
			<0.02, 0, 0>, 0.001
			<0.03, 0.05, 0>, 0.001
			<0.05, 0.08, 0>, 0.001
			<0.12, 0.12, 0>, 0.001
			<0.2, 0.1, 0>, 0.001
			<0.24, 0.05, 0>, 0.001
			<0.26, 0, 0>, 0.001
			<0.27, -0.1, 0>, 0.001
			<0.255, -0.175, 0>, 0.001
			<0.235, -0.1875, 0>, 0.001
			<0.2, -0.19, 0>, 0.001
			<0, -0.192, 0>, 0.001
			<-0.2, -0.19, 0>, 0.001
			<-0.235, -0.1875, 0>, 0.001
			<-0.255, -0.175, 0>, 0.001
			<-0.26, -0.1, 0>, 0.001
			<-0.25, 0, 0>, 0.001
			<-0.2, 0.075, 0>, 0.001
			<-0.12, 0.1, 0>, 0.001
			<-0.05, 0.05, 0>, 0.001
			<-0.045, 0, 0>, 0.001
			<-0.04, 0, 0>, 0.001
			texture {t_tape}
			scale <1, 1, 12>
		}
	#end
}
#end

