/* CASTLE.POV - Programmed by Maarten Hofman */
/* 150103: Started programming */
/* 170103: Added bloodstained floor */
/* 200103: Added torches and changed various textures */
/* 210103: Fixed the positions of the torches */
/* 220103: Added chimney */
/* 230103: Added tool rack */
/* 270103: Added more nails */
/* 280103: Added hammer */
/* 290103: Added bucket with water */
/* 030203: Added sword */
/* 040203: Experimented with different stone textures */
/* 210203: Final version */

#include "colors.inc"
#include "stones.inc"
#include "woods.inc"   
#include "golds.inc"
#include "metals.inc"  
#include "functions.inc"

global_settings { radiosity {} } 

light_source { <5,6,1> color White }
light_source { <9,7,5> color White }
light_source { <1,7,5> color White }
light_source { <5,7,9> color White }
light_source { <5,3,5> color Orange fade_distance 3 fade_power 2 }

#declare wallstone = texture {
  T_Stone6
//  T_Grnt17 /* Better */
//  T_Stone18
//  T_Stone24
}

#declare blackwood = texture {
  bozo
  texture_map {
    [0.0 pigment { Black } ]
    [0.8 T_Wood2 ]
  }
}

/* Torches */
cone { <9,6.8,5>,0.15,<10,5,5>,0.05 texture { blackwood } }
cone { <1,6.8,5>,0.15,<0,5,5>,0.05 texture { blackwood } }
cone { <5,6.8,9>,0.15,<5,5,10>,0.05 texture { blackwood } }
sphere { <0,0,0>,0.1 scale <1,2,1> translate <9,7,5> pigment { rgbf <1,1,0.8,0.8> } finish { ambient 0.9 diffuse 0.8 } }
sphere { <0,0,0>,0.1 scale <1,2,1> translate <1,7,5> pigment { rgbf <1,1,0.8,0.8> } finish { ambient 0.9 diffuse 0.8 } }
sphere { <0,0,0>,0.1 scale <1,2,1> translate <5,7,9> pigment { rgbf <1,1,0.8,0.8> } finish { ambient 0.9 diffuse 0.8 } }
cylinder { <9.5,6,5>,<10,6,5>,0.05 texture { T_Brass_1B } }
cylinder { <0.5,6,5>,<0,6,5>,0.05 texture { T_Brass_1B } }
cylinder { <5,6,9.5>,<5,6,10>,0.05 texture { T_Brass_1B } }
                     
camera { 
//  location <5,6,1>
//  look_at <5,2,8>
location <9,7,1>
look_at <2,1,9>
//location <4,5,6>
//look_at <5,4,8>
      
}

#declare bloodwood = texture {
  bozo
  texture_map {
    [0.0 pigment { Red } ]
    [0.2 pigment { Black } ]
    [0.4 T_Wood2 ]
  }
}

#declare bloodwood2 = texture {
  bozo
  texture_map {
    [0.0 pigment { Red } ]
    [0.2 pigment { Black } ]
    [0.4 T_Wood4 ]
  }
}

/* Main room */
difference {
  box {
    <-100,-100,-100>,
    <100,100,100>
  }
  box {
    <-1,-1,-1>,
    <11,11,11>
  }         
  texture {
    brick texture { T_Grnt15 } texture { T_Stone37 }       
    scale 0.2
  }
}

height_field {
  png "wallbw.png"
  smooth    
  rotate <-90,0,0>    
  scale <10,-10,0.5>
  translate <0,10,10>
  texture {
    wallstone
  }
}

height_field {
  png "wallbw.png"
  smooth    
  rotate <-90,0,0>    
  scale <10,-10,0.3>
  rotate <0,90,0>
  translate <10,10,10>
  texture {
    wallstone
  }
}

height_field {
  png "wallbw.png"
  smooth    
  rotate <90,0,0>    
  scale <10,-10,0.2>
  rotate <0,90,0>
  translate <0,0,10>
  texture {
    wallstone
  }
}

/* Ceiling and ceiling support */

box {
  <0,9.9,0>,
  <10,10,10>
  texture {
    blackwood
  }
}
box {
  <0,9,0>,
  <1,10,10>
  texture {
    blackwood
  }
}
box {
  <9,9,0>,
  <10,10,10>
  texture {
    blackwood
  }
}

box {
  <3,9,0>,
  <4,10,10>
  texture {
    blackwood
  }
}

box {
  <6,9,0>,
  <7,10,10>
  texture {
    blackwood
  }
}

box {
  <0,9.5,3>,
  <10,10,3.5>
  texture {
    blackwood
  }
}
box {
  <0,9.5,6>,
  <10,10,6.5>
  texture {
    blackwood
  }
}

/* Floor */
difference {
  box {
    <0,0,0>,
    <10,0.1,10>
  }
  box {
    <1,0.05,0>,
    <1.05,0.2,10>
  }
  box {
    <2,0.05,0>,
    <2.05,0.2,10>
  }
  box {
    <3,0.05,0>,
    <3.05,0.2,10>
  }
  box {
    <4,0.05,0>,
    <4.05,0.2,10>
  }
  box {
    <5,0.05,0>,
    <5.05,0.2,10>
  }
  box {
    <6,0.05,0>,
    <6.05,0.2,10>
  }
  box {
    <7,0.05,0>,
    <7.05,0.2,10>
  }
  box {
    <8,0.05,0>,
    <8.05,0.2,10>
  }
  box {
    <9,0.05,0>,
    <9.05,0.2,10>
  }
  texture {
    bloodwood
  }
}

/* Thing above the fire */
difference {
  box {
    <4.5,10,4.5>,
    <5.5,7.5,5.5>
  }            
  box {
    <4.6,10,4.6>,
    <5.4,7,5.4>
  }
  texture {
    T_Brass_1B
  }
}  
   
difference {
  prism {
    conic_sweep
    linear_spline  
    0,
    1,
    5,
    <-1,-1>,<-1,1>,<1,1>,<1,-1>,<-1,-1>
    scale <1.5,-3,1.5>
    translate <5,9,5>  
  }
  prism {
    conic_sweep
    linear_spline
    0,
    1,
    5,
    <-0.9,-0.9>,<-0.9,0.9>,<0.9,0.9>,<0.9,-0.9>,<-0.9,-0.9>
    scale <1.5,-3,1.5>
    translate <5,8.9,5>
  }
  texture {
    T_Brass_1B
  }
}

#declare clay = pigment {
  gradient y
  color_map {
    [0.0 Sienna]
    [0.9 Sienna]
    [1.0 Black]
  }
  scale 3
}

/* Fireplace */
superellipsoid {
  <0.25,0.25>
  scale <1.5,1.5,0.2>
  translate <5,1.5,3.7>
  pigment {
    clay
  }
}

superellipsoid {
  <0.25,0.25>
  scale <1.5,1.5,0.2>
  translate <5,1.5,6.3>
  pigment {
    clay
  }
}

superellipsoid {
  <0.25,0.25>
  scale <0.2,1.5,1.5>
  translate <6.3,1.5,5>
  pigment {
    clay
  }
}

superellipsoid {
  <0.25,0.25>
  scale <0.2,1.5,1.5>
  translate <3.7,1.5,5>
  pigment {
    clay
  }
}

height_field {
  png "wallbw.png"
  smooth        
  scale <2.5,0.5,2.5>
  translate <3.7,2.5,3.6>
  pigment {
    bozo
    color_map {
      [0.0 Black]
      [0.2 Red]
      [0.4 Black]
      [0.6 Orange]
      [0.8 Black]
      [1 Gray]
    }                 
    scale 0.1
  }
  finish {
    ambient 0.7
    diffuse 0.5
  }
}

/* Blaasbalg */
#declare pusher = prism {
  linear_spline  
  0,
  0.1,
  4,
  <-1,-1>,<1,0>,<-1,1>,<-1,-1>
  scale <1,1,0.5>
  texture {
    T_Wood1  
    rotate <0,90,0>
  }    
}

#declare height = 0.6;

object {
  pusher
  rotate <0,0,15>
  translate <2,height,5>
}              

object {
  pusher
  rotate <0,0,-15>
  translate <2,height+0.5,5>
}

sphere {
  <1.7,height+0.25,5>,0.4
  pigment {
    Brown
  }
}

cylinder {
  <1.2,height-0.4,5>,
  <1.2,height+0.9,5>,0.05
  texture {
    T_Brass_1B
  }
}

cylinder {
  <1.5,height+0.25,5>
  <5,height+0.25,5>,0.1      
  texture {
    T_Brass_1B
  }
}

/* Rack */
box {
  <1,0,9>,
  <1.1,2.8,8.5>
  texture {
    T_Wood1
  }
}

box {
  <3,0,9>,
  <3.1,2.8,8.5>
  texture {
    T_Wood1
  }
}

box {
  <1,0.5,9>,
  <3,0.4,8.5>
  texture {
    T_Wood1
  }
}

difference {
  box {
    <1,2.5,9>,
    <3,2.4,8.5>
  }
  cylinder { 
    <1.5,2.6,8.75>,
    <1.5,2.3,8.75>,0.1
  }
  cylinder { 
    <1.9,2.6,8.75>,
    <1.9,2.3,8.75>,0.1
  }
  cylinder { 
    <2.3,2.6,8.75>,
    <2.3,2.3,8.75>,0.1
  }
  cylinder { 
    <2.7,2.6,8.75>,
    <2.7,2.3,8.75>,0.1
  }
  texture {
    T_Wood1
  }
}

#declare poke = union {
  difference {
    torus {
      0.2,0.04
      rotate <90,0,0>
    }
    box {
      <-1,0,-1>,
      <1,-1,1>
    }
  }
  cylinder {
    <0.2,0,0>,
    <0.2,-2.5,0>,0.04
  }
  texture {
    gradient y
    texture_map {
      [0.8 T_Brass_1B]
      [1.0 pigment { Black } ]
    } 
    scale 3
  }     
  translate <-0.2,2.5,0>
}

object {
  poke
  translate <1.5,0.5,8.75>
}

#declare anvilbase = union {
  cone {
    <-1,0.2,0>,0,
    <0,0,0>,0.2
  }
  box {
    <0,0.2,0.2>,
    <0.2,-0.2,-0.2>
  }
  box {
    <0.2,0.3,0.3>,
    <2,-0.3,-0.3>
  }
  box {
    <0.2,-0.3,0.3>,
    <1,-1,-0.3>
  }
  box {
    <0,-1,-0.5>,
    <1.3,-0.5,0.5>
  }  
}

#declare anvil = difference {
  object {
    anvilbase
  }
  cylinder {
    <-0.3,-0.5,-2>,
    <-0.3,-0.5,2>,0.5
    scale <1.5,1,1>
  }
  cylinder {
    <1.2,-0.5,-2>,
    <1.2,-0.5,2>,0.7
    scale <1.8,1,1>
  }          
  cylinder {
    <-2,-0.5,-0.7>
    <2,-0.5,-0.7>,0.4
  } 
  cylinder {
    <-2,-0.5,0.7>
    <2,-0.5,0.7>,0.4
  }
  cylinder {
    <0.65,-2,-0.7>,
    <0.65,2,-0.7>,0.4
  }
  cylinder {
    <0.65,-2,0.7>,
    <0.65,2,0.7>,0.4
  }
  texture {
    T_Chrome_2B     
    normal {
      bumps 0.5
    }
  }            
}

object {
  anvil
  translate <5,4,8>
}

/* Anvil stand */
box {            
  <4.8,0,7.5>,
  <6.5,3,8.5>
  texture {
    blackwood
  }
}

#declare nail = union {
  difference {
    torus {
      0.4,0.01
      rotate <90,0,0>
    }
    box {
      <-1,-1,-1>,
      <0,1,1>
    }
  }
  box {
    <-0.02,0.38,-0.02>,
    <0.02,0.42,0.02>
  }
  texture {
    T_Chrome_2B
  }
}

object {
  nail
  translate <5.15,3,7.55>
}                         

object {
  nail
  rotate <0,170,0>
  translate <6.1,2.85,7.6>
}

object {
  nail
  translate <5.2,3,8.4>
}                         

object {
  nail
  rotate <0,170,0>
  translate <6.1,2.85,8.4>
}

#declare hammer = union {
  cone {
    <0,-0.5,0>,0.15,
    <0,1.72,0>,0.1
    texture {
      blackwood
    }
  }
  cylinder {
    <0,1.5,-0.15>,
    <0,1.5,0.15>,0.2
    texture {
      T_Brass_1B
    }
  }
  cylinder {
    <-0.5,1.5,0>,
    <0.4,1.5,0>,0.1
    texture {
      T_Brass_1B
    }
  }
  cylinder {
    <-0.5,1.5,0>,
    <-0.25,1.5,0>,0.15
    texture {
      T_Brass_1B
    }
  }
  box {
    <0.4,1.65,-0.15>,
    <0.25,1.35,0.15>
    texture {
      T_Brass_1B
    }
  }
  scale 0.6
}

object {
  hammer  
  rotate <0,30,0>
  translate <1.9,2.5-1.3*0.6,8.75>
}

object {
  hammer
  rotate <0,0,75>  
  rotate <0,5,0>
  translate <7.1,4.34,8>
}

#declare tanghalf = prism {
  linear_sweep
  cubic_spline
  0,
  0.02,
  11,
  <-0.2,-2>,<-0.2,0>,<0.1,2>,<0.3,2.2>,<0.4,2.3>,<0.4,2.5>,<0.3,2.3>,<0.2,2.2>,<0,2>,<-0.2,0>,<-0.2,-2>
  texture {
    T_Brass_1B
  }             
}

#declare pliers = union {
  object {
    tanghalf
  }                      
  object {
    tanghalf
    rotate <0,0,180>
    translate <0.4,0,0>
  }         
  cylinder {
    <0.25,2.1,0.03>,
    <0.25,2.1,-0.03>,0.02 
    texture {
      T_Brass_1B
    }
  }
  scale <0.5,1,1> 
}
       
object {
  pliers
  rotate <-90,0,0>
  rotate <0,90,0>
  translate <2.3,0.5,8.85>
}

object {
  pliers
  rotate <-80,0,0>
  translate <5.5,3,7.45>
}          

/* Bucket */
#declare bucket = union {
  difference {
    cone {
      <0,0,0>,0.5
      <0,1.5,0>,0.8
    }
    cone {
      <0,0.1,0>,0.4
      <0,1.6,0>,0.7
    }
    texture {
      T_Wood1
      rotate <90,0,0>
    }
  }
  difference {
    cone {
      <0,0,0>,0.51
      <0,1.5,0>,0.81
    }
    box {
      <-1,-1,-1>,
      <1,0.3,1>
    }
    box {
      <-1,0.6,-1>,
      <1,0.9,1>
    }
    box {
      <-1,1.2,-1>,
      <1,2,1>
    }
    texture {
      T_Brass_1B
    }
  }
}

object {
  bucket
  translate <2.5,0,3>
}
      
#declare water = material {
  texture {
    pigment {
      color rgbt <1, 1, 1, 1>
    }
    finish {
      ambient 0.0
      diffuse 0.0

      reflection {
        0.0, 1.0
        fresnel on
      }

      specular 0.4
      roughness 0.003
    }
    normal {
      function {
        f_ridged_mf(x, y, z, 0.1, 3.0, 7, 0.7, 0.7, 2)
      } 0.8
//      scale 0.13
    }
  }
  interior {
    ior 1.3
  }
}  

cylinder {
  <2.5,1.2,3>,
  <2.5,1.21,3>,0.65
  material {
    water
  }
}

#declare clay2 = pigment {
  bozo
  color_map {
    [0.0 DarkBrown]
    [1.0 DarkSlateGray]
  }                    
  scale 0.5
}

#declare terracotta = pigment {
  bozo
  color_map {
    [0.0 DarkGreen]
    [1.0 Firebrick]
  }                    
  scale 0.2
}

/* Waterplace */
superellipsoid {
  <0.25,0.25>
  scale <0.2,1,1>
  translate <7.3,1,9.1>
  pigment {
    clay2
  }
}
superellipsoid {
  <0.25,0.25>
  scale <1.5,1,0.2>
  translate <8.6,1,8.3>
  pigment {
    clay2
  }
}

box {
  <7.3,1.5,8.3>,
  <11,1.51,11>
  material {
    water
  }
}

/* Waterpipe */
difference {
  cylinder {
    <8,2.5,11>,
    <8,2.2,9.5>,0.2
  }
  cylinder {
    <8,2.5,11>,
    <8,1.9,8>,0.15
  }
  pigment {
    terracotta
  }
}

#declare sword_handle = lathe {
  cubic_spline
  8,
  <0,-1>,<0,0>,<0.15,0.1>,<0.1,0.2>,<0.1,0.7>,<0.15,0.8>,<0.15,0.9>,<0.15,2>
  texture {
    T_Stone1
  }
}

#declare sword_guard = union {
  box {
    <-0.15,0,-0.2>,
    <0.15,0.1,0.2>
  }
  box {
    <-0.15,0,0>,
    <0.15,0.1,-0.5>
    rotate <-30,0,0>
    translate <0,0,-0.18>
  }
  box {
    <-0.15,0,0>,
    <0.15,0.1,0.5>
    rotate <30,0,0>
    translate <0,0,0.18>
  }
  texture {
    T_Gold_1B
  }
}

#declare sword_blade = cone {
  <0,0,0>,0.15
  <0,4,0>,0
  scale <0.1,1,1>
  texture {
    T_Silver_1B
  }
}
              
#declare sword = union {
  sphere {
    <0,0,0>,0.15
    pigment {
      rgbt <1,0,0,0.8>
    }
    finish {
      ambient 0.7
      diffuse 0.5
    }
  }
  object {
    sword_handle
  }                     
  object {
    sword_guard
    translate <0,0.9,0>
  }
  object {
    sword_blade
    translate <0,1,0>
  }
}
        
object {
  sword
  rotate <90,0,0>
  translate <0.2,3.5,4>
}

/* Places that the sword rests on */
cylinder {
  <0,3.3,4.88>,
  <0.4,3.3,4.88>,0.05
  texture {
    T_Brass_1B
  }
}
              
cylinder {
  <0,3.38,7>,
  <0.4,3.38,7>,0.05
  texture {
    T_Brass_1B
  }
}
