// CROSSCUT.POV                         Jan/Feb 2003              for IRTC "Old Technology"      

 
       
#include "colors.inc" 

background { color rgb < 0.5, 0.5, 1 > }

camera {
        location < 0, 0, -350 >
        look_at  < 0, -20, 0 >    
        angle 48
        }
light_source { < 2500, 4500, -1000 > color White    // for FINAL
                  area_light  100*x, 100*z, 4, 4
                  adaptive 2
                  jitter
              }    
            
                
//FOG *****************************************
                     
fog {                                   // a trace of smoke
       distance 2000
       color rgb < 0.6, 0.6, 1 >
       fog_type 2 
       turbulence 0.8
       turb_depth 0.8
       fog_offset 80
       fog_alt 10
    }   

      
// CROSSCUT SAW **********************************************************************      

#declare Wear =
               texture {
                         pigment {
                                  gradient y
                                  color_map { 
                                             [ 0 color rgb < 0.85, 0.75, 0.5 > ]
                                             [ 0.3 color rgb < 0.95, 0.85, 0.7 > ]   
                                             [ 0.6 color rgb < 0.95, 0.85, 0.7 > ]
                                             [ 1 color rgb < 0.85, 0.75, 0.5 > ]
                                             }
                                        scale 20
                                        turbulence 0.1
                                  }
                         finish { ambient 0.2 }
                       }                       

#declare Rhandle =
                  union {
                          cylinder { < 0, -5, 0 >,< 0, -20, 0 >,0.65
                                     texture { Wear }                                      
                                   }
                          sphere { < 0, 0, 0 >,0.9
                                    scale < 1, 5.6, 1 > 
                                    translate y*-15.5
                                    texture { Wear } 
                                   }         
                          cylinder { < 0, -6.5, 0 >,< 0, -11.5, 0 >,0.7
                                     pigment { color White }
                                     finish { ambient 0.2 }
                                   }         
                          box { < 0, -6.5, -0.065 >,< -6, -11.5, 0 >
                                 pigment { color White }
                              } 
                          sphere { < -5, -9, -0.025 >,0.5 }     
                          sphere { < -3, -7.5, -0.025 >,0.5 }
                          sphere { < -3, -11, -0.025 >,0.5 }
                                  pigment { color White }
                                  finish { ambient 0.2 }
                              
                           translate z*160
                           rotate y*17
                           translate < 0, 160, -160.13 >   
                          }                                                 
#declare Lhandle =
                  union {
                          cylinder { < 0, -5, 0 >,< 0, -20, 0 >,0.65
                                    texture { Wear }
                                   } 
                          sphere { < 0, 0, 0 >,0.9
                                    scale < 1, 5.6, 1 > 
                                    translate y*-15.5
                                    texture { Wear }
                                   }                  
                          cylinder { < 0, -6.5, 0 >,< 0, -11.5, 0 >,0.7
                                     pigment { color White }
                                     finish { ambient 0.2 }
                                   }                  
                          box { < 0, -6.5, -0.065 >,< 6, -11.5, 0 >
                                 pigment { color White }
                              } 
                          sphere { < 5, -9, -0.025 >,0.5 }     
                          sphere { < 3, -7.5, -0.025 >,0.5 }
                          sphere { < 3, -11, -0.025 >,0.5 }
                                  pigment { color White }
                                  finish { ambient 0.2 }
                              
                           translate z*160
                           rotate y*-17
                           translate < 0, 160, -160.13 >   
                          }                                              

#declare Tooth =
                union {
                        box { < -1, -1, -10 >,< 1, 1, 10 >
                                rotate z*45
                                scale < 0.5, 1.25, 1 >
                             }
                        box { < -0.707, -2, -10 >,< -2, 3, 10 > }    
                        box { < 0.707, -2, -10 >,< 2, 3, 10 > } 
                        cylinder { < -1.353, -2, -10 >,< -1.353, -2, 10 >,0.646 }  
                        cylinder { < 1.353, -2, -10 >,< 1.353, -2, 10 >,0.646 }
                        box { < -2, 0, -10 >,< 2, 10, 10 > }
                              translate y*160
                              pigment { color Gray50 }
                              finish { ambient 0.2 }
                      } 

#declare Stan =                                 // saw texture
              texture {
                       pigment {
                                 gradient y
                                 color_map {
                                            [ 0 color rgb < 0.38, 0.34, 0.45 > ]
                                            [ 1 color rgb < 0.78, 0.75, 0.7 > ]
                                           }
                                       scale 13
                                       turbulence 0.1
                                 }
                         finish { ambient 0.3 }
                       }
               texture {
                        pigment {
                                  bozo
                                  color_map {
                                              [ 0 color Clear ] 
                                              [ 0.15 color Clear ]
                                              [ 0.2 color rgbt < 1, 0, 0, 0.5 > ]
                                              [ 0.3 color rgbt < 0.6, 0.4, 0.3, 0.8 > ]
                                              [ 0.5 color rgbt < 0.6, 0.4, 0.3, 0.9 > ]
                                              [ 0.7 color rgbt < 0.7, 0.5, 0.4, 0.9 > ] 
                                              [ 0.85 color Clear ]
                                              [ 1 color Clear ]
                                             }
                                       scale 3
                                        turbulence 1
                                  }
                         finish { ambient 0.2 
                                  metallic
                                 }
                        }                                                             
                                    
#declare Back =
              difference {
                          cylinder { < 0, -12, -160 >,< 0, 0, -160 >,160 }   
                          cylinder { < 0, -12.1, -160 >,< 0, 0.1, -160 >,159.9 } 
                      clipped_by {
                                   box { < -45, -12.5, -20 >,< 45, 5, 10 > }
                                  }
                          translate y*160        
                          texture { Stan translate y*-9 }
                          }
#declare Cutting = 
                  union {
                          object { Tooth }
                          object { Tooth rotate z*1 }
                          object { Tooth rotate z*-1 } 
                          object { Tooth rotate z*2 }
                          object { Tooth rotate z*-2 }    
                          object { Tooth rotate z*3 }
                          object { Tooth rotate z*-3 } 
                          object { Tooth rotate z*4 }
                          object { Tooth rotate z*-4 }          
                          object { Tooth rotate z*5 }
                          object { Tooth rotate z*-5 } 
                          object { Tooth rotate z*6 }
                          object { Tooth rotate z*-6 }    
                          object { Tooth rotate z*7 }
                          object { Tooth rotate z*-7 } 
                          object { Tooth rotate z*8 }
                          object { Tooth rotate z*-8 }        
                          object { Tooth rotate z*9 }
                          object { Tooth rotate z*-9 } 
                          object { Tooth rotate z*10 }
                          object { Tooth rotate z*-10 }    
                          object { Tooth rotate z*11 }
                          object { Tooth rotate z*-11 } 
                          object { Tooth rotate z*12 }
                          object { Tooth rotate z*-12 }          
                          object { Tooth rotate z*13 }
                          object { Tooth rotate z*-13 } 
                          box { < -37, -6, -10 >,< -46, 2, 10 > 
                                  translate y*160
                                  pigment { color Gray50 } 
                              }                                     
                          box { < 37, -6, -10 >,< 46, 2, 10 > 
                                  translate y*160
                                  pigment { color Gray50 } 
                              }  
                                                       
                        } 
                        
#declare Xcut =                                   // Crosscut saw *******************
               union {
                        difference {
                                    object { Back }
                                    object { Cutting }
                                   }
                         object { Rhandle }
                         object { Lhandle } 
                            translate y*-160
                            rotate < 90, 0, -28 >  
                     }                         

   
object { Xcut rotate y*50 translate < -50, -35, -146 > }                               
        
                                                                       
      
// AXE *****************************************************************      
      
#declare Face =
               difference { 
                              box { < -10, 0, -1.65 >,< 2.5, -11, 1.65 > }
                              union {
                                      box { < 3, 0, 0 >,< -11, -12, -3 > 
                                           rotate x*-9.5
                                           translate z*-1.85
                                           }                               
                                       box { < 3, 0, 0 >,< -11, -12, 3 > 
                                            rotate x*9.5
                                            translate z*1.85
                                           }
                                     }       
                              clipped_by {
                                           cylinder { < -4, 0, 3 >,< -4, 0, -3 >,10 }
                                         }
                                  pigment { 
                                            gradient y
                                            color_map {
                                                       [ 0 color Blue ]
                                                       [ 1 color White ]
                                                       }
                                             scale 17
                                             turbulence 0.25
                                             translate y*8
                                           }            
                                  finish { ambient 0.2 }
                             }
#declare Blade =
                difference { 
                             object { Face }
                             union {
                                    cylinder { < 16, 0, -5 >,< 16, 0, 5 >,16 } 
                                    cylinder { < -30, 0, -5 >,< -30, 0, 5 >,22 } 
                                      pigment { color Blue }
                                      finish { ambient 0.2 } 
                                    }  
                             }                                                 
                              
                                                        
#declare Dings =
                 union {
                        box { < -11, 0, -0.5 >,< 0.1, -1.2, 0.5 >
                                 rotate x*-45
                                 translate z*-2.3
                            }                                   
                        box { < -11, 0, -0.5 >,< 0.1, -1.2, 0.5 >
                                 rotate x*45
                                 translate z*2.3
                            } 
                        sphere { < -8, -0.5, -1.65 >,0.3 }  
                        sphere { < -4, -0.5, -1.65 >,0.32 }  
                        sphere { < -5, -0.5, -1.65 >,0.3 }  
                        sphere { < -4, -0.5, 1.65 >,0.32 } 
                         pigment { color rgb < 0.1, 0.3, 1 > }
                         finish { ambient 0.2 } 
                        }                                       

#declare Axehead = 
                  difference { 
                               union { 
                                       box { < 0, -0.5, -1.65 >,< -8, -11, 1.65 > }
                                       object { Blade translate y*-10 } 
                                             pigment { color Blue }
                                             finish { ambient 0.2 }
                                     }
                               object { Dings }
                             }                                    
                           

#declare Axehandle =
                 difference {
                   sphere_sweep {
                                 cubic_spline 
                                 11
                                 < -3, -5.7, 0 >,3.3,
                                 < 0, -5.7, 0 >,3.3,
                                 < 3, -5.7, 0 >,3.3,
                                 < 13, -6.2, 0 >,2.3,
                                 < 23, -6.6, 0 >,2.0,
                                 < 33, -6.8, 0 >,2.0,
                                 < 43, -6.5, 0 >,2.0,
                                 < 58, -4.5, 0 >,2.0,
                                 < 64, -4.2, 0 >,2.5,
                                 < 70, -5, 0 >,3.0,
                                 < 75, -7, 0 >,3.0 
                                 scale < 1, 1, 0.5 > 
                                 pigment { color Yellow }
                                 finish { ambient 0.2 }
                                 }
                     union {
                             box { < 0, -7, -4 >,< 4, 0, 4 > }
                             box { < 0, 0, -4 >,< 4, -7, 4 >
                                     rotate z*-45
                                     translate y*-5
                                 }
                                 translate < 70, 0, 0 >                      
                                 pigment { color Yellow }
                                 finish { ambient 0.2 }
                                 }
                            } 
#declare Axe =
               union {                                 
                       object { Axehandle  }
                       object { Axehead scale < 1.25, 1, 1 > }       
                       scale 0.4
                     }
// sledgehammer  *************************************************

#declare Hamhead =
                   union {
                           cylinder { < 0, 3.25, 0 >,< 0, -3.25, 0 >,1.25 }
                           superellipsoid { < 0.25, 0.25 >
                                              scale < 1.25, 1.4, 1.25 >
                                          }    
                           
                           sphere { < 0, 0, 0 >,1.25
                                      scale < 1, 0.25, 1 >
                                      translate y*3.25
                                  }                         
                                  sphere { < 0, 0, 0 >,1.25
                                      scale < 1, 0.25, 1 >
                                      translate y*-3.25
                                  } 
                               pigment { color Gray45 }
                               finish { ambient 0.2 }
                         }
#declare Hamhandle =
                     cylinder { < -1.5, 0, 0 >,< 28.5, 0, 0 >,0.75
                                  scale < 1, 1, 0.8 >
                                  pigment { color rgb < 0.8, 0.75, 0.5 > }
                                  finish { ambient 0.2 }
                              }
#declare Hammer =
                    union {
                           object { Hamhead }
                           object { Hamhandle }
                           }
object { Hammer rotate z*90 rotate x*45 translate < 50, -51.5, -85 > } 


// Wedges ******************************************************* 


#declare Wedge =
                 union { 
                             superellipsoid { < 0.25, 0.25 >
                                              scale < 0.5, 1.25, 2 >
                                            } 
                             difference {
                                          superellipsoid { < 0.25, 0.25 >
                                                 scale < 6, 1.25, 2 >
                                                 translate < -5.6, -1.25, 0 > 
                                                 rotate z*7
                                                 translate y*1.4
                                                }
                                           box { < 0, 0, -2.5 >,< -15, -3, 2.5 >
                                                  rotate z*-7
                                                  translate y*-1.2
                                                }
                                          } 
                                        pigment { color rgb < 0.45, 0.45, 0.5 > }
                                        finish { ambient 0.2 }
                        }
object { Wedge rotate y*-30 translate < 40, -51, -90 > }                                                                
                                                                                                                         
#declare Row =
               union {
                       object { Wedge rotate y*-90 }
                       object { Wedge rotate y*160 translate < -6, 0, 10 > }   
                       object { Wedge rotate y*190 translate < -5, 0, 18  > }  
                       object { Wedge rotate y*16 translate z*25 } 
                       rotate z*-8
                     }
object { Row rotate y*60 translate < -50, -2.5, -95 > } 

  

                                             
// TREETRUNK ***********************************************************    



#declare Stringy =
                  texture {
                            pigment {
                                      gradient z
                                      color_map { 
                                                  [ 0  color rgb < 1, 0.6, 0.5 > ]  
                                                  [ 0.2  color rgb < 1, 0.6, 0.5 > ] 
                                                  [ 0.4  color rgb < 0.7, 0.5, 0.4 > ]
                                                  [ 1  color rgb < 0.7, 0.5, 0.4 > ]
                                                  
                                                 }
                                           scale 3 
                                           translate z*3
                                    } 
                             normal { dents 1 scale < 0.15, 5, 1 > rotate z*-15 turbulence 1 }
                             finish { ambient 0.2 } 
                           }          
 
                       texture {
                            pigment {  color Clear }
                                     
                             normal { dents 1 scale < 0.15, 5, 1 > rotate z*15 turbulence 1 }
                             finish { ambient 0.2 } 
                           }                                    
                                                                
#declare Bbark =                                    // bark of log
                 sphere_sweep {
                               cubic_spline
                               20
                               < 0, 0, -20 >,3.3,
                               < 0.75, 5, -20 >,2.7,
                               < 0, 10, -20 >,3.5,
                               < -0.5, 15, -20 >,2.6,
                               < 0, 20, -20 >,3.2,
                               < 0.9, 25, -20 >,2.9,
                               < -0.75, 30, -20 >,3.3,
                               < 0, 35, -20 >,2.8,
                               < 0.75, 40, -20 >,3.4,
                               < 0, 45, -20 >,2.8     
                               < 0, 50, -20 >,3.3,
                               < 0.75, 55, -20 >,2.7,
                               < 0, 60, -20 >,3.5,
                               < -0.5, 65, -20 >,2.6,
                               < 0, 70, -20 >,3.2,
                               < 0.9, 75, -20 >,2.9,
                               < -0.75, 80, -20 >,3.3,
                               < 0, 85, -20 >,2.8,
                               < 0.65, 90, -20 >,3.4,
                               < 0, 95, -20 >,2.8 
                               scale < 1.3, 5, 1 >
                               texture { Stringy } 
                        }                        
#declare Log =
              union {
                                                                                      
                     cylinder { < 0, 45, 0 >,< 0, 400, 0 >,21
                                 pigment { color Gray70 }
                                 finish { ambient 0.2 }
                              } 
                      object { Bbark }
                      object { Bbark rotate y*-10 translate y*-50 }
                      object { Bbark rotate y*-20 translate y*40 }      
                      object { Bbark rotate y*-30 translate y*-40 }
                      object { Bbark rotate y*-40 translate y*20 }
                      object { Bbark rotate y*-50 }
                      object { Bbark rotate y*-60 translate y*-40 }  
                      object { Bbark rotate y*-70 translate y*40 }
                      object { Bbark rotate y*-80 translate y*20 }  
                      object { Bbark rotate y*-90 translate y*10 }
                      object { Bbark rotate y*-100 }
                      object { Bbark rotate y*-110 translate y*20 }                              
                      object { Bbark rotate y*10 translate y*-10 }  
                      object { Bbark rotate y*20 translate y*-20 }       
                      object { Bbark rotate y*30 translate y*30 }
                      object { Bbark rotate y*40 translate y*-30 }      
                      object { Bbark rotate y*50 translate y*40 }
                      object { Bbark rotate y*60 translate y*-30 }
                      object { Bbark rotate y*70 }
                      object { Bbark rotate y*80 translate y*20 }  
                      object { Bbark rotate y*90 translate y*10 }   
                      object { Bbark rotate y*100 }
                      object { Bbark rotate y*110 translate y*20 }                         
                               
                     }                                                                    
                                                                     
                                                         
                                                 
                                                                                                                                   
                                                 
#declare Debark =                                            // cuts made debarking                   
                  box { < 0, 0, -3 >,< 10, -20, 3 >
                           rotate z*-45
                           translate < 25, 6, 0 > 
                           pigment { color NewTan }
                           finish { ambient 0.3 }
                      } 
                        
                        
#declare Cutoff =                                            // total of debarking cuts
                  union {
                          object { Debark }
                          object { Debark rotate y*10 }
                          object { Debark translate y*-1 rotate y*20 }
                          object { Debark rotate y*30 }
                          object { Debark translate y*1 rotate y*40 }   
                          object { Debark rotate y*50 }
                          object { Debark translate y*-1 rotate y*60 }
                          object { Debark rotate y*70 }
                          object { Debark translate y*1 rotate y*80 } 
                          object { Debark rotate y*90 }
                          object { Debark translate y*-1 rotate y*100 }
                          object { Debark rotate y*110 }
                          object { Debark translate y*1 rotate y*120 } 
                          object { Debark rotate y*130 }
                          object { Debark translate y*-1 rotate y*140 }
                          object { Debark rotate y*150 }
                          object { Debark translate y*1 rotate y*160 }
                          object { Debark rotate y*170 }   
                          object { Debark rotate y*180 }                 
                          object { Debark rotate y*-10 }
                          object { Debark translate y*-1 rotate y*-20 }
                          object { Debark rotate y*-30 }
                          object { Debark translate y*1 rotate y*-40 }   
                          object { Debark rotate y*-50 }
                          object { Debark translate y*-1 rotate y*-60 }
                          object { Debark rotate y*-70 }
                          object { Debark translate y*1 rotate y*-80 } 
                          object { Debark rotate y*-90 }
                          object { Debark translate y*-1 rotate y*-100 }
                          object { Debark rotate y*-110 }
                          object { Debark translate y*1 rotate y*-120 } 
                          object { Debark rotate y*-130 }
                          object { Debark translate y*-1 rotate y*-140 }
                          object { Debark rotate y*-150 }
                          object { Debark translate y*1 rotate y*-160 }
                          object { Debark rotate y*-170 } 
                          box { < -30, -5, -30 >,< 30, -150, 30 >       //cutoff bark end
                                   pigment { color Tan }
                              }     
                         }
                                                                
               



#declare Lomain =                                    // Final trunk ***********
                 difference {
                             object { Log translate y*-45 }                                   
                                 
                             object { Cutoff }
                            }                                   
                                                          
                                                
                                                             



#declare Raw =
                texture {                           
                          pigment {
                                    wood
                                    color_map {
                                                [ 0  color rgb < 1, 1, 0.75 > ]
                                                [ 1 color rgb < 1, 0.95, 0.6 > ]
                                               }
                                     turbulence 0.05          
                                     rotate x*90
                                   } 
                          finish { ambient 0.2 }
                          }                             
#declare Trunk =
               union {
                        object { Lomain }       
                        difference {                                           // barked butt 
                                     cylinder { < 0, 2, 0 >,< 0, -6, 0 >,19 }                     
                                                box { < 0, 0, -25 >,< 25, -10, 25 >    // scarf
                                                           rotate z*-10
                                                           translate < -25, -3, 0 > 
                                                     } 
                                                       texture { Raw }      
                                                          
                                    } 
                     }
                     
object { Trunk rotate z*90 translate < -50, -25, -50 > rotate y*-30 }                                     
        



  
// GROUND **************************************************** 

#declare Soil =
          texture { 
               pigment {
                        bozo
                        color_map {
                                   [ 0 color NewTan ]  
                                   [ 0.4 color NewTan ]
                                   [ 0.5 color rgb < 0.85, 0.7, 0.6 > ]
                                   [ 0.9 color rgb < 0.75, 0.5, 0.4 > ] 
                                   [ 1 color NewTan ]
                                   }
                              scale 35 
                              turbulence 0.85    
                        } 
                normal { bumps 0.25 scale 0.25 }
                finish { ambient 0.23 }
                  }
                                    
#declare Surface =                                 // height_field made in Povray from wrinkles 
                  height_field { 
                                 tga "wrinc2.tga" smooth
                                 translate < -0.5, -0.5, -0.5 >
                                 scale < 300, 30, 300 >
                                 texture { Soil }
                                 hollow               
                               }                                  
#declare Bsurface =  
                  height_field { 
                                 tga "wrinc2.tga" smooth
                                 translate < -0.5, -0.5, -0.5 >
                                 scale < 300, 45, 300 >
                                 pigment { color NewTan }
                                 finish { ambient 0.25 }
                                 hollow               
                               }                               

object { Surface translate < 0, -50, -200 > }                              // foreground
object { Surface scale < 1.5, 1, 1 > translate < 0, -55, -20 > } 
object { Bsurface rotate x*-5 scale < 2, 1, 1 > translate < 0, -50, 200 > }     
object { Bsurface rotate x*-10 scale < 3, 1, 1 > translate < 0, -25, 450 > }    
object { Bsurface rotate x*-20 scale < 4, 1, 1 > translate < 0, 30, 670 > }     
object { Surface rotate x*-12 scale < 5, 5, 1 > translate < 0, 130, 900 > }    // background 



// Dead Saplings ***********************

#declare Dead =
              texture {
                       pigment { color rgb < 0.95, 0.77, 0.9 > }
                       normal { dents 1 scale < 1, 10, 1 > }
                       finish { ambient 0.2 } 
                       }

#declare Root =
                sphere_sweep {
                              b_spline 
                              7
                              < 0, 10, 0 >,5,
                              < 0, 0, 0 >,5,
                              < -3, -30, 0 >,3,
                              < 0, -40, 3 >,2,
                              < 3, -50, 1 >,1.2,
                              < -3, -60, 0 >,1,
                              < 0, -70, -1 >,0                                                           
                              texture { Dead }                                
                             }                                              
#declare Asap =
            union {
               object { Root translate y*-20 } 
               object { Root scale < 1, 0.5, 0.5 > rotate x*80 translate y*-20 }    
               object { Root rotate < 80, 120, 0 > translate y*-20 }
               object { Root rotate < 80, -120, 0 >  translate y*-20 }
                 
               sphere_sweep {
                              b_spline 
                              10
                              < 0, -50, 0 >,10,
                              < 0, -20, 0 >,8,
                              < -6, 0, 0 >,5,
                              < -12, 50, 0 >,4.5,
                              < -6, 100, 0 >,4,
                              < -3, 150, 0 >,3,
                              < 0, 200, 0 >,2.5,
                              < 6, 250, 0 >,2,
                              < 19, 300, 0 >,1.5,
                              < 20, 350, 0 >,1.5
                              
                             } 
                             texture { Dead }
                  }
#declare Xbranch = 
                sphere_sweep {
                              b_spline 
                              8                 
                              < -5, 150, 8 >,3, 
                              < 0, 160, 8 >,3,
                              < 5, 170, 8 >,2.5,
                              < 15, 250, 6 >,2,  
                              < 5, 275, 0 >,1.8,
                              < 20, 375, 0 >,1.5,
                              < 25, 390, -4 >,0.5,
                              < 25, 325, -8 >,0.5 
                              texture { Dead }                             
                             }                   
                                                                
#declare Bsap =
               sphere_sweep {
                              b_spline 
                              13 
                              < -5, -60, 0 >,1,
                              < -3, -50, 0 >,2,
                              < -2, -40, 0 >,4,
                              < -1, -20, 0 >,5,
                              < 0, 0, 0 >,10,
                              < 2, 30, 2 >,5,
                              < 5, 80, 4 >,4.5,
                              < 2, 130, 12 >,4,
                              < 0, 160, 8 >,3,
                              < -5, 220, 6 >,2.5,
                              < -8, 275, 0 >,2,
                              < -5, 300, -4 >,1.5,
                              < 0, 350, -10 >,1.5 
                              texture { Dead }                             
                             }                             
#declare Xsap =
               union { 
                       object { Bsap }
                       object { Xbranch }
                     }  
object { Asap rotate y*50 translate < 50, 100, 950 > }  
object { Asap rotate < 5, 60, 10 > translate < 50, 100, 951 > }  
object { Xsap rotate < -5, 0, -5 > translate < 100, 100, 900 > }        
object { Bsap translate < -150, 60, 875 > }  
object { Xsap rotate y*180 translate < -130, 60, 875 > }                             
object { Bsap translate < 250, 60, 875 > }   
object { Bsap rotate < -5, 90, 2 > translate < 250, 60, 875 > }  
object { Xsap rotate < -5, 0, 0 > translate < -350, 40, 875 > }
  
object { Bsap rotate < -5, -60, -5 > translate < 460, 50, 1100 > }        
object { Asap translate < -250, 70, 875 > }  
object { Asap rotate < 5, 60, 10 > translate < -450, 0, 875 > }  
object { Asap rotate < -5, -60, -5 > translate < 450, -50, 850 > }                            
                                                                     
object { Asap rotate z*90  translate < 450, 200, 990 > } 
  
object { Xsap rotate z*90  rotate y*-15 translate < 85, -5, 575 > }  
object { Asap rotate z*-90 rotate y*25 translate < 15, 30, 650 > }
object { Root scale < 1, 0.6, 1 > rotate < 160, -90, 0 > translate < 85, -5, 575 > }      
object { Bsap rotate z*90   translate < 275, 200, 985 > }  
object { Asap rotate z*90   translate < -300, 200, 965 > }  
object { Bsap rotate z*-90  rotate y*15 translate < 200, -20, 500 > } 
object { Root rotate z*-150 translate < 200, -25, 500 > } 
object { Asap rotate z*90 rotate < 120, -25, 10 > translate < 350, 65, 750 > } 

object { Root scale 0.5 rotate z*-90 translate < 92, -54, -170 > }                            

// FOLIAGE **************************************************
 
#declare Stalk =
              union {
                 torus { 2, 0.02
                           rotate x*90                                   
                           clipped_by {
                                       box { < 0, 0, -1 >,< -3, 3, 1 > }
                                       }
                            translate < 2, 0.1, 0 >
                            rotate y*180              
                            scale < 0.5, 0.2, 1 >                            
                                                                                
                        } 
                  cylinder { < -1, 0.4, 0 >,< -2.5, 0.4, 0 >,0.005 } 
                                pigment { color Yellow }
                                finish { ambient 0.2 }   
                    } 
                                  
                                  
#declare Adleaf = 
             union {
                     disc { < 0, 0, 0 >,< 0, 0, 1 >,0.1 } 
                     triangle { < -0.09, -0.03, 0 >,< 0.09, -0.03, 0 >,< 0, -0.25, 0 > }
                      scale < 0.8, 1.85, 1 > 
                     translate < 0, -0.185, 0 >
                    pigment { color rgb < 0.5, 0.6, 0.5 > }
                    finish { ambient 0.25 }
                   }              
#declare Leaf = 
             union { 
                     object { Stalk }
                     object { Adleaf  rotate < 0, 45, -20 > translate < -0.4, 0.3, 0 > }   
                     object { Adleaf  rotate < 0, 45, 40 >  translate < -0.2, 0.3, 0 > } 
                     union {
                             disc { < 0, 0, 0 >,< 0, 0, 1 >,0.1 } 
                             triangle { < -0.09, -0.03, 0 >,< 0.09, -0.03, 0 >,< 0, -0.25, 0 > }
                                          scale < 0.7, 2, 1 >
                                          translate y*-0.15  
                           }               
                    pigment { color rgb < 0.5, 0.6, 0.5 > }
                    finish { ambient 0.25 }
                   } 


#declare Number_of_Cycles = 10 ;
#declare Count_per_Cycle = 40; 
#declare Coefficient = 0.01 ;
#declare Starting_Angle = 0 ;
#declare Angle = 360 / Count_per_Cycle ;
#declare Count = Number_of_Cycles * Count_per_Cycle -1 ;

#declare SD1 = seed(1) ;    
#declare SD2 = seed(2) ;
#declare Clump =
         union {
         #while ( Count >= 0 )
                object { Leaf 
                translate < 4*rand(SD2), 4*rand(SD1), 0 >  
                       rotate <  25*rand(SD2),  Starting_Angle * rand(SD1), 45*rand(SD2) >
                       }
         #declare Starting_Angle =  Starting_Angle + Angle ;
         #declare Count = Count - 1 ;

         #end      
               }                    
            
              
#declare NewLeaf = 
             union {
                     disc { < 0, 0, 0 >,< 0, 0, 1 >,0.1 } 
                     triangle { < -0.09, -0.03, 0 >,< 0.09, -0.03, 0 >,< 0, -0.25, 0 > } 
                      translate y*-0.2
                      scale < 0.25, 1, 1 > rotate < 0, -90, 60 >
                    pigment { color rgb < 0.65, 1, 0.5 > }
                    finish { ambient 0.25 }
                   } 
#declare TriLeaf =
             union {
                      object { NewLeaf }
                      object { NewLeaf rotate y*120 }
                      object { NewLeaf rotate y*-120 }
                   }
                                         
#declare Number_of_Cycles = 10 ;
#declare Count_per_Cycle = 40; 
#declare Coefficient = 0.01 ;
#declare Starting_Angle = 0 ;
#declare Angle = 360 / Count_per_Cycle ;
#declare Count = Number_of_Cycles * Count_per_Cycle -1 ;

#declare SD1 = seed(1) ;    
#declare SD2 = seed(2) ;
#declare Klump =
         union {
         #while ( Count >= 0 )
                object { TriLeaf 
                translate < 4*rand(SD2), 4+1*rand(SD1), 0 >  
                       rotate <  25*rand(SD2),  Starting_Angle * rand(SD1), 45*rand(SD2) >
                       }
         #declare Starting_Angle =  Starting_Angle + Angle ;
         #declare Count = Count - 1 ;

         #end      
               } 
 
#declare Bunch =
               union { 
                         object { Clump }
                         object { Klump } 
                             rotate z*-20 
                             scale 1.5
                      }
 
#declare Twig =
               sphere_sweep {
                             cubic_spline 
                              9
                             < 1, -5, 0 >,0.08  
                             < 0, -5, 0 >,0.08
                             < -0.5, -4.8, 0 >,0.08   
                             < -2, -4, 0 >,0.07  
                             < -3, -3, 0 >,0.06
                             < -3.5, -2, 0 >,0.05
                             < -4, -1, 0 >,0.04         
                             < -5, 0, 0 >,0.035  
                             < -5.5, 1, 0 >,0.03
                              scale < 0.75, 1.25, 1 >
                               pigment {   
                         wrinkles    
                         color_map {
                                     [ 0.0 color rgb < 0.9, 0.9, 0.7 > ]                                    
                                     [ 0.4 color rgb < 0.9, 0.9, 0.7 > ]
                                     [ 0.65 color rgb < 0.5, 0.6, 0.4 > ]
                                     [ 0.68 color Brown ] 
                                     [ 0.7 color rgb < 0.9, 0.9, 0.4 > ]                                    
                                     [ 1.0 color rgb < 0.9, 0.9, 0.4 > ]    
                                     
                                     }
                          scale 0.25           
                        }
                finish { ambient 0.3 }
                     
                      } 
                         
               
  

#declare Twigs =
                union {                      
object { Twig translate < 6.25, 5.2, 0 > }   
object { Twig scale 0.8 rotate y*150 translate < 4.9, 5, -0.02 > }  
object { Twig scale 0.7 rotate y* -120 translate < 3.95, 6, 0 > }  
object { Twig  scale 0.6 rotate y*-60 translate < 6.3, 5.5, 0.8 > } 
                      } 
  




// BRANCH 
#declare Mbranch =
sphere_sweep {                     
               cubic_spline 
               11
               < -1, -0.25, 0 >,0.26  
               < 0, 0, 0 >,0.23
               < 1, 0.5, 0 >,0.18   
               < 2, 1.5, 0 >,0.16  
               < 3, 2.1, 0 >,0.14
               < 3.8, 4, 0 >,0.12
               < 4.8, 6, 0 >,0.1         
               < 5.8, 9, 0 >,0.08  
               < 6.3, 12, 0 >,0.07
               < 7, 15, 0 >,0.06
               < 7.2, 17, 0 >,0.05
               
               pigment {   
                         wrinkles    
                         color_map {
                                     [ 0.0 color rgb < 0.9, 0.9, 0.7 > ]                                    
                                     [ 0.4 color rgb < 0.9, 0.9, 0.7 > ]
                                     [ 0.65 color rgb < 0.5, 0.6, 0.4 > ]
                                     [ 0.68 color Brown ] 
                                     [ 0.7 color rgb < 0.9, 0.9, 0.4 > ]                                    
                                     [ 1.0 color rgb < 0.9, 0.9, 0.4 > ]    
                                     
                                     }
                          scale 0.25           
                        }
                finish { ambient 0.3 }
                rotate z* -5                                     
                translate < -6.3, -10, 0 >   
      } 
#declare Gain =  
                union {            
                       object { Twigs translate < -6.05, -2.5, 0 > } 
                       object { Twigs rotate y*180 translate < 6, -3.8, 0 > }                       
                       object { Bunch } 
                       object { Mbranch translate < 0, -2, 0 > }
                      }
                

#declare Strunk = 
sphere_sweep {                     // tree trunk
               cubic_spline 
               5            
               < -0.1, -10, 0 >,0.8,
               < 0.2, 0, 0 >,0.8,   
               < 0.2, 10, 0 >,0.5,
               < 0.2, 20, 0 >,0.25,
               < 0.2, 30, 0 >,0.1 
               pigment { 
                        
                        color rgb < 0.6, 0.6, 0.4 >                                      
                        }
                finish { ambient 0.2 }
                rotate z* -5                                     
                translate < -6.3, -22, 0 >   
      } 

#declare Treetop =
                   union {      
object { Strunk }
object { Gain }
object { Gain scale 0.92 rotate y*180 translate < -11.5, 2, 0 > }     
object { Gain scale 0.8 rotate y*75 translate < -4, 12, -5 > }   
object { Gain scale 0.9 rotate y*-110 translate < -7, 8, 5.6 > }       
object { Gain scale 1.2 rotate y*110 translate < -10, -8, -5.6 > }
               translate y*22 
               scale 6
                         }

#declare Treehead =
                   union {
                          object { Treetop }
                          object { Treetop rotate x*25 translate y*-10 }   
                          object { Treetop rotate x*-25 translate y*-10 }
                             
                          } 
                          
#declare Forebranch =
                 union {            
                       object { Twigs translate < -6.05, -2.5, 0 > } 
                       object { Twigs rotate y*180 translate < 6, -3.8, 0 > }                       
                       object { Bunch } 
                       object { Mbranch translate < 0, -2, 0 > }
                      } 
                         
                         
                         
                        // foreground branches 
                         
 object { Forebranch scale 5  rotate y*180 translate < 95, -10, -120 > }     
 object { Forebranch scale 5  rotate y*180 translate < 145, -10, -100 > }   
 object { Forebranch scale 5  rotate y*180 translate < 120, -10, -200 > } 
 object { Bunch scale 5 rotate y*60 translate < -70, 5, -200 > }            
 object { Bunch scale 5 translate < 75, 30, -200 > }                         
 object { Mbranch scale 5 rotate < 0, 180, 80 > translate < 80, 50, -200 > }  
 
                                                                                                      
// STUMP ***************************************************         
         
 
#declare Bstringy =
                  texture {
                            pigment {
                                      gradient z
                                      color_map { 
                                                  [ 0  color rgb < 1, 0.6, 0.5 > ]  
                                                  [ 0.2  color rgb < 1, 0.6, 0.5 > ] 
                                                  [ 0.6  color rgb < 0.7, 0.5, 0.4 > ]
                                                  [ 0.9  color rgb < 0.7, 0.5, 0.4 > ]
                                                  [ 1.0  color rgb < 1, 0.6, 0.5 > ]  
                                                 }
                                           scale 3 
                                           translate z*3
                                           rotate x*20
                                    } 
                             normal { dents 1 scale < 0.25, 5, 1 > }
                             finish { ambient 0.2 } 
                           }                                     
                                                                
#declare Stumpbark =                                    // bark of stump
                 sphere_sweep {
                               cubic_spline 
                               10
                               < 0, -4, -40 >,2.3,
                               < 0, -2, -34>,2.3,
                               < 0, 0, -30 >,2.3,
                               < 0.25, 1, -28 >,2.7,
                               < 0, 2.5, -26 >,3.5,
                               < -0.3, 5, -24 >,2.6,
                               < 0, 8, -22 >,3.2,
                               < 0.8, 14, -21 >,2.9,
                               < 0.1, 20, -20 >,3.3,
                               < 0, 25, -20 >,3.3                               
                               scale < 1.3, 1.25, 1 >
                               texture { Bstringy } 
                        }                        
#declare Astumpbark =                                    // bark of stump ( smaller )
                  sphere_sweep {
                               cubic_spline  
                               10
                               < 0, -4, -40 >,2.3,
                               < 0, -2, -28>,2.3,
                               < 0, 0, -26 >,2.3,
                               < 0.25, 1, -28 >,2.7,
                               < 0, 2, -24 >,3.5,
                               < -0.3, 4.2, -22 >,2.6,
                               < 0, 8, -20.5 >,3.2,
                               < 0.8, 14, -19 >,2.9,
                               < 0.1, 20, -20 >,3.3,                                                                                        
                               < 0, 25, -20 >,3.3   
                               scale < 1.3, 1.25, 1 >
                               texture { Bstringy } 
                        }                        
                        
#declare Tump =                                                            // all of stump bark
              union {
                                                                                      
                    
                      object { Stumpbark }
                      object { Astumpbark rotate y*-15 }  
                      object { Stumpbark rotate y*-30 }       
                      object { Stumpbark rotate y*-45 } 
                      object { Astumpbark rotate y*-60 } 
                      object { Stumpbark rotate y*-7 }
                      object { Stumpbark rotate y*-90 }   
                      object { Stumpbark rotate y*-105 } 
                      object { Astumpbark rotate y*-120 }
                      object { Stumpbark rotate y*-135 }   
                      object { Astumpbark rotate y*-150 }
                      object { Stumpbark rotate y*-165 }
                      object { Astumpbark rotate y*-180 }                               
                      object { Astumpbark rotate y*15 }   
                      object { Stumpbark rotate y*30 }        
                      object { Stumpbark rotate y*45 } 
                      object { Astumpbark rotate y*60 }       
                      object { Stumpbark rotate y*75 } 
                      object { Stumpbark rotate y*90 } 
                      object { Astumpbark rotate y*105 }
                      object { Astumpbark rotate y*120 }  
                      object { Stumpbark rotate y*135 }    
                      object { Stumpbark rotate y*150 }
                      object { Astumpbark rotate y*165 }                         
                               
                     } 
#declare Tain =                                                  // axed stump bark
                 difference {
                             object { Tump  }                                   
                                 
                             object { Cutoff rotate z*180 translate y*25 }
                            }
                                                                                          
                                                          
                                                           

                        
#declare Stump =
               union {
                        object { Tain }
                        difference {                                           // barked butt 
                                     cylinder { < 0, 20, 0 >,< 0, 25, 0 >,19 }                     
                                                box { < 0, 0, -25 >,< -25, 10, 25 >    // scarf
                                                           rotate z*10
                                                           translate < -5, 25, 0 > 
                                                     }
                                                   texture { Raw }         
                                                         
                                      translate y*4                      
                                    }
                                   
                     }
                     
object { Stump rotate y*-30 translate < 50, -60, -40 > }           
object { Axe rotate < 0, 15, 40 > translate < 60, -24, -40 > }     

// AXEMAN ***************************************************       
#declare Top = 
              
               union {
                      sphere { < 0, 0, 0 >,8.5
                                  scale < 1, 0.3, 1 >
                                  translate y*5
                             }
                                                                                       
                      cylinder { < 0, 0, 0 >,< 0, 5, 0 >,8.5 }  // shoulder 
                          
                                 scale < 1, 1, 0.5 >                                     
                                 rotate < 55, -10, 20 >
                                 translate < -10.5, 56.5, 5.6 >
                       } 
#declare Uaxe =
               union {
                       cylinder { < 0, 0, 0 >,< -24, 0, 0 >,1 
                                   pigment { color Yellow }
                                 }                              
                      cylinder { < -29, 0, 0 >,< -24, 0, 0 >,1 
                                   pigment { color Blue }
                                 } 
                               rotate z*-30
                               translate < -35, 58, 33 >
                      }                     
                                                                        
#declare Body =
             union {
                sphere { < 0, 0, 0 >,3               // hand
                          scale < 1, 0.5, 0.5 >
                          rotate z*-30
                          translate < -33, 57, 33 >
                          pigment { color Flesh }
                          finish { ambient 0.3 }
                        }
                object { Uaxe }          
                object { Top } 
                cylinder { < -15, 59, 8 >,< -23, 50, 20 >,2 }         // larm
                cylinder { < -23, 50, 20 >,< -30, 55, 30 >,2 }        // larm   
                cylinder { < -30, 55, 33 >,< -10, 57, 27 >,2 }        // rarm                                                  
                sphere_sweep {
                               cubic_spline                                                                
                               6
                               < 0, 38, 0 >,8,
                               < 0, 42, -1 >,7.5,
                               < -1, 45, 0 >,7.5,
                               < -4, 50, 2 >,7.5,
                               < -9, 55, 5 >,8,
                               < -13, 58, 9 >,8.5                              
                               scale < 1, 1, 0.5 >
                              } 
                               pigment { checker color White color rgb < 0.75, 0.75, 1 > 
                                        scale 3 rotate z*45 }
                               finish { ambient 0.2 }
                       }       
                                          
#declare Hat =
              union {
                      sphere { < 0, 0, 0 >,6 
                                scale < 0.86, 1, 1 > 
                             }
                      cone { < 0, 0.5, 0 >,0.55,< 0, -1, 0 >,7.5 open }          
                                     rotate < 20, 0, 20 >
                                     translate < -14, 64, 15 >                    // head 
                                     pigment { color NewTan }
                                     finish { ambient 0.3 }
                    }                 
#declare Figure =
                 union { 
                         difference {
                                      sphere { < 0, 0, 0 >,8          // rump
                                               scale < 1, 1.25, 0.6 >
                                                translate < 0, 41, 0 >                                
                                             } 
                                       box { < -10, 35, -20 >,< 10, 30, 20 > }
                                              pigment { color NewTan }
                                              normal { dents 1 scale < 2, 0.8, 1 > }
                                              finish { ambient 0.2 }                
                                     }
                                             
                         cylinder { < 0, 0, 0 >,< 0, 5, 0 >,8   // belt
                                    scale < 1, 1, 0.5 >
                                    rotate < 5, 0, 10 >
                                    translate < 0, 40, -0.8 >
                                  } 
                          cylinder { < 0, 3.5, 0 >,< 0, 5, 0 >,8.2   // belt
                                    scale < 1, 1, 0.5 >
                                    rotate < 5, 0, 10 >
                                    translate < 0, 40, -0.8 >
                                    pigment { color Tan }
                                    finish { ambient 0.2 }
                                  } 
                         object { Hat }
                         object { Body } 
                         sphere { < 4, 38, 3 >,4.5 }
                         sphere { < -4, 39, 1 >,4.5 }                      
                         cone { < 7, 23, 11 >,3.4,< 4, 38, 3 >,4.5 }     // rleg      
                         cone { < 7, 23, 11 >,3.4,< 10, 2, 9 >,3 }       // rleg
                         cone { < -12, 23, -1 >,3.4,< -4, 39, 1 >,4.5 }  //lleg    
                         cone { < -12, 23, -1 >,3.4,< -19, 2, -7 >,3 }   //lleg                           
                                 pigment { color NewTan }
                                 normal { dents 1 scale < 2, 0.8, 1 > }
                                 finish { ambient 0.2 }
                        } 
object { Figure translate < -40, 38, 720 > }  

// Tree being barked  *************************************************

#declare Fartree =
                  difference { 
                               sphere_sweep {
                                             cubic_spline
                                             9
                                             < 0, -20, 0 >,30,
                                             < 0, 0, 0 >,18,
                                             < 0, 20, 0 >,13,
                                             < 0, 40, 0 >,10,
                                             < -2, 80, 0 >,10,
                                             < 0, 180, 0 >,9,
                                             < 2, 300, 0 >,9,
                                             < -2, 400, 0 >,8,
                                             < 0, 450, 0 >,8
                                             pigment { color rgb < 0.8, 0.6, 0.5 > }
                                             normal { dents 1 scale < 0.25, 8, 1 > }
                                             finish { ambient 0.3 }
                                             }
                                torus { 11.5, 2
                                            scale < 1, 1.5, 1 >
                                            translate y*30
                                            pigment { color Yellow }
                                      }
                               }
object { Fartree translate < -34, 49, 760 > } 

#declare Lfartree =                                                    // tree on left              
                               sphere_sweep {
                                             cubic_spline
                                             9
                                             < 0, -20, 0 >,30,
                                             < 0, 0, 0 >,18,
                                             < 0, 20, 0 >,13,
                                             < 0, 40, 0 >,10,
                                             < -2, 80, 0 >,10,
                                             < 0, 180, 0 >,9,
                                             < 2, 300, 0 >,9,
                                             < -2, 400, 0 >,8,
                                             < 0, 450, 0 >,8
                                             pigment { color rgb < 0.8, 0.6, 0.5 > }
                                             normal { dents 1 scale < 0.25, 8, 1 > }
                                             finish { ambient 0.3 } 
                                             rotate y*160
                                             } 
object { Lfartree rotate z*4 translate < -350, 50, 730 > }

object { Treehead translate < 5, 430, 750 > }   


// CHIPS  **********************************

#declare Acut =
               
                union { 
                        box { < -2.5, 0, -1.6 >,< 2.5, -0.75, 1.6 > 
                                pigment { color rgb < 0.7, 0.5, 0.4 > }
                                finish { ambient 0.2 }
                            }   
                        box { < -3.5, 0, -1.5 >,< 2.5, 1, 1.5 >                                   } 
                                 pigment { color NewTan }
                                 finish { ambient 0.3 }
                            }
                       
#declare Bcut =                                 
                union {
                       box { < 0, -2, -2 >,< 2, 2, 2 >
                                rotate z*45 
                                translate x*2                    
                           }                               
                       box { < 0, -2, -2 >,< -2, 2, 2 >
                                 rotate z*45
                                 translate x*-2.5
                           } 
                             pigment { color NewTan }
                             finish { ambient 0.3 }
                      } 
                          
#declare Chip =
                difference {
                            object { Acut }
                            object { Bcut } 
                              scale 1.5
                           }
                             
#declare Chips =
                union {
                       object { Chip rotate y*-5  }      
                       object { Chip rotate < 10, 30, 0 > translate < -5, 0, -3.5 > }
                       object { Chip rotate < 0, 90, 20 > translate < 20, 0, -7.5 > }
                       object { Chip rotate < 20, 20, 0 > translate < -9, -1.75, -8 > }
                       object { Chip rotate < 0, 60, -25 > translate < -3, -1.75, -4 > }
                       object { Chip rotate < -10, -3, 30 > translate < 5, -1.75, -14 > }
                       object { Chip rotate < 0, 45, -20 > translate < 15, -1.75, -10 > }
                       } 
object { Chips translate <  -94, 59, 765 > }     
object { Chips translate <  10, 56, 755 > }  
object { Chips translate <  15, -50, -110 > }    
object { Chips rotate y*30 translate <  -30, -52, -110 > }   
object { Chips rotate y*160 translate <  15, -52, -130 > }   
object { Chips rotate y*80 translate <  -15, -52, -90 > }   
object { Chips rotate y*160 translate <  85, -54, -20 > }        
object { Chips rotate y*70 translate <  -95, -52, -35 > }   
object { Chips rotate y*30 translate <  105, -52, -45 > }       
object { Chips rotate y*160 translate <  10, -54, -20 > }        
object { Chips rotate y*70 translate <  -20, -52, -35 > }   
object { Chips rotate y*30 translate <  20, -52, -45 > }             
object { Chips rotate y*160 translate <  -10, -52, -30 > }        
object { Chips rotate y*70 translate <  -40, -52, -45 > }   
object { Chips rotate y*30 translate <  -30, -52, -65 > }               
                         
                         
                         
                         
                         
                         
                         
                         
                         


                            

// GRASS or WEED or whatever  ******************************************************

#declare Agrass =                                     
                 union {
                        torus { 20, 0.05
                                rotate x*90
                                translate x*20
                                clipped_by {
                                            box { < -1, 0, -1 >,< 3, 10, 1 > }
                                            }
                              }
                        sphere { < 0, 0, 0 >,0.1
                                scale < 1, 5, 1 >
                                translate x*-20
                                rotate z*-30
                                translate x*20
                               } 
                                     pigment { color rgb < 1, 0.7, 0.6 > }
                               finish { ambient 0.3 }
                         }                         

#declare Bgrass =                                     // tuft of weed
                  union {
                          object { Agrass } 
                          object { Agrass scale < 1, 0.8, 1 > rotate < 0, 50, -8 > }  
                          object { Agrass rotate < 0, -120, 8 > }  
                          object { Agrass rotate < 0, 130, 10 > }
                          cylinder { < 0, 0, 0 >,< 0, -5, 0 >,0.08 
                                       pigment { color rgb < 1, 0.7, 0.6 > }
                                       finish { ambient 0.2 }
                                   }     
                         } 
#declare Number_of_Cycles = 10 ;
#declare Count_per_Cycle = 2; 
#declare Coefficient = 0.01 ;
#declare Starting_Angle = 0 ;
#declare Angle = 360 / Count_per_Cycle ;
#declare Count = Number_of_Cycles * Count_per_Cycle -1 ;

#declare SD1 = seed(1) ;    
#declare SD2 = seed(2) ;
#declare Tuft =
         union {
         #while ( Count >= 0 )
                object { Bgrass  scale < 1, 0.9*rand(SD1), 1 >
                translate < 8*rand(SD2), 0, 0 >  
                       rotate <  5*rand(SD2),  Starting_Angle * rand(SD1), 5*rand(SD2) >
                       }
         #declare Starting_Angle =  Starting_Angle + Angle ;
         #declare Count = Count - 1 ;

         #end      
               }
#declare Ltuft =
                 union {
                
                         object { Tuft translate < 0, 0, 0 > }    
                         object { Tuft translate < 20, 0, -20 > }   
                         object { Tuft translate < -25, 0, 0 > }   
                         object { Tuft translate < -35, 0, -20 > }   
                         object { Tuft translate < 45, 0, 0 > } 
                           scale 4
                       } 
#declare Mtuft =
                 object { Ltuft scale 0.6  }                             
#declare Mok =
              sphere { 0, 10
                          pigment { color White }
                     }
                      
object { Mtuft translate < 300, 80, 920 > }                     
object { Mtuft translate < 350, 60, 910 > }
object { Mtuft translate < 450, 115, 950 > }  
object { Mtuft translate < 400, 110, 950 > }                      

object { Ltuft translate < -375, 48, 720 > }  
object { Ltuft translate < -300, 35, 700 > } 
object { Ltuft translate < -275, 33, 750 > }  
object { Ltuft translate < -180, 32, 680 > }

object { Ltuft translate < -110, 60, 780 > }    
object { Mtuft translate < -305, 75, 820 > }  
object { Mtuft translate < -150, 63, 780 > }    
object { Ltuft translate < -120, 10, 680 > }  
object { Ltuft translate < -110, 5, 700 > } 



object { Ltuft translate < 180, 35, 750 > }          
object { Ltuft translate < 220, 30, 730 > }
object { Mtuft translate < 250, 10, 680 > }       
object { Mtuft translate < 300, 30, 720 > } 
object { Ltuft translate < 350, 27, 720 > } 
     
object { Ltuft translate < -350, 10, 650 > }  
object { Ltuft translate < -300, 10, 600 > }    
object { Mtuft translate < -250, 5, 630 > }  
object { Ltuft translate < -200, 5, 620 > }


object { Ltuft translate < 50, -15, 520 > } 
 
object { Mtuft translate < 115, -35, 530 > }          
object { Ltuft translate < 210, -35, 480 > }
object { Mtuft translate < 240, -30, 520 > }   
object { Ltuft translate < 310, -30, 510 > }      
object { Ltuft translate < 360, -30, 540 > }   

object { Mtuft translate < 20, -42, 330 > } 
object { Ltuft translate < 110, -48, 300 > } 
object { Ltuft translate < 180, -53, 270 > }        
object { Mtuft translate < 200, -54, 340 > }
object { Ltuft translate < 240, -53, 320 > }   
object { Ltuft translate < 310, -60, 300 > }                          
                                                                             
                                                             
                                                              
                                                                                                                      
object { Mtuft rotate y*10 translate < 40, -53, -110 > }   //a   foreground weeds
object { Mtuft translate < 0, -53, -150 > }                //d 
object { Mtuft translate < 50, -53, -190 > }               //f  
object { Mtuft translate < -80, -53, -154 > }              //c   
object { Mtuft translate < -60, -53, -210 > }              //e        
object { Mtuft translate < -40, -53, -115 > }              //b  
object { Mtuft translate < -20, -53, -220 > }              //g 


 
// WATERBAG ********************************
       
#declare Canvas =
                 texture {
                          pigment {
                                   gradient z
                                   color_map {
                                               [ 0 color rgb < 0.9, 0.8, 0.86 > ]
                                               [ 1 color rgb < 0.75, 0.8, 0.7 > ]
                                             }
                                        scale 0.1     
                                   }
                           finish { ambient 0.3 }
                         } 
                 texture {                 
                           pigment {
                                   gradient y
                                   color_map {
                                               [ 0 color rgbt < 0.9, 0.78, 0.86, 0.25 > ]
                                               [ 1 color rgbt < 0.75, 0.7, 0.7, 0.8 > ]
                                             }
                                        scale 0.1     
                                   }
                           finish { ambient 0.3 }
                         }
                 texture {
                            pigment {
                                     bozo
                                     color_map {
                                                 [ 0 color rgbt < 0.9, 0.85, 0.8, 0.8 > ]
                                                 [ 0.5 color rgbt < 0.5, 0.3, 0.4, 0.75 > ]
                                                 [ 1.0 color rgbt < 0.9, 0.8, 0.75, 0.8 > ]
                                               }
                                     }
                             finish { ambient 0.2 }
                          }                                        
#declare Bag =                                                                             
prism {
        cubic_spline
        0
        12
        27
        < -2, 0 >,
        < 0, 0 >,
        < 1.1, 0.15 >,
        < 1.5, 0.5 >,
        < 1.65, 1 >,
        < 1.66, 1.5 >,
        < 1.65, 2 >,
        < 1.5, 3 >,
        < 1.1, 4 >,
        < 0.75, 5 >,
        < 0.42, 6 >,
        < 0.15, 7 >,
        < 0.1, 8 >,         
        < 0, 8.1 >,        
        < -0.1, 8 >,
        < -0.15, 7 >,
        < -0.42, 6 >,
        < -0.66, 5 >, 
        < -1.1, 4 >,
        < -1.5, 3 >,
        < -1.65, 2 >,
        < -1.75, 1.5 >,
        < -1.65, 1 >,
        < -1.5, 0.5 >, 
        < -1.1, 0.15 >, 
        < 0, 0 >,
        < 2, 0 > 
        texture { Canvas }
         
                rotate < -90, 90, 0 >
       
        } 
        
#declare Tab =
              superellipsoid {  < 0.25, 0.1 >
                                scale < 0.6, 0.76, 0.15 >
                                texture { Canvas }
                             } 
#declare Spout =
                 union { 
                          torus {  0.6, 0.05 
                                          pigment { color White }
                                          finish { ambient 0.3 }
                                   } 
                          cylinder { < 0, 0, 0 >,< 0, 0.8, 0 >,0.6
                                          pigment { color White }
                                          finish { ambient 0.3 }
                                   }
                          cone { < 0, 0, 0 >,0.59,< 0, -1, 0 >,0.7
                                     texture { Canvas }
                                   }                                     
                          cone { < 0, -1, 0 >,0.7,< 0, -4, 0 >,0.4
                                     texture { Canvas }
                                   }         
                        }                             
#declare Wire = 
             union {
               cylinder { < -3, 0, 0 >,< 4.5, 0, 0 >,0.1 }
                      
               torus { 0.65, 0.1
                       rotate x*90
                       translate y*0.65
                     }                  
               torus { 0.3, 0.1
                       rotate x*90 
                       clipped_by {
                                   box { < 0, -1, -1 >,< 1, 1, 1 > }
                                   }
                       translate < 4.5, 0.3, 0 >
                     } 
                torus { 0.3, 0.1
                       rotate x*90 
                       clipped_by {
                                   box { < 0, -1, -1 >,< -1, 1, 1 > }
                                   }
                       translate < -3, 0.3, 0 >
                     }
                            pigment { color White }
                            finish { ambient 0.3 } 
                   }                    
                                                                                   
#declare Waterbag =
                  union {                                                                                   
                         object { Bag translate < 6, -4.3, 0 > }
                         object { Tab translate < -2.5, 3.9, 0 > }
                         object { Tab translate < 4, 3.9, 0 > }
                         object { Spout translate < -4.5, 4.5, 0 > }
                         object { Wire translate y*4.5 } 
                         }

object { Waterbag rotate < 0, -20, -2 > translate < 115, -48, -70 > }                                                              
                                                                                                                                
                                                                              

// SKY ************************ FINAL

plane { y, 0                 // top of clouds
          
           pigment { 
                    wrinkles  
                               color_map {
                                          [ 0 color Clear ] 
                                          [ 0.5 color Clear ]
                                          [ 0.75 color White ]
                                          [ 1 color White ] 
                                         }
                              turbulence 0.6  lambda 2.5           
                      }
               finish { ambient 1 }
               hollow
               scale < 700, 1, 950 > 
                translate < 500, 2050, -500 >
       }  
       
plane { y, 0                 // middle of clouds
          
           pigment { 
                    wrinkles  
                               color_map {
                                          [ 0 color Clear ] 
                                          [ 0.5 color Clear ]
                                          [ 0.75 color rgb < 0.95, 0.85, 0.92 > ]
                                          [ 1 color rgb < 0.8, 0.75, 0.8 > ] 
                                         }
                              turbulence 0.6  lambda 3.5           
                      }
               finish { ambient 0.7 } 
               hollow
               scale < 700, 1, 950 > 
                translate < 500, 2025, -500 >
       }  
                                                    
plane { y, 0                 // base of clouds
          
           pigment { 
                    wrinkles  
                               color_map {
                                          [ 0 color Clear ] 
                                          [ 0.5 color Clear ]
                                          [ 0.75 color rgb < 0.85, 0.76, 0.9 > ]
                                          [ 1 color rgb < 0.75, 0.55, 0.85 > ] 
                                         }
                              turbulence 0.6  lambda 4           
                      }
               finish { ambient 0.7 } 
               hollow
               scale < 700, 1, 950 > 
                translate < 500, 2000, -500 >
       }                                                                                                 

                       