// shield.pov JPCreations 02/23/03

#include "shapes.inc"

camera{
	location <5, -2, -20>
	look_at 0
	translate z * -4
	rotate y * -15
}
media{
	scattering { 1, rgb 0.03 }
	intervals 1
	samples 5
	method 3
}
// Nonmediatic lights ;)
light_source{
	<0, 10, -50>
	rgb 1
	media_interaction off
}
light_source{
	<15, 0, 10>
	rgb 1
	media_interaction off
}
// And Mediatic lights
light_source{
	<-120, 20, 50>
	rgb 100
	spotlight
	point_at <-20, -20, 50>
	radius 35
	falloff 15
	tightness 1
	media_attenuation on
}

/***************
****************
*** TEXTURES ***
****************
***************/

#declare Coloured_metal = 
texture{
	pigment {
		bumps
		color_map{
			[0 rgb .56]
			[1 rgb .6]
		}
		scale .5
		scale <1, 4, 1>
	}
	normal{
		bumps .06
		scale .5
		scale <1, 2, 1>
	}
	finish{
		roughness .9
	}
}

#declare Rusty_metal =
texture {
	pigment {
		agate
		color_map{
			[ 0 rgb 0.3]
			[.4 rgb 0.3]
			[.6 rgb 0.6]
			[ 1 rgb 0.6]
		}
	}
	normal{
		granite .3
	}
	scale .3
}

/**************
***************
***  SCENE  ***
***************
**************/

#declare Label =
bicubic_patch{
	type 0
	
	u_steps 4 v_steps 4
   uv_vectors
   <0,0> <1,0> <1,1> <0,1>
	
	<0.0, 0.0, 0.0>, <0.25, 0.0, 0.0>, <0.5, 0.0, 0.0>, <0.75, 0.0, 0.0>,
	<0.0, 0.25, 0.0>, <0.25, 0.25, 0.0>, <0.5, 0.25, 0.0>, <0.75, 0.25, 0.0>,
	<0.0, 0.5, 0.0>, <0.25, 0.5, 0.0>, <0.5, 0.5, 0.0>, <0.75, 0.5, 0.0>,
	<0.0, 0.75, 0.0>, <0.25, 0.75, 0.0>, <0.5, 0.75, 0.0>, <0.70, 0.70, -1>
	uv_mapping
	pigment {
		image_map{
			png "png/label.png"
		}
	}
	scale 3
	translate -x + y
	translate <0, 1, -2.201>
}
//----- BOX -----//

difference{
	
		Round_Box_Merge(
			< 5, 7, 2>,
			<-5,-7,-2>,
			.2
		)

	box {
		< 4.1, 6.1, 1.9>,
		<-4.1,-6.1,-2.1>
	}
	cylinder{
		<3, 0, 0>,
		<6, 0, 0>,
		1.1
	}
	texture{
		Coloured_metal
	}

}

//----- LEVER -----//

union{
	union{
		cone{
			<5, 0, 0>,
			1
			<6, 0, 0>,
			.5
		}
		cylinder{
			<5, 0, 0>,
			<3, 0, 0>,
			1
		}
		cylinder{
			<  6, 0, 0>,
			<6.5, 0, 0>,
			.5
		}
		cylinder{
			<6.25, 0, 0>,
			<6.25, 5, 0>,
			.25
	
		}
		texture { Rusty_metal }
	}
	union{
		sphere{
			<6.25, 5, 0>,
			.5
		}
		torus{
			.5, .1
		}
		pigment{
			rgb .4
			
		}
		finish{
			roughness .5
			phong .6
		}
	}
}
	
//----- DOOR -----//

union{
	object{
		Label
	}
	difference{
		object{
			Round_Box_Merge(
				< 4, 6,-1.7>,
				<-4,-6,-2.2>,
				.2
			)
			texture { 
				Coloured_metal 
				translate 100
			}
		}
		// [-- Keyhole
		cylinder{
			<3, -.5, -1.71>,
			<3, -.5, -2.3>,
			.2
			texture { Rusty_metal }
		}
		box{
			<2.9, -0.5, -1.71>,
			<3.1, -1.2, -5.3>
			texture { Rusty_metal }
		}
		// --]
		height_field{
			png "png/crack.png"
			scale  <3, .07, 3>
			rotate x * 90
			translate <.5, -1, -2.21>
			texture { Rusty_metal }
		}
	}
	// [-- The thing in the keyhole
	cylinder{
		<3, -.5, -1.71>,
		<3, -.5, -2.0>,
		.1
		texture { Rusty_metal }
	}
	sphere{
		<3, -.5, -2.0>,
		.1
		texture { Rusty_metal }
	}
	// --]
	translate x * 4
	rotate y * 8
	translate x * -4
}

// ----- CABLE ----- //
union{
	cone{
		<0, -7, 0>,
		1,
		<0, -8, 0>,
		.5
	}
	torus{
		.5, .1
		translate <0, -8, 0>
	}
	cylinder {
		<0, -8, 0>,
		<0,-20, 0>,
		.4
	}
	pigment {
		rgb .4
	}
	finish{
		roughness .7
		phong .6
	}
}
// ----- PILLAR ----- //
box {
	<-8, -20,  2 >,
	< 8,  20,  18>

	pigment { 
		gradient y
		pigment_map{
			#declare Pigment_0 =
			pigment{
				bumps
					color_map{
					[  0 rgb .45 ]
					[0.4 rgb .6 ]
					[0.5 rgb .7 ]
				}
			}
			#declare Pigment_1=
			pigment{
				rgb .7
			}
			[ 0 Pigment_1]
			[.8 Pigment_0]
		}
		scale <1, 30, 1>
		translate y * 18 + x * 10
	}
	normal{
		granite .8
	}

}
// ----- ROOM ----- //
box{
	<-70, -20, -100>,
	< 70,  20,  100>
	pigment { rgb .5 }
	hollow
	clipped_by{
		box {
			<-71, -18, 68>,
			<-69,  18, 32>
			inverse
		}
	}
	normal{
		granite .3
		scale 10
	}

}

// ----- WINDOW ----- //

union{
	difference{
		box {
			<-71, -18, 68>,
			<-69,  18, 32>
		}
		box {
			<-72, -17, 67>,
			<-68,  17, 33>
		}
		pigment { rgb 0 }
	}
	// Ugly glass
	box{
		<-70.001, -17, 67>,
		<-70,      17, 33>
		pigment{
			bozo
			color_map{
				[.3 rgbt <0, 0, 0, 1>]
				[1 rgbt <0, 0, 0, .6>]
			}
		}
	}
	#declare Count = 1;
	#while (Count < 8)
		cylinder{
			<-70, -17, 33 + (4.5 * Count)>,
			<-70,  17, 33 + (4.5 * Count)>,
			.5
			pigment { rgb 0 }
		}	
		#declare Count = Count + 1;
	#end
	#declare Count = 1;
	#while (Count < 8)
		cylinder{
			<-70, -18 + (4.5 * Count), 33>,
			<-70, -18 + (4.5 * Count), 67>,
			.5
			pigment { rgb 0 }
		}	
		#declare Count = Count + 1;
	#end
}
// vim:ts=3
