// Persistence of Vision Ray Tracer Scene Description File
// File: fc_bsmith.pov
// Vers: 3.5
// Desc: A blacksmith workplace
// Date: 02/12/03
// Auth: Fernando Jose Cordeiro
//

#version 3.5;

#include "colors.inc"
#include "stones.inc"  
#include "shapes.inc" 
#include "woods.inc"
#include "bricks.inc" 
#include "swords.inc" 
#include "walls.inc"
#include "prism.inc"
#include "barril.inc"   
#include "shield.inc" 
#include "hammer.inc" 
#include "fire.inc"  
#include "anvil.inc"
            
            
#declare T_Wood12 = 
    texture {  pigment{ P_WoodGrain12A color_map { M_Wood12A }} finish {ambient 0}} 
    texture {  pigment{ P_WoodGrain12B color_map { M_Wood12B }}finish {ambient 0}}



// Choose Render = 1 for final rendering, or any other value for preview without radiosity and with a light to see the scene
#declare Render = 1;
#if (Render = 1)
   #include "final.inc"
#else #include "preview.inc"
#end


// Choose between 5 cameras to test (Camera 4 was used for final rendering)
#declare cam = 4;
// ----------------------------------------

#if (cam = 1) 
   camera {
      location  <1.1, 1.7, -2.7>  
      direction 1.5*z
      right     x*image_width/image_height
      look_at   <1.7, 1.1,  -0.5>
      angle 75
      }
#end
#if (cam = 2)
   camera {
      location  <0.25, 1.8, -4.35>
      direction 1.5*z
      right     x*image_width/image_height
      look_at   <1.75, 0.80,  -0.55> 
      angle 65
      }
#end  

                
#if (cam = 3)                
// panoramic lens for wide field of view with less distortion
camera {
  panoramic
  location <1, 1.8, -3>               
  look_at  <2.2, 1.1, -.6>             
  right    x*image_width/image_height
  angle    60                         
}            
#end  

#if (cam = 4) 
   camera {
      location  <0.25, 1.65, -3.7>
      direction 1.5*z
      right     x*image_width/image_height
      look_at   <0.85, 1.12,  -1.6>
      angle 75
      }
#end             

#if (cam = 5) 
   camera {
      location  < 2.4, 1.8, -0.1>
      direction 1.5*z
      right     x*image_width/image_height
      look_at   <0.2, 1.3,  -2.8>
      }
#end


                  
// Area light inside the furnace
light_source {<3.4,.82,-.6>
              color rgb <.3,.05,.01>*1.0 
              area_light <0, .1, 0>, <0, 0, .3>, 3, 2
              adaptive 1
              jitter
                
              }                   

// ----------------------------------------------
// Calling a macro that put the bricks in place


        
make_wall (-(xlen+0.010)/2,0,0,90,9,12,0)     
make_wall (0,0,0,0,9,12,1)
make_wall ((xlen+.01)*9-(xlen+0.01)/2,0,0,90,9,12,1)
make_wall (0+3*(xlen+.01),-9*(xlen+.01),0,0,7,12,0)

make_wall (6*(xlen+.01),0,0,90,3,3,0)  

make_wall (6.5*(xlen+.01),-3*(xlen+.01),0,0,3,6,0)      

make_wall (6*(xlen+.01),0,(ylen+.01)*5,90,3,1,1)
make_wall (6.25*(xlen+.01),0,(ylen+.01)*6,90,3,1,1)
make_wall (6.5*(xlen+.01),0,(ylen+.01)*7,90,3,1,0)
make_wall (6.75*(xlen+.01),-3*(xlen+.01),(ylen+0.01)*6,0,3,1,1) 
make_wall (6.75*(xlen+.01),0,(ylen+.01)*8,90,3,4,1)
make_wall (7*(xlen+.01),-3*(xlen+.01),(ylen+0.01)*7,0,3,1,0)
make_wall (7.25*(xlen+.01),-3*(xlen+.01),(ylen+0.01)*8,0,2,4,1)  




// The ground

box { <-0.1,0.000,0.1>,<4.1,-.5,-4.1>
     //pigment {rgb <.5,.4.2>}
     texture { pigment {
        granite  
        turbulence .1
        color_map {
            [0.0 rgb 0.3 ]
            [1.0 rgb 0.6 ]
        }
        scale 0.225
    }
    normal  { /*crackle 2 form <-1,1.8,-.5>  scale .005}*/    crackle 1 form <1,-4.5,4.5> scale .1}
    finish {ambient 0 diffuse .6 specular .1 roughness .01}
    }
}        


//------------------------------------------
//Some extra bricks that were missing in furnace


superellipsoid {<.2,.2>  
                scale .5
                scale <zlen,ylen,zlen>
                translate <6.25*(xlen+0.01),3.5*(ylen+0.01),-2.75*(xlen+0.01)>
                texture {myrock}  
                }
superellipsoid {<.2,.2>  
                scale .5
                scale <zlen,ylen*2+.01,zlen>
                translate <6.25*(xlen+0.01),4*(ylen+0.01),-0.25*(xlen+0.01)>
                texture {myrock} 
                 }


// The furnace lid                 

union {
   box {<6.25*(xlen+.01),3*(ylen+.01),-.4*(xlen+.01)>,<6.25*(xlen+.01)-.15,3*(ylen+0.01)-.03,-.4*(xlen+.01)+.06>}       
   box {<6.25*(xlen+.01),5*(ylen+.01),-.4*(xlen+.01)>,<6.25*(xlen+.01)-.15,5*(ylen+0.01)+.03,-.4*(xlen+.01)+.06>}
   cylinder {<6.25*(xlen+.01)-.12,5*(ylen+.01)+.04,-.4*(xlen+.01)+.03>,<6.25*(xlen+.01)-.12,3*(ylen+.01)-.04,-.4*(xlen+.01)+.03>,.01}
   difference {box {<+.03,5*(ylen+.01)+.04,-.01>,<-1.07,3*(ylen+.01)-.04,+.01>}
               box {<.04,5*(ylen+.01)+.05,-.02>,<-.05,5*(ylen+.01)-.001,.02>}
               box {<.04,3*(ylen+.01)-.05,-.02>,<-.05,3*(ylen+.01)+.001,.02>}
               rotate y*-10.5
               translate <6.25*(xlen+.01)-.12,0,-.4*(xlen+.01)+.03>
              }
   texture {T_anvil scale .1}
   }


// The roof

box {<-.1,2.5,-1.9>,<4.1,2.3,-2.1>
     texture {T_Wood12 rotate y*90}
     } 
      
#declare Count = 0;
#while (Count  < 10)
   box {<-.195,-.01,-1>,<.195,.01,1>    
        translate <.2,.01,-1>
        rotate z*2*(rand(R2)-.5)
        texture {T_Wood12 rotate <90*rand(R3),90*rand(R4),0> }
        translate <Count*.4,2.4,0>  
        } 
        
   box {<-.195,-.01,-1>,<.195,.01,1>
       texture {T_Wood12 rotate <90*rand(R3),90*rand(R4),0>}
        translate <.2,.01,1> 
        rotate z*2*(rand(R2)-.5)
        translate <Count*.4,2.4,-4>
        }
   #declare Count = Count+1;
#end

// The barrel

object {Barril rotate x*-90 scale .08 translate <0.42,.4,-.45>}    
             
// Water in barrel
             
cylinder {<.42,.2,-.45>,<.42,.7,-.45>,.31
   pigment {rgbf <0.1,0.1,.3,1>} 
   normal {ripples .6 scale .05 translate <.42,.7,-.45>}    
   interior {ior 1.34}
   finish {reflection .4 ambient 0 specular 1 roughness .01 }
   }

// Closing the holes in barrel
   
difference {cylinder {<.42,.1,-.45>,<.42,.771,-.45>,.311}
            cylinder {<.42,.11,-.45>,<.42,.776,-.45>,.3109} 
            pigment {rgb 0}
            finish {ambient 0}
            }

/*
box {<0,2.4,-4>,<4,10,-4.2>
        pigment {rgb 0}
        finish {ambient 0 diffuse 0}
        }      */

// The shield on the wall
               
object {Ps7 rotate x*-10 translate <1,2.3,-0.17>} 

// The sword on the wall

union {
         object {esp4 scale .5}
         object {myob3 pigment {rgb<.9,.5,.03>} finish {ambient 0 reflection {.6 } metallic specular .9 roughness .001} translate y*0.005}
         rotate z*180 translate <1.55,2.05,-.045>}
                        
// The hot things in furnace

object {Hot_thing scale .01 translate <2.9,.49,-.05>}


// Putting anvil, hammer and the hot sword in place

#declare Group1 = union {
   object {Anvil rotate y*90 scale .015 translate <1.3,0,-.40>}   
   object {Hammer scale 1.2 rotate <87.1,-100,0> translate <1.19,.6375,-.28>}  
   object {esp2 scale .5 rotate x*90 rotate y*-70 translate <1.5,.615,-.6>} 
      
   translate <-0.88,0,-1>   
   }

object {Group1}

// A poker to play with fire

#declare Poker = union {             
   union {
      sphere {<0,0.9,0>,0.015}
      cylinder {<0,0.9,0>,<0,1.2,0>,0.015}
      texture {T_handle scale .05}
      }
   union {
      cylinder {<0,.03,0>,<0,.9,0>,.0075}
      cone {<0,0.03,0>,0.0075,<0,0,0>,0}
      cone {<0,0.03,0>,0.0075,<0,0.12,-.05>,0}
      sphere {<0,0.03,0>,.0075}
      texture {T_head scale .05}
      }
   }
object {Poker rotate y*80 rotate x*15 translate<1.2,0.0,-0.3335>}