// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: ????????????
// Date: mm/dd/yy
// Auth: J. F. Tuduri
//

#version 3.5;

#include "colors.inc"

global_settings {
  assumed_gamma 1.0 max_trace_level 35
}

// ----------------------------------------

camera {
  location  <0.0, 12, -40.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 10.0,  10.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <0, 8, -40>
}

// ----------------------------------------

#declare TexTierra1=texture{
                            pigment {bozo
                                     color_map{[0 rgb <.7,.5,.3>]
                                               [.9 rgb <.2,.4,.05>]}
                                     scale .1
                                     turbulence .4
                                    }
                            normal {bumps scale .05}//finish {ambient 0}
                           }
                    texture{
                            pigment{bozo
                                    color_map{[0 Wheat filter .6]
                                              [.5 rgbt 1]
                                              [1 Wheat filter .2]
                                             }
                                    scale .01
                                    turbulence .1
                                    translate <45,76,12>
                                   }//finish {ambient 0}
                           }
#declare TexTierra=texture{
                           pigment {bozo
                                    color_map{[0 rgb <.3,.1,.05>]
                                              [.45 rgb <.2,.1,.05>]
                                              [1 rgb <.35,.15,0>]
                                              }
                                    scale .5 turbulence .4
                                    }
                           normal {bumps scale .05 turbulence 1}  //finish {ambient 0}
                           }                              
#declare TexTerreno=texture {  //TexTierra
                                slope {
                                        y, 0.5, 1
                                        } 
                                texture_map {
                                        [0.3, TexTierra]
                                        [1, TexTierra1]
                                             }
                             
                             }
                             

#local HFf=height_field {
  png               // the file type to read (tga/pot/pgm/ppm/png/sys)
  "terrenofondo.png"     // the file name to read
  rotate x*-10
  scale <80,8,80>
  translate <-40,0,-40>
  texture{TexTierra1}
}

object{HFf}
#local i=0;
#local SD=seed(342);
#while (i<30)
        #local A=int(rand(SD)*3);
        #local X=rand(SD)*20-10;
        #local Z=rand(SD)*10-15;
        #local Y=trace(HFf,<X,20,Z>,-y).y-1;
        #switch (A)
                #case (0)
                        box{<0,0,0>,<1,1,.0000001>  
                            pigment{image_map {gif "imagemaps\arbol2.gif" transmit 0,1}} 
                            scale <97,108,1>*.1
                            translate <X,Y,Z>
                            }
                        #break
                #case (1)  
                        box{<0,0,0>,<1,1,.0000001>  
                                pigment{image_map {gif "imagemaps\arbol1.gif" transmit 0,1 }} 
                                scale <-97,108,1>*.1
                                rotate y*0
                                translate <X,Y,Z>
                        }
                        #break
                #case (2)
                        box{<0,0,0>,<1,1,.0000001>  
                                pigment{image_map {gif "imagemaps\arbol3a.gif" transmit 0,1}} 
                                scale <97,108,1>*.085
                                rotate y*0
                                translate <X,Y,Z>
                                }
                        #break
        #end
        #local i=i+1;
#end


#include "textures.inc"
// the clouds
#include "stsky\i_stsky.inc"
#declare dark_color=White*.8+SkyBlue*.1;     //*.2
#declare light_color=White;
#declare height=8000;
#declare cloud_level=.45;
#declare planes=15;//Aumentar cantidad de planos
#declare pdist=30;
#declare ppatt=pigment{wrinkles}
#declare pturb=.4;
#declare pocta=9;
#declare plamb=3;
#declare pomeg=.5;
#declare tdist=50;
#declare sfactor=10000;
#declare dfactor=.9;
#declare border=.1;
#declare fstart=.7;
#declare fend=.8;
object{
 clouds(
  dark_color,         // color for lower parts
  light_color,        // color for upper parts
  height,             // heigth to first layer
  cloud_level,        // level of "cloudiness"(?)
  planes,             // number of planes
  pdist,              // distance between planes
  ppatt,              // pigment pattern
  pturb,              // amount of turbulence
  pocta,              // and its modifiers
  plamb,
  pomeg,
  tdist,              // distance between textures
  sfactor,            // scaling factor
  dfactor,            // darkening factor
  border,             // width of change zone
  fstart,             // filter for lower layer
  fend                // filter for upper layer
 )
 hollow
 no_shadow
 rotate 5*y
}
