// Persistence of Vision Ray Tracer Scene Description File
// File: carreta.pov - Cart -
// Vers: 3.5
// Desc: Jan-Feb 2003 IRTC Entry - Topic "Old Technologies" (a Water Mill)
// Date: Start - 11Ene03
// Auth: J. F. Tuduri
//

#version 3.5;

#include "colors.inc" 
#include "transforms.inc"
#include "shapes.inc"
        /*            
global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  
  direction 2*z
  right     x*image_width/image_height
  location  <-3, 2, -4.0> look_at   <0.0, 1.0,  0.0>
  //location  <-3, 2, -0.0> look_at   <0.0, 1.0,  0.0>
  //location  <1, 2, -6.0> look_at   <1.0, 1.0,  0.0>
  //Rueda
  //location <-1.5,1,-1.5> look_at <.55,.55,0>
  //Tablas
  //location <-2,1.5,-2> look_at <.55,1.15,0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}                  
light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>*.4  // light's color
  translate <-2,1.5,2> shadowless
} 


plane {
  y, 0
  pigment { color rgb <0.7,0.5,0.3> }
}              */                     
//-----------  
         
#local SD=seed(1222);
#declare TexCarretaMad1=texture{pigment{wood rotate y*90 turbulence .1 scale <.7,.05,.7>*.4
                                        color_map{[0 rgb <.5,.3,.2>*.8]
                                                  [.5 rgb <.45,.3,.25>*.5]
                                                  [1 rgb <.5,.2,.15>]
                                                  }
                                        }
                                        normal{wood .1 rotate y*90 turbulence .1 scale <.7,.05,.7>*.5}
                               }
#declare TexCarretaMad2=texture{pigment{wood rotate x*90 turbulence .05 scale .02
                                        color_map{[0 rgb <.5,.45,.3>*.5]
                                                  [1 rgb <.55,.3,.3>*.5]
                                                  }
                                       }
                                }                               
#declare TexCarretaMetal1=texture{pigment{
                                        agate scale .01
                                        color_map{[0 rgb <.15,.15,.2>]     
                                                  [1 rgb <.2,.1,.1>]
                                                  }
                                          }
                                   normal{agate -.2 scale .01}
                                   finish{phong .3 phong_size 100 metallic}
                                 }                               
                   
//CARRETA
#declare Carreta=
union{
//ruedas
#local Rueda=
     union{
           //cubierta
           torus{.52,.01 rotate x*90 scale <1,1,4>
                 pigment {Grey*.2} finish{phong 5 phong_size 100 metallic} normal {bumps 2 scale .005}
                }
           //fin cubierta
                
        //llanta
        #local i=0;
        #local Step=360/10;
        #while (i<10)
           union{
                box{<-.015,0,-.02>,<.015,.5,.02>}
                cylinder{<0,0,0>,<0,.5,0>,.015 scale <1,1,.5> translate z*-.02}
                cylinder{<0,0,0>,<0,.5,0>,.015 scale <1,1,.5> translate z*.02}
                rotate x*-4
                translate z*.03
                texture{TexCarretaMad2 translate y*rand(SD)*50}
                rotate z*Step*i
                }
           intersection{
                        difference{
                        cylinder{<0,0,-.04>,<0,0,.04>,.52}
                        cylinder{<0,0,-.05>,<0,0,.05>,.47}
                        }  
                        plane {x,0 rotate z*(i*Step*.99)}
                        plane {-x,0 rotate z*(i*Step+Step)}
                        texture{TexCarretaMad2 scale .8 rotate x*90 translate y*rand(SD)*100 rotate z*Step}
                        }
           #local i=i+1;
        #end
        difference{
                cylinder{<0,0,-.01>,<0,0,.05>,.09}
                cylinder{<0,0,-.02>,<0,0,.06>,.07}
                texture{TexCarretaMad2}
                }
        //fin llanta
        
        union{
                Round_Cylinder_Union(<0,0,-.02>,<0,0,.07>,.07,.001)
                Round_Cylinder_Union(<0,0,-.05>,<0,0,.07>,.04,.001)
                texture{TexCarretaMetal1}
                }
       translate <0,.55,-.8> pigment {Grey}
      }//fin rueda
      
object{Rueda}  //derecha
object{Rueda scale <1,1,-1>}//izquierda      
      


//eje
cylinder{<0,0,-.7>,<0,0,.7>,.05 translate y*.55 texture{TexCarretaMetal1}}
cylinder{<0,0,-.4>,<0,0,.4>,.1 translate y*.55 texture{TexCarretaMetal1}}

//piso
object{Round_Box_Union(<-.8,.75,-.75>,<.8,.78,-.5>,.01) texture{TexCarretaMad1 rotate x*90 translate x*rand(SD)*50}}
object{Round_Box_Union(<-.8,.75,-.5>,<.8,.78,-.15>,.01) texture{TexCarretaMad1 rotate x*90 translate x*rand(SD)*50}}
object{Round_Box_Union(<-.8,.75,-.15>,<.8,.78,.15>,.01) texture{TexCarretaMad1 rotate x*90 translate x*rand(SD)*50}}
object{Round_Box_Union(<-.8,.75,.15>,<.8,.78,.5>,.01) texture{TexCarretaMad1 rotate x*90 translate x*rand(SD)*50}}
object{Round_Box_Union(<-.8,.75,.5>,<.8,.78,.75>,.01) texture{TexCarretaMad1 rotate x*90 translate x*rand(SD)*50}}

//pared
object{Round_Box_Union(<-.77,.77,-.72>,<.77,.9,-.75>,.01) texture{TexCarretaMad1 translate z*rand(SD)*50}}
object{Round_Box_Union(<-.77,.9,-.72>,<.77,1.1,-.75>,.01) texture{TexCarretaMad1 translate z*rand(SD)*50}}
object{Round_Box_Union(<-.77,1.095,-.72>,<.77,1.25,-.75>,.01) texture{TexCarretaMad1 translate z*rand(SD)*50}}
object{Round_Box_Union(<-.77,1.24,-.72>,<.77,1.27,-.8>,.01) texture{TexCarretaMad1 translate z*rand(SD)*50 rotate x*91}}

object{Round_Box_Union(<-.77,.77,.72>,<.77,.9,.75>,.01) texture{TexCarretaMad1 translate z*rand(SD)*50}}
object{Round_Box_Union(<-.77,.9,.72>,<.77,1.1,.75>,.01) texture{TexCarretaMad1 translate z*rand(SD)*50}}
object{Round_Box_Union(<-.77,1.095,.72>,<.77,1.25,.75>,.01) texture{TexCarretaMad1 translate z*rand(SD)*50}}
object{Round_Box_Union(<-.77,1.24,.72>,<.77,1.27,.8>,.01) texture{TexCarretaMad1 rotate <90,0,0> translate x*rand(SD)*50 }}

//tapa delantera
object{Round_Box_Union(<.77,.78,-.75>,<.8,1.35,.75>,.01) texture{TexCarretaMad1 rotate y*90}}

//tapa trasera
object{Round_Box_Union(<-.77,.77,-.755>,<-.8,.95,.755>,.01) texture{TexCarretaMad1 rotate y*90 translate x*rand(SD)*50}}
object{Round_Box_Union(<-.77,.95,-.755>,<-.8,1.1,.75>,.01) texture{TexCarretaMad1 rotate y*90 translate x*rand(SD)*50}}
object{Round_Box_Union(<-.77,1.09,-.755>,<-.82,1.12,.75>,.01) texture{TexCarretaMad1 rotate y*90 translate x*rand(SD)*50}}   
      
//soporte para caballo
object{Round_Box_Union(<-.3,.65,-.04>,<2.5,.75,.04>,.01) texture{TexCarretaMad2 rotate z*90} rotate y*2.5 translate z*.35}
object{Round_Box_Union(<-.3,.65,-.04>,<2.5,.75,.04>,.01) texture{TexCarretaMad2 rotate z*90} rotate y*-2.5 translate z*-.35}

//fijaciones tablas
box{<-.8,1.05,.6>,<-.805,.745,.5> texture{TexCarretaMetal1}}
box{<-.8,.75,.6>,<-.6,.745,.5> texture{TexCarretaMetal1}}

box{<-.5,1.15,.75>,<-.6,.745,.755> texture{TexCarretaMetal1}}
box{<-.5,.745,.755>,<-.6,.75,.6> texture{TexCarretaMetal1}}

box{<-.65,1.05,.75>,<-.805,1,.755> texture{TexCarretaMetal1}}
box{<-.8,1.05,.75>,<-.805,1,.65> texture{TexCarretaMetal1}}

box{<-.65,.87,.75>,<-.805,.82,.755> texture{TexCarretaMetal1}}
box{<-.8,.87,.75>,<-.805,.82,.65> texture{TexCarretaMetal1}}
                                                      
box{<-.8,1.05,-.6>,<-.805,.745,-.5> texture{TexCarretaMetal1}}
box{<-.8,.75,-.6>,<-.6,.745,-.5> texture{TexCarretaMetal1}}

box{<-.5,1.15,-.75>,<-.6,.745,-.755> texture{TexCarretaMetal1}}
box{<-.5,.745,-.755>,<-.6,.75,-.6> texture{TexCarretaMetal1}}

box{<-.65,1.05,-.75>,<-.805,1,-.76> texture{TexCarretaMetal1}}
box{<-.8,1.05,-.76>,<-.805,1,-.65> texture{TexCarretaMetal1}}

box{<-.65,.87,-.75>,<-.8,.82,-.76> texture{TexCarretaMetal1}}
box{<-.8,.87,-.76>,<-.805,.82,-.65> texture{TexCarretaMetal1}}                                                      
Rotate_Around_Trans(z*(-15),<0,.55,0>)
}
//fin carreta

//object{Carreta}
             