// Persistence of Vision Ray Tracer Scene Description File
// File: molino.pov  
// Vers: 3.5
// Desc: Jan-Feb 2003 IRTC Entry - Topic "Old Technologies" (a Water Mill)
// Date: Start - 11Ene03
// Auth: J. F. Tuduri

/* 
Tools: 
     *MakeTree by Gilles Tran -> http://www.oyonale.com/  
     *MakeWall by Gilles Tran -> http://www.oyonale.com/
     *Stacked Sky by Jaime Vives Piqueres -> http://www.ignorancia.org/
     *TomTree by Tom Aust -> http://www.aust-manufaktur.de/
     *PovTree by Gena Obukhov -> http://propro.ru/go/index.html
     *Object Bender by Chris Colefax -> http://www.geocities.com/SiliconValley/Lakes/1434/
     *HamaPatch by Hamakazu -> http://www.geocities.com/hamapatch/program/
     *IrfanView 
     *Photoshop
     
Files:
     *Molino.pov -> This file, main file.
     *Casa.pov -> The Mill House
        *Techo.pov -> Contains macro to create the tiled roofs
        *Puerta.inc -> A door, barely visible through the window closer to the wheel.
        *Cobertizo.pov-> The Shed
                *Bolsas.pov -> The sacks in the shed, created with HamaPatch.
     *Rueda.pov -> The Wheel and Canal
        *Cascada.pov -> Macro to make the falling water
     *Carreta.pov -> The Cart
     *Cerco.pov -> The fence in the background
     *Sauce.inc -> The Willow Tree, created with MakeTree
     
     *imagemaps\arbol3.gif -> create with imagemaps\arbol.pov (TomTree and arbol.inc needed)
     *imagemaps\arbol2.gif -> create with imagemaps\arbol2.pov (and MakeTree)
     *imagemaps\arbol1.gif -> create with imagemaps\arbol1.pov (and MakeTree)
     *terreno.png -> heightfield terrain
     *terrenofondo.png -> background heightfield
     *terrenoPasto.png -> map to place the grass
     *imagemaps\roca2.jpg -> imagemap for the wall to the right, behind the willow tree (http://www.grsites.com/textures/rock002.shtml)
     *imagemaps\reflejo.png ->create with imagemaps\reflejo.pov (it's the reflection on the windows)
     

*/

#version 3.5;

#include "colors.inc"

global_settings {
  assumed_gamma 1.0
  max_trace_level 64 //64    +a0.1  //+sr1 +er200 //+sr201 +er400 //+sr401 +er600
}
                                               
//----------Switches-------------------------------
#local Luz1=1; #local LuzDist=10000;//10000  //problemas
#local Luz2=1;
#local HCasa=1;         //House
#local HCarreta=1;      //Cart
#local HRueda=1;        //Wheel
#local HCanal=1;        //Canal
#local HAguaMolino=1;   //Falling Water
#local HCartel=1;       //Sign
#local HCerco=1;        //Fence
#local HArbol1=1;       //Willow Tree
#local HArbol2=1;       //Background Trees
#local HArbol3=1;       //Tree on the left, behind the cart
#local HTerreno=1;      //Land
#local HPasto=1;        //Grass
#local HContencion=1;   //Planks holding the land
#local HAgua=1;         //Water
#local HCielo=1;        //Sky aumentar la cantidad de planos para render final //sin pasto ni arboles 8 min
#local HMuro=1;         //Wall


// ---------Lights/Camera---------------------

#declare camera_location = <-15, 2, -15>;  //<-15, 2, -15.0>;

camera {
 
  direction 1.5*z  //1.5
  right     x*image_width/image_height
  location  camera_location look_at   <1.0,3.0, 2.0>
  //location  <-15, 5, -15.0> look_at   <5.0,3.0, -10.0> 
  //location  <-20, 5, -1.0> look_at   <6.0,3.0, 6.0>
  //location <5,100,0> look_at <5,.1,5>
  //location <5,1.5,5> look_at <10,0,-8>
  //location <11.5,2,-20> look_at <11.5,2,0>
  //location <0,2,0> look_at <-3.1,0,15>
  //location <30,15,30> look_at <0,0,0>
}
                
sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

#if(Luz1)        
/*light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>*LuzDist    //<-30, 30, -30>
}  */
light_source {
  0*x                 // light's position (translated below)
  color rgb 1.0       // light's color
  area_light
  <8, 0, 0> <0, 0, 8> // lights spread out across this distance (x * z)
  4, 4                // total number of lights in grid (4x*4z = 16 lights)
  adaptive 0          // 0,1,2,3...
  jitter              // adds random softening of light
  circular            // make the shape of the light circular
  orient              // orient light
  translate <-30, 30, -30>*LuzDist   // <x y z> position of light
}

#end

#if(Luz2)
light_source {
  camera_location            // light's position (translated below)
  color rgb .05  // light's color
  shadowless
}
#end   
     

// ----------------------------------------
#declare TexContencion=texture{pigment{wood rotate <90,0,90> turbulence .2 scale <.5,.05,.05>
                                       color_map{[0 rgb <.45,.35,.3>*.6]
                                                 [1 rgb <.4,.2,.1>]}
                                       }
                               normal {wood rotate <90,0,90> turbulence .2 scale <.5,.05,.05>}
                             }
#declare TexMarcaAgua=texture{pigment {gradient -y scale 1 translate y*.15
                                       color_map{[0 rgbt 1]
                                                 [.52 rgbt 1]
                                                 [.6 rgbt <.05,.05,.05,.6>]
                                                 [1 rgbt <.05,.05,.05,.6>]}
                                       }
                              }
//Texturas de terreno
#declare TexTierra1=texture{
                            pigment {bozo
                                     color_map{[0 rgb <.7,.5,.3>]
                                               [.9 rgb <.2,.4,.05>]}
                                     scale .1
                                     turbulence .4
                                    }
                            normal {bumps scale .05}
                           }
                    texture{
                            pigment{bozo
                                    color_map{[0 Wheat filter .6]
                                              [.5 rgbt 1]
                                              [1 Wheat filter .2]
                                             }
                                    scale .01
                                    turbulence .1
                                    translate <45,76,12>
                                   }
                           }
#declare TexTierra=texture{
                           pigment {bozo
                                    color_map{[0 rgb <.3,.1,.05>]
                                              [.45 rgb <.2,.1,.05>]
                                              [1 rgb <.35,.15,0>]
                                              }
                                    scale .5 turbulence .4
                                    }
                           normal {bumps scale .05 turbulence 1}
                           }                              
#declare TexTerreno=texture {  //TexTierra
                                slope {
                                        y, 0.5, 1
                                        } 
                                texture_map {
                                        [0.3, TexTierra]
                                        [1, TexTierra1]
                                             }
                             
                             }                              

// --- Molino ---
#if (HCasa) #include "casa.pov" #end

#if ((HRueda)|(HCanal)|(HCartel)) #include "rueda.pov" #end

//Rueda 
#if (HRueda) object{Rueda translate <1.8+.4,1.7,-.9-.25>} #end

//Canal
#if (HCanal) object{Canal translate <2.5+.4,0,-.9-.25>} #end

//Agua Molino
#if (HAguaMolino)  object{Agua translate <2.5+.4,0,-.9-.25>} #end

//Cartel
#if (HCartel) object{Cartel translate <2.5+.4,0,-.9-.25>} #end

//Carreta
#if (HCarreta) #include "carreta.pov" object{Carreta rotate y*-145 translate <-8.2,.07,3.5>} #end

//Cerco
#if (HCerco) #include "cerco.pov" object{Cerco translate <-2.5,0,20>} #end

//Arbol
#if (HArbol1)
        #include "sauce.inc"
        object{Sauce scale .15 translate <9,0,-4.5>}
#end

#if (HArbol2) 
box{<0,0,0>,<1,1,.0000001>  
        pigment{image_map {gif "imagemaps\arbol3.gif" transmit 0,1}}
        scale <97,108,1>*.07 rotate y*45 translate <-6.6,-1.2,14.5>
} 
#end

#if (HArbol3)
        box{<0,0,0>,<1,1,.0000001>  
        pigment{image_map {gif "imagemaps\arbol1.gif" transmit 0,1}} 
        scale <97,108,1>*.09 rotate y*45 translate <10.5,0,9>
}  
box{<0,0,0>,<1,1,.0000001>  
        pigment{image_map {gif "imagemaps\arbol2.gif" transmit 0,1}} 
        scale <97,108,1>*.12 rotate y*45 translate <8,0,20>
}                            
box{<0,0,0>,<1,1,.0000001>  
        pigment{image_map {gif "imagemaps\arbol1.gif" transmit 0,1 }} 
        scale <-97,108,1>*.1 rotate y*45 translate <10,0,15>
}
box{<0,0,0>,<1,1,.0000001>  
        pigment{image_map {gif "imagemaps\arbol3.gif" transmit 0,1}} 
        scale <97,108,1>*.085 rotate y*45 translate <75,2,36>
}
box{<0,0,0>,<1,1,.0000001>  
        pigment{image_map {gif "imagemaps\arbol3.gif" transmit 0,1}} 
        rotate y*180 scale <97,108,1>*.0865 rotate y*45 translate <65,1,15>
}
box{<0,0,0>,<1,1,.0000001>  
        pigment{image_map {gif "imagemaps\arbol3.gif" transmit 0,1}} 
        rotate y*180 scale <97,108,1>*.0865 rotate y*45 translate <50,1,20>
}
#end         
     
                 
//Terreno    
//Main HeightField
#declare HF=
height_field {
        png "terreno.png"     
        smooth
        translate<-.5,.18,-.5>
        scale <26,2,26>
        translate <2,-2,5>
        }   

#if (HTerreno) object{HF texture {TexTerreno}} 
               box{<-11,-.1,18>,<20,0,25> texture{TexTierra1}} 

//Background Heightfields
height_field {
  png               // the file type to read (tga/pot/pgm/ppm/png/sys)
  "terrenofondo.png"     // the file name to read
  rotate x*-10
  scale <80,15,80>
  translate <-15,-11,28>
  texture{TexTierra1}
} 

height_field {
  png               // the file type to read (tga/pot/pgm/ppm/png/sys)
  "terrenofondo.png"     // the file name to read
  rotate z*20
  scale <80,15,80>
  translate <50,-9,5>
  texture{TexTierra1}
}

#end

//pasto
#declare PastoMap=pigment{image_map{png "terrenoPasto.png"}
                                        rotate x*90 
                                        translate<-.5,.18,-.5>
                                        scale <26,2,26>
                                        translate <2,-2,5>
                                        }
                                        
#local i=0;
#local Xi=-11; #local Xf=15;
#local Zi=-8; #local Zf=18;
#local SD=seed(444);
#include "functions.inc"

#macro PastoPig(valor)
        pigment{gradient y
                        color_map{
                                  [0 rgb <0.747059,0.847059,0.64902>]
                                  [.1 rgb <0.747059,0.847059,0.64902>]
                                  [.3 rgb <.2,.4,.05>*(rand(SD)*.6+.7)]
                                  [1 rgb <.2,.4,.05>*(rand(SD)*.6+.7)]
                                  }                             
                scale valor
               }
#end

// Pasto / Grass     
#if(HPasto)
#declare Patch=
                union{
                        triangle{<0,-.05,-.005>,<0,-.05,.005>,<0,.22*(rand(SD)*.8+.6),0> PastoPig(.2*(rand(SD)*.8+.6))rotate <30+rand(SD)*10-5,0+rand(SD)*10-5,0>}
                        triangle{<0,-.05,-.005>,<0,-.05,.005>,<0,.22*(rand(SD)*.8+.6),0> PastoPig(.2*(rand(SD)*.8+.6))rotate <30+rand(SD)*10-5,45+rand(SD)*10-5,0>}
                        triangle{<0,-.05,-.005>,<0,-.05,.005>,<0,.22*(rand(SD)*.8+.6),0> PastoPig(.2*(rand(SD)*.8+.6))rotate <30+rand(SD)*10-5,90+rand(SD)*10-5,0>}
                        triangle{<0,-.05,-.005>,<0,-.05,.005>,<0,.22*(rand(SD)*.8+.6),0> PastoPig(.2*(rand(SD)*.8+.6))rotate <30+rand(SD)*10-5,135+rand(SD)*10-5,0>}
                        triangle{<0,-.05,-.005>,<0,-.05,.005>,<0,.22*(rand(SD)*.8+.6),0> PastoPig(.2*(rand(SD)*.8+.6))rotate <30+rand(SD)*10-5,180+rand(SD)*10-5,0>}
                        triangle{<0,-.05,-.005>,<0,-.05,.005>,<0,.22*(rand(SD)*.8+.6),0> PastoPig(.2*(rand(SD)*.8+.6))rotate <30+rand(SD)*10-5,225+rand(SD)*10-5,0>}
                        triangle{<0,-.05,-.005>,<0,-.05,.005>,<0,.22*(rand(SD)*.8+.6),0> PastoPig(.2*(rand(SD)*.8+.6))rotate <30+rand(SD)*10-5,315+rand(SD)*10-5,0>}
                        triangle{<0,-.05,-.005>,<0,-.05,.005>,<0,.22*(rand(SD)*.8+.6),0> PastoPig(.2*(rand(SD)*.8+.6))rotate <30+rand(SD)*10-5,0+rand(SD)*10-5,0>}
                      }

#while(i<25000)   //20000
        #local Xsample=(rand(SD)*(Xf-Xi)+Xi);
        #local Zsample=(rand(SD)*(Zf-Zi)+Zi);
        #local PigV=eval_pigment(PastoMap,<Xsample,0,Zsample>);
        
        
        //#debug "X= " #debug str(Xsample,0,3) #debug " Z= " #debug str(Zsample,0,3) #debug " Valor= " #debug str(PigV.x,0,3) #debug "\n" 
        #local Prob=rand(SD);
        #if (PigV.y>Prob)
                #local punto=trace(HF,<Xsample,4,Zsample>,-y) ;
                        object{Patch rotate y*360*rand(SD) translate punto}
                #local i=i+1;   
                #if(mod(i,1000)=0)
                        #debug str((20000-i),0,1) #debug "\n"
                #end
        #end
                                
        
#end //end while                                 

#end //end if pasto/grass                                          



//contencion de terreno / Planks in the water
#if (HContencion)                             
union{
        box{<-.1,-2,-.1>,<.1,.1,0> translate <-5.2,0,.7>texture{TexContencion rotate z*90}texture{TexMarcaAgua}}
        box{<-.1,-2,-.1>,<.1,.1,0> translate <-8,0,.7>texture{TexContencion rotate z*90}texture{TexMarcaAgua}}

        box{<-8.12,0,.7>,<-5.2,-.2,.75> texture{TexContencion translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua}}
        box{<-8.15,-.22,.7>,<-5.2,-.42,.75> texture{TexContencion translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua}}
        box{<-8.11,-.44,.7>,<-5.2,-.66,.75> texture{TexContencion translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua}}         
        translate z*.3
        }
union{
box{<-.1,-3,0>,<.1,.1,.1> translate <4,0,0> texture{TexContencion rotate z*90}texture{TexMarcaAgua}}
        box{<4.1,0,0>,<4.15,-.2,-1.9> texture{TexContencion rotate y*90 translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua}}
        box{<4.1,-.22,0>,<4.15,-.42,-1.9>texture{TexContencion rotate y*90 translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua}}
        box{<4.1,-.44,0>,<4.15,-.64,-1.9>texture{TexContencion rotate y*90 translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua}}
box{<-.1,-3,0>,<.1,.1,.1> translate <4,0,-1.9> texture{TexContencion rotate z*90}texture{TexMarcaAgua}}
        box{<1,0,-1.9>,<4,-.2,-1.95> texture{TexContencion translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua}}
        box{<1,-.22,-1.9>,<4,-.42,-1.95> texture{TexContencion translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua}}
        box{<1,-.44,-1.9>,<4,-.64,-1.95> texture{TexContencion translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua}}
box{<-.05,-3,-.1>,<.05,.1,.1> translate <1,0,-1.9> texture{TexContencion rotate z*90}texture{TexMarcaAgua}}
        box{<0,0,0>,<.05,-.2,-1.6> texture{TexContencion rotate y*90 translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua}rotate y*-44 translate <1,0,-1.9>}
        box{<0,-.22,0>,<.05,-.42,-1.6> texture{TexContencion rotate y*90 translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua}rotate y*-44 translate <1,0,-1.9>}
        box{<0,-.44,0>,<.05,-.64,-1.6> texture{TexContencion rotate y*90 translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua}rotate y*-44 translate <1,0,-1.9>}
box{<-.05,-3,-.1>,<.05,.1,.1> rotate y*-43 translate <2,0,-3> texture{TexContencion rotate z*90}texture{TexMarcaAgua}}
        box{<0,0,0>,<.05,-.2,-2.2> texture{TexContencion rotate y*90 translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua} rotate y*-73 translate <2,0,-3>}
        box{<0,-.22,0>,<.05,-.42,-2.2> texture{TexContencion rotate y*90 translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua} rotate y*-73 translate <2,0,-3>}
        box{<0,-.44,0>,<.05,-.64,-2.2> texture{TexContencion rotate y*90 translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua} rotate y*-73 translate <2,0,-3>}
box{<-.05,-3,-.1>,<.05,.1,.1> rotate y*-70 translate <4,0,-3.7> texture{TexContencion rotate z*90}texture{TexMarcaAgua}}
        box{<0,0,0>,<.05,-.2,-2> texture{TexContencion rotate y*90 translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua} rotate y*-85 translate <4,0,-3.7>} 
        box{<0,-.22,0>,<.05,-.42,-2> texture{TexContencion rotate y*90 translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua} rotate y*-85 translate <4,0,-3.7>}
        box{<0,-.44,0>,<.05,-.64,-2> texture{TexContencion rotate y*90 translate <rand(SD)*50,0,rand(SD)*50>}texture{TexMarcaAgua} rotate y*-85 translate <4,0,-3.7>}      
box{<-.05,-3,-.1>,<.05,.1,.1> rotate y*-50 translate <6,0,-4> texture{TexContencion rotate z*90}texture{TexMarcaAgua}}
pigment {Brown}
}

#end

//Agua / Water
#if (HAgua) 
        #declare Normal_1=normal {waves scale <4,.5,5>*.025 translate <1.0,0,-1.0> turbulence .4}
        #declare Normal_2=normal {bumps scale <5,1,5>*.05}
        
        disc{0,y, 15 translate <0,-.5,0> pigment {rgb <.03,.03,.01>} 
        normal{average normal_map{[1 Normal_1][1 Normal_2]}}
        finish { reflection{ 1 fresnel}} interior {ior 1.4}
        }
        
#end

//Cielo / Sky
#if (HCielo)

#include "textures.inc"
// the clouds
#include "stsky\i_stsky.inc"
#declare dark_color=White*.8+SkyBlue*.1;     //*.2
#declare light_color=White*1.02;//1
#declare height=8000;
#declare cloud_level=.45;
#declare planes=40;//15Aumentar cantidad de planos
#declare pdist=40;//30
#declare ppatt=pigment{wrinkles}
#declare pturb=.4;
#declare pocta=9;
#declare plamb=3;
#declare pomeg=.5;
#declare tdist=50;
#declare sfactor=10000;
#declare dfactor=.9;
#declare border=.1;
#declare fstart=.7;
#declare fend=.8;
object{
 clouds(
  dark_color,         // color for lower parts
  light_color,        // color for upper parts
  height,             // heigth to first layer
  cloud_level,        // level of "cloudiness"(?)
  planes,             // number of planes
  pdist,              // distance between planes
  ppatt,              // pigment pattern
  pturb,              // amount of turbulence
  pocta,              // and its modifiers
  plamb,
  pomeg,
  tdist,              // distance between textures
  sfactor,            // scaling factor
  dfactor,            // darkening factor
  border,             // width of change zone
  fstart,             // filter for lower layer
  fend                // filter for upper layer
 )
 hollow
 no_shadow
 rotate 5*y
}

#end

//muro/wall
#if (HMuro)
box{<0,-.2,0>,<.2,2.1,26> translate <11.5,0,-8>
pigment{
        image_map {
                jpeg "imagemaps\roca2.jpg" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
                map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                  }
        rotate <0,90,0>
        scale <1.58,1,1>*.75
        }
        
normal{
bump_map { // uses image color or index as bumpiness
  jpeg "imagemaps\roca2.jpg" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
  map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
  interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
  bump_size 7     // 0...3
        }
  rotate <0,90,0>
  scale <1.58,1,1>*.75 // bump_map  
}
}   
#end //fin muro
    
 

#local radio=30;
difference{
        cylinder{<0,-2,0>,<0,5,0>,radio}
        cylinder{<0,-2.2,0>,<0,11,0>,radio*.99}
        pigment {
                image_map {
                        png "imagemaps\reflejo.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
                        map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
                        interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
                     } // image_map
                     scale <1.25,1,1>*7 translate y*-1
        }finish {ambient .85}  no_image
        }