// Persistence of Vision Ray Tracer Scene Description File
// File: rueda.pov - Wheel -
// Vers: 3.5
// Desc: Jan-Feb 2003 IRTC Entry - Topic "Old Technologies" (a Water Mill)
// Date: Start - 11Ene03
// Auth: J. F. Tuduri
//
                    
#version 3.5;
              
#include "colors.inc"
#include "shapes.inc"
#include "transforms.inc"
#local Apertura=1;                  
                
                 
global_settings {
  assumed_gamma 1.0
}
    /*         
// ----------------------------------------
#declare camera_location = <-15, 2, -15>;  //<-15, 2, -15.0>;
         
camera {
  
  direction 3.7*z
  right     x*image_width/image_height
  //location  <-1.0, 2, -5.0> look_at   <0.0, 1.7,  -1.0>
  //location  <-5.0, 2, -8.0> look_at   <0.0, 2,  2.0>
  location  camera_location look_at   <1.0,1, 2.0>
  //location  <-6.0, 4, -1.0> look_at   <0.0, 2.0,  0.0>
}

sky_sphere {
  pigment {
    bozo turbulence 2 scale .2
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.6,0.1,0.8>]
    }
  }
}

plane{y,-.5 pigment {Cyan}} 

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}                
               
       */  
// ---------------------------------------
#local SD=seed(234);
#declare Madera1=texture{
                         pigment {wood
                                  color_map{
                                            [0 rgb<.45,.3,0>*.4] //*.6
                                            [1 rgb<.45,.35,.05>*.4]
                                            }
                                   scale <.7,.07,.1>*.75
                                   turbulence .1
                                  }
                         normal{wood .25 scale <.7,.07,.1>*.75 turbulence .1}
                         } 
                  texture{
                         pigment {cylindrical scale 1.87 frequency 5.42 rotate x*90
                                  color_map{
                                            [0 rgbt<.05,.1,0,.5>]
                                            [.2 rgbt <.05,.1,0,.8>]
                                            [.25 rgbt 1]
                                            [1 rgbt 1]
                                            }
                                  }
                         normal {bumps 2 scale -.01 turbulence .2}
                         }

#declare Madera2=texture{
                         pigment {wood scale <.1,.07,.5>*.75 turbulence .1
                                  color_map{
                                            [0 rgb<.45,.25,.15>*.5] //*1
                                            [1 rgb<.45,.34,.05>*.5]
                                            }
                                   
                                  }
                         normal{wood .15 scale <.1,.07,.5>*.75 turbulence .1}
                        }
                 texture{pigment{gradient y scale 2.2 frequency 5
                                 color_map{[0 rgbt 1]
                                           [.6 rgbt 1]
                                           [.6 rgbt<.05,.1,0,.8>]
                                           [1 rgbt<.05,.1,0,.6>]
                                           }
                                }
                         normal {bumps 2 scale -.01 turbulence .2}
                         
                       }
                       
#declare Madera3=texture{pigment {wood scale <.1,.05,.5> rotate x*88 turbulence .1
                                  color_map{[0 rgb <.15,.1,0>]
                                            [1 rgb <.1,.05,0>]
                                            }
                                 }
                         normal {wood scale <.1,.05,.5> rotate x*88 turbulence .1}
                        }
#declare Madera4=texture{pigment{wood rotate <90,0,0> scale <.05,.6,.05> turbulence .2
                                 color_map{[0 rgb <.85,.8,.7>*.6]//<.8,.65,.4>*.8
                                           [.8 rgb <.85,.8,.7>*.7]
                                           [1 rgb <.85,.8,.7>*.5]//<.85,.6,.3>
                                           }
                                 }
                                 normal {wood .25 rotate <90,0,0> scale <.05,.6,.05> turbulence .2}
                         scale 1.3}
                         
#declare Madera5=texture{Madera4 rotate <0,0,90> scale <1,.5,.5>}
#declare TexSucioGrad=texture{pigment{
                                        gradient y scale 12
                                        color_map{[0 rgbt <.1,.1,0,.2>]
                                                  [.2 rgbt 1]
                                                  [1 rgbt 1]
                                                  }
                                      }
                             }                                                                         
                        
#declare Metal1=texture{pigment{bozo scale .05 turbulence .5
                                color_map{[0 rgb <.15,.1,.1>]
                                          [.5 rgb <.1,.1,.1>]
                                          [1 rgb <.15,.18,.15>]
                                          }
                                }
                        normal {dents 2 scale .01}
                        finish {specular .2 roughness .09}
                       }

#declare Metal2=texture{pigment{bozo scale .05 turbulence .5
                                color_map{[0 rgb <.05,.07,.05>]
                                          [1 rgb <.07,.1,.07>]
                                          }
                                }
                        normal{bumps 2 scale .05 turbulence .3}
                        }

#declare Metal3=texture{pigment {agate
                                 color_map{[0 rgb <.1,.0,.0>]
                                           [.5 rgb .05]
                                           [1 rgb <.05,.08,.05>]
                                           }
                                 } 
                         finish{phong .7 phong_size 40}
                         normal {dents 2 scale .1}
                        }                                                                                                                                       
//Rueda 

#declare Rueda=union{
     union{
        #local i=45/2;
        #while (i<360)
         //placas costado
        intersection{
             union{
                difference{
                           cylinder{<0,0,-.4>,<0,0,-.35>,1.9}  
                           cylinder{<0,0,-.41>,<0,0,-.34>,1.55}
                          }
                torus{1.9,.025 rotate x*90 translate z*-.375}
                torus{1.55,.025 rotate x*90 translate z*-.375}
                  }
            plane {x,0 rotate z*(i-45/2+.5)}
            plane {-x,0 rotate z*(i+45/2-.5)}
            texture{Madera1 translate z*rand(SD)*50 rotate z*i}//pigment{Green}
            } 
        
        intersection{
            union{
               difference{
                          cylinder{<0,0,.4>,<0,0,.35>,1.9}  
                          cylinder{<0,0,.41>,<0,0,.34>,1.55}
                         }
               torus{1.9,.025 rotate x*90 translate z*.375}
               torus{1.55,.025 rotate x*90 translate z*.375}
                 }
            plane {x,0 rotate z*(i-45/2+.5)}
            plane {-x,0 rotate z*(i+45/2-.5)}
            texture{Madera1 translate z*rand(SD)*50 rotate z*i}//pigment{Green}
            }
        
        //sujeciones metalicas y tornillos
        union{
        box{<-.2,1.87,-.4>,<.2,1.77,-.415>} box{<-.2,1.72,-.4>,<.2,1.62,-.415>}
        box{<-.2,1.87,-.35>,<.2,1.77,-.335>} box{<-.2,1.72,-.35>,<.2,1.62,-.335>}
        texture{Metal2}
        rotate z*(i-45/2)
        }
        union{
         sphere{<0,0,0>,.03 scale <1,1,.5> translate <-.15,1.82,-.415>} sphere{<0,0,0>,.03 scale <1,1,.5> translate <.15,1.82,-.415>}
         sphere{<0,0,0>,.03 scale <1,1,.5> translate <-.15,1.67,-.415>} sphere{<0,0,0>,.03 scale <1,1,.5> translate <.15,1.67,-.415>}
         sphere{<0,0,0>,.03 scale <1,1,.5> translate <-.15,1.82,-.335>} sphere{<0,0,0>,.03 scale <1,1,.5> translate <.15,1.82,-.335>}
         sphere{<0,0,0>,.03 scale <1,1,.5> translate <-.15,1.67,-.335>} sphere{<0,0,0>,.03 scale <1,1,.5> translate <.15,1.67,-.335>}
         texture{Metal1 translate x*50*rand(SD)}
        rotate z*(i-45/2)
        }
        union{
        box{<-.2,1.87,.4>,<.2,1.77,.415>} box{<-.2,1.72,.4>,<.2,1.62,.415>}
        box{<-.2,1.87,.35>,<.2,1.77,.335>} box{<-.2,1.72,.35>,<.2,1.62,.335>}
        texture{Metal2}
        rotate z*(i-45/2)
        }
        union{
         sphere{<0,0,0>,.03 scale <1,1,.5> translate <-.15,1.82,.415>} sphere{<0,0,0>,.03 scale <1,1,.5> translate <.15,1.82,.415>}
         sphere{<0,0,0>,.03 scale <1,1,.5> translate <-.15,1.67,.415>} sphere{<0,0,0>,.03 scale <1,1,.5> translate <.15,1.67,.415>}
         sphere{<0,0,0>,.03 scale <1,1,.5> translate <-.15,1.82,.335>} sphere{<0,0,0>,.03 scale <1,1,.5> translate <.15,1.82,.335>}
         sphere{<0,0,0>,.03 scale <1,1,.5> translate <-.15,1.67,.335>} sphere{<0,0,0>,.03 scale <1,1,.5> translate <.15,1.67,.335>}
         texture{Metal1 translate x*50*rand(SD)}
         rotate z*(i-45/2)
        }
        
        #local i=i+45;
       #end       

//el "piso"
#declare i=0;
#while (i<360)
        box{<.2,1.6,.35>,<-.2,1.62,-.35> rotate z*i texture{Madera2 rotate z*90}}
        #declare i=i+14;
#end

//las "aletas" y agua
#declare i=0;
#while (i<360)
        union{
                box{<-.02,0,.35>,<.02,.4,-.35>}
                cylinder{<0,.4,.35>,<0,.4,-.35>,.02}
                texture{Madera2} 
                rotate z*-45 translate <0,1.62,0> rotate z*i
                }
        #local Punto=<0,.4,0>;
        #local Trans=transform{rotate z*-45 translate <0,1.62,0> rotate z*i }
        #local Punto=vtransform(Punto,Trans);
        #if (Punto.x<-.3)
                box{Punto+z*.35,(Punto+<.4,.01,-.35>)
                    texture{pigment {//rgb 0 
                                    bumps  scale .1 color_map{[0 rgb 1]
                                                              [.5 rgb 0]
                                                              [1 rgb 0]
                                                             }
                                           }    
                            finish {reflection 1 }
                            normal{bumps 2 scale .01}
                            }
                    }
        #end
        #declare i=i+12.86;
#end        


//Rayos AFUERA       
#local i=0;
#while (i<4)
union{
      intersection{
        Round_Box_Union(<.04,1.85,-.4>,<-.04,.3,-.5>,.01)
        plane{-z,0 rotate x*30 translate <0,1.75,-.5>}
        texture{Madera3 translate y*rand(SD)*50}}
      intersection{
        Round_Box_Union(<.04,-1.85,-.4>,<-.04,-.3,-.5>,.01)
        plane{-z,0 rotate x*-30 translate <0,-1.75,-.5>}
        texture{Madera3 translate y*rand(SD)*50}}
        union{
             sphere{<0,0,0>,.035 scale <1,1,.7> translate <0,1.67,-.5>}
             sphere{<0,0,0>,.035 scale <1,1,.7> translate <0,-1.67,-.5>}
             texture{Metal1 translate x*50*rand(SD)}
             }
        rotate z*i*45
      }
#local i=i+1;
#end

//Rayos Adentro
#local i=0;
#while (i<4)
union{
      intersection{
        Round_Box_Union(<.04,1.85,-.4>,<-.04,.3,-.5>,.01)
        plane{-z,0 rotate x*30 translate <0,1.75,-.5>}
        texture{Madera3 translate y*rand(SD)*50}}
      intersection{
        Round_Box_Union(<.04,-1.85,-.4>,<-.04,-.3,-.5>,.01)
        plane{-z,0 rotate x*-30 translate <0,-1.75,-.5>}
        texture{Madera3 translate y*rand(SD)*50}}
        union{
             sphere{<0,0,0>,.035 scale <1,1,.7> translate <0,1.67,-.5>}
             sphere{<0,0,0>,.035 scale <1,1,.7> translate <0,-1.67,-.5>}
             texture{Metal1 translate x*50*rand(SD)}
             }
        rotate z*i*45
      scale <1,1,-1>}
#local i=i+1;
#end
        
union{ //Metal del centro
#local i=0;
#while (i<4)
    union {
           box{<.05,.5,-.39>,<-.05,.25,-.51>}
           box{<.05,-.5,-.39>,<-.05,-.25,-.51>}
       rotate z*i*45
       }
       #local i=i+1;
#end        
      
difference{
        union{
                cylinder{<0,0,-.39>,<0,0,-.51>,.3}
                cylinder{<0,0,-.37>,<0,0,-.53>,.25} 
                cylinder{<0,0,-.32>,<0,0,-.58>,.16}
              }
        cylinder{<0,0,.3>,<0,0,-.6>,.14}
        } 
        
        #local i=0;  //tornillos del centro
        #while(i<360)
              union{
              sphere{<0,0,0>,.03 scale <1,1,.4> translate <-.2,0,-.53>}
              sphere{<0,0,0>,.03 scale <1,1,.4> translate <-.2,0,-.37>}
              sphere{<0,0,0>,.035 scale <1,1,.7> translate <0,.4,-.51>}
              sphere{<0,0,0>,.035 scale <1,1,.7> translate <0,-.4,-.51>}
              sphere{<0,0,0>,.035 scale <1,1,.7> translate <0,.4,-.39>}
              sphere{<0,0,0>,.035 scale <1,1,.7> translate <0,-.4,-.39>}
               rotate z*i}
              #local i=i+45;
        #end 
texture{Metal1 translate x*50*rand(SD)}
}        

union{ //Metal del centro
#local i=0;
#while (i<4)
    union {
           box{<.05,.5,-.39>,<-.05,.25,-.51>}
           box{<.05,-.5,-.39>,<-.05,-.25,-.51>}
       rotate z*i*45
       }
       #local i=i+1;
#end        
      
difference{
        union{
                cylinder{<0,0,-.39>,<0,0,-.51>,.3}
                cylinder{<0,0,-.37>,<0,0,-.53>,.25} 
                cylinder{<0,0,-.32>,<0,0,-.58>,.16}
              }
        cylinder{<0,0,.3>,<0,0,-.6>,.14}
        } 
        
        #local i=0;  //tornillos del centro
        #while(i<360)
              union{
              sphere{<0,0,0>,.03 scale <1,1,.4> translate <-.2,0,-.53>}
              sphere{<0,0,0>,.03 scale <1,1,.4> translate <-.2,0,-.37>}
              sphere{<0,0,0>,.035 scale <1,1,.7> translate <0,.4,-.51>}
              sphere{<0,0,0>,.035 scale <1,1,.7> translate <0,-.4,-.51>}
              sphere{<0,0,0>,.035 scale <1,1,.7> translate <0,.4,-.39>}
              sphere{<0,0,0>,.035 scale <1,1,.7> translate <0,-.4,-.39>}
               rotate z*i}
              #local i=i+45;
        #end 
texture{Metal1 translate x*50*rand(SD)} scale <1,1,-1>
}                  


//EJE
cylinder{<0,0,1.2>,<0,0,-1.2>,.125 texture{Metal3 translate z*50*rand(SD)}}

rotate z*10
}//fin union para rotar
difference{
 union{
        cylinder{<0,0,-1>,<0,0,-1.18>,.15}
        box{<-.23,-.15,-1>,<.23,-.02,-1.18>}
        box{<-.23,-.15,-1>,<-.29,-.1,-1.18>}
        box{<.23,-.15,-1>,<.29,-.1,-1.18>}
        
        }
        cylinder{<0,0,-.99>,<0,0,-1.19>,.13}
        cylinder{<-.23,-.02,-.99>,<-.23,-.02,-1.19>,.08}
        cylinder{<.23,-.02,-.99>,<.23,-.02,-1.19>,.08}
        texture{Metal3 translate z*50*rand(SD)}}

#include "wall\makewall.pov"
#declare typeWall=2;            // 1=box ; 2=ellipsoid
#declare pEllipsoid=0.1;        // usual ellipsoid parameter
#declare xWall=1;             // wall length in x
#declare yWall=1.2;              // wall height in y
#declare eMortar=.02;           // mortar thickness
#declare eWall=-.92;             // mortar depth
#declare xBrickMin=.2;             // min brick size
#declare xBrickMax=.2;             // max brick size
#declare yBrickMin=0.01;             // min brick height
#declare yBrickMax=.05;             // max brick height
#declare seedWall=425;              // seed wall
#declare srd1=0.7;                  // randomness amount for brick position (0=no random)
#declare srd2=0.3;                  // randomness amount for brick rotation (0=no random)
#declare srdcol=0.8;                // randomness amount for color (0=no random)
#declare patternWall=1;             // y color gradient for wall texture

#declare pigWall=rgb<0.7,0.65,0.65>*1.2;    // wall main color
#declare txtMortar=texture{pigment{rgb<0.89,0.9,0.95>*.7}} // mortar texture
//-----------------------------------------
//Pillar
union{
object{MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar)
        scale <1,1,.25> translate <-.5,-2,-1.09>}

#declare xWall=.9;             // wall length in x
#declare yWall=.2;              // wall height in y
#declare seedWall=845;
object{MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar)
        scale <1,1,.25> translate <-.5+.05,-2+1.2,-1.09>}
#declare xWall=.8;             // wall length in x
#declare yWall=.2;              // wall height in y
#declare seedWall=55;
object{MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar)
        scale <1,1,.25> translate <-.5+.1,-2+1.4,-1.09>}                
#declare xWall=.7;             // wall length in x
#declare yWall=.3;              // wall height in y 
#declare seedWall=778;
object{MakeWall(typeWall,pEllipsoid,xWall,yWall,eMortar,eWall,xBrickMin,xBrickMax,yBrickMin,yBrickMax,seedWall,srd1,srd2,srdcol,patternWall,pigWall,txtMortar)
        scale <1,1,.25> translate <-.5+.15,-2+1.6,-1.09>}        
translate y*-.03}             

}//Fin Rueda

//----------------------------------------------

#declare Canal=union{
                        object{Round_Box_Union(<-.1,-.5,-.05><.1,3.81,.05>,.01) texture{Madera4 translate x*100*rand(SD)} rotate x*3.76 translate <1.5,0,-.7-.25> texture{TexSucioGrad}}
                        object{Round_Box_Union(<-.1,-.5,-.05><.1,3.81,.05>,.01) texture{Madera4 translate x*100*rand(SD)} rotate x*3.76 translate <3.5,0,-.7-.25> texture{TexSucioGrad}}
                        object{Round_Box_Union(<-.1,-.5,-.05><.1,3.81,.05>,.01) texture{Madera4 translate x*100*rand(SD)} rotate x*3.76 translate <5.5,0,-.7-.25> texture{TexSucioGrad}}
                        object{Round_Box_Union(<-.1,-.5,-.05><.1,3.81,.05>,.01) texture{Madera4 translate x*100*rand(SD)} rotate x*3.76 translate <7.5,0,-.7-.25> texture{TexSucioGrad}}
                        object{Round_Box_Union(<-.1,-.5,-.05><.1,3.81,.05>,.01) texture{Madera4 translate x*100*rand(SD)} rotate x*3.76 translate <9.5,0,-.7-.25> texture{TexSucioGrad}}
                        object{Round_Box_Union(<-.1,-.5,-.05><.1,3.81,.05>,.01) texture{Madera4 translate x*100*rand(SD)} rotate x*-3.76 translate <1.5,0,.7+.25> texture{TexSucioGrad}}
                        object{Round_Box_Union(<-.1,-.5,-.05><.1,3.81,.05>,.01) texture{Madera4 translate x*100*rand(SD)} rotate x*-3.76 translate <3.5,0,.7+.25> texture{TexSucioGrad}}
                        object{Round_Box_Union(<-.1,-.5,-.05><.1,3.81,.05>,.01) texture{Madera4 translate x*100*rand(SD)} rotate x*-3.76 translate <5.5,0,.7+.25> texture{TexSucioGrad}}
                        object{Round_Box_Union(<-.1,-.5,-.05><.1,3.81,.05>,.01) texture{Madera4 translate x*100*rand(SD)} rotate x*-3.76 translate <7.5,0,.7+.25> texture{TexSucioGrad}}
                        object{Round_Box_Union(<-.1,-.5,-.05><.1,3.81,.05>,.01) texture{Madera4 translate x*100*rand(SD)} rotate x*-3.76 translate <9.5,0,.7+.25> texture{TexSucioGrad}}
                        
                        object{Round_Cylinder_Union(<1.5,.3,-.7-.1>,<1.5,.3,-.7-.3>,.04,.01) texture{Metal1}}
                        object{Round_Cylinder_Union(<3.5,.3,-.7-.1>,<3.5,.3,-.7-.385>,.04,.01) texture{Metal1}}
                        object{Round_Cylinder_Union(<5.5,.3,-.7-.2>,<5.5,.3,-.7-.385>,.04,.01) texture{Metal1}}
                        
                        object{Round_Cylinder_Union(<1.5,3.5,-.7-.1>,<1.5,3.5,-.7-.3>,.04,.01) translate z*.12 texture{Metal1}}
                        object{Round_Cylinder_Union(<3.5,3.5,-.7-.1>,<3.5,3.5,-.7-.385>,.04,.01) translate z*.2 texture{Metal1}}
                        object{Round_Cylinder_Union(<5.5,3.5,-.7-.2>,<5.5,3.5,-.7-.385>,.04,.01) translate z*.29 texture{Metal1}}
                        
                        object{Round_Box_Union(<-.08,-.1,-.04>,<.08,3.87,.04>,.01) texture{Madera4 translate x*100*rand(SD)} rotate z*32 rotate x*3.76 translate <3.5,.3,-.7-.33> texture{TexSucioGrad}}
                        object{Round_Box_Union(<-.08,-.1,-.04>,<.08,3.87,.04>,.01) texture{Madera4 translate x*100*rand(SD)} rotate z*-32 rotate x*3.76 translate <1.5,.3,-.7-.16> texture{TexSucioGrad}}
                        
                        object{Round_Box_Union(<-.08,-.1,-.04>,<.08,3.87,.04>,.01) texture{Madera4 translate x*100*rand(SD)} rotate z*32 rotate x*3.76 translate <5.5,.3,-.7-.33> texture{TexSucioGrad}}
                        object{Round_Box_Union(<-.08,-.1,-.04>,<.08,3.87,.04>,.01) texture{Madera4 translate x*100*rand(SD)} rotate z*-32 rotate x*3.76 translate <3.5,.3,-.7-.16> texture{TexSucioGrad}}
                        
                        object{Round_Box_Union(<-.08,-.1,-.04>,<.08,3.87,.04>,.01) texture{Madera4 translate x*100*rand(SD)} rotate z*32 rotate x*3.76 translate <7.5,.3,-.7-.33> texture{TexSucioGrad}}
                        object{Round_Box_Union(<-.08,-.1,-.04>,<.08,3.87,.04>,.01) texture{Madera4 translate x*100*rand(SD)} rotate z*-32 rotate x*3.76 translate <5.5,.3,-.7-.16> texture{TexSucioGrad}}
                        
                        object{Round_Box_Union(<-.08,-.1,-.04>,<.08,3.87,.04>,.01) texture{Madera4 translate x*100*rand(SD)} rotate z*-32 rotate x*3.76 translate <7.5,.3,-.7-.16> texture{TexSucioGrad}}
 
                        object{Round_Box_Union(<-.08,-.1,-.04>,<.08,3.87,.04>,.01) texture{Madera4 translate x*100*rand(SD)} rotate z*32 rotate x*-3.76 translate <3.5,.3,.7+.35> texture{TexSucioGrad}}
                        object{Round_Box_Union(<-.08,-.1,-.04>,<.08,3.87,.04>,.01) texture{Madera4 translate x*100*rand(SD)} rotate z*-32 rotate x*-3.76 translate <1.5,.3,.7+.16> texture{TexSucioGrad}}
                         
                        object{Round_Box_Union(<-.08,-.1,-.04>,<.08,3.87,.04>,.01) texture{Madera4 translate x*100*rand(SD)} rotate z*32 rotate x*-3.76 translate <5.5,.3,.7+.35> texture{TexSucioGrad}}
                        object{Round_Box_Union(<-.08,-.1,-.04>,<.08,3.87,.04>,.01) texture{Madera4 translate x*100*rand(SD)}rotate z*-32 rotate x*-3.76 translate <3.5,.3,.7+.16> texture{TexSucioGrad}}
                        
                        object{Round_Box_Union(<-.08,-.1,-.04>,<.08,3.87,.04>,.01) texture{Madera4 translate x*100*rand(SD)} rotate z*32 rotate x*-3.76 translate <7.5,.3,.7+.35> texture{TexSucioGrad}}
                        object{Round_Box_Union(<-.08,-.1,-.04>,<.08,3.87,.04>,.01) texture{Madera4 translate x*100*rand(SD)} rotate z*-32 rotate x*-3.76 translate <5.5,.3,.7+.16> texture{TexSucioGrad}}
                        
                        object{Round_Box_Union(<-.08,-.1,-.04>,<.08,3.87,.04>,.01) texture{Madera4 translate x*100*rand(SD)} rotate z*-32 rotate x*-3.76 translate <7.5,.3,.7+.16> texture{TexSucioGrad}}
                                               
                        object{Round_Box_Union(<1.4,3.76,-.8>,<1.6,3.84,.8>,.01) texture{Madera4 translate x*100*rand(SD)rotate x*90}}
                        object{Round_Box_Union(<3.4,3.76,-.8>,<3.6,3.84,.8>,.01) texture{Madera4 translate x*100*rand(SD)rotate x*91}}
                        object{Round_Box_Union(<5.4,3.76,-.8>,<5.6,3.84,.8>,.01) texture{Madera4 translate x*100*rand(SD)rotate x*88}}
                        object{Round_Box_Union(<7.4,3.76,-.8>,<7.6,3.84,.8>,.01) texture{Madera4 translate x*100*rand(SD)rotate x*95}}
                        object{Round_Box_Union(<9.4,3.76,-.8>,<9.6,3.84,.8>,.01) texture{Madera4 translate x*100*rand(SD)rotate x*92}}
                        
                        //Piso
                        difference{
                                Round_Box_Union(<-.25,3.84,-.45>,<3.5,3.88,-.35>,.01)
                                plane{z,0 rotate y*15 translate <.2,0,-.475>}
                                texture{Madera5 translate x*100*rand(SD) rotate x*90}}
                        object{Round_Box_Union(<-.25,3.84,-.35>,<3.5,3.88,0>,.01)texture{Madera5 translate x*100*rand(SD) rotate x*90}}
                        object{Round_Box_Union(<-.25,3.84,0>,<3.5,3.88,.35>,.01)texture{Madera5 translate x*100*rand(SD) rotate x*90}}
                        difference{
                                Round_Box_Union(<-.25,3.84,.35>,<3.5,3.88,.45>,.01)
                                plane{-z,0 rotate y*-15 translate <.2,0,.475>}
                                texture{Madera5 translate x*100*rand(SD) rotate x*90}}
                        object{Round_Box_Union(<3.5,3.84,-.45>,<11.7,3.88,-.35>,.01)texture{Madera5 translate x*100*rand(SD)rotate x*90}}
                        object{Round_Box_Union(<3.5,3.84,-.35>,<11.7,3.88,0>,.01)texture{Madera5 translate x*100*rand(SD)rotate x*90}}
                        object{Round_Box_Union(<3.5,3.84,0>,<11.7,3.88,.35>,.01)texture{Madera5 translate x*100*rand(SD) rotate x*90}}
                        object{Round_Box_Union(<3.5,3.84,.35>,<11.7,3.88,.45>,.01)texture{Madera5 translate x*100*rand(SD) rotate x*90}}
                        
                        //Paredes
                        object{Round_Box_Union(<.2,3.84,-.45>,<.95,4.02,-.5>,.008) texture{Madera5 translate x*100*rand(SD)}}
                        object{Round_Box_Union(<.2,4.02,-.45>,<.95,4.2,-.5>,.01) texture{Madera5 translate x*100*rand(SD)}}
                        
                        object{Round_Box_Union(<1.65,3.84,-.45>,<11.7,4.02,-.5>,.008) texture{Madera5 translate x*100*rand(SD)}}
                        object{Round_Box_Union(<1.65,4.02,-.45>,<11.7,4.2,-.5>,.01) texture{Madera5 translate x*100*rand(SD)}}
                        
                        object{Round_Box_Union(<.2,3.84,.45>,<11.7,4.02,.5>,.008) texture{Madera5 translate x*100*rand(SD)}}
                        object{Round_Box_Union(<.2,4.02,.45>,<11.7,4.2,.5>,.01) texture{Madera5 translate x*100*rand(SD)}}
                        
                        
                        //Llave 2 Costado
                        
                        difference{
                                Round_Box_Union(<.95,3.84,-.52>,<1,4.7,-.43>,.01)
                                Round_Box_Union(<.97,3.83,-.455>,<1.01,4.71,-.495>,.01)
                                texture{Madera5 translate x*100*rand(SD) rotate <90,0,90>}}
                        difference{
                                Round_Box_Union(<1.6,3.84,-.52>,<1.65,4.7,-.43>,.01)
                                Round_Box_Union(<1.6,3.83,-.455>,<1.63,4.71,-.495>,.01)
                                texture{Madera5 translate x*100*rand(SD) rotate <90,0,90>}}
                        object{Round_Box_Union(<.95,4.6,-.52>,<1.65,4.65,-.55>,.01)texture{Madera5 translate x*100*rand(SD)}}
                        object{Round_Box_Union(<.95,4.6,-.43>,<1.65,4.65,-.4>,.01)texture{Madera5 translate x*100*rand(SD)}}
                                //tapa
                                union{
                                      object{Round_Box_Union(<.98,3.84,-.45>,<1.62,4.02,-.5>,.008)texture{Madera5 translate x*100*rand(SD)}}
                                      object{Round_Box_Union(<.98,4.02,-.45>,<1.62,4.2,-.5>,.01)texture{Madera5 translate x*100*rand(SD)}}
                                      texture{Madera5 translate x*100*rand(SD)}
                                      translate y*-(Apertura-1)*.4
                                      }
                                //piso
                                union{
                                        object{Round_Box_Union(<.03,0,.6>,<.225,.04,-1.5>,.01)texture{Madera5 translate x*100*rand(SD) rotate <90,90,0>}}
                                        object{Round_Box_Union(<.225,0,.6>,<.42,.04,-1.5>,.01)texture{Madera5 translate x*100*rand(SD) rotate <90,90,0>}}
                                        object{Round_Box_Union(<0,0,.6>,<.03,.18,-1.5>,.01)texture{Madera5 translate x*100*rand(SD)rotate 90}}
                                        object{Round_Box_Union(<0,.18,.6>,<.03,.36,-1.5>,.008)texture{Madera5 translate x*100*rand(SD)rotate 90}}
                                        object{Round_Box_Union(<.42,0,.6>,<.45,.18,-1.5>,.01)texture{Madera5 translate x*100*rand(SD)rotate 90}}
                                        object{Round_Box_Union(<.42,.18,.6>,<.45,.36,-1.5>,.008)texture{Madera5 translate x*100*rand(SD)rotate 90}}                                        
                                        rotate x*-5 rotate y*45 translate <.97,3.84,-.5>
                                        clipped_by {plane {z,-.5}}
                                      }
                               object{Round_Box_Union(<-.06,-.13,-.025>,<.06,2,.025>,.01) 
                                        texture{Madera4 translate x*100*rand(SD)} rotate x*-45 rotate y*61
                                        translate <1.42,2.3,-.88>}
                                
                        //Llave 1 frente

                        union{
                              object{Round_Box_Union(<-.06,3.84,-.5>,<.06,4.7,-.55>,.01)texture{Madera5 translate x*100*rand(SD) rotate<0,0,90>}}
                              difference{
                                         Round_Box_Union(<-.06,3.84,-.45>,<.06,4.7,-.42>,.01)
                                         box{<-.02,3.83,-.44>,<.02,4.71,-.41>}
                                         texture{Madera5 translate x*100*rand(SD) rotate<0,0,90>}}
                              object{Round_Box_Union(<-.06,3.84,.5>,<.06,4.7,.55>,.01)texture{Madera5 translate x*100*rand(SD) rotate<0,0,90>}}
                              difference{
                                         Round_Box_Union(<-.06,3.84,.45>,<.06,4.7,.42>,.01)
                                         box{<-.02,3.83,.44>,<.02,4.71,.41>}
                                         texture{Madera5 translate x*100*rand(SD) rotate<0,0,90>}}
                                         
                              //tapa
                              union{
                                    object{Round_Box_Union(<-.018,3.84,.44>,<.018,4.07,-.44>,.01)texture{Madera5 translate x*100*rand(SD) rotate y*90}}
                                    object{Round_Box_Union(<-.018,4.06,.44>,<.018,4.3,-.44>,.01)texture{Madera5 translate x*100*rand(SD) rotate y*90}}
                                    translate y*(Apertura*.4)}                                         
                              
                              object{Round_Box_Union(<-.08,3.84,-.55>,<.08,3.78,.55>,.01)texture{Madera5 translate x*100*rand(SD) rotate<90,0,0>}}
                              
                              translate<.4,0,0>
                              }
                        //Punta
                        
                        object{Round_Box_Union(<-.5,3.84,-.025>,<0,4.02,.025>,.008) texture{Madera5 translate x*100*rand(SD)} rotate y*15 translate <.2,0,-.475>}
                        object{Round_Box_Union(<-.5,4.02,-.025>,<0,4.2,.025>,.01) texture{Madera5 translate x*100*rand(SD)} rotate y*15 translate <.2,0,-.475>} 
                        object{Round_Box_Union(<-.5,3.84,-.025>,<0,4.02,.025>,.008) texture{Madera5 translate x*100*rand(SD)} rotate y*-15 translate <.2,0,.475>}
                        object{Round_Box_Union(<-.5,4.02,-.025>,<0,4.2,.025>,.01) texture{Madera5 translate x*100*rand(SD)} rotate y*-15 translate <.2,0,.475>}
                        
                        object{Round_Box_Union(<-.05,3.84,.75>,<.15,3.78,-0.7>,.01)texture{Madera4 translate x*100*rand(SD) rotate x*90}}
                        difference{
                                box{<-.1,0,-.02>,<.1,2.1,.02> texture{Madera4 translate x*100*rand(SD)} rotate x*3.76 rotate z*48 translate <1.5,2.5,-.7>}
                                box{<-.2,3.78,-.6>,<.2,4,-.4>} 
                                cutaway_textures
                                }
                        difference{
                                box{<-.1,0,-.02>,<.1,2.1,.02> texture{Madera4 translate x*100*rand(SD)} rotate x*-3.76 rotate z*48 translate <1.5,2.5,.7>}
                                box{<-.2,3.78,.6>,<.2,4,.4>}
                                cutaway_textures 
                                }
                        //Soporte Paredes
                        union{
                              object{Round_Box_Union(<-.05,3.88,-.5>,<.05,4.2,-.54>,.01)texture{Madera5 translate x*100*rand(SD) rotate<0,0,90>}}
                              object{Round_Box_Union(<-.05,3.88,.5>,<.05,4.2,.54>,.01)texture{Madera5 translate x*100*rand(SD) rotate<0,0,90>}}
                              object{Round_Box_Union(<-.05,4.2,-.54>,<.05,4.25,.54>,.01)texture{Madera5 translate x*100*rand(SD) rotate<90,90,0>}}
                              translate<.7,0,0>
                              }
                        
                        union{
                              object{Round_Box_Union(<-.05,3.88,-.5>,<.05,4.2,-.54>,.01)texture{Madera5 translate x*100*rand(SD) rotate<0,0,90>}}
                              object{Round_Box_Union(<-.05,3.88,.5>,<.05,4.2,.54>,.01)texture{Madera5 translate x*100*rand(SD) rotate<0,0,90>}}
                              object{Round_Box_Union(<-.05,4.2,-.54>,<.05,4.25,.54>,.01)texture{Madera5 translate x*100*rand(SD) rotate<90,90,0>}}
                              translate<2.0,0,0>
                              }
                        union{
                              object{ Round_Box_Union(<-.05,3.88,-.5>,<.05,4.2,-.54>,.01)texture{Madera5 translate x*100*rand(SD) rotate<0,0,90>}}
                              object{Round_Box_Union(<-.05,3.88,.5>,<.05,4.2,.54>,.01)texture{Madera5 translate x*100*rand(SD) rotate<0,0,90>}}
                              object{Round_Box_Union(<-.05,4.2,-.54>,<.05,4.25,.54>,.01)texture{Madera5 translate x*100*rand(SD) rotate<90,90,0>}}
                              translate<3.2,0,0>
                              }
                        union{
                              object{Round_Box_Union(<-.05,3.88,-.5>,<.05,4.2,-.54>,.01)texture{Madera5 translate x*100*rand(SD) rotate<0,0,90>}}
                              object{Round_Box_Union(<-.05,3.88,.5>,<.05,4.2,.54>,.01)texture{Madera5 translate x*100*rand(SD) rotate<0,0,90>}}
                              object{Round_Box_Union(<-.05,4.2,-.54>,<.05,4.25,.54>,.01)texture{Madera5 translate x*100*rand(SD) rotate<90,90,0>}}
                              translate<4.2,0,0>
                              }                              
                                    
                 translate x*-.2 
                 pigment {Grey}
}

#include "cascada.pov"
#declare Agua=
union{ 

AguaCae(3.84,-.2,0,-2.4,.007,0,.35,.005,-.35,.35,.01,40)//viene del canal

AguaCae(.8,-2.5,-.02,-.2,.005,0,.5,.005,-.35,.35,.05,15) //cayendo de rueda       

AguaCae(.6,-2.4,-.02,-.2,.005,0,.5,.005,-.35,.35,.05,15)

AguaCae(.4,-2,-.02,-.2,.005,0,.5,.005,-.17,.17,.05,15)

AguaCae(0,-1.5,-.02,-.2,.005,0,.5,.005,-.15,.15,.05,15)

AguaCae(1.2,-2.6,-.02,-.5,.005,0,.55,.005,-.05,.05,.05,15)

AguaCae(.9,-2.5,-.02,-.5,.005,0,.55,.005,-.05,.05,.05,15)

object{AguaCae(3.8,0,0,0,.005,0,1,.05,-2,-.5,.08,30) rotate y*90}
AguaCae(3.84,-.7,-.02,-2.5,.0025,0,1,.01,-.5,.5,.05,50)

//splash
 AguaCae(-.45,-2.8,2,-1,.0035,0,.5,.005,-.7,.7,.04,80)
 AguaCae(-.45,-2.7,2,1,.0035,0,.5,.005,-.7,.7,.04,80)


}


#declare Cartel=
        union{
        box{<-.015,0,-.025>,<.015,1,.025> texture{Madera4}}
        box{<.015,.6,.2>,<.025,.9,-.2> texture{Madera4 rotate x*90}}
        rotate <12,20,15>
        translate <1.5,-.1,-1.5>}

//object{Cartel}
//object{Rueda translate y*1.7 translate x*-.7}
//object{Canal}
//object{Agua}
            
 
