// Definitions for the cowshed and the hay-loft

#include "straw.inc"
#include "ladder.inc"

#local Bricks =
texture
{
    pigment
    {
        brick <0.7, 0.73, 0.25>, <0.6, 0.4, 0.3>
    }
    /*
    normal
    {
        brick 0.5
    }
    */
    
    finish { ambient 0 diffuse 0.2 }
    scale 0.04
}

texture
{
    pigment
    {
        granite
        color_map
        {
            [0.5 color rgb 0 transmit 1]
            [0.7 color rgb 0 transmit 0.8]
        }
    }
    
    scale 0.008
    
    finish { ambient 0 diffuse 0.2 }
}


#local Uniform =
texture
{
    pigment
    {
        wrinkles
        color_map
        {
            [0.5 color rgb <0.70, 0.65, 0.4>]
            [1.0 color rgb <0.70, 0.65, 0.4> * 0.7]
        }
        
        scale 0.01
    }
    
    normal
    {
        wrinkles 0.5
    }

    finish { ambient 0 diffuse 0.2 }
}

#declare BrickTexture =
texture
{
    agate
    scale 1
    texture_map
    {
        [0.4 Bricks]
        [0.75 Uniform]
    }
}

#declare Cowshed =
union
{
    box
    {
        <-30, 10, 0>, <30, 10.5, 50>
        texture { BrickTexture }
    }
    
    box
    {
        <-30, 30, 0>, <30, 30.5, 50>
        texture { BrickTexture }
    }

    box
    {
        <0, 0, 0>, <1, 30, 1>
        texture { BrickTexture }
    }
    
    difference
    {
        box
        {
            <-30, 30, 5>, <30, 30, 6>
            texture { BrickTexture }
        }

        box
        {
            <4, -3, 4>, <7, 25, 7>
            texture { BrickTexture }
        }

        cutaway_textures
    }
    
    object
    {
        union
        {
            object
            {
                CreateStraw (<0, 0, 1>, <7, 8, 2>, 0.06, 0.8, 3000, 13)
            }

            box
            {
                <0.5, 0.5, 1.5>, <6.5, 7.5, 2>
                pigment { color rgb 0 }
            }
        }
        
        // Do a shear operation along the x axis
        matrix
        <
          1, 0, 0,    
          0.4, 1, 0,  
          0, 0, 1,
          6, 10.4, 0     // Translate to this position
        >
    }


    object
    {
        union
        {
            object
            {
                CreateStraw (<0, 0, 1>, <7, 9, 2>, 0.06, 0.8, 3000, 13)
            }

            box
            {
                <0.5, 0.5, 1.5>, <6.5, 8.5, 2>
                pigment { color rgb 0 }
            }
        }
        
        // Do a shear operation along the x axis
        matrix
        <
          1, 0, 0,    
          -0.2, 1, 0,
          0, 0, 1,
          -3, 10.4, 0     // Translate to this position
        >
    }
    

    object
    {
        Ladder
        scale 13
        rotate 15*x
        translate <3.5, 0, -5>
    }

    difference
    {
        box
        {
            <-30, -3, 50>, <30, 30.5, 51>
            texture { BrickTexture }
        }
        
        union
        {
            #local RepX = 0;
            #while (RepX < 20)
                #local RepY = 0;
                #while (RepY < 10)
                    #declare RepY = RepY + 1;
                    
                    #local i = (RepX + RepY) / 2;
                    #if (i = floor (i))
                        box { <-2 + RepX, 14 + RepY, 49>, <-2 + RepX + 1, 14 + RepY + 1, 52> }
                    #end
                #end
                #declare RepX = RepX + 1;
            #end
        }
        
        cutaway_textures
    }
}


light_group
{
    light_source { <-70, 80, -20> color rgb 1 }
    object { Cowshed }

    translate z*100
}


#include "cart.inc"

object
{
    Cart
    scale 2.5
    rotate -20*y
    translate <6.5, 0, 80>
    
    finish { diffuse 0.2 brilliance 0.1 }
}

