// Persistence of Vision Ray Tracer Scene Description File
// File: sew.pov
// Vers: 3.5
// Desc: The sewing-machine
// Date: 2003/01/18
// Auth: Maurizio Tomasi
//

#version 3.5;

#declare IMPORT_SPATCH = 1;

#declare USE_WALLS = 1; // Include room's walls
#declare USE_FLOOR = 1; // Include a floor in the scene
#declare USE_SHELF = 1; // Include the shelf with the clock and the lantern
#declare USE_SEWING_MACHINE = 1; // Include the sewing machine
#declare USE_BASIN = 1; // Include a basin with its support
#declare USE_CHAIR = 1; // Include a chair in front of the sewing machine
#declare USE_TABLE = 1; // Include a table in the other room
#declare USE_SINK = 1; // Include the sink in the kitchen
#declare USE_COWSHED = 1; // Include the cowshed at the horizon
#declare USE_STRAW = 1; // Place straw in the cart and the cowshed

#declare USE_AREA_LIGHT = 1; // Use an area light instead of a point light
#declare USE_RADIOSITY = 1; // Use radiosity

#declare CAMERA_NUM = 0; // Camera number

//#declare FAST_WALLS = 1; // Do not create wrinkles on the walls
//#declare FAST_LIGHTS = 1; // Use fast lights
//#declare FAST_FLOOR = 1; // Do not create wrinkles on the floor


#include "colors.inc"
#include "functions.inc"
#include "math.inc"
#include "glass.inc"

global_settings 
{
    assumed_gamma 1.6
    max_trace_level 10

#ifdef (USE_RADIOSITY)    

    ambient_light 0

    radiosity
    {
        count 20
        recursion_limit 2
        brightness 0.8
        normal on
    }

#else

    ambient_light rgb <0.89, 0.67, 0.55>

#end
}


//////////////////////////////////////////////////////////////////
// The Camera

#switch (CAMERA_NUM)
#case (0)
#declare CameraPos = <-0.195, 3.5, 1.5>;
#declare LookAt = <-0.29, 2.3, 8.0>;
#break

#case (1)
#declare CameraPos = <-0.02, 3.0, 0.0>;
#declare LookAt = <0.01, 2.5, 10.0>;
#break

#case (2)
#declare CameraPos = <0, 6, 6.5>;
#declare LookAt = <0, 0, 6.5>;
#break

#case (3)
#declare CameraPos = <3, 2.5, 6.5>;
#declare LookAt = <0.0, 2.5, 6.5>;
#break

#case (4)
#declare CameraPos = <10, 3.5, 10>;
#declare LookAt = <10, 3.5, -5.0>;
#break
#end

camera {
    perspective
    location  CameraPos
    direction 1*z
    right     x*image_width/image_height
    look_at   LookAt
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.88,0.75,0.40>]
      [0.7 rgb <0.62,0.54,0.09>]
    }
    scale 2
    translate -1
  }
}


//////////////////////////////////////////////////////////////////
// The Lights

light_source
{
    <-40, 43, 10>
    color rgb 0.9
    
    #ifdef (USE_AREA_LIGHT)
        area_light
        2*z, 2*y, 4, 4
        jitter
        //adaptive 1.5
    #end
    
    parallel
    point_at <40, -43, 5>
}


#ifndef (FAST_LIGHTS)
    
    // Fill light
    light_source
    {
        <7, 6, 2>
        color rgb 0.12
        shadowless
    }
    
    
    // "Ground" light
    light_source
    {
        <-3, 6, 7.5>
        color rgb 0.12
        
        area_light
        2*y, 1.5*z, 4, 4
        jitter
        adaptive 1
    }
    
    // Ground light (in the other room)
    light_source
    {
        <-3, 6, 16>
        color rgb 0.12
        
        area_light
        2*y, 1.5*z, 4, 4
        jitter
        adaptive 1
    }

#else // FAST_LIGHTS

    light_source
    {
        <0, 5, 10>
        color rgb 0.8
        shadowless
    }

#end


//////////////////////////////////////////////////////////////////
// A "fake" background (seen in the window glasses)

#local FakePigment =
pigment
{
    image_map
    {
        jpeg "fake_bkgr.jpg"
    }
}

object
{
    box
    {
        <0, 0, 0>, <1, 1, -1>
        
        pigment { FakePigment }

        scale <10.24, 7.68, 1>
    }

    translate <-10.24 - 5, 0, 5>
    no_shadow
}

object
{
    box
    {
        <0, 0, 0>, <1, 1, -1>
        
        pigment { FakePigment }

        scale <10.24, 7.68, 1> * 1.5
    }

    rotate -90*y
    translate <-4, 0, 22>

    no_shadow
}

object
{
    box
    {
        <-1, 0, 0>, <0, 1, -1>
        
        pigment { FakePigment }

        scale <10.24, 7.68, 1> * 1.5
    }

    rotate 90*y
    translate <7, 0, 23>

    no_shadow
}


//////////////////////////////////////////////////////////////////
// The Walls


#ifdef (USE_WALLS)

    #include "walls.inc"

#end // USE_WALLS


//////////////////////////////////////////////////////////////////
// Window and Door Frames

#ifdef (USE_WALLS)

    #include "door-window.inc"
        
#end /* USE_WALLS */


//////////////////////////////////////////////////////////////////
// The Floor


#ifdef (USE_FLOOR)

    #declare FloorBase =
    #ifdef (FAST_FLOOR)
    
        box
        {
            <-4, 0, -1>, <9, 0.03, 23>
        }
    
    #else
    
        height_field
        {
            // This was generated from an isosurface: it is faster
            // to render it as an height field
            jpeg "floor2-hf.jpg"
                   
            scale <9 + 4, 0.03, 23 + 1>
            translate <-4, 0, -1>
        }
    
    #end
    
    #declare FloorTexture =
    texture
    {
        pigment {
            image_map
            {
                jpeg "floor2.jpg"
            }
        }
    
        rotate 90*x
        scale <9 + 4, 1, 23 + 1>
        translate <-4, 0, -1>
    }
    
    object { FloorBase texture { FloorTexture } }

    // A thread
    #local ThreadRadius = 0.001;
    sphere_sweep
    {
        cubic_spline
        11,
        
        <-0.16, 0.00,  0.01>, ThreadRadius
        <-0.15, 0.00,  0.00>, ThreadRadius
        <-0.13, 0.02, -0.01>, ThreadRadius
        <-0.09, 0.00,  0.02>, ThreadRadius
        <-0.04, 0.00,  0.00>, ThreadRadius
        < 0.00, 0.00, -0.01>, ThreadRadius
        < 0.04, 0.00, -0.02>, ThreadRadius
        < 0.09, 0.01, -0.01>, ThreadRadius
        < 0.13, 0.01,  0.01>, ThreadRadius
        < 0.15, 0.00,  0.01>, ThreadRadius
        < 0.16, 0.00,  0.00>, ThreadRadius
        
        pigment { color rgb 1.25 }
        
        scale 1.67
        rotate 16*y
        translate <-1.5, 0.03, 6.3>
    }
    
#else // ! USE_FLOOR

    plane {
      y, 0
      pigment { color rgb <0.7,0.5,0.3> }
    }

#end // ! USE_FLOOR


//////////////////////////////////////////////////////////////////
// The Shelf

#ifdef (USE_SHELF)
    
    #include "shelf.inc"
    #include "lantern.inc"
    #include "clock.inc"

    light_group
    {    
        light_source { <-2, 0.75, 8> color rgb 0.3 shadowless }
        union
        {
            object
            {
                Clock
                scale 0.35
                rotate 10*x
                rotate -20*y
                translate <-1.8, 0.25, 10>
            }

            object
            {
                Lantern
                scale 0.6
                rotate -10*y
                translate <-2.6, 0.05, 10.2>
            }
            
            object
            {
                Shelf
                translate <-3, 0, 11>
            }
        }
        global_lights on
        
        translate 4.5*y
    }
    
#end // USE_SHELF

//////////////////////////////////////////////////////////////////
// The Sink and the Tiles

#ifdef (USE_SINK)

    #include "sink.inc"
    
    #include "bucket.inc"
    
    object
    {
        Bucket

        rotate 30*y        
        translate <4.4, 0, 20>
    }
    
        
#end // USE_SINK


//////////////////////////////////////////////////////////////////
// The Basin and its support

#ifdef (USE_BASIN)
    #include "basin_set.inc"

    object
    {
        BasinSet
        
        scale 0.75
        rotate -39*y
        translate <4, 0, 9.5>
    }
    
#end

//////////////////////////////////////////////////////////////////
// The Picture

#ifdef (USE_WALLS)
    #include "rounded-plate.inc"
    
    #local PictureBorderTex =
    texture
    {
        pigment { color rgb <0.41, 0.29, 0.22> }
    }
    
    #local PictureTex =
    texture
    {
        pigment
        {
            image_map
            {
                jpeg "photo.jpg"
            }
            translate <-0.5, -0.5, 0>
            rotate 90*x
        }
        
        normal
        {
            crackle 1.3
            scale 0.1
        }
        
    }
    
    #local Picture =
    union
    {
        object
        {
            RoundedBorder (0.05)
            
            texture { PictureBorderTex }
            translate 0.2*y
        }

        // Glass in front of the picture        
        box
        {
            <-0.5, 0, -0.5>, <0.5, 0.02, 0.5>
            
            texture
            {
                pigment { color rgbt <0.4, 0.4, 0.4, 0.95> }
                finish
                {
                    reflection { 0.05 }
                }
            }
            translate 0.2*y
        }

        box
        {
            <-0.5, -0.02, -0.5>, <0.5, 0, 0.5>
            
            texture { PictureTex }
            translate 0.2*y
        }
        
        // The wire and the nail
        union
        {
            cylinder { <-0.3, 0.6, 0.5>, <0, 0.2, 0.81>, 0.01 }
            cylinder { <0.3, 0.6, 0.5>, <0, 0.2, 0.81>, 0.01 }
            cylinder { <0, 0, 0.79>, <0, 0.5, 0.81>, 0.015 }
            
            texture
            {
                pigment { color rgb 0.3 }
            }
        }
    }

    #ifndef (FAST_LIGHTS)
        light_group
        {
            light_source
            {
                <0, 5, 10>
                color rgb 0.3
                shadowless
            }
    #end

            object
            {
                Picture
            
                rotate -90*x
                rotate 1.5*z
                scale <486/714, 1.0, 0.3> * 1.1
                translate <4.3, 4.5, 10.98>
            }
            
    #ifndef (FAST_LIGHTS)
            global_lights on
        }
    #end
#end

//////////////////////////////////////////////////////////////////
// The Chair in front of the Sewing-machine

#ifdef (USE_CHAIR)

    #include "chair_set.inc"
    //#include "cloth.inc"
    
    object
    {
        ChairWithCloth
    
        rotate 144*y
        translate <-0.5, 0, 6.5>
    }
    
#end

//////////////////////////////////////////////////////////////////
// The Table in the Other Room

#ifdef (USE_TABLE)
    #include "chair_set.inc"

    object
    {
        Chair
        rotate 116*y
        translate <2.5, 0, 16>
    }
    
    object
    {
        Chair
        rotate -8*y
        translate <0.5, 0, 18>
    }

    object
    {
        Chair
        rotate -8*y
        translate <-1.5, 0, 18>
    }

    object
    {
        Chair
        rotate 177*y
        translate <-1.2, 0, 15>
    }

    object
    {
        Table
        rotate -97*y
        translate <-0.5, 0, 16>
    }
    
    // The candle
    #include "candlestick.inc"
    
    union
    {
        union
        {
            object { Candlestick1 }
            object { Candlestick2 }
            
            texture
            {
                pigment { color rgb <0.81, 0.72, 0.38> * 0.4 }
                finish { specular 0.2 roughness 0.4 metallic }
                normal { wrinkles 0.3 scale 0.3 }
            }
        }
        
        object
        {
            Candle
            pigment { color rgb <1, 1, 0.92> }
        }
        
        object
        {
            Wick
            pigment { color rgb 0 }
        }

        scale 0.2
        rotate 67*y
        translate <0.1, 2, 15.3>
    }
    
#end


//////////////////////////////////////////////////////////////////
// The Sewing-machine

#ifdef (USE_SEWING_MACHINE)
    
    #include "machine.inc"

    light_group
    {
        light_source { <3, 0.2, 8> color rgb 0.2 shadowless }
        object
        {
            SewingMachine
            
            scale <1.20, 1.20, 1.54>
            rotate 35*y
            translate <-2.5, 0, 6.5>
//            translate <0, 0, 6>
        }
        
        global_lights on
    }    
#end // USE_SEWING_MACHINE


//////////////////////////////////////////////////////////////////
// The Holy Crucifix

#local Pos = <11.74, 6.34, -0.98>; // <3.9, 3, 10.2> + 12.85 * <0.61, 0.26, -0.87>

#local Crucifix =
union
{
    box { <-0.02, -0.16, 0>, <0.02, 0.08, 0.02> }
    box { <-0.10, -0.02, 0>, <0.10, 0.02, 0.02> }
    
    pigment { color rgb <0.3, 0.2, 0.1> }
}

object
{
    Crucifix
    
    scale 1.2
    
    translate Pos + <0.1, 0.3, 0>
}


//////////////////////////////////////////////////////////////////
// A Chest of Drawers

light_group
{
    light_source
    {
        <-2, -6, 3> color rgb 0.2
    }
    
    union
    {
        box
        {
            <-3, -6.4, 0>, <-1, -0.4, 1>
        }
    
        box
        {
            <-2.9, -6, 1>, <-1.1, -0.5, 1.1>
        }
    
        box
        {
            <-3.1, -0.4, 0>, <-0.9, -0.35, 1.1>
        }
        
        pigment
        {
            wood
            warp { turbulence 0.2 }
            color_map
            {
                [0.5 color rgb <0.67, 0.39, 0.15> * 0.6]
                [1.0 color rgb <0.39, 0.28, 0.15> * 0.6]
            }
            rotate 92*x
            scale 0.03
        }    
    }

    global_lights on

    translate Pos
}


//////////////////////////////////////////////////////////////////
// The Farmyard

object
{
    height_field
    {
        png "farmyard.png"
        smooth
    }
    
    scale <100, 0.20, 100>
    translate <-20, -1 - 0.20, 22>

    texture
    {
        pigment { color rgb <0.52, 0.42, 0.44> } //<0.59, 0.38, 0.43>
        normal { wrinkles 2 scale 0.1 }
    }
}


//////////////////////////////////////////////////////////////////
// The Cowshed

#ifdef (USE_COWSHED)
    
    #include "cowshed.inc"
    
#end
