#include "rand.inc"
#include "dish.inc"

#local TileSeed = seed (18);
#local TileSize = 0.7;

#local TileTexture =
texture
{
    pigment { color rgb 0.8 }
    finish { specular 0.2 roughness 0.3 reflection { 0.1 } }
    normal { bozo 0.4 scale 0.1 }
}


#local CeramicColor = color rgb 0.95;
#local StripColor = color rgb <0.4, 0.4, 0.7>;

#local CeramicTexture =
texture
{
    pigment { color CeramicColor }
    finish { specular 0.1 reflection { 0.1 } }
}

#local StripTexture =
texture
{
    pigment { color StripColor }
}

#local DishTexture =
texture
{
    gradient y
    warp { cylindrical orientation y }
    texture_map
    {
        [0.55 CeramicTexture]
        [0.55 StripTexture]
        [0.57 StripTexture]
        [0.57 CeramicTexture]

        [0.59 CeramicTexture]
        [0.59 StripTexture]
        [0.60 StripTexture]
        [0.60 CeramicTexture]
    }
}

#local DishWithTexture =
object
{
    Dish
    translate <-0.5, 0, -0.5>
    
    texture { DishTexture }
}


///////////////////////////////////////////////////////////////////////////////////////
// The tiles

union
{
    #local i = 0;
    #while (i < 3)
        #local j = 0;
        #while (j < 7)
        
            box
            {
                <TileSize * i, TileSize * j, 0>,
                <TileSize * (i + 1) * 0.98, TileSize * (j + 1) * 0.98, 0.1>
                
                rotate RRand (-1, 1, TileSeed)*x
                rotate RRand (-1, 1, TileSeed)*y
                rotate RRand (-1, 1, TileSeed)*z
                texture { TileTexture translate VRand (TileSeed) }
            }
        
            #declare j = j + 1;
        #end
        #declare i= i + 1;
    #end

    // Cement under the tiles
    box
    {
        <-0.01, -0.5, 0.15>, <TileSize*3 + 0.01, TileSize*7 + 0.01, 0.2>
        pigment { color rgb 1.2 }
        normal { wrinkles 0.7 scale 0.01 }
    }    
        
    translate <4.1, 0.1, 21.7>
}

///////////////////////////////////////////////////////////////////////////////////////
// The sink

#include "sink-model.inc"

union
{
    object
    {
        SinkModel
        
        scale <1.5, 1.3, 1.5>
        texture { TileTexture }
    }
    
    #local DishSeed = seed(18);
    #local CurY = 1.1;
    #while (CurY < 1.6)
        object
        {
            DishWithTexture
            
            rotate RRand(-7, 7, DishSeed)*x
            rotate RRand(-6, 6, DishSeed)*z
            translate <RRand(-1.9, -1.5, DishSeed), CurY, RRand(-1.3, -0.3, DishSeed)>
        }
        
        #local CurY = CurY + 0.12;
    #end
    
    // The pipe
    sphere_sweep
    {
        linear_spline
        3,
        <0,  0,   -1>, 0.15
        <0, -0.5, -1>, 0.15
        <0, -0.8,  1>, 0.15
        
        texture
        {
            pigment { color rgb 0.4 }
            normal { wrinkles 1 scale 0.01 }
        }
        
        translate <-1.3, 0, 0>
    }
    
    translate <6.5, 2, 21.8>
}


///////////////////////////////////////////////////////////////////////////////////////
// A pot

#include "pot.inc"

union
{
    light_group
    {
        light_source
        {
            <-2, -1, -3> color rgb 0.2
        }
        
        union
        {
            object { Pot }
            object { PotHandles }
            
            scale 0.5
            rotate 90*x
            rotate 90*z
            
            texture
            {
                pigment { color rgb <0.4, 0.4, 0.3> }
                finish { specular 0.6 metallic reflection { 0.3 metallic } }
                normal { bozo scale 0.05 }
            }
        }
        
        global_lights on
    }
    
    // The nail
    cylinder
    {
        <0, 0.8, 0.3>, <0, 0.75, 1>, 0.03
        pigment { color rgb 0 }
    }

    translate <4.8, 6, 21>
}
