/********************************** openbridge.inc ********************************/
/* This file is part of the source code for the openbridge project                                                   */
/* Copyright (c) 2003 Cyrille Berger (cberger.net) *************************************/

#declare TF_HEIGHT_FIELD = height_field { tga "terrain_hf.tga"  smooth double_illuminate }
#declare TF_TILE_TERRAIN = false;
#declare TF_WATER_LEVEL = 0.330000;
#declare TF_HAVE_WATER = true;
#declare TF_WATER_CLARITY = 0.350000;
#declare TF_TIME_OF_DAY = 17.500000;
#declare TF_HAVE_CLOUDS = true;
#declare TF_CLOUDS_TEXTURE = "clouds_01.inc"
#declare TF_STARS_TEXTURE = "stars_01.inc"
#declare TF_HAVE_FOG = false;
#declare TF_HAVE_GROUND_FOG = false;
#declare TF_HAVE_RAINBOW = false;
#declare TF_FOG_OFFSET = 0.0000;
#declare TF_FOG_ALT = 0.0000;
#declare TF_FOG_TURBULENCE = 0.0000;
#declare TF_FOG_DENSITY = 0.00000;
#declare TF_NORTH_DIR = 0.000000;
#declare TF_Y_SCALE_FACTOR = 0.2500000;


//#declare TF_X_SCALE = 1000.000000;
//#declare TF_Z_SCALE = 1000.000000;
#declare TF_CAMERA_LOCATION = <200.000000, 100.000000, 600.000000>;
#declare TF_CAMERA_LOOK_AT = <500.000000, 100.000000, 400.000000>;
//#declare TF_CAMERA_LOCATION = <300.000000, 500.000000, 350.000000>;
//#declare TF_CAMERA_LOOK_AT = <300.000000, 0.000000, 350.000000>;


#include "colors.inc"
#include "defaults.inc"
#include "earth_fog.inc"    
#include "earth_regular_sky.inc"
#include "earth_green_landscape.inc"
#include "earth_water.inc"

global_settings {
    max_trace_level 3
}

//#declare TF_LANDSCAPE_TEXTURE = texture { pigment { color Red } }

/*fog {
    distance 900
    color Gray60
}*/

#include "generic_land.inc"

#declare s1 = seed(50);


#include "tree1.inc"
#macro arbre1()
#local yarbre = hf_height_at( xarbre/TF_X_SCALE, zarbre/TF_Z_SCALE, TF_HEIGHT_FIELD)*TF_Y_SCALE;
object {
                   tree1
//    cylinder { <0,0,0>, <0,50,0>, 4 pigment { color Green } }
    scale <0.6+0.6*rand(s1), 0.4+0.4*rand(s1), 0.6+0.6*rand(s1)>
    rotate <rand(s1)*10, rand(s1)*360, rand(s1)*10>
    translate <xarbre, yarbre, zarbre>
}
#end


#declare xarbre = 320;
#declare zarbre = 400;
arbre1()
#declare xarbre = 340;
#declare zarbre = 340;
arbre1()
#declare xarbre = 360;
#declare zarbre = 380;
arbre1()
#declare xarbre = 320;
#declare zarbre = 360;
arbre1()
#declare xarbre = 290;
#declare zarbre = 405;
arbre1()
#declare xarbre = 330;
#declare zarbre = 380;
arbre1()
#declare xarbre = 320;
#declare zarbre = 320;
arbre1()
#declare xarbre = 300;
#declare zarbre = 380;
arbre1()


#declare xarbre = 325;
#declare zarbre = 595;
#declare yarbre = hf_height_at( xarbre/TF_X_SCALE, zarbre/TF_Z_SCALE, TF_HEIGHT_FIELD)*TF_Y_SCALE;

object {
  #include "tree2.inc"
  //  cylinder { <0,0,0>, <0,10,0>, 4 pigment { color Green } }
    scale 0.5
    translate <xarbre, yarbre-2, zarbre>  }

union {
    #include "papillon.inc"
    rotate -30*y
    scale 10
    translate <220, 90, 580>
}

union {
    #include "papillon.inc"
    scale 11
    translate <219, 89, 581>
}

union {
    #include "papillon.inc"
    rotate -90*y
    scale 9
    translate <221, 91, 581>
}

#include "pontouvrable.inc"
object { pontouvrable
    translate < 340, 0.25*0.33*1000-10, 500> }


#include "bateau.inc"
object { bateau
    rotate 140*y
    translate <360, 0.25*0.33*1000+1, 490> }
